import{s as re,o as ae,n as le}from"../chunks/scheduler.9039eef2.js";import{S as oe,i as ie,g as i,s as a,r as v,A as pe,h as p,f as n,c as l,j as P,u as U,x as H,k as Q,y as x,a as s,v as C,d as _,t as N,w as B}from"../chunks/index.cdcc3d35.js";import{T as me}from"../chunks/Tip.6f74db41.js";import{D as ne}from"../chunks/Docstring.fff63cfc.js";import{C as ue}from"../chunks/CodeBlock.e3ac94d9.js";import{H as se}from"../chunks/Heading.96ce3702.js";function ce(z){let r,T='The <a href="https://huggingface.co/docs/optimum/neuron/package_reference/trainer#optimum.neuron.NeuronTrainer" rel="nofollow"><code>NeuronTrainer</code></a> class is optimized for 🤗 Transformers models running on AWS Trainium.';return{c(){r=i("p"),r.innerHTML=T},l(o){r=p(o,"P",{"data-svelte-h":!0}),H(r)!=="svelte-95vt7d"&&(r.innerHTML=T)},m(o,I){s(o,r,I)},p:le,d(o){o&&n(r)}}}function Te(z){let r,T,o,I,f,Z,d,D='The <a href="https://huggingface.co/docs/optimum/neuron/package_reference/trainer#optimum.neuron.NeuronTrainer" rel="nofollow"><code>NeuronTrainer</code></a> class provides an extended API for the feature-complete <a href="https://huggingface.co/docs/transformers/main_classes/trainer" rel="nofollow">Transformers Trainer</a>. It is used in all the <a href="https://github.com/huggingface/optimum-neuron/tree/main/examples" rel="nofollow">example scripts</a>.',A,c,S,w,K='Here is an example of how to customize <a href="https://huggingface.co/docs/optimum/neuron/package_reference/trainer#optimum.neuron.NeuronTrainer" rel="nofollow"><code>NeuronTrainer</code></a> to use a weighted loss (useful when you have an unbalanced training set):',X,h,L,M,O='Another way to customize the training loop behavior for the PyTorch <a href="https://huggingface.co/docs/optimum/neuron/package_reference/trainer#optimum.neuron.NeuronTrainer" rel="nofollow"><code>NeuronTrainer</code></a> is to use <a href="https://huggingface.co/docs/transformers/main_classes/callback" rel="nofollow">callbacks</a> that can inspect the training loop state (for progress reporting, logging on TensorBoard or other ML platforms…) and take decisions (like early stopping).',V,g,W,m,J,Y,$,ee="Trainer that is suited for performing training on AWS Tranium instances.",R,u,y,F,j,te="Seq2SeqTrainer that is suited for performing training on AWS Tranium instances.",E,k,G;return f=new se({props:{title:"NeuronTrainer",local:"neurontrainer",headingTag:"h1"}}),c=new me({props:{warning:!0,$$slots:{default:[ce]},$$scope:{ctx:z}}}),h=new ue({props:{code:"ZnJvbSUyMHRvcmNoJTIwaW1wb3J0JTIwbm4lMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25UcmFpbmVyJTBBJTBBJTBBY2xhc3MlMjBDdXN0b21OZXVyb25UcmFpbmVyKE5ldXJvblRyYWluZXIpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwY29tcHV0ZV9sb3NzKHNlbGYlMkMlMjBtb2RlbCUyQyUyMGlucHV0cyUyQyUyMHJldHVybl9vdXRwdXRzJTNERmFsc2UpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGFiZWxzJTIwJTNEJTIwaW5wdXRzLmdldCglMjJsYWJlbHMlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwZm9yd2FyZCUyMHBhc3MlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5nZXQoJTIybG9naXRzJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMGNvbXB1dGUlMjBjdXN0b20lMjBsb3NzJTIwKHN1cHBvc2UlMjBvbmUlMjBoYXMlMjAzJTIwbGFiZWxzJTIwd2l0aCUyMGRpZmZlcmVudCUyMHdlaWdodHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zc19mY3QlMjAlM0QlMjBubi5Dcm9zc0VudHJvcHlMb3NzKHdlaWdodCUzRHRvcmNoLnRlbnNvciglNUIxLjAlMkMlMjAyLjAlMkMlMjAzLjAlNUQpKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBsb3NzX2ZjdChsb2dpdHMudmlldygtMSUyQyUyMHNlbGYubW9kZWwuY29uZmlnLm51bV9sYWJlbHMpJTJDJTIwbGFiZWxzLnZpZXcoLTEpKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMChsb3NzJTJDJTIwb3V0cHV0cyklMjBpZiUyMHJldHVybl9vdXRwdXRzJTIwZWxzZSUyMGxvc3M=",highlighted:`<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> nn
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronTrainer


<span class="hljs-keyword">class</span> <span class="hljs-title class_">CustomNeuronTrainer</span>(<span class="hljs-title class_ inherited__">NeuronTrainer</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_loss</span>(<span class="hljs-params">self, model, inputs, return_outputs=<span class="hljs-literal">False</span></span>):
        labels = inputs.get(<span class="hljs-string">&quot;labels&quot;</span>)
        <span class="hljs-comment"># forward pass</span>
        outputs = model(**inputs)
        logits = outputs.get(<span class="hljs-string">&quot;logits&quot;</span>)
        <span class="hljs-comment"># compute custom loss (suppose one has 3 labels with different weights)</span>
        loss_fct = nn.CrossEntropyLoss(weight=torch.tensor([<span class="hljs-number">1.0</span>, <span class="hljs-number">2.0</span>, <span class="hljs-number">3.0</span>]))
        loss = loss_fct(logits.view(-<span class="hljs-number">1</span>, self.model.config.num_labels), labels.view(-<span class="hljs-number">1</span>))
        <span class="hljs-keyword">return</span> (loss, outputs) <span class="hljs-keyword">if</span> return_outputs <span class="hljs-keyword">else</span> loss`,wrap:!1}}),g=new se({props:{title:"NeuronTrainer",local:"optimum.neuron.NeuronTrainer",headingTag:"h2"}}),J=new ne({props:{name:"class optimum.neuron.NeuronTrainer",anchor:"optimum.neuron.NeuronTrainer",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-neuron/blob/vr_724/optimum/neuron/trainers.py#L1500"}}),y=new ne({props:{name:"class optimum.neuron.Seq2SeqNeuronTrainer",anchor:"optimum.neuron.Seq2SeqNeuronTrainer",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-neuron/blob/vr_724/optimum/neuron/trainers.py#L1506"}}),{c(){r=i("meta"),T=a(),o=i("p"),I=a(),v(f.$$.fragment),Z=a(),d=i("p"),d.innerHTML=D,A=a(),v(c.$$.fragment),S=a(),w=i("p"),w.innerHTML=K,X=a(),v(h.$$.fragment),L=a(),M=i("p"),M.innerHTML=O,V=a(),v(g.$$.fragment),W=a(),m=i("div"),v(J.$$.fragment),Y=a(),$=i("p"),$.textContent=ee,R=a(),u=i("div"),v(y.$$.fragment),F=a(),j=i("p"),j.textContent=te,E=a(),k=i("p"),this.h()},l(e){const t=pe("svelte-u9bgzb",document.head);r=p(t,"META",{name:!0,content:!0}),t.forEach(n),T=l(e),o=p(e,"P",{}),P(o).forEach(n),I=l(e),U(f.$$.fragment,e),Z=l(e),d=p(e,"P",{"data-svelte-h":!0}),H(d)!=="svelte-17t4iuq"&&(d.innerHTML=D),A=l(e),U(c.$$.fragment,e),S=l(e),w=p(e,"P",{"data-svelte-h":!0}),H(w)!=="svelte-6qwkss"&&(w.innerHTML=K),X=l(e),U(h.$$.fragment,e),L=l(e),M=p(e,"P",{"data-svelte-h":!0}),H(M)!=="svelte-1v1d9m6"&&(M.innerHTML=O),V=l(e),U(g.$$.fragment,e),W=l(e),m=p(e,"DIV",{class:!0});var b=P(m);U(J.$$.fragment,b),Y=l(b),$=p(b,"P",{"data-svelte-h":!0}),H($)!=="svelte-1l8fy86"&&($.textContent=ee),b.forEach(n),R=l(e),u=p(e,"DIV",{class:!0});var q=P(u);U(y.$$.fragment,q),F=l(q),j=p(q,"P",{"data-svelte-h":!0}),H(j)!=="svelte-1qxnatk"&&(j.textContent=te),q.forEach(n),E=l(e),k=p(e,"P",{}),P(k).forEach(n),this.h()},h(){Q(r,"name","hf:doc:metadata"),Q(r,"content",fe),Q(m,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Q(u,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){x(document.head,r),s(e,T,t),s(e,o,t),s(e,I,t),C(f,e,t),s(e,Z,t),s(e,d,t),s(e,A,t),C(c,e,t),s(e,S,t),s(e,w,t),s(e,X,t),C(h,e,t),s(e,L,t),s(e,M,t),s(e,V,t),C(g,e,t),s(e,W,t),s(e,m,t),C(J,m,null),x(m,Y),x(m,$),s(e,R,t),s(e,u,t),C(y,u,null),x(u,F),x(u,j),s(e,E,t),s(e,k,t),G=!0},p(e,[t]){const b={};t&2&&(b.$$scope={dirty:t,ctx:e}),c.$set(b)},i(e){G||(_(f.$$.fragment,e),_(c.$$.fragment,e),_(h.$$.fragment,e),_(g.$$.fragment,e),_(J.$$.fragment,e),_(y.$$.fragment,e),G=!0)},o(e){N(f.$$.fragment,e),N(c.$$.fragment,e),N(h.$$.fragment,e),N(g.$$.fragment,e),N(J.$$.fragment,e),N(y.$$.fragment,e),G=!1},d(e){e&&(n(T),n(o),n(I),n(Z),n(d),n(A),n(S),n(w),n(X),n(L),n(M),n(V),n(W),n(m),n(R),n(u),n(E),n(k)),n(r),B(f,e),B(c,e),B(h,e),B(g,e),B(J),B(y)}}}const fe='{"title":"NeuronTrainer","local":"neurontrainer","sections":[{"title":"NeuronTrainer","local":"optimum.neuron.NeuronTrainer","sections":[],"depth":2}],"depth":1}';function de(z){return ae(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class be extends oe{constructor(r){super(),ie(this,r,de,Te,re,{})}}export{be as component};
