import{s as Md,o as Td,n as q}from"../chunks/scheduler.8c3d61f6.js";import{S as Ad,i as Gd,g as a,s as o,r as m,A as Dd,h as s,f as r,c as i,j as w,u as f,x as c,k as y,y as t,a as b,v as g,d as u,t as _,w as h}from"../chunks/index.da70eac4.js";import{T as Id}from"../chunks/Tip.1d9b8c37.js";import{D as I}from"../chunks/Docstring.6b390b9a.js";import{C as ne}from"../chunks/CodeBlock.00a903b3.js";import{E as te}from"../chunks/ExampleCodeBlock.db12be95.js";import{H,E as Cd}from"../chunks/EditOnGithub.1e64e623.js";function kd(T){let l,M="Since RegEx is supported as a way for matching layer identifiers, it is crucial to use it correctly otherwise there might be unexpected behaviour. The recommended way to use PAG is by specifying layers as <code>blocks.{layer_index}</code> and <code>blocks.({layer_index_1|layer_index_2|...})</code>. Using it in any other way, while doable, may bypass our basic validation checks and give you unexpected results.";return{c(){l=a("p"),l.innerHTML=M},l(v){l=s(v,"P",{"data-svelte-h":!0}),c(l)!=="svelte-82c0ns"&&(l.innerHTML=M)},m(v,d){b(v,l,d)},p:q,d(v){v&&r(l)}}}function Ld(T){let l,M="Examples:",v,d,P;return d=new ne({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQW5pbWF0ZURpZmZQQUdQaXBlbGluZSUyQyUyME1vdGlvbkFkYXB0ZXIlMkMlMjBERElNU2NoZWR1bGVyJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGV4cG9ydF90b19naWYlMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMlNHMTYxMjIyJTJGUmVhbGlzdGljX1Zpc2lvbl9WNS4xX25vVkFFJTIyJTBBbW90aW9uX2FkYXB0ZXJfaWQlMjAlM0QlMjAlMjJndW95d3clMkZhbmltYXRlZGlmZi1tb3Rpb24tYWRhcHRlci12MS01LTIlMjIlMEFtb3Rpb25fYWRhcHRlciUyMCUzRCUyME1vdGlvbkFkYXB0ZXIuZnJvbV9wcmV0cmFpbmVkKG1vdGlvbl9hZGFwdGVyX2lkKSUwQXNjaGVkdWxlciUyMCUzRCUyMERESU1TY2hlZHVsZXIuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIyc2NoZWR1bGVyJTIyJTJDJTIwYmV0YV9zY2hlZHVsZSUzRCUyMmxpbmVhciUyMiUyQyUyMHN0ZXBzX29mZnNldCUzRDElMkMlMjBjbGlwX3NhbXBsZSUzREZhbHNlJTBBKSUwQXBpcGUlMjAlM0QlMjBBbmltYXRlRGlmZlBBR1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUwQSUyMCUyMCUyMCUyMG1vdGlvbl9hZGFwdGVyJTNEbW90aW9uX2FkYXB0ZXIlMkMlMEElMjAlMjAlMjAlMjBzY2hlZHVsZXIlM0RzY2hlZHVsZXIlMkMlMEElMjAlMjAlMjAlMjBwYWdfYXBwbGllZF9sYXllcnMlM0QlNUIlMjJtaWQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBdmlkZW8lMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMmNhciUyQyUyMGZ1dHVyaXN0aWMlMjBjaXR5c2NhcGUlMjB3aXRoJTIwbmVvbiUyMGxpZ2h0cyUyQyUyMHN0cmVldCUyQyUyMG5vJTIwaHVtYW4lMjIlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0QlMjJsb3clMjBxdWFsaXR5JTJDJTIwYmFkJTIwcXVhbGl0eSUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyNSUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNENi4wJTJDJTBBJTIwJTIwJTIwJTIwcGFnX3NjYWxlJTNEMy4wJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEdG9yY2guR2VuZXJhdG9yKCkubWFudWFsX3NlZWQoNDIpJTJDJTBBKS5mcmFtZXMlNUIwJTVEJTBBJTBBZXhwb3J0X3RvX2dpZih2aWRlbyUyQyUyMCUyMmFuaW1hdGVkaWZmX3BhZy5naWYlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AnimateDiffPAGPipeline, MotionAdapter, DDIMScheduler
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;SG161222/Realistic_Vision_V5.1_noVAE&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>motion_adapter_id = <span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-2&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>motion_adapter = MotionAdapter.from_pretrained(motion_adapter_id)
<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler = DDIMScheduler.from_pretrained(
<span class="hljs-meta">... </span>    model_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>, beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>, steps_offset=<span class="hljs-number">1</span>, clip_sample=<span class="hljs-literal">False</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = AnimateDiffPAGPipeline.from_pretrained(
<span class="hljs-meta">... </span>    model_id,
<span class="hljs-meta">... </span>    motion_adapter=motion_adapter,
<span class="hljs-meta">... </span>    scheduler=scheduler,
<span class="hljs-meta">... </span>    pag_applied_layers=[<span class="hljs-string">&quot;mid&quot;</span>],
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>video = pipe(
<span class="hljs-meta">... </span>    prompt=<span class="hljs-string">&quot;car, futuristic cityscape with neon lights, street, no human&quot;</span>,
<span class="hljs-meta">... </span>    negative_prompt=<span class="hljs-string">&quot;low quality, bad quality&quot;</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">25</span>,
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">6.0</span>,
<span class="hljs-meta">... </span>    pag_scale=<span class="hljs-number">3.0</span>,
<span class="hljs-meta">... </span>    generator=torch.Generator().manual_seed(<span class="hljs-number">42</span>),
<span class="hljs-meta">... </span>).frames[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_gif(video, <span class="hljs-string">&quot;animatediff_pag.gif&quot;</span>)`,wrap:!1}}),{c(){l=a("p"),l.textContent=M,v=o(),m(d.$$.fragment)},l(n){l=s(n,"P",{"data-svelte-h":!0}),c(l)!=="svelte-kvfsh7"&&(l.textContent=M),v=i(n),f(d.$$.fragment,n)},m(n,x){b(n,l,x),b(n,v,x),g(d,n,x),P=!0},p:q,i(n){P||(u(d.$$.fragment,n),P=!0)},o(n){_(d.$$.fragment,n),P=!1},d(n){n&&(r(l),r(v)),h(d,n)}}}function Sd(T){let l,M="Examples:",v,d,P;return d=new ne({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZSUwQSUwQXBpcGUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJUZW5jZW50LUh1bnl1YW4lMkZIdW55dWFuRGlULXYxLjItRGlmZnVzZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwZW5hYmxlX3BhZyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBwYWdfYXBwbGllZF9sYXllcnMlM0QlNUIxNCU1RCUyQyUwQSkudG8oJTIyY3VkYSUyMiklMEElMEElMjMlMjBwcm9tcHQlMjAlM0QlMjAlMjJhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMiUwQXByb21wdCUyMCUzRCUyMCUyMiVFNCVCOCU4MCVFNCVCOCVBQSVFNSVBRSU4NyVFOCU4OCVBQSVFNSU5MSU5OCVFNSU5QyVBOCVFOSVBQSU5MSVFOSVBOSVBQyUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDQlMkMlMjBwYWdfc2NhbGUlM0QzKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = AutoPipelineForText2Image.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Tencent-Hunyuan/HunyuanDiT-v1.2-Diffusers&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    enable_pag=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    pag_applied_layers=[<span class="hljs-number">14</span>],
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prompt = &quot;an astronaut riding a horse&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;一个宇航员在骑马&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt, guidance_scale=<span class="hljs-number">4</span>, pag_scale=<span class="hljs-number">3</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){l=a("p"),l.textContent=M,v=o(),m(d.$$.fragment)},l(n){l=s(n,"P",{"data-svelte-h":!0}),c(l)!=="svelte-kvfsh7"&&(l.textContent=M),v=i(n),f(d.$$.fragment,n)},m(n,x){b(n,l,x),b(n,v,x),g(d,n,x),P=!0},p:q,i(n){P||(u(d.$$.fragment,n),P=!0)},o(n){_(d.$$.fragment,n),P=!1},d(n){n&&(r(l),r(v)),h(d,n)}}}function Ud(T){let l,M="Examples:",v,d,P;return d=new ne({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZSUwQSUwQXBpcGUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJLd2FpLUtvbG9ycyUyRktvbG9ycy1kaWZmdXNlcnMlMjIlMkMlMEElMjAlMjAlMjAlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMGVuYWJsZV9wYWclM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcGFnX2FwcGxpZWRfbGF5ZXJzJTNEJTVCJTIyZG93bi5ibG9ja18yLmF0dGVudGlvbnNfMSUyMiUyQyUyMCUyMnVwLmJsb2NrXzAuYXR0ZW50aW9uc18xJTIyJTVEJTJDJTBBKSUwQXBpcGUlMjAlM0QlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMCUyMkElMjBwaG90byUyMG9mJTIwYSUyMGxhZHlidWclMkMlMjBtYWNybyUyQyUyMHpvb20lMkMlMjBoaWdoJTIwcXVhbGl0eSUyQyUyMGZpbG0lMkMlMjBob2xkaW5nJTIwYSUyMHdvb2RlbiUyMHNpZ24lMjB3aXRoJTIwdGhlJTIwdGV4dCUyMCdLT0xPUlMnJTIyJTBBKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDUuNSUyQyUyMHBhZ19zY2FsZSUzRDEuNSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = AutoPipelineForText2Image.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Kwai-Kolors/Kolors-diffusers&quot;</span>,
<span class="hljs-meta">... </span>    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    enable_pag=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    pag_applied_layers=[<span class="hljs-string">&quot;down.block_2.attentions_1&quot;</span>, <span class="hljs-string">&quot;up.block_0.attentions_1&quot;</span>],
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A photo of a ladybug, macro, zoom, high quality, film, holding a wooden sign with the text &#x27;KOLORS&#x27;&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt, guidance_scale=<span class="hljs-number">5.5</span>, pag_scale=<span class="hljs-number">1.5</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){l=a("p"),l.textContent=M,v=o(),m(d.$$.fragment)},l(n){l=s(n,"P",{"data-svelte-h":!0}),c(l)!=="svelte-kvfsh7"&&(l.textContent=M),v=i(n),f(d.$$.fragment,n)},m(n,x){b(n,l,x),b(n,v,x),g(d,n,x),P=!0},p:q,i(n){P||(u(d.$$.fragment,n),P=!0)},o(n){_(d.$$.fragment,n),P=!1},d(n){n&&(r(l),r(v)),h(d,n)}}}function jd(T){let l,M="Examples:",v,d,P;return d=new ne({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZSUwQSUwQXBpcGUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMGVuYWJsZV9wYWclM0RUcnVlJTBBKSUwQXBpcGUlMjAlM0QlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBwYWdfc2NhbGUlM0QwLjMpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = AutoPipelineForText2Image.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, enable_pag=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt, pag_scale=<span class="hljs-number">0.3</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){l=a("p"),l.textContent=M,v=o(),m(d.$$.fragment)},l(n){l=s(n,"P",{"data-svelte-h":!0}),c(l)!=="svelte-kvfsh7"&&(l.textContent=M),v=i(n),f(d.$$.fragment,n)},m(n,x){b(n,l,x),b(n,v,x),g(d,n,x),P=!0},p:q,i(n){P||(u(d.$$.fragment,n),P=!0)},o(n){_(d.$$.fragment,n),P=!1},d(n){n&&(r(l),r(v)),h(d,n)}}}function Nd(T){let l,M="Examples:",v,d,P;return d=new ne({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQXBpcGUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjBlbmFibGVfcGFnJTNEVHJ1ZSUyQyUwQSklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRnBhdHJpY2t2b25wbGF0ZW4lMkZpbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmFhX3hsJTJGMDAwMDAwMDA5LnBuZyUyMiUwQSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKHVybCkuY29udmVydCglMjJSR0IlMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMjBwYWdfc2NhbGUlM0QwLjMpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = AutoPipelineForImage2Image.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    enable_pag=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://huggingface.co/datasets/patrickvonplaten/images/resolve/main/aa_xl/000000009.png&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = load_image(url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt, image=init_image, pag_scale=<span class="hljs-number">0.3</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){l=a("p"),l.textContent=M,v=o(),m(d.$$.fragment)},l(n){l=s(n,"P",{"data-svelte-h":!0}),c(l)!=="svelte-kvfsh7"&&(l.textContent=M),v=i(n),f(d.$$.fragment,n)},m(n,x){b(n,l,x),b(n,v,x),g(d,n,x),P=!0},p:q,i(n){P||(u(d.$$.fragment,n),P=!0)},o(n){_(d.$$.fragment,n),P=!1},d(n){n&&(r(l),r(v)),h(d,n)}}}function Jd(T){let l,M=`This pipeline can be used with checkpoints that have been specifically fine-tuned for inpainting
(<a href="https://huggingface.co/runwayml/stable-diffusion-inpainting" rel="nofollow">runwayml/stable-diffusion-inpainting</a>) as well as
default text-to-image Stable Diffusion checkpoints
(<a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">runwayml/stable-diffusion-v1-5</a>). Default text-to-image
Stable Diffusion checkpoints might be preferable for ControlNets that have been fine-tuned on those, such as
<a href="https://huggingface.co/lllyasviel/control_v11p_sd15_inpaint" rel="nofollow">lllyasviel/control_v11p_sd15_inpaint</a>.`;return{c(){l=a("p"),l.innerHTML=M},l(v){l=s(v,"P",{"data-svelte-h":!0}),c(l)!=="svelte-mk8vnx"&&(l.innerHTML=M)},m(v,d){b(v,l,d)},p:q,d(v){v&&r(l)}}}function $d(T){let l,M="Examples:",v,d,P;return d=new ne({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># !pip install transformers accelerate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> cv2
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting, ControlNetModel, DDIMScheduler
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/diffusers/test-arrays/resolve/main/stable_diffusion_inpaint/boy.png&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = init_image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>mask_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/diffusers/test-arrays/resolve/main/stable_diffusion_inpaint/boy_mask.png&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_image = mask_image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">make_canny_condition</span>(<span class="hljs-params">image</span>):
<span class="hljs-meta">... </span>    image = np.array(image)
<span class="hljs-meta">... </span>    image = cv2.Canny(image, <span class="hljs-number">100</span>, <span class="hljs-number">200</span>)
<span class="hljs-meta">... </span>    image = image[:, :, <span class="hljs-literal">None</span>]
<span class="hljs-meta">... </span>    image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
<span class="hljs-meta">... </span>    image = Image.fromarray(image)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> image


<span class="hljs-meta">&gt;&gt;&gt; </span>control_image = make_canny_condition(init_image)

<span class="hljs-meta">&gt;&gt;&gt; </span>controlnet = ControlNetModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;lllyasviel/control_v11p_sd15_inpaint&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = AutoPipelineForInpainting.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16, enable_pag=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = DDIMScheduler.from_config(pipe.scheduler.config)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_model_cpu_offload()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># generate image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;a handsome man with ray-ban sunglasses&quot;</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">20</span>,
<span class="hljs-meta">... </span>    generator=generator,
<span class="hljs-meta">... </span>    eta=<span class="hljs-number">1.0</span>,
<span class="hljs-meta">... </span>    image=init_image,
<span class="hljs-meta">... </span>    mask_image=mask_image,
<span class="hljs-meta">... </span>    control_image=control_image,
<span class="hljs-meta">... </span>    pag_scale=<span class="hljs-number">0.3</span>,
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){l=a("p"),l.textContent=M,v=o(),m(d.$$.fragment)},l(n){l=s(n,"P",{"data-svelte-h":!0}),c(l)!=="svelte-kvfsh7"&&(l.textContent=M),v=i(n),f(d.$$.fragment,n)},m(n,x){b(n,l,x),b(n,v,x),g(d,n,x),P=!0},p:q,i(n){P||(u(d.$$.fragment,n),P=!0)},o(n){_(d.$$.fragment,n),P=!1},d(n){n&&(r(l),r(v)),h(d,n)}}}function Xd(T){let l,M="Examples:",v,d,P;return d=new ne({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZSUwQSUwQXBpcGUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjBlbmFibGVfcGFnJTNEVHJ1ZSUyQyUwQSklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBwaG90byUyMG9mJTIwYW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMG1hcnMlMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwcGFnX3NjYWxlJTNEMC4zKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = AutoPipelineForText2Image.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    enable_pag=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt, pag_scale=<span class="hljs-number">0.3</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){l=a("p"),l.textContent=M,v=o(),m(d.$$.fragment)},l(n){l=s(n,"P",{"data-svelte-h":!0}),c(l)!=="svelte-kvfsh7"&&(l.textContent=M),v=i(n),f(d.$$.fragment,n)},m(n,x){b(n,l,x),b(n,v,x),g(d,n,x),P=!0},p:q,i(n){P||(u(d.$$.fragment,n),P=!0)},o(n){_(d.$$.fragment,n),P=!1},d(n){n&&(r(l),r(v)),h(d,n)}}}function zd(T){let l,M="Examples:",v,d,P;return d=new ne({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQXBpcGUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLXJlZmluZXItMS4wJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwZW5hYmxlX3BhZyUzRFRydWUlMkMlMEEpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZwYXRyaWNrdm9ucGxhdGVuJTJGaW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZhYV94bCUyRjAwMDAwMDAwOS5wbmclMjIlMEElMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSh1cmwpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBwaG90byUyMG9mJTIwYW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMG1hcnMlMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTIwcGFnX3NjYWxlJTNEMC4zKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = AutoPipelineForImage2Image.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-refiner-1.0&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    enable_pag=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://huggingface.co/datasets/patrickvonplaten/images/resolve/main/aa_xl/000000009.png&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = load_image(url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt, image=init_image, pag_scale=<span class="hljs-number">0.3</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){l=a("p"),l.textContent=M,v=o(),m(d.$$.fragment)},l(n){l=s(n,"P",{"data-svelte-h":!0}),c(l)!=="svelte-kvfsh7"&&(l.textContent=M),v=i(n),f(d.$$.fragment,n)},m(n,x){b(n,l,x),b(n,v,x),g(d,n,x),P=!0},p:q,i(n){P||(u(d.$$.fragment,n),P=!0)},o(n){_(d.$$.fragment,n),P=!1},d(n){n&&(r(l),r(v)),h(d,n)}}}function Zd(T){let l,M="Examples:",v,d,P;return d=new ne({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW5wYWludGluZyUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBcGlwZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmcuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTBBJTIwJTIwJTIwJTIwZW5hYmxlX3BhZyUzRFRydWUlMkMlMEEpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQWltZ191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGbGF0ZW50LWRpZmZ1c2lvbiUyRm1haW4lMkZkYXRhJTJGaW5wYWludGluZ19leGFtcGxlcyUyRm92ZXJ0dXJlLWNyZWF0aW9ucy01c0k2ZlFnWUl1by5wbmclMjIlMEFtYXNrX3VybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRkNvbXBWaXMlMkZsYXRlbnQtZGlmZnVzaW9uJTJGbWFpbiUyRmRhdGElMkZpbnBhaW50aW5nX2V4YW1wbGVzJTJGb3ZlcnR1cmUtY3JlYXRpb25zLTVzSTZmUWdZSXVvX21hc2sucG5nJTIyJTBBJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoaW1nX3VybCkuY29udmVydCglMjJSR0IlMjIpJTBBbWFza19pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UobWFza191cmwpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBtYWplc3RpYyUyMHRpZ2VyJTIwc2l0dGluZyUyMG9uJTIwYSUyMGJlbmNoJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG1hc2tfaW1hZ2UlM0RtYXNrX2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTBBJTIwJTIwJTIwJTIwc3RyZW5ndGglM0QwLjgwJTJDJTBBJTIwJTIwJTIwJTIwcGFnX3NjYWxlJTNEMC4zJTJDJTBBKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = AutoPipelineForInpainting.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
<span class="hljs-meta">... </span>    enable_pag=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = load_image(img_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_image = load_image(mask_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A majestic tiger sitting on a bench&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    image=init_image,
<span class="hljs-meta">... </span>    mask_image=mask_image,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    strength=<span class="hljs-number">0.80</span>,
<span class="hljs-meta">... </span>    pag_scale=<span class="hljs-number">0.3</span>,
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){l=a("p"),l.textContent=M,v=o(),m(d.$$.fragment)},l(n){l=s(n,"P",{"data-svelte-h":!0}),c(l)!=="svelte-kvfsh7"&&(l.textContent=M),v=i(n),f(d.$$.fragment,n)},m(n,x){b(n,l,x),b(n,v,x),g(d,n,x),P=!0},p:q,i(n){P||(u(d.$$.fragment,n),P=!0)},o(n){_(d.$$.fragment,n),P=!1},d(n){n&&(r(l),r(v)),h(d,n)}}}function Wd(T){let l,M="Examples:",v,d,P;return d=new ne({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># !pip install opencv-python transformers accelerate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image, ControlNetModel, AutoencoderKL
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> cv2
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;aerial view, a futuristic research complex in a bright foggy jungle, hard lighting&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt = <span class="hljs-string">&quot;low quality, bad quality, sketches&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># download an image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://hf.co/datasets/hf-internal-testing/diffusers-images/resolve/main/sd_controlnet/hf-logo.png&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># initialize the models and pipeline</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>controlnet_conditioning_scale = <span class="hljs-number">0.5</span>  <span class="hljs-comment"># recommended for good generalization</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>controlnet = ControlNetModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;diffusers/controlnet-canny-sdxl-1.0&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;madebyollin/sdxl-vae-fp16-fix&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = AutoPipelineForText2Image.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
<span class="hljs-meta">... </span>    controlnet=controlnet,
<span class="hljs-meta">... </span>    vae=vae,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    enable_pag=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_model_cpu_offload()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># get canny image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = np.array(image)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = cv2.Canny(image, <span class="hljs-number">100</span>, <span class="hljs-number">200</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = image[:, :, <span class="hljs-literal">None</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>canny_image = Image.fromarray(image)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># generate image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    prompt, controlnet_conditioning_scale=controlnet_conditioning_scale, image=canny_image, pag_scale=<span class="hljs-number">0.3</span>
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){l=a("p"),l.textContent=M,v=o(),m(d.$$.fragment)},l(n){l=s(n,"P",{"data-svelte-h":!0}),c(l)!=="svelte-kvfsh7"&&(l.textContent=M),v=i(n),f(d.$$.fragment,n)},m(n,x){b(n,l,x),b(n,v,x),g(d,n,x),P=!0},p:q,i(n){P||(u(d.$$.fragment,n),P=!0)},o(n){_(d.$$.fragment,n),P=!1},d(n){n&&(r(l),r(v)),h(d,n)}}}function Bd(T){let l,M="Examples:",v,d,P;return d=new ne({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># pip install accelerate transformers safetensors diffusers</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DPTFeatureExtractor, DPTForDepthEstimation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> ControlNetModel, StableDiffusionXLControlNetPAGImg2ImgPipeline, AutoencoderKL
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image


<span class="hljs-meta">&gt;&gt;&gt; </span>depth_estimator = DPTForDepthEstimation.from_pretrained(<span class="hljs-string">&quot;Intel/dpt-hybrid-midas&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = DPTFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;Intel/dpt-hybrid-midas&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>controlnet = ControlNetModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;diffusers/controlnet-depth-sdxl-1.0-small&quot;</span>,
<span class="hljs-meta">... </span>    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-string">&quot;True&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;madebyollin/sdxl-vae-fp16-fix&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionXLControlNetPAGImg2ImgPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
<span class="hljs-meta">... </span>    controlnet=controlnet,
<span class="hljs-meta">... </span>    vae=vae,
<span class="hljs-meta">... </span>    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    enable_pag=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_model_cpu_offload()


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_depth_map</span>(<span class="hljs-params">image</span>):
<span class="hljs-meta">... </span>    image = feature_extractor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad(), torch.autocast(<span class="hljs-string">&quot;cuda&quot;</span>):
<span class="hljs-meta">... </span>        depth_map = depth_estimator(image).predicted_depth

<span class="hljs-meta">... </span>    depth_map = torch.nn.fuctional.interpolate(
<span class="hljs-meta">... </span>        depth_map.unsqueeze(<span class="hljs-number">1</span>),
<span class="hljs-meta">... </span>        size=(<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>),
<span class="hljs-meta">... </span>        mode=<span class="hljs-string">&quot;bicubic&quot;</span>,
<span class="hljs-meta">... </span>        align_corners=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>    depth_min = torch.amin(depth_map, dim=[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>], keepdim=<span class="hljs-literal">True</span>)
<span class="hljs-meta">... </span>    depth_max = torch.amax(depth_map, dim=[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>], keepdim=<span class="hljs-literal">True</span>)
<span class="hljs-meta">... </span>    depth_map = (depth_map - depth_min) / (depth_max - depth_min)
<span class="hljs-meta">... </span>    image = torch.cat([depth_map] * <span class="hljs-number">3</span>, dim=<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    image = image.permute(<span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>).cpu().numpy()[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>    image = Image.fromarray((image * <span class="hljs-number">255.0</span>).clip(<span class="hljs-number">0</span>, <span class="hljs-number">255</span>).astype(np.uint8))
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> image


<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A robot, 4k photo&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;/kandinsky/cat.png&quot;</span>
<span class="hljs-meta">... </span>).resize((<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>controlnet_conditioning_scale = <span class="hljs-number">0.5</span>  <span class="hljs-comment"># recommended for good generalization</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>depth_image = get_depth_map(image)

<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(
<span class="hljs-meta">... </span>    prompt,
<span class="hljs-meta">... </span>    image=image,
<span class="hljs-meta">... </span>    control_image=depth_image,
<span class="hljs-meta">... </span>    strength=<span class="hljs-number">0.99</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    controlnet_conditioning_scale=controlnet_conditioning_scale,
<span class="hljs-meta">... </span>).images
<span class="hljs-meta">&gt;&gt;&gt; </span>images[<span class="hljs-number">0</span>].save(<span class="hljs-string">f&quot;robot_cat.png&quot;</span>)`,wrap:!1}}),{c(){l=a("p"),l.textContent=M,v=o(),m(d.$$.fragment)},l(n){l=s(n,"P",{"data-svelte-h":!0}),c(l)!=="svelte-kvfsh7"&&(l.textContent=M),v=i(n),f(d.$$.fragment,n)},m(n,x){b(n,l,x),b(n,v,x),g(d,n,x),P=!0},p:q,i(n){P||(u(d.$$.fragment,n),P=!0)},o(n){_(d.$$.fragment,n),P=!1},d(n){n&&(r(l),r(v)),h(d,n)}}}function Rd(T){let l,M="Examples:",v,d,P;return d=new ne({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZSUwQSUwQXBpcGUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMy1tZWRpdW0tZGlmZnVzZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwZW5hYmxlX3BhZyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBwYWdfYXBwbGllZF9sYXllcnMlM0QlNUIlMjJibG9ja3MuMTMlMjIlNUQlMkMlMEEpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBjYXQlMjBob2xkaW5nJTIwYSUyMHNpZ24lMjB0aGF0JTIwc2F5cyUyMGhlbGxvJTIwd29ybGQlMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q1LjAlMkMlMjBwYWdfc2NhbGUlM0QwLjcpLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMnNkM19wYWcucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = AutoPipelineForText2Image.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    enable_pag=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    pag_applied_layers=[<span class="hljs-string">&quot;blocks.13&quot;</span>],
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt, guidance_scale=<span class="hljs-number">5.0</span>, pag_scale=<span class="hljs-number">0.7</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;sd3_pag.png&quot;</span>)`,wrap:!1}}),{c(){l=a("p"),l.textContent=M,v=o(),m(d.$$.fragment)},l(n){l=s(n,"P",{"data-svelte-h":!0}),c(l)!=="svelte-kvfsh7"&&(l.textContent=M),v=i(n),f(d.$$.fragment,n)},m(n,x){b(n,l,x),b(n,v,x),g(d,n,x),P=!0},p:q,i(n){P||(u(d.$$.fragment,n),P=!0)},o(n){_(d.$$.fragment,n),P=!1},d(n){n&&(r(l),r(v)),h(d,n)}}}function Fd(T){let l,M="Examples:",v,d,P;return d=new ne({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZSUwQSUwQXBpcGUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJQaXhBcnQtYWxwaGElMkZQaXhBcnQtU2lnbWEtWEwtMi0xMDI0LU1TJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwcGFnX2FwcGxpZWRfbGF5ZXJzJTNEJTVCJTIyYmxvY2tzLjE0JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZW5hYmxlX3BhZyUzRFRydWUlMkMlMEEpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwc21hbGwlMjBjYWN0dXMlMjB3aXRoJTIwYSUyMGhhcHB5JTIwZmFjZSUyMGluJTIwdGhlJTIwU2FoYXJhJTIwZGVzZXJ0JTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUyQyUyMHBhZ19zY2FsZSUzRDQuMCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEMS4wKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = AutoPipelineForText2Image.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;PixArt-alpha/PixArt-Sigma-XL-2-1024-MS&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    pag_applied_layers=[<span class="hljs-string">&quot;blocks.14&quot;</span>],
<span class="hljs-meta">... </span>    enable_pag=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A small cactus with a happy face in the Sahara desert&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt, pag_scale=<span class="hljs-number">4.0</span>, guidance_scale=<span class="hljs-number">1.0</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){l=a("p"),l.textContent=M,v=o(),m(d.$$.fragment)},l(n){l=s(n,"P",{"data-svelte-h":!0}),c(l)!=="svelte-kvfsh7"&&(l.textContent=M),v=i(n),f(d.$$.fragment,n)},m(n,x){b(n,l,x),b(n,v,x),g(d,n,x),P=!0},p:q,i(n){P||(u(d.$$.fragment,n),P=!0)},o(n){_(d.$$.fragment,n),P=!1},d(n){n&&(r(l),r(v)),h(d,n)}}}function Ed(T){let l,M,v,d,P,n,x,Zr='<a href="https://ku-cvlab.github.io/Perturbed-Attention-Guidance/" rel="nofollow">Perturbed-Attention Guidance (PAG)</a> is a new diffusion sampling guidance that improves sample quality across both unconditional and conditional settings, achieving this without requiring further training or the integration of external modules.',_i,at,Wr='PAG was introduced in <a href="https://huggingface.co/papers/2403.17377" rel="nofollow">Self-Rectifying Diffusion Sampling with Perturbed-Attention Guidance</a> by Donghoon Ahn, Hyoungwon Cho, Jaewon Min, Wooseok Jang, Jungwoo Kim, SeonHwa Kim, Hyun Hee Park, Kyong Hwan Jin and Seungryong Kim.',hi,st,Br="The abstract from the paper is:",bi,rt,Rr="<em>Recent studies have demonstrated that diffusion models are capable of generating high-quality samples, but their quality heavily depends on sampling guidance techniques, such as classifier guidance (CG) and classifier-free guidance (CFG). These techniques are often not applicable in unconditional generation or in various downstream tasks such as image restoration. In this paper, we propose a novel sampling guidance, called Perturbed-Attention Guidance (PAG), which improves diffusion sample quality across both unconditional and conditional settings, achieving this without requiring additional training or the integration of external modules. PAG is designed to progressively enhance the structure of samples throughout the denoising process. It involves generating intermediate samples with degraded structure by substituting selected self-attention maps in diffusion U-Net with an identity matrix, by considering the self-attention mechanisms’ ability to capture structural information, and guiding the denoising process away from these degraded samples. In both ADM and Stable Diffusion, PAG surprisingly improves sample quality in conditional and even unconditional scenarios. Moreover, PAG significantly improves the baseline performance in various downstream tasks where existing guidances such as CG or CFG cannot be fully utilized, including ControlNet with empty prompts and image restoration such as inpainting and deblurring.</em>",vi,lt,Fr="PAG can be used by specifying the <code>pag_applied_layers</code> as a parameter when instantiating a PAG pipeline. It can be a single string or a list of strings. Each string can be a unique layer identifier or a regular expression to identify one or more layers.",Pi,dt,Er="<li>Full identifier as a normal string: <code>down_blocks.2.attentions.0.transformer_blocks.0.attn1.processor</code></li> <li>Full identifier as a RegEx: <code>down_blocks.2.(attentions|motion_modules).0.transformer_blocks.0.attn1.processor</code></li> <li>Partial identifier as a RegEx: <code>down_blocks.2</code>, or <code>attn1</code></li> <li>List of identifiers (can be combo of strings and ReGex): <code>[&quot;blocks.1&quot;, &quot;blocks.(14|20)&quot;, r&quot;down_blocks\\.(2,3)&quot;]</code></li>",xi,Pe,wi,pt,yi,j,ct,ua,Gn,Vr=`Pipeline for text-to-video generation using
<a href="https://huggingface.co/docs/diffusers/en/api/pipelines/animatediff" rel="nofollow">AnimateDiff</a> and <a href="https://huggingface.co/docs/diffusers/en/using-diffusers/pag" rel="nofollow">Perturbed Attention
Guidance</a>.`,_a,Dn,Or=`This model inherits from <a href="/docs/diffusers/pr_7613/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,ha,Cn,Hr="The pipeline also inherits the following loading methods:",ba,kn,qr='<li><a href="/docs/diffusers/pr_7613/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/pr_7613/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/pr_7613/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/pr_7613/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li>',va,oe,mt,Pa,Ln,Yr="The call function to the pipeline for generation.",xa,xe,wa,we,ft,ya,Sn,Qr="Encodes the prompt into text encoder hidden states.",Ii,gt,Mi,W,ut,Ia,Un,Kr=`Pipeline for English/Chinese-to-image generation using HunyuanDiT and <a href="https://huggingface.co/docs/diffusers/en/using-diffusers/pag" rel="nofollow">Perturbed Attention
Guidance</a>.`,Ma,jn,el=`This model inherits from <a href="/docs/diffusers/pr_7613/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Ta,Nn,tl=`HunyuanDiT uses two text encoders: <a href="https://huggingface.co/google/mt5-base" rel="nofollow">mT5</a> and [bilingual CLIP](fine-tuned by
ourselves)`,Aa,ie,_t,Ga,Jn,nl="The call function to the pipeline for generation with HunyuanDiT.",Da,ye,Ca,Ie,ht,ka,$n,ol="Encodes the prompt into text encoder hidden states.",Ti,bt,Ai,G,vt,La,Xn,il="Pipeline for text-to-image generation using Kolors.",Sa,zn,al=`This model inherits from <a href="/docs/diffusers/pr_7613/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Ua,Zn,sl="The pipeline also inherits the following loading methods:",ja,Wn,rl='<li><a href="/docs/diffusers/pr_7613/en/api/loaders/lora#diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/pr_7613/en/api/loaders/lora#diffusers.loaders.StableDiffusionXLLoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/pr_7613/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li>',Na,ae,Pt,Ja,Bn,ll="Function invoked when calling the pipeline for generation.",$a,Me,Xa,Te,xt,za,Rn,dl="Encodes the prompt into text encoder hidden states.",Za,Ae,wt,Wa,Fn,pl='See <a href="https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298" rel="nofollow">https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298</a>',Gi,yt,Di,D,It,Ba,En,cl="Pipeline for text-to-image generation using Stable Diffusion.",Ra,Vn,ml=`This model inherits from <a href="/docs/diffusers/pr_7613/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Fa,On,fl="The pipeline also inherits the following loading methods:",Ea,Hn,gl='<li><a href="/docs/diffusers/pr_7613/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/pr_7613/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/pr_7613/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/pr_7613/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">from_single_file()</a> for loading <code>.ckpt</code> files</li> <li><a href="/docs/diffusers/pr_7613/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li>',Va,se,Mt,Oa,qn,ul="The call function to the pipeline for generation.",Ha,Ge,qa,De,Tt,Ya,Yn,_l="Encodes the prompt into text encoder hidden states.",Qa,Ce,At,Ka,Qn,hl='See <a href="https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298" rel="nofollow">https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298</a>',Ci,Gt,ki,C,Dt,es,Kn,bl="Pipeline for text-guided image-to-image generation using Stable Diffusion.",ts,eo,vl=`This model inherits from <a href="/docs/diffusers/pr_7613/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,ns,to,Pl="The pipeline also inherits the following loading methods:",os,no,xl='<li><a href="/docs/diffusers/pr_7613/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/pr_7613/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/pr_7613/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/pr_7613/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">from_single_file()</a> for loading <code>.ckpt</code> files</li> <li><a href="/docs/diffusers/pr_7613/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li>',is,re,Ct,as,oo,wl="The call function to the pipeline for generation.",ss,ke,rs,Le,kt,ls,io,yl="Encodes the prompt into text encoder hidden states.",ds,Se,Lt,ps,ao,Il='See <a href="https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298" rel="nofollow">https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298</a>',Li,St,Si,N,Ut,cs,so,Ml="Pipeline for text-to-image generation using Stable Diffusion with ControlNet guidance.",ms,ro,Tl=`This model inherits from <a href="/docs/diffusers/pr_7613/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,fs,lo,Al="The pipeline also inherits the following loading methods:",gs,po,Gl='<li><a href="/docs/diffusers/pr_7613/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/pr_7613/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/pr_7613/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/pr_7613/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">from_single_file()</a> for loading <code>.ckpt</code> files</li> <li><a href="/docs/diffusers/pr_7613/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li>',us,Ue,jt,_s,co,Dl="Encodes the prompt into text encoder hidden states.",hs,je,Nt,bs,mo,Cl='See <a href="https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298" rel="nofollow">https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298</a>',Ui,Jt,ji,A,$t,vs,fo,kl="Pipeline for image inpainting using Stable Diffusion with ControlNet guidance.",Ps,go,Ll=`This model inherits from <a href="/docs/diffusers/pr_7613/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,xs,uo,Sl="The pipeline also inherits the following loading methods:",ws,_o,Ul='<li><a href="/docs/diffusers/pr_7613/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/pr_7613/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/pr_7613/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/pr_7613/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">from_single_file()</a> for loading <code>.ckpt</code> files</li> <li><a href="/docs/diffusers/pr_7613/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li>',ys,Ne,Is,le,Xt,Ms,ho,jl="The call function to the pipeline for generation.",Ts,Je,As,$e,zt,Gs,bo,Nl="Encodes the prompt into text encoder hidden states.",Ds,Xe,Zt,Cs,vo,Jl='See <a href="https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298" rel="nofollow">https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298</a>',Ni,Wt,Ji,k,Bt,ks,Po,$l="Pipeline for text-to-image generation using Stable Diffusion XL.",Ls,xo,Xl=`This model inherits from <a href="/docs/diffusers/pr_7613/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Ss,wo,zl="The pipeline also inherits the following loading methods:",Us,yo,Zl='<li><a href="/docs/diffusers/pr_7613/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/pr_7613/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">from_single_file()</a> for loading <code>.ckpt</code> files</li> <li><a href="/docs/diffusers/pr_7613/en/api/loaders/lora#diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/pr_7613/en/api/loaders/lora#diffusers.loaders.StableDiffusionXLLoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/pr_7613/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li>',js,de,Rt,Ns,Io,Wl="Function invoked when calling the pipeline for generation.",Js,ze,$s,Ze,Ft,Xs,Mo,Bl="Encodes the prompt into text encoder hidden states.",zs,We,Et,Zs,To,Rl='See <a href="https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298" rel="nofollow">https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298</a>',$i,Vt,Xi,L,Ot,Ws,Ao,Fl="Pipeline for text-to-image generation using Stable Diffusion XL.",Bs,Go,El=`This model inherits from <a href="/docs/diffusers/pr_7613/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Rs,Do,Vl="The pipeline also inherits the following loading methods:",Fs,Co,Ol='<li><a href="/docs/diffusers/pr_7613/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/pr_7613/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">from_single_file()</a> for loading <code>.ckpt</code> files</li> <li><a href="/docs/diffusers/pr_7613/en/api/loaders/lora#diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/pr_7613/en/api/loaders/lora#diffusers.loaders.StableDiffusionXLLoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/pr_7613/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li>',Es,pe,Ht,Vs,ko,Hl="Function invoked when calling the pipeline for generation.",Os,Be,Hs,Re,qt,qs,Lo,ql="Encodes the prompt into text encoder hidden states.",Ys,Fe,Yt,Qs,So,Yl='See <a href="https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298" rel="nofollow">https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298</a>',zi,Qt,Zi,S,Kt,Ks,Uo,Ql="Pipeline for text-to-image generation using Stable Diffusion XL.",er,jo,Kl=`This model inherits from <a href="/docs/diffusers/pr_7613/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,tr,No,ed="The pipeline also inherits the following loading methods:",nr,Jo,td='<li><a href="/docs/diffusers/pr_7613/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/pr_7613/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">from_single_file()</a> for loading <code>.ckpt</code> files</li> <li><a href="/docs/diffusers/pr_7613/en/api/loaders/lora#diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/pr_7613/en/api/loaders/lora#diffusers.loaders.StableDiffusionXLLoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/pr_7613/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li>',or,ce,en,ir,$o,nd="Function invoked when calling the pipeline for generation.",ar,Ee,sr,Ve,tn,rr,Xo,od="Encodes the prompt into text encoder hidden states.",lr,Oe,nn,dr,zo,id='See <a href="https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298" rel="nofollow">https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298</a>',Wi,on,Bi,U,an,pr,Zo,ad="Pipeline for text-to-image generation using Stable Diffusion XL with ControlNet guidance.",cr,Wo,sd=`This model inherits from <a href="/docs/diffusers/pr_7613/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,mr,Bo,rd="The pipeline also inherits the following loading methods:",fr,Ro,ld='<li><a href="/docs/diffusers/pr_7613/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/pr_7613/en/api/loaders/lora#diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/pr_7613/en/api/loaders/lora#diffusers.loaders.StableDiffusionXLLoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/pr_7613/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">from_single_file()</a> for loading <code>.ckpt</code> files</li> <li><a href="/docs/diffusers/pr_7613/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li>',gr,me,sn,ur,Fo,dd="The call function to the pipeline for generation.",_r,He,hr,qe,rn,br,Eo,pd="Encodes the prompt into text encoder hidden states.",vr,Ye,ln,Pr,Vo,cd='See <a href="https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298" rel="nofollow">https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298</a>',Ri,dn,Fi,J,pn,xr,Oo,md="Pipeline for image-to-image generation using Stable Diffusion XL with ControlNet guidance.",wr,Ho,fd=`This model inherits from <a href="/docs/diffusers/pr_7613/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,yr,qo,gd="The pipeline also inherits the following loading methods:",Ir,Yo,ud='<li><a href="/docs/diffusers/pr_7613/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/pr_7613/en/api/loaders/lora#diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/pr_7613/en/api/loaders/lora#diffusers.loaders.StableDiffusionXLLoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/pr_7613/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li>',Mr,fe,cn,Tr,Qo,_d="Function invoked when calling the pipeline for generation.",Ar,Qe,Gr,Ke,mn,Dr,Ko,hd="Encodes the prompt into text encoder hidden states.",Ei,fn,Vi,K,gn,Cr,ei,bd=`<a href="https://huggingface.co/docs/diffusers/main/en/using-diffusers/pag" rel="nofollow">PAG pipeline</a> for text-to-image generation
using Stable Diffusion 3.`,kr,ge,un,Lr,ti,vd="Function invoked when calling the pipeline for generation.",Sr,et,Ur,ni,_n,Oi,hn,Hi,ee,bn,jr,oi,Pd=`<a href="https://huggingface.co/docs/diffusers/main/en/using-diffusers/pag" rel="nofollow">PAG pipeline</a> for text-to-image generation
using PixArt-Sigma.`,Nr,ue,vn,Jr,ii,xd="Function invoked when calling the pipeline for generation.",$r,tt,Xr,nt,Pn,zr,ai,wd="Encodes the prompt into text encoder hidden states.",qi,xn,Yi,ui,Qi;return P=new H({props:{title:"Perturbed-Attention Guidance",local:"perturbed-attention-guidance",headingTag:"h1"}}),Pe=new Id({props:{warning:!0,$$slots:{default:[kd]},$$scope:{ctx:T}}}),pt=new H({props:{title:"AnimateDiffPAGPipeline",local:"diffusers.AnimateDiffPAGPipeline",headingTag:"h2"}}),ct=new I({props:{name:"class diffusers.AnimateDiffPAGPipeline",anchor:"diffusers.AnimateDiffPAGPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": Union"},{name:"motion_adapter",val:": MotionAdapter"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"feature_extractor",val:": CLIPImageProcessor = None"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"},{name:"pag_applied_layers",val:": Union = 'mid_block.*attn1'"}],parametersDescription:[{anchor:"diffusers.AnimateDiffPAGPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/pr_7613/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.AnimateDiffPAGPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.AnimateDiffPAGPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.AnimateDiffPAGPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/pr_7613/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <a href="/docs/diffusers/pr_7613/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> used to create a UNetMotionModel to denoise the encoded video latents.`,name:"unet"},{anchor:"diffusers.AnimateDiffPAGPipeline.motion_adapter",description:`<strong>motion_adapter</strong> (<code>MotionAdapter</code>) &#x2014;
A <code>MotionAdapter</code> to be used in combination with <code>unet</code> to denoise the encoded video latents.`,name:"motion_adapter"},{anchor:"diffusers.AnimateDiffPAGPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/pr_7613/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/pr_7613/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/pr_7613/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/pr_7613/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_sd_animatediff.py#L80"}}),mt=new I({props:{name:"__call__",anchor:"diffusers.AnimateDiffPAGPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"num_frames",val:": Optional = 16"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": Union = None"},{name:"num_videos_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"ip_adapter_image",val:": Union = None"},{name:"ip_adapter_image_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"decode_chunk_size",val:": int = 16"},{name:"pag_scale",val:": float = 3.0"},{name:"pag_adaptive_scale",val:": float = 0.0"}],parametersDescription:[{anchor:"diffusers.AnimateDiffPAGPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.AnimateDiffPAGPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated video.`,name:"height"},{anchor:"diffusers.AnimateDiffPAGPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated video.`,name:"width"},{anchor:"diffusers.AnimateDiffPAGPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The number of video frames that are generated. Defaults to 16 frames which at 8 frames per seconds
amounts to 2 seconds of video.`,name:"num_frames"},{anchor:"diffusers.AnimateDiffPAGPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality videos at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.AnimateDiffPAGPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.AnimateDiffPAGPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.AnimateDiffPAGPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/pr_7613/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.AnimateDiffPAGPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.AnimateDiffPAGPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for video
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>. Latents should be of shape
<code>(batch_size, num_channel, num_frames, height, width)</code>.`,name:"latents"},{anchor:"diffusers.AnimateDiffPAGPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.AnimateDiffPAGPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.
ip_adapter_image &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>):
Optional image input to work with IP Adapters.`,name:"negative_prompt_embeds"},{anchor:"diffusers.AnimateDiffPAGPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should
contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to <code>True</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"diffusers.AnimateDiffPAGPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated video. Choose between <code>torch.Tensor</code>, <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.AnimateDiffPAGPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/pr_7613/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput">TextToVideoSDPipelineOutput</a> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.AnimateDiffPAGPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.AnimateDiffPAGPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.AnimateDiffPAGPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.AnimateDiffPAGPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.AnimateDiffPAGPipeline.__call__.pag_scale",description:`<strong>pag_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 3.0) &#x2014;
The scale factor for the perturbed attention guidance. If it is set to 0.0, the perturbed attention
guidance will not be used.`,name:"pag_scale"},{anchor:"diffusers.AnimateDiffPAGPipeline.__call__.pag_adaptive_scale",description:`<strong>pag_adaptive_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The adaptive scale factor for the perturbed attention guidance. If it is set to 0.0, <code>pag_scale</code> is
used.`,name:"pag_adaptive_scale"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_sd_animatediff.py#L566",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/pr_7613/en/api/pipelines/animatediff#diffusers.pipelines.animatediff.AnimateDiffPipelineOutput"
>AnimateDiffPipelineOutput</a> is
returned, otherwise a <code>tuple</code> is returned where the first element is a list with the generated frames.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_7613/en/api/pipelines/animatediff#diffusers.pipelines.animatediff.AnimateDiffPipelineOutput"
>AnimateDiffPipelineOutput</a> or <code>tuple</code></p>
`}}),xe=new te({props:{anchor:"diffusers.AnimateDiffPAGPipeline.__call__.example",$$slots:{default:[Ld]},$$scope:{ctx:T}}}),ft=new I({props:{name:"encode_prompt",anchor:"diffusers.AnimateDiffPAGPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.AnimateDiffPAGPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.AnimateDiffPAGPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.AnimateDiffPAGPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.AnimateDiffPAGPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.AnimateDiffPAGPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.AnimateDiffPAGPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.AnimateDiffPAGPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.AnimateDiffPAGPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_sd_animatediff.py#L156"}}),gt=new H({props:{title:"HunyuanDiTPAGPipeline",local:"diffusers.HunyuanDiTPAGPipeline",headingTag:"h2"}}),ut=new I({props:{name:"class diffusers.HunyuanDiTPAGPipeline",anchor:"diffusers.HunyuanDiTPAGPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": BertModel"},{name:"tokenizer",val:": BertTokenizer"},{name:"transformer",val:": HunyuanDiT2DModel"},{name:"scheduler",val:": DDPMScheduler"},{name:"safety_checker",val:": Optional = None"},{name:"feature_extractor",val:": Optional = None"},{name:"requires_safety_checker",val:": bool = True"},{name:"text_encoder_2",val:": Optional = None"},{name:"tokenizer_2",val:": Optional = None"},{name:"pag_applied_layers",val:": Union = 'blocks.1'"}],parametersDescription:[{anchor:"diffusers.HunyuanDiTPAGPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/pr_7613/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations. We use
<code>sdxl-vae-fp16-fix</code>.`,name:"vae"},{anchor:"diffusers.HunyuanDiTPAGPipeline.text_encoder",description:`<strong>text_encoder</strong> (Optional[<code>~transformers.BertModel</code>, <code>~transformers.CLIPTextModel</code>]) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).
HunyuanDiT uses a fine-tuned [bilingual CLIP].`,name:"text_encoder"},{anchor:"diffusers.HunyuanDiTPAGPipeline.tokenizer",description:`<strong>tokenizer</strong> (Optional[<code>~transformers.BertTokenizer</code>, <code>~transformers.CLIPTokenizer</code>]) &#x2014;
A <code>BertTokenizer</code> or <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.HunyuanDiTPAGPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/pr_7613/en/api/models/hunyuan_transformer2d#diffusers.HunyuanDiT2DModel">HunyuanDiT2DModel</a>) &#x2014;
The HunyuanDiT model designed by Tencent Hunyuan.`,name:"transformer"},{anchor:"diffusers.HunyuanDiTPAGPipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<code>T5EncoderModel</code>) &#x2014;
The mT5 embedder. Specifically, it is &#x2018;t5-v1_1-xxl&#x2019;.`,name:"text_encoder_2"},{anchor:"diffusers.HunyuanDiTPAGPipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<code>MT5Tokenizer</code>) &#x2014;
The tokenizer for the mT5 embedder.`,name:"tokenizer_2"},{anchor:"diffusers.HunyuanDiTPAGPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/pr_7613/en/api/schedulers/ddpm#diffusers.DDPMScheduler">DDPMScheduler</a>) &#x2014;
A scheduler to be used in combination with HunyuanDiT to denoise the encoded image latents.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_hunyuandit.py#L144"}}),_t=new I({props:{name:"__call__",anchor:"diffusers.HunyuanDiTPAGPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": Optional = 50"},{name:"guidance_scale",val:": Optional = 5.0"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"eta",val:": Optional = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"prompt_embeds_2",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds_2",val:": Optional = None"},{name:"prompt_attention_mask",val:": Optional = None"},{name:"prompt_attention_mask_2",val:": Optional = None"},{name:"negative_prompt_attention_mask",val:": Optional = None"},{name:"negative_prompt_attention_mask_2",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback_on_step_end",val:": Union = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"guidance_rescale",val:": float = 0.0"},{name:"original_size",val:": Optional = (1024, 1024)"},{name:"target_size",val:": Optional = None"},{name:"crops_coords_top_left",val:": Tuple = (0, 0)"},{name:"use_resolution_binning",val:": bool = True"},{name:"pag_scale",val:": float = 3.0"},{name:"pag_adaptive_scale",val:": float = 0.0"}],parametersDescription:[{anchor:"diffusers.HunyuanDiTPAGPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.HunyuanDiTPAGPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.HunyuanDiTPAGPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.HunyuanDiTPAGPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference. This parameter is modulated by <code>strength</code>.`,name:"num_inference_steps"},{anchor:"diffusers.HunyuanDiTPAGPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.HunyuanDiTPAGPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.HunyuanDiTPAGPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.HunyuanDiTPAGPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/pr_7613/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.HunyuanDiTPAGPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.HunyuanDiTPAGPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.HunyuanDiTPAGPipeline.__call__.prompt_embeds_2",description:`<strong>prompt_embeds_2</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds_2"},{anchor:"diffusers.HunyuanDiTPAGPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.HunyuanDiTPAGPipeline.__call__.negative_prompt_embeds_2",description:`<strong>negative_prompt_embeds_2</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds_2"},{anchor:"diffusers.HunyuanDiTPAGPipeline.__call__.prompt_attention_mask",description:`<strong>prompt_attention_mask</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Attention mask for the prompt. Required when <code>prompt_embeds</code> is passed directly.`,name:"prompt_attention_mask"},{anchor:"diffusers.HunyuanDiTPAGPipeline.__call__.prompt_attention_mask_2",description:`<strong>prompt_attention_mask_2</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Attention mask for the prompt. Required when <code>prompt_embeds_2</code> is passed directly.`,name:"prompt_attention_mask_2"},{anchor:"diffusers.HunyuanDiTPAGPipeline.__call__.negative_prompt_attention_mask",description:`<strong>negative_prompt_attention_mask</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Attention mask for the negative prompt. Required when <code>negative_prompt_embeds</code> is passed directly.`,name:"negative_prompt_attention_mask"},{anchor:"diffusers.HunyuanDiTPAGPipeline.__call__.negative_prompt_attention_mask_2",description:`<strong>negative_prompt_attention_mask_2</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Attention mask for the negative prompt. Required when <code>negative_prompt_embeds_2</code> is passed directly.`,name:"negative_prompt_attention_mask_2"},{anchor:"diffusers.HunyuanDiTPAGPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.HunyuanDiTPAGPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/pr_7613/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.HunyuanDiTPAGPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable[[int, int, Dict], None]</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A callback function or a list of callback functions to be called at the end of each denoising step.`,name:"callback_on_step_end"},{anchor:"diffusers.HunyuanDiTPAGPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of tensor inputs that should be passed to the callback function. If not defined, all tensor
inputs will be passed.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.HunyuanDiTPAGPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Rescale the noise_cfg according to <code>guidance_rescale</code>. Based on findings of <a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise
Schedules and Sample Steps are Flawed</a>. See Section 3.4`,name:"guidance_rescale"},{anchor:"diffusers.HunyuanDiTPAGPipeline.__call__.original_size",description:`<strong>original_size</strong> (<code>Tuple[int, int]</code>, <em>optional</em>, defaults to <code>(1024, 1024)</code>) &#x2014;
The original size of the image. Used to calculate the time ids.`,name:"original_size"},{anchor:"diffusers.HunyuanDiTPAGPipeline.__call__.target_size",description:`<strong>target_size</strong> (<code>Tuple[int, int]</code>, <em>optional</em>) &#x2014;
The target size of the image. Used to calculate the time ids.`,name:"target_size"},{anchor:"diffusers.HunyuanDiTPAGPipeline.__call__.crops_coords_top_left",description:`<strong>crops_coords_top_left</strong> (<code>Tuple[int, int]</code>, <em>optional</em>, defaults to <code>(0, 0)</code>) &#x2014;
The top left coordinates of the crop. Used to calculate the time ids.`,name:"crops_coords_top_left"},{anchor:"diffusers.HunyuanDiTPAGPipeline.__call__.use_resolution_binning",description:`<strong>use_resolution_binning</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use resolution binning or not. If <code>True</code>, the input resolution will be mapped to the closest
standard resolution. Supported resolutions are 1024x1024, 1280x1280, 1024x768, 1152x864, 1280x960,
768x1024, 864x1152, 960x1280, 1280x768, and 768x1280. It is recommended to set this to <code>True</code>.`,name:"use_resolution_binning"},{anchor:"diffusers.HunyuanDiTPAGPipeline.__call__.pag_scale",description:`<strong>pag_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 3.0) &#x2014;
The scale factor for the perturbed attention guidance. If it is set to 0.0, the perturbed attention
guidance will not be used.`,name:"pag_scale"},{anchor:"diffusers.HunyuanDiTPAGPipeline.__call__.pag_adaptive_scale",description:`<strong>pag_adaptive_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The adaptive scale factor for the perturbed attention guidance. If it is set to 0.0, <code>pag_scale</code> is
used.`,name:"pag_adaptive_scale"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_hunyuandit.py#L573",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/pr_7613/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_7613/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),ye=new te({props:{anchor:"diffusers.HunyuanDiTPAGPipeline.__call__.example",$$slots:{default:[Sd]},$$scope:{ctx:T}}}),ht=new I({props:{name:"encode_prompt",anchor:"diffusers.HunyuanDiTPAGPipeline.encode_prompt",parameters:[{name:"prompt",val:": str"},{name:"device",val:": device = None"},{name:"dtype",val:": dtype = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"negative_prompt",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"prompt_attention_mask",val:": Optional = None"},{name:"negative_prompt_attention_mask",val:": Optional = None"},{name:"max_sequence_length",val:": Optional = None"},{name:"text_encoder_index",val:": int = 0"}],parametersDescription:[{anchor:"diffusers.HunyuanDiTPAGPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.HunyuanDiTPAGPipeline.encode_prompt.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>) &#x2014;
torch dtype`,name:"dtype"},{anchor:"diffusers.HunyuanDiTPAGPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.HunyuanDiTPAGPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.HunyuanDiTPAGPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.HunyuanDiTPAGPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.HunyuanDiTPAGPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.HunyuanDiTPAGPipeline.encode_prompt.prompt_attention_mask",description:`<strong>prompt_attention_mask</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Attention mask for the prompt. Required when <code>prompt_embeds</code> is passed directly.`,name:"prompt_attention_mask"},{anchor:"diffusers.HunyuanDiTPAGPipeline.encode_prompt.negative_prompt_attention_mask",description:`<strong>negative_prompt_attention_mask</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Attention mask for the negative prompt. Required when <code>negative_prompt_embeds</code> is passed directly.`,name:"negative_prompt_attention_mask"},{anchor:"diffusers.HunyuanDiTPAGPipeline.encode_prompt.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code>, <em>optional</em>) &#x2014; maximum sequence length to use for the prompt.",name:"max_sequence_length"},{anchor:"diffusers.HunyuanDiTPAGPipeline.encode_prompt.text_encoder_index",description:`<strong>text_encoder_index</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Index of the text encoder to use. <code>0</code> for clip and <code>1</code> for T5.`,name:"text_encoder_index"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_hunyuandit.py#L252"}}),bt=new H({props:{title:"KolorsPAGPipeline",local:"diffusers.KolorsPAGPipeline",headingTag:"h2"}}),vt=new I({props:{name:"class diffusers.KolorsPAGPipeline",anchor:"diffusers.KolorsPAGPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": ChatGLMModel"},{name:"tokenizer",val:": ChatGLMTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"},{name:"feature_extractor",val:": CLIPImageProcessor = None"},{name:"force_zeros_for_empty_prompt",val:": bool = False"},{name:"pag_applied_layers",val:": Union = 'mid'"}],parametersDescription:[{anchor:"diffusers.KolorsPAGPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/pr_7613/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.KolorsPAGPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>ChatGLMModel</code>) &#x2014;
Frozen text-encoder. Kolors uses <a href="https://huggingface.co/THUDM/chatglm3-6b" rel="nofollow">ChatGLM3-6B</a>.`,name:"text_encoder"},{anchor:"diffusers.KolorsPAGPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>ChatGLMTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/THUDM/chatglm3-6b/blob/main/tokenization_chatglm.py" rel="nofollow">ChatGLMTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.KolorsPAGPipeline.unet",description:'<strong>unet</strong> (<a href="/docs/diffusers/pr_7613/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014; Conditional U-Net architecture to denoise the encoded image latents.',name:"unet"},{anchor:"diffusers.KolorsPAGPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/pr_7613/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/pr_7613/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/pr_7613/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/pr_7613/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.KolorsPAGPipeline.force_zeros_for_empty_prompt",description:`<strong>force_zeros_for_empty_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>&quot;False&quot;</code>) &#x2014;
Whether the negative prompt embeddings shall be forced to always be set to 0. Also see the config of
<code>Kwai-Kolors/Kolors-diffusers</code>.`,name:"force_zeros_for_empty_prompt"},{anchor:"diffusers.KolorsPAGPipeline.pag_applied_layers",description:`<strong>pag_applied_layers</strong> (<code>str</code> or <code>List[str]\`\`, *optional*, defaults to </code>&#x201C;mid&#x201D;\`) &#x2014;
Set the transformer attention layers where to apply the perturbed attention guidance. Can be a string or a
list of strings with &#x201C;down&#x201D;, &#x201C;mid&#x201D;, &#x201C;up&#x201D;, a whole transformer block or specific transformer block attention
layers, e.g.:
[&#x201C;mid&#x201D;][&quot;down&quot;, &quot;mid&quot;] [&#x201C;down&#x201D;, &#x201C;mid&#x201D;, &#x201C;up.block_1&#x201D;][&quot;down&quot;, &quot;mid&quot;, &quot;up.block_1.attentions_0&quot;,
&quot;up.block_1.attentions_1&quot;]`,name:"pag_applied_layers"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_kolors.py#L129"}}),Pt=new I({props:{name:"__call__",anchor:"diffusers.KolorsPAGPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": List = None"},{name:"sigmas",val:": List = None"},{name:"denoising_end",val:": Optional = None"},{name:"guidance_scale",val:": float = 5.0"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"pooled_prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"negative_pooled_prompt_embeds",val:": Optional = None"},{name:"ip_adapter_image",val:": Union = None"},{name:"ip_adapter_image_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"original_size",val:": Optional = None"},{name:"crops_coords_top_left",val:": Tuple = (0, 0)"},{name:"target_size",val:": Optional = None"},{name:"negative_original_size",val:": Optional = None"},{name:"negative_crops_coords_top_left",val:": Tuple = (0, 0)"},{name:"negative_target_size",val:": Optional = None"},{name:"callback_on_step_end",val:": Union = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"pag_scale",val:": float = 3.0"},{name:"pag_adaptive_scale",val:": float = 0.0"},{name:"max_sequence_length",val:": int = 256"}],parametersDescription:[{anchor:"diffusers.KolorsPAGPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.KolorsPAGPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.
Anything below 512 pixels won&#x2019;t work well for
<a href="https://huggingface.co/Kwai-Kolors/Kolors-diffusers" rel="nofollow">Kwai-Kolors/Kolors-diffusers</a> and checkpoints
that are not specifically fine-tuned on low resolutions.`,name:"height"},{anchor:"diffusers.KolorsPAGPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.
Anything below 512 pixels won&#x2019;t work well for
<a href="https://huggingface.co/Kwai-Kolors/Kolors-diffusers" rel="nofollow">Kwai-Kolors/Kolors-diffusers</a> and checkpoints
that are not specifically fine-tuned on low resolutions.`,name:"width"},{anchor:"diffusers.KolorsPAGPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KolorsPAGPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.KolorsPAGPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.KolorsPAGPipeline.__call__.denoising_end",description:`<strong>denoising_end</strong> (<code>float</code>, <em>optional</em>) &#x2014;
When specified, determines the fraction (between 0.0 and 1.0) of the total denoising process to be
completed before it is intentionally prematurely terminated. As a result, the returned sample will
still retain a substantial amount of noise as determined by the discrete timesteps selected by the
scheduler. The denoising_end parameter should ideally be utilized when this pipeline forms a part of a
&#x201C;Mixture of Denoisers&#x201D; multi-pipeline setup, as elaborated in <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_xl#refining-the-image-output" rel="nofollow"><strong>Refining the Image
Output</strong></a>`,name:"denoising_end"},{anchor:"diffusers.KolorsPAGPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 5.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KolorsPAGPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KolorsPAGPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KolorsPAGPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">https://arxiv.org/abs/2010.02502</a>. Only applies to
<a href="/docs/diffusers/pr_7613/en/api/schedulers/ddim#diffusers.DDIMScheduler">schedulers.DDIMScheduler</a>, will be ignored for others.`,name:"eta"},{anchor:"diffusers.KolorsPAGPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KolorsPAGPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KolorsPAGPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.KolorsPAGPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.KolorsPAGPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.KolorsPAGPipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.
ip_adapter_image &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.KolorsPAGPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should
contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to <code>True</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"diffusers.KolorsPAGPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.KolorsPAGPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.kolors.KolorsPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.KolorsPAGPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.KolorsPAGPipeline.__call__.original_size",description:`<strong>original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
If <code>original_size</code> is not the same as <code>target_size</code> the image will appear to be down- or upsampled.
<code>original_size</code> defaults to <code>(height, width)</code> if not specified. Part of SDXL&#x2019;s micro-conditioning as
explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"original_size"},{anchor:"diffusers.KolorsPAGPipeline.__call__.crops_coords_top_left",description:`<strong>crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
<code>crops_coords_top_left</code> can be used to generate an image that appears to be &#x201C;cropped&#x201D; from the position
<code>crops_coords_top_left</code> downwards. Favorable, well-centered images are usually achieved by setting
<code>crops_coords_top_left</code> to (0, 0). Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"crops_coords_top_left"},{anchor:"diffusers.KolorsPAGPipeline.__call__.target_size",description:`<strong>target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
For most cases, <code>target_size</code> should be set to the desired height and width of the generated image. If
not specified it will default to <code>(height, width)</code>. Part of SDXL&#x2019;s micro-conditioning as explained in
section 2.2 of <a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"target_size"},{anchor:"diffusers.KolorsPAGPipeline.__call__.negative_original_size",description:`<strong>negative_original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
To negatively condition the generation process based on a specific image resolution. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_original_size"},{anchor:"diffusers.KolorsPAGPipeline.__call__.negative_crops_coords_top_left",description:`<strong>negative_crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
To negatively condition the generation process based on a specific crop coordinates. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_crops_coords_top_left"},{anchor:"diffusers.KolorsPAGPipeline.__call__.negative_target_size",description:`<strong>negative_target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
To negatively condition the generation process based on a target image resolution. It should be as same
as the <code>target_size</code> for most cases. Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_target_size"},{anchor:"diffusers.KolorsPAGPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.KolorsPAGPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.KolorsPAGPipeline.__call__.pag_scale",description:`<strong>pag_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 3.0) &#x2014;
The scale factor for the perturbed attention guidance. If it is set to 0.0, the perturbed attention
guidance will not be used.`,name:"pag_scale"},{anchor:"diffusers.KolorsPAGPipeline.__call__.pag_adaptive_scale",description:`<strong>pag_adaptive_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The adaptive scale factor for the perturbed attention guidance. If it is set to 0.0, <code>pag_scale</code> is
used.`,name:"pag_adaptive_scale"},{anchor:"diffusers.KolorsPAGPipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 256) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_kolors.py#L674",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.kolors.KolorsPipelineOutput</code> if
<code>return_dict</code> is True, otherwise a <code>tuple</code>. When returning a tuple, the first element is a list with the
generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.kolors.KolorsPipelineOutput</code> or <code>tuple</code></p>
`}}),Me=new te({props:{anchor:"diffusers.KolorsPAGPipeline.__call__.example",$$slots:{default:[Ud]},$$scope:{ctx:T}}}),xt=new I({props:{name:"encode_prompt",anchor:"diffusers.KolorsPAGPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:": Optional = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"pooled_prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"negative_pooled_prompt_embeds",val:": Optional = None"},{name:"max_sequence_length",val:": int = 256"}],parametersDescription:[{anchor:"diffusers.KolorsPAGPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.KolorsPAGPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.KolorsPAGPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.KolorsPAGPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KolorsPAGPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.KolorsPAGPipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.KolorsPAGPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.KolorsPAGPipeline.encode_prompt.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.KolorsPAGPipeline.encode_prompt.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 256) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_kolors.py#L215"}}),wt=new I({props:{name:"get_guidance_scale_embedding",anchor:"diffusers.KolorsPAGPipeline.get_guidance_scale_embedding",parameters:[{name:"w",val:": Tensor"},{name:"embedding_dim",val:": int = 512"},{name:"dtype",val:": dtype = torch.float32"}],parametersDescription:[{anchor:"diffusers.KolorsPAGPipeline.get_guidance_scale_embedding.w",description:`<strong>w</strong> (<code>torch.Tensor</code>) &#x2014;
Generate embedding vectors with a specified guidance scale to subsequently enrich timestep embeddings.`,name:"w"},{anchor:"diffusers.KolorsPAGPipeline.get_guidance_scale_embedding.embedding_dim",description:`<strong>embedding_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Dimension of the embeddings to generate.`,name:"embedding_dim"},{anchor:"diffusers.KolorsPAGPipeline.get_guidance_scale_embedding.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.float32</code>) &#x2014;
Data type of the generated embeddings.`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_kolors.py#L617",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Embedding vectors with shape <code>(len(w), embedding_dim)</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),yt=new H({props:{title:"StableDiffusionPAGPipeline",local:"diffusers.StableDiffusionPAGPipeline",headingTag:"h2"}}),It=new I({props:{name:"class diffusers.StableDiffusionPAGPipeline",anchor:"diffusers.StableDiffusionPAGPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"},{name:"requires_safety_checker",val:": bool = True"},{name:"pag_applied_layers",val:": Union = 'mid'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPAGPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/pr_7613/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionPAGPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionPAGPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionPAGPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/pr_7613/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionPAGPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/pr_7613/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/pr_7613/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/pr_7613/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/pr_7613/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionPAGPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.StableDiffusionPAGPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_sd.py#L136"}}),Mt=new I({props:{name:"__call__",anchor:"diffusers.StableDiffusionPAGPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": List = None"},{name:"sigmas",val:": List = None"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"ip_adapter_image",val:": Union = None"},{name:"ip_adapter_image_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"guidance_rescale",val:": float = 0.0"},{name:"clip_skip",val:": Optional = None"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"pag_scale",val:": float = 3.0"},{name:"pag_adaptive_scale",val:": float = 0.0"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPAGPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionPAGPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableDiffusionPAGPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableDiffusionPAGPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionPAGPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.StableDiffusionPAGPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.StableDiffusionPAGPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionPAGPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionPAGPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionPAGPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/pr_7613/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionPAGPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionPAGPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionPAGPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionPAGPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.
ip_adapter_image &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionPAGPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should
contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to <code>True</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"diffusers.StableDiffusionPAGPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionPAGPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/pr_7613/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionPAGPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionPAGPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Guidance rescale factor from <a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a>. Guidance rescale factor should fix overexposure when
using zero terminal SNR.`,name:"guidance_rescale"},{anchor:"diffusers.StableDiffusionPAGPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.StableDiffusionPAGPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.StableDiffusionPAGPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.StableDiffusionPAGPipeline.__call__.pag_scale",description:`<strong>pag_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 3.0) &#x2014;
The scale factor for the perturbed attention guidance. If it is set to 0.0, the perturbed attention
guidance will not be used.`,name:"pag_scale"},{anchor:"diffusers.StableDiffusionPAGPipeline.__call__.pag_adaptive_scale",description:`<strong>pag_adaptive_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The adaptive scale factor for the perturbed attention guidance. If it is set to 0.0, <code>pag_scale</code> is
used.`,name:"pag_adaptive_scale"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_sd.py#L720",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/pr_7613/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_7613/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),Ge=new te({props:{anchor:"diffusers.StableDiffusionPAGPipeline.__call__.example",$$slots:{default:[jd]},$$scope:{ctx:T}}}),Tt=new I({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionPAGPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPAGPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.StableDiffusionPAGPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionPAGPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionPAGPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionPAGPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionPAGPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionPAGPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionPAGPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_sd.py#L279"}}),At=new I({props:{name:"get_guidance_scale_embedding",anchor:"diffusers.StableDiffusionPAGPipeline.get_guidance_scale_embedding",parameters:[{name:"w",val:": Tensor"},{name:"embedding_dim",val:": int = 512"},{name:"dtype",val:": dtype = torch.float32"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPAGPipeline.get_guidance_scale_embedding.w",description:`<strong>w</strong> (<code>torch.Tensor</code>) &#x2014;
Generate embedding vectors with a specified guidance scale to subsequently enrich timestep embeddings.`,name:"w"},{anchor:"diffusers.StableDiffusionPAGPipeline.get_guidance_scale_embedding.embedding_dim",description:`<strong>embedding_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Dimension of the embeddings to generate.`,name:"embedding_dim"},{anchor:"diffusers.StableDiffusionPAGPipeline.get_guidance_scale_embedding.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.float32</code>) &#x2014;
Data type of the generated embeddings.`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_sd.py#L659",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Embedding vectors with shape <code>(len(w), embedding_dim)</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),Gt=new H({props:{title:"StableDiffusionPAGImg2ImgPipeline",local:"diffusers.StableDiffusionPAGImg2ImgPipeline",headingTag:"h2"}}),Dt=new I({props:{name:"class diffusers.StableDiffusionPAGImg2ImgPipeline",anchor:"diffusers.StableDiffusionPAGImg2ImgPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"},{name:"requires_safety_checker",val:": bool = True"},{name:"pag_applied_layers",val:": Union = 'mid'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPAGImg2ImgPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/pr_7613/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionPAGImg2ImgPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionPAGImg2ImgPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionPAGImg2ImgPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/pr_7613/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionPAGImg2ImgPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/pr_7613/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/pr_7613/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/pr_7613/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/pr_7613/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionPAGImg2ImgPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.StableDiffusionPAGImg2ImgPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_sd_img2img.py#L143"}}),Ct=new I({props:{name:"__call__",anchor:"diffusers.StableDiffusionPAGImg2ImgPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"image",val:": Union = None"},{name:"strength",val:": float = 0.8"},{name:"num_inference_steps",val:": Optional = 50"},{name:"timesteps",val:": List = None"},{name:"sigmas",val:": List = None"},{name:"guidance_scale",val:": Optional = 7.5"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"eta",val:": Optional = 0.0"},{name:"generator",val:": Union = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"ip_adapter_image",val:": Union = None"},{name:"ip_adapter_image_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"clip_skip",val:": int = None"},{name:"callback_on_step_end",val:": Union = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"pag_scale",val:": float = 3.0"},{name:"pag_adaptive_scale",val:": float = 0.0"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPAGImg2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionPAGImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to be used as the starting point. For both
numpy array and pytorch tensor, the expected value range is between <code>[0, 1]</code> If it&#x2019;s a tensor or a list
or tensors, the expected shape should be <code>(B, C, H, W)</code> or <code>(C, H, W)</code>. If it is a numpy array or a
list of arrays, the expected shape should be <code>(B, H, W, C)</code> or <code>(H, W, C)</code> It can also accept image
latents as <code>image</code>, but if passing latents directly it is not encoded again.`,name:"image"},{anchor:"diffusers.StableDiffusionPAGImg2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
Indicates extent to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code> is used as a
starting point and more noise is added the higher the <code>strength</code>. The number of denoising steps depends
on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the denoising
process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of 1
essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.StableDiffusionPAGImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference. This parameter is modulated by <code>strength</code>.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionPAGImg2ImgPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.StableDiffusionPAGImg2ImgPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.StableDiffusionPAGImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionPAGImg2ImgPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionPAGImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionPAGImg2ImgPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/pr_7613/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionPAGImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionPAGImg2ImgPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionPAGImg2ImgPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.
ip_adapter_image &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionPAGImg2ImgPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should
contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to <code>True</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"diffusers.StableDiffusionPAGImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionPAGImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/pr_7613/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionPAGImg2ImgPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionPAGImg2ImgPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.StableDiffusionPAGImg2ImgPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.StableDiffusionPAGImg2ImgPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.StableDiffusionPAGImg2ImgPipeline.__call__.pag_scale",description:`<strong>pag_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 3.0) &#x2014;
The scale factor for the perturbed attention guidance. If it is set to 0.0, the perturbed attention
guidance will not be used.`,name:"pag_scale"},{anchor:"diffusers.StableDiffusionPAGImg2ImgPipeline.__call__.pag_adaptive_scale",description:`<strong>pag_adaptive_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The adaptive scale factor for the perturbed attention guidance. If it is set to 0.0, <code>pag_scale</code> is
used.`,name:"pag_adaptive_scale"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_sd_img2img.py#L769",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/pr_7613/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_7613/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),ke=new te({props:{anchor:"diffusers.StableDiffusionPAGImg2ImgPipeline.__call__.example",$$slots:{default:[Nd]},$$scope:{ctx:T}}}),kt=new I({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionPAGImg2ImgPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPAGImg2ImgPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.StableDiffusionPAGImg2ImgPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionPAGImg2ImgPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionPAGImg2ImgPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionPAGImg2ImgPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionPAGImg2ImgPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionPAGImg2ImgPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionPAGImg2ImgPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_sd_img2img.py#L286"}}),Lt=new I({props:{name:"get_guidance_scale_embedding",anchor:"diffusers.StableDiffusionPAGImg2ImgPipeline.get_guidance_scale_embedding",parameters:[{name:"w",val:": Tensor"},{name:"embedding_dim",val:": int = 512"},{name:"dtype",val:": dtype = torch.float32"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPAGImg2ImgPipeline.get_guidance_scale_embedding.w",description:`<strong>w</strong> (<code>torch.Tensor</code>) &#x2014;
Generate embedding vectors with a specified guidance scale to subsequently enrich timestep embeddings.`,name:"w"},{anchor:"diffusers.StableDiffusionPAGImg2ImgPipeline.get_guidance_scale_embedding.embedding_dim",description:`<strong>embedding_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Dimension of the embeddings to generate.`,name:"embedding_dim"},{anchor:"diffusers.StableDiffusionPAGImg2ImgPipeline.get_guidance_scale_embedding.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.float32</code>) &#x2014;
Data type of the generated embeddings.`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_sd_img2img.py#L712",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Embedding vectors with shape <code>(len(w), embedding_dim)</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),St=new H({props:{title:"StableDiffusionControlNetPAGPipeline",local:"diffusers.StableDiffusionControlNetPAGPipeline",headingTag:"h2"}}),Ut=new I({props:{name:"class diffusers.StableDiffusionControlNetPAGPipeline",anchor:"diffusers.StableDiffusionControlNetPAGPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"controlnet",val:": Union"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"},{name:"requires_safety_checker",val:": bool = True"},{name:"pag_applied_layers",val:": Union = 'mid'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetPAGPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/pr_7613/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionControlNetPAGPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionControlNetPAGPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionControlNetPAGPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/pr_7613/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionControlNetPAGPipeline.controlnet",description:`<strong>controlnet</strong> (<a href="/docs/diffusers/pr_7613/en/api/models/controlnet#diffusers.ControlNetModel">ControlNetModel</a> or <code>List[ControlNetModel]</code>) &#x2014;
Provides additional conditioning to the <code>unet</code> during the denoising process. If you set multiple
ControlNets as a list, the outputs from each ControlNet are added together to create one combined
additional conditioning.`,name:"controlnet"},{anchor:"diffusers.StableDiffusionControlNetPAGPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/pr_7613/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/pr_7613/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/pr_7613/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/pr_7613/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionControlNetPAGPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.StableDiffusionControlNetPAGPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_controlnet_sd.py#L158"}}),jt=new I({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionControlNetPAGPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetPAGPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.StableDiffusionControlNetPAGPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionControlNetPAGPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionControlNetPAGPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionControlNetPAGPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionControlNetPAGPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionControlNetPAGPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionControlNetPAGPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_controlnet_sd.py#L265"}}),Nt=new I({props:{name:"get_guidance_scale_embedding",anchor:"diffusers.StableDiffusionControlNetPAGPipeline.get_guidance_scale_embedding",parameters:[{name:"w",val:": Tensor"},{name:"embedding_dim",val:": int = 512"},{name:"dtype",val:": dtype = torch.float32"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetPAGPipeline.get_guidance_scale_embedding.w",description:`<strong>w</strong> (<code>torch.Tensor</code>) &#x2014;
Generate embedding vectors with a specified guidance scale to subsequently enrich timestep embeddings.`,name:"w"},{anchor:"diffusers.StableDiffusionControlNetPAGPipeline.get_guidance_scale_embedding.embedding_dim",description:`<strong>embedding_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Dimension of the embeddings to generate.`,name:"embedding_dim"},{anchor:"diffusers.StableDiffusionControlNetPAGPipeline.get_guidance_scale_embedding.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.float32</code>) &#x2014;
Data type of the generated embeddings.`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_controlnet_sd.py#L800",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Embedding vectors with shape <code>(len(w), embedding_dim)</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),Jt=new H({props:{title:"StableDiffusionControlNetPAGInpaintPipeline",local:"diffusers.StableDiffusionControlNetPAGInpaintPipeline",headingTag:"h2"}}),$t=new I({props:{name:"class diffusers.StableDiffusionControlNetPAGInpaintPipeline",anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"controlnet",val:": Union"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"},{name:"requires_safety_checker",val:": bool = True"},{name:"pag_applied_layers",val:": Union = 'mid'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/pr_7613/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/pr_7613/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.controlnet",description:`<strong>controlnet</strong> (<a href="/docs/diffusers/pr_7613/en/api/models/controlnet#diffusers.ControlNetModel">ControlNetModel</a> or <code>List[ControlNetModel]</code>) &#x2014;
Provides additional conditioning to the <code>unet</code> during the denoising process. If you set multiple
ControlNets as a list, the outputs from each ControlNet are added together to create one combined
additional conditioning.`,name:"controlnet"},{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/pr_7613/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/pr_7613/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/pr_7613/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/pr_7613/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_controlnet_sd_inpaint.py#L124"}}),Ne=new Id({props:{$$slots:{default:[Jd]},$$scope:{ctx:T}}}),Xt=new I({props:{name:"__call__",anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"image",val:": Union = None"},{name:"mask_image",val:": Union = None"},{name:"control_image",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"padding_mask_crop",val:": Optional = None"},{name:"strength",val:": float = 1.0"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"ip_adapter_image",val:": Union = None"},{name:"ip_adapter_image_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"controlnet_conditioning_scale",val:": Union = 0.5"},{name:"control_guidance_start",val:": Union = 0.0"},{name:"control_guidance_end",val:": Union = 1.0"},{name:"clip_skip",val:": Optional = None"},{name:"callback_on_step_end",val:": Union = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"pag_scale",val:": float = 3.0"},{name:"pag_adaptive_scale",val:": float = 0.0"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, &#x2014;
<code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>):
<code>Image</code>, NumPy array or tensor representing an image batch to be used as the starting point. For both
NumPy array and PyTorch tensor, the expected value range is between <code>[0, 1]</code>. If it&#x2019;s a tensor or a
list or tensors, the expected shape should be <code>(B, C, H, W)</code> or <code>(C, H, W)</code>. If it is a NumPy array or
a list of arrays, the expected shape should be <code>(B, H, W, C)</code> or <code>(H, W, C)</code>. It can also accept image
latents as <code>image</code>, but if passing latents directly it is not encoded again.`,name:"image"},{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, &#x2014;
<code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>):
<code>Image</code>, NumPy array or tensor representing an image batch to mask <code>image</code>. White pixels in the mask
are repainted while black pixels are preserved. If <code>mask_image</code> is a PIL image, it is converted to a
single channel (luminance) before use. If it&#x2019;s a NumPy array or PyTorch tensor, it should contain one
color channel (L) instead of 3, so the expected shape for PyTorch tensor would be <code>(B, 1, H, W)</code>, <code>(B, H, W)</code>, <code>(1, H, W)</code>, <code>(H, W)</code>. And for NumPy array, it would be for <code>(B, H, W, 1)</code>, <code>(B, H, W)</code>, <code>(H, W, 1)</code>, or <code>(H, W)</code>.`,name:"mask_image"},{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.__call__.control_image",description:`<strong>control_image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, &#x2014;
<code>List[List[torch.Tensor]]</code>, or <code>List[List[PIL.Image.Image]]</code>):
The ControlNet input condition to provide guidance to the <code>unet</code> for generation. If the type is
specified as <code>torch.Tensor</code>, it is passed to ControlNet as is. <code>PIL.Image.Image</code> can also be accepted
as an image. The dimensions of the output image defaults to <code>image</code>&#x2019;s dimensions. If height and/or
width are passed, <code>image</code> is resized accordingly. If multiple ControlNets are specified in <code>init</code>,
images must be passed as a list such that each element of the list can be correctly batched for input
to a single ControlNet.`,name:"control_image"},{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.__call__.padding_mask_crop",description:`<strong>padding_mask_crop</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The size of margin in the crop to be applied to the image and masking. If <code>None</code>, no crop is applied to
image and mask_image. If <code>padding_mask_crop</code> is not <code>None</code>, it will first find a rectangular region
with the same aspect ration of the image and contains all masked area, and then expand that area based
on <code>padding_mask_crop</code>. The image and mask_image will then be cropped based on the expanded area before
resizing to the original image size for inpainting. This is useful when the masked area is small while
the image is large and contain information irrelevant for inpainting, such as background.`,name:"padding_mask_crop"},{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Indicates extent to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code> is used as a
starting point and more noise is added the higher the <code>strength</code>. The number of denoising steps depends
on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the denoising
process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of 1
essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/pr_7613/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.
ip_adapter_image &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should
contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to <code>True</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/pr_7613/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.__call__.controlnet_conditioning_scale",description:`<strong>controlnet_conditioning_scale</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The outputs of the ControlNet are multiplied by <code>controlnet_conditioning_scale</code> before they are added
to the residual in the original <code>unet</code>. If multiple ControlNets are specified in <code>init</code>, you can set
the corresponding scale as a list.`,name:"controlnet_conditioning_scale"},{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.__call__.control_guidance_start",description:`<strong>control_guidance_start</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The percentage of total steps at which the ControlNet starts applying.`,name:"control_guidance_start"},{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.__call__.control_guidance_end",description:`<strong>control_guidance_end</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The percentage of total steps at which the ControlNet stops applying.`,name:"control_guidance_end"},{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.__call__.pag_scale",description:`<strong>pag_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 3.0) &#x2014;
The scale factor for the perturbed attention guidance. If it is set to 0.0, the perturbed attention
guidance will not be used.`,name:"pag_scale"},{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.__call__.pag_adaptive_scale",description:`<strong>pag_adaptive_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The adaptive scale factor for the perturbed attention guidance. If it is set to 0.0, <code>pag_scale</code> is
used.`,name:"pag_adaptive_scale"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_controlnet_sd_inpaint.py#L965",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/pr_7613/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_7613/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),Je=new te({props:{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.__call__.example",$$slots:{default:[$d]},$$scope:{ctx:T}}}),zt=new I({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_controlnet_sd_inpaint.py#L244"}}),Zt=new I({props:{name:"get_guidance_scale_embedding",anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.get_guidance_scale_embedding",parameters:[{name:"w",val:": Tensor"},{name:"embedding_dim",val:": int = 512"},{name:"dtype",val:": dtype = torch.float32"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.get_guidance_scale_embedding.w",description:`<strong>w</strong> (<code>torch.Tensor</code>) &#x2014;
Generate embedding vectors with a specified guidance scale to subsequently enrich timestep embeddings.`,name:"w"},{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.get_guidance_scale_embedding.embedding_dim",description:`<strong>embedding_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Dimension of the embeddings to generate.`,name:"embedding_dim"},{anchor:"diffusers.StableDiffusionControlNetPAGInpaintPipeline.get_guidance_scale_embedding.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.float32</code>) &#x2014;
Data type of the generated embeddings.`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_controlnet_sd_inpaint.py#L912",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Embedding vectors with shape <code>(len(w), embedding_dim)</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),Wt=new H({props:{title:"StableDiffusionXLPAGPipeline",local:"diffusers.StableDiffusionXLPAGPipeline",headingTag:"h2"}}),Bt=new I({props:{name:"class diffusers.StableDiffusionXLPAGPipeline",anchor:"diffusers.StableDiffusionXLPAGPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"text_encoder_2",val:": CLIPTextModelWithProjection"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"tokenizer_2",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"},{name:"feature_extractor",val:": CLIPImageProcessor = None"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": Optional = None"},{name:"pag_applied_layers",val:": Union = 'mid'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLPAGPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/pr_7613/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder. Stable Diffusion XL uses the text portion of
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIP</a>, specifically
the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<code> CLIPTextModelWithProjection</code>) &#x2014;
Second frozen text-encoder. Stable Diffusion XL uses the text and pool portion of
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModelWithProjection" rel="nofollow">CLIP</a>,
specifically the
<a href="https://huggingface.co/laion/CLIP-ViT-bigG-14-laion2B-39B-b160k" rel="nofollow">laion/CLIP-ViT-bigG-14-laion2B-39B-b160k</a>
variant.`,name:"text_encoder_2"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<code>CLIPTokenizer</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer_2"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.unet",description:'<strong>unet</strong> (<a href="/docs/diffusers/pr_7613/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014; Conditional U-Net architecture to denoise the encoded image latents.',name:"unet"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/pr_7613/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/pr_7613/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/pr_7613/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/pr_7613/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.force_zeros_for_empty_prompt",description:`<strong>force_zeros_for_empty_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>&quot;True&quot;</code>) &#x2014;
Whether the negative prompt embeddings shall be forced to always be set to 0. Also see the config of
<code>stabilityai/stable-diffusion-xl-base-1-0</code>.`,name:"force_zeros_for_empty_prompt"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.add_watermarker",description:`<strong>add_watermarker</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to use the <a href="https://github.com/ShieldMnt/invisible-watermark/" rel="nofollow">invisible_watermark library</a> to
watermark output images. If not defined, it will default to True if the package is installed, otherwise no
watermarker will be used.`,name:"add_watermarker"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_sd_xl.py#L164"}}),Rt=new I({props:{name:"__call__",anchor:"diffusers.StableDiffusionXLPAGPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"prompt_2",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": List = None"},{name:"sigmas",val:": List = None"},{name:"denoising_end",val:": Optional = None"},{name:"guidance_scale",val:": float = 5.0"},{name:"negative_prompt",val:": Union = None"},{name:"negative_prompt_2",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"pooled_prompt_embeds",val:": Optional = None"},{name:"negative_pooled_prompt_embeds",val:": Optional = None"},{name:"ip_adapter_image",val:": Union = None"},{name:"ip_adapter_image_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"guidance_rescale",val:": float = 0.0"},{name:"original_size",val:": Optional = None"},{name:"crops_coords_top_left",val:": Tuple = (0, 0)"},{name:"target_size",val:": Optional = None"},{name:"negative_original_size",val:": Optional = None"},{name:"negative_crops_coords_top_left",val:": Tuple = (0, 0)"},{name:"negative_target_size",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"pag_scale",val:": float = 3.0"},{name:"pag_adaptive_scale",val:": float = 0.0"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLPAGPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders`,name:"prompt_2"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.
Anything below 512 pixels won&#x2019;t work well for
<a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a>
and checkpoints that are not specifically fine-tuned on low resolutions.`,name:"height"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.
Anything below 512 pixels won&#x2019;t work well for
<a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a>
and checkpoints that are not specifically fine-tuned on low resolutions.`,name:"width"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.__call__.denoising_end",description:`<strong>denoising_end</strong> (<code>float</code>, <em>optional</em>) &#x2014;
When specified, determines the fraction (between 0.0 and 1.0) of the total denoising process to be
completed before it is intentionally prematurely terminated. As a result, the returned sample will
still retain a substantial amount of noise as determined by the discrete timesteps selected by the
scheduler. The denoising_end parameter should ideally be utilized when this pipeline forms a part of a
&#x201C;Mixture of Denoisers&#x201D; multi-pipeline setup, as elaborated in <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_xl#refining-the-image-output" rel="nofollow"><strong>Refining the Image
Output</strong></a>`,name:"denoising_end"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 5.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">https://arxiv.org/abs/2010.02502</a>. Only applies to
<a href="/docs/diffusers/pr_7613/en/api/schedulers/ddim#diffusers.DDIMScheduler">schedulers.DDIMScheduler</a>, will be ignored for others.`,name:"eta"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.
ip_adapter_image &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should
contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to <code>True</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Guidance rescale factor proposed by <a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a> <code>guidance_scale</code> is defined as <code>&#x3C6;</code> in equation 16. of
<a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are Flawed</a>.
Guidance rescale factor should fix overexposure when using zero terminal SNR.`,name:"guidance_rescale"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.__call__.original_size",description:`<strong>original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
If <code>original_size</code> is not the same as <code>target_size</code> the image will appear to be down- or upsampled.
<code>original_size</code> defaults to <code>(height, width)</code> if not specified. Part of SDXL&#x2019;s micro-conditioning as
explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"original_size"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.__call__.crops_coords_top_left",description:`<strong>crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
<code>crops_coords_top_left</code> can be used to generate an image that appears to be &#x201C;cropped&#x201D; from the position
<code>crops_coords_top_left</code> downwards. Favorable, well-centered images are usually achieved by setting
<code>crops_coords_top_left</code> to (0, 0). Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"crops_coords_top_left"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.__call__.target_size",description:`<strong>target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
For most cases, <code>target_size</code> should be set to the desired height and width of the generated image. If
not specified it will default to <code>(height, width)</code>. Part of SDXL&#x2019;s micro-conditioning as explained in
section 2.2 of <a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"target_size"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.__call__.negative_original_size",description:`<strong>negative_original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
To negatively condition the generation process based on a specific image resolution. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_original_size"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.__call__.negative_crops_coords_top_left",description:`<strong>negative_crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
To negatively condition the generation process based on a specific crop coordinates. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_crops_coords_top_left"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.__call__.negative_target_size",description:`<strong>negative_target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
To negatively condition the generation process based on a target image resolution. It should be as same
as the <code>target_size</code> for most cases. Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_target_size"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.__call__.pag_scale",description:`<strong>pag_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 3.0) &#x2014;
The scale factor for the perturbed attention guidance. If it is set to 0.0, the perturbed attention
guidance will not be used.`,name:"pag_scale"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.__call__.pag_adaptive_scale",description:`<strong>pag_adaptive_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The adaptive scale factor for the perturbed attention guidance. If it is set to 0.0, <code>pag_scale</code> is
used.`,name:"pag_adaptive_scale"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_sd_xl.py#L828",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> if <code>return_dict</code> is True, otherwise a
<code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> or <code>tuple</code></p>
`}}),ze=new te({props:{anchor:"diffusers.StableDiffusionXLPAGPipeline.__call__.example",$$slots:{default:[Xd]},$$scope:{ctx:T}}}),Ft=new I({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionXLPAGPipeline.encode_prompt",parameters:[{name:"prompt",val:": str"},{name:"prompt_2",val:": Optional = None"},{name:"device",val:": Optional = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"negative_prompt",val:": Optional = None"},{name:"negative_prompt_2",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"pooled_prompt_embeds",val:": Optional = None"},{name:"negative_pooled_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLPAGPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt_2"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.encode_prompt.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.encode_prompt.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_sd_xl.py#L281"}}),Et=new I({props:{name:"get_guidance_scale_embedding",anchor:"diffusers.StableDiffusionXLPAGPipeline.get_guidance_scale_embedding",parameters:[{name:"w",val:": Tensor"},{name:"embedding_dim",val:": int = 512"},{name:"dtype",val:": dtype = torch.float32"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLPAGPipeline.get_guidance_scale_embedding.w",description:`<strong>w</strong> (<code>torch.Tensor</code>) &#x2014;
Generate embedding vectors with a specified guidance scale to subsequently enrich timestep embeddings.`,name:"w"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.get_guidance_scale_embedding.embedding_dim",description:`<strong>embedding_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Dimension of the embeddings to generate.`,name:"embedding_dim"},{anchor:"diffusers.StableDiffusionXLPAGPipeline.get_guidance_scale_embedding.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.float32</code>) &#x2014;
Data type of the generated embeddings.`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_sd_xl.py#L763",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Embedding vectors with shape <code>(len(w), embedding_dim)</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),Vt=new H({props:{title:"StableDiffusionXLPAGImg2ImgPipeline",local:"diffusers.StableDiffusionXLPAGImg2ImgPipeline",headingTag:"h2"}}),Ot=new I({props:{name:"class diffusers.StableDiffusionXLPAGImg2ImgPipeline",anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"text_encoder_2",val:": CLIPTextModelWithProjection"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"tokenizer_2",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"},{name:"feature_extractor",val:": CLIPImageProcessor = None"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": Optional = None"},{name:"pag_applied_layers",val:": Union = 'mid'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/pr_7613/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder. Stable Diffusion XL uses the text portion of
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIP</a>, specifically
the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<code> CLIPTextModelWithProjection</code>) &#x2014;
Second frozen text-encoder. Stable Diffusion XL uses the text and pool portion of
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModelWithProjection" rel="nofollow">CLIP</a>,
specifically the
<a href="https://huggingface.co/laion/CLIP-ViT-bigG-14-laion2B-39B-b160k" rel="nofollow">laion/CLIP-ViT-bigG-14-laion2B-39B-b160k</a>
variant.`,name:"text_encoder_2"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<code>CLIPTokenizer</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer_2"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.unet",description:'<strong>unet</strong> (<a href="/docs/diffusers/pr_7613/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014; Conditional U-Net architecture to denoise the encoded image latents.',name:"unet"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/pr_7613/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/pr_7613/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/pr_7613/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/pr_7613/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.requires_aesthetics_score",description:`<strong>requires_aesthetics_score</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>&quot;False&quot;</code>) &#x2014;
Whether the <code>unet</code> requires an <code>aesthetic_score</code> condition to be passed during inference. Also see the
config of <code>stabilityai/stable-diffusion-xl-refiner-1-0</code>.`,name:"requires_aesthetics_score"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.force_zeros_for_empty_prompt",description:`<strong>force_zeros_for_empty_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>&quot;True&quot;</code>) &#x2014;
Whether the negative prompt embeddings shall be forced to always be set to 0. Also see the config of
<code>stabilityai/stable-diffusion-xl-base-1-0</code>.`,name:"force_zeros_for_empty_prompt"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.add_watermarker",description:`<strong>add_watermarker</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to use the <a href="https://github.com/ShieldMnt/invisible-watermark/" rel="nofollow">invisible_watermark library</a> to
watermark output images. If not defined, it will default to True if the package is installed, otherwise no
watermarker will be used.`,name:"add_watermarker"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_sd_xl_img2img.py#L182"}}),Ht=new I({props:{name:"__call__",anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"prompt_2",val:": Union = None"},{name:"image",val:": Union = None"},{name:"strength",val:": float = 0.3"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": List = None"},{name:"sigmas",val:": List = None"},{name:"denoising_start",val:": Optional = None"},{name:"denoising_end",val:": Optional = None"},{name:"guidance_scale",val:": float = 5.0"},{name:"negative_prompt",val:": Union = None"},{name:"negative_prompt_2",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"pooled_prompt_embeds",val:": Optional = None"},{name:"negative_pooled_prompt_embeds",val:": Optional = None"},{name:"ip_adapter_image",val:": Union = None"},{name:"ip_adapter_image_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"guidance_rescale",val:": float = 0.0"},{name:"original_size",val:": Tuple = None"},{name:"crops_coords_top_left",val:": Tuple = (0, 0)"},{name:"target_size",val:": Tuple = None"},{name:"negative_original_size",val:": Optional = None"},{name:"negative_crops_coords_top_left",val:": Tuple = (0, 0)"},{name:"negative_target_size",val:": Optional = None"},{name:"aesthetic_score",val:": float = 6.0"},{name:"negative_aesthetic_score",val:": float = 2.5"},{name:"clip_skip",val:": Optional = None"},{name:"callback_on_step_end",val:": Union = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"pag_scale",val:": float = 3.0"},{name:"pag_adaptive_scale",val:": float = 0.0"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders`,name:"prompt_2"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code> or <code>PIL.Image.Image</code> or <code>np.ndarray</code> or <code>List[torch.Tensor]</code> or <code>List[PIL.Image.Image]</code> or <code>List[np.ndarray]</code>) &#x2014;
The image(s) to modify with the pipeline.`,name:"image"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.3) &#x2014;
Conceptually, indicates how much to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code>
will be used as a starting point, adding more noise to it the larger the <code>strength</code>. The number of
denoising steps depends on the amount of noise initially added. When <code>strength</code> is 1, added noise will
be maximum and the denoising process will run for the full number of iterations specified in
<code>num_inference_steps</code>. A value of 1, therefore, essentially ignores <code>image</code>. Note that in the case of
<code>denoising_start</code> being declared as an integer, the value of <code>strength</code> will be ignored.`,name:"strength"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.__call__.denoising_start",description:`<strong>denoising_start</strong> (<code>float</code>, <em>optional</em>) &#x2014;
When specified, indicates the fraction (between 0.0 and 1.0) of the total denoising process to be
bypassed before it is initiated. Consequently, the initial part of the denoising process is skipped and
it is assumed that the passed <code>image</code> is a partly denoised image. Note that when this is specified,
strength will be ignored. The <code>denoising_start</code> parameter is particularly beneficial when this pipeline
is integrated into a &#x201C;Mixture of Denoisers&#x201D; multi-pipeline setup, as detailed in <a href="https://huggingface.co/docs/diffusers/using-diffusers/sdxl#refine-image-quality" rel="nofollow"><strong>Refine Image
Quality</strong></a>.`,name:"denoising_start"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.__call__.denoising_end",description:`<strong>denoising_end</strong> (<code>float</code>, <em>optional</em>) &#x2014;
When specified, determines the fraction (between 0.0 and 1.0) of the total denoising process to be
completed before it is intentionally prematurely terminated. As a result, the returned sample will
still retain a substantial amount of noise (ca. final 20% of timesteps still needed) and should be
denoised by a successor pipeline that has <code>denoising_start</code> set to 0.8 so that it only denoises the
final 20% of the scheduler. The denoising_end parameter should ideally be utilized when this pipeline
forms a part of a &#x201C;Mixture of Denoisers&#x201D; multi-pipeline setup, as elaborated in <a href="https://huggingface.co/docs/diffusers/using-diffusers/sdxl#refine-image-quality" rel="nofollow"><strong>Refine Image
Quality</strong></a>.`,name:"denoising_end"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">https://arxiv.org/abs/2010.02502</a>. Only applies to
<a href="/docs/diffusers/pr_7613/en/api/schedulers/ddim#diffusers.DDIMScheduler">schedulers.DDIMScheduler</a>, will be ignored for others.`,name:"eta"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.
ip_adapter_image &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should
contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to <code>True</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Guidance rescale factor proposed by <a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a> <code>guidance_scale</code> is defined as <code>&#x3C6;</code> in equation 16. of
<a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are Flawed</a>.
Guidance rescale factor should fix overexposure when using zero terminal SNR.`,name:"guidance_rescale"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.__call__.original_size",description:`<strong>original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
If <code>original_size</code> is not the same as <code>target_size</code> the image will appear to be down- or upsampled.
<code>original_size</code> defaults to <code>(height, width)</code> if not specified. Part of SDXL&#x2019;s micro-conditioning as
explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"original_size"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.__call__.crops_coords_top_left",description:`<strong>crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
<code>crops_coords_top_left</code> can be used to generate an image that appears to be &#x201C;cropped&#x201D; from the position
<code>crops_coords_top_left</code> downwards. Favorable, well-centered images are usually achieved by setting
<code>crops_coords_top_left</code> to (0, 0). Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"crops_coords_top_left"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.__call__.target_size",description:`<strong>target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
For most cases, <code>target_size</code> should be set to the desired height and width of the generated image. If
not specified it will default to <code>(height, width)</code>. Part of SDXL&#x2019;s micro-conditioning as explained in
section 2.2 of <a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"target_size"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.__call__.negative_original_size",description:`<strong>negative_original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
To negatively condition the generation process based on a specific image resolution. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_original_size"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.__call__.negative_crops_coords_top_left",description:`<strong>negative_crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
To negatively condition the generation process based on a specific crop coordinates. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_crops_coords_top_left"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.__call__.negative_target_size",description:`<strong>negative_target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
To negatively condition the generation process based on a target image resolution. It should be as same
as the <code>target_size</code> for most cases. Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_target_size"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.__call__.aesthetic_score",description:`<strong>aesthetic_score</strong> (<code>float</code>, <em>optional</em>, defaults to 6.0) &#x2014;
Used to simulate an aesthetic score of the generated image by influencing the positive text condition.
Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"aesthetic_score"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.__call__.negative_aesthetic_score",description:`<strong>negative_aesthetic_score</strong> (<code>float</code>, <em>optional</em>, defaults to 2.5) &#x2014;
Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. Can be used to
simulate an aesthetic score of the generated image by influencing the negative text condition.`,name:"negative_aesthetic_score"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.__call__.pag_scale",description:`<strong>pag_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 3.0) &#x2014;
The scale factor for the perturbed attention guidance. If it is set to 0.0, the perturbed attention
guidance will not be used.`,name:"pag_scale"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.__call__.pag_adaptive_scale",description:`<strong>pag_adaptive_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The adaptive scale factor for the perturbed attention guidance. If it is set to 0.0, <code>pag_scale</code> is
used.`,name:"pag_adaptive_scale"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_sd_xl_img2img.py#L983",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> if <code>return_dict</code> is True, otherwise a
\`tuple. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> or <code>tuple</code></p>
`}}),Be=new te({props:{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.__call__.example",$$slots:{default:[zd]},$$scope:{ctx:T}}}),qt=new I({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.encode_prompt",parameters:[{name:"prompt",val:": str"},{name:"prompt_2",val:": Optional = None"},{name:"device",val:": Optional = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"negative_prompt",val:": Optional = None"},{name:"negative_prompt_2",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"pooled_prompt_embeds",val:": Optional = None"},{name:"negative_pooled_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt_2"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.encode_prompt.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.encode_prompt.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_sd_xl_img2img.py#L302"}}),Yt=new I({props:{name:"get_guidance_scale_embedding",anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.get_guidance_scale_embedding",parameters:[{name:"w",val:": Tensor"},{name:"embedding_dim",val:": int = 512"},{name:"dtype",val:": dtype = torch.float32"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.get_guidance_scale_embedding.w",description:`<strong>w</strong> (<code>torch.Tensor</code>) &#x2014;
Generate embedding vectors with a specified guidance scale to subsequently enrich timestep embeddings.`,name:"w"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.get_guidance_scale_embedding.embedding_dim",description:`<strong>embedding_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Dimension of the embeddings to generate.`,name:"embedding_dim"},{anchor:"diffusers.StableDiffusionXLPAGImg2ImgPipeline.get_guidance_scale_embedding.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.float32</code>) &#x2014;
Data type of the generated embeddings.`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_sd_xl_img2img.py#L914",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Embedding vectors with shape <code>(len(w), embedding_dim)</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),Qt=new H({props:{title:"StableDiffusionXLPAGInpaintPipeline",local:"diffusers.StableDiffusionXLPAGInpaintPipeline",headingTag:"h2"}}),Kt=new I({props:{name:"class diffusers.StableDiffusionXLPAGInpaintPipeline",anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"text_encoder_2",val:": CLIPTextModelWithProjection"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"tokenizer_2",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"},{name:"feature_extractor",val:": CLIPImageProcessor = None"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": Optional = None"},{name:"pag_applied_layers",val:": Union = 'mid'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/pr_7613/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder. Stable Diffusion XL uses the text portion of
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIP</a>, specifically
the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<code> CLIPTextModelWithProjection</code>) &#x2014;
Second frozen text-encoder. Stable Diffusion XL uses the text and pool portion of
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModelWithProjection" rel="nofollow">CLIP</a>,
specifically the
<a href="https://huggingface.co/laion/CLIP-ViT-bigG-14-laion2B-39B-b160k" rel="nofollow">laion/CLIP-ViT-bigG-14-laion2B-39B-b160k</a>
variant.`,name:"text_encoder_2"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<code>CLIPTokenizer</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer_2"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.unet",description:'<strong>unet</strong> (<a href="/docs/diffusers/pr_7613/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014; Conditional U-Net architecture to denoise the encoded image latents.',name:"unet"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/pr_7613/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/pr_7613/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/pr_7613/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/pr_7613/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.requires_aesthetics_score",description:`<strong>requires_aesthetics_score</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>&quot;False&quot;</code>) &#x2014;
Whether the <code>unet</code> requires a aesthetic_score condition to be passed during inference. Also see the config
of <code>stabilityai/stable-diffusion-xl-refiner-1-0</code>.`,name:"requires_aesthetics_score"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.force_zeros_for_empty_prompt",description:`<strong>force_zeros_for_empty_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>&quot;True&quot;</code>) &#x2014;
Whether the negative prompt embeddings shall be forced to always be set to 0. Also see the config of
<code>stabilityai/stable-diffusion-xl-base-1-0</code>.`,name:"force_zeros_for_empty_prompt"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.add_watermarker",description:`<strong>add_watermarker</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to use the <a href="https://github.com/ShieldMnt/invisible-watermark/" rel="nofollow">invisible_watermark library</a> to
watermark output images. If not defined, it will default to True if the package is installed, otherwise no
watermarker will be used.`,name:"add_watermarker"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_sd_xl_inpaint.py#L195"}}),en=new I({props:{name:"__call__",anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"prompt_2",val:": Union = None"},{name:"image",val:": Union = None"},{name:"mask_image",val:": Union = None"},{name:"masked_image_latents",val:": Tensor = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"padding_mask_crop",val:": Optional = None"},{name:"strength",val:": float = 0.9999"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": List = None"},{name:"sigmas",val:": List = None"},{name:"denoising_start",val:": Optional = None"},{name:"denoising_end",val:": Optional = None"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": Union = None"},{name:"negative_prompt_2",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"pooled_prompt_embeds",val:": Optional = None"},{name:"negative_pooled_prompt_embeds",val:": Optional = None"},{name:"ip_adapter_image",val:": Union = None"},{name:"ip_adapter_image_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"guidance_rescale",val:": float = 0.0"},{name:"original_size",val:": Tuple = None"},{name:"crops_coords_top_left",val:": Tuple = (0, 0)"},{name:"target_size",val:": Tuple = None"},{name:"negative_original_size",val:": Optional = None"},{name:"negative_crops_coords_top_left",val:": Tuple = (0, 0)"},{name:"negative_target_size",val:": Optional = None"},{name:"aesthetic_score",val:": float = 6.0"},{name:"negative_aesthetic_score",val:": float = 2.5"},{name:"clip_skip",val:": Optional = None"},{name:"callback_on_step_end",val:": Union = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"pag_scale",val:": float = 3.0"},{name:"pag_adaptive_scale",val:": float = 0.0"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders`,name:"prompt_2"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.__call__.image",description:`<strong>image</strong> (<code>PIL.Image.Image</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch which will be inpainted, <em>i.e.</em> parts of the image will
be masked out with <code>mask_image</code> and repainted according to <code>prompt</code>.`,name:"image"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>PIL.Image.Image</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch, to mask <code>image</code>. White pixels in the mask will be
repainted, while black pixels will be preserved. If <code>mask_image</code> is a PIL image, it will be converted
to a single channel (luminance) before use. If it&#x2019;s a tensor, it should contain one color channel (L)
instead of 3, so the expected shape would be <code>(B, H, W, 1)</code>.`,name:"mask_image"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.
Anything below 512 pixels won&#x2019;t work well for
<a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a>
and checkpoints that are not specifically fine-tuned on low resolutions.`,name:"height"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.
Anything below 512 pixels won&#x2019;t work well for
<a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a>
and checkpoints that are not specifically fine-tuned on low resolutions.`,name:"width"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.__call__.padding_mask_crop",description:`<strong>padding_mask_crop</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The size of margin in the crop to be applied to the image and masking. If <code>None</code>, no crop is applied to
image and mask_image. If <code>padding_mask_crop</code> is not <code>None</code>, it will first find a rectangular region
with the same aspect ration of the image and contains all masked area, and then expand that area based
on <code>padding_mask_crop</code>. The image and mask_image will then be cropped based on the expanded area before
resizing to the original image size for inpainting. This is useful when the masked area is small while
the image is large and contain information irrelevant for inpainting, such as background.`,name:"padding_mask_crop"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.9999) &#x2014;
Conceptually, indicates how much to transform the masked portion of the reference <code>image</code>. Must be
between 0 and 1. <code>image</code> will be used as a starting point, adding more noise to it the larger the
<code>strength</code>. The number of denoising steps depends on the amount of noise initially added. When
<code>strength</code> is 1, added noise will be maximum and the denoising process will run for the full number of
iterations specified in <code>num_inference_steps</code>. A value of 1, therefore, essentially ignores the masked
portion of the reference <code>image</code>. Note that in the case of <code>denoising_start</code> being declared as an
integer, the value of <code>strength</code> will be ignored.`,name:"strength"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.__call__.denoising_start",description:`<strong>denoising_start</strong> (<code>float</code>, <em>optional</em>) &#x2014;
When specified, indicates the fraction (between 0.0 and 1.0) of the total denoising process to be
bypassed before it is initiated. Consequently, the initial part of the denoising process is skipped and
it is assumed that the passed <code>image</code> is a partly denoised image. Note that when this is specified,
strength will be ignored. The <code>denoising_start</code> parameter is particularly beneficial when this pipeline
is integrated into a &#x201C;Mixture of Denoisers&#x201D; multi-pipeline setup, as detailed in <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_xl#refining-the-image-output" rel="nofollow"><strong>Refining the Image
Output</strong></a>.`,name:"denoising_start"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.__call__.denoising_end",description:`<strong>denoising_end</strong> (<code>float</code>, <em>optional</em>) &#x2014;
When specified, determines the fraction (between 0.0 and 1.0) of the total denoising process to be
completed before it is intentionally prematurely terminated. As a result, the returned sample will
still retain a substantial amount of noise (ca. final 20% of timesteps still needed) and should be
denoised by a successor pipeline that has <code>denoising_start</code> set to 0.8 so that it only denoises the
final 20% of the scheduler. The denoising_end parameter should ideally be utilized when this pipeline
forms a part of a &#x201C;Mixture of Denoisers&#x201D; multi-pipeline setup, as elaborated in <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_xl#refining-the-image-output" rel="nofollow"><strong>Refining the Image
Output</strong></a>.`,name:"denoising_end"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.
ip_adapter_image &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should
contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to <code>True</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">https://arxiv.org/abs/2010.02502</a>. Only applies to
<a href="/docs/diffusers/pr_7613/en/api/schedulers/ddim#diffusers.DDIMScheduler">schedulers.DDIMScheduler</a>, will be ignored for others.`,name:"eta"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/pr_7613/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.__call__.original_size",description:`<strong>original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
If <code>original_size</code> is not the same as <code>target_size</code> the image will appear to be down- or upsampled.
<code>original_size</code> defaults to <code>(height, width)</code> if not specified. Part of SDXL&#x2019;s micro-conditioning as
explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"original_size"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.__call__.crops_coords_top_left",description:`<strong>crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
<code>crops_coords_top_left</code> can be used to generate an image that appears to be &#x201C;cropped&#x201D; from the position
<code>crops_coords_top_left</code> downwards. Favorable, well-centered images are usually achieved by setting
<code>crops_coords_top_left</code> to (0, 0). Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"crops_coords_top_left"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.__call__.target_size",description:`<strong>target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
For most cases, <code>target_size</code> should be set to the desired height and width of the generated image. If
not specified it will default to <code>(height, width)</code>. Part of SDXL&#x2019;s micro-conditioning as explained in
section 2.2 of <a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"target_size"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.__call__.negative_original_size",description:`<strong>negative_original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
To negatively condition the generation process based on a specific image resolution. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_original_size"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.__call__.negative_crops_coords_top_left",description:`<strong>negative_crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
To negatively condition the generation process based on a specific crop coordinates. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_crops_coords_top_left"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.__call__.negative_target_size",description:`<strong>negative_target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
To negatively condition the generation process based on a target image resolution. It should be as same
as the <code>target_size</code> for most cases. Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_target_size"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.__call__.aesthetic_score",description:`<strong>aesthetic_score</strong> (<code>float</code>, <em>optional</em>, defaults to 6.0) &#x2014;
Used to simulate an aesthetic score of the generated image by influencing the positive text condition.
Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"aesthetic_score"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.__call__.negative_aesthetic_score",description:`<strong>negative_aesthetic_score</strong> (<code>float</code>, <em>optional</em>, defaults to 2.5) &#x2014;
Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. Can be used to
simulate an aesthetic score of the generated image by influencing the negative text condition.`,name:"negative_aesthetic_score"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.__call__.pag_scale",description:`<strong>pag_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 3.0) &#x2014;
The scale factor for the perturbed attention guidance. If it is set to 0.0, the perturbed attention
guidance will not be used.`,name:"pag_scale"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.__call__.pag_adaptive_scale",description:`<strong>pag_adaptive_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The adaptive scale factor for the perturbed attention guidance. If it is set to 0.0, <code>pag_scale</code> is
used.`,name:"pag_adaptive_scale"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_sd_xl_inpaint.py#L1074",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> if <code>return_dict</code> is True, otherwise a
<code>tuple. </code>tuple. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> or <code>tuple</code></p>
`}}),Ee=new te({props:{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.__call__.example",$$slots:{default:[Zd]},$$scope:{ctx:T}}}),tn=new I({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.encode_prompt",parameters:[{name:"prompt",val:": str"},{name:"prompt_2",val:": Optional = None"},{name:"device",val:": Optional = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"negative_prompt",val:": Optional = None"},{name:"negative_prompt_2",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"pooled_prompt_embeds",val:": Optional = None"},{name:"negative_pooled_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt_2"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.encode_prompt.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.encode_prompt.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_sd_xl_inpaint.py#L392"}}),nn=new I({props:{name:"get_guidance_scale_embedding",anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.get_guidance_scale_embedding",parameters:[{name:"w",val:": Tensor"},{name:"embedding_dim",val:": int = 512"},{name:"dtype",val:": dtype = torch.float32"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.get_guidance_scale_embedding.w",description:`<strong>w</strong> (<code>torch.Tensor</code>) &#x2014;
Generate embedding vectors with a specified guidance scale to subsequently enrich timestep embeddings.`,name:"w"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.get_guidance_scale_embedding.embedding_dim",description:`<strong>embedding_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Dimension of the embeddings to generate.`,name:"embedding_dim"},{anchor:"diffusers.StableDiffusionXLPAGInpaintPipeline.get_guidance_scale_embedding.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.float32</code>) &#x2014;
Data type of the generated embeddings.`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_sd_xl_inpaint.py#L1005",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Embedding vectors with shape <code>(len(w), embedding_dim)</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),on=new H({props:{title:"StableDiffusionXLControlNetPAGPipeline",local:"diffusers.StableDiffusionXLControlNetPAGPipeline",headingTag:"h2"}}),an=new I({props:{name:"class diffusers.StableDiffusionXLControlNetPAGPipeline",anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"text_encoder_2",val:": CLIPTextModelWithProjection"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"tokenizer_2",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"controlnet",val:": Union"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": Optional = None"},{name:"feature_extractor",val:": CLIPImageProcessor = None"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"},{name:"pag_applied_layers",val:": Union = 'mid'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/pr_7613/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModelWithProjection" rel="nofollow">CLIPTextModelWithProjection</a>) &#x2014;
Second frozen text-encoder
(<a href="https://huggingface.co/laion/CLIP-ViT-bigG-14-laion2B-39B-b160k" rel="nofollow">laion/CLIP-ViT-bigG-14-laion2B-39B-b160k</a>).`,name:"text_encoder_2"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer_2"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/pr_7613/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.controlnet",description:`<strong>controlnet</strong> (<a href="/docs/diffusers/pr_7613/en/api/models/controlnet#diffusers.ControlNetModel">ControlNetModel</a> or <code>List[ControlNetModel]</code>) &#x2014;
Provides additional conditioning to the <code>unet</code> during the denoising process. If you set multiple
ControlNets as a list, the outputs from each ControlNet are added together to create one combined
additional conditioning.`,name:"controlnet"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/pr_7613/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/pr_7613/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/pr_7613/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/pr_7613/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.force_zeros_for_empty_prompt",description:`<strong>force_zeros_for_empty_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>&quot;True&quot;</code>) &#x2014;
Whether the negative prompt embeddings should always be set to 0. Also see the config of
<code>stabilityai/stable-diffusion-xl-base-1-0</code>.`,name:"force_zeros_for_empty_prompt"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.add_watermarker",description:`<strong>add_watermarker</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to use the <a href="https://github.com/ShieldMnt/invisible-watermark/" rel="nofollow">invisible_watermark</a> library to
watermark output images. If not defined, it defaults to <code>True</code> if the package is installed; otherwise no
watermarker is used.`,name:"add_watermarker"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_controlnet_sd_xl.py#L180"}}),sn=new I({props:{name:"__call__",anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"prompt_2",val:": Union = None"},{name:"image",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": List = None"},{name:"sigmas",val:": List = None"},{name:"denoising_end",val:": Optional = None"},{name:"guidance_scale",val:": float = 5.0"},{name:"negative_prompt",val:": Union = None"},{name:"negative_prompt_2",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"pooled_prompt_embeds",val:": Optional = None"},{name:"negative_pooled_prompt_embeds",val:": Optional = None"},{name:"ip_adapter_image",val:": Union = None"},{name:"ip_adapter_image_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"controlnet_conditioning_scale",val:": Union = 1.0"},{name:"control_guidance_start",val:": Union = 0.0"},{name:"control_guidance_end",val:": Union = 1.0"},{name:"original_size",val:": Tuple = None"},{name:"crops_coords_top_left",val:": Tuple = (0, 0)"},{name:"target_size",val:": Tuple = None"},{name:"negative_original_size",val:": Optional = None"},{name:"negative_crops_coords_top_left",val:": Tuple = (0, 0)"},{name:"negative_target_size",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"},{name:"callback_on_step_end",val:": Union = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"pag_scale",val:": float = 3.0"},{name:"pag_adaptive_scale",val:": float = 0.0"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders.`,name:"prompt_2"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>, &#x2014;
<code>List[List[torch.Tensor]]</code>, <code>List[List[np.ndarray]]</code> or <code>List[List[PIL.Image.Image]]</code>):
The ControlNet input condition to provide guidance to the <code>unet</code> for generation. If the type is
specified as <code>torch.Tensor</code>, it is passed to ControlNet as is. <code>PIL.Image.Image</code> can also be accepted
as an image. The dimensions of the output image defaults to <code>image</code>&#x2019;s dimensions. If height and/or
width are passed, <code>image</code> is resized accordingly. If multiple ControlNets are specified in <code>init</code>,
images must be passed as a list such that each element of the list can be correctly batched for input
to a single ControlNet.`,name:"image"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image. Anything below 512 pixels won&#x2019;t work well for
<a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a>
and checkpoints that are not specifically fine-tuned on low resolutions.`,name:"height"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image. Anything below 512 pixels won&#x2019;t work well for
<a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a>
and checkpoints that are not specifically fine-tuned on low resolutions.`,name:"width"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.__call__.denoising_end",description:`<strong>denoising_end</strong> (<code>float</code>, <em>optional</em>) &#x2014;
When specified, determines the fraction (between 0.0 and 1.0) of the total denoising process to be
completed before it is intentionally prematurely terminated. As a result, the returned sample will
still retain a substantial amount of noise as determined by the discrete timesteps selected by the
scheduler. The denoising_end parameter should ideally be utilized when this pipeline forms a part of a
&#x201C;Mixture of Denoisers&#x201D; multi-pipeline setup, as elaborated in <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_xl#refining-the-image-output" rel="nofollow"><strong>Refining the Image
Output</strong></a>`,name:"denoising_end"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 5.0) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. This is sent to <code>tokenizer_2</code>
and <code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders.`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/pr_7613/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, pooled text embeddings are generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs (prompt
weighting). If not provided, pooled <code>negative_prompt_embeds</code> are generated from <code>negative_prompt</code> input
argument.
ip_adapter_image &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should
contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to <code>True</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/pr_7613/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.__call__.controlnet_conditioning_scale",description:`<strong>controlnet_conditioning_scale</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The outputs of the ControlNet are multiplied by <code>controlnet_conditioning_scale</code> before they are added
to the residual in the original <code>unet</code>. If multiple ControlNets are specified in <code>init</code>, you can set
the corresponding scale as a list.`,name:"controlnet_conditioning_scale"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.__call__.control_guidance_start",description:`<strong>control_guidance_start</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The percentage of total steps at which the ControlNet starts applying.`,name:"control_guidance_start"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.__call__.control_guidance_end",description:`<strong>control_guidance_end</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The percentage of total steps at which the ControlNet stops applying.`,name:"control_guidance_end"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.__call__.original_size",description:`<strong>original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
If <code>original_size</code> is not the same as <code>target_size</code> the image will appear to be down- or upsampled.
<code>original_size</code> defaults to <code>(height, width)</code> if not specified. Part of SDXL&#x2019;s micro-conditioning as
explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"original_size"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.__call__.crops_coords_top_left",description:`<strong>crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
<code>crops_coords_top_left</code> can be used to generate an image that appears to be &#x201C;cropped&#x201D; from the position
<code>crops_coords_top_left</code> downwards. Favorable, well-centered images are usually achieved by setting
<code>crops_coords_top_left</code> to (0, 0). Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"crops_coords_top_left"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.__call__.target_size",description:`<strong>target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
For most cases, <code>target_size</code> should be set to the desired height and width of the generated image. If
not specified it will default to <code>(height, width)</code>. Part of SDXL&#x2019;s micro-conditioning as explained in
section 2.2 of <a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"target_size"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.__call__.negative_original_size",description:`<strong>negative_original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
To negatively condition the generation process based on a specific image resolution. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_original_size"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.__call__.negative_crops_coords_top_left",description:`<strong>negative_crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
To negatively condition the generation process based on a specific crop coordinates. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_crops_coords_top_left"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.__call__.negative_target_size",description:`<strong>negative_target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
To negatively condition the generation process based on a target image resolution. It should be as same
as the <code>target_size</code> for most cases. Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_target_size"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.__call__.pag_scale",description:`<strong>pag_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 3.0) &#x2014;
The scale factor for the perturbed attention guidance. If it is set to 0.0, the perturbed attention
guidance will not be used.`,name:"pag_scale"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.__call__.pag_adaptive_scale",description:`<strong>pag_adaptive_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The adaptive scale factor for the perturbed attention guidance. If it is set to 0.0, <code>pag_scale</code> is
used.`,name:"pag_adaptive_scale"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_controlnet_sd_xl.py#L1001",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/pr_7613/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned containing the output images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_7613/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),He=new te({props:{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.__call__.example",$$slots:{default:[Wd]},$$scope:{ctx:T}}}),rn=new I({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.encode_prompt",parameters:[{name:"prompt",val:": str"},{name:"prompt_2",val:": Optional = None"},{name:"device",val:": Optional = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"negative_prompt",val:": Optional = None"},{name:"negative_prompt_2",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"pooled_prompt_embeds",val:": Optional = None"},{name:"negative_pooled_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt_2"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.encode_prompt.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.encode_prompt.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_controlnet_sd_xl.py#L301"}}),ln=new I({props:{name:"get_guidance_scale_embedding",anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.get_guidance_scale_embedding",parameters:[{name:"w",val:": Tensor"},{name:"embedding_dim",val:": int = 512"},{name:"dtype",val:": dtype = torch.float32"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.get_guidance_scale_embedding.w",description:`<strong>w</strong> (<code>torch.Tensor</code>) &#x2014;
Generate embedding vectors with a specified guidance scale to subsequently enrich timestep embeddings.`,name:"w"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.get_guidance_scale_embedding.embedding_dim",description:`<strong>embedding_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Dimension of the embeddings to generate.`,name:"embedding_dim"},{anchor:"diffusers.StableDiffusionXLControlNetPAGPipeline.get_guidance_scale_embedding.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.float32</code>) &#x2014;
Data type of the generated embeddings.`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_controlnet_sd_xl.py#L944",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Embedding vectors with shape <code>(len(w), embedding_dim)</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),dn=new H({props:{title:"StableDiffusionXLControlNetPAGImg2ImgPipeline",local:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline",headingTag:"h2"}}),pn=new I({props:{name:"class diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline",anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"text_encoder_2",val:": CLIPTextModelWithProjection"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"tokenizer_2",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"controlnet",val:": Union"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": Optional = None"},{name:"feature_extractor",val:": CLIPImageProcessor = None"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"},{name:"pag_applied_layers",val:": Union = 'mid'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/pr_7613/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder. Stable Diffusion uses the text portion of
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIP</a>, specifically
the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<code> CLIPTextModelWithProjection</code>) &#x2014;
Second frozen text-encoder. Stable Diffusion XL uses the text and pool portion of
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModelWithProjection" rel="nofollow">CLIP</a>,
specifically the
<a href="https://huggingface.co/laion/CLIP-ViT-bigG-14-laion2B-39B-b160k" rel="nofollow">laion/CLIP-ViT-bigG-14-laion2B-39B-b160k</a>
variant.`,name:"text_encoder_2"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<code>CLIPTokenizer</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer_2"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.unet",description:'<strong>unet</strong> (<a href="/docs/diffusers/pr_7613/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014; Conditional U-Net architecture to denoise the encoded image latents.',name:"unet"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.controlnet",description:`<strong>controlnet</strong> (<a href="/docs/diffusers/pr_7613/en/api/models/controlnet#diffusers.ControlNetModel">ControlNetModel</a> or <code>List[ControlNetModel]</code>) &#x2014;
Provides additional conditioning to the unet during the denoising process. If you set multiple ControlNets
as a list, the outputs from each ControlNet are added together to create one combined additional
conditioning.`,name:"controlnet"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/pr_7613/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/pr_7613/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/pr_7613/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/pr_7613/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.requires_aesthetics_score",description:`<strong>requires_aesthetics_score</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>&quot;False&quot;</code>) &#x2014;
Whether the <code>unet</code> requires an <code>aesthetic_score</code> condition to be passed during inference. Also see the
config of <code>stabilityai/stable-diffusion-xl-refiner-1-0</code>.`,name:"requires_aesthetics_score"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.force_zeros_for_empty_prompt",description:`<strong>force_zeros_for_empty_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>&quot;True&quot;</code>) &#x2014;
Whether the negative prompt embeddings shall be forced to always be set to 0. Also see the config of
<code>stabilityai/stable-diffusion-xl-base-1-0</code>.`,name:"force_zeros_for_empty_prompt"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.add_watermarker",description:`<strong>add_watermarker</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to use the <a href="https://github.com/ShieldMnt/invisible-watermark/" rel="nofollow">invisible_watermark library</a> to
watermark output images. If not defined, it will default to True if the package is installed, otherwise no
watermarker will be used.`,name:"add_watermarker"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_controlnet_sd_xl_img2img.py#L160"}}),cn=new I({props:{name:"__call__",anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"prompt_2",val:": Union = None"},{name:"image",val:": Union = None"},{name:"control_image",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"strength",val:": float = 0.8"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 5.0"},{name:"negative_prompt",val:": Union = None"},{name:"negative_prompt_2",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"pooled_prompt_embeds",val:": Optional = None"},{name:"negative_pooled_prompt_embeds",val:": Optional = None"},{name:"ip_adapter_image",val:": Union = None"},{name:"ip_adapter_image_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"controlnet_conditioning_scale",val:": Union = 0.8"},{name:"guess_mode",val:": bool = False"},{name:"control_guidance_start",val:": Union = 0.0"},{name:"control_guidance_end",val:": Union = 1.0"},{name:"original_size",val:": Tuple = None"},{name:"crops_coords_top_left",val:": Tuple = (0, 0)"},{name:"target_size",val:": Tuple = None"},{name:"negative_original_size",val:": Optional = None"},{name:"negative_crops_coords_top_left",val:": Tuple = (0, 0)"},{name:"negative_target_size",val:": Optional = None"},{name:"aesthetic_score",val:": float = 6.0"},{name:"negative_aesthetic_score",val:": float = 2.5"},{name:"clip_skip",val:": Optional = None"},{name:"callback_on_step_end",val:": Union = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"pag_scale",val:": float = 3.0"},{name:"pag_adaptive_scale",val:": float = 0.0"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders`,name:"prompt_2"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>, &#x2014;
<code>List[List[torch.Tensor]]</code>, <code>List[List[np.ndarray]]</code> or <code>List[List[PIL.Image.Image]]</code>):
The initial image will be used as the starting point for the image generation process. Can also accept
image latents as <code>image</code>, if passing latents directly, it will not be encoded again.`,name:"image"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.__call__.control_image",description:`<strong>control_image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>, &#x2014;
<code>List[List[torch.Tensor]]</code>, <code>List[List[np.ndarray]]</code> or <code>List[List[PIL.Image.Image]]</code>):
The ControlNet input condition. ControlNet uses this input condition to generate guidance to Unet. If
the type is specified as <code>torch.Tensor</code>, it is passed to ControlNet as is. <code>PIL.Image.Image</code> can also
be accepted as an image. The dimensions of the output image defaults to <code>image</code>&#x2019;s dimensions. If height
and/or width are passed, <code>image</code> is resized according to them. If multiple ControlNets are specified in
init, images must be passed as a list such that each element of the list can be correctly batched for
input to a single controlnet.`,name:"control_image"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to the size of control_image) &#x2014;
The height in pixels of the generated image. Anything below 512 pixels won&#x2019;t work well for
<a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a>
and checkpoints that are not specifically fine-tuned on low resolutions.`,name:"height"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to the size of control_image) &#x2014;
The width in pixels of the generated image. Anything below 512 pixels won&#x2019;t work well for
<a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a>
and checkpoints that are not specifically fine-tuned on low resolutions.`,name:"width"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
Indicates extent to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code> is used as a
starting point and more noise is added the higher the <code>strength</code>. The number of denoising steps depends
on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the denoising
process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of 1
essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">https://arxiv.org/abs/2010.02502</a>. Only applies to
<a href="/docs/diffusers/pr_7613/en/api/schedulers/ddim#diffusers.DDIMScheduler">schedulers.DDIMScheduler</a>, will be ignored for others.`,name:"eta"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.
ip_adapter_image &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should
contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to <code>True</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/pr_7613/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.__call__.controlnet_conditioning_scale",description:`<strong>controlnet_conditioning_scale</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The outputs of the controlnet are multiplied by <code>controlnet_conditioning_scale</code> before they are added
to the residual in the original unet. If multiple ControlNets are specified in init, you can set the
corresponding scale as a list.`,name:"controlnet_conditioning_scale"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.__call__.guess_mode",description:`<strong>guess_mode</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
In this mode, the ControlNet encoder will try best to recognize the content of the input image even if
you remove all prompts. The <code>guidance_scale</code> between 3.0 and 5.0 is recommended.`,name:"guess_mode"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.__call__.control_guidance_start",description:`<strong>control_guidance_start</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The percentage of total steps at which the controlnet starts applying.`,name:"control_guidance_start"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.__call__.control_guidance_end",description:`<strong>control_guidance_end</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The percentage of total steps at which the controlnet stops applying.`,name:"control_guidance_end"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.__call__.original_size",description:`<strong>original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
If <code>original_size</code> is not the same as <code>target_size</code> the image will appear to be down- or upsampled.
<code>original_size</code> defaults to <code>(height, width)</code> if not specified. Part of SDXL&#x2019;s micro-conditioning as
explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"original_size"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.__call__.crops_coords_top_left",description:`<strong>crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
<code>crops_coords_top_left</code> can be used to generate an image that appears to be &#x201C;cropped&#x201D; from the position
<code>crops_coords_top_left</code> downwards. Favorable, well-centered images are usually achieved by setting
<code>crops_coords_top_left</code> to (0, 0). Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"crops_coords_top_left"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.__call__.target_size",description:`<strong>target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
For most cases, <code>target_size</code> should be set to the desired height and width of the generated image. If
not specified it will default to <code>(height, width)</code>. Part of SDXL&#x2019;s micro-conditioning as explained in
section 2.2 of <a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"target_size"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.__call__.negative_original_size",description:`<strong>negative_original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
To negatively condition the generation process based on a specific image resolution. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_original_size"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.__call__.negative_crops_coords_top_left",description:`<strong>negative_crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
To negatively condition the generation process based on a specific crop coordinates. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_crops_coords_top_left"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.__call__.negative_target_size",description:`<strong>negative_target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
To negatively condition the generation process based on a target image resolution. It should be as same
as the <code>target_size</code> for most cases. Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_target_size"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.__call__.aesthetic_score",description:`<strong>aesthetic_score</strong> (<code>float</code>, <em>optional</em>, defaults to 6.0) &#x2014;
Used to simulate an aesthetic score of the generated image by influencing the positive text condition.
Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"aesthetic_score"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.__call__.negative_aesthetic_score",description:`<strong>negative_aesthetic_score</strong> (<code>float</code>, <em>optional</em>, defaults to 2.5) &#x2014;
Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. Can be used to
simulate an aesthetic score of the generated image by influencing the negative text condition.`,name:"negative_aesthetic_score"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.__call__.pag_scale",description:`<strong>pag_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 3.0) &#x2014;
The scale factor for the perturbed attention guidance. If it is set to 0.0, the perturbed attention
guidance will not be used.`,name:"pag_scale"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.__call__.pag_adaptive_scale",description:`<strong>pag_adaptive_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The adaptive scale factor for the perturbed attention guidance. If it is set to 0.0, <code>pag_scale</code> is
used.`,name:"pag_adaptive_scale"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_controlnet_sd_xl_img2img.py#L1079",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> if <code>return_dict</code> is True, otherwise a
<code>tuple</code> containing the output images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> or <code>tuple</code></p>
`}}),Qe=new te({props:{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.__call__.example",$$slots:{default:[Bd]},$$scope:{ctx:T}}}),mn=new I({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.encode_prompt",parameters:[{name:"prompt",val:": str"},{name:"prompt_2",val:": Optional = None"},{name:"device",val:": Optional = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"negative_prompt",val:": Optional = None"},{name:"negative_prompt_2",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"pooled_prompt_embeds",val:": Optional = None"},{name:"negative_pooled_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt_2"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.encode_prompt.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.encode_prompt.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_controlnet_sd_xl_img2img.py#L293"}}),fn=new H({props:{title:"StableDiffusion3PAGPipeline",local:"diffusers.StableDiffusion3PAGPipeline",headingTag:"h2"}}),gn=new I({props:{name:"class diffusers.StableDiffusion3PAGPipeline",anchor:"diffusers.StableDiffusion3PAGPipeline",parameters:[{name:"transformer",val:": SD3Transformer2DModel"},{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModelWithProjection"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder_2",val:": CLIPTextModelWithProjection"},{name:"tokenizer_2",val:": CLIPTokenizer"},{name:"text_encoder_3",val:": T5EncoderModel"},{name:"tokenizer_3",val:": T5TokenizerFast"},{name:"pag_applied_layers",val:": Union = 'blocks.1'"}],parametersDescription:[{anchor:"diffusers.StableDiffusion3PAGPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/pr_7613/en/api/models/sd3_transformer2d#diffusers.SD3Transformer2DModel">SD3Transformer2DModel</a>) &#x2014;
Conditional Transformer (MMDiT) architecture to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.StableDiffusion3PAGPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/pr_7613/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.StableDiffusion3PAGPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/pr_7613/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusion3PAGPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModelWithProjection" rel="nofollow">CLIP</a>,
specifically the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant,
with an additional added projection layer that is initialized with a diagonal matrix with the <code>hidden_size</code>
as its dimension.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusion3PAGPipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModelWithProjection" rel="nofollow">CLIP</a>,
specifically the
<a href="https://huggingface.co/laion/CLIP-ViT-bigG-14-laion2B-39B-b160k" rel="nofollow">laion/CLIP-ViT-bigG-14-laion2B-39B-b160k</a>
variant.`,name:"text_encoder_2"},{anchor:"diffusers.StableDiffusion3PAGPipeline.text_encoder_3",description:`<strong>text_encoder_3</strong> (<code>T5EncoderModel</code>) &#x2014;
Frozen text-encoder. Stable Diffusion 3 uses
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically the
<a href="https://huggingface.co/google/t5-v1_1-xxl" rel="nofollow">t5-v1_1-xxl</a> variant.`,name:"text_encoder_3"},{anchor:"diffusers.StableDiffusion3PAGPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusion3PAGPipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<code>CLIPTokenizer</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer_2"},{anchor:"diffusers.StableDiffusion3PAGPipeline.tokenizer_3",description:`<strong>tokenizer_3</strong> (<code>T5TokenizerFast</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>.`,name:"tokenizer_3"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_sd_3.py#L136"}}),un=new I({props:{name:"__call__",anchor:"diffusers.StableDiffusion3PAGPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"prompt_2",val:": Union = None"},{name:"prompt_3",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": int = 28"},{name:"timesteps",val:": List = None"},{name:"guidance_scale",val:": float = 7.0"},{name:"negative_prompt",val:": Union = None"},{name:"negative_prompt_2",val:": Union = None"},{name:"negative_prompt_3",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"pooled_prompt_embeds",val:": Optional = None"},{name:"negative_pooled_prompt_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"joint_attention_kwargs",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"max_sequence_length",val:": int = 256"},{name:"pag_scale",val:": float = 3.0"},{name:"pag_adaptive_scale",val:": float = 0.0"}],parametersDescription:[{anchor:"diffusers.StableDiffusion3PAGPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.StableDiffusion3PAGPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
will be used instead`,name:"prompt_2"},{anchor:"diffusers.StableDiffusion3PAGPipeline.__call__.prompt_3",description:`<strong>prompt_3</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_3</code> and <code>text_encoder_3</code>. If not defined, <code>prompt</code> is
will be used instead`,name:"prompt_3"},{anchor:"diffusers.StableDiffusion3PAGPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"diffusers.StableDiffusion3PAGPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"diffusers.StableDiffusion3PAGPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusion3PAGPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.StableDiffusion3PAGPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusion3PAGPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusion3PAGPipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used instead`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusion3PAGPipeline.__call__.negative_prompt_3",description:`<strong>negative_prompt_3</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_3</code> and
<code>text_encoder_3</code>. If not defined, <code>negative_prompt</code> is used instead`,name:"negative_prompt_3"},{anchor:"diffusers.StableDiffusion3PAGPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusion3PAGPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusion3PAGPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusion3PAGPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusion3PAGPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusion3PAGPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusion3PAGPipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusion3PAGPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusion3PAGPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusion3PAGPipeline.__call__.joint_attention_kwargs",description:`<strong>joint_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"joint_attention_kwargs"},{anchor:"diffusers.StableDiffusion3PAGPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.StableDiffusion3PAGPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.StableDiffusion3PAGPipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 256) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"},{anchor:"diffusers.StableDiffusion3PAGPipeline.__call__.pag_scale",description:`<strong>pag_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 3.0) &#x2014;
The scale factor for the perturbed attention guidance. If it is set to 0.0, the perturbed attention
guidance will not be used.`,name:"pag_scale"},{anchor:"diffusers.StableDiffusion3PAGPipeline.__call__.pag_adaptive_scale",description:`<strong>pag_adaptive_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The adaptive scale factor for the perturbed attention guidance. If it is set to 0.0, <code>pag_scale</code> is
used.`,name:"pag_adaptive_scale"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_sd_3.py#L686",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion_3.StableDiffusion3PipelineOutput</code> if <code>return_dict</code> is True, otherwise a
<code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion_3.StableDiffusion3PipelineOutput</code> or <code>tuple</code></p>
`}}),et=new te({props:{anchor:"diffusers.StableDiffusion3PAGPipeline.__call__.example",$$slots:{default:[Rd]},$$scope:{ctx:T}}}),_n=new I({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusion3PAGPipeline.encode_prompt",parameters:[{name:"prompt",val:": Union"},{name:"prompt_2",val:": Union"},{name:"prompt_3",val:": Union"},{name:"device",val:": Optional = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"negative_prompt",val:": Union = None"},{name:"negative_prompt_2",val:": Union = None"},{name:"negative_prompt_3",val:": Union = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"pooled_prompt_embeds",val:": Optional = None"},{name:"negative_pooled_prompt_embeds",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"},{name:"max_sequence_length",val:": int = 256"},{name:"lora_scale",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusion3PAGPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.StableDiffusion3PAGPipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in all text-encoders`,name:"prompt_2"},{anchor:"diffusers.StableDiffusion3PAGPipeline.encode_prompt.prompt_3",description:`<strong>prompt_3</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_3</code> and <code>text_encoder_3</code>. If not defined, <code>prompt</code> is
used in all text-encoders
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt_3"},{anchor:"diffusers.StableDiffusion3PAGPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusion3PAGPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusion3PAGPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusion3PAGPipeline.encode_prompt.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in all the text-encoders.`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusion3PAGPipeline.encode_prompt.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_3</code> and
<code>text_encoder_3</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusion3PAGPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusion3PAGPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusion3PAGPipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusion3PAGPipeline.encode_prompt.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusion3PAGPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.StableDiffusion3PAGPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_sd_3.py#L337"}}),hn=new H({props:{title:"PixArtSigmaPAGPipeline",local:"diffusers.PixArtSigmaPAGPipeline",headingTag:"h2"}}),bn=new I({props:{name:"class diffusers.PixArtSigmaPAGPipeline",anchor:"diffusers.PixArtSigmaPAGPipeline",parameters:[{name:"tokenizer",val:": T5Tokenizer"},{name:"text_encoder",val:": T5EncoderModel"},{name:"vae",val:": AutoencoderKL"},{name:"transformer",val:": PixArtTransformer2DModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"pag_applied_layers",val:": Union = 'blocks.1'"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_pixart_sigma.py#L135"}}),vn=new I({props:{name:"__call__",anchor:"diffusers.PixArtSigmaPAGPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"negative_prompt",val:": str = ''"},{name:"num_inference_steps",val:": int = 20"},{name:"timesteps",val:": List = None"},{name:"sigmas",val:": List = None"},{name:"guidance_scale",val:": float = 4.5"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"prompt_attention_mask",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"negative_prompt_attention_mask",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"clean_caption",val:": bool = True"},{name:"use_resolution_binning",val:": bool = True"},{name:"max_sequence_length",val:": int = 300"},{name:"pag_scale",val:": float = 3.0"},{name:"pag_adaptive_scale",val:": float = 0.0"}],parametersDescription:[{anchor:"diffusers.PixArtSigmaPAGPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.PixArtSigmaPAGPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.PixArtSigmaPAGPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.PixArtSigmaPAGPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.PixArtSigmaPAGPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.PixArtSigmaPAGPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.5) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.PixArtSigmaPAGPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.PixArtSigmaPAGPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.PixArtSigmaPAGPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.PixArtSigmaPAGPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">https://arxiv.org/abs/2010.02502</a>. Only applies to
<a href="/docs/diffusers/pr_7613/en/api/schedulers/ddim#diffusers.DDIMScheduler">schedulers.DDIMScheduler</a>, will be ignored for others.`,name:"eta"},{anchor:"diffusers.PixArtSigmaPAGPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.PixArtSigmaPAGPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.PixArtSigmaPAGPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.PixArtSigmaPAGPipeline.__call__.prompt_attention_mask",description:"<strong>prompt_attention_mask</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014; Pre-generated attention mask for text embeddings.",name:"prompt_attention_mask"},{anchor:"diffusers.PixArtSigmaPAGPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. For PixArt-Sigma this negative prompt should be &quot;&quot;. If not
provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.PixArtSigmaPAGPipeline.__call__.negative_prompt_attention_mask",description:`<strong>negative_prompt_attention_mask</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated attention mask for negative text embeddings.`,name:"negative_prompt_attention_mask"},{anchor:"diffusers.PixArtSigmaPAGPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.PixArtSigmaPAGPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.IFPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.PixArtSigmaPAGPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that will be called every <code>callback_steps</code> steps during inference. The function will be
called with the following arguments: <code>callback(step: int, timestep: int, latents: torch.Tensor)</code>.`,name:"callback"},{anchor:"diffusers.PixArtSigmaPAGPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function will be called. If not specified, the callback will be
called at every step.`,name:"callback_steps"},{anchor:"diffusers.PixArtSigmaPAGPipeline.__call__.clean_caption",description:`<strong>clean_caption</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to clean the caption before creating embeddings. Requires <code>beautifulsoup4</code> and <code>ftfy</code> to
be installed. If the dependencies are not installed, the embeddings will be created from the raw
prompt.`,name:"clean_caption"},{anchor:"diffusers.PixArtSigmaPAGPipeline.__call__.use_resolution_binning",description:`<strong>use_resolution_binning</strong> (<code>bool</code> defaults to <code>True</code>) &#x2014;
If set to <code>True</code>, the requested height and width are first mapped to the closest resolutions using
<code>ASPECT_RATIO_1024_BIN</code>. After the produced latents are decoded into images, they are resized back to
the requested resolution. Useful for generating non-square images.`,name:"use_resolution_binning"},{anchor:"diffusers.PixArtSigmaPAGPipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 300) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"},{anchor:"diffusers.PixArtSigmaPAGPipeline.__call__.pag_scale",description:`<strong>pag_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 3.0) &#x2014;
The scale factor for the perturbed attention guidance. If it is set to 0.0, the perturbed attention
guidance will not be used.`,name:"pag_scale"},{anchor:"diffusers.PixArtSigmaPAGPipeline.__call__.pag_adaptive_scale",description:`<strong>pag_adaptive_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The adaptive scale factor for the perturbed attention guidance. If it is set to 0.0, <code>pag_scale</code> is
used.`,name:"pag_adaptive_scale"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_pixart_sigma.py#L572",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/pr_7613/en/api/pipelines/latent_diffusion#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> is returned, otherwise a <code>tuple</code> is
returned where the first element is a list with the generated images</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_7613/en/api/pipelines/latent_diffusion#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),tt=new te({props:{anchor:"diffusers.PixArtSigmaPAGPipeline.__call__.example",$$slots:{default:[Fd]},$$scope:{ctx:T}}}),Pn=new I({props:{name:"encode_prompt",anchor:"diffusers.PixArtSigmaPAGPipeline.encode_prompt",parameters:[{name:"prompt",val:": Union"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"negative_prompt",val:": str = ''"},{name:"num_images_per_prompt",val:": int = 1"},{name:"device",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"prompt_attention_mask",val:": Optional = None"},{name:"negative_prompt_attention_mask",val:": Optional = None"},{name:"clean_caption",val:": bool = False"},{name:"max_sequence_length",val:": int = 300"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.PixArtSigmaPAGPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.PixArtSigmaPAGPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt not to guide the image generation. If not defined, one has to pass <code>negative_prompt_embeds</code>
instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is less than <code>1</code>). For
PixArt-Alpha, this should be &quot;&quot;.`,name:"negative_prompt"},{anchor:"diffusers.PixArtSigmaPAGPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.PixArtSigmaPAGPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
number of images that should be generated per prompt
device &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device to place the resulting embeddings on`,name:"num_images_per_prompt"},{anchor:"diffusers.PixArtSigmaPAGPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.PixArtSigmaPAGPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. For PixArt-Alpha, it&#x2019;s should be the embeddings of the &quot;&quot;
string.`,name:"negative_prompt_embeds"},{anchor:"diffusers.PixArtSigmaPAGPipeline.encode_prompt.clean_caption",description:`<strong>clean_caption</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, the function will preprocess and clean the provided caption before encoding.`,name:"clean_caption"},{anchor:"diffusers.PixArtSigmaPAGPipeline.encode_prompt.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code>, defaults to 300) &#x2014; Maximum sequence length to use for the prompt.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/vr_7613/src/diffusers/pipelines/pag/pipeline_pag_pixart_sigma.py#L181"}}),xn=new Cd({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/pag.md"}}),{c(){l=a("meta"),M=o(),v=a("p"),d=o(),m(P.$$.fragment),n=o(),x=a("p"),x.innerHTML=Zr,_i=o(),at=a("p"),at.innerHTML=Wr,hi=o(),st=a("p"),st.textContent=Br,bi=o(),rt=a("p"),rt.innerHTML=Rr,vi=o(),lt=a("p"),lt.innerHTML=Fr,Pi=o(),dt=a("ul"),dt.innerHTML=Er,xi=o(),m(Pe.$$.fragment),wi=o(),m(pt.$$.fragment),yi=o(),j=a("div"),m(ct.$$.fragment),ua=o(),Gn=a("p"),Gn.innerHTML=Vr,_a=o(),Dn=a("p"),Dn.innerHTML=Or,ha=o(),Cn=a("p"),Cn.textContent=Hr,ba=o(),kn=a("ul"),kn.innerHTML=qr,va=o(),oe=a("div"),m(mt.$$.fragment),Pa=o(),Ln=a("p"),Ln.textContent=Yr,xa=o(),m(xe.$$.fragment),wa=o(),we=a("div"),m(ft.$$.fragment),ya=o(),Sn=a("p"),Sn.textContent=Qr,Ii=o(),m(gt.$$.fragment),Mi=o(),W=a("div"),m(ut.$$.fragment),Ia=o(),Un=a("p"),Un.innerHTML=Kr,Ma=o(),jn=a("p"),jn.innerHTML=el,Ta=o(),Nn=a("p"),Nn.innerHTML=tl,Aa=o(),ie=a("div"),m(_t.$$.fragment),Ga=o(),Jn=a("p"),Jn.textContent=nl,Da=o(),m(ye.$$.fragment),Ca=o(),Ie=a("div"),m(ht.$$.fragment),ka=o(),$n=a("p"),$n.textContent=ol,Ti=o(),m(bt.$$.fragment),Ai=o(),G=a("div"),m(vt.$$.fragment),La=o(),Xn=a("p"),Xn.textContent=il,Sa=o(),zn=a("p"),zn.innerHTML=al,Ua=o(),Zn=a("p"),Zn.textContent=sl,ja=o(),Wn=a("ul"),Wn.innerHTML=rl,Na=o(),ae=a("div"),m(Pt.$$.fragment),Ja=o(),Bn=a("p"),Bn.textContent=ll,$a=o(),m(Me.$$.fragment),Xa=o(),Te=a("div"),m(xt.$$.fragment),za=o(),Rn=a("p"),Rn.textContent=dl,Za=o(),Ae=a("div"),m(wt.$$.fragment),Wa=o(),Fn=a("p"),Fn.innerHTML=pl,Gi=o(),m(yt.$$.fragment),Di=o(),D=a("div"),m(It.$$.fragment),Ba=o(),En=a("p"),En.textContent=cl,Ra=o(),Vn=a("p"),Vn.innerHTML=ml,Fa=o(),On=a("p"),On.textContent=fl,Ea=o(),Hn=a("ul"),Hn.innerHTML=gl,Va=o(),se=a("div"),m(Mt.$$.fragment),Oa=o(),qn=a("p"),qn.textContent=ul,Ha=o(),m(Ge.$$.fragment),qa=o(),De=a("div"),m(Tt.$$.fragment),Ya=o(),Yn=a("p"),Yn.textContent=_l,Qa=o(),Ce=a("div"),m(At.$$.fragment),Ka=o(),Qn=a("p"),Qn.innerHTML=hl,Ci=o(),m(Gt.$$.fragment),ki=o(),C=a("div"),m(Dt.$$.fragment),es=o(),Kn=a("p"),Kn.textContent=bl,ts=o(),eo=a("p"),eo.innerHTML=vl,ns=o(),to=a("p"),to.textContent=Pl,os=o(),no=a("ul"),no.innerHTML=xl,is=o(),re=a("div"),m(Ct.$$.fragment),as=o(),oo=a("p"),oo.textContent=wl,ss=o(),m(ke.$$.fragment),rs=o(),Le=a("div"),m(kt.$$.fragment),ls=o(),io=a("p"),io.textContent=yl,ds=o(),Se=a("div"),m(Lt.$$.fragment),ps=o(),ao=a("p"),ao.innerHTML=Il,Li=o(),m(St.$$.fragment),Si=o(),N=a("div"),m(Ut.$$.fragment),cs=o(),so=a("p"),so.textContent=Ml,ms=o(),ro=a("p"),ro.innerHTML=Tl,fs=o(),lo=a("p"),lo.textContent=Al,gs=o(),po=a("ul"),po.innerHTML=Gl,us=o(),Ue=a("div"),m(jt.$$.fragment),_s=o(),co=a("p"),co.textContent=Dl,hs=o(),je=a("div"),m(Nt.$$.fragment),bs=o(),mo=a("p"),mo.innerHTML=Cl,Ui=o(),m(Jt.$$.fragment),ji=o(),A=a("div"),m($t.$$.fragment),vs=o(),fo=a("p"),fo.textContent=kl,Ps=o(),go=a("p"),go.innerHTML=Ll,xs=o(),uo=a("p"),uo.textContent=Sl,ws=o(),_o=a("ul"),_o.innerHTML=Ul,ys=o(),m(Ne.$$.fragment),Is=o(),le=a("div"),m(Xt.$$.fragment),Ms=o(),ho=a("p"),ho.textContent=jl,Ts=o(),m(Je.$$.fragment),As=o(),$e=a("div"),m(zt.$$.fragment),Gs=o(),bo=a("p"),bo.textContent=Nl,Ds=o(),Xe=a("div"),m(Zt.$$.fragment),Cs=o(),vo=a("p"),vo.innerHTML=Jl,Ni=o(),m(Wt.$$.fragment),Ji=o(),k=a("div"),m(Bt.$$.fragment),ks=o(),Po=a("p"),Po.textContent=$l,Ls=o(),xo=a("p"),xo.innerHTML=Xl,Ss=o(),wo=a("p"),wo.textContent=zl,Us=o(),yo=a("ul"),yo.innerHTML=Zl,js=o(),de=a("div"),m(Rt.$$.fragment),Ns=o(),Io=a("p"),Io.textContent=Wl,Js=o(),m(ze.$$.fragment),$s=o(),Ze=a("div"),m(Ft.$$.fragment),Xs=o(),Mo=a("p"),Mo.textContent=Bl,zs=o(),We=a("div"),m(Et.$$.fragment),Zs=o(),To=a("p"),To.innerHTML=Rl,$i=o(),m(Vt.$$.fragment),Xi=o(),L=a("div"),m(Ot.$$.fragment),Ws=o(),Ao=a("p"),Ao.textContent=Fl,Bs=o(),Go=a("p"),Go.innerHTML=El,Rs=o(),Do=a("p"),Do.textContent=Vl,Fs=o(),Co=a("ul"),Co.innerHTML=Ol,Es=o(),pe=a("div"),m(Ht.$$.fragment),Vs=o(),ko=a("p"),ko.textContent=Hl,Os=o(),m(Be.$$.fragment),Hs=o(),Re=a("div"),m(qt.$$.fragment),qs=o(),Lo=a("p"),Lo.textContent=ql,Ys=o(),Fe=a("div"),m(Yt.$$.fragment),Qs=o(),So=a("p"),So.innerHTML=Yl,zi=o(),m(Qt.$$.fragment),Zi=o(),S=a("div"),m(Kt.$$.fragment),Ks=o(),Uo=a("p"),Uo.textContent=Ql,er=o(),jo=a("p"),jo.innerHTML=Kl,tr=o(),No=a("p"),No.textContent=ed,nr=o(),Jo=a("ul"),Jo.innerHTML=td,or=o(),ce=a("div"),m(en.$$.fragment),ir=o(),$o=a("p"),$o.textContent=nd,ar=o(),m(Ee.$$.fragment),sr=o(),Ve=a("div"),m(tn.$$.fragment),rr=o(),Xo=a("p"),Xo.textContent=od,lr=o(),Oe=a("div"),m(nn.$$.fragment),dr=o(),zo=a("p"),zo.innerHTML=id,Wi=o(),m(on.$$.fragment),Bi=o(),U=a("div"),m(an.$$.fragment),pr=o(),Zo=a("p"),Zo.textContent=ad,cr=o(),Wo=a("p"),Wo.innerHTML=sd,mr=o(),Bo=a("p"),Bo.textContent=rd,fr=o(),Ro=a("ul"),Ro.innerHTML=ld,gr=o(),me=a("div"),m(sn.$$.fragment),ur=o(),Fo=a("p"),Fo.textContent=dd,_r=o(),m(He.$$.fragment),hr=o(),qe=a("div"),m(rn.$$.fragment),br=o(),Eo=a("p"),Eo.textContent=pd,vr=o(),Ye=a("div"),m(ln.$$.fragment),Pr=o(),Vo=a("p"),Vo.innerHTML=cd,Ri=o(),m(dn.$$.fragment),Fi=o(),J=a("div"),m(pn.$$.fragment),xr=o(),Oo=a("p"),Oo.textContent=md,wr=o(),Ho=a("p"),Ho.innerHTML=fd,yr=o(),qo=a("p"),qo.textContent=gd,Ir=o(),Yo=a("ul"),Yo.innerHTML=ud,Mr=o(),fe=a("div"),m(cn.$$.fragment),Tr=o(),Qo=a("p"),Qo.textContent=_d,Ar=o(),m(Qe.$$.fragment),Gr=o(),Ke=a("div"),m(mn.$$.fragment),Dr=o(),Ko=a("p"),Ko.textContent=hd,Ei=o(),m(fn.$$.fragment),Vi=o(),K=a("div"),m(gn.$$.fragment),Cr=o(),ei=a("p"),ei.innerHTML=bd,kr=o(),ge=a("div"),m(un.$$.fragment),Lr=o(),ti=a("p"),ti.textContent=vd,Sr=o(),m(et.$$.fragment),Ur=o(),ni=a("div"),m(_n.$$.fragment),Oi=o(),m(hn.$$.fragment),Hi=o(),ee=a("div"),m(bn.$$.fragment),jr=o(),oi=a("p"),oi.innerHTML=Pd,Nr=o(),ue=a("div"),m(vn.$$.fragment),Jr=o(),ii=a("p"),ii.textContent=xd,$r=o(),m(tt.$$.fragment),Xr=o(),nt=a("div"),m(Pn.$$.fragment),zr=o(),ai=a("p"),ai.textContent=wd,qi=o(),m(xn.$$.fragment),Yi=o(),ui=a("p"),this.h()},l(e){const p=Dd("svelte-u9bgzb",document.head);l=s(p,"META",{name:!0,content:!0}),p.forEach(r),M=i(e),v=s(e,"P",{}),w(v).forEach(r),d=i(e),f(P.$$.fragment,e),n=i(e),x=s(e,"P",{"data-svelte-h":!0}),c(x)!=="svelte-1f0h9oa"&&(x.innerHTML=Zr),_i=i(e),at=s(e,"P",{"data-svelte-h":!0}),c(at)!=="svelte-fqzi6w"&&(at.innerHTML=Wr),hi=i(e),st=s(e,"P",{"data-svelte-h":!0}),c(st)!=="svelte-1cwsb16"&&(st.textContent=Br),bi=i(e),rt=s(e,"P",{"data-svelte-h":!0}),c(rt)!=="svelte-zk9tps"&&(rt.innerHTML=Rr),vi=i(e),lt=s(e,"P",{"data-svelte-h":!0}),c(lt)!=="svelte-jkimze"&&(lt.innerHTML=Fr),Pi=i(e),dt=s(e,"UL",{"data-svelte-h":!0}),c(dt)!=="svelte-mmuswp"&&(dt.innerHTML=Er),xi=i(e),f(Pe.$$.fragment,e),wi=i(e),f(pt.$$.fragment,e),yi=i(e),j=s(e,"DIV",{class:!0});var B=w(j);f(ct.$$.fragment,B),ua=i(B),Gn=s(B,"P",{"data-svelte-h":!0}),c(Gn)!=="svelte-lhgky6"&&(Gn.innerHTML=Vr),_a=i(B),Dn=s(B,"P",{"data-svelte-h":!0}),c(Dn)!=="svelte-inpef5"&&(Dn.innerHTML=Or),ha=i(B),Cn=s(B,"P",{"data-svelte-h":!0}),c(Cn)!=="svelte-14s6m4u"&&(Cn.textContent=Hr),ba=i(B),kn=s(B,"UL",{"data-svelte-h":!0}),c(kn)!=="svelte-m297xe"&&(kn.innerHTML=qr),va=i(B),oe=s(B,"DIV",{class:!0});var _e=w(oe);f(mt.$$.fragment,_e),Pa=i(_e),Ln=s(_e,"P",{"data-svelte-h":!0}),c(Ln)!=="svelte-50j04k"&&(Ln.textContent=Yr),xa=i(_e),f(xe.$$.fragment,_e),_e.forEach(r),wa=i(B),we=s(B,"DIV",{class:!0});var wn=w(we);f(ft.$$.fragment,wn),ya=i(wn),Sn=s(wn,"P",{"data-svelte-h":!0}),c(Sn)!=="svelte-16q0ax1"&&(Sn.textContent=Qr),wn.forEach(r),B.forEach(r),Ii=i(e),f(gt.$$.fragment,e),Mi=i(e),W=s(e,"DIV",{class:!0});var O=w(W);f(ut.$$.fragment,O),Ia=i(O),Un=s(O,"P",{"data-svelte-h":!0}),c(Un)!=="svelte-1mwv1km"&&(Un.innerHTML=Kr),Ma=i(O),jn=s(O,"P",{"data-svelte-h":!0}),c(jn)!=="svelte-1gfi0ra"&&(jn.innerHTML=el),Ta=i(O),Nn=s(O,"P",{"data-svelte-h":!0}),c(Nn)!=="svelte-18ud7q1"&&(Nn.innerHTML=tl),Aa=i(O),ie=s(O,"DIV",{class:!0});var he=w(ie);f(_t.$$.fragment,he),Ga=i(he),Jn=s(he,"P",{"data-svelte-h":!0}),c(Jn)!=="svelte-1jqbgbl"&&(Jn.textContent=nl),Da=i(he),f(ye.$$.fragment,he),he.forEach(r),Ca=i(O),Ie=s(O,"DIV",{class:!0});var yn=w(Ie);f(ht.$$.fragment,yn),ka=i(yn),$n=s(yn,"P",{"data-svelte-h":!0}),c($n)!=="svelte-16q0ax1"&&($n.textContent=ol),yn.forEach(r),O.forEach(r),Ti=i(e),f(bt.$$.fragment,e),Ai=i(e),G=s(e,"DIV",{class:!0});var $=w(G);f(vt.$$.fragment,$),La=i($),Xn=s($,"P",{"data-svelte-h":!0}),c(Xn)!=="svelte-d2bqje"&&(Xn.textContent=il),Sa=i($),zn=s($,"P",{"data-svelte-h":!0}),c(zn)!=="svelte-1gfi0ra"&&(zn.innerHTML=al),Ua=i($),Zn=s($,"P",{"data-svelte-h":!0}),c(Zn)!=="svelte-14s6m4u"&&(Zn.textContent=sl),ja=i($),Wn=s($,"UL",{"data-svelte-h":!0}),c(Wn)!=="svelte-1e4ahzf"&&(Wn.innerHTML=rl),Na=i($),ae=s($,"DIV",{class:!0});var be=w(ae);f(Pt.$$.fragment,be),Ja=i(be),Bn=s(be,"P",{"data-svelte-h":!0}),c(Bn)!=="svelte-v78lg8"&&(Bn.textContent=ll),$a=i(be),f(Me.$$.fragment,be),be.forEach(r),Xa=i($),Te=s($,"DIV",{class:!0});var In=w(Te);f(xt.$$.fragment,In),za=i(In),Rn=s(In,"P",{"data-svelte-h":!0}),c(Rn)!=="svelte-16q0ax1"&&(Rn.textContent=dl),In.forEach(r),Za=i($),Ae=s($,"DIV",{class:!0});var Mn=w(Ae);f(wt.$$.fragment,Mn),Wa=i(Mn),Fn=s(Mn,"P",{"data-svelte-h":!0}),c(Fn)!=="svelte-vo59ec"&&(Fn.innerHTML=pl),Mn.forEach(r),$.forEach(r),Gi=i(e),f(yt.$$.fragment,e),Di=i(e),D=s(e,"DIV",{class:!0});var X=w(D);f(It.$$.fragment,X),Ba=i(X),En=s(X,"P",{"data-svelte-h":!0}),c(En)!=="svelte-35p306"&&(En.textContent=cl),Ra=i(X),Vn=s(X,"P",{"data-svelte-h":!0}),c(Vn)!=="svelte-inpef5"&&(Vn.innerHTML=ml),Fa=i(X),On=s(X,"P",{"data-svelte-h":!0}),c(On)!=="svelte-14s6m4u"&&(On.textContent=fl),Ea=i(X),Hn=s(X,"UL",{"data-svelte-h":!0}),c(Hn)!=="svelte-gnr5ga"&&(Hn.innerHTML=gl),Va=i(X),se=s(X,"DIV",{class:!0});var ve=w(se);f(Mt.$$.fragment,ve),Oa=i(ve),qn=s(ve,"P",{"data-svelte-h":!0}),c(qn)!=="svelte-50j04k"&&(qn.textContent=ul),Ha=i(ve),f(Ge.$$.fragment,ve),ve.forEach(r),qa=i(X),De=s(X,"DIV",{class:!0});var Tn=w(De);f(Tt.$$.fragment,Tn),Ya=i(Tn),Yn=s(Tn,"P",{"data-svelte-h":!0}),c(Yn)!=="svelte-16q0ax1"&&(Yn.textContent=_l),Tn.forEach(r),Qa=i(X),Ce=s(X,"DIV",{class:!0});var An=w(Ce);f(At.$$.fragment,An),Ka=i(An),Qn=s(An,"P",{"data-svelte-h":!0}),c(Qn)!=="svelte-vo59ec"&&(Qn.innerHTML=hl),An.forEach(r),X.forEach(r),Ci=i(e),f(Gt.$$.fragment,e),ki=i(e),C=s(e,"DIV",{class:!0});var z=w(C);f(Dt.$$.fragment,z),es=i(z),Kn=s(z,"P",{"data-svelte-h":!0}),c(Kn)!=="svelte-1n95u1g"&&(Kn.textContent=bl),ts=i(z),eo=s(z,"P",{"data-svelte-h":!0}),c(eo)!=="svelte-inpef5"&&(eo.innerHTML=vl),ns=i(z),to=s(z,"P",{"data-svelte-h":!0}),c(to)!=="svelte-14s6m4u"&&(to.textContent=Pl),os=i(z),no=s(z,"UL",{"data-svelte-h":!0}),c(no)!=="svelte-gnr5ga"&&(no.innerHTML=xl),is=i(z),re=s(z,"DIV",{class:!0});var si=w(re);f(Ct.$$.fragment,si),as=i(si),oo=s(si,"P",{"data-svelte-h":!0}),c(oo)!=="svelte-50j04k"&&(oo.textContent=wl),ss=i(si),f(ke.$$.fragment,si),si.forEach(r),rs=i(z),Le=s(z,"DIV",{class:!0});var Ki=w(Le);f(kt.$$.fragment,Ki),ls=i(Ki),io=s(Ki,"P",{"data-svelte-h":!0}),c(io)!=="svelte-16q0ax1"&&(io.textContent=yl),Ki.forEach(r),ds=i(z),Se=s(z,"DIV",{class:!0});var ea=w(Se);f(Lt.$$.fragment,ea),ps=i(ea),ao=s(ea,"P",{"data-svelte-h":!0}),c(ao)!=="svelte-vo59ec"&&(ao.innerHTML=Il),ea.forEach(r),z.forEach(r),Li=i(e),f(St.$$.fragment,e),Si=i(e),N=s(e,"DIV",{class:!0});var Y=w(N);f(Ut.$$.fragment,Y),cs=i(Y),so=s(Y,"P",{"data-svelte-h":!0}),c(so)!=="svelte-1or48uk"&&(so.textContent=Ml),ms=i(Y),ro=s(Y,"P",{"data-svelte-h":!0}),c(ro)!=="svelte-inpef5"&&(ro.innerHTML=Tl),fs=i(Y),lo=s(Y,"P",{"data-svelte-h":!0}),c(lo)!=="svelte-14s6m4u"&&(lo.textContent=Al),gs=i(Y),po=s(Y,"UL",{"data-svelte-h":!0}),c(po)!=="svelte-gnr5ga"&&(po.innerHTML=Gl),us=i(Y),Ue=s(Y,"DIV",{class:!0});var ta=w(Ue);f(jt.$$.fragment,ta),_s=i(ta),co=s(ta,"P",{"data-svelte-h":!0}),c(co)!=="svelte-16q0ax1"&&(co.textContent=Dl),ta.forEach(r),hs=i(Y),je=s(Y,"DIV",{class:!0});var na=w(je);f(Nt.$$.fragment,na),bs=i(na),mo=s(na,"P",{"data-svelte-h":!0}),c(mo)!=="svelte-vo59ec"&&(mo.innerHTML=Cl),na.forEach(r),Y.forEach(r),Ui=i(e),f(Jt.$$.fragment,e),ji=i(e),A=s(e,"DIV",{class:!0});var Z=w(A);f($t.$$.fragment,Z),vs=i(Z),fo=s(Z,"P",{"data-svelte-h":!0}),c(fo)!=="svelte-l9ypsb"&&(fo.textContent=kl),Ps=i(Z),go=s(Z,"P",{"data-svelte-h":!0}),c(go)!=="svelte-inpef5"&&(go.innerHTML=Ll),xs=i(Z),uo=s(Z,"P",{"data-svelte-h":!0}),c(uo)!=="svelte-14s6m4u"&&(uo.textContent=Sl),ws=i(Z),_o=s(Z,"UL",{"data-svelte-h":!0}),c(_o)!=="svelte-gnr5ga"&&(_o.innerHTML=Ul),ys=i(Z),f(Ne.$$.fragment,Z),Is=i(Z),le=s(Z,"DIV",{class:!0});var ri=w(le);f(Xt.$$.fragment,ri),Ms=i(ri),ho=s(ri,"P",{"data-svelte-h":!0}),c(ho)!=="svelte-50j04k"&&(ho.textContent=jl),Ts=i(ri),f(Je.$$.fragment,ri),ri.forEach(r),As=i(Z),$e=s(Z,"DIV",{class:!0});var oa=w($e);f(zt.$$.fragment,oa),Gs=i(oa),bo=s(oa,"P",{"data-svelte-h":!0}),c(bo)!=="svelte-16q0ax1"&&(bo.textContent=Nl),oa.forEach(r),Ds=i(Z),Xe=s(Z,"DIV",{class:!0});var ia=w(Xe);f(Zt.$$.fragment,ia),Cs=i(ia),vo=s(ia,"P",{"data-svelte-h":!0}),c(vo)!=="svelte-vo59ec"&&(vo.innerHTML=Jl),ia.forEach(r),Z.forEach(r),Ni=i(e),f(Wt.$$.fragment,e),Ji=i(e),k=s(e,"DIV",{class:!0});var R=w(k);f(Bt.$$.fragment,R),ks=i(R),Po=s(R,"P",{"data-svelte-h":!0}),c(Po)!=="svelte-1q4yve"&&(Po.textContent=$l),Ls=i(R),xo=s(R,"P",{"data-svelte-h":!0}),c(xo)!=="svelte-1gfi0ra"&&(xo.innerHTML=Xl),Ss=i(R),wo=s(R,"P",{"data-svelte-h":!0}),c(wo)!=="svelte-14s6m4u"&&(wo.textContent=zl),Us=i(R),yo=s(R,"UL",{"data-svelte-h":!0}),c(yo)!=="svelte-1rnsbsy"&&(yo.innerHTML=Zl),js=i(R),de=s(R,"DIV",{class:!0});var li=w(de);f(Rt.$$.fragment,li),Ns=i(li),Io=s(li,"P",{"data-svelte-h":!0}),c(Io)!=="svelte-v78lg8"&&(Io.textContent=Wl),Js=i(li),f(ze.$$.fragment,li),li.forEach(r),$s=i(R),Ze=s(R,"DIV",{class:!0});var aa=w(Ze);f(Ft.$$.fragment,aa),Xs=i(aa),Mo=s(aa,"P",{"data-svelte-h":!0}),c(Mo)!=="svelte-16q0ax1"&&(Mo.textContent=Bl),aa.forEach(r),zs=i(R),We=s(R,"DIV",{class:!0});var sa=w(We);f(Et.$$.fragment,sa),Zs=i(sa),To=s(sa,"P",{"data-svelte-h":!0}),c(To)!=="svelte-vo59ec"&&(To.innerHTML=Rl),sa.forEach(r),R.forEach(r),$i=i(e),f(Vt.$$.fragment,e),Xi=i(e),L=s(e,"DIV",{class:!0});var F=w(L);f(Ot.$$.fragment,F),Ws=i(F),Ao=s(F,"P",{"data-svelte-h":!0}),c(Ao)!=="svelte-1q4yve"&&(Ao.textContent=Fl),Bs=i(F),Go=s(F,"P",{"data-svelte-h":!0}),c(Go)!=="svelte-1gfi0ra"&&(Go.innerHTML=El),Rs=i(F),Do=s(F,"P",{"data-svelte-h":!0}),c(Do)!=="svelte-14s6m4u"&&(Do.textContent=Vl),Fs=i(F),Co=s(F,"UL",{"data-svelte-h":!0}),c(Co)!=="svelte-1rnsbsy"&&(Co.innerHTML=Ol),Es=i(F),pe=s(F,"DIV",{class:!0});var di=w(pe);f(Ht.$$.fragment,di),Vs=i(di),ko=s(di,"P",{"data-svelte-h":!0}),c(ko)!=="svelte-v78lg8"&&(ko.textContent=Hl),Os=i(di),f(Be.$$.fragment,di),di.forEach(r),Hs=i(F),Re=s(F,"DIV",{class:!0});var ra=w(Re);f(qt.$$.fragment,ra),qs=i(ra),Lo=s(ra,"P",{"data-svelte-h":!0}),c(Lo)!=="svelte-16q0ax1"&&(Lo.textContent=ql),ra.forEach(r),Ys=i(F),Fe=s(F,"DIV",{class:!0});var la=w(Fe);f(Yt.$$.fragment,la),Qs=i(la),So=s(la,"P",{"data-svelte-h":!0}),c(So)!=="svelte-vo59ec"&&(So.innerHTML=Yl),la.forEach(r),F.forEach(r),zi=i(e),f(Qt.$$.fragment,e),Zi=i(e),S=s(e,"DIV",{class:!0});var E=w(S);f(Kt.$$.fragment,E),Ks=i(E),Uo=s(E,"P",{"data-svelte-h":!0}),c(Uo)!=="svelte-1q4yve"&&(Uo.textContent=Ql),er=i(E),jo=s(E,"P",{"data-svelte-h":!0}),c(jo)!=="svelte-1gfi0ra"&&(jo.innerHTML=Kl),tr=i(E),No=s(E,"P",{"data-svelte-h":!0}),c(No)!=="svelte-14s6m4u"&&(No.textContent=ed),nr=i(E),Jo=s(E,"UL",{"data-svelte-h":!0}),c(Jo)!=="svelte-1rnsbsy"&&(Jo.innerHTML=td),or=i(E),ce=s(E,"DIV",{class:!0});var pi=w(ce);f(en.$$.fragment,pi),ir=i(pi),$o=s(pi,"P",{"data-svelte-h":!0}),c($o)!=="svelte-v78lg8"&&($o.textContent=nd),ar=i(pi),f(Ee.$$.fragment,pi),pi.forEach(r),sr=i(E),Ve=s(E,"DIV",{class:!0});var da=w(Ve);f(tn.$$.fragment,da),rr=i(da),Xo=s(da,"P",{"data-svelte-h":!0}),c(Xo)!=="svelte-16q0ax1"&&(Xo.textContent=od),da.forEach(r),lr=i(E),Oe=s(E,"DIV",{class:!0});var pa=w(Oe);f(nn.$$.fragment,pa),dr=i(pa),zo=s(pa,"P",{"data-svelte-h":!0}),c(zo)!=="svelte-vo59ec"&&(zo.innerHTML=id),pa.forEach(r),E.forEach(r),Wi=i(e),f(on.$$.fragment,e),Bi=i(e),U=s(e,"DIV",{class:!0});var V=w(U);f(an.$$.fragment,V),pr=i(V),Zo=s(V,"P",{"data-svelte-h":!0}),c(Zo)!=="svelte-ehlo5w"&&(Zo.textContent=ad),cr=i(V),Wo=s(V,"P",{"data-svelte-h":!0}),c(Wo)!=="svelte-inpef5"&&(Wo.innerHTML=sd),mr=i(V),Bo=s(V,"P",{"data-svelte-h":!0}),c(Bo)!=="svelte-14s6m4u"&&(Bo.textContent=rd),fr=i(V),Ro=s(V,"UL",{"data-svelte-h":!0}),c(Ro)!=="svelte-yiucci"&&(Ro.innerHTML=ld),gr=i(V),me=s(V,"DIV",{class:!0});var ci=w(me);f(sn.$$.fragment,ci),ur=i(ci),Fo=s(ci,"P",{"data-svelte-h":!0}),c(Fo)!=="svelte-50j04k"&&(Fo.textContent=dd),_r=i(ci),f(He.$$.fragment,ci),ci.forEach(r),hr=i(V),qe=s(V,"DIV",{class:!0});var ca=w(qe);f(rn.$$.fragment,ca),br=i(ca),Eo=s(ca,"P",{"data-svelte-h":!0}),c(Eo)!=="svelte-16q0ax1"&&(Eo.textContent=pd),ca.forEach(r),vr=i(V),Ye=s(V,"DIV",{class:!0});var ma=w(Ye);f(ln.$$.fragment,ma),Pr=i(ma),Vo=s(ma,"P",{"data-svelte-h":!0}),c(Vo)!=="svelte-vo59ec"&&(Vo.innerHTML=cd),ma.forEach(r),V.forEach(r),Ri=i(e),f(dn.$$.fragment,e),Fi=i(e),J=s(e,"DIV",{class:!0});var Q=w(J);f(pn.$$.fragment,Q),xr=i(Q),Oo=s(Q,"P",{"data-svelte-h":!0}),c(Oo)!=="svelte-1q9vn04"&&(Oo.textContent=md),wr=i(Q),Ho=s(Q,"P",{"data-svelte-h":!0}),c(Ho)!=="svelte-1gfi0ra"&&(Ho.innerHTML=fd),yr=i(Q),qo=s(Q,"P",{"data-svelte-h":!0}),c(qo)!=="svelte-14s6m4u"&&(qo.textContent=gd),Ir=i(Q),Yo=s(Q,"UL",{"data-svelte-h":!0}),c(Yo)!=="svelte-12qe60a"&&(Yo.innerHTML=ud),Mr=i(Q),fe=s(Q,"DIV",{class:!0});var mi=w(fe);f(cn.$$.fragment,mi),Tr=i(mi),Qo=s(mi,"P",{"data-svelte-h":!0}),c(Qo)!=="svelte-v78lg8"&&(Qo.textContent=_d),Ar=i(mi),f(Qe.$$.fragment,mi),mi.forEach(r),Gr=i(Q),Ke=s(Q,"DIV",{class:!0});var fa=w(Ke);f(mn.$$.fragment,fa),Dr=i(fa),Ko=s(fa,"P",{"data-svelte-h":!0}),c(Ko)!=="svelte-16q0ax1"&&(Ko.textContent=hd),fa.forEach(r),Q.forEach(r),Ei=i(e),f(fn.$$.fragment,e),Vi=i(e),K=s(e,"DIV",{class:!0});var ot=w(K);f(gn.$$.fragment,ot),Cr=i(ot),ei=s(ot,"P",{"data-svelte-h":!0}),c(ei)!=="svelte-cbb6gb"&&(ei.innerHTML=bd),kr=i(ot),ge=s(ot,"DIV",{class:!0});var fi=w(ge);f(un.$$.fragment,fi),Lr=i(fi),ti=s(fi,"P",{"data-svelte-h":!0}),c(ti)!=="svelte-v78lg8"&&(ti.textContent=vd),Sr=i(fi),f(et.$$.fragment,fi),fi.forEach(r),Ur=i(ot),ni=s(ot,"DIV",{class:!0});var yd=w(ni);f(_n.$$.fragment,yd),yd.forEach(r),ot.forEach(r),Oi=i(e),f(hn.$$.fragment,e),Hi=i(e),ee=s(e,"DIV",{class:!0});var it=w(ee);f(bn.$$.fragment,it),jr=i(it),oi=s(it,"P",{"data-svelte-h":!0}),c(oi)!=="svelte-rv44po"&&(oi.innerHTML=Pd),Nr=i(it),ue=s(it,"DIV",{class:!0});var gi=w(ue);f(vn.$$.fragment,gi),Jr=i(gi),ii=s(gi,"P",{"data-svelte-h":!0}),c(ii)!=="svelte-v78lg8"&&(ii.textContent=xd),$r=i(gi),f(tt.$$.fragment,gi),gi.forEach(r),Xr=i(it),nt=s(it,"DIV",{class:!0});var ga=w(nt);f(Pn.$$.fragment,ga),zr=i(ga),ai=s(ga,"P",{"data-svelte-h":!0}),c(ai)!=="svelte-16q0ax1"&&(ai.textContent=wd),ga.forEach(r),it.forEach(r),qi=i(e),f(xn.$$.fragment,e),Yi=i(e),ui=s(e,"P",{}),w(ui).forEach(r),this.h()},h(){y(l,"name","hf:doc:metadata"),y(l,"content",Vd),y(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(we,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(Ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(Te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(Ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(De,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y($e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(Ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(We,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(Re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(Ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(Ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(Ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(ni,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,p){t(document.head,l),b(e,M,p),b(e,v,p),b(e,d,p),g(P,e,p),b(e,n,p),b(e,x,p),b(e,_i,p),b(e,at,p),b(e,hi,p),b(e,st,p),b(e,bi,p),b(e,rt,p),b(e,vi,p),b(e,lt,p),b(e,Pi,p),b(e,dt,p),b(e,xi,p),g(Pe,e,p),b(e,wi,p),g(pt,e,p),b(e,yi,p),b(e,j,p),g(ct,j,null),t(j,ua),t(j,Gn),t(j,_a),t(j,Dn),t(j,ha),t(j,Cn),t(j,ba),t(j,kn),t(j,va),t(j,oe),g(mt,oe,null),t(oe,Pa),t(oe,Ln),t(oe,xa),g(xe,oe,null),t(j,wa),t(j,we),g(ft,we,null),t(we,ya),t(we,Sn),b(e,Ii,p),g(gt,e,p),b(e,Mi,p),b(e,W,p),g(ut,W,null),t(W,Ia),t(W,Un),t(W,Ma),t(W,jn),t(W,Ta),t(W,Nn),t(W,Aa),t(W,ie),g(_t,ie,null),t(ie,Ga),t(ie,Jn),t(ie,Da),g(ye,ie,null),t(W,Ca),t(W,Ie),g(ht,Ie,null),t(Ie,ka),t(Ie,$n),b(e,Ti,p),g(bt,e,p),b(e,Ai,p),b(e,G,p),g(vt,G,null),t(G,La),t(G,Xn),t(G,Sa),t(G,zn),t(G,Ua),t(G,Zn),t(G,ja),t(G,Wn),t(G,Na),t(G,ae),g(Pt,ae,null),t(ae,Ja),t(ae,Bn),t(ae,$a),g(Me,ae,null),t(G,Xa),t(G,Te),g(xt,Te,null),t(Te,za),t(Te,Rn),t(G,Za),t(G,Ae),g(wt,Ae,null),t(Ae,Wa),t(Ae,Fn),b(e,Gi,p),g(yt,e,p),b(e,Di,p),b(e,D,p),g(It,D,null),t(D,Ba),t(D,En),t(D,Ra),t(D,Vn),t(D,Fa),t(D,On),t(D,Ea),t(D,Hn),t(D,Va),t(D,se),g(Mt,se,null),t(se,Oa),t(se,qn),t(se,Ha),g(Ge,se,null),t(D,qa),t(D,De),g(Tt,De,null),t(De,Ya),t(De,Yn),t(D,Qa),t(D,Ce),g(At,Ce,null),t(Ce,Ka),t(Ce,Qn),b(e,Ci,p),g(Gt,e,p),b(e,ki,p),b(e,C,p),g(Dt,C,null),t(C,es),t(C,Kn),t(C,ts),t(C,eo),t(C,ns),t(C,to),t(C,os),t(C,no),t(C,is),t(C,re),g(Ct,re,null),t(re,as),t(re,oo),t(re,ss),g(ke,re,null),t(C,rs),t(C,Le),g(kt,Le,null),t(Le,ls),t(Le,io),t(C,ds),t(C,Se),g(Lt,Se,null),t(Se,ps),t(Se,ao),b(e,Li,p),g(St,e,p),b(e,Si,p),b(e,N,p),g(Ut,N,null),t(N,cs),t(N,so),t(N,ms),t(N,ro),t(N,fs),t(N,lo),t(N,gs),t(N,po),t(N,us),t(N,Ue),g(jt,Ue,null),t(Ue,_s),t(Ue,co),t(N,hs),t(N,je),g(Nt,je,null),t(je,bs),t(je,mo),b(e,Ui,p),g(Jt,e,p),b(e,ji,p),b(e,A,p),g($t,A,null),t(A,vs),t(A,fo),t(A,Ps),t(A,go),t(A,xs),t(A,uo),t(A,ws),t(A,_o),t(A,ys),g(Ne,A,null),t(A,Is),t(A,le),g(Xt,le,null),t(le,Ms),t(le,ho),t(le,Ts),g(Je,le,null),t(A,As),t(A,$e),g(zt,$e,null),t($e,Gs),t($e,bo),t(A,Ds),t(A,Xe),g(Zt,Xe,null),t(Xe,Cs),t(Xe,vo),b(e,Ni,p),g(Wt,e,p),b(e,Ji,p),b(e,k,p),g(Bt,k,null),t(k,ks),t(k,Po),t(k,Ls),t(k,xo),t(k,Ss),t(k,wo),t(k,Us),t(k,yo),t(k,js),t(k,de),g(Rt,de,null),t(de,Ns),t(de,Io),t(de,Js),g(ze,de,null),t(k,$s),t(k,Ze),g(Ft,Ze,null),t(Ze,Xs),t(Ze,Mo),t(k,zs),t(k,We),g(Et,We,null),t(We,Zs),t(We,To),b(e,$i,p),g(Vt,e,p),b(e,Xi,p),b(e,L,p),g(Ot,L,null),t(L,Ws),t(L,Ao),t(L,Bs),t(L,Go),t(L,Rs),t(L,Do),t(L,Fs),t(L,Co),t(L,Es),t(L,pe),g(Ht,pe,null),t(pe,Vs),t(pe,ko),t(pe,Os),g(Be,pe,null),t(L,Hs),t(L,Re),g(qt,Re,null),t(Re,qs),t(Re,Lo),t(L,Ys),t(L,Fe),g(Yt,Fe,null),t(Fe,Qs),t(Fe,So),b(e,zi,p),g(Qt,e,p),b(e,Zi,p),b(e,S,p),g(Kt,S,null),t(S,Ks),t(S,Uo),t(S,er),t(S,jo),t(S,tr),t(S,No),t(S,nr),t(S,Jo),t(S,or),t(S,ce),g(en,ce,null),t(ce,ir),t(ce,$o),t(ce,ar),g(Ee,ce,null),t(S,sr),t(S,Ve),g(tn,Ve,null),t(Ve,rr),t(Ve,Xo),t(S,lr),t(S,Oe),g(nn,Oe,null),t(Oe,dr),t(Oe,zo),b(e,Wi,p),g(on,e,p),b(e,Bi,p),b(e,U,p),g(an,U,null),t(U,pr),t(U,Zo),t(U,cr),t(U,Wo),t(U,mr),t(U,Bo),t(U,fr),t(U,Ro),t(U,gr),t(U,me),g(sn,me,null),t(me,ur),t(me,Fo),t(me,_r),g(He,me,null),t(U,hr),t(U,qe),g(rn,qe,null),t(qe,br),t(qe,Eo),t(U,vr),t(U,Ye),g(ln,Ye,null),t(Ye,Pr),t(Ye,Vo),b(e,Ri,p),g(dn,e,p),b(e,Fi,p),b(e,J,p),g(pn,J,null),t(J,xr),t(J,Oo),t(J,wr),t(J,Ho),t(J,yr),t(J,qo),t(J,Ir),t(J,Yo),t(J,Mr),t(J,fe),g(cn,fe,null),t(fe,Tr),t(fe,Qo),t(fe,Ar),g(Qe,fe,null),t(J,Gr),t(J,Ke),g(mn,Ke,null),t(Ke,Dr),t(Ke,Ko),b(e,Ei,p),g(fn,e,p),b(e,Vi,p),b(e,K,p),g(gn,K,null),t(K,Cr),t(K,ei),t(K,kr),t(K,ge),g(un,ge,null),t(ge,Lr),t(ge,ti),t(ge,Sr),g(et,ge,null),t(K,Ur),t(K,ni),g(_n,ni,null),b(e,Oi,p),g(hn,e,p),b(e,Hi,p),b(e,ee,p),g(bn,ee,null),t(ee,jr),t(ee,oi),t(ee,Nr),t(ee,ue),g(vn,ue,null),t(ue,Jr),t(ue,ii),t(ue,$r),g(tt,ue,null),t(ee,Xr),t(ee,nt),g(Pn,nt,null),t(nt,zr),t(nt,ai),b(e,qi,p),g(xn,e,p),b(e,Yi,p),b(e,ui,p),Qi=!0},p(e,[p]){const B={};p&2&&(B.$$scope={dirty:p,ctx:e}),Pe.$set(B);const _e={};p&2&&(_e.$$scope={dirty:p,ctx:e}),xe.$set(_e);const wn={};p&2&&(wn.$$scope={dirty:p,ctx:e}),ye.$set(wn);const O={};p&2&&(O.$$scope={dirty:p,ctx:e}),Me.$set(O);const he={};p&2&&(he.$$scope={dirty:p,ctx:e}),Ge.$set(he);const yn={};p&2&&(yn.$$scope={dirty:p,ctx:e}),ke.$set(yn);const $={};p&2&&($.$$scope={dirty:p,ctx:e}),Ne.$set($);const be={};p&2&&(be.$$scope={dirty:p,ctx:e}),Je.$set(be);const In={};p&2&&(In.$$scope={dirty:p,ctx:e}),ze.$set(In);const Mn={};p&2&&(Mn.$$scope={dirty:p,ctx:e}),Be.$set(Mn);const X={};p&2&&(X.$$scope={dirty:p,ctx:e}),Ee.$set(X);const ve={};p&2&&(ve.$$scope={dirty:p,ctx:e}),He.$set(ve);const Tn={};p&2&&(Tn.$$scope={dirty:p,ctx:e}),Qe.$set(Tn);const An={};p&2&&(An.$$scope={dirty:p,ctx:e}),et.$set(An);const z={};p&2&&(z.$$scope={dirty:p,ctx:e}),tt.$set(z)},i(e){Qi||(u(P.$$.fragment,e),u(Pe.$$.fragment,e),u(pt.$$.fragment,e),u(ct.$$.fragment,e),u(mt.$$.fragment,e),u(xe.$$.fragment,e),u(ft.$$.fragment,e),u(gt.$$.fragment,e),u(ut.$$.fragment,e),u(_t.$$.fragment,e),u(ye.$$.fragment,e),u(ht.$$.fragment,e),u(bt.$$.fragment,e),u(vt.$$.fragment,e),u(Pt.$$.fragment,e),u(Me.$$.fragment,e),u(xt.$$.fragment,e),u(wt.$$.fragment,e),u(yt.$$.fragment,e),u(It.$$.fragment,e),u(Mt.$$.fragment,e),u(Ge.$$.fragment,e),u(Tt.$$.fragment,e),u(At.$$.fragment,e),u(Gt.$$.fragment,e),u(Dt.$$.fragment,e),u(Ct.$$.fragment,e),u(ke.$$.fragment,e),u(kt.$$.fragment,e),u(Lt.$$.fragment,e),u(St.$$.fragment,e),u(Ut.$$.fragment,e),u(jt.$$.fragment,e),u(Nt.$$.fragment,e),u(Jt.$$.fragment,e),u($t.$$.fragment,e),u(Ne.$$.fragment,e),u(Xt.$$.fragment,e),u(Je.$$.fragment,e),u(zt.$$.fragment,e),u(Zt.$$.fragment,e),u(Wt.$$.fragment,e),u(Bt.$$.fragment,e),u(Rt.$$.fragment,e),u(ze.$$.fragment,e),u(Ft.$$.fragment,e),u(Et.$$.fragment,e),u(Vt.$$.fragment,e),u(Ot.$$.fragment,e),u(Ht.$$.fragment,e),u(Be.$$.fragment,e),u(qt.$$.fragment,e),u(Yt.$$.fragment,e),u(Qt.$$.fragment,e),u(Kt.$$.fragment,e),u(en.$$.fragment,e),u(Ee.$$.fragment,e),u(tn.$$.fragment,e),u(nn.$$.fragment,e),u(on.$$.fragment,e),u(an.$$.fragment,e),u(sn.$$.fragment,e),u(He.$$.fragment,e),u(rn.$$.fragment,e),u(ln.$$.fragment,e),u(dn.$$.fragment,e),u(pn.$$.fragment,e),u(cn.$$.fragment,e),u(Qe.$$.fragment,e),u(mn.$$.fragment,e),u(fn.$$.fragment,e),u(gn.$$.fragment,e),u(un.$$.fragment,e),u(et.$$.fragment,e),u(_n.$$.fragment,e),u(hn.$$.fragment,e),u(bn.$$.fragment,e),u(vn.$$.fragment,e),u(tt.$$.fragment,e),u(Pn.$$.fragment,e),u(xn.$$.fragment,e),Qi=!0)},o(e){_(P.$$.fragment,e),_(Pe.$$.fragment,e),_(pt.$$.fragment,e),_(ct.$$.fragment,e),_(mt.$$.fragment,e),_(xe.$$.fragment,e),_(ft.$$.fragment,e),_(gt.$$.fragment,e),_(ut.$$.fragment,e),_(_t.$$.fragment,e),_(ye.$$.fragment,e),_(ht.$$.fragment,e),_(bt.$$.fragment,e),_(vt.$$.fragment,e),_(Pt.$$.fragment,e),_(Me.$$.fragment,e),_(xt.$$.fragment,e),_(wt.$$.fragment,e),_(yt.$$.fragment,e),_(It.$$.fragment,e),_(Mt.$$.fragment,e),_(Ge.$$.fragment,e),_(Tt.$$.fragment,e),_(At.$$.fragment,e),_(Gt.$$.fragment,e),_(Dt.$$.fragment,e),_(Ct.$$.fragment,e),_(ke.$$.fragment,e),_(kt.$$.fragment,e),_(Lt.$$.fragment,e),_(St.$$.fragment,e),_(Ut.$$.fragment,e),_(jt.$$.fragment,e),_(Nt.$$.fragment,e),_(Jt.$$.fragment,e),_($t.$$.fragment,e),_(Ne.$$.fragment,e),_(Xt.$$.fragment,e),_(Je.$$.fragment,e),_(zt.$$.fragment,e),_(Zt.$$.fragment,e),_(Wt.$$.fragment,e),_(Bt.$$.fragment,e),_(Rt.$$.fragment,e),_(ze.$$.fragment,e),_(Ft.$$.fragment,e),_(Et.$$.fragment,e),_(Vt.$$.fragment,e),_(Ot.$$.fragment,e),_(Ht.$$.fragment,e),_(Be.$$.fragment,e),_(qt.$$.fragment,e),_(Yt.$$.fragment,e),_(Qt.$$.fragment,e),_(Kt.$$.fragment,e),_(en.$$.fragment,e),_(Ee.$$.fragment,e),_(tn.$$.fragment,e),_(nn.$$.fragment,e),_(on.$$.fragment,e),_(an.$$.fragment,e),_(sn.$$.fragment,e),_(He.$$.fragment,e),_(rn.$$.fragment,e),_(ln.$$.fragment,e),_(dn.$$.fragment,e),_(pn.$$.fragment,e),_(cn.$$.fragment,e),_(Qe.$$.fragment,e),_(mn.$$.fragment,e),_(fn.$$.fragment,e),_(gn.$$.fragment,e),_(un.$$.fragment,e),_(et.$$.fragment,e),_(_n.$$.fragment,e),_(hn.$$.fragment,e),_(bn.$$.fragment,e),_(vn.$$.fragment,e),_(tt.$$.fragment,e),_(Pn.$$.fragment,e),_(xn.$$.fragment,e),Qi=!1},d(e){e&&(r(M),r(v),r(d),r(n),r(x),r(_i),r(at),r(hi),r(st),r(bi),r(rt),r(vi),r(lt),r(Pi),r(dt),r(xi),r(wi),r(yi),r(j),r(Ii),r(Mi),r(W),r(Ti),r(Ai),r(G),r(Gi),r(Di),r(D),r(Ci),r(ki),r(C),r(Li),r(Si),r(N),r(Ui),r(ji),r(A),r(Ni),r(Ji),r(k),r($i),r(Xi),r(L),r(zi),r(Zi),r(S),r(Wi),r(Bi),r(U),r(Ri),r(Fi),r(J),r(Ei),r(Vi),r(K),r(Oi),r(Hi),r(ee),r(qi),r(Yi),r(ui)),r(l),h(P,e),h(Pe,e),h(pt,e),h(ct),h(mt),h(xe),h(ft),h(gt,e),h(ut),h(_t),h(ye),h(ht),h(bt,e),h(vt),h(Pt),h(Me),h(xt),h(wt),h(yt,e),h(It),h(Mt),h(Ge),h(Tt),h(At),h(Gt,e),h(Dt),h(Ct),h(ke),h(kt),h(Lt),h(St,e),h(Ut),h(jt),h(Nt),h(Jt,e),h($t),h(Ne),h(Xt),h(Je),h(zt),h(Zt),h(Wt,e),h(Bt),h(Rt),h(ze),h(Ft),h(Et),h(Vt,e),h(Ot),h(Ht),h(Be),h(qt),h(Yt),h(Qt,e),h(Kt),h(en),h(Ee),h(tn),h(nn),h(on,e),h(an),h(sn),h(He),h(rn),h(ln),h(dn,e),h(pn),h(cn),h(Qe),h(mn),h(fn,e),h(gn),h(un),h(et),h(_n),h(hn,e),h(bn),h(vn),h(tt),h(Pn),h(xn,e)}}}const Vd='{"title":"Perturbed-Attention Guidance","local":"perturbed-attention-guidance","sections":[{"title":"AnimateDiffPAGPipeline","local":"diffusers.AnimateDiffPAGPipeline","sections":[],"depth":2},{"title":"HunyuanDiTPAGPipeline","local":"diffusers.HunyuanDiTPAGPipeline","sections":[],"depth":2},{"title":"KolorsPAGPipeline","local":"diffusers.KolorsPAGPipeline","sections":[],"depth":2},{"title":"StableDiffusionPAGPipeline","local":"diffusers.StableDiffusionPAGPipeline","sections":[],"depth":2},{"title":"StableDiffusionPAGImg2ImgPipeline","local":"diffusers.StableDiffusionPAGImg2ImgPipeline","sections":[],"depth":2},{"title":"StableDiffusionControlNetPAGPipeline","local":"diffusers.StableDiffusionControlNetPAGPipeline","sections":[],"depth":2},{"title":"StableDiffusionControlNetPAGInpaintPipeline","local":"diffusers.StableDiffusionControlNetPAGInpaintPipeline","sections":[],"depth":2},{"title":"StableDiffusionXLPAGPipeline","local":"diffusers.StableDiffusionXLPAGPipeline","sections":[],"depth":2},{"title":"StableDiffusionXLPAGImg2ImgPipeline","local":"diffusers.StableDiffusionXLPAGImg2ImgPipeline","sections":[],"depth":2},{"title":"StableDiffusionXLPAGInpaintPipeline","local":"diffusers.StableDiffusionXLPAGInpaintPipeline","sections":[],"depth":2},{"title":"StableDiffusionXLControlNetPAGPipeline","local":"diffusers.StableDiffusionXLControlNetPAGPipeline","sections":[],"depth":2},{"title":"StableDiffusionXLControlNetPAGImg2ImgPipeline","local":"diffusers.StableDiffusionXLControlNetPAGImg2ImgPipeline","sections":[],"depth":2},{"title":"StableDiffusion3PAGPipeline","local":"diffusers.StableDiffusion3PAGPipeline","sections":[],"depth":2},{"title":"PixArtSigmaPAGPipeline","local":"diffusers.PixArtSigmaPAGPipeline","sections":[],"depth":2}],"depth":1}';function Od(T){return Td(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class np extends Ad{constructor(l){super(),Gd(this,l,Od,Ed,Md,{})}}export{np as component};
