import{s as $o,o as Xo,n as Ot}from"../chunks/scheduler.8c3d61f6.js";import{S as Zo,i as Io,g as a,s as i,r as m,A as ko,h as l,f as o,c as s,j as C,u,x as c,k as U,y as r,a as n,v as g,d as f,t as h,w as _}from"../chunks/index.da70eac4.js";import{T as Go}from"../chunks/Tip.1d9b8c37.js";import{D as j}from"../chunks/Docstring.ee4b6913.js";import{C as qe}from"../chunks/CodeBlock.00a903b3.js";import{E as jo}from"../chunks/ExampleCodeBlock.f7bd2c1f.js";import{H as Ue,E as Wo}from"../chunks/EditOnGithub.1e64e623.js";function Po(k){let p,J='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers.md">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading.md#reuse-a-pipeline">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){p=a("p"),p.innerHTML=J},l(v){p=l(v,"P",{"data-svelte-h":!0}),c(p)!=="svelte-w7r39y"&&(p.innerHTML=J)},m(v,b){n(v,p,b)},p:Ot,d(v){v&&o(p)}}}function Bo(k){let p,J="Examples:",v,b,T;return b=new qe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQ29nVmlkZW9YUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBJTIzJTIwTW9kZWxzJTNBJTIwJTIyVEhVRE0lMkZDb2dWaWRlb1gtMmIlMjIlMjBvciUyMCUyMlRIVURNJTJGQ29nVmlkZW9YLTViJTIyJTBBcGlwZSUyMCUzRCUyMENvZ1ZpZGVvWFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJUSFVETSUyRkNvZ1ZpZGVvWC0yYiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEFwcm9tcHQlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwJTIyQSUyMHBhbmRhJTJDJTIwZHJlc3NlZCUyMGluJTIwYSUyMHNtYWxsJTJDJTIwcmVkJTIwamFja2V0JTIwYW5kJTIwYSUyMHRpbnklMjBoYXQlMkMlMjBzaXRzJTIwb24lMjBhJTIwd29vZGVuJTIwc3Rvb2wlMjBpbiUyMGElMjBzZXJlbmUlMjBiYW1ib28lMjBmb3Jlc3QuJTIwJTIyJTBBJTIwJTIwJTIwJTIwJTIyVGhlJTIwcGFuZGEncyUyMGZsdWZmeSUyMHBhd3MlMjBzdHJ1bSUyMGElMjBtaW5pYXR1cmUlMjBhY291c3RpYyUyMGd1aXRhciUyQyUyMHByb2R1Y2luZyUyMHNvZnQlMkMlMjBtZWxvZGljJTIwdHVuZXMuJTIwTmVhcmJ5JTJDJTIwYSUyMGZldyUyMG90aGVyJTIwJTIyJTBBJTIwJTIwJTIwJTIwJTIycGFuZGFzJTIwZ2F0aGVyJTJDJTIwd2F0Y2hpbmclMjBjdXJpb3VzbHklMjBhbmQlMjBzb21lJTIwY2xhcHBpbmclMjBpbiUyMHJoeXRobS4lMjBTdW5saWdodCUyMGZpbHRlcnMlMjB0aHJvdWdoJTIwdGhlJTIwdGFsbCUyMGJhbWJvbyUyQyUyMCUyMiUwQSUyMCUyMCUyMCUyMCUyMmNhc3RpbmclMjBhJTIwZ2VudGxlJTIwZ2xvdyUyMG9uJTIwdGhlJTIwc2NlbmUuJTIwVGhlJTIwcGFuZGEncyUyMGZhY2UlMjBpcyUyMGV4cHJlc3NpdmUlMkMlMjBzaG93aW5nJTIwY29uY2VudHJhdGlvbiUyMGFuZCUyMGpveSUyMGFzJTIwaXQlMjBwbGF5cy4lMjAlMjIlMEElMjAlMjAlMjAlMjAlMjJUaGUlMjBiYWNrZ3JvdW5kJTIwaW5jbHVkZXMlMjBhJTIwc21hbGwlMkMlMjBmbG93aW5nJTIwc3RyZWFtJTIwYW5kJTIwdmlicmFudCUyMGdyZWVuJTIwZm9saWFnZSUyQyUyMGVuaGFuY2luZyUyMHRoZSUyMHBlYWNlZnVsJTIwYW5kJTIwbWFnaWNhbCUyMCUyMiUwQSUyMCUyMCUyMCUyMCUyMmF0bW9zcGhlcmUlMjBvZiUyMHRoaXMlMjB1bmlxdWUlMjBtdXNpY2FsJTIwcGVyZm9ybWFuY2UuJTIyJTBBKSUwQXZpZGVvJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDYlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmZyYW1lcyU1QjAlNUQlMEFleHBvcnRfdG9fdmlkZW8odmlkZW8lMkMlMjAlMjJvdXRwdXQubXA0JTIyJTJDJTIwZnBzJTNEOCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> CogVideoXPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Models: &quot;THUDM/CogVideoX-2b&quot; or &quot;THUDM/CogVideoX-5b&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = CogVideoXPipeline.from_pretrained(<span class="hljs-string">&quot;THUDM/CogVideoX-2b&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A panda, dressed in a small, red jacket and a tiny hat, sits on a wooden stool in a serene bamboo forest. &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;The panda&#x27;s fluffy paws strum a miniature acoustic guitar, producing soft, melodic tunes. Nearby, a few other &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;pandas gather, watching curiously and some clapping in rhythm. Sunlight filters through the tall bamboo, &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;casting a gentle glow on the scene. The panda&#x27;s face is expressive, showing concentration and joy as it plays. &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;The background includes a small, flowing stream and vibrant green foliage, enhancing the peaceful and magical &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;atmosphere of this unique musical performance.&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>video = pipe(prompt=prompt, guidance_scale=<span class="hljs-number">6</span>, num_inference_steps=<span class="hljs-number">50</span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">8</span>)`,wrap:!1}}),{c(){p=a("p"),p.textContent=J,v=i(),m(b.$$.fragment)},l(d){p=l(d,"P",{"data-svelte-h":!0}),c(p)!=="svelte-kvfsh7"&&(p.textContent=J),v=s(d),u(b.$$.fragment,d)},m(d,V){n(d,p,V),n(d,v,V),g(b,d,V),T=!0},p:Ot,i(d){T||(f(b.$$.fragment,d),T=!0)},o(d){h(b.$$.fragment,d),T=!1},d(d){d&&(o(p),o(v)),_(b,d)}}}function zo(k){let p,J="Examples:",v,b,T;return b=new qe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQ29nVmlkZW9YRFBNU2NoZWR1bGVyJTJDJTIwQ29nVmlkZW9YVmlkZW9Ub1ZpZGVvUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTJDJTIwbG9hZF92aWRlbyUwQSUwQSUyMyUyME1vZGVscyUzQSUyMCUyMlRIVURNJTJGQ29nVmlkZW9YLTJiJTIyJTIwb3IlMjAlMjJUSFVETSUyRkNvZ1ZpZGVvWC01YiUyMiUwQXBpcGUlMjAlM0QlMjBDb2dWaWRlb1hWaWRlb1RvVmlkZW9QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyVEhVRE0lMkZDb2dWaWRlb1gtNWIlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KSUwQXBpcGUudG8oJTIyY3VkYSUyMiklMEFwaXBlLnNjaGVkdWxlciUyMCUzRCUyMENvZ1ZpZGVvWERQTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcpJTBBJTBBaW5wdXRfdmlkZW8lMjAlM0QlMjBsb2FkX3ZpZGVvKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmhpa2VyLm1wNCUyMiUwQSklMEFwcm9tcHQlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwJTIyQW4lMjBhc3Ryb25hdXQlMjBzdGFuZHMlMjB0cml1bXBoYW50bHklMjBhdCUyMHRoZSUyMHBlYWslMjBvZiUyMGElMjB0b3dlcmluZyUyMG1vdW50YWluLiUyMFBhbm9yYW1hJTIwb2YlMjBydWdnZWQlMjBwZWFrcyUyMGFuZCUyMCUyMiUwQSUyMCUyMCUyMCUyMCUyMnZhbGxleXMuJTIwVmVyeSUyMGZ1dHVyaXN0aWMlMjB2aWJlJTIwYW5kJTIwYW5pbWF0ZWQlMjBhZXN0aGV0aWMuJTIwSGlnaGxpZ2h0cyUyMG9mJTIwcHVycGxlJTIwYW5kJTIwZ29sZGVuJTIwY29sb3JzJTIwaW4lMjAlMjIlMEElMjAlMjAlMjAlMjAlMjJ0aGUlMjBzY2VuZS4lMjBUaGUlMjBza3klMjBpcyUyMGxvb2tzJTIwbGlrZSUyMGFuJTIwYW5pbWF0ZWQlMkZjYXJ0b29uaXNoJTIwZHJlYW0lMjBvZiUyMGdhbGF4aWVzJTJDJTIwbmVidWxhZSUyQyUyMHN0YXJzJTJDJTIwcGxhbmV0cyUyQyUyMCUyMiUwQSUyMCUyMCUyMCUyMCUyMm1vb25zJTJDJTIwYnV0JTIwdGhlJTIwcmVtYWluZGVyJTIwb2YlMjB0aGUlMjBzY2VuZSUyMGlzJTIwbW9zdGx5JTIwcmVhbGlzdGljLiUyMiUwQSklMEElMEF2aWRlbyUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwdmlkZW8lM0RpbnB1dF92aWRlbyUyQyUyMHByb21wdCUzRHByb21wdCUyQyUyMHN0cmVuZ3RoJTNEMC44JTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q2JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTBBKS5mcmFtZXMlNUIwJTVEJTBBZXhwb3J0X3RvX3ZpZGVvKHZpZGVvJTJDJTIwJTIyb3V0cHV0Lm1wNCUyMiUyQyUyMGZwcyUzRDgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> CogVideoXDPMScheduler, CogVideoXVideoToVideoPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video, load_video

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Models: &quot;THUDM/CogVideoX-2b&quot; or &quot;THUDM/CogVideoX-5b&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = CogVideoXVideoToVideoPipeline.from_pretrained(<span class="hljs-string">&quot;THUDM/CogVideoX-5b&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = CogVideoXDPMScheduler.from_config(pipe.scheduler.config)

<span class="hljs-meta">&gt;&gt;&gt; </span>input_video = load_video(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/hiker.mp4&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;An astronaut stands triumphantly at the peak of a towering mountain. Panorama of rugged peaks and &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;valleys. Very futuristic vibe and animated aesthetic. Highlights of purple and golden colors in &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;the scene. The sky is looks like an animated/cartoonish dream of galaxies, nebulae, stars, planets, &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;moons, but the remainder of the scene is mostly realistic.&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>video = pipe(
<span class="hljs-meta">... </span>    video=input_video, prompt=prompt, strength=<span class="hljs-number">0.8</span>, guidance_scale=<span class="hljs-number">6</span>, num_inference_steps=<span class="hljs-number">50</span>
<span class="hljs-meta">... </span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">8</span>)`,wrap:!1}}),{c(){p=a("p"),p.textContent=J,v=i(),m(b.$$.fragment)},l(d){p=l(d,"P",{"data-svelte-h":!0}),c(p)!=="svelte-kvfsh7"&&(p.textContent=J),v=s(d),u(b.$$.fragment,d)},m(d,V){n(d,p,V),n(d,v,V),g(b,d,V),T=!0},p:Ot,i(d){T||(f(b.$$.fragment,d),T=!0)},o(d){h(b.$$.fragment,d),T=!1},d(d){d&&(o(p),o(v)),_(b,d)}}}function Ho(k){let p,J,v,b,T,d,V,Kt='<a href="https://arxiv.org/abs/2408.06072" rel="nofollow">CogVideoX: Text-to-Video Diffusion Models with An Expert Transformer</a> from Tsinghua University &amp; ZhipuAI, by Zhuoyi Yang, Jiayan Teng, Wendi Zheng, Ming Ding, Shiyu Huang, Jiazheng Xu, Yuanming Yang, Wenyi Hong, Xiaohan Zhang, Guanyu Feng, Da Yin, Xiaotao Gu, Yuxuan Zhang, Weihan Wang, Yean Cheng, Ting Liu, Bin Xu, Yuxiao Dong, Jie Tang.',Re,L,eo="The abstract from the paper is:",De,R,to='<em>We introduce CogVideoX, a large-scale diffusion transformer model designed for generating videos based on text prompts. To efficently model video data, we propose to levearge a 3D Variational Autoencoder (VAE) to compresses videos along both spatial and temporal dimensions. To improve the text-video alignment, we propose an expert transformer with the expert adaptive LayerNorm to facilitate the deep fusion between the two modalities. By employing a progressive training technique, CogVideoX is adept at producing coherent, long-duration videos characterized by significant motion. In addition, we develop an effectively text-video data processing pipeline that includes various data preprocessing strategies and a video captioning method. It significantly helps enhance the performance of CogVideoX, improving both generation quality and semantic alignment. Results show that CogVideoX demonstrates state-of-the-art performance across both multiple machine metrics and human evaluations. The model weight of CogVideoX-2B is publicly available at <a href="https://github.com/THUDM/CogVideo" rel="nofollow">https://github.com/THUDM/CogVideo</a>.</em>',Ee,G,Fe,D,oo='This pipeline was contributed by <a href="https://github.com/zRzRzRzRzRzRzR" rel="nofollow">zRzRzRzRzRzRzR</a>. The original codebase can be found <a href="https://huggingface.co/THUDM" rel="nofollow">here</a>. The original weights can be found under <a href="https://huggingface.co/THUDM" rel="nofollow">hf.co/THUDM</a>.',Se,E,no="There are two models available that can be used with the CogVideoX pipeline:",Qe,F,io='<li><a href="https://huggingface.co/THUDM/CogVideoX-2b" rel="nofollow"><code>THUDM/CogVideoX-2b</code></a></li> <li><a href="https://huggingface.co/THUDM/CogVideoX-5b" rel="nofollow"><code>THUDM/CogVideoX-5b</code></a></li>',Ae,S,Oe,Q,so='Use <a href="https://huggingface.co/docs/diffusers/main/en/tutorials/fast_diffusion#torchcompile" rel="nofollow"><code>torch.compile</code></a> to reduce the inference latency.',Ke,A,ao="First, load the pipeline:",et,O,tt,K,lo="Then change the memory layout of the pipelines <code>transformer</code> component to <code>torch.channels_last</code>:",ot,ee,nt,te,ro="Finally, compile the components and run inference:",it,oe,st,ne,po='The <a href="https://gist.github.com/a-r-r-o-w/5183d75e452a368fd17448fcc810bd3f" rel="nofollow">benchmark</a> results on an 80GB A100 machine are:',at,ie,lt,se,rt,ae,co='CogVideoX-2b requires about 19 GB of GPU memory to decode 49 frames (6 seconds of video at 8 FPS) with output resolution 720x480 (W x H), which makes it not possible to run on consumer GPUs or free-tier T4 Colab. The following memory optimizations could be used to reduce the memory footprint. For replication, you can refer to <a href="https://gist.github.com/a-r-r-o-w/3959a03f15be5c9bd1fe545b09dfcc93" rel="nofollow">this</a> script.',dt,le,mo="<li><code>pipe.enable_model_cpu_offload()</code>:<ul><li>Without enabling cpu offloading, memory usage is <code>33 GB</code></li> <li>With enabling cpu offloading, memory usage is <code>19 GB</code></li></ul></li> <li><code>pipe.enable_sequential_cpu_offload()</code>:<ul><li>Similar to <code>enable_model_cpu_offload</code> but can significantly reduce memory usage at the cost of slow inference</li> <li>When enabled, memory usage is under <code>4 GB</code></li></ul></li> <li><code>pipe.vae.enable_tiling()</code>:<ul><li>With enabling cpu offloading and tiling, memory usage is <code>11 GB</code></li></ul></li> <li><code>pipe.vae.enable_slicing()</code></li>",pt,re,ct,de,uo='<a href="https://github.com/pytorch/ao" rel="nofollow">torchao</a> and <a href="https://github.com/huggingface/optimum-quanto/" rel="nofollow">optimum-quanto</a> can be used to quantize the text encoder, transformer and VAE modules to lower the memory requirements. This makes it possible to run the model on a free-tier T4 Colab or lower VRAM GPUs!',mt,pe,go='It is also worth noting that torchao quantization is fully compatible with <a href="/optimization/torch2.0#torchcompile">torch.compile</a>, which allows for much faster inference speed. Additionally, models can be serialized and stored in a quantized datatype to save disk space with torchao. Find examples and benchmarks in the gists below.',ut,ce,fo='<li><a href="https://gist.github.com/a-r-r-o-w/4d9732d17412888c885480c6521a9897" rel="nofollow">torchao</a></li> <li><a href="https://gist.github.com/a-r-r-o-w/31be62828b00a9292821b85c1017effa" rel="nofollow">quanto</a></li>',gt,me,ft,w,ue,jt,je,ho="Pipeline for text-to-video generation using CogVideoX.",$t,$e,_o=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Xt,$,ge,Zt,Xe,bo="Function invoked when calling the pipeline for generation.",It,W,kt,P,fe,Gt,Ze,vo="Encodes the prompt into text encoder hidden states.",Wt,B,he,Pt,Ie,wo="Enables fused QKV projections.",Bt,z,_e,zt,ke,yo="Disable QKV projection fusion if enabled.",ht,be,_t,y,ve,Ht,Ge,To="Pipeline for video-to-video generation using CogVideoX.",Nt,We,Mo=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Yt,X,we,qt,Pe,Vo="Function invoked when calling the pipeline for generation.",Lt,H,Rt,N,ye,Dt,Be,xo="Encodes the prompt into text encoder hidden states.",Et,Y,Te,Ft,ze,Jo="Enables fused QKV projections.",St,q,Me,Qt,He,Co="Disable QKV projection fusion if enabled.",bt,Ve,vt,Z,xe,At,Ne,Uo="Output class for CogVideo pipelines.",wt,Je,yt,Le,Tt;return T=new Ue({props:{title:"CogVideoX",local:"cogvideox",headingTag:"h1"}}),G=new Go({props:{$$slots:{default:[Po]},$$scope:{ctx:k}}}),S=new Ue({props:{title:"Inference",local:"inference",headingTag:"h2"}}),O=new qe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQ29nVmlkZW9YUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMENvZ1ZpZGVvWFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJUSFVETSUyRkNvZ1ZpZGVvWC0yYiUyMikudG8oJTIyY3VkYSUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> CogVideoXPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

pipe = CogVideoXPipeline.from_pretrained(<span class="hljs-string">&quot;THUDM/CogVideoX-2b&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),ee=new qe({props:{code:"cGlwZS50cmFuc2Zvcm1lci50byhtZW1vcnlfZm9ybWF0JTNEdG9yY2guY2hhbm5lbHNfbGFzdCk=",highlighted:"pipe.transformer.to(memory_format=torch.channels_last)",wrap:!1}}),oe=new qe({props:{code:"cGlwZS50cmFuc2Zvcm1lciUyMCUzRCUyMHRvcmNoLmNvbXBpbGUocGlwZWxpbmUudHJhbnNmb3JtZXIlMkMlMjBtb2RlJTNEJTIybWF4LWF1dG90dW5lJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSklMEElMEElMjMlMjBDb2dWaWRlb1glMjB3b3JrcyUyMHdlbGwlMjB3aXRoJTIwbG9uZyUyMGFuZCUyMHdlbGwtZGVzY3JpYmVkJTIwcHJvbXB0cyUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBwYW5kYSUyQyUyMGRyZXNzZWQlMjBpbiUyMGElMjBzbWFsbCUyQyUyMHJlZCUyMGphY2tldCUyMGFuZCUyMGElMjB0aW55JTIwaGF0JTJDJTIwc2l0cyUyMG9uJTIwYSUyMHdvb2RlbiUyMHN0b29sJTIwaW4lMjBhJTIwc2VyZW5lJTIwYmFtYm9vJTIwZm9yZXN0LiUyMFRoZSUyMHBhbmRhJ3MlMjBmbHVmZnklMjBwYXdzJTIwc3RydW0lMjBhJTIwbWluaWF0dXJlJTIwYWNvdXN0aWMlMjBndWl0YXIlMkMlMjBwcm9kdWNpbmclMjBzb2Z0JTJDJTIwbWVsb2RpYyUyMHR1bmVzLiUyME5lYXJieSUyQyUyMGElMjBmZXclMjBvdGhlciUyMHBhbmRhcyUyMGdhdGhlciUyQyUyMHdhdGNoaW5nJTIwY3VyaW91c2x5JTIwYW5kJTIwc29tZSUyMGNsYXBwaW5nJTIwaW4lMjByaHl0aG0uJTIwU3VubGlnaHQlMjBmaWx0ZXJzJTIwdGhyb3VnaCUyMHRoZSUyMHRhbGwlMjBiYW1ib28lMkMlMjBjYXN0aW5nJTIwYSUyMGdlbnRsZSUyMGdsb3clMjBvbiUyMHRoZSUyMHNjZW5lLiUyMFRoZSUyMHBhbmRhJ3MlMjBmYWNlJTIwaXMlMjBleHByZXNzaXZlJTJDJTIwc2hvd2luZyUyMGNvbmNlbnRyYXRpb24lMjBhbmQlMjBqb3klMjBhcyUyMGl0JTIwcGxheXMuJTIwVGhlJTIwYmFja2dyb3VuZCUyMGluY2x1ZGVzJTIwYSUyMHNtYWxsJTJDJTIwZmxvd2luZyUyMHN0cmVhbSUyMGFuZCUyMHZpYnJhbnQlMjBncmVlbiUyMGZvbGlhZ2UlMkMlMjBlbmhhbmNpbmclMjB0aGUlMjBwZWFjZWZ1bCUyMGFuZCUyMG1hZ2ljYWwlMjBhdG1vc3BoZXJlJTIwb2YlMjB0aGlzJTIwdW5pcXVlJTIwbXVzaWNhbCUyMHBlcmZvcm1hbmNlLiUyMiUwQXZpZGVvJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDYlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmZyYW1lcyU1QjAlNUQ=",highlighted:`pipe.transformer = torch.<span class="hljs-built_in">compile</span>(pipeline.transformer, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># CogVideoX works well with long and well-described prompts</span>
prompt = <span class="hljs-string">&quot;A panda, dressed in a small, red jacket and a tiny hat, sits on a wooden stool in a serene bamboo forest. The panda&#x27;s fluffy paws strum a miniature acoustic guitar, producing soft, melodic tunes. Nearby, a few other pandas gather, watching curiously and some clapping in rhythm. Sunlight filters through the tall bamboo, casting a gentle glow on the scene. The panda&#x27;s face is expressive, showing concentration and joy as it plays. The background includes a small, flowing stream and vibrant green foliage, enhancing the peaceful and magical atmosphere of this unique musical performance.&quot;</span>
video = pipe(prompt=prompt, guidance_scale=<span class="hljs-number">6</span>, num_inference_steps=<span class="hljs-number">50</span>).frames[<span class="hljs-number">0</span>]`,wrap:!1}}),ie=new qe({props:{code:"V2l0aG91dCUyMHRvcmNoLmNvbXBpbGUoKSUzQSUyMEF2ZXJhZ2UlMjBpbmZlcmVuY2UlMjB0aW1lJTNBJTIwOTYuODklMjBzZWNvbmRzLiUwQVdpdGglMjB0b3JjaC5jb21waWxlKCklM0ElMjBBdmVyYWdlJTIwaW5mZXJlbmNlJTIwdGltZSUzQSUyMDc2LjI3JTIwc2Vjb25kcy4=",highlighted:`<span class="hljs-attribute">Without</span> torch.compile(): Average inference time: <span class="hljs-number">96</span>.<span class="hljs-number">89</span> seconds.
<span class="hljs-attribute">With</span> torch.compile(): Average inference time: <span class="hljs-number">76</span>.<span class="hljs-number">27</span> seconds.`,wrap:!1}}),se=new Ue({props:{title:"Memory optimization",local:"memory-optimization",headingTag:"h3"}}),re=new Ue({props:{title:"Quantized inference",local:"quantized-inference",headingTag:"h3"}}),me=new Ue({props:{title:"CogVideoXPipeline",local:"diffusers.CogVideoXPipeline",headingTag:"h2"}}),ue=new j({props:{name:"class diffusers.CogVideoXPipeline",anchor:"diffusers.CogVideoXPipeline",parameters:[{name:"tokenizer",val:": T5Tokenizer"},{name:"text_encoder",val:": T5EncoderModel"},{name:"vae",val:": AutoencoderKLCogVideoX"},{name:"transformer",val:": CogVideoXTransformer3DModel"},{name:"scheduler",val:": Union"}],parametersDescription:[{anchor:"diffusers.CogVideoXPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"},{anchor:"diffusers.CogVideoXPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
Frozen text-encoder. CogVideoX uses
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>; specifically the
<a href="https://huggingface.co/PixArt-alpha/PixArt-alpha/tree/main/t5-v1_1-xxl" rel="nofollow">t5-v1_1-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.CogVideoXPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5Tokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.CogVideoXPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/cogvideox_transformer3d#diffusers.CogVideoXTransformer3DModel">CogVideoXTransformer3DModel</a>) &#x2014;
A text conditioned <code>CogVideoXTransformer3DModel</code> to denoise the encoded video latents.`,name:"transformer"},{anchor:"diffusers.CogVideoXPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded video latents.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox.py#L139"}}),ge=new j({props:{name:"__call__",anchor:"diffusers.CogVideoXPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"negative_prompt",val:": Union = None"},{name:"height",val:": int = 480"},{name:"width",val:": int = 720"},{name:"num_frames",val:": int = 49"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": Optional = None"},{name:"guidance_scale",val:": float = 6"},{name:"use_dynamic_cfg",val:": bool = False"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback_on_step_end",val:": Union = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"max_sequence_length",val:": int = 226"}],parametersDescription:[{anchor:"diffusers.CogVideoXPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.CogVideoXPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.CogVideoXPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"diffusers.CogVideoXPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"diffusers.CogVideoXPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>48</code>) &#x2014;
Number of frames to generate. Must be divisible by self.vae_scale_factor_temporal. Generated video will
contain 1 extra frame because CogVideoX is conditioned with (num_seconds * fps + 1) frames where
num_seconds is 6 and fps is 4. However, since videos can be saved at any fps, the only condition that
needs to be satisfied is that of divisibility mentioned above.`,name:"num_frames"},{anchor:"diffusers.CogVideoXPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.CogVideoXPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.CogVideoXPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.CogVideoXPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of videos to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.CogVideoXPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.CogVideoXPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.CogVideoXPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.CogVideoXPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.CogVideoXPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.CogVideoXPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.CogVideoXPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.CogVideoXPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.CogVideoXPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code>, defaults to <code>226</code>) &#x2014;
Maximum sequence length in encoded prompt. Must be consistent with
<code>self.transformer.config.max_text_seq_length</code> otherwise may lead to poor results.`,name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox.py#L469",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/cogvideox#diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput"
>CogVideoXPipelineOutput</a> if <code>return_dict</code> is True, otherwise a
<code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/cogvideox#diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput"
>CogVideoXPipelineOutput</a> or <code>tuple</code></p>
`}}),W=new jo({props:{anchor:"diffusers.CogVideoXPipeline.__call__.example",$$slots:{default:[Bo]},$$scope:{ctx:k}}}),fe=new j({props:{name:"encode_prompt",anchor:"diffusers.CogVideoXPipeline.encode_prompt",parameters:[{name:"prompt",val:": Union"},{name:"negative_prompt",val:": Union = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"max_sequence_length",val:": int = 226"},{name:"device",val:": Optional = None"},{name:"dtype",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.CogVideoXPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.CogVideoXPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.CogVideoXPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.CogVideoXPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.CogVideoXPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.CogVideoXPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.
device &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device
dtype &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"negative_prompt_embeds"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox.py#L235"}}),he=new j({props:{name:"fuse_qkv_projections",anchor:"diffusers.CogVideoXPipeline.fuse_qkv_projections",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox.py#L418"}}),_e=new j({props:{name:"unfuse_qkv_projections",anchor:"diffusers.CogVideoXPipeline.unfuse_qkv_projections",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox.py#L423"}}),be=new Ue({props:{title:"CogVideoXVideoToVideoPipeline",local:"diffusers.CogVideoXVideoToVideoPipeline",headingTag:"h2"}}),ve=new j({props:{name:"class diffusers.CogVideoXVideoToVideoPipeline",anchor:"diffusers.CogVideoXVideoToVideoPipeline",parameters:[{name:"tokenizer",val:": T5Tokenizer"},{name:"text_encoder",val:": T5EncoderModel"},{name:"vae",val:": AutoencoderKLCogVideoX"},{name:"transformer",val:": CogVideoXTransformer3DModel"},{name:"scheduler",val:": Union"}],parametersDescription:[{anchor:"diffusers.CogVideoXVideoToVideoPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
Frozen text-encoder. CogVideoX uses
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>; specifically the
<a href="https://huggingface.co/PixArt-alpha/PixArt-alpha/tree/main/t5-v1_1-xxl" rel="nofollow">t5-v1_1-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5Tokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/cogvideox_transformer3d#diffusers.CogVideoXTransformer3DModel">CogVideoXTransformer3DModel</a>) &#x2014;
A text conditioned <code>CogVideoXTransformer3DModel</code> to denoise the encoded video latents.`,name:"transformer"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded video latents.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_video2video.py#L164"}}),we=new j({props:{name:"__call__",anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__",parameters:[{name:"video",val:": List = None"},{name:"prompt",val:": Union = None"},{name:"negative_prompt",val:": Union = None"},{name:"height",val:": int = 480"},{name:"width",val:": int = 720"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": Optional = None"},{name:"strength",val:": float = 0.8"},{name:"guidance_scale",val:": float = 6"},{name:"use_dynamic_cfg",val:": bool = False"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback_on_step_end",val:": Union = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"max_sequence_length",val:": int = 226"}],parametersDescription:[{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.video",description:`<strong>video</strong> (<code>List[PIL.Image.Image]</code>) &#x2014;
The input video to condition the generation on. Must be a list of images/frames of the video.`,name:"video"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
Higher strength leads to more differences between original video and generated video.`,name:"strength"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of videos to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code>, defaults to <code>226</code>) &#x2014;
Maximum sequence length in encoded prompt. Must be consistent with
<code>self.transformer.config.max_text_seq_length</code> otherwise may lead to poor results.`,name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_video2video.py#L548",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/cogvideox#diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput"
>CogVideoXPipelineOutput</a> if <code>return_dict</code> is True, otherwise a
<code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/cogvideox#diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput"
>CogVideoXPipelineOutput</a> or <code>tuple</code></p>
`}}),H=new jo({props:{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.example",$$slots:{default:[zo]},$$scope:{ctx:k}}}),ye=new j({props:{name:"encode_prompt",anchor:"diffusers.CogVideoXVideoToVideoPipeline.encode_prompt",parameters:[{name:"prompt",val:": Union"},{name:"negative_prompt",val:": Union = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"max_sequence_length",val:": int = 226"},{name:"device",val:": Optional = None"},{name:"dtype",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.CogVideoXVideoToVideoPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.
device &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device
dtype &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"negative_prompt_embeds"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_video2video.py#L262"}}),Te=new j({props:{name:"fuse_qkv_projections",anchor:"diffusers.CogVideoXVideoToVideoPipeline.fuse_qkv_projections",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_video2video.py#L495"}}),Me=new j({props:{name:"unfuse_qkv_projections",anchor:"diffusers.CogVideoXVideoToVideoPipeline.unfuse_qkv_projections",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_video2video.py#L501"}}),Ve=new Ue({props:{title:"CogVideoXPipelineOutput",local:"diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput",headingTag:"h2"}}),xe=new j({props:{name:"class diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput",anchor:"diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput",parameters:[{name:"frames",val:": Tensor"}],parametersDescription:[{anchor:"diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput.frames",description:`<strong>frames</strong> (<code>torch.Tensor</code>, <code>np.ndarray</code>, or List[List[PIL.Image.Image]]) &#x2014;
List of video outputs - It can be a nested list of length <code>batch_size,</code> with each sub-list containing
denoised PIL image sequences of length <code>num_frames.</code> It can also be a NumPy array or Torch tensor of shape
<code>(batch_size, num_frames, channels, height, width)</code>.`,name:"frames"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_output.py#L8"}}),Je=new Wo({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/cogvideox.md"}}),{c(){p=a("meta"),J=i(),v=a("p"),b=i(),m(T.$$.fragment),d=i(),V=a("p"),V.innerHTML=Kt,Re=i(),L=a("p"),L.textContent=eo,De=i(),R=a("p"),R.innerHTML=to,Ee=i(),m(G.$$.fragment),Fe=i(),D=a("p"),D.innerHTML=oo,Se=i(),E=a("p"),E.textContent=no,Qe=i(),F=a("ul"),F.innerHTML=io,Ae=i(),m(S.$$.fragment),Oe=i(),Q=a("p"),Q.innerHTML=so,Ke=i(),A=a("p"),A.textContent=ao,et=i(),m(O.$$.fragment),tt=i(),K=a("p"),K.innerHTML=lo,ot=i(),m(ee.$$.fragment),nt=i(),te=a("p"),te.textContent=ro,it=i(),m(oe.$$.fragment),st=i(),ne=a("p"),ne.innerHTML=po,at=i(),m(ie.$$.fragment),lt=i(),m(se.$$.fragment),rt=i(),ae=a("p"),ae.innerHTML=co,dt=i(),le=a("ul"),le.innerHTML=mo,pt=i(),m(re.$$.fragment),ct=i(),de=a("p"),de.innerHTML=uo,mt=i(),pe=a("p"),pe.innerHTML=go,ut=i(),ce=a("ul"),ce.innerHTML=fo,gt=i(),m(me.$$.fragment),ft=i(),w=a("div"),m(ue.$$.fragment),jt=i(),je=a("p"),je.textContent=ho,$t=i(),$e=a("p"),$e.innerHTML=_o,Xt=i(),$=a("div"),m(ge.$$.fragment),Zt=i(),Xe=a("p"),Xe.textContent=bo,It=i(),m(W.$$.fragment),kt=i(),P=a("div"),m(fe.$$.fragment),Gt=i(),Ze=a("p"),Ze.textContent=vo,Wt=i(),B=a("div"),m(he.$$.fragment),Pt=i(),Ie=a("p"),Ie.textContent=wo,Bt=i(),z=a("div"),m(_e.$$.fragment),zt=i(),ke=a("p"),ke.textContent=yo,ht=i(),m(be.$$.fragment),_t=i(),y=a("div"),m(ve.$$.fragment),Ht=i(),Ge=a("p"),Ge.textContent=To,Nt=i(),We=a("p"),We.innerHTML=Mo,Yt=i(),X=a("div"),m(we.$$.fragment),qt=i(),Pe=a("p"),Pe.textContent=Vo,Lt=i(),m(H.$$.fragment),Rt=i(),N=a("div"),m(ye.$$.fragment),Dt=i(),Be=a("p"),Be.textContent=xo,Et=i(),Y=a("div"),m(Te.$$.fragment),Ft=i(),ze=a("p"),ze.textContent=Jo,St=i(),q=a("div"),m(Me.$$.fragment),Qt=i(),He=a("p"),He.textContent=Co,bt=i(),m(Ve.$$.fragment),vt=i(),Z=a("div"),m(xe.$$.fragment),At=i(),Ne=a("p"),Ne.textContent=Uo,wt=i(),m(Je.$$.fragment),yt=i(),Le=a("p"),this.h()},l(e){const t=ko("svelte-u9bgzb",document.head);p=l(t,"META",{name:!0,content:!0}),t.forEach(o),J=s(e),v=l(e,"P",{}),C(v).forEach(o),b=s(e),u(T.$$.fragment,e),d=s(e),V=l(e,"P",{"data-svelte-h":!0}),c(V)!=="svelte-1jx3rme"&&(V.innerHTML=Kt),Re=s(e),L=l(e,"P",{"data-svelte-h":!0}),c(L)!=="svelte-1cwsb16"&&(L.textContent=eo),De=s(e),R=l(e,"P",{"data-svelte-h":!0}),c(R)!=="svelte-19oae4l"&&(R.innerHTML=to),Ee=s(e),u(G.$$.fragment,e),Fe=s(e),D=l(e,"P",{"data-svelte-h":!0}),c(D)!=="svelte-14a2tju"&&(D.innerHTML=oo),Se=s(e),E=l(e,"P",{"data-svelte-h":!0}),c(E)!=="svelte-n3pqk3"&&(E.textContent=no),Qe=s(e),F=l(e,"UL",{"data-svelte-h":!0}),c(F)!=="svelte-1sqd7ay"&&(F.innerHTML=io),Ae=s(e),u(S.$$.fragment,e),Oe=s(e),Q=l(e,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-iekg51"&&(Q.innerHTML=so),Ke=s(e),A=l(e,"P",{"data-svelte-h":!0}),c(A)!=="svelte-jub7f1"&&(A.textContent=ao),et=s(e),u(O.$$.fragment,e),tt=s(e),K=l(e,"P",{"data-svelte-h":!0}),c(K)!=="svelte-1p91erm"&&(K.innerHTML=lo),ot=s(e),u(ee.$$.fragment,e),nt=s(e),te=l(e,"P",{"data-svelte-h":!0}),c(te)!=="svelte-9i4prs"&&(te.textContent=ro),it=s(e),u(oe.$$.fragment,e),st=s(e),ne=l(e,"P",{"data-svelte-h":!0}),c(ne)!=="svelte-1brnakn"&&(ne.innerHTML=po),at=s(e),u(ie.$$.fragment,e),lt=s(e),u(se.$$.fragment,e),rt=s(e),ae=l(e,"P",{"data-svelte-h":!0}),c(ae)!=="svelte-1wycjro"&&(ae.innerHTML=co),dt=s(e),le=l(e,"UL",{"data-svelte-h":!0}),c(le)!=="svelte-195dfo2"&&(le.innerHTML=mo),pt=s(e),u(re.$$.fragment,e),ct=s(e),de=l(e,"P",{"data-svelte-h":!0}),c(de)!=="svelte-1elq2ob"&&(de.innerHTML=uo),mt=s(e),pe=l(e,"P",{"data-svelte-h":!0}),c(pe)!=="svelte-9tb0fb"&&(pe.innerHTML=go),ut=s(e),ce=l(e,"UL",{"data-svelte-h":!0}),c(ce)!=="svelte-190pde7"&&(ce.innerHTML=fo),gt=s(e),u(me.$$.fragment,e),ft=s(e),w=l(e,"DIV",{class:!0});var M=C(w);u(ue.$$.fragment,M),jt=s(M),je=l(M,"P",{"data-svelte-h":!0}),c(je)!=="svelte-gmblkq"&&(je.textContent=ho),$t=s(M),$e=l(M,"P",{"data-svelte-h":!0}),c($e)!=="svelte-wu1jmh"&&($e.innerHTML=_o),Xt=s(M),$=l(M,"DIV",{class:!0});var I=C($);u(ge.$$.fragment,I),Zt=s(I),Xe=l(I,"P",{"data-svelte-h":!0}),c(Xe)!=="svelte-v78lg8"&&(Xe.textContent=bo),It=s(I),u(W.$$.fragment,I),I.forEach(o),kt=s(M),P=l(M,"DIV",{class:!0});var Ce=C(P);u(fe.$$.fragment,Ce),Gt=s(Ce),Ze=l(Ce,"P",{"data-svelte-h":!0}),c(Ze)!=="svelte-16q0ax1"&&(Ze.textContent=vo),Ce.forEach(o),Wt=s(M),B=l(M,"DIV",{class:!0});var Mt=C(B);u(he.$$.fragment,Mt),Pt=s(Mt),Ie=l(Mt,"P",{"data-svelte-h":!0}),c(Ie)!=="svelte-1vadzv1"&&(Ie.textContent=wo),Mt.forEach(o),Bt=s(M),z=l(M,"DIV",{class:!0});var Vt=C(z);u(_e.$$.fragment,Vt),zt=s(Vt),ke=l(Vt,"P",{"data-svelte-h":!0}),c(ke)!=="svelte-fohozp"&&(ke.textContent=yo),Vt.forEach(o),M.forEach(o),ht=s(e),u(be.$$.fragment,e),_t=s(e),y=l(e,"DIV",{class:!0});var x=C(y);u(ve.$$.fragment,x),Ht=s(x),Ge=l(x,"P",{"data-svelte-h":!0}),c(Ge)!=="svelte-4lf8uk"&&(Ge.textContent=To),Nt=s(x),We=l(x,"P",{"data-svelte-h":!0}),c(We)!=="svelte-wu1jmh"&&(We.innerHTML=Mo),Yt=s(x),X=l(x,"DIV",{class:!0});var Ye=C(X);u(we.$$.fragment,Ye),qt=s(Ye),Pe=l(Ye,"P",{"data-svelte-h":!0}),c(Pe)!=="svelte-v78lg8"&&(Pe.textContent=Vo),Lt=s(Ye),u(H.$$.fragment,Ye),Ye.forEach(o),Rt=s(x),N=l(x,"DIV",{class:!0});var xt=C(N);u(ye.$$.fragment,xt),Dt=s(xt),Be=l(xt,"P",{"data-svelte-h":!0}),c(Be)!=="svelte-16q0ax1"&&(Be.textContent=xo),xt.forEach(o),Et=s(x),Y=l(x,"DIV",{class:!0});var Jt=C(Y);u(Te.$$.fragment,Jt),Ft=s(Jt),ze=l(Jt,"P",{"data-svelte-h":!0}),c(ze)!=="svelte-1vadzv1"&&(ze.textContent=Jo),Jt.forEach(o),St=s(x),q=l(x,"DIV",{class:!0});var Ct=C(q);u(Me.$$.fragment,Ct),Qt=s(Ct),He=l(Ct,"P",{"data-svelte-h":!0}),c(He)!=="svelte-fohozp"&&(He.textContent=Co),Ct.forEach(o),x.forEach(o),bt=s(e),u(Ve.$$.fragment,e),vt=s(e),Z=l(e,"DIV",{class:!0});var Ut=C(Z);u(xe.$$.fragment,Ut),At=s(Ut),Ne=l(Ut,"P",{"data-svelte-h":!0}),c(Ne)!=="svelte-1qnvsrt"&&(Ne.textContent=Uo),Ut.forEach(o),wt=s(e),u(Je.$$.fragment,e),yt=s(e),Le=l(e,"P",{}),C(Le).forEach(o),this.h()},h(){U(p,"name","hf:doc:metadata"),U(p,"content",No),U($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){r(document.head,p),n(e,J,t),n(e,v,t),n(e,b,t),g(T,e,t),n(e,d,t),n(e,V,t),n(e,Re,t),n(e,L,t),n(e,De,t),n(e,R,t),n(e,Ee,t),g(G,e,t),n(e,Fe,t),n(e,D,t),n(e,Se,t),n(e,E,t),n(e,Qe,t),n(e,F,t),n(e,Ae,t),g(S,e,t),n(e,Oe,t),n(e,Q,t),n(e,Ke,t),n(e,A,t),n(e,et,t),g(O,e,t),n(e,tt,t),n(e,K,t),n(e,ot,t),g(ee,e,t),n(e,nt,t),n(e,te,t),n(e,it,t),g(oe,e,t),n(e,st,t),n(e,ne,t),n(e,at,t),g(ie,e,t),n(e,lt,t),g(se,e,t),n(e,rt,t),n(e,ae,t),n(e,dt,t),n(e,le,t),n(e,pt,t),g(re,e,t),n(e,ct,t),n(e,de,t),n(e,mt,t),n(e,pe,t),n(e,ut,t),n(e,ce,t),n(e,gt,t),g(me,e,t),n(e,ft,t),n(e,w,t),g(ue,w,null),r(w,jt),r(w,je),r(w,$t),r(w,$e),r(w,Xt),r(w,$),g(ge,$,null),r($,Zt),r($,Xe),r($,It),g(W,$,null),r(w,kt),r(w,P),g(fe,P,null),r(P,Gt),r(P,Ze),r(w,Wt),r(w,B),g(he,B,null),r(B,Pt),r(B,Ie),r(w,Bt),r(w,z),g(_e,z,null),r(z,zt),r(z,ke),n(e,ht,t),g(be,e,t),n(e,_t,t),n(e,y,t),g(ve,y,null),r(y,Ht),r(y,Ge),r(y,Nt),r(y,We),r(y,Yt),r(y,X),g(we,X,null),r(X,qt),r(X,Pe),r(X,Lt),g(H,X,null),r(y,Rt),r(y,N),g(ye,N,null),r(N,Dt),r(N,Be),r(y,Et),r(y,Y),g(Te,Y,null),r(Y,Ft),r(Y,ze),r(y,St),r(y,q),g(Me,q,null),r(q,Qt),r(q,He),n(e,bt,t),g(Ve,e,t),n(e,vt,t),n(e,Z,t),g(xe,Z,null),r(Z,At),r(Z,Ne),n(e,wt,t),g(Je,e,t),n(e,yt,t),n(e,Le,t),Tt=!0},p(e,[t]){const M={};t&2&&(M.$$scope={dirty:t,ctx:e}),G.$set(M);const I={};t&2&&(I.$$scope={dirty:t,ctx:e}),W.$set(I);const Ce={};t&2&&(Ce.$$scope={dirty:t,ctx:e}),H.$set(Ce)},i(e){Tt||(f(T.$$.fragment,e),f(G.$$.fragment,e),f(S.$$.fragment,e),f(O.$$.fragment,e),f(ee.$$.fragment,e),f(oe.$$.fragment,e),f(ie.$$.fragment,e),f(se.$$.fragment,e),f(re.$$.fragment,e),f(me.$$.fragment,e),f(ue.$$.fragment,e),f(ge.$$.fragment,e),f(W.$$.fragment,e),f(fe.$$.fragment,e),f(he.$$.fragment,e),f(_e.$$.fragment,e),f(be.$$.fragment,e),f(ve.$$.fragment,e),f(we.$$.fragment,e),f(H.$$.fragment,e),f(ye.$$.fragment,e),f(Te.$$.fragment,e),f(Me.$$.fragment,e),f(Ve.$$.fragment,e),f(xe.$$.fragment,e),f(Je.$$.fragment,e),Tt=!0)},o(e){h(T.$$.fragment,e),h(G.$$.fragment,e),h(S.$$.fragment,e),h(O.$$.fragment,e),h(ee.$$.fragment,e),h(oe.$$.fragment,e),h(ie.$$.fragment,e),h(se.$$.fragment,e),h(re.$$.fragment,e),h(me.$$.fragment,e),h(ue.$$.fragment,e),h(ge.$$.fragment,e),h(W.$$.fragment,e),h(fe.$$.fragment,e),h(he.$$.fragment,e),h(_e.$$.fragment,e),h(be.$$.fragment,e),h(ve.$$.fragment,e),h(we.$$.fragment,e),h(H.$$.fragment,e),h(ye.$$.fragment,e),h(Te.$$.fragment,e),h(Me.$$.fragment,e),h(Ve.$$.fragment,e),h(xe.$$.fragment,e),h(Je.$$.fragment,e),Tt=!1},d(e){e&&(o(J),o(v),o(b),o(d),o(V),o(Re),o(L),o(De),o(R),o(Ee),o(Fe),o(D),o(Se),o(E),o(Qe),o(F),o(Ae),o(Oe),o(Q),o(Ke),o(A),o(et),o(tt),o(K),o(ot),o(nt),o(te),o(it),o(st),o(ne),o(at),o(lt),o(rt),o(ae),o(dt),o(le),o(pt),o(ct),o(de),o(mt),o(pe),o(ut),o(ce),o(gt),o(ft),o(w),o(ht),o(_t),o(y),o(bt),o(vt),o(Z),o(wt),o(yt),o(Le)),o(p),_(T,e),_(G,e),_(S,e),_(O,e),_(ee,e),_(oe,e),_(ie,e),_(se,e),_(re,e),_(me,e),_(ue),_(ge),_(W),_(fe),_(he),_(_e),_(be,e),_(ve),_(we),_(H),_(ye),_(Te),_(Me),_(Ve,e),_(xe),_(Je,e)}}}const No='{"title":"CogVideoX","local":"cogvideox","sections":[{"title":"Inference","local":"inference","sections":[{"title":"Memory optimization","local":"memory-optimization","sections":[],"depth":3},{"title":"Quantized inference","local":"quantized-inference","sections":[],"depth":3}],"depth":2},{"title":"CogVideoXPipeline","local":"diffusers.CogVideoXPipeline","sections":[],"depth":2},{"title":"CogVideoXVideoToVideoPipeline","local":"diffusers.CogVideoXVideoToVideoPipeline","sections":[],"depth":2},{"title":"CogVideoXPipelineOutput","local":"diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput","sections":[],"depth":2}],"depth":1}';function Yo(k){return Xo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Qo extends Zo{constructor(p){super(),Io(this,p,Yo,Ho,$o,{})}}export{Qo as component};
