import{s as dt,n as wt,o as Tt}from"../chunks/scheduler.25b97de1.js";import{S as Jt,i as ht,g as i,s as n,r as p,A as Ut,h as o,f as s,c as a,j as ct,u as y,x as M,k as mt,y as ut,a as l,v as r,d as c,t as m,w as d}from"../chunks/index.d9030fc9.js";import{C as se}from"../chunks/CodeBlock.e6cd0d95.js";import{H as T,E as ft}from"../chunks/EditOnGithub.91d95064.js";function jt(xe){let w,le,ee,ne,J,ae,h,Ye='The <a href="https://github.com/huggingface/transformers" rel="nofollow">🤗 Transformers</a> library offers a collection of pre-trained models and tools for natural language processing, vision, and beyond. While these models cover a wide range of applications, you might encounter use cases that aren’t supported out of the box. Customizing models can unlock new possibilities, such as adding new layers, altering architectures, or optimizing attention mechanisms. This guide will show you how to modify existing Transformers models to fit your specific needs. The great thing is, you don’t have to step away from the Transformers framework to make these changes. You can actually modify models directly in Transformers and still take advantage of features like the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer" rel="nofollow">Trainer API</a>, <a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel" rel="nofollow">PreTrainedModel</a>, and efficient fine-tuning with tools like <a href="https://huggingface.co/docs/peft/index" rel="nofollow">PEFT</a>.',ie,U,ze="In this guide, we’ll walk you through how to customize existing Transformers models to meet your requirements—without losing the benefits of the ecosystem.",oe,u,qe="You’ll learn how to:",Me,f,Le="<li>Modify a model’s architecture by changing its attention mechanism.</li> <li>Apply techniques like Low-Rank Adaptation (LoRA) to specific model components.</li>",pe,j,Ee="We encourage you to contribute your own hacks and share them here with the community1",ye,C,re,I,Fe="The <strong>Segment Anything Model (SAM)</strong> is a state-of-the-art model for image segmentation. In its default implementation, SAM uses a combined query-key-value (<code>qkv</code>) projection in its attention mechanism. However, you might want to fine-tune only specific components of the attention mechanism, such as the query (<code>q</code>) and value (<code>v</code>) projections, to reduce the number of trainable parameters and computational resources required.",ce,b,me,g,De="By splitting the combined <code>qkv</code> projection into separate <code>q</code>, <code>k</code>, and <code>v</code> projections, you can apply techniques like <strong>LoRA</strong> (Low-Rank Adaptation) to only the <code>q</code> and <code>v</code> projections. This approach allows you to:",de,k,Pe="<li>Fine-tune fewer parameters, reducing computational overhead.</li> <li>Potentially achieve better performance by focusing on specific components.</li> <li>Experiment with different adaptation strategies in the attention mechanism.</li>",we,Z,Te,_,Je,B,Ke="Next, subclass the original <code>SamVisionAttention</code> class and modify it to have separate <code>q</code>, <code>k</code>, and <code>v</code> projections.",he,v,Ue,W,Oe="<strong>Explanation:</strong>",ue,G,et="<li><strong>Separate Projections:</strong> The combined <code>qkv</code> projection is removed, and separate <code>q</code>, <code>k</code>, and <code>v</code> linear layers are created.</li> <li><strong>Weight Loading Hook:</strong> The <code>_split_qkv_load_hook</code> method splits the pre-trained <code>qkv</code> weights into separate <code>q</code>, <code>k</code>, and <code>v</code> weights when loading the model. This ensures compatibility with any pre-trained model.</li> <li><strong>Forward Pass:</strong> Queries, keys, and values are computed separately, and the attention mechanism proceeds as usual.</li>",fe,R,je,A,tt="Replace the original <code>SamVisionAttention</code> class with your custom class so that the model uses the modified attention mechanism.",Ce,X,Ie,S,st="<strong>Explanation:</strong>",be,H,lt="<li><strong>Class Replacement:</strong> By assigning your custom class to <code>modeling_sam.SamVisionAttention</code>, any instances of <code>SamVisionAttention</code> in the model will use the modified version. Thus when you call <code>SamModel</code>, it will use the newly defined <code>SamVisionAttentionSplit</code>.</li> <li><strong>Model Loading:</strong> The model is loaded using <code>from_pretrained</code>, and the custom attention mechanism is integrated.</li>",ge,$,ke,Q,nt="With separate <code>q</code>, <code>k</code>, and <code>v</code> projections, you can now apply LoRA to specific components, such as the <code>q</code> and <code>v</code> projections.",Ze,V,_e,N,at="<strong>Explanation:</strong>",Be,x,it="<li><strong>LoRA Configuration:</strong> The <code>LoraConfig</code> specifies the rank <code>r</code>, scaling factor <code>lora_alpha</code>, target modules (<code>&quot;q&quot;</code> and <code>&quot;v&quot;</code>), dropout, and task type.</li> <li><strong>Applying LoRA:</strong> The <code>get_peft_model</code> function applies LoRA to the specified modules in the model.</li> <li><strong>Parameter Reduction:</strong> By focusing on <code>q</code> and <code>v</code>, you reduce the number of trainable parameters, leading to faster training and lower memory usage.</li>",ve,Y,We,z,ot="It’s simple to verify the number of trainable parameters and see what impact your modification had.",Ge,q,Re,L,Mt="<strong>Expected Output:</strong>",Ae,E,Xe,F,Se,D,pt="Modifying pre-trained models can open up new avenues for research and application. By understanding and adjusting the internal mechanisms of models like SAM, you can tailor them to your specific needs, optimize performance, and experiment with new ideas.",He,P,yt="If you’ve developed your own hacks for Transformers models and would like to share them, consider contributing to this doc.",$e,K,rt="<li><strong>Open a Pull Request:</strong> Share your code changes and improvements directly in the repository.</li> <li><strong>Write Documentation:</strong> Provide clear explanations and examples of your modifications.</li> <li><strong>Engage with the Community:</strong> Discuss your ideas and get feedback from other developers and researchers by opening an issue.</li>",Qe,O,Ve,te,Ne;return J=new T({props:{title:"How to Hack Any Transformers Model",local:"how-to-hack-any-transformers-model",headingTag:"h1"}}),C=new T({props:{title:"Example: Modifying the Attention Mechanism in the Segment Anything Model (SAM)",local:"example-modifying-the-attention-mechanism-in-the-segment-anything-model-sam",headingTag:"h2"}}),b=new T({props:{title:"Motivation",local:"motivation",headingTag:"h3"}}),Z=new T({props:{title:"Implementation",local:"implementation",headingTag:"h3"}}),_=new T({props:{title:"Step 1: Create a Custom Attention Class",local:"step-1-create-a-custom-attention-class",headingTag:"h4"}}),v=new se({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-keyword">from</span> transformers.models.sam.modeling_sam <span class="hljs-keyword">import</span> SamVisionAttention

<span class="hljs-keyword">class</span> <span class="hljs-title class_">SamVisionAttentionSplit</span>(SamVisionAttention, nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config, window_size</span>):
        <span class="hljs-built_in">super</span>().__init__(config, window_size)
        <span class="hljs-keyword">del</span> self.qkv
        <span class="hljs-comment"># Separate q, k, v projections</span>
        self.q = nn.Linear(config.hidden_size, config.hidden_size, bias=config.qkv_bias)
        self.k = nn.Linear(config.hidden_size, config.hidden_size, bias=config.qkv_bias)
        self.v = nn.Linear(config.hidden_size, config.hidden_size, bias=config.qkv_bias)
        self._register_load_state_dict_pre_hook(self.split_q_k_v_load_hook)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">split_q_k_v_load_hook</span>(<span class="hljs-params">self, state_dict, prefix, *args</span>):
        keys_to_delete = []
        <span class="hljs-keyword">for</span> key <span class="hljs-keyword">in</span> <span class="hljs-built_in">list</span>(state_dict.keys()):
            <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;qkv.&quot;</span> <span class="hljs-keyword">in</span> key:
                <span class="hljs-comment"># Split q, k, v from the combined projection</span>
                q, k, v = state_dict[key].chunk(<span class="hljs-number">3</span>, dim=<span class="hljs-number">0</span>)
                <span class="hljs-comment"># Replace with individual q, k, v projections</span>
                state_dict[key.replace(<span class="hljs-string">&quot;qkv.&quot;</span>, <span class="hljs-string">&quot;q.&quot;</span>)] = q
                state_dict[key.replace(<span class="hljs-string">&quot;qkv.&quot;</span>, <span class="hljs-string">&quot;k.&quot;</span>)] = k
                state_dict[key.replace(<span class="hljs-string">&quot;qkv.&quot;</span>, <span class="hljs-string">&quot;v.&quot;</span>)] = v
                <span class="hljs-comment"># Mark the old qkv key for deletion</span>
                keys_to_delete.append(key)
        
        <span class="hljs-comment"># Remove old qkv keys</span>
        <span class="hljs-keyword">for</span> key <span class="hljs-keyword">in</span> keys_to_delete:
            <span class="hljs-keyword">del</span> state_dict[key]

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, hidden_states: torch.Tensor, output_attentions=<span class="hljs-literal">False</span></span>) -&gt; torch.Tensor:
        batch_size, height, width, _ = hidden_states.shape
        qkv_shapes = (batch_size *  self.num_attention_heads,  height * width, -<span class="hljs-number">1</span>)
        query = self.q(hidden_states).reshape((batch_size,  height * width,self.num_attention_heads, -<span class="hljs-number">1</span>)).permute(<span class="hljs-number">0</span>,<span class="hljs-number">2</span>,<span class="hljs-number">1</span>,<span class="hljs-number">3</span>).reshape(qkv_shapes)
        key = self.k(hidden_states).reshape((batch_size,  height * width,self.num_attention_heads, -<span class="hljs-number">1</span>)).permute(<span class="hljs-number">0</span>,<span class="hljs-number">2</span>,<span class="hljs-number">1</span>,<span class="hljs-number">3</span>).reshape(qkv_shapes)
        value = self.v(hidden_states).reshape((batch_size,  height * width,self.num_attention_heads, -<span class="hljs-number">1</span>)).permute(<span class="hljs-number">0</span>,<span class="hljs-number">2</span>,<span class="hljs-number">1</span>,<span class="hljs-number">3</span>).reshape(qkv_shapes)

        attn_weights = (query * self.scale) @ key.transpose(-<span class="hljs-number">2</span>, -<span class="hljs-number">1</span>)

        <span class="hljs-keyword">if</span> self.use_rel_pos:
            attn_weights = self.add_decomposed_rel_pos(
                attn_weights, query, self.rel_pos_h, self.rel_pos_w, (height, width), (height, width)
            )

        attn_weights = torch.nn.functional.softmax(attn_weights, dtype=torch.float32, dim=-<span class="hljs-number">1</span>).to(query.dtype)
        attn_probs = nn.functional.dropout(attn_weights, p=self.dropout, training=self.training)
        attn_output = (attn_probs @ value).reshape(batch_size, self.num_attention_heads, height, width, -<span class="hljs-number">1</span>)
        attn_output = attn_output.permute(<span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>, <span class="hljs-number">4</span>).reshape(batch_size, height, width, -<span class="hljs-number">1</span>)
        attn_output = self.proj(attn_output)

        <span class="hljs-keyword">if</span> output_attentions:
            outputs = (attn_output, attn_weights)
        <span class="hljs-keyword">else</span>:
            outputs = (attn_output, <span class="hljs-literal">None</span>)
        <span class="hljs-keyword">return</span> outputs`,wrap:!1}}),R=new T({props:{title:"Step 2: Replace the Original Attention Class",local:"step-2-replace-the-original-attention-class",headingTag:"h4"}}),X=new se({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNhbU1vZGVsJTBBZnJvbSUyMHRyYW5zZm9ybWVycy5tb2RlbHMuc2FtJTIwaW1wb3J0JTIwbW9kZWxpbmdfc2FtJTBBJTBBJTIzJTIwUmVwbGFjZSUyMHRoZSUyMGF0dGVudGlvbiUyMGNsYXNzJTIwaW4lMjB0aGUlMjBtb2RlbGluZ19zYW0lMjBtb2R1bGUlMEFtb2RlbGluZ19zYW0uU2FtVmlzaW9uQXR0ZW50aW9uJTIwJTNEJTIwU2FtVmlzaW9uQXR0ZW50aW9uU3BsaXQlMEElMEElMjMlMjBMb2FkJTIwdGhlJTIwcHJlLXRyYWluZWQlMjBTQU0lMjBtb2RlbCUwQW1vZGVsJTIwJTNEJTIwU2FtTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGc2FtLXZpdC1iYXNlJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SamModel
<span class="hljs-keyword">from</span> transformers.models.sam <span class="hljs-keyword">import</span> modeling_sam

<span class="hljs-comment"># Replace the attention class in the modeling_sam module</span>
modeling_sam.SamVisionAttention = SamVisionAttentionSplit

<span class="hljs-comment"># Load the pre-trained SAM model</span>
model = SamModel.from_pretrained(<span class="hljs-string">&quot;facebook/sam-vit-base&quot;</span>)`,wrap:!1}}),$=new T({props:{title:"Step 3: Apply LoRA to Specific Projections",local:"step-3-apply-lora-to-specific-projections",headingTag:"h4"}}),V=new se({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFjb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0QzMiUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycSUyMiUyQyUyMCUyMnYlMjIlNUQlMkMlMjAlMjAlMjMlMjBBcHBseSUyMExvUkElMjB0byUyMHElMjBhbmQlMjB2JTIwcHJvamVjdGlvbnMlMEElMjAlMjAlMjAlMjBsb3JhX2Ryb3BvdXQlM0QwLjElMkMlMEElMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0QlMjJtYXNrLWdlbmVyYXRpb24lMjIlMEEpJTBBJTBBJTIzJTIwQXBwbHklMjBMb1JBJTIwdG8lMjB0aGUlMjBtb2RlbCUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBjb25maWcp",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model

config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    target_modules=[<span class="hljs-string">&quot;q&quot;</span>, <span class="hljs-string">&quot;v&quot;</span>],  <span class="hljs-comment"># Apply LoRA to q and v projections</span>
    lora_dropout=<span class="hljs-number">0.1</span>,
    task_type=<span class="hljs-string">&quot;mask-generation&quot;</span>
)

<span class="hljs-comment"># Apply LoRA to the model</span>
model = get_peft_model(model, config)`,wrap:!1}}),Y=new T({props:{title:"Step 4: Verify the Number of Trainable Parameters",local:"step-4-verify-the-number-of-trainable-parameters",headingTag:"h4"}}),q=new se({props:{code:"bW9kZWwucHJpbnRfdHJhaW5hYmxlX3BhcmFtZXRlcnMoKQ==",highlighted:"model.print_trainable_parameters()",wrap:!1}}),E=new se({props:{code:"dHJhaW5hYmxlJTIwcGFyYW1zJTNBJTIwNjA4JTJDMjU2JTIwJTdDJTdDJTIwYWxsJTIwcGFyYW1zJTNBJTIwOTQlMkMzNDMlMkM3MjglMjAlN0MlN0MlMjB0cmFpbmFibGUlMjUlM0ElMjAwLjY0NDclMEF0cmFpbmFibGUlMjBwYXJhbXMlM0ElMjA5MTIlMkMzODQlMjAlN0MlN0MlMjBhbGwlMjBwYXJhbXMlM0ElMjA5NCUyQzY0NyUyQzg1NiUyMCU3QyU3QyUyMHRyYWluYWJsZSUyNSUzQSUyMDAuOTY0MCUyMCUyMyUyMHdpdGglMjBrJTIw",highlighted:`<span class="hljs-attribute">trainable</span> params: <span class="hljs-number">608</span>,<span class="hljs-number">256</span> || <span class="hljs-literal">all</span> params: <span class="hljs-number">94</span>,<span class="hljs-number">343</span>,<span class="hljs-number">728</span> || trainable%: <span class="hljs-number">0</span>.<span class="hljs-number">6447</span>
<span class="hljs-attribute">trainable</span> params: <span class="hljs-number">912</span>,<span class="hljs-number">384</span> || <span class="hljs-literal">all</span> params: <span class="hljs-number">94</span>,<span class="hljs-number">647</span>,<span class="hljs-number">856</span> || trainable%: <span class="hljs-number">0</span>.<span class="hljs-number">9640</span> # with k `,wrap:!1}}),F=new T({props:{title:"Contributing Your Own Hacks",local:"contributing-your-own-hacks",headingTag:"h2"}}),O=new ft({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/how_to_hack_models.md"}}),{c(){w=i("meta"),le=n(),ee=i("p"),ne=n(),p(J.$$.fragment),ae=n(),h=i("p"),h.innerHTML=Ye,ie=n(),U=i("p"),U.textContent=ze,oe=n(),u=i("p"),u.textContent=qe,Me=n(),f=i("ul"),f.innerHTML=Le,pe=n(),j=i("p"),j.textContent=Ee,ye=n(),p(C.$$.fragment),re=n(),I=i("p"),I.innerHTML=Fe,ce=n(),p(b.$$.fragment),me=n(),g=i("p"),g.innerHTML=De,de=n(),k=i("ul"),k.innerHTML=Pe,we=n(),p(Z.$$.fragment),Te=n(),p(_.$$.fragment),Je=n(),B=i("p"),B.innerHTML=Ke,he=n(),p(v.$$.fragment),Ue=n(),W=i("p"),W.innerHTML=Oe,ue=n(),G=i("ul"),G.innerHTML=et,fe=n(),p(R.$$.fragment),je=n(),A=i("p"),A.innerHTML=tt,Ce=n(),p(X.$$.fragment),Ie=n(),S=i("p"),S.innerHTML=st,be=n(),H=i("ul"),H.innerHTML=lt,ge=n(),p($.$$.fragment),ke=n(),Q=i("p"),Q.innerHTML=nt,Ze=n(),p(V.$$.fragment),_e=n(),N=i("p"),N.innerHTML=at,Be=n(),x=i("ul"),x.innerHTML=it,ve=n(),p(Y.$$.fragment),We=n(),z=i("p"),z.textContent=ot,Ge=n(),p(q.$$.fragment),Re=n(),L=i("p"),L.innerHTML=Mt,Ae=n(),p(E.$$.fragment),Xe=n(),p(F.$$.fragment),Se=n(),D=i("p"),D.textContent=pt,He=n(),P=i("p"),P.textContent=yt,$e=n(),K=i("ul"),K.innerHTML=rt,Qe=n(),p(O.$$.fragment),Ve=n(),te=i("p"),this.h()},l(e){const t=Ut("svelte-u9bgzb",document.head);w=o(t,"META",{name:!0,content:!0}),t.forEach(s),le=a(e),ee=o(e,"P",{}),ct(ee).forEach(s),ne=a(e),y(J.$$.fragment,e),ae=a(e),h=o(e,"P",{"data-svelte-h":!0}),M(h)!=="svelte-4p0w22"&&(h.innerHTML=Ye),ie=a(e),U=o(e,"P",{"data-svelte-h":!0}),M(U)!=="svelte-1kaw87e"&&(U.textContent=ze),oe=a(e),u=o(e,"P",{"data-svelte-h":!0}),M(u)!=="svelte-16olrhx"&&(u.textContent=qe),Me=a(e),f=o(e,"UL",{"data-svelte-h":!0}),M(f)!=="svelte-1219jh3"&&(f.innerHTML=Le),pe=a(e),j=o(e,"P",{"data-svelte-h":!0}),M(j)!=="svelte-1fl0iuo"&&(j.textContent=Ee),ye=a(e),y(C.$$.fragment,e),re=a(e),I=o(e,"P",{"data-svelte-h":!0}),M(I)!=="svelte-pqt08"&&(I.innerHTML=Fe),ce=a(e),y(b.$$.fragment,e),me=a(e),g=o(e,"P",{"data-svelte-h":!0}),M(g)!=="svelte-1fee5zh"&&(g.innerHTML=De),de=a(e),k=o(e,"UL",{"data-svelte-h":!0}),M(k)!=="svelte-ajxk4v"&&(k.innerHTML=Pe),we=a(e),y(Z.$$.fragment,e),Te=a(e),y(_.$$.fragment,e),Je=a(e),B=o(e,"P",{"data-svelte-h":!0}),M(B)!=="svelte-183kvjr"&&(B.innerHTML=Ke),he=a(e),y(v.$$.fragment,e),Ue=a(e),W=o(e,"P",{"data-svelte-h":!0}),M(W)!=="svelte-qcx91s"&&(W.innerHTML=Oe),ue=a(e),G=o(e,"UL",{"data-svelte-h":!0}),M(G)!=="svelte-17qbtt1"&&(G.innerHTML=et),fe=a(e),y(R.$$.fragment,e),je=a(e),A=o(e,"P",{"data-svelte-h":!0}),M(A)!=="svelte-sp0tsy"&&(A.innerHTML=tt),Ce=a(e),y(X.$$.fragment,e),Ie=a(e),S=o(e,"P",{"data-svelte-h":!0}),M(S)!=="svelte-qcx91s"&&(S.innerHTML=st),be=a(e),H=o(e,"UL",{"data-svelte-h":!0}),M(H)!=="svelte-1qee5e9"&&(H.innerHTML=lt),ge=a(e),y($.$$.fragment,e),ke=a(e),Q=o(e,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-14bh2vd"&&(Q.innerHTML=nt),Ze=a(e),y(V.$$.fragment,e),_e=a(e),N=o(e,"P",{"data-svelte-h":!0}),M(N)!=="svelte-qcx91s"&&(N.innerHTML=at),Be=a(e),x=o(e,"UL",{"data-svelte-h":!0}),M(x)!=="svelte-ampkeh"&&(x.innerHTML=it),ve=a(e),y(Y.$$.fragment,e),We=a(e),z=o(e,"P",{"data-svelte-h":!0}),M(z)!=="svelte-a867g8"&&(z.textContent=ot),Ge=a(e),y(q.$$.fragment,e),Re=a(e),L=o(e,"P",{"data-svelte-h":!0}),M(L)!=="svelte-cry7xq"&&(L.innerHTML=Mt),Ae=a(e),y(E.$$.fragment,e),Xe=a(e),y(F.$$.fragment,e),Se=a(e),D=o(e,"P",{"data-svelte-h":!0}),M(D)!=="svelte-1rmqfnq"&&(D.textContent=pt),He=a(e),P=o(e,"P",{"data-svelte-h":!0}),M(P)!=="svelte-1vdc3k7"&&(P.textContent=yt),$e=a(e),K=o(e,"UL",{"data-svelte-h":!0}),M(K)!=="svelte-1934g57"&&(K.innerHTML=rt),Qe=a(e),y(O.$$.fragment,e),Ve=a(e),te=o(e,"P",{}),ct(te).forEach(s),this.h()},h(){mt(w,"name","hf:doc:metadata"),mt(w,"content",Ct)},m(e,t){ut(document.head,w),l(e,le,t),l(e,ee,t),l(e,ne,t),r(J,e,t),l(e,ae,t),l(e,h,t),l(e,ie,t),l(e,U,t),l(e,oe,t),l(e,u,t),l(e,Me,t),l(e,f,t),l(e,pe,t),l(e,j,t),l(e,ye,t),r(C,e,t),l(e,re,t),l(e,I,t),l(e,ce,t),r(b,e,t),l(e,me,t),l(e,g,t),l(e,de,t),l(e,k,t),l(e,we,t),r(Z,e,t),l(e,Te,t),r(_,e,t),l(e,Je,t),l(e,B,t),l(e,he,t),r(v,e,t),l(e,Ue,t),l(e,W,t),l(e,ue,t),l(e,G,t),l(e,fe,t),r(R,e,t),l(e,je,t),l(e,A,t),l(e,Ce,t),r(X,e,t),l(e,Ie,t),l(e,S,t),l(e,be,t),l(e,H,t),l(e,ge,t),r($,e,t),l(e,ke,t),l(e,Q,t),l(e,Ze,t),r(V,e,t),l(e,_e,t),l(e,N,t),l(e,Be,t),l(e,x,t),l(e,ve,t),r(Y,e,t),l(e,We,t),l(e,z,t),l(e,Ge,t),r(q,e,t),l(e,Re,t),l(e,L,t),l(e,Ae,t),r(E,e,t),l(e,Xe,t),r(F,e,t),l(e,Se,t),l(e,D,t),l(e,He,t),l(e,P,t),l(e,$e,t),l(e,K,t),l(e,Qe,t),r(O,e,t),l(e,Ve,t),l(e,te,t),Ne=!0},p:wt,i(e){Ne||(c(J.$$.fragment,e),c(C.$$.fragment,e),c(b.$$.fragment,e),c(Z.$$.fragment,e),c(_.$$.fragment,e),c(v.$$.fragment,e),c(R.$$.fragment,e),c(X.$$.fragment,e),c($.$$.fragment,e),c(V.$$.fragment,e),c(Y.$$.fragment,e),c(q.$$.fragment,e),c(E.$$.fragment,e),c(F.$$.fragment,e),c(O.$$.fragment,e),Ne=!0)},o(e){m(J.$$.fragment,e),m(C.$$.fragment,e),m(b.$$.fragment,e),m(Z.$$.fragment,e),m(_.$$.fragment,e),m(v.$$.fragment,e),m(R.$$.fragment,e),m(X.$$.fragment,e),m($.$$.fragment,e),m(V.$$.fragment,e),m(Y.$$.fragment,e),m(q.$$.fragment,e),m(E.$$.fragment,e),m(F.$$.fragment,e),m(O.$$.fragment,e),Ne=!1},d(e){e&&(s(le),s(ee),s(ne),s(ae),s(h),s(ie),s(U),s(oe),s(u),s(Me),s(f),s(pe),s(j),s(ye),s(re),s(I),s(ce),s(me),s(g),s(de),s(k),s(we),s(Te),s(Je),s(B),s(he),s(Ue),s(W),s(ue),s(G),s(fe),s(je),s(A),s(Ce),s(Ie),s(S),s(be),s(H),s(ge),s(ke),s(Q),s(Ze),s(_e),s(N),s(Be),s(x),s(ve),s(We),s(z),s(Ge),s(Re),s(L),s(Ae),s(Xe),s(Se),s(D),s(He),s(P),s($e),s(K),s(Qe),s(Ve),s(te)),s(w),d(J,e),d(C,e),d(b,e),d(Z,e),d(_,e),d(v,e),d(R,e),d(X,e),d($,e),d(V,e),d(Y,e),d(q,e),d(E,e),d(F,e),d(O,e)}}}const Ct='{"title":"How to Hack Any Transformers Model","local":"how-to-hack-any-transformers-model","sections":[{"title":"Example: Modifying the Attention Mechanism in the Segment Anything Model (SAM)","local":"example-modifying-the-attention-mechanism-in-the-segment-anything-model-sam","sections":[{"title":"Motivation","local":"motivation","sections":[],"depth":3},{"title":"Implementation","local":"implementation","sections":[{"title":"Step 1: Create a Custom Attention Class","local":"step-1-create-a-custom-attention-class","sections":[],"depth":4},{"title":"Step 2: Replace the Original Attention Class","local":"step-2-replace-the-original-attention-class","sections":[],"depth":4},{"title":"Step 3: Apply LoRA to Specific Projections","local":"step-3-apply-lora-to-specific-projections","sections":[],"depth":4},{"title":"Step 4: Verify the Number of Trainable Parameters","local":"step-4-verify-the-number-of-trainable-parameters","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Contributing Your Own Hacks","local":"contributing-your-own-hacks","sections":[],"depth":2}],"depth":1}';function It(xe){return Tt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _t extends Jt{constructor(w){super(),ht(this,w,It,jt,dt,{})}}export{_t as component};
