import{s as ws,f as mt,n as Ts,o as Js}from"../chunks/scheduler.37c15a92.js";import{S as gs,i as bs,g as o,s,r as m,A as vs,h as i,f as l,c as a,j as hs,u as p,x as r,k as f,y as Us,a as n,v as M,d as u,t as c,w as y}from"../chunks/index.7cb9c9b8.js";import{C as h}from"../chunks/CodeBlock.abae2786.js";import{C as js}from"../chunks/CourseFloatingBanner.df82c153.js";import{H as d,E as Zs}from"../chunks/getInferenceSnippets.15b814d1.js";function Is(rn){let w,ut,pt,ct,T,yt,J,dt,g,mn=`The colab notebook:
<a href="https://colab.research.google.com/github/huggingface/deep-rl-class/blob/master/notebooks/unit8/unit8_part2.ipynb" rel="nofollow"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"/></a>`,ft,b,ht,v,pn,wt,U,Mn='In this notebook, we will learn how to train a Deep Neural Network to collect objects in a 3D environment based on the game of Doom, a video of the resulting policy is shown below. We train this policy using <a href="https://www.samplefactory.dev/" rel="nofollow">Sample Factory</a>, an asynchronous implementation of the PPO algorithm.',Tt,j,un="Please note the following points:",Jt,Z,cn='<li><p><a href="https://www.samplefactory.dev/" rel="nofollow">Sample Factory</a> is an advanced RL framework and <strong>only functions on Linux and Mac</strong> (not Windows).</p></li> <li><p>The framework performs best on a <strong>GPU machine with many CPU cores</strong>, where it can achieve speeds of 100k interactions per second. The resources available on a standard Colab notebook <strong>limit the performance of this library</strong>. So the speed in this setting <strong>does not reflect the real-world performance</strong>.</p></li> <li><p>Benchmarks for Sample Factory are available in a number of settings, check out the <a href="https://github.com/alex-petrenko/sample-factory/tree/master/sf_examples" rel="nofollow">examples</a> if you want to find out more.</p></li>',gt,I,bt,_,yn='To validate this hands-on for the <a href="https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process" rel="nofollow">certification process</a>, you need to push one model:',vt,$,dn="<li><code>doom_health_gathering_supreme</code> get a result of &gt;= 5.</li>",Ut,k,fn='To find your result, go to the <a href="https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard" rel="nofollow">leaderboard</a> and find your model, <strong>the result = mean_reward - std of reward</strong>',jt,C,hn="If you don’t find your model, <strong>go to the bottom of the page and click on the refresh button</strong>",Zt,G,wn='For more information about the certification process, check this section 👉 <a href="https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process" rel="nofollow">https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process</a>',It,B,_t,W,Tn="<li>To <strong>accelerate the agent’s training, we’ll use a GPU</strong>. To do that, go to <code>Runtime &gt; Change Runtime type</code></li>",$t,H,Jn,kt,X,gn="<li><code>Hardware Accelerator &gt; GPU</code></li>",Ct,V,bn,Gt,R,vn="Before starting to train our agent, let’s <strong>study the library and environments we’re going to use</strong>.",Bt,L,Wt,z,Un='<a href="https://www.samplefactory.dev/" rel="nofollow">Sample Factory</a> is one of the <strong>fastest RL libraries focused on very efficient synchronous and asynchronous implementations of policy gradients (PPO)</strong>.',Ht,x,jn="Sample Factory is thoroughly <strong>tested, used by many researchers and practitioners</strong>, and is actively maintained. Our implementation is known to <strong>reach SOTA performance in a variety of domains while minimizing RL experiment training time and hardware requirements</strong>.",Xt,q,Zn,Vt,E,Rt,N,In='<li>Highly optimized algorithm <a href="https://www.samplefactory.dev/06-architecture/overview/" rel="nofollow">architecture</a> for maximum learning throughput</li> <li><a href="https://www.samplefactory.dev/07-advanced-topics/sync-async/" rel="nofollow">Synchronous and asynchronous</a> training regimes</li> <li><a href="https://www.samplefactory.dev/07-advanced-topics/serial-mode/" rel="nofollow">Serial (single-process) mode</a> for easy debugging</li> <li>Optimal performance in both CPU-based and <a href="https://www.samplefactory.dev/09-environment-integrations/isaacgym/" rel="nofollow">GPU-accelerated environments</a></li> <li>Single- &amp; multi-agent training, self-play, supports <a href="https://www.samplefactory.dev/07-advanced-topics/multi-policy-training/" rel="nofollow">training multiple policies</a> at once on one or many GPUs</li> <li>Population-Based Training (<a href="https://www.samplefactory.dev/07-advanced-topics/pbt/" rel="nofollow">PBT</a>)</li> <li>Discrete, continuous, hybrid action spaces</li> <li>Vector-based, image-based, dictionary observation spaces</li> <li>Automatically creates a model architecture by parsing action/observation space specification. Supports <a href="https://www.samplefactory.dev/03-customization/custom-models/" rel="nofollow">custom model architectures</a></li> <li>Designed to be imported into other projects, <a href="https://www.samplefactory.dev/03-customization/custom-environments/" rel="nofollow">custom environments</a> are first-class citizens</li> <li>Detailed <a href="https://www.samplefactory.dev/05-monitoring/metrics-reference/" rel="nofollow">WandB and Tensorboard summaries</a>, <a href="https://www.samplefactory.dev/05-monitoring/custom-metrics/" rel="nofollow">custom metrics</a></li> <li><a href="https://www.samplefactory.dev/10-huggingface/huggingface/" rel="nofollow">HuggingFace 🤗 integration</a> (upload trained models and metrics to the Hub)</li> <li><a href="https://www.samplefactory.dev/09-environment-integrations/mujoco/" rel="nofollow">Multiple</a> <a href="https://www.samplefactory.dev/09-environment-integrations/atari/" rel="nofollow">example</a> <a href="https://www.samplefactory.dev/09-environment-integrations/vizdoom/" rel="nofollow">environment</a> <a href="https://www.samplefactory.dev/09-environment-integrations/dmlab/" rel="nofollow">integrations</a> with tuned parameters and trained models</li>',Lt,Y,_n='All of the above policies are available on the 🤗 hub. Search for the tag <a href="https://huggingface.co/models?library=sample-factory&amp;sort=downloads" rel="nofollow">sample-factory</a>',zt,S,xt,A,$n="Sample-factory is one of the <strong>most highly optimized RL implementations available to the community</strong>.",qt,F,kn="It works by <strong>spawning multiple processes that run rollout workers, inference workers and a learner worker</strong>.",Et,Q,Cn="The <em>workers</em> <strong>communicate through shared memory, which lowers the communication cost between processes</strong>.",Nt,D,Gn="The <em>rollout workers</em> interact with the environment and send observations to the <em>inference workers</em>.",Yt,P,Bn="The <em>inferences workers</em> query a fixed version of the policy and <strong>send actions back to the rollout worker</strong>.",St,K,Wn="After <em>k</em> steps the rollout works send a trajectory of experience to the learner worker, <strong>which it uses to update the agent’s policy network</strong>.",At,O,Hn,Ft,ee,Qt,te,Xn="Actor Critic models in Sample Factory are composed of three components:",Dt,le,Vn="<li><strong>Encoder</strong> - Process input observations (images, vectors) and map them to a vector. This is the part of the model you will most likely want to customize.</li> <li><strong>Core</strong> - Intergrate vectors from one or more encoders, can optionally include a single- or multi-layer LSTM/GRU in a memory-based agent.</li> <li><strong>Decoder</strong> - Apply additional layers to the output of the model core before computing the policy and value outputs.</li>",Pt,ne,Rn='The library has been designed to automatically support any observation and action spaces. Users can easily add their custom models. You can find out more in the <a href="https://www.samplefactory.dev/03-customization/custom-models/#actor-critic-models-in-sample-factory" rel="nofollow">documentation</a>.',Kt,se,Ot,ae,Ln='<a href="https://vizdoom.cs.put.edu.pl/" rel="nofollow">ViZDoom</a> is an <strong>open-source python interface for the Doom Engine</strong>.',el,oe,zn="The library was created in 2016 by Marek Wydmuch, Michal Kempka  at the Institute of Computing Science, Poznan University of Technology, Poland.",tl,ie,xn="The library enables the <strong>training of agents directly from the screen pixels in a number of scenarios</strong>, including team deathmatch, shown in the video below. Because the ViZDoom environment is based on a game the was created in the 90s, it can be run on modern hardware at accelerated speeds, <strong>allowing us to learn complex AI behaviors fairly quickly</strong>.",ll,re,qn="The library includes feature such as:",nl,me,En='<li>Multi-platform (Linux, macOS, Windows),</li> <li>API for Python and C++,</li> <li><a href="https://www.gymlibrary.dev/" rel="nofollow">OpenAI Gym</a> environment wrappers</li> <li>Easy-to-create custom scenarios (visual editors, scripting language, and examples available),</li> <li>Async and sync single-player and multiplayer modes,</li> <li>Lightweight (few MBs) and fast (up to 7000 fps in sync mode, single-threaded),</li> <li>Customizable resolution and rendering parameters,</li> <li>Access to the depth buffer (3D vision),</li> <li>Automatic labeling of game objects visible in the frame,</li> <li>Access to the audio buffer</li> <li>Access to the list of actors/objects and map geometry,</li> <li>Off-screen rendering and episode recording,</li> <li>Time scaling in async mode.</li>',sl,pe,al,Me,Nn="Now that our Colab runtime is set up, we can start by installing the dependencies required to run ViZDoom on linux.",ol,ue,Yn='If you are following on your machine on Mac, you will want to follow the installation instructions on the <a href="https://github.com/Farama-Foundation/ViZDoom/blob/master/doc/Quickstart.md#-quickstart-for-macos-and-anaconda3-python-36" rel="nofollow">github page</a>.',il,ce,rl,ye,ml,de,Sn="<li>This can take 7min</li>",pl,fe,Ml,he,ul,we,cl,Te,An="Now that the setup if complete, we can train the agent. We have chosen here to learn a ViZDoom task called <code>Health Gathering Supreme</code>.",yl,Je,dl,ge,Fn,fl,be,Qn="The objective of this scenario is to <strong>teach the agent how to survive without knowing what makes it survive</strong>. The Agent know only that <strong>life is precious</strong> and death is bad so <strong>it must learn what prolongs its existence and that its health is connected with survival</strong>.",hl,ve,Dn="The map is a rectangle containing walls and with a green, acidic floor which <strong>hurts the player periodically</strong>. Initially there are some medkits spread uniformly over the map. A new medkit falls from the skies every now and then. <strong>Medkits heal some portions of player’s health</strong> - to survive, the agent needs to pick them up. The episode finishes after the player’s death or on timeout.",wl,Ue,Pn="Further configuration:",Tl,je,Kn="<li>Living_reward = 1</li> <li>3 available buttons: turn left, turn right, move forward</li> <li>1 available game variable: HEALTH</li> <li>death penalty = 100</li>",Jl,Ze,On='You can find out more about the scenarios available in ViZDoom <a href="https://github.com/Farama-Foundation/ViZDoom/tree/master/scenarios" rel="nofollow">here</a>.',gl,Ie,es='There are also a number of more complex scenarios that have been create for ViZDoom, such as the ones detailed on <a href="https://github.com/edbeeching/3d_control_deep_rl" rel="nofollow">this github page</a>.',bl,_e,vl,$e,ts="<li>We’re going to train the agent for 4000000 steps. It will take approximately 20min</li>",Ul,ke,jl,Ce,Zl,Ge,Il,Be,_l,We,$l,He,ls="The agent has learned something, but its performance could be better. We would clearly need to train for longer. But let’s upload this model to the Hub.",kl,Xe,Cl,Ve,ns="To be able to share your model with the community there are three more steps to follow:",Gl,Re,ss='1️⃣ (If it’s not already done) create an account to HF ➡ <a href="https://huggingface.co/join" rel="nofollow">https://huggingface.co/join</a>',Bl,Le,as="2️⃣ Sign in and get your authentication token from the Hugging Face website.",Wl,ze,os='<li>Create a new token (<a href="https://huggingface.co/settings/tokens" rel="nofollow">https://huggingface.co/settings/tokens</a>) <strong>with write role</strong></li>',Hl,xe,is,Xl,qe,rs="<li>Copy the token</li> <li>Run the cell below and paste the token</li>",Vl,Ee,ms="If you don’t want to use Google Colab or a Jupyter Notebook, you need to use this command instead: <code>huggingface-cli login</code>",Rl,Ne,Ll,Ye,zl,Se,xl,Ae,ps="This agent’s performance was good, but we can do better! Let’s download and visualize an agent trained for 10B timesteps from the hub.",ql,Fe,El,Qe,Nl,De,Yl,Pe,Sl,Ke,Al,Oe,Ms="Training an agent to play a Doom deathmatch <strong>takes many hours on a more beefy machine than is available in Colab</strong>.",Fl,et,us="Fortunately, we have have <strong>already trained an agent in this scenario and it is available in the 🤗 Hub!</strong> Let’s download the model and visualize the agent’s performance.",Ql,tt,Dl,lt,cs="Given the agent plays for a long time the video generation can take <strong>10 minutes</strong>.",Pl,nt,Kl,st,ys=`You <strong>can try to train your agent in this environment</strong> using the code above, but not on colab.
<strong>Good luck 🤞</strong>`,Ol,at,ds="If you prefer an easier scenario, <strong>why not try training in another ViZDoom scenario such as <code>doom_deadly_corridor</code> or <code>doom_defend_the_center</code>.</strong>",en,tn,ln,ot,fs="This concludes the last unit. But we are not finished yet! 🤗 The following <strong>bonus section include some of the most interesting, advanced, and cutting edge work in Deep Reinforcement Learning</strong>.",nn,it,sn,rt,an,Mt,on;return T=new d({props:{title:"Hands-on: advanced Deep Reinforcement Learning. Using Sample Factory to play Doom from pixels",local:"hands-on-advanced-deep-reinforcement-learning-using-sample-factory-to-play-doom-from-pixels",headingTag:"h1"}}),J=new js({props:{classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/deep-rl-class/blob/main/notebooks/unit8/unit8_part2.ipynb"}],askForHelpUrl:"http://hf.co/join/discord"}}),b=new d({props:{title:"Unit 8 Part 2: Advanced Deep Reinforcement Learning. Using Sample Factory to play Doom from pixels",local:"unit-8-part-2-advanced-deep-reinforcement-learning-using-sample-factory-to-play-doom-from-pixels",headingTag:"h1"}}),I=new h({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEhUTUwlMEElMEFIVE1MKCUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUzQ3ZpZGVvJTIwd2lkdGglM0QlMjI2NDAlMjIlMjBoZWlnaHQlM0QlMjI0ODAlMjIlMjBjb250cm9scyUzRSUwQSUyMCUyMCUzQ3NvdXJjZSUyMHNyYyUzRCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZlZGJlZWNoaW5nJTJGZG9vbV9oZWFsdGhfZ2F0aGVyaW5nX3N1cHJlbWVfMzMzMyUyRnJlc29sdmUlMkZtYWluJTJGcmVwbGF5Lm1wNCUyMiUwQSUyMCUyMHR5cGUlM0QlMjJ2aWRlbyUyRm1wNCUyMiUzRVlvdXIlMjBicm93c2VyJTIwZG9lcyUyMG5vdCUyMHN1cHBvcnQlMjB0aGUlMjB2aWRlbyUyMHRhZy4lM0MlMkZ2aWRlbyUzRSUyMiUyMiUyMiUwQSk=",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> HTML

HTML(
    <span class="hljs-string">&quot;&quot;&quot;&lt;video width=&quot;640&quot; height=&quot;480&quot; controls&gt;
  &lt;source src=&quot;https://huggingface.co/edbeeching/doom_health_gathering_supreme_3333/resolve/main/replay.mp4&quot;
  type=&quot;video/mp4&quot;&gt;Your browser does not support the video tag.&lt;/video&gt;&quot;&quot;&quot;</span>
)`,wrap:!1}}),B=new d({props:{title:"Set the GPU 💪",local:"set-the-gpu-",headingTag:"h2"}}),L=new d({props:{title:"Sample Factory",local:"sample-factory",headingTag:"h2"}}),E=new d({props:{title:"Key features",local:"key-features",headingTag:"h3"}}),S=new d({props:{title:"How sample-factory works",local:"how-sample-factory-works",headingTag:"h3"}}),ee=new d({props:{title:"Actor Critic models in Sample-factory",local:"actor-critic-models-in-sample-factory",headingTag:"h3"}}),se=new d({props:{title:"ViZDoom",local:"vizdoom",headingTag:"h2"}}),pe=new d({props:{title:"We first need to install some dependencies that are required for the ViZDoom environment",local:"we-first-need-to-install-some-dependencies-that-are-required-for-the-vizdoom-environment",headingTag:"h2"}}),ce=new h({props:{code:"JTIzJTIwSW5zdGFsbCUyMFZpWkRvb20lMjBkZXBzJTIwZnJvbSUwQSUyMyUyMGh0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRm13eWRtdWNoJTJGVmlaRG9vbSUyRmJsb2IlMkZtYXN0ZXIlMkZkb2MlMkZCdWlsZGluZy5tZCUyMy1saW51eCUwQSUwQWFwdC1nZXQlMjBpbnN0YWxsJTIwYnVpbGQtZXNzZW50aWFsJTIwemxpYjFnLWRldiUyMGxpYnNkbDItZGV2JTIwbGlianBlZy1kZXYlMjAlNUMlMEFuYXNtJTIwdGFyJTIwbGliYnoyLWRldiUyMGxpYmd0azIuMC1kZXYlMjBjbWFrZSUyMGdpdCUyMGxpYmZsdWlkc3ludGgtZGV2JTIwbGliZ21lLWRldiUyMCU1QyUwQWxpYm9wZW5hbC1kZXYlMjB0aW1pZGl0eSUyMGxpYndpbGRtaWRpLWRldiUyMHVuemlwJTIwZmZtcGVnJTBBJTBBJTIzJTIwQm9vc3QlMjBsaWJyYXJpZXMlMEFhcHQtZ2V0JTIwaW5zdGFsbCUyMGxpYmJvb3N0LWFsbC1kZXYlMEElMEElMjMlMjBMdWElMjBiaW5kaW5nJTIwZGVwZW5kZW5jaWVzJTBBYXB0LWdldCUyMGluc3RhbGwlMjBsaWJsdWE1LjEtZGV2",highlighted:`<span class="hljs-comment"># Install ViZDoom deps from</span>
<span class="hljs-comment"># https://github.com/mwydmuch/ViZDoom/blob/master/doc/Building.md#-linux</span>

apt-get install build-essential zlib1g-dev libsdl2-dev libjpeg-dev \\
nasm tar libbz2-dev libgtk2<span class="hljs-number">.0</span>-dev cmake git libfluidsynth-dev libgme-dev \\
libopenal-dev timidity libwildmidi-dev unzip ffmpeg

<span class="hljs-comment"># Boost libraries</span>
apt-get install libboost-<span class="hljs-built_in">all</span>-dev

<span class="hljs-comment"># Lua binding dependencies</span>
apt-get install liblua5<span class="hljs-number">.1</span>-dev`,wrap:!1}}),ye=new d({props:{title:"Then we can install Sample Factory and ViZDoom",local:"then-we-can-install-sample-factory-and-vizdoom",headingTag:"h2"}}),fe=new h({props:{code:"cGlwJTIwaW5zdGFsbCUyMHNhbXBsZS1mYWN0b3J5JTBBcGlwJTIwaW5zdGFsbCUyMHZpemRvb20=",highlighted:`pip install sample-factory
pip install vizdoom`,wrap:!1}}),he=new d({props:{title:"Setting up the Doom Environment in sample-factory",local:"setting-up-the-doom-environment-in-sample-factory",headingTag:"h2"}}),we=new h({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> functools

<span class="hljs-keyword">from</span> sample_factory.algo.utils.context <span class="hljs-keyword">import</span> global_model_factory
<span class="hljs-keyword">from</span> sample_factory.cfg.arguments <span class="hljs-keyword">import</span> parse_full_cfg, parse_sf_args
<span class="hljs-keyword">from</span> sample_factory.envs.env_utils <span class="hljs-keyword">import</span> register_env
<span class="hljs-keyword">from</span> sample_factory.train <span class="hljs-keyword">import</span> run_rl

<span class="hljs-keyword">from</span> sf_examples.vizdoom.doom.doom_model <span class="hljs-keyword">import</span> make_vizdoom_encoder
<span class="hljs-keyword">from</span> sf_examples.vizdoom.doom.doom_params <span class="hljs-keyword">import</span> add_doom_env_args, doom_override_defaults
<span class="hljs-keyword">from</span> sf_examples.vizdoom.doom.doom_utils <span class="hljs-keyword">import</span> DOOM_ENVS, make_doom_env_from_spec


<span class="hljs-comment"># Registers all the ViZDoom environments</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">register_vizdoom_envs</span>():
    <span class="hljs-keyword">for</span> env_spec <span class="hljs-keyword">in</span> DOOM_ENVS:
        make_env_func = functools.partial(make_doom_env_from_spec, env_spec)
        register_env(env_spec.name, make_env_func)


<span class="hljs-comment"># Sample Factory allows the registration of a custom Neural Network architecture</span>
<span class="hljs-comment"># See https://github.com/alex-petrenko/sample-factory/blob/master/sf_examples/vizdoom/doom/doom_model.py for more details</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">register_vizdoom_models</span>():
    global_model_factory().register_encoder_factory(make_vizdoom_encoder)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">register_vizdoom_components</span>():
    register_vizdoom_envs()
    register_vizdoom_models()


<span class="hljs-comment"># parse the command line args and create a config</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">parse_vizdoom_cfg</span>(<span class="hljs-params">argv=<span class="hljs-literal">None</span>, evaluation=<span class="hljs-literal">False</span></span>):
    parser, _ = parse_sf_args(argv=argv, evaluation=evaluation)
    <span class="hljs-comment"># parameters specific to Doom envs</span>
    add_doom_env_args(parser)
    <span class="hljs-comment"># override Doom default values for algo parameters</span>
    doom_override_defaults(parser)
    <span class="hljs-comment"># second parsing pass yields the final configuration</span>
    final_cfg = parse_full_cfg(parser, argv)
    <span class="hljs-keyword">return</span> final_cfg`,wrap:!1}}),Je=new d({props:{title:"The scenario: Health Gathering Supreme",local:"the-scenario-health-gathering-supreme",headingTag:"h3"}}),_e=new d({props:{title:"Training the agent",local:"training-the-agent",headingTag:"h2"}}),ke=new h({props:{code:"JTIzJTIzJTIwU3RhcnQlMjB0aGUlMjB0cmFpbmluZyUyQyUyMHRoaXMlMjBzaG91bGQlMjB0YWtlJTIwYXJvdW5kJTIwMTUlMjBtaW51dGVzJTBBcmVnaXN0ZXJfdml6ZG9vbV9jb21wb25lbnRzKCklMEElMEElMjMlMjBUaGUlMjBzY2VuYXJpbyUyMHdlJTIwdHJhaW4lMjBvbiUyMHRvZGF5JTIwaXMlMjBoZWFsdGglMjBnYXRoZXJpbmclMEElMjMlMjBvdGhlciUyMHNjZW5hcmlvcyUyMGluY2x1ZGUlMjAlMjJkb29tX2Jhc2ljJTIyJTJDJTIwJTIyZG9vbV90d29fY29sb3JzX2Vhc3klMjIlMkMlMjAlMjJkb29tX2RtJTIyJTJDJTIwJTIyZG9vbV9kd2FuZ281JTIyJTJDJTIwJTIyZG9vbV9teV93YXlfaG9tZSUyMiUyQyUyMCUyMmRvb21fZGVhZGx5X2NvcnJpZG9yJTIyJTJDJTIwJTIyZG9vbV9kZWZlbmRfdGhlX2NlbnRlciUyMiUyQyUyMCUyMmRvb21fZGVmZW5kX3RoZV9saW5lJTIyJTBBZW52JTIwJTNEJTIwJTIyZG9vbV9oZWFsdGhfZ2F0aGVyaW5nX3N1cHJlbWUlMjIlMEFjZmclMjAlM0QlMjBwYXJzZV92aXpkb29tX2NmZyglMEElMjAlMjAlMjAlMjBhcmd2JTNEJTVCZiUyMi0tZW52JTNEJTdCZW52JTdEJTIyJTJDJTIwJTIyLS1udW1fd29ya2VycyUzRDglMjIlMkMlMjAlMjItLW51bV9lbnZzX3Blcl93b3JrZXIlM0Q0JTIyJTJDJTIwJTIyLS10cmFpbl9mb3JfZW52X3N0ZXBzJTNENDAwMDAwMCUyMiU1RCUwQSklMEElMEFzdGF0dXMlMjAlM0QlMjBydW5fcmwoY2ZnKQ==",highlighted:`<span class="hljs-comment">## Start the training, this should take around 15 minutes</span>
register_vizdoom_components()

<span class="hljs-comment"># The scenario we train on today is health gathering</span>
<span class="hljs-comment"># other scenarios include &quot;doom_basic&quot;, &quot;doom_two_colors_easy&quot;, &quot;doom_dm&quot;, &quot;doom_dwango5&quot;, &quot;doom_my_way_home&quot;, &quot;doom_deadly_corridor&quot;, &quot;doom_defend_the_center&quot;, &quot;doom_defend_the_line&quot;</span>
env = <span class="hljs-string">&quot;doom_health_gathering_supreme&quot;</span>
cfg = parse_vizdoom_cfg(
    argv=[<span class="hljs-string">f&quot;--env=<span class="hljs-subst">{env}</span>&quot;</span>, <span class="hljs-string">&quot;--num_workers=8&quot;</span>, <span class="hljs-string">&quot;--num_envs_per_worker=4&quot;</span>, <span class="hljs-string">&quot;--train_for_env_steps=4000000&quot;</span>]
)

status = run_rl(cfg)`,wrap:!1}}),Ce=new d({props:{title:"Let’s take a look at the performance of the trained policy and output a video of the agent.",local:"lets-take-a-look-at-the-performance-of-the-trained-policy-and-output-a-video-of-the-agent",headingTag:"h2"}}),Ge=new h({props:{code:"ZnJvbSUyMHNhbXBsZV9mYWN0b3J5LmVuam95JTIwaW1wb3J0JTIwZW5qb3klMEElMEFjZmclMjAlM0QlMjBwYXJzZV92aXpkb29tX2NmZyglMEElMjAlMjAlMjAlMjBhcmd2JTNEJTVCZiUyMi0tZW52JTNEJTdCZW52JTdEJTIyJTJDJTIwJTIyLS1udW1fd29ya2VycyUzRDElMjIlMkMlMjAlMjItLXNhdmVfdmlkZW8lMjIlMkMlMjAlMjItLW5vX3JlbmRlciUyMiUyQyUyMCUyMi0tbWF4X251bV9lcGlzb2RlcyUzRDEwJTIyJTVEJTJDJTIwZXZhbHVhdGlvbiUzRFRydWUlMEEpJTBBc3RhdHVzJTIwJTNEJTIwZW5qb3koY2ZnKQ==",highlighted:`<span class="hljs-keyword">from</span> sample_factory.enjoy <span class="hljs-keyword">import</span> enjoy

cfg = parse_vizdoom_cfg(
    argv=[<span class="hljs-string">f&quot;--env=<span class="hljs-subst">{env}</span>&quot;</span>, <span class="hljs-string">&quot;--num_workers=1&quot;</span>, <span class="hljs-string">&quot;--save_video&quot;</span>, <span class="hljs-string">&quot;--no_render&quot;</span>, <span class="hljs-string">&quot;--max_num_episodes=10&quot;</span>], evaluation=<span class="hljs-literal">True</span>
)
status = enjoy(cfg)`,wrap:!1}}),Be=new d({props:{title:"Now lets visualize the performance of the agent",local:"now-lets-visualize-the-performance-of-the-agent",headingTag:"h2"}}),We=new h({props:{code:"ZnJvbSUyMGJhc2U2NCUyMGltcG9ydCUyMGI2NGVuY29kZSUwQWZyb20lMjBJUHl0aG9uLmRpc3BsYXklMjBpbXBvcnQlMjBIVE1MJTBBJTBBbXA0JTIwJTNEJTIwb3BlbiglMjIlMkZjb250ZW50JTJGdHJhaW5fZGlyJTJGZGVmYXVsdF9leHBlcmltZW50JTJGcmVwbGF5Lm1wNCUyMiUyQyUyMCUyMnJiJTIyKS5yZWFkKCklMEFkYXRhX3VybCUyMCUzRCUyMCUyMmRhdGElM0F2aWRlbyUyRm1wNCUzQmJhc2U2NCUyQyUyMiUyMCUyQiUyMGI2NGVuY29kZShtcDQpLmRlY29kZSgpJTBBSFRNTCglMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElM0N2aWRlbyUyMHdpZHRoJTNENjQwJTIwY29udHJvbHMlM0UlMEElMjAlMjAlMjAlMjAlMjAlMjAlM0Nzb3VyY2UlMjBzcmMlM0QlMjIlMjVzJTIyJTIwdHlwZSUzRCUyMnZpZGVvJTJGbXA0JTIyJTNFJTBBJTNDJTJGdmlkZW8lM0UlMEElMjIlMjIlMjIlMEElMjAlMjAlMjAlMjAlMjUlMjBkYXRhX3VybCUwQSk=",highlighted:`<span class="hljs-keyword">from</span> base64 <span class="hljs-keyword">import</span> b64encode
<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> HTML

mp4 = <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;/content/train_dir/default_experiment/replay.mp4&quot;</span>, <span class="hljs-string">&quot;rb&quot;</span>).read()
data_url = <span class="hljs-string">&quot;data:video/mp4;base64,&quot;</span> + b64encode(mp4).decode()
HTML(
    <span class="hljs-string">&quot;&quot;&quot;
&lt;video width=640 controls&gt;
      &lt;source src=&quot;%s&quot; type=&quot;video/mp4&quot;&gt;
&lt;/video&gt;
&quot;&quot;&quot;</span>
    % data_url
)`,wrap:!1}}),Xe=new d({props:{title:"Now lets upload your checkpoint and video to the Hugging Face Hub",local:"now-lets-upload-your-checkpoint-and-video-to-the-hugging-face-hub",headingTag:"h2"}}),Ne=new h({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBbm90ZWJvb2tfbG9naW4oKSUwQSFnaXQlMjBjb25maWclMjAtLWdsb2JhbCUyMGNyZWRlbnRpYWwuaGVscGVyJTIwc3RvcmU=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login
notebook_login()
!git config --<span class="hljs-keyword">global</span> credential.helper store`,wrap:!1}}),Ye=new h({props:{code:"ZnJvbSUyMHNhbXBsZV9mYWN0b3J5LmVuam95JTIwaW1wb3J0JTIwZW5qb3klMEElMEFoZl91c2VybmFtZSUyMCUzRCUyMCUyMlRob21hc1NpbW9uaW5pJTIyJTIwJTIwJTIzJTIwaW5zZXJ0JTIweW91ciUyMEh1Z2dpbmdGYWNlJTIwdXNlcm5hbWUlMjBoZXJlJTBBJTBBY2ZnJTIwJTNEJTIwcGFyc2Vfdml6ZG9vbV9jZmcoJTBBJTIwJTIwJTIwJTIwYXJndiUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGYlMjItLWVudiUzRCU3QmVudiU3RCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMi0tbnVtX3dvcmtlcnMlM0QxJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyLS1zYXZlX3ZpZGVvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyLS1ub19yZW5kZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjItLW1heF9udW1fZXBpc29kZXMlM0QxMCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMi0tbWF4X251bV9mcmFtZXMlM0QxMDAwMDAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjItLXB1c2hfdG9faHViJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMi0taGZfcmVwb3NpdG9yeSUzRCU3QmhmX3VzZXJuYW1lJTdEJTJGcmxfY291cnNlX3ZpemRvb21faGVhbHRoX2dhdGhlcmluZ19zdXByZW1lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwZXZhbHVhdGlvbiUzRFRydWUlMkMlMEEpJTBBc3RhdHVzJTIwJTNEJTIwZW5qb3koY2ZnKQ==",highlighted:`<span class="hljs-keyword">from</span> sample_factory.enjoy <span class="hljs-keyword">import</span> enjoy

hf_username = <span class="hljs-string">&quot;ThomasSimonini&quot;</span>  <span class="hljs-comment"># insert your HuggingFace username here</span>

cfg = parse_vizdoom_cfg(
    argv=[
        <span class="hljs-string">f&quot;--env=<span class="hljs-subst">{env}</span>&quot;</span>,
        <span class="hljs-string">&quot;--num_workers=1&quot;</span>,
        <span class="hljs-string">&quot;--save_video&quot;</span>,
        <span class="hljs-string">&quot;--no_render&quot;</span>,
        <span class="hljs-string">&quot;--max_num_episodes=10&quot;</span>,
        <span class="hljs-string">&quot;--max_num_frames=100000&quot;</span>,
        <span class="hljs-string">&quot;--push_to_hub&quot;</span>,
        <span class="hljs-string">f&quot;--hf_repository=<span class="hljs-subst">{hf_username}</span>/rl_course_vizdoom_health_gathering_supreme&quot;</span>,
    ],
    evaluation=<span class="hljs-literal">True</span>,
)
status = enjoy(cfg)`,wrap:!1}}),Se=new d({props:{title:"Let’s load another model",local:"lets-load-another-model",headingTag:"h2"}}),Fe=new h({props:{code:"JTIzZG93bmxvYWQlMjB0aGUlMjBhZ2VudCUyMGZyb20lMjB0aGUlMjBodWIlMEFweXRob24lMjAtbSUyMHNhbXBsZV9mYWN0b3J5Lmh1Z2dpbmdmYWNlLmxvYWRfZnJvbV9odWIlMjAtciUyMGVkYmVlY2hpbmclMkZkb29tX2hlYWx0aF9nYXRoZXJpbmdfc3VwcmVtZV8yMjIyJTIwLWQlMjAuJTJGdHJhaW5fZGly",highlighted:`<span class="hljs-comment">#download the agent from the hub</span>
python -m sample_factory.huggingface.load_from_hub -r edbeeching/doom_health_gathering_supreme_2222 -d ./train_dir`,wrap:!1}}),Qe=new h({props:{code:"bHMlMjB0cmFpbl9kaXIlMkZkb29tX2hlYWx0aF9nYXRoZXJpbmdfc3VwcmVtZV8yMjIy",highlighted:'<span class="hljs-built_in">ls</span> train_dir/doom_health_gathering_supreme_2222',wrap:!1}}),De=new h({props:{code:"ZW52JTIwJTNEJTIwJTIyZG9vbV9oZWFsdGhfZ2F0aGVyaW5nX3N1cHJlbWUlMjIlMEFjZmclMjAlM0QlMjBwYXJzZV92aXpkb29tX2NmZyglMEElMjAlMjAlMjAlMjBhcmd2JTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMi0tZW52JTNEJTdCZW52JTdEJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyLS1udW1fd29ya2VycyUzRDElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjItLXNhdmVfdmlkZW8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjItLW5vX3JlbmRlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMi0tbWF4X251bV9lcGlzb2RlcyUzRDEwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyLS1leHBlcmltZW50JTNEZG9vbV9oZWFsdGhfZ2F0aGVyaW5nX3N1cHJlbWVfMjIyMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMi0tdHJhaW5fZGlyJTNEdHJhaW5fZGlyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwZXZhbHVhdGlvbiUzRFRydWUlMkMlMEEpJTBBc3RhdHVzJTIwJTNEJTIwZW5qb3koY2ZnKQ==",highlighted:`env = <span class="hljs-string">&quot;doom_health_gathering_supreme&quot;</span>
cfg = parse_vizdoom_cfg(
    argv=[
        <span class="hljs-string">f&quot;--env=<span class="hljs-subst">{env}</span>&quot;</span>,
        <span class="hljs-string">&quot;--num_workers=1&quot;</span>,
        <span class="hljs-string">&quot;--save_video&quot;</span>,
        <span class="hljs-string">&quot;--no_render&quot;</span>,
        <span class="hljs-string">&quot;--max_num_episodes=10&quot;</span>,
        <span class="hljs-string">&quot;--experiment=doom_health_gathering_supreme_2222&quot;</span>,
        <span class="hljs-string">&quot;--train_dir=train_dir&quot;</span>,
    ],
    evaluation=<span class="hljs-literal">True</span>,
)
status = enjoy(cfg)`,wrap:!1}}),Pe=new h({props:{code:"bXA0JTIwJTNEJTIwb3BlbiglMjIlMkZjb250ZW50JTJGdHJhaW5fZGlyJTJGZG9vbV9oZWFsdGhfZ2F0aGVyaW5nX3N1cHJlbWVfMjIyMiUyRnJlcGxheS5tcDQlMjIlMkMlMjAlMjJyYiUyMikucmVhZCgpJTBBZGF0YV91cmwlMjAlM0QlMjAlMjJkYXRhJTNBdmlkZW8lMkZtcDQlM0JiYXNlNjQlMkMlMjIlMjAlMkIlMjBiNjRlbmNvZGUobXA0KS5kZWNvZGUoKSUwQUhUTUwoJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTNDdmlkZW8lMjB3aWR0aCUzRDY0MCUyMGNvbnRyb2xzJTNFJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTNDc291cmNlJTIwc3JjJTNEJTIyJTI1cyUyMiUyMHR5cGUlM0QlMjJ2aWRlbyUyRm1wNCUyMiUzRSUwQSUzQyUyRnZpZGVvJTNFJTBBJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwJTI1JTIwZGF0YV91cmwlMEEp",highlighted:`mp4 = <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;/content/train_dir/doom_health_gathering_supreme_2222/replay.mp4&quot;</span>, <span class="hljs-string">&quot;rb&quot;</span>).read()
data_url = <span class="hljs-string">&quot;data:video/mp4;base64,&quot;</span> + b64encode(mp4).decode()
HTML(
    <span class="hljs-string">&quot;&quot;&quot;
&lt;video width=640 controls&gt;
      &lt;source src=&quot;%s&quot; type=&quot;video/mp4&quot;&gt;
&lt;/video&gt;
&quot;&quot;&quot;</span>
    % data_url
)`,wrap:!1}}),Ke=new d({props:{title:"Some additional challenges 🏆: Doom Deathmatch",local:"some-additional-challenges--doom-deathmatch",headingTag:"h2"}}),tt=new h({props:{code:"JTIzJTIwRG93bmxvYWQlMjB0aGUlMjBhZ2VudCUyMGZyb20lMjB0aGUlMjBodWIlMEFweXRob24lMjAtbSUyMHNhbXBsZV9mYWN0b3J5Lmh1Z2dpbmdmYWNlLmxvYWRfZnJvbV9odWIlMjAtciUyMGVkYmVlY2hpbmclMkZkb29tX2RlYXRobWF0Y2hfYm90c18yMjIyJTIwLWQlMjAuJTJGdHJhaW5fZGly",highlighted:`<span class="hljs-comment"># Download the agent from the hub</span>
python -m sample_factory.huggingface.load_from_hub -r edbeeching/doom_deathmatch_bots_2222 -d ./train_dir`,wrap:!1}}),nt=new h({props:{code:"ZnJvbSUyMHNhbXBsZV9mYWN0b3J5LmVuam95JTIwaW1wb3J0JTIwZW5qb3klMEElMEFyZWdpc3Rlcl92aXpkb29tX2NvbXBvbmVudHMoKSUwQWVudiUyMCUzRCUyMCUyMmRvb21fZGVhdGhtYXRjaF9ib3RzJTIyJTBBY2ZnJTIwJTNEJTIwcGFyc2Vfdml6ZG9vbV9jZmcoJTBBJTIwJTIwJTIwJTIwYXJndiUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGYlMjItLWVudiUzRCU3QmVudiU3RCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMi0tbnVtX3dvcmtlcnMlM0QxJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyLS1zYXZlX3ZpZGVvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyLS1ub19yZW5kZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjItLW1heF9udW1fZXBpc29kZXMlM0QxJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyLS1leHBlcmltZW50JTNEZG9vbV9kZWF0aG1hdGNoX2JvdHNfMjIyMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMi0tdHJhaW5fZGlyJTNEdHJhaW5fZGlyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwZXZhbHVhdGlvbiUzRFRydWUlMkMlMEEpJTBBc3RhdHVzJTIwJTNEJTIwZW5qb3koY2ZnKSUwQW1wNCUyMCUzRCUyMG9wZW4oJTIyJTJGY29udGVudCUyRnRyYWluX2RpciUyRmRvb21fZGVhdGhtYXRjaF9ib3RzXzIyMjIlMkZyZXBsYXkubXA0JTIyJTJDJTIwJTIycmIlMjIpLnJlYWQoKSUwQWRhdGFfdXJsJTIwJTNEJTIwJTIyZGF0YSUzQXZpZGVvJTJGbXA0JTNCYmFzZTY0JTJDJTIyJTIwJTJCJTIwYjY0ZW5jb2RlKG1wNCkuZGVjb2RlKCklMEFIVE1MKCUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUzQ3ZpZGVvJTIwd2lkdGglM0Q2NDAlMjBjb250cm9scyUzRSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUzQ3NvdXJjZSUyMHNyYyUzRCUyMiUyNXMlMjIlMjB0eXBlJTNEJTIydmlkZW8lMkZtcDQlMjIlM0UlMEElM0MlMkZ2aWRlbyUzRSUwQSUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMCUyNSUyMGRhdGFfdXJsJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> sample_factory.enjoy <span class="hljs-keyword">import</span> enjoy

register_vizdoom_components()
env = <span class="hljs-string">&quot;doom_deathmatch_bots&quot;</span>
cfg = parse_vizdoom_cfg(
    argv=[
        <span class="hljs-string">f&quot;--env=<span class="hljs-subst">{env}</span>&quot;</span>,
        <span class="hljs-string">&quot;--num_workers=1&quot;</span>,
        <span class="hljs-string">&quot;--save_video&quot;</span>,
        <span class="hljs-string">&quot;--no_render&quot;</span>,
        <span class="hljs-string">&quot;--max_num_episodes=1&quot;</span>,
        <span class="hljs-string">&quot;--experiment=doom_deathmatch_bots_2222&quot;</span>,
        <span class="hljs-string">&quot;--train_dir=train_dir&quot;</span>,
    ],
    evaluation=<span class="hljs-literal">True</span>,
)
status = enjoy(cfg)
mp4 = <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;/content/train_dir/doom_deathmatch_bots_2222/replay.mp4&quot;</span>, <span class="hljs-string">&quot;rb&quot;</span>).read()
data_url = <span class="hljs-string">&quot;data:video/mp4;base64,&quot;</span> + b64encode(mp4).decode()
HTML(
    <span class="hljs-string">&quot;&quot;&quot;
&lt;video width=640 controls&gt;
      &lt;source src=&quot;%s&quot; type=&quot;video/mp4&quot;&gt;
&lt;/video&gt;
&quot;&quot;&quot;</span>
    % data_url
)`,wrap:!1}}),it=new d({props:{title:"Keep learning, stay awesome 🤗",local:"keep-learning-stay-awesome-",headingTag:"h2"}}),rt=new Zs({props:{source:"https://github.com/huggingface/deep-rl-class/blob/main/units/en/unit8/hands-on-sf.mdx"}}),{c(){w=o("meta"),ut=s(),pt=o("p"),ct=s(),m(T.$$.fragment),yt=s(),m(J.$$.fragment),dt=s(),g=o("p"),g.innerHTML=mn,ft=s(),m(b.$$.fragment),ht=s(),v=o("img"),wt=s(),U=o("p"),U.innerHTML=Mn,Tt=s(),j=o("p"),j.textContent=un,Jt=s(),Z=o("ul"),Z.innerHTML=cn,gt=s(),m(I.$$.fragment),bt=s(),_=o("p"),_.innerHTML=yn,vt=s(),$=o("ul"),$.innerHTML=dn,Ut=s(),k=o("p"),k.innerHTML=fn,jt=s(),C=o("p"),C.innerHTML=hn,Zt=s(),G=o("p"),G.innerHTML=wn,It=s(),m(B.$$.fragment),_t=s(),W=o("ul"),W.innerHTML=Tn,$t=s(),H=o("img"),kt=s(),X=o("ul"),X.innerHTML=gn,Ct=s(),V=o("img"),Gt=s(),R=o("p"),R.innerHTML=vn,Bt=s(),m(L.$$.fragment),Wt=s(),z=o("p"),z.innerHTML=Un,Ht=s(),x=o("p"),x.innerHTML=jn,Xt=s(),q=o("img"),Vt=s(),m(E.$$.fragment),Rt=s(),N=o("ul"),N.innerHTML=In,Lt=s(),Y=o("p"),Y.innerHTML=_n,zt=s(),m(S.$$.fragment),xt=s(),A=o("p"),A.innerHTML=$n,qt=s(),F=o("p"),F.innerHTML=kn,Et=s(),Q=o("p"),Q.innerHTML=Cn,Nt=s(),D=o("p"),D.innerHTML=Gn,Yt=s(),P=o("p"),P.innerHTML=Bn,St=s(),K=o("p"),K.innerHTML=Wn,At=s(),O=o("img"),Ft=s(),m(ee.$$.fragment),Qt=s(),te=o("p"),te.textContent=Xn,Dt=s(),le=o("ul"),le.innerHTML=Vn,Pt=s(),ne=o("p"),ne.innerHTML=Rn,Kt=s(),m(se.$$.fragment),Ot=s(),ae=o("p"),ae.innerHTML=Ln,el=s(),oe=o("p"),oe.textContent=zn,tl=s(),ie=o("p"),ie.innerHTML=xn,ll=s(),re=o("p"),re.textContent=qn,nl=s(),me=o("ul"),me.innerHTML=En,sl=s(),m(pe.$$.fragment),al=s(),Me=o("p"),Me.textContent=Nn,ol=s(),ue=o("p"),ue.innerHTML=Yn,il=s(),m(ce.$$.fragment),rl=s(),m(ye.$$.fragment),ml=s(),de=o("ul"),de.innerHTML=Sn,pl=s(),m(fe.$$.fragment),Ml=s(),m(he.$$.fragment),ul=s(),m(we.$$.fragment),cl=s(),Te=o("p"),Te.innerHTML=An,yl=s(),m(Je.$$.fragment),dl=s(),ge=o("img"),fl=s(),be=o("p"),be.innerHTML=Qn,hl=s(),ve=o("p"),ve.innerHTML=Dn,wl=s(),Ue=o("p"),Ue.textContent=Pn,Tl=s(),je=o("ul"),je.innerHTML=Kn,Jl=s(),Ze=o("p"),Ze.innerHTML=On,gl=s(),Ie=o("p"),Ie.innerHTML=es,bl=s(),m(_e.$$.fragment),vl=s(),$e=o("ul"),$e.innerHTML=ts,Ul=s(),m(ke.$$.fragment),jl=s(),m(Ce.$$.fragment),Zl=s(),m(Ge.$$.fragment),Il=s(),m(Be.$$.fragment),_l=s(),m(We.$$.fragment),$l=s(),He=o("p"),He.textContent=ls,kl=s(),m(Xe.$$.fragment),Cl=s(),Ve=o("p"),Ve.textContent=ns,Gl=s(),Re=o("p"),Re.innerHTML=ss,Bl=s(),Le=o("p"),Le.textContent=as,Wl=s(),ze=o("ul"),ze.innerHTML=os,Hl=s(),xe=o("img"),Xl=s(),qe=o("ul"),qe.innerHTML=rs,Vl=s(),Ee=o("p"),Ee.innerHTML=ms,Rl=s(),m(Ne.$$.fragment),Ll=s(),m(Ye.$$.fragment),zl=s(),m(Se.$$.fragment),xl=s(),Ae=o("p"),Ae.textContent=ps,ql=s(),m(Fe.$$.fragment),El=s(),m(Qe.$$.fragment),Nl=s(),m(De.$$.fragment),Yl=s(),m(Pe.$$.fragment),Sl=s(),m(Ke.$$.fragment),Al=s(),Oe=o("p"),Oe.innerHTML=Ms,Fl=s(),et=o("p"),et.innerHTML=us,Ql=s(),m(tt.$$.fragment),Dl=s(),lt=o("p"),lt.innerHTML=cs,Pl=s(),m(nt.$$.fragment),Kl=s(),st=o("p"),st.innerHTML=ys,Ol=s(),at=o("p"),at.innerHTML=ds,en=s(),tn=o("hr"),ln=s(),ot=o("p"),ot.innerHTML=fs,nn=s(),m(it.$$.fragment),sn=s(),m(rt.$$.fragment),an=s(),Mt=o("p"),this.h()},l(e){const t=vs("svelte-u9bgzb",document.head);w=i(t,"META",{name:!0,content:!0}),t.forEach(l),ut=a(e),pt=i(e,"P",{}),hs(pt).forEach(l),ct=a(e),p(T.$$.fragment,e),yt=a(e),p(J.$$.fragment,e),dt=a(e),g=i(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1rvwns4"&&(g.innerHTML=mn),ft=a(e),p(b.$$.fragment,e),ht=a(e),v=i(e,"IMG",{src:!0,alt:!0}),wt=a(e),U=i(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1emi8cy"&&(U.innerHTML=Mn),Tt=a(e),j=i(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1r1z9s5"&&(j.textContent=un),Jt=a(e),Z=i(e,"UL",{"data-svelte-h":!0}),r(Z)!=="svelte-14d2rd7"&&(Z.innerHTML=cn),gt=a(e),p(I.$$.fragment,e),bt=a(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1aajwkw"&&(_.innerHTML=yn),vt=a(e),$=i(e,"UL",{"data-svelte-h":!0}),r($)!=="svelte-17i4cff"&&($.innerHTML=dn),Ut=a(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-lt0dbq"&&(k.innerHTML=fn),jt=a(e),C=i(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-19noeh0"&&(C.innerHTML=hn),Zt=a(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1qkxyrx"&&(G.innerHTML=wn),It=a(e),p(B.$$.fragment,e),_t=a(e),W=i(e,"UL",{"data-svelte-h":!0}),r(W)!=="svelte-1funvfi"&&(W.innerHTML=Tn),$t=a(e),H=i(e,"IMG",{src:!0,alt:!0}),kt=a(e),X=i(e,"UL",{"data-svelte-h":!0}),r(X)!=="svelte-1cge6gn"&&(X.innerHTML=gn),Ct=a(e),V=i(e,"IMG",{src:!0,alt:!0}),Gt=a(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1s4z5f"&&(R.innerHTML=vn),Bt=a(e),p(L.$$.fragment,e),Wt=a(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1x4am13"&&(z.innerHTML=Un),Ht=a(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-2jys3z"&&(x.innerHTML=jn),Xt=a(e),q=i(e,"IMG",{src:!0,alt:!0}),Vt=a(e),p(E.$$.fragment,e),Rt=a(e),N=i(e,"UL",{"data-svelte-h":!0}),r(N)!=="svelte-fckxaw"&&(N.innerHTML=In),Lt=a(e),Y=i(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-10g6all"&&(Y.innerHTML=_n),zt=a(e),p(S.$$.fragment,e),xt=a(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1x9lpru"&&(A.innerHTML=$n),qt=a(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1n6rwii"&&(F.innerHTML=kn),Et=a(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-15dyw52"&&(Q.innerHTML=Cn),Nt=a(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1smvsi5"&&(D.innerHTML=Gn),Yt=a(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-hrlu55"&&(P.innerHTML=Bn),St=a(e),K=i(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1j1f3jo"&&(K.innerHTML=Wn),At=a(e),O=i(e,"IMG",{src:!0,alt:!0}),Ft=a(e),p(ee.$$.fragment,e),Qt=a(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-gd99jz"&&(te.textContent=Xn),Dt=a(e),le=i(e,"UL",{"data-svelte-h":!0}),r(le)!=="svelte-ct17ue"&&(le.innerHTML=Vn),Pt=a(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-89bve0"&&(ne.innerHTML=Rn),Kt=a(e),p(se.$$.fragment,e),Ot=a(e),ae=i(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-60uig6"&&(ae.innerHTML=Ln),el=a(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-wd45l7"&&(oe.textContent=zn),tl=a(e),ie=i(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-7tc00l"&&(ie.innerHTML=xn),ll=a(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-j6e0v0"&&(re.textContent=qn),nl=a(e),me=i(e,"UL",{"data-svelte-h":!0}),r(me)!=="svelte-120m9nl"&&(me.innerHTML=En),sl=a(e),p(pe.$$.fragment,e),al=a(e),Me=i(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-eon89t"&&(Me.textContent=Nn),ol=a(e),ue=i(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-bboubd"&&(ue.innerHTML=Yn),il=a(e),p(ce.$$.fragment,e),rl=a(e),p(ye.$$.fragment,e),ml=a(e),de=i(e,"UL",{"data-svelte-h":!0}),r(de)!=="svelte-1az788b"&&(de.innerHTML=Sn),pl=a(e),p(fe.$$.fragment,e),Ml=a(e),p(he.$$.fragment,e),ul=a(e),p(we.$$.fragment,e),cl=a(e),Te=i(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1f19xzu"&&(Te.innerHTML=An),yl=a(e),p(Je.$$.fragment,e),dl=a(e),ge=i(e,"IMG",{src:!0,alt:!0}),fl=a(e),be=i(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-1trz4y3"&&(be.innerHTML=Qn),hl=a(e),ve=i(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-1s302cc"&&(ve.innerHTML=Dn),wl=a(e),Ue=i(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-g7fw6"&&(Ue.textContent=Pn),Tl=a(e),je=i(e,"UL",{"data-svelte-h":!0}),r(je)!=="svelte-7pwo6w"&&(je.innerHTML=Kn),Jl=a(e),Ze=i(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-zzrzje"&&(Ze.innerHTML=On),gl=a(e),Ie=i(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-xo5xn7"&&(Ie.innerHTML=es),bl=a(e),p(_e.$$.fragment,e),vl=a(e),$e=i(e,"UL",{"data-svelte-h":!0}),r($e)!=="svelte-18mvbc9"&&($e.innerHTML=ts),Ul=a(e),p(ke.$$.fragment,e),jl=a(e),p(Ce.$$.fragment,e),Zl=a(e),p(Ge.$$.fragment,e),Il=a(e),p(Be.$$.fragment,e),_l=a(e),p(We.$$.fragment,e),$l=a(e),He=i(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-1fqobdf"&&(He.textContent=ls),kl=a(e),p(Xe.$$.fragment,e),Cl=a(e),Ve=i(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-6k9qpu"&&(Ve.textContent=ns),Gl=a(e),Re=i(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-932u9c"&&(Re.innerHTML=ss),Bl=a(e),Le=i(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-adopwf"&&(Le.textContent=as),Wl=a(e),ze=i(e,"UL",{"data-svelte-h":!0}),r(ze)!=="svelte-19b5tev"&&(ze.innerHTML=os),Hl=a(e),xe=i(e,"IMG",{src:!0,alt:!0}),Xl=a(e),qe=i(e,"UL",{"data-svelte-h":!0}),r(qe)!=="svelte-mbo7r4"&&(qe.innerHTML=rs),Vl=a(e),Ee=i(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-1gq4mmb"&&(Ee.innerHTML=ms),Rl=a(e),p(Ne.$$.fragment,e),Ll=a(e),p(Ye.$$.fragment,e),zl=a(e),p(Se.$$.fragment,e),xl=a(e),Ae=i(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-10mw4u3"&&(Ae.textContent=ps),ql=a(e),p(Fe.$$.fragment,e),El=a(e),p(Qe.$$.fragment,e),Nl=a(e),p(De.$$.fragment,e),Yl=a(e),p(Pe.$$.fragment,e),Sl=a(e),p(Ke.$$.fragment,e),Al=a(e),Oe=i(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-dn0c28"&&(Oe.innerHTML=Ms),Fl=a(e),et=i(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-1pu1now"&&(et.innerHTML=us),Ql=a(e),p(tt.$$.fragment,e),Dl=a(e),lt=i(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-una3pz"&&(lt.innerHTML=cs),Pl=a(e),p(nt.$$.fragment,e),Kl=a(e),st=i(e,"P",{"data-svelte-h":!0}),r(st)!=="svelte-2fsgzg"&&(st.innerHTML=ys),Ol=a(e),at=i(e,"P",{"data-svelte-h":!0}),r(at)!=="svelte-1sdymzl"&&(at.innerHTML=ds),en=a(e),tn=i(e,"HR",{}),ln=a(e),ot=i(e,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-oaatl0"&&(ot.innerHTML=fs),nn=a(e),p(it.$$.fragment,e),sn=a(e),p(rt.$$.fragment,e),an=a(e),Mt=i(e,"P",{}),hs(Mt).forEach(l),this.h()},h(){f(w,"name","hf:doc:metadata"),f(w,"content",_s),mt(v.src,pn="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit9/thumbnail2.png")||f(v,"src",pn),f(v,"alt","Thumbnail"),mt(H.src,Jn="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/gpu-step1.jpg")||f(H,"src",Jn),f(H,"alt","GPU Step 1"),mt(V.src,bn="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/gpu-step2.jpg")||f(V,"src",bn),f(V,"alt","GPU Step 2"),mt(q.src,Zn="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit9/samplefactoryenvs.png")||f(q,"src",Zn),f(q,"alt","Sample factory"),mt(O.src,Hn="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit9/samplefactory.png")||f(O,"src",Hn),f(O,"alt","Sample factory"),mt(ge.src,Fn="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit9/Health-Gathering-Supreme.png")||f(ge,"src",Fn),f(ge,"alt","Health-Gathering-Supreme"),mt(xe.src,is="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/create-token.jpg")||f(xe,"src",is),f(xe,"alt","Create HF Token")},m(e,t){Us(document.head,w),n(e,ut,t),n(e,pt,t),n(e,ct,t),M(T,e,t),n(e,yt,t),M(J,e,t),n(e,dt,t),n(e,g,t),n(e,ft,t),M(b,e,t),n(e,ht,t),n(e,v,t),n(e,wt,t),n(e,U,t),n(e,Tt,t),n(e,j,t),n(e,Jt,t),n(e,Z,t),n(e,gt,t),M(I,e,t),n(e,bt,t),n(e,_,t),n(e,vt,t),n(e,$,t),n(e,Ut,t),n(e,k,t),n(e,jt,t),n(e,C,t),n(e,Zt,t),n(e,G,t),n(e,It,t),M(B,e,t),n(e,_t,t),n(e,W,t),n(e,$t,t),n(e,H,t),n(e,kt,t),n(e,X,t),n(e,Ct,t),n(e,V,t),n(e,Gt,t),n(e,R,t),n(e,Bt,t),M(L,e,t),n(e,Wt,t),n(e,z,t),n(e,Ht,t),n(e,x,t),n(e,Xt,t),n(e,q,t),n(e,Vt,t),M(E,e,t),n(e,Rt,t),n(e,N,t),n(e,Lt,t),n(e,Y,t),n(e,zt,t),M(S,e,t),n(e,xt,t),n(e,A,t),n(e,qt,t),n(e,F,t),n(e,Et,t),n(e,Q,t),n(e,Nt,t),n(e,D,t),n(e,Yt,t),n(e,P,t),n(e,St,t),n(e,K,t),n(e,At,t),n(e,O,t),n(e,Ft,t),M(ee,e,t),n(e,Qt,t),n(e,te,t),n(e,Dt,t),n(e,le,t),n(e,Pt,t),n(e,ne,t),n(e,Kt,t),M(se,e,t),n(e,Ot,t),n(e,ae,t),n(e,el,t),n(e,oe,t),n(e,tl,t),n(e,ie,t),n(e,ll,t),n(e,re,t),n(e,nl,t),n(e,me,t),n(e,sl,t),M(pe,e,t),n(e,al,t),n(e,Me,t),n(e,ol,t),n(e,ue,t),n(e,il,t),M(ce,e,t),n(e,rl,t),M(ye,e,t),n(e,ml,t),n(e,de,t),n(e,pl,t),M(fe,e,t),n(e,Ml,t),M(he,e,t),n(e,ul,t),M(we,e,t),n(e,cl,t),n(e,Te,t),n(e,yl,t),M(Je,e,t),n(e,dl,t),n(e,ge,t),n(e,fl,t),n(e,be,t),n(e,hl,t),n(e,ve,t),n(e,wl,t),n(e,Ue,t),n(e,Tl,t),n(e,je,t),n(e,Jl,t),n(e,Ze,t),n(e,gl,t),n(e,Ie,t),n(e,bl,t),M(_e,e,t),n(e,vl,t),n(e,$e,t),n(e,Ul,t),M(ke,e,t),n(e,jl,t),M(Ce,e,t),n(e,Zl,t),M(Ge,e,t),n(e,Il,t),M(Be,e,t),n(e,_l,t),M(We,e,t),n(e,$l,t),n(e,He,t),n(e,kl,t),M(Xe,e,t),n(e,Cl,t),n(e,Ve,t),n(e,Gl,t),n(e,Re,t),n(e,Bl,t),n(e,Le,t),n(e,Wl,t),n(e,ze,t),n(e,Hl,t),n(e,xe,t),n(e,Xl,t),n(e,qe,t),n(e,Vl,t),n(e,Ee,t),n(e,Rl,t),M(Ne,e,t),n(e,Ll,t),M(Ye,e,t),n(e,zl,t),M(Se,e,t),n(e,xl,t),n(e,Ae,t),n(e,ql,t),M(Fe,e,t),n(e,El,t),M(Qe,e,t),n(e,Nl,t),M(De,e,t),n(e,Yl,t),M(Pe,e,t),n(e,Sl,t),M(Ke,e,t),n(e,Al,t),n(e,Oe,t),n(e,Fl,t),n(e,et,t),n(e,Ql,t),M(tt,e,t),n(e,Dl,t),n(e,lt,t),n(e,Pl,t),M(nt,e,t),n(e,Kl,t),n(e,st,t),n(e,Ol,t),n(e,at,t),n(e,en,t),n(e,tn,t),n(e,ln,t),n(e,ot,t),n(e,nn,t),M(it,e,t),n(e,sn,t),M(rt,e,t),n(e,an,t),n(e,Mt,t),on=!0},p:Ts,i(e){on||(u(T.$$.fragment,e),u(J.$$.fragment,e),u(b.$$.fragment,e),u(I.$$.fragment,e),u(B.$$.fragment,e),u(L.$$.fragment,e),u(E.$$.fragment,e),u(S.$$.fragment,e),u(ee.$$.fragment,e),u(se.$$.fragment,e),u(pe.$$.fragment,e),u(ce.$$.fragment,e),u(ye.$$.fragment,e),u(fe.$$.fragment,e),u(he.$$.fragment,e),u(we.$$.fragment,e),u(Je.$$.fragment,e),u(_e.$$.fragment,e),u(ke.$$.fragment,e),u(Ce.$$.fragment,e),u(Ge.$$.fragment,e),u(Be.$$.fragment,e),u(We.$$.fragment,e),u(Xe.$$.fragment,e),u(Ne.$$.fragment,e),u(Ye.$$.fragment,e),u(Se.$$.fragment,e),u(Fe.$$.fragment,e),u(Qe.$$.fragment,e),u(De.$$.fragment,e),u(Pe.$$.fragment,e),u(Ke.$$.fragment,e),u(tt.$$.fragment,e),u(nt.$$.fragment,e),u(it.$$.fragment,e),u(rt.$$.fragment,e),on=!0)},o(e){c(T.$$.fragment,e),c(J.$$.fragment,e),c(b.$$.fragment,e),c(I.$$.fragment,e),c(B.$$.fragment,e),c(L.$$.fragment,e),c(E.$$.fragment,e),c(S.$$.fragment,e),c(ee.$$.fragment,e),c(se.$$.fragment,e),c(pe.$$.fragment,e),c(ce.$$.fragment,e),c(ye.$$.fragment,e),c(fe.$$.fragment,e),c(he.$$.fragment,e),c(we.$$.fragment,e),c(Je.$$.fragment,e),c(_e.$$.fragment,e),c(ke.$$.fragment,e),c(Ce.$$.fragment,e),c(Ge.$$.fragment,e),c(Be.$$.fragment,e),c(We.$$.fragment,e),c(Xe.$$.fragment,e),c(Ne.$$.fragment,e),c(Ye.$$.fragment,e),c(Se.$$.fragment,e),c(Fe.$$.fragment,e),c(Qe.$$.fragment,e),c(De.$$.fragment,e),c(Pe.$$.fragment,e),c(Ke.$$.fragment,e),c(tt.$$.fragment,e),c(nt.$$.fragment,e),c(it.$$.fragment,e),c(rt.$$.fragment,e),on=!1},d(e){e&&(l(ut),l(pt),l(ct),l(yt),l(dt),l(g),l(ft),l(ht),l(v),l(wt),l(U),l(Tt),l(j),l(Jt),l(Z),l(gt),l(bt),l(_),l(vt),l($),l(Ut),l(k),l(jt),l(C),l(Zt),l(G),l(It),l(_t),l(W),l($t),l(H),l(kt),l(X),l(Ct),l(V),l(Gt),l(R),l(Bt),l(Wt),l(z),l(Ht),l(x),l(Xt),l(q),l(Vt),l(Rt),l(N),l(Lt),l(Y),l(zt),l(xt),l(A),l(qt),l(F),l(Et),l(Q),l(Nt),l(D),l(Yt),l(P),l(St),l(K),l(At),l(O),l(Ft),l(Qt),l(te),l(Dt),l(le),l(Pt),l(ne),l(Kt),l(Ot),l(ae),l(el),l(oe),l(tl),l(ie),l(ll),l(re),l(nl),l(me),l(sl),l(al),l(Me),l(ol),l(ue),l(il),l(rl),l(ml),l(de),l(pl),l(Ml),l(ul),l(cl),l(Te),l(yl),l(dl),l(ge),l(fl),l(be),l(hl),l(ve),l(wl),l(Ue),l(Tl),l(je),l(Jl),l(Ze),l(gl),l(Ie),l(bl),l(vl),l($e),l(Ul),l(jl),l(Zl),l(Il),l(_l),l($l),l(He),l(kl),l(Cl),l(Ve),l(Gl),l(Re),l(Bl),l(Le),l(Wl),l(ze),l(Hl),l(xe),l(Xl),l(qe),l(Vl),l(Ee),l(Rl),l(Ll),l(zl),l(xl),l(Ae),l(ql),l(El),l(Nl),l(Yl),l(Sl),l(Al),l(Oe),l(Fl),l(et),l(Ql),l(Dl),l(lt),l(Pl),l(Kl),l(st),l(Ol),l(at),l(en),l(tn),l(ln),l(ot),l(nn),l(sn),l(an),l(Mt)),l(w),y(T,e),y(J,e),y(b,e),y(I,e),y(B,e),y(L,e),y(E,e),y(S,e),y(ee,e),y(se,e),y(pe,e),y(ce,e),y(ye,e),y(fe,e),y(he,e),y(we,e),y(Je,e),y(_e,e),y(ke,e),y(Ce,e),y(Ge,e),y(Be,e),y(We,e),y(Xe,e),y(Ne,e),y(Ye,e),y(Se,e),y(Fe,e),y(Qe,e),y(De,e),y(Pe,e),y(Ke,e),y(tt,e),y(nt,e),y(it,e),y(rt,e)}}}const _s='{"title":"Hands-on: advanced Deep Reinforcement Learning. Using Sample Factory to play Doom from pixels","local":"hands-on-advanced-deep-reinforcement-learning-using-sample-factory-to-play-doom-from-pixels","sections":[],"depth":1}';function $s(rn){return Js(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Hs extends gs{constructor(w){super(),bs(this,w,$s,Is,ws,{})}}export{Hs as component};
