import{s as st,f as et,o as tt,n as Oe}from"../chunks/scheduler.85c25b89.js";import{S as at,i as nt,g as p,s as n,r,A as lt,h as i,f as t,c as l,j as qe,u as m,x as d,k as Ms,y as pt,a,v as c,d as o,t as h,w as g}from"../chunks/index.c9837788.js";import{T as De}from"../chunks/Tip.6bd863a0.js";import{C as j}from"../chunks/CodeBlock.52fa569e.js";import{H as $s,E as it}from"../chunks/EditOnGithub.b65eee75.js";function rt(xs){let f,b="<strong>Note:</strong> The returned PyTorch model is set to train mode by default, so you must call <code>.eval()</code> on it if you plan to use it for inference.";return{c(){f=p("p"),f.innerHTML=b},l(u){f=i(u,"P",{"data-svelte-h":!0}),d(f)!=="svelte-1i1h0ed"&&(f.innerHTML=b)},m(u,$){a(u,f,$)},p:Oe,d(u){u&&t(f)}}}function mt(xs){let f,b="<strong>Note:</strong> Here, the pretrained model’s config happens to be the same as the generic config we made earlier. This is not always the case. So, it’s safer to use the data config to create the transform as we did here instead of using the generic transform.";return{c(){f=p("p"),f.innerHTML=b},l(u){f=i(u,"P",{"data-svelte-h":!0}),d(f)!=="svelte-n3zkvc"&&(f.innerHTML=b)},m(u,$){a(u,f,$)},p:Oe,d(u){u&&t(f)}}}function ct(xs){let f,b,u,$,_,_s,y,_e="This quickstart is intended for developers who are ready to dive into the code and see an example of how to integrate <code>timm</code> into their model training workflow.",ys,T,ye='First, you’ll need to install <code>timm</code>. For more information on installation, see <a href="installation">Installation</a>.',Ts,v,vs,J,Js,W,Te='Pretrained models can be loaded using <a href="/docs/timm/pr_2336/en/reference/models#timm.create_model">create_model()</a>.',Ws,k,ve="Here, we load the pretrained <code>mobilenetv3_large_100</code> model.",ks,Z,Zs,x,Cs,C,Us,U,Je='To list models packaged with <code>timm</code>, you can use <a href="/docs/timm/pr_2336/en/reference/models#timm.list_models">list_models()</a>. If you specify <code>pretrained=True</code>, this function will only return model names that have associated pretrained weights available.',Hs,H,Rs,R,We="You can also list models with a specific pattern in their name.",Fs,F,Vs,V,Ls,L,ke="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",Ns,N,Gs,G,Ze='To fine-tune on your own dataset, you have to write a PyTorch training loop or adapt <code>timm</code>’s <a href="training_script">training script</a> to use your dataset.',zs,z,Qs,Q,Ce="Without modifying the network, one can call model.forward_features(input) on any model instead of the usual model(input). This will bypass the head classifier and global pooling for networks.",Es,E,Ue='For a more in depth guide to using <code>timm</code> for feature extraction, see <a href="feature_extraction">Feature Extraction</a>.',Is,I,Bs,B,Ps,P,He='To transform images into valid inputs for a model, you can use <a href="/docs/timm/pr_2336/en/reference/data#timm.data.create_transform">timm.data.create_transform()</a>, providing the desired <code>input_size</code> that the model expects.',Xs,X,Re="This will return a generic transform that uses reasonable defaults.",Ss,S,Ys,Y,Fe="Pretrained models have specific transforms that were applied to images fed into them while training. If you use the wrong transform on your image, the model won’t understand what it’s seeing!",As,A,Ve="To figure out which transformations were used for a given pretrained model, we can start by taking a look at its <code>pretrained_cfg</code>",Ks,K,qs,q,Le='We can then resolve only the data related configuration by using <a href="/docs/timm/pr_2336/en/reference/data#timm.data.resolve_data_config">timm.data.resolve_data_config()</a>.',Ds,D,Os,O,Ne='We can pass this data config to <a href="/docs/timm/pr_2336/en/reference/data#timm.data.create_transform">timm.data.create_transform()</a> to initialize the model’s associated transform.',se,ss,ee,w,te,es,ae,ts,Ge="Here, we will put together the above sections and use a pretrained model for inference.",ne,as,ze="First we’ll need an image to do inference on. Here we load a picture of a leaf from the web:",le,ns,pe,ls,Qe="Here’s the image we loaded:",ie,M,Ee,re,ps,Ie="Now, we’ll create our model and transforms again. This time, we make sure to set our model in evaluation mode.",me,is,ce,rs,Be="We can prepare this image for the model by passing it to the transform.",oe,ms,he,cs,Pe="Now we can pass that image to the model to get the predictions. We use <code>unsqueeze(0)</code> in this case, as the model is expecting a batch dimension.",ge,os,de,hs,Xe="To get the predicted probabilities, we apply softmax to the output. This leaves us with a tensor of shape <code>(num_classes,)</code>.",fe,gs,ue,ds,Se="Now we’ll find the top 5 predicted class indexes and values using <code>torch.topk</code>.",je,fs,be,us,Ye="If we check the imagenet labels for the top index, we can see what the model predicted…",$e,js,xe,bs,we,ws,Me;return _=new $s({props:{title:"Quickstart",local:"quickstart",headingTag:"h1"}}),v=new j({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRpbW0=",highlighted:"pip install timm",wrap:!1}}),J=new $s({props:{title:"Load a Pretrained Model",local:"load-a-pretrained-model",headingTag:"h2"}}),Z=new j({props:{code:"aW1wb3J0JTIwdGltbSUwQSUwQW0lMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnbW9iaWxlbmV0djNfbGFyZ2VfMTAwJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW0uZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm

<span class="hljs-meta">&gt;&gt;&gt; </span>m = timm.create_model(<span class="hljs-string">&#x27;mobilenetv3_large_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>m.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),x=new De({props:{$$slots:{default:[rt]},$$scope:{ctx:xs}}}),C=new $s({props:{title:"List Models with Pretrained Weights",local:"list-models-with-pretrained-weights",headingTag:"h2"}}),H=new j({props:{code:"aW1wb3J0JTIwdGltbSUwQWZyb20lMjBwcHJpbnQlMjBpbXBvcnQlMjBwcHJpbnQlMEFtb2RlbF9uYW1lcyUyMCUzRCUyMHRpbW0ubGlzdF9tb2RlbHMocHJldHJhaW5lZCUzRFRydWUpJTBBcHByaW50KG1vZGVsX25hbWVzKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pprint <span class="hljs-keyword">import</span> pprint
<span class="hljs-meta">&gt;&gt;&gt; </span>model_names = timm.list_models(pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pprint(model_names)
[
    <span class="hljs-string">&#x27;adv_inception_v3&#x27;</span>,
    <span class="hljs-string">&#x27;cspdarknet53&#x27;</span>,
    <span class="hljs-string">&#x27;cspresnext50&#x27;</span>,
    <span class="hljs-string">&#x27;densenet121&#x27;</span>,
    <span class="hljs-string">&#x27;densenet161&#x27;</span>,
    <span class="hljs-string">&#x27;densenet169&#x27;</span>,
    <span class="hljs-string">&#x27;densenet201&#x27;</span>,
    <span class="hljs-string">&#x27;densenetblur121d&#x27;</span>,
    <span class="hljs-string">&#x27;dla34&#x27;</span>,
    <span class="hljs-string">&#x27;dla46_c&#x27;</span>,
]`,wrap:!1}}),F=new j({props:{code:"aW1wb3J0JTIwdGltbSUwQWZyb20lMjBwcHJpbnQlMjBpbXBvcnQlMjBwcHJpbnQlMEFtb2RlbF9uYW1lcyUyMCUzRCUyMHRpbW0ubGlzdF9tb2RlbHMoJypyZXNuZSp0KicpJTBBcHByaW50KG1vZGVsX25hbWVzKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pprint <span class="hljs-keyword">import</span> pprint
<span class="hljs-meta">&gt;&gt;&gt; </span>model_names = timm.list_models(<span class="hljs-string">&#x27;*resne*t*&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pprint(model_names)
[
    <span class="hljs-string">&#x27;cspresnet50&#x27;</span>,
    <span class="hljs-string">&#x27;cspresnet50d&#x27;</span>,
    <span class="hljs-string">&#x27;cspresnet50w&#x27;</span>,
    <span class="hljs-string">&#x27;cspresnext50&#x27;</span>,
    ...
]`,wrap:!1}}),V=new $s({props:{title:"Fine-Tune a Pretrained Model",local:"fine-tune-a-pretrained-model",headingTag:"h2"}}),N=new j({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnbW9iaWxlbmV0djNfbGFyZ2VfMTAwJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;mobilenetv3_large_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),z=new $s({props:{title:"Use a Pretrained Model for Feature Extraction",local:"use-a-pretrained-model-for-feature-extraction",headingTag:"h2"}}),I=new j({props:{code:"aW1wb3J0JTIwdGltbSUwQWltcG9ydCUyMHRvcmNoJTBBeCUyMCUzRCUyMHRvcmNoLnJhbmRuKDElMkMlMjAzJTJDJTIwMjI0JTJDJTIwMjI0KSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ21vYmlsZW5ldHYzX2xhcmdlXzEwMCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFmZWF0dXJlcyUyMCUzRCUyMG1vZGVsLmZvcndhcmRfZmVhdHVyZXMoeCklMEFwcmludChmZWF0dXJlcy5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span>x = torch.randn(<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;mobilenetv3_large_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>features = model.forward_features(x)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(features.shape)
torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">960</span>, <span class="hljs-number">7</span>, <span class="hljs-number">7</span>])`,wrap:!1}}),B=new $s({props:{title:"Image Augmentation",local:"image-augmentation",headingTag:"h2"}}),S=new j({props:{code:"dGltbS5kYXRhLmNyZWF0ZV90cmFuc2Zvcm0oKDMlMkMlMjAyMjQlMkMlMjAyMjQpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>timm.data.create_transform((<span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
Compose(
    Resize(size=<span class="hljs-number">256</span>, interpolation=bilinear, max_size=<span class="hljs-literal">None</span>, antialias=<span class="hljs-literal">None</span>)
    CenterCrop(size=(<span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
    ToTensor()
    Normalize(mean=tensor([<span class="hljs-number">0.4850</span>, <span class="hljs-number">0.4560</span>, <span class="hljs-number">0.4060</span>]), std=tensor([<span class="hljs-number">0.2290</span>, <span class="hljs-number">0.2240</span>, <span class="hljs-number">0.2250</span>]))
)`,wrap:!1}}),K=new j({props:{code:"bW9kZWwucHJldHJhaW5lZF9jZmc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>model.pretrained_cfg
{<span class="hljs-string">&#x27;url&#x27;</span>: <span class="hljs-string">&#x27;https://github.com/rwightman/pytorch-image-models/releases/download/v0.1-weights/mobilenetv3_large_100_ra-f55367f5.pth&#x27;</span>,
 <span class="hljs-string">&#x27;num_classes&#x27;</span>: <span class="hljs-number">1000</span>,
 <span class="hljs-string">&#x27;input_size&#x27;</span>: (<span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>),
 <span class="hljs-string">&#x27;pool_size&#x27;</span>: (<span class="hljs-number">7</span>, <span class="hljs-number">7</span>),
 <span class="hljs-string">&#x27;crop_pct&#x27;</span>: <span class="hljs-number">0.875</span>,
 <span class="hljs-string">&#x27;interpolation&#x27;</span>: <span class="hljs-string">&#x27;bicubic&#x27;</span>,
 <span class="hljs-string">&#x27;mean&#x27;</span>: (<span class="hljs-number">0.485</span>, <span class="hljs-number">0.456</span>, <span class="hljs-number">0.406</span>),
 <span class="hljs-string">&#x27;std&#x27;</span>: (<span class="hljs-number">0.229</span>, <span class="hljs-number">0.224</span>, <span class="hljs-number">0.225</span>),
 <span class="hljs-string">&#x27;first_conv&#x27;</span>: <span class="hljs-string">&#x27;conv_stem&#x27;</span>,
 <span class="hljs-string">&#x27;classifier&#x27;</span>: <span class="hljs-string">&#x27;classifier&#x27;</span>,
 <span class="hljs-string">&#x27;architecture&#x27;</span>: <span class="hljs-string">&#x27;mobilenetv3_large_100&#x27;</span>}`,wrap:!1}}),D=new j({props:{code:"dGltbS5kYXRhLnJlc29sdmVfZGF0YV9jb25maWcobW9kZWwucHJldHJhaW5lZF9jZmcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>timm.data.resolve_data_config(model.pretrained_cfg)
{<span class="hljs-string">&#x27;input_size&#x27;</span>: (<span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>),
 <span class="hljs-string">&#x27;interpolation&#x27;</span>: <span class="hljs-string">&#x27;bicubic&#x27;</span>,
 <span class="hljs-string">&#x27;mean&#x27;</span>: (<span class="hljs-number">0.485</span>, <span class="hljs-number">0.456</span>, <span class="hljs-number">0.406</span>),
 <span class="hljs-string">&#x27;std&#x27;</span>: (<span class="hljs-number">0.229</span>, <span class="hljs-number">0.224</span>, <span class="hljs-number">0.225</span>),
 <span class="hljs-string">&#x27;crop_pct&#x27;</span>: <span class="hljs-number">0.875</span>}`,wrap:!1}}),ss=new j({props:{code:"ZGF0YV9jZmclMjAlM0QlMjB0aW1tLmRhdGEucmVzb2x2ZV9kYXRhX2NvbmZpZyhtb2RlbC5wcmV0cmFpbmVkX2NmZyklMEF0cmFuc2Zvcm0lMjAlM0QlMjB0aW1tLmRhdGEuY3JlYXRlX3RyYW5zZm9ybSgqKmRhdGFfY2ZnKSUwQXRyYW5zZm9ybQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>data_cfg = timm.data.resolve_data_config(model.pretrained_cfg)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = timm.data.create_transform(**data_cfg)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform
Compose(
    Resize(size=<span class="hljs-number">256</span>, interpolation=bicubic, max_size=<span class="hljs-literal">None</span>, antialias=<span class="hljs-literal">None</span>)
    CenterCrop(size=(<span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
    ToTensor()
    Normalize(mean=tensor([<span class="hljs-number">0.4850</span>, <span class="hljs-number">0.4560</span>, <span class="hljs-number">0.4060</span>]), std=tensor([<span class="hljs-number">0.2290</span>, <span class="hljs-number">0.2240</span>, <span class="hljs-number">0.2250</span>]))
)`,wrap:!1}}),w=new De({props:{$$slots:{default:[mt]},$$scope:{ctx:xs}}}),es=new $s({props:{title:"Using Pretrained Models for Inference",local:"using-pretrained-models-for-inference",headingTag:"h2"}}),ns=new j({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwaW8lMjBpbXBvcnQlMjBCeXRlc0lPJTBBdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGZGF0YXNldHMtc2VydmVyLmh1Z2dpbmdmYWNlLmNvJTJGYXNzZXRzJTJGaW1hZ2VuZXQtMWslMkYtLSUyRmRlZmF1bHQlMkZ0ZXN0JTJGMTIlMkZpbWFnZSUyRmltYWdlLmpwZyclMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFpbWFnZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&#x27;https://datasets-server.huggingface.co/assets/imagenet-1k/--/default/test/12/image/image.jpg&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),is=new j({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnbW9iaWxlbmV0djNfbGFyZ2VfMTAwJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKS5ldmFsKCklMEF0cmFuc2Zvcm0lMjAlM0QlMjB0aW1tLmRhdGEuY3JlYXRlX3RyYW5zZm9ybSg=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;mobilenetv3_large_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>).<span class="hljs-built_in">eval</span>()
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = timm.data.create_transform(
    **timm.data.resolve_data_config(model.pretrained_cfg)
)`,wrap:!1}}),ms=new j({props:{code:"aW1hZ2VfdGVuc29yJTIwJTNEJTIwdHJhbnNmb3JtKGltYWdlKSUwQWltYWdlX3RlbnNvci5zaGFwZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>image_tensor = transform(image)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_tensor.shape
torch.Size([<span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>])`,wrap:!1}}),os=new j({props:{code:"b3V0cHV0JTIwJTNEJTIwbW9kZWwoaW1hZ2VfdGVuc29yLnVuc3F1ZWV6ZSgwKSklMEFvdXRwdXQuc2hhcGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>output = model(image_tensor.unsqueeze(<span class="hljs-number">0</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>output.shape
torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">1000</span>])`,wrap:!1}}),gs=new j({props:{code:"cHJvYmFiaWxpdGllcyUyMCUzRCUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwuc29mdG1heChvdXRwdXQlNUIwJTVEJTJDJTIwZGltJTNEMCklMEFwcm9iYWJpbGl0aWVzLnNoYXBl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(output[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities.shape
torch.Size([<span class="hljs-number">1000</span>])`,wrap:!1}}),fs=new j({props:{code:"dmFsdWVzJTJDJTIwaW5kaWNlcyUyMCUzRCUyMHRvcmNoLnRvcGsocHJvYmFiaWxpdGllcyUyQyUyMDUpJTBBaW5kaWNlcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>values, indices = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>indices
tensor([<span class="hljs-number">162</span>, <span class="hljs-number">166</span>, <span class="hljs-number">161</span>, <span class="hljs-number">164</span>, <span class="hljs-number">167</span>])`,wrap:!1}}),js=new j({props:{code:"SU1BR0VORVRfMWtfVVJMJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGc3RvcmFnZS5nb29nbGVhcGlzLmNvbSUyRmJpdF9tb2RlbHMlMkZpbHN2cmMyMDEyX3dvcmRuZXRfbGVtbWFzLnR4dCclMEFJTUFHRU5FVF8xa19MQUJFTFMlMjAlM0QlMjByZXF1ZXN0cy5nZXQoSU1BR0VORVRfMWtfVVJMKS50ZXh0LnN0cmlwKCkuc3BsaXQoJyU1Q24nKSUwQSU1QiU3QidsYWJlbCclM0ElMjBJTUFHRU5FVF8xa19MQUJFTFMlNUJpZHglNUQlMkMlMjAndmFsdWUnJTNBJTIwdmFsLml0ZW0oKSU3RCUyMGZvciUyMHZhbCUyQyUyMGlkeCUyMGluJTIwemlwKHZhbHVlcyUyQyUyMGluZGljZXMpJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>IMAGENET_1k_URL = <span class="hljs-string">&#x27;https://storage.googleapis.com/bit_models/ilsvrc2012_wordnet_lemmas.txt&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>IMAGENET_1k_LABELS = requests.get(IMAGENET_1k_URL).text.strip().split(<span class="hljs-string">&#x27;\\n&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>[{<span class="hljs-string">&#x27;label&#x27;</span>: IMAGENET_1k_LABELS[idx], <span class="hljs-string">&#x27;value&#x27;</span>: val.item()} <span class="hljs-keyword">for</span> val, idx <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(values, indices)]
[{<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;beagle&#x27;</span>, <span class="hljs-string">&#x27;value&#x27;</span>: <span class="hljs-number">0.8486220836639404</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;Walker_hound, Walker_foxhound&#x27;</span>, <span class="hljs-string">&#x27;value&#x27;</span>: <span class="hljs-number">0.03753996267914772</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;basset, basset_hound&#x27;</span>, <span class="hljs-string">&#x27;value&#x27;</span>: <span class="hljs-number">0.024628572165966034</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;bluetick&#x27;</span>, <span class="hljs-string">&#x27;value&#x27;</span>: <span class="hljs-number">0.010317106731235981</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;English_foxhound&#x27;</span>, <span class="hljs-string">&#x27;value&#x27;</span>: <span class="hljs-number">0.006958036217838526</span>}]`,wrap:!1}}),bs=new it({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/quickstart.mdx"}}),{c(){f=p("meta"),b=n(),u=p("p"),$=n(),r(_.$$.fragment),_s=n(),y=p("p"),y.innerHTML=_e,ys=n(),T=p("p"),T.innerHTML=ye,Ts=n(),r(v.$$.fragment),vs=n(),r(J.$$.fragment),Js=n(),W=p("p"),W.innerHTML=Te,Ws=n(),k=p("p"),k.innerHTML=ve,ks=n(),r(Z.$$.fragment),Zs=n(),r(x.$$.fragment),Cs=n(),r(C.$$.fragment),Us=n(),U=p("p"),U.innerHTML=Je,Hs=n(),r(H.$$.fragment),Rs=n(),R=p("p"),R.textContent=We,Fs=n(),r(F.$$.fragment),Vs=n(),r(V.$$.fragment),Ls=n(),L=p("p"),L.textContent=ke,Ns=n(),r(N.$$.fragment),Gs=n(),G=p("p"),G.innerHTML=Ze,zs=n(),r(z.$$.fragment),Qs=n(),Q=p("p"),Q.textContent=Ce,Es=n(),E=p("p"),E.innerHTML=Ue,Is=n(),r(I.$$.fragment),Bs=n(),r(B.$$.fragment),Ps=n(),P=p("p"),P.innerHTML=He,Xs=n(),X=p("p"),X.textContent=Re,Ss=n(),r(S.$$.fragment),Ys=n(),Y=p("p"),Y.textContent=Fe,As=n(),A=p("p"),A.innerHTML=Ve,Ks=n(),r(K.$$.fragment),qs=n(),q=p("p"),q.innerHTML=Le,Ds=n(),r(D.$$.fragment),Os=n(),O=p("p"),O.innerHTML=Ne,se=n(),r(ss.$$.fragment),ee=n(),r(w.$$.fragment),te=n(),r(es.$$.fragment),ae=n(),ts=p("p"),ts.textContent=Ge,ne=n(),as=p("p"),as.textContent=ze,le=n(),r(ns.$$.fragment),pe=n(),ls=p("p"),ls.textContent=Qe,ie=n(),M=p("img"),re=n(),ps=p("p"),ps.textContent=Ie,me=n(),r(is.$$.fragment),ce=n(),rs=p("p"),rs.textContent=Be,oe=n(),r(ms.$$.fragment),he=n(),cs=p("p"),cs.innerHTML=Pe,ge=n(),r(os.$$.fragment),de=n(),hs=p("p"),hs.innerHTML=Xe,fe=n(),r(gs.$$.fragment),ue=n(),ds=p("p"),ds.innerHTML=Se,je=n(),r(fs.$$.fragment),be=n(),us=p("p"),us.textContent=Ye,$e=n(),r(js.$$.fragment),xe=n(),r(bs.$$.fragment),we=n(),ws=p("p"),this.h()},l(s){const e=lt("svelte-u9bgzb",document.head);f=i(e,"META",{name:!0,content:!0}),e.forEach(t),b=l(s),u=i(s,"P",{}),qe(u).forEach(t),$=l(s),m(_.$$.fragment,s),_s=l(s),y=i(s,"P",{"data-svelte-h":!0}),d(y)!=="svelte-1mt2wpi"&&(y.innerHTML=_e),ys=l(s),T=i(s,"P",{"data-svelte-h":!0}),d(T)!=="svelte-15vunib"&&(T.innerHTML=ye),Ts=l(s),m(v.$$.fragment,s),vs=l(s),m(J.$$.fragment,s),Js=l(s),W=i(s,"P",{"data-svelte-h":!0}),d(W)!=="svelte-1rs67u9"&&(W.innerHTML=Te),Ws=l(s),k=i(s,"P",{"data-svelte-h":!0}),d(k)!=="svelte-11h2wfj"&&(k.innerHTML=ve),ks=l(s),m(Z.$$.fragment,s),Zs=l(s),m(x.$$.fragment,s),Cs=l(s),m(C.$$.fragment,s),Us=l(s),U=i(s,"P",{"data-svelte-h":!0}),d(U)!=="svelte-1tgcf17"&&(U.innerHTML=Je),Hs=l(s),m(H.$$.fragment,s),Rs=l(s),R=i(s,"P",{"data-svelte-h":!0}),d(R)!=="svelte-15bjls3"&&(R.textContent=We),Fs=l(s),m(F.$$.fragment,s),Vs=l(s),m(V.$$.fragment,s),Ls=l(s),L=i(s,"P",{"data-svelte-h":!0}),d(L)!=="svelte-9sr7nh"&&(L.textContent=ke),Ns=l(s),m(N.$$.fragment,s),Gs=l(s),G=i(s,"P",{"data-svelte-h":!0}),d(G)!=="svelte-17jj7hb"&&(G.innerHTML=Ze),zs=l(s),m(z.$$.fragment,s),Qs=l(s),Q=i(s,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-1bs7nra"&&(Q.textContent=Ce),Es=l(s),E=i(s,"P",{"data-svelte-h":!0}),d(E)!=="svelte-1ufypal"&&(E.innerHTML=Ue),Is=l(s),m(I.$$.fragment,s),Bs=l(s),m(B.$$.fragment,s),Ps=l(s),P=i(s,"P",{"data-svelte-h":!0}),d(P)!=="svelte-1eu5c10"&&(P.innerHTML=He),Xs=l(s),X=i(s,"P",{"data-svelte-h":!0}),d(X)!=="svelte-14s5fqt"&&(X.textContent=Re),Ss=l(s),m(S.$$.fragment,s),Ys=l(s),Y=i(s,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-jniymz"&&(Y.textContent=Fe),As=l(s),A=i(s,"P",{"data-svelte-h":!0}),d(A)!=="svelte-1qp841i"&&(A.innerHTML=Ve),Ks=l(s),m(K.$$.fragment,s),qs=l(s),q=i(s,"P",{"data-svelte-h":!0}),d(q)!=="svelte-kdt18i"&&(q.innerHTML=Le),Ds=l(s),m(D.$$.fragment,s),Os=l(s),O=i(s,"P",{"data-svelte-h":!0}),d(O)!=="svelte-uckjyf"&&(O.innerHTML=Ne),se=l(s),m(ss.$$.fragment,s),ee=l(s),m(w.$$.fragment,s),te=l(s),m(es.$$.fragment,s),ae=l(s),ts=i(s,"P",{"data-svelte-h":!0}),d(ts)!=="svelte-1vfr0rj"&&(ts.textContent=Ge),ne=l(s),as=i(s,"P",{"data-svelte-h":!0}),d(as)!=="svelte-1u7llub"&&(as.textContent=ze),le=l(s),m(ns.$$.fragment,s),pe=l(s),ls=i(s,"P",{"data-svelte-h":!0}),d(ls)!=="svelte-nk223p"&&(ls.textContent=Qe),ie=l(s),M=i(s,"IMG",{src:!0,alt:!0,width:!0}),re=l(s),ps=i(s,"P",{"data-svelte-h":!0}),d(ps)!=="svelte-1lr3iea"&&(ps.textContent=Ie),me=l(s),m(is.$$.fragment,s),ce=l(s),rs=i(s,"P",{"data-svelte-h":!0}),d(rs)!=="svelte-8vriuk"&&(rs.textContent=Be),oe=l(s),m(ms.$$.fragment,s),he=l(s),cs=i(s,"P",{"data-svelte-h":!0}),d(cs)!=="svelte-ql7fkr"&&(cs.innerHTML=Pe),ge=l(s),m(os.$$.fragment,s),de=l(s),hs=i(s,"P",{"data-svelte-h":!0}),d(hs)!=="svelte-1sn7t3l"&&(hs.innerHTML=Xe),fe=l(s),m(gs.$$.fragment,s),ue=l(s),ds=i(s,"P",{"data-svelte-h":!0}),d(ds)!=="svelte-1bct4ll"&&(ds.innerHTML=Se),je=l(s),m(fs.$$.fragment,s),be=l(s),us=i(s,"P",{"data-svelte-h":!0}),d(us)!=="svelte-9q87ex"&&(us.textContent=Ye),$e=l(s),m(js.$$.fragment,s),xe=l(s),m(bs.$$.fragment,s),we=l(s),ws=i(s,"P",{}),qe(ws).forEach(t),this.h()},h(){Ms(f,"name","hf:doc:metadata"),Ms(f,"content",ot),et(M.src,Ee="https://datasets-server.huggingface.co/assets/imagenet-1k/--/default/test/12/image/image.jpg")||Ms(M,"src",Ee),Ms(M,"alt","An Image from a link"),Ms(M,"width","300")},m(s,e){pt(document.head,f),a(s,b,e),a(s,u,e),a(s,$,e),c(_,s,e),a(s,_s,e),a(s,y,e),a(s,ys,e),a(s,T,e),a(s,Ts,e),c(v,s,e),a(s,vs,e),c(J,s,e),a(s,Js,e),a(s,W,e),a(s,Ws,e),a(s,k,e),a(s,ks,e),c(Z,s,e),a(s,Zs,e),c(x,s,e),a(s,Cs,e),c(C,s,e),a(s,Us,e),a(s,U,e),a(s,Hs,e),c(H,s,e),a(s,Rs,e),a(s,R,e),a(s,Fs,e),c(F,s,e),a(s,Vs,e),c(V,s,e),a(s,Ls,e),a(s,L,e),a(s,Ns,e),c(N,s,e),a(s,Gs,e),a(s,G,e),a(s,zs,e),c(z,s,e),a(s,Qs,e),a(s,Q,e),a(s,Es,e),a(s,E,e),a(s,Is,e),c(I,s,e),a(s,Bs,e),c(B,s,e),a(s,Ps,e),a(s,P,e),a(s,Xs,e),a(s,X,e),a(s,Ss,e),c(S,s,e),a(s,Ys,e),a(s,Y,e),a(s,As,e),a(s,A,e),a(s,Ks,e),c(K,s,e),a(s,qs,e),a(s,q,e),a(s,Ds,e),c(D,s,e),a(s,Os,e),a(s,O,e),a(s,se,e),c(ss,s,e),a(s,ee,e),c(w,s,e),a(s,te,e),c(es,s,e),a(s,ae,e),a(s,ts,e),a(s,ne,e),a(s,as,e),a(s,le,e),c(ns,s,e),a(s,pe,e),a(s,ls,e),a(s,ie,e),a(s,M,e),a(s,re,e),a(s,ps,e),a(s,me,e),c(is,s,e),a(s,ce,e),a(s,rs,e),a(s,oe,e),c(ms,s,e),a(s,he,e),a(s,cs,e),a(s,ge,e),c(os,s,e),a(s,de,e),a(s,hs,e),a(s,fe,e),c(gs,s,e),a(s,ue,e),a(s,ds,e),a(s,je,e),c(fs,s,e),a(s,be,e),a(s,us,e),a(s,$e,e),c(js,s,e),a(s,xe,e),c(bs,s,e),a(s,we,e),a(s,ws,e),Me=!0},p(s,[e]){const Ae={};e&2&&(Ae.$$scope={dirty:e,ctx:s}),x.$set(Ae);const Ke={};e&2&&(Ke.$$scope={dirty:e,ctx:s}),w.$set(Ke)},i(s){Me||(o(_.$$.fragment,s),o(v.$$.fragment,s),o(J.$$.fragment,s),o(Z.$$.fragment,s),o(x.$$.fragment,s),o(C.$$.fragment,s),o(H.$$.fragment,s),o(F.$$.fragment,s),o(V.$$.fragment,s),o(N.$$.fragment,s),o(z.$$.fragment,s),o(I.$$.fragment,s),o(B.$$.fragment,s),o(S.$$.fragment,s),o(K.$$.fragment,s),o(D.$$.fragment,s),o(ss.$$.fragment,s),o(w.$$.fragment,s),o(es.$$.fragment,s),o(ns.$$.fragment,s),o(is.$$.fragment,s),o(ms.$$.fragment,s),o(os.$$.fragment,s),o(gs.$$.fragment,s),o(fs.$$.fragment,s),o(js.$$.fragment,s),o(bs.$$.fragment,s),Me=!0)},o(s){h(_.$$.fragment,s),h(v.$$.fragment,s),h(J.$$.fragment,s),h(Z.$$.fragment,s),h(x.$$.fragment,s),h(C.$$.fragment,s),h(H.$$.fragment,s),h(F.$$.fragment,s),h(V.$$.fragment,s),h(N.$$.fragment,s),h(z.$$.fragment,s),h(I.$$.fragment,s),h(B.$$.fragment,s),h(S.$$.fragment,s),h(K.$$.fragment,s),h(D.$$.fragment,s),h(ss.$$.fragment,s),h(w.$$.fragment,s),h(es.$$.fragment,s),h(ns.$$.fragment,s),h(is.$$.fragment,s),h(ms.$$.fragment,s),h(os.$$.fragment,s),h(gs.$$.fragment,s),h(fs.$$.fragment,s),h(js.$$.fragment,s),h(bs.$$.fragment,s),Me=!1},d(s){s&&(t(b),t(u),t($),t(_s),t(y),t(ys),t(T),t(Ts),t(vs),t(Js),t(W),t(Ws),t(k),t(ks),t(Zs),t(Cs),t(Us),t(U),t(Hs),t(Rs),t(R),t(Fs),t(Vs),t(Ls),t(L),t(Ns),t(Gs),t(G),t(zs),t(Qs),t(Q),t(Es),t(E),t(Is),t(Bs),t(Ps),t(P),t(Xs),t(X),t(Ss),t(Ys),t(Y),t(As),t(A),t(Ks),t(qs),t(q),t(Ds),t(Os),t(O),t(se),t(ee),t(te),t(ae),t(ts),t(ne),t(as),t(le),t(pe),t(ls),t(ie),t(M),t(re),t(ps),t(me),t(ce),t(rs),t(oe),t(he),t(cs),t(ge),t(de),t(hs),t(fe),t(ue),t(ds),t(je),t(be),t(us),t($e),t(xe),t(we),t(ws)),t(f),g(_,s),g(v,s),g(J,s),g(Z,s),g(x,s),g(C,s),g(H,s),g(F,s),g(V,s),g(N,s),g(z,s),g(I,s),g(B,s),g(S,s),g(K,s),g(D,s),g(ss,s),g(w,s),g(es,s),g(ns,s),g(is,s),g(ms,s),g(os,s),g(gs,s),g(fs,s),g(js,s),g(bs,s)}}}const ot='{"title":"Quickstart","local":"quickstart","sections":[{"title":"Load a Pretrained Model","local":"load-a-pretrained-model","sections":[],"depth":2},{"title":"List Models with Pretrained Weights","local":"list-models-with-pretrained-weights","sections":[],"depth":2},{"title":"Fine-Tune a Pretrained Model","local":"fine-tune-a-pretrained-model","sections":[],"depth":2},{"title":"Use a Pretrained Model for Feature Extraction","local":"use-a-pretrained-model-for-feature-extraction","sections":[],"depth":2},{"title":"Image Augmentation","local":"image-augmentation","sections":[],"depth":2},{"title":"Using Pretrained Models for Inference","local":"using-pretrained-models-for-inference","sections":[],"depth":2}],"depth":1}';function ht(xs){return tt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bt extends at{constructor(f){super(),nt(this,f,ht,ct,st,{})}}export{bt as component};
