import{s as Zs,o as Cs,n as qn}from"../chunks/scheduler.8c3d61f6.js";import{S as $s,i as Ss,g as a,s as n,r as c,A as Ds,h as i,f as o,c as s,j as w,u as m,x as _,k as I,y as t,a as M,v as g,d as f,t as u,w as h}from"../chunks/index.589a98e8.js";import{T as ks}from"../chunks/Tip.42aa8582.js";import{D as y}from"../chunks/Docstring.27406313.js";import{C as Es}from"../chunks/CodeBlock.36627b28.js";import{E as Ns}from"../chunks/ExampleCodeBlock.3dc467a7.js";import{H as Ht,E as Ps}from"../chunks/EditOnGithub.e5a8d9cb.js";function Ws(C){let b,U='Make sure to check out the Stable Diffusion <a href="https://huggingface.co/docs/diffusers/en/api/pipelines/stable_diffusion/overview#tips" rel="nofollow">Tips</a> section to learn how to explore the tradeoff between scheduler speed and quality and how to reuse pipeline components efficiently!',x,T,J='If you want to use one of the official checkpoints for a task, explore the <a href="https://huggingface.co/gligen" rel="nofollow">gligen</a> Hub organizations!';return{c(){b=a("p"),b.innerHTML=U,x=n(),T=a("p"),T.innerHTML=J},l(l){b=i(l,"P",{"data-svelte-h":!0}),_(b)!=="svelte-v9h8gm"&&(b.innerHTML=U),x=s(l),T=i(l,"P",{"data-svelte-h":!0}),_(T)!=="svelte-9ek9ww"&&(T.innerHTML=J)},m(l,j){M(l,b,j),M(l,x,j),M(l,T,j)},p:qn,d(l){l&&(o(b),o(x),o(T))}}}function Bs(C){let b,U="Examples:",x,T,J;return T=new Es({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uR0xJR0VOUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQSUyMyUyMEluc2VydCUyMG9iamVjdHMlMjBkZXNjcmliZWQlMjBieSUyMHRleHQlMjBhdCUyMHRoZSUyMHJlZ2lvbiUyMGRlZmluZWQlMjBieSUyMGJvdW5kaW5nJTIwYm94ZXMlMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uR0xJR0VOUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMm1hc3RlcmZ1bCUyRmdsaWdlbi0xLTQtaW5wYWludGluZy10ZXh0LWJveCUyMiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGUlMjAlM0QlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBaW5wdXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaGYuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmdsaWdlbiUyRmxpdmluZ3Jvb21fbW9kZXJuLnBuZyUyMiUwQSklMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwYmlydGhkYXklMjBjYWtlJTIyJTBBYm94ZXMlMjAlM0QlMjAlNUIlNUIwLjI2NzYlMkMlMjAwLjYwODglMkMlMjAwLjQ3NzMlMkMlMjAwLjcxODMlNUQlNUQlMEFwaHJhc2VzJTIwJTNEJTIwJTVCJTIyYSUyMGJpcnRoZGF5JTIwY2FrZSUyMiU1RCUwQSUwQWltYWdlcyUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwZ2xpZ2VuX3BocmFzZXMlM0RwaHJhc2VzJTJDJTBBJTIwJTIwJTIwJTIwZ2xpZ2VuX2lucGFpbnRfaW1hZ2UlM0RpbnB1dF9pbWFnZSUyQyUwQSUyMCUyMCUyMCUyMGdsaWdlbl9ib3hlcyUzRGJveGVzJTJDJTBBJTIwJTIwJTIwJTIwZ2xpZ2VuX3NjaGVkdWxlZF9zYW1wbGluZ19iZXRhJTNEMSUyQyUwQSUyMCUyMCUyMCUyMG91dHB1dF90eXBlJTNEJTIycGlsJTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTBBKS5pbWFnZXMlMEElMEFpbWFnZXMlNUIwJTVELnNhdmUoJTIyLiUyRmdsaWdlbi0xLTQtaW5wYWludGluZy10ZXh0LWJveC5qcGclMjIpJTBBJTBBJTIzJTIwR2VuZXJhdGUlMjBhbiUyMGltYWdlJTIwZGVzY3JpYmVkJTIwYnklMjB0aGUlMjBwcm9tcHQlMjBhbmQlMEElMjMlMjBpbnNlcnQlMjBvYmplY3RzJTIwZGVzY3JpYmVkJTIwYnklMjB0ZXh0JTIwYXQlMjB0aGUlMjByZWdpb24lMjBkZWZpbmVkJTIwYnklMjBib3VuZGluZyUyMGJveGVzJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbkdMSUdFTlBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJtYXN0ZXJmdWwlMkZnbGlnZW4tMS00LWdlbmVyYXRpb24tdGV4dC1ib3glMjIlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjB3YXRlcmZhbGwlMjBhbmQlMjBhJTIwbW9kZXJuJTIwaGlnaCUyMHNwZWVkJTIwdHJhaW4lMjBydW5uaW5nJTIwdGhyb3VnaCUyMHRoZSUyMHR1bm5lbCUyMGluJTIwYSUyMGJlYXV0aWZ1bCUyMGZvcmVzdCUyMHdpdGglMjBmYWxsJTIwZm9saWFnZSUyMiUwQWJveGVzJTIwJTNEJTIwJTVCJTVCMC4xMzg3JTJDJTIwMC4yMDUxJTJDJTIwMC40Mjc3JTJDJTIwMC43MDkwJTVEJTJDJTIwJTVCMC40OTgwJTJDJTIwMC40MzU1JTJDJTIwMC44NTE2JTJDJTIwMC43MjY2JTVEJTVEJTBBcGhyYXNlcyUyMCUzRCUyMCU1QiUyMmElMjB3YXRlcmZhbGwlMjIlMkMlMjAlMjJhJTIwbW9kZXJuJTIwaGlnaCUyMHNwZWVkJTIwdHJhaW4lMjBydW5uaW5nJTIwdGhyb3VnaCUyMHRoZSUyMHR1bm5lbCUyMiU1RCUwQSUwQWltYWdlcyUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwZ2xpZ2VuX3BocmFzZXMlM0RwaHJhc2VzJTJDJTBBJTIwJTIwJTIwJTIwZ2xpZ2VuX2JveGVzJTNEYm94ZXMlMkMlMEElMjAlMjAlMjAlMjBnbGlnZW5fc2NoZWR1bGVkX3NhbXBsaW5nX2JldGElM0QxJTJDJTBBJTIwJTIwJTIwJTIwb3V0cHV0X3R5cGUlM0QlMjJwaWwlMjIlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMEEpLmltYWdlcyUwQSUwQWltYWdlcyU1QjAlNUQuc2F2ZSglMjIuJTJGZ2xpZ2VuLTEtNC1nZW5lcmF0aW9uLXRleHQtYm94LmpwZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionGLIGENPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Insert objects described by text at the region defined by bounding boxes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionGLIGENPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;masterful/gligen-1-4-inpainting-text-box&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>input_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://hf.co/datasets/huggingface/documentation-images/resolve/main/diffusers/gligen/livingroom_modern.png&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a birthday cake&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes = [[<span class="hljs-number">0.2676</span>, <span class="hljs-number">0.6088</span>, <span class="hljs-number">0.4773</span>, <span class="hljs-number">0.7183</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>phrases = [<span class="hljs-string">&quot;a birthday cake&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    gligen_phrases=phrases,
<span class="hljs-meta">... </span>    gligen_inpaint_image=input_image,
<span class="hljs-meta">... </span>    gligen_boxes=boxes,
<span class="hljs-meta">... </span>    gligen_scheduled_sampling_beta=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    output_type=<span class="hljs-string">&quot;pil&quot;</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>).images

<span class="hljs-meta">&gt;&gt;&gt; </span>images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;./gligen-1-4-inpainting-text-box.jpg&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate an image described by the prompt and</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># insert objects described by text at the region defined by bounding boxes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionGLIGENPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;masterful/gligen-1-4-generation-text-box&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a waterfall and a modern high speed train running through the tunnel in a beautiful forest with fall foliage&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes = [[<span class="hljs-number">0.1387</span>, <span class="hljs-number">0.2051</span>, <span class="hljs-number">0.4277</span>, <span class="hljs-number">0.7090</span>], [<span class="hljs-number">0.4980</span>, <span class="hljs-number">0.4355</span>, <span class="hljs-number">0.8516</span>, <span class="hljs-number">0.7266</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>phrases = [<span class="hljs-string">&quot;a waterfall&quot;</span>, <span class="hljs-string">&quot;a modern high speed train running through the tunnel&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    gligen_phrases=phrases,
<span class="hljs-meta">... </span>    gligen_boxes=boxes,
<span class="hljs-meta">... </span>    gligen_scheduled_sampling_beta=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    output_type=<span class="hljs-string">&quot;pil&quot;</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>).images

<span class="hljs-meta">&gt;&gt;&gt; </span>images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;./gligen-1-4-generation-text-box.jpg&quot;</span>)`,wrap:!1}}),{c(){b=a("p"),b.textContent=U,x=n(),c(T.$$.fragment)},l(l){b=i(l,"P",{"data-svelte-h":!0}),_(b)!=="svelte-kvfsh7"&&(b.textContent=U),x=s(l),m(T.$$.fragment,l)},m(l,j){M(l,b,j),M(l,x,j),g(T,l,j),J=!0},p:qn,i(l){J||(f(T.$$.fragment,l),J=!0)},o(l){u(T.$$.fragment,l),J=!1},d(l){l&&(o(b),o(x)),h(T,l)}}}function Vs(C){let b,U="Examples:",x,T,J;return T=new Es({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionGLIGENTextImagePipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Insert objects described by image at the region defined by bounding boxes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionGLIGENTextImagePipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;anhnct/Gligen_Inpainting_Text_Image&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>input_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://hf.co/datasets/huggingface/documentation-images/resolve/main/diffusers/gligen/livingroom_modern.png&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a backpack&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes = [[<span class="hljs-number">0.2676</span>, <span class="hljs-number">0.4088</span>, <span class="hljs-number">0.4773</span>, <span class="hljs-number">0.7183</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>phrases = <span class="hljs-literal">None</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gligen_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/gligen/backpack.jpeg&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    gligen_phrases=phrases,
<span class="hljs-meta">... </span>    gligen_inpaint_image=input_image,
<span class="hljs-meta">... </span>    gligen_boxes=boxes,
<span class="hljs-meta">... </span>    gligen_images=[gligen_image],
<span class="hljs-meta">... </span>    gligen_scheduled_sampling_beta=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    output_type=<span class="hljs-string">&quot;pil&quot;</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>).images

<span class="hljs-meta">&gt;&gt;&gt; </span>images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;./gligen-inpainting-text-image-box.jpg&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate an image described by the prompt and</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># insert objects described by text and image at the region defined by bounding boxes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionGLIGENTextImagePipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;anhnct/Gligen_Text_Image&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a flower sitting on the beach&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes = [[<span class="hljs-number">0.0</span>, <span class="hljs-number">0.09</span>, <span class="hljs-number">0.53</span>, <span class="hljs-number">0.76</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>phrases = [<span class="hljs-string">&quot;flower&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>gligen_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/gligen/pexels-pixabay-60597.jpg&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    gligen_phrases=phrases,
<span class="hljs-meta">... </span>    gligen_images=[gligen_image],
<span class="hljs-meta">... </span>    gligen_boxes=boxes,
<span class="hljs-meta">... </span>    gligen_scheduled_sampling_beta=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    output_type=<span class="hljs-string">&quot;pil&quot;</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>).images

<span class="hljs-meta">&gt;&gt;&gt; </span>images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;./gligen-generation-text-image-box.jpg&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate an image described by the prompt and</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># transfer style described by image at the region defined by bounding boxes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionGLIGENTextImagePipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;anhnct/Gligen_Text_Image&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a dragon flying on the sky&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes = [[<span class="hljs-number">0.4</span>, <span class="hljs-number">0.2</span>, <span class="hljs-number">1.0</span>, <span class="hljs-number">0.8</span>], [<span class="hljs-number">0.0</span>, <span class="hljs-number">1.0</span>, <span class="hljs-number">0.0</span>, <span class="hljs-number">1.0</span>]]  <span class="hljs-comment"># Set \`[0.0, 1.0, 0.0, 1.0]\` for the style</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>gligen_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/landscape.png&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gligen_placeholder = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/landscape.png&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    gligen_phrases=[
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;dragon&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;placeholder&quot;</span>,
<span class="hljs-meta">... </span>    ],  <span class="hljs-comment"># Can use any text instead of \`placeholder\` token, because we will use mask here</span>
<span class="hljs-meta">... </span>    gligen_images=[
<span class="hljs-meta">... </span>        gligen_placeholder,
<span class="hljs-meta">... </span>        gligen_image,
<span class="hljs-meta">... </span>    ],  <span class="hljs-comment"># Can use any image in gligen_placeholder, because we will use mask here</span>
<span class="hljs-meta">... </span>    input_phrases_mask=[<span class="hljs-number">1</span>, <span class="hljs-number">0</span>],  <span class="hljs-comment"># Set 0 for the placeholder token</span>
<span class="hljs-meta">... </span>    input_images_mask=[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>],  <span class="hljs-comment"># Set 0 for the placeholder image</span>
<span class="hljs-meta">... </span>    gligen_boxes=boxes,
<span class="hljs-meta">... </span>    gligen_scheduled_sampling_beta=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    output_type=<span class="hljs-string">&quot;pil&quot;</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>).images

<span class="hljs-meta">&gt;&gt;&gt; </span>images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;./gligen-generation-text-image-box-style-transfer.jpg&quot;</span>)`,wrap:!1}}),{c(){b=a("p"),b.textContent=U,x=n(),c(T.$$.fragment)},l(l){b=i(l,"P",{"data-svelte-h":!0}),_(b)!=="svelte-kvfsh7"&&(b.textContent=U),x=s(l),m(T.$$.fragment,l)},m(l,j){M(l,b,j),M(l,x,j),g(T,l,j),J=!0},p:qn,i(l){J||(f(T.$$.fragment,l),J=!0)},o(l){u(T.$$.fragment,l),J=!1},d(l){l&&(o(b),o(x)),h(T,l)}}}function As(C){let b,U,x,T,J,l,j,Fn='The GLIGEN model was created by researchers and engineers from <a href="https://github.com/gligen/GLIGEN" rel="nofollow">University of Wisconsin-Madison, Columbia University, and Microsoft</a>. The <a href="/docs/diffusers/pr_8468/en/api/pipelines/stable_diffusion/gligen#diffusers.StableDiffusionGLIGENPipeline">StableDiffusionGLIGENPipeline</a> and <a href="/docs/diffusers/pr_8468/en/api/pipelines/stable_diffusion/gligen#diffusers.StableDiffusionGLIGENTextImagePipeline">StableDiffusionGLIGENTextImagePipeline</a> can generate photorealistic images conditioned on grounding inputs. Along with text and bounding boxes with <a href="/docs/diffusers/pr_8468/en/api/pipelines/stable_diffusion/gligen#diffusers.StableDiffusionGLIGENPipeline">StableDiffusionGLIGENPipeline</a>, if input images are given, <a href="/docs/diffusers/pr_8468/en/api/pipelines/stable_diffusion/gligen#diffusers.StableDiffusionGLIGENTextImagePipeline">StableDiffusionGLIGENTextImagePipeline</a> can insert objects described by text at the region defined by bounding boxes. Otherwise, it’ll generate an image described by the caption/prompt and insert objects described by text at the region defined by bounding boxes. It’s trained on COCO2014D and COCO2014CD datasets, and the model uses a frozen CLIP ViT-L/14 text encoder to condition itself on grounding inputs.',_t,se,On='The abstract from the <a href="https://huggingface.co/papers/2301.07093" rel="nofollow">paper</a> is:',bt,ae,Kn="<em>Large-scale text-to-image diffusion models have made amazing advances. However, the status quo is to use text input alone, which can impede controllability. In this work, we propose GLIGEN, Grounded-Language-to-Image Generation, a novel approach that builds upon and extends the functionality of existing pre-trained text-to-image diffusion models by enabling them to also be conditioned on grounding inputs. To preserve the vast concept knowledge of the pre-trained model, we freeze all of its weights and inject the grounding information into new trainable layers via a gated mechanism. Our model achieves open-world grounded text2img generation with caption and bounding box condition inputs, and the grounding ability generalizes well to novel spatial configurations and concepts. GLIGEN’s zeroshot performance on COCO and LVIS outperforms existing supervised layout-to-image baselines by a large margin.</em>",Mt,$,wt,ie,es='<a href="/docs/diffusers/pr_8468/en/api/pipelines/stable_diffusion/gligen#diffusers.StableDiffusionGLIGENPipeline">StableDiffusionGLIGENPipeline</a> was contributed by <a href="https://github.com/nikhil-masterful" rel="nofollow">Nikhil Gajendrakumar</a> and <a href="/docs/diffusers/pr_8468/en/api/pipelines/stable_diffusion/gligen#diffusers.StableDiffusionGLIGENTextImagePipeline">StableDiffusionGLIGENTextImagePipeline</a> was contributed by <a href="https://github.com/tuanh123789" rel="nofollow">Nguyễn Công Tú Anh</a>.',It,oe,vt,v,le,qt,Pe,ts="Pipeline for text-to-image generation using Stable Diffusion with Grounded-Language-to-Image Generation (GLIGEN).",Ft,We,ns=`This model inherits from <a href="/docs/diffusers/pr_8468/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.).`,Ot,L,re,Kt,Be,ss="The call function to the pipeline for generation.",en,S,tn,D,pe,nn,Ve,as=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,sn,k,de,an,Ae,is=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,on,P,ce,ln,Re,os=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,rn,W,me,pn,ze,ls=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,dn,B,ge,cn,Ye,rs=`Offloads all models to CPU using accelerate, reducing memory usage with a low impact on performance. Compared
to <code>enable_sequential_cpu_offload</code>, this method moves one whole model at a time to the GPU when its <code>forward</code>
method is called, and the model remains in GPU until the next model runs. Memory savings are lower than with
<code>enable_sequential_cpu_offload</code>, but performance is much better due to the iterative execution of the <code>unet</code>.`,mn,Xe,fe,gn,Qe,ue,fn,V,he,un,He,ps="Encodes the prompt into text encoder hidden states.",Tt,_e,yt,r,be,hn,qe,ds="Pipeline for text-to-image generation using Stable Diffusion with Grounded-Language-to-Image Generation (GLIGEN).",_n,Fe,cs=`This model inherits from <a href="/docs/diffusers/pr_8468/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.).`,bn,N,Me,Mn,Oe,ms="The call function to the pipeline for generation.",wn,A,In,R,we,vn,Ke,gs=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Tn,z,Ie,yn,et,fs=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Gn,Y,ve,xn,tt,us=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,Jn,X,Te,jn,nt,hs=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,Un,Q,ye,Ln,st,_s=`Offloads all models to CPU using accelerate, reducing memory usage with a low impact on performance. Compared
to <code>enable_sequential_cpu_offload</code>, this method moves one whole model at a time to the GPU when its <code>forward</code>
method is called, and the model remains in GPU until the next model runs. Memory savings are lower than with
<code>enable_sequential_cpu_offload</code>, but performance is much better due to the iterative execution of the <code>unet</code>.`,Nn,at,Ge,En,it,xe,Zn,H,Je,Cn,ot,bs=`Based on the input mask corresponding value <code>0 or 1</code> for each phrases and image, mask the features
corresponding to phrases and images.`,$n,q,je,Sn,lt,Ms="Crop the input image to the specified dimensions.",Dn,F,Ue,kn,rt,ws=`Create an inpainting mask based on given boxes. This function generates an inpainting mask using the provided
boxes to mark regions that need to be inpainted.`,Pn,O,Le,Wn,pt,Is="Encodes the prompt into text encoder hidden states.",Bn,K,Ne,Vn,dt,vs=`Get image and phrases embedding by using CLIP pretrain model. The image embedding is transformed into the
phrases embedding space through a projection.`,An,ee,Ee,Rn,ct,Ts=`Prepare the cross-attention kwargs containing information about the grounded input (boxes, mask, image
embedding, phrases embedding).`,zn,te,Ze,Yn,mt,ys=`Prepare the cross-attention kwargs without information about the grounded input (boxes, mask, image embedding,
phrases embedding) (All are zero tensor).`,Xn,ne,Ce,Qn,gt,Gs="Crop and resize the image to the target size while keeping the center.",Gt,$e,xt,E,Se,Hn,ft,xs="Output class for Stable Diffusion pipelines.",Jt,De,jt,ht,Ut;return J=new Ht({props:{title:"GLIGEN (Grounded Language-to-Image Generation)",local:"gligen-grounded-language-to-image-generation",headingTag:"h1"}}),$=new ks({props:{$$slots:{default:[Ws]},$$scope:{ctx:C}}}),oe=new Ht({props:{title:"StableDiffusionGLIGENPipeline",local:"diffusers.StableDiffusionGLIGENPipeline",headingTag:"h2"}}),le=new y({props:{name:"class diffusers.StableDiffusionGLIGENPipeline",anchor:"diffusers.StableDiffusionGLIGENPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPFeatureExtractor"},{name:"requires_safety_checker",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionGLIGENPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/pr_8468/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/pr_8468/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/pr_8468/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/pr_8468/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/pr_8468/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/pr_8468/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/vr_8468/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen.py#L102"}}),re=new y({props:{name:"__call__",anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"gligen_scheduled_sampling_beta",val:": float = 0.3"},{name:"gligen_phrases",val:": List = None"},{name:"gligen_boxes",val:": List = None"},{name:"gligen_inpaint_image",val:": Optional = None"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.gligen_phrases",description:`<strong>gligen_phrases</strong> (<code>List[str]</code>) &#x2014;
The phrases to guide what to include in each of the regions defined by the corresponding
<code>gligen_boxes</code>. There should only be one phrase per bounding box.`,name:"gligen_phrases"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.gligen_boxes",description:`<strong>gligen_boxes</strong> (<code>List[List[float]]</code>) &#x2014;
The bounding boxes that identify rectangular regions of the image that are going to be filled with the
content described by the corresponding <code>gligen_phrases</code>. Each rectangular box is defined as a
<code>List[float]</code> of 4 elements <code>[xmin, ymin, xmax, ymax]</code> where each value is between [0,1].`,name:"gligen_boxes"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.gligen_inpaint_image",description:`<strong>gligen_inpaint_image</strong> (<code>PIL.Image.Image</code>, <em>optional</em>) &#x2014;
The input image, if provided, is inpainted with objects described by the <code>gligen_boxes</code> and
<code>gligen_phrases</code>. Otherwise, it is treated as a generation task on a blank input image.`,name:"gligen_inpaint_image"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.gligen_scheduled_sampling_beta",description:`<strong>gligen_scheduled_sampling_beta</strong> (<code>float</code>, defaults to 0.3) &#x2014;
Scheduled Sampling factor from <a href="https://arxiv.org/pdf/2301.07093.pdf" rel="nofollow">GLIGEN: Open-Set Grounded Text-to-Image
Generation</a>. Scheduled Sampling factor is only varied for
scheduled sampling during inference for improved quality and controllability.`,name:"gligen_scheduled_sampling_beta"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/pr_8468/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/pr_8468/en/api/pipelines/stable_diffusion/gligen#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.Tensor)</code>.`,name:"callback"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Guidance rescale factor from <a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a>. Guidance rescale factor should fix overexposure when
using zero terminal SNR.`,name:"guidance_rescale"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/vr_8468/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen.py#L528",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/pr_8468/en/api/pipelines/stable_diffusion/gligen#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_8468/en/api/pipelines/stable_diffusion/gligen#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),S=new Ns({props:{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.example",$$slots:{default:[Bs]},$$scope:{ctx:C}}}),pe=new y({props:{name:"enable_vae_slicing",anchor:"diffusers.StableDiffusionGLIGENPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_8468/src/diffusers/pipelines/pipeline_utils.py#L1888"}}),de=new y({props:{name:"disable_vae_slicing",anchor:"diffusers.StableDiffusionGLIGENPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_8468/src/diffusers/pipelines/pipeline_utils.py#L1895"}}),ce=new y({props:{name:"enable_vae_tiling",anchor:"diffusers.StableDiffusionGLIGENPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_8468/src/diffusers/pipelines/pipeline_utils.py#L1902"}}),me=new y({props:{name:"disable_vae_tiling",anchor:"diffusers.StableDiffusionGLIGENPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_8468/src/diffusers/pipelines/pipeline_utils.py#L1910"}}),ge=new y({props:{name:"enable_model_cpu_offload",anchor:"diffusers.StableDiffusionGLIGENPipeline.enable_model_cpu_offload",parameters:[{name:"gpu_id",val:": Optional = None"},{name:"device",val:": Union = 'cuda'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionGLIGENPipeline.enable_model_cpu_offload.gpu_id",description:`<strong>gpu_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The ID of the accelerator that shall be used in inference. If not specified, it will default to 0.`,name:"gpu_id"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.enable_model_cpu_offload.device",description:`<strong>device</strong> (<code>torch.Device</code> or <code>str</code>, <em>optional</em>, defaults to &#x201C;cuda&#x201D;) &#x2014;
The PyTorch device type of the accelerator that shall be used in inference. If not specified, it will
default to &#x201C;cuda&#x201D;.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/vr_8468/src/diffusers/pipelines/pipeline_utils.py#L1015"}}),fe=new y({props:{name:"prepare_latents",anchor:"diffusers.StableDiffusionGLIGENPipeline.prepare_latents",parameters:[{name:"batch_size",val:""},{name:"num_channels_latents",val:""},{name:"height",val:""},{name:"width",val:""},{name:"dtype",val:""},{name:"device",val:""},{name:"generator",val:""},{name:"latents",val:" = None"}],source:"https://github.com/huggingface/diffusers/blob/vr_8468/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen.py#L479"}}),ue=new y({props:{name:"enable_fuser",anchor:"diffusers.StableDiffusionGLIGENPipeline.enable_fuser",parameters:[{name:"enabled",val:" = True"}],source:"https://github.com/huggingface/diffusers/blob/vr_8468/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen.py#L501"}}),he=new y({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionGLIGENPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionGLIGENPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/vr_8468/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen.py#L209"}}),_e=new Ht({props:{title:"StableDiffusionGLIGENTextImagePipeline",local:"diffusers.StableDiffusionGLIGENTextImagePipeline",headingTag:"h2"}}),be=new y({props:{name:"class diffusers.StableDiffusionGLIGENTextImagePipeline",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"processor",val:": CLIPProcessor"},{name:"image_encoder",val:": CLIPVisionModelWithProjection"},{name:"image_project",val:": CLIPImageProjection"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPFeatureExtractor"},{name:"requires_safety_checker",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/pr_8468/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.processor",description:`<strong>processor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPProcessor" rel="nofollow">CLIPProcessor</a>) &#x2014;
A <code>CLIPProcessor</code> to procces reference image.`,name:"processor"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.image_encoder",description:`<strong>image_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPVisionModelWithProjection" rel="nofollow">CLIPVisionModelWithProjection</a>) &#x2014;
Frozen image-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"image_encoder"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.image_project",description:`<strong>image_project</strong> (<code>CLIPImageProjection</code>) &#x2014;
A <code>CLIPImageProjection</code> to project image embedding into phrases embedding space.`,name:"image_project"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/pr_8468/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/pr_8468/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/pr_8468/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/pr_8468/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/pr_8468/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/vr_8468/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen_text_image.py#L148"}}),Me=new y({props:{name:"__call__",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"gligen_scheduled_sampling_beta",val:": float = 0.3"},{name:"gligen_phrases",val:": List = None"},{name:"gligen_images",val:": List = None"},{name:"input_phrases_mask",val:": Union = None"},{name:"input_images_mask",val:": Union = None"},{name:"gligen_boxes",val:": List = None"},{name:"gligen_inpaint_image",val:": Optional = None"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"gligen_normalize_constant",val:": float = 28.7"},{name:"clip_skip",val:": int = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.gligen_phrases",description:`<strong>gligen_phrases</strong> (<code>List[str]</code>) &#x2014;
The phrases to guide what to include in each of the regions defined by the corresponding
<code>gligen_boxes</code>. There should only be one phrase per bounding box.`,name:"gligen_phrases"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.gligen_images",description:`<strong>gligen_images</strong> (<code>List[PIL.Image.Image]</code>) &#x2014;
The images to guide what to include in each of the regions defined by the corresponding <code>gligen_boxes</code>.
There should only be one image per bounding box`,name:"gligen_images"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.input_phrases_mask",description:`<strong>input_phrases_mask</strong> (<code>int</code> or <code>List[int]</code>) &#x2014;
pre phrases mask input defined by the correspongding <code>input_phrases_mask</code>`,name:"input_phrases_mask"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.input_images_mask",description:`<strong>input_images_mask</strong> (<code>int</code> or <code>List[int]</code>) &#x2014;
pre images mask input defined by the correspongding <code>input_images_mask</code>`,name:"input_images_mask"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.gligen_boxes",description:`<strong>gligen_boxes</strong> (<code>List[List[float]]</code>) &#x2014;
The bounding boxes that identify rectangular regions of the image that are going to be filled with the
content described by the corresponding <code>gligen_phrases</code>. Each rectangular box is defined as a
<code>List[float]</code> of 4 elements <code>[xmin, ymin, xmax, ymax]</code> where each value is between [0,1].`,name:"gligen_boxes"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.gligen_inpaint_image",description:`<strong>gligen_inpaint_image</strong> (<code>PIL.Image.Image</code>, <em>optional</em>) &#x2014;
The input image, if provided, is inpainted with objects described by the <code>gligen_boxes</code> and
<code>gligen_phrases</code>. Otherwise, it is treated as a generation task on a blank input image.`,name:"gligen_inpaint_image"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.gligen_scheduled_sampling_beta",description:`<strong>gligen_scheduled_sampling_beta</strong> (<code>float</code>, defaults to 0.3) &#x2014;
Scheduled Sampling factor from <a href="https://arxiv.org/pdf/2301.07093.pdf" rel="nofollow">GLIGEN: Open-Set Grounded Text-to-Image
Generation</a>. Scheduled Sampling factor is only varied for
scheduled sampling during inference for improved quality and controllability.`,name:"gligen_scheduled_sampling_beta"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/pr_8468/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/pr_8468/en/api/pipelines/stable_diffusion/gligen#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.Tensor)</code>.`,name:"callback"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.gligen_normalize_constant",description:`<strong>gligen_normalize_constant</strong> (<code>float</code>, <em>optional</em>, defaults to 28.7) &#x2014;
The normalize value of the image embedding.`,name:"gligen_normalize_constant"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/vr_8468/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen_text_image.py#L689",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/pr_8468/en/api/pipelines/stable_diffusion/gligen#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_8468/en/api/pipelines/stable_diffusion/gligen#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),A=new Ns({props:{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.example",$$slots:{default:[Vs]},$$scope:{ctx:C}}}),we=new y({props:{name:"enable_vae_slicing",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_8468/src/diffusers/pipelines/pipeline_utils.py#L1888"}}),Ie=new y({props:{name:"disable_vae_slicing",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_8468/src/diffusers/pipelines/pipeline_utils.py#L1895"}}),ve=new y({props:{name:"enable_vae_tiling",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_8468/src/diffusers/pipelines/pipeline_utils.py#L1902"}}),Te=new y({props:{name:"disable_vae_tiling",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_8468/src/diffusers/pipelines/pipeline_utils.py#L1910"}}),ye=new y({props:{name:"enable_model_cpu_offload",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.enable_model_cpu_offload",parameters:[{name:"gpu_id",val:": Optional = None"},{name:"device",val:": Union = 'cuda'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.enable_model_cpu_offload.gpu_id",description:`<strong>gpu_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The ID of the accelerator that shall be used in inference. If not specified, it will default to 0.`,name:"gpu_id"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.enable_model_cpu_offload.device",description:`<strong>device</strong> (<code>torch.Device</code> or <code>str</code>, <em>optional</em>, defaults to &#x201C;cuda&#x201D;) &#x2014;
The PyTorch device type of the accelerator that shall be used in inference. If not specified, it will
default to &#x201C;cuda&#x201D;.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/vr_8468/src/diffusers/pipelines/pipeline_utils.py#L1015"}}),Ge=new y({props:{name:"prepare_latents",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.prepare_latents",parameters:[{name:"batch_size",val:""},{name:"num_channels_latents",val:""},{name:"height",val:""},{name:"width",val:""},{name:"dtype",val:""},{name:"device",val:""},{name:"generator",val:""},{name:"latents",val:" = None"}],source:"https://github.com/huggingface/diffusers/blob/vr_8468/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen_text_image.py#L503"}}),xe=new y({props:{name:"enable_fuser",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.enable_fuser",parameters:[{name:"enabled",val:" = True"}],source:"https://github.com/huggingface/diffusers/blob/vr_8468/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen_text_image.py#L525"}}),Je=new y({props:{name:"complete_mask",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.complete_mask",parameters:[{name:"has_mask",val:""},{name:"max_objs",val:""},{name:"device",val:""}],source:"https://github.com/huggingface/diffusers/blob/vr_8468/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen_text_image.py#L562"}}),je=new y({props:{name:"crop",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.crop",parameters:[{name:"im",val:""},{name:"new_width",val:""},{name:"new_height",val:""}],source:"https://github.com/huggingface/diffusers/blob/vr_8468/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen_text_image.py#L542"}}),Ue=new y({props:{name:"draw_inpaint_mask_from_boxes",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.draw_inpaint_mask_from_boxes",parameters:[{name:"boxes",val:""},{name:"size",val:""}],source:"https://github.com/huggingface/diffusers/blob/vr_8468/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen_text_image.py#L530"}}),Le=new y({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/vr_8468/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen_text_image.py#L234"}}),Ne=new y({props:{name:"get_clip_feature",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.get_clip_feature",parameters:[{name:"input",val:""},{name:"normalize_constant",val:""},{name:"device",val:""},{name:"is_image",val:" = False"}],source:"https://github.com/huggingface/diffusers/blob/vr_8468/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen_text_image.py#L578"}}),Ee=new y({props:{name:"get_cross_attention_kwargs_with_grounded",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.get_cross_attention_kwargs_with_grounded",parameters:[{name:"hidden_size",val:""},{name:"gligen_phrases",val:""},{name:"gligen_images",val:""},{name:"gligen_boxes",val:""},{name:"input_phrases_mask",val:""},{name:"input_images_mask",val:""},{name:"repeat_batch",val:""},{name:"normalize_constant",val:""},{name:"max_objs",val:""},{name:"device",val:""}],source:"https://github.com/huggingface/diffusers/blob/vr_8468/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen_text_image.py#L602"}}),Ze=new y({props:{name:"get_cross_attention_kwargs_without_grounded",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.get_cross_attention_kwargs_without_grounded",parameters:[{name:"hidden_size",val:""},{name:"repeat_batch",val:""},{name:"max_objs",val:""},{name:"device",val:""}],source:"https://github.com/huggingface/diffusers/blob/vr_8468/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen_text_image.py#L666"}}),Ce=new y({props:{name:"target_size_center_crop",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.target_size_center_crop",parameters:[{name:"im",val:""},{name:"new_hw",val:""}],source:"https://github.com/huggingface/diffusers/blob/vr_8468/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen_text_image.py#L553"}}),$e=new Ht({props:{title:"StableDiffusionPipelineOutput",local:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",headingTag:"h2"}}),Se=new y({props:{name:"class diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",parameters:[{name:"images",val:": Union"},{name:"nsfw_content_detected",val:": Optional"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content or
<code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/vr_8468/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L10"}}),De=new Ps({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/stable_diffusion/gligen.md"}}),{c(){b=a("meta"),U=n(),x=a("p"),T=n(),c(J.$$.fragment),l=n(),j=a("p"),j.innerHTML=Fn,_t=n(),se=a("p"),se.innerHTML=On,bt=n(),ae=a("p"),ae.innerHTML=Kn,Mt=n(),c($.$$.fragment),wt=n(),ie=a("p"),ie.innerHTML=es,It=n(),c(oe.$$.fragment),vt=n(),v=a("div"),c(le.$$.fragment),qt=n(),Pe=a("p"),Pe.textContent=ts,Ft=n(),We=a("p"),We.innerHTML=ns,Ot=n(),L=a("div"),c(re.$$.fragment),Kt=n(),Be=a("p"),Be.textContent=ss,en=n(),c(S.$$.fragment),tn=n(),D=a("div"),c(pe.$$.fragment),nn=n(),Ve=a("p"),Ve.textContent=as,sn=n(),k=a("div"),c(de.$$.fragment),an=n(),Ae=a("p"),Ae.innerHTML=is,on=n(),P=a("div"),c(ce.$$.fragment),ln=n(),Re=a("p"),Re.textContent=os,rn=n(),W=a("div"),c(me.$$.fragment),pn=n(),ze=a("p"),ze.innerHTML=ls,dn=n(),B=a("div"),c(ge.$$.fragment),cn=n(),Ye=a("p"),Ye.innerHTML=rs,mn=n(),Xe=a("div"),c(fe.$$.fragment),gn=n(),Qe=a("div"),c(ue.$$.fragment),fn=n(),V=a("div"),c(he.$$.fragment),un=n(),He=a("p"),He.textContent=ps,Tt=n(),c(_e.$$.fragment),yt=n(),r=a("div"),c(be.$$.fragment),hn=n(),qe=a("p"),qe.textContent=ds,_n=n(),Fe=a("p"),Fe.innerHTML=cs,bn=n(),N=a("div"),c(Me.$$.fragment),Mn=n(),Oe=a("p"),Oe.textContent=ms,wn=n(),c(A.$$.fragment),In=n(),R=a("div"),c(we.$$.fragment),vn=n(),Ke=a("p"),Ke.textContent=gs,Tn=n(),z=a("div"),c(Ie.$$.fragment),yn=n(),et=a("p"),et.innerHTML=fs,Gn=n(),Y=a("div"),c(ve.$$.fragment),xn=n(),tt=a("p"),tt.textContent=us,Jn=n(),X=a("div"),c(Te.$$.fragment),jn=n(),nt=a("p"),nt.innerHTML=hs,Un=n(),Q=a("div"),c(ye.$$.fragment),Ln=n(),st=a("p"),st.innerHTML=_s,Nn=n(),at=a("div"),c(Ge.$$.fragment),En=n(),it=a("div"),c(xe.$$.fragment),Zn=n(),H=a("div"),c(Je.$$.fragment),Cn=n(),ot=a("p"),ot.innerHTML=bs,$n=n(),q=a("div"),c(je.$$.fragment),Sn=n(),lt=a("p"),lt.textContent=Ms,Dn=n(),F=a("div"),c(Ue.$$.fragment),kn=n(),rt=a("p"),rt.textContent=ws,Pn=n(),O=a("div"),c(Le.$$.fragment),Wn=n(),pt=a("p"),pt.textContent=Is,Bn=n(),K=a("div"),c(Ne.$$.fragment),Vn=n(),dt=a("p"),dt.textContent=vs,An=n(),ee=a("div"),c(Ee.$$.fragment),Rn=n(),ct=a("p"),ct.textContent=Ts,zn=n(),te=a("div"),c(Ze.$$.fragment),Yn=n(),mt=a("p"),mt.textContent=ys,Xn=n(),ne=a("div"),c(Ce.$$.fragment),Qn=n(),gt=a("p"),gt.textContent=Gs,Gt=n(),c($e.$$.fragment),xt=n(),E=a("div"),c(Se.$$.fragment),Hn=n(),ft=a("p"),ft.textContent=xs,Jt=n(),c(De.$$.fragment),jt=n(),ht=a("p"),this.h()},l(e){const p=Ds("svelte-u9bgzb",document.head);b=i(p,"META",{name:!0,content:!0}),p.forEach(o),U=s(e),x=i(e,"P",{}),w(x).forEach(o),T=s(e),m(J.$$.fragment,e),l=s(e),j=i(e,"P",{"data-svelte-h":!0}),_(j)!=="svelte-1wmb00w"&&(j.innerHTML=Fn),_t=s(e),se=i(e,"P",{"data-svelte-h":!0}),_(se)!=="svelte-uh0q2i"&&(se.innerHTML=On),bt=s(e),ae=i(e,"P",{"data-svelte-h":!0}),_(ae)!=="svelte-5czwpf"&&(ae.innerHTML=Kn),Mt=s(e),m($.$$.fragment,e),wt=s(e),ie=i(e,"P",{"data-svelte-h":!0}),_(ie)!=="svelte-1cezejw"&&(ie.innerHTML=es),It=s(e),m(oe.$$.fragment,e),vt=s(e),v=i(e,"DIV",{class:!0});var G=w(v);m(le.$$.fragment,G),qt=s(G),Pe=i(G,"P",{"data-svelte-h":!0}),_(Pe)!=="svelte-gowtb8"&&(Pe.textContent=ts),Ft=s(G),We=i(G,"P",{"data-svelte-h":!0}),_(We)!=="svelte-1ju6zqn"&&(We.innerHTML=ns),Ot=s(G),L=i(G,"DIV",{class:!0});var Z=w(L);m(re.$$.fragment,Z),Kt=s(Z),Be=i(Z,"P",{"data-svelte-h":!0}),_(Be)!=="svelte-50j04k"&&(Be.textContent=ss),en=s(Z),m(S.$$.fragment,Z),Z.forEach(o),tn=s(G),D=i(G,"DIV",{class:!0});var ke=w(D);m(pe.$$.fragment,ke),nn=s(ke),Ve=i(ke,"P",{"data-svelte-h":!0}),_(Ve)!=="svelte-14bnrb6"&&(Ve.textContent=as),ke.forEach(o),sn=s(G),k=i(G,"DIV",{class:!0});var Lt=w(k);m(de.$$.fragment,Lt),an=s(Lt),Ae=i(Lt,"P",{"data-svelte-h":!0}),_(Ae)!=="svelte-1s3c06i"&&(Ae.innerHTML=is),Lt.forEach(o),on=s(G),P=i(G,"DIV",{class:!0});var Nt=w(P);m(ce.$$.fragment,Nt),ln=s(Nt),Re=i(Nt,"P",{"data-svelte-h":!0}),_(Re)!=="svelte-1xwrf7t"&&(Re.textContent=os),Nt.forEach(o),rn=s(G),W=i(G,"DIV",{class:!0});var Et=w(W);m(me.$$.fragment,Et),pn=s(Et),ze=i(Et,"P",{"data-svelte-h":!0}),_(ze)!=="svelte-pkn4ui"&&(ze.innerHTML=ls),Et.forEach(o),dn=s(G),B=i(G,"DIV",{class:!0});var Zt=w(B);m(ge.$$.fragment,Zt),cn=s(Zt),Ye=i(Zt,"P",{"data-svelte-h":!0}),_(Ye)!=="svelte-d7vywi"&&(Ye.innerHTML=rs),Zt.forEach(o),mn=s(G),Xe=i(G,"DIV",{class:!0});var Js=w(Xe);m(fe.$$.fragment,Js),Js.forEach(o),gn=s(G),Qe=i(G,"DIV",{class:!0});var js=w(Qe);m(ue.$$.fragment,js),js.forEach(o),fn=s(G),V=i(G,"DIV",{class:!0});var Ct=w(V);m(he.$$.fragment,Ct),un=s(Ct),He=i(Ct,"P",{"data-svelte-h":!0}),_(He)!=="svelte-16q0ax1"&&(He.textContent=ps),Ct.forEach(o),G.forEach(o),Tt=s(e),m(_e.$$.fragment,e),yt=s(e),r=i(e,"DIV",{class:!0});var d=w(r);m(be.$$.fragment,d),hn=s(d),qe=i(d,"P",{"data-svelte-h":!0}),_(qe)!=="svelte-gowtb8"&&(qe.textContent=ds),_n=s(d),Fe=i(d,"P",{"data-svelte-h":!0}),_(Fe)!=="svelte-1ju6zqn"&&(Fe.innerHTML=cs),bn=s(d),N=i(d,"DIV",{class:!0});var ut=w(N);m(Me.$$.fragment,ut),Mn=s(ut),Oe=i(ut,"P",{"data-svelte-h":!0}),_(Oe)!=="svelte-50j04k"&&(Oe.textContent=ms),wn=s(ut),m(A.$$.fragment,ut),ut.forEach(o),In=s(d),R=i(d,"DIV",{class:!0});var $t=w(R);m(we.$$.fragment,$t),vn=s($t),Ke=i($t,"P",{"data-svelte-h":!0}),_(Ke)!=="svelte-14bnrb6"&&(Ke.textContent=gs),$t.forEach(o),Tn=s(d),z=i(d,"DIV",{class:!0});var St=w(z);m(Ie.$$.fragment,St),yn=s(St),et=i(St,"P",{"data-svelte-h":!0}),_(et)!=="svelte-1s3c06i"&&(et.innerHTML=fs),St.forEach(o),Gn=s(d),Y=i(d,"DIV",{class:!0});var Dt=w(Y);m(ve.$$.fragment,Dt),xn=s(Dt),tt=i(Dt,"P",{"data-svelte-h":!0}),_(tt)!=="svelte-1xwrf7t"&&(tt.textContent=us),Dt.forEach(o),Jn=s(d),X=i(d,"DIV",{class:!0});var kt=w(X);m(Te.$$.fragment,kt),jn=s(kt),nt=i(kt,"P",{"data-svelte-h":!0}),_(nt)!=="svelte-pkn4ui"&&(nt.innerHTML=hs),kt.forEach(o),Un=s(d),Q=i(d,"DIV",{class:!0});var Pt=w(Q);m(ye.$$.fragment,Pt),Ln=s(Pt),st=i(Pt,"P",{"data-svelte-h":!0}),_(st)!=="svelte-d7vywi"&&(st.innerHTML=_s),Pt.forEach(o),Nn=s(d),at=i(d,"DIV",{class:!0});var Us=w(at);m(Ge.$$.fragment,Us),Us.forEach(o),En=s(d),it=i(d,"DIV",{class:!0});var Ls=w(it);m(xe.$$.fragment,Ls),Ls.forEach(o),Zn=s(d),H=i(d,"DIV",{class:!0});var Wt=w(H);m(Je.$$.fragment,Wt),Cn=s(Wt),ot=i(Wt,"P",{"data-svelte-h":!0}),_(ot)!=="svelte-z0y3an"&&(ot.innerHTML=bs),Wt.forEach(o),$n=s(d),q=i(d,"DIV",{class:!0});var Bt=w(q);m(je.$$.fragment,Bt),Sn=s(Bt),lt=i(Bt,"P",{"data-svelte-h":!0}),_(lt)!=="svelte-11j7r65"&&(lt.textContent=Ms),Bt.forEach(o),Dn=s(d),F=i(d,"DIV",{class:!0});var Vt=w(F);m(Ue.$$.fragment,Vt),kn=s(Vt),rt=i(Vt,"P",{"data-svelte-h":!0}),_(rt)!=="svelte-9eocln"&&(rt.textContent=ws),Vt.forEach(o),Pn=s(d),O=i(d,"DIV",{class:!0});var At=w(O);m(Le.$$.fragment,At),Wn=s(At),pt=i(At,"P",{"data-svelte-h":!0}),_(pt)!=="svelte-16q0ax1"&&(pt.textContent=Is),At.forEach(o),Bn=s(d),K=i(d,"DIV",{class:!0});var Rt=w(K);m(Ne.$$.fragment,Rt),Vn=s(Rt),dt=i(Rt,"P",{"data-svelte-h":!0}),_(dt)!=="svelte-1hybt25"&&(dt.textContent=vs),Rt.forEach(o),An=s(d),ee=i(d,"DIV",{class:!0});var zt=w(ee);m(Ee.$$.fragment,zt),Rn=s(zt),ct=i(zt,"P",{"data-svelte-h":!0}),_(ct)!=="svelte-1f1gk5j"&&(ct.textContent=Ts),zt.forEach(o),zn=s(d),te=i(d,"DIV",{class:!0});var Yt=w(te);m(Ze.$$.fragment,Yt),Yn=s(Yt),mt=i(Yt,"P",{"data-svelte-h":!0}),_(mt)!=="svelte-1tqrrzw"&&(mt.textContent=ys),Yt.forEach(o),Xn=s(d),ne=i(d,"DIV",{class:!0});var Xt=w(ne);m(Ce.$$.fragment,Xt),Qn=s(Xt),gt=i(Xt,"P",{"data-svelte-h":!0}),_(gt)!=="svelte-gczl07"&&(gt.textContent=Gs),Xt.forEach(o),d.forEach(o),Gt=s(e),m($e.$$.fragment,e),xt=s(e),E=i(e,"DIV",{class:!0});var Qt=w(E);m(Se.$$.fragment,Qt),Hn=s(Qt),ft=i(Qt,"P",{"data-svelte-h":!0}),_(ft)!=="svelte-1qpjiuf"&&(ft.textContent=xs),Qt.forEach(o),Jt=s(e),m(De.$$.fragment,e),jt=s(e),ht=i(e,"P",{}),w(ht).forEach(o),this.h()},h(){I(b,"name","hf:doc:metadata"),I(b,"content",Rs),I(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(at,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(it,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(r,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,p){t(document.head,b),M(e,U,p),M(e,x,p),M(e,T,p),g(J,e,p),M(e,l,p),M(e,j,p),M(e,_t,p),M(e,se,p),M(e,bt,p),M(e,ae,p),M(e,Mt,p),g($,e,p),M(e,wt,p),M(e,ie,p),M(e,It,p),g(oe,e,p),M(e,vt,p),M(e,v,p),g(le,v,null),t(v,qt),t(v,Pe),t(v,Ft),t(v,We),t(v,Ot),t(v,L),g(re,L,null),t(L,Kt),t(L,Be),t(L,en),g(S,L,null),t(v,tn),t(v,D),g(pe,D,null),t(D,nn),t(D,Ve),t(v,sn),t(v,k),g(de,k,null),t(k,an),t(k,Ae),t(v,on),t(v,P),g(ce,P,null),t(P,ln),t(P,Re),t(v,rn),t(v,W),g(me,W,null),t(W,pn),t(W,ze),t(v,dn),t(v,B),g(ge,B,null),t(B,cn),t(B,Ye),t(v,mn),t(v,Xe),g(fe,Xe,null),t(v,gn),t(v,Qe),g(ue,Qe,null),t(v,fn),t(v,V),g(he,V,null),t(V,un),t(V,He),M(e,Tt,p),g(_e,e,p),M(e,yt,p),M(e,r,p),g(be,r,null),t(r,hn),t(r,qe),t(r,_n),t(r,Fe),t(r,bn),t(r,N),g(Me,N,null),t(N,Mn),t(N,Oe),t(N,wn),g(A,N,null),t(r,In),t(r,R),g(we,R,null),t(R,vn),t(R,Ke),t(r,Tn),t(r,z),g(Ie,z,null),t(z,yn),t(z,et),t(r,Gn),t(r,Y),g(ve,Y,null),t(Y,xn),t(Y,tt),t(r,Jn),t(r,X),g(Te,X,null),t(X,jn),t(X,nt),t(r,Un),t(r,Q),g(ye,Q,null),t(Q,Ln),t(Q,st),t(r,Nn),t(r,at),g(Ge,at,null),t(r,En),t(r,it),g(xe,it,null),t(r,Zn),t(r,H),g(Je,H,null),t(H,Cn),t(H,ot),t(r,$n),t(r,q),g(je,q,null),t(q,Sn),t(q,lt),t(r,Dn),t(r,F),g(Ue,F,null),t(F,kn),t(F,rt),t(r,Pn),t(r,O),g(Le,O,null),t(O,Wn),t(O,pt),t(r,Bn),t(r,K),g(Ne,K,null),t(K,Vn),t(K,dt),t(r,An),t(r,ee),g(Ee,ee,null),t(ee,Rn),t(ee,ct),t(r,zn),t(r,te),g(Ze,te,null),t(te,Yn),t(te,mt),t(r,Xn),t(r,ne),g(Ce,ne,null),t(ne,Qn),t(ne,gt),M(e,Gt,p),g($e,e,p),M(e,xt,p),M(e,E,p),g(Se,E,null),t(E,Hn),t(E,ft),M(e,Jt,p),g(De,e,p),M(e,jt,p),M(e,ht,p),Ut=!0},p(e,[p]){const G={};p&2&&(G.$$scope={dirty:p,ctx:e}),$.$set(G);const Z={};p&2&&(Z.$$scope={dirty:p,ctx:e}),S.$set(Z);const ke={};p&2&&(ke.$$scope={dirty:p,ctx:e}),A.$set(ke)},i(e){Ut||(f(J.$$.fragment,e),f($.$$.fragment,e),f(oe.$$.fragment,e),f(le.$$.fragment,e),f(re.$$.fragment,e),f(S.$$.fragment,e),f(pe.$$.fragment,e),f(de.$$.fragment,e),f(ce.$$.fragment,e),f(me.$$.fragment,e),f(ge.$$.fragment,e),f(fe.$$.fragment,e),f(ue.$$.fragment,e),f(he.$$.fragment,e),f(_e.$$.fragment,e),f(be.$$.fragment,e),f(Me.$$.fragment,e),f(A.$$.fragment,e),f(we.$$.fragment,e),f(Ie.$$.fragment,e),f(ve.$$.fragment,e),f(Te.$$.fragment,e),f(ye.$$.fragment,e),f(Ge.$$.fragment,e),f(xe.$$.fragment,e),f(Je.$$.fragment,e),f(je.$$.fragment,e),f(Ue.$$.fragment,e),f(Le.$$.fragment,e),f(Ne.$$.fragment,e),f(Ee.$$.fragment,e),f(Ze.$$.fragment,e),f(Ce.$$.fragment,e),f($e.$$.fragment,e),f(Se.$$.fragment,e),f(De.$$.fragment,e),Ut=!0)},o(e){u(J.$$.fragment,e),u($.$$.fragment,e),u(oe.$$.fragment,e),u(le.$$.fragment,e),u(re.$$.fragment,e),u(S.$$.fragment,e),u(pe.$$.fragment,e),u(de.$$.fragment,e),u(ce.$$.fragment,e),u(me.$$.fragment,e),u(ge.$$.fragment,e),u(fe.$$.fragment,e),u(ue.$$.fragment,e),u(he.$$.fragment,e),u(_e.$$.fragment,e),u(be.$$.fragment,e),u(Me.$$.fragment,e),u(A.$$.fragment,e),u(we.$$.fragment,e),u(Ie.$$.fragment,e),u(ve.$$.fragment,e),u(Te.$$.fragment,e),u(ye.$$.fragment,e),u(Ge.$$.fragment,e),u(xe.$$.fragment,e),u(Je.$$.fragment,e),u(je.$$.fragment,e),u(Ue.$$.fragment,e),u(Le.$$.fragment,e),u(Ne.$$.fragment,e),u(Ee.$$.fragment,e),u(Ze.$$.fragment,e),u(Ce.$$.fragment,e),u($e.$$.fragment,e),u(Se.$$.fragment,e),u(De.$$.fragment,e),Ut=!1},d(e){e&&(o(U),o(x),o(T),o(l),o(j),o(_t),o(se),o(bt),o(ae),o(Mt),o(wt),o(ie),o(It),o(vt),o(v),o(Tt),o(yt),o(r),o(Gt),o(xt),o(E),o(Jt),o(jt),o(ht)),o(b),h(J,e),h($,e),h(oe,e),h(le),h(re),h(S),h(pe),h(de),h(ce),h(me),h(ge),h(fe),h(ue),h(he),h(_e,e),h(be),h(Me),h(A),h(we),h(Ie),h(ve),h(Te),h(ye),h(Ge),h(xe),h(Je),h(je),h(Ue),h(Le),h(Ne),h(Ee),h(Ze),h(Ce),h($e,e),h(Se),h(De,e)}}}const Rs='{"title":"GLIGEN (Grounded Language-to-Image Generation)","local":"gligen-grounded-language-to-image-generation","sections":[{"title":"StableDiffusionGLIGENPipeline","local":"diffusers.StableDiffusionGLIGENPipeline","sections":[],"depth":2},{"title":"StableDiffusionGLIGENTextImagePipeline","local":"diffusers.StableDiffusionGLIGENTextImagePipeline","sections":[],"depth":2},{"title":"StableDiffusionPipelineOutput","local":"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput","sections":[],"depth":2}],"depth":1}';function zs(C){return Cs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ks extends $s{constructor(b){super(),Ss(this,b,zs,As,Zs,{})}}export{Ks as component};
