import{s as Pa,o as Ka,n as qa}from"../chunks/scheduler.0219f8bd.js";import{S as Oa,i as st,g as p,s as e,r,m as lt,A as at,h as M,f as a,c as n,j as d,u as j,x as c,n as tt,k as ra,y as i,a as t,v as o,d as h,t as U,w as J}from"../chunks/index.f61edf3b.js";import{T as et}from"../chunks/Tip.5d1e3ef4.js";import{C as T}from"../chunks/CodeBlock.38e566ae.js";import{H as Gs,E as nt}from"../chunks/EditOnGithub.48fa589f.js";function pt($s){let y,I=`We recommend starting the development server again with <code>npm run dev</code>
(if not already running) so that you can see your changes in real-time.`;return{c(){y=p("p"),y.innerHTML=I},l(w){y=M(w,"P",{"data-svelte-h":!0}),c(y)!=="svelte-155lffx"&&(y.innerHTML=I)},m(w,Ss){t(w,y,Ss)},p:qa,d(w){w&&a(y)}}}function Mt($s){let y,I,w,Ss,b,Fs,g,ja="In this tutorial, we’ll be building a simple React application that performs multilingual translation using Transformers.js! The final product will look something like this:",Ls,f,oa='<img src="https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/react-translator-demo.gif" alt="Demo"/>',_s,B,ha="Useful links:",Ds,Z,Ua='<li><a href="https://huggingface.co/spaces/Xenova/react-translator" rel="nofollow">Demo site</a></li> <li><a href="https://github.com/huggingface/transformers.js/tree/main/examples/react-translator" rel="nofollow">Source code</a></li>',Ps,E,Ks,N,Ja='<li><a href="https://nodejs.org/en/" rel="nofollow">Node.js</a> version 18+</li> <li><a href="https://www.npmjs.com/" rel="nofollow">npm</a> version 9+</li>',qs,Q,Os,A,ya='For this tutorial, we will use <a href="https://vitejs.dev/" rel="nofollow">Vite</a> to initialise our project. Vite is a build tool that allows us to quickly set up a React application with minimal configuration. Run the following command in your terminal:',sl,G,ll,S,Ta="If prompted to install <code>create-vite</code>, type <kbd>y</kbd> and press <kbd>Enter</kbd>.",al,R,da="Next, enter the project directory and install the necessary development dependencies:",tl,W,el,k,wa="To test that our application is working, we can run the following command:",nl,v,pl,x,ua=`Visiting the URL shown in the terminal (e.g., <a href="http://localhost:5173/" rel="nofollow">http://localhost:5173/</a>) should show the default “React + Vite” landing page.
You can stop the development server by pressing <kbd>Ctrl</kbd> + <kbd>C</kbd> in the terminal.`,Ml,z,cl,V,ma='Now we get to the fun part: adding machine learning to our application! First, install Transformers.js from <a href="https://www.npmjs.com/package/@huggingface/transformers" rel="nofollow">NPM</a> with the following command:',il,Y,rl,X,Ca='For this application, we will use the <a href="https://huggingface.co/Xenova/nllb-200-distilled-600M" rel="nofollow">Xenova/nllb-200-distilled-600M</a> model, which can perform multilingual translation among 200 languages. Before we start, there are 2 things we need to take note of:',jl,H,Ia="<li>ML inference can be quite computationally intensive, so it’s better to load and run the models in a separate thread from the main (UI) thread.</li> <li>Since the model is quite large (&gt;1 GB), we don’t want to download it until the user clicks the “Translate” button.</li>",ol,$,ba='We can achieve both of these goals by using a <a href="https://developer.mozilla.org/en-US/docs/Web/API/Web_Workers_API/Using_web_workers" rel="nofollow">Web Worker</a> and some <a href="https://react.dev/reference/react" rel="nofollow">React hooks</a>.',hl,u,F,Rs,ga='Create a file called <code>worker.js</code> in the <code>src</code> directory. This script will do all the heavy-lifing for us, including loading and running of the translation pipeline. To ensure the model is only loaded once, we will create the <code>MyTranslationPipeline</code> class which use the <a href="https://en.wikipedia.org/wiki/Singleton_pattern" rel="nofollow">singleton pattern</a> to lazily create a single instance of the pipeline when <code>getInstance</code> is first called, and use this pipeline for all subsequent calls:',sa,L,la,_,Ws,fa="Modify <code>App.jsx</code> in the <code>src</code> directory. This file is automatically created when initializing our React project, and will contain some boilerplate code. Inside the <code>App</code> function, let’s create the web worker and store a reference to it using the <code>useRef</code> hook:",aa,D,Ul,P,Jl,m,yl,K,Ba="First, let’s define our components. Create a folder called <code>components</code> in the <code>src</code> directory, and create the following files:",Tl,ks,q,vs,Za='<code>LanguageSelector.jsx</code>: This component will allow the user to select the input and output languages. Check out the full list of languages <a href="https://github.com/huggingface/transformers.js/blob/main/examples/react-translator/src/components/LanguageSelector.jsx" rel="nofollow">here</a>.',ta,O,dl,ss,ls,xs,Ea="Progress.jsx",ea,as,wl,ts,Na="We can now use these components in <code>App.jsx</code> by adding these imports to the top of the file:",ul,es,ml,ns,Qa="Let’s also add some state variables to keep track of a few things in our application, like model loading, languages, input text, and output text. Add the following code to the beginning of the <code>App</code> function in <code>src/App.jsx</code>:",Cl,ps,Il,Ms,Aa="Next, we can add our custom components to the main <code>App</code> component. We will also add two <code>textarea</code> elements for input and output text, and a <code>button</code> to trigger the translation.  Modify the <code>return</code> statement to look like this:",bl,cs,gl,is,Ga="Don’t worry about the <code>translate</code> function for now. We will define it in the next section.",fl,rs,Sa="Finally, we can add some CSS to make our app look a little nicer. Modify the following files in the <code>src</code> directory:",Bl,C,js,zs,Ra="<code>index.css</code>:",na,os,Vs,Wa="View code",pa,hs,Ma,Us,Ys,ka="<code>App.css</code>",ca,Js,Xs,va="View code",ia,ys,Zl,Ts,El,ds,xa="Now that we have a basic user interface set up, we can finally connect everything together.",Nl,ws,za="First, let’s define the <code>translate</code> function, which will be called when the user clicks the <code>Translate</code> button. This sends a message (containing the input text, source language, and target language) to the worker thread for processing. We will also disable the button so the user doesn’t click it multiple times. Add the following code just before the <code>return</code> statement in the <code>App</code> function:",Ql,us,Al,ms,Va="Now, let’s add an event listener in <code>src/worker.js</code> to listen for messages from the main thread. We will send back messages (e.g., for model loading progress and text streaming) to the main thread with <code>self.postMessage</code>.",Gl,Cs,Sl,Is,Ya="Finally, let’s fill in our <code>onMessageReceived</code> function, which will update the application state in response to messages from the worker thread. Add the following code inside the <code>useEffect</code> hook we defined earlier:",Rl,bs,Wl,gs,Xa="You can now run the application with <code>npm run dev</code> and perform multilingual translation directly in your browser!",kl,fs,vl,Bs,Ha="To build your application, simply run <code>npm run build</code>. This will bundle your application and output the static files to the <code>dist</code> folder.",xl,Zs,$a='For this demo, we will deploy our application as a static <a href="https://huggingface.co/docs/hub/spaces" rel="nofollow">Hugging Face Space</a>, but you can deploy it anywhere you like! If you haven’t already, you can create a free Hugging Face account <a href="https://huggingface.co/join" rel="nofollow">here</a>.',zl,Es,Fa='<li>Visit <a href="https://huggingface.co/new-space" rel="nofollow">https://huggingface.co/new-space</a> and fill in the form. Remember to select “Static” as the space type.</li> <li>Go to “Files” → “Add file” → “Upload files”. Drag the <code>index.html</code> file and <code>public/</code> folder from the <code>dist</code> folder into the upload box and click “Upload”. After they have uploaded, scroll down to the button and click “Commit changes to main”.</li>',Vl,Ns,La="<strong>That’s it!</strong> Your application should now be live at <code>https://huggingface.co/spaces/&lt;your-username&gt;/&lt;your-space-name&gt;</code>!",Yl,Qs,Xl,Hs,Hl;return b=new Gs({props:{title:"Building a React application",local:"building-a-react-application",headingTag:"h1"}}),E=new Gs({props:{title:"Prerequisites",local:"prerequisites",headingTag:"h2"}}),Q=new Gs({props:{title:"Step 1: Initialise the project",local:"step-1-initialise-the-project",headingTag:"h2"}}),G=new T({props:{code:"bnBtJTIwY3JlYXRlJTIwdml0ZSU0MGxhdGVzdCUyMHJlYWN0LXRyYW5zbGF0b3IlMjAtLSUyMC0tdGVtcGxhdGUlMjByZWFjdA==",highlighted:"npm create vite@latest react-translator -- --template react",wrap:!1}}),W=new T({props:{code:"Y2QlMjByZWFjdC10cmFuc2xhdG9yJTBBbnBtJTIwaW5zdGFsbA==",highlighted:`<span class="hljs-built_in">cd</span> react-translator
npm install`,wrap:!1}}),v=new T({props:{code:"bnBtJTIwcnVuJTIwZGV2",highlighted:"npm run dev",wrap:!1}}),z=new Gs({props:{title:"Step 2: Install and configure Transformers.js",local:"step-2-install-and-configure-transformersjs",headingTag:"h2"}}),Y=new T({props:{code:"bnBtJTIwaW5zdGFsbCUyMCU0MGh1Z2dpbmdmYWNlJTJGdHJhbnNmb3JtZXJz",highlighted:"npm install @huggingface/transformers",wrap:!1}}),L=new T({props:{code:"aW1wb3J0JTIwJTdCJTIwcGlwZWxpbmUlMjAlN0QlMjBmcm9tJTIwJyU0MGh1Z2dpbmdmYWNlJTJGdHJhbnNmb3JtZXJzJyUzQiUwQSUwQWNsYXNzJTIwTXlUcmFuc2xhdGlvblBpcGVsaW5lJTIwJTdCJTBBJTIwJTIwc3RhdGljJTIwdGFzayUyMCUzRCUyMCd0cmFuc2xhdGlvbiclM0IlMEElMjAlMjBzdGF0aWMlMjBtb2RlbCUyMCUzRCUyMCdYZW5vdmElMkZubGxiLTIwMC1kaXN0aWxsZWQtNjAwTSclM0IlMEElMjAlMjBzdGF0aWMlMjBpbnN0YW5jZSUyMCUzRCUyMG51bGwlM0IlMEElMEElMjAlMjBzdGF0aWMlMjBhc3luYyUyMGdldEluc3RhbmNlKHByb2dyZXNzX2NhbGxiYWNrJTIwJTNEJTIwbnVsbCklMjAlN0IlMEElMjAlMjAlMjAlMjBpZiUyMCh0aGlzLmluc3RhbmNlJTIwJTNEJTNEJTNEJTIwbnVsbCklMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjB0aGlzLmluc3RhbmNlJTIwJTNEJTIwcGlwZWxpbmUodGhpcy50YXNrJTJDJTIwdGhpcy5tb2RlbCUyQyUyMCU3QiUyMHByb2dyZXNzX2NhbGxiYWNrJTIwJTdEKSUzQiUwQSUyMCUyMCUyMCUyMCU3RCUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRoaXMuaW5zdGFuY2UlM0IlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-keyword">import</span> { pipeline } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@huggingface/transformers&#x27;</span>;

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyTranslationPipeline</span> {
  <span class="hljs-keyword">static</span> task = <span class="hljs-string">&#x27;translation&#x27;</span>;
  <span class="hljs-keyword">static</span> model = <span class="hljs-string">&#x27;Xenova/nllb-200-distilled-600M&#x27;</span>;
  <span class="hljs-keyword">static</span> instance = <span class="hljs-literal">null</span>;

  <span class="hljs-keyword">static</span> <span class="hljs-keyword">async</span> <span class="hljs-title function_">getInstance</span>(<span class="hljs-params">progress_callback = <span class="hljs-literal">null</span></span>) {
    <span class="hljs-keyword">if</span> (<span class="hljs-variable language_">this</span>.<span class="hljs-property">instance</span> === <span class="hljs-literal">null</span>) {
      <span class="hljs-variable language_">this</span>.<span class="hljs-property">instance</span> = <span class="hljs-title function_">pipeline</span>(<span class="hljs-variable language_">this</span>.<span class="hljs-property">task</span>, <span class="hljs-variable language_">this</span>.<span class="hljs-property">model</span>, { progress_callback });
    }

    <span class="hljs-keyword">return</span> <span class="hljs-variable language_">this</span>.<span class="hljs-property">instance</span>;
  }
}`,wrap:!1}}),D=new T({props:{code:"JTJGJTJGJTIwUmVtZW1iZXIlMjB0byUyMGltcG9ydCUyMHRoZSUyMHJlbGV2YW50JTIwaG9va3MlMEFpbXBvcnQlMjAlN0IlMjB1c2VFZmZlY3QlMkMlMjB1c2VSZWYlMkMlMjB1c2VTdGF0ZSUyMCU3RCUyMGZyb20lMjAncmVhY3QnJTBBJTBBZnVuY3Rpb24lMjBBcHAoKSUyMCU3QiUwQSUyMCUyMCUyRiUyRiUyMENyZWF0ZSUyMGElMjByZWZlcmVuY2UlMjB0byUyMHRoZSUyMHdvcmtlciUyMG9iamVjdC4lMEElMjAlMjBjb25zdCUyMHdvcmtlciUyMCUzRCUyMHVzZVJlZihudWxsKSUzQiUwQSUwQSUyMCUyMCUyRiUyRiUyMFdlJTIwdXNlJTIwdGhlJTIwJTYwdXNlRWZmZWN0JTYwJTIwaG9vayUyMHRvJTIwc2V0dXAlMjB0aGUlMjB3b3JrZXIlMjBhcyUyMHNvb24lMjBhcyUyMHRoZSUyMCU2MEFwcCU2MCUyMGNvbXBvbmVudCUyMGlzJTIwbW91bnRlZC4lMEElMjAlMjB1c2VFZmZlY3QoKCklMjAlM0QlM0UlMjAlN0IlMEElMjAlMjAlMjAlMjBpZiUyMCghd29ya2VyLmN1cnJlbnQpJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTJGJTJGJTIwQ3JlYXRlJTIwdGhlJTIwd29ya2VyJTIwaWYlMjBpdCUyMGRvZXMlMjBub3QlMjB5ZXQlMjBleGlzdC4lMEElMjAlMjAlMjAlMjAlMjAlMjB3b3JrZXIuY3VycmVudCUyMCUzRCUyMG5ldyUyMFdvcmtlcihuZXclMjBVUkwoJy4lMkZ3b3JrZXIuanMnJTJDJTIwaW1wb3J0Lm1ldGEudXJsKSUyQyUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHR5cGUlM0ElMjAnbW9kdWxlJyUwQSUyMCUyMCUyMCUyMCUyMCUyMCU3RCklM0IlMEElMjAlMjAlMjAlMjAlN0QlMEElMEElMjAlMjAlMjAlMjAlMkYlMkYlMjBDcmVhdGUlMjBhJTIwY2FsbGJhY2slMjBmdW5jdGlvbiUyMGZvciUyMG1lc3NhZ2VzJTIwZnJvbSUyMHRoZSUyMHdvcmtlciUyMHRocmVhZC4lMEElMjAlMjAlMjAlMjBjb25zdCUyMG9uTWVzc2FnZVJlY2VpdmVkJTIwJTNEJTIwKGUpJTIwJTNEJTNFJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTJGJTJGJTIwVE9ETyUzQSUyMFdpbGwlMjBmaWxsJTIwaW4lMjBsYXRlciUwQSUyMCUyMCUyMCUyMCU3RCUzQiUwQSUwQSUyMCUyMCUyMCUyMCUyRiUyRiUyMEF0dGFjaCUyMHRoZSUyMGNhbGxiYWNrJTIwZnVuY3Rpb24lMjBhcyUyMGFuJTIwZXZlbnQlMjBsaXN0ZW5lci4lMEElMjAlMjAlMjAlMjB3b3JrZXIuY3VycmVudC5hZGRFdmVudExpc3RlbmVyKCdtZXNzYWdlJyUyQyUyMG9uTWVzc2FnZVJlY2VpdmVkKSUzQiUwQSUwQSUyMCUyMCUyMCUyMCUyRiUyRiUyMERlZmluZSUyMGElMjBjbGVhbnVwJTIwZnVuY3Rpb24lMjBmb3IlMjB3aGVuJTIwdGhlJTIwY29tcG9uZW50JTIwaXMlMjB1bm1vdW50ZWQuJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwKCklMjAlM0QlM0UlMjB3b3JrZXIuY3VycmVudC5yZW1vdmVFdmVudExpc3RlbmVyKCdtZXNzYWdlJyUyQyUyMG9uTWVzc2FnZVJlY2VpdmVkKSUzQiUwQSUyMCUyMCU3RCklM0IlMEElMEElMjAlMjByZXR1cm4lMjAoJTBBJTIwJTIwJTIwJTIwJTJGJTJGJTIwVE9ETyUzQSUyMFJlc3QlMjBvZiUyMG91ciUyMGFwcCUyMGdvZXMlMjBoZXJlLi4uJTBBJTIwJTIwKSUwQSU3RCUwQSUwQWV4cG9ydCUyMGRlZmF1bHQlMjBBcHAlMEE=",highlighted:`<span class="hljs-comment">// Remember to import the relevant hooks</span>
<span class="hljs-keyword">import</span> { useEffect, useRef, useState } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;react&#x27;</span>

<span class="hljs-keyword">function</span> <span class="hljs-title function_">App</span>(<span class="hljs-params"></span>) {
  <span class="hljs-comment">// Create a reference to the worker object.</span>
  <span class="hljs-keyword">const</span> worker = <span class="hljs-title function_">useRef</span>(<span class="hljs-literal">null</span>);

  <span class="hljs-comment">// We use the \`useEffect\` hook to setup the worker as soon as the \`App\` component is mounted.</span>
  <span class="hljs-title function_">useEffect</span>(<span class="hljs-function">() =&gt;</span> {
    <span class="hljs-keyword">if</span> (!worker.<span class="hljs-property">current</span>) {
      <span class="hljs-comment">// Create the worker if it does not yet exist.</span>
      worker.<span class="hljs-property">current</span> = <span class="hljs-keyword">new</span> <span class="hljs-title class_">Worker</span>(<span class="hljs-keyword">new</span> <span class="hljs-title function_">URL</span>(<span class="hljs-string">&#x27;./worker.js&#x27;</span>, <span class="hljs-keyword">import</span>.<span class="hljs-property">meta</span>.<span class="hljs-property">url</span>), {
          <span class="hljs-attr">type</span>: <span class="hljs-string">&#x27;module&#x27;</span>
      });
    }

    <span class="hljs-comment">// Create a callback function for messages from the worker thread.</span>
    <span class="hljs-keyword">const</span> <span class="hljs-title function_">onMessageReceived</span> = (<span class="hljs-params">e</span>) =&gt; {
      <span class="hljs-comment">// <span class="hljs-doctag">TODO:</span> Will fill in later</span>
    };

    <span class="hljs-comment">// Attach the callback function as an event listener.</span>
    worker.<span class="hljs-property">current</span>.<span class="hljs-title function_">addEventListener</span>(<span class="hljs-string">&#x27;message&#x27;</span>, onMessageReceived);

    <span class="hljs-comment">// Define a cleanup function for when the component is unmounted.</span>
    <span class="hljs-keyword">return</span> <span class="hljs-function">() =&gt;</span> worker.<span class="hljs-property">current</span>.<span class="hljs-title function_">removeEventListener</span>(<span class="hljs-string">&#x27;message&#x27;</span>, onMessageReceived);
  });

  <span class="hljs-keyword">return</span> (
    <span class="hljs-comment">// <span class="hljs-doctag">TODO:</span> Rest of our app goes here...</span>
  )
}

<span class="hljs-keyword">export</span> <span class="hljs-keyword">default</span> <span class="hljs-title class_">App</span>
`,wrap:!1}}),P=new Gs({props:{title:"Step 3: Design the user interface",local:"step-3-design-the-user-interface",headingTag:"h2"}}),m=new et({props:{$$slots:{default:[pt]},$$scope:{ctx:$s}}}),O=new T({props:{code:"Y29uc3QlMjBMQU5HVUFHRVMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjJBY2VobmVzZSUyMChBcmFiaWMlMjBzY3JpcHQpJTIyJTNBJTIwJTIyYWNlX0FyYWIlMjIlMkMlMEElMjAlMjAlMjJBY2VobmVzZSUyMChMYXRpbiUyMHNjcmlwdCklMjIlM0ElMjAlMjJhY2VfTGF0biUyMiUyQyUwQSUyMCUyMCUyMkFmcmlrYWFucyUyMiUzQSUyMCUyMmFmcl9MYXRuJTIyJTJDJTBBJTIwJTIwLi4uJTBBJTIwJTIwJTIyWnVsdSUyMiUzQSUyMCUyMnp1bF9MYXRuJTIyJTJDJTBBJTdEJTBBJTBBZXhwb3J0JTIwZGVmYXVsdCUyMGZ1bmN0aW9uJTIwTGFuZ3VhZ2VTZWxlY3RvciglN0IlMjB0eXBlJTJDJTIwb25DaGFuZ2UlMkMlMjBkZWZhdWx0TGFuZ3VhZ2UlMjAlN0QpJTIwJTdCJTBBJTIwJTIwcmV0dXJuJTIwKCUwQSUyMCUyMCUyMCUyMCUzQ2RpdiUyMGNsYXNzTmFtZSUzRCdsYW5ndWFnZS1zZWxlY3RvciclM0UlMEElMjAlMjAlMjAlMjAlMjAlMjAlM0NsYWJlbCUzRSU3QnR5cGUlN0QlM0ElMjAlM0MlMkZsYWJlbCUzRSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUzQ3NlbGVjdCUyMG9uQ2hhbmdlJTNEJTdCb25DaGFuZ2UlN0QlMjBkZWZhdWx0VmFsdWUlM0QlN0JkZWZhdWx0TGFuZ3VhZ2UlN0QlM0UlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0JPYmplY3QuZW50cmllcyhMQU5HVUFHRVMpLm1hcCgoJTVCa2V5JTJDJTIwdmFsdWUlNUQpJTIwJTNEJTNFJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTNDb3B0aW9uJTIwa2V5JTNEJTdCa2V5JTdEJTIwdmFsdWUlM0QlN0J2YWx1ZSU3RCUzRSU3QmtleSU3RCUzQyUyRm9wdGlvbiUzRSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCklN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlM0MlMkZzZWxlY3QlM0UlMEElMjAlMjAlMjAlMjAlM0MlMkZkaXYlM0UlMEElMjAlMjApJTBBJTdE",highlighted:`<span class="hljs-keyword">const</span> <span class="hljs-variable constant_">LANGUAGES</span> = {
  <span class="hljs-string">&quot;Acehnese (Arabic script)&quot;</span>: <span class="hljs-string">&quot;ace_Arab&quot;</span>,
  <span class="hljs-string">&quot;Acehnese (Latin script)&quot;</span>: <span class="hljs-string">&quot;ace_Latn&quot;</span>,
  <span class="hljs-string">&quot;Afrikaans&quot;</span>: <span class="hljs-string">&quot;afr_Latn&quot;</span>,
  ...
  <span class="hljs-string">&quot;Zulu&quot;</span>: <span class="hljs-string">&quot;zul_Latn&quot;</span>,
}

<span class="hljs-keyword">export</span> <span class="hljs-keyword">default</span> <span class="hljs-keyword">function</span> <span class="hljs-title function_">LanguageSelector</span>(<span class="hljs-params">{ type, onChange, defaultLanguage }</span>) {
  <span class="hljs-keyword">return</span> (
    <span class="language-xml"><span class="hljs-tag">&lt;<span class="hljs-name">div</span> <span class="hljs-attr">className</span>=<span class="hljs-string">&#x27;language-selector&#x27;</span>&gt;</span>
      <span class="hljs-tag">&lt;<span class="hljs-name">label</span>&gt;</span>{type}: <span class="hljs-tag">&lt;/<span class="hljs-name">label</span>&gt;</span>
      <span class="hljs-tag">&lt;<span class="hljs-name">select</span> <span class="hljs-attr">onChange</span>=<span class="hljs-string">{onChange}</span> <span class="hljs-attr">defaultValue</span>=<span class="hljs-string">{defaultLanguage}</span>&gt;</span>
        {Object.entries(LANGUAGES).map(([key, value]) =&gt; {
          return <span class="hljs-tag">&lt;<span class="hljs-name">option</span> <span class="hljs-attr">key</span>=<span class="hljs-string">{key}</span> <span class="hljs-attr">value</span>=<span class="hljs-string">{value}</span>&gt;</span>{key}<span class="hljs-tag">&lt;/<span class="hljs-name">option</span>&gt;</span>
        })}
      <span class="hljs-tag">&lt;/<span class="hljs-name">select</span>&gt;</span>
    <span class="hljs-tag">&lt;/<span class="hljs-name">div</span>&gt;</span></span>
  )
}`,wrap:!1}}),as=new T({props:{code:"ZXhwb3J0JTIwZGVmYXVsdCUyMGZ1bmN0aW9uJTIwUHJvZ3Jlc3MoJTdCJTIwdGV4dCUyQyUyMHBlcmNlbnRhZ2UlMjAlN0QpJTIwJTdCJTBBJTIwJTIwcGVyY2VudGFnZSUyMCUzRCUyMHBlcmNlbnRhZ2UlMjAlM0YlM0YlMjAwJTNCJTBBJTIwJTIwcmV0dXJuJTIwKCUwQSUyMCUyMCUyMCUyMCUzQ2RpdiUyMGNsYXNzTmFtZSUzRCUyMnByb2dyZXNzLWNvbnRhaW5lciUyMiUzRSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUzQ2RpdiUyMGNsYXNzTmFtZSUzRCdwcm9ncmVzcy1iYXInJTIwc3R5bGUlM0QlN0IlN0IlMjAnd2lkdGgnJTNBJTIwJTYwJTI0JTdCcGVyY2VudGFnZSU3RCUyNSU2MCUyMCU3RCU3RCUzRSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QnRleHQlN0QlMjAoJTdCJTYwJTI0JTdCcGVyY2VudGFnZS50b0ZpeGVkKDIpJTdEJTI1JTYwJTdEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUzQyUyRmRpdiUzRSUwQSUyMCUyMCUyMCUyMCUzQyUyRmRpdiUzRSUwQSUyMCUyMCklM0IlMEElN0Q=",highlighted:`<span class="hljs-keyword">export</span> <span class="hljs-keyword">default</span> <span class="hljs-keyword">function</span> <span class="hljs-title function_">Progress</span>(<span class="hljs-params">{ text, percentage }</span>) {
  percentage = percentage ?? <span class="hljs-number">0</span>;
  <span class="hljs-keyword">return</span> (
    <span class="language-xml"><span class="hljs-tag">&lt;<span class="hljs-name">div</span> <span class="hljs-attr">className</span>=<span class="hljs-string">&quot;progress-container&quot;</span>&gt;</span>
      <span class="hljs-tag">&lt;<span class="hljs-name">div</span> <span class="hljs-attr">className</span>=<span class="hljs-string">&#x27;progress-bar&#x27;</span> <span class="hljs-attr">style</span>=<span class="hljs-string">{{</span> &#x27;<span class="hljs-attr">width</span>&#x27;<span class="hljs-attr">:</span> \`\${<span class="hljs-attr">percentage</span>}%\` }}&gt;</span>
        {text} ({\`\${percentage.toFixed(2)}%\`})
      <span class="hljs-tag">&lt;/<span class="hljs-name">div</span>&gt;</span>
    <span class="hljs-tag">&lt;/<span class="hljs-name">div</span>&gt;</span></span>
  );
}`,wrap:!1}}),es=new T({props:{code:"aW1wb3J0JTIwTGFuZ3VhZ2VTZWxlY3RvciUyMGZyb20lMjAnLiUyRmNvbXBvbmVudHMlMkZMYW5ndWFnZVNlbGVjdG9yJyUzQiUwQWltcG9ydCUyMFByb2dyZXNzJTIwZnJvbSUyMCcuJTJGY29tcG9uZW50cyUyRlByb2dyZXNzJyUzQg==",highlighted:`<span class="hljs-keyword">import</span> <span class="hljs-title class_">LanguageSelector</span> <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;./components/LanguageSelector&#x27;</span>;
<span class="hljs-keyword">import</span> <span class="hljs-title class_">Progress</span> <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;./components/Progress&#x27;</span>;`,wrap:!1}}),ps=new T({props:{code:"ZnVuY3Rpb24lMjBBcHAoKSUyMCU3QiUwQSUwQSUyMCUyMCUyRiUyRiUyME1vZGVsJTIwbG9hZGluZyUwQSUyMCUyMGNvbnN0JTIwJTVCcmVhZHklMkMlMjBzZXRSZWFkeSU1RCUyMCUzRCUyMHVzZVN0YXRlKG51bGwpJTNCJTBBJTIwJTIwY29uc3QlMjAlNUJkaXNhYmxlZCUyQyUyMHNldERpc2FibGVkJTVEJTIwJTNEJTIwdXNlU3RhdGUoZmFsc2UpJTNCJTBBJTIwJTIwY29uc3QlMjAlNUJwcm9ncmVzc0l0ZW1zJTJDJTIwc2V0UHJvZ3Jlc3NJdGVtcyU1RCUyMCUzRCUyMHVzZVN0YXRlKCU1QiU1RCklM0IlMEElMEElMjAlMjAlMkYlMkYlMjBJbnB1dHMlMjBhbmQlMjBvdXRwdXRzJTBBJTIwJTIwY29uc3QlMjAlNUJpbnB1dCUyQyUyMHNldElucHV0JTVEJTIwJTNEJTIwdXNlU3RhdGUoJ0klMjBsb3ZlJTIwd2Fsa2luZyUyMG15JTIwZG9nLicpJTNCJTBBJTIwJTIwY29uc3QlMjAlNUJzb3VyY2VMYW5ndWFnZSUyQyUyMHNldFNvdXJjZUxhbmd1YWdlJTVEJTIwJTNEJTIwdXNlU3RhdGUoJ2VuZ19MYXRuJyklM0IlMEElMjAlMjBjb25zdCUyMCU1QnRhcmdldExhbmd1YWdlJTJDJTIwc2V0VGFyZ2V0TGFuZ3VhZ2UlNUQlMjAlM0QlMjB1c2VTdGF0ZSgnZnJhX0xhdG4nKSUzQiUwQSUyMCUyMGNvbnN0JTIwJTVCb3V0cHV0JTJDJTIwc2V0T3V0cHV0JTVEJTIwJTNEJTIwdXNlU3RhdGUoJycpJTNCJTBBJTBBJTIwJTIwJTJGJTJGJTIwcmVzdCUyMG9mJTIwdGhlJTIwY29kZS4uLiUwQSU3RA==",highlighted:`<span class="hljs-keyword">function</span> <span class="hljs-title function_">App</span>(<span class="hljs-params"></span>) {

  <span class="hljs-comment">// Model loading</span>
  <span class="hljs-keyword">const</span> [ready, setReady] = <span class="hljs-title function_">useState</span>(<span class="hljs-literal">null</span>);
  <span class="hljs-keyword">const</span> [disabled, setDisabled] = <span class="hljs-title function_">useState</span>(<span class="hljs-literal">false</span>);
  <span class="hljs-keyword">const</span> [progressItems, setProgressItems] = <span class="hljs-title function_">useState</span>([]);

  <span class="hljs-comment">// Inputs and outputs</span>
  <span class="hljs-keyword">const</span> [input, setInput] = <span class="hljs-title function_">useState</span>(<span class="hljs-string">&#x27;I love walking my dog.&#x27;</span>);
  <span class="hljs-keyword">const</span> [sourceLanguage, setSourceLanguage] = <span class="hljs-title function_">useState</span>(<span class="hljs-string">&#x27;eng_Latn&#x27;</span>);
  <span class="hljs-keyword">const</span> [targetLanguage, setTargetLanguage] = <span class="hljs-title function_">useState</span>(<span class="hljs-string">&#x27;fra_Latn&#x27;</span>);
  <span class="hljs-keyword">const</span> [output, setOutput] = <span class="hljs-title function_">useState</span>(<span class="hljs-string">&#x27;&#x27;</span>);

  <span class="hljs-comment">// rest of the code...</span>
}`,wrap:!1}}),cs=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">return</span> (
  <span class="language-xml"><span class="hljs-tag">&lt;&gt;</span>
    <span class="hljs-tag">&lt;<span class="hljs-name">h1</span>&gt;</span>Transformers.js<span class="hljs-tag">&lt;/<span class="hljs-name">h1</span>&gt;</span>
    <span class="hljs-tag">&lt;<span class="hljs-name">h2</span>&gt;</span>ML-powered multilingual translation in React!<span class="hljs-tag">&lt;/<span class="hljs-name">h2</span>&gt;</span>

    <span class="hljs-tag">&lt;<span class="hljs-name">div</span> <span class="hljs-attr">className</span>=<span class="hljs-string">&#x27;container&#x27;</span>&gt;</span>
      <span class="hljs-tag">&lt;<span class="hljs-name">div</span> <span class="hljs-attr">className</span>=<span class="hljs-string">&#x27;language-container&#x27;</span>&gt;</span>
        <span class="hljs-tag">&lt;<span class="hljs-name">LanguageSelector</span> <span class="hljs-attr">type</span>=<span class="hljs-string">{</span>&quot;<span class="hljs-attr">Source</span>&quot;} <span class="hljs-attr">defaultLanguage</span>=<span class="hljs-string">{</span>&quot;<span class="hljs-attr">eng_Latn</span>&quot;} <span class="hljs-attr">onChange</span>=<span class="hljs-string">{x</span> =&gt;</span> setSourceLanguage(x.target.value)} /&gt;
        <span class="hljs-tag">&lt;<span class="hljs-name">LanguageSelector</span> <span class="hljs-attr">type</span>=<span class="hljs-string">{</span>&quot;<span class="hljs-attr">Target</span>&quot;} <span class="hljs-attr">defaultLanguage</span>=<span class="hljs-string">{</span>&quot;<span class="hljs-attr">fra_Latn</span>&quot;} <span class="hljs-attr">onChange</span>=<span class="hljs-string">{x</span> =&gt;</span> setTargetLanguage(x.target.value)} /&gt;
      <span class="hljs-tag">&lt;/<span class="hljs-name">div</span>&gt;</span>

      <span class="hljs-tag">&lt;<span class="hljs-name">div</span> <span class="hljs-attr">className</span>=<span class="hljs-string">&#x27;textbox-container&#x27;</span>&gt;</span>
        <span class="hljs-tag">&lt;<span class="hljs-name">textarea</span> <span class="hljs-attr">value</span>=<span class="hljs-string">{input}</span> <span class="hljs-attr">rows</span>=<span class="hljs-string">{3}</span> <span class="hljs-attr">onChange</span>=<span class="hljs-string">{e</span> =&gt;</span> setInput(e.target.value)}&gt;<span class="hljs-tag">&lt;/<span class="hljs-name">textarea</span>&gt;</span>
        <span class="hljs-tag">&lt;<span class="hljs-name">textarea</span> <span class="hljs-attr">value</span>=<span class="hljs-string">{output}</span> <span class="hljs-attr">rows</span>=<span class="hljs-string">{3}</span> <span class="hljs-attr">readOnly</span>&gt;</span><span class="hljs-tag">&lt;/<span class="hljs-name">textarea</span>&gt;</span>
      <span class="hljs-tag">&lt;/<span class="hljs-name">div</span>&gt;</span>
    <span class="hljs-tag">&lt;/<span class="hljs-name">div</span>&gt;</span>

    <span class="hljs-tag">&lt;<span class="hljs-name">button</span> <span class="hljs-attr">disabled</span>=<span class="hljs-string">{disabled}</span> <span class="hljs-attr">onClick</span>=<span class="hljs-string">{translate}</span>&gt;</span>Translate<span class="hljs-tag">&lt;/<span class="hljs-name">button</span>&gt;</span>

    <span class="hljs-tag">&lt;<span class="hljs-name">div</span> <span class="hljs-attr">className</span>=<span class="hljs-string">&#x27;progress-bars-container&#x27;</span>&gt;</span>
      {ready === false &amp;&amp; (
        <span class="hljs-tag">&lt;<span class="hljs-name">label</span>&gt;</span>Loading models... (only run once)<span class="hljs-tag">&lt;/<span class="hljs-name">label</span>&gt;</span>
      )}
      {progressItems.map(data =&gt; (
        <span class="hljs-tag">&lt;<span class="hljs-name">div</span> <span class="hljs-attr">key</span>=<span class="hljs-string">{data.file}</span>&gt;</span>
          <span class="hljs-tag">&lt;<span class="hljs-name">Progress</span> <span class="hljs-attr">text</span>=<span class="hljs-string">{data.file}</span> <span class="hljs-attr">percentage</span>=<span class="hljs-string">{data.progress}</span> /&gt;</span>
        <span class="hljs-tag">&lt;/<span class="hljs-name">div</span>&gt;</span>
      ))}
    <span class="hljs-tag">&lt;/<span class="hljs-name">div</span>&gt;</span>
  <span class="hljs-tag">&lt;/&gt;</span></span>
)`,wrap:!1}}),hs=new T({props:{code:"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",highlighted:`<span class="hljs-selector-pseudo">:root</span> {
  <span class="hljs-attribute">font-family</span>: Inter, system-ui, Avenir, Helvetica, Arial, sans-serif;
  <span class="hljs-attribute">line-height</span>: <span class="hljs-number">1.5</span>;
  <span class="hljs-attribute">font-weight</span>: <span class="hljs-number">400</span>;
  <span class="hljs-attribute">color</span>: <span class="hljs-number">#213547</span>;
  <span class="hljs-attribute">background-color</span>: <span class="hljs-number">#ffffff</span>;

  <span class="hljs-attribute">font-synthesis</span>: none;
  <span class="hljs-attribute">text-rendering</span>: optimizeLegibility;
  -webkit-<span class="hljs-attribute">font-smoothing</span>: antialiased;
  -moz-osx-<span class="hljs-attribute">font-smoothing</span>: grayscale;
  -webkit-text-size-adjust: <span class="hljs-number">100%</span>;
}

<span class="hljs-selector-tag">body</span> {
  <span class="hljs-attribute">margin</span>: <span class="hljs-number">0</span>;
  <span class="hljs-attribute">display</span>: flex;
  place-items: center;
  <span class="hljs-attribute">min-width</span>: <span class="hljs-number">320px</span>;
  <span class="hljs-attribute">min-height</span>: <span class="hljs-number">100vh</span>;
}

<span class="hljs-selector-tag">h1</span> {
  <span class="hljs-attribute">font-size</span>: <span class="hljs-number">3.2em</span>;
  <span class="hljs-attribute">line-height</span>: <span class="hljs-number">1</span>;
}

<span class="hljs-selector-tag">h1</span>,
<span class="hljs-selector-tag">h2</span> {
  <span class="hljs-attribute">margin</span>: <span class="hljs-number">8px</span>;
}

select {
  <span class="hljs-attribute">padding</span>: <span class="hljs-number">0.3em</span>;
  <span class="hljs-attribute">cursor</span>: pointer;
}

<span class="hljs-selector-tag">textarea</span> {
  <span class="hljs-attribute">padding</span>: <span class="hljs-number">0.6em</span>;
}

<span class="hljs-selector-tag">button</span> {
  <span class="hljs-attribute">padding</span>: <span class="hljs-number">0.6em</span> <span class="hljs-number">1.2em</span>;
  <span class="hljs-attribute">cursor</span>: pointer;
  <span class="hljs-attribute">font-weight</span>: <span class="hljs-number">500</span>;
}

<span class="hljs-selector-tag">button</span><span class="hljs-selector-attr">[disabled]</span> {
  <span class="hljs-attribute">cursor</span>: not-allowed;
}

select,
<span class="hljs-selector-tag">textarea</span>,
<span class="hljs-selector-tag">button</span> {
  <span class="hljs-attribute">border-radius</span>: <span class="hljs-number">8px</span>;
  <span class="hljs-attribute">border</span>: <span class="hljs-number">1px</span> solid transparent;
  <span class="hljs-attribute">font-size</span>: <span class="hljs-number">1em</span>;
  <span class="hljs-attribute">font-family</span>: inherit;
  <span class="hljs-attribute">background-color</span>: <span class="hljs-number">#f9f9f9</span>;
  <span class="hljs-attribute">transition</span>: border-color <span class="hljs-number">0.25s</span>;
}

select<span class="hljs-selector-pseudo">:hover</span>,
<span class="hljs-selector-tag">textarea</span><span class="hljs-selector-pseudo">:hover</span>,
<span class="hljs-selector-tag">button</span><span class="hljs-selector-pseudo">:not</span>(<span class="hljs-selector-attr">[disabled]</span>)<span class="hljs-selector-pseudo">:hover</span> {
  <span class="hljs-attribute">border-color</span>: <span class="hljs-number">#646cff</span>;
}

select<span class="hljs-selector-pseudo">:focus</span>,
select<span class="hljs-selector-pseudo">:focus</span>-visible,
<span class="hljs-selector-tag">textarea</span><span class="hljs-selector-pseudo">:focus</span>,
<span class="hljs-selector-tag">textarea</span><span class="hljs-selector-pseudo">:focus</span>-visible,
<span class="hljs-selector-tag">button</span><span class="hljs-selector-pseudo">:focus</span>,
<span class="hljs-selector-tag">button</span><span class="hljs-selector-pseudo">:focus</span>-visible {
  <span class="hljs-attribute">outline</span>: <span class="hljs-number">4px</span> auto -webkit-focus-ring-color;
}`,wrap:!1}}),ys=new T({props:{code:"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",highlighted:`<span class="hljs-selector-id">#root</span> {
  <span class="hljs-attribute">max-width</span>: <span class="hljs-number">1280px</span>;
  <span class="hljs-attribute">margin</span>: <span class="hljs-number">0</span> auto;
  <span class="hljs-attribute">padding</span>: <span class="hljs-number">2rem</span>;
  <span class="hljs-attribute">text-align</span>: center;
}

<span class="hljs-selector-class">.language-container</span> {
  <span class="hljs-attribute">display</span>: flex;
  <span class="hljs-attribute">gap</span>: <span class="hljs-number">20px</span>;
}

<span class="hljs-selector-class">.textbox-container</span> {
  <span class="hljs-attribute">display</span>: flex;
  <span class="hljs-attribute">justify-content</span>: center;
  <span class="hljs-attribute">gap</span>: <span class="hljs-number">20px</span>;
  <span class="hljs-attribute">width</span>: <span class="hljs-number">800px</span>;
}

<span class="hljs-selector-class">.textbox-container</span>&gt;<span class="hljs-selector-tag">textarea</span>, <span class="hljs-selector-class">.language-selector</span> {
  <span class="hljs-attribute">width</span>: <span class="hljs-number">50%</span>;
}

<span class="hljs-selector-class">.language-selector</span>&gt;select {
  <span class="hljs-attribute">width</span>: <span class="hljs-number">150px</span>;
}

<span class="hljs-selector-class">.progress-container</span> {
  <span class="hljs-attribute">position</span>: relative;
  <span class="hljs-attribute">font-size</span>: <span class="hljs-number">14px</span>;
  <span class="hljs-attribute">color</span>: white;
  <span class="hljs-attribute">background-color</span>: <span class="hljs-number">#e9ecef</span>;
  <span class="hljs-attribute">border</span>: solid <span class="hljs-number">1px</span>;
  <span class="hljs-attribute">border-radius</span>: <span class="hljs-number">8px</span>;
  <span class="hljs-attribute">text-align</span>: left;
  <span class="hljs-attribute">overflow</span>: hidden;
}

<span class="hljs-selector-class">.progress-bar</span> {
  <span class="hljs-attribute">padding</span>: <span class="hljs-number">0</span> <span class="hljs-number">4px</span>;
  <span class="hljs-attribute">z-index</span>: <span class="hljs-number">0</span>;
  <span class="hljs-attribute">top</span>: <span class="hljs-number">0</span>;
  <span class="hljs-attribute">width</span>: <span class="hljs-number">1%</span>;
  <span class="hljs-attribute">height</span>: <span class="hljs-number">100%</span>;
  <span class="hljs-attribute">overflow</span>: hidden;
  <span class="hljs-attribute">background-color</span>: <span class="hljs-number">#007bff</span>;
  <span class="hljs-attribute">white-space</span>: nowrap;
}

<span class="hljs-selector-class">.progress-text</span> {
  <span class="hljs-attribute">z-index</span>: <span class="hljs-number">2</span>;
}

<span class="hljs-selector-class">.selector-container</span> {
  <span class="hljs-attribute">display</span>: flex;
  <span class="hljs-attribute">gap</span>: <span class="hljs-number">20px</span>;
}

<span class="hljs-selector-class">.progress-bars-container</span> {
  <span class="hljs-attribute">padding</span>: <span class="hljs-number">8px</span>;
  <span class="hljs-attribute">height</span>: <span class="hljs-number">140px</span>;
}

<span class="hljs-selector-class">.container</span> {
  <span class="hljs-attribute">margin</span>: <span class="hljs-number">25px</span>;
  <span class="hljs-attribute">display</span>: flex;
  <span class="hljs-attribute">flex-direction</span>: column;
  <span class="hljs-attribute">gap</span>: <span class="hljs-number">10px</span>;
}`,wrap:!1}}),Ts=new Gs({props:{title:"Step 4: Connecting everything together",local:"step-4-connecting-everything-together",headingTag:"h2"}}),us=new T({props:{code:"Y29uc3QlMjB0cmFuc2xhdGUlMjAlM0QlMjAoKSUyMCUzRCUzRSUyMCU3QiUwQSUyMCUyMHNldERpc2FibGVkKHRydWUpJTNCJTBBJTIwJTIwd29ya2VyLmN1cnJlbnQucG9zdE1lc3NhZ2UoJTdCJTBBJTIwJTIwJTIwJTIwdGV4dCUzQSUyMGlucHV0JTJDJTBBJTIwJTIwJTIwJTIwc3JjX2xhbmclM0ElMjBzb3VyY2VMYW5ndWFnZSUyQyUwQSUyMCUyMCUyMCUyMHRndF9sYW5nJTNBJTIwdGFyZ2V0TGFuZ3VhZ2UlMkMlMEElMjAlMjAlN0QpJTNCJTBBJTdE",highlighted:`<span class="hljs-keyword">const</span> <span class="hljs-title function_">translate</span> = (<span class="hljs-params"></span>) =&gt; {
  <span class="hljs-title function_">setDisabled</span>(<span class="hljs-literal">true</span>);
  worker.<span class="hljs-property">current</span>.<span class="hljs-title function_">postMessage</span>({
    <span class="hljs-attr">text</span>: input,
    <span class="hljs-attr">src_lang</span>: sourceLanguage,
    <span class="hljs-attr">tgt_lang</span>: targetLanguage,
  });
}`,wrap:!1}}),Cs=new T({props:{code:"JTJGJTJGJTIwTGlzdGVuJTIwZm9yJTIwbWVzc2FnZXMlMjBmcm9tJTIwdGhlJTIwbWFpbiUyMHRocmVhZCUwQXNlbGYuYWRkRXZlbnRMaXN0ZW5lcignbWVzc2FnZSclMkMlMjBhc3luYyUyMChldmVudCklMjAlM0QlM0UlMjAlN0IlMEElMjAlMjAlMkYlMkYlMjBSZXRyaWV2ZSUyMHRoZSUyMHRyYW5zbGF0aW9uJTIwcGlwZWxpbmUuJTIwV2hlbiUyMGNhbGxlZCUyMGZvciUyMHRoZSUyMGZpcnN0JTIwdGltZSUyQyUwQSUyMCUyMCUyRiUyRiUyMHRoaXMlMjB3aWxsJTIwbG9hZCUyMHRoZSUyMHBpcGVsaW5lJTIwYW5kJTIwc2F2ZSUyMGl0JTIwZm9yJTIwZnV0dXJlJTIwdXNlLiUwQSUyMCUyMGxldCUyMHRyYW5zbGF0b3IlMjAlM0QlMjBhd2FpdCUyME15VHJhbnNsYXRpb25QaXBlbGluZS5nZXRJbnN0YW5jZSh4JTIwJTNEJTNFJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTJGJTJGJTIwV2UlMjBhbHNvJTIwYWRkJTIwYSUyMHByb2dyZXNzJTIwY2FsbGJhY2slMjB0byUyMHRoZSUyMHBpcGVsaW5lJTIwc28lMjB0aGF0JTIwd2UlMjBjYW4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMkYlMkYlMjB0cmFjayUyMG1vZGVsJTIwbG9hZGluZy4lMEElMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnBvc3RNZXNzYWdlKHgpJTNCJTBBJTIwJTIwJTdEKSUzQiUwQSUwQSUyMCUyMCUyRiUyRiUyMEFjdHVhbGx5JTIwcGVyZm9ybSUyMHRoZSUyMHRyYW5zbGF0aW9uJTBBJTIwJTIwbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjB0cmFuc2xhdG9yKGV2ZW50LmRhdGEudGV4dCUyQyUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMHRndF9sYW5nJTNBJTIwZXZlbnQuZGF0YS50Z3RfbGFuZyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHNyY19sYW5nJTNBJTIwZXZlbnQuZGF0YS5zcmNfbGFuZyUyQyUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyRiUyRiUyMEFsbG93cyUyMGZvciUyMHBhcnRpYWwlMjBvdXRwdXQlMEElMjAlMjAlMjAlMjAlMjAlMjBjYWxsYmFja19mdW5jdGlvbiUzQSUyMHglMjAlM0QlM0UlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnBvc3RNZXNzYWdlKCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN0YXR1cyUzQSUyMCd1cGRhdGUnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0JTNBJTIwdHJhbnNsYXRvci50b2tlbml6ZXIuZGVjb2RlKHglNUIwJTVELm91dHB1dF90b2tlbl9pZHMlMkMlMjAlN0IlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNBJTIwdHJ1ZSUyMCU3RCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QpJTNCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTdEKSUzQiUwQSUwQSUyMCUyMCUyRiUyRiUyMFNlbmQlMjB0aGUlMjBvdXRwdXQlMjBiYWNrJTIwdG8lMjB0aGUlMjBtYWluJTIwdGhyZWFkJTBBJTIwJTIwc2VsZi5wb3N0TWVzc2FnZSglN0IlMEElMjAlMjAlMjAlMjAlMjAlMjBzdGF0dXMlM0ElMjAnY29tcGxldGUnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0JTNBJTIwb3V0cHV0JTJDJTBBJTIwJTIwJTdEKSUzQiUwQSU3RCklM0I=",highlighted:`<span class="hljs-comment">// Listen for messages from the main thread</span>
self.<span class="hljs-title function_">addEventListener</span>(<span class="hljs-string">&#x27;message&#x27;</span>, <span class="hljs-keyword">async</span> (event) =&gt; {
  <span class="hljs-comment">// Retrieve the translation pipeline. When called for the first time,</span>
  <span class="hljs-comment">// this will load the pipeline and save it for future use.</span>
  <span class="hljs-keyword">let</span> translator = <span class="hljs-keyword">await</span> <span class="hljs-title class_">MyTranslationPipeline</span>.<span class="hljs-title function_">getInstance</span>(<span class="hljs-function"><span class="hljs-params">x</span> =&gt;</span> {
      <span class="hljs-comment">// We also add a progress callback to the pipeline so that we can</span>
      <span class="hljs-comment">// track model loading.</span>
      self.<span class="hljs-title function_">postMessage</span>(x);
  });

  <span class="hljs-comment">// Actually perform the translation</span>
  <span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">translator</span>(event.<span class="hljs-property">data</span>.<span class="hljs-property">text</span>, {
      <span class="hljs-attr">tgt_lang</span>: event.<span class="hljs-property">data</span>.<span class="hljs-property">tgt_lang</span>,
      <span class="hljs-attr">src_lang</span>: event.<span class="hljs-property">data</span>.<span class="hljs-property">src_lang</span>,

      <span class="hljs-comment">// Allows for partial output</span>
      <span class="hljs-attr">callback_function</span>: <span class="hljs-function"><span class="hljs-params">x</span> =&gt;</span> {
          self.<span class="hljs-title function_">postMessage</span>({
              <span class="hljs-attr">status</span>: <span class="hljs-string">&#x27;update&#x27;</span>,
              <span class="hljs-attr">output</span>: translator.<span class="hljs-property">tokenizer</span>.<span class="hljs-title function_">decode</span>(x[<span class="hljs-number">0</span>].<span class="hljs-property">output_token_ids</span>, { <span class="hljs-attr">skip_special_tokens</span>: <span class="hljs-literal">true</span> })
          });
      }
  });

  <span class="hljs-comment">// Send the output back to the main thread</span>
  self.<span class="hljs-title function_">postMessage</span>({
      <span class="hljs-attr">status</span>: <span class="hljs-string">&#x27;complete&#x27;</span>,
      <span class="hljs-attr">output</span>: output,
  });
});`,wrap:!1}}),bs=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">const</span> <span class="hljs-title function_">onMessageReceived</span> = (<span class="hljs-params">e</span>) =&gt; {
  <span class="hljs-keyword">switch</span> (e.<span class="hljs-property">data</span>.<span class="hljs-property">status</span>) {
    <span class="hljs-keyword">case</span> <span class="hljs-string">&#x27;initiate&#x27;</span>:
      <span class="hljs-comment">// Model file start load: add a new progress item to the list.</span>
      <span class="hljs-title function_">setReady</span>(<span class="hljs-literal">false</span>);
      <span class="hljs-title function_">setProgressItems</span>(<span class="hljs-function"><span class="hljs-params">prev</span> =&gt;</span> [...prev, e.<span class="hljs-property">data</span>]);
      <span class="hljs-keyword">break</span>;

    <span class="hljs-keyword">case</span> <span class="hljs-string">&#x27;progress&#x27;</span>:
      <span class="hljs-comment">// Model file progress: update one of the progress items.</span>
      <span class="hljs-title function_">setProgressItems</span>(
        <span class="hljs-function"><span class="hljs-params">prev</span> =&gt;</span> prev.<span class="hljs-title function_">map</span>(<span class="hljs-function"><span class="hljs-params">item</span> =&gt;</span> {
          <span class="hljs-keyword">if</span> (item.<span class="hljs-property">file</span> === e.<span class="hljs-property">data</span>.<span class="hljs-property">file</span>) {
            <span class="hljs-keyword">return</span> { ...item, <span class="hljs-attr">progress</span>: e.<span class="hljs-property">data</span>.<span class="hljs-property">progress</span> }
          }
          <span class="hljs-keyword">return</span> item;
        })
      );
      <span class="hljs-keyword">break</span>;

    <span class="hljs-keyword">case</span> <span class="hljs-string">&#x27;done&#x27;</span>:
      <span class="hljs-comment">// Model file loaded: remove the progress item from the list.</span>
      <span class="hljs-title function_">setProgressItems</span>(
        <span class="hljs-function"><span class="hljs-params">prev</span> =&gt;</span> prev.<span class="hljs-title function_">filter</span>(<span class="hljs-function"><span class="hljs-params">item</span> =&gt;</span> item.<span class="hljs-property">file</span> !== e.<span class="hljs-property">data</span>.<span class="hljs-property">file</span>)
      );
      <span class="hljs-keyword">break</span>;

    <span class="hljs-keyword">case</span> <span class="hljs-string">&#x27;ready&#x27;</span>:
      <span class="hljs-comment">// Pipeline ready: the worker is ready to accept messages.</span>
      <span class="hljs-title function_">setReady</span>(<span class="hljs-literal">true</span>);
      <span class="hljs-keyword">break</span>;

    <span class="hljs-keyword">case</span> <span class="hljs-string">&#x27;update&#x27;</span>:
      <span class="hljs-comment">// Generation update: update the output text.</span>
      <span class="hljs-title function_">setOutput</span>(e.<span class="hljs-property">data</span>.<span class="hljs-property">output</span>);
      <span class="hljs-keyword">break</span>;

    <span class="hljs-keyword">case</span> <span class="hljs-string">&#x27;complete&#x27;</span>:
      <span class="hljs-comment">// Generation complete: re-enable the &quot;Translate&quot; button</span>
      <span class="hljs-title function_">setDisabled</span>(<span class="hljs-literal">false</span>);
      <span class="hljs-keyword">break</span>;
  }
};`,wrap:!1}}),fs=new Gs({props:{title:"(Optional) Step 5: Build and deploy",local:"optional-step-5-build-and-deploy",headingTag:"h2"}}),Qs=new nt({props:{source:"https://github.com/huggingface/transformers.js/blob/main/docs/source/tutorials/react.md"}}),{c(){y=p("meta"),I=e(),w=p("p"),Ss=e(),r(b.$$.fragment),Fs=e(),g=p("p"),g.textContent=ja,Ls=e(),f=p("p"),f.innerHTML=oa,_s=e(),B=p("p"),B.textContent=ha,Ds=e(),Z=p("ul"),Z.innerHTML=Ua,Ps=e(),r(E.$$.fragment),Ks=e(),N=p("ul"),N.innerHTML=Ja,qs=e(),r(Q.$$.fragment),Os=e(),A=p("p"),A.innerHTML=ya,sl=e(),r(G.$$.fragment),ll=e(),S=p("p"),S.innerHTML=Ta,al=e(),R=p("p"),R.textContent=da,tl=e(),r(W.$$.fragment),el=e(),k=p("p"),k.textContent=wa,nl=e(),r(v.$$.fragment),pl=e(),x=p("p"),x.innerHTML=ua,Ml=e(),r(z.$$.fragment),cl=e(),V=p("p"),V.innerHTML=ma,il=e(),r(Y.$$.fragment),rl=e(),X=p("p"),X.innerHTML=Ca,jl=e(),H=p("ol"),H.innerHTML=Ia,ol=e(),$=p("p"),$.innerHTML=ba,hl=e(),u=p("ol"),F=p("li"),Rs=p("p"),Rs.innerHTML=ga,sa=e(),r(L.$$.fragment),la=e(),_=p("li"),Ws=p("p"),Ws.innerHTML=fa,aa=e(),r(D.$$.fragment),Ul=e(),r(P.$$.fragment),Jl=e(),r(m.$$.fragment),yl=e(),K=p("p"),K.innerHTML=Ba,Tl=e(),ks=p("ol"),q=p("li"),vs=p("p"),vs.innerHTML=Za,ta=e(),r(O.$$.fragment),dl=e(),ss=p("ol"),ls=p("li"),xs=p("code"),xs.textContent=Ea,ea=lt(`: This component will display the progress for downloading each model file.
	`),r(as.$$.fragment),wl=e(),ts=p("p"),ts.innerHTML=Na,ul=e(),r(es.$$.fragment),ml=e(),ns=p("p"),ns.innerHTML=Qa,Cl=e(),r(ps.$$.fragment),Il=e(),Ms=p("p"),Ms.innerHTML=Aa,bl=e(),r(cs.$$.fragment),gl=e(),is=p("p"),is.innerHTML=Ga,fl=e(),rs=p("p"),rs.innerHTML=Sa,Bl=e(),C=p("ol"),js=p("li"),zs=p("p"),zs.innerHTML=Ra,na=e(),os=p("details"),Vs=p("summary"),Vs.textContent=Wa,pa=e(),r(hs.$$.fragment),Ma=e(),Us=p("li"),Ys=p("p"),Ys.innerHTML=ka,ca=e(),Js=p("details"),Xs=p("summary"),Xs.textContent=va,ia=e(),r(ys.$$.fragment),Zl=e(),r(Ts.$$.fragment),El=e(),ds=p("p"),ds.textContent=xa,Nl=e(),ws=p("p"),ws.innerHTML=za,Ql=e(),r(us.$$.fragment),Al=e(),ms=p("p"),ms.innerHTML=Va,Gl=e(),r(Cs.$$.fragment),Sl=e(),Is=p("p"),Is.innerHTML=Ya,Rl=e(),r(bs.$$.fragment),Wl=e(),gs=p("p"),gs.innerHTML=Xa,kl=e(),r(fs.$$.fragment),vl=e(),Bs=p("p"),Bs.innerHTML=Ha,xl=e(),Zs=p("p"),Zs.innerHTML=$a,zl=e(),Es=p("ol"),Es.innerHTML=Fa,Vl=e(),Ns=p("p"),Ns.innerHTML=La,Yl=e(),r(Qs.$$.fragment),Xl=e(),Hs=p("p"),this.h()},l(s){const l=at("svelte-u9bgzb",document.head);y=M(l,"META",{name:!0,content:!0}),l.forEach(a),I=n(s),w=M(s,"P",{}),d(w).forEach(a),Ss=n(s),j(b.$$.fragment,s),Fs=n(s),g=M(s,"P",{"data-svelte-h":!0}),c(g)!=="svelte-dpjqaw"&&(g.textContent=ja),Ls=n(s),f=M(s,"P",{"data-svelte-h":!0}),c(f)!=="svelte-1n9mzrq"&&(f.innerHTML=oa),_s=n(s),B=M(s,"P",{"data-svelte-h":!0}),c(B)!=="svelte-1tlxmzn"&&(B.textContent=ha),Ds=n(s),Z=M(s,"UL",{"data-svelte-h":!0}),c(Z)!=="svelte-nmlr4e"&&(Z.innerHTML=Ua),Ps=n(s),j(E.$$.fragment,s),Ks=n(s),N=M(s,"UL",{"data-svelte-h":!0}),c(N)!=="svelte-1qy4daj"&&(N.innerHTML=Ja),qs=n(s),j(Q.$$.fragment,s),Os=n(s),A=M(s,"P",{"data-svelte-h":!0}),c(A)!=="svelte-yun097"&&(A.innerHTML=ya),sl=n(s),j(G.$$.fragment,s),ll=n(s),S=M(s,"P",{"data-svelte-h":!0}),c(S)!=="svelte-jey2qt"&&(S.innerHTML=Ta),al=n(s),R=M(s,"P",{"data-svelte-h":!0}),c(R)!=="svelte-1uss4lu"&&(R.textContent=da),tl=n(s),j(W.$$.fragment,s),el=n(s),k=M(s,"P",{"data-svelte-h":!0}),c(k)!=="svelte-3f3wv"&&(k.textContent=wa),nl=n(s),j(v.$$.fragment,s),pl=n(s),x=M(s,"P",{"data-svelte-h":!0}),c(x)!=="svelte-uw3n4a"&&(x.innerHTML=ua),Ml=n(s),j(z.$$.fragment,s),cl=n(s),V=M(s,"P",{"data-svelte-h":!0}),c(V)!=="svelte-lqc2c5"&&(V.innerHTML=ma),il=n(s),j(Y.$$.fragment,s),rl=n(s),X=M(s,"P",{"data-svelte-h":!0}),c(X)!=="svelte-65henz"&&(X.innerHTML=Ca),jl=n(s),H=M(s,"OL",{"data-svelte-h":!0}),c(H)!=="svelte-10l42oh"&&(H.innerHTML=Ia),ol=n(s),$=M(s,"P",{"data-svelte-h":!0}),c($)!=="svelte-x351t5"&&($.innerHTML=ba),hl=n(s),u=M(s,"OL",{});var As=d(u);F=M(As,"LI",{});var $l=d(F);Rs=M($l,"P",{"data-svelte-h":!0}),c(Rs)!=="svelte-1pdf701"&&(Rs.innerHTML=ga),sa=n($l),j(L.$$.fragment,$l),$l.forEach(a),la=n(As),_=M(As,"LI",{});var Fl=d(_);Ws=M(Fl,"P",{"data-svelte-h":!0}),c(Ws)!=="svelte-s97xjw"&&(Ws.innerHTML=fa),aa=n(Fl),j(D.$$.fragment,Fl),Fl.forEach(a),As.forEach(a),Ul=n(s),j(P.$$.fragment,s),Jl=n(s),j(m.$$.fragment,s),yl=n(s),K=M(s,"P",{"data-svelte-h":!0}),c(K)!=="svelte-11kk027"&&(K.innerHTML=Ba),Tl=n(s),ks=M(s,"OL",{});var _a=d(ks);q=M(_a,"LI",{});var Ll=d(q);vs=M(Ll,"P",{"data-svelte-h":!0}),c(vs)!=="svelte-114uklx"&&(vs.innerHTML=Za),ta=n(Ll),j(O.$$.fragment,Ll),Ll.forEach(a),_a.forEach(a),dl=n(s),ss=M(s,"OL",{start:!0});var Da=d(ss);ls=M(Da,"LI",{});var _l=d(ls);xs=M(_l,"CODE",{"data-svelte-h":!0}),c(xs)!=="svelte-x5z4ps"&&(xs.textContent=Ea),ea=tt(_l,`: This component will display the progress for downloading each model file.
	`),j(as.$$.fragment,_l),_l.forEach(a),Da.forEach(a),wl=n(s),ts=M(s,"P",{"data-svelte-h":!0}),c(ts)!=="svelte-q4axcm"&&(ts.innerHTML=Na),ul=n(s),j(es.$$.fragment,s),ml=n(s),ns=M(s,"P",{"data-svelte-h":!0}),c(ns)!=="svelte-1c4l5r3"&&(ns.innerHTML=Qa),Cl=n(s),j(ps.$$.fragment,s),Il=n(s),Ms=M(s,"P",{"data-svelte-h":!0}),c(Ms)!=="svelte-12zt7ut"&&(Ms.innerHTML=Aa),bl=n(s),j(cs.$$.fragment,s),gl=n(s),is=M(s,"P",{"data-svelte-h":!0}),c(is)!=="svelte-pde8gh"&&(is.innerHTML=Ga),fl=n(s),rs=M(s,"P",{"data-svelte-h":!0}),c(rs)!=="svelte-1m2ra9t"&&(rs.innerHTML=Sa),Bl=n(s),C=M(s,"OL",{});var Dl=d(C);js=M(Dl,"LI",{});var Pl=d(js);zs=M(Pl,"P",{"data-svelte-h":!0}),c(zs)!=="svelte-1xd3pzq"&&(zs.innerHTML=Ra),na=n(Pl),os=M(Pl,"DETAILS",{});var Kl=d(os);Vs=M(Kl,"SUMMARY",{"data-svelte-h":!0}),c(Vs)!=="svelte-1hbuv8y"&&(Vs.textContent=Wa),pa=n(Kl),j(hs.$$.fragment,Kl),Kl.forEach(a),Pl.forEach(a),Ma=n(Dl),Us=M(Dl,"LI",{});var ql=d(Us);Ys=M(ql,"P",{"data-svelte-h":!0}),c(Ys)!=="svelte-1a8u5ov"&&(Ys.innerHTML=ka),ca=n(ql),Js=M(ql,"DETAILS",{});var Ol=d(Js);Xs=M(Ol,"SUMMARY",{"data-svelte-h":!0}),c(Xs)!=="svelte-1hbuv8y"&&(Xs.textContent=va),ia=n(Ol),j(ys.$$.fragment,Ol),Ol.forEach(a),ql.forEach(a),Dl.forEach(a),Zl=n(s),j(Ts.$$.fragment,s),El=n(s),ds=M(s,"P",{"data-svelte-h":!0}),c(ds)!=="svelte-1wkt7b9"&&(ds.textContent=xa),Nl=n(s),ws=M(s,"P",{"data-svelte-h":!0}),c(ws)!=="svelte-1ca719u"&&(ws.innerHTML=za),Ql=n(s),j(us.$$.fragment,s),Al=n(s),ms=M(s,"P",{"data-svelte-h":!0}),c(ms)!=="svelte-jduhe6"&&(ms.innerHTML=Va),Gl=n(s),j(Cs.$$.fragment,s),Sl=n(s),Is=M(s,"P",{"data-svelte-h":!0}),c(Is)!=="svelte-1ljeksu"&&(Is.innerHTML=Ya),Rl=n(s),j(bs.$$.fragment,s),Wl=n(s),gs=M(s,"P",{"data-svelte-h":!0}),c(gs)!=="svelte-2gywwo"&&(gs.innerHTML=Xa),kl=n(s),j(fs.$$.fragment,s),vl=n(s),Bs=M(s,"P",{"data-svelte-h":!0}),c(Bs)!=="svelte-10i26x6"&&(Bs.innerHTML=Ha),xl=n(s),Zs=M(s,"P",{"data-svelte-h":!0}),c(Zs)!=="svelte-1c1gg25"&&(Zs.innerHTML=$a),zl=n(s),Es=M(s,"OL",{"data-svelte-h":!0}),c(Es)!=="svelte-493ag0"&&(Es.innerHTML=Fa),Vl=n(s),Ns=M(s,"P",{"data-svelte-h":!0}),c(Ns)!=="svelte-181xlpv"&&(Ns.innerHTML=La),Yl=n(s),j(Qs.$$.fragment,s),Xl=n(s),Hs=M(s,"P",{}),d(Hs).forEach(a),this.h()},h(){ra(y,"name","hf:doc:metadata"),ra(y,"content",ct),ra(ss,"start","2")},m(s,l){i(document.head,y),t(s,I,l),t(s,w,l),t(s,Ss,l),o(b,s,l),t(s,Fs,l),t(s,g,l),t(s,Ls,l),t(s,f,l),t(s,_s,l),t(s,B,l),t(s,Ds,l),t(s,Z,l),t(s,Ps,l),o(E,s,l),t(s,Ks,l),t(s,N,l),t(s,qs,l),o(Q,s,l),t(s,Os,l),t(s,A,l),t(s,sl,l),o(G,s,l),t(s,ll,l),t(s,S,l),t(s,al,l),t(s,R,l),t(s,tl,l),o(W,s,l),t(s,el,l),t(s,k,l),t(s,nl,l),o(v,s,l),t(s,pl,l),t(s,x,l),t(s,Ml,l),o(z,s,l),t(s,cl,l),t(s,V,l),t(s,il,l),o(Y,s,l),t(s,rl,l),t(s,X,l),t(s,jl,l),t(s,H,l),t(s,ol,l),t(s,$,l),t(s,hl,l),t(s,u,l),i(u,F),i(F,Rs),i(F,sa),o(L,F,null),i(u,la),i(u,_),i(_,Ws),i(_,aa),o(D,_,null),t(s,Ul,l),o(P,s,l),t(s,Jl,l),o(m,s,l),t(s,yl,l),t(s,K,l),t(s,Tl,l),t(s,ks,l),i(ks,q),i(q,vs),i(q,ta),o(O,q,null),t(s,dl,l),t(s,ss,l),i(ss,ls),i(ls,xs),i(ls,ea),o(as,ls,null),t(s,wl,l),t(s,ts,l),t(s,ul,l),o(es,s,l),t(s,ml,l),t(s,ns,l),t(s,Cl,l),o(ps,s,l),t(s,Il,l),t(s,Ms,l),t(s,bl,l),o(cs,s,l),t(s,gl,l),t(s,is,l),t(s,fl,l),t(s,rs,l),t(s,Bl,l),t(s,C,l),i(C,js),i(js,zs),i(js,na),i(js,os),i(os,Vs),i(os,pa),o(hs,os,null),i(C,Ma),i(C,Us),i(Us,Ys),i(Us,ca),i(Us,Js),i(Js,Xs),i(Js,ia),o(ys,Js,null),t(s,Zl,l),o(Ts,s,l),t(s,El,l),t(s,ds,l),t(s,Nl,l),t(s,ws,l),t(s,Ql,l),o(us,s,l),t(s,Al,l),t(s,ms,l),t(s,Gl,l),o(Cs,s,l),t(s,Sl,l),t(s,Is,l),t(s,Rl,l),o(bs,s,l),t(s,Wl,l),t(s,gs,l),t(s,kl,l),o(fs,s,l),t(s,vl,l),t(s,Bs,l),t(s,xl,l),t(s,Zs,l),t(s,zl,l),t(s,Es,l),t(s,Vl,l),t(s,Ns,l),t(s,Yl,l),o(Qs,s,l),t(s,Xl,l),t(s,Hs,l),Hl=!0},p(s,[l]){const As={};l&2&&(As.$$scope={dirty:l,ctx:s}),m.$set(As)},i(s){Hl||(h(b.$$.fragment,s),h(E.$$.fragment,s),h(Q.$$.fragment,s),h(G.$$.fragment,s),h(W.$$.fragment,s),h(v.$$.fragment,s),h(z.$$.fragment,s),h(Y.$$.fragment,s),h(L.$$.fragment,s),h(D.$$.fragment,s),h(P.$$.fragment,s),h(m.$$.fragment,s),h(O.$$.fragment,s),h(as.$$.fragment,s),h(es.$$.fragment,s),h(ps.$$.fragment,s),h(cs.$$.fragment,s),h(hs.$$.fragment,s),h(ys.$$.fragment,s),h(Ts.$$.fragment,s),h(us.$$.fragment,s),h(Cs.$$.fragment,s),h(bs.$$.fragment,s),h(fs.$$.fragment,s),h(Qs.$$.fragment,s),Hl=!0)},o(s){U(b.$$.fragment,s),U(E.$$.fragment,s),U(Q.$$.fragment,s),U(G.$$.fragment,s),U(W.$$.fragment,s),U(v.$$.fragment,s),U(z.$$.fragment,s),U(Y.$$.fragment,s),U(L.$$.fragment,s),U(D.$$.fragment,s),U(P.$$.fragment,s),U(m.$$.fragment,s),U(O.$$.fragment,s),U(as.$$.fragment,s),U(es.$$.fragment,s),U(ps.$$.fragment,s),U(cs.$$.fragment,s),U(hs.$$.fragment,s),U(ys.$$.fragment,s),U(Ts.$$.fragment,s),U(us.$$.fragment,s),U(Cs.$$.fragment,s),U(bs.$$.fragment,s),U(fs.$$.fragment,s),U(Qs.$$.fragment,s),Hl=!1},d(s){s&&(a(I),a(w),a(Ss),a(Fs),a(g),a(Ls),a(f),a(_s),a(B),a(Ds),a(Z),a(Ps),a(Ks),a(N),a(qs),a(Os),a(A),a(sl),a(ll),a(S),a(al),a(R),a(tl),a(el),a(k),a(nl),a(pl),a(x),a(Ml),a(cl),a(V),a(il),a(rl),a(X),a(jl),a(H),a(ol),a($),a(hl),a(u),a(Ul),a(Jl),a(yl),a(K),a(Tl),a(ks),a(dl),a(ss),a(wl),a(ts),a(ul),a(ml),a(ns),a(Cl),a(Il),a(Ms),a(bl),a(gl),a(is),a(fl),a(rs),a(Bl),a(C),a(Zl),a(El),a(ds),a(Nl),a(ws),a(Ql),a(Al),a(ms),a(Gl),a(Sl),a(Is),a(Rl),a(Wl),a(gs),a(kl),a(vl),a(Bs),a(xl),a(Zs),a(zl),a(Es),a(Vl),a(Ns),a(Yl),a(Xl),a(Hs)),a(y),J(b,s),J(E,s),J(Q,s),J(G,s),J(W,s),J(v,s),J(z,s),J(Y,s),J(L),J(D),J(P,s),J(m,s),J(O),J(as),J(es,s),J(ps,s),J(cs,s),J(hs),J(ys),J(Ts,s),J(us,s),J(Cs,s),J(bs,s),J(fs,s),J(Qs,s)}}}const ct='{"title":"Building a React application","local":"building-a-react-application","sections":[{"title":"Prerequisites","local":"prerequisites","sections":[],"depth":2},{"title":"Step 1: Initialise the project","local":"step-1-initialise-the-project","sections":[],"depth":2},{"title":"Step 2: Install and configure Transformers.js","local":"step-2-install-and-configure-transformersjs","sections":[],"depth":2},{"title":"Step 3: Design the user interface","local":"step-3-design-the-user-interface","sections":[],"depth":2},{"title":"Step 4: Connecting everything together","local":"step-4-connecting-everything-together","sections":[],"depth":2},{"title":"(Optional) Step 5: Build and deploy","local":"optional-step-5-build-and-deploy","sections":[],"depth":2}],"depth":1}';function it($s){return Ka(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Jt extends Oa{constructor(y){super(),st(this,y,it,Mt,Pa,{})}}export{Jt as component};
