import{s as Ye,f as Re,n as Ee,o as We}from"../chunks/scheduler.f6b352c8.js";import{S as Fe,i as Ae,g as i,s as n,r as h,A as Qe,h as p,f as e,c as a,j as zs,u,x as o,k as Hs,y as Ps,a as l,v as r,d as c,t as M,w as y}from"../chunks/index.7f38e934.js";import{C as w}from"../chunks/CodeBlock.2a338b68.js";import{H as Os}from"../chunks/Heading.333929c4.js";import{E as Ve}from"../chunks/EditOnGithub.c3245a01.js";function Le(Ds){let j,Ct,kt,vt,d,xt,T,Ks,Xt,f,te="This course is framework-agnostic because we want to <strong>focus on the concepts of AI agents and avoid getting bogged down in the specifics of a particular framework</strong>.",qt,b,se="Also, we want students to be able to use the concepts they learn in this course in their own projects, using any framework they like.",Zt,J,ee="Therefore, for this Unit 1, we will use a dummy agent library and a simple serverless API to access our LLM engine.",Nt,g,le="You probably wouldn’t use these in production, but they will serve as a good <strong>starting point for understanding how agents work</strong>.",Yt,U,ne="After this section, you’ll be ready to <strong>create a simple Agent</strong> using <code>smolagents</code>",Rt,B,ae="And in the following Units we will also use other AI Agent libraries like <code>LangGraph</code>, <code>LangChain</code>, and <code>LlamaIndex</code>.",Et,_,ie="To keep things simple we will use a simple Python function as a Tool and Agent.",Wt,I,pe="We will use built-in Python packages like <code>datetime</code> and <code>os</code> so that you can try it out in any environment.",Ft,$,oe='You can follow the process <a href="https://huggingface.co/agents-course/notebooks/blob/main/dummy_agent_library.ipynb" rel="nofollow">in this notebook</a> and <strong>run the code yourself</strong>.',At,k,Qt,G,he="In the Hugging Face ecosystem, there is a convenient feature called Serverless API that allows you to easily run inference on many models. There’s no installation or deployment required.",Vt,C,Lt,v,Ht,x,ue="output:",St,X,zt,q,re="As seen in the LLM section, if we just do decoding, <strong>the model will only stop when it predicts an EOS token</strong>, and this does not happen here because this is a conversational (chat) model and <strong>we didn’t apply the chat template it expects</strong>.",Pt,Z,ce='If we now add the special tokens related to the <a href="https://huggingface.co/meta-llama/Llama-3.2-3B-Instruct">Llama-3.2-3B-Instruct model</a> that we’re using, the behavior changes and it now produces the expected EOS.',Ot,N,Dt,Y,Me="output:",Kt,R,ts,E,ye="Using the “chat” method is a much more convenient and reliable way to apply chat templates:",ss,W,es,F,we="output:",ls,A,ns,Q,je="The chat method is the RECOMMENDED method to use in order to ensure a smooth transition between models, but since this notebook is only educational, we will keep using the “text_generation” method to understand the details.",as,V,is,L,me="In the previous sections, we saw that the core of an agent library is to append information in the system prompt.",ps,H,de="This system prompt is a bit more complex than the one we saw earlier, but it already contains:",os,S,Te="<li><strong>Information about the tools</strong></li> <li><strong>Cycle instructions</strong> (Thought → Action → Observation)</li>",hs,z,us,P,fe="Since we are running the “text_generation” method, we need to apply the prompt manually:",rs,O,cs,D,be="We can also do it like this, which is what happens inside the <code>chat</code> method :",Ms,K,ys,tt,Je="The prompt now is :",ws,st,js,et,ge="Let’s decode!",ms,lt,ds,nt,Ue="output:",Ts,at,fs,it,Be=`{
“action”: “get_weather”,
“action”: {“location”: “London”}
}`,bs,pt,Js,ot,_e="Do you see the issue?",gs,m,$t,Ie=`The answer was hallucinated by the model. We need to stop to actually execute the function!
Let’s now stop on “Observation” so that we don’t hallucinate the actual function response`,Ss,ht,Us,ut,$e="print(output)",Bs,rt,_s,ct,ke="Action:",Is,Mt,$s,yt,Ge=`Thought: I will check the weather in London.
Observation:`,ks,wt,Ce=`Much Better!
Let’s now create a dummy get weather function.  In a real situation, you would likely call an API.`,Gs,jt,Cs,mt,ve="output:",vs,dt,xs,Tt,xe="Let’s concatenate the base prompt, the completion until function execution and the result of the function as an Observation and resume generation.",Xs,ft,qs,bt,Xe="Here is the new prompt:",Zs,Jt,Ns,gt,qe="Output:",Ys,Ut,Rs,Es,Ws,Bt,Ze="We learned how we can create Agents from scratch using Python code, and we <strong>saw just how tedious that process can be</strong>. Fortunately, many Agent libraries simplify this work by handling much of the heavy lifting for you.",Fs,_t,Ne="Now, we’re ready <strong>to create our first real Agent</strong> using the <code>smolagents</code> library.",As,It,Qs,Gt,Vs;return d=new Os({props:{title:"Dummy Agent Library",local:"dummy-agent-library",headingTag:"h1"}}),k=new Os({props:{title:"Serverless API",local:"serverless-api",headingTag:"h2"}}),C=new w({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwSW5mZXJlbmNlQ2xpZW50JTBBJTBBJTIzJTIzJTIwWW91JTIwbmVlZCUyMGElMjB0b2tlbiUyMGZyb20lMjBodHRwcyUzQSUyRiUyRmhmLmNvJTJGc2V0dGluZ3MlMkZ0b2tlbnMuJTIwSWYlMjB5b3UlMjBydW4lMjB0aGlzJTIwb24lMjBHb29nbGUlMjBDb2xhYiUyQyUyMHlvdSUyMGNhbiUyMHNldCUyMGl0JTIwdXAlMjBpbiUyMHRoZSUyMCUyMnNldHRpbmdzJTIyJTIwdGFiJTIwdW5kZXIlMjAlMjJzZWNyZXRzJTIyLiUyME1ha2UlMjBzdXJlJTIwdG8lMjBjYWxsJTIwaXQlMjAlMjJIRl9UT0tFTiUyMiUwQW9zLmVudmlyb24lNUIlMjJIRl9UT0tFTiUyMiU1RCUzRCUyMmhmX3h4eHh4eHh4eHh4eHh4JTIyJTBBJTBBY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCUyMm1ldGEtbGxhbWElMkZMbGFtYS0zLjItM0ItSW5zdHJ1Y3QlMjIp",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

<span class="hljs-comment">## You need a token from https://hf.co/settings/tokens. If you run this on Google Colab, you can set it up in the &quot;settings&quot; tab under &quot;secrets&quot;. Make sure to call it &quot;HF_TOKEN&quot;</span>
os.environ[<span class="hljs-string">&quot;HF_TOKEN&quot;</span>]=<span class="hljs-string">&quot;hf_xxxxxxxxxxxxxx&quot;</span>

client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Llama-3.2-3B-Instruct&quot;</span>)`,wrap:!1}}),v=new w({props:{code:"b3V0cHV0JTIwJTNEJTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMEElMjAlMjAlMjAlMjAlMjJUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMiUyQyUwQSUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNEMTAwJTJDJTBBKSUwQSUwQXByaW50KG91dHB1dCk=",highlighted:`output = client.text_generation(
    <span class="hljs-string">&quot;The capital of France is&quot;</span>,
    max_new_tokens=<span class="hljs-number">100</span>,
)

<span class="hljs-built_in">print</span>(output)`,wrap:!1}}),X=new w({props:{code:"UGFyaXMuJTIwVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4lMjBUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLiUyMFRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwUGFyaXMuJTIwVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4lMjBUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLiUyMFRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwUGFyaXMuJTIwVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4lMjBUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLiUyMFRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwUGFyaXMuJTIwVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4lMjBUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLiUyMFRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwUGFyaXMuJTIwVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4lMjBUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLg==",highlighted:'Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris.',wrap:!1}}),N=new w({props:{code:"cHJvbXB0JTNEJTIyJTIyJTIyJTNDJTdDYmVnaW5fb2ZfdGV4dCU3QyUzRSUzQyU3Q3N0YXJ0X2hlYWRlcl9pZCU3QyUzRXVzZXIlM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNFJTBBVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlM0MlN0Nlb3RfaWQlN0MlM0UlM0MlN0NzdGFydF9oZWFkZXJfaWQlN0MlM0Vhc3Npc3RhbnQlM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNFJTIyJTIyJTIyJTBBb3V0cHV0JTIwJTNEJTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDEwMCUyQyUwQSklMEElMEFwcmludChvdXRwdXQp",highlighted:`prompt=<span class="hljs-string">&quot;&quot;&quot;&lt;|begin_of_text|&gt;&lt;|start_header_id|&gt;user&lt;|end_header_id|&gt;
The capital of France is&lt;|eot_id|&gt;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;&quot;&quot;&quot;</span>
output = client.text_generation(
    prompt,
    max_new_tokens=<span class="hljs-number">100</span>,
)

<span class="hljs-built_in">print</span>(output)`,wrap:!1}}),R=new w({props:{code:"VGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4=",highlighted:'The capital of France <span class="hljs-keyword">is</span> Paris.',wrap:!1}}),W=new w({props:{code:"b3V0cHV0JTIwJTNEJTIwY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBzdHJlYW0lM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0QxMDI0JTJDJTBBKQ==",highlighted:`output = client.chat.completions.create(
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;The capital of France is&quot;</span>},
    ],
    stream=<span class="hljs-literal">False</span>,
    max_tokens=<span class="hljs-number">1024</span>,
)`,wrap:!1}}),A=new w({props:{code:"UGFyaXMu",highlighted:"Paris.",wrap:!1}}),V=new Os({props:{title:"Dummy Agent",local:"dummy-agent",headingTag:"h2"}}),z=new w({props:{code:"JTBBJTBBJTBBJTBBJTBBJTBBJTBBJTBBKHRoaXMlMjBUaG91Z2h0JTJGQWN0aW9uJTJGT2JzZXJ2YXRpb24lMjBjYW4lMjByZXBlYXQlMjBOJTIwdGltZXMlMkMlMjB5b3UlMjBzaG91bGQlMjB0YWtlJTIwc2V2ZXJhbCUyMHN0ZXBzJTIwd2hlbiUyMG5lZWRlZC4lMjBUaGUlMjAlMjRKU09OX0JMT0IlMjBtdXN0JTIwYmUlMjBmb3JtYXR0ZWQlMjBhcyUyMG1hcmtkb3duJTIwYW5kJTIwb25seSUyMHVzZSUyMGElMjBTSU5HTEUlMjBhY3Rpb24lMjBhdCUyMGElMjB0aW1lLiklMEElMEElMEE=",highlighted:`Answer the following questions as best you can. You have access to the following tools:

get_weather: Get the current weather in a given location

The way you <span class="hljs-keyword">use</span> the tools is by specifying a json blob.
Specifically, <span class="hljs-keyword">this</span> json should have an \`action\` key (<span class="hljs-keyword">with</span> the name of the tool to <span class="hljs-keyword">use</span>) <span class="hljs-keyword">and</span> an \`action_input\` key (<span class="hljs-keyword">with</span> the <span class="hljs-keyword">input</span> to the tool going here).

The only values that should be in the <span class="hljs-string">&quot;action&quot;</span> field are:
get_weather: Get the current weather in a given location, args: {<span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}}
example <span class="hljs-keyword">use</span> : 

{{
  <span class="hljs-string">&quot;action&quot;</span>: <span class="hljs-string">&quot;get_weather&quot;</span>,
  <span class="hljs-string">&quot;action_input&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;New York&quot;</span>}
}}

ALWAYS <span class="hljs-keyword">use</span> the following format:

Question: the <span class="hljs-keyword">input</span> question you must answer
Thought: you should <span class="hljs-keyword">always</span> think about one action to take. Only one action at a <span class="hljs-keyword">time</span> in <span class="hljs-keyword">this</span> format:
Action:

$JSON_BLOB (<span class="hljs-keyword">inside</span> markdown <span class="hljs-keyword">cell</span>)

Observation: the result of the action. This Observation is <span class="hljs-keyword">unique</span>, complete, <span class="hljs-keyword">and</span> the source of truth.
... (<span class="hljs-keyword">this</span> Thought/Action/Observation can <span class="hljs-keyword">repeat</span> N times, you should take several steps when needed. The $JSON_BLOB must be formatted as markdown <span class="hljs-keyword">and</span> only <span class="hljs-keyword">use</span> a SINGLE action at a <span class="hljs-keyword">time</span>.)

You must <span class="hljs-keyword">always</span> <span class="hljs-keyword">end</span> your <span class="hljs-keyword">output</span> <span class="hljs-keyword">with</span> the following format:

Thought: I now know the <span class="hljs-keyword">final</span> answer
Final Answer: the <span class="hljs-keyword">final</span> answer to the original <span class="hljs-keyword">input</span> question

Now <span class="hljs-keyword">begin</span>! Reminder to ALWAYS <span class="hljs-keyword">use</span> the exact characters \`Final Answer:\` when you provide a definitive answer.`,wrap:!1}}),O=new w({props:{code:"cHJvbXB0JTNEZiUyMiUyMiUyMiUzQyU3Q2JlZ2luX29mX3RleHQlN0MlM0UlM0MlN0NzdGFydF9oZWFkZXJfaWQlN0MlM0VzeXN0ZW0lM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNFJTBBJTdCU1lTVEVNX1BST01QVCU3RCUwQSUzQyU3Q2VvdF9pZCU3QyUzRSUzQyU3Q3N0YXJ0X2hlYWRlcl9pZCU3QyUzRXVzZXIlM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNFJTBBV2hhdCdzJTIwdGhlJTIwd2VhdGhlciUyMGluJTIwTG9uZG9uJTIwJTNGJTBBJTNDJTdDZW90X2lkJTdDJTNFJTNDJTdDc3RhcnRfaGVhZGVyX2lkJTdDJTNFYXNzaXN0YW50JTNDJTdDZW5kX2hlYWRlcl9pZCU3QyUzRSUwQSUyMiUyMiUyMg==",highlighted:`<span class="hljs-attr">prompt</span>=f<span class="hljs-string">&quot;&quot;&quot;&lt;|begin_of_text|&gt;&lt;|start_header_id|&gt;system&lt;|end_header_id|&gt;
{SYSTEM_PROMPT}
&lt;|eot_id|&gt;&lt;|start_header_id|&gt;user&lt;|end_header_id|&gt;
What&#x27;s the weather in London ?
&lt;|eot_id|&gt;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;
&quot;&quot;&quot;</span>`,wrap:!1}}),K=new w({props:{code:"bWVzc2FnZXMlM0QlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMFNZU1RFTV9QUk9NUFQlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0J3MlMjB0aGUlMjB3ZWF0aGVyJTIwaW4lMjBMb25kb24lMjAlM0YlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlNUQlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1ldGEtbGxhbWElMkZMbGFtYS0zLjItM0ItSW5zdHJ1Y3QlMjIpJTBBJTBBdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSk=",highlighted:`messages=[
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: SYSTEM_PROMPT},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the weather in London ?&quot;</span>},
    ]
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-3.2-3B-Instruct&quot;</span>)

tokenizer.apply_chat_template(messages, <span class="hljs-keyword">tokenize</span>=<span class="hljs-keyword">False</span>,add_generation_prompt=<span class="hljs-keyword">True</span>)`,wrap:!1}}),st=new w({props:{code:"JTBBJTBBJTBBJTBBJTBBJTBBJTBBJTBBKHRoaXMlMjBUaG91Z2h0JTJGQWN0aW9uJTJGT2JzZXJ2YXRpb24lMjBjYW4lMjByZXBlYXQlMjBOJTIwdGltZXMlMkMlMjB5b3UlMjBzaG91bGQlMjB0YWtlJTIwc2V2ZXJhbCUyMHN0ZXBzJTIwd2hlbiUyMG5lZWRlZC4lMjBUaGUlMjAlMjRKU09OX0JMT0IlMjBtdXN0JTIwYmUlMjBmb3JtYXR0ZWQlMjBhcyUyMG1hcmtkb3duJTIwYW5kJTIwb25seSUyMHVzZSUyMGElMjBTSU5HTEUlMjBhY3Rpb24lMjBhdCUyMGElMjB0aW1lLiklMEElMEElMEE=",highlighted:`&lt;|<span class="hljs-type">begin_of_text</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;system</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;
Answer</span> the following questions <span class="hljs-built_in">as</span> best you can. You have access to the following tools:

get_weather: Get the current weather <span class="hljs-built_in">in</span> a given location

The way you use the tools is <span class="hljs-built_in">by</span> specifying a json blob.
Specifically, this json should have an \`action\` key (<span class="hljs-built_in">with</span> the name of the tool to use) and a \`action_input\` key (<span class="hljs-built_in">with</span> the input to the tool going here).

The only values that should be <span class="hljs-built_in">in</span> the <span class="hljs-string">&quot;action&quot;</span> <span class="hljs-built_in">field</span> are:
get_weather: Get the current weather <span class="hljs-built_in">in</span> a given location, args: {<span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}}
example use : 

{{
  <span class="hljs-string">&quot;action&quot;</span>: <span class="hljs-string">&quot;get_weather&quot;</span>,
  <span class="hljs-string">&quot;action_input&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;New York&quot;</span>}
}}

ALWAYS use the following format:

Question: the input question you must answer
Thought: you should always think about one action to take. Only one action <span class="hljs-built_in">at</span> a <span class="hljs-built_in">time</span> <span class="hljs-built_in">in</span> this format:
Action:

$JSON_BLOB (inside markdown cell)

Observation: the result of the action. This Observation is unique, complete, and the source of truth.
... (this Thought/Action/Observation can <span class="hljs-built_in">repeat</span> N times, you should take several steps when needed. The $JSON_BLOB must be formatted <span class="hljs-built_in">as</span> markdown and only use a SINGLE action <span class="hljs-built_in">at</span> a <span class="hljs-built_in">time</span>.)

You must always <span class="hljs-keyword">end</span> your output <span class="hljs-built_in">with</span> the following format:

Thought: I now know the final answer
Final Answer: the final answer to the original input question

Now begin! Reminder to ALWAYS use the <span class="hljs-built_in">exact</span> characters \`Final Answer:\` when you provide a definitive answer. 
&lt;|<span class="hljs-type">eot_id</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;user</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;
What</span>&#x27;s the weather <span class="hljs-built_in">in</span> London ?
&lt;|<span class="hljs-type">eot_id</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;assistant</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;</span>`,wrap:!1}}),lt=new w({props:{code:"b3V0cHV0JTIwJTNEJTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDIwMCUyQyUwQSklMEElMEFwcmludChvdXRwdXQp",highlighted:`output = client.text_generation(
    prompt,
    max_new_tokens=<span class="hljs-number">200</span>,
)

<span class="hljs-built_in">print</span>(output)`,wrap:!1}}),at=new w({props:{code:"QWN0aW9uJTNB",highlighted:'<span class="hljs-symbol">Action:</span>',wrap:!1}}),pt=new w({props:{code:"VGhvdWdodCUzQSUyMEklMjB3aWxsJTIwY2hlY2slMjB0aGUlMjB3ZWF0aGVyJTIwaW4lMjBMb25kb24uJTBBT2JzZXJ2YXRpb24lM0ElMjBUaGUlMjBjdXJyZW50JTIwd2VhdGhlciUyMGluJTIwTG9uZG9uJTIwaXMlMjBtb3N0bHklMjBjbG91ZHklMjB3aXRoJTIwYSUyMGhpZ2glMjBvZiUyMDEyJUMyJUIwQyUyMGFuZCUyMGElMjBsb3clMjBvZiUyMDglQzIlQjBDLg==",highlighted:`Thought: I will<span class="hljs-built_in"> check </span>the weather in London.
Observation: The current weather in London is mostly cloudy with a high of 12°C<span class="hljs-built_in"> and </span>a low of 8°C.`,wrap:!1}}),ht=new w({props:{code:"b3V0cHV0JTIwJTNEJTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDIwMCUyQyUwQSUyMCUyMCUyMCUyMHN0b3AlM0QlNUIlMjJPYnNlcnZhdGlvbiUzQSUyMiU1RCUyMCUyMyUyMExldCdzJTIwc3RvcCUyMGJlZm9yZSUyMGFueSUyMGFjdHVhbCUyMGZ1bmN0aW9uJTIwaXMlMjBjYWxsZWQlMEEp",highlighted:`output = client.text_generation(
    prompt,
    max_new_tokens=<span class="hljs-number">200</span>,
    stop=[<span class="hljs-string">&quot;Observation:&quot;</span>] <span class="hljs-comment"># Let&#x27;s stop before any actual function is called</span>
)`,wrap:!1}}),rt=new w({props:{code:"b3V0cHV0JTNB",highlighted:'<span class="hljs-symbol">output:</span>',wrap:!1}}),Mt=new w({props:{code:"JTdCJTBBJTIwJTIwJTIyYWN0aW9uJTIyJTNBJTIwJTIyZ2V0X3dlYXRoZXIlMjIlMkMlMEElMjAlMjAlMjJhY3Rpb24lMjIlM0ElMjAlN0IlMjJsb2NhdGlvbiUyMiUzQSUyMCUyMkxvbmRvbiUyMiU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;action&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;get_weather&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;action&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;location&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;London&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),jt=new w({props:{code:"JTIzRHVtbXklMjBmdW5jdGlvbiUwQWRlZiUyMGdldF93ZWF0aGVyKGxvY2F0aW9uKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGYlMjJ0aGUlMjB3ZWF0aGVyJTIwaW4lMjAlN0Jsb2NhdGlvbiU3RCUyMGlzJTIwc3VubnklMjB3aXRoJTIwbG93JTIwdGVtcGVyYXR1cmVzLiUyMCU1Q24lMjIlMEElMEFnZXRfd2VhdGhlcignTG9uZG9uJyk=",highlighted:`<span class="hljs-comment">#Dummy function</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather</span>(<span class="hljs-params">location</span>):
    <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;the weather in <span class="hljs-subst">{location}</span> is sunny with low temperatures. \\n&quot;</span>

get_weather(<span class="hljs-string">&#x27;London&#x27;</span>)`,wrap:!1}}),dt=new w({props:{code:"J3RoZSUyMHdlYXRoZXIlMjBpbiUyMExvbmRvbiUyMGlzJTIwc3VubnklMjB3aXRoJTIwbG93JTIwdGVtcGVyYXR1cmVzLiUyMCU1Q24n",highlighted:'<span class="hljs-symbol">&#x27;the</span> weather <span class="hljs-keyword">in</span> London <span class="hljs-keyword">is</span> sunny <span class="hljs-keyword">with</span> low temperatures. \\n&#x27;',wrap:!1}}),ft=new w({props:{code:"bmV3X3Byb21wdCUzRHByb21wdCUyQm91dHB1dCUyQmdldF93ZWF0aGVyKCdMb25kb24nKSUwQWZpbmFsX291dHB1dCUyMCUzRCUyMGNsaWVudC50ZXh0X2dlbmVyYXRpb24oJTBBJTIwJTIwJTIwJTIwbmV3X3Byb21wdCUyQyUwQSUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNEMjAwJTJDJTBBKSUwQSUwQXByaW50KGZpbmFsX291dHB1dCk=",highlighted:`new_prompt=prompt+output+get_weather(<span class="hljs-string">&#x27;London&#x27;</span>)
final_output = client.text_generation(
    new_prompt,
    max_new_tokens=<span class="hljs-number">200</span>,
)

<span class="hljs-built_in">print</span>(final_output)`,wrap:!1}}),Jt=new w({props:{code:"JTBBJTBBJTBBJTBBJTBBJTBBJTBBJTBBKHRoaXMlMjBUaG91Z2h0JTJGQWN0aW9uJTJGT2JzZXJ2YXRpb24lMjBjYW4lMjByZXBlYXQlMjBOJTIwdGltZXMlMkMlMjB5b3UlMjBzaG91bGQlMjB0YWtlJTIwc2V2ZXJhbCUyMHN0ZXBzJTIwd2hlbiUyMG5lZWRlZC4lMjBUaGUlMjAlMjRKU09OX0JMT0IlMjBtdXN0JTIwYmUlMjBmb3JtYXR0ZWQlMjBhcyUyMG1hcmtkb3duJTIwYW5kJTIwb25seSUyMHVzZSUyMGElMjBTSU5HTEUlMjBhY3Rpb24lMjBhdCUyMGElMjB0aW1lLiklMEElMEElMEElMEE=",highlighted:`&lt;|<span class="hljs-type">begin_of_text</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;system</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;
    Answer</span> the following questions <span class="hljs-built_in">as</span> best you can. You have access to the following tools:

get_weather: Get the current weather <span class="hljs-built_in">in</span> a given location

The way you use the tools is <span class="hljs-built_in">by</span> specifying a json blob.
Specifically, this json should have a \`action\` key (<span class="hljs-built_in">with</span> the name of the tool to use) and a \`action_input\` key (<span class="hljs-built_in">with</span> the input to the tool going here).

The only values that should be <span class="hljs-built_in">in</span> the <span class="hljs-string">&quot;action&quot;</span> <span class="hljs-built_in">field</span> are:
get_weather: Get the current weather <span class="hljs-built_in">in</span> a given location, args: {<span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}}
example use : 

{{
  <span class="hljs-string">&quot;action&quot;</span>: <span class="hljs-string">&quot;get_weather&quot;</span>,
  <span class="hljs-string">&quot;action_input&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;New York&quot;</span>}
}}

ALWAYS use the following format:

Question: the input question you must answer
Thought: you should always think about one action to take. Only one action <span class="hljs-built_in">at</span> a <span class="hljs-built_in">time</span> <span class="hljs-built_in">in</span> this format:
Action:

$JSON_BLOB (inside markdown cell)

Observation: the result of the action. This Observation is unique, complete, and the source of truth.
... (this Thought/Action/Observation can <span class="hljs-built_in">repeat</span> N times, you should take several steps when needed. The $JSON_BLOB must be formatted <span class="hljs-built_in">as</span> markdown and only use a SINGLE action <span class="hljs-built_in">at</span> a <span class="hljs-built_in">time</span>.)

You must always <span class="hljs-keyword">end</span> your output <span class="hljs-built_in">with</span> the following format:

Thought: I now know the final answer
Final Answer: the final answer to the original input question

Now begin! Reminder to ALWAYS use the <span class="hljs-built_in">exact</span> characters \`Final Answer:\` when you provide a definitive answer. 
&lt;|<span class="hljs-type">eot_id</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;user</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;
What</span>&#x27;s the weather <span class="hljs-built_in">in</span> London ?
&lt;|<span class="hljs-type">eot_id</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;assistant</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;

Action</span>:
\`\`\`
{
  <span class="hljs-string">&quot;action&quot;</span>: <span class="hljs-string">&quot;get_weather&quot;</span>,
  <span class="hljs-string">&quot;action&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>: <span class="hljs-string">&quot;London&quot;</span>}
}
\`\`\`
Thought: I will check the weather <span class="hljs-built_in">in</span> London.
Observation:the weather <span class="hljs-built_in">in</span> London is sunny <span class="hljs-built_in">with</span> low temperatures. `,wrap:!1}}),Ut=new w({props:{code:"RmluYWwlMjBBbnN3ZXIlM0ElMjBUaGUlMjB3ZWF0aGVyJTIwaW4lMjBMb25kb24lMjBpcyUyMHN1bm55JTIwd2l0aCUyMGxvdyUyMHRlbXBlcmF0dXJlcy4=",highlighted:'<span class="hljs-keyword">Final</span> Answer: The weather <span class="hljs-keyword">in</span> London <span class="hljs-keyword">is</span> sunny <span class="hljs-keyword">with</span> low temperatures.',wrap:!1}}),It=new Ve({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit1/dummy-agent-library.mdx"}}),{c(){j=i("meta"),Ct=n(),kt=i("p"),vt=n(),h(d.$$.fragment),xt=n(),T=i("img"),Xt=n(),f=i("p"),f.innerHTML=te,qt=n(),b=i("p"),b.textContent=se,Zt=n(),J=i("p"),J.textContent=ee,Nt=n(),g=i("p"),g.innerHTML=le,Yt=n(),U=i("p"),U.innerHTML=ne,Rt=n(),B=i("p"),B.innerHTML=ae,Et=n(),_=i("p"),_.textContent=ie,Wt=n(),I=i("p"),I.innerHTML=pe,Ft=n(),$=i("p"),$.innerHTML=oe,At=n(),h(k.$$.fragment),Qt=n(),G=i("p"),G.textContent=he,Vt=n(),h(C.$$.fragment),Lt=n(),h(v.$$.fragment),Ht=n(),x=i("p"),x.textContent=ue,St=n(),h(X.$$.fragment),zt=n(),q=i("p"),q.innerHTML=re,Pt=n(),Z=i("p"),Z.innerHTML=ce,Ot=n(),h(N.$$.fragment),Dt=n(),Y=i("p"),Y.textContent=Me,Kt=n(),h(R.$$.fragment),ts=n(),E=i("p"),E.textContent=ye,ss=n(),h(W.$$.fragment),es=n(),F=i("p"),F.textContent=we,ls=n(),h(A.$$.fragment),ns=n(),Q=i("p"),Q.textContent=je,as=n(),h(V.$$.fragment),is=n(),L=i("p"),L.textContent=me,ps=n(),H=i("p"),H.textContent=de,os=n(),S=i("ol"),S.innerHTML=Te,hs=n(),h(z.$$.fragment),us=n(),P=i("p"),P.textContent=fe,rs=n(),h(O.$$.fragment),cs=n(),D=i("p"),D.innerHTML=be,Ms=n(),h(K.$$.fragment),ys=n(),tt=i("p"),tt.textContent=Je,ws=n(),h(st.$$.fragment),js=n(),et=i("p"),et.textContent=ge,ms=n(),h(lt.$$.fragment),ds=n(),nt=i("p"),nt.textContent=Ue,Ts=n(),h(at.$$.fragment),fs=n(),it=i("p"),it.textContent=Be,bs=n(),h(pt.$$.fragment),Js=n(),ot=i("p"),ot.textContent=_e,gs=n(),m=i("blockquote"),$t=i("p"),$t.textContent=Ie,Ss=n(),h(ht.$$.fragment),Us=n(),ut=i("p"),ut.textContent=$e,Bs=n(),h(rt.$$.fragment),_s=n(),ct=i("p"),ct.textContent=ke,Is=n(),h(Mt.$$.fragment),$s=n(),yt=i("p"),yt.textContent=Ge,ks=n(),wt=i("p"),wt.textContent=Ce,Gs=n(),h(jt.$$.fragment),Cs=n(),mt=i("p"),mt.textContent=ve,vs=n(),h(dt.$$.fragment),xs=n(),Tt=i("p"),Tt.textContent=xe,Xs=n(),h(ft.$$.fragment),qs=n(),bt=i("p"),bt.textContent=Xe,Zs=n(),h(Jt.$$.fragment),Ns=n(),gt=i("p"),gt.textContent=qe,Ys=n(),h(Ut.$$.fragment),Rs=n(),Es=i("hr"),Ws=n(),Bt=i("p"),Bt.innerHTML=Ze,Fs=n(),_t=i("p"),_t.innerHTML=Ne,As=n(),h(It.$$.fragment),Qs=n(),Gt=i("p"),this.h()},l(t){const s=Qe("svelte-u9bgzb",document.head);j=p(s,"META",{name:!0,content:!0}),s.forEach(e),Ct=a(t),kt=p(t,"P",{}),zs(kt).forEach(e),vt=a(t),u(d.$$.fragment,t),xt=a(t),T=p(t,"IMG",{src:!0,alt:!0}),Xt=a(t),f=p(t,"P",{"data-svelte-h":!0}),o(f)!=="svelte-1rwfam6"&&(f.innerHTML=te),qt=a(t),b=p(t,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1pvln0h"&&(b.textContent=se),Zt=a(t),J=p(t,"P",{"data-svelte-h":!0}),o(J)!=="svelte-17n0axy"&&(J.textContent=ee),Nt=a(t),g=p(t,"P",{"data-svelte-h":!0}),o(g)!=="svelte-1ssvh5p"&&(g.innerHTML=le),Yt=a(t),U=p(t,"P",{"data-svelte-h":!0}),o(U)!=="svelte-r0w337"&&(U.innerHTML=ne),Rt=a(t),B=p(t,"P",{"data-svelte-h":!0}),o(B)!=="svelte-9snja6"&&(B.innerHTML=ae),Et=a(t),_=p(t,"P",{"data-svelte-h":!0}),o(_)!=="svelte-scmak8"&&(_.textContent=ie),Wt=a(t),I=p(t,"P",{"data-svelte-h":!0}),o(I)!=="svelte-10qtj1b"&&(I.innerHTML=pe),Ft=a(t),$=p(t,"P",{"data-svelte-h":!0}),o($)!=="svelte-1fa85bb"&&($.innerHTML=oe),At=a(t),u(k.$$.fragment,t),Qt=a(t),G=p(t,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1y7mhy7"&&(G.textContent=he),Vt=a(t),u(C.$$.fragment,t),Lt=a(t),u(v.$$.fragment,t),Ht=a(t),x=p(t,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1wueeet"&&(x.textContent=ue),St=a(t),u(X.$$.fragment,t),zt=a(t),q=p(t,"P",{"data-svelte-h":!0}),o(q)!=="svelte-14l0pz9"&&(q.innerHTML=re),Pt=a(t),Z=p(t,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1891xc3"&&(Z.innerHTML=ce),Ot=a(t),u(N.$$.fragment,t),Dt=a(t),Y=p(t,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1wueeet"&&(Y.textContent=Me),Kt=a(t),u(R.$$.fragment,t),ts=a(t),E=p(t,"P",{"data-svelte-h":!0}),o(E)!=="svelte-10i9u01"&&(E.textContent=ye),ss=a(t),u(W.$$.fragment,t),es=a(t),F=p(t,"P",{"data-svelte-h":!0}),o(F)!=="svelte-1wueeet"&&(F.textContent=we),ls=a(t),u(A.$$.fragment,t),ns=a(t),Q=p(t,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-o9oayq"&&(Q.textContent=je),as=a(t),u(V.$$.fragment,t),is=a(t),L=p(t,"P",{"data-svelte-h":!0}),o(L)!=="svelte-xr84ar"&&(L.textContent=me),ps=a(t),H=p(t,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1m7y210"&&(H.textContent=de),os=a(t),S=p(t,"OL",{"data-svelte-h":!0}),o(S)!=="svelte-27sevg"&&(S.innerHTML=Te),hs=a(t),u(z.$$.fragment,t),us=a(t),P=p(t,"P",{"data-svelte-h":!0}),o(P)!=="svelte-1jc27vd"&&(P.textContent=fe),rs=a(t),u(O.$$.fragment,t),cs=a(t),D=p(t,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1letw4p"&&(D.innerHTML=be),Ms=a(t),u(K.$$.fragment,t),ys=a(t),tt=p(t,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-u9o4sn"&&(tt.textContent=Je),ws=a(t),u(st.$$.fragment,t),js=a(t),et=p(t,"P",{"data-svelte-h":!0}),o(et)!=="svelte-18yryy0"&&(et.textContent=ge),ms=a(t),u(lt.$$.fragment,t),ds=a(t),nt=p(t,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-1wueeet"&&(nt.textContent=Ue),Ts=a(t),u(at.$$.fragment,t),fs=a(t),it=p(t,"P",{"data-svelte-h":!0}),o(it)!=="svelte-1u60rex"&&(it.textContent=Be),bs=a(t),u(pt.$$.fragment,t),Js=a(t),ot=p(t,"P",{"data-svelte-h":!0}),o(ot)!=="svelte-azbr52"&&(ot.textContent=_e),gs=a(t),m=p(t,"BLOCKQUOTE",{});var Ls=zs(m);$t=p(Ls,"P",{"data-svelte-h":!0}),o($t)!=="svelte-eu81gr"&&($t.textContent=Ie),Ss=a(Ls),u(ht.$$.fragment,Ls),Ls.forEach(e),Us=a(t),ut=p(t,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-1yqfqub"&&(ut.textContent=$e),Bs=a(t),u(rt.$$.fragment,t),_s=a(t),ct=p(t,"P",{"data-svelte-h":!0}),o(ct)!=="svelte-a5d62w"&&(ct.textContent=ke),Is=a(t),u(Mt.$$.fragment,t),$s=a(t),yt=p(t,"P",{"data-svelte-h":!0}),o(yt)!=="svelte-1s2rtg2"&&(yt.textContent=Ge),ks=a(t),wt=p(t,"P",{"data-svelte-h":!0}),o(wt)!=="svelte-1ndvzyl"&&(wt.textContent=Ce),Gs=a(t),u(jt.$$.fragment,t),Cs=a(t),mt=p(t,"P",{"data-svelte-h":!0}),o(mt)!=="svelte-1wueeet"&&(mt.textContent=ve),vs=a(t),u(dt.$$.fragment,t),xs=a(t),Tt=p(t,"P",{"data-svelte-h":!0}),o(Tt)!=="svelte-18w5bdv"&&(Tt.textContent=xe),Xs=a(t),u(ft.$$.fragment,t),qs=a(t),bt=p(t,"P",{"data-svelte-h":!0}),o(bt)!=="svelte-smcbfz"&&(bt.textContent=Xe),Zs=a(t),u(Jt.$$.fragment,t),Ns=a(t),gt=p(t,"P",{"data-svelte-h":!0}),o(gt)!=="svelte-1wuxk0l"&&(gt.textContent=qe),Ys=a(t),u(Ut.$$.fragment,t),Rs=a(t),Es=p(t,"HR",{}),Ws=a(t),Bt=p(t,"P",{"data-svelte-h":!0}),o(Bt)!=="svelte-1qq5buo"&&(Bt.innerHTML=Ze),Fs=a(t),_t=p(t,"P",{"data-svelte-h":!0}),o(_t)!=="svelte-1ef9lfw"&&(_t.innerHTML=Ne),As=a(t),u(It.$$.fragment,t),Qs=a(t),Gt=p(t,"P",{}),zs(Gt).forEach(e),this.h()},h(){Hs(j,"name","hf:doc:metadata"),Hs(j,"content",He),Re(T.src,Ks="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/whiteboard-unit1sub3DONE.jpg")||Hs(T,"src",Ks),Hs(T,"alt","Unit 1 planning")},m(t,s){Ps(document.head,j),l(t,Ct,s),l(t,kt,s),l(t,vt,s),r(d,t,s),l(t,xt,s),l(t,T,s),l(t,Xt,s),l(t,f,s),l(t,qt,s),l(t,b,s),l(t,Zt,s),l(t,J,s),l(t,Nt,s),l(t,g,s),l(t,Yt,s),l(t,U,s),l(t,Rt,s),l(t,B,s),l(t,Et,s),l(t,_,s),l(t,Wt,s),l(t,I,s),l(t,Ft,s),l(t,$,s),l(t,At,s),r(k,t,s),l(t,Qt,s),l(t,G,s),l(t,Vt,s),r(C,t,s),l(t,Lt,s),r(v,t,s),l(t,Ht,s),l(t,x,s),l(t,St,s),r(X,t,s),l(t,zt,s),l(t,q,s),l(t,Pt,s),l(t,Z,s),l(t,Ot,s),r(N,t,s),l(t,Dt,s),l(t,Y,s),l(t,Kt,s),r(R,t,s),l(t,ts,s),l(t,E,s),l(t,ss,s),r(W,t,s),l(t,es,s),l(t,F,s),l(t,ls,s),r(A,t,s),l(t,ns,s),l(t,Q,s),l(t,as,s),r(V,t,s),l(t,is,s),l(t,L,s),l(t,ps,s),l(t,H,s),l(t,os,s),l(t,S,s),l(t,hs,s),r(z,t,s),l(t,us,s),l(t,P,s),l(t,rs,s),r(O,t,s),l(t,cs,s),l(t,D,s),l(t,Ms,s),r(K,t,s),l(t,ys,s),l(t,tt,s),l(t,ws,s),r(st,t,s),l(t,js,s),l(t,et,s),l(t,ms,s),r(lt,t,s),l(t,ds,s),l(t,nt,s),l(t,Ts,s),r(at,t,s),l(t,fs,s),l(t,it,s),l(t,bs,s),r(pt,t,s),l(t,Js,s),l(t,ot,s),l(t,gs,s),l(t,m,s),Ps(m,$t),Ps(m,Ss),r(ht,m,null),l(t,Us,s),l(t,ut,s),l(t,Bs,s),r(rt,t,s),l(t,_s,s),l(t,ct,s),l(t,Is,s),r(Mt,t,s),l(t,$s,s),l(t,yt,s),l(t,ks,s),l(t,wt,s),l(t,Gs,s),r(jt,t,s),l(t,Cs,s),l(t,mt,s),l(t,vs,s),r(dt,t,s),l(t,xs,s),l(t,Tt,s),l(t,Xs,s),r(ft,t,s),l(t,qs,s),l(t,bt,s),l(t,Zs,s),r(Jt,t,s),l(t,Ns,s),l(t,gt,s),l(t,Ys,s),r(Ut,t,s),l(t,Rs,s),l(t,Es,s),l(t,Ws,s),l(t,Bt,s),l(t,Fs,s),l(t,_t,s),l(t,As,s),r(It,t,s),l(t,Qs,s),l(t,Gt,s),Vs=!0},p:Ee,i(t){Vs||(c(d.$$.fragment,t),c(k.$$.fragment,t),c(C.$$.fragment,t),c(v.$$.fragment,t),c(X.$$.fragment,t),c(N.$$.fragment,t),c(R.$$.fragment,t),c(W.$$.fragment,t),c(A.$$.fragment,t),c(V.$$.fragment,t),c(z.$$.fragment,t),c(O.$$.fragment,t),c(K.$$.fragment,t),c(st.$$.fragment,t),c(lt.$$.fragment,t),c(at.$$.fragment,t),c(pt.$$.fragment,t),c(ht.$$.fragment,t),c(rt.$$.fragment,t),c(Mt.$$.fragment,t),c(jt.$$.fragment,t),c(dt.$$.fragment,t),c(ft.$$.fragment,t),c(Jt.$$.fragment,t),c(Ut.$$.fragment,t),c(It.$$.fragment,t),Vs=!0)},o(t){M(d.$$.fragment,t),M(k.$$.fragment,t),M(C.$$.fragment,t),M(v.$$.fragment,t),M(X.$$.fragment,t),M(N.$$.fragment,t),M(R.$$.fragment,t),M(W.$$.fragment,t),M(A.$$.fragment,t),M(V.$$.fragment,t),M(z.$$.fragment,t),M(O.$$.fragment,t),M(K.$$.fragment,t),M(st.$$.fragment,t),M(lt.$$.fragment,t),M(at.$$.fragment,t),M(pt.$$.fragment,t),M(ht.$$.fragment,t),M(rt.$$.fragment,t),M(Mt.$$.fragment,t),M(jt.$$.fragment,t),M(dt.$$.fragment,t),M(ft.$$.fragment,t),M(Jt.$$.fragment,t),M(Ut.$$.fragment,t),M(It.$$.fragment,t),Vs=!1},d(t){t&&(e(Ct),e(kt),e(vt),e(xt),e(T),e(Xt),e(f),e(qt),e(b),e(Zt),e(J),e(Nt),e(g),e(Yt),e(U),e(Rt),e(B),e(Et),e(_),e(Wt),e(I),e(Ft),e($),e(At),e(Qt),e(G),e(Vt),e(Lt),e(Ht),e(x),e(St),e(zt),e(q),e(Pt),e(Z),e(Ot),e(Dt),e(Y),e(Kt),e(ts),e(E),e(ss),e(es),e(F),e(ls),e(ns),e(Q),e(as),e(is),e(L),e(ps),e(H),e(os),e(S),e(hs),e(us),e(P),e(rs),e(cs),e(D),e(Ms),e(ys),e(tt),e(ws),e(js),e(et),e(ms),e(ds),e(nt),e(Ts),e(fs),e(it),e(bs),e(Js),e(ot),e(gs),e(m),e(Us),e(ut),e(Bs),e(_s),e(ct),e(Is),e($s),e(yt),e(ks),e(wt),e(Gs),e(Cs),e(mt),e(vs),e(xs),e(Tt),e(Xs),e(qs),e(bt),e(Zs),e(Ns),e(gt),e(Ys),e(Rs),e(Es),e(Ws),e(Bt),e(Fs),e(_t),e(As),e(Qs),e(Gt)),e(j),y(d,t),y(k,t),y(C,t),y(v,t),y(X,t),y(N,t),y(R,t),y(W,t),y(A,t),y(V,t),y(z,t),y(O,t),y(K,t),y(st,t),y(lt,t),y(at,t),y(pt,t),y(ht),y(rt,t),y(Mt,t),y(jt,t),y(dt,t),y(ft,t),y(Jt,t),y(Ut,t),y(It,t)}}}const He='{"title":"Dummy Agent Library","local":"dummy-agent-library","sections":[{"title":"Serverless API","local":"serverless-api","sections":[],"depth":2},{"title":"Dummy Agent","local":"dummy-agent","sections":[],"depth":2}],"depth":1}';function Se(Ds){return We(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class tl extends Fe{constructor(j){super(),Ae(this,j,Se,Le,Ye,{})}}export{tl as component};
