import{s as el,n as tl,o as ll}from"../chunks/scheduler.f7e1785c.js";import{S as sl,i as nl,g as o,s as n,r as M,A as al,h as i,f as l,c as a,j as Kt,u as p,x as r,k as Ot,y as ol,a as s,v as h,d as c,t as d,w as y}from"../chunks/index.9f8f0838.js";import{C as ue}from"../chunks/CodeBlock.b3510e34.js";import{H as u}from"../chunks/Heading.6643a2f7.js";import{E as il}from"../chunks/EditOnGithub.d8925fc6.js";function rl(wt){let m,Te,me,we,g,Je,T,Jt="As we explored in unit 1, agents use tools to perform various actions. In <code>smolagents</code>, tools are treated as functions that an LLM can call within an agent system. To interact with a tool, the LLM needs an <strong>interface description</strong> with these key components:",Ue,w,Ut="<li><strong>Name</strong>: What the tool is called</li> <li><strong>Tool description</strong>: What the tool does</li> <li><strong>Input types and descriptions</strong>: What arguments the tool accepts</li> <li><strong>Output type</strong>: What the tool returns</li>",fe,J,ft="For instance, while preparing for a party at Wayne Manor, Alfred needs various tools to gather information - from searching for catering services to finding party theme ideas. Here’s how a simple search tool interface might look:",je,U,jt="<li><strong>Name:</strong> <code>web_search</code></li> <li><strong>Tool description:</strong> Searches the web for specific queries</li> <li><strong>Input:</strong> <code>query</code> (string) - The search term to look up</li> <li><strong>Output:</strong> String containing the search results</li>",be,f,bt="By using these tools, Alfred can make informed decisions and gather all the information needed for planning the perfect party.",Ie,j,It="Below, you can see an animation illustrating how a tool call is managed:",Ce,b,Ct='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/Agent_ManimCE.gif" alt="Agentic pipeline from https://huggingface.co/docs/smolagents/conceptual_guides/react"/>',ve,I,Ge,C,vt="In <code>smolagents</code>, tools can be defined in two ways:",Ze,v,Gt="<li><strong>Using the <code>@tool</code> decorator</strong> for simple function-based tools</li> <li><strong>Creating a subclass of <code>Tool</code></strong> for more complex functionality</li>",Be,G,Ae,Z,Zt="The <code>@tool</code> decorator is the recommended way to define simple tools. Under the hood, smolagents will parse basic information about the function from Python. So if you name you function clearly and a good docstring, it will be easier for the LLM to use. Using this approach, we define a function with:",Ve,B,Bt="<li><strong>A clear and descriptive function name</strong> that helps the LLM understand its purpose.</li> <li><strong>Type hints for both inputs and outputs</strong> to ensure proper usage.</li> <li><strong>A detailed description</strong>, including an <code>Args:</code> section where each argument is explicitly described. These descriptions provide valuable context for the LLM, so it’s important to write them carefully.</li>",Xe,A,$e,V,At="Let’s imagine that Alfred has already decided on the menu for the party, but now he needs help preparing food for such a large number of guests. To do so, he would like to hire a catering service and needs to identify the highest-rated options available. Alfred can leverage a tool to search for the best catering services in his area. Below is an example of how Alfred can use the <code>@tool</code> decorator to make this happen:",We,X,He,$,xe,W,Vt='This approach involves creating a subclass of <a href="https://huggingface.co/docs/smolagents/v1.8.1/en/reference/tools#smolagents.Tool" rel="nofollow"><code>Tool</code></a>.  For complex tools, we can implement a class instead of a Python function. The class wraps the function with metadata that helps the LLM understand how to use it effectively. In this class, we define:',Re,H,Xt="<li><code>name</code>: The tool’s name.</li> <li><code>description</code>: A description used to populate the agent’s system prompt.</li> <li><code>inputs</code>: A dictionary with keys <code>type</code> and <code>description</code>, providing information to help the Python interpreter process inputs.</li> <li><code>output_type</code>: Specifies the expected output type.</li> <li><code>forward</code>: The method containing the inference logic to execute.</li>",Se,x,$t="Below, we can see an example of a tool built using <code>Tool</code> and to integrate it within a <code>CodeAgent</code>.",ke,R,Qe,S,Wt="Alfred’s party at the mansion is a <strong>superhero-themed event</strong>, but he needs some creative ideas to make it truly special. As a fantastic host, he wants to surprise the guests with a unique theme. To do this, he can use an agent that generates superhero-themed party ideas based on a given category. This way, Alfred can find the perfect party theme to wow his guests.",Ee,k,_e,Q,Ht="With this tool, Alfred will be the ultimate super host, impressing his guests with a superhero-themed party they won’t forget! 🦸‍♂️🦸‍♀️",Ne,E,Fe,_,xt='<code>smolagents</code> comes with a set of pre-built tools that can be directly injected into your agent. The <a href="https://huggingface.co/docs/smolagents/guided_tour?build-a-tool=Decorate+a+function+with+%40tool#default-toolbox" rel="nofollow">default toolbox</a> includes:',Ye,N,Rt="<li><strong>PythonInterpreterTool</strong></li> <li><strong>FinalAnswerTool</strong></li> <li><strong>UserInputTool</strong></li> <li><strong>DuckDuckGoSearchTool</strong></li> <li><strong>GoogleSearchTool</strong></li> <li><strong>VisitWebpageTool</strong></li>",Le,F,St="Alfred could use various tools to ensure a flawless party at Wayne Manor. First, he could use the <code>DuckDuckGoSearchTool</code> to find creative superhero-themed party ideas. For catering, he’d rely on the <code>GoogleSearchTool</code> to find the highest-rated services in Gotham. To manage seating arrangements, Alfred could run calculations with the <code>PythonInterpreterTool</code>. Once everything is gathered, he’d compile the plan using the <code>FinalAnswerTool</code>. Lastly, the <code>VisitWebpageTool</code> would keep him updated on any changes, ensuring a smooth event. With these tools, Alfred guarantees the party is both exceptional and seamless. 🦇💡",qe,Y,ze,L,kt="One of the most powerful features of <strong>smolagents</strong> is its ability to share custom tools on the Hub and seamlessly integrate tools created by the community. This includes connecting with <strong>HF Spaces</strong> and <strong>LangChain tools</strong>, significantly enhancing Alfred’s ability to orchestrate an unforgettable party at Wayne Manor. 🎭",Pe,q,Qt="With these integrations, Alfred can tap into advanced event-planning tools—whether it’s adjusting the lighting for the perfect ambiance, curating the ideal playlist for the party, or coordinating with Gotham’s finest caterers.",De,z,Et="Here are examples showcasing how these functionalities can elevate the party experience:",Ke,P,Oe,D,_t="Sharing your custom tool with the community is easy! Simply upload it to your Hugging Face account using the <code>push_to_hub()</code> method.",et,K,Nt="For instance, Alfred can share his <code>catering_service_tool</code> to help others find the best catering services in Gotham. Here’s how to do it:",tt,O,lt,ee,st,te,Ft="You can easily import tools created by other users using the <code>load_tool()</code> function. For example, Alfred might want to generate a promotional image for the party using AI. Instead of building a tool from scratch, he can leverage a predefined one from the community:",nt,le,at,se,ot,ne,Yt="You can also import a HF Space as a tool using <code>Tool.from_space()</code>. This opens up possibilities for integrating with thousands of spaces from the community for tasks from image generation to data analysis. The tool will connect with the spaces Gradio backend using the <code>gradio_client</code>, so make sure to install it via <code>pip</code> if you don’t have it already. For the party, Alfred can also use a HF Space directly for the geneation of the previous annoucement AI-generated image. Let’s build it!",it,ae,rt,oe,Mt,ie,Lt="You can easily load LangChain tools using the <code>Tool.from_langchain()</code> method. Alfred, ever the perfectionist, is preparing for a spectacular superhero night at Wayne Manor while the Waynes are away. To make sure every detail exceeds expectations, he taps into LangChain tools to find top-tier entertainment ideas.",pt,re,qt="By using <code>Tool.from_langchain()</code>, Alfred effortlessly adds advanced search functionalities to his smolagent, enabling him to discover exclusive party ideas and services with just a few commands.",ht,Me,zt="Here’s how he does it:",ct,pe,dt,he,Pt="With this setup, Alfred can quickly discover luxurious entertainment options, ensuring Gotham’s elite guests have an unforgettable experience. This tool helps him curate the perfect superhero-themed event for Wayne Manor! 🎉",yt,ce,ut,de,Dt='<li><a href="https://huggingface.co/docs/smolagents/tutorials/tools" rel="nofollow">Tools Tutorial</a> - Explore this tutorial to learn how to work with tools effectively.</li> <li><a href="https://huggingface.co/docs/smolagents/v1.8.1/en/reference/tools" rel="nofollow">Tools Documentation</a> - Comprehensive reference documentation on tools.</li> <li><a href="https://huggingface.co/docs/smolagents/v1.8.1/en/guided_tour#tools" rel="nofollow">Tools Guided Tour</a> - A step-by-step guided tour to help you build and utilize tools efficiently.</li> <li><a href="https://huggingface.co/docs/smolagents/tutorials/building_good_agents" rel="nofollow">Building Effective Agents</a> - A detailed guide on best practices for developing reliable and high-performance custom function agents.</li>',mt,ye,gt,ge,Tt;return g=new u({props:{title:"Tools",local:"tools",headingTag:"h1"}}),I=new u({props:{title:"Tool Creation Methods",local:"tool-creation-methods",headingTag:"h2"}}),G=new u({props:{title:"The @tool Decorator",local:"the-tool-decorator",headingTag:"h3"}}),A=new u({props:{title:"Generating a tool that retrieves the highest-rated catering",local:"generating-a-tool-that-retrieves-the-highest-rated-catering",headingTag:"h4"}}),X=new ue({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, HfApiModel, tool

<span class="hljs-comment"># Let&#x27;s pretend we have a function that fetches the highest-rated catering services.</span>
<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">catering_service_tool</span>(<span class="hljs-params">query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    This tool returns the highest-rated catering service in Gotham City.
    
    Args:
        query: A search term for finding catering services.
    &quot;&quot;&quot;</span>
    <span class="hljs-comment"># Example list of catering services and their ratings</span>
    services = {
        <span class="hljs-string">&quot;Gotham Catering Co.&quot;</span>: <span class="hljs-number">4.9</span>,
        <span class="hljs-string">&quot;Wayne Manor Catering&quot;</span>: <span class="hljs-number">4.8</span>,
        <span class="hljs-string">&quot;Gotham City Events&quot;</span>: <span class="hljs-number">4.7</span>,
    }
    
    <span class="hljs-comment"># Find the highest rated catering service (simulating search query filtering)</span>
    best_service = <span class="hljs-built_in">max</span>(services, key=services.get)
    
    <span class="hljs-keyword">return</span> best_service


agent = CodeAgent(tools=[catering_service_tool], model=HfApiModel())

<span class="hljs-comment"># Run the agent to find the best catering service</span>
result = agent.run(
    <span class="hljs-string">&quot;Can you give me the name of the highest-rated catering service in Gotham City?&quot;</span>
)

<span class="hljs-built_in">print</span>(result)   <span class="hljs-comment"># Output: Gotham Catering Co.</span>`,wrap:!1}}),$=new u({props:{title:"Defining a Tool as a Python Class",local:"defining-a-tool-as-a-python-class",headingTag:"h3"}}),R=new u({props:{title:"Generating a tool to generate ideas about the superhero-themed party",local:"generating-a-tool-to-generate-ideas-about-the-superhero-themed-party",headingTag:"h4"}}),k=new ue({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sJTJDJTIwQ29kZUFnZW50JTJDJTIwSGZBcGlNb2RlbCUwQSUwQWNsYXNzJTIwU3VwZXJoZXJvUGFydHlUaGVtZVRvb2woVG9vbCklM0ElMEElMjAlMjAlMjAlMjBuYW1lJTIwJTNEJTIwJTIyc3VwZXJoZXJvX3BhcnR5X3RoZW1lX2dlbmVyYXRvciUyMiUwQSUyMCUyMCUyMCUyMGRlc2NyaXB0aW9uJTIwJTNEJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwVGhpcyUyMHRvb2wlMjBzdWdnZXN0cyUyMGNyZWF0aXZlJTIwc3VwZXJoZXJvLXRoZW1lZCUyMHBhcnR5JTIwaWRlYXMlMjBiYXNlZCUyMG9uJTIwYSUyMGNhdGVnb3J5LiUwQSUyMCUyMCUyMCUyMEl0JTIwcmV0dXJucyUyMGElMjB1bmlxdWUlMjBwYXJ0eSUyMHRoZW1lJTIwaWRlYS4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjYXRlZ29yeSUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJzdHJpbmclMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJkZXNjcmlwdGlvbiUyMiUzQSUyMCUyMlRoZSUyMHR5cGUlMjBvZiUyMHN1cGVyaGVybyUyMHBhcnR5JTIwKGUuZy4lMkMlMjAnY2xhc3NpYyUyMGhlcm9lcyclMkMlMjAndmlsbGFpbiUyMG1hc3F1ZXJhZGUnJTJDJTIwJ2Z1dHVyaXN0aWMlMjBHb3RoYW0nKS4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjBvdXRwdXRfdHlwZSUyMCUzRCUyMCUyMnN0cmluZyUyMiUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMGNhdGVnb3J5JTNBJTIwc3RyKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRoZW1lcyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNsYXNzaWMlMjBoZXJvZXMlMjIlM0ElMjAlMjJKdXN0aWNlJTIwTGVhZ3VlJTIwR2FsYSUzQSUyMEd1ZXN0cyUyMGNvbWUlMjBkcmVzc2VkJTIwYXMlMjB0aGVpciUyMGZhdm9yaXRlJTIwREMlMjBoZXJvZXMlMjB3aXRoJTIwdGhlbWVkJTIwY29ja3RhaWxzJTIwbGlrZSUyMCdUaGUlMjBLcnlwdG9uaXRlJTIwUHVuY2gnLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnZpbGxhaW4lMjBtYXNxdWVyYWRlJTIyJTNBJTIwJTIyR290aGFtJTIwUm9ndWVzJyUyMEJhbGwlM0ElMjBBJTIwbXlzdGVyaW91cyUyMG1hc3F1ZXJhZGUlMjB3aGVyZSUyMGd1ZXN0cyUyMGRyZXNzJTIwYXMlMjBjbGFzc2ljJTIwQmF0bWFuJTIwdmlsbGFpbnMuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZnV0dXJpc3RpYyUyMEdvdGhhbSUyMiUzQSUyMCUyMk5lby1Hb3RoYW0lMjBOaWdodCUzQSUyMEElMjBjeWJlcnB1bmstc3R5bGUlMjBwYXJ0eSUyMGluc3BpcmVkJTIwYnklMjBCYXRtYW4lMjBCZXlvbmQlMkMlMjB3aXRoJTIwbmVvbiUyMGRlY29yYXRpb25zJTIwYW5kJTIwZnV0dXJpc3RpYyUyMGdhZGdldHMuJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwdGhlbWVzLmdldChjYXRlZ29yeS5sb3dlcigpJTJDJTIwJTIyVGhlbWVkJTIwcGFydHklMjBpZGVhJTIwbm90JTIwZm91bmQuJTIwVHJ5JTIwJ2NsYXNzaWMlMjBoZXJvZXMnJTJDJTIwJ3ZpbGxhaW4lMjBtYXNxdWVyYWRlJyUyQyUyMG9yJTIwJ2Z1dHVyaXN0aWMlMjBHb3RoYW0nLiUyMiklMEElMEElMjMlMjBJbnN0YW50aWF0ZSUyMHRoZSUyMHRvb2wlMEFwYXJ0eV90aGVtZV90b29sJTIwJTNEJTIwU3VwZXJoZXJvUGFydHlUaGVtZVRvb2woKSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCcGFydHlfdGhlbWVfdG9vbCU1RCUyQyUyMG1vZGVsJTNESGZBcGlNb2RlbCgpKSUwQSUwQSUyMyUyMFJ1biUyMHRoZSUyMGFnZW50JTIwdG8lMjBnZW5lcmF0ZSUyMGElMjBwYXJ0eSUyMHRoZW1lJTIwaWRlYSUwQXJlc3VsdCUyMCUzRCUyMGFnZW50LnJ1biglMEElMjAlMjAlMjAlMjAlMjJXaGF0JTIwd291bGQlMjBiZSUyMGElMjBnb29kJTIwc3VwZXJoZXJvJTIwcGFydHklMjBpZGVhJTIwZm9yJTIwYSUyMCd2aWxsYWluJTIwbWFzcXVlcmFkZSclMjB0aGVtZSUzRiUyMiUwQSklMEElMEFwcmludChyZXN1bHQpJTIwJTIwJTIzJTIwT3V0cHV0JTNBJTIwJTIyR290aGFtJTIwUm9ndWVzJyUyMEJhbGwlM0ElMjBBJTIwbXlzdGVyaW91cyUyMG1hc3F1ZXJhZGUlMjB3aGVyZSUyMGd1ZXN0cyUyMGRyZXNzJTIwYXMlMjBjbGFzc2ljJTIwQmF0bWFuJTIwdmlsbGFpbnMuJTIy",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool, CodeAgent, HfApiModel

<span class="hljs-keyword">class</span> <span class="hljs-title class_">SuperheroPartyThemeTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;superhero_party_theme_generator&quot;</span>
    description = <span class="hljs-string">&quot;&quot;&quot;
    This tool suggests creative superhero-themed party ideas based on a category.
    It returns a unique party theme idea.&quot;&quot;&quot;</span>
    
    inputs = {
        <span class="hljs-string">&quot;category&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The type of superhero party (e.g., &#x27;classic heroes&#x27;, &#x27;villain masquerade&#x27;, &#x27;futuristic Gotham&#x27;).&quot;</span>,
        }
    }
    
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, category: <span class="hljs-built_in">str</span></span>):
        themes = {
            <span class="hljs-string">&quot;classic heroes&quot;</span>: <span class="hljs-string">&quot;Justice League Gala: Guests come dressed as their favorite DC heroes with themed cocktails like &#x27;The Kryptonite Punch&#x27;.&quot;</span>,
            <span class="hljs-string">&quot;villain masquerade&quot;</span>: <span class="hljs-string">&quot;Gotham Rogues&#x27; Ball: A mysterious masquerade where guests dress as classic Batman villains.&quot;</span>,
            <span class="hljs-string">&quot;futuristic Gotham&quot;</span>: <span class="hljs-string">&quot;Neo-Gotham Night: A cyberpunk-style party inspired by Batman Beyond, with neon decorations and futuristic gadgets.&quot;</span>
        }
        
        <span class="hljs-keyword">return</span> themes.get(category.lower(), <span class="hljs-string">&quot;Themed party idea not found. Try &#x27;classic heroes&#x27;, &#x27;villain masquerade&#x27;, or &#x27;futuristic Gotham&#x27;.&quot;</span>)

<span class="hljs-comment"># Instantiate the tool</span>
party_theme_tool = SuperheroPartyThemeTool()
agent = CodeAgent(tools=[party_theme_tool], model=HfApiModel())

<span class="hljs-comment"># Run the agent to generate a party theme idea</span>
result = agent.run(
    <span class="hljs-string">&quot;What would be a good superhero party idea for a &#x27;villain masquerade&#x27; theme?&quot;</span>
)

<span class="hljs-built_in">print</span>(result)  <span class="hljs-comment"># Output: &quot;Gotham Rogues&#x27; Ball: A mysterious masquerade where guests dress as classic Batman villains.&quot;</span>`,wrap:!1}}),E=new u({props:{title:"Default Toolbox",local:"default-toolbox",headingTag:"h2"}}),Y=new u({props:{title:"Sharing and Importing Tools",local:"sharing-and-importing-tools",headingTag:"h2"}}),P=new u({props:{title:"Sharing a Tool to the Hub",local:"sharing-a-tool-to-the-hub",headingTag:"h3"}}),O=new ue({props:{code:"cGFydHlfdGhlbWVfdG9vbC5wdXNoX3RvX2h1YiglMjIlN0J5b3VyX3VzZXJuYW1lJTdEJTJGY2F0ZXJpbmdfc2VydmljZV90b29sJTIyJTJDJTIwdG9rZW4lM0QlMjIlM0NZT1VSX0hVR0dJTkdGQUNFSFVCX0FQSV9UT0tFTiUzRSUyMik=",highlighted:'party_theme_tool.push_to_hub(<span class="hljs-string">&quot;{your_username}/catering_service_tool&quot;</span>, token=<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>)',wrap:!1}}),ee=new u({props:{title:"Importing a Tool from the Hub",local:"importing-a-tool-from-the-hub",headingTag:"h3"}}),le=new ue({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2wlMkMlMjBDb2RlQWdlbnQlMkMlMjBIZkFwaU1vZGVsJTBBJTBBaW1hZ2VfZ2VuZXJhdGlvbl90b29sJTIwJTNEJTIwbG9hZF90b29sKCUwQSUyMCUyMCUyMCUyMCUyMm0tcmljJTJGdGV4dC10by1pbWFnZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSUwQSklMEElMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QmltYWdlX2dlbmVyYXRpb25fdG9vbCU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNESGZBcGlNb2RlbCgpJTBBKSUwQSUwQWFnZW50LnJ1biglMjJHZW5lcmF0ZSUyMGFuJTIwaW1hZ2UlMjBvZiUyMGElMjBsdXh1cmlvdXMlMjBzdXBlcmhlcm8tdGhlbWVkJTIwcGFydHklMjBhdCUyMFdheW5lJTIwTWFub3IlMjB3aXRoJTIwbWFkZS11cCUyMHN1cGVyaGVyb3MuJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> load_tool, CodeAgent, HfApiModel

image_generation_tool = load_tool(
    <span class="hljs-string">&quot;m-ric/text-to-image&quot;</span>,
    trust_remote_code=<span class="hljs-literal">True</span>
)

agent = CodeAgent(
    tools=[image_generation_tool],
    model=HfApiModel()
)

agent.run(<span class="hljs-string">&quot;Generate an image of a luxurious superhero-themed party at Wayne Manor with made-up superheros.&quot;</span>)`,wrap:!1}}),se=new u({props:{title:"Importing a Hugging Face Space as a Tool",local:"importing-a-hugging-face-space-as-a-tool",headingTag:"h3"}}),ae=new ue({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBIZkFwaU1vZGVsJTJDJTIwVG9vbCUwQSUwQWltYWdlX2dlbmVyYXRpb25fdG9vbCUyMCUzRCUyMFRvb2wuZnJvbV9zcGFjZSglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1zY2huZWxsJTIyJTJDJTBBJTIwJTIwJTIwJTIwbmFtZSUzRCUyMmltYWdlX2dlbmVyYXRvciUyMiUyQyUwQSUyMCUyMCUyMCUyMGRlc2NyaXB0aW9uJTNEJTIyR2VuZXJhdGUlMjBhbiUyMGltYWdlJTIwZnJvbSUyMGElMjBwcm9tcHQlMjIlMEEpJTBBJTBBbW9kZWwlMjAlM0QlMjBIZkFwaU1vZGVsKCUyMlF3ZW4lMkZRd2VuMi41LUNvZGVyLTMyQi1JbnN0cnVjdCUyMiklMEElMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QmltYWdlX2dlbmVyYXRpb25fdG9vbCU1RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBJTBBYWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMkltcHJvdmUlMjB0aGlzJTIwcHJvbXB0JTJDJTIwdGhlbiUyMGdlbmVyYXRlJTIwYW4lMjBpbWFnZSUyMG9mJTIwaXQuJTIyJTJDJTIwJTBBJTIwJTIwJTIwJTIwYWRkaXRpb25hbF9hcmdzJTNEJTdCJ3VzZXJfcHJvbXB0JyUzQSUyMCdBJTIwZ3JhbmQlMjBzdXBlcmhlcm8tdGhlbWVkJTIwcGFydHklMjBhdCUyMFdheW5lJTIwTWFub3IlMkMlMjB3aXRoJTIwQWxmcmVkJTIwb3ZlcnNlZWluZyUyMGElMjBsdXh1cmlvdXMlMjBnYWxhJyU3RCUwQSk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, HfApiModel, Tool

image_generation_tool = Tool.from_space(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
    name=<span class="hljs-string">&quot;image_generator&quot;</span>,
    description=<span class="hljs-string">&quot;Generate an image from a prompt&quot;</span>
)

model = HfApiModel(<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)

agent = CodeAgent(tools=[image_generation_tool], model=model)

agent.run(
    <span class="hljs-string">&quot;Improve this prompt, then generate an image of it.&quot;</span>, 
    additional_args={<span class="hljs-string">&#x27;user_prompt&#x27;</span>: <span class="hljs-string">&#x27;A grand superhero-themed party at Wayne Manor, with Alfred overseeing a luxurious gala&#x27;</span>}
)`,wrap:!1}}),oe=new u({props:{title:"Importing a LangChain Tool",local:"importing-a-langchain-tool",headingTag:"h3"}}),pe=new ue({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5hZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2xzJTBBZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBIZkFwaU1vZGVsJTJDJTIwVG9vbCUwQSUwQXNlYXJjaF90b29sJTIwJTNEJTIwVG9vbC5mcm9tX2xhbmdjaGFpbihsb2FkX3Rvb2xzKCU1QiUyMnNlcnBhcGklMjIlNUQpJTVCMCU1RCklMEElMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QnNlYXJjaF90b29sJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCklMEElMEFhZ2VudC5ydW4oJTIyU2VhcmNoJTIwZm9yJTIwbHV4dXJ5JTIwZW50ZXJ0YWlubWVudCUyMGlkZWFzJTIwZm9yJTIwYSUyMHN1cGVyaGVyby10aGVtZWQlMjBldmVudCUyQyUyMHN1Y2glMjBhcyUyMGxpdmUlMjBwZXJmb3JtYW5jZXMlMjBhbmQlMjBpbnRlcmFjdGl2ZSUyMGV4cGVyaWVuY2VzLiUyMik=",highlighted:`<span class="hljs-keyword">from</span> langchain.agents <span class="hljs-keyword">import</span> load_tools
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, HfApiModel, Tool

search_tool = Tool.from_langchain(load_tools([<span class="hljs-string">&quot;serpapi&quot;</span>])[<span class="hljs-number">0</span>])

agent = CodeAgent(tools=[search_tool], model=model)

agent.run(<span class="hljs-string">&quot;Search for luxury entertainment ideas for a superhero-themed event, such as live performances and interactive experiences.&quot;</span>)`,wrap:!1}}),ce=new u({props:{title:"Resources",local:"resources",headingTag:"h2"}}),ye=new il({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit2/smolagents/tools.md"}}),{c(){m=o("meta"),Te=n(),me=o("p"),we=n(),M(g.$$.fragment),Je=n(),T=o("p"),T.innerHTML=Jt,Ue=n(),w=o("ul"),w.innerHTML=Ut,fe=n(),J=o("p"),J.textContent=ft,je=n(),U=o("ul"),U.innerHTML=jt,be=n(),f=o("p"),f.textContent=bt,Ie=n(),j=o("p"),j.textContent=It,Ce=n(),b=o("p"),b.innerHTML=Ct,ve=n(),M(I.$$.fragment),Ge=n(),C=o("p"),C.innerHTML=vt,Ze=n(),v=o("ol"),v.innerHTML=Gt,Be=n(),M(G.$$.fragment),Ae=n(),Z=o("p"),Z.innerHTML=Zt,Ve=n(),B=o("ul"),B.innerHTML=Bt,Xe=n(),M(A.$$.fragment),$e=n(),V=o("p"),V.innerHTML=At,We=n(),M(X.$$.fragment),He=n(),M($.$$.fragment),xe=n(),W=o("p"),W.innerHTML=Vt,Re=n(),H=o("ul"),H.innerHTML=Xt,Se=n(),x=o("p"),x.innerHTML=$t,ke=n(),M(R.$$.fragment),Qe=n(),S=o("p"),S.innerHTML=Wt,Ee=n(),M(k.$$.fragment),_e=n(),Q=o("p"),Q.textContent=Ht,Ne=n(),M(E.$$.fragment),Fe=n(),_=o("p"),_.innerHTML=xt,Ye=n(),N=o("ul"),N.innerHTML=Rt,Le=n(),F=o("p"),F.innerHTML=St,qe=n(),M(Y.$$.fragment),ze=n(),L=o("p"),L.innerHTML=kt,Pe=n(),q=o("p"),q.textContent=Qt,De=n(),z=o("p"),z.textContent=Et,Ke=n(),M(P.$$.fragment),Oe=n(),D=o("p"),D.innerHTML=_t,et=n(),K=o("p"),K.innerHTML=Nt,tt=n(),M(O.$$.fragment),lt=n(),M(ee.$$.fragment),st=n(),te=o("p"),te.innerHTML=Ft,nt=n(),M(le.$$.fragment),at=n(),M(se.$$.fragment),ot=n(),ne=o("p"),ne.innerHTML=Yt,it=n(),M(ae.$$.fragment),rt=n(),M(oe.$$.fragment),Mt=n(),ie=o("p"),ie.innerHTML=Lt,pt=n(),re=o("p"),re.innerHTML=qt,ht=n(),Me=o("p"),Me.textContent=zt,ct=n(),M(pe.$$.fragment),dt=n(),he=o("p"),he.textContent=Pt,yt=n(),M(ce.$$.fragment),ut=n(),de=o("ul"),de.innerHTML=Dt,mt=n(),M(ye.$$.fragment),gt=n(),ge=o("p"),this.h()},l(e){const t=al("svelte-u9bgzb",document.head);m=i(t,"META",{name:!0,content:!0}),t.forEach(l),Te=a(e),me=i(e,"P",{}),Kt(me).forEach(l),we=a(e),p(g.$$.fragment,e),Je=a(e),T=i(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1su08i"&&(T.innerHTML=Jt),Ue=a(e),w=i(e,"UL",{"data-svelte-h":!0}),r(w)!=="svelte-dlnk8z"&&(w.innerHTML=Ut),fe=a(e),J=i(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-xxdm5o"&&(J.textContent=ft),je=a(e),U=i(e,"UL",{"data-svelte-h":!0}),r(U)!=="svelte-1y8sxu4"&&(U.innerHTML=jt),be=a(e),f=i(e,"P",{"data-svelte-h":!0}),r(f)!=="svelte-1s1gqsf"&&(f.textContent=bt),Ie=a(e),j=i(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-gwhed0"&&(j.textContent=It),Ce=a(e),b=i(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1j9zfgm"&&(b.innerHTML=Ct),ve=a(e),p(I.$$.fragment,e),Ge=a(e),C=i(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1yodl19"&&(C.innerHTML=vt),Ze=a(e),v=i(e,"OL",{"data-svelte-h":!0}),r(v)!=="svelte-1idspfm"&&(v.innerHTML=Gt),Be=a(e),p(G.$$.fragment,e),Ae=a(e),Z=i(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-hf7a9k"&&(Z.innerHTML=Zt),Ve=a(e),B=i(e,"UL",{"data-svelte-h":!0}),r(B)!=="svelte-r6zbcf"&&(B.innerHTML=Bt),Xe=a(e),p(A.$$.fragment,e),$e=a(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-y5wh41"&&(V.innerHTML=At),We=a(e),p(X.$$.fragment,e),He=a(e),p($.$$.fragment,e),xe=a(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-cmtwcn"&&(W.innerHTML=Vt),Re=a(e),H=i(e,"UL",{"data-svelte-h":!0}),r(H)!=="svelte-17z09hb"&&(H.innerHTML=Xt),Se=a(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-i76vwl"&&(x.innerHTML=$t),ke=a(e),p(R.$$.fragment,e),Qe=a(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-114z22o"&&(S.innerHTML=Wt),Ee=a(e),p(k.$$.fragment,e),_e=a(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-148a819"&&(Q.textContent=Ht),Ne=a(e),p(E.$$.fragment,e),Fe=a(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-10xt16w"&&(_.innerHTML=xt),Ye=a(e),N=i(e,"UL",{"data-svelte-h":!0}),r(N)!=="svelte-1pasg00"&&(N.innerHTML=Rt),Le=a(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-ok3m90"&&(F.innerHTML=St),qe=a(e),p(Y.$$.fragment,e),ze=a(e),L=i(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1xcpx7t"&&(L.innerHTML=kt),Pe=a(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-xc6zmk"&&(q.textContent=Qt),De=a(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-fsw72s"&&(z.textContent=Et),Ke=a(e),p(P.$$.fragment,e),Oe=a(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1cmmx6"&&(D.innerHTML=_t),et=a(e),K=i(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-zedixg"&&(K.innerHTML=Nt),tt=a(e),p(O.$$.fragment,e),lt=a(e),p(ee.$$.fragment,e),st=a(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1v2b8b8"&&(te.innerHTML=Ft),nt=a(e),p(le.$$.fragment,e),at=a(e),p(se.$$.fragment,e),ot=a(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-10iem2l"&&(ne.innerHTML=Yt),it=a(e),p(ae.$$.fragment,e),rt=a(e),p(oe.$$.fragment,e),Mt=a(e),ie=i(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-n7r7ow"&&(ie.innerHTML=Lt),pt=a(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-sjrzcz"&&(re.innerHTML=qt),ht=a(e),Me=i(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-154co1f"&&(Me.textContent=zt),ct=a(e),p(pe.$$.fragment,e),dt=a(e),he=i(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1yv1f1"&&(he.textContent=Pt),yt=a(e),p(ce.$$.fragment,e),ut=a(e),de=i(e,"UL",{"data-svelte-h":!0}),r(de)!=="svelte-1gwl39i"&&(de.innerHTML=Dt),mt=a(e),p(ye.$$.fragment,e),gt=a(e),ge=i(e,"P",{}),Kt(ge).forEach(l),this.h()},h(){Ot(m,"name","hf:doc:metadata"),Ot(m,"content",Ml)},m(e,t){ol(document.head,m),s(e,Te,t),s(e,me,t),s(e,we,t),h(g,e,t),s(e,Je,t),s(e,T,t),s(e,Ue,t),s(e,w,t),s(e,fe,t),s(e,J,t),s(e,je,t),s(e,U,t),s(e,be,t),s(e,f,t),s(e,Ie,t),s(e,j,t),s(e,Ce,t),s(e,b,t),s(e,ve,t),h(I,e,t),s(e,Ge,t),s(e,C,t),s(e,Ze,t),s(e,v,t),s(e,Be,t),h(G,e,t),s(e,Ae,t),s(e,Z,t),s(e,Ve,t),s(e,B,t),s(e,Xe,t),h(A,e,t),s(e,$e,t),s(e,V,t),s(e,We,t),h(X,e,t),s(e,He,t),h($,e,t),s(e,xe,t),s(e,W,t),s(e,Re,t),s(e,H,t),s(e,Se,t),s(e,x,t),s(e,ke,t),h(R,e,t),s(e,Qe,t),s(e,S,t),s(e,Ee,t),h(k,e,t),s(e,_e,t),s(e,Q,t),s(e,Ne,t),h(E,e,t),s(e,Fe,t),s(e,_,t),s(e,Ye,t),s(e,N,t),s(e,Le,t),s(e,F,t),s(e,qe,t),h(Y,e,t),s(e,ze,t),s(e,L,t),s(e,Pe,t),s(e,q,t),s(e,De,t),s(e,z,t),s(e,Ke,t),h(P,e,t),s(e,Oe,t),s(e,D,t),s(e,et,t),s(e,K,t),s(e,tt,t),h(O,e,t),s(e,lt,t),h(ee,e,t),s(e,st,t),s(e,te,t),s(e,nt,t),h(le,e,t),s(e,at,t),h(se,e,t),s(e,ot,t),s(e,ne,t),s(e,it,t),h(ae,e,t),s(e,rt,t),h(oe,e,t),s(e,Mt,t),s(e,ie,t),s(e,pt,t),s(e,re,t),s(e,ht,t),s(e,Me,t),s(e,ct,t),h(pe,e,t),s(e,dt,t),s(e,he,t),s(e,yt,t),h(ce,e,t),s(e,ut,t),s(e,de,t),s(e,mt,t),h(ye,e,t),s(e,gt,t),s(e,ge,t),Tt=!0},p:tl,i(e){Tt||(c(g.$$.fragment,e),c(I.$$.fragment,e),c(G.$$.fragment,e),c(A.$$.fragment,e),c(X.$$.fragment,e),c($.$$.fragment,e),c(R.$$.fragment,e),c(k.$$.fragment,e),c(E.$$.fragment,e),c(Y.$$.fragment,e),c(P.$$.fragment,e),c(O.$$.fragment,e),c(ee.$$.fragment,e),c(le.$$.fragment,e),c(se.$$.fragment,e),c(ae.$$.fragment,e),c(oe.$$.fragment,e),c(pe.$$.fragment,e),c(ce.$$.fragment,e),c(ye.$$.fragment,e),Tt=!0)},o(e){d(g.$$.fragment,e),d(I.$$.fragment,e),d(G.$$.fragment,e),d(A.$$.fragment,e),d(X.$$.fragment,e),d($.$$.fragment,e),d(R.$$.fragment,e),d(k.$$.fragment,e),d(E.$$.fragment,e),d(Y.$$.fragment,e),d(P.$$.fragment,e),d(O.$$.fragment,e),d(ee.$$.fragment,e),d(le.$$.fragment,e),d(se.$$.fragment,e),d(ae.$$.fragment,e),d(oe.$$.fragment,e),d(pe.$$.fragment,e),d(ce.$$.fragment,e),d(ye.$$.fragment,e),Tt=!1},d(e){e&&(l(Te),l(me),l(we),l(Je),l(T),l(Ue),l(w),l(fe),l(J),l(je),l(U),l(be),l(f),l(Ie),l(j),l(Ce),l(b),l(ve),l(Ge),l(C),l(Ze),l(v),l(Be),l(Ae),l(Z),l(Ve),l(B),l(Xe),l($e),l(V),l(We),l(He),l(xe),l(W),l(Re),l(H),l(Se),l(x),l(ke),l(Qe),l(S),l(Ee),l(_e),l(Q),l(Ne),l(Fe),l(_),l(Ye),l(N),l(Le),l(F),l(qe),l(ze),l(L),l(Pe),l(q),l(De),l(z),l(Ke),l(Oe),l(D),l(et),l(K),l(tt),l(lt),l(st),l(te),l(nt),l(at),l(ot),l(ne),l(it),l(rt),l(Mt),l(ie),l(pt),l(re),l(ht),l(Me),l(ct),l(dt),l(he),l(yt),l(ut),l(de),l(mt),l(gt),l(ge)),l(m),y(g,e),y(I,e),y(G,e),y(A,e),y(X,e),y($,e),y(R,e),y(k,e),y(E,e),y(Y,e),y(P,e),y(O,e),y(ee,e),y(le,e),y(se,e),y(ae,e),y(oe,e),y(pe,e),y(ce,e),y(ye,e)}}}const Ml='{"title":"Tools","local":"tools","sections":[{"title":"Tool Creation Methods","local":"tool-creation-methods","sections":[{"title":"The @tool Decorator","local":"the-tool-decorator","sections":[{"title":"Generating a tool that retrieves the highest-rated catering","local":"generating-a-tool-that-retrieves-the-highest-rated-catering","sections":[],"depth":4}],"depth":3},{"title":"Defining a Tool as a Python Class","local":"defining-a-tool-as-a-python-class","sections":[{"title":"Generating a tool to generate ideas about the superhero-themed party","local":"generating-a-tool-to-generate-ideas-about-the-superhero-themed-party","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Default Toolbox","local":"default-toolbox","sections":[],"depth":2},{"title":"Sharing and Importing Tools","local":"sharing-and-importing-tools","sections":[{"title":"Sharing a Tool to the Hub","local":"sharing-a-tool-to-the-hub","sections":[],"depth":3},{"title":"Importing a Tool from the Hub","local":"importing-a-tool-from-the-hub","sections":[],"depth":3},{"title":"Importing a Hugging Face Space as a Tool","local":"importing-a-hugging-face-space-as-a-tool","sections":[],"depth":3},{"title":"Importing a LangChain Tool","local":"importing-a-langchain-tool","sections":[],"depth":3}],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function pl(wt){return ll(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ml extends sl{constructor(m){super(),nl(this,m,pl,rl,el,{})}}export{ml as component};
