import{s as Qo,o as Wo,n as No}from"../chunks/scheduler.f6b352c8.js";import{S as So,i as Ro,g as i,s as n,r,m as Go,A as Xo,h as o,f as s,c as a,j as k,u as c,x as p,n as zo,k as w,y as j,a as l,v as u,d as M,t as h,w as y}from"../chunks/index.b90df637.js";import{T as Yo}from"../chunks/Tip.366d2e6e.js";import{C as m}from"../chunks/CodeBlock.e5718f9d.js";import{H as T,E as Vo}from"../chunks/getInferenceSnippets.1e3ae0bf.js";function Po(As){let d,E='If you have any questions or need help, please reach out on <a href="https://discord.com/invite/s3KuuzsPFb" rel="nofollow">Discord</a>.';return{c(){d=i("p"),d.innerHTML=E},l(J){d=o(J,"P",{"data-svelte-h":!0}),p(d)!=="svelte-aht5b3"&&(d.innerHTML=E)},m(J,fs){l(J,d,fs)},p:No,d(J){J&&s(d)}}}function Fo(As){let d,E,J,fs,q,_s,Q,$a="In this tutorial you will go through the full Human-in-the-Loop Sample-Efficient Reinforcement Learning (HIL-SERL) workflow using LeRobot. You will master training a policy with RL on a real robot in just a few hours.",xs,W,Za="HIL-SERL is a sample-efficient reinforcement learning algorithm that combines human demonstrations with online learning and human interventions. The approach starts from a small set of human demonstrations, uses them to train a reward classifier, and then employs an actor-learner architecture where humans can intervene during policy execution to guide exploration and correct unsafe behaviors. In this tutorial, you’ll use a gamepad to provide interventions and control the robot during the learning process.",$s,N,La="It combines three key ingredients: 1. <strong>Offline demonstrations &amp; reward classifier:</strong> a handful of human-teleop episodes plus a vision-based success detector give the policy a shaped starting point. 2. <strong>On-robot actor / learner loop with human interventions:</strong> a distributed Soft Actor Critic (SAC) learner updates the policy while an actor explores on the physical robot; the human can jump in at any time to correct dangerous or unproductive behaviour. 3. <strong>Safety &amp; efficiency tools:</strong> joint/end-effector (EE) bounds, crop region of interest (ROI) preprocessing and WandB monitoring keep the data useful and the hardware safe.",Zs,S,Ha="Together these elements let HIL-SERL reach near-perfect task success and faster cycle times than imitation-only baselines.",Ls,g,Ba='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/lerobot/hilserl-main-figure.png" alt="HIL-SERL workflow" title="HIL-SERL workflow" width="100%"/>',Hs,I,ka="<i>HIL-SERL workflow, Luo et al. 2024</i>",Bs,R,Ea="This guide provides step-by-step instructions for training a robot policy using LeRobot’s HilSerl implementation to train on a real robot.",ks,G,Es,X,qa="<li>A gamepad (recommended) or keyboard to control the robot</li> <li>A Nvidia GPU</li> <li>A real robot with a follower and leader arm (optional if you use the keyboard or the gamepad)</li> <li>A URDF file for the robot for the kinematics package (check <code>lerobot/model/kinematics.py</code>)</li>",qs,z,Qs,Y,Qa="One can use HIL-SERL to train on a variety of manipulation tasks. Some recommendations:",Ws,V,Wa="<li>Start with a simple task to understand how the system works.<ul><li>Push cube to a goal region</li> <li>Pick and lift cube with the gripper</li></ul></li> <li>Avoid extremely long horizon tasks. Focus on tasks that can be completed in 5-10 seconds.</li> <li>Once you have a good idea of how the system works, you can try more complex tasks and longer horizons.<ul><li>Pick and place cube</li> <li>Bimanual tasks to pick objects with two arms</li> <li>Hand-over tasks to transfer objects from one arm to another</li> <li>Go crazy!</li></ul></li>",Ns,P,Ss,F,Na="To install LeRobot with HIL-SERL, you need to install the <code>hilserl</code> extra.",Rs,D,Gs,O,Xs,K,zs,tt,Sa="The training process begins with proper configuration for the HILSerl environment. The main configuration class is <code>GymManipulatorConfig</code> in <code>lerobot/scripts/rl/gym_manipulator.py</code>, which contains nested <code>HILSerlRobotEnvConfig</code> and <code>DatasetConfig</code>. The configuration is organized into focused, nested sub-configs:",Ys,et,Vs,st,Ps,lt,Ra="Before collecting demonstrations, you need to determine the appropriate operational bounds for your robot.",Fs,nt,Ga="This helps simplify the problem of learning on the real robot in two ways: 1) by limiting the robot’s operational space to a specific region that solves the task and avoids unnecessary or unsafe exploration, and 2) by allowing training in end-effector space rather than joint space. Empirically, learning in joint space for reinforcement learning in manipulation is often a harder problem - some tasks are nearly impossible to learn in joint space but become learnable when the action space is transformed to end-effector coordinates.",Ds,at,Xa="<strong>Using find_joint_limits.py</strong>",Os,it,za=`This script helps you find the safe operational bounds for your robot’s end-effector. Given that you have a follower and leader arm, you can use the script to find the bounds for the follower arm that will be applied during training.
Bounding the action space will reduce the redundant exploration of the agent and guarantees safety.`,Ks,ot,tl,pt,Ya="<strong>Workflow</strong>",el,U,ws,Va="Run the script and move the robot through the space that solves the task",Ja,Js,Ua,rt,Ca,Us,Pa="Use these values in the configuration of your teleoperation device (TeleoperatorConfig) under the <code>end_effector_bounds</code> field",sl,ct,Fa="<strong>Example Configuration</strong>",ll,ut,nl,Mt,al,ht,Da="With the bounds defined, you can safely collect demonstrations for training. Training RL with off-policy algorithm allows us to use offline datasets collected in order to improve the efficiency of the learning process.",il,yt,Oa="<strong>Setting Up Record Mode</strong>",ol,mt,Ka='Create a configuration file for recording demonstrations (or edit an existing one like <a href="https://huggingface.co/datasets/aractingi/lerobot-example-config-files/blob/main/env_config_so100.json" rel="nofollow">env_config_so100.json</a>):',pl,jt,ti="<li>Set <code>mode</code> to <code>&quot;record&quot;</code> at the root level</li> <li>Specify a unique <code>repo_id</code> for your dataset in the <code>dataset</code> section (e.g., “username/task_name”)</li> <li>Set <code>num_episodes</code> in the <code>dataset</code> section to the number of demonstrations you want to collect</li> <li>Set <code>env.processor.image_preprocessing.crop_params_dict</code> to <code>{}</code> initially (we’ll determine crops later)</li> <li>Configure <code>env.robot</code>, <code>env.teleop</code>, and other hardware settings in the <code>env</code> section</li>",rl,dt,ei="Example configuration section:",cl,Tt,ul,ft,Ml,wt,si=`Along with your robot, you will need a teleoperation device to control it in order to collect datasets of your task and perform interventions during the online training.
We support using a gamepad or a keyboard or the leader arm of the robot.`,hl,Jt,li="HIL-Serl learns actions in the end-effector space of the robot. Therefore, the teleoperation will control the end-effector’s x,y,z displacements.",yl,Ut,ni="For that we need to define a version of the robot that takes actions in the end-effector space. Check the robot class <code>SO100FollowerEndEffector</code> and its configuration <code>SO100FollowerEndEffectorConfig</code> for the default parameters related to the end-effector space.",ml,Ct,jl,gt,ai="The <code>Teleoperator</code> defines the teleoperation device. You can check the list of available teleoperators in <code>lerobot/teleoperators</code>.",dl,It,ii="<strong>Setting up the Gamepad</strong>",Tl,bt,oi="The gamepad provides a very convenient way to control the robot and the episode state.",fl,vt,pi="To setup the gamepad, you need to set the <code>control_mode</code> to <code>&quot;gamepad&quot;</code> and define the <code>teleop</code> section in the configuration file.",wl,At,Jl,b,ri='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/lerobot/gamepad_guide.jpg?raw=true" alt="Figure shows the control mappings on a Logitech gamepad." title="Gamepad Control Mapping" width="100%"/>',Ul,v,ci="<i>Gamepad button mapping for robot control and episode management</i>",Cl,_t,ui="<strong>Setting up the SO101 leader</strong>",gl,xt,Mi="The SO101 leader arm has reduced gears that allows it to move and track the follower arm during exploration. Therefore, taking over is much smoother than the gearless SO100.",Il,$t,hi="To setup the SO101 leader, you need to set the <code>control_mode</code> to <code>&quot;leader&quot;</code> and define the <code>teleop</code> section in the configuration file.",bl,Zt,vl,Lt,yi=`In order to annotate the success/failure of the episode, <strong>you will need</strong> to use a keyboard to press <code>s</code> for success, <code>esc</code> for failure.
During the online training, press <code>space</code> to take over the policy and <code>space</code> again to give the control back to the policy.`,Al,Ht,mi='<summary><strong>Video: SO101 leader teleoperation</strong></summary> <div class="video-container"><video controls="" width="600"><source src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/lerobot/so101_leader_tutorial.mp4" type="video/mp4"/></video></div> <p align="center"><i>SO101 leader teleoperation example, the leader tracks the follower, press `space` to intervene</i></p>',_l,Bt,ji="<strong>Recording Demonstrations</strong>",xl,kt,di='Start the recording process, an example of the config file can be found <a href="https://huggingface.co/datasets/aractingi/lerobot-example-config-files/blob/main/env_config_so100.json" rel="nofollow">here</a>:',$l,Et,Zl,qt,Ti="During recording:",Ll,Qt,fi="<li>The robot will reset to the initial position defined in the configuration file <code>env.processor.reset.fixed_reset_joint_positions</code></li> <li>Complete the task successfully</li> <li>The episode ends with a reward of 1 when you press the “success” button</li> <li>If the time limit is reached, or the fail button is pressed, the episode ends with a reward of 0</li> <li>You can rerecord an episode by pressing the “rerecord” button</li> <li>The process automatically continues to the next episode</li> <li>After recording all episodes, the dataset is pushed to the Hugging Face Hub (optional) and saved locally</li>",Hl,Wt,Bl,Nt,wi=`After collecting demonstrations, process them to determine optimal camera crops.
Reinforcement learning is sensitive to background distractions, so it is important to crop the images to the relevant workspace area.`,kl,St,Ji="Visual RL algorithms learn directly from pixel inputs, making them vulnerable to irrelevant visual information. Background elements like changing lighting, shadows, people moving, or objects outside the workspace can confuse the learning process. Good ROI selection should:",El,Rt,Ui="<li>Include only the essential workspace where the task happens</li> <li>Capture the robot’s end-effector and all objects involved in the task</li> <li>Exclude unnecessary background elements and distractions</li>",ql,Gt,Ci="Note: If you already know the crop parameters, you can skip this step and just set the <code>crop_params_dict</code> in the configuration file during recording.",Ql,Xt,gi="<strong>Determining Crop Parameters</strong>",Wl,zt,Ii="Use the <code>crop_dataset_roi.py</code> script to interactively select regions of interest in your camera images:",Nl,Yt,Sl,Vt,bi="<li>For each camera view, the script will display the first frame</li> <li>Draw a rectangle around the relevant workspace area</li> <li>Press ‘c’ to confirm the selection</li> <li>Repeat for all camera views</li> <li>The script outputs cropping parameters and creates a new cropped dataset</li>",Rl,Pt,vi="Example output:",Gl,Ft,Xl,A,Ai='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/lerobot/crop_dataset.gif" width="600"/>',zl,_,_i="<i>Interactive cropping tool for selecting regions of interest</i>",Yl,Dt,xi="<strong>Updating Configuration</strong>",Vl,Ot,$i="Add these crop parameters to your training configuration:",Pl,Kt,Fl,te,Zi="<strong>Recommended image resolution</strong>",Dl,ee,Li="Most vision-based policies have been validated on square inputs of either <strong>128×128</strong> (default) or <strong>64×64</strong> pixels. We therefore advise setting the resize_size parameter to [128, 128] – or [64, 64] if you need to save GPU memory and bandwidth. Other resolutions are possible but have not been extensively tested.",Ol,se,Kl,le,Hi="The reward classifier plays an important role in the HIL-SERL workflow by automating reward assignment and automatically detecting episode success. Instead of manually defining reward functions or relying on human feedback for every timestep, the reward classifier learns to predict success/failure from visual observations. This enables the RL algorithm to learn efficiently by providing consistent and automated reward signals based on the robot’s camera inputs.",tn,ne,Bi="This guide explains how to train a reward classifier for human-in-the-loop reinforcement learning implementation of LeRobot. Reward classifiers learn to predict the reward value given a state which can be used in an RL setup to train a policy.",en,ae,ki="<strong>Note</strong>: Training a reward classifier is optional. You can start the first round of RL experiments by annotating the success manually with your gamepad or keyboard device.",sn,ie,Ei="The reward classifier implementation in <code>modeling_classifier.py</code> uses a pretrained vision model to process the images. It can output either a single value for binary rewards to predict success/fail cases or multiple values for multi-class settings.",ln,oe,qi="<strong>Collecting a Dataset for the reward classifier</strong>",nn,pe,Qi="Before training, you need to collect a dataset with labeled examples. The <code>record_dataset</code> function in <code>gym_manipulator.py</code> enables the process of collecting a dataset of observations, actions, and rewards.",an,re,Wi="To collect a dataset, you need to modify some parameters in the environment configuration based on HILSerlRobotEnvConfig.",on,ce,pn,ue,Ni="<strong>Key Parameters for Data Collection</strong>",rn,Me,Si="<li><strong>mode</strong>: set it to <code>&quot;record&quot;</code> to collect a dataset (at root level)</li> <li><strong>dataset.repo_id</strong>: <code>&quot;hf_username/dataset_name&quot;</code>, name of the dataset and repo on the hub</li> <li><strong>dataset.num_episodes</strong>: Number of episodes to record</li> <li><strong>env.processor.reset.number_of_steps_after_success</strong>: Number of additional frames to record after a success (reward=1) is detected</li> <li><strong>env.fps</strong>: Number of frames per second to record</li> <li><strong>dataset.push_to_hub</strong>: Whether to push the dataset to the hub</li>",cn,he,Ri="The <code>env.processor.reset.number_of_steps_after_success</code> parameter is crucial as it allows you to collect more positive examples. When a success is detected, the system will continue recording for the specified number of steps while maintaining the reward=1 label. Otherwise, there won’t be enough states in the dataset labeled to 1 to train a good classifier.",un,ye,Gi="Example configuration section for data collection:",Mn,me,hn,je,Xi="<strong>Reward Classifier Configuration</strong>",yn,de,zi="The reward classifier is configured using <code>configuration_classifier.py</code>. Here are the key parameters:",mn,Te,Yi="<li><strong>model_name</strong>: Base model architecture (e.g., we mainly use <code>&quot;helper2424/resnet10&quot;</code>)</li> <li><strong>model_type</strong>: <code>&quot;cnn&quot;</code> or <code>&quot;transformer&quot;</code></li> <li><strong>num_cameras</strong>: Number of camera inputs</li> <li><strong>num_classes</strong>: Number of output classes (typically 2 for binary success/failure)</li> <li><strong>hidden_dim</strong>: Size of hidden representation</li> <li><strong>dropout_rate</strong>: Regularization parameter</li> <li><strong>learning_rate</strong>: Learning rate for optimizer</li>",jn,fe,Vi='Example configuration for training the <a href="https://huggingface.co/datasets/aractingi/lerobot-example-config-files/blob/main/reward_classifier_train_config.json" rel="nofollow">reward classifier</a>:',dn,we,Tn,Je,Pi="<strong>Training the Classifier</strong>",fn,Ue,Fi="To train the classifier, use the <code>train.py</code> script with your configuration:",wn,Ce,Jn,ge,Di="<strong>Deploying and Testing the Model</strong>",Un,Ie,Oi="To use your trained reward classifier, configure the <code>HILSerlRobotEnvConfig</code> to use your model:",Cn,be,gn,ve,Ki="or set the argument in the json config file.",In,Ae,bn,_e,to="Run <code>gym_manipulator.py</code> to test the model.",vn,xe,An,$e,eo="The reward classifier will automatically provide rewards based on the visual input from the robot’s cameras.",_n,Ze,so="<strong>Example Workflow for training the reward classifier</strong>",xn,f,Cs,lo=`<p><strong>Create the configuration files</strong>:
Create the necessary json configuration files for the reward classifier and the environment. Check the examples <a href="https://huggingface.co/datasets/aractingi/lerobot-example-config-files/tree/main" rel="nofollow">here</a>.</p>`,ga,Le,gs,no="<strong>Collect a dataset</strong>:",Ia,He,ba,Be,Is,ao="<strong>Train the classifier</strong>:",va,ke,Aa,Ee,bs,io="<strong>Test the classifier</strong>:",_a,qe,$n,Qe,Zn,We,oo="The LeRobot system uses a distributed actor-learner architecture for training. This architecture decouples robot interactions from the learning process, allowing them to run concurrently without blocking each other. The actor server handles robot observations and actions, sending interaction data to the learner server. The learner server performs gradient descent and periodically updates the actor’s policy weights. You will need to start two processes: a learner and an actor.",Ln,Ne,po="<strong>Configuration Setup</strong>",Hn,Se,ro='Create a training configuration file (example available <a href="https://huggingface.co/datasets/aractingi/lerobot-example-config-files/blob/main/train_config_hilserl_so100.json" rel="nofollow">here</a>). The training config is based on the main <code>TrainRLServerPipelineConfig</code> class in <code>lerobot/configs/train.py</code>.',Bn,Re,co='<li>Configure the policy settings (<code>type=&quot;sac&quot;</code>, <code>device</code>, etc.)</li> <li>Set <code>dataset</code> to your cropped dataset</li> <li>Configure environment settings with crop parameters</li> <li>Check the other parameters related to SAC in <a href="https://github.com/huggingface/lerobot/blob/main/src/lerobot/policies/sac/configuration_sac.py#L79" rel="nofollow">configuration_sac.py</a>.</li> <li>Verify that the <code>policy</code> config is correct with the right <code>input_features</code> and <code>output_features</code> for your task.</li>',kn,Ge,uo="<strong>Starting the Learner</strong>",En,Xe,Mo="First, start the learner server process:",qn,ze,Qn,Ye,ho="The learner:",Wn,Ve,yo="<li>Initializes the policy network</li> <li>Prepares replay buffers</li> <li>Opens a <code>gRPC</code> server to communicate with actors</li> <li>Processes transitions and updates the policy</li>",Nn,Pe,mo="<strong>Starting the Actor</strong>",Sn,Fe,jo="In a separate terminal, start the actor process with the same configuration:",Rn,De,Gn,Oe,To="The actor:",Xn,Ke,fo="<li>Connects to the learner via <code>gRPC</code></li> <li>Initializes the environment</li> <li>Execute rollouts of the policy to collect experience</li> <li>Sends transitions to the learner</li> <li>Receives updated policy parameters</li>",zn,ts,wo="<strong>Training Flow</strong>",Yn,es,Jo="The training proceeds automatically:",Vn,ss,Uo="<li>The actor executes the policy in the environment</li> <li>Transitions are collected and sent to the learner</li> <li>The learner updates the policy based on these transitions</li> <li>Updated policy parameters are sent back to the actor</li> <li>The process continues until the specified step limit is reached</li>",Pn,ls,Co="<strong>Human in the Loop</strong>",Fn,ns,go="<li>The key to learning efficiently is to have human interventions to provide corrective feedback and completing the task to aide the policy learning and exploration.</li> <li>To perform human interventions, you can press the upper right trigger button on the gamepad (or the <code>space</code> key on the keyboard). This will pause the policy actions and allow you to take over.</li> <li>A successful experiment is one where the human has to intervene at the start but then reduces the amount of interventions as the policy improves. You can monitor the intervention rate in the <code>wandb</code> dashboard.</li>",Dn,x,Io='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/lerobot/hil_effect.png?raw=true" alt="Figure shows the control mappings on a Logitech gamepad." title="Gamepad Control Mapping" width="100%"/>',On,$,bo="<i>Example showing how human interventions help guide policy learning over time</i>",Kn,as,vo="<li>The figure shows the plot of the episodic reward over interaction step. The figure shows the effect of human interventions on the policy learning.</li> <li>The orange curve is an experiment without any human interventions. While the pink and blue curves are experiments with human interventions.</li> <li>We can observe that the number of steps where the policy starts achieving the maximum reward is cut by a quarter when human interventions are present.</li>",ta,is,Ao="<strong>Monitoring and Debugging</strong>",ea,os,_o='If you have <code>wandb.enable</code> set to <code>true</code> in your configuration, you can monitor training progress in real-time through the <a href="https://wandb.ai/site/" rel="nofollow">Weights &amp; Biases</a> dashboard.',sa,ps,la,rs,xo="The learning process is very sensitive to the intervention strategy. It will takes a few runs to understand how to intervene effectively. Some tips and hints:",na,cs,$o="<li>Allow the policy to explore for a few episodes at the start of training.</li> <li>Avoid intervening for long periods of time. Try to intervene in situation to correct the robot’s behaviour when it goes off track.</li> <li>Once the policy starts achieving the task, even if its not perfect, you can limit your interventions to simple quick actions like a simple grasping commands.</li>",aa,us,Zo="The ideal behaviour is that your intervention rate should drop gradually during training as shown in the figure below.",ia,Z,Lo='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/lerobot/intervention_rate_tutorial_rl.png?raw=true" alt="Intervention rate" title="Intervention rate during training" width="100%"/>',oa,L,Ho=`<i>Plot of the intervention rate during a training run on a pick and lift cube
    task</i>`,pa,Ms,ra,hs,Bo="Some configuration values have a disproportionate impact on training stability and speed:",ca,ys,ko="<li><strong><code>temperature_init</code></strong> (<code>policy.temperature_init</code>) – initial entropy temperature in SAC. Higher values encourage more exploration; lower values make the policy more deterministic early on. A good starting point is <code>1e-2</code>. We observed that setting it too high can make human interventions ineffective and slow down learning.</li> <li><strong><code>policy_parameters_push_frequency</code></strong> (<code>policy.actor_learner_config.policy_parameters_push_frequency</code>) – interval in <em>seconds</em> between two weight pushes from the learner to the actor. The default is <code>4 s</code>. Decrease to <strong>1-2 s</strong> to provide fresher weights (at the cost of more network traffic); increase only if your connection is slow, as this will reduce sample efficiency.</li> <li><strong><code>storage_device</code></strong> (<code>policy.storage_device</code>) – device on which the learner keeps the policy parameters. If you have spare GPU memory, set this to <code>&quot;cuda&quot;</code> (instead of the default <code>&quot;cpu&quot;</code>). Keeping the weights on-GPU removes CPU→GPU transfer overhead and can significantly increase the number of learner updates per second.</li>",ua,ms,Eo="Congrats 🎉, you have finished this tutorial!",Ma,H,ha,js,qo="Paper citation:",ya,ds,ma,Ts,ja,vs,da;return q=new T({props:{title:"HIL-SERL Real Robot Training Workflow Guide",local:"hil-serl-real-robot-training-workflow-guide",headingTag:"h1"}}),G=new T({props:{title:"What do I need?",local:"what-do-i-need",headingTag:"h2"}}),z=new T({props:{title:"What kind of tasks can I train?",local:"what-kind-of-tasks-can-i-train",headingTag:"h2"}}),P=new T({props:{title:"Install LeRobot with HIL-SERL",local:"install-lerobot-with-hil-serl",headingTag:"h2"}}),D=new m({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1lJTIwJTIyLiU1QmhpbHNlcmwlNUQlMjI=",highlighted:'pip install -e <span class="hljs-string">&quot;.[hilserl]&quot;</span>',wrap:!1}}),O=new T({props:{title:"Real Robot Training Workflow",local:"real-robot-training-workflow",headingTag:"h2"}}),K=new T({props:{title:"Understanding Configuration",local:"understanding-configuration",headingTag:"h3"}}),et=new m({props:{code:"Y2xhc3MlMjBHeW1NYW5pcHVsYXRvckNvbmZpZyUzQSUwQSUyMCUyMCUyMCUyMGVudiUzQSUyMEhJTFNlcmxSb2JvdEVudkNvbmZpZyUyMCUyMCUyMCUyMCUyMyUyMEVudmlyb25tZW50JTIwY29uZmlndXJhdGlvbiUyMChuZXN0ZWQpJTBBJTIwJTIwJTIwJTIwZGF0YXNldCUzQSUyMERhdGFzZXRDb25maWclMjAlMjAlMjAlMjAlMjMlMjBEYXRhc2V0JTIwcmVjb3JkaW5nJTJGcmVwbGF5JTIwY29uZmlndXJhdGlvbiUyMChuZXN0ZWQpJTBBJTIwJTIwJTIwJTIwbW9kZSUzQSUyMHN0ciUyMCU3QyUyME5vbmUlMjAlM0QlMjBOb25lJTIwJTIwJTIwJTIwJTIzJTIwJTIycmVjb3JkJTIyJTJDJTIwJTIycmVwbGF5JTIyJTJDJTIwb3IlMjBOb25lJTIwKGZvciUyMHRyYWluaW5nKSUwQSUwQWNsYXNzJTIwSElMU2VybFJvYm90RW52Q29uZmlnKEVudkNvbmZpZyklM0ElMEElMjAlMjAlMjAlMjByb2JvdCUzQSUyMFJvYm90Q29uZmlnJTIwJTdDJTIwTm9uZSUyMCUzRCUyME5vbmUlMjAlMjAlMjAlMjAlMjMlMjBNYWluJTIwcm9ib3QlMjBhZ2VudCUyMChkZWZpbmVkJTIwaW4lMjAlNjBsZXJvYm90JTJGcm9ib3RzJTYwKSUwQSUyMCUyMCUyMCUyMHRlbGVvcCUzQSUyMFRlbGVvcGVyYXRvckNvbmZpZyUyMCU3QyUyME5vbmUlMjAlM0QlMjBOb25lJTIwJTIwJTIwJTIwJTIzJTIwVGVsZW9wZXJhdG9yJTIwYWdlbnQlMkMlMjBlLmcuJTJDJTIwZ2FtZXBhZCUyMG9yJTIwbGVhZGVyJTIwYXJtJTBBJTIwJTIwJTIwJTIwcHJvY2Vzc29yJTNBJTIwSElMU2VybFByb2Nlc3NvckNvbmZpZyUyMCUyMCUyMCUyMCUyMyUyMFByb2Nlc3NpbmclMjBwaXBlbGluZSUyMGNvbmZpZ3VyYXRpb24lMjAobmVzdGVkKSUwQSUyMCUyMCUyMCUyMG5hbWUlM0ElMjBzdHIlMjAlM0QlMjAlMjJyZWFsX3JvYm90JTIyJTIwJTIwJTIwJTIwJTIzJTIwRW52aXJvbm1lbnQlMjBuYW1lJTBBJTIwJTIwJTIwJTIwZGV2aWNlJTNBJTIwc3RyJTIwJTNEJTIwJTIyY3VkYSUyMiUyMCUyMCUyMCUyMCUyMyUyMENvbXB1dGUlMjBkZXZpY2UlMEElMjAlMjAlMjAlMjBmcHMlM0ElMjBpbnQlMjAlM0QlMjAzMCUyMCUyMCUyMCUyMCUyMyUyMENvbnRyb2wlMjBmcmVxdWVuY3klMEElMEElMjMlMjBOZXN0ZWQlMjBwcm9jZXNzb3IlMjBjb25maWd1cmF0aW9uJTBBY2xhc3MlMjBISUxTZXJsUHJvY2Vzc29yQ29uZmlnJTNBJTBBJTIwJTIwJTIwJTIwY29udHJvbF9tb2RlJTNBJTIwc3RyJTIwJTNEJTIwJTIyZ2FtZXBhZCUyMiUyMCUyMCUyMCUyMCUyMyUyMENvbnRyb2wlMjBtb2RlJTBBJTIwJTIwJTIwJTIwb2JzZXJ2YXRpb24lM0ElMjBPYnNlcnZhdGlvbkNvbmZpZyUyMCUyMCUyMCUyMCUyMyUyME9ic2VydmF0aW9uJTIwcHJvY2Vzc2luZyUyMHNldHRpbmdzJTBBJTIwJTIwJTIwJTIwaW1hZ2VfcHJlcHJvY2Vzc2luZyUzQSUyMEltYWdlUHJlcHJvY2Vzc2luZ0NvbmZpZyUyMCUyMCUyMCUyMCUyMyUyMEltYWdlJTIwY3JvcCUyRnJlc2l6ZSUyMHNldHRpbmdzJTBBJTIwJTIwJTIwJTIwZ3JpcHBlciUzQSUyMEdyaXBwZXJDb25maWclMjAlMjAlMjAlMjAlMjMlMjBHcmlwcGVyJTIwY29udHJvbCUyMGFuZCUyMHBlbmFsdHklMjBzZXR0aW5ncyUwQSUyMCUyMCUyMCUyMHJlc2V0JTNBJTIwUmVzZXRDb25maWclMjAlMjAlMjAlMjAlMjMlMjBFbnZpcm9ubWVudCUyMHJlc2V0JTIwYW5kJTIwdGltaW5nJTIwc2V0dGluZ3MlMEElMjAlMjAlMjAlMjBpbnZlcnNlX2tpbmVtYXRpY3MlM0ElMjBJbnZlcnNlS2luZW1hdGljc0NvbmZpZyUyMCUyMCUyMCUyMCUyMyUyMElLJTIwcHJvY2Vzc2luZyUyMHNldHRpbmdzJTBBJTIwJTIwJTIwJTIwcmV3YXJkX2NsYXNzaWZpZXIlM0ElMjBSZXdhcmRDbGFzc2lmaWVyQ29uZmlnJTIwJTIwJTIwJTIwJTIzJTIwUmV3YXJkJTIwY2xhc3NpZmllciUyMHNldHRpbmdzJTBBJTBBJTIzJTIwRGF0YXNldCUyMGNvbmZpZ3VyYXRpb24lMEFjbGFzcyUyMERhdGFzZXRDb25maWclM0ElMEElMjAlMjAlMjAlMjByZXBvX2lkJTNBJTIwc3RyJTIwJTIwJTIwJTIwJTIzJTIwTGVSb2JvdCUyMGRhdGFzZXQlMjByZXBvc2l0b3J5JTIwSUQlMEElMjAlMjAlMjAlMjBkYXRhc2V0X3Jvb3QlM0ElMjBzdHIlMjAlN0MlMjBOb25lJTIwJTNEJTIwTm9uZSUyMCUyMCUyMCUyMCUyMyUyMExvY2FsJTIwZGF0YXNldCUyMHJvb3QlMjAob3B0aW9uYWwpJTBBJTIwJTIwJTIwJTIwdGFzayUzQSUyMHN0ciUyMCUyMCUyMCUyMCUyMyUyMFRhc2slMjBpZGVudGlmaWVyJTBBJTIwJTIwJTIwJTIwbnVtX2VwaXNvZGVzJTNBJTIwaW50JTIwJTIwJTIwJTIwJTIzJTIwTnVtYmVyJTIwb2YlMjBlcGlzb2RlcyUyMGZvciUyMHJlY29yZGluZyUwQSUyMCUyMCUyMCUyMGVwaXNvZGUlM0ElMjBpbnQlMjAlMjAlMjAlMjAlMjMlMjBFcGlzb2RlJTIwaW5kZXglMjBmb3IlMjByZXBsYXklMEElMjAlMjAlMjAlMjBwdXNoX3RvX2h1YiUzQSUyMGJvb2wlMjAlMjAlMjAlMjAlMjMlMjBXaGV0aGVyJTIwdG8lMjBwdXNoJTIwZGF0YXNldHMlMjB0byUyMEh1Yg==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">GymManipulatorConfig</span>:
    env: HILSerlRobotEnvConfig    <span class="hljs-comment"># Environment configuration (nested)</span>
    dataset: DatasetConfig    <span class="hljs-comment"># Dataset recording/replay configuration (nested)</span>
    mode: <span class="hljs-built_in">str</span> | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># &quot;record&quot;, &quot;replay&quot;, or None (for training)</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">HILSerlRobotEnvConfig</span>(<span class="hljs-title class_ inherited__">EnvConfig</span>):
    robot: RobotConfig | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># Main robot agent (defined in \`lerobot/robots\`)</span>
    teleop: TeleoperatorConfig | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># Teleoperator agent, e.g., gamepad or leader arm</span>
    processor: HILSerlProcessorConfig    <span class="hljs-comment"># Processing pipeline configuration (nested)</span>
    name: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;real_robot&quot;</span>    <span class="hljs-comment"># Environment name</span>
    device: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;cuda&quot;</span>    <span class="hljs-comment"># Compute device</span>
    fps: <span class="hljs-built_in">int</span> = <span class="hljs-number">30</span>    <span class="hljs-comment"># Control frequency</span>

<span class="hljs-comment"># Nested processor configuration</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">HILSerlProcessorConfig</span>:
    control_mode: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;gamepad&quot;</span>    <span class="hljs-comment"># Control mode</span>
    observation: ObservationConfig    <span class="hljs-comment"># Observation processing settings</span>
    image_preprocessing: ImagePreprocessingConfig    <span class="hljs-comment"># Image crop/resize settings</span>
    gripper: GripperConfig    <span class="hljs-comment"># Gripper control and penalty settings</span>
    reset: ResetConfig    <span class="hljs-comment"># Environment reset and timing settings</span>
    inverse_kinematics: InverseKinematicsConfig    <span class="hljs-comment"># IK processing settings</span>
    reward_classifier: RewardClassifierConfig    <span class="hljs-comment"># Reward classifier settings</span>

<span class="hljs-comment"># Dataset configuration</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">DatasetConfig</span>:
    repo_id: <span class="hljs-built_in">str</span>    <span class="hljs-comment"># LeRobot dataset repository ID</span>
    dataset_root: <span class="hljs-built_in">str</span> | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># Local dataset root (optional)</span>
    task: <span class="hljs-built_in">str</span>    <span class="hljs-comment"># Task identifier</span>
    num_episodes: <span class="hljs-built_in">int</span>    <span class="hljs-comment"># Number of episodes for recording</span>
    episode: <span class="hljs-built_in">int</span>    <span class="hljs-comment"># Episode index for replay</span>
    push_to_hub: <span class="hljs-built_in">bool</span>    <span class="hljs-comment"># Whether to push datasets to Hub</span>`,wrap:!1}}),st=new T({props:{title:"Finding Robot Workspace Bounds",local:"finding-robot-workspace-bounds",headingTag:"h3"}}),ot=new m({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnNjcmlwdHMuZmluZF9qb2ludF9saW1pdHMlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXJvYm90LnR5cGUlM0RzbzEwMF9mb2xsb3dlciUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcm9ib3QucG9ydCUzRCUyRmRldiUyRnR0eS51c2Jtb2RlbTU4NzYwNDMxNTQxJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1yb2JvdC5pZCUzRGJsYWNrJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS10ZWxlb3AudHlwZSUzRHNvMTAwX2xlYWRlciUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tdGVsZW9wLnBvcnQlM0QlMkZkZXYlMkZ0dHkudXNibW9kZW01ODc2MDQzMTU1MSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tdGVsZW9wLmlkJTNEYmx1ZQ==",highlighted:`python -m lerobot.scripts.find_joint_limits \\
    --robot.type=so100_follower \\
    --robot.port=/dev/tty.usbmodem58760431541 \\
    --robot.id=black \\
    --teleop.type=so100_leader \\
    --teleop.port=/dev/tty.usbmodem58760431551 \\
    --teleop.id=blue`,wrap:!1}}),rt=new m({props:{code:"TWF4JTIwZWUlMjBwb3NpdGlvbiUyMCU1QjAuMjQxNyUyMDAuMjAxMiUyMDAuMTAyNyU1RCUwQU1pbiUyMGVlJTIwcG9zaXRpb24lMjAlNUIwLjE2NjMlMjAtMC4wODIzJTIwMC4wMzM2JTVEJTBBTWF4JTIwam9pbnQlMjBwb3NpdGlvbnMlMjAlNUItMjAuMCUyQyUyMC0yMC4wJTJDJTIwLTIwLjAlMkMlMjAtMjAuMCUyQyUyMC0yMC4wJTJDJTIwLTIwLjAlNUQlMEFNaW4lMjBqb2ludCUyMHBvc2l0aW9ucyUyMCU1QjUwLjAlMkMlMjA1MC4wJTJDJTIwNTAuMCUyQyUyMDUwLjAlMkMlMjA1MC4wJTJDJTIwNTAuMCU1RA==",highlighted:`Max ee position [0.2417 0.2012 0.1027]
Min ee position [0.1663 <span class="hljs-string">-0</span>.0823 0.0336]
Max joint positions [<span class="hljs-string">-20</span>.0, <span class="hljs-string">-20</span>.0, <span class="hljs-string">-20</span>.0, <span class="hljs-string">-20</span>.0, <span class="hljs-string">-20</span>.0, <span class="hljs-string">-20</span>.0]
Min joint positions [50.0, 50.0, 50.0, 50.0, 50.0, 50.0]`,wrap:!1}}),ut=new m({props:{code:"JTIyZW5kX2VmZmVjdG9yX2JvdW5kcyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMm1heCUyMiUzQSUyMCU1QjAuMjQlMkMlMjAwLjIwJTJDJTIwMC4xMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMm1pbiUyMiUzQSUyMCU1QjAuMTYlMkMlMjAtMC4wOCUyQyUyMDAuMDMlNUQlMEElN0Q=",highlighted:`<span class="hljs-attr">&quot;end_effector_bounds&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;max&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">0.24</span><span class="hljs-punctuation">,</span> <span class="hljs-number">0.20</span><span class="hljs-punctuation">,</span> <span class="hljs-number">0.10</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;min&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">0.16</span><span class="hljs-punctuation">,</span> <span class="hljs-number">-0.08</span><span class="hljs-punctuation">,</span> <span class="hljs-number">0.03</span><span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Mt=new T({props:{title:"Collecting Demonstrations",local:"collecting-demonstrations",headingTag:"h3"}}),Tt=new m({props:{code:"JTdCJTBBJTIwJTIwJTIyZW52JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMmd5bV9tYW5pcHVsYXRvciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmZwcyUyMiUzQSUyMDEwJTBBJTIwJTIwJTIwJTIwJTJGJTJGJTIwLi4uJTIwcm9ib3QlMkMlMjB0ZWxlb3AlMkMlMjBwcm9jZXNzb3IlMjBjb25maWdzJTIwLi4uJTBBJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIyZGF0YXNldCUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnJlcG9faWQlMjIlM0ElMjAlMjJ1c2VybmFtZSUyRnBpY2tfbGlmdF9jdWJlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyZGF0YXNldF9yb290JTIyJTNBJTIwbnVsbCUyQyUwQSUyMCUyMCUyMCUyMCUyMnRhc2slMjIlM0ElMjAlMjJwaWNrX2FuZF9saWZ0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIybnVtX2VwaXNvZGVzJTIyJTNBJTIwMTUlMkMlMEElMjAlMjAlMjAlMjAlMjJlcGlzb2RlJTIyJTNBJTIwMCUyQyUwQSUyMCUyMCUyMCUyMCUyMnB1c2hfdG9faHViJTIyJTNBJTIwdHJ1ZSUwQSUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMm1vZGUlMjIlM0ElMjAlMjJyZWNvcmQlMjIlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;env&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gym_manipulator&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;fps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">10</span>
    <span class="hljs-comment">// ... robot, teleop, processor configs ...</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;dataset&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;repo_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;username/pick_lift_cube&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;dataset_root&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;task&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;pick_and_lift&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;num_episodes&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">15</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;episode&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;push_to_hub&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;mode&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;record&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),ft=new T({props:{title:"Using a Teleoperation Device",local:"using-a-teleoperation-device",headingTag:"h3"}}),Ct=new m({props:{code:"Y2xhc3MlMjBTTzEwMEZvbGxvd2VyRW5kRWZmZWN0b3JDb25maWcoU08xMDBGb2xsb3dlckNvbmZpZyklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJDb25maWd1cmF0aW9uJTIwZm9yJTIwdGhlJTIwU08xMDBGb2xsb3dlckVuZEVmZmVjdG9yJTIwcm9ib3QuJTIyJTIyJTIyJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwRGVmYXVsdCUyMGJvdW5kcyUyMGZvciUyMHRoZSUyMGVuZC1lZmZlY3RvciUyMHBvc2l0aW9uJTIwKGluJTIwbWV0ZXJzKSUwQSUyMCUyMCUyMCUyMGVuZF9lZmZlY3Rvcl9ib3VuZHMlM0ElMjBkaWN0JTVCc3RyJTJDJTIwbGlzdCU1QmZsb2F0JTVEJTVEJTIwJTNEJTIwZmllbGQoJTIwJTIzJTIwYm91bmRzJTIwZm9yJTIwdGhlJTIwZW5kLWVmZmVjdG9yJTIwaW4lMjB4JTJDeSUyQ3olMjBkaXJlY3Rpb24lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkZWZhdWx0X2ZhY3RvcnklM0RsYW1iZGElM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtaW4lMjIlM0ElMjAlNUItMS4wJTJDJTIwLTEuMCUyQyUyMC0xLjAlNUQlMkMlMjAlMjAlMjMlMjBtaW4lMjB4JTJDJTIweSUyQyUyMHolMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtYXglMjIlM0ElMjAlNUIxLjAlMkMlMjAxLjAlMkMlMjAxLjAlNUQlMkMlMjAlMjAlMjMlMjBtYXglMjB4JTJDJTIweSUyQyUyMHolMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwbWF4X2dyaXBwZXJfcG9zJTNBJTIwZmxvYXQlMjAlM0QlMjA1MCUyMCUyMyUyMG1heGltdW0lMjBncmlwcGVyJTIwcG9zaXRpb24lMjB0aGF0JTIwdGhlJTIwZ3JpcHBlciUyMHdpbGwlMjBiZSUyMG9wZW4lMjBhdCUwQSUwQSUyMCUyMCUyMCUyMGVuZF9lZmZlY3Rvcl9zdGVwX3NpemVzJTNBJTIwZGljdCU1QnN0ciUyQyUyMGZsb2F0JTVEJTIwJTNEJTIwZmllbGQoJTIwJTIzJTIwbWF4aW11bSUyMHN0ZXAlMjBzaXplJTIwZm9yJTIwdGhlJTIwZW5kLWVmZmVjdG9yJTIwaW4lMjB4JTJDeSUyQ3olMjBkaXJlY3Rpb24lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkZWZhdWx0X2ZhY3RvcnklM0RsYW1iZGElM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ4JTIyJTNBJTIwMC4wMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnklMjIlM0ElMjAwLjAyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyeiUyMiUzQSUyMDAuMDIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAp",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">SO100FollowerEndEffectorConfig</span>(<span class="hljs-title class_ inherited__">SO100FollowerConfig</span>):
    <span class="hljs-string">&quot;&quot;&quot;Configuration for the SO100FollowerEndEffector robot.&quot;&quot;&quot;</span>

    <span class="hljs-comment"># Default bounds for the end-effector position (in meters)</span>
    end_effector_bounds: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">list</span>[<span class="hljs-built_in">float</span>]] = field( <span class="hljs-comment"># bounds for the end-effector in x,y,z direction</span>
        default_factory=<span class="hljs-keyword">lambda</span>: {
            <span class="hljs-string">&quot;min&quot;</span>: [-<span class="hljs-number">1.0</span>, -<span class="hljs-number">1.0</span>, -<span class="hljs-number">1.0</span>],  <span class="hljs-comment"># min x, y, z</span>
            <span class="hljs-string">&quot;max&quot;</span>: [<span class="hljs-number">1.0</span>, <span class="hljs-number">1.0</span>, <span class="hljs-number">1.0</span>],  <span class="hljs-comment"># max x, y, z</span>
        }
    )

    max_gripper_pos: <span class="hljs-built_in">float</span> = <span class="hljs-number">50</span> <span class="hljs-comment"># maximum gripper position that the gripper will be open at</span>

    end_effector_step_sizes: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">float</span>] = field( <span class="hljs-comment"># maximum step size for the end-effector in x,y,z direction</span>
        default_factory=<span class="hljs-keyword">lambda</span>: {
            <span class="hljs-string">&quot;x&quot;</span>: <span class="hljs-number">0.02</span>,
            <span class="hljs-string">&quot;y&quot;</span>: <span class="hljs-number">0.02</span>,
            <span class="hljs-string">&quot;z&quot;</span>: <span class="hljs-number">0.02</span>,
        }
    )`,wrap:!1}}),At=new m({props:{code:"JTdCJTBBJTIwJTIwJTIyZW52JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIydGVsZW9wJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMmdhbWVwYWQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ1c2VfZ3JpcHBlciUyMiUzQSUyMHRydWUlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjJwcm9jZXNzb3IlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250cm9sX21vZGUlMjIlM0ElMjAlMjJnYW1lcGFkJTIyJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTdEJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;env&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;teleop&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gamepad&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;use_gripper&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;processor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;control_mode&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gamepad&quot;</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Zt=new m({props:{code:"JTdCJTBBJTIwJTIwJTIyZW52JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIydGVsZW9wJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnNvMTAxX2xlYWRlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnBvcnQlMjIlM0ElMjAlMjIlMkZkZXYlMkZ0dHkudXNibW9kZW01ODVBMDA3NzkyMSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnVzZV9kZWdyZWVzJTIyJTNBJTIwdHJ1ZSUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnByb2Nlc3NvciUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRyb2xfbW9kZSUyMiUzQSUyMCUyMmxlYWRlciUyMiUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;env&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;teleop&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;so101_leader&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;port&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;/dev/tty.usbmodem585A0077921&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;use_degrees&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;processor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;control_mode&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;leader&quot;</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Et=new m({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnNjcmlwdHMucmwuZ3ltX21hbmlwdWxhdG9yJTIwLS1jb25maWdfcGF0aCUyMHNyYyUyRmxlcm9ib3QlMkZjb25maWdzJTJGZW52X2NvbmZpZ19zbzEwMC5qc29u",highlighted:"python -m lerobot.scripts.rl.gym_manipulator --config_path src/lerobot/configs/env_config_so100.json",wrap:!1}}),Wt=new T({props:{title:"Processing the Dataset",local:"processing-the-dataset",headingTag:"h3"}}),Yt=new m({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnNjcmlwdHMucmwuY3JvcF9kYXRhc2V0X3JvaSUyMC0tcmVwby1pZCUyMHVzZXJuYW1lJTJGcGlja19saWZ0X2N1YmU=",highlighted:"python -m lerobot.scripts.rl.crop_dataset_roi --repo-id username/pick_lift_cube",wrap:!1}}),Ft=new m({props:{code:"U2VsZWN0ZWQlMjBSZWN0YW5ndWxhciUyMFJlZ2lvbnMlMjBvZiUyMEludGVyZXN0JTIwKHRvcCUyQyUyMGxlZnQlMkMlMjBoZWlnaHQlMkMlMjB3aWR0aCklM0ElMEFvYnNlcnZhdGlvbi5pbWFnZXMuc2lkZSUzQSUyMCU1QjE4MCUyQyUyMDIwNyUyQyUyMDE4MCUyQyUyMDIwMCU1RCUwQW9ic2VydmF0aW9uLmltYWdlcy5mcm9udCUzQSUyMCU1QjE4MCUyQyUyMDI1MCUyQyUyMDEyMCUyQyUyMDE1MCU1RA==",highlighted:`Selected Rectangular Regions of Interest (<span class="hljs-attribute">top</span>, left, height, width):
observation<span class="hljs-selector-class">.images</span><span class="hljs-selector-class">.side</span>: <span class="hljs-selector-attr">[180, 207, 180, 200]</span>
observation<span class="hljs-selector-class">.images</span><span class="hljs-selector-class">.front</span>: <span class="hljs-selector-attr">[180, 250, 120, 150]</span>`,wrap:!1}}),Kt=new m({props:{code:"JTdCJTBBJTIwJTIwJTIyZW52JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycHJvY2Vzc29yJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyaW1hZ2VfcHJlcHJvY2Vzc2luZyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNyb3BfcGFyYW1zX2RpY3QlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJvYnNlcnZhdGlvbi5pbWFnZXMuc2lkZSUyMiUzQSUyMCU1QjE4MCUyQyUyMDIwNyUyQyUyMDE4MCUyQyUyMDIwMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm9ic2VydmF0aW9uLmltYWdlcy5mcm9udCUyMiUzQSUyMCU1QjE4MCUyQyUyMDI1MCUyQyUyMDEyMCUyQyUyMDE1MCU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJlc2l6ZV9zaXplJTIyJTNBJTIwJTVCMTI4JTJDJTIwMTI4JTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTdEJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;env&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;processor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;image_preprocessing&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;crop_params_dict&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;observation.images.side&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">180</span><span class="hljs-punctuation">,</span> <span class="hljs-number">207</span><span class="hljs-punctuation">,</span> <span class="hljs-number">180</span><span class="hljs-punctuation">,</span> <span class="hljs-number">200</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;observation.images.front&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">180</span><span class="hljs-punctuation">,</span> <span class="hljs-number">250</span><span class="hljs-punctuation">,</span> <span class="hljs-number">120</span><span class="hljs-punctuation">,</span> <span class="hljs-number">150</span><span class="hljs-punctuation">]</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;resize_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">128</span><span class="hljs-punctuation">,</span> <span class="hljs-number">128</span><span class="hljs-punctuation">]</span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),se=new T({props:{title:"Training a Reward Classifier",local:"training-a-reward-classifier",headingTag:"h3"}}),ce=new m({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnNjcmlwdHMucmwuZ3ltX21hbmlwdWxhdG9yJTIwLS1jb25maWdfcGF0aCUyMHNyYyUyRmxlcm9ib3QlMkZjb25maWdzJTJGcmV3YXJkX2NsYXNzaWZpZXJfdHJhaW5fY29uZmlnLmpzb24=",highlighted:"python -m lerobot.scripts.rl.gym_manipulator --config_path src/lerobot/configs/reward_classifier_train_config.json",wrap:!1}}),me=new m({props:{code:"JTdCJTBBJTIwJTIwJTIyZW52JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMmd5bV9tYW5pcHVsYXRvciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmZwcyUyMiUzQSUyMDEwJTJDJTBBJTIwJTIwJTIwJTIwJTIycHJvY2Vzc29yJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIycmVzZXQlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJudW1iZXJfb2Zfc3RlcHNfYWZ0ZXJfc3VjY2VzcyUyMiUzQSUyMDE1JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIyZGF0YXNldCUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnJlcG9faWQlMjIlM0ElMjAlMjJoZl91c2VybmFtZSUyRmRhdGFzZXRfbmFtZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmRhdGFzZXRfcm9vdCUyMiUzQSUyMCUyMmRhdGElMkZ5b3VyX2RhdGFzZXQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJudW1fZXBpc29kZXMlMjIlM0ElMjAyMCUyQyUwQSUyMCUyMCUyMCUyMCUyMnB1c2hfdG9faHViJTIyJTNBJTIwdHJ1ZSUwQSUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMm1vZGUlMjIlM0ElMjAlMjJyZWNvcmQlMjIlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;env&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gym_manipulator&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;fps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">10</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;processor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;reset&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;number_of_steps_after_success&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">15</span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;dataset&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;repo_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;hf_username/dataset_name&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;dataset_root&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;data/your_dataset&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;num_episodes&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">20</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;push_to_hub&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;mode&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;record&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),we=new m({props:{code:"JTdCJTBBJTIwJTIwJTIycG9saWN5JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnJld2FyZF9jbGFzc2lmaWVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIybW9kZWxfbmFtZSUyMiUzQSUyMCUyMmhlbHBlcjI0MjQlMkZyZXNuZXQxMCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMm1vZGVsX3R5cGUlMjIlM0ElMjAlMjJjbm4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJudW1fY2FtZXJhcyUyMiUzQSUyMDIlMkMlMEElMjAlMjAlMjAlMjAlMjJudW1fY2xhc3NlcyUyMiUzQSUyMDIlMkMlMEElMjAlMjAlMjAlMjAlMjJoaWRkZW5fZGltJTIyJTNBJTIwMjU2JTJDJTBBJTIwJTIwJTIwJTIwJTIyZHJvcG91dF9yYXRlJTIyJTNBJTIwMC4xJTJDJTBBJTIwJTIwJTIwJTIwJTIybGVhcm5pbmdfcmF0ZSUyMiUzQSUyMDFlLTQlMkMlMEElMjAlMjAlMjAlMjAlMjJkZXZpY2UlMjIlM0ElMjAlMjJjdWRhJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydXNlX2FtcCUyMiUzQSUyMHRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjJpbnB1dF9mZWF0dXJlcyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMm9ic2VydmF0aW9uLmltYWdlcy5mcm9udCUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJWSVNVQUwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzaGFwZSUyMiUzQSUyMCU1QjMlMkMlMjAxMjglMkMlMjAxMjglNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJvYnNlcnZhdGlvbi5pbWFnZXMuc2lkZSUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJWSVNVQUwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzaGFwZSUyMiUzQSUyMCU1QjMlMkMlMjAxMjglMkMlMjAxMjglNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;policy&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;reward_classifier&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;model_name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;helper2424/resnet10&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;model_type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cnn&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;num_cameras&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;num_classes&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;hidden_dim&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">256</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;dropout_rate&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.1</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;learning_rate&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e-4</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cuda&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;use_amp&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;input_features&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;observation.images.front&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;VISUAL&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;shape&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">3</span><span class="hljs-punctuation">,</span> <span class="hljs-number">128</span><span class="hljs-punctuation">,</span> <span class="hljs-number">128</span><span class="hljs-punctuation">]</span>
      <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;observation.images.side&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;VISUAL&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;shape&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">3</span><span class="hljs-punctuation">,</span> <span class="hljs-number">128</span><span class="hljs-punctuation">,</span> <span class="hljs-number">128</span><span class="hljs-punctuation">]</span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Ce=new m({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnNjcmlwdHMudHJhaW4lMjAtLWNvbmZpZ19wYXRoJTIwcGF0aCUyRnRvJTJGcmV3YXJkX2NsYXNzaWZpZXJfdHJhaW5fY29uZmlnLmpzb24=",highlighted:"python -m lerobot.scripts.train --config_path path/to/reward_classifier_train_config.json",wrap:!1}}),be=new m({props:{code:"Y29uZmlnJTIwJTNEJTIwR3ltTWFuaXB1bGF0b3JDb25maWcoJTBBJTIwJTIwJTIwJTIwZW52JTNESElMU2VybFJvYm90RW52Q29uZmlnKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb2Nlc3NvciUzREhJTFNlcmxQcm9jZXNzb3JDb25maWcoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV3YXJkX2NsYXNzaWZpZXIlM0RSZXdhcmRDbGFzc2lmaWVyQ29uZmlnKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByZXRyYWluZWRfcGF0aCUzRCUyMnBhdGhfdG9feW91cl9wcmV0cmFpbmVkX3RyYWluZWRfbW9kZWwlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyME90aGVyJTIwZW52aXJvbm1lbnQlMjBwYXJhbWV0ZXJzJTBBJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMGRhdGFzZXQlM0REYXRhc2V0Q29uZmlnKC4uLiklMkMlMEElMjAlMjAlMjAlMjBtb2RlJTNETm9uZSUyMCUyMCUyMyUyMEZvciUyMHRyYWluaW5nJTBBKQ==",highlighted:`config = GymManipulatorConfig(
    env=HILSerlRobotEnvConfig(
        processor=HILSerlProcessorConfig(
            reward_classifier=RewardClassifierConfig(
                pretrained_path=<span class="hljs-string">&quot;path_to_your_pretrained_trained_model&quot;</span>
            )
        ),
        <span class="hljs-comment"># Other environment parameters</span>
    ),
    dataset=DatasetConfig(...),
    mode=<span class="hljs-literal">None</span>  <span class="hljs-comment"># For training</span>
)`,wrap:!1}}),Ae=new m({props:{code:"JTdCJTBBJTIwJTIwJTIyZW52JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycHJvY2Vzc29yJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIycmV3YXJkX2NsYXNzaWZpZXIlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJwcmV0cmFpbmVkX3BhdGglMjIlM0ElMjAlMjJwYXRoX3RvX3lvdXJfcHJldHJhaW5lZF9tb2RlbCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnN1Y2Nlc3NfdGhyZXNob2xkJTIyJTNBJTIwMC43JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3VjY2Vzc19yZXdhcmQlMjIlM0ElMjAxLjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;env&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;processor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;reward_classifier&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;pretrained_path&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;path_to_your_pretrained_model&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;success_threshold&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.7</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;success_reward&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1.0</span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),xe=new m({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnNjcmlwdHMucmwuZ3ltX21hbmlwdWxhdG9yJTIwLS1jb25maWdfcGF0aCUyMHBhdGglMkZ0byUyRmVudl9jb25maWcuanNvbg==",highlighted:"python -m lerobot.scripts.rl.gym_manipulator --config_path path/to/env_config.json",wrap:!1}}),He=new m({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnNjcmlwdHMucmwuZ3ltX21hbmlwdWxhdG9yJTIwLS1jb25maWdfcGF0aCUyMHNyYyUyRmxlcm9ib3QlMkZjb25maWdzJTJGZW52X2NvbmZpZy5qc29u",highlighted:"python -m lerobot.scripts.rl.gym_manipulator --config_path src/lerobot/configs/env_config.json",wrap:!1}}),ke=new m({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnNjcmlwdHMudHJhaW4lMjAtLWNvbmZpZ19wYXRoJTIwc3JjJTJGbGVyb2JvdCUyRmNvbmZpZ3MlMkZyZXdhcmRfY2xhc3NpZmllcl90cmFpbl9jb25maWcuanNvbg==",highlighted:"python -m lerobot.scripts.train --config_path src/lerobot/configs/reward_classifier_train_config.json",wrap:!1}}),qe=new m({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnNjcmlwdHMucmwuZ3ltX21hbmlwdWxhdG9yJTIwLS1jb25maWdfcGF0aCUyMHNyYyUyRmxlcm9ib3QlMkZjb25maWdzJTJGZW52X2NvbmZpZy5qc29u",highlighted:"python -m lerobot.scripts.rl.gym_manipulator --config_path src/lerobot/configs/env_config.json",wrap:!1}}),Qe=new T({props:{title:"Training with Actor-Learner",local:"training-with-actor-learner",headingTag:"h3"}}),ze=new m({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnNjcmlwdHMucmwubGVhcm5lciUyMC0tY29uZmlnX3BhdGglMjBzcmMlMkZsZXJvYm90JTJGY29uZmlncyUyRnRyYWluX2NvbmZpZ19oaWxzZXJsX3NvMTAwLmpzb24=",highlighted:"python -m lerobot.scripts.rl.learner --config_path src/lerobot/configs/train_config_hilserl_so100.json",wrap:!1}}),De=new m({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnNjcmlwdHMucmwuYWN0b3IlMjAtLWNvbmZpZ19wYXRoJTIwc3JjJTJGbGVyb2JvdCUyRmNvbmZpZ3MlMkZ0cmFpbl9jb25maWdfaGlsc2VybF9zbzEwMC5qc29u",highlighted:"python -m lerobot.scripts.rl.actor --config_path src/lerobot/configs/train_config_hilserl_so100.json",wrap:!1}}),ps=new T({props:{title:"Guide to Human Interventions",local:"guide-to-human-interventions",headingTag:"h3"}}),Ms=new T({props:{title:"Key hyperparameters to tune",local:"key-hyperparameters-to-tune",headingTag:"h3"}}),H=new Yo({props:{warning:!1,$$slots:{default:[Po]},$$scope:{ctx:As}}}),ds=new m({props:{code:"JTQwYXJ0aWNsZSU3Qmx1bzIwMjRwcmVjaXNlJTJDJTBBJTIwJTIwdGl0bGUlM0QlN0JQcmVjaXNlJTIwYW5kJTIwRGV4dGVyb3VzJTIwUm9ib3RpYyUyME1hbmlwdWxhdGlvbiUyMHZpYSUyMEh1bWFuLWluLXRoZS1Mb29wJTIwUmVpbmZvcmNlbWVudCUyMExlYXJuaW5nJTdEJTJDJTBBJTIwJTIwYXV0aG9yJTNEJTdCTHVvJTJDJTIwSmlhbmxhbiUyMGFuZCUyMFh1JTJDJTIwQ2hhcmxlcyUyMGFuZCUyMFd1JTJDJTIwSmVmZnJleSUyMGFuZCUyMExldmluZSUyQyUyMFNlcmdleSU3RCUyQyUwQSUyMCUyMGpvdXJuYWwlM0QlN0JhclhpdiUyMHByZXByaW50JTIwYXJYaXYlM0EyNDEwLjIxODQ1JTdEJTJDJTBBJTIwJTIweWVhciUzRCU3QjIwMjQlN0QlMEElN0Q=",highlighted:`@article{luo2024precise,
  title={Precise <span class="hljs-keyword">and </span>Dexterous Robotic Manipulation via Human-in-the-Loop Reinforcement Learning},
  author={Luo, <span class="hljs-keyword">Jianlan </span><span class="hljs-keyword">and </span>Xu, Charles <span class="hljs-keyword">and </span>Wu, <span class="hljs-keyword">Jeffrey </span><span class="hljs-keyword">and </span>Levine, Sergey},
  <span class="hljs-keyword">journal={arXiv </span>preprint arXiv:<span class="hljs-number">2410</span>.<span class="hljs-number">21845</span>},
  year={<span class="hljs-number">2024</span>}
}`,wrap:!1}}),Ts=new Vo({props:{source:"https://github.com/huggingface/lerobot/blob/main/docs/source/hilserl.mdx"}}),{c(){d=i("meta"),E=n(),J=i("p"),fs=n(),r(q.$$.fragment),_s=n(),Q=i("p"),Q.textContent=$a,xs=n(),W=i("p"),W.textContent=Za,$s=n(),N=i("p"),N.innerHTML=La,Zs=n(),S=i("p"),S.textContent=Ha,Ls=n(),g=i("p"),g.innerHTML=Ba,Hs=n(),I=i("p"),I.innerHTML=ka,Bs=n(),R=i("p"),R.textContent=Ea,ks=n(),r(G.$$.fragment),Es=n(),X=i("ul"),X.innerHTML=qa,qs=n(),r(z.$$.fragment),Qs=n(),Y=i("p"),Y.textContent=Qa,Ws=n(),V=i("ul"),V.innerHTML=Wa,Ns=n(),r(P.$$.fragment),Ss=n(),F=i("p"),F.innerHTML=Na,Rs=n(),r(D.$$.fragment),Gs=n(),r(O.$$.fragment),Xs=n(),r(K.$$.fragment),zs=n(),tt=i("p"),tt.innerHTML=Sa,Ys=n(),r(et.$$.fragment),Vs=n(),r(st.$$.fragment),Ps=n(),lt=i("p"),lt.textContent=Ra,Fs=n(),nt=i("p"),nt.textContent=Ga,Ds=n(),at=i("p"),at.innerHTML=Xa,Os=n(),it=i("p"),it.textContent=za,Ks=n(),r(ot.$$.fragment),tl=n(),pt=i("p"),pt.innerHTML=Ya,el=n(),U=i("ol"),ws=i("li"),ws.textContent=Va,Ja=n(),Js=i("li"),Ua=Go(`The script will record the minimum and maximum end-effector positions and the joint angles and prints them to the console, for example:
	`),r(rt.$$.fragment),Ca=n(),Us=i("li"),Us.innerHTML=Pa,sl=n(),ct=i("p"),ct.innerHTML=Fa,ll=n(),r(ut.$$.fragment),nl=n(),r(Mt.$$.fragment),al=n(),ht=i("p"),ht.textContent=Da,il=n(),yt=i("p"),yt.innerHTML=Oa,ol=n(),mt=i("p"),mt.innerHTML=Ka,pl=n(),jt=i("ol"),jt.innerHTML=ti,rl=n(),dt=i("p"),dt.textContent=ei,cl=n(),r(Tt.$$.fragment),ul=n(),r(ft.$$.fragment),Ml=n(),wt=i("p"),wt.textContent=si,hl=n(),Jt=i("p"),Jt.textContent=li,yl=n(),Ut=i("p"),Ut.innerHTML=ni,ml=n(),r(Ct.$$.fragment),jl=n(),gt=i("p"),gt.innerHTML=ai,dl=n(),It=i("p"),It.innerHTML=ii,Tl=n(),bt=i("p"),bt.textContent=oi,fl=n(),vt=i("p"),vt.innerHTML=pi,wl=n(),r(At.$$.fragment),Jl=n(),b=i("p"),b.innerHTML=ri,Ul=n(),v=i("p"),v.innerHTML=ci,Cl=n(),_t=i("p"),_t.innerHTML=ui,gl=n(),xt=i("p"),xt.textContent=Mi,Il=n(),$t=i("p"),$t.innerHTML=hi,bl=n(),r(Zt.$$.fragment),vl=n(),Lt=i("p"),Lt.innerHTML=yi,Al=n(),Ht=i("details"),Ht.innerHTML=mi,_l=n(),Bt=i("p"),Bt.innerHTML=ji,xl=n(),kt=i("p"),kt.innerHTML=di,$l=n(),r(Et.$$.fragment),Zl=n(),qt=i("p"),qt.textContent=Ti,Ll=n(),Qt=i("ol"),Qt.innerHTML=fi,Hl=n(),r(Wt.$$.fragment),Bl=n(),Nt=i("p"),Nt.textContent=wi,kl=n(),St=i("p"),St.textContent=Ji,El=n(),Rt=i("ul"),Rt.innerHTML=Ui,ql=n(),Gt=i("p"),Gt.innerHTML=Ci,Ql=n(),Xt=i("p"),Xt.innerHTML=gi,Wl=n(),zt=i("p"),zt.innerHTML=Ii,Nl=n(),r(Yt.$$.fragment),Sl=n(),Vt=i("ol"),Vt.innerHTML=bi,Rl=n(),Pt=i("p"),Pt.textContent=vi,Gl=n(),r(Ft.$$.fragment),Xl=n(),A=i("p"),A.innerHTML=Ai,zl=n(),_=i("p"),_.innerHTML=_i,Yl=n(),Dt=i("p"),Dt.innerHTML=xi,Vl=n(),Ot=i("p"),Ot.textContent=$i,Pl=n(),r(Kt.$$.fragment),Fl=n(),te=i("p"),te.innerHTML=Zi,Dl=n(),ee=i("p"),ee.innerHTML=Li,Ol=n(),r(se.$$.fragment),Kl=n(),le=i("p"),le.textContent=Hi,tn=n(),ne=i("p"),ne.textContent=Bi,en=n(),ae=i("p"),ae.innerHTML=ki,sn=n(),ie=i("p"),ie.innerHTML=Ei,ln=n(),oe=i("p"),oe.innerHTML=qi,nn=n(),pe=i("p"),pe.innerHTML=Qi,an=n(),re=i("p"),re.textContent=Wi,on=n(),r(ce.$$.fragment),pn=n(),ue=i("p"),ue.innerHTML=Ni,rn=n(),Me=i("ul"),Me.innerHTML=Si,cn=n(),he=i("p"),he.innerHTML=Ri,un=n(),ye=i("p"),ye.textContent=Gi,Mn=n(),r(me.$$.fragment),hn=n(),je=i("p"),je.innerHTML=Xi,yn=n(),de=i("p"),de.innerHTML=zi,mn=n(),Te=i("ul"),Te.innerHTML=Yi,jn=n(),fe=i("p"),fe.innerHTML=Vi,dn=n(),r(we.$$.fragment),Tn=n(),Je=i("p"),Je.innerHTML=Pi,fn=n(),Ue=i("p"),Ue.innerHTML=Fi,wn=n(),r(Ce.$$.fragment),Jn=n(),ge=i("p"),ge.innerHTML=Di,Un=n(),Ie=i("p"),Ie.innerHTML=Oi,Cn=n(),r(be.$$.fragment),gn=n(),ve=i("p"),ve.textContent=Ki,In=n(),r(Ae.$$.fragment),bn=n(),_e=i("p"),_e.innerHTML=to,vn=n(),r(xe.$$.fragment),An=n(),$e=i("p"),$e.textContent=eo,_n=n(),Ze=i("p"),Ze.innerHTML=so,xn=n(),f=i("ol"),Cs=i("li"),Cs.innerHTML=lo,ga=n(),Le=i("li"),gs=i("p"),gs.innerHTML=no,Ia=n(),r(He.$$.fragment),ba=n(),Be=i("li"),Is=i("p"),Is.innerHTML=ao,va=n(),r(ke.$$.fragment),Aa=n(),Ee=i("li"),bs=i("p"),bs.innerHTML=io,_a=n(),r(qe.$$.fragment),$n=n(),r(Qe.$$.fragment),Zn=n(),We=i("p"),We.textContent=oo,Ln=n(),Ne=i("p"),Ne.innerHTML=po,Hn=n(),Se=i("p"),Se.innerHTML=ro,Bn=n(),Re=i("ol"),Re.innerHTML=co,kn=n(),Ge=i("p"),Ge.innerHTML=uo,En=n(),Xe=i("p"),Xe.textContent=Mo,qn=n(),r(ze.$$.fragment),Qn=n(),Ye=i("p"),Ye.textContent=ho,Wn=n(),Ve=i("ul"),Ve.innerHTML=yo,Nn=n(),Pe=i("p"),Pe.innerHTML=mo,Sn=n(),Fe=i("p"),Fe.textContent=jo,Rn=n(),r(De.$$.fragment),Gn=n(),Oe=i("p"),Oe.textContent=To,Xn=n(),Ke=i("ul"),Ke.innerHTML=fo,zn=n(),ts=i("p"),ts.innerHTML=wo,Yn=n(),es=i("p"),es.textContent=Jo,Vn=n(),ss=i("ol"),ss.innerHTML=Uo,Pn=n(),ls=i("p"),ls.innerHTML=Co,Fn=n(),ns=i("ul"),ns.innerHTML=go,Dn=n(),x=i("p"),x.innerHTML=Io,On=n(),$=i("p"),$.innerHTML=bo,Kn=n(),as=i("ul"),as.innerHTML=vo,ta=n(),is=i("p"),is.innerHTML=Ao,ea=n(),os=i("p"),os.innerHTML=_o,sa=n(),r(ps.$$.fragment),la=n(),rs=i("p"),rs.textContent=xo,na=n(),cs=i("ul"),cs.innerHTML=$o,aa=n(),us=i("p"),us.textContent=Zo,ia=n(),Z=i("p"),Z.innerHTML=Lo,oa=n(),L=i("p"),L.innerHTML=Ho,pa=n(),r(Ms.$$.fragment),ra=n(),hs=i("p"),hs.textContent=Bo,ca=n(),ys=i("ul"),ys.innerHTML=ko,ua=n(),ms=i("p"),ms.textContent=Eo,Ma=n(),r(H.$$.fragment),ha=n(),js=i("p"),js.textContent=qo,ya=n(),r(ds.$$.fragment),ma=n(),r(Ts.$$.fragment),ja=n(),vs=i("p"),this.h()},l(t){const e=Xo("svelte-u9bgzb",document.head);d=o(e,"META",{name:!0,content:!0}),e.forEach(s),E=a(t),J=o(t,"P",{}),k(J).forEach(s),fs=a(t),c(q.$$.fragment,t),_s=a(t),Q=o(t,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-tip1wc"&&(Q.textContent=$a),xs=a(t),W=o(t,"P",{"data-svelte-h":!0}),p(W)!=="svelte-85x4lc"&&(W.textContent=Za),$s=a(t),N=o(t,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1axnr08"&&(N.innerHTML=La),Zs=a(t),S=o(t,"P",{"data-svelte-h":!0}),p(S)!=="svelte-6ttl9o"&&(S.textContent=Ha),Ls=a(t),g=o(t,"P",{align:!0,"data-svelte-h":!0}),p(g)!=="svelte-2ozfa6"&&(g.innerHTML=Ba),Hs=a(t),I=o(t,"P",{align:!0,"data-svelte-h":!0}),p(I)!=="svelte-agh7op"&&(I.innerHTML=ka),Bs=a(t),R=o(t,"P",{"data-svelte-h":!0}),p(R)!=="svelte-kh48rx"&&(R.textContent=Ea),ks=a(t),c(G.$$.fragment,t),Es=a(t),X=o(t,"UL",{"data-svelte-h":!0}),p(X)!=="svelte-st8mkn"&&(X.innerHTML=qa),qs=a(t),c(z.$$.fragment,t),Qs=a(t),Y=o(t,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-12wjggm"&&(Y.textContent=Qa),Ws=a(t),V=o(t,"UL",{"data-svelte-h":!0}),p(V)!=="svelte-1xew5vn"&&(V.innerHTML=Wa),Ns=a(t),c(P.$$.fragment,t),Ss=a(t),F=o(t,"P",{"data-svelte-h":!0}),p(F)!=="svelte-punxaj"&&(F.innerHTML=Na),Rs=a(t),c(D.$$.fragment,t),Gs=a(t),c(O.$$.fragment,t),Xs=a(t),c(K.$$.fragment,t),zs=a(t),tt=o(t,"P",{"data-svelte-h":!0}),p(tt)!=="svelte-i4i1db"&&(tt.innerHTML=Sa),Ys=a(t),c(et.$$.fragment,t),Vs=a(t),c(st.$$.fragment,t),Ps=a(t),lt=o(t,"P",{"data-svelte-h":!0}),p(lt)!=="svelte-qhx7nb"&&(lt.textContent=Ra),Fs=a(t),nt=o(t,"P",{"data-svelte-h":!0}),p(nt)!=="svelte-13zpkl7"&&(nt.textContent=Ga),Ds=a(t),at=o(t,"P",{"data-svelte-h":!0}),p(at)!=="svelte-1xbrdof"&&(at.innerHTML=Xa),Os=a(t),it=o(t,"P",{"data-svelte-h":!0}),p(it)!=="svelte-12g0x8n"&&(it.textContent=za),Ks=a(t),c(ot.$$.fragment,t),tl=a(t),pt=o(t,"P",{"data-svelte-h":!0}),p(pt)!=="svelte-133252y"&&(pt.innerHTML=Ya),el=a(t),U=o(t,"OL",{});var C=k(U);ws=o(C,"LI",{"data-svelte-h":!0}),p(ws)!=="svelte-jwhws7"&&(ws.textContent=Va),Ja=a(C),Js=o(C,"LI",{});var xa=k(Js);Ua=zo(xa,`The script will record the minimum and maximum end-effector positions and the joint angles and prints them to the console, for example:
	`),c(rt.$$.fragment,xa),xa.forEach(s),Ca=a(C),Us=o(C,"LI",{"data-svelte-h":!0}),p(Us)!=="svelte-1o9aezs"&&(Us.innerHTML=Pa),C.forEach(s),sl=a(t),ct=o(t,"P",{"data-svelte-h":!0}),p(ct)!=="svelte-9e4z7l"&&(ct.innerHTML=Fa),ll=a(t),c(ut.$$.fragment,t),nl=a(t),c(Mt.$$.fragment,t),al=a(t),ht=o(t,"P",{"data-svelte-h":!0}),p(ht)!=="svelte-1xayq1k"&&(ht.textContent=Da),il=a(t),yt=o(t,"P",{"data-svelte-h":!0}),p(yt)!=="svelte-1b1oyiu"&&(yt.innerHTML=Oa),ol=a(t),mt=o(t,"P",{"data-svelte-h":!0}),p(mt)!=="svelte-1fm14qo"&&(mt.innerHTML=Ka),pl=a(t),jt=o(t,"OL",{"data-svelte-h":!0}),p(jt)!=="svelte-1sxmjct"&&(jt.innerHTML=ti),rl=a(t),dt=o(t,"P",{"data-svelte-h":!0}),p(dt)!=="svelte-gur1fh"&&(dt.textContent=ei),cl=a(t),c(Tt.$$.fragment,t),ul=a(t),c(ft.$$.fragment,t),Ml=a(t),wt=o(t,"P",{"data-svelte-h":!0}),p(wt)!=="svelte-1k55eio"&&(wt.textContent=si),hl=a(t),Jt=o(t,"P",{"data-svelte-h":!0}),p(Jt)!=="svelte-1gu8vct"&&(Jt.textContent=li),yl=a(t),Ut=o(t,"P",{"data-svelte-h":!0}),p(Ut)!=="svelte-lkgt27"&&(Ut.innerHTML=ni),ml=a(t),c(Ct.$$.fragment,t),jl=a(t),gt=o(t,"P",{"data-svelte-h":!0}),p(gt)!=="svelte-12kabho"&&(gt.innerHTML=ai),dl=a(t),It=o(t,"P",{"data-svelte-h":!0}),p(It)!=="svelte-123qamy"&&(It.innerHTML=ii),Tl=a(t),bt=o(t,"P",{"data-svelte-h":!0}),p(bt)!=="svelte-q27m3q"&&(bt.textContent=oi),fl=a(t),vt=o(t,"P",{"data-svelte-h":!0}),p(vt)!=="svelte-1458spy"&&(vt.innerHTML=pi),wl=a(t),c(At.$$.fragment,t),Jl=a(t),b=o(t,"P",{align:!0,"data-svelte-h":!0}),p(b)!=="svelte-l7xw97"&&(b.innerHTML=ri),Ul=a(t),v=o(t,"P",{align:!0,"data-svelte-h":!0}),p(v)!=="svelte-i8xgvo"&&(v.innerHTML=ci),Cl=a(t),_t=o(t,"P",{"data-svelte-h":!0}),p(_t)!=="svelte-17w4vys"&&(_t.innerHTML=ui),gl=a(t),xt=o(t,"P",{"data-svelte-h":!0}),p(xt)!=="svelte-1n513na"&&(xt.textContent=Mi),Il=a(t),$t=o(t,"P",{"data-svelte-h":!0}),p($t)!=="svelte-fnzfno"&&($t.innerHTML=hi),bl=a(t),c(Zt.$$.fragment,t),vl=a(t),Lt=o(t,"P",{"data-svelte-h":!0}),p(Lt)!=="svelte-u9lwpw"&&(Lt.innerHTML=yi),Al=a(t),Ht=o(t,"DETAILS",{"data-svelte-h":!0}),p(Ht)!=="svelte-1raqgp9"&&(Ht.innerHTML=mi),_l=a(t),Bt=o(t,"P",{"data-svelte-h":!0}),p(Bt)!=="svelte-1lumdn2"&&(Bt.innerHTML=ji),xl=a(t),kt=o(t,"P",{"data-svelte-h":!0}),p(kt)!=="svelte-303oat"&&(kt.innerHTML=di),$l=a(t),c(Et.$$.fragment,t),Zl=a(t),qt=o(t,"P",{"data-svelte-h":!0}),p(qt)!=="svelte-1e9jl8o"&&(qt.textContent=Ti),Ll=a(t),Qt=o(t,"OL",{"data-svelte-h":!0}),p(Qt)!=="svelte-an135w"&&(Qt.innerHTML=fi),Hl=a(t),c(Wt.$$.fragment,t),Bl=a(t),Nt=o(t,"P",{"data-svelte-h":!0}),p(Nt)!=="svelte-1muq6i8"&&(Nt.textContent=wi),kl=a(t),St=o(t,"P",{"data-svelte-h":!0}),p(St)!=="svelte-1q8tlhb"&&(St.textContent=Ji),El=a(t),Rt=o(t,"UL",{"data-svelte-h":!0}),p(Rt)!=="svelte-b0vrwx"&&(Rt.innerHTML=Ui),ql=a(t),Gt=o(t,"P",{"data-svelte-h":!0}),p(Gt)!=="svelte-tevvdp"&&(Gt.innerHTML=Ci),Ql=a(t),Xt=o(t,"P",{"data-svelte-h":!0}),p(Xt)!=="svelte-98970x"&&(Xt.innerHTML=gi),Wl=a(t),zt=o(t,"P",{"data-svelte-h":!0}),p(zt)!=="svelte-1eej4ha"&&(zt.innerHTML=Ii),Nl=a(t),c(Yt.$$.fragment,t),Sl=a(t),Vt=o(t,"OL",{"data-svelte-h":!0}),p(Vt)!=="svelte-xydyib"&&(Vt.innerHTML=bi),Rl=a(t),Pt=o(t,"P",{"data-svelte-h":!0}),p(Pt)!=="svelte-c9hbnf"&&(Pt.textContent=vi),Gl=a(t),c(Ft.$$.fragment,t),Xl=a(t),A=o(t,"P",{align:!0,"data-svelte-h":!0}),p(A)!=="svelte-1kgsj1n"&&(A.innerHTML=Ai),zl=a(t),_=o(t,"P",{align:!0,"data-svelte-h":!0}),p(_)!=="svelte-m2u5tt"&&(_.innerHTML=_i),Yl=a(t),Dt=o(t,"P",{"data-svelte-h":!0}),p(Dt)!=="svelte-1fvonll"&&(Dt.innerHTML=xi),Vl=a(t),Ot=o(t,"P",{"data-svelte-h":!0}),p(Ot)!=="svelte-1u063o4"&&(Ot.textContent=$i),Pl=a(t),c(Kt.$$.fragment,t),Fl=a(t),te=o(t,"P",{"data-svelte-h":!0}),p(te)!=="svelte-gm91yt"&&(te.innerHTML=Zi),Dl=a(t),ee=o(t,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-1xu368l"&&(ee.innerHTML=Li),Ol=a(t),c(se.$$.fragment,t),Kl=a(t),le=o(t,"P",{"data-svelte-h":!0}),p(le)!=="svelte-1s4360z"&&(le.textContent=Hi),tn=a(t),ne=o(t,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-1gn06z5"&&(ne.textContent=Bi),en=a(t),ae=o(t,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-a5qxyo"&&(ae.innerHTML=ki),sn=a(t),ie=o(t,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-d4pith"&&(ie.innerHTML=Ei),ln=a(t),oe=o(t,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-1v0tk6u"&&(oe.innerHTML=qi),nn=a(t),pe=o(t,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-972ybh"&&(pe.innerHTML=Qi),an=a(t),re=o(t,"P",{"data-svelte-h":!0}),p(re)!=="svelte-1najbyj"&&(re.textContent=Wi),on=a(t),c(ce.$$.fragment,t),pn=a(t),ue=o(t,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-6lst9n"&&(ue.innerHTML=Ni),rn=a(t),Me=o(t,"UL",{"data-svelte-h":!0}),p(Me)!=="svelte-p9kqo6"&&(Me.innerHTML=Si),cn=a(t),he=o(t,"P",{"data-svelte-h":!0}),p(he)!=="svelte-j4jqtm"&&(he.innerHTML=Ri),un=a(t),ye=o(t,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-17ipf62"&&(ye.textContent=Gi),Mn=a(t),c(me.$$.fragment,t),hn=a(t),je=o(t,"P",{"data-svelte-h":!0}),p(je)!=="svelte-1g8qm4r"&&(je.innerHTML=Xi),yn=a(t),de=o(t,"P",{"data-svelte-h":!0}),p(de)!=="svelte-1k00g85"&&(de.innerHTML=zi),mn=a(t),Te=o(t,"UL",{"data-svelte-h":!0}),p(Te)!=="svelte-299w4m"&&(Te.innerHTML=Yi),jn=a(t),fe=o(t,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-164cgkl"&&(fe.innerHTML=Vi),dn=a(t),c(we.$$.fragment,t),Tn=a(t),Je=o(t,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-gncodb"&&(Je.innerHTML=Pi),fn=a(t),Ue=o(t,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-1i92i25"&&(Ue.innerHTML=Fi),wn=a(t),c(Ce.$$.fragment,t),Jn=a(t),ge=o(t,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-t7wvp3"&&(ge.innerHTML=Di),Un=a(t),Ie=o(t,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-1373v1s"&&(Ie.innerHTML=Oi),Cn=a(t),c(be.$$.fragment,t),gn=a(t),ve=o(t,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-1dg5zv5"&&(ve.textContent=Ki),In=a(t),c(Ae.$$.fragment,t),bn=a(t),_e=o(t,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-ufcypw"&&(_e.innerHTML=to),vn=a(t),c(xe.$$.fragment,t),An=a(t),$e=o(t,"P",{"data-svelte-h":!0}),p($e)!=="svelte-kwp5x9"&&($e.textContent=eo),_n=a(t),Ze=o(t,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-164odnw"&&(Ze.innerHTML=so),xn=a(t),f=o(t,"OL",{});var B=k(f);Cs=o(B,"LI",{"data-svelte-h":!0}),p(Cs)!=="svelte-1ea113g"&&(Cs.innerHTML=lo),ga=a(B),Le=o(B,"LI",{});var Ta=k(Le);gs=o(Ta,"P",{"data-svelte-h":!0}),p(gs)!=="svelte-uug10y"&&(gs.innerHTML=no),Ia=a(Ta),c(He.$$.fragment,Ta),Ta.forEach(s),ba=a(B),Be=o(B,"LI",{});var fa=k(Be);Is=o(fa,"P",{"data-svelte-h":!0}),p(Is)!=="svelte-1bu8h49"&&(Is.innerHTML=ao),va=a(fa),c(ke.$$.fragment,fa),fa.forEach(s),Aa=a(B),Ee=o(B,"LI",{});var wa=k(Ee);bs=o(wa,"P",{"data-svelte-h":!0}),p(bs)!=="svelte-9fejhf"&&(bs.innerHTML=io),_a=a(wa),c(qe.$$.fragment,wa),wa.forEach(s),B.forEach(s),$n=a(t),c(Qe.$$.fragment,t),Zn=a(t),We=o(t,"P",{"data-svelte-h":!0}),p(We)!=="svelte-ielnui"&&(We.textContent=oo),Ln=a(t),Ne=o(t,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-1nzvpp6"&&(Ne.innerHTML=po),Hn=a(t),Se=o(t,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-itmw1a"&&(Se.innerHTML=ro),Bn=a(t),Re=o(t,"OL",{"data-svelte-h":!0}),p(Re)!=="svelte-46iinu"&&(Re.innerHTML=co),kn=a(t),Ge=o(t,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-a4qqfr"&&(Ge.innerHTML=uo),En=a(t),Xe=o(t,"P",{"data-svelte-h":!0}),p(Xe)!=="svelte-3hlmw"&&(Xe.textContent=Mo),qn=a(t),c(ze.$$.fragment,t),Qn=a(t),Ye=o(t,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-1j61g44"&&(Ye.textContent=ho),Wn=a(t),Ve=o(t,"UL",{"data-svelte-h":!0}),p(Ve)!=="svelte-1a6gefp"&&(Ve.innerHTML=yo),Nn=a(t),Pe=o(t,"P",{"data-svelte-h":!0}),p(Pe)!=="svelte-mqduir"&&(Pe.innerHTML=mo),Sn=a(t),Fe=o(t,"P",{"data-svelte-h":!0}),p(Fe)!=="svelte-1fri2t1"&&(Fe.textContent=jo),Rn=a(t),c(De.$$.fragment,t),Gn=a(t),Oe=o(t,"P",{"data-svelte-h":!0}),p(Oe)!=="svelte-1pg0b4o"&&(Oe.textContent=To),Xn=a(t),Ke=o(t,"UL",{"data-svelte-h":!0}),p(Ke)!=="svelte-1a3rfwc"&&(Ke.innerHTML=fo),zn=a(t),ts=o(t,"P",{"data-svelte-h":!0}),p(ts)!=="svelte-1gfkg27"&&(ts.innerHTML=wo),Yn=a(t),es=o(t,"P",{"data-svelte-h":!0}),p(es)!=="svelte-16xa10t"&&(es.textContent=Jo),Vn=a(t),ss=o(t,"OL",{"data-svelte-h":!0}),p(ss)!=="svelte-xvk7zd"&&(ss.innerHTML=Uo),Pn=a(t),ls=o(t,"P",{"data-svelte-h":!0}),p(ls)!=="svelte-1t6xdcm"&&(ls.innerHTML=Co),Fn=a(t),ns=o(t,"UL",{"data-svelte-h":!0}),p(ns)!=="svelte-1lrs7nq"&&(ns.innerHTML=go),Dn=a(t),x=o(t,"P",{align:!0,"data-svelte-h":!0}),p(x)!=="svelte-gebtxy"&&(x.innerHTML=Io),On=a(t),$=o(t,"P",{align:!0,"data-svelte-h":!0}),p($)!=="svelte-1nilrco"&&($.innerHTML=bo),Kn=a(t),as=o(t,"UL",{"data-svelte-h":!0}),p(as)!=="svelte-ya9pqf"&&(as.innerHTML=vo),ta=a(t),is=o(t,"P",{"data-svelte-h":!0}),p(is)!=="svelte-5yw35g"&&(is.innerHTML=Ao),ea=a(t),os=o(t,"P",{"data-svelte-h":!0}),p(os)!=="svelte-67cyg"&&(os.innerHTML=_o),sa=a(t),c(ps.$$.fragment,t),la=a(t),rs=o(t,"P",{"data-svelte-h":!0}),p(rs)!=="svelte-rqagvd"&&(rs.textContent=xo),na=a(t),cs=o(t,"UL",{"data-svelte-h":!0}),p(cs)!=="svelte-sb7wdj"&&(cs.innerHTML=$o),aa=a(t),us=o(t,"P",{"data-svelte-h":!0}),p(us)!=="svelte-1ezclbk"&&(us.textContent=Zo),ia=a(t),Z=o(t,"P",{align:!0,"data-svelte-h":!0}),p(Z)!=="svelte-mocte1"&&(Z.innerHTML=Lo),oa=a(t),L=o(t,"P",{align:!0,"data-svelte-h":!0}),p(L)!=="svelte-15kockq"&&(L.innerHTML=Ho),pa=a(t),c(Ms.$$.fragment,t),ra=a(t),hs=o(t,"P",{"data-svelte-h":!0}),p(hs)!=="svelte-1h575sh"&&(hs.textContent=Bo),ca=a(t),ys=o(t,"UL",{"data-svelte-h":!0}),p(ys)!=="svelte-1t7hhz6"&&(ys.innerHTML=ko),ua=a(t),ms=o(t,"P",{"data-svelte-h":!0}),p(ms)!=="svelte-kg8fpw"&&(ms.textContent=Eo),Ma=a(t),c(H.$$.fragment,t),ha=a(t),js=o(t,"P",{"data-svelte-h":!0}),p(js)!=="svelte-k8021v"&&(js.textContent=qo),ya=a(t),c(ds.$$.fragment,t),ma=a(t),c(Ts.$$.fragment,t),ja=a(t),vs=o(t,"P",{}),k(vs).forEach(s),this.h()},h(){w(d,"name","hf:doc:metadata"),w(d,"content",Do),w(g,"align","center"),w(I,"align","center"),w(b,"align","center"),w(v,"align","center"),w(A,"align","center"),w(_,"align","center"),w(x,"align","center"),w($,"align","center"),w(Z,"align","center"),w(L,"align","center")},m(t,e){j(document.head,d),l(t,E,e),l(t,J,e),l(t,fs,e),u(q,t,e),l(t,_s,e),l(t,Q,e),l(t,xs,e),l(t,W,e),l(t,$s,e),l(t,N,e),l(t,Zs,e),l(t,S,e),l(t,Ls,e),l(t,g,e),l(t,Hs,e),l(t,I,e),l(t,Bs,e),l(t,R,e),l(t,ks,e),u(G,t,e),l(t,Es,e),l(t,X,e),l(t,qs,e),u(z,t,e),l(t,Qs,e),l(t,Y,e),l(t,Ws,e),l(t,V,e),l(t,Ns,e),u(P,t,e),l(t,Ss,e),l(t,F,e),l(t,Rs,e),u(D,t,e),l(t,Gs,e),u(O,t,e),l(t,Xs,e),u(K,t,e),l(t,zs,e),l(t,tt,e),l(t,Ys,e),u(et,t,e),l(t,Vs,e),u(st,t,e),l(t,Ps,e),l(t,lt,e),l(t,Fs,e),l(t,nt,e),l(t,Ds,e),l(t,at,e),l(t,Os,e),l(t,it,e),l(t,Ks,e),u(ot,t,e),l(t,tl,e),l(t,pt,e),l(t,el,e),l(t,U,e),j(U,ws),j(U,Ja),j(U,Js),j(Js,Ua),u(rt,Js,null),j(U,Ca),j(U,Us),l(t,sl,e),l(t,ct,e),l(t,ll,e),u(ut,t,e),l(t,nl,e),u(Mt,t,e),l(t,al,e),l(t,ht,e),l(t,il,e),l(t,yt,e),l(t,ol,e),l(t,mt,e),l(t,pl,e),l(t,jt,e),l(t,rl,e),l(t,dt,e),l(t,cl,e),u(Tt,t,e),l(t,ul,e),u(ft,t,e),l(t,Ml,e),l(t,wt,e),l(t,hl,e),l(t,Jt,e),l(t,yl,e),l(t,Ut,e),l(t,ml,e),u(Ct,t,e),l(t,jl,e),l(t,gt,e),l(t,dl,e),l(t,It,e),l(t,Tl,e),l(t,bt,e),l(t,fl,e),l(t,vt,e),l(t,wl,e),u(At,t,e),l(t,Jl,e),l(t,b,e),l(t,Ul,e),l(t,v,e),l(t,Cl,e),l(t,_t,e),l(t,gl,e),l(t,xt,e),l(t,Il,e),l(t,$t,e),l(t,bl,e),u(Zt,t,e),l(t,vl,e),l(t,Lt,e),l(t,Al,e),l(t,Ht,e),l(t,_l,e),l(t,Bt,e),l(t,xl,e),l(t,kt,e),l(t,$l,e),u(Et,t,e),l(t,Zl,e),l(t,qt,e),l(t,Ll,e),l(t,Qt,e),l(t,Hl,e),u(Wt,t,e),l(t,Bl,e),l(t,Nt,e),l(t,kl,e),l(t,St,e),l(t,El,e),l(t,Rt,e),l(t,ql,e),l(t,Gt,e),l(t,Ql,e),l(t,Xt,e),l(t,Wl,e),l(t,zt,e),l(t,Nl,e),u(Yt,t,e),l(t,Sl,e),l(t,Vt,e),l(t,Rl,e),l(t,Pt,e),l(t,Gl,e),u(Ft,t,e),l(t,Xl,e),l(t,A,e),l(t,zl,e),l(t,_,e),l(t,Yl,e),l(t,Dt,e),l(t,Vl,e),l(t,Ot,e),l(t,Pl,e),u(Kt,t,e),l(t,Fl,e),l(t,te,e),l(t,Dl,e),l(t,ee,e),l(t,Ol,e),u(se,t,e),l(t,Kl,e),l(t,le,e),l(t,tn,e),l(t,ne,e),l(t,en,e),l(t,ae,e),l(t,sn,e),l(t,ie,e),l(t,ln,e),l(t,oe,e),l(t,nn,e),l(t,pe,e),l(t,an,e),l(t,re,e),l(t,on,e),u(ce,t,e),l(t,pn,e),l(t,ue,e),l(t,rn,e),l(t,Me,e),l(t,cn,e),l(t,he,e),l(t,un,e),l(t,ye,e),l(t,Mn,e),u(me,t,e),l(t,hn,e),l(t,je,e),l(t,yn,e),l(t,de,e),l(t,mn,e),l(t,Te,e),l(t,jn,e),l(t,fe,e),l(t,dn,e),u(we,t,e),l(t,Tn,e),l(t,Je,e),l(t,fn,e),l(t,Ue,e),l(t,wn,e),u(Ce,t,e),l(t,Jn,e),l(t,ge,e),l(t,Un,e),l(t,Ie,e),l(t,Cn,e),u(be,t,e),l(t,gn,e),l(t,ve,e),l(t,In,e),u(Ae,t,e),l(t,bn,e),l(t,_e,e),l(t,vn,e),u(xe,t,e),l(t,An,e),l(t,$e,e),l(t,_n,e),l(t,Ze,e),l(t,xn,e),l(t,f,e),j(f,Cs),j(f,ga),j(f,Le),j(Le,gs),j(Le,Ia),u(He,Le,null),j(f,ba),j(f,Be),j(Be,Is),j(Be,va),u(ke,Be,null),j(f,Aa),j(f,Ee),j(Ee,bs),j(Ee,_a),u(qe,Ee,null),l(t,$n,e),u(Qe,t,e),l(t,Zn,e),l(t,We,e),l(t,Ln,e),l(t,Ne,e),l(t,Hn,e),l(t,Se,e),l(t,Bn,e),l(t,Re,e),l(t,kn,e),l(t,Ge,e),l(t,En,e),l(t,Xe,e),l(t,qn,e),u(ze,t,e),l(t,Qn,e),l(t,Ye,e),l(t,Wn,e),l(t,Ve,e),l(t,Nn,e),l(t,Pe,e),l(t,Sn,e),l(t,Fe,e),l(t,Rn,e),u(De,t,e),l(t,Gn,e),l(t,Oe,e),l(t,Xn,e),l(t,Ke,e),l(t,zn,e),l(t,ts,e),l(t,Yn,e),l(t,es,e),l(t,Vn,e),l(t,ss,e),l(t,Pn,e),l(t,ls,e),l(t,Fn,e),l(t,ns,e),l(t,Dn,e),l(t,x,e),l(t,On,e),l(t,$,e),l(t,Kn,e),l(t,as,e),l(t,ta,e),l(t,is,e),l(t,ea,e),l(t,os,e),l(t,sa,e),u(ps,t,e),l(t,la,e),l(t,rs,e),l(t,na,e),l(t,cs,e),l(t,aa,e),l(t,us,e),l(t,ia,e),l(t,Z,e),l(t,oa,e),l(t,L,e),l(t,pa,e),u(Ms,t,e),l(t,ra,e),l(t,hs,e),l(t,ca,e),l(t,ys,e),l(t,ua,e),l(t,ms,e),l(t,Ma,e),u(H,t,e),l(t,ha,e),l(t,js,e),l(t,ya,e),u(ds,t,e),l(t,ma,e),u(Ts,t,e),l(t,ja,e),l(t,vs,e),da=!0},p(t,[e]){const C={};e&2&&(C.$$scope={dirty:e,ctx:t}),H.$set(C)},i(t){da||(M(q.$$.fragment,t),M(G.$$.fragment,t),M(z.$$.fragment,t),M(P.$$.fragment,t),M(D.$$.fragment,t),M(O.$$.fragment,t),M(K.$$.fragment,t),M(et.$$.fragment,t),M(st.$$.fragment,t),M(ot.$$.fragment,t),M(rt.$$.fragment,t),M(ut.$$.fragment,t),M(Mt.$$.fragment,t),M(Tt.$$.fragment,t),M(ft.$$.fragment,t),M(Ct.$$.fragment,t),M(At.$$.fragment,t),M(Zt.$$.fragment,t),M(Et.$$.fragment,t),M(Wt.$$.fragment,t),M(Yt.$$.fragment,t),M(Ft.$$.fragment,t),M(Kt.$$.fragment,t),M(se.$$.fragment,t),M(ce.$$.fragment,t),M(me.$$.fragment,t),M(we.$$.fragment,t),M(Ce.$$.fragment,t),M(be.$$.fragment,t),M(Ae.$$.fragment,t),M(xe.$$.fragment,t),M(He.$$.fragment,t),M(ke.$$.fragment,t),M(qe.$$.fragment,t),M(Qe.$$.fragment,t),M(ze.$$.fragment,t),M(De.$$.fragment,t),M(ps.$$.fragment,t),M(Ms.$$.fragment,t),M(H.$$.fragment,t),M(ds.$$.fragment,t),M(Ts.$$.fragment,t),da=!0)},o(t){h(q.$$.fragment,t),h(G.$$.fragment,t),h(z.$$.fragment,t),h(P.$$.fragment,t),h(D.$$.fragment,t),h(O.$$.fragment,t),h(K.$$.fragment,t),h(et.$$.fragment,t),h(st.$$.fragment,t),h(ot.$$.fragment,t),h(rt.$$.fragment,t),h(ut.$$.fragment,t),h(Mt.$$.fragment,t),h(Tt.$$.fragment,t),h(ft.$$.fragment,t),h(Ct.$$.fragment,t),h(At.$$.fragment,t),h(Zt.$$.fragment,t),h(Et.$$.fragment,t),h(Wt.$$.fragment,t),h(Yt.$$.fragment,t),h(Ft.$$.fragment,t),h(Kt.$$.fragment,t),h(se.$$.fragment,t),h(ce.$$.fragment,t),h(me.$$.fragment,t),h(we.$$.fragment,t),h(Ce.$$.fragment,t),h(be.$$.fragment,t),h(Ae.$$.fragment,t),h(xe.$$.fragment,t),h(He.$$.fragment,t),h(ke.$$.fragment,t),h(qe.$$.fragment,t),h(Qe.$$.fragment,t),h(ze.$$.fragment,t),h(De.$$.fragment,t),h(ps.$$.fragment,t),h(Ms.$$.fragment,t),h(H.$$.fragment,t),h(ds.$$.fragment,t),h(Ts.$$.fragment,t),da=!1},d(t){t&&(s(E),s(J),s(fs),s(_s),s(Q),s(xs),s(W),s($s),s(N),s(Zs),s(S),s(Ls),s(g),s(Hs),s(I),s(Bs),s(R),s(ks),s(Es),s(X),s(qs),s(Qs),s(Y),s(Ws),s(V),s(Ns),s(Ss),s(F),s(Rs),s(Gs),s(Xs),s(zs),s(tt),s(Ys),s(Vs),s(Ps),s(lt),s(Fs),s(nt),s(Ds),s(at),s(Os),s(it),s(Ks),s(tl),s(pt),s(el),s(U),s(sl),s(ct),s(ll),s(nl),s(al),s(ht),s(il),s(yt),s(ol),s(mt),s(pl),s(jt),s(rl),s(dt),s(cl),s(ul),s(Ml),s(wt),s(hl),s(Jt),s(yl),s(Ut),s(ml),s(jl),s(gt),s(dl),s(It),s(Tl),s(bt),s(fl),s(vt),s(wl),s(Jl),s(b),s(Ul),s(v),s(Cl),s(_t),s(gl),s(xt),s(Il),s($t),s(bl),s(vl),s(Lt),s(Al),s(Ht),s(_l),s(Bt),s(xl),s(kt),s($l),s(Zl),s(qt),s(Ll),s(Qt),s(Hl),s(Bl),s(Nt),s(kl),s(St),s(El),s(Rt),s(ql),s(Gt),s(Ql),s(Xt),s(Wl),s(zt),s(Nl),s(Sl),s(Vt),s(Rl),s(Pt),s(Gl),s(Xl),s(A),s(zl),s(_),s(Yl),s(Dt),s(Vl),s(Ot),s(Pl),s(Fl),s(te),s(Dl),s(ee),s(Ol),s(Kl),s(le),s(tn),s(ne),s(en),s(ae),s(sn),s(ie),s(ln),s(oe),s(nn),s(pe),s(an),s(re),s(on),s(pn),s(ue),s(rn),s(Me),s(cn),s(he),s(un),s(ye),s(Mn),s(hn),s(je),s(yn),s(de),s(mn),s(Te),s(jn),s(fe),s(dn),s(Tn),s(Je),s(fn),s(Ue),s(wn),s(Jn),s(ge),s(Un),s(Ie),s(Cn),s(gn),s(ve),s(In),s(bn),s(_e),s(vn),s(An),s($e),s(_n),s(Ze),s(xn),s(f),s($n),s(Zn),s(We),s(Ln),s(Ne),s(Hn),s(Se),s(Bn),s(Re),s(kn),s(Ge),s(En),s(Xe),s(qn),s(Qn),s(Ye),s(Wn),s(Ve),s(Nn),s(Pe),s(Sn),s(Fe),s(Rn),s(Gn),s(Oe),s(Xn),s(Ke),s(zn),s(ts),s(Yn),s(es),s(Vn),s(ss),s(Pn),s(ls),s(Fn),s(ns),s(Dn),s(x),s(On),s($),s(Kn),s(as),s(ta),s(is),s(ea),s(os),s(sa),s(la),s(rs),s(na),s(cs),s(aa),s(us),s(ia),s(Z),s(oa),s(L),s(pa),s(ra),s(hs),s(ca),s(ys),s(ua),s(ms),s(Ma),s(ha),s(js),s(ya),s(ma),s(ja),s(vs)),s(d),y(q,t),y(G,t),y(z,t),y(P,t),y(D,t),y(O,t),y(K,t),y(et,t),y(st,t),y(ot,t),y(rt),y(ut,t),y(Mt,t),y(Tt,t),y(ft,t),y(Ct,t),y(At,t),y(Zt,t),y(Et,t),y(Wt,t),y(Yt,t),y(Ft,t),y(Kt,t),y(se,t),y(ce,t),y(me,t),y(we,t),y(Ce,t),y(be,t),y(Ae,t),y(xe,t),y(He),y(ke),y(qe),y(Qe,t),y(ze,t),y(De,t),y(ps,t),y(Ms,t),y(H,t),y(ds,t),y(Ts,t)}}}const Do='{"title":"HIL-SERL Real Robot Training Workflow Guide","local":"hil-serl-real-robot-training-workflow-guide","sections":[{"title":"What do I need?","local":"what-do-i-need","sections":[],"depth":2},{"title":"What kind of tasks can I train?","local":"what-kind-of-tasks-can-i-train","sections":[],"depth":2},{"title":"Install LeRobot with HIL-SERL","local":"install-lerobot-with-hil-serl","sections":[],"depth":2},{"title":"Real Robot Training Workflow","local":"real-robot-training-workflow","sections":[{"title":"Understanding Configuration","local":"understanding-configuration","sections":[],"depth":3},{"title":"Finding Robot Workspace Bounds","local":"finding-robot-workspace-bounds","sections":[],"depth":3},{"title":"Collecting Demonstrations","local":"collecting-demonstrations","sections":[],"depth":3},{"title":"Using a Teleoperation Device","local":"using-a-teleoperation-device","sections":[],"depth":3},{"title":"Processing the Dataset","local":"processing-the-dataset","sections":[],"depth":3},{"title":"Training a Reward Classifier","local":"training-a-reward-classifier","sections":[],"depth":3},{"title":"Training with Actor-Learner","local":"training-with-actor-learner","sections":[],"depth":3},{"title":"Guide to Human Interventions","local":"guide-to-human-interventions","sections":[],"depth":3},{"title":"Key hyperparameters to tune","local":"key-hyperparameters-to-tune","sections":[],"depth":3}],"depth":2}],"depth":1}';function Oo(As){return Wo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class np extends So{constructor(d){super(),Ro(this,d,Oo,Fo,Qo,{})}}export{np as component};
