import{s as et,o as lt,n as tt}from"../chunks/scheduler.65852ee5.js";import{S as nt,i as at,g as p,s as n,r as M,A as pt,h as i,f as l,c as a,j as Ol,u as c,x as o,k as cl,l as st,y as it,a as t,v as y,d as r,t as m,w as d}from"../chunks/index.aa74147d.js";import{T as ot}from"../chunks/Tip.bb8ccac8.js";import{D as Mt,C as h}from"../chunks/DocNotebookDropdown.479f4286.js";import{H as J,E as ct}from"../chunks/EditOnGithub.4eda6a96.js";function yt(Ss){let j,g='For VLMs, an image represents a certain amount of tokens. For Idefics2, for example, one image represents 64 tokens at low resolution and 5*64=320 tokens in high resolution. High resolution is the default in TGI (see <code>do_image_splitting</code> in the <a href="https://huggingface.co/HuggingFaceM4/idefics2-8b-chatty" rel="nofollow">model card</a> for details). This means that one image consumed 320 tokens.';return{c(){j=p("p"),j.innerHTML=g},l(u){j=i(u,"P",{"data-svelte-h":!0}),o(j)!=="svelte-1r2dwpj"&&(j.innerHTML=g)},m(u,qs){t(u,j,qs)},p:tt,d(u){u&&l(j)}}}function rt(Ss){let j,g,u,qs,I,Ys,b,Ns,f,yl='<em>Authored by: <a href="https://huggingface.co/MoritzLaurer" rel="nofollow">Moritz Laurer</a></em>',zs,C,rl='Have you ever wanted to create your own machine learning API? That’s what we will do in this recipe with the <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">HF Dedicated Inference Endpoints</a>. Inference Endpoints enable you to pick any of the hundreds of thousands of models on the HF Hub, create your own API on a deployment platform you control, and on hardware you choose.',Fs,Z,ml='<a href="link-to-recipe">Serverless Inference APIs</a> are great for initial testing, but they are limited to a pre-configured selection of popular models and they are rate limited, because the serverless API’s hardware is used by many users at the same time. With a Dedicated Inference Endpoint, you can customize the deployment of your model and the hardware is exclusively dedicated to you.',$s,B,dl="In this recipe, we will:",xs,G,hl="<li>Create an Inference Endpoint via a simple UI and send standard HTTP requests to the Endpoint</li> <li>Create and manage different Inference Endpoints programmatically with the <code>huggingface_hub</code> library</li> <li>Cover three use-cases: text generation with an LLM, image generation with Stable Diffusion, and reasoning over images with Idefics2.</li>",Ls,W,Ps,A,jl='In case you don’t have a HF Account, you can create your account <a href="https://huggingface.co/join" rel="nofollow">here</a>. If you work in a larger team, you can also create a <a href="https://huggingface.co/organizations" rel="nofollow">HF Organization</a> and manage all your models, datasets and Endpoints via this organization. Dedicated Inference Endpoints are a paid service and you will therefore need to add a credit card to the <a href="https://huggingface.co/settings/billing" rel="nofollow">billing settings</a> of your personal HF account, or of your HF organization.',Ds,E,ul='You can then create a user access token <a href="https://huggingface.co/docs/hub/security-tokens" rel="nofollow">here</a>. A token with <code>read</code> or <code>write</code> permissions will work for this guide, but we encourage the use of fine-grained tokens for increased security. For this notebook, you’ll need a fine-grained token with <code>User Permissions &gt; Inference &gt; Make calls to Inference Endpoints &amp; Manage Inference Endpoints</code> and <code>Repository permissions &gt; google/gemma-1.1-2b-it &amp; HuggingFaceM4/idefics2-8b-chatty</code>.',Ks,k,Os,V,se,v,ee,R,Jl='With this initial setup out of the way, we can now create our first Endpoint. Navigate to <a href="https://ui.endpoints.huggingface.co/" rel="nofollow">https://ui.endpoints.huggingface.co/</a> and click on <code>+ New</code> next to <code>Dedicated Endpoints</code>. You will then see the interface for creating a new Endpoint with the following options (see image below):',le,Q,wl='<li><strong>Model Repository</strong>: Here you can insert the identifier of any model on the HF Hub. For this initial demonstration, we use <a href="https://huggingface.co/google/gemma-1.1-2b-it" rel="nofollow">google/gemma-1.1-2b-it</a>, a small generative LLM (2.5B parameters).</li> <li><strong>Endpoint Name</strong>: The Endpoint Name is automatically generated based on the model identifier, but you are free to change the name. Valid Endpoint names must only contain lower-case characters, numbers or hyphens (”-”) and are between 4 to 32 characters long.</li> <li><strong>Instance Configuration</strong>: Here you can choose from a wide range of CPUs or GPUs from all major cloud platforms. You can also adjust the region, for example if you need to host your Endpoint in the EU.</li> <li><strong>Automatic Scale-to-Zero</strong>: You can configure your Endpoint to scale to zero GPUs/CPUs after a certain amount of time. Scaled-to-zero Endpoints are not billed anymore. Note that restarting the Endpoint requires the model to be re-loaded into memory (and potentially re-downloaded), which can take several minutes for large models.</li> <li><strong>Endpoint Security Level</strong>: The standard security level is <code>Protected</code>, which requires an authorized HF token for accessing the Endpoint. <code>Public</code> Endpoints are accessible by anyone without token authentification. <code>Private</code> Endpoints are only available through an intra-region secured AWS or Azure PrivateLink connection.</li> <li><strong>Advanced configuration</strong>: Here you can select some advanced options like the Docker container type. As Gemma is compatible with <a href="https://huggingface.co/docs/text-generation-inference/index" rel="nofollow">Text Generation Inference (TGI)</a> containers, the system automatically selects TGI as the container type and other good default values.</li>',te,H,Tl="For this guide, select the options in the image below and click on <code>Create Endpoint</code>.",ne,w,Ul='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/enterprise-endpoints-creation.png"/>',ae,_,gl="After roughly one minute, your Endpoint will be created and you will see a page similar to the image below.",pe,q,Il="On the Endpoint’s <code>Overview</code> page, will find the URL for querying the Endpoint, a Playground for testing the model and additional tabs on <code>Analytics</code>, <code>Usage &amp; Cost</code>, <code>Logs</code>and <code>Settings</code>.",ie,T,bl='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/enterprise-endpoint-overviewpage.png"/>',oe,X,Me,S,fl='When moving into production, you don’t always want to manually start, stop and modify your Endpoints. The <code>huggingface_hub</code> library provides good functionality for managing your Endpoints programmatically. See the docs <a href="https://huggingface.co/docs/huggingface_hub/guides/inference_endpoints" rel="nofollow">here</a> and details on all functions <a href="https://huggingface.co/docs/huggingface_hub/en/package_reference/inference_endpoints" rel="nofollow">here</a>. Here are some key functions:',ce,Y,ye,N,Cl="You can also create an inference Endpoint programmatically. Let’s recreate the same <code>gemma</code> LLM Endpoint as the one created with the UI.",re,z,me,F,de,$,he,x,Zl='Now let’s query this Endpoint like any other LLM API. First copy the Endpoint URL from the interface (or use <code>endpoint.url</code>) and assign it to <code>API_URL</code> below. We then use the standardised messages format for the text inputs, i.e. a dictionary of user and assistant messages, which you might know from other LLM API services. We then need to apply the chat template to the messages, which LLMs like Gemma, Llama-3 etc. have been trained to expect (see details on in the <a href="https://huggingface.co/docs/transformers/main/en/chat_templating" rel="nofollow">docs</a>). For most recent generative LLMs, it is essential to apply this chat template, otherwise the model’s performance will degrade without throwing an error.',je,L,ue,P,Bl=`Your text input looks like this, after the chat template has been applied:

<bos><start_of_turn>user
Please write a short poem about open source for me.<end_of_turn>
</end_of_turn></start_of_turn></bos>`,Je,D,we,K,Gl=`The output from your API/Endpoint call:

[&#123;'generated_text': "Free to use, free to share,\\nA collaborative code, a community's care.\\n\\nCode transparent, bugs readily found,\\nContributions welcome, stories unbound.\\nOpen source, a gift to all,\\nBuilding the future, one line at a call.\\n\\nSo join the movement, embrace the light,\\nOpen source, shining ever so bright."}]
`,Te,O,Wl="That’s it, you’ve made the first request to your Endpoint - your very own API!",Ue,ss,Al='If you want the Endpoint to handle the chat template automatically and if your LLM runs on a TGI container, you can also use the <a href="https://huggingface.co/docs/text-generation-inference/en/messages_api" rel="nofollow">messages API</a> by appending the <code>/v1/chat/completions</code> path to the URL. With the <code>/v1/chat/completions</code> path, the <a href="https://huggingface.co/docs/text-generation-inference/index" rel="nofollow">TGI</a> container running on the Endpoint applies the chat template automatically and is fully compatible with OpenAI’s API structure for easier interoperability. See the <a href="https://huggingface.github.io/text-generation-inference/#/Text%20Generation%20Inference/chat_completions" rel="nofollow">TGI Swagger UI</a> for all available parameters. Note that the parameters accepted by the default <code>/</code> path and by the <code>/v1/chat/completions</code> path are slightly different. Here is the slightly modified code for using the messages API:',ge,es,Ie,ls,El=`The output from your API/Endpoint call with the OpenAI-compatible messages API route:

&#123;'id': '', 'object': 'text_completion', 'created': 1718283608, 'model': '/repository', 'system_fingerprint': '2.0.5-dev0-sha-90184df', 'choices': [&#123;'index': 0, 'message': &#123;'role': 'assistant', 'content': '**Open Source**\\n\\nA license for the mind,\\nTo share, distribute, and bind,\\nIdeas freely given birth,\\nFor the good of all to sort.\\n\\nCode transparent, eyes open wide,\\nA permission for the wise,\\nTo learn, to build, to use at will,\\nA future bright, we help fill.\\n\\nFrom servers vast to candles low,\\nOpen source, a guiding key,\\nFor progress made, knowledge shared,\\nA future brimming with'}, 'logprobs': None, 'finish_reason': 'length'}], 'usage': &#123;'prompt_tokens': 20, 'completion_tokens': 100, 'total_tokens': 120}}
`,be,ts,fe,ns,kl='You can also use the <a href="https://huggingface.co/docs/huggingface_hub/en/package_reference/inference_client#huggingface_hub.InferenceClient" rel="nofollow"><code>InferenceClient</code></a> to easily send requests to your Endpoint. The client is a convenient utility available in the <code>huggingface_hub</code> Python library that allows you to easily make calls to both <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Dedicated Inference Endpoints</a> and the <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Serverless Inference API</a>. See the <a href="https://huggingface.co/docs/huggingface_hub/en/package_reference/inference_client#inference" rel="nofollow">docs</a> for details.',Ce,as,Vl="This is the most succinct way of sending requests to your Endpoint:",Ze,ps,Be,is,Ge,os,We,Ms,vl="Following the same process, you can create Endpoints for any of the models on the HF Hub. Let’s illustrate some other use-cases.",Ae,cs,Ee,ys,Rl="We can create an image generation Endpoint with almost the exact same code as for the LLM. The only difference is that we do not use the TGI container in this case, as TGI is only designed for LLMs (and vision LMs).",ke,rs,Ve,ms,Ql=`Collecting Pillow
  Downloading pillow-10.3.0-cp39-cp39-manylinux_2_28_x86_64.whl (4.5 MB)
\x1B[K     |████████████████████████████████| 4.5 MB 24.7 MB/s eta 0:00:01
\x1B[?25hInstalling collected packages: Pillow
Successfully installed Pillow-10.3.0
`,ve,ds,Re,hs,Hl=`Does the endpoint already exist? True
Waiting for endpoint to start
Endpoint ready
`,Qe,js,He,us,_l=`PROMPT:  A whimsical illustration of a fashionably dressed llama proudly holding a worn, vintage cookbook, with a warm cup of tea and a few freshly baked treats scattered around, set against a cozy background of rustic wood and blooming flowers.
`,_e,Js,ql="We pause the Endpoint again to stop billing.",qe,ws,Xe,Ts,Se,Us,Xl='Now let’s create an Endpoint for a vision language model (VLM). VLMs are very similar to LLMs, only that they can take both text and images as input simultaneously. Their output is autoregressively generated text, just like for a standard LLM. VLMs can tackle many tasks from visual question answering to document understanding. For this example, we use <a href="https://huggingface.co/blog/idefics2" rel="nofollow">Idefics2</a>, a powerful 8B parameter VLM.',Ye,gs,Sl="We first need to convert our PIL image generated with Stable Diffusion to a <code>base64</code> encoded string so that we can send it to the model over the network.",Ne,Is,ze,bs,Yl='Because VLMs and LLMs are so similar, we can use almost the same messages format and chat template again, only with some additional code for including the image in the prompt. See the <a href="https://huggingface.co/HuggingFaceM4/idefics2-8b" rel="nofollow">Idefics2 model card</a> for specific details on prompt formatting.',Fe,fs,$e,U,xe,Cs,Nl='Several VLMs like Idefics2 are also supported by TGI (see <a href="https://huggingface.co/docs/text-generation-inference/supported_models" rel="nofollow">list of supported models</a>), so we use the TGI container again when creating the Endpoint.',Le,Zs,Pe,Bs,zl=`Does the endpoint already exist? False
Waiting for endpoint to be created
Endpoint ready
`,De,Gs,Ke,Ws,Fl=`In a quaint little café, there lived a llama,
With glasses on his face, he was quite a charm.
He'd sit at the table,
With a book and a mable,
And sip from a cup of warm tea.
`,Oe,As,sl,Es,el,ks,$l="<li>When creating several Endpoints, you will probably get an error message that your GPU quota has been reached. Don’t hesitate to send a message to the email address in the error message and we will most likely increase your GPU quota.</li> <li>What is the difference between <code>paused</code> and <code>scaled-to-zero</code> Endpoints? <code>scaled-to-zero</code> Endpoints can be flexibly woken up and scaled up by user requests, while <code>paused</code> Endpoints need to be unpaused by the creator of the Endpoint. Moreover, <code>scaled-to-zero</code> Endpoints count towards your GPU quota (with the maximum possible replica it could be scaled up to), while <code>paused</code> Endpoints do not. A simple way of freeing up your GPU quota is therefore to pause some Endpoints.</li>",ll,Vs,tl,vs,xl="That’s it, you’ve created three different Endpoints (your own APIs!) for text-to-text, text-to-image, and image-to-text generation and the same is possible for many other models and tasks.",nl,Rs,Ll='We encourage you to read the Dedicated Inference Endpoint <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">docs</a> to learn more. If you are using generative LLMs and VLMs, we also recommend reading the TGI <a href="https://huggingface.co/docs/text-generation-inference/index" rel="nofollow">docs</a>, as the most popular LLMs/VLMs are also supported by TGI, which makes your Endpoints significantly more efficient.',al,Qs,Pl='You can, for example, use <strong>JSON-mode or function calling</strong> with open-source models via <a href="https://huggingface.co/docs/text-generation-inference/basic_tutorials/using_guidance" rel="nofollow">TGI Guidance</a> (see also this <a href="https://huggingface.co/learn/cookbook/structured_generation" rel="nofollow">recipe</a> for an example for RAG with structured generation).',pl,Hs,Dl="When moving your Endpoints into production, you will want to make several additional improvements to make your setup more efficient. When using TGI, you should send batches of requests to the Endpoint with asynchronous function calls to fully utilize the Endpoint’s hardware and you can adapt several container parameters to optimize latency and throughput for your use-case. We will cover these optimizations in another recipe.",il,_s,ol,Xs,Ml;return I=new Mt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/patch-1/notebooks/en/enterprise_dedicated_endpoints.ipynb"}]}}),b=new J({props:{title:"Inference Endpoints (dedicated)",local:"inference-endpoints-dedicated",headingTag:"h1"}}),W=new J({props:{title:"Install and login",local:"install-and-login",headingTag:"h2"}}),k=new h({props:{code:"IXBpcCUyMGluc3RhbGwlMjBodWdnaW5nZmFjZV9odWJ+JTNEMC4yMy4zJTBBIXBpcCUyMGluc3RhbGwlMjB0cmFuc2Zvcm1lcnN+JTNENC40MS4y",highlighted:`!pip install huggingface_hub~=<span class="hljs-number">0.23</span><span class="hljs-number">.3</span>
!pip install transformers~=<span class="hljs-number">4.41</span><span class="hljs-number">.2</span>`,wrap:!1}}),V=new h({props:{code:"JTIzJTIwTG9naW4lMjB0byUyMHRoZSUyMEhGJTIwSHViLiUyMFdlJTIwcmVjb21tZW5kJTIwdXNpbmclMjB0aGlzJTIwbG9naW4lMjBtZXRob2QlMEElMjMlMjB0byUyMGF2b2lkJTIwdGhlJTIwbmVlZCUyMGZvciUyMGV4cGxpY2l0bHklMjBzdG9yaW5nJTIweW91ciUyMEhGJTIwdG9rZW4lMjBpbiUyMHZhcmlhYmxlcyUwQWltcG9ydCUyMGh1Z2dpbmdmYWNlX2h1YiUwQSUwQWh1Z2dpbmdmYWNlX2h1Yi5pbnRlcnByZXRlcl9sb2dpbigp",highlighted:`<span class="hljs-comment"># Login to the HF Hub. We recommend using this login method</span>
<span class="hljs-comment"># to avoid the need for explicitly storing your HF token in variables</span>
<span class="hljs-keyword">import</span> huggingface_hub

huggingface_hub.interpreter_login()`,wrap:!1}}),v=new J({props:{title:"Creating your first Endpoint",local:"creating-your-first-endpoint",headingTag:"h2"}}),X=new J({props:{title:"Creating and managing Endpoints programmatically",local:"creating-and-managing-endpoints-programmatically",headingTag:"h3"}}),Y=new h({props:{code:"JTIzJTIwbGlzdCUyMGFsbCUyMHlvdXIlMjBpbmZlcmVuY2UlMjBlbmRwb2ludHMlMEFodWdnaW5nZmFjZV9odWIubGlzdF9pbmZlcmVuY2VfZW5kcG9pbnRzKCklMEElMEElMjMlMjBnZXQlMjBhbiUyMGV4aXN0aW5nJTIwZW5kcG9pbnQlMjBhbmQlMjBjaGVjayUyMGl0J3MlMjBzdGF0dXMlMEFlbmRwb2ludCUyMCUzRCUyMGh1Z2dpbmdmYWNlX2h1Yi5nZXRfaW5mZXJlbmNlX2VuZHBvaW50KCUwQSUyMCUyMCUyMCUyMG5hbWUlM0QlMjJnZW1tYS0xLTEtMmItaXQteWNpJTIyJTJDJTIwJTIwJTIzJTIwdGhlJTIwbmFtZSUyMG9mJTIwdGhlJTIwZW5kcG9pbnQlMEElMjAlMjAlMjAlMjBuYW1lc3BhY2UlM0QlMjJNb3JpdHpMYXVyZXIlMjIlMkMlMjAlMjAlMjMlMjB5b3VyJTIwdXNlciUyMG5hbWUlMjBvciUyMG9yZ2FuaXphdGlvbiUyMG5hbWUlMEEpJTBBcHJpbnQoZW5kcG9pbnQpJTBBJTBBJTIzJTIwUGF1c2UlMjBlbmRwb2ludCUyMHRvJTIwc3RvcCUyMGJpbGxpbmclMEFlbmRwb2ludC5wYXVzZSgpJTBBJTBBJTIzJTIwUmVzdW1lJTIwYW5kJTIwd2FpdCUyMHVudGlsJTIwdGhlJTIwZW5kcG9pbnQlMjBpcyUyMHJlYWR5JTBBJTIzJTIwZW5kcG9pbnQucmVzdW1lKCklMEElMjMlMjBlbmRwb2ludC53YWl0KCklMEElMEElMjMlMjBVcGRhdGUlMjB0aGUlMjBlbmRwb2ludCUyMHRvJTIwYSUyMGRpZmZlcmVudCUyMEdQVSUwQSUyMyUyMFlvdSUyMGNhbiUyMGZpbmQlMjB0aGUlMjBjb3JyZWN0JTIwYXJndW1lbnRzJTIwZm9yJTIwZGlmZmVyZW50JTIwaGFyZHdhcmUlMjB0eXBlcyUyMGluJTIwdGhpcyUyMHRhYmxlJTNBJTIwaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRvY3MlMkZpbmZlcmVuY2UtZW5kcG9pbnRzJTJGcHJpY2luZyUyM2dwdS1pbnN0YW5jZXMlMEElMjMlMjBlbmRwb2ludC51cGRhdGUoJTBBJTIzJTIwJTIwJTIwJTIwaW5zdGFuY2Vfc2l6ZSUzRCUyMngxJTIyJTJDJTBBJTIzJTIwJTIwJTIwJTIwaW5zdGFuY2VfdHlwZSUzRCUyMm52aWRpYS1hMTAwJTIyJTJDJTIwJTIwJTIzJTIwbnZpZGlhLWExMGclMEElMjMlMjAp",highlighted:`<span class="hljs-comment"># list all your inference endpoints</span>
huggingface_hub.list_inference_endpoints()

<span class="hljs-comment"># get an existing endpoint and check it&#x27;s status</span>
endpoint = huggingface_hub.get_inference_endpoint(
    name=<span class="hljs-string">&quot;gemma-1-1-2b-it-yci&quot;</span>,  <span class="hljs-comment"># the name of the endpoint</span>
    namespace=<span class="hljs-string">&quot;MoritzLaurer&quot;</span>,  <span class="hljs-comment"># your user name or organization name</span>
)
<span class="hljs-built_in">print</span>(endpoint)

<span class="hljs-comment"># Pause endpoint to stop billing</span>
endpoint.pause()

<span class="hljs-comment"># Resume and wait until the endpoint is ready</span>
<span class="hljs-comment"># endpoint.resume()</span>
<span class="hljs-comment"># endpoint.wait()</span>

<span class="hljs-comment"># Update the endpoint to a different GPU</span>
<span class="hljs-comment"># You can find the correct arguments for different hardware types in this table: https://huggingface.co/docs/inference-endpoints/pricing#gpu-instances</span>
<span class="hljs-comment"># endpoint.update(</span>
<span class="hljs-comment">#    instance_size=&quot;x1&quot;,</span>
<span class="hljs-comment">#    instance_type=&quot;nvidia-a100&quot;,  # nvidia-a10g</span>
<span class="hljs-comment"># )</span>`,wrap:!1}}),z=new h({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_inference_endpoint


model_id = <span class="hljs-string">&quot;google/gemma-1.1-2b-it&quot;</span>
endpoint_name = <span class="hljs-string">&quot;gemma-1-1-2b-it-001&quot;</span>  <span class="hljs-comment"># Valid Endpoint names must only contain lower-case characters, numbers or hyphens (&quot;-&quot;) and are between 4 to 32 characters long.</span>
namespace = <span class="hljs-string">&quot;MoritzLaurer&quot;</span>  <span class="hljs-comment"># your user or organization name</span>


<span class="hljs-comment"># check if endpoint with this name already exists from previous tests</span>
available_endpoints_names = [endpoint.name <span class="hljs-keyword">for</span> endpoint <span class="hljs-keyword">in</span> huggingface_hub.list_inference_endpoints()]
<span class="hljs-keyword">if</span> endpoint_name <span class="hljs-keyword">in</span> available_endpoints_names:
    endpoint_exists = <span class="hljs-literal">True</span>
<span class="hljs-keyword">else</span>:
    endpoint_exists = <span class="hljs-literal">False</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Does the endpoint already exist?&quot;</span>, endpoint_exists)


<span class="hljs-comment"># create new endpoint</span>
<span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> endpoint_exists:
    endpoint = create_inference_endpoint(
        endpoint_name,
        repository=model_id,
        namespace=namespace,
        framework=<span class="hljs-string">&quot;pytorch&quot;</span>,
        task=<span class="hljs-string">&quot;text-generation&quot;</span>,
        <span class="hljs-comment"># see the available hardware options here: https://huggingface.co/docs/inference-endpoints/pricing#pricing</span>
        accelerator=<span class="hljs-string">&quot;gpu&quot;</span>,
        vendor=<span class="hljs-string">&quot;aws&quot;</span>,
        region=<span class="hljs-string">&quot;us-east-1&quot;</span>,
        instance_size=<span class="hljs-string">&quot;x1&quot;</span>,
        instance_type=<span class="hljs-string">&quot;nvidia-a10g&quot;</span>,
        min_replica=<span class="hljs-number">0</span>,
        max_replica=<span class="hljs-number">1</span>,
        <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;protected&quot;</span>,
        <span class="hljs-comment"># since the LLM is compatible with TGI, we specify that we want to use the latest TGI image</span>
        custom_image={
            <span class="hljs-string">&quot;health_route&quot;</span>: <span class="hljs-string">&quot;/health&quot;</span>,
            <span class="hljs-string">&quot;env&quot;</span>: {<span class="hljs-string">&quot;MODEL_ID&quot;</span>: <span class="hljs-string">&quot;/repository&quot;</span>},
            <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;ghcr.io/huggingface/text-generation-inference:latest&quot;</span>,
        },
    )
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Waiting for endpoint to be created&quot;</span>)
    endpoint.wait()
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Endpoint ready&quot;</span>)

<span class="hljs-comment"># if endpoint with this name already exists, get and resume existing endpoint</span>
<span class="hljs-keyword">else</span>:
    endpoint = huggingface_hub.get_inference_endpoint(name=endpoint_name, namespace=namespace)
    <span class="hljs-keyword">if</span> endpoint.status <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;paused&quot;</span>, <span class="hljs-string">&quot;scaledToZero&quot;</span>]:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Resuming endpoint&quot;</span>)
        endpoint.resume()
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Waiting for endpoint to start&quot;</span>)
    endpoint.wait()
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Endpoint ready&quot;</span>)`,wrap:!1}}),F=new h({props:{code:"JTIzJTIwYWNjZXNzJTIwdGhlJTIwZW5kcG9pbnQlMjB1cmwlMjBmb3IlMjBBUEklMjBjYWxscyUwQXByaW50KGVuZHBvaW50LnVybCk=",highlighted:`<span class="hljs-comment"># access the endpoint url for API calls</span>
<span class="hljs-built_in">print</span>(endpoint.url)`,wrap:!1}}),$=new J({props:{title:"Querying your Endpoint",local:"querying-your-endpoint",headingTag:"h2"}}),L=new h({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># paste your endpoint URL here or reuse endpoint.url if you created the endpoint programmatically</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>API_URL = endpoint.url  <span class="hljs-comment"># or paste link like &quot;https://dz07884a53qjqb98.us-east-1.aws.endpoints.huggingface.cloud&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>HEADERS = {<span class="hljs-string">&quot;Authorization&quot;</span>: <span class="hljs-string">f&quot;Bearer <span class="hljs-subst">{huggingface_hub.get_token()}</span>&quot;</span>}


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># function for standard http requests</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">query</span>(<span class="hljs-params">payload=<span class="hljs-literal">None</span>, api_url=<span class="hljs-literal">None</span></span>):
<span class="hljs-meta">... </span>    response = requests.post(api_url, headers=HEADERS, json=payload)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> response.json()


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># define conversation input in messages format</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can also provide multiple turns between user and assistant</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
<span class="hljs-meta">... </span>    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Please write a short poem about open source for me.&quot;</span>},
<span class="hljs-meta">... </span>    <span class="hljs-comment"># {&quot;role&quot;: &quot;assistant&quot;, &quot;content&quot;: &quot;I am not in the mood.&quot;},</span>
<span class="hljs-meta">... </span>    <span class="hljs-comment"># {&quot;role&quot;: &quot;user&quot;, &quot;content&quot;: &quot;Can you please do this for me?&quot;},</span>
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># apply the chat template for the respective model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;google/gemma-1.1-2b-it&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(model_id)
<span class="hljs-meta">&gt;&gt;&gt; </span>messages_with_template = tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Your text input looks like this, after the chat template has been applied:\\n&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(messages_with_template)`,wrap:!1}}),D=new h({props:{code:"JTIzJTIwc2VuZCUyMHN0YW5kYXJkJTIwaHR0cCUyMHJlcXVlc3QlMjB0byUyMGVuZHBvaW50JTBBb3V0cHV0JTIwJTNEJTIwcXVlcnkoJTBBJTIwJTIwJTIwJTIwcGF5bG9hZCUzRCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmlucHV0cyUyMiUzQSUyMG1lc3NhZ2VzX3dpdGhfdGVtcGxhdGUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJwYXJhbWV0ZXJzJTIyJTNBJTIwJTdCJTIydGVtcGVyYXR1cmUlMjIlM0ElMjAwLjIlMkMlMjAlMjJtYXhfbmV3X3Rva2VucyUyMiUzQSUyMDEwMCUyQyUyMCUyMnNlZWQlMjIlM0ElMjA0MiUyQyUyMCUyMnJldHVybl9mdWxsX3RleHQlMjIlM0ElMjBGYWxzZSU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMGFwaV91cmwlM0RBUElfVVJMJTJDJTBBKSUwQSUwQXByaW50KCUyMlRoZSUyMG91dHB1dCUyMGZyb20lMjB5b3VyJTIwQVBJJTJGRW5kcG9pbnQlMjBjYWxsJTNBJTVDbiUyMiklMEFwcmludChvdXRwdXQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># send standard http request to endpoint</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output = query(
<span class="hljs-meta">... </span>    payload={
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;inputs&quot;</span>: messages_with_template,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;parameters&quot;</span>: {<span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.2</span>, <span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">100</span>, <span class="hljs-string">&quot;seed&quot;</span>: <span class="hljs-number">42</span>, <span class="hljs-string">&quot;return_full_text&quot;</span>: <span class="hljs-literal">False</span>},
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    api_url=API_URL,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;The output from your API/Endpoint call:\\n&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(output)`,wrap:!1}}),es=new h({props:{code:"QVBJX1VSTF9DSEFUJTIwJTNEJTIwQVBJX1VSTCUyMCUyQiUyMCUyMiUyRnYxJTJGY2hhdCUyRmNvbXBsZXRpb25zJTIyJTBBJTBBb3V0cHV0JTIwJTNEJTIwcXVlcnkoJTBBJTIwJTIwJTIwJTIwcGF5bG9hZCUzRCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1lc3NhZ2VzJTIyJTNBJTIwbWVzc2FnZXMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtb2RlbCUyMiUzQSUyMCUyMnRnaSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjAlN0IlMjJ0ZW1wZXJhdHVyZSUyMiUzQSUyMDAuMiUyQyUyMCUyMm1heF90b2tlbnMlMjIlM0ElMjAxMDAlMkMlMjAlMjJzZWVkJTIyJTNBJTIwNDIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjBhcGlfdXJsJTNEQVBJX1VSTF9DSEFUJTJDJTBBKSUwQSUwQXByaW50KCUyMlRoZSUyMG91dHB1dCUyMGZyb20lMjB5b3VyJTIwQVBJJTJGRW5kcG9pbnQlMjBjYWxsJTIwd2l0aCUyMHRoZSUyME9wZW5BSS1jb21wYXRpYmxlJTIwbWVzc2FnZXMlMjBBUEklMjByb3V0ZSUzQSU1Q24lMjIpJTBBcHJpbnQob3V0cHV0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>API_URL_CHAT = API_URL + <span class="hljs-string">&quot;/v1/chat/completions&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>output = query(
<span class="hljs-meta">... </span>    payload={
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;messages&quot;</span>: messages,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;model&quot;</span>: <span class="hljs-string">&quot;tgi&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;parameters&quot;</span>: {<span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.2</span>, <span class="hljs-string">&quot;max_tokens&quot;</span>: <span class="hljs-number">100</span>, <span class="hljs-string">&quot;seed&quot;</span>: <span class="hljs-number">42</span>},
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    api_url=API_URL_CHAT,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;The output from your API/Endpoint call with the OpenAI-compatible messages API route:\\n&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(output)`,wrap:!1}}),ts=new J({props:{title:"Simplified Endpoint usage with the InferenceClient",local:"simplified-endpoint-usage-with-the-inferenceclient",headingTag:"h3"}}),ps=new h({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQSUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBJTBBb3V0cHV0JTIwJTNEJTIwY2xpZW50LmNoYXRfY29tcGxldGlvbiglMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUyQyUyMCUyMCUyMyUyMHRoZSUyMGNoYXQlMjB0ZW1wbGF0ZSUyMGlzJTIwYXBwbGllZCUyMGF1dG9tYXRpY2FsbHklMkMlMjBpZiUyMHlvdXIlMjBlbmRwb2ludCUyMHVzZXMlMjBhJTIwVEdJJTIwY29udGFpbmVyJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0RBUElfVVJMJTJDJTBBJTIwJTIwJTIwJTIwdGVtcGVyYXR1cmUlM0QwLjIlMkMlMEElMjAlMjAlMjAlMjBtYXhfdG9rZW5zJTNEMTAwJTJDJTBBJTIwJTIwJTIwJTIwc2VlZCUzRDQyJTJDJTBBKSUwQSUwQXByaW50KCUyMlRoZSUyMG91dHB1dCUyMGZyb20lMjB5b3VyJTIwQVBJJTJGRW5kcG9pbnQlMjBjYWxsJTIwd2l0aCUyMHRoZSUyMEluZmVyZW5jZUNsaWVudCUzQSU1Q24lMjIpJTBBcHJpbnQob3V0cHV0KQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

client = InferenceClient()

output = client.chat_completion(
    messages,  <span class="hljs-comment"># the chat template is applied automatically, if your endpoint uses a TGI container</span>
    model=API_URL,
    temperature=<span class="hljs-number">0.2</span>,
    max_tokens=<span class="hljs-number">100</span>,
    seed=<span class="hljs-number">42</span>,
)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;The output from your API/Endpoint call with the InferenceClient:\\n&quot;</span>)
<span class="hljs-built_in">print</span>(output)`,wrap:!1}}),is=new h({props:{code:"JTIzJTIwcGF1c2UlMjB0aGUlMjBlbmRwb2ludCUyMHRvJTIwc3RvcCUyMGJpbGxpbmclMEElMjMlMjBlbmRwb2ludC5wYXVzZSgp",highlighted:`<span class="hljs-comment"># pause the endpoint to stop billing</span>
<span class="hljs-comment"># endpoint.pause()</span>`,wrap:!1}}),os=new J({props:{title:"Creating Endpoints for a wide variety of models",local:"creating-endpoints-for-a-wide-variety-of-models",headingTag:"h2"}}),cs=new J({props:{title:"Image generation with Stable Diffusion",local:"image-generation-with-stable-diffusion",headingTag:"h3"}}),rs=new h({props:{code:"IXBpcCUyMGluc3RhbGwlMjBQaWxsb3clMjAlMjAlMjMlMjBmb3IlMjBpbWFnZSUyMHByb2Nlc3Npbmc=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>!pip install Pillow  <span class="hljs-comment"># for image processing</span>',wrap:!1}}),ds=new h({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_inference_endpoint

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint_name = <span class="hljs-string">&quot;stable-diffusion-xl-base-1-0-001&quot;</span>  <span class="hljs-comment"># Valid Endpoint names must only contain lower-case characters, numbers or hyphens (&quot;-&quot;) and are between 4 to 32 characters long.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>namespace = <span class="hljs-string">&quot;MoritzLaurer&quot;</span>  <span class="hljs-comment"># your user or organization name</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>task = <span class="hljs-string">&quot;text-to-image&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># check if endpoint with this name already exists from previous tests</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>available_endpoints_names = [endpoint.name <span class="hljs-keyword">for</span> endpoint <span class="hljs-keyword">in</span> huggingface_hub.list_inference_endpoints()]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> endpoint_name <span class="hljs-keyword">in</span> available_endpoints_names:
<span class="hljs-meta">... </span>    endpoint_exists = <span class="hljs-literal">True</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>    endpoint_exists = <span class="hljs-literal">False</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Does the endpoint already exist?&quot;</span>, endpoint_exists)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># create new endpoint</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> endpoint_exists:
<span class="hljs-meta">... </span>    endpoint = create_inference_endpoint(
<span class="hljs-meta">... </span>        endpoint_name,
<span class="hljs-meta">... </span>        repository=model_id,
<span class="hljs-meta">... </span>        namespace=namespace,
<span class="hljs-meta">... </span>        framework=<span class="hljs-string">&quot;pytorch&quot;</span>,
<span class="hljs-meta">... </span>        task=task,
<span class="hljs-meta">... </span>        <span class="hljs-comment"># see the available hardware options here: https://huggingface.co/docs/inference-endpoints/pricing#pricing</span>
<span class="hljs-meta">... </span>        accelerator=<span class="hljs-string">&quot;gpu&quot;</span>,
<span class="hljs-meta">... </span>        vendor=<span class="hljs-string">&quot;aws&quot;</span>,
<span class="hljs-meta">... </span>        region=<span class="hljs-string">&quot;us-east-1&quot;</span>,
<span class="hljs-meta">... </span>        instance_size=<span class="hljs-string">&quot;x1&quot;</span>,
<span class="hljs-meta">... </span>        instance_type=<span class="hljs-string">&quot;nvidia-a100&quot;</span>,
<span class="hljs-meta">... </span>        min_replica=<span class="hljs-number">0</span>,
<span class="hljs-meta">... </span>        max_replica=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>        <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;protected&quot;</span>,
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Waiting for endpoint to be created&quot;</span>)
<span class="hljs-meta">... </span>    endpoint.wait()
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Endpoint ready&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># if endpoint with this name already exists, get existing endpoint</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>    endpoint = huggingface_hub.get_inference_endpoint(name=endpoint_name, namespace=namespace)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> endpoint.status <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;paused&quot;</span>, <span class="hljs-string">&quot;scaledToZero&quot;</span>]:
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Resuming endpoint&quot;</span>)
<span class="hljs-meta">... </span>        endpoint.resume()
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Waiting for endpoint to start&quot;</span>)
<span class="hljs-meta">... </span>    endpoint.wait()
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Endpoint ready&quot;</span>)`,wrap:!1}}),js=new h({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyQSUyMHdoaW1zaWNhbCUyMGlsbHVzdHJhdGlvbiUyMG9mJTIwYSUyMGZhc2hpb25hYmx5JTIwZHJlc3NlZCUyMGxsYW1hJTIwcHJvdWRseSUyMGhvbGRpbmclMjBhJTIwd29ybiUyQyUyMHZpbnRhZ2UlMjBjb29rYm9vayUyQyUyMHdpdGglMjBhJTIwd2FybSUyMGN1cCUyMG9mJTIwdGVhJTIwYW5kJTIwYSUyMGZldyUyMGZyZXNobHklMjBiYWtlZCUyMHRyZWF0cyUyMHNjYXR0ZXJlZCUyMGFyb3VuZCUyQyUyMHNldCUyMGFnYWluc3QlMjBhJTIwY296eSUyMGJhY2tncm91bmQlMjBvZiUyMHJ1c3RpYyUyMHdvb2QlMjBhbmQlMjBibG9vbWluZyUyMGZsb3dlcnMuJTIyJTBBJTBBaW1hZ2UlMjAlM0QlMjBjbGllbnQudGV4dF90b19pbWFnZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzRGVuZHBvaW50LnVybCUyQyUyMCUyMCUyMyUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEOCUyQyUwQSklMEElMEFwcmludCglMjJQUk9NUFQlM0ElMjAlMjIlMkMlMjBwcm9tcHQpJTBBZGlzcGxheShpbWFnZS5yZXNpemUoKGltYWdlLndpZHRoJTIwJTJGJTJGJTIwMiUyQyUyMGltYWdlLmhlaWdodCUyMCUyRiUyRiUyMDIpKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A whimsical illustration of a fashionably dressed llama proudly holding a worn, vintage cookbook, with a warm cup of tea and a few freshly baked treats scattered around, set against a cozy background of rustic wood and blooming flowers.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    model=endpoint.url,  <span class="hljs-comment"># &quot;stabilityai/stable-diffusion-xl-base-1.0&quot;,</span>
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">8</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;PROMPT: &quot;</span>, prompt)
<span class="hljs-meta">&gt;&gt;&gt; </span>display(image.resize((image.width // <span class="hljs-number">2</span>, image.height // <span class="hljs-number">2</span>)))`,wrap:!1}}),ws=new h({props:{code:"ZW5kcG9pbnQucGF1c2UoKQ==",highlighted:"endpoint.pause()",wrap:!1}}),Ts=new J({props:{title:"Vision Language Models: Reasoning over text and images",local:"vision-language-models-reasoning-over-text-and-images",headingTag:"h3"}}),Is=new h({props:{code:"aW1wb3J0JTIwYmFzZTY0JTBBZnJvbSUyMGlvJTIwaW1wb3J0JTIwQnl0ZXNJTyUwQSUwQSUwQWRlZiUyMHBpbF9pbWFnZV90b19iYXNlNjQoaW1hZ2UpJTNBJTBBJTIwJTIwJTIwJTIwYnVmZmVyZWQlMjAlM0QlMjBCeXRlc0lPKCklMEElMjAlMjAlMjAlMjBpbWFnZS5zYXZlKGJ1ZmZlcmVkJTJDJTIwZm9ybWF0JTNEJTIySlBFRyUyMiklMEElMjAlMjAlMjAlMjBpbWdfc3RyJTIwJTNEJTIwYmFzZTY0LmI2NGVuY29kZShidWZmZXJlZC5nZXR2YWx1ZSgpKS5kZWNvZGUoJTIydXRmLTglMjIpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwaW1nX3N0ciUwQSUwQSUwQWltYWdlX2I2NCUyMCUzRCUyMHBpbF9pbWFnZV90b19iYXNlNjQoaW1hZ2Up",highlighted:`<span class="hljs-keyword">import</span> base64
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO


<span class="hljs-keyword">def</span> <span class="hljs-title function_">pil_image_to_base64</span>(<span class="hljs-params">image</span>):
    buffered = BytesIO()
    image.save(buffered, <span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;JPEG&quot;</span>)
    img_str = base64.b64encode(buffered.getvalue()).decode(<span class="hljs-string">&quot;utf-8&quot;</span>)
    <span class="hljs-keyword">return</span> img_str


image_b64 = pil_image_to_base64(image)`,wrap:!1}}),fs=new h({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

<span class="hljs-comment"># load the processor</span>
model_id_vlm = <span class="hljs-string">&quot;HuggingFaceM4/idefics2-8b-chatty&quot;</span>
processor = AutoProcessor.from_pretrained(model_id_vlm)

<span class="hljs-comment"># define the user messages</span>
messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {
                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>
            },  <span class="hljs-comment"># the image is placed here in the prompt. You can add multiple images throughout the conversation.</span>
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Write a short limerick about this image.&quot;</span>},
        ],
    },
]

<span class="hljs-comment"># apply the chat template to the messages</span>
prompt = processor.apply_chat_template(messages, add_generation_prompt=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># the chat template places a special &quot;&lt;image&gt;&quot; token at the position where the image should go</span>
<span class="hljs-comment"># here we replace the &quot;&lt;image&gt;&quot; token with the base64 encoded image string in the prompt</span>
<span class="hljs-comment"># to be able to send the image via an API request</span>
image_input = <span class="hljs-string">f&quot;data:image/jpeg;base64,<span class="hljs-subst">{image_b64}</span>&quot;</span>
image_input = <span class="hljs-string">f&quot;![](<span class="hljs-subst">{image_input}</span>)&quot;</span>
prompt = prompt.replace(<span class="hljs-string">&quot;&lt;image&gt;&quot;</span>, image_input)`,wrap:!1}}),U=new ot({props:{warning:!1,$$slots:{default:[yt]},$$scope:{ctx:Ss}}}),Zs=new h({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_inference_endpoint

<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint_name = <span class="hljs-string">&quot;idefics2-8b-chatty-001&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>namespace = <span class="hljs-string">&quot;MoritzLaurer&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>task = <span class="hljs-string">&quot;text-generation&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># check if endpoint with this name already exists from previous tests</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>available_endpoints_names = [endpoint.name <span class="hljs-keyword">for</span> endpoint <span class="hljs-keyword">in</span> huggingface_hub.list_inference_endpoints()]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> endpoint_name <span class="hljs-keyword">in</span> available_endpoints_names:
<span class="hljs-meta">... </span>    endpoint_exists = <span class="hljs-literal">True</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>    endpoint_exists = <span class="hljs-literal">False</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Does the endpoint already exist?&quot;</span>, endpoint_exists)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> endpoint_exists:
<span class="hljs-meta">... </span>    endpoint = huggingface_hub.get_inference_endpoint(name=endpoint_name, namespace=namespace)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> endpoint.status <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;paused&quot;</span>, <span class="hljs-string">&quot;scaledToZero&quot;</span>]:
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Resuming endpoint&quot;</span>)
<span class="hljs-meta">... </span>        endpoint.resume()
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Waiting for endpoint to start&quot;</span>)
<span class="hljs-meta">... </span>    endpoint.wait()
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Endpoint ready&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>    endpoint = create_inference_endpoint(
<span class="hljs-meta">... </span>        endpoint_name,
<span class="hljs-meta">... </span>        repository=model_id_vlm,
<span class="hljs-meta">... </span>        namespace=namespace,
<span class="hljs-meta">... </span>        framework=<span class="hljs-string">&quot;pytorch&quot;</span>,
<span class="hljs-meta">... </span>        task=task,
<span class="hljs-meta">... </span>        accelerator=<span class="hljs-string">&quot;gpu&quot;</span>,
<span class="hljs-meta">... </span>        vendor=<span class="hljs-string">&quot;aws&quot;</span>,
<span class="hljs-meta">... </span>        region=<span class="hljs-string">&quot;us-east-1&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;protected&quot;</span>,
<span class="hljs-meta">... </span>        instance_size=<span class="hljs-string">&quot;x1&quot;</span>,
<span class="hljs-meta">... </span>        instance_type=<span class="hljs-string">&quot;nvidia-a100&quot;</span>,
<span class="hljs-meta">... </span>        min_replica=<span class="hljs-number">0</span>,
<span class="hljs-meta">... </span>        max_replica=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>        custom_image={
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;health_route&quot;</span>: <span class="hljs-string">&quot;/health&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;env&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;MAX_BATCH_PREFILL_TOKENS&quot;</span>: <span class="hljs-string">&quot;2048&quot;</span>,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;MAX_INPUT_LENGTH&quot;</span>: <span class="hljs-string">&quot;1024&quot;</span>,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;MAX_TOTAL_TOKENS&quot;</span>: <span class="hljs-string">&quot;1536&quot;</span>,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;MODEL_ID&quot;</span>: <span class="hljs-string">&quot;/repository&quot;</span>,
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;ghcr.io/huggingface/text-generation-inference:latest&quot;</span>,
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    )

<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Waiting for endpoint to be created&quot;</span>)
<span class="hljs-meta">... </span>    endpoint.wait()
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Endpoint ready&quot;</span>)`,wrap:!1}}),Gs=new h({props:{code:"b3V0cHV0JTIwJTNEJTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbihwcm9tcHQlMkMlMjBtb2RlbCUzRG1vZGVsX2lkX3ZsbSUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjAwJTJDJTIwc2VlZCUzRDQyKSUwQSUwQXByaW50KG91dHB1dCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>output = client.text_generation(prompt, model=model_id_vlm, max_new_tokens=<span class="hljs-number">200</span>, seed=<span class="hljs-number">42</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(output)`,wrap:!1}}),As=new h({props:{code:"ZW5kcG9pbnQucGF1c2UoKQ==",highlighted:"endpoint.pause()",wrap:!1}}),Es=new J({props:{title:"Additional information",local:"additional-information",headingTag:"h2"}}),Vs=new J({props:{title:"Conclusion and next steps",local:"conclusion-and-next-steps",headingTag:"h2"}}),_s=new ct({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/enterprise_dedicated_endpoints.md"}}),{c(){j=p("meta"),g=n(),u=p("p"),qs=n(),M(I.$$.fragment),Ys=n(),M(b.$$.fragment),Ns=n(),f=p("p"),f.innerHTML=yl,zs=n(),C=p("p"),C.innerHTML=rl,Fs=n(),Z=p("p"),Z.innerHTML=ml,$s=n(),B=p("p"),B.textContent=dl,xs=n(),G=p("ul"),G.innerHTML=hl,Ls=n(),M(W.$$.fragment),Ps=n(),A=p("p"),A.innerHTML=jl,Ds=n(),E=p("p"),E.innerHTML=ul,Ks=n(),M(k.$$.fragment),Os=n(),M(V.$$.fragment),se=n(),M(v.$$.fragment),ee=n(),R=p("p"),R.innerHTML=Jl,le=n(),Q=p("ul"),Q.innerHTML=wl,te=n(),H=p("p"),H.innerHTML=Tl,ne=n(),w=p("div"),w.innerHTML=Ul,ae=n(),_=p("p"),_.textContent=gl,pe=n(),q=p("p"),q.innerHTML=Il,ie=n(),T=p("div"),T.innerHTML=bl,oe=n(),M(X.$$.fragment),Me=n(),S=p("p"),S.innerHTML=fl,ce=n(),M(Y.$$.fragment),ye=n(),N=p("p"),N.innerHTML=Cl,re=n(),M(z.$$.fragment),me=n(),M(F.$$.fragment),de=n(),M($.$$.fragment),he=n(),x=p("p"),x.innerHTML=Zl,je=n(),M(L.$$.fragment),ue=n(),P=p("pre"),P.innerHTML=Bl,Je=n(),M(D.$$.fragment),we=n(),K=p("pre"),K.textContent=Gl,Te=n(),O=p("p"),O.textContent=Wl,Ue=n(),ss=p("p"),ss.innerHTML=Al,ge=n(),M(es.$$.fragment),Ie=n(),ls=p("pre"),ls.textContent=El,be=n(),M(ts.$$.fragment),fe=n(),ns=p("p"),ns.innerHTML=kl,Ce=n(),as=p("p"),as.textContent=Vl,Ze=n(),M(ps.$$.fragment),Be=n(),M(is.$$.fragment),Ge=n(),M(os.$$.fragment),We=n(),Ms=p("p"),Ms.textContent=vl,Ae=n(),M(cs.$$.fragment),Ee=n(),ys=p("p"),ys.textContent=Rl,ke=n(),M(rs.$$.fragment),Ve=n(),ms=p("pre"),ms.textContent=Ql,ve=n(),M(ds.$$.fragment),Re=n(),hs=p("pre"),hs.textContent=Hl,Qe=n(),M(js.$$.fragment),He=n(),us=p("pre"),us.textContent=_l,_e=n(),Js=p("p"),Js.textContent=ql,qe=n(),M(ws.$$.fragment),Xe=n(),M(Ts.$$.fragment),Se=n(),Us=p("p"),Us.innerHTML=Xl,Ye=n(),gs=p("p"),gs.innerHTML=Sl,Ne=n(),M(Is.$$.fragment),ze=n(),bs=p("p"),bs.innerHTML=Yl,Fe=n(),M(fs.$$.fragment),$e=n(),M(U.$$.fragment),xe=n(),Cs=p("p"),Cs.innerHTML=Nl,Le=n(),M(Zs.$$.fragment),Pe=n(),Bs=p("pre"),Bs.textContent=zl,De=n(),M(Gs.$$.fragment),Ke=n(),Ws=p("pre"),Ws.textContent=Fl,Oe=n(),M(As.$$.fragment),sl=n(),M(Es.$$.fragment),el=n(),ks=p("ul"),ks.innerHTML=$l,ll=n(),M(Vs.$$.fragment),tl=n(),vs=p("p"),vs.textContent=xl,nl=n(),Rs=p("p"),Rs.innerHTML=Ll,al=n(),Qs=p("p"),Qs.innerHTML=Pl,pl=n(),Hs=p("p"),Hs.textContent=Dl,il=n(),M(_s.$$.fragment),ol=n(),Xs=p("p"),this.h()},l(s){const e=pt("svelte-u9bgzb",document.head);j=i(e,"META",{name:!0,content:!0}),e.forEach(l),g=a(s),u=i(s,"P",{}),Ol(u).forEach(l),qs=a(s),c(I.$$.fragment,s),Ys=a(s),c(b.$$.fragment,s),Ns=a(s),f=i(s,"P",{"data-svelte-h":!0}),o(f)!=="svelte-phy2er"&&(f.innerHTML=yl),zs=a(s),C=i(s,"P",{"data-svelte-h":!0}),o(C)!=="svelte-31gxb1"&&(C.innerHTML=rl),Fs=a(s),Z=i(s,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-ea64o2"&&(Z.innerHTML=ml),$s=a(s),B=i(s,"P",{"data-svelte-h":!0}),o(B)!=="svelte-cjypfx"&&(B.textContent=dl),xs=a(s),G=i(s,"UL",{"data-svelte-h":!0}),o(G)!=="svelte-1y2rksz"&&(G.innerHTML=hl),Ls=a(s),c(W.$$.fragment,s),Ps=a(s),A=i(s,"P",{"data-svelte-h":!0}),o(A)!=="svelte-mgw3ja"&&(A.innerHTML=jl),Ds=a(s),E=i(s,"P",{"data-svelte-h":!0}),o(E)!=="svelte-qnpmsm"&&(E.innerHTML=ul),Ks=a(s),c(k.$$.fragment,s),Os=a(s),c(V.$$.fragment,s),se=a(s),c(v.$$.fragment,s),ee=a(s),R=i(s,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1jdmkft"&&(R.innerHTML=Jl),le=a(s),Q=i(s,"UL",{"data-svelte-h":!0}),o(Q)!=="svelte-1fztman"&&(Q.innerHTML=wl),te=a(s),H=i(s,"P",{"data-svelte-h":!0}),o(H)!=="svelte-14vawf4"&&(H.innerHTML=Tl),ne=a(s),w=i(s,"DIV",{style:!0,"data-svelte-h":!0}),o(w)!=="svelte-y2vyyr"&&(w.innerHTML=Ul),ae=a(s),_=i(s,"P",{"data-svelte-h":!0}),o(_)!=="svelte-16u6bcx"&&(_.textContent=gl),pe=a(s),q=i(s,"P",{"data-svelte-h":!0}),o(q)!=="svelte-1b0vo31"&&(q.innerHTML=Il),ie=a(s),T=i(s,"DIV",{style:!0,"data-svelte-h":!0}),o(T)!=="svelte-a4voxj"&&(T.innerHTML=bl),oe=a(s),c(X.$$.fragment,s),Me=a(s),S=i(s,"P",{"data-svelte-h":!0}),o(S)!=="svelte-d6pll0"&&(S.innerHTML=fl),ce=a(s),c(Y.$$.fragment,s),ye=a(s),N=i(s,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1oik75g"&&(N.innerHTML=Cl),re=a(s),c(z.$$.fragment,s),me=a(s),c(F.$$.fragment,s),de=a(s),c($.$$.fragment,s),he=a(s),x=i(s,"P",{"data-svelte-h":!0}),o(x)!=="svelte-h8bvlt"&&(x.innerHTML=Zl),je=a(s),c(L.$$.fragment,s),ue=a(s),P=i(s,"PRE",{"data-svelte-h":!0}),o(P)!=="svelte-1ge2cq1"&&(P.innerHTML=Bl),Je=a(s),c(D.$$.fragment,s),we=a(s),K=i(s,"PRE",{"data-svelte-h":!0}),o(K)!=="svelte-eapgg6"&&(K.textContent=Gl),Te=a(s),O=i(s,"P",{"data-svelte-h":!0}),o(O)!=="svelte-n71ylo"&&(O.textContent=Wl),Ue=a(s),ss=i(s,"P",{"data-svelte-h":!0}),o(ss)!=="svelte-1nmi541"&&(ss.innerHTML=Al),ge=a(s),c(es.$$.fragment,s),Ie=a(s),ls=i(s,"PRE",{"data-svelte-h":!0}),o(ls)!=="svelte-ylq8xh"&&(ls.textContent=El),be=a(s),c(ts.$$.fragment,s),fe=a(s),ns=i(s,"P",{"data-svelte-h":!0}),o(ns)!=="svelte-1tmrz4s"&&(ns.innerHTML=kl),Ce=a(s),as=i(s,"P",{"data-svelte-h":!0}),o(as)!=="svelte-z4qkh9"&&(as.textContent=Vl),Ze=a(s),c(ps.$$.fragment,s),Be=a(s),c(is.$$.fragment,s),Ge=a(s),c(os.$$.fragment,s),We=a(s),Ms=i(s,"P",{"data-svelte-h":!0}),o(Ms)!=="svelte-qoiq95"&&(Ms.textContent=vl),Ae=a(s),c(cs.$$.fragment,s),Ee=a(s),ys=i(s,"P",{"data-svelte-h":!0}),o(ys)!=="svelte-mbrgfm"&&(ys.textContent=Rl),ke=a(s),c(rs.$$.fragment,s),Ve=a(s),ms=i(s,"PRE",{"data-svelte-h":!0}),o(ms)!=="svelte-155ymre"&&(ms.textContent=Ql),ve=a(s),c(ds.$$.fragment,s),Re=a(s),hs=i(s,"PRE",{"data-svelte-h":!0}),o(hs)!=="svelte-1y8n5ov"&&(hs.textContent=Hl),Qe=a(s),c(js.$$.fragment,s),He=a(s),us=i(s,"PRE",{"data-svelte-h":!0}),o(us)!=="svelte-1cx6d48"&&(us.textContent=_l),_e=a(s),Js=i(s,"P",{"data-svelte-h":!0}),o(Js)!=="svelte-1bjtv3s"&&(Js.textContent=ql),qe=a(s),c(ws.$$.fragment,s),Xe=a(s),c(Ts.$$.fragment,s),Se=a(s),Us=i(s,"P",{"data-svelte-h":!0}),o(Us)!=="svelte-io8nac"&&(Us.innerHTML=Xl),Ye=a(s),gs=i(s,"P",{"data-svelte-h":!0}),o(gs)!=="svelte-81wpai"&&(gs.innerHTML=Sl),Ne=a(s),c(Is.$$.fragment,s),ze=a(s),bs=i(s,"P",{"data-svelte-h":!0}),o(bs)!=="svelte-18m2y9y"&&(bs.innerHTML=Yl),Fe=a(s),c(fs.$$.fragment,s),$e=a(s),c(U.$$.fragment,s),xe=a(s),Cs=i(s,"P",{"data-svelte-h":!0}),o(Cs)!=="svelte-197qp1q"&&(Cs.innerHTML=Nl),Le=a(s),c(Zs.$$.fragment,s),Pe=a(s),Bs=i(s,"PRE",{"data-svelte-h":!0}),o(Bs)!=="svelte-rvo07b"&&(Bs.textContent=zl),De=a(s),c(Gs.$$.fragment,s),Ke=a(s),Ws=i(s,"PRE",{"data-svelte-h":!0}),o(Ws)!=="svelte-vodlno"&&(Ws.textContent=Fl),Oe=a(s),c(As.$$.fragment,s),sl=a(s),c(Es.$$.fragment,s),el=a(s),ks=i(s,"UL",{"data-svelte-h":!0}),o(ks)!=="svelte-17e5lbs"&&(ks.innerHTML=$l),ll=a(s),c(Vs.$$.fragment,s),tl=a(s),vs=i(s,"P",{"data-svelte-h":!0}),o(vs)!=="svelte-1qat679"&&(vs.textContent=xl),nl=a(s),Rs=i(s,"P",{"data-svelte-h":!0}),o(Rs)!=="svelte-nwy2z9"&&(Rs.innerHTML=Ll),al=a(s),Qs=i(s,"P",{"data-svelte-h":!0}),o(Qs)!=="svelte-e8d7iw"&&(Qs.innerHTML=Pl),pl=a(s),Hs=i(s,"P",{"data-svelte-h":!0}),o(Hs)!=="svelte-1yipim9"&&(Hs.textContent=Dl),il=a(s),c(_s.$$.fragment,s),ol=a(s),Xs=i(s,"P",{}),Ol(Xs).forEach(l),this.h()},h(){cl(j,"name","hf:doc:metadata"),cl(j,"content",mt),st(w,"display","flex"),st(w,"justify-content","center",1),cl(T,"style","flex justify-center")},m(s,e){it(document.head,j),t(s,g,e),t(s,u,e),t(s,qs,e),y(I,s,e),t(s,Ys,e),y(b,s,e),t(s,Ns,e),t(s,f,e),t(s,zs,e),t(s,C,e),t(s,Fs,e),t(s,Z,e),t(s,$s,e),t(s,B,e),t(s,xs,e),t(s,G,e),t(s,Ls,e),y(W,s,e),t(s,Ps,e),t(s,A,e),t(s,Ds,e),t(s,E,e),t(s,Ks,e),y(k,s,e),t(s,Os,e),y(V,s,e),t(s,se,e),y(v,s,e),t(s,ee,e),t(s,R,e),t(s,le,e),t(s,Q,e),t(s,te,e),t(s,H,e),t(s,ne,e),t(s,w,e),t(s,ae,e),t(s,_,e),t(s,pe,e),t(s,q,e),t(s,ie,e),t(s,T,e),t(s,oe,e),y(X,s,e),t(s,Me,e),t(s,S,e),t(s,ce,e),y(Y,s,e),t(s,ye,e),t(s,N,e),t(s,re,e),y(z,s,e),t(s,me,e),y(F,s,e),t(s,de,e),y($,s,e),t(s,he,e),t(s,x,e),t(s,je,e),y(L,s,e),t(s,ue,e),t(s,P,e),t(s,Je,e),y(D,s,e),t(s,we,e),t(s,K,e),t(s,Te,e),t(s,O,e),t(s,Ue,e),t(s,ss,e),t(s,ge,e),y(es,s,e),t(s,Ie,e),t(s,ls,e),t(s,be,e),y(ts,s,e),t(s,fe,e),t(s,ns,e),t(s,Ce,e),t(s,as,e),t(s,Ze,e),y(ps,s,e),t(s,Be,e),y(is,s,e),t(s,Ge,e),y(os,s,e),t(s,We,e),t(s,Ms,e),t(s,Ae,e),y(cs,s,e),t(s,Ee,e),t(s,ys,e),t(s,ke,e),y(rs,s,e),t(s,Ve,e),t(s,ms,e),t(s,ve,e),y(ds,s,e),t(s,Re,e),t(s,hs,e),t(s,Qe,e),y(js,s,e),t(s,He,e),t(s,us,e),t(s,_e,e),t(s,Js,e),t(s,qe,e),y(ws,s,e),t(s,Xe,e),y(Ts,s,e),t(s,Se,e),t(s,Us,e),t(s,Ye,e),t(s,gs,e),t(s,Ne,e),y(Is,s,e),t(s,ze,e),t(s,bs,e),t(s,Fe,e),y(fs,s,e),t(s,$e,e),y(U,s,e),t(s,xe,e),t(s,Cs,e),t(s,Le,e),y(Zs,s,e),t(s,Pe,e),t(s,Bs,e),t(s,De,e),y(Gs,s,e),t(s,Ke,e),t(s,Ws,e),t(s,Oe,e),y(As,s,e),t(s,sl,e),y(Es,s,e),t(s,el,e),t(s,ks,e),t(s,ll,e),y(Vs,s,e),t(s,tl,e),t(s,vs,e),t(s,nl,e),t(s,Rs,e),t(s,al,e),t(s,Qs,e),t(s,pl,e),t(s,Hs,e),t(s,il,e),y(_s,s,e),t(s,ol,e),t(s,Xs,e),Ml=!0},p(s,[e]){const Kl={};e&2&&(Kl.$$scope={dirty:e,ctx:s}),U.$set(Kl)},i(s){Ml||(r(I.$$.fragment,s),r(b.$$.fragment,s),r(W.$$.fragment,s),r(k.$$.fragment,s),r(V.$$.fragment,s),r(v.$$.fragment,s),r(X.$$.fragment,s),r(Y.$$.fragment,s),r(z.$$.fragment,s),r(F.$$.fragment,s),r($.$$.fragment,s),r(L.$$.fragment,s),r(D.$$.fragment,s),r(es.$$.fragment,s),r(ts.$$.fragment,s),r(ps.$$.fragment,s),r(is.$$.fragment,s),r(os.$$.fragment,s),r(cs.$$.fragment,s),r(rs.$$.fragment,s),r(ds.$$.fragment,s),r(js.$$.fragment,s),r(ws.$$.fragment,s),r(Ts.$$.fragment,s),r(Is.$$.fragment,s),r(fs.$$.fragment,s),r(U.$$.fragment,s),r(Zs.$$.fragment,s),r(Gs.$$.fragment,s),r(As.$$.fragment,s),r(Es.$$.fragment,s),r(Vs.$$.fragment,s),r(_s.$$.fragment,s),Ml=!0)},o(s){m(I.$$.fragment,s),m(b.$$.fragment,s),m(W.$$.fragment,s),m(k.$$.fragment,s),m(V.$$.fragment,s),m(v.$$.fragment,s),m(X.$$.fragment,s),m(Y.$$.fragment,s),m(z.$$.fragment,s),m(F.$$.fragment,s),m($.$$.fragment,s),m(L.$$.fragment,s),m(D.$$.fragment,s),m(es.$$.fragment,s),m(ts.$$.fragment,s),m(ps.$$.fragment,s),m(is.$$.fragment,s),m(os.$$.fragment,s),m(cs.$$.fragment,s),m(rs.$$.fragment,s),m(ds.$$.fragment,s),m(js.$$.fragment,s),m(ws.$$.fragment,s),m(Ts.$$.fragment,s),m(Is.$$.fragment,s),m(fs.$$.fragment,s),m(U.$$.fragment,s),m(Zs.$$.fragment,s),m(Gs.$$.fragment,s),m(As.$$.fragment,s),m(Es.$$.fragment,s),m(Vs.$$.fragment,s),m(_s.$$.fragment,s),Ml=!1},d(s){s&&(l(g),l(u),l(qs),l(Ys),l(Ns),l(f),l(zs),l(C),l(Fs),l(Z),l($s),l(B),l(xs),l(G),l(Ls),l(Ps),l(A),l(Ds),l(E),l(Ks),l(Os),l(se),l(ee),l(R),l(le),l(Q),l(te),l(H),l(ne),l(w),l(ae),l(_),l(pe),l(q),l(ie),l(T),l(oe),l(Me),l(S),l(ce),l(ye),l(N),l(re),l(me),l(de),l(he),l(x),l(je),l(ue),l(P),l(Je),l(we),l(K),l(Te),l(O),l(Ue),l(ss),l(ge),l(Ie),l(ls),l(be),l(fe),l(ns),l(Ce),l(as),l(Ze),l(Be),l(Ge),l(We),l(Ms),l(Ae),l(Ee),l(ys),l(ke),l(Ve),l(ms),l(ve),l(Re),l(hs),l(Qe),l(He),l(us),l(_e),l(Js),l(qe),l(Xe),l(Se),l(Us),l(Ye),l(gs),l(Ne),l(ze),l(bs),l(Fe),l($e),l(xe),l(Cs),l(Le),l(Pe),l(Bs),l(De),l(Ke),l(Ws),l(Oe),l(sl),l(el),l(ks),l(ll),l(tl),l(vs),l(nl),l(Rs),l(al),l(Qs),l(pl),l(Hs),l(il),l(ol),l(Xs)),l(j),d(I,s),d(b,s),d(W,s),d(k,s),d(V,s),d(v,s),d(X,s),d(Y,s),d(z,s),d(F,s),d($,s),d(L,s),d(D,s),d(es,s),d(ts,s),d(ps,s),d(is,s),d(os,s),d(cs,s),d(rs,s),d(ds,s),d(js,s),d(ws,s),d(Ts,s),d(Is,s),d(fs,s),d(U,s),d(Zs,s),d(Gs,s),d(As,s),d(Es,s),d(Vs,s),d(_s,s)}}}const mt='{"title":"Inference Endpoints (dedicated)","local":"inference-endpoints-dedicated","sections":[{"title":"Install and login","local":"install-and-login","sections":[],"depth":2},{"title":"Creating your first Endpoint","local":"creating-your-first-endpoint","sections":[{"title":"Creating and managing Endpoints programmatically","local":"creating-and-managing-endpoints-programmatically","sections":[],"depth":3}],"depth":2},{"title":"Querying your Endpoint","local":"querying-your-endpoint","sections":[{"title":"Simplified Endpoint usage with the InferenceClient","local":"simplified-endpoint-usage-with-the-inferenceclient","sections":[],"depth":3}],"depth":2},{"title":"Creating Endpoints for a wide variety of models","local":"creating-endpoints-for-a-wide-variety-of-models","sections":[{"title":"Image generation with Stable Diffusion","local":"image-generation-with-stable-diffusion","sections":[],"depth":3},{"title":"Vision Language Models: Reasoning over text and images","local":"vision-language-models-reasoning-over-text-and-images","sections":[],"depth":3}],"depth":2},{"title":"Additional information","local":"additional-information","sections":[],"depth":2},{"title":"Conclusion and next steps","local":"conclusion-and-next-steps","sections":[],"depth":2}],"depth":1}';function dt(Ss){return lt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Tt extends nt{constructor(j){super(),at(this,j,dt,rt,et,{})}}export{Tt as component};
