import{s as It,o as $t,n as Xe}from"../chunks/scheduler.8c3d61f6.js";import{S as Wt,i as Xt,g as m,s as a,r as y,A as Rt,h as p,f as s,c as i,j as Bt,u as c,x as f,k as dt,y as kt,a as l,v as J,d as M,t as T,w as b}from"../chunks/index.da70eac4.js";import{T as ft}from"../chunks/Tip.1d9b8c37.js";import{C as q}from"../chunks/CodeBlock.00a903b3.js";import{H as O,E as Gt}from"../chunks/EditOnGithub.1e64e623.js";import{H as Ft,a as vt}from"../chunks/HfOption.c1483eb1.js";function qt(z){let o,U="Quantizing a model in 8-bit halves the memory-usage:",d,h,u=`bitsandbytes is supported in both Transformers and Diffusers, so you can quantize both the
<a href="/docs/diffusers/pr_10012/en/api/models/flux_transformer#diffusers.FluxTransformer2DModel">FluxTransformer2DModel</a> and <a href="https://huggingface.co/docs/transformers/main/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5EncoderModel</a>.`,Z,w,S=`<p>[!Note]
Depending on the GPU, set your <code>torch_dtype</code>. For Ada and higher series GPUs support <code>torch.bfloat16</code> and we suggest using it when applicable.</p>`,V,C,ee=`<p>[!Note]
We do not qunatize the <code>CLIPTextModel</code> and the <code>AutoencoderKL</code> due to their small size, and also for the fact that <code>AutoencoderKL</code> has very few <code>torch.nn.Linear</code> layers.</p>`,E,g,L,v,Y="By default, all the other modules such as <code>torch.nn.LayerNorm</code> are converted to <code>torch.float16</code>. You can change the data type of these modules with the <code>torch_dtype</code> parameter.",A,I,k,X,P="Let’s generate an image using our quantized models.",G,$,H=`Setting <code>device_map=&quot;auto&quot;</code> automatically fills all available space on the GPU(s) first, then the
CPU, and finally, the hard drive (the absolute slowest option) if there is still not enough memory.`,D,W,R,B,N='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/quant-bnb/8bit.png"/>',Q,j,te=`<p>[!Note]
When memory permits, one can directly mode the pipeline (<code>pipe</code> here) to the GPU using the <code>.to(&quot;cuda&quot;)</code> API.
One can also use the <code>enable_model_cpu_offload()</code> to optimize GPU VRAM usage.</p>`,x,_,K='Once a model is quantized, you can push the model to the Hub with the <a href="/docs/diffusers/pr_10012/en/api/pipelines/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method. The quantization <code>config.json</code> file is pushed first, followed by the quantized model weights. You can also save the serialized 8-bit models locally with <a href="/docs/diffusers/pr_10012/en/api/models/overview#diffusers.ModelMixin.save_pretrained">save_pretrained()</a>.',F;return g=new q({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVDVFbmNvZGVyTW9kZWwlMEElMEFxdWFudF9jb25maWclMjAlM0QlMjBUcmFuc2Zvcm1lcnNCaXRzQW5kQnl0ZXNDb25maWcobG9hZF9pbl84Yml0JTNEVHJ1ZSUyQyklMEElMEF0ZXh0X2VuY29kZXJfMl84Yml0JTIwJTNEJTIwVDVFbmNvZGVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRleHRfZW5jb2Rlcl8yJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50X2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSklMEElMEFxdWFudF9jb25maWclMjAlM0QlMjBEaWZmdXNlcnNCaXRzQW5kQnl0ZXNDb25maWcobG9hZF9pbl84Yml0JTNEVHJ1ZSUyQyklMEElMEF0cmFuc2Zvcm1lcl84Yml0JTIwJTNEJTIwRmx1eFRyYW5zZm9ybWVyMkRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> TransformersBitsAndBytesConfig

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxTransformer2DModel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel

quant_config = TransformersBitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>,)

text_encoder_2_8bit = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder_2&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

quant_config = DiffusersBitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>,)

transformer_8bit = FluxTransformer2DModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)`,wrap:!1}}),I=new q({props:{code:"dHJhbnNmb3JtZXJfOGJpdCUyMCUzRCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRyYW5zZm9ybWVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50X2NvbmZpZyUyQyUwQSUyQiUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQzMiUyQyUwQSk=",highlighted:`transformer_8bit = FluxTransformer2DModel.from_pretrained(
    &quot;black-forest-labs/FLUX.1-dev&quot;,
    subfolder=&quot;transformer&quot;,
    quantization_config=quant_config,
<span class="hljs-addition">+   torch_dtype=torch.float32,</span>
)`,wrap:!1}}),W=new q({props:{code:"cGlwZSUyMCUzRCUyMEZsdXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwdHJhbnNmb3JtZXIlM0R0cmFuc2Zvcm1lcl84Yml0JTJDJTBBJTIwJTIwJTIwJTIwdGV4dF9lbmNvZGVyXzIlM0R0ZXh0X2VuY29kZXJfMl84Yml0JTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMEEpJTBBJTBBcGlwZV9rd2FyZ3MlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlMjJBJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMHdvcmxkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyaGVpZ2h0JTIyJTNBJTIwMTAyNCUyQyUwQSUyMCUyMCUyMCUyMCUyMndpZHRoJTIyJTNBJTIwMTAyNCUyQyUwQSUyMCUyMCUyMCUyMCUyMmd1aWRhbmNlX3NjYWxlJTIyJTNBJTIwMy41JTJDJTBBJTIwJTIwJTIwJTIwJTIybnVtX2luZmVyZW5jZV9zdGVwcyUyMiUzQSUyMDUwJTJDJTBBJTIwJTIwJTIwJTIwJTIybWF4X3NlcXVlbmNlX2xlbmd0aCUyMiUzQSUyMDUxMiUyQyUwQSU3RCUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZSgqKnBpcGVfa3dhcmdzJTJDJTIwZ2VuZXJhdG9yJTNEdG9yY2gubWFudWFsX3NlZWQoMCklMkMpLmltYWdlcyU1QjAlNUQ=",highlighted:`pipe = FluxPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    transformer=transformer_8bit,
    text_encoder_2=text_encoder_2_8bit,
    torch_dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)

pipe_kwargs = {
    <span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>,
    <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">1024</span>,
    <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">1024</span>,
    <span class="hljs-string">&quot;guidance_scale&quot;</span>: <span class="hljs-number">3.5</span>,
    <span class="hljs-string">&quot;num_inference_steps&quot;</span>: <span class="hljs-number">50</span>,
    <span class="hljs-string">&quot;max_sequence_length&quot;</span>: <span class="hljs-number">512</span>,
}

image = pipe(**pipe_kwargs, generator=torch.manual_seed(<span class="hljs-number">0</span>),).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){o=m("p"),o.textContent=U,d=a(),h=m("p"),h.innerHTML=u,Z=a(),w=m("blockquote"),w.innerHTML=S,V=a(),C=m("blockquote"),C.innerHTML=ee,E=a(),y(g.$$.fragment),L=a(),v=m("p"),v.innerHTML=Y,A=a(),y(I.$$.fragment),k=a(),X=m("p"),X.textContent=P,G=a(),$=m("p"),$.innerHTML=H,D=a(),y(W.$$.fragment),R=a(),B=m("div"),B.innerHTML=N,Q=a(),j=m("blockquote"),j.innerHTML=te,x=a(),_=m("p"),_.innerHTML=K,this.h()},l(t){o=p(t,"P",{"data-svelte-h":!0}),f(o)!=="svelte-4djpqq"&&(o.textContent=U),d=i(t),h=p(t,"P",{"data-svelte-h":!0}),f(h)!=="svelte-1jjzczl"&&(h.innerHTML=u),Z=i(t),w=p(t,"BLOCKQUOTE",{"data-svelte-h":!0}),f(w)!=="svelte-fmmzem"&&(w.innerHTML=S),V=i(t),C=p(t,"BLOCKQUOTE",{"data-svelte-h":!0}),f(C)!=="svelte-10kj63n"&&(C.innerHTML=ee),E=i(t),c(g.$$.fragment,t),L=i(t),v=p(t,"P",{"data-svelte-h":!0}),f(v)!=="svelte-1qozsrk"&&(v.innerHTML=Y),A=i(t),c(I.$$.fragment,t),k=i(t),X=p(t,"P",{"data-svelte-h":!0}),f(X)!=="svelte-2bde4h"&&(X.textContent=P),G=i(t),$=p(t,"P",{"data-svelte-h":!0}),f($)!=="svelte-1eyrcy7"&&($.innerHTML=H),D=i(t),c(W.$$.fragment,t),R=i(t),B=p(t,"DIV",{class:!0,"data-svelte-h":!0}),f(B)!=="svelte-14afenp"&&(B.innerHTML=N),Q=i(t),j=p(t,"BLOCKQUOTE",{"data-svelte-h":!0}),f(j)!=="svelte-rwvqdw"&&(j.innerHTML=te),x=i(t),_=p(t,"P",{"data-svelte-h":!0}),f(_)!=="svelte-gmmigy"&&(_.innerHTML=K),this.h()},h(){dt(B,"class","flex justify-center")},m(t,r){l(t,o,r),l(t,d,r),l(t,h,r),l(t,Z,r),l(t,w,r),l(t,V,r),l(t,C,r),l(t,E,r),J(g,t,r),l(t,L,r),l(t,v,r),l(t,A,r),J(I,t,r),l(t,k,r),l(t,X,r),l(t,G,r),l(t,$,r),l(t,D,r),J(W,t,r),l(t,R,r),l(t,B,r),l(t,Q,r),l(t,j,r),l(t,x,r),l(t,_,r),F=!0},p:Xe,i(t){F||(M(g.$$.fragment,t),M(I.$$.fragment,t),M(W.$$.fragment,t),F=!0)},o(t){T(g.$$.fragment,t),T(I.$$.fragment,t),T(W.$$.fragment,t),F=!1},d(t){t&&(s(o),s(d),s(h),s(Z),s(w),s(V),s(C),s(E),s(L),s(v),s(A),s(k),s(X),s(G),s($),s(D),s(R),s(B),s(Q),s(j),s(x),s(_)),b(g,t),b(I,t),b(W,t)}}}function zt(z){let o,U="Quantizing a model in 4-bit reduces your memory-usage by 4x:",d,h,u=`bitsandbytes is supported in both Transformers and Diffusers, so you can can quantize both the
<a href="/docs/diffusers/pr_10012/en/api/models/flux_transformer#diffusers.FluxTransformer2DModel">FluxTransformer2DModel</a> and <a href="https://huggingface.co/docs/transformers/main/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5EncoderModel</a>.`,Z,w,S=`<p>[!Note]
Depending on the GPU, set your <code>torch_dtype</code>. For Ada and higher series GPUs support <code>torch.bfloat16</code> and we suggest using it when applicable.</p>`,V,C,ee=`<p>[!Note]
We do not qunatize the <code>CLIPTextModel</code> and the <code>AutoencoderKL</code> due to their small size, and also for the fact that <code>AutoencoderKL</code> has very few <code>torch.nn.Linear</code> layers.</p>`,E,g,L,v,Y="By default, all the other modules such as <code>torch.nn.LayerNorm</code> are converted to <code>torch.float16</code>. You can change the data type of these modules with the <code>torch_dtype</code> parameter.",A,I,k,X,P="Let’s generate an image using our quantized models.",G,$,H="Setting <code>device_map=&quot;auto&quot;</code> automatically fills all available space on the GPU(s) first, then the CPU, and finally, the hard drive (the absolute slowest option) if there is still not enough memory.",D,W,R,B,N='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/quant-bnb/4bit.png"/>',Q,j,te=`<p>[!Note]
When memory permits, one can directly mode the pipeline (<code>pipe</code> here) to the GPU using the <code>.to(&quot;cuda&quot;)</code> API.
One can also use the <code>enable_model_cpu_offload()</code> to optimize GPU VRAM usage.</p>`,x,_,K='Once a model is quantized, you can push the model to the Hub with the <a href="/docs/diffusers/pr_10012/en/api/pipelines/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method. The quantization <code>config.json</code> file is pushed first, followed by the quantized model weights. You can also save the serialized 4-bit models locally with <a href="/docs/diffusers/pr_10012/en/api/models/overview#diffusers.ModelMixin.save_pretrained">save_pretrained()</a>.',F;return g=new q({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVDVFbmNvZGVyTW9kZWwlMEElMEFxdWFudF9jb25maWclMjAlM0QlMjBUcmFuc2Zvcm1lcnNCaXRzQW5kQnl0ZXNDb25maWcobG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyklMEElMEF0ZXh0X2VuY29kZXJfMl80Yml0JTIwJTNEJTIwVDVFbmNvZGVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRleHRfZW5jb2Rlcl8yJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50X2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSklMEElMEFxdWFudF9jb25maWclMjAlM0QlMjBEaWZmdXNlcnNCaXRzQW5kQnl0ZXNDb25maWcobG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyklMEElMEF0cmFuc2Zvcm1lcl80Yml0JTIwJTNEJTIwRmx1eFRyYW5zZm9ybWVyMkRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> TransformersBitsAndBytesConfig

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxTransformer2DModel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel

quant_config = TransformersBitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>,)

text_encoder_2_4bit = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder_2&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

quant_config = DiffusersBitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>,)

transformer_4bit = FluxTransformer2DModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)`,wrap:!1}}),I=new q({props:{code:"dHJhbnNmb3JtZXJfNGJpdCUyMCUzRCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRyYW5zZm9ybWVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50X2NvbmZpZyUyQyUwQSUyQiUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQzMiUyQyUwQSk=",highlighted:`transformer_4bit = FluxTransformer2DModel.from_pretrained(
    &quot;black-forest-labs/FLUX.1-dev&quot;,
    subfolder=&quot;transformer&quot;,
    quantization_config=quant_config,
<span class="hljs-addition">+   torch_dtype=torch.float32,</span>
)`,wrap:!1}}),W=new q({props:{code:"cGlwZSUyMCUzRCUyMEZsdXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwdHJhbnNmb3JtZXIlM0R0cmFuc2Zvcm1lcl80Yml0JTJDJTBBJTIwJTIwJTIwJTIwdGV4dF9lbmNvZGVyXzIlM0R0ZXh0X2VuY29kZXJfMl80Yml0JTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMEEpJTBBJTBBcGlwZV9rd2FyZ3MlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlMjJBJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMHdvcmxkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyaGVpZ2h0JTIyJTNBJTIwMTAyNCUyQyUwQSUyMCUyMCUyMCUyMCUyMndpZHRoJTIyJTNBJTIwMTAyNCUyQyUwQSUyMCUyMCUyMCUyMCUyMmd1aWRhbmNlX3NjYWxlJTIyJTNBJTIwMy41JTJDJTBBJTIwJTIwJTIwJTIwJTIybnVtX2luZmVyZW5jZV9zdGVwcyUyMiUzQSUyMDUwJTJDJTBBJTIwJTIwJTIwJTIwJTIybWF4X3NlcXVlbmNlX2xlbmd0aCUyMiUzQSUyMDUxMiUyQyUwQSU3RCUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZSgqKnBpcGVfa3dhcmdzJTJDJTIwZ2VuZXJhdG9yJTNEdG9yY2gubWFudWFsX3NlZWQoMCklMkMpLmltYWdlcyU1QjAlNUQ=",highlighted:`pipe = FluxPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    transformer=transformer_4bit,
    text_encoder_2=text_encoder_2_4bit,
    torch_dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)

pipe_kwargs = {
    <span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>,
    <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">1024</span>,
    <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">1024</span>,
    <span class="hljs-string">&quot;guidance_scale&quot;</span>: <span class="hljs-number">3.5</span>,
    <span class="hljs-string">&quot;num_inference_steps&quot;</span>: <span class="hljs-number">50</span>,
    <span class="hljs-string">&quot;max_sequence_length&quot;</span>: <span class="hljs-number">512</span>,
}

image = pipe(**pipe_kwargs, generator=torch.manual_seed(<span class="hljs-number">0</span>),).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){o=m("p"),o.textContent=U,d=a(),h=m("p"),h.innerHTML=u,Z=a(),w=m("blockquote"),w.innerHTML=S,V=a(),C=m("blockquote"),C.innerHTML=ee,E=a(),y(g.$$.fragment),L=a(),v=m("p"),v.innerHTML=Y,A=a(),y(I.$$.fragment),k=a(),X=m("p"),X.textContent=P,G=a(),$=m("p"),$.innerHTML=H,D=a(),y(W.$$.fragment),R=a(),B=m("div"),B.innerHTML=N,Q=a(),j=m("blockquote"),j.innerHTML=te,x=a(),_=m("p"),_.innerHTML=K,this.h()},l(t){o=p(t,"P",{"data-svelte-h":!0}),f(o)!=="svelte-i07c71"&&(o.textContent=U),d=i(t),h=p(t,"P",{"data-svelte-h":!0}),f(h)!=="svelte-z8la1r"&&(h.innerHTML=u),Z=i(t),w=p(t,"BLOCKQUOTE",{"data-svelte-h":!0}),f(w)!=="svelte-fmmzem"&&(w.innerHTML=S),V=i(t),C=p(t,"BLOCKQUOTE",{"data-svelte-h":!0}),f(C)!=="svelte-10kj63n"&&(C.innerHTML=ee),E=i(t),c(g.$$.fragment,t),L=i(t),v=p(t,"P",{"data-svelte-h":!0}),f(v)!=="svelte-1qozsrk"&&(v.innerHTML=Y),A=i(t),c(I.$$.fragment,t),k=i(t),X=p(t,"P",{"data-svelte-h":!0}),f(X)!=="svelte-2bde4h"&&(X.textContent=P),G=i(t),$=p(t,"P",{"data-svelte-h":!0}),f($)!=="svelte-6ilppp"&&($.innerHTML=H),D=i(t),c(W.$$.fragment,t),R=i(t),B=p(t,"DIV",{class:!0,"data-svelte-h":!0}),f(B)!=="svelte-qev6y1"&&(B.innerHTML=N),Q=i(t),j=p(t,"BLOCKQUOTE",{"data-svelte-h":!0}),f(j)!=="svelte-rwvqdw"&&(j.innerHTML=te),x=i(t),_=p(t,"P",{"data-svelte-h":!0}),f(_)!=="svelte-13wiqqe"&&(_.innerHTML=K),this.h()},h(){dt(B,"class","flex justify-center")},m(t,r){l(t,o,r),l(t,d,r),l(t,h,r),l(t,Z,r),l(t,w,r),l(t,V,r),l(t,C,r),l(t,E,r),J(g,t,r),l(t,L,r),l(t,v,r),l(t,A,r),J(I,t,r),l(t,k,r),l(t,X,r),l(t,G,r),l(t,$,r),l(t,D,r),J(W,t,r),l(t,R,r),l(t,B,r),l(t,Q,r),l(t,j,r),l(t,x,r),l(t,_,r),F=!0},p:Xe,i(t){F||(M(g.$$.fragment,t),M(I.$$.fragment,t),M(W.$$.fragment,t),F=!0)},o(t){T(g.$$.fragment,t),T(I.$$.fragment,t),T(W.$$.fragment,t),F=!1},d(t){t&&(s(o),s(d),s(h),s(Z),s(w),s(V),s(C),s(E),s(L),s(v),s(A),s(k),s(X),s(G),s($),s(D),s(R),s(B),s(Q),s(j),s(x),s(_)),b(g,t),b(I,t),b(W,t)}}}function Vt(z){let o,U,d,h;return o=new vt({props:{id:"bnb",option:"8-bit",$$slots:{default:[qt]},$$scope:{ctx:z}}}),d=new vt({props:{id:"bnb",option:"4-bit",$$slots:{default:[zt]},$$scope:{ctx:z}}}),{c(){y(o.$$.fragment),U=a(),y(d.$$.fragment)},l(u){c(o.$$.fragment,u),U=i(u),c(d.$$.fragment,u)},m(u,Z){J(o,u,Z),l(u,U,Z),J(d,u,Z),h=!0},p(u,Z){const w={};Z&2&&(w.$$scope={dirty:Z,ctx:u}),o.$set(w);const S={};Z&2&&(S.$$scope={dirty:Z,ctx:u}),d.$set(S)},i(u){h||(M(o.$$.fragment,u),M(d.$$.fragment,u),h=!0)},o(u){T(o.$$.fragment,u),T(d.$$.fragment,u),h=!1},d(u){u&&s(U),b(o,u),b(d,u)}}}function Et(z){let o,U="Training with 8-bit and 4-bit weights are only supported for training <em>extra</em> parameters.";return{c(){o=m("p"),o.innerHTML=U},l(d){o=p(d,"P",{"data-svelte-h":!0}),f(o)!=="svelte-of9sym"&&(o.innerHTML=U)},m(d,h){l(d,o,h)},p:Xe,d(d){d&&s(o)}}}function Nt(z){let o,U='Learn more about the details of 8-bit quantization in this <a href="https://huggingface.co/blog/hf-bitsandbytes-integration" rel="nofollow">blog post</a>!';return{c(){o=m("p"),o.innerHTML=U},l(d){o=p(d,"P",{"data-svelte-h":!0}),f(o)!=="svelte-1bb05fp"&&(o.innerHTML=U)},m(d,h){l(d,o,h)},p:Xe,d(d){d&&s(o)}}}function Qt(z){let o,U='Learn more about its details in this <a href="https://huggingface.co/blog/4bit-transformers-bitsandbytes" rel="nofollow">blog post</a>.';return{c(){o=m("p"),o.innerHTML=U},l(d){o=p(d,"P",{"data-svelte-h":!0}),f(o)!=="svelte-kpdzjq"&&(o.innerHTML=U)},m(d,h){l(d,o,h)},p:Xe,d(d){d&&s(o)}}}function xt(z){let o,U,d,h,u,Z,w,S='<a href="https://huggingface.co/docs/bitsandbytes/index" rel="nofollow">bitsandbytes</a> is the easiest option for quantizing a model to 8 and 4-bit. 8-bit quantization multiplies outliers in fp16 with non-outliers in int8, converts the non-outlier values back to fp16, and then adds them together to return the weights in fp16. This reduces the degradative effect outlier values have on a model’s performance.',V,C,ee='4-bit quantization compresses a model even further, and it is commonly used with <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a> to finetune quantized LLMs.',E,g,L=`This guide demonstrates how quantization can enable running
<a href="https://huggingface.co/black-forest-labs/FLUX.1-dev" rel="nofollow">FLUX.1-dev</a>
on less than 16GB of VRAM and even on a free Google
Colab instance.`,v,Y,A='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/quant-bnb/comparison.png" alt="comparison image"/>',I,k,X="To use bitsandbytes, make sure you have the following libraries installed:",P,G,$,H,D='Now you can quantize a model by passing a <a href="/docs/diffusers/pr_10012/en/api/quantization#diffusers.BitsAndBytesConfig">BitsAndBytesConfig</a> to <a href="/docs/diffusers/pr_10012/en/api/models/overview#diffusers.ModelMixin.from_pretrained">from_pretrained()</a>. This works for any model in any modality, as long as it supports loading with <a href="https://hf.co/docs/accelerate/index" rel="nofollow">Accelerate</a> and contains <code>torch.nn.Linear</code> layers.',W,R,B,N,Q,j,te="Check your memory footprint with the <code>get_memory_footprint</code> method:",x,_,K,F,t='Quantized models can be loaded from the <a href="/docs/diffusers/pr_10012/en/api/models/overview#diffusers.ModelMixin.from_pretrained">from_pretrained()</a> method without needing to specify the <code>quantization_config</code> parameters:',r,ne,Re,ae,ke,se,Ge,ie,ut="This section explores some of the specific features of 8-bit models, such as outlier thresholds and skipping module conversion.",Fe,oe,qe,re,yt="An “outlier” is a hidden state value greater than a certain threshold, and these values are computed in fp16. While the values are usually normally distributed ([-3.5, 3.5]), this distribution can be very different for large models ([-60, 6] or [6, 60]). 8-bit quantization works well for values ~5, but beyond that, there is a significant performance penalty. A good default threshold value is 6, but a lower threshold may be needed for more unstable models (small models or finetuning).",ze,me,ct='To find the best threshold for your model, we recommend experimenting with the <code>llm_int8_threshold</code> parameter in <a href="/docs/diffusers/pr_10012/en/api/quantization#diffusers.BitsAndBytesConfig">BitsAndBytesConfig</a>:',Ve,pe,Ee,de,Ne,fe,Jt='For some models, you don’t need to quantize every module to 8-bit which can actually cause instability. For example, for diffusion models like <a href="../api/pipelines/stable_diffusion/stable_diffusion_3">Stable Diffusion 3</a>, the <code>proj_out</code> module can be skipped using the <code>llm_int8_skip_modules</code> parameter in <a href="/docs/diffusers/pr_10012/en/api/quantization#diffusers.BitsAndBytesConfig">BitsAndBytesConfig</a>:',Qe,ue,xe,ye,Ye,le,He,ce,Mt="This section explores some of the specific features of 4-bit models, such as changing the compute data type, using the Normal Float 4 (NF4) data type, and using nested quantization.",Le,Je,Ae,Me,Tt='To speedup computation, you can change the data type from float32 (the default value) to bf16 using the <code>bnb_4bit_compute_dtype</code> parameter in <a href="/docs/diffusers/pr_10012/en/api/quantization#diffusers.BitsAndBytesConfig">BitsAndBytesConfig</a>:',De,Te,Se,be,Pe,he,bt='NF4 is a 4-bit data type from the <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a> paper, adapted for weights initialized from a normal distribution. You should use NF4 for training 4-bit base models. This can be configured with the <code>bnb_4bit_quant_type</code> parameter in the <a href="/docs/diffusers/pr_10012/en/api/quantization#diffusers.BitsAndBytesConfig">BitsAndBytesConfig</a>:',Ke,we,Oe,Ue,ht="For inference, the <code>bnb_4bit_quant_type</code> does not have a huge impact on performance. However, to remain consistent with the model weights, you should use the <code>bnb_4bit_compute_dtype</code> and <code>torch_dtype</code> values.",et,Ze,tt,Ce,wt="Nested quantization is a technique that can save additional memory at no additional performance cost. This feature performs a second quantization of the already quantized weights to save an additional 0.4 bits/parameter.",st,ge,lt,je,nt,_e,Ut="Once quantized, you can dequantize a model to its original precision, but this might result in a small loss of quality. Make sure you have enough GPU RAM to fit the dequantized model.",at,Be,it,ve,ot,Ie,Zt='<li><a href="https://gist.github.com/sayakpaul/c76bd845b48759e11687ac550b99d8b4" rel="nofollow">End-to-end notebook showing Flux.1 Dev inference in a free-tier Colab</a></li> <li><a href="https://gist.github.com/sayakpaul/05afd428bc089b47af7c016e42004527" rel="nofollow">Training</a></li>',rt,$e,mt,We,pt;return u=new O({props:{title:"bitsandbytes",local:"bitsandbytes",headingTag:"h1"}}),G=new q({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRpZmZ1c2VycyUyMHRyYW5zZm9ybWVycyUyMGFjY2VsZXJhdGUlMjBiaXRzYW5kYnl0ZXMlMjAtVQ==",highlighted:"pip install diffusers transformers accelerate bitsandbytes -U",wrap:!1}}),R=new Ft({props:{id:"bnb",options:["8-bit","4-bit"],$$slots:{default:[Vt]},$$scope:{ctx:z}}}),N=new ft({props:{warning:!0,$$slots:{default:[Et]},$$scope:{ctx:z}}}),_=new q({props:{code:"cHJpbnQobW9kZWwuZ2V0X21lbW9yeV9mb290cHJpbnQoKSk=",highlighted:'<span class="hljs-built_in">print</span>(model.get_memory_footprint())',wrap:!1}}),ne=new q({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwlMkMlMjBCaXRzQW5kQnl0ZXNDb25maWclMEElMEFxdWFudGl6YXRpb25fY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fNGJpdCUzRFRydWUpJTBBJTBBbW9kZWxfNGJpdCUyMCUzRCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZmbHV4LjEtZGV2LW5mNC1wa2clMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJ0cmFuc2Zvcm1lciUyMiUwQSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxTransformer2DModel, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>)

model_4bit = FluxTransformer2DModel.from_pretrained(
    <span class="hljs-string">&quot;hf-internal-testing/flux.1-dev-nf4-pkg&quot;</span>, subfolder=<span class="hljs-string">&quot;transformer&quot;</span>
)`,wrap:!1}}),ae=new O({props:{title:"8-bit (LLM.int8() algorithm)",local:"8-bit-llmint8-algorithm",headingTag:"h2"}}),se=new ft({props:{$$slots:{default:[Nt]},$$scope:{ctx:z}}}),oe=new O({props:{title:"Outlier threshold",local:"outlier-threshold",headingTag:"h3"}}),pe=new q({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwlMkMlMjBCaXRzQW5kQnl0ZXNDb25maWclMEElMEFxdWFudGl6YXRpb25fY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fOGJpdCUzRFRydWUlMkMlMjBsbG1faW50OF90aHJlc2hvbGQlM0QxMCUyQyUwQSklMEElMEFtb2RlbF84Yml0JTIwJTNEJTIwRmx1eFRyYW5zZm9ybWVyMkRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRpemF0aW9uX2NvbmZpZyUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxTransformer2DModel, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(
    load_in_8bit=<span class="hljs-literal">True</span>, llm_int8_threshold=<span class="hljs-number">10</span>,
)

model_8bit = FluxTransformer2DModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quantization_config,
)`,wrap:!1}}),de=new O({props:{title:"Skip module conversion",local:"skip-module-conversion",headingTag:"h3"}}),ue=new q({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFNEM1RyYW5zZm9ybWVyMkRNb2RlbCUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl84Yml0JTNEVHJ1ZSUyQyUyMGxsbV9pbnQ4X3NraXBfbW9kdWxlcyUzRCU1QiUyMnByb2pfb3V0JTIyJTVEJTJDJTBBKSUwQSUwQW1vZGVsXzhiaXQlMjAlM0QlMjBTRDNUcmFuc2Zvcm1lcjJETW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi0zLW1lZGl1bS1kaWZmdXNlcnMlMjIlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0cmFuc2Zvcm1lciUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudGl6YXRpb25fY29uZmlnJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> SD3Transformer2DModel, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(
    load_in_8bit=<span class="hljs-literal">True</span>, llm_int8_skip_modules=[<span class="hljs-string">&quot;proj_out&quot;</span>],
)

model_8bit = SD3Transformer2DModel.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quantization_config,
)`,wrap:!1}}),ye=new O({props:{title:"4-bit (QLoRA algorithm)",local:"4-bit-qlora-algorithm",headingTag:"h2"}}),le=new ft({props:{$$slots:{default:[Qt]},$$scope:{ctx:z}}}),Je=new O({props:{title:"Compute data type",local:"compute-data-type",headingTag:"h3"}}),Te=new q({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyhsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>, bnb_4bit_compute_dtype=torch.bfloat16)`,wrap:!1}}),be=new O({props:{title:"Normal Float 4 (NF4)",local:"normal-float-4-nf4",headingTag:"h3"}}),we=new q({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVDVFbmNvZGVyTW9kZWwlMEElMEFxdWFudF9jb25maWclMjAlM0QlMjBUcmFuc2Zvcm1lcnNCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3F1YW50X3R5cGUlM0QlMjJuZjQlMjIlMkMlMEEpJTBBJTBBdGV4dF9lbmNvZGVyXzJfNGJpdCUyMCUzRCUyMFQ1RW5jb2Rlck1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0ZXh0X2VuY29kZXJfMiUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudF9jb25maWclMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEpJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9xdWFudF90eXBlJTNEJTIybmY0JTIyJTJDJTBBKSUwQSUwQXRyYW5zZm9ybWVyXzRiaXQlMjAlM0QlMjBGbHV4VHJhbnNmb3JtZXIyRE1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0cmFuc2Zvcm1lciUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudF9jb25maWclMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> TransformersBitsAndBytesConfig

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxTransformer2DModel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel

quant_config = TransformersBitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
)

text_encoder_2_4bit = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder_2&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

quant_config = DiffusersBitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
)

transformer_4bit = FluxTransformer2DModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)`,wrap:!1}}),Ze=new O({props:{title:"Nested quantization",local:"nested-quantization",headingTag:"h3"}}),ge=new q({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVDVFbmNvZGVyTW9kZWwlMEElMEFxdWFudF9jb25maWclMjAlM0QlMjBUcmFuc2Zvcm1lcnNCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3VzZV9kb3VibGVfcXVhbnQlM0RUcnVlJTJDJTBBKSUwQSUwQXRleHRfZW5jb2Rlcl8yXzRiaXQlMjAlM0QlMjBUNUVuY29kZXJNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydGV4dF9lbmNvZGVyXzIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKSUwQSUwQXF1YW50X2NvbmZpZyUyMCUzRCUyMERpZmZ1c2Vyc0JpdHNBbmRCeXRlc0NvbmZpZyglMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfdXNlX2RvdWJsZV9xdWFudCUzRFRydWUlMkMlMEEpJTBBJTBBdHJhbnNmb3JtZXJfNGJpdCUyMCUzRCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRyYW5zZm9ybWVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50X2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> TransformersBitsAndBytesConfig

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxTransformer2DModel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel

quant_config = TransformersBitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
)

text_encoder_2_4bit = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder_2&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

quant_config = DiffusersBitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
)

transformer_4bit = FluxTransformer2DModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)`,wrap:!1}}),je=new O({props:{title:"Dequantizing bitsandbytes models",local:"dequantizing-bitsandbytes-models",headingTag:"h2"}}),Be=new q({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVDVFbmNvZGVyTW9kZWwlMEElMEFxdWFudF9jb25maWclMjAlM0QlMjBUcmFuc2Zvcm1lcnNCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3VzZV9kb3VibGVfcXVhbnQlM0RUcnVlJTJDJTBBKSUwQSUwQXRleHRfZW5jb2Rlcl8yXzRiaXQlMjAlM0QlMjBUNUVuY29kZXJNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydGV4dF9lbmNvZGVyXzIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKSUwQSUwQXF1YW50X2NvbmZpZyUyMCUzRCUyMERpZmZ1c2Vyc0JpdHNBbmRCeXRlc0NvbmZpZyglMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfdXNlX2RvdWJsZV9xdWFudCUzRFRydWUlMkMlMEEpJTBBJTBBdHJhbnNmb3JtZXJfNGJpdCUyMCUzRCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRyYW5zZm9ybWVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50X2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSklMEElMEF0ZXh0X2VuY29kZXJfMl80Yml0LmRlcXVhbnRpemUoKSUwQXRyYW5zZm9ybWVyXzRiaXQuZGVxdWFudGl6ZSgp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> TransformersBitsAndBytesConfig

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxTransformer2DModel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel

quant_config = TransformersBitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
)

text_encoder_2_4bit = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder_2&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

quant_config = DiffusersBitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
)

transformer_4bit = FluxTransformer2DModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

text_encoder_2_4bit.dequantize()
transformer_4bit.dequantize()`,wrap:!1}}),ve=new O({props:{title:"Resources",local:"resources",headingTag:"h2"}}),$e=new Gt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/quantization/bitsandbytes.md"}}),{c(){o=m("meta"),U=a(),d=m("p"),h=a(),y(u.$$.fragment),Z=a(),w=m("p"),w.innerHTML=S,V=a(),C=m("p"),C.innerHTML=ee,E=a(),g=m("p"),g.innerHTML=L,v=a(),Y=m("p"),Y.innerHTML=A,I=a(),k=m("p"),k.textContent=X,P=a(),y(G.$$.fragment),$=a(),H=m("p"),H.innerHTML=D,W=a(),y(R.$$.fragment),B=a(),y(N.$$.fragment),Q=a(),j=m("p"),j.innerHTML=te,x=a(),y(_.$$.fragment),K=a(),F=m("p"),F.innerHTML=t,r=a(),y(ne.$$.fragment),Re=a(),y(ae.$$.fragment),ke=a(),y(se.$$.fragment),Ge=a(),ie=m("p"),ie.textContent=ut,Fe=a(),y(oe.$$.fragment),qe=a(),re=m("p"),re.textContent=yt,ze=a(),me=m("p"),me.innerHTML=ct,Ve=a(),y(pe.$$.fragment),Ee=a(),y(de.$$.fragment),Ne=a(),fe=m("p"),fe.innerHTML=Jt,Qe=a(),y(ue.$$.fragment),xe=a(),y(ye.$$.fragment),Ye=a(),y(le.$$.fragment),He=a(),ce=m("p"),ce.textContent=Mt,Le=a(),y(Je.$$.fragment),Ae=a(),Me=m("p"),Me.innerHTML=Tt,De=a(),y(Te.$$.fragment),Se=a(),y(be.$$.fragment),Pe=a(),he=m("p"),he.innerHTML=bt,Ke=a(),y(we.$$.fragment),Oe=a(),Ue=m("p"),Ue.innerHTML=ht,et=a(),y(Ze.$$.fragment),tt=a(),Ce=m("p"),Ce.textContent=wt,st=a(),y(ge.$$.fragment),lt=a(),y(je.$$.fragment),nt=a(),_e=m("p"),_e.textContent=Ut,at=a(),y(Be.$$.fragment),it=a(),y(ve.$$.fragment),ot=a(),Ie=m("ul"),Ie.innerHTML=Zt,rt=a(),y($e.$$.fragment),mt=a(),We=m("p"),this.h()},l(e){const n=Rt("svelte-u9bgzb",document.head);o=p(n,"META",{name:!0,content:!0}),n.forEach(s),U=i(e),d=p(e,"P",{}),Bt(d).forEach(s),h=i(e),c(u.$$.fragment,e),Z=i(e),w=p(e,"P",{"data-svelte-h":!0}),f(w)!=="svelte-1m50ob7"&&(w.innerHTML=S),V=i(e),C=p(e,"P",{"data-svelte-h":!0}),f(C)!=="svelte-11pyf03"&&(C.innerHTML=ee),E=i(e),g=p(e,"P",{"data-svelte-h":!0}),f(g)!=="svelte-1erhi5i"&&(g.innerHTML=L),v=i(e),Y=p(e,"P",{"data-svelte-h":!0}),f(Y)!=="svelte-ryfe7d"&&(Y.innerHTML=A),I=i(e),k=p(e,"P",{"data-svelte-h":!0}),f(k)!=="svelte-gf36q7"&&(k.textContent=X),P=i(e),c(G.$$.fragment,e),$=i(e),H=p(e,"P",{"data-svelte-h":!0}),f(H)!=="svelte-js0psj"&&(H.innerHTML=D),W=i(e),c(R.$$.fragment,e),B=i(e),c(N.$$.fragment,e),Q=i(e),j=p(e,"P",{"data-svelte-h":!0}),f(j)!=="svelte-139tok6"&&(j.innerHTML=te),x=i(e),c(_.$$.fragment,e),K=i(e),F=p(e,"P",{"data-svelte-h":!0}),f(F)!=="svelte-1sw5q2p"&&(F.innerHTML=t),r=i(e),c(ne.$$.fragment,e),Re=i(e),c(ae.$$.fragment,e),ke=i(e),c(se.$$.fragment,e),Ge=i(e),ie=p(e,"P",{"data-svelte-h":!0}),f(ie)!=="svelte-1myadau"&&(ie.textContent=ut),Fe=i(e),c(oe.$$.fragment,e),qe=i(e),re=p(e,"P",{"data-svelte-h":!0}),f(re)!=="svelte-ur5rgd"&&(re.textContent=yt),ze=i(e),me=p(e,"P",{"data-svelte-h":!0}),f(me)!=="svelte-1gvj5wj"&&(me.innerHTML=ct),Ve=i(e),c(pe.$$.fragment,e),Ee=i(e),c(de.$$.fragment,e),Ne=i(e),fe=p(e,"P",{"data-svelte-h":!0}),f(fe)!=="svelte-rkwz6m"&&(fe.innerHTML=Jt),Qe=i(e),c(ue.$$.fragment,e),xe=i(e),c(ye.$$.fragment,e),Ye=i(e),c(le.$$.fragment,e),He=i(e),ce=p(e,"P",{"data-svelte-h":!0}),f(ce)!=="svelte-7ob7j"&&(ce.textContent=Mt),Le=i(e),c(Je.$$.fragment,e),Ae=i(e),Me=p(e,"P",{"data-svelte-h":!0}),f(Me)!=="svelte-i3bhq"&&(Me.innerHTML=Tt),De=i(e),c(Te.$$.fragment,e),Se=i(e),c(be.$$.fragment,e),Pe=i(e),he=p(e,"P",{"data-svelte-h":!0}),f(he)!=="svelte-1jbdjte"&&(he.innerHTML=bt),Ke=i(e),c(we.$$.fragment,e),Oe=i(e),Ue=p(e,"P",{"data-svelte-h":!0}),f(Ue)!=="svelte-1qoc2ct"&&(Ue.innerHTML=ht),et=i(e),c(Ze.$$.fragment,e),tt=i(e),Ce=p(e,"P",{"data-svelte-h":!0}),f(Ce)!=="svelte-ep1hhf"&&(Ce.textContent=wt),st=i(e),c(ge.$$.fragment,e),lt=i(e),c(je.$$.fragment,e),nt=i(e),_e=p(e,"P",{"data-svelte-h":!0}),f(_e)!=="svelte-lubruw"&&(_e.textContent=Ut),at=i(e),c(Be.$$.fragment,e),it=i(e),c(ve.$$.fragment,e),ot=i(e),Ie=p(e,"UL",{"data-svelte-h":!0}),f(Ie)!=="svelte-vejlmz"&&(Ie.innerHTML=Zt),rt=i(e),c($e.$$.fragment,e),mt=i(e),We=p(e,"P",{}),Bt(We).forEach(s),this.h()},h(){dt(o,"name","hf:doc:metadata"),dt(o,"content",Yt)},m(e,n){kt(document.head,o),l(e,U,n),l(e,d,n),l(e,h,n),J(u,e,n),l(e,Z,n),l(e,w,n),l(e,V,n),l(e,C,n),l(e,E,n),l(e,g,n),l(e,v,n),l(e,Y,n),l(e,I,n),l(e,k,n),l(e,P,n),J(G,e,n),l(e,$,n),l(e,H,n),l(e,W,n),J(R,e,n),l(e,B,n),J(N,e,n),l(e,Q,n),l(e,j,n),l(e,x,n),J(_,e,n),l(e,K,n),l(e,F,n),l(e,r,n),J(ne,e,n),l(e,Re,n),J(ae,e,n),l(e,ke,n),J(se,e,n),l(e,Ge,n),l(e,ie,n),l(e,Fe,n),J(oe,e,n),l(e,qe,n),l(e,re,n),l(e,ze,n),l(e,me,n),l(e,Ve,n),J(pe,e,n),l(e,Ee,n),J(de,e,n),l(e,Ne,n),l(e,fe,n),l(e,Qe,n),J(ue,e,n),l(e,xe,n),J(ye,e,n),l(e,Ye,n),J(le,e,n),l(e,He,n),l(e,ce,n),l(e,Le,n),J(Je,e,n),l(e,Ae,n),l(e,Me,n),l(e,De,n),J(Te,e,n),l(e,Se,n),J(be,e,n),l(e,Pe,n),l(e,he,n),l(e,Ke,n),J(we,e,n),l(e,Oe,n),l(e,Ue,n),l(e,et,n),J(Ze,e,n),l(e,tt,n),l(e,Ce,n),l(e,st,n),J(ge,e,n),l(e,lt,n),J(je,e,n),l(e,nt,n),l(e,_e,n),l(e,at,n),J(Be,e,n),l(e,it,n),J(ve,e,n),l(e,ot,n),l(e,Ie,n),l(e,rt,n),J($e,e,n),l(e,mt,n),l(e,We,n),pt=!0},p(e,[n]){const Ct={};n&2&&(Ct.$$scope={dirty:n,ctx:e}),R.$set(Ct);const gt={};n&2&&(gt.$$scope={dirty:n,ctx:e}),N.$set(gt);const jt={};n&2&&(jt.$$scope={dirty:n,ctx:e}),se.$set(jt);const _t={};n&2&&(_t.$$scope={dirty:n,ctx:e}),le.$set(_t)},i(e){pt||(M(u.$$.fragment,e),M(G.$$.fragment,e),M(R.$$.fragment,e),M(N.$$.fragment,e),M(_.$$.fragment,e),M(ne.$$.fragment,e),M(ae.$$.fragment,e),M(se.$$.fragment,e),M(oe.$$.fragment,e),M(pe.$$.fragment,e),M(de.$$.fragment,e),M(ue.$$.fragment,e),M(ye.$$.fragment,e),M(le.$$.fragment,e),M(Je.$$.fragment,e),M(Te.$$.fragment,e),M(be.$$.fragment,e),M(we.$$.fragment,e),M(Ze.$$.fragment,e),M(ge.$$.fragment,e),M(je.$$.fragment,e),M(Be.$$.fragment,e),M(ve.$$.fragment,e),M($e.$$.fragment,e),pt=!0)},o(e){T(u.$$.fragment,e),T(G.$$.fragment,e),T(R.$$.fragment,e),T(N.$$.fragment,e),T(_.$$.fragment,e),T(ne.$$.fragment,e),T(ae.$$.fragment,e),T(se.$$.fragment,e),T(oe.$$.fragment,e),T(pe.$$.fragment,e),T(de.$$.fragment,e),T(ue.$$.fragment,e),T(ye.$$.fragment,e),T(le.$$.fragment,e),T(Je.$$.fragment,e),T(Te.$$.fragment,e),T(be.$$.fragment,e),T(we.$$.fragment,e),T(Ze.$$.fragment,e),T(ge.$$.fragment,e),T(je.$$.fragment,e),T(Be.$$.fragment,e),T(ve.$$.fragment,e),T($e.$$.fragment,e),pt=!1},d(e){e&&(s(U),s(d),s(h),s(Z),s(w),s(V),s(C),s(E),s(g),s(v),s(Y),s(I),s(k),s(P),s($),s(H),s(W),s(B),s(Q),s(j),s(x),s(K),s(F),s(r),s(Re),s(ke),s(Ge),s(ie),s(Fe),s(qe),s(re),s(ze),s(me),s(Ve),s(Ee),s(Ne),s(fe),s(Qe),s(xe),s(Ye),s(He),s(ce),s(Le),s(Ae),s(Me),s(De),s(Se),s(Pe),s(he),s(Ke),s(Oe),s(Ue),s(et),s(tt),s(Ce),s(st),s(lt),s(nt),s(_e),s(at),s(it),s(ot),s(Ie),s(rt),s(mt),s(We)),s(o),b(u,e),b(G,e),b(R,e),b(N,e),b(_,e),b(ne,e),b(ae,e),b(se,e),b(oe,e),b(pe,e),b(de,e),b(ue,e),b(ye,e),b(le,e),b(Je,e),b(Te,e),b(be,e),b(we,e),b(Ze,e),b(ge,e),b(je,e),b(Be,e),b(ve,e),b($e,e)}}}const Yt='{"title":"bitsandbytes","local":"bitsandbytes","sections":[{"title":"8-bit (LLM.int8() algorithm)","local":"8-bit-llmint8-algorithm","sections":[{"title":"Outlier threshold","local":"outlier-threshold","sections":[],"depth":3},{"title":"Skip module conversion","local":"skip-module-conversion","sections":[],"depth":3}],"depth":2},{"title":"4-bit (QLoRA algorithm)","local":"4-bit-qlora-algorithm","sections":[{"title":"Compute data type","local":"compute-data-type","sections":[],"depth":3},{"title":"Normal Float 4 (NF4)","local":"normal-float-4-nf4","sections":[],"depth":3},{"title":"Nested quantization","local":"nested-quantization","sections":[],"depth":3}],"depth":2},{"title":"Dequantizing bitsandbytes models","local":"dequantizing-bitsandbytes-models","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function Ht(z){return $t(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ot extends Wt{constructor(o){super(),Xt(this,o,Ht,xt,It,{})}}export{Ot as component};
