import{s as wt,n as Ut,o as Jt}from"../chunks/scheduler.3a17fb72.js";import{S as jt,i as Ct,e as M,s as i,c as a,h as bt,a as u,d as l,b as n,f as Tt,g as m,j as y,k as st,l as vt,m as s,n as p,t as r,o as c,p as o}from"../chunks/index.093f8863.js";import{C as It,H as f,E as _t}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.f34f997e.js";import{C as $}from"../chunks/CodeBlock.2bb8c6c8.js";function kt(it){let g,ce,pe,oe,T,Me,w,ue,U,fe,J,ye,j,nt="There are two types of metrics in Lighteval:",ge,C,$e,b,at="<li><strong>Purpose</strong>: Evaluate individual samples/predictions</li> <li><strong>Input</strong>: Takes a <code>Doc</code> and <code>ModelResponse</code> (model’s prediction)</li> <li><strong>Output</strong>: Returns a float or boolean value for that specific sample</li> <li><strong>Example</strong>: Checking if a model’s answer matches the correct answer for one sample</li>",he,v,de,I,mt=`<li><strong>Purpose</strong>: Compute final scores across the entire dataset/corpus</li> <li><strong>Input</strong>: Takes the results from all sample-level evaluations</li> <li><strong>Output</strong>: Returns a single score representing overall performance</li> <li><strong>Examples</strong>:
<ul><li>Simple aggregation: Calculating average accuracy across all test samples</li> <li>Complex metrics: BLEU score where sample-level metric prepares data (tokenization, etc.) and corpus-level metric computes the actual BLEU score</li></ul></li>`,Te,_,we,k,pt=`First, check if you can use one of the parameterized functions in
<a href="package_reference/metrics#corpus-metrics">Corpus Metrics</a> or
<a href="package_reference/metrics#sample-metrics">Sample Metrics</a>.`,Ue,V,rt="If not, you can use the <code>custom_task</code> system to register your new metric.",Je,h,ct='<p>To see an example of a custom metric added along with a custom task, look at the <a href="https://github.com/huggingface/lighteval/tree/main/examples/custom_tasks/ifeval" rel="nofollow">IFEval custom task</a>.</p>',je,d,ot=`<p>To contribute your custom metric to the Lighteval repository, you would first need
to install the required dev dependencies by running <code>pip install -e .[dev]</code>
and then run <code>pre-commit install</code> to install the pre-commit hooks.</p>`,Ce,G,be,E,ve,Z,Mt=`Create a new Python file which should contain the full logic of your metric.
The file also needs to start with these imports:`,Ie,B,_e,X,ke,S,ut=`You need to define a sample-level metric. All sample-level metrics will have the same signature, taking a
<code>~lighteval.types.Doc</code> and a <code>~lighteval.types.ModelResponse</code>. The metric should return a float or a
boolean.`,Ve,x,Ge,R,Ee,Y,Ze,N,ft="If you want to return multiple metrics per sample, you need to return a dictionary with the metrics as keys and the values as values:",Be,z,Xe,W,Se,A,yt="You can define an aggregation function if needed. A common aggregation function is <code>np.mean</code>:",xe,L,Re,Q,Ye,q,Ne,H,gt=`If it’s a sample-level metric, you can use the following code
with <a href="/docs/lighteval/pr_1057/en/package_reference/metrics#lighteval.metrics.utils.metric_utils.SampleLevelMetric">SampleLevelMetric</a>:`,ze,F,We,P,Ae,D,$t=`If your metric defines multiple metrics per sample, you can use the following code
with <a href="/docs/lighteval/pr_1057/en/package_reference/metrics#lighteval.metrics.utils.metric_utils.SampleLevelMetricGrouping">SampleLevelMetricGrouping</a>:`,Le,O,Qe,K,qe,ee,ht=`To finish, add the following code so that it adds your metric to our metrics list
when loaded as a module:`,He,te,Fe,le,Pe,se,De,ie,dt="You can then give your custom metric to Lighteval by using <code>--custom-tasks path_to_your_file</code> when launching it after adding it to the task config.",Oe,ne,Ke,ae,et,me,tt,re,lt;return T=new It({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),w=new f({props:{title:"Adding a New Metric",local:"adding-a-new-metric",headingTag:"h1"}}),U=new f({props:{title:"Before You Start",local:"before-you-start",headingTag:"h2"}}),J=new f({props:{title:"Two different types of metrics",local:"two-different-types-of-metrics",headingTag:"h3"}}),C=new f({props:{title:"Sample-Level Metrics",local:"sample-level-metrics",headingTag:"h4"}}),v=new f({props:{title:"Corpus-Level Metrics",local:"corpus-level-metrics",headingTag:"h4"}}),_=new f({props:{title:"Check Existing Metrics",local:"check-existing-metrics",headingTag:"h3"}}),G=new f({props:{title:"Creating a Custom Metric",local:"creating-a-custom-metric",headingTag:"h2"}}),E=new f({props:{title:"Step 1: Create the Metric File",local:"step-1-create-the-metric-file",headingTag:"h3"}}),B=new $({props:{code:"ZnJvbSUyMGFlbnVtJTIwaW1wb3J0JTIwZXh0ZW5kX2VudW0lMEFmcm9tJTIwbGlnaHRldmFsLm1ldHJpY3MlMjBpbXBvcnQlMjBNZXRyaWNz",highlighted:`<span class="hljs-keyword">from</span> aenum <span class="hljs-keyword">import</span> extend_enum
<span class="hljs-keyword">from</span> lighteval.metrics <span class="hljs-keyword">import</span> Metrics`,wrap:!1}}),X=new f({props:{title:"Step 2: Define the Sample-Level Metric",local:"step-2-define-the-sample-level-metric",headingTag:"h3"}}),x=new f({props:{title:"Single Metric Example",local:"single-metric-example",headingTag:"h4"}}),R=new $({props:{code:"ZGVmJTIwY3VzdG9tX21ldHJpYyhkb2MlM0ElMjBEb2MlMkMlMjBtb2RlbF9yZXNwb25zZSUzQSUyME1vZGVsUmVzcG9uc2UpJTIwLSUzRSUyMGJvb2wlM0ElMEElMjAlMjAlMjAlMjByZXNwb25zZSUyMCUzRCUyMG1vZGVsX3Jlc3BvbnNlLmZpbmFsX3RleHQlNUIwJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwcmVzcG9uc2UlMjAlM0QlM0QlMjBkb2MuY2hvaWNlcyU1QmRvYy5nb2xkX2luZGV4JTVE",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">custom_metric</span>(<span class="hljs-params">doc: Doc, model_response: ModelResponse</span>) -&gt; <span class="hljs-built_in">bool</span>:
    response = model_response.final_text[<span class="hljs-number">0</span>]
    <span class="hljs-keyword">return</span> response == doc.choices[doc.gold_index]`,wrap:!1}}),Y=new f({props:{title:"Multiple Metrics Example",local:"multiple-metrics-example",headingTag:"h4"}}),z=new $({props:{code:"ZGVmJTIwY3VzdG9tX21ldHJpYyhkb2MlM0ElMjBEb2MlMkMlMjBtb2RlbF9yZXNwb25zZSUzQSUyME1vZGVsUmVzcG9uc2UpJTIwLSUzRSUyMGRpY3QlM0ElMEElMjAlMjAlMjAlMjByZXNwb25zZSUyMCUzRCUyMG1vZGVsX3Jlc3BvbnNlLmZpbmFsX3RleHQlNUIwJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIyYWNjdXJhY3klMjIlM0ElMjByZXNwb25zZSUyMCUzRCUzRCUyMGRvYy5jaG9pY2VzJTVCZG9jLmdvbGRfaW5kZXglNUQlMkMlMjAlMjJvdGhlcl9tZXRyaWMlMjIlM0ElMjAwLjUlN0Q=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">custom_metric</span>(<span class="hljs-params">doc: Doc, model_response: ModelResponse</span>) -&gt; <span class="hljs-built_in">dict</span>:
    response = model_response.final_text[<span class="hljs-number">0</span>]
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;accuracy&quot;</span>: response == doc.choices[doc.gold_index], <span class="hljs-string">&quot;other_metric&quot;</span>: <span class="hljs-number">0.5</span>}`,wrap:!1}}),W=new f({props:{title:"Step 3: Define Aggregation Function (Optional)",local:"step-3-define-aggregation-function-optional",headingTag:"h3"}}),L=new $({props:{code:"ZGVmJTIwYWdnX2Z1bmN0aW9uKGl0ZW1zKSUzQSUwQSUyMCUyMCUyMCUyMGZsYXRfaXRlbXMlMjAlM0QlMjAlNUJpdGVtJTIwZm9yJTIwc3VibGlzdCUyMGluJTIwaXRlbXMlMjBmb3IlMjBpdGVtJTIwaW4lMjBzdWJsaXN0JTVEJTBBJTIwJTIwJTIwJTIwc2NvcmUlMjAlM0QlMjBzdW0oZmxhdF9pdGVtcyklMjAlMkYlMjBsZW4oZmxhdF9pdGVtcyklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzY29yZQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">agg_function</span>(<span class="hljs-params">items</span>):
    flat_items = [item <span class="hljs-keyword">for</span> sublist <span class="hljs-keyword">in</span> items <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> sublist]
    score = <span class="hljs-built_in">sum</span>(flat_items) / <span class="hljs-built_in">len</span>(flat_items)
    <span class="hljs-keyword">return</span> score`,wrap:!1}}),Q=new f({props:{title:"Step 4: Create the Metric Object",local:"step-4-create-the-metric-object",headingTag:"h3"}}),q=new f({props:{title:"Single Metric",local:"single-metric",headingTag:"h4"}}),F=new $({props:{code:"bXlfY3VzdG9tX21ldHJpYyUyMCUzRCUyMFNhbXBsZUxldmVsTWV0cmljKCUwQSUyMCUyMCUyMCUyMG1ldHJpY19uYW1lJTNEJTIyY3VzdG9tX2FjY3VyYWN5JTIyJTJDJTBBJTIwJTIwJTIwJTIwaGlnaGVyX2lzX2JldHRlciUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBjYXRlZ29yeSUzRFNhbXBsaW5nTWV0aG9kLkdFTkVSQVRJVkUlMkMlMEElMjAlMjAlMjAlMjBzYW1wbGVfbGV2ZWxfZm4lM0RjdXN0b21fbWV0cmljJTJDJTBBJTIwJTIwJTIwJTIwY29ycHVzX2xldmVsX2ZuJTNEYWdnX2Z1bmN0aW9uJTJDJTBBKQ==",highlighted:`my_custom_metric = SampleLevelMetric(
    metric_name=<span class="hljs-string">&quot;custom_accuracy&quot;</span>,
    higher_is_better=<span class="hljs-literal">True</span>,
    category=SamplingMethod.GENERATIVE,
    sample_level_fn=custom_metric,
    corpus_level_fn=agg_function,
)`,wrap:!1}}),P=new f({props:{title:"Multiple Metrics",local:"multiple-metrics",headingTag:"h4"}}),O=new $({props:{code:"Y3VzdG9tX21ldHJpYyUyMCUzRCUyMFNhbXBsZUxldmVsTWV0cmljR3JvdXBpbmcoJTBBJTIwJTIwJTIwJTIwbWV0cmljX25hbWUlM0QlNUIlMjJhY2N1cmFjeSUyMiUyQyUyMCUyMnJlc3BvbnNlX2xlbmd0aCUyMiUyQyUyMCUyMmNvbmZpZGVuY2UlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBoaWdoZXJfaXNfYmV0dGVyJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYWNjdXJhY3klMjIlM0ElMjBUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycmVzcG9uc2VfbGVuZ3RoJTIyJTNBJTIwRmFsc2UlMkMlMjAlMjAlMjMlMjBTaG9ydGVyJTIwcmVzcG9uc2VzJTIwbWlnaHQlMjBiZSUyMGJldHRlciUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbmZpZGVuY2UlMjIlM0ElMjBUcnVlJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwY2F0ZWdvcnklM0RTYW1wbGluZ01ldGhvZC5HRU5FUkFUSVZFJTJDJTBBJTIwJTIwJTIwJTIwc2FtcGxlX2xldmVsX2ZuJTNEY3VzdG9tX21ldHJpYyUyQyUwQSUyMCUyMCUyMCUyMGNvcnB1c19sZXZlbF9mbiUzRCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmFjY3VyYWN5JTIyJTNBJTIwbnAubWVhbiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJlc3BvbnNlX2xlbmd0aCUyMiUzQSUyMG5wLm1lYW4lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb25maWRlbmNlJTIyJTNBJTIwbnAubWVhbiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSk=",highlighted:`custom_metric = SampleLevelMetricGrouping(
    metric_name=[<span class="hljs-string">&quot;accuracy&quot;</span>, <span class="hljs-string">&quot;response_length&quot;</span>, <span class="hljs-string">&quot;confidence&quot;</span>],
    higher_is_better={
        <span class="hljs-string">&quot;accuracy&quot;</span>: <span class="hljs-literal">True</span>,
        <span class="hljs-string">&quot;response_length&quot;</span>: <span class="hljs-literal">False</span>,  <span class="hljs-comment"># Shorter responses might be better</span>
        <span class="hljs-string">&quot;confidence&quot;</span>: <span class="hljs-literal">True</span>
    },
    category=SamplingMethod.GENERATIVE,
    sample_level_fn=custom_metric,
    corpus_level_fn={
        <span class="hljs-string">&quot;accuracy&quot;</span>: np.mean,
        <span class="hljs-string">&quot;response_length&quot;</span>: np.mean,
        <span class="hljs-string">&quot;confidence&quot;</span>: np.mean,
    },
)`,wrap:!1}}),K=new f({props:{title:"Step 5: Register the Metric",local:"step-5-register-the-metric",headingTag:"h3"}}),te=new $({props:{code:"JTIzJTIwQWRkcyUyMHRoZSUyMG1ldHJpYyUyMHRvJTIwdGhlJTIwbWV0cmljJTIwbGlzdCElMEFleHRlbmRfZW51bShNZXRyaWNzJTJDJTIwJTIyQ1VTVE9NX0FDQ1VSQUNZJTIyJTJDJTIwbXlfY3VzdG9tX21ldHJpYyklMEElMEFpZiUyMF9fbmFtZV9fJTIwJTNEJTNEJTIwJTIyX19tYWluX18lMjIlM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjJJbXBvcnRlZCUyMG1ldHJpYyUyMik=",highlighted:`<span class="hljs-comment"># Adds the metric to the metric list!</span>
extend_enum(Metrics, <span class="hljs-string">&quot;CUSTOM_ACCURACY&quot;</span>, my_custom_metric)

<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Imported metric&quot;</span>)`,wrap:!1}}),le=new f({props:{title:"Using Your Custom Metric",local:"using-your-custom-metric",headingTag:"h2"}}),se=new f({props:{title:"With Custom Tasks",local:"with-custom-tasks",headingTag:"h3"}}),ne=new $({props:{code:"bGlnaHRldmFsJTIwYWNjZWxlcmF0ZSUyMCU1QyUwQSUyMCUyMCUyMCUyMCUyMm1vZGVsX25hbWUlM0RvcGVuYWktY29tbXVuaXR5JTJGZ3B0MiUyMiUyMCU1QyUwQSUyMCUyMCUyMCUyMCUyMnRydXRoZnVscWElM0FtYyUyMiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tY3VzdG9tLXRhc2tzJTIwcGF0aF90b195b3VyX21ldHJpY19maWxlLnB5",highlighted:`lighteval accelerate \\
    <span class="hljs-string">&quot;model_name=openai-community/gpt2&quot;</span> \\
    <span class="hljs-string">&quot;truthfulqa:mc&quot;</span> \\
    --custom-tasks path_to_your_metric_file.py`,wrap:!1}}),ae=new $({props:{code:"ZnJvbSUyMGxpZ2h0ZXZhbC50YXNrcy5saWdodGV2YWxfdGFzayUyMGltcG9ydCUyMExpZ2h0ZXZhbFRhc2tDb25maWclMEElMEF0YXNrJTIwJTNEJTIwTGlnaHRldmFsVGFza0NvbmZpZyglMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIybXlfY3VzdG9tX3Rhc2slMjIlMkMlMEElMjAlMjAlMjAlMjBzdWl0ZSUzRCU1QiUyMmNvbW11bml0eSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMG1ldHJpYyUzRCU1Qm15X2N1c3RvbV9tZXRyaWMlNUQlMkMlMjAlMjAlMjMlMjBVc2UlMjB5b3VyJTIwY3VzdG9tJTIwbWV0cmljJTIwaGVyZSUwQSUyMCUyMCUyMCUyMHByb21wdF9mdW5jdGlvbiUzRG15X3Byb21wdF9mdW5jdGlvbiUyQyUwQSUyMCUyMCUyMCUyMGhmX3JlcG8lM0QlMjJteV9kYXRhc2V0JTIyJTJDJTBBJTIwJTIwJTIwJTIwZXZhbHVhdGlvbl9zcGxpdHMlM0QlNUIlMjJ0ZXN0JTIyJTVEJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> lighteval.tasks.lighteval_task <span class="hljs-keyword">import</span> LightevalTaskConfig

task = LightevalTaskConfig(
    name=<span class="hljs-string">&quot;my_custom_task&quot;</span>,
    suite=[<span class="hljs-string">&quot;community&quot;</span>],
    metric=[my_custom_metric],  <span class="hljs-comment"># Use your custom metric here</span>
    prompt_function=my_prompt_function,
    hf_repo=<span class="hljs-string">&quot;my_dataset&quot;</span>,
    evaluation_splits=[<span class="hljs-string">&quot;test&quot;</span>]
)`,wrap:!1}}),me=new _t({props:{source:"https://github.com/huggingface/lighteval/blob/main/docs/source/adding-a-new-metric.mdx"}}),{c(){g=M("meta"),ce=i(),pe=M("p"),oe=i(),a(T.$$.fragment),Me=i(),a(w.$$.fragment),ue=i(),a(U.$$.fragment),fe=i(),a(J.$$.fragment),ye=i(),j=M("p"),j.textContent=nt,ge=i(),a(C.$$.fragment),$e=i(),b=M("ul"),b.innerHTML=at,he=i(),a(v.$$.fragment),de=i(),I=M("ul"),I.innerHTML=mt,Te=i(),a(_.$$.fragment),we=i(),k=M("p"),k.innerHTML=pt,Ue=i(),V=M("p"),V.innerHTML=rt,Je=i(),h=M("blockquote"),h.innerHTML=ct,je=i(),d=M("blockquote"),d.innerHTML=ot,Ce=i(),a(G.$$.fragment),be=i(),a(E.$$.fragment),ve=i(),Z=M("p"),Z.textContent=Mt,Ie=i(),a(B.$$.fragment),_e=i(),a(X.$$.fragment),ke=i(),S=M("p"),S.innerHTML=ut,Ve=i(),a(x.$$.fragment),Ge=i(),a(R.$$.fragment),Ee=i(),a(Y.$$.fragment),Ze=i(),N=M("p"),N.textContent=ft,Be=i(),a(z.$$.fragment),Xe=i(),a(W.$$.fragment),Se=i(),A=M("p"),A.innerHTML=yt,xe=i(),a(L.$$.fragment),Re=i(),a(Q.$$.fragment),Ye=i(),a(q.$$.fragment),Ne=i(),H=M("p"),H.innerHTML=gt,ze=i(),a(F.$$.fragment),We=i(),a(P.$$.fragment),Ae=i(),D=M("p"),D.innerHTML=$t,Le=i(),a(O.$$.fragment),Qe=i(),a(K.$$.fragment),qe=i(),ee=M("p"),ee.textContent=ht,He=i(),a(te.$$.fragment),Fe=i(),a(le.$$.fragment),Pe=i(),a(se.$$.fragment),De=i(),ie=M("p"),ie.innerHTML=dt,Oe=i(),a(ne.$$.fragment),Ke=i(),a(ae.$$.fragment),et=i(),a(me.$$.fragment),tt=i(),re=M("p"),this.h()},l(e){const t=bt("svelte-u9bgzb",document.head);g=u(t,"META",{name:!0,content:!0}),t.forEach(l),ce=n(e),pe=u(e,"P",{}),Tt(pe).forEach(l),oe=n(e),m(T.$$.fragment,e),Me=n(e),m(w.$$.fragment,e),ue=n(e),m(U.$$.fragment,e),fe=n(e),m(J.$$.fragment,e),ye=n(e),j=u(e,"P",{"data-svelte-h":!0}),y(j)!=="svelte-1jnixsg"&&(j.textContent=nt),ge=n(e),m(C.$$.fragment,e),$e=n(e),b=u(e,"UL",{"data-svelte-h":!0}),y(b)!=="svelte-1nwago0"&&(b.innerHTML=at),he=n(e),m(v.$$.fragment,e),de=n(e),I=u(e,"UL",{"data-svelte-h":!0}),y(I)!=="svelte-15e9ylm"&&(I.innerHTML=mt),Te=n(e),m(_.$$.fragment,e),we=n(e),k=u(e,"P",{"data-svelte-h":!0}),y(k)!=="svelte-vpq2qz"&&(k.innerHTML=pt),Ue=n(e),V=u(e,"P",{"data-svelte-h":!0}),y(V)!=="svelte-xdscpl"&&(V.innerHTML=rt),Je=n(e),h=u(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),y(h)!=="svelte-1nxhxit"&&(h.innerHTML=ct),je=n(e),d=u(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),y(d)!=="svelte-3wrpqo"&&(d.innerHTML=ot),Ce=n(e),m(G.$$.fragment,e),be=n(e),m(E.$$.fragment,e),ve=n(e),Z=u(e,"P",{"data-svelte-h":!0}),y(Z)!=="svelte-rk8zi4"&&(Z.textContent=Mt),Ie=n(e),m(B.$$.fragment,e),_e=n(e),m(X.$$.fragment,e),ke=n(e),S=u(e,"P",{"data-svelte-h":!0}),y(S)!=="svelte-uw89ed"&&(S.innerHTML=ut),Ve=n(e),m(x.$$.fragment,e),Ge=n(e),m(R.$$.fragment,e),Ee=n(e),m(Y.$$.fragment,e),Ze=n(e),N=u(e,"P",{"data-svelte-h":!0}),y(N)!=="svelte-1vuyefu"&&(N.textContent=ft),Be=n(e),m(z.$$.fragment,e),Xe=n(e),m(W.$$.fragment,e),Se=n(e),A=u(e,"P",{"data-svelte-h":!0}),y(A)!=="svelte-n3kro3"&&(A.innerHTML=yt),xe=n(e),m(L.$$.fragment,e),Re=n(e),m(Q.$$.fragment,e),Ye=n(e),m(q.$$.fragment,e),Ne=n(e),H=u(e,"P",{"data-svelte-h":!0}),y(H)!=="svelte-1saovko"&&(H.innerHTML=gt),ze=n(e),m(F.$$.fragment,e),We=n(e),m(P.$$.fragment,e),Ae=n(e),D=u(e,"P",{"data-svelte-h":!0}),y(D)!=="svelte-zdqee6"&&(D.innerHTML=$t),Le=n(e),m(O.$$.fragment,e),Qe=n(e),m(K.$$.fragment,e),qe=n(e),ee=u(e,"P",{"data-svelte-h":!0}),y(ee)!=="svelte-1bbv5uf"&&(ee.textContent=ht),He=n(e),m(te.$$.fragment,e),Fe=n(e),m(le.$$.fragment,e),Pe=n(e),m(se.$$.fragment,e),De=n(e),ie=u(e,"P",{"data-svelte-h":!0}),y(ie)!=="svelte-o8irch"&&(ie.innerHTML=dt),Oe=n(e),m(ne.$$.fragment,e),Ke=n(e),m(ae.$$.fragment,e),et=n(e),m(me.$$.fragment,e),tt=n(e),re=u(e,"P",{}),Tt(re).forEach(l),this.h()},h(){st(g,"name","hf:doc:metadata"),st(g,"content",Vt),st(h,"class","tip"),st(d,"class","warning")},m(e,t){vt(document.head,g),s(e,ce,t),s(e,pe,t),s(e,oe,t),p(T,e,t),s(e,Me,t),p(w,e,t),s(e,ue,t),p(U,e,t),s(e,fe,t),p(J,e,t),s(e,ye,t),s(e,j,t),s(e,ge,t),p(C,e,t),s(e,$e,t),s(e,b,t),s(e,he,t),p(v,e,t),s(e,de,t),s(e,I,t),s(e,Te,t),p(_,e,t),s(e,we,t),s(e,k,t),s(e,Ue,t),s(e,V,t),s(e,Je,t),s(e,h,t),s(e,je,t),s(e,d,t),s(e,Ce,t),p(G,e,t),s(e,be,t),p(E,e,t),s(e,ve,t),s(e,Z,t),s(e,Ie,t),p(B,e,t),s(e,_e,t),p(X,e,t),s(e,ke,t),s(e,S,t),s(e,Ve,t),p(x,e,t),s(e,Ge,t),p(R,e,t),s(e,Ee,t),p(Y,e,t),s(e,Ze,t),s(e,N,t),s(e,Be,t),p(z,e,t),s(e,Xe,t),p(W,e,t),s(e,Se,t),s(e,A,t),s(e,xe,t),p(L,e,t),s(e,Re,t),p(Q,e,t),s(e,Ye,t),p(q,e,t),s(e,Ne,t),s(e,H,t),s(e,ze,t),p(F,e,t),s(e,We,t),p(P,e,t),s(e,Ae,t),s(e,D,t),s(e,Le,t),p(O,e,t),s(e,Qe,t),p(K,e,t),s(e,qe,t),s(e,ee,t),s(e,He,t),p(te,e,t),s(e,Fe,t),p(le,e,t),s(e,Pe,t),p(se,e,t),s(e,De,t),s(e,ie,t),s(e,Oe,t),p(ne,e,t),s(e,Ke,t),p(ae,e,t),s(e,et,t),p(me,e,t),s(e,tt,t),s(e,re,t),lt=!0},p:Ut,i(e){lt||(r(T.$$.fragment,e),r(w.$$.fragment,e),r(U.$$.fragment,e),r(J.$$.fragment,e),r(C.$$.fragment,e),r(v.$$.fragment,e),r(_.$$.fragment,e),r(G.$$.fragment,e),r(E.$$.fragment,e),r(B.$$.fragment,e),r(X.$$.fragment,e),r(x.$$.fragment,e),r(R.$$.fragment,e),r(Y.$$.fragment,e),r(z.$$.fragment,e),r(W.$$.fragment,e),r(L.$$.fragment,e),r(Q.$$.fragment,e),r(q.$$.fragment,e),r(F.$$.fragment,e),r(P.$$.fragment,e),r(O.$$.fragment,e),r(K.$$.fragment,e),r(te.$$.fragment,e),r(le.$$.fragment,e),r(se.$$.fragment,e),r(ne.$$.fragment,e),r(ae.$$.fragment,e),r(me.$$.fragment,e),lt=!0)},o(e){c(T.$$.fragment,e),c(w.$$.fragment,e),c(U.$$.fragment,e),c(J.$$.fragment,e),c(C.$$.fragment,e),c(v.$$.fragment,e),c(_.$$.fragment,e),c(G.$$.fragment,e),c(E.$$.fragment,e),c(B.$$.fragment,e),c(X.$$.fragment,e),c(x.$$.fragment,e),c(R.$$.fragment,e),c(Y.$$.fragment,e),c(z.$$.fragment,e),c(W.$$.fragment,e),c(L.$$.fragment,e),c(Q.$$.fragment,e),c(q.$$.fragment,e),c(F.$$.fragment,e),c(P.$$.fragment,e),c(O.$$.fragment,e),c(K.$$.fragment,e),c(te.$$.fragment,e),c(le.$$.fragment,e),c(se.$$.fragment,e),c(ne.$$.fragment,e),c(ae.$$.fragment,e),c(me.$$.fragment,e),lt=!1},d(e){e&&(l(ce),l(pe),l(oe),l(Me),l(ue),l(fe),l(ye),l(j),l(ge),l($e),l(b),l(he),l(de),l(I),l(Te),l(we),l(k),l(Ue),l(V),l(Je),l(h),l(je),l(d),l(Ce),l(be),l(ve),l(Z),l(Ie),l(_e),l(ke),l(S),l(Ve),l(Ge),l(Ee),l(Ze),l(N),l(Be),l(Xe),l(Se),l(A),l(xe),l(Re),l(Ye),l(Ne),l(H),l(ze),l(We),l(Ae),l(D),l(Le),l(Qe),l(qe),l(ee),l(He),l(Fe),l(Pe),l(De),l(ie),l(Oe),l(Ke),l(et),l(tt),l(re)),l(g),o(T,e),o(w,e),o(U,e),o(J,e),o(C,e),o(v,e),o(_,e),o(G,e),o(E,e),o(B,e),o(X,e),o(x,e),o(R,e),o(Y,e),o(z,e),o(W,e),o(L,e),o(Q,e),o(q,e),o(F,e),o(P,e),o(O,e),o(K,e),o(te,e),o(le,e),o(se,e),o(ne,e),o(ae,e),o(me,e)}}}const Vt='{"title":"Adding a New Metric","local":"adding-a-new-metric","sections":[{"title":"Before You Start","local":"before-you-start","sections":[{"title":"Two different types of metrics","local":"two-different-types-of-metrics","sections":[{"title":"Sample-Level Metrics","local":"sample-level-metrics","sections":[],"depth":4},{"title":"Corpus-Level Metrics","local":"corpus-level-metrics","sections":[],"depth":4}],"depth":3},{"title":"Check Existing Metrics","local":"check-existing-metrics","sections":[],"depth":3}],"depth":2},{"title":"Creating a Custom Metric","local":"creating-a-custom-metric","sections":[{"title":"Step 1: Create the Metric File","local":"step-1-create-the-metric-file","sections":[],"depth":3},{"title":"Step 2: Define the Sample-Level Metric","local":"step-2-define-the-sample-level-metric","sections":[{"title":"Single Metric Example","local":"single-metric-example","sections":[],"depth":4},{"title":"Multiple Metrics Example","local":"multiple-metrics-example","sections":[],"depth":4}],"depth":3},{"title":"Step 3: Define Aggregation Function (Optional)","local":"step-3-define-aggregation-function-optional","sections":[],"depth":3},{"title":"Step 4: Create the Metric Object","local":"step-4-create-the-metric-object","sections":[{"title":"Single Metric","local":"single-metric","sections":[],"depth":4},{"title":"Multiple Metrics","local":"multiple-metrics","sections":[],"depth":4}],"depth":3},{"title":"Step 5: Register the Metric","local":"step-5-register-the-metric","sections":[],"depth":3}],"depth":2},{"title":"Using Your Custom Metric","local":"using-your-custom-metric","sections":[{"title":"With Custom Tasks","local":"with-custom-tasks","sections":[],"depth":3}],"depth":2}],"depth":1}';function Gt(it){return Jt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class St extends jt{constructor(g){super(),Ct(this,g,Gt,kt,wt,{})}}export{St as component};
