import{s as Ia,o as Za,n as va}from"../chunks/scheduler.25b97de1.js";import{S as ka,i as xa,g as i,s as l,r as o,A as Ga,h as p,f as t,c as n,j as Ua,u as c,x as r,k as Zt,y as Ba,a,v as m,d as h,t as u,w as d,m as Wa,n as Ca}from"../chunks/index.d9030fc9.js";import{T as kt}from"../chunks/Tip.baa67368.js";import{C as y}from"../chunks/CodeBlock.e6cd0d95.js";import{H as b,E as _a}from"../chunks/EditOnGithub.91d95064.js";function Xa($){let f,M='Take a look at the <a href="/docs/transformers/pr_31198/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> documentation for a complete list of supported tasks and available parameters.';return{c(){f=i("p"),f.innerHTML=M},l(w){f=p(w,"P",{"data-svelte-h":!0}),r(f)!=="svelte-1kh6zz0"&&(f.innerHTML=M)},m(w,T){a(w,f,T)},p:va,d(w){w&&t(f)}}}function Ha($){let f;return{c(){f=Wa(`Creating an inference engine is a complex topic which deserves it's own
page.`)},l(M){f=Ca(M,`Creating an inference engine is a complex topic which deserves it's own
page.`)},m(M,w){a(M,f,w)},d(M){M&&t(f)}}}function Ra($){let f,M='To run the example above you need to have <a href="https://pypi.org/project/pytesseract/" rel="nofollow"><code>pytesseract</code></a> installed in addition to 🤗 Transformers:',w,T,j;return T=new y({props:{code:"c3VkbyUyMGFwdCUyMGluc3RhbGwlMjAteSUyMHRlc3NlcmFjdC1vY3IlMEFwaXAlMjBpbnN0YWxsJTIwcHl0ZXNzZXJhY3Q=",highlighted:`sudo apt install -y tesseract-ocr
pip install pytesseract`,wrap:!1}}),{c(){f=i("p"),f.innerHTML=M,w=l(),o(T.$$.fragment)},l(g){f=p(g,"P",{"data-svelte-h":!0}),r(f)!=="svelte-z3k1tk"&&(f.innerHTML=M),w=n(g),c(T.$$.fragment,g)},m(g,J){a(g,f,J),a(g,w,J),m(T,g,J),j=!0},p:va,i(g){j||(h(T.$$.fragment,g),j=!0)},o(g){u(T.$$.fragment,g),j=!1},d(g){g&&(t(f),t(w)),d(T,g)}}}function Ya($){let f,M,w,T,j,g,J,xt='The <a href="/docs/transformers/pr_31198/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> makes it simple to use any model from the <a href="https://huggingface.co/models" rel="nofollow">Hub</a> for inference on any language, computer vision, speech, and multimodal tasks. Even if you don’t have experience with a specific modality or aren’t familiar with the underlying code behind the models, you can still use them for inference with the <a href="/docs/transformers/pr_31198/en/main_classes/pipelines#transformers.pipeline">pipeline()</a>! This tutorial will teach you to:',Oe,k,Gt='<li>Use a <a href="/docs/transformers/pr_31198/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> for inference.</li> <li>Use a specific tokenizer or model.</li> <li>Use a <a href="/docs/transformers/pr_31198/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> for audio, vision, and multimodal tasks.</li>',es,U,ss,x,ts,G,Bt=`While each task has an associated <a href="/docs/transformers/pr_31198/en/main_classes/pipelines#transformers.pipeline">pipeline()</a>, it is simpler to use the general <a href="/docs/transformers/pr_31198/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> abstraction which contains
all the task-specific pipelines. The <a href="/docs/transformers/pr_31198/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> automatically loads a default model and a preprocessing class capable
of inference for your task. Let’s take the example of using the <a href="/docs/transformers/pr_31198/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> for automatic speech recognition (ASR), or
speech-to-text.`,as,B,Wt='<li>Start by creating a <a href="/docs/transformers/pr_31198/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> and specify the inference task:</li>',ls,W,ns,v,Ct='<li>Pass your input to the <a href="/docs/transformers/pr_31198/en/main_classes/pipelines#transformers.pipeline">pipeline()</a>. In the case of speech recognition, this is an audio input file:</li>',is,C,ps,_,_t=`Not the result you had in mind? Check out some of the <a href="https://huggingface.co/models?pipeline_tag=automatic-speech-recognition&amp;sort=trending" rel="nofollow">most downloaded automatic speech recognition models</a>
on the Hub to see if you can get a better transcription.`,rs,X,Xt=`Let’s try the <a href="https://huggingface.co/openai/whisper-large" rel="nofollow">Whisper large-v2</a> model from OpenAI. Whisper was released
2 years later than Wav2Vec2, and was trained on close to 10x more data. As such, it beats Wav2Vec2 on most downstream
benchmarks. It also has the added benefit of predicting punctuation and casing, neither of which are possible with<br/>
Wav2Vec2.`,os,H,Ht="Let’s give it a try here to see how it performs:",cs,R,ms,Y,Rt=`Now this result looks more accurate! For a deep-dive comparison on Wav2Vec2 vs Whisper, refer to the <a href="https://huggingface.co/learn/audio-course/chapter5/asr_models" rel="nofollow">Audio Transformers Course</a>.
We really encourage you to check out the Hub for models in different languages, models specialized in your field, and more.
You can check out and compare model results directly from your browser on the Hub to see if it fits or
handles corner cases better than other ones.
And if you don’t find a model for your use case, you can always start <a href="training">training</a> your own!`,hs,N,Yt="If you have several inputs, you can pass your input as a list:",us,q,ds,V,Nt=`Pipelines are great for experimentation as switching from one model to another is trivial; however, there are some ways to optimize them for larger workloads than experimentation. See the following guides that dive into iterating over whole datasets or using pipelines in a webserver:
of the docs:`,fs,z,qt='<li><a href="#using-pipelines-on-a-dataset">Using pipelines on a dataset</a></li> <li><a href="./pipeline_webserver">Using pipelines for a webserver</a></li>',ys,L,gs,S,Vt=`<a href="/docs/transformers/pr_31198/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> supports many parameters; some are task specific, and some are general to all pipelines.
In general, you can specify parameters anywhere you want:`,ws,F,Ms,Q,zt="Let’s check out 3 important ones:",Ts,E,bs,P,Lt=`If you use <code>device=n</code>, the pipeline automatically puts the model on the specified device.
This will work regardless of whether you are using PyTorch or Tensorflow.`,js,A,Js,D,St="If the model is too large for a single GPU and you are using PyTorch, you can set <code>torch_dtype=&#39;float16&#39;</code> to enable FP16 precision inference. Usually this would not cause significant performance drops but make sure you evaluate it on your models!",$s,K,Ft=`Alternatively, you can set <code>device_map=&quot;auto&quot;</code> to automatically
determine how to load and store the model weights. Using the <code>device_map</code> argument requires the 🤗 <a href="https://huggingface.co/docs/accelerate" rel="nofollow">Accelerate</a>
package:`,Us,O,vs,ee,Qt="The following code automatically loads and stores model weights across devices:",Is,se,Zs,te,Et="Note that if  <code>device_map=&quot;auto&quot;</code> is passed, there is no need to add the argument <code>device=device</code> when instantiating your <code>pipeline</code> as you may encounter some unexpected behavior!",ks,ae,xs,le,Pt='By default, pipelines will not batch inference for reasons explained in detail <a href="https://huggingface.co/docs/transformers/main_classes/pipelines#pipeline-batching" rel="nofollow">here</a>. The reason is that batching is not necessarily faster, and can actually be quite slower in some cases.',Gs,ne,At="But if it works in your use case, you can use:",Bs,ie,Ws,pe,Dt=`This runs the pipeline on the 4 provided audio files, but it will pass them in batches of 2
to the model (which is on a GPU, where batching is more likely to help) without requiring any further code from you.
The output should always match what you would have received without batching. It is only meant as a way to help you get more speed out of a pipeline.`,Cs,re,Kt='Pipelines can also alleviate some of the complexities of batching because, for some pipelines, a single item (like a long audio file) needs to be chunked into multiple parts to be processed by a model. The pipeline performs this <a href="./main_classes/pipelines#pipeline-chunk-batching"><em>chunk batching</em></a> for you.',_s,oe,Xs,ce,Ot=`All tasks provide task specific parameters which allow for additional flexibility and options to help you get your job done.
For instance, the <a href="/docs/transformers/pr_31198/en/main_classes/pipelines#transformers.AutomaticSpeechRecognitionPipeline.__call__">transformers.AutomaticSpeechRecognitionPipeline.<strong>call</strong>()</a> method has a <code>return_timestamps</code> parameter which sounds promising for subtitling videos:`,Hs,me,Rs,he,ea="As you can see, the model inferred the text and also outputted <strong>when</strong> the various sentences were pronounced.",Ys,ue,sa=`There are many parameters available for each task, so check out each task’s API reference to see what you can tinker with!
For instance, the <a href="/docs/transformers/pr_31198/en/main_classes/pipelines#transformers.AutomaticSpeechRecognitionPipeline">AutomaticSpeechRecognitionPipeline</a> has a <code>chunk_length_s</code> parameter which is helpful
for working on really long audio files (for example, subtitling entire movies or hour-long videos) that a model typically
cannot handle on its own:`,Ns,de,qs,fe,ta='If you can’t find a parameter that would really help you out, feel free to <a href="https://github.com/huggingface/transformers/issues/new?assignees=&amp;labels=feature&amp;template=feature-request.yml" rel="nofollow">request it</a>!',Vs,ye,zs,ge,aa="The pipeline can also run inference on a large dataset. The easiest way we recommend doing this is by using an iterator:",Ls,we,Ss,Me,la=`The iterator <code>data()</code> yields each result, and the pipeline automatically
recognizes the input is iterable and will start fetching the data while
it continues to process it on the GPU (this uses <a href="https://pytorch.org/docs/stable/data.html#torch.utils.data.DataLoader" rel="nofollow">DataLoader</a> under the hood).
This is important because you don’t have to allocate memory for the whole dataset
and you can feed the GPU as fast as possible.`,Fs,Te,na="Since batching could speed things up, it may be useful to try tuning the <code>batch_size</code> parameter here.",Qs,be,ia='The simplest way to iterate over a dataset is to just load one from 🤗 <a href="https://github.com/huggingface/datasets/" rel="nofollow">Datasets</a>:',Es,je,Ps,Je,As,I,Ds,$e,pa='<a href="./pipeline_webserver">Link</a>',Ks,Ue,Os,ve,ra='Using a <a href="/docs/transformers/pr_31198/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> for vision tasks is practically identical.',et,Ie,oa="Specify your task and pass your image to the classifier. The image can be a link, a local path or a base64-encoded image. For example, what species of cat is shown below?",st,Ze,ca='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg" alt="pipeline-cat-chonk"/>',tt,ke,at,xe,lt,Ge,ma='Using a <a href="/docs/transformers/pr_31198/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> for NLP tasks is practically identical.',nt,Be,it,We,pt,Ce,ha='The <a href="/docs/transformers/pr_31198/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> supports more than one modality. For example, a visual question answering (VQA) task combines text and image. Feel free to use any image link you like and a question you want to ask about the image. The image can be a URL or a local path to the image.',rt,_e,ua='For example, if you use this <a href="https://huggingface.co/spaces/impira/docquery/resolve/2359223c1837a7587402bda0f2643382a6eefeab/invoice.png" rel="nofollow">invoice image</a>:',ot,Xe,ct,Z,mt,He,ht,Re,da="You can easily run <code>pipeline</code> on large models using 🤗 <code>accelerate</code>! First make sure you have installed <code>accelerate</code> with <code>pip install accelerate</code>.",ut,Ye,fa="First load your model using <code>device_map=&quot;auto&quot;</code>! We will use <code>facebook/opt-1.3b</code> for our example.",dt,Ne,ft,qe,ya="You can also pass 8-bit loaded models if you install <code>bitsandbytes</code> and add the argument <code>load_in_8bit=True</code>",yt,Ve,gt,ze,ga="Note that you can replace the checkpoint with any Hugging Face model that supports large model loading, such as BLOOM.",wt,Le,Mt,Se,wa='Pipelines are automatically supported in <a href="https://github.com/gradio-app/gradio/" rel="nofollow">Gradio</a>, a library that makes creating beautiful and user-friendly machine learning apps on the web a breeze. First, make sure you have Gradio installed:',Tt,Fe,bt,Qe,Ma='Then, you can create a web demo around an image classification pipeline (or any other pipeline) in a single line of code by calling Gradio’s <a href="https://www.gradio.app/docs/interface#interface-from-pipeline" rel="nofollow"><code>Interface.from_pipeline</code></a> function to launch the pipeline. This creates an intuitive drag-and-drop interface in your browser:',jt,Ee,Jt,Pe,Ta='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/panda-classification.png"/>',$t,Ae,ba=`By default, the web demo runs on a local server. If you’d like to share it with others, you can generate a temporary public
link by setting <code>share=True</code> in <code>launch()</code>. You can also host your demo on <a href="https://huggingface.co/spaces" rel="nofollow">Hugging Face Spaces</a> for a permanent link.`,Ut,De,vt,Ke,It;return j=new b({props:{title:"Pipelines for inference",local:"pipelines-for-inference",headingTag:"h1"}}),U=new kt({props:{$$slots:{default:[Xa]},$$scope:{ctx:$}}}),x=new b({props:{title:"Pipeline usage",local:"pipeline-usage",headingTag:"h2"}}),W=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber = pipeline(task=<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>)`,wrap:!1}}),C=new y({props:{code:"dHJhbnNjcmliZXIoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGTmFyc2lsJTJGYXNyX2R1bW15JTJGcmVzb2x2ZSUyRm1haW4lMkZtbGsuZmxhYyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>)
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;I HAVE A DREAM BUT ONE DAY THIS NATION WILL RISE UP LIVE UP THE TRUE MEANING OF ITS TREES&#x27;</span>}`,wrap:!1}}),R=new y({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIpJTBBdHJhbnNjcmliZXIoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGTmFyc2lsJTJGYXNyX2R1bW15JTJGcmVzb2x2ZSUyRm1haW4lMkZtbGsuZmxhYyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>)
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27; I have a dream that one day this nation will rise up and live out the true meaning of its creed.&#x27;</span>}`,wrap:!1}}),q=new y({props:{code:"dHJhbnNjcmliZXIoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGTmFyc2lsJTJGYXNyX2R1bW15JTJGcmVzb2x2ZSUyRm1haW4lMkZtbGsuZmxhYyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRk5hcnNpbCUyRmFzcl9kdW1teSUyRnJlc29sdmUlMkZtYWluJTJGMS5mbGFjJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTBBKQ==",highlighted:`transcriber(
    [
        <span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>,
        <span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/1.flac&quot;</span>,
    ]
)`,wrap:!1}}),L=new b({props:{title:"Parameters",local:"parameters",headingTag:"h2"}}),F=new y({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIlMkMlMjBteV9wYXJhbWV0ZXIlM0QxKSUwQSUwQW91dCUyMCUzRCUyMHRyYW5zY3JpYmVyKC4uLiklMjAlMjAlMjMlMjBUaGlzJTIwd2lsbCUyMHVzZSUyMCU2MG15X3BhcmFtZXRlciUzRDElNjAuJTBBb3V0JTIwJTNEJTIwdHJhbnNjcmliZXIoLi4uJTJDJTIwbXlfcGFyYW1ldGVyJTNEMiklMjAlMjAlMjMlMjBUaGlzJTIwd2lsbCUyMG92ZXJyaWRlJTIwYW5kJTIwdXNlJTIwJTYwbXlfcGFyYW1ldGVyJTNEMiU2MC4lMEFvdXQlMjAlM0QlMjB0cmFuc2NyaWJlciguLi4pJTIwJTIwJTIzJTIwVGhpcyUyMHdpbGwlMjBnbyUyMGJhY2slMjB0byUyMHVzaW5nJTIwJTYwbXlfcGFyYW1ldGVyJTNEMSU2MC4=",highlighted:'transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>, my_parameter=<span class="hljs-number">1</span>)\n\nout = transcriber(...)  <span class="hljs-comment"># This will use `my_parameter=1`.</span>\nout = transcriber(..., my_parameter=<span class="hljs-number">2</span>)  <span class="hljs-comment"># This will override and use `my_parameter=2`.</span>\nout = transcriber(...)  <span class="hljs-comment"># This will go back to using `my_parameter=1`.</span>',wrap:!1}}),E=new b({props:{title:"Device",local:"device",headingTag:"h3"}}),A=new y({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIlMkMlMjBkZXZpY2UlM0QwKQ==",highlighted:'transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>, device=<span class="hljs-number">0</span>)',wrap:!1}}),O=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMGFjY2VsZXJhdGU=",highlighted:"pip install --upgrade accelerate",wrap:!1}}),se=new y({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMik=",highlighted:'transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)',wrap:!1}}),ae=new b({props:{title:"Batch size",local:"batch-size",headingTag:"h3"}}),ie=new y({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIlMkMlMjBkZXZpY2UlM0QwJTJDJTIwYmF0Y2hfc2l6ZSUzRDIpJTBBYXVkaW9fZmlsZW5hbWVzJTIwJTNEJTIwJTVCZiUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRk5hcnNpbCUyRmFzcl9kdW1teSUyRnJlc29sdmUlMkZtYWluJTJGJTdCaSU3RC5mbGFjJTIyJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMSUyQyUyMDUpJTVEJTBBdGV4dHMlMjAlM0QlMjB0cmFuc2NyaWJlcihhdWRpb19maWxlbmFtZXMp",highlighted:`transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>, device=<span class="hljs-number">0</span>, batch_size=<span class="hljs-number">2</span>)
audio_filenames = [<span class="hljs-string">f&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/<span class="hljs-subst">{i}</span>.flac&quot;</span> <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1</span>, <span class="hljs-number">5</span>)]
texts = transcriber(audio_filenames)`,wrap:!1}}),oe=new b({props:{title:"Task specific parameters",local:"task-specific-parameters",headingTag:"h3"}}),me=new y({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIlMkMlMjByZXR1cm5fdGltZXN0YW1wcyUzRFRydWUpJTBBdHJhbnNjcmliZXIoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGTmFyc2lsJTJGYXNyX2R1bW15JTJGcmVzb2x2ZSUyRm1haW4lMkZtbGsuZmxhYyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>, return_timestamps=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>)
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27; I have a dream that one day this nation will rise up and live out the true meaning of its creed.&#x27;</span>, <span class="hljs-string">&#x27;chunks&#x27;</span>: [{<span class="hljs-string">&#x27;timestamp&#x27;</span>: (<span class="hljs-number">0.0</span>, <span class="hljs-number">11.88</span>), <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27; I have a dream that one day this nation will rise up and live out the true meaning of its&#x27;</span>}, {<span class="hljs-string">&#x27;timestamp&#x27;</span>: (<span class="hljs-number">11.88</span>, <span class="hljs-number">12.38</span>), <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27; creed.&#x27;</span>}]}`,wrap:!1}}),de=new y({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIlMkMlMjBjaHVua19sZW5ndGhfcyUzRDMwKSUwQXRyYW5zY3JpYmVyKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRnJlYWNoLXZiJTJGcmFuZG9tLWF1ZGlvcyUyRnJlc29sdmUlMkZtYWluJTJGdGVkXzYwLndhdiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>, chunk_length_s=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber(<span class="hljs-string">&quot;https://huggingface.co/datasets/reach-vb/random-audios/resolve/main/ted_60.wav&quot;</span>)
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&quot; So in college, I was a government major, which means I had to write a lot of papers. Now, when a normal student writes a paper, they might spread the work out a little like this. So, you know. You get started maybe a little slowly, but you get enough done in the first week that with some heavier days later on, everything gets done and things stay civil. And I would want to do that like that. That would be the plan. I would have it all ready to go, but then actually the paper would come along, and then I would kind of do this. And that would happen every single paper. But then came my 90-page senior thesis, a paper you&#x27;re supposed to spend a year on. I knew for a paper like that, my normal workflow was not an option, it was way too big a project. So I planned things out and I decided I kind of had to go something like this. This is how the year would go. So I&#x27;d start off light and I&#x27;d bump it up&quot;</span>}`,wrap:!1}}),ye=new b({props:{title:"Using pipelines on a dataset",local:"using-pipelines-on-a-dataset",headingTag:"h2"}}),we=new y({props:{code:"ZGVmJTIwZGF0YSgpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMTAwMCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB5aWVsZCUyMGYlMjJNeSUyMGV4YW1wbGUlMjAlN0JpJTdEJTIyJTBBJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIlMkMlMjBkZXZpY2UlM0QwKSUwQWdlbmVyYXRlZF9jaGFyYWN0ZXJzJTIwJTNEJTIwMCUwQWZvciUyMG91dCUyMGluJTIwcGlwZShkYXRhKCkpJTNBJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVkX2NoYXJhY3RlcnMlMjAlMkIlM0QlMjBsZW4ob3V0JTVCMCU1RCU1QiUyMmdlbmVyYXRlZF90ZXh0JTIyJTVEKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">data</span>():
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>):
        <span class="hljs-keyword">yield</span> <span class="hljs-string">f&quot;My example <span class="hljs-subst">{i}</span>&quot;</span>


pipe = pipeline(model=<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>, device=<span class="hljs-number">0</span>)
generated_characters = <span class="hljs-number">0</span>
<span class="hljs-keyword">for</span> out <span class="hljs-keyword">in</span> pipe(data()):
    generated_characters += <span class="hljs-built_in">len</span>(out[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>])`,wrap:!1}}),je=new y({props:{code:"JTIzJTIwS2V5RGF0YXNldCUyMGlzJTIwYSUyMHV0aWwlMjB0aGF0JTIwd2lsbCUyMGp1c3QlMjBvdXRwdXQlMjB0aGUlMjBpdGVtJTIwd2UncmUlMjBpbnRlcmVzdGVkJTIwaW4uJTBBZnJvbSUyMHRyYW5zZm9ybWVycy5waXBlbGluZXMucHRfdXRpbHMlMjBpbXBvcnQlMjBLZXlEYXRhc2V0JTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRnRpbnktcmFuZG9tLXdhdjJ2ZWMyJTIyJTJDJTIwZGV2aWNlJTNEMCklMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiU1QiUzQTEwJTVEJTIyKSUwQSUwQWZvciUyMG91dCUyMGluJTIwcGlwZShLZXlEYXRhc2V0KGRhdGFzZXQlMkMlMjAlMjJhdWRpbyUyMikpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQob3V0KQ==",highlighted:`<span class="hljs-comment"># KeyDataset is a util that will just output the item we&#x27;re interested in.</span>
<span class="hljs-keyword">from</span> transformers.pipelines.pt_utils <span class="hljs-keyword">import</span> KeyDataset
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

pipe = pipeline(model=<span class="hljs-string">&quot;hf-internal-testing/tiny-random-wav2vec2&quot;</span>, device=<span class="hljs-number">0</span>)
dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation[:10]&quot;</span>)

<span class="hljs-keyword">for</span> out <span class="hljs-keyword">in</span> pipe(KeyDataset(dataset, <span class="hljs-string">&quot;audio&quot;</span>)):
    <span class="hljs-built_in">print</span>(out)`,wrap:!1}}),Je=new b({props:{title:"Using pipelines for a webserver",local:"using-pipelines-for-a-webserver",headingTag:"h2"}}),I=new kt({props:{$$slots:{default:[Ha]},$$scope:{ctx:$}}}),Ue=new b({props:{title:"Vision pipeline",local:"vision-pipeline",headingTag:"h2"}}),ke=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdmlzaW9uX2NsYXNzaWZpZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMmdvb2dsZSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0JTIyKSUwQXByZWRzJTIwJTNEJTIwdmlzaW9uX2NsYXNzaWZpZXIoJTBBJTIwJTIwJTIwJTIwaW1hZ2VzJTNEJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGcGlwZWxpbmUtY2F0LWNob25rLmpwZWclMjIlMEEpJTBBcHJlZHMlMjAlM0QlMjAlNUIlN0IlMjJzY29yZSUyMiUzQSUyMHJvdW5kKHByZWQlNUIlMjJzY29yZSUyMiU1RCUyQyUyMDQpJTJDJTIwJTIybGFiZWwlMjIlM0ElMjBwcmVkJTVCJTIybGFiZWwlMjIlNUQlN0QlMjBmb3IlMjBwcmVkJTIwaW4lMjBwcmVkcyU1RCUwQXByZWRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>vision_classifier = pipeline(model=<span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = vision_classifier(
<span class="hljs-meta">... </span>    images=<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.4335</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;lynx, catamount&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0348</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cougar, puma, catamount, mountain lion, painter, panther, Felis concolor&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0324</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;snow leopard, ounce, Panthera uncia&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0239</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;Egyptian cat&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0229</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;tiger cat&#x27;</span>}]`,wrap:!1}}),xe=new b({props:{title:"Text pipeline",local:"text-pipeline",headingTag:"h2"}}),Be=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBJTIzJTIwVGhpcyUyMG1vZGVsJTIwaXMlMjBhJTIwJTYwemVyby1zaG90LWNsYXNzaWZpY2F0aW9uJTYwJTIwbW9kZWwuJTBBJTIzJTIwSXQlMjB3aWxsJTIwY2xhc3NpZnklMjB0ZXh0JTJDJTIwZXhjZXB0JTIweW91JTIwYXJlJTIwZnJlZSUyMHRvJTIwY2hvb3NlJTIwYW55JTIwbGFiZWwlMjB5b3UlMjBtaWdodCUyMGltYWdpbmUlMEFjbGFzc2lmaWVyJTIwJTNEJTIwcGlwZWxpbmUobW9kZWwlM0QlMjJmYWNlYm9vayUyRmJhcnQtbGFyZ2UtbW5saSUyMiklMEFjbGFzc2lmaWVyKCUwQSUyMCUyMCUyMCUyMCUyMkklMjBoYXZlJTIwYSUyMHByb2JsZW0lMjB3aXRoJTIwbXklMjBpcGhvbmUlMjB0aGF0JTIwbmVlZHMlMjB0byUyMGJlJTIwcmVzb2x2ZWQlMjBhc2FwISElMjIlMkMlMEElMjAlMjAlMjAlMjBjYW5kaWRhdGVfbGFiZWxzJTNEJTVCJTIydXJnZW50JTIyJTJDJTIwJTIybm90JTIwdXJnZW50JTIyJTJDJTIwJTIycGhvbmUlMjIlMkMlMjAlMjJ0YWJsZXQlMjIlMkMlMjAlMjJjb21wdXRlciUyMiU1RCUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This model is a \`zero-shot-classification\` model.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># It will classify text, except you are free to choose any label you might imagine</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(model=<span class="hljs-string">&quot;facebook/bart-large-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>classifier(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;I have a problem with my iphone that needs to be resolved asap!!&quot;</span>,
<span class="hljs-meta">... </span>    candidate_labels=[<span class="hljs-string">&quot;urgent&quot;</span>, <span class="hljs-string">&quot;not urgent&quot;</span>, <span class="hljs-string">&quot;phone&quot;</span>, <span class="hljs-string">&quot;tablet&quot;</span>, <span class="hljs-string">&quot;computer&quot;</span>],
<span class="hljs-meta">... </span>)
{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;I have a problem with my iphone that needs to be resolved asap!!&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>: [<span class="hljs-string">&#x27;urgent&#x27;</span>, <span class="hljs-string">&#x27;phone&#x27;</span>, <span class="hljs-string">&#x27;computer&#x27;</span>, <span class="hljs-string">&#x27;not urgent&#x27;</span>, <span class="hljs-string">&#x27;tablet&#x27;</span>], <span class="hljs-string">&#x27;scores&#x27;</span>: [<span class="hljs-number">0.504</span>, <span class="hljs-number">0.479</span>, <span class="hljs-number">0.013</span>, <span class="hljs-number">0.003</span>, <span class="hljs-number">0.002</span>]}`,wrap:!1}}),We=new b({props:{title:"Multimodal pipeline",local:"multimodal-pipeline",headingTag:"h2"}}),Xe=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdnFhJTIwJTNEJTIwcGlwZWxpbmUobW9kZWwlM0QlMjJpbXBpcmElMkZsYXlvdXRsbS1kb2N1bWVudC1xYSUyMiklMEFvdXRwdXQlMjAlM0QlMjB2cWEoJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0QlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc3BhY2VzJTJGaW1waXJhJTJGZG9jcXVlcnklMkZyZXNvbHZlJTJGMjM1OTIyM2MxODM3YTc1ODc0MDJiZGEwZjI2NDMzODJhNmVlZmVhYiUyRmludm9pY2UucG5nJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVlc3Rpb24lM0QlMjJXaGF0JTIwaXMlMjB0aGUlMjBpbnZvaWNlJTIwbnVtYmVyJTNGJTIyJTJDJTBBKSUwQW91dHB1dCU1QjAlNUQlNUIlMjJzY29yZSUyMiU1RCUyMCUzRCUyMHJvdW5kKG91dHB1dCU1QjAlNUQlNUIlMjJzY29yZSUyMiU1RCUyQyUyMDMpJTBBb3V0cHV0",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>vqa = pipeline(model=<span class="hljs-string">&quot;impira/layoutlm-document-qa&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output = vqa(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;https://huggingface.co/spaces/impira/docquery/resolve/2359223c1837a7587402bda0f2643382a6eefeab/invoice.png&quot;</span>,
<span class="hljs-meta">... </span>    question=<span class="hljs-string">&quot;What is the invoice number?&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;score&quot;</span>] = <span class="hljs-built_in">round</span>(output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">3</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.425</span>, <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;us-001&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">16</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">16</span>}]`,wrap:!1}}),Z=new kt({props:{$$slots:{default:[Ra]},$$scope:{ctx:$}}}),He=new b({props:{title:"Using pipeline on large models with 🤗 accelerate :",local:"using-pipeline-on-large-models-with--accelerate-",headingTag:"h2"}}),Ne=new y({props:{code:"JTIzJTIwcGlwJTIwaW5zdGFsbCUyMGFjY2VsZXJhdGUlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBwaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMmZhY2Vib29rJTJGb3B0LTEuM2IlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIpJTBBb3V0cHV0JTIwJTNEJTIwcGlwZSglMjJUaGlzJTIwaXMlMjBhJTIwY29vbCUyMGV4YW1wbGUhJTIyJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMHRvcF9wJTNEMC45NSk=",highlighted:`<span class="hljs-comment"># pip install accelerate</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(model=<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
output = pipe(<span class="hljs-string">&quot;This is a cool example!&quot;</span>, do_sample=<span class="hljs-literal">True</span>, top_p=<span class="hljs-number">0.95</span>)`,wrap:!1}}),Ve=new y({props:{code:"JTIzJTIwcGlwJTIwaW5zdGFsbCUyMGFjY2VsZXJhdGUlMjBiaXRzYW5kYnl0ZXMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBwaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMmZhY2Vib29rJTJGb3B0LTEuM2IlMjIlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUyMG1vZGVsX2t3YXJncyUzRCU3QiUyMmxvYWRfaW5fOGJpdCUyMiUzQSUyMFRydWUlN0QpJTBBb3V0cHV0JTIwJTNEJTIwcGlwZSglMjJUaGlzJTIwaXMlMjBhJTIwY29vbCUyMGV4YW1wbGUhJTIyJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMHRvcF9wJTNEMC45NSk=",highlighted:`<span class="hljs-comment"># pip install accelerate bitsandbytes</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(model=<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, model_kwargs={<span class="hljs-string">&quot;load_in_8bit&quot;</span>: <span class="hljs-literal">True</span>})
output = pipe(<span class="hljs-string">&quot;This is a cool example!&quot;</span>, do_sample=<span class="hljs-literal">True</span>, top_p=<span class="hljs-number">0.95</span>)`,wrap:!1}}),Le=new b({props:{title:"Creating web demos from pipelines with gradio",local:"creating-web-demos-from-pipelines-with-gradio",headingTag:"h2"}}),Fe=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMGdyYWRpbw==",highlighted:'pip <span class="hljs-keyword">install</span> gradio',wrap:!1}}),Ee=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZSglMjJpbWFnZS1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyZ29vZ2xlJTJGdml0LWJhc2UtcGF0Y2gxNi0yMjQlMjIpJTBBJTBBZ3IuSW50ZXJmYWNlLmZyb21fcGlwZWxpbmUocGlwZSkubGF1bmNoKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

pipe = pipeline(<span class="hljs-string">&quot;image-classification&quot;</span>, model=<span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>)

gr.Interface.from_pipeline(pipe).launch()`,wrap:!1}}),De=new _a({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/pipeline_tutorial.md"}}),{c(){f=i("meta"),M=l(),w=i("p"),T=l(),o(j.$$.fragment),g=l(),J=i("p"),J.innerHTML=xt,Oe=l(),k=i("ul"),k.innerHTML=Gt,es=l(),o(U.$$.fragment),ss=l(),o(x.$$.fragment),ts=l(),G=i("p"),G.innerHTML=Bt,as=l(),B=i("ol"),B.innerHTML=Wt,ls=l(),o(W.$$.fragment),ns=l(),v=i("ol"),v.innerHTML=Ct,is=l(),o(C.$$.fragment),ps=l(),_=i("p"),_.innerHTML=_t,rs=l(),X=i("p"),X.innerHTML=Xt,os=l(),H=i("p"),H.textContent=Ht,cs=l(),o(R.$$.fragment),ms=l(),Y=i("p"),Y.innerHTML=Rt,hs=l(),N=i("p"),N.textContent=Yt,us=l(),o(q.$$.fragment),ds=l(),V=i("p"),V.textContent=Nt,fs=l(),z=i("ul"),z.innerHTML=qt,ys=l(),o(L.$$.fragment),gs=l(),S=i("p"),S.innerHTML=Vt,ws=l(),o(F.$$.fragment),Ms=l(),Q=i("p"),Q.textContent=zt,Ts=l(),o(E.$$.fragment),bs=l(),P=i("p"),P.innerHTML=Lt,js=l(),o(A.$$.fragment),Js=l(),D=i("p"),D.innerHTML=St,$s=l(),K=i("p"),K.innerHTML=Ft,Us=l(),o(O.$$.fragment),vs=l(),ee=i("p"),ee.textContent=Qt,Is=l(),o(se.$$.fragment),Zs=l(),te=i("p"),te.innerHTML=Et,ks=l(),o(ae.$$.fragment),xs=l(),le=i("p"),le.innerHTML=Pt,Gs=l(),ne=i("p"),ne.textContent=At,Bs=l(),o(ie.$$.fragment),Ws=l(),pe=i("p"),pe.textContent=Dt,Cs=l(),re=i("p"),re.innerHTML=Kt,_s=l(),o(oe.$$.fragment),Xs=l(),ce=i("p"),ce.innerHTML=Ot,Hs=l(),o(me.$$.fragment),Rs=l(),he=i("p"),he.innerHTML=ea,Ys=l(),ue=i("p"),ue.innerHTML=sa,Ns=l(),o(de.$$.fragment),qs=l(),fe=i("p"),fe.innerHTML=ta,Vs=l(),o(ye.$$.fragment),zs=l(),ge=i("p"),ge.textContent=aa,Ls=l(),o(we.$$.fragment),Ss=l(),Me=i("p"),Me.innerHTML=la,Fs=l(),Te=i("p"),Te.innerHTML=na,Qs=l(),be=i("p"),be.innerHTML=ia,Es=l(),o(je.$$.fragment),Ps=l(),o(Je.$$.fragment),As=l(),o(I.$$.fragment),Ds=l(),$e=i("p"),$e.innerHTML=pa,Ks=l(),o(Ue.$$.fragment),Os=l(),ve=i("p"),ve.innerHTML=ra,et=l(),Ie=i("p"),Ie.textContent=oa,st=l(),Ze=i("p"),Ze.innerHTML=ca,tt=l(),o(ke.$$.fragment),at=l(),o(xe.$$.fragment),lt=l(),Ge=i("p"),Ge.innerHTML=ma,nt=l(),o(Be.$$.fragment),it=l(),o(We.$$.fragment),pt=l(),Ce=i("p"),Ce.innerHTML=ha,rt=l(),_e=i("p"),_e.innerHTML=ua,ot=l(),o(Xe.$$.fragment),ct=l(),o(Z.$$.fragment),mt=l(),o(He.$$.fragment),ht=l(),Re=i("p"),Re.innerHTML=da,ut=l(),Ye=i("p"),Ye.innerHTML=fa,dt=l(),o(Ne.$$.fragment),ft=l(),qe=i("p"),qe.innerHTML=ya,yt=l(),o(Ve.$$.fragment),gt=l(),ze=i("p"),ze.textContent=ga,wt=l(),o(Le.$$.fragment),Mt=l(),Se=i("p"),Se.innerHTML=wa,Tt=l(),o(Fe.$$.fragment),bt=l(),Qe=i("p"),Qe.innerHTML=Ma,jt=l(),o(Ee.$$.fragment),Jt=l(),Pe=i("p"),Pe.innerHTML=Ta,$t=l(),Ae=i("p"),Ae.innerHTML=ba,Ut=l(),o(De.$$.fragment),vt=l(),Ke=i("p"),this.h()},l(e){const s=Ga("svelte-u9bgzb",document.head);f=p(s,"META",{name:!0,content:!0}),s.forEach(t),M=n(e),w=p(e,"P",{}),Ua(w).forEach(t),T=n(e),c(j.$$.fragment,e),g=n(e),J=p(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-j90dys"&&(J.innerHTML=xt),Oe=n(e),k=p(e,"UL",{"data-svelte-h":!0}),r(k)!=="svelte-ra7nro"&&(k.innerHTML=Gt),es=n(e),c(U.$$.fragment,e),ss=n(e),c(x.$$.fragment,e),ts=n(e),G=p(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-11qut9m"&&(G.innerHTML=Bt),as=n(e),B=p(e,"OL",{"data-svelte-h":!0}),r(B)!=="svelte-12kzjxy"&&(B.innerHTML=Wt),ls=n(e),c(W.$$.fragment,e),ns=n(e),v=p(e,"OL",{start:!0,"data-svelte-h":!0}),r(v)!=="svelte-1byuvai"&&(v.innerHTML=Ct),is=n(e),c(C.$$.fragment,e),ps=n(e),_=p(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-jt3v05"&&(_.innerHTML=_t),rs=n(e),X=p(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1sbs9t3"&&(X.innerHTML=Xt),os=n(e),H=p(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-5gg07s"&&(H.textContent=Ht),cs=n(e),c(R.$$.fragment,e),ms=n(e),Y=p(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1yjypga"&&(Y.innerHTML=Rt),hs=n(e),N=p(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1udq0dv"&&(N.textContent=Yt),us=n(e),c(q.$$.fragment,e),ds=n(e),V=p(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1y2bxsh"&&(V.textContent=Nt),fs=n(e),z=p(e,"UL",{"data-svelte-h":!0}),r(z)!=="svelte-boqb6q"&&(z.innerHTML=qt),ys=n(e),c(L.$$.fragment,e),gs=n(e),S=p(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-c43ecj"&&(S.innerHTML=Vt),ws=n(e),c(F.$$.fragment,e),Ms=n(e),Q=p(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-e9485z"&&(Q.textContent=zt),Ts=n(e),c(E.$$.fragment,e),bs=n(e),P=p(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-sob7ne"&&(P.innerHTML=Lt),js=n(e),c(A.$$.fragment,e),Js=n(e),D=p(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1lln0af"&&(D.innerHTML=St),$s=n(e),K=p(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-197qrar"&&(K.innerHTML=Ft),Us=n(e),c(O.$$.fragment,e),vs=n(e),ee=p(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-6riuku"&&(ee.textContent=Qt),Is=n(e),c(se.$$.fragment,e),Zs=n(e),te=p(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1otna9r"&&(te.innerHTML=Et),ks=n(e),c(ae.$$.fragment,e),xs=n(e),le=p(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-v1mumi"&&(le.innerHTML=Pt),Gs=n(e),ne=p(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1jutax8"&&(ne.textContent=At),Bs=n(e),c(ie.$$.fragment,e),Ws=n(e),pe=p(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-n3ouik"&&(pe.textContent=Dt),Cs=n(e),re=p(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-sq1wry"&&(re.innerHTML=Kt),_s=n(e),c(oe.$$.fragment,e),Xs=n(e),ce=p(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1vncweu"&&(ce.innerHTML=Ot),Hs=n(e),c(me.$$.fragment,e),Rs=n(e),he=p(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1ad1wem"&&(he.innerHTML=ea),Ys=n(e),ue=p(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1m2b7ii"&&(ue.innerHTML=sa),Ns=n(e),c(de.$$.fragment,e),qs=n(e),fe=p(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1nowgzq"&&(fe.innerHTML=ta),Vs=n(e),c(ye.$$.fragment,e),zs=n(e),ge=p(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1sh6mg6"&&(ge.textContent=aa),Ls=n(e),c(we.$$.fragment,e),Ss=n(e),Me=p(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1rrzg9"&&(Me.innerHTML=la),Fs=n(e),Te=p(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1litpj1"&&(Te.innerHTML=na),Qs=n(e),be=p(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-1pgxdbs"&&(be.innerHTML=ia),Es=n(e),c(je.$$.fragment,e),Ps=n(e),c(Je.$$.fragment,e),As=n(e),c(I.$$.fragment,e),Ds=n(e),$e=p(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-52dmam"&&($e.innerHTML=pa),Ks=n(e),c(Ue.$$.fragment,e),Os=n(e),ve=p(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-x9wspo"&&(ve.innerHTML=ra),et=n(e),Ie=p(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-ip2z2f"&&(Ie.textContent=oa),st=n(e),Ze=p(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1bks2jw"&&(Ze.innerHTML=ca),tt=n(e),c(ke.$$.fragment,e),at=n(e),c(xe.$$.fragment,e),lt=n(e),Ge=p(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-1504i7o"&&(Ge.innerHTML=ma),nt=n(e),c(Be.$$.fragment,e),it=n(e),c(We.$$.fragment,e),pt=n(e),Ce=p(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-1kb0207"&&(Ce.innerHTML=ha),rt=n(e),_e=p(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-4s0csr"&&(_e.innerHTML=ua),ot=n(e),c(Xe.$$.fragment,e),ct=n(e),c(Z.$$.fragment,e),mt=n(e),c(He.$$.fragment,e),ht=n(e),Re=p(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-32c7q2"&&(Re.innerHTML=da),ut=n(e),Ye=p(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-1yg483v"&&(Ye.innerHTML=fa),dt=n(e),c(Ne.$$.fragment,e),ft=n(e),qe=p(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-1c9ycn6"&&(qe.innerHTML=ya),yt=n(e),c(Ve.$$.fragment,e),gt=n(e),ze=p(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-frv3wv"&&(ze.textContent=ga),wt=n(e),c(Le.$$.fragment,e),Mt=n(e),Se=p(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-hf8ov5"&&(Se.innerHTML=wa),Tt=n(e),c(Fe.$$.fragment,e),bt=n(e),Qe=p(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-191d3mo"&&(Qe.innerHTML=Ma),jt=n(e),c(Ee.$$.fragment,e),Jt=n(e),Pe=p(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-rjj5jb"&&(Pe.innerHTML=Ta),$t=n(e),Ae=p(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-efanlv"&&(Ae.innerHTML=ba),Ut=n(e),c(De.$$.fragment,e),vt=n(e),Ke=p(e,"P",{}),Ua(Ke).forEach(t),this.h()},h(){Zt(f,"name","hf:doc:metadata"),Zt(f,"content",Na),Zt(v,"start","2")},m(e,s){Ba(document.head,f),a(e,M,s),a(e,w,s),a(e,T,s),m(j,e,s),a(e,g,s),a(e,J,s),a(e,Oe,s),a(e,k,s),a(e,es,s),m(U,e,s),a(e,ss,s),m(x,e,s),a(e,ts,s),a(e,G,s),a(e,as,s),a(e,B,s),a(e,ls,s),m(W,e,s),a(e,ns,s),a(e,v,s),a(e,is,s),m(C,e,s),a(e,ps,s),a(e,_,s),a(e,rs,s),a(e,X,s),a(e,os,s),a(e,H,s),a(e,cs,s),m(R,e,s),a(e,ms,s),a(e,Y,s),a(e,hs,s),a(e,N,s),a(e,us,s),m(q,e,s),a(e,ds,s),a(e,V,s),a(e,fs,s),a(e,z,s),a(e,ys,s),m(L,e,s),a(e,gs,s),a(e,S,s),a(e,ws,s),m(F,e,s),a(e,Ms,s),a(e,Q,s),a(e,Ts,s),m(E,e,s),a(e,bs,s),a(e,P,s),a(e,js,s),m(A,e,s),a(e,Js,s),a(e,D,s),a(e,$s,s),a(e,K,s),a(e,Us,s),m(O,e,s),a(e,vs,s),a(e,ee,s),a(e,Is,s),m(se,e,s),a(e,Zs,s),a(e,te,s),a(e,ks,s),m(ae,e,s),a(e,xs,s),a(e,le,s),a(e,Gs,s),a(e,ne,s),a(e,Bs,s),m(ie,e,s),a(e,Ws,s),a(e,pe,s),a(e,Cs,s),a(e,re,s),a(e,_s,s),m(oe,e,s),a(e,Xs,s),a(e,ce,s),a(e,Hs,s),m(me,e,s),a(e,Rs,s),a(e,he,s),a(e,Ys,s),a(e,ue,s),a(e,Ns,s),m(de,e,s),a(e,qs,s),a(e,fe,s),a(e,Vs,s),m(ye,e,s),a(e,zs,s),a(e,ge,s),a(e,Ls,s),m(we,e,s),a(e,Ss,s),a(e,Me,s),a(e,Fs,s),a(e,Te,s),a(e,Qs,s),a(e,be,s),a(e,Es,s),m(je,e,s),a(e,Ps,s),m(Je,e,s),a(e,As,s),m(I,e,s),a(e,Ds,s),a(e,$e,s),a(e,Ks,s),m(Ue,e,s),a(e,Os,s),a(e,ve,s),a(e,et,s),a(e,Ie,s),a(e,st,s),a(e,Ze,s),a(e,tt,s),m(ke,e,s),a(e,at,s),m(xe,e,s),a(e,lt,s),a(e,Ge,s),a(e,nt,s),m(Be,e,s),a(e,it,s),m(We,e,s),a(e,pt,s),a(e,Ce,s),a(e,rt,s),a(e,_e,s),a(e,ot,s),m(Xe,e,s),a(e,ct,s),m(Z,e,s),a(e,mt,s),m(He,e,s),a(e,ht,s),a(e,Re,s),a(e,ut,s),a(e,Ye,s),a(e,dt,s),m(Ne,e,s),a(e,ft,s),a(e,qe,s),a(e,yt,s),m(Ve,e,s),a(e,gt,s),a(e,ze,s),a(e,wt,s),m(Le,e,s),a(e,Mt,s),a(e,Se,s),a(e,Tt,s),m(Fe,e,s),a(e,bt,s),a(e,Qe,s),a(e,jt,s),m(Ee,e,s),a(e,Jt,s),a(e,Pe,s),a(e,$t,s),a(e,Ae,s),a(e,Ut,s),m(De,e,s),a(e,vt,s),a(e,Ke,s),It=!0},p(e,[s]){const ja={};s&2&&(ja.$$scope={dirty:s,ctx:e}),U.$set(ja);const Ja={};s&2&&(Ja.$$scope={dirty:s,ctx:e}),I.$set(Ja);const $a={};s&2&&($a.$$scope={dirty:s,ctx:e}),Z.$set($a)},i(e){It||(h(j.$$.fragment,e),h(U.$$.fragment,e),h(x.$$.fragment,e),h(W.$$.fragment,e),h(C.$$.fragment,e),h(R.$$.fragment,e),h(q.$$.fragment,e),h(L.$$.fragment,e),h(F.$$.fragment,e),h(E.$$.fragment,e),h(A.$$.fragment,e),h(O.$$.fragment,e),h(se.$$.fragment,e),h(ae.$$.fragment,e),h(ie.$$.fragment,e),h(oe.$$.fragment,e),h(me.$$.fragment,e),h(de.$$.fragment,e),h(ye.$$.fragment,e),h(we.$$.fragment,e),h(je.$$.fragment,e),h(Je.$$.fragment,e),h(I.$$.fragment,e),h(Ue.$$.fragment,e),h(ke.$$.fragment,e),h(xe.$$.fragment,e),h(Be.$$.fragment,e),h(We.$$.fragment,e),h(Xe.$$.fragment,e),h(Z.$$.fragment,e),h(He.$$.fragment,e),h(Ne.$$.fragment,e),h(Ve.$$.fragment,e),h(Le.$$.fragment,e),h(Fe.$$.fragment,e),h(Ee.$$.fragment,e),h(De.$$.fragment,e),It=!0)},o(e){u(j.$$.fragment,e),u(U.$$.fragment,e),u(x.$$.fragment,e),u(W.$$.fragment,e),u(C.$$.fragment,e),u(R.$$.fragment,e),u(q.$$.fragment,e),u(L.$$.fragment,e),u(F.$$.fragment,e),u(E.$$.fragment,e),u(A.$$.fragment,e),u(O.$$.fragment,e),u(se.$$.fragment,e),u(ae.$$.fragment,e),u(ie.$$.fragment,e),u(oe.$$.fragment,e),u(me.$$.fragment,e),u(de.$$.fragment,e),u(ye.$$.fragment,e),u(we.$$.fragment,e),u(je.$$.fragment,e),u(Je.$$.fragment,e),u(I.$$.fragment,e),u(Ue.$$.fragment,e),u(ke.$$.fragment,e),u(xe.$$.fragment,e),u(Be.$$.fragment,e),u(We.$$.fragment,e),u(Xe.$$.fragment,e),u(Z.$$.fragment,e),u(He.$$.fragment,e),u(Ne.$$.fragment,e),u(Ve.$$.fragment,e),u(Le.$$.fragment,e),u(Fe.$$.fragment,e),u(Ee.$$.fragment,e),u(De.$$.fragment,e),It=!1},d(e){e&&(t(M),t(w),t(T),t(g),t(J),t(Oe),t(k),t(es),t(ss),t(ts),t(G),t(as),t(B),t(ls),t(ns),t(v),t(is),t(ps),t(_),t(rs),t(X),t(os),t(H),t(cs),t(ms),t(Y),t(hs),t(N),t(us),t(ds),t(V),t(fs),t(z),t(ys),t(gs),t(S),t(ws),t(Ms),t(Q),t(Ts),t(bs),t(P),t(js),t(Js),t(D),t($s),t(K),t(Us),t(vs),t(ee),t(Is),t(Zs),t(te),t(ks),t(xs),t(le),t(Gs),t(ne),t(Bs),t(Ws),t(pe),t(Cs),t(re),t(_s),t(Xs),t(ce),t(Hs),t(Rs),t(he),t(Ys),t(ue),t(Ns),t(qs),t(fe),t(Vs),t(zs),t(ge),t(Ls),t(Ss),t(Me),t(Fs),t(Te),t(Qs),t(be),t(Es),t(Ps),t(As),t(Ds),t($e),t(Ks),t(Os),t(ve),t(et),t(Ie),t(st),t(Ze),t(tt),t(at),t(lt),t(Ge),t(nt),t(it),t(pt),t(Ce),t(rt),t(_e),t(ot),t(ct),t(mt),t(ht),t(Re),t(ut),t(Ye),t(dt),t(ft),t(qe),t(yt),t(gt),t(ze),t(wt),t(Mt),t(Se),t(Tt),t(bt),t(Qe),t(jt),t(Jt),t(Pe),t($t),t(Ae),t(Ut),t(vt),t(Ke)),t(f),d(j,e),d(U,e),d(x,e),d(W,e),d(C,e),d(R,e),d(q,e),d(L,e),d(F,e),d(E,e),d(A,e),d(O,e),d(se,e),d(ae,e),d(ie,e),d(oe,e),d(me,e),d(de,e),d(ye,e),d(we,e),d(je,e),d(Je,e),d(I,e),d(Ue,e),d(ke,e),d(xe,e),d(Be,e),d(We,e),d(Xe,e),d(Z,e),d(He,e),d(Ne,e),d(Ve,e),d(Le,e),d(Fe,e),d(Ee,e),d(De,e)}}}const Na='{"title":"Pipelines for inference","local":"pipelines-for-inference","sections":[{"title":"Pipeline usage","local":"pipeline-usage","sections":[],"depth":2},{"title":"Parameters","local":"parameters","sections":[{"title":"Device","local":"device","sections":[],"depth":3},{"title":"Batch size","local":"batch-size","sections":[],"depth":3},{"title":"Task specific parameters","local":"task-specific-parameters","sections":[],"depth":3}],"depth":2},{"title":"Using pipelines on a dataset","local":"using-pipelines-on-a-dataset","sections":[],"depth":2},{"title":"Using pipelines for a webserver","local":"using-pipelines-for-a-webserver","sections":[],"depth":2},{"title":"Vision pipeline","local":"vision-pipeline","sections":[],"depth":2},{"title":"Text pipeline","local":"text-pipeline","sections":[],"depth":2},{"title":"Multimodal pipeline","local":"multimodal-pipeline","sections":[],"depth":2},{"title":"Using pipeline on large models with 🤗 accelerate :","local":"using-pipeline-on-large-models-with--accelerate-","sections":[],"depth":2},{"title":"Creating web demos from pipelines with gradio","local":"creating-web-demos-from-pipelines-with-gradio","sections":[],"depth":2}],"depth":1}';function qa($){return Za(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Qa extends ka{constructor(f){super(),xa(this,f,qa,Ya,Ia,{})}}export{Qa as component};
