import{s as Et,f as qt,o as Lt,n as W}from"../chunks/scheduler.25b97de1.js";import{S as At,i as Dt,g as M,s as c,r as f,A as Pt,h,f as a,c as d,j as ht,u as y,x as U,k as ge,y as Kt,a as n,v as J,d as T,t as w,w as b}from"../chunks/index.d9030fc9.js";import{T as je}from"../chunks/Tip.baa67368.js";import{C as B}from"../chunks/CodeBlock.e6cd0d95.js";import{H as S,E as Ot}from"../chunks/EditOnGithub.91d95064.js";import{H as ft,a as $e}from"../chunks/HfOption.1e589c90.js";function es(j){let t,p='Hugging Face also provides <a href="https://hf.co/docs/text-generation-inference" rel="nofollow">Text Generation Inference (TGI)</a>, a library dedicated to deploying and serving highly optimized LLMs for inference. It includes more optimization features not included in Transformers, such as continuous batching for increasing throughput and tensor parallelism for multi-GPU inference.';return{c(){t=M("p"),t.innerHTML=p},l(l){t=h(l,"P",{"data-svelte-h":!0}),U(t)!=="svelte-1wl2u2g"&&(t.innerHTML=p)},m(l,r){n(l,t,r)},p:W,d(l){l&&a(t)}}}function ts(j){let t,p='Currently, only <a href="./model_doc/llama2">Llama</a> and a few other models support static kv-cache and torch.compile. Check <a href="https://github.com/huggingface/transformers/issues/28981" rel="nofollow">this issue</a> for a live model compatibility list.';return{c(){t=M("p"),t.innerHTML=p},l(l){t=h(l,"P",{"data-svelte-h":!0}),U(t)!=="svelte-k4zgrc"&&(t.innerHTML=p)},m(l,r){n(l,t,r)},p:W,d(l){l&&a(t)}}}function ss(j){let t,p="Access the model’s <code>generation_config</code> attribute and set the <code>cache_implementation</code> to “static”.",l,r,o,i,g="Call torch.compile on the model to compile the forward pass with the static kv-cache.",$,v,_,I,C="Under the hood, <code>generate</code> will attempt to reuse the same cache object, removing the need for re-compilation at each call. However, if the batch size or the maximum output length increase between calls, the cache will have to be reinitialized, triggering a new compilation.",k;return r=new B({props:{code:"bW9kZWwuZ2VuZXJhdGlvbl9jb25maWcuY2FjaGVfaW1wbGVtZW50YXRpb24lMjAlM0QlMjAlMjJzdGF0aWMlMjI=",highlighted:'model.generation_config.cache_implementation = <span class="hljs-string">&quot;static&quot;</span>',wrap:!1}}),v=new B({props:{code:"Y29tcGlsZWRfbW9kZWwlMjAlM0QlMjB0b3JjaC5jb21waWxlKG1vZGVsJTJDJTIwbW9kZSUzRCUyMnJlZHVjZS1vdmVyaGVhZCUyMiUyQyUyMGZ1bGxncmFwaCUzRFRydWUpJTBBaW5wdXRfdGV4dCUyMCUzRCUyMCUyMlRoZSUyMHRoZW9yeSUyMG9mJTIwc3BlY2lhbCUyMHJlbGF0aXZpdHklMjBzdGF0ZXMlMjAlMjIlMEFpbnB1dF9pZHMlMjAlM0QlMjB0b2tlbml6ZXIoaW5wdXRfdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMGNvbXBpbGVkX21vZGVsLmdlbmVyYXRlKCoqaW5wdXRfaWRzKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSUwQSU1QidUaGUlMjB0aGVvcnklMjBvZiUyMHNwZWNpYWwlMjByZWxhdGl2aXR5JTIwc3RhdGVzJTIwMS4lMjBUaGUlMjBzcGVlZCUyMG9mJTIwbGlnaHQlMjBpcyUyMGNvbnN0YW50JTIwaW4lMjBhbGwlMjBpbmVydGlhbCUyMHJlZmVyZW5jZSclNUQ=",highlighted:`compiled_model = torch.<span class="hljs-built_in">compile</span>(model, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
input_text = <span class="hljs-string">&quot;The theory of special relativity states &quot;</span>
input_ids = tokenizer(input_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

outputs = compiled_model.generate(**input_ids)
tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;The theory of special relativity states 1. The speed of light is constant in all inertial reference&#x27;</span>]`,wrap:!1}}),{c(){t=M("p"),t.innerHTML=p,l=c(),f(r.$$.fragment),o=c(),i=M("p"),i.textContent=g,$=c(),f(v.$$.fragment),_=c(),I=M("p"),I.innerHTML=C},l(u){t=h(u,"P",{"data-svelte-h":!0}),U(t)!=="svelte-oou7hc"&&(t.innerHTML=p),l=d(u),y(r.$$.fragment,u),o=d(u),i=h(u,"P",{"data-svelte-h":!0}),U(i)!=="svelte-pgmdb4"&&(i.textContent=g),$=d(u),y(v.$$.fragment,u),_=d(u),I=h(u,"P",{"data-svelte-h":!0}),U(I)!=="svelte-1xnu6p2"&&(I.innerHTML=C)},m(u,G){n(u,t,G),n(u,l,G),J(r,u,G),n(u,o,G),n(u,i,G),n(u,$,G),J(v,u,G),n(u,_,G),n(u,I,G),k=!0},p:W,i(u){k||(T(r.$$.fragment,u),T(v.$$.fragment,u),k=!0)},o(u){w(r.$$.fragment,u),w(v.$$.fragment,u),k=!1},d(u){u&&(a(t),a(l),a(o),a(i),a($),a(_),a(I)),b(r,u),b(v,u)}}}function ls(j){let t,p='If you want to reuse the <a href="/docs/transformers/pr_30650/en/internal/generation_utils#transformers.StaticCache">StaticCache</a> object on a new prompt, be sure to reset its contents with the <code>.reset()</code> method';return{c(){t=M("p"),t.innerHTML=p},l(l){t=h(l,"P",{"data-svelte-h":!0}),U(t)!=="svelte-1l0iqzi"&&(t.innerHTML=p)},m(l,r){n(l,t,r)},p:W,d(l){l&&a(t)}}}function as(j){let t,p='A <a href="/docs/transformers/pr_30650/en/internal/generation_utils#transformers.StaticCache">StaticCache</a> object can be passed to the model’s forward pass under the <code>past_key_values</code> argument, enabling the use of this object as a static kv-cache. Using this strategy, you can write your own function to decode the next token given the current token and position and cache position of previously generated tokens. You can also pass the <a href="/docs/transformers/pr_30650/en/internal/generation_utils#transformers.StaticCache">StaticCache</a> object to <a href="/docs/transformers/pr_30650/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> and use it across calls, like you would do with a dynamic cache.',l,r,o,i,g="There are a few important things you must do to enable static kv-cache and torch.compile with the <code>StaticCache</code> method:",$,v,_='<li><p>Initialize the <a href="/docs/transformers/pr_30650/en/internal/generation_utils#transformers.StaticCache">StaticCache</a> instance before using the model for inference. There you can configure parameters like the maximum batch size and sequence length.</p></li> <li><p>Call torch.compile on the model to compile the forward pass with the static kv-cache.</p></li> <li><p>Set <code>enable_math=True</code> in the <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow">torch.backends.cuda.sdp_kernel</a> context manager to enable the native PyTorch C++ implementation of scaled dot product attention to speed up inference even more.</p></li>',I,C,k,u,G;return r=new B({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYW1hVG9rZW5pemVyJTJDJTIwTGxhbWFGb3JDYXVzYWxMTSUyQyUyMFN0YXRpY0NhY2hlJTJDJTIwbG9nZ2luZyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMudGVzdGluZ191dGlscyUyMGltcG9ydCUyMENhcHR1cmVMb2dnZXIlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXByb21wdHMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJTaW1wbHklMjBwdXQlMkMlMjB0aGUlMjB0aGVvcnklMjBvZiUyMHJlbGF0aXZpdHklMjBzdGF0ZXMlMjB0aGF0JTIwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyTXklMjBmYXZvcml0ZSUyMGFsbCUyMHRpbWUlMjBmYXZvcml0ZSUyMGNvbmRpbWVudCUyMGlzJTIwa2V0Y2h1cC4lMjIlMkMlMEElNUQlMEElMEFOVU1fVE9LRU5TX1RPX0dFTkVSQVRFJTIwJTNEJTIwNDAlMEF0b3JjaF9kZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwTGxhbWFUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1ldGEtbGxhbWElMkZMbGFtYS0yLTdiLWhmJTIyJTJDJTIwcGFkX3Rva2VuJTNEJTIyJTNDJTJGcyUzRSUyMiUyQyUyMHBhZGRpbmdfc2lkZSUzRCUyMnJpZ2h0JTIyKSUwQW1vZGVsJTIwJTNEJTIwTGxhbWFGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWV0YS1sbGFtYSUyRkxsYW1hLTItN2ItaGYlMjIlMkMlMjBkZXZpY2VfbWFwJTNEJTIyc2VxdWVudGlhbCUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocHJvbXB0cyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMkMlMjBwYWRkaW5nJTNEVHJ1ZSkudG8obW9kZWwuZGV2aWNlKSUwQSUwQWRlZiUyMGRlY29kZV9vbmVfdG9rZW5zKG1vZGVsJTJDJTIwY3VyX3Rva2VuJTJDJTIwaW5wdXRfcG9zJTJDJTIwY2FjaGVfcG9zaXRpb24lMkMlMjBwYXN0X2tleV92YWx1ZXMpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY3VyX3Rva2VuJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcG9zaXRpb25faWRzJTNEaW5wdXRfcG9zJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2FjaGVfcG9zaXRpb24lM0RjYWNoZV9wb3NpdGlvbiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhc3Rfa2V5X3ZhbHVlcyUzRHBhc3Rfa2V5X3ZhbHVlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybl9kaWN0JTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB1c2VfY2FjaGUlM0RUcnVlJTBBJTIwJTIwJTIwJTIwKSU1QjAlNUQlMEElMjAlMjAlMjAlMjBuZXdfdG9rZW4lMjAlM0QlMjB0b3JjaC5hcmdtYXgobG9naXRzJTVCJTNBJTJDJTIwLTElNUQlMkMlMjBkaW0lM0QtMSklNUIlM0ElMkMlMjBOb25lJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwbmV3X3Rva2Vu",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlamaTokenizer, LlamaForCausalLM, StaticCache, logging
<span class="hljs-keyword">from</span> transformers.testing_utils <span class="hljs-keyword">import</span> CaptureLogger
<span class="hljs-keyword">import</span> torch

prompts = [
    <span class="hljs-string">&quot;Simply put, the theory of relativity states that &quot;</span>,
    <span class="hljs-string">&quot;My favorite all time favorite condiment is ketchup.&quot;</span>,
]

NUM_TOKENS_TO_GENERATE = <span class="hljs-number">40</span>
torch_device = <span class="hljs-string">&quot;cuda&quot;</span>

tokenizer = LlamaTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-hf&quot;</span>, pad_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>, padding_side=<span class="hljs-string">&quot;right&quot;</span>)
model = LlamaForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-hf&quot;</span>, device_map=<span class="hljs-string">&quot;sequential&quot;</span>)
inputs = tokenizer(prompts, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>).to(model.device)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">decode_one_tokens</span>(<span class="hljs-params">model, cur_token, input_pos, cache_position, past_key_values</span>):
    logits = model(
        cur_token,
        position_ids=input_pos,
        cache_position=cache_position,
        past_key_values=past_key_values,
        return_dict=<span class="hljs-literal">False</span>,
        use_cache=<span class="hljs-literal">True</span>
    )[<span class="hljs-number">0</span>]
    new_token = torch.argmax(logits[:, -<span class="hljs-number">1</span>], dim=-<span class="hljs-number">1</span>)[:, <span class="hljs-literal">None</span>]
    <span class="hljs-keyword">return</span> new_token`,wrap:!1}}),C=new B({props:{code:"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",highlighted:`batch_size, seq_length = inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape
<span class="hljs-keyword">with</span> torch.no_grad():
    past_key_values = StaticCache(
        config=model.config, max_batch_size=<span class="hljs-number">2</span>, max_cache_len=<span class="hljs-number">4096</span>, device=torch_device, dtype=model.dtype
    )
    cache_position = torch.arange(seq_length, device=torch_device)
    generated_ids = torch.zeros(
        batch_size, seq_length + NUM_TOKENS_TO_GENERATE + <span class="hljs-number">1</span>, dtype=torch.<span class="hljs-built_in">int</span>, device=torch_device
    )
    generated_ids[:, cache_position] = inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].to(torch_device).to(torch.<span class="hljs-built_in">int</span>)

    logits = model(
        **inputs, cache_position=cache_position, past_key_values=past_key_values,return_dict=<span class="hljs-literal">False</span>, use_cache=<span class="hljs-literal">True</span>
    )[<span class="hljs-number">0</span>]
    next_token = torch.argmax(logits[:, -<span class="hljs-number">1</span>], dim=-<span class="hljs-number">1</span>)[:, <span class="hljs-literal">None</span>]
    generated_ids[:, seq_length] = next_token[:, <span class="hljs-number">0</span>]

    decode_one_tokens = torch.<span class="hljs-built_in">compile</span>(decode_one_tokens, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
    cache_position = torch.tensor([seq_length + <span class="hljs-number">1</span>], device=torch_device)
    <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1</span>, NUM_TOKENS_TO_GENERATE):
        <span class="hljs-keyword">with</span> torch.backends.cuda.sdp_kernel(enable_flash=<span class="hljs-literal">False</span>, enable_mem_efficient=<span class="hljs-literal">False</span>, enable_math=<span class="hljs-literal">True</span>):
            next_token = decode_one_tokens(model, next_token.clone(), <span class="hljs-literal">None</span>, cache_position, past_key_values)
            generated_ids[:, cache_position] = next_token.<span class="hljs-built_in">int</span>()
        cache_position += <span class="hljs-number">1</span>

text = tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
text
[<span class="hljs-string">&#x27;Simply put, the theory of relativity states that 1) the speed of light is constant, 2) the speed of light is the same for all observers, and 3) the laws of physics are the same for all observers.&#x27;</span>,
 <span class="hljs-string">&#x27;My favorite all time favorite condiment is ketchup. I love it on everything. I love it on my eggs, my fries, my chicken, my burgers, my hot dogs, my sandwiches, my salads, my p&#x27;</span>]`,wrap:!1}}),u=new je({props:{warning:!1,$$slots:{default:[ls]},$$scope:{ctx:j}}}),{c(){t=M("p"),t.innerHTML=p,l=c(),f(r.$$.fragment),o=c(),i=M("p"),i.innerHTML=g,$=c(),v=M("ol"),v.innerHTML=_,I=c(),f(C.$$.fragment),k=c(),f(u.$$.fragment)},l(m){t=h(m,"P",{"data-svelte-h":!0}),U(t)!=="svelte-3fm52f"&&(t.innerHTML=p),l=d(m),y(r.$$.fragment,m),o=d(m),i=h(m,"P",{"data-svelte-h":!0}),U(i)!=="svelte-1yhzvte"&&(i.innerHTML=g),$=d(m),v=h(m,"OL",{"data-svelte-h":!0}),U(v)!=="svelte-1b0qvnk"&&(v.innerHTML=_),I=d(m),y(C.$$.fragment,m),k=d(m),y(u.$$.fragment,m)},m(m,Z){n(m,t,Z),n(m,l,Z),J(r,m,Z),n(m,o,Z),n(m,i,Z),n(m,$,Z),n(m,v,Z),n(m,I,Z),J(C,m,Z),n(m,k,Z),J(u,m,Z),G=!0},p(m,Z){const V={};Z&2&&(V.$$scope={dirty:Z,ctx:m}),u.$set(V)},i(m){G||(T(r.$$.fragment,m),T(C.$$.fragment,m),T(u.$$.fragment,m),G=!0)},o(m){w(r.$$.fragment,m),w(C.$$.fragment,m),w(u.$$.fragment,m),G=!1},d(m){m&&(a(t),a(l),a(o),a(i),a($),a(v),a(I),a(k)),b(r,m),b(C,m),b(u,m)}}}function ns(j){let t,p,l,r;return t=new $e({props:{id:"static-kv",option:"generation_config",$$slots:{default:[ss]},$$scope:{ctx:j}}}),l=new $e({props:{id:"static-kv",option:"Static Cache",$$slots:{default:[as]},$$scope:{ctx:j}}}),{c(){f(t.$$.fragment),p=c(),f(l.$$.fragment)},l(o){y(t.$$.fragment,o),p=d(o),y(l.$$.fragment,o)},m(o,i){J(t,o,i),n(o,p,i),J(l,o,i),r=!0},p(o,i){const g={};i&2&&(g.$$scope={dirty:i,ctx:o}),t.$set(g);const $={};i&2&&($.$$scope={dirty:i,ctx:o}),l.$set($)},i(o){r||(T(t.$$.fragment,o),T(l.$$.fragment,o),r=!0)},o(o){w(t.$$.fragment,o),w(l.$$.fragment,o),r=!1},d(o){o&&a(p),b(t,o),b(l,o)}}}function os(j){let t,p='For a more in-depth explanation, take a look at the <a href="https://hf.co/blog/assisted-generation" rel="nofollow">Assisted Generation: a new direction toward low-latency text generation</a> blog post!';return{c(){t=M("p"),t.innerHTML=p},l(l){t=h(l,"P",{"data-svelte-h":!0}),U(t)!=="svelte-112w74b"&&(t.innerHTML=p)},m(l,r){n(l,t,r)},p:W,d(l){l&&a(t)}}}function is(j){let t,p="Speculative decoding is only supported for the greedy search and sampling decoding strategies, and it also doesn’t support batched inputs.";return{c(){t=M("p"),t.textContent=p},l(l){t=h(l,"P",{"data-svelte-h":!0}),U(t)!=="svelte-eq929k"&&(t.textContent=p)},m(l,r){n(l,t,r)},p:W,d(l){l&&a(t)}}}function rs(j){let t,p;return t=new B({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm9wdC0xLjNiJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJFaW5zdGVpbidzJTIwdGhlb3J5JTIwb2YlMjByZWxhdGl2aXR5JTIwc3RhdGVzJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oZGV2aWNlKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTEuM2IlMjIpLnRvKGRldmljZSklMEFhc3Npc3RhbnRfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMTI1bSUyMikudG8oZGV2aWNlKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGFzc2lzdGFudF9tb2RlbCUzRGFzc2lzdGFudF9tb2RlbCklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklMEElNUIlMjJFaW5zdGVpbidzJTIwdGhlb3J5JTIwb2YlMjByZWxhdGl2aXR5JTIwc3RhdGVzJTIwdGhhdCUyMHRoZSUyMHNwZWVkJTIwb2YlMjBsaWdodCUyMGlzJTIwY29uc3RhbnQuJTIwJTIwJTIwJTIwJTIyJTVE",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">import</span> torch

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>)
inputs = tokenizer(<span class="hljs-string">&quot;Einstein&#x27;s theory of relativity states&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>).to(device)
assistant_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-125m&quot;</span>).to(device)
outputs = model.generate(**inputs, assistant_model=assistant_model)
tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&quot;Einstein&#x27;s theory of relativity states that the speed of light is constant.    &quot;</span>]`,wrap:!1}}),{c(){f(t.$$.fragment)},l(l){y(t.$$.fragment,l)},m(l,r){J(t,l,r),p=!0},p:W,i(l){p||(T(t.$$.fragment,l),p=!0)},o(l){w(t.$$.fragment,l),p=!1},d(l){b(t,l)}}}function ps(j){let t,p='For speculative sampling decoding, add the <code>do_sample</code> and <code>temperature</code> parameters to the <a href="/docs/transformers/pr_30650/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> method in addition to the assistant model.',l,r,o;return r=new B({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm9wdC0xLjNiJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJFaW5zdGVpbidzJTIwdGhlb3J5JTIwb2YlMjByZWxhdGl2aXR5JTIwc3RhdGVzJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oZGV2aWNlKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTEuM2IlMjIpLnRvKGRldmljZSklMEFhc3Npc3RhbnRfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMTI1bSUyMikudG8oZGV2aWNlKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGFzc2lzdGFudF9tb2RlbCUzRGFzc2lzdGFudF9tb2RlbCUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjB0ZW1wZXJhdHVyZSUzRDAuNyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSkpJTBBJTVCJTIyRWluc3RlaW4ncyUyMHRoZW9yeSUyMG9mJTIwcmVsYXRpdml0eSUyMHN0YXRlcyUyMHRoYXQlMjBtb3Rpb24lMjBpbiUyMHRoZSUyMHVuaXZlcnNlJTIwaXMlMjBub3QlMjBhJTIwc3RyYWlnaHQlMjBsaW5lLiU1Q24lMjIlNUQ=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">import</span> torch

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>)
inputs = tokenizer(<span class="hljs-string">&quot;Einstein&#x27;s theory of relativity states&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>).to(device)
assistant_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-125m&quot;</span>).to(device)
outputs = model.generate(**inputs, assistant_model=assistant_model, do_sample=<span class="hljs-literal">True</span>, temperature=<span class="hljs-number">0.7</span>)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&quot;Einstein&#x27;s theory of relativity states that motion in the universe is not a straight line.\\n&quot;</span>]`,wrap:!1}}),{c(){t=M("p"),t.innerHTML=p,l=c(),f(r.$$.fragment)},l(i){t=h(i,"P",{"data-svelte-h":!0}),U(t)!=="svelte-1r3ifdv"&&(t.innerHTML=p),l=d(i),y(r.$$.fragment,i)},m(i,g){n(i,t,g),n(i,l,g),J(r,i,g),o=!0},p:W,i(i){o||(T(r.$$.fragment,i),o=!0)},o(i){w(r.$$.fragment,i),o=!1},d(i){i&&(a(t),a(l)),b(r,i)}}}function cs(j){let t,p,l,r;return t=new $e({props:{id:"spec-decoding",option:"greedy search",$$slots:{default:[rs]},$$scope:{ctx:j}}}),l=new $e({props:{id:"spec-decoding",option:"sampling",$$slots:{default:[ps]},$$scope:{ctx:j}}}),{c(){f(t.$$.fragment),p=c(),f(l.$$.fragment)},l(o){y(t.$$.fragment,o),p=d(o),y(l.$$.fragment,o)},m(o,i){J(t,o,i),n(o,p,i),J(l,o,i),r=!0},p(o,i){const g={};i&2&&(g.$$scope={dirty:i,ctx:o}),t.$set(g);const $={};i&2&&($.$$scope={dirty:i,ctx:o}),l.$set($)},i(o){r||(T(t.$$.fragment,o),T(l.$$.fragment,o),r=!0)},o(o){w(t.$$.fragment,o),w(l.$$.fragment,o),r=!1},d(o){o&&a(p),b(t,o),b(l,o)}}}function ds(j){let t,p;return t=new B({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm9wdC0xLjNiJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJUaGUlMjBzZWNvbmQlMjBsYXclMjBvZiUyMHRoZXJtb2R5bmFtaWNzJTIwc3RhdGVzJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oZGV2aWNlKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTEuM2IlMjIpLnRvKGRldmljZSklMEFhc3Npc3RhbnRfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMTI1bSUyMikudG8oZGV2aWNlKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMHByb21wdF9sb29rdXBfbnVtX3Rva2VucyUzRDMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKSUwQSU1QidUaGUlMjBzZWNvbmQlMjBsYXclMjBvZiUyMHRoZXJtb2R5bmFtaWNzJTIwc3RhdGVzJTIwdGhhdCUyMGVudHJvcHklMjBpbmNyZWFzZXMlMjB3aXRoJTIwdGVtcGVyYXR1cmUuJTIwJTIwJTIwJTIwJTIwJTIwJyU1RA==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">import</span> torch

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>)
inputs = tokenizer(<span class="hljs-string">&quot;The second law of thermodynamics states&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>).to(device)
assistant_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-125m&quot;</span>).to(device)
outputs = model.generate(**inputs, prompt_lookup_num_tokens=<span class="hljs-number">3</span>)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;The second law of thermodynamics states that entropy increases with temperature.      &#x27;</span>]`,wrap:!1}}),{c(){f(t.$$.fragment)},l(l){y(t.$$.fragment,l)},m(l,r){J(t,l,r),p=!0},p:W,i(l){p||(T(t.$$.fragment,l),p=!0)},o(l){w(t.$$.fragment,l),p=!1},d(l){b(t,l)}}}function ms(j){let t,p='For prompt lookup decoding with sampling, add the <code>do_sample</code> and <code>temperature</code> parameters to the <a href="/docs/transformers/pr_30650/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> method.',l,r,o;return r=new B({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm9wdC0xLjNiJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJUaGUlMjBzZWNvbmQlMjBsYXclMjBvZiUyMHRoZXJtb2R5bmFtaWNzJTIwc3RhdGVzJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oZGV2aWNlKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTEuM2IlMjIpLnRvKGRldmljZSklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBwcm9tcHRfbG9va3VwX251bV90b2tlbnMlM0QzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMHRlbXBlcmF0dXJlJTNEMC43KSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElNUIlMjJUaGUlMjBzZWNvbmQlMjBsYXclMjBvZiUyMHRoZXJtb2R5bmFtaWNzJTIwc3RhdGVzJTIwdGhhdCUyMGVuZXJneSUyMGNhbm5vdCUyMGJlJTIwY3JlYXRlZCUyMG5vciUyMGRlc3Ryb3llZC4lMjBJdCdzJTIwbm90JTIwYSUyMiU1RA==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">import</span> torch

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>)
inputs = tokenizer(<span class="hljs-string">&quot;The second law of thermodynamics states&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>).to(device)
outputs = model.generate(**inputs, prompt_lookup_num_tokens=<span class="hljs-number">3</span>, do_sample=<span class="hljs-literal">True</span>, temperature=<span class="hljs-number">0.7</span>)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&quot;The second law of thermodynamics states that energy cannot be created nor destroyed. It&#x27;s not a&quot;</span>]`,wrap:!1}}),{c(){t=M("p"),t.innerHTML=p,l=c(),f(r.$$.fragment)},l(i){t=h(i,"P",{"data-svelte-h":!0}),U(t)!=="svelte-1x7zuzs"&&(t.innerHTML=p),l=d(i),y(r.$$.fragment,i)},m(i,g){n(i,t,g),n(i,l,g),J(r,i,g),o=!0},p:W,i(i){o||(T(r.$$.fragment,i),o=!0)},o(i){w(r.$$.fragment,i),o=!1},d(i){i&&(a(t),a(l)),b(r,i)}}}function us(j){let t,p,l,r;return t=new $e({props:{id:"pld",option:"greedy decoding",$$slots:{default:[ds]},$$scope:{ctx:j}}}),l=new $e({props:{id:"pld",option:"sampling",$$slots:{default:[ms]},$$scope:{ctx:j}}}),{c(){f(t.$$.fragment),p=c(),f(l.$$.fragment)},l(o){y(t.$$.fragment,o),p=d(o),y(l.$$.fragment,o)},m(o,i){J(t,o,i),n(o,p,i),J(l,o,i),r=!0},p(o,i){const g={};i&2&&(g.$$scope={dirty:i,ctx:o}),t.$set(g);const $={};i&2&&($.$$scope={dirty:i,ctx:o}),l.$set($)},i(o){r||(T(t.$$.fragment,o),T(l.$$.fragment,o),r=!0)},o(o){w(t.$$.fragment,o),w(l.$$.fragment,o),r=!1},d(o){o&&a(p),b(t,o),b(l,o)}}}function Ms(j){let t,p="SDPA supports FlashAttention-2 as long as you have the latest PyTorch version installed.";return{c(){t=M("p"),t.textContent=p},l(l){t=h(l,"P",{"data-svelte-h":!0}),U(t)!=="svelte-12yxz1f"&&(t.textContent=p)},m(l,r){n(l,t,r)},p:W,d(l){l&&a(t)}}}function hs(j){let t,p='There are many quantization libraries (see the <a href="./quantization">Quantization</a> guide for more details) available, such as Quanto, AQLM, AWQ, and AutoGPTQ. Feel free to try them out and see which one works best for your use case. We also recommend reading the <a href="https://hf.co/blog/overview-quantization-transformers" rel="nofollow">Overview of natively supported quantization schemes in 🤗 Transformers</a> blog post which compares AutoGPTQ and bitsandbytes.';return{c(){t=M("p"),t.innerHTML=p},l(l){t=h(l,"P",{"data-svelte-h":!0}),U(t)!=="svelte-1b7gbou"&&(t.innerHTML=p)},m(l,r){n(l,t,r)},p:W,d(l){l&&a(t)}}}function fs(j){let t,p,l,r,o,i,g,$="Large language models (LLMs) have pushed text generation applications, such as chat and code completion models, to the next level by producing text that displays a high level of understanding and fluency. But what makes LLMs so powerful - namely their size - also presents challenges for inference.",v,_,I="Basic inference is slow because LLMs have to be called repeatedly to generate the next token. The input sequence increases as generation progresses, which takes longer and longer for the LLM to process. LLMs also have billions of parameters, making it a challenge to store and handle all those weights in memory.",C,k,u="This guide will show you how to use the optimization techniques available in Transformers to accelerate LLM inference.",G,m,Z,V,Ge,E,yt="During decoding, a LLM computes the key-value (kv) values for each input token and since it is autoregressive, it computes the same kv values each time because the generated output becomes part of the input now. This is not very efficient because you’re recomputing the same kv values each time.",Ze,q,Jt='To optimize this, you can use a kv-cache to store the past keys and values instead of recomputing them each time. However, since the kv-cache grows with each generation step and is dynamic, it prevents you from taking advantage of <a href="./perf_torch_compile">torch.compile</a>, a powerful optimization tool that fuses PyTorch code into fast and optimized kernels.',ke,L,Tt="The <em>static kv-cache</em> solves this issue by pre-allocating the kv-cache size to a maximum value which allows you to combine it with torch.compile for up to a 4x speed up.",_e,X,Ie,A,wt='For this example, let’s load the <a href="https://hf.co/google/gemma-2b" rel="nofollow">Gemma</a> model.',Ce,D,Be,P,bt='There are two ways you can configure the model to use a static kv-cache. For a 7B model on an A100, both methods get a 4x speed up in the forward pass. Your speed up may vary depending on the model size (larger models have a smaller speed up) and hardware. If you’re using the <a href="/docs/transformers/pr_30650/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> method, the speed up is ~3x. The forward pass (which still gets 4x speed up) is only a part of the whole <a href="/docs/transformers/pr_30650/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> code.',We,z,Ve,K,Re,F,Xe,O,Ut="Another issue with autoregression is that for each input token you need to load the model weights each time during the forward pass. This is slow and cumbersome for LLMs which have billions of parameters. Speculative decoding alleviates this slowdown by using a second smaller and faster assistant model to generate candidate tokens that are verified by the larger LLM in a single forward pass. If the verified tokens are correct, the LLM essentially gets them for “free” without having to generate them itself. There is no degradation in accuracy because the verification forward pass ensures the same outputs are generated as if the LLM had generated them on its own.",ze,ee,jt="To get the largest speed up, the assistant model should be a lot smaller than the LLM so that it can generate tokens quickly. The assistant and LLM model must also share the same tokenizer to avoid re-encoding and decoding tokens.",Fe,N,Ne,te,gt='Enable speculative decoding by loading an assistant model and passing it to the <a href="/docs/transformers/pr_30650/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> method.',Qe,Q,He,se,Ye,le,$t="Prompt lookup decoding is a variant of speculative decoding that is also compatible with greedy search and sampling. Prompt lookup works especially well for input-grounded tasks - such as summarization - where there is often overlapping words between the prompt and output. These overlapping n-grams are used as the LLM candidate tokens.",xe,ae,vt='To enable prompt lookup decoding, specify the number of tokens that should be overlapping in the <code>prompt_lookup_num_tokens</code> parameter. Then you can pass this parameter to the <a href="/docs/transformers/pr_30650/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> method.',Se,H,Ee,ne,qe,oe,Gt="A known issue with transformer models is that the self-attention mechanism grows quadratically in compute and memory with the number of input tokens. This limitation is only magnified in LLMs which handles much longer sequences. To address this, try FlashAttention2 or PyTorch’s scaled dot product attention (SDPA), which are more memory efficient attention implementations and can accelerate inference.",Le,ie,Ae,re,Zt='FlashAttention and <a href="./perf_infer_gpu_one#flashattention-2">FlashAttention-2</a> break up the attention computation into smaller chunks and reduces the number of intermediate read/write operations to GPU memory to speed up inference. FlashAttention-2 improves on the original FlashAttention algorithm by also parallelizing over sequence length dimension and better partitioning work on the hardware to reduce synchronization and communication overhead.',De,pe,kt='To use FlashAttention-2, set <code>attn_implementation=&quot;flash_attention_2&quot;</code> in the <a href="/docs/transformers/pr_30650/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method.',Pe,ce,Ke,de,Oe,me,_t="Scaled dot product attention (SDPA) is automatically enabled in PyTorch 2.0 and it supports FlashAttention, xFormers, and PyTorch’s C++ implementation. SDPA chooses the most performant attention algorithm if you’re using a CUDA backend. For other backends, SDPA defaults to the PyTorch C++ implementation.",et,Y,tt,ue,It='Use the <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow">torch.backends.cuda.sdp_kernel</a> context manager to explicitly enable or disable any of the three attention algorithms. For example, set <code>enable_flash=True</code> to enable FlashAttention.',st,Me,lt,he,at,fe,Ct="Quantization reduces the size of the LLM weights by storing them in a lower precision. This translates to lower memory usage and makes loading LLMs for inference more accessible if you’re constrained by your GPUs memory. If you aren’t limited by your GPU, you don’t necessarily need to quantize your model because it can incur a small latency cost (except for AWQ and fused AWQ modules) due to the extra step required to quantize and dequantize the weights.",nt,x,ot,ye,Bt='Use the Model Memory Calculator below to estimate and compare how much memory is required to load a model. For example, try estimating how much memory it costs to load <a href="https://huggingface.co/mistralai/Mistral-7B-v0.1" rel="nofollow">Mistral-7B-v0.1</a>.',it,R,Wt,rt,Je,Vt='To load Mistral-7B-v0.1 in half-precision, set the <code>torch_dtype</code> parameter in the <a href="/docs/transformers/pr_30650/en/model_doc/auto#transformers.AutoModel.from_pretrained">from_pretrained()</a> method to <code>torch.bfloat16</code>. This requires 13.74GB of memory.',pt,Te,ct,we,Rt='To load a quantized model (8-bit or 4-bit) for inference, try <a href="https://hf.co/docs/bitsandbytes" rel="nofollow">bitsandbytes</a> and set the <code>load_in_4bit</code> or <code>load_in_8bit</code> parameters to <code>True</code>. Loading the model in 8-bits only requires 6.87 GB of memory.',dt,be,mt,Ue,ut,ve,Mt;return o=new S({props:{title:"LLM inference optimization",local:"llm-inference-optimization",headingTag:"h1"}}),m=new je({props:{warning:!1,$$slots:{default:[es]},$$scope:{ctx:j}}}),V=new S({props:{title:"Static kv-cache and torch.compile",local:"static-kv-cache-and-torchcompile",headingTag:"h2"}}),X=new je({props:{warning:!0,$$slots:{default:[ts]},$$scope:{ctx:j}}}),D=new B({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmdvb2dsZSUyRmdlbW1hLTJiJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b&quot;</span>)
model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;google/gemma-2b&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>
)`,wrap:!1}}),z=new ft({props:{id:"static-kv",options:["generation_config","Static Cache"],$$slots:{default:[ns]},$$scope:{ctx:j}}}),K=new S({props:{title:"Speculative decoding",local:"speculative-decoding",headingTag:"h2"}}),F=new je({props:{warning:!1,$$slots:{default:[os]},$$scope:{ctx:j}}}),N=new je({props:{warning:!0,$$slots:{default:[is]},$$scope:{ctx:j}}}),Q=new ft({props:{id:"spec-decoding",options:["greedy search","sampling"],$$slots:{default:[cs]},$$scope:{ctx:j}}}),se=new S({props:{title:"Prompt lookup decoding",local:"prompt-lookup-decoding",headingTag:"h3"}}),H=new ft({props:{id:"pld",options:["greedy decoding","sampling"],$$slots:{default:[us]},$$scope:{ctx:j}}}),ne=new S({props:{title:"Attention optimizations",local:"attention-optimizations",headingTag:"h2"}}),ie=new S({props:{title:"FlashAttention-2",local:"flashattention-2",headingTag:"h3"}}),ce=new B({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fOGJpdCUzRFRydWUpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZ29vZ2xlJTJGZ2VtbWEtMmIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMGF0dG5faW1wbGVtZW50YXRpb24lM0QlMjJmbGFzaF9hdHRlbnRpb25fMiUyMiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, BitsAndBytesConfig

quant_config = BitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;google/gemma-2b&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.bfloat16,
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>,
)`,wrap:!1}}),de=new S({props:{title:"PyTorch scaled dot product attention",local:"pytorch-scaled-dot-product-attention",headingTag:"h3"}}),Y=new je({props:{warning:!1,$$slots:{default:[Ms]},$$scope:{ctx:j}}}),Me=new B({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJnb29nbGUlMkZnZW1tYS0yYiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEEpJTBBJTBBd2l0aCUyMHRvcmNoLmJhY2tlbmRzLmN1ZGEuc2RwX2tlcm5lbChlbmFibGVfZmxhc2glM0RUcnVlJTJDJTIwZW5hYmxlX21hdGglM0RGYWxzZSUyQyUyMGVuYWJsZV9tZW1fZWZmaWNpZW50JTNERmFsc2UpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;google/gemma-2b&quot;</span>,
    torch_dtype=torch.bfloat16,
)

<span class="hljs-keyword">with</span> torch.backends.cuda.sdp_kernel(enable_flash=<span class="hljs-literal">True</span>, enable_math=<span class="hljs-literal">False</span>, enable_mem_efficient=<span class="hljs-literal">False</span>):
    outputs = model.generate(**inputs)`,wrap:!1}}),he=new S({props:{title:"Quantization",local:"quantization",headingTag:"h2"}}),x=new je({props:{warning:!1,$$slots:{default:[hs]},$$scope:{ctx:j}}}),Te=new B({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-keyword">import</span> torch

model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)`,wrap:!1}}),be=new B({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fOGJpdCUzRFRydWUpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50X2NvbmZpZyUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, BitsAndBytesConfig
<span class="hljs-keyword">import</span> torch

quant_config = BitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, quantization_config=quant_config, device_map=<span class="hljs-string">&quot;auto&quot;</span>
)`,wrap:!1}}),Ue=new Ot({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/llm_optims.md"}}),{c(){t=M("meta"),p=c(),l=M("p"),r=c(),f(o.$$.fragment),i=c(),g=M("p"),g.textContent=$,v=c(),_=M("p"),_.textContent=I,C=c(),k=M("p"),k.textContent=u,G=c(),f(m.$$.fragment),Z=c(),f(V.$$.fragment),Ge=c(),E=M("p"),E.textContent=yt,Ze=c(),q=M("p"),q.innerHTML=Jt,ke=c(),L=M("p"),L.innerHTML=Tt,_e=c(),f(X.$$.fragment),Ie=c(),A=M("p"),A.innerHTML=wt,Ce=c(),f(D.$$.fragment),Be=c(),P=M("p"),P.innerHTML=bt,We=c(),f(z.$$.fragment),Ve=c(),f(K.$$.fragment),Re=c(),f(F.$$.fragment),Xe=c(),O=M("p"),O.textContent=Ut,ze=c(),ee=M("p"),ee.textContent=jt,Fe=c(),f(N.$$.fragment),Ne=c(),te=M("p"),te.innerHTML=gt,Qe=c(),f(Q.$$.fragment),He=c(),f(se.$$.fragment),Ye=c(),le=M("p"),le.textContent=$t,xe=c(),ae=M("p"),ae.innerHTML=vt,Se=c(),f(H.$$.fragment),Ee=c(),f(ne.$$.fragment),qe=c(),oe=M("p"),oe.textContent=Gt,Le=c(),f(ie.$$.fragment),Ae=c(),re=M("p"),re.innerHTML=Zt,De=c(),pe=M("p"),pe.innerHTML=kt,Pe=c(),f(ce.$$.fragment),Ke=c(),f(de.$$.fragment),Oe=c(),me=M("p"),me.textContent=_t,et=c(),f(Y.$$.fragment),tt=c(),ue=M("p"),ue.innerHTML=It,st=c(),f(Me.$$.fragment),lt=c(),f(he.$$.fragment),at=c(),fe=M("p"),fe.textContent=Ct,nt=c(),f(x.$$.fragment),ot=c(),ye=M("p"),ye.innerHTML=Bt,it=c(),R=M("iframe"),rt=c(),Je=M("p"),Je.innerHTML=Vt,pt=c(),f(Te.$$.fragment),ct=c(),we=M("p"),we.innerHTML=Rt,dt=c(),f(be.$$.fragment),mt=c(),f(Ue.$$.fragment),ut=c(),ve=M("p"),this.h()},l(e){const s=Pt("svelte-u9bgzb",document.head);t=h(s,"META",{name:!0,content:!0}),s.forEach(a),p=d(e),l=h(e,"P",{}),ht(l).forEach(a),r=d(e),y(o.$$.fragment,e),i=d(e),g=h(e,"P",{"data-svelte-h":!0}),U(g)!=="svelte-1kjw8nj"&&(g.textContent=$),v=d(e),_=h(e,"P",{"data-svelte-h":!0}),U(_)!=="svelte-1l3iyos"&&(_.textContent=I),C=d(e),k=h(e,"P",{"data-svelte-h":!0}),U(k)!=="svelte-1wb7yan"&&(k.textContent=u),G=d(e),y(m.$$.fragment,e),Z=d(e),y(V.$$.fragment,e),Ge=d(e),E=h(e,"P",{"data-svelte-h":!0}),U(E)!=="svelte-bq37ce"&&(E.textContent=yt),Ze=d(e),q=h(e,"P",{"data-svelte-h":!0}),U(q)!=="svelte-1mrwa3s"&&(q.innerHTML=Jt),ke=d(e),L=h(e,"P",{"data-svelte-h":!0}),U(L)!=="svelte-yamton"&&(L.innerHTML=Tt),_e=d(e),y(X.$$.fragment,e),Ie=d(e),A=h(e,"P",{"data-svelte-h":!0}),U(A)!=="svelte-45dili"&&(A.innerHTML=wt),Ce=d(e),y(D.$$.fragment,e),Be=d(e),P=h(e,"P",{"data-svelte-h":!0}),U(P)!=="svelte-h2spzq"&&(P.innerHTML=bt),We=d(e),y(z.$$.fragment,e),Ve=d(e),y(K.$$.fragment,e),Re=d(e),y(F.$$.fragment,e),Xe=d(e),O=h(e,"P",{"data-svelte-h":!0}),U(O)!=="svelte-18z9bzk"&&(O.textContent=Ut),ze=d(e),ee=h(e,"P",{"data-svelte-h":!0}),U(ee)!=="svelte-1nm1j4o"&&(ee.textContent=jt),Fe=d(e),y(N.$$.fragment,e),Ne=d(e),te=h(e,"P",{"data-svelte-h":!0}),U(te)!=="svelte-112d7l5"&&(te.innerHTML=gt),Qe=d(e),y(Q.$$.fragment,e),He=d(e),y(se.$$.fragment,e),Ye=d(e),le=h(e,"P",{"data-svelte-h":!0}),U(le)!=="svelte-123yl06"&&(le.textContent=$t),xe=d(e),ae=h(e,"P",{"data-svelte-h":!0}),U(ae)!=="svelte-dkplwy"&&(ae.innerHTML=vt),Se=d(e),y(H.$$.fragment,e),Ee=d(e),y(ne.$$.fragment,e),qe=d(e),oe=h(e,"P",{"data-svelte-h":!0}),U(oe)!=="svelte-zxt0p7"&&(oe.textContent=Gt),Le=d(e),y(ie.$$.fragment,e),Ae=d(e),re=h(e,"P",{"data-svelte-h":!0}),U(re)!=="svelte-pa091d"&&(re.innerHTML=Zt),De=d(e),pe=h(e,"P",{"data-svelte-h":!0}),U(pe)!=="svelte-bheok4"&&(pe.innerHTML=kt),Pe=d(e),y(ce.$$.fragment,e),Ke=d(e),y(de.$$.fragment,e),Oe=d(e),me=h(e,"P",{"data-svelte-h":!0}),U(me)!=="svelte-16n93px"&&(me.textContent=_t),et=d(e),y(Y.$$.fragment,e),tt=d(e),ue=h(e,"P",{"data-svelte-h":!0}),U(ue)!=="svelte-cbkj1o"&&(ue.innerHTML=It),st=d(e),y(Me.$$.fragment,e),lt=d(e),y(he.$$.fragment,e),at=d(e),fe=h(e,"P",{"data-svelte-h":!0}),U(fe)!=="svelte-x4c749"&&(fe.textContent=Ct),nt=d(e),y(x.$$.fragment,e),ot=d(e),ye=h(e,"P",{"data-svelte-h":!0}),U(ye)!=="svelte-1i2aaqz"&&(ye.innerHTML=Bt),it=d(e),R=h(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),ht(R).forEach(a),rt=d(e),Je=h(e,"P",{"data-svelte-h":!0}),U(Je)!=="svelte-1d423jb"&&(Je.innerHTML=Vt),pt=d(e),y(Te.$$.fragment,e),ct=d(e),we=h(e,"P",{"data-svelte-h":!0}),U(we)!=="svelte-a32zwr"&&(we.innerHTML=Rt),dt=d(e),y(be.$$.fragment,e),mt=d(e),y(Ue.$$.fragment,e),ut=d(e),ve=h(e,"P",{}),ht(ve).forEach(a),this.h()},h(){ge(t,"name","hf:doc:metadata"),ge(t,"content",ys),qt(R.src,Wt="https://hf-accelerate-model-memory-usage.hf.space")||ge(R,"src",Wt),ge(R,"frameborder","0"),ge(R,"width","850"),ge(R,"height","450")},m(e,s){Kt(document.head,t),n(e,p,s),n(e,l,s),n(e,r,s),J(o,e,s),n(e,i,s),n(e,g,s),n(e,v,s),n(e,_,s),n(e,C,s),n(e,k,s),n(e,G,s),J(m,e,s),n(e,Z,s),J(V,e,s),n(e,Ge,s),n(e,E,s),n(e,Ze,s),n(e,q,s),n(e,ke,s),n(e,L,s),n(e,_e,s),J(X,e,s),n(e,Ie,s),n(e,A,s),n(e,Ce,s),J(D,e,s),n(e,Be,s),n(e,P,s),n(e,We,s),J(z,e,s),n(e,Ve,s),J(K,e,s),n(e,Re,s),J(F,e,s),n(e,Xe,s),n(e,O,s),n(e,ze,s),n(e,ee,s),n(e,Fe,s),J(N,e,s),n(e,Ne,s),n(e,te,s),n(e,Qe,s),J(Q,e,s),n(e,He,s),J(se,e,s),n(e,Ye,s),n(e,le,s),n(e,xe,s),n(e,ae,s),n(e,Se,s),J(H,e,s),n(e,Ee,s),J(ne,e,s),n(e,qe,s),n(e,oe,s),n(e,Le,s),J(ie,e,s),n(e,Ae,s),n(e,re,s),n(e,De,s),n(e,pe,s),n(e,Pe,s),J(ce,e,s),n(e,Ke,s),J(de,e,s),n(e,Oe,s),n(e,me,s),n(e,et,s),J(Y,e,s),n(e,tt,s),n(e,ue,s),n(e,st,s),J(Me,e,s),n(e,lt,s),J(he,e,s),n(e,at,s),n(e,fe,s),n(e,nt,s),J(x,e,s),n(e,ot,s),n(e,ye,s),n(e,it,s),n(e,R,s),n(e,rt,s),n(e,Je,s),n(e,pt,s),J(Te,e,s),n(e,ct,s),n(e,we,s),n(e,dt,s),J(be,e,s),n(e,mt,s),J(Ue,e,s),n(e,ut,s),n(e,ve,s),Mt=!0},p(e,[s]){const Xt={};s&2&&(Xt.$$scope={dirty:s,ctx:e}),m.$set(Xt);const zt={};s&2&&(zt.$$scope={dirty:s,ctx:e}),X.$set(zt);const Ft={};s&2&&(Ft.$$scope={dirty:s,ctx:e}),z.$set(Ft);const Nt={};s&2&&(Nt.$$scope={dirty:s,ctx:e}),F.$set(Nt);const Qt={};s&2&&(Qt.$$scope={dirty:s,ctx:e}),N.$set(Qt);const Ht={};s&2&&(Ht.$$scope={dirty:s,ctx:e}),Q.$set(Ht);const Yt={};s&2&&(Yt.$$scope={dirty:s,ctx:e}),H.$set(Yt);const xt={};s&2&&(xt.$$scope={dirty:s,ctx:e}),Y.$set(xt);const St={};s&2&&(St.$$scope={dirty:s,ctx:e}),x.$set(St)},i(e){Mt||(T(o.$$.fragment,e),T(m.$$.fragment,e),T(V.$$.fragment,e),T(X.$$.fragment,e),T(D.$$.fragment,e),T(z.$$.fragment,e),T(K.$$.fragment,e),T(F.$$.fragment,e),T(N.$$.fragment,e),T(Q.$$.fragment,e),T(se.$$.fragment,e),T(H.$$.fragment,e),T(ne.$$.fragment,e),T(ie.$$.fragment,e),T(ce.$$.fragment,e),T(de.$$.fragment,e),T(Y.$$.fragment,e),T(Me.$$.fragment,e),T(he.$$.fragment,e),T(x.$$.fragment,e),T(Te.$$.fragment,e),T(be.$$.fragment,e),T(Ue.$$.fragment,e),Mt=!0)},o(e){w(o.$$.fragment,e),w(m.$$.fragment,e),w(V.$$.fragment,e),w(X.$$.fragment,e),w(D.$$.fragment,e),w(z.$$.fragment,e),w(K.$$.fragment,e),w(F.$$.fragment,e),w(N.$$.fragment,e),w(Q.$$.fragment,e),w(se.$$.fragment,e),w(H.$$.fragment,e),w(ne.$$.fragment,e),w(ie.$$.fragment,e),w(ce.$$.fragment,e),w(de.$$.fragment,e),w(Y.$$.fragment,e),w(Me.$$.fragment,e),w(he.$$.fragment,e),w(x.$$.fragment,e),w(Te.$$.fragment,e),w(be.$$.fragment,e),w(Ue.$$.fragment,e),Mt=!1},d(e){e&&(a(p),a(l),a(r),a(i),a(g),a(v),a(_),a(C),a(k),a(G),a(Z),a(Ge),a(E),a(Ze),a(q),a(ke),a(L),a(_e),a(Ie),a(A),a(Ce),a(Be),a(P),a(We),a(Ve),a(Re),a(Xe),a(O),a(ze),a(ee),a(Fe),a(Ne),a(te),a(Qe),a(He),a(Ye),a(le),a(xe),a(ae),a(Se),a(Ee),a(qe),a(oe),a(Le),a(Ae),a(re),a(De),a(pe),a(Pe),a(Ke),a(Oe),a(me),a(et),a(tt),a(ue),a(st),a(lt),a(at),a(fe),a(nt),a(ot),a(ye),a(it),a(R),a(rt),a(Je),a(pt),a(ct),a(we),a(dt),a(mt),a(ut),a(ve)),a(t),b(o,e),b(m,e),b(V,e),b(X,e),b(D,e),b(z,e),b(K,e),b(F,e),b(N,e),b(Q,e),b(se,e),b(H,e),b(ne,e),b(ie,e),b(ce,e),b(de,e),b(Y,e),b(Me,e),b(he,e),b(x,e),b(Te,e),b(be,e),b(Ue,e)}}}const ys='{"title":"LLM inference optimization","local":"llm-inference-optimization","sections":[{"title":"Static kv-cache and torch.compile","local":"static-kv-cache-and-torchcompile","sections":[],"depth":2},{"title":"Speculative decoding","local":"speculative-decoding","sections":[{"title":"Prompt lookup decoding","local":"prompt-lookup-decoding","sections":[],"depth":3}],"depth":2},{"title":"Attention optimizations","local":"attention-optimizations","sections":[{"title":"FlashAttention-2","local":"flashattention-2","sections":[],"depth":3},{"title":"PyTorch scaled dot product attention","local":"pytorch-scaled-dot-product-attention","sections":[],"depth":3}],"depth":2},{"title":"Quantization","local":"quantization","sections":[],"depth":2}],"depth":1}';function Js(j){return Lt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $s extends At{constructor(t){super(),Dt(this,t,Js,fs,Et,{})}}export{$s as component};
