import{s as vo,f as Co,o as ko,n as wt}from"../chunks/scheduler.25b97de1.js";import{S as Ro,i as $o,g as a,s as n,r as h,A as jo,h as i,f as o,c as s,j as x,u as f,x as m,k,y as d,a as r,v as u,d as g,t as _,w as T}from"../chunks/index.d9030fc9.js";import{T as Mo}from"../chunks/Tip.baa67368.js";import{D as I}from"../chunks/Docstring.e257edda.js";import{C as Et}from"../chunks/CodeBlock.e6cd0d95.js";import{E as yo}from"../chunks/ExampleCodeBlock.20db4b6e.js";import{P as wo}from"../chunks/PipelineTag.5f100392.js";import{H as G,E as xo}from"../chunks/EditOnGithub.91d95064.js";function Jo(J){let l,v="Example:",p,b,w;return b=new Et({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyT0NSQ29uZmlnJTJDJTIwVHJPQ1JGb3JDYXVzYWxMTSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBUck9DUi1iYXNlJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMFRyT0NSQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbW9kZWwlMjAod2l0aCUyMHJhbmRvbSUyMHdlaWdodHMpJTIwZnJvbSUyMHRoZSUyMFRyT0NSLWJhc2UlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMFRyT0NSRm9yQ2F1c2FsTE0oY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrOCRConfig, TrOCRForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a TrOCR-base style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = TrOCRConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the TrOCR-base style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TrOCRForCausalLM(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){l=a("p"),l.textContent=v,p=n(),h(b.$$.fragment)},l(c){l=i(c,"P",{"data-svelte-h":!0}),m(l)!=="svelte-11lpom8"&&(l.textContent=v),p=s(c),f(b.$$.fragment,c)},m(c,C){r(c,l,C),r(c,p,C),u(b,c,C),w=!0},p:wt,i(c){w||(g(b.$$.fragment,c),w=!0)},o(c){_(b.$$.fragment,c),w=!1},d(c){c&&(o(l),o(p)),T(b,c)}}}function Zo(J){let l,v=`This class method is simply calling the feature extractor
<a href="/docs/transformers/pr_30650/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.from_pretrained">from_pretrained()</a>, image processor
<a href="/docs/transformers/pr_30650/en/internal/image_processing_utils#transformers.ImageProcessingMixin">ImageProcessingMixin</a> and the tokenizer
<code>~tokenization_utils_base.PreTrainedTokenizer.from_pretrained</code> methods. Please refer to the docstrings of the
methods above for more information.`;return{c(){l=a("p"),l.innerHTML=v},l(p){l=i(p,"P",{"data-svelte-h":!0}),m(l)!=="svelte-l94mwp"&&(l.innerHTML=v)},m(p,b){r(p,l,b)},p:wt,d(p){p&&o(l)}}}function Oo(J){let l,v=`This class method is simply calling <a href="/docs/transformers/pr_30650/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> and
<a href="/docs/transformers/pr_30650/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.save_pretrained">save_pretrained()</a>. Please refer to the docstrings of the
methods above for more information.`;return{c(){l=a("p"),l.innerHTML=v},l(p){l=i(p,"P",{"data-svelte-h":!0}),m(l)!=="svelte-tnhdlm"&&(l.innerHTML=v)},m(p,b){r(p,l,b)},p:wt,d(p){p&&o(l)}}}function Uo(J){let l,v="Example:",p,b,w;return b=new Et({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    TrOCRConfig,
<span class="hljs-meta">... </span>    TrOCRProcessor,
<span class="hljs-meta">... </span>    TrOCRForCausalLM,
<span class="hljs-meta">... </span>    ViTConfig,
<span class="hljs-meta">... </span>    ViTModel,
<span class="hljs-meta">... </span>    VisionEncoderDecoderModel,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># TrOCR is a decoder model and should be used within a VisionEncoderDecoderModel</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># init vision2text model with random weights</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoder = ViTModel(ViTConfig())
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder = TrOCRForCausalLM(TrOCRConfig())
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VisionEncoderDecoderModel(encoder=encoder, decoder=decoder)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If you want to start from the pretrained model, load the checkpoint with \`VisionEncoderDecoderModel\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = TrOCRProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/trocr-base-handwritten&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VisionEncoderDecoderModel.from_pretrained(<span class="hljs-string">&quot;microsoft/trocr-base-handwritten&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load image from the IAM dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://fki.tic.heia-fr.ch/static/img/a01-122-02.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pixel_values = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;industry, &#x27; Mr. Brown commented icily. &#x27; Let us have a&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># training</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.decoder_start_token_id = processor.tokenizer.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.pad_token_id = processor.tokenizer.pad_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.vocab_size = model.config.decoder.vocab_size

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = processor.tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(pixel_values, labels=labels)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(loss.item(), <span class="hljs-number">2</span>)
<span class="hljs-number">5.30</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(pixel_values)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text
<span class="hljs-string">&#x27;industry, &quot; Mr. Brown commented icily. &quot; Let us have a&#x27;</span>`,wrap:!1}}),{c(){l=a("p"),l.textContent=v,p=n(),h(b.$$.fragment)},l(c){l=i(c,"P",{"data-svelte-h":!0}),m(l)!=="svelte-11lpom8"&&(l.textContent=v),p=s(c),f(b.$$.fragment,c)},m(c,C){r(c,l,C),r(c,p,C),u(b,c,C),w=!0},p:wt,i(c){w||(g(b.$$.fragment,c),w=!0)},o(c){_(b.$$.fragment,c),w=!1},d(c){c&&(o(l),o(p)),T(b,c)}}}function Io(J){let l,v,p,b,w,c,C,Be,X,Gt=`The TrOCR model was proposed in <a href="https://arxiv.org/abs/2109.10282" rel="nofollow">TrOCR: Transformer-based Optical Character Recognition with Pre-trained
Models</a> by Minghao Li, Tengchao Lv, Lei Cui, Yijuan Lu, Dinei Florencio, Cha Zhang,
Zhoujun Li, Furu Wei. TrOCR consists of an image Transformer encoder and an autoregressive text Transformer decoder to
perform <a href="https://en.wikipedia.org/wiki/Optical_character_recognition" rel="nofollow">optical character recognition (OCR)</a>.`,He,S,Xt="The abstract from the paper is the following:",Ne,q,St=`<em>Text recognition is a long-standing research problem for document digitalization. Existing approaches for text recognition
are usually built based on CNN for image understanding and RNN for char-level text generation. In addition, another language
model is usually needed to improve the overall accuracy as a post-processing step. In this paper, we propose an end-to-end
text recognition approach with pre-trained image Transformer and text Transformer models, namely TrOCR, which leverages the
Transformer architecture for both image understanding and wordpiece-level text generation. The TrOCR model is simple but
effective, and can be pre-trained with large-scale synthetic data and fine-tuned with human-labeled datasets. Experiments
show that the TrOCR model outperforms the current state-of-the-art models on both printed and handwritten text recognition
tasks.</em>`,Ee,W,qt,Ge,Y,Yt='TrOCR architecture. Taken from the <a href="https://arxiv.org/abs/2109.10282">original paper</a>.',Xe,Q,Qt="Please refer to the <code>VisionEncoderDecoder</code> class on how to use this model.",Se,D,Dt=`This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>. The original code can be found
<a href="https://github.com/microsoft/unilm/tree/6f60612e7cc86a2a1ae85c47231507a587ab4e01/trocr" rel="nofollow">here</a>.`,qe,A,Ye,K,At=`<li>The quickest way to get started with TrOCR is by checking the <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/TrOCR" rel="nofollow">tutorial
notebooks</a>, which show how to use the model
at inference time as well as fine-tuning on custom data.</li> <li>TrOCR is pre-trained in 2 stages before being fine-tuned on downstream datasets. It achieves state-of-the-art results
on both printed (e.g. the <a href="https://paperswithcode.com/dataset/sroie" rel="nofollow">SROIE dataset</a> and handwritten (e.g. the <a href="https://fki.tic.heia-fr.ch/databases/iam-handwriting-database%3E" rel="nofollow">IAM
Handwriting dataset</a> text recognition tasks. For more
information, see the <a href="https://huggingface.co/models?other=trocr%3E" rel="nofollow">official models</a>.</li> <li>TrOCR is always used within the <a href="vision-encoder-decoder">VisionEncoderDecoder</a> framework.</li>`,Qe,ee,De,te,Kt="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with TrOCR. If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",Ae,oe,Ke,re,eo='<li>A blog post on <a href="https://huggingface.co/blog/document-ai" rel="nofollow">Accelerating Document AI</a> with TrOCR.</li> <li>A blog post on how to <a href="https://github.com/philschmid/document-ai-transformers" rel="nofollow">Document AI</a> with TrOCR.</li> <li>A notebook on how to <a href="https://colab.research.google.com/github/NielsRogge/Transformers-Tutorials/blob/master/TrOCR/Fine_tune_TrOCR_on_IAM_Handwriting_Database_using_Seq2SeqTrainer.ipynb" rel="nofollow">finetune TrOCR on IAM Handwriting Database using Seq2SeqTrainer</a>.</li> <li>A notebook on <a href="https://colab.research.google.com/github/NielsRogge/Transformers-Tutorials/blob/master/TrOCR/Inference_with_TrOCR_%2B_Gradio_demo.ipynb" rel="nofollow">inference with TrOCR</a> and Gradio demo.</li> <li>A notebook on <a href="https://colab.research.google.com/github/NielsRogge/Transformers-Tutorials/blob/master/TrOCR/Fine_tune_TrOCR_on_IAM_Handwriting_Database_using_native_PyTorch.ipynb" rel="nofollow">finetune TrOCR on the IAM Handwriting Database</a> using native PyTorch.</li> <li>A notebook on <a href="https://colab.research.google.com/github/NielsRogge/Transformers-Tutorials/blob/master/TrOCR/Evaluating_TrOCR_base_handwritten_on_the_IAM_test_set.ipynb" rel="nofollow">evaluating TrOCR on the IAM test set</a>.</li>',et,ne,tt,se,to='<li><a href="https://huggingface.co/docs/transformers/tasks/language_modeling" rel="nofollow">Casual language modeling</a> task guide.</li>',ot,ae,oo="⚡️ Inference",rt,ie,ro='<li>An interactive-demo on <a href="https://huggingface.co/spaces/nielsr/TrOCR-handwritten" rel="nofollow">TrOCR handwritten character recognition</a>.</li>',nt,le,st,de,no=`TrOCR’s <code>VisionEncoderDecoder</code> model accepts images as input and makes use of
<a href="/docs/transformers/pr_30650/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> to autoregressively generate text given the input image.`,at,ce,so=`The [<code>ViTImageProcessor</code>/<code>DeiTImageProcessor</code>] class is responsible for preprocessing the input image and
[<code>RobertaTokenizer</code>/<code>XLMRobertaTokenizer</code>] decodes the generated target tokens to the target string. The
<a href="/docs/transformers/pr_30650/en/model_doc/trocr#transformers.TrOCRProcessor">TrOCRProcessor</a> wraps [<code>ViTImageProcessor</code>/<code>DeiTImageProcessor</code>] and [<code>RobertaTokenizer</code>/<code>XLMRobertaTokenizer</code>]
into a single instance to both extract the input features and decode the predicted token ids.`,it,me,ao="<li>Step-by-step Optical Character Recognition (OCR)</li>",lt,pe,dt,he,io='See the <a href="https://huggingface.co/models?filter=trocr" rel="nofollow">model hub</a> to look for TrOCR checkpoints.',ct,fe,mt,R,ue,vt,je,lo=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_30650/en/model_doc/trocr#transformers.TrOCRForCausalLM">TrOCRForCausalLM</a>. It is used to instantiate an
TrOCR model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the TrOCR
<a href="https://huggingface.co/microsoft/trocr-base-handwritten" rel="nofollow">microsoft/trocr-base-handwritten</a> architecture.`,Ct,xe,co=`Configuration objects inherit from <a href="/docs/transformers/pr_30650/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_30650/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,kt,L,pt,ge,ht,M,_e,Rt,Je,mo="Constructs a TrOCR processor which wraps a vision image processor and a TrOCR tokenizer into a single processor.",$t,Ze,po=`<a href="/docs/transformers/pr_30650/en/model_doc/trocr#transformers.TrOCRProcessor">TrOCRProcessor</a> offers all the functionalities of [<code>ViTImageProcessor</code>/<code>DeiTImageProcessor</code>] and
[<code>RobertaTokenizer</code>/<code>XLMRobertaTokenizer</code>]. See the <a href="/docs/transformers/pr_30650/en/model_doc/trocr#transformers.TrOCRProcessor.__call__"><strong>call</strong>()</a> and <a href="/docs/transformers/pr_30650/en/model_doc/trocr#transformers.TrOCRProcessor.decode">decode()</a> for
more information.`,jt,z,Te,xt,Oe,ho=`When used in normal mode, this method forwards all its arguments to AutoImageProcessor’s
<code>__call__()</code> and returns its output. If used in the context
<code>as_target_processor()</code> this method forwards all its arguments to TrOCRTokenizer’s
<code>~TrOCRTokenizer.__call__</code>. Please refer to the doctsring of the above two methods for more information.`,Jt,Z,be,Zt,Ue,fo="Instantiate a processor associated with a pretrained model.",Ot,F,Ut,O,Me,It,Ie,uo=`Saves the attributes of this processor (feature extractor, tokenizer…) in the specified directory so that it
can be reloaded using the <a href="/docs/transformers/pr_30650/en/main_classes/processors#transformers.ProcessorMixin.from_pretrained">from_pretrained()</a> method.`,Wt,V,Lt,P,ye,zt,We,go=`This method forwards all its arguments to TrOCRTokenizer’s <a href="/docs/transformers/pr_30650/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>. Please refer
to the docstring of this method for more information.`,Ft,B,we,Vt,Le,_o=`This method forwards all its arguments to TrOCRTokenizer’s <a href="/docs/transformers/pr_30650/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>. Please refer to the
docstring of this method for more information.`,ft,ve,ut,$,Ce,Pt,ze,To=`The TrOCR Decoder with a language modeling head. Can be used as the decoder part of <a href="/docs/transformers/pr_30650/en/model_doc/encoder-decoder#transformers.EncoderDecoderModel">EncoderDecoderModel</a> and <code>VisionEncoderDecoder</code>.
This model inherits from <a href="/docs/transformers/pr_30650/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Bt,Fe,bo=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ht,H,ke,Nt,N,gt,Re,_t,Pe,Tt;return w=new G({props:{title:"TrOCR",local:"trocr",headingTag:"h1"}}),C=new G({props:{title:"Overview",local:"overview",headingTag:"h2"}}),A=new G({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),ee=new G({props:{title:"Resources",local:"resources",headingTag:"h2"}}),oe=new wo({props:{pipeline:"text-classification"}}),ne=new wo({props:{pipeline:"text-generation"}}),le=new G({props:{title:"Inference",local:"inference",headingTag:"h2"}}),pe=new Et({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyT0NSUHJvY2Vzc29yJTJDJTIwVmlzaW9uRW5jb2RlckRlY29kZXJNb2RlbCUwQWltcG9ydCUyMHJlcXVlc3RzJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwVHJPQ1JQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnRyb2NyLWJhc2UtaGFuZHdyaXR0ZW4lMjIpJTBBbW9kZWwlMjAlM0QlMjBWaXNpb25FbmNvZGVyRGVjb2Rlck1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZ0cm9jci1iYXNlLWhhbmR3cml0dGVuJTIyKSUwQSUwQSUyMyUyMGxvYWQlMjBpbWFnZSUyMGZyb20lMjB0aGUlMjBJQU0lMjBkYXRhc2V0JTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZma2kudGljLmhlaWEtZnIuY2glMkZzdGF0aWMlMkZpbWclMkZhMDEtMTIyLTAyLmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KS5jb252ZXJ0KCUyMlJHQiUyMiklMEElMEFwaXhlbF92YWx1ZXMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS5waXhlbF92YWx1ZXMlMEFnZW5lcmF0ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUocGl4ZWxfdmFsdWVzKSUwQSUwQWdlbmVyYXRlZF90ZXh0JTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrOCRProcessor, VisionEncoderDecoderModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = TrOCRProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/trocr-base-handwritten&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VisionEncoderDecoderModel.from_pretrained(<span class="hljs-string">&quot;microsoft/trocr-base-handwritten&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load image from the IAM dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://fki.tic.heia-fr.ch/static/img/a01-122-02.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pixel_values = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(pixel_values)

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]`,wrap:!1}}),fe=new G({props:{title:"TrOCRConfig",local:"transformers.TrOCRConfig",headingTag:"h2"}}),ue=new I({props:{name:"class transformers.TrOCRConfig",anchor:"transformers.TrOCRConfig",parameters:[{name:"vocab_size",val:" = 50265"},{name:"d_model",val:" = 1024"},{name:"decoder_layers",val:" = 12"},{name:"decoder_attention_heads",val:" = 16"},{name:"decoder_ffn_dim",val:" = 4096"},{name:"activation_function",val:" = 'gelu'"},{name:"max_position_embeddings",val:" = 512"},{name:"dropout",val:" = 0.1"},{name:"attention_dropout",val:" = 0.0"},{name:"activation_dropout",val:" = 0.0"},{name:"decoder_start_token_id",val:" = 2"},{name:"init_std",val:" = 0.02"},{name:"decoder_layerdrop",val:" = 0.0"},{name:"use_cache",val:" = True"},{name:"scale_embedding",val:" = False"},{name:"use_learned_position_embeddings",val:" = True"},{name:"layernorm_embedding",val:" = True"},{name:"pad_token_id",val:" = 1"},{name:"bos_token_id",val:" = 0"},{name:"eos_token_id",val:" = 2"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TrOCRConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 50265) &#x2014;
Vocabulary size of the TrOCR model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/pr_30650/en/model_doc/trocr#transformers.TrOCRForCausalLM">TrOCRForCausalLM</a>.`,name:"vocab_size"},{anchor:"transformers.TrOCRConfig.d_model",description:`<strong>d_model</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Dimensionality of the layers and the pooler layer.`,name:"d_model"},{anchor:"transformers.TrOCRConfig.decoder_layers",description:`<strong>decoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of decoder layers.`,name:"decoder_layers"},{anchor:"transformers.TrOCRConfig.decoder_attention_heads",description:`<strong>decoder_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of attention heads for each attention layer in the Transformer decoder.`,name:"decoder_attention_heads"},{anchor:"transformers.TrOCRConfig.decoder_ffn_dim",description:`<strong>decoder_ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in decoder.`,name:"decoder_ffn_dim"},{anchor:"transformers.TrOCRConfig.activation_function",description:`<strong>activation_function</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the pooler. If string, <code>&quot;gelu&quot;</code>, <code>&quot;relu&quot;</code>,
<code>&quot;silu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"activation_function"},{anchor:"transformers.TrOCRConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The maximum sequence length that this model might ever be used with. Typically set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.TrOCRConfig.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, and pooler.`,name:"dropout"},{anchor:"transformers.TrOCRConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.TrOCRConfig.activation_dropout",description:`<strong>activation_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for activations inside the fully connected layer.`,name:"activation_dropout"},{anchor:"transformers.TrOCRConfig.init_std",description:`<strong>init_std</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"init_std"},{anchor:"transformers.TrOCRConfig.decoder_layerdrop",description:`<strong>decoder_layerdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The LayerDrop probability for the decoder. See the [LayerDrop paper](see <a href="https://arxiv.org/abs/1909.11556" rel="nofollow">https://arxiv.org/abs/1909.11556</a>)
for more details.`,name:"decoder_layerdrop"},{anchor:"transformers.TrOCRConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models).`,name:"use_cache"},{anchor:"transformers.TrOCRConfig.scale_embedding",description:`<strong>scale_embedding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to scale the word embeddings by sqrt(d_model).`,name:"scale_embedding"},{anchor:"transformers.TrOCRConfig.use_learned_position_embeddings",description:`<strong>use_learned_position_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to use learned position embeddings. If not, sinusoidal position embeddings will be used.`,name:"use_learned_position_embeddings"},{anchor:"transformers.TrOCRConfig.layernorm_embedding",description:`<strong>layernorm_embedding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to use a layernorm after the word + position embeddings.`,name:"layernorm_embedding"}],source:"https://github.com/huggingface/transformers/blob/vr_30650/src/transformers/models/trocr/configuration_trocr.py#L24"}}),L=new yo({props:{anchor:"transformers.TrOCRConfig.example",$$slots:{default:[Jo]},$$scope:{ctx:J}}}),ge=new G({props:{title:"TrOCRProcessor",local:"transformers.TrOCRProcessor",headingTag:"h2"}}),_e=new I({props:{name:"class transformers.TrOCRProcessor",anchor:"transformers.TrOCRProcessor",parameters:[{name:"image_processor",val:" = None"},{name:"tokenizer",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TrOCRProcessor.image_processor",description:`<strong>image_processor</strong> ([<code>ViTImageProcessor</code>/<code>DeiTImageProcessor</code>], <em>optional</em>) &#x2014;
An instance of [<code>ViTImageProcessor</code>/<code>DeiTImageProcessor</code>]. The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.TrOCRProcessor.tokenizer",description:`<strong>tokenizer</strong> ([<code>RobertaTokenizer</code>/<code>XLMRobertaTokenizer</code>], <em>optional</em>) &#x2014;
An instance of [<code>RobertaTokenizer</code>/<code>XLMRobertaTokenizer</code>]. The tokenizer is a required input.`,name:"tokenizer"}],source:"https://github.com/huggingface/transformers/blob/vr_30650/src/transformers/models/trocr/processing_trocr.py#L25"}}),Te=new I({props:{name:"__call__",anchor:"transformers.TrOCRProcessor.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30650/src/transformers/models/trocr/processing_trocr.py#L64"}}),be=new I({props:{name:"from_pretrained",anchor:"transformers.TrOCRProcessor.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"cache_dir",val:": Union = None"},{name:"force_download",val:": bool = False"},{name:"local_files_only",val:": bool = False"},{name:"token",val:": Union = None"},{name:"revision",val:": str = 'main'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TrOCRProcessor.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained feature_extractor hosted inside a model repo on
huggingface.co.</li>
<li>a path to a <em>directory</em> containing a feature extractor file saved using the
<a href="/docs/transformers/pr_30650/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> method, e.g., <code>./my_model_directory/</code>.</li>
<li>a path or url to a saved feature extractor JSON <em>file</em>, e.g.,
<code>./my_model_directory/preprocessor_config.json</code>.
**kwargs &#x2014;
Additional keyword arguments passed along to both
<a href="/docs/transformers/pr_30650/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.from_pretrained">from_pretrained()</a> and
<code>~tokenization_utils_base.PreTrainedTokenizer.from_pretrained</code>.</li>
</ul>`,name:"pretrained_model_name_or_path"}],source:"https://github.com/huggingface/transformers/blob/vr_30650/src/transformers/processing_utils.py#L412"}}),F=new Mo({props:{$$slots:{default:[Zo]},$$scope:{ctx:J}}}),Me=new I({props:{name:"save_pretrained",anchor:"transformers.TrOCRProcessor.save_pretrained",parameters:[{name:"save_directory",val:""},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TrOCRProcessor.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory where the feature extractor JSON file and the tokenizer files will be saved (directory will
be created if it does not exist).`,name:"save_directory"},{anchor:"transformers.TrOCRProcessor.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"transformers.TrOCRProcessor.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional key word arguments passed along to the <a href="/docs/transformers/pr_30650/en/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30650/src/transformers/processing_utils.py#L168"}}),V=new Mo({props:{$$slots:{default:[Oo]},$$scope:{ctx:J}}}),ye=new I({props:{name:"batch_decode",anchor:"transformers.TrOCRProcessor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30650/src/transformers/models/trocr/processing_trocr.py#L97"}}),we=new I({props:{name:"decode",anchor:"transformers.TrOCRProcessor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30650/src/transformers/models/trocr/processing_trocr.py#L104"}}),ve=new G({props:{title:"TrOCRForCausalLM",local:"transformers.TrOCRForCausalLM",headingTag:"h2"}}),Ce=new I({props:{name:"class transformers.TrOCRForCausalLM",anchor:"transformers.TrOCRForCausalLM",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.TrOCRForCausalLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30650/en/model_doc/trocr#transformers.TrOCRConfig">TrOCRConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/pr_30650/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30650/src/transformers/models/trocr/modeling_trocr.py#L734"}}),ke=new I({props:{name:"forward",anchor:"transformers.TrOCRForCausalLM.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"encoder_attention_mask",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"cross_attn_head_mask",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.TrOCRForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you
provide it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30650/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30650/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30650/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TrOCRForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TrOCRForCausalLM.forward.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong>  (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder. Used in the cross-attention
if the model is configured as a decoder.`,name:"encoder_hidden_states"},{anchor:"transformers.TrOCRForCausalLM.forward.encoder_attention_mask",description:`<strong>encoder_attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on the padding token indices of the encoder input. This mask is used
in the cross-attention if the model is configured as a decoder. Mask values selected in <code>[0, 1]</code>:`,name:"encoder_attention_mask"},{anchor:"transformers.TrOCRForCausalLM.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(decoder_layers, decoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TrOCRForCausalLM.forward.cross_attn_head_mask",description:`<strong>cross_attn_head_mask</strong> (<code>torch.Tensor</code> of shape <code>(decoder_layers, decoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the cross-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"cross_attn_head_mask"},{anchor:"transformers.TrOCRForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of
shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>. The two additional
tensors are only required when the model is used as a decoder in a Sequence to Sequence model.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the
cross-attention blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those
that don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of
all <code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.TrOCRForCausalLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.TrOCRForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding
(see <code>past_key_values</code>).</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>`,name:"use_cache"},{anchor:"transformers.TrOCRForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TrOCRForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more detail.`,name:"output_hidden_states"},{anchor:"transformers.TrOCRForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30650/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_30650/src/transformers/models/trocr/modeling_trocr.py#L772",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_30650/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithCrossAttentions"
>transformers.modeling_outputs.CausalLMOutputWithCrossAttentions</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_30650/en/model_doc/trocr#transformers.TrOCRConfig"
>TrOCRConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Cross attentions weights after the attention softmax, used to compute the weighted average in the
cross-attention heads.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>torch.FloatTensor</code> tuples of length <code>config.n_layers</code>, with each tuple containing the cached key,
value states of the self-attention and the cross-attention layers if model is used in encoder-decoder
setting. Only relevant if <code>config.is_decoder = True</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_30650/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithCrossAttentions"
>transformers.modeling_outputs.CausalLMOutputWithCrossAttentions</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),N=new yo({props:{anchor:"transformers.TrOCRForCausalLM.forward.example",$$slots:{default:[Uo]},$$scope:{ctx:J}}}),Re=new xo({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/trocr.md"}}),{c(){l=a("meta"),v=n(),p=a("p"),b=n(),h(w.$$.fragment),c=n(),h(C.$$.fragment),Be=n(),X=a("p"),X.innerHTML=Gt,He=n(),S=a("p"),S.textContent=Xt,Ne=n(),q=a("p"),q.innerHTML=St,Ee=n(),W=a("img"),Ge=n(),Y=a("small"),Y.innerHTML=Yt,Xe=n(),Q=a("p"),Q.innerHTML=Qt,Se=n(),D=a("p"),D.innerHTML=Dt,qe=n(),h(A.$$.fragment),Ye=n(),K=a("ul"),K.innerHTML=At,Qe=n(),h(ee.$$.fragment),De=n(),te=a("p"),te.textContent=Kt,Ae=n(),h(oe.$$.fragment),Ke=n(),re=a("ul"),re.innerHTML=eo,et=n(),h(ne.$$.fragment),tt=n(),se=a("ul"),se.innerHTML=to,ot=n(),ae=a("p"),ae.textContent=oo,rt=n(),ie=a("ul"),ie.innerHTML=ro,nt=n(),h(le.$$.fragment),st=n(),de=a("p"),de.innerHTML=no,at=n(),ce=a("p"),ce.innerHTML=so,it=n(),me=a("ul"),me.innerHTML=ao,lt=n(),h(pe.$$.fragment),dt=n(),he=a("p"),he.innerHTML=io,ct=n(),h(fe.$$.fragment),mt=n(),R=a("div"),h(ue.$$.fragment),vt=n(),je=a("p"),je.innerHTML=lo,Ct=n(),xe=a("p"),xe.innerHTML=co,kt=n(),h(L.$$.fragment),pt=n(),h(ge.$$.fragment),ht=n(),M=a("div"),h(_e.$$.fragment),Rt=n(),Je=a("p"),Je.textContent=mo,$t=n(),Ze=a("p"),Ze.innerHTML=po,jt=n(),z=a("div"),h(Te.$$.fragment),xt=n(),Oe=a("p"),Oe.innerHTML=ho,Jt=n(),Z=a("div"),h(be.$$.fragment),Zt=n(),Ue=a("p"),Ue.textContent=fo,Ot=n(),h(F.$$.fragment),Ut=n(),O=a("div"),h(Me.$$.fragment),It=n(),Ie=a("p"),Ie.innerHTML=uo,Wt=n(),h(V.$$.fragment),Lt=n(),P=a("div"),h(ye.$$.fragment),zt=n(),We=a("p"),We.innerHTML=go,Ft=n(),B=a("div"),h(we.$$.fragment),Vt=n(),Le=a("p"),Le.innerHTML=_o,ft=n(),h(ve.$$.fragment),ut=n(),$=a("div"),h(Ce.$$.fragment),Pt=n(),ze=a("p"),ze.innerHTML=To,Bt=n(),Fe=a("p"),Fe.innerHTML=bo,Ht=n(),H=a("div"),h(ke.$$.fragment),Nt=n(),h(N.$$.fragment),gt=n(),h(Re.$$.fragment),_t=n(),Pe=a("p"),this.h()},l(e){const t=jo("svelte-u9bgzb",document.head);l=i(t,"META",{name:!0,content:!0}),t.forEach(o),v=s(e),p=i(e,"P",{}),x(p).forEach(o),b=s(e),f(w.$$.fragment,e),c=s(e),f(C.$$.fragment,e),Be=s(e),X=i(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1ueqt35"&&(X.innerHTML=Gt),He=s(e),S=i(e,"P",{"data-svelte-h":!0}),m(S)!=="svelte-vfdo9a"&&(S.textContent=Xt),Ne=s(e),q=i(e,"P",{"data-svelte-h":!0}),m(q)!=="svelte-u8sjcw"&&(q.innerHTML=St),Ee=s(e),W=i(e,"IMG",{src:!0,alt:!0,width:!0}),Ge=s(e),Y=i(e,"SMALL",{"data-svelte-h":!0}),m(Y)!=="svelte-745sv3"&&(Y.innerHTML=Yt),Xe=s(e),Q=i(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-1qnnowp"&&(Q.innerHTML=Qt),Se=s(e),D=i(e,"P",{"data-svelte-h":!0}),m(D)!=="svelte-38zca0"&&(D.innerHTML=Dt),qe=s(e),f(A.$$.fragment,e),Ye=s(e),K=i(e,"UL",{"data-svelte-h":!0}),m(K)!=="svelte-10xobs4"&&(K.innerHTML=At),Qe=s(e),f(ee.$$.fragment,e),De=s(e),te=i(e,"P",{"data-svelte-h":!0}),m(te)!=="svelte-j67pez"&&(te.textContent=Kt),Ae=s(e),f(oe.$$.fragment,e),Ke=s(e),re=i(e,"UL",{"data-svelte-h":!0}),m(re)!=="svelte-14fopzs"&&(re.innerHTML=eo),et=s(e),f(ne.$$.fragment,e),tt=s(e),se=i(e,"UL",{"data-svelte-h":!0}),m(se)!=="svelte-1k3rqn7"&&(se.innerHTML=to),ot=s(e),ae=i(e,"P",{"data-svelte-h":!0}),m(ae)!=="svelte-1wntqpp"&&(ae.textContent=oo),rt=s(e),ie=i(e,"UL",{"data-svelte-h":!0}),m(ie)!=="svelte-16d3ard"&&(ie.innerHTML=ro),nt=s(e),f(le.$$.fragment,e),st=s(e),de=i(e,"P",{"data-svelte-h":!0}),m(de)!=="svelte-m8zjgz"&&(de.innerHTML=no),at=s(e),ce=i(e,"P",{"data-svelte-h":!0}),m(ce)!=="svelte-6ik2kr"&&(ce.innerHTML=so),it=s(e),me=i(e,"UL",{"data-svelte-h":!0}),m(me)!=="svelte-1noonjl"&&(me.innerHTML=ao),lt=s(e),f(pe.$$.fragment,e),dt=s(e),he=i(e,"P",{"data-svelte-h":!0}),m(he)!=="svelte-1iv4swp"&&(he.innerHTML=io),ct=s(e),f(fe.$$.fragment,e),mt=s(e),R=i(e,"DIV",{class:!0});var j=x(R);f(ue.$$.fragment,j),vt=s(j),je=i(j,"P",{"data-svelte-h":!0}),m(je)!=="svelte-o8g77"&&(je.innerHTML=lo),Ct=s(j),xe=i(j,"P",{"data-svelte-h":!0}),m(xe)!=="svelte-1jw32xj"&&(xe.innerHTML=co),kt=s(j),f(L.$$.fragment,j),j.forEach(o),pt=s(e),f(ge.$$.fragment,e),ht=s(e),M=i(e,"DIV",{class:!0});var y=x(M);f(_e.$$.fragment,y),Rt=s(y),Je=i(y,"P",{"data-svelte-h":!0}),m(Je)!=="svelte-ndaubh"&&(Je.textContent=mo),$t=s(y),Ze=i(y,"P",{"data-svelte-h":!0}),m(Ze)!=="svelte-1wv34n1"&&(Ze.innerHTML=po),jt=s(y),z=i(y,"DIV",{class:!0});var $e=x(z);f(Te.$$.fragment,$e),xt=s($e),Oe=i($e,"P",{"data-svelte-h":!0}),m(Oe)!=="svelte-9cxgu"&&(Oe.innerHTML=ho),$e.forEach(o),Jt=s(y),Z=i(y,"DIV",{class:!0});var U=x(Z);f(be.$$.fragment,U),Zt=s(U),Ue=i(U,"P",{"data-svelte-h":!0}),m(Ue)!=="svelte-1cj8dcb"&&(Ue.textContent=fo),Ot=s(U),f(F.$$.fragment,U),U.forEach(o),Ut=s(y),O=i(y,"DIV",{class:!0});var Ve=x(O);f(Me.$$.fragment,Ve),It=s(Ve),Ie=i(Ve,"P",{"data-svelte-h":!0}),m(Ie)!=="svelte-1djuw0l"&&(Ie.innerHTML=uo),Wt=s(Ve),f(V.$$.fragment,Ve),Ve.forEach(o),Lt=s(y),P=i(y,"DIV",{class:!0});var bt=x(P);f(ye.$$.fragment,bt),zt=s(bt),We=i(bt,"P",{"data-svelte-h":!0}),m(We)!=="svelte-h36qfh"&&(We.innerHTML=go),bt.forEach(o),Ft=s(y),B=i(y,"DIV",{class:!0});var Mt=x(B);f(we.$$.fragment,Mt),Vt=s(Mt),Le=i(Mt,"P",{"data-svelte-h":!0}),m(Le)!=="svelte-1likn9z"&&(Le.innerHTML=_o),Mt.forEach(o),y.forEach(o),ft=s(e),f(ve.$$.fragment,e),ut=s(e),$=i(e,"DIV",{class:!0});var E=x($);f(Ce.$$.fragment,E),Pt=s(E),ze=i(E,"P",{"data-svelte-h":!0}),m(ze)!=="svelte-1oemwc2"&&(ze.innerHTML=To),Bt=s(E),Fe=i(E,"P",{"data-svelte-h":!0}),m(Fe)!=="svelte-hswkmf"&&(Fe.innerHTML=bo),Ht=s(E),H=i(E,"DIV",{class:!0});var yt=x(H);f(ke.$$.fragment,yt),Nt=s(yt),f(N.$$.fragment,yt),yt.forEach(o),E.forEach(o),gt=s(e),f(Re.$$.fragment,e),_t=s(e),Pe=i(e,"P",{}),x(Pe).forEach(o),this.h()},h(){k(l,"name","hf:doc:metadata"),k(l,"content",Wo),Co(W.src,qt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/trocr_architecture.jpg")||k(W,"src",qt),k(W,"alt","drawing"),k(W,"width","600"),k(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){d(document.head,l),r(e,v,t),r(e,p,t),r(e,b,t),u(w,e,t),r(e,c,t),u(C,e,t),r(e,Be,t),r(e,X,t),r(e,He,t),r(e,S,t),r(e,Ne,t),r(e,q,t),r(e,Ee,t),r(e,W,t),r(e,Ge,t),r(e,Y,t),r(e,Xe,t),r(e,Q,t),r(e,Se,t),r(e,D,t),r(e,qe,t),u(A,e,t),r(e,Ye,t),r(e,K,t),r(e,Qe,t),u(ee,e,t),r(e,De,t),r(e,te,t),r(e,Ae,t),u(oe,e,t),r(e,Ke,t),r(e,re,t),r(e,et,t),u(ne,e,t),r(e,tt,t),r(e,se,t),r(e,ot,t),r(e,ae,t),r(e,rt,t),r(e,ie,t),r(e,nt,t),u(le,e,t),r(e,st,t),r(e,de,t),r(e,at,t),r(e,ce,t),r(e,it,t),r(e,me,t),r(e,lt,t),u(pe,e,t),r(e,dt,t),r(e,he,t),r(e,ct,t),u(fe,e,t),r(e,mt,t),r(e,R,t),u(ue,R,null),d(R,vt),d(R,je),d(R,Ct),d(R,xe),d(R,kt),u(L,R,null),r(e,pt,t),u(ge,e,t),r(e,ht,t),r(e,M,t),u(_e,M,null),d(M,Rt),d(M,Je),d(M,$t),d(M,Ze),d(M,jt),d(M,z),u(Te,z,null),d(z,xt),d(z,Oe),d(M,Jt),d(M,Z),u(be,Z,null),d(Z,Zt),d(Z,Ue),d(Z,Ot),u(F,Z,null),d(M,Ut),d(M,O),u(Me,O,null),d(O,It),d(O,Ie),d(O,Wt),u(V,O,null),d(M,Lt),d(M,P),u(ye,P,null),d(P,zt),d(P,We),d(M,Ft),d(M,B),u(we,B,null),d(B,Vt),d(B,Le),r(e,ft,t),u(ve,e,t),r(e,ut,t),r(e,$,t),u(Ce,$,null),d($,Pt),d($,ze),d($,Bt),d($,Fe),d($,Ht),d($,H),u(ke,H,null),d(H,Nt),u(N,H,null),r(e,gt,t),u(Re,e,t),r(e,_t,t),r(e,Pe,t),Tt=!0},p(e,[t]){const j={};t&2&&(j.$$scope={dirty:t,ctx:e}),L.$set(j);const y={};t&2&&(y.$$scope={dirty:t,ctx:e}),F.$set(y);const $e={};t&2&&($e.$$scope={dirty:t,ctx:e}),V.$set($e);const U={};t&2&&(U.$$scope={dirty:t,ctx:e}),N.$set(U)},i(e){Tt||(g(w.$$.fragment,e),g(C.$$.fragment,e),g(A.$$.fragment,e),g(ee.$$.fragment,e),g(oe.$$.fragment,e),g(ne.$$.fragment,e),g(le.$$.fragment,e),g(pe.$$.fragment,e),g(fe.$$.fragment,e),g(ue.$$.fragment,e),g(L.$$.fragment,e),g(ge.$$.fragment,e),g(_e.$$.fragment,e),g(Te.$$.fragment,e),g(be.$$.fragment,e),g(F.$$.fragment,e),g(Me.$$.fragment,e),g(V.$$.fragment,e),g(ye.$$.fragment,e),g(we.$$.fragment,e),g(ve.$$.fragment,e),g(Ce.$$.fragment,e),g(ke.$$.fragment,e),g(N.$$.fragment,e),g(Re.$$.fragment,e),Tt=!0)},o(e){_(w.$$.fragment,e),_(C.$$.fragment,e),_(A.$$.fragment,e),_(ee.$$.fragment,e),_(oe.$$.fragment,e),_(ne.$$.fragment,e),_(le.$$.fragment,e),_(pe.$$.fragment,e),_(fe.$$.fragment,e),_(ue.$$.fragment,e),_(L.$$.fragment,e),_(ge.$$.fragment,e),_(_e.$$.fragment,e),_(Te.$$.fragment,e),_(be.$$.fragment,e),_(F.$$.fragment,e),_(Me.$$.fragment,e),_(V.$$.fragment,e),_(ye.$$.fragment,e),_(we.$$.fragment,e),_(ve.$$.fragment,e),_(Ce.$$.fragment,e),_(ke.$$.fragment,e),_(N.$$.fragment,e),_(Re.$$.fragment,e),Tt=!1},d(e){e&&(o(v),o(p),o(b),o(c),o(Be),o(X),o(He),o(S),o(Ne),o(q),o(Ee),o(W),o(Ge),o(Y),o(Xe),o(Q),o(Se),o(D),o(qe),o(Ye),o(K),o(Qe),o(De),o(te),o(Ae),o(Ke),o(re),o(et),o(tt),o(se),o(ot),o(ae),o(rt),o(ie),o(nt),o(st),o(de),o(at),o(ce),o(it),o(me),o(lt),o(dt),o(he),o(ct),o(mt),o(R),o(pt),o(ht),o(M),o(ft),o(ut),o($),o(gt),o(_t),o(Pe)),o(l),T(w,e),T(C,e),T(A,e),T(ee,e),T(oe,e),T(ne,e),T(le,e),T(pe,e),T(fe,e),T(ue),T(L),T(ge,e),T(_e),T(Te),T(be),T(F),T(Me),T(V),T(ye),T(we),T(ve,e),T(Ce),T(ke),T(N),T(Re,e)}}}const Wo='{"title":"TrOCR","local":"trocr","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2},{"title":"TrOCRConfig","local":"transformers.TrOCRConfig","sections":[],"depth":2},{"title":"TrOCRProcessor","local":"transformers.TrOCRProcessor","sections":[],"depth":2},{"title":"TrOCRForCausalLM","local":"transformers.TrOCRForCausalLM","sections":[],"depth":2}],"depth":1}';function Lo(J){return ko(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Go extends Ro{constructor(l){super(),$o(this,l,Lo,Io,vo,{})}}export{Go as component};
