import{s as Ct,o as Pt,n as we}from"../chunks/scheduler.25b97de1.js";import{S as xt,i as zt,g as h,s as i,r as y,A as jt,h as m,f as r,c as d,j as Q,u as T,x as _,k as A,y as c,a as l,v,d as k,t as w,w as M}from"../chunks/index.d9030fc9.js";import{T as De}from"../chunks/Tip.baa67368.js";import{D as ue}from"../chunks/Docstring.e257edda.js";import{C as tt}from"../chunks/CodeBlock.e6cd0d95.js";import{F as Ft,M as Lt}from"../chunks/Markdown.7217f838.js";import{E as ft}from"../chunks/ExampleCodeBlock.20db4b6e.js";import{H as Ae,E as It}from"../chunks/EditOnGithub.91d95064.js";function Ut(C){let t,f="Phi-3 has been integrated in the development version (4.40.0.dev) of <code>transformers</code>. Until the official version is released through <code>pip</code>, ensure that you are doing one of the following:",a,o,g="<li><p>When loading the model, ensure that <code>trust_remote_code=True</code> is passed as an argument of the <code>from_pretrained()</code> function.</p></li> <li><p>Update your local <code>transformers</code> to the development version: <code>pip uninstall -y transformers &amp;&amp; pip install git+https://github.com/huggingface/transformers</code>. The previous command is an alternative to cloning and installing from the source.</p></li>";return{c(){t=h("p"),t.innerHTML=f,a=i(),o=h("ul"),o.innerHTML=g},l(s){t=m(s,"P",{"data-svelte-h":!0}),_(t)!=="svelte-c51ot7"&&(t.innerHTML=f),a=d(s),o=m(s,"UL",{"data-svelte-h":!0}),_(o)!=="svelte-1ysocqo"&&(o.innerHTML=g)},m(s,b){l(s,t,b),l(s,a,b),l(s,o,b)},p:we,d(s){s&&(r(t),r(a),r(o))}}}function Wt(C){let t,f="Example:",a,o,g;return o=new tt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBoaTNNb2RlbCUyQyUyMFBoaTNDb25maWclMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwUGhpLTMlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwUGhpM0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGUGhpLTMtbWluaS00ay1pbnN0cnVjdCUyMiklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbW9kZWwlMjBmcm9tJTIwdGhlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwUGhpM01vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Phi3Model, Phi3Config

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Phi-3 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = Phi3Config.from_pretrained(<span class="hljs-string">&quot;microsoft/Phi-3-mini-4k-instruct&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Phi3Model(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){t=h("p"),t.textContent=f,a=i(),y(o.$$.fragment)},l(s){t=m(s,"P",{"data-svelte-h":!0}),_(t)!=="svelte-11lpom8"&&(t.textContent=f),a=d(s),T(o.$$.fragment,s)},m(s,b){l(s,t,b),l(s,a,b),v(o,s,b),g=!0},p:we,i(s){g||(k(o.$$.fragment,s),g=!0)},o(s){w(o.$$.fragment,s),g=!1},d(s){s&&(r(t),r(a)),M(o,s)}}}function Nt(C){let t,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=h("p"),t.innerHTML=f},l(a){t=m(a,"P",{"data-svelte-h":!0}),_(t)!=="svelte-fincs2"&&(t.innerHTML=f)},m(a,o){l(a,t,o)},p:we,d(a){a&&r(t)}}}function Gt(C){let t,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=h("p"),t.innerHTML=f},l(a){t=m(a,"P",{"data-svelte-h":!0}),_(t)!=="svelte-fincs2"&&(t.innerHTML=f)},m(a,o){l(a,t,o)},p:we,d(a){a&&r(t)}}}function Jt(C){let t,f="Example:",a,o,g;return o=new tt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBQaGkzRm9yQ2F1c2FsTE0lMEElMEFtb2RlbCUyMCUzRCUyMFBoaTNGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGcGhpLTMtbWluaS00ay1pbnN0cnVjdCUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZwaGktMy1taW5pLTRrLWluc3RydWN0JTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMlRoaXMlMjBpcyUyMGFuJTIwZXhhbXBsZSUyMHNjcmlwdCUyMC4lMjIlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocHJvbXB0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBHZW5lcmF0ZSUwQWdlbmVyYXRlX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cy5pbnB1dF9pZHMlMkMlMjBtYXhfbGVuZ3RoJTNEMzApJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZV9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSUyQyUyMGNsZWFuX3VwX3Rva2VuaXphdGlvbl9zcGFjZXMlM0RGYWxzZSklNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, Phi3ForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = Phi3ForCausalLM.from_pretrained(<span class="hljs-string">&quot;microsoft/phi-3-mini-4k-instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;microsoft/phi-3-mini-4k-instruct&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;This is an example script .&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(inputs.input_ids, max_length=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;This is an example script .\\n Certainly! Below is a sample script that demonstrates a simple task, such as calculating the sum&#x27;</span>`,wrap:!1}}),{c(){t=h("p"),t.textContent=f,a=i(),y(o.$$.fragment)},l(s){t=m(s,"P",{"data-svelte-h":!0}),_(t)!=="svelte-11lpom8"&&(t.textContent=f),a=d(s),T(o.$$.fragment,s)},m(s,b){l(s,t,b),l(s,a,b),v(o,s,b),g=!0},p:we,i(s){g||(k(o.$$.fragment,s),g=!0)},o(s){w(o.$$.fragment,s),g=!1},d(s){s&&(r(t),r(a)),M(o,s)}}}function Bt(C){let t,f=`Most generation-controlling parameters are set in <code>generation_config</code> which, if not passed, will be set to the
model’s default generation configuration. You can override any <code>generation_config</code> by passing the corresponding
parameters to generate(), e.g. <code>.generate(inputs, num_beams=4, do_sample=True)</code>.`,a,o,g=`For an overview of generation strategies and code examples, check out the <a href="../generation_strategies">following
guide</a>.`;return{c(){t=h("p"),t.innerHTML=f,a=i(),o=h("p"),o.innerHTML=g},l(s){t=m(s,"P",{"data-svelte-h":!0}),_(t)!=="svelte-1c5u34l"&&(t.innerHTML=f),a=d(s),o=m(s,"P",{"data-svelte-h":!0}),_(o)!=="svelte-fvlq1g"&&(o.innerHTML=g)},m(s,b){l(s,t,b),l(s,a,b),l(s,o,b)},p:we,d(s){s&&(r(t),r(a),r(o))}}}function qt(C){let t,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=h("p"),t.innerHTML=f},l(a){t=m(a,"P",{"data-svelte-h":!0}),_(t)!=="svelte-fincs2"&&(t.innerHTML=f)},m(a,o){l(a,t,o)},p:we,d(a){a&&r(t)}}}function Zt(C){let t,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=h("p"),t.innerHTML=f},l(a){t=m(a,"P",{"data-svelte-h":!0}),_(t)!=="svelte-fincs2"&&(t.innerHTML=f)},m(a,o){l(a,t,o)},p:we,d(a){a&&r(t)}}}function Ht(C){let t,f="Example:",a,o,g;return o=new tt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBQaGkzRm9yVG9rZW5DbGFzc2lmaWNhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGUGhpLTMtbWluaS00ay1pbnN0cnVjdCUyMiklMEFtb2RlbCUyMCUzRCUyMFBoaTNGb3JUb2tlbkNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZQaGktMy1taW5pLTRrLWluc3RydWN0JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjAlMjJIdWdnaW5nRmFjZSUyMGlzJTIwYSUyMGNvbXBhbnklMjBiYXNlZCUyMGluJTIwUGFyaXMlMjBhbmQlMjBOZXclMjBZb3JrJTIyJTJDJTIwYWRkX3NwZWNpYWxfdG9rZW5zJTNERmFsc2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTBBKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJlZGljdGVkX3Rva2VuX2NsYXNzX2lkcyUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoLTEpJTBBJTBBJTIzJTIwTm90ZSUyMHRoYXQlMjB0b2tlbnMlMjBhcmUlMjBjbGFzc2lmaWVkJTIwcmF0aGVyJTIwdGhlbiUyMGlucHV0JTIwd29yZHMlMjB3aGljaCUyMG1lYW5zJTIwdGhhdCUwQSUyMyUyMHRoZXJlJTIwbWlnaHQlMjBiZSUyMG1vcmUlMjBwcmVkaWN0ZWQlMjB0b2tlbiUyMGNsYXNzZXMlMjB0aGFuJTIwd29yZHMuJTBBJTIzJTIwTXVsdGlwbGUlMjB0b2tlbiUyMGNsYXNzZXMlMjBtaWdodCUyMGFjY291bnQlMjBmb3IlMjB0aGUlMjBzYW1lJTIwd29yZCUwQXByZWRpY3RlZF90b2tlbnNfY2xhc3NlcyUyMCUzRCUyMCU1Qm1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QnQuaXRlbSgpJTVEJTIwZm9yJTIwdCUyMGluJTIwcHJlZGljdGVkX3Rva2VuX2NsYXNzX2lkcyU1QjAlNUQlNUQlMEElMEFsYWJlbHMlMjAlM0QlMjBwcmVkaWN0ZWRfdG9rZW5fY2xhc3NfaWRzJTBBbG9zcyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwbGFiZWxzJTNEbGFiZWxzKS5sb3Nz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, Phi3ForTokenClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;microsoft/Phi-3-mini-4k-instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Phi3ForTokenClassification.from_pretrained(<span class="hljs-string">&quot;microsoft/Phi-3-mini-4k-instruct&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;HuggingFace is a company based in Paris and New York&quot;</span>, add_special_tokens=<span class="hljs-literal">False</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_token_class_ids = logits.argmax(-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Note that tokens are classified rather then input words which means that</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># there might be more predicted token classes than words.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Multiple token classes might account for the same word</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_tokens_classes = [model.config.id2label[t.item()] <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> predicted_token_class_ids[<span class="hljs-number">0</span>]]

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = predicted_token_class_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`,wrap:!1}}),{c(){t=h("p"),t.textContent=f,a=i(),y(o.$$.fragment)},l(s){t=m(s,"P",{"data-svelte-h":!0}),_(t)!=="svelte-11lpom8"&&(t.textContent=f),a=d(s),T(o.$$.fragment,s)},m(s,b){l(s,t,b),l(s,a,b),v(o,s,b),g=!0},p:we,i(s){g||(k(o.$$.fragment,s),g=!0)},o(s){w(o.$$.fragment,s),g=!1},d(s){s&&(r(t),r(a)),M(o,s)}}}function St(C){let t,f="## Phi3Model[[transformers.Phi3Model]]",a,o,g,s,b,je=`The bare Phi-3 model outputting raw hidden-states without any specific head on top.
This model inherits from <a href="/docs/transformers/pr_30650/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,D,fe,Fe=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Y,K,re="Transformer decoder consisting of <em>config.num_hidden_layers</em> layers. Each layer is a <code>Phi3DecoderLayer</code>",Ge,F,L,Je,ee,ie='The <a href="/docs/transformers/pr_30650/en/model_doc/phi3#transformers.Phi3Model">Phi3Model</a> forward method, overrides the <code>__call__</code> special method.',Be,N,Z,H,de="## Phi3ForCausalLM[[transformers.Phi3ForCausalLM]]",Le,j,I,Me,x,S,te,ne,le='The <a href="/docs/transformers/pr_30650/en/model_doc/phi3#transformers.Phi3ForCausalLM">Phi3ForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',$e,P,oe,O,ce,G,se,pe,ge,qe="Generates sequences of token ids for models with a language modeling head.",X,J,B,E,he="## Phi3ForSequenceClassification[[transformers.Phi3ForSequenceClassification]]",_e,$,R,e,p,W='The <a href="/docs/transformers/pr_30650/en/model_doc/phi3#transformers.Phi3Model">Phi3Model</a> with a sequence classification head on top (linear layer).',Ze,be,gt=`<a href="/docs/transformers/pr_30650/en/model_doc/phi3#transformers.Phi3ForSequenceClassification">Phi3ForSequenceClassification</a> uses the last token in order to do the classification, as other causal models
(e.g. GPT-2) do.`,nt,He,_t=`Since it does classification on the last token, it requires to know the position of the last token. If a
<code>pad_token_id</code> is defined in the configuration, it finds the last token that is not a padding token in each row. If
no <code>pad_token_id</code> is defined, it simply takes the last value in each row of the batch. Since it cannot guess the
padding tokens when <code>inputs_embeds</code> are passed instead of <code>input_ids</code>, it does the same (take the last value in
each row of the batch).`,ot,Se,bt=`This model inherits from <a href="/docs/transformers/pr_30650/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,st,Oe,yt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,at,me,Ie,rt,Xe,Tt='The <a href="/docs/transformers/pr_30650/en/model_doc/phi3#transformers.Phi3ForSequenceClassification">Phi3ForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',it,Ce,Ye,Ue,vt="## Phi3ForTokenClassification[[transformers.Phi3ForTokenClassification]]",Ke,U,We,dt,Ee,kt=`<a href="/docs/transformers/pr_30650/en/model_doc/phi3#transformers.Phi3Model">Phi3Model</a> with a token classification head on top (a linear layer on top of the hidden-states output) e.g. for
Named-Entity-Recognition (NER) tasks.`,lt,Re,wt=`This model inherits from <a href="/docs/transformers/pr_30650/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ct,Ve,Mt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,pt,V,Ne,ht,Qe,$t='The <a href="/docs/transformers/pr_30650/en/model_doc/phi3#transformers.Phi3ForTokenClassification">Phi3ForTokenClassification</a> forward method, overrides the <code>__call__</code> special method.',mt,Pe,ut,xe,et;return g=new ue({props:{name:"class transformers.Phi3Model",anchor:"transformers.Phi3Model",parameters:[{name:"config",val:": Phi3Config"}],parametersDescription:[{anchor:"transformers.Phi3Model.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30650/en/model_doc/phi3#transformers.Phi3Config">Phi3Config</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/pr_30650/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.
config &#x2014; Phi3Config`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30650/src/transformers/models/phi3/modeling_phi3.py#L998"}}),L=new ue({props:{name:"forward",anchor:"transformers.Phi3Model.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Phi3Model.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30650/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30650/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30650/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Phi3Model.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30650/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30650/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30650/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.Phi3Model.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.Phi3Model.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/pr_30650/en/internal/generation_utils#transformers.Cache">Cache</a> instance;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Phi3Model.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Phi3Model.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.Phi3Model.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Phi3Model.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Phi3Model.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30650/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_30650/src/transformers/models/phi3/modeling_phi3.py#L1033"}}),N=new De({props:{$$slots:{default:[Nt]},$$scope:{ctx:C}}}),I=new ue({props:{name:"class transformers.Phi3ForCausalLM",anchor:"transformers.Phi3ForCausalLM",parameters:[{name:"config",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30650/src/transformers/models/phi3/modeling_phi3.py#L1171"}}),S=new ue({props:{name:"forward",anchor:"transformers.Phi3ForCausalLM.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Phi3ForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30650/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30650/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30650/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Phi3ForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30650/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30650/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30650/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.Phi3ForCausalLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.Phi3ForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/pr_30650/en/internal/generation_utils#transformers.Cache">Cache</a> instance;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Phi3ForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Phi3ForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.Phi3ForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Phi3ForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Phi3ForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30650/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.</p>
<p>Args &#x2014;
labels (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>):
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_30650/src/transformers/models/phi3/modeling_phi3.py#L1209",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_30650/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_30650/en/model_doc/phi3#transformers.Phi3Config"
>Phi3Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_30650/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),P=new De({props:{$$slots:{default:[Gt]},$$scope:{ctx:C}}}),O=new ft({props:{anchor:"transformers.Phi3ForCausalLM.forward.example",$$slots:{default:[Jt]},$$scope:{ctx:C}}}),se=new ue({props:{name:"generate",anchor:"transformers.Phi3ForCausalLM.generate",parameters:[{name:"inputs",val:": Optional = None"},{name:"generation_config",val:": Optional = None"},{name:"logits_processor",val:": Optional = None"},{name:"stopping_criteria",val:": Optional = None"},{name:"prefix_allowed_tokens_fn",val:": Optional = None"},{name:"synced_gpus",val:": Optional = None"},{name:"assistant_model",val:": Optional = None"},{name:"streamer",val:": Optional = None"},{name:"negative_prompt_ids",val:": Optional = None"},{name:"negative_prompt_attention_mask",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Phi3ForCausalLM.generate.inputs",description:`<strong>inputs</strong> (<code>torch.Tensor</code> of varying shape depending on the modality, <em>optional</em>) &#x2014;
The sequence used as a prompt for the generation or as model inputs to the encoder. If <code>None</code> the
method initializes it with <code>bos_token_id</code> and a batch size of 1. For decoder-only models <code>inputs</code>
should be in the format of <code>input_ids</code>. For encoder-decoder models <em>inputs</em> can represent any of
<code>input_ids</code>, <code>input_values</code>, <code>input_features</code>, or <code>pixel_values</code>.`,name:"inputs"},{anchor:"transformers.Phi3ForCausalLM.generate.generation_config",description:`<strong>generation_config</strong> (<a href="/docs/transformers/pr_30650/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>, <em>optional</em>) &#x2014;
The generation configuration to be used as base parametrization for the generation call. <code>**kwargs</code>
passed to generate matching the attributes of <code>generation_config</code> will override them. If
<code>generation_config</code> is not provided, the default will be used, which has the following loading
priority: 1) from the <code>generation_config.json</code> model file, if it exists; 2) from the model
configuration. Please note that unspecified parameters will inherit <a href="/docs/transformers/pr_30650/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>&#x2019;s
default values, whose documentation should be checked to parameterize generation.`,name:"generation_config"},{anchor:"transformers.Phi3ForCausalLM.generate.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
Custom logits processors that complement the default logits processors built from arguments and
generation config. If a logit processor is passed that is already created with the arguments or a
generation config an error is thrown. This feature is intended for advanced users.`,name:"logits_processor"},{anchor:"transformers.Phi3ForCausalLM.generate.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
Custom stopping criteria that complements the default stopping criteria built from arguments and a
generation config. If a stopping criteria is passed that is already created with the arguments or a
generation config an error is thrown. If your stopping criteria depends on the <code>scores</code> input, make
sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>. This feature is
intended for advanced users.`,name:"stopping_criteria"},{anchor:"transformers.Phi3ForCausalLM.generate.prefix_allowed_tokens_fn",description:`<strong>prefix_allowed_tokens_fn</strong> (<code>Callable[[int, torch.Tensor], List[int]]</code>, <em>optional</em>) &#x2014;
If provided, this function constraints the beam search to allowed tokens only at each step. If not
provided no constraint is applied. This function takes 2 arguments: the batch ID <code>batch_id</code> and
<code>input_ids</code>. It has to return a list with the allowed tokens for the next generation step conditioned
on the batch ID <code>batch_id</code> and the previously generated tokens <code>inputs_ids</code>. This argument is useful
for constrained generation conditioned on the prefix, as described in <a href="https://arxiv.org/abs/2010.00904" rel="nofollow">Autoregressive Entity
Retrieval</a>.`,name:"prefix_allowed_tokens_fn"},{anchor:"transformers.Phi3ForCausalLM.generate.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to continue running the while loop until max_length. Unless overridden this flag will be set to
<code>True</code> under DeepSpeed ZeRO Stage 3 multiple GPUs environment to avoid hanging if one GPU finished
generating before other GPUs. Otherwise it&#x2019;ll be set to <code>False</code>.`,name:"synced_gpus"},{anchor:"transformers.Phi3ForCausalLM.generate.assistant_model",description:`<strong>assistant_model</strong> (<code>PreTrainedModel</code>, <em>optional</em>) &#x2014;
An assistant model that can be used to accelerate generation. The assistant model must have the exact
same tokenizer. The acceleration is achieved when forecasting candidate tokens with the assistent model
is much faster than running generation with the model you&#x2019;re calling generate from. As such, the
assistant model should be much smaller.`,name:"assistant_model"},{anchor:"transformers.Phi3ForCausalLM.generate.streamer",description:`<strong>streamer</strong> (<code>BaseStreamer</code>, <em>optional</em>) &#x2014;
Streamer object that will be used to stream the generated sequences. Generated tokens are passed
through <code>streamer.put(token_ids)</code> and the streamer is responsible for any further processing.`,name:"streamer"},{anchor:"transformers.Phi3ForCausalLM.generate.negative_prompt_ids",description:`<strong>negative_prompt_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
The negative prompt needed for some processors such as CFG. The batch size must match the input batch
size. This is an experimental feature, subject to breaking API changes in future versions.`,name:"negative_prompt_ids"},{anchor:"transformers.Phi3ForCausalLM.generate.negative_prompt_attention_mask",description:`<strong>negative_prompt_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Attention_mask for <code>negative_prompt_ids</code>.`,name:"negative_prompt_attention_mask"},{anchor:"transformers.Phi3ForCausalLM.generate.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Ad hoc parametrization of <code>generation_config</code> and/or additional model-specific kwargs that will be
forwarded to the <code>forward</code> function of the model. If the model is an encoder-decoder model, encoder
specific kwargs should not be prefixed and decoder specific kwargs should be prefixed with <em>decoder_</em>.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30650/src/transformers/generation/utils.py#L1531",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_30650/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> (if <code>return_dict_in_generate=True</code>
or when <code>config.return_dict_in_generate=True</code>) or a <code>torch.LongTensor</code>.</p>
<p>If the model is <em>not</em> an encoder-decoder model (<code>model.config.is_encoder_decoder=False</code>), the possible
<a
  href="/docs/transformers/pr_30650/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/pr_30650/en/internal/generation_utils#transformers.generation.GenerateDecoderOnlyOutput"
>GenerateDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/pr_30650/en/internal/generation_utils#transformers.generation.GenerateBeamDecoderOnlyOutput"
>GenerateBeamDecoderOnlyOutput</a></li>
</ul>
<p>If the model is an encoder-decoder model (<code>model.config.is_encoder_decoder=True</code>), the possible
<a
  href="/docs/transformers/pr_30650/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/pr_30650/en/internal/generation_utils#transformers.generation.GenerateEncoderDecoderOutput"
>GenerateEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/pr_30650/en/internal/generation_utils#transformers.generation.GenerateBeamEncoderDecoderOutput"
>GenerateBeamEncoderDecoderOutput</a></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_30650/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> or <code>torch.LongTensor</code></p>
`}}),J=new De({props:{warning:!0,$$slots:{default:[Bt]},$$scope:{ctx:C}}}),R=new ue({props:{name:"class transformers.Phi3ForSequenceClassification",anchor:"transformers.Phi3ForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.Phi3ForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30650/en/model_doc/phi3#transformers.Phi3Config">Phi3Config</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/pr_30650/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30650/src/transformers/models/phi3/modeling_phi3.py#L1364"}}),Ie=new ue({props:{name:"forward",anchor:"transformers.Phi3ForSequenceClassification.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Union = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Phi3ForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30650/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30650/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30650/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Phi3ForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30650/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30650/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30650/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.Phi3ForSequenceClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.Phi3ForSequenceClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/pr_30650/en/internal/generation_utils#transformers.Cache">Cache</a> instance;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Phi3ForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Phi3ForSequenceClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.Phi3ForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Phi3ForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Phi3ForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30650/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Phi3ForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_30650/src/transformers/models/phi3/modeling_phi3.py#L1396"}}),Ce=new De({props:{$$slots:{default:[qt]},$$scope:{ctx:C}}}),We=new ue({props:{name:"class transformers.Phi3ForTokenClassification",anchor:"transformers.Phi3ForTokenClassification",parameters:[{name:"config",val:": Phi3Config"}],parametersDescription:[{anchor:"transformers.Phi3ForTokenClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30650/en/model_doc/phi3#transformers.Phi3Config">Phi3Config</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/pr_30650/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30650/src/transformers/models/phi3/modeling_phi3.py#L1488"}}),Ne=new ue({props:{name:"forward",anchor:"transformers.Phi3ForTokenClassification.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"**deprecated_arguments",val:""}],parametersDescription:[{anchor:"transformers.Phi3ForTokenClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30650/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30650/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30650/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Phi3ForTokenClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30650/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30650/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30650/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.Phi3ForTokenClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.Phi3ForTokenClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/pr_30650/en/internal/generation_utils#transformers.Cache">Cache</a> instance;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Phi3ForTokenClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Phi3ForTokenClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.Phi3ForTokenClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Phi3ForTokenClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Phi3ForTokenClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30650/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Phi3ForTokenClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_30650/src/transformers/models/phi3/modeling_phi3.py#L1514",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_30650/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_30650/en/model_doc/phi3#transformers.Phi3Config"
>Phi3Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided)  — Classification loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>) — Classification scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_30650/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Pe=new De({props:{$$slots:{default:[Zt]},$$scope:{ctx:C}}}),xe=new ft({props:{anchor:"transformers.Phi3ForTokenClassification.forward.example",$$slots:{default:[Ht]},$$scope:{ctx:C}}}),{c(){t=h("p"),t.textContent=f,a=i(),o=h("div"),y(g.$$.fragment),s=i(),b=h("p"),b.innerHTML=je,D=i(),fe=h("p"),fe.innerHTML=Fe,Y=i(),K=h("p"),K.innerHTML=re,Ge=i(),F=h("div"),y(L.$$.fragment),Je=i(),ee=h("p"),ee.innerHTML=ie,Be=i(),y(N.$$.fragment),Z=i(),H=h("p"),H.textContent=de,Le=i(),j=h("div"),y(I.$$.fragment),Me=i(),x=h("div"),y(S.$$.fragment),te=i(),ne=h("p"),ne.innerHTML=le,$e=i(),y(P.$$.fragment),oe=i(),y(O.$$.fragment),ce=i(),G=h("div"),y(se.$$.fragment),pe=i(),ge=h("p"),ge.textContent=qe,X=i(),y(J.$$.fragment),B=i(),E=h("p"),E.textContent=he,_e=i(),$=h("div"),y(R.$$.fragment),e=i(),p=h("p"),p.innerHTML=W,Ze=i(),be=h("p"),be.innerHTML=gt,nt=i(),He=h("p"),He.innerHTML=_t,ot=i(),Se=h("p"),Se.innerHTML=bt,st=i(),Oe=h("p"),Oe.innerHTML=yt,at=i(),me=h("div"),y(Ie.$$.fragment),rt=i(),Xe=h("p"),Xe.innerHTML=Tt,it=i(),y(Ce.$$.fragment),Ye=i(),Ue=h("p"),Ue.textContent=vt,Ke=i(),U=h("div"),y(We.$$.fragment),dt=i(),Ee=h("p"),Ee.innerHTML=kt,lt=i(),Re=h("p"),Re.innerHTML=wt,ct=i(),Ve=h("p"),Ve.innerHTML=Mt,pt=i(),V=h("div"),y(Ne.$$.fragment),ht=i(),Qe=h("p"),Qe.innerHTML=$t,mt=i(),y(Pe.$$.fragment),ut=i(),y(xe.$$.fragment),this.h()},l(n){t=m(n,"P",{"data-svelte-h":!0}),_(t)!=="svelte-jpbq18"&&(t.textContent=f),a=d(n),o=m(n,"DIV",{class:!0});var u=Q(o);T(g.$$.fragment,u),s=d(u),b=m(u,"P",{"data-svelte-h":!0}),_(b)!=="svelte-16scgjt"&&(b.innerHTML=je),D=d(u),fe=m(u,"P",{"data-svelte-h":!0}),_(fe)!=="svelte-1ydu1el"&&(fe.innerHTML=Fe),Y=d(u),K=m(u,"P",{"data-svelte-h":!0}),_(K)!=="svelte-1njzjq3"&&(K.innerHTML=re),Ge=d(u),F=m(u,"DIV",{class:!0});var ye=Q(F);T(L.$$.fragment,ye),Je=d(ye),ee=m(ye,"P",{"data-svelte-h":!0}),_(ee)!=="svelte-39dwt7"&&(ee.innerHTML=ie),Be=d(ye),T(N.$$.fragment,ye),ye.forEach(r),u.forEach(r),Z=d(n),H=m(n,"P",{"data-svelte-h":!0}),_(H)!=="svelte-1t2126o"&&(H.textContent=de),Le=d(n),j=m(n,"DIV",{class:!0});var Te=Q(j);T(I.$$.fragment,Te),Me=d(Te),x=m(Te,"DIV",{class:!0});var ae=Q(x);T(S.$$.fragment,ae),te=d(ae),ne=m(ae,"P",{"data-svelte-h":!0}),_(ne)!=="svelte-3zyxwn"&&(ne.innerHTML=le),$e=d(ae),T(P.$$.fragment,ae),oe=d(ae),T(O.$$.fragment,ae),ae.forEach(r),ce=d(Te),G=m(Te,"DIV",{class:!0});var ve=Q(G);T(se.$$.fragment,ve),pe=d(ve),ge=m(ve,"P",{"data-svelte-h":!0}),_(ge)!=="svelte-s5ko3x"&&(ge.textContent=qe),X=d(ve),T(J.$$.fragment,ve),ve.forEach(r),Te.forEach(r),B=d(n),E=m(n,"P",{"data-svelte-h":!0}),_(E)!=="svelte-fgot0g"&&(E.textContent=he),_e=d(n),$=m(n,"DIV",{class:!0});var z=Q($);T(R.$$.fragment,z),e=d(z),p=m(z,"P",{"data-svelte-h":!0}),_(p)!=="svelte-13gno0l"&&(p.innerHTML=W),Ze=d(z),be=m(z,"P",{"data-svelte-h":!0}),_(be)!=="svelte-1ve8uwi"&&(be.innerHTML=gt),nt=d(z),He=m(z,"P",{"data-svelte-h":!0}),_(He)!=="svelte-10ugs3m"&&(He.innerHTML=_t),ot=d(z),Se=m(z,"P",{"data-svelte-h":!0}),_(Se)!=="svelte-6yf91o"&&(Se.innerHTML=bt),st=d(z),Oe=m(z,"P",{"data-svelte-h":!0}),_(Oe)!=="svelte-1ydu1el"&&(Oe.innerHTML=yt),at=d(z),me=m(z,"DIV",{class:!0});var ke=Q(me);T(Ie.$$.fragment,ke),rt=d(ke),Xe=m(ke,"P",{"data-svelte-h":!0}),_(Xe)!=="svelte-1j6xiwf"&&(Xe.innerHTML=Tt),it=d(ke),T(Ce.$$.fragment,ke),ke.forEach(r),z.forEach(r),Ye=d(n),Ue=m(n,"P",{"data-svelte-h":!0}),_(Ue)!=="svelte-1x5megw"&&(Ue.textContent=vt),Ke=d(n),U=m(n,"DIV",{class:!0});var q=Q(U);T(We.$$.fragment,q),dt=d(q),Ee=m(q,"P",{"data-svelte-h":!0}),_(Ee)!=="svelte-th5s7t"&&(Ee.innerHTML=kt),lt=d(q),Re=m(q,"P",{"data-svelte-h":!0}),_(Re)!=="svelte-6yf91o"&&(Re.innerHTML=wt),ct=d(q),Ve=m(q,"P",{"data-svelte-h":!0}),_(Ve)!=="svelte-1ydu1el"&&(Ve.innerHTML=Mt),pt=d(q),V=m(q,"DIV",{class:!0});var ze=Q(V);T(Ne.$$.fragment,ze),ht=d(ze),Qe=m(ze,"P",{"data-svelte-h":!0}),_(Qe)!=="svelte-1k32udr"&&(Qe.innerHTML=$t),mt=d(ze),T(Pe.$$.fragment,ze),ut=d(ze),T(xe.$$.fragment,ze),ze.forEach(r),q.forEach(r),this.h()},h(){A(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),A(o,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),A(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),A(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),A(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),A(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),A($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),A(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),A(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(n,u){l(n,t,u),l(n,a,u),l(n,o,u),v(g,o,null),c(o,s),c(o,b),c(o,D),c(o,fe),c(o,Y),c(o,K),c(o,Ge),c(o,F),v(L,F,null),c(F,Je),c(F,ee),c(F,Be),v(N,F,null),l(n,Z,u),l(n,H,u),l(n,Le,u),l(n,j,u),v(I,j,null),c(j,Me),c(j,x),v(S,x,null),c(x,te),c(x,ne),c(x,$e),v(P,x,null),c(x,oe),v(O,x,null),c(j,ce),c(j,G),v(se,G,null),c(G,pe),c(G,ge),c(G,X),v(J,G,null),l(n,B,u),l(n,E,u),l(n,_e,u),l(n,$,u),v(R,$,null),c($,e),c($,p),c($,Ze),c($,be),c($,nt),c($,He),c($,ot),c($,Se),c($,st),c($,Oe),c($,at),c($,me),v(Ie,me,null),c(me,rt),c(me,Xe),c(me,it),v(Ce,me,null),l(n,Ye,u),l(n,Ue,u),l(n,Ke,u),l(n,U,u),v(We,U,null),c(U,dt),c(U,Ee),c(U,lt),c(U,Re),c(U,ct),c(U,Ve),c(U,pt),c(U,V),v(Ne,V,null),c(V,ht),c(V,Qe),c(V,mt),v(Pe,V,null),c(V,ut),v(xe,V,null),et=!0},p(n,u){const ye={};u&2&&(ye.$$scope={dirty:u,ctx:n}),N.$set(ye);const Te={};u&2&&(Te.$$scope={dirty:u,ctx:n}),P.$set(Te);const ae={};u&2&&(ae.$$scope={dirty:u,ctx:n}),O.$set(ae);const ve={};u&2&&(ve.$$scope={dirty:u,ctx:n}),J.$set(ve);const z={};u&2&&(z.$$scope={dirty:u,ctx:n}),Ce.$set(z);const ke={};u&2&&(ke.$$scope={dirty:u,ctx:n}),Pe.$set(ke);const q={};u&2&&(q.$$scope={dirty:u,ctx:n}),xe.$set(q)},i(n){et||(k(g.$$.fragment,n),k(L.$$.fragment,n),k(N.$$.fragment,n),k(I.$$.fragment,n),k(S.$$.fragment,n),k(P.$$.fragment,n),k(O.$$.fragment,n),k(se.$$.fragment,n),k(J.$$.fragment,n),k(R.$$.fragment,n),k(Ie.$$.fragment,n),k(Ce.$$.fragment,n),k(We.$$.fragment,n),k(Ne.$$.fragment,n),k(Pe.$$.fragment,n),k(xe.$$.fragment,n),et=!0)},o(n){w(g.$$.fragment,n),w(L.$$.fragment,n),w(N.$$.fragment,n),w(I.$$.fragment,n),w(S.$$.fragment,n),w(P.$$.fragment,n),w(O.$$.fragment,n),w(se.$$.fragment,n),w(J.$$.fragment,n),w(R.$$.fragment,n),w(Ie.$$.fragment,n),w(Ce.$$.fragment,n),w(We.$$.fragment,n),w(Ne.$$.fragment,n),w(Pe.$$.fragment,n),w(xe.$$.fragment,n),et=!1},d(n){n&&(r(t),r(a),r(o),r(Z),r(H),r(Le),r(j),r(B),r(E),r(_e),r($),r(Ye),r(Ue),r(Ke),r(U)),M(g),M(L),M(N),M(I),M(S),M(P),M(O),M(se),M(J),M(R),M(Ie),M(Ce),M(We),M(Ne),M(Pe),M(xe)}}}function Ot(C){let t,f;return t=new Lt({props:{$$slots:{default:[St]},$$scope:{ctx:C}}}),{c(){y(t.$$.fragment)},l(a){T(t.$$.fragment,a)},m(a,o){v(t,a,o),f=!0},p(a,o){const g={};o&2&&(g.$$scope={dirty:o,ctx:a}),t.$set(g)},i(a){f||(k(t.$$.fragment,a),f=!0)},o(a){w(t.$$.fragment,a),f=!1},d(a){M(t,a)}}}function Xt(C){let t,f,a,o,g,s,b,je,D,fe='The Phi-3 model was proposed in <a href="https://arxiv.org/abs/2404.14219" rel="nofollow">Phi-3 Technical Report: A Highly Capable Language Model Locally on Your Phone</a> by Microsoft.',Fe,Y,K,re,Ge="The abstract from the Phi-3 paper is the following:",F,L,Je="We introduce phi-3-mini, a 3.8 billion parameter language model trained on 3.3 trillion tokens, whose overall performance, as measured by both academic benchmarks and internal testing, rivals that of models such as Mixtral 8x7B and GPT-3.5 (e.g., phi-3-mini achieves 69% on MMLU and 8.38 on MT-bench), despite being small enough to be deployed on a phone. The innovation lies entirely in our dataset for training, a scaled-up version of the one used for phi-2, composed of heavily filtered web data and synthetic data. The model is also further aligned for robustness, safety, and chat format. We also provide some initial parameter-scaling results with a 7B and 14B models trained for 4.8T tokens, called phi-3-small and phi-3-medium, both significantly more capable than phi-3-mini (e.g., respectively 75% and 78% on MMLU, and 8.7 and 8.9 on MT-bench).",ee,ie,Be='The original code for Phi-3 can be found <a href="https://huggingface.co/microsoft/Phi-3-mini-4k-instruct" rel="nofollow">here</a>.',N,Z,H,de,Le='<li>This model is very similar to <code>Llama</code> with the main difference of <code>Phi3SuScaledRotaryEmbedding</code> and <code>Phi3YarnScaledRotaryEmbedding</code>, where they are used to extend the context of the rotary embeddings. The query, key and values are fused, and the MLP’s up and gate projection layers are also fused.</li> <li>The tokenizer used for this model is identical to the <a href="/docs/transformers/pr_30650/en/model_doc/llama#transformers.LlamaTokenizer">LlamaTokenizer</a>, with the exception of additional tokens.</li>',j,I,Me,x,S,te,ne,le,$e,P,oe,O,ce,G=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_30650/en/model_doc/phi3#transformers.Phi3Model">Phi3Model</a>. It is used to instantiate a Phi-3
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the
<a href="https://huggingface.co/microsoft/Phi-3-mini-4k-instruct" rel="nofollow">microsoft/Phi-3-mini-4k-instruct</a>.`,se,pe,ge=`Configuration objects inherit from <a href="/docs/transformers/pr_30650/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_30650/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,qe,X,J,B,E,he,_e,$,R;return g=new Ae({props:{title:"Phi-3",local:"phi-3",headingTag:"h1"}}),b=new Ae({props:{title:"Overview",local:"overview",headingTag:"h2"}}),Y=new Ae({props:{title:"Summary",local:"summary",headingTag:"h3"}}),Z=new Ae({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),I=new Ae({props:{title:"How to use Phi-3",local:"how-to-use-phi-3",headingTag:"h2"}}),x=new De({props:{warning:!0,$$slots:{default:[Ut]},$$scope:{ctx:C}}}),te=new tt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRlBoaS0zLW1pbmktNGstaW5zdHJ1Y3QlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGUGhpLTMtbWluaS00ay1pbnN0cnVjdCUyMiklMEElMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkNhbiUyMHlvdSUyMHByb3ZpZGUlMjB3YXlzJTIwdG8lMjBlYXQlMjBjb21iaW5hdGlvbnMlMjBvZiUyMGJhbmFuYXMlMjBhbmQlMjBkcmFnb25mcnVpdHMlM0YlMjIlN0QlNUQlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZShtZXNzYWdlcyUyQyUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUzRFRydWUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDMyKSUwQXRleHQlMjAlM0QlMjB0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMpJTVCMCU1RCUwQXByaW50KHRleHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;microsoft/Phi-3-mini-4k-instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;microsoft/Phi-3-mini-4k-instruct&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Can you provide ways to eat combinations of bananas and dragonfruits?&quot;</span>}]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer.apply_chat_template(messages, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(inputs, max_new_tokens=<span class="hljs-number">32</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>text = tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(text)
&lt;s&gt;&lt;|user|&gt; 
Can you provide ways to eat combinations of bananas <span class="hljs-keyword">and</span> dragonfruits?&lt;|end|&gt; 
&lt;|assistant|&gt; 
Certainly! Bananas <span class="hljs-keyword">and</span> dragonfruits can be combined <span class="hljs-keyword">in</span> various delicious ways. Here are some ideas <span class="hljs-keyword">for</span> eating combinations of bananas <span class="hljs-keyword">and</span>`,wrap:!1}}),le=new Ae({props:{title:"Phi3Config",local:"transformers.Phi3Config",headingTag:"h2"}}),oe=new ue({props:{name:"class transformers.Phi3Config",anchor:"transformers.Phi3Config",parameters:[{name:"vocab_size",val:" = 32064"},{name:"hidden_size",val:" = 3072"},{name:"intermediate_size",val:" = 8192"},{name:"num_hidden_layers",val:" = 32"},{name:"num_attention_heads",val:" = 32"},{name:"num_key_value_heads",val:" = None"},{name:"resid_pdrop",val:" = 0.0"},{name:"embd_pdrop",val:" = 0.0"},{name:"attention_dropout",val:" = 0.0"},{name:"hidden_act",val:" = 'silu'"},{name:"max_position_embeddings",val:" = 4096"},{name:"original_max_position_embeddings",val:" = 4096"},{name:"initializer_range",val:" = 0.02"},{name:"rms_norm_eps",val:" = 1e-05"},{name:"use_cache",val:" = True"},{name:"tie_word_embeddings",val:" = False"},{name:"rope_theta",val:" = 10000.0"},{name:"rope_scaling",val:" = None"},{name:"bos_token_id",val:" = 1"},{name:"eos_token_id",val:" = 32000"},{name:"pad_token_id",val:" = 32000"},{name:"sliding_window",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Phi3Config.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32064) &#x2014;
Vocabulary size of the Phi-3 model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/pr_30650/en/model_doc/phi3#transformers.Phi3Model">Phi3Model</a>.`,name:"vocab_size"},{anchor:"transformers.Phi3Config.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimension of the hidden representations.`,name:"hidden_size"},{anchor:"transformers.Phi3Config.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 8192) &#x2014;
Dimension of the MLP representations.`,name:"intermediate_size"},{anchor:"transformers.Phi3Config.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of hidden layers in the Transformer decoder.`,name:"num_hidden_layers"},{anchor:"transformers.Phi3Config.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of attention heads for each attention layer in the Transformer decoder.`,name:"num_attention_heads"},{anchor:"transformers.Phi3Config.num_key_value_heads",description:`<strong>num_key_value_heads</strong> (<code>int</code>, <em>optional</em>) &#x2014;
This is the number of key_value heads that should be used to implement Grouped Query Attention. If
<code>num_key_value_heads=num_attention_heads</code>, the model will use Multi Head Attention (MHA), if
<code>num_key_value_heads=1 the model will use Multi Query Attention (MQA) otherwise GQA is used. When converting a multi-head checkpoint to a GQA checkpoint, each group key and value head should be constructed by meanpooling all the original heads within that group. For more details checkout [this paper](https://arxiv.org/pdf/2305.13245.pdf). If it is not specified, will default to </code>num_attention_heads\`.`,name:"num_key_value_heads"},{anchor:"transformers.Phi3Config.resid_pdrop",description:`<strong>resid_pdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Dropout probability for mlp outputs.`,name:"resid_pdrop"},{anchor:"transformers.Phi3Config.embd_pdrop",description:`<strong>embd_pdrop</strong> (<code>int</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the embeddings.`,name:"embd_pdrop"},{anchor:"transformers.Phi3Config.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio after computing the attention scores.`,name:"attention_dropout"},{anchor:"transformers.Phi3Config.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder.`,name:"hidden_act"},{anchor:"transformers.Phi3Config.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
The maximum sequence length that this model might ever be used with.`,name:"max_position_embeddings"},{anchor:"transformers.Phi3Config.original_max_position_embeddings",description:`<strong>original_max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
The maximum sequence length that this model was trained with. This is used to determine the size of the
original RoPE embeddings when using long scaling.`,name:"original_max_position_embeddings"},{anchor:"transformers.Phi3Config.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.Phi3Config.rms_norm_eps",description:`<strong>rms_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon value used for the RMSNorm.`,name:"rms_norm_eps"},{anchor:"transformers.Phi3Config.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>. Whether to tie weight embeddings or not.`,name:"use_cache"},{anchor:"transformers.Phi3Config.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to tie weight embeddings`,name:"tie_word_embeddings"},{anchor:"transformers.Phi3Config.rope_theta",description:`<strong>rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to 10000.0) &#x2014;
The base period of the RoPE embeddings.`,name:"rope_theta"},{anchor:"transformers.Phi3Config.rope_scaling",description:`<strong>rope_scaling</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
The scaling strategy for the RoPE embeddings. If <code>None</code>, no scaling is applied. If a dictionary, it must
contain the following keys: <code>type</code>, <code>short_factor</code> and <code>long_factor</code>. The <code>type</code> must be either <code>su</code> or <code>yarn</code> and
the <code>short_factor</code> and <code>long_factor</code> must be lists of numbers with the same length as the hidden size
divided by the number of attention heads divided by 2.`,name:"rope_scaling"},{anchor:"transformers.Phi3Config.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The id of the &#x201C;beginning-of-sequence&#x201D; token.`,name:"bos_token_id"},{anchor:"transformers.Phi3Config.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 32000) &#x2014;
The id of the &#x201C;end-of-sequence&#x201D; token.`,name:"eos_token_id"},{anchor:"transformers.Phi3Config.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 32000) &#x2014;
The id of the padding token.`,name:"pad_token_id"},{anchor:"transformers.Phi3Config.sliding_window",description:`<strong>sliding_window</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Sliding window attention window size. If <code>None</code>, no sliding window is applied.`,name:"sliding_window"}],source:"https://github.com/huggingface/transformers/blob/vr_30650/src/transformers/models/phi3/configuration_phi3.py#L25"}}),X=new ft({props:{anchor:"transformers.Phi3Config.example",$$slots:{default:[Wt]},$$scope:{ctx:C}}}),B=new Ft({props:{pytorch:!0,tensorflow:!1,jax:!1,$$slots:{pytorch:[Ot]},$$scope:{ctx:C}}}),he=new It({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/phi3.md"}}),{c(){t=h("meta"),f=i(),a=h("p"),o=i(),y(g.$$.fragment),s=i(),y(b.$$.fragment),je=i(),D=h("p"),D.innerHTML=fe,Fe=i(),y(Y.$$.fragment),K=i(),re=h("p"),re.textContent=Ge,F=i(),L=h("p"),L.textContent=Je,ee=i(),ie=h("p"),ie.innerHTML=Be,N=i(),y(Z.$$.fragment),H=i(),de=h("ul"),de.innerHTML=Le,j=i(),y(I.$$.fragment),Me=i(),y(x.$$.fragment),S=i(),y(te.$$.fragment),ne=i(),y(le.$$.fragment),$e=i(),P=h("div"),y(oe.$$.fragment),O=i(),ce=h("p"),ce.innerHTML=G,se=i(),pe=h("p"),pe.innerHTML=ge,qe=i(),y(X.$$.fragment),J=i(),y(B.$$.fragment),E=i(),y(he.$$.fragment),_e=i(),$=h("p"),this.h()},l(e){const p=jt("svelte-u9bgzb",document.head);t=m(p,"META",{name:!0,content:!0}),p.forEach(r),f=d(e),a=m(e,"P",{}),Q(a).forEach(r),o=d(e),T(g.$$.fragment,e),s=d(e),T(b.$$.fragment,e),je=d(e),D=m(e,"P",{"data-svelte-h":!0}),_(D)!=="svelte-1d28kuk"&&(D.innerHTML=fe),Fe=d(e),T(Y.$$.fragment,e),K=d(e),re=m(e,"P",{"data-svelte-h":!0}),_(re)!=="svelte-1iah8ch"&&(re.textContent=Ge),F=d(e),L=m(e,"P",{"data-svelte-h":!0}),_(L)!=="svelte-10zying"&&(L.textContent=Je),ee=d(e),ie=m(e,"P",{"data-svelte-h":!0}),_(ie)!=="svelte-1deox1y"&&(ie.innerHTML=Be),N=d(e),T(Z.$$.fragment,e),H=d(e),de=m(e,"UL",{"data-svelte-h":!0}),_(de)!=="svelte-arpe09"&&(de.innerHTML=Le),j=d(e),T(I.$$.fragment,e),Me=d(e),T(x.$$.fragment,e),S=d(e),T(te.$$.fragment,e),ne=d(e),T(le.$$.fragment,e),$e=d(e),P=m(e,"DIV",{class:!0});var W=Q(P);T(oe.$$.fragment,W),O=d(W),ce=m(W,"P",{"data-svelte-h":!0}),_(ce)!=="svelte-tws19j"&&(ce.innerHTML=G),se=d(W),pe=m(W,"P",{"data-svelte-h":!0}),_(pe)!=="svelte-1rov41f"&&(pe.innerHTML=ge),qe=d(W),T(X.$$.fragment,W),W.forEach(r),J=d(e),T(B.$$.fragment,e),E=d(e),T(he.$$.fragment,e),_e=d(e),$=m(e,"P",{}),Q($).forEach(r),this.h()},h(){A(t,"name","hf:doc:metadata"),A(t,"content",Et),A(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,p){c(document.head,t),l(e,f,p),l(e,a,p),l(e,o,p),v(g,e,p),l(e,s,p),v(b,e,p),l(e,je,p),l(e,D,p),l(e,Fe,p),v(Y,e,p),l(e,K,p),l(e,re,p),l(e,F,p),l(e,L,p),l(e,ee,p),l(e,ie,p),l(e,N,p),v(Z,e,p),l(e,H,p),l(e,de,p),l(e,j,p),v(I,e,p),l(e,Me,p),v(x,e,p),l(e,S,p),v(te,e,p),l(e,ne,p),v(le,e,p),l(e,$e,p),l(e,P,p),v(oe,P,null),c(P,O),c(P,ce),c(P,se),c(P,pe),c(P,qe),v(X,P,null),l(e,J,p),v(B,e,p),l(e,E,p),v(he,e,p),l(e,_e,p),l(e,$,p),R=!0},p(e,[p]){const W={};p&2&&(W.$$scope={dirty:p,ctx:e}),x.$set(W);const Ze={};p&2&&(Ze.$$scope={dirty:p,ctx:e}),X.$set(Ze);const be={};p&2&&(be.$$scope={dirty:p,ctx:e}),B.$set(be)},i(e){R||(k(g.$$.fragment,e),k(b.$$.fragment,e),k(Y.$$.fragment,e),k(Z.$$.fragment,e),k(I.$$.fragment,e),k(x.$$.fragment,e),k(te.$$.fragment,e),k(le.$$.fragment,e),k(oe.$$.fragment,e),k(X.$$.fragment,e),k(B.$$.fragment,e),k(he.$$.fragment,e),R=!0)},o(e){w(g.$$.fragment,e),w(b.$$.fragment,e),w(Y.$$.fragment,e),w(Z.$$.fragment,e),w(I.$$.fragment,e),w(x.$$.fragment,e),w(te.$$.fragment,e),w(le.$$.fragment,e),w(oe.$$.fragment,e),w(X.$$.fragment,e),w(B.$$.fragment,e),w(he.$$.fragment,e),R=!1},d(e){e&&(r(f),r(a),r(o),r(s),r(je),r(D),r(Fe),r(K),r(re),r(F),r(L),r(ee),r(ie),r(N),r(H),r(de),r(j),r(Me),r(S),r(ne),r($e),r(P),r(J),r(E),r(_e),r($)),r(t),M(g,e),M(b,e),M(Y,e),M(Z,e),M(I,e),M(x,e),M(te,e),M(le,e),M(oe),M(X),M(B,e),M(he,e)}}}const Et='{"title":"Phi-3","local":"phi-3","sections":[{"title":"Overview","local":"overview","sections":[{"title":"Summary","local":"summary","sections":[],"depth":3}],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"How to use Phi-3","local":"how-to-use-phi-3","sections":[],"depth":2},{"title":"Phi3Config","local":"transformers.Phi3Config","sections":[],"depth":2}],"depth":1}';function Rt(C){return Pt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class nn extends xt{constructor(t){super(),zt(this,t,Rt,Xt,Ct,{})}}export{nn as component};
