import{s as Ut,f as jt,o as Ct,n as Jo}from"../chunks/scheduler.25b97de1.js";import{S as xt,i as kt,g as a,s,r as f,A as Bt,h as i,f as t,c as r,j as C,u as h,x as p,k as b,y as l,a as n,v as u,d as g,t as _,w as T}from"../chunks/index.d9030fc9.js";import{T as Jt}from"../chunks/Tip.baa67368.js";import{D as G}from"../chunks/Docstring.e257edda.js";import{C as qo}from"../chunks/CodeBlock.e6cd0d95.js";import{E as It}from"../chunks/ExampleCodeBlock.20db4b6e.js";import{H as q,E as Zt}from"../chunks/EditOnGithub.91d95064.js";function Gt(z){let d,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){d=a("p"),d.innerHTML=y},l(m){d=i(m,"P",{"data-svelte-h":!0}),p(d)!=="svelte-fincs2"&&(d.innerHTML=y)},m(m,M){n(m,d,M)},p:Jo,d(m){m&&t(d)}}}function zt(z){let d,y="Examples:",m,M,v;return M=new qo({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0NvbmZpZyUyQyUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBUdnBNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwVHZwTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMkppcWluZyUyRnRpbnktcmFuZG9tLXR2cCUyMiklMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJKaXFpbmclMkZ0aW55LXJhbmRvbS10dnAlMjIpJTBBJTBBcGl4ZWxfdmFsdWVzJTIwJTNEJTIwdG9yY2gucmFuZCgxJTJDJTIwMSUyQyUyMDMlMkMlMjA0NDglMkMlMjA0NDgpJTBBdGV4dF9pbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyVGhpcyUyMGlzJTIwYW4lMjBleGFtcGxlJTIwaW5wdXQlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dCUyMCUzRCUyMG1vZGVsKHRleHRfaW5wdXRzLmlucHV0X2lkcyUyQyUyMHBpeGVsX3ZhbHVlcyUyQyUyMHRleHRfaW5wdXRzLmF0dGVudGlvbl9tYXNrKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoTokenizer, TvpModel

<span class="hljs-meta">&gt;&gt;&gt; </span>model = TvpModel.from_pretrained(<span class="hljs-string">&quot;Jiqing/tiny-random-tvp&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Jiqing/tiny-random-tvp&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pixel_values = torch.rand(<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">3</span>, <span class="hljs-number">448</span>, <span class="hljs-number">448</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>text_inputs = tokenizer(<span class="hljs-string">&quot;This is an example input&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output = model(text_inputs.input_ids, pixel_values, text_inputs.attention_mask)`,wrap:!1}}),{c(){d=a("p"),d.textContent=y,m=s(),f(M.$$.fragment)},l(c){d=i(c,"P",{"data-svelte-h":!0}),p(d)!=="svelte-kvfsh7"&&(d.textContent=y),m=r(c),h(M.$$.fragment,c)},m(c,w){n(c,d,w),n(c,m,w),u(M,c,w),v=!0},p:Jo,i(c){v||(g(M.$$.fragment,c),v=!0)},o(c){_(M.$$.fragment,c),v=!1},d(c){c&&(t(d),t(m)),T(M,c)}}}function $t(z){let d,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){d=a("p"),d.innerHTML=y},l(m){d=i(m,"P",{"data-svelte-h":!0}),p(d)!=="svelte-fincs2"&&(d.innerHTML=y)},m(m,M){n(m,d,M)},p:Jo,d(m){m&&t(d)}}}function Wt(z){let d,y="Examples:",m,M,v;return M=new qo({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0NvbmZpZyUyQyUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBUdnBGb3JWaWRlb0dyb3VuZGluZyUwQSUwQW1vZGVsJTIwJTNEJTIwVHZwRm9yVmlkZW9Hcm91bmRpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMkppcWluZyUyRnRpbnktcmFuZG9tLXR2cCUyMiklMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJKaXFpbmclMkZ0aW55LXJhbmRvbS10dnAlMjIpJTBBJTBBcGl4ZWxfdmFsdWVzJTIwJTNEJTIwdG9yY2gucmFuZCgxJTJDJTIwMSUyQyUyMDMlMkMlMjA0NDglMkMlMjA0NDgpJTBBdGV4dF9pbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyVGhpcyUyMGlzJTIwYW4lMjBleGFtcGxlJTIwaW5wdXQlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dCUyMCUzRCUyMG1vZGVsKHRleHRfaW5wdXRzLmlucHV0X2lkcyUyQyUyMHBpeGVsX3ZhbHVlcyUyQyUyMHRleHRfaW5wdXRzLmF0dGVudGlvbl9tYXNrKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoTokenizer, TvpForVideoGrounding

<span class="hljs-meta">&gt;&gt;&gt; </span>model = TvpForVideoGrounding.from_pretrained(<span class="hljs-string">&quot;Jiqing/tiny-random-tvp&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Jiqing/tiny-random-tvp&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pixel_values = torch.rand(<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">3</span>, <span class="hljs-number">448</span>, <span class="hljs-number">448</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>text_inputs = tokenizer(<span class="hljs-string">&quot;This is an example input&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output = model(text_inputs.input_ids, pixel_values, text_inputs.attention_mask)`,wrap:!1}}),{c(){d=a("p"),d.textContent=y,m=s(),f(M.$$.fragment)},l(c){d=i(c,"P",{"data-svelte-h":!0}),p(d)!=="svelte-kvfsh7"&&(d.textContent=y),m=r(c),h(M.$$.fragment,c)},m(c,w){n(c,d,w),n(c,m,w),u(M,c,w),v=!0},p:Jo,i(c){v||(g(M.$$.fragment,c),v=!0)},o(c){_(M.$$.fragment,c),v=!1},d(c){c&&(t(d),t(m)),T(M,c)}}}function Vt(z){let d,y,m,M,v,c,w,Qe,D,Do='The text-visual prompting (TVP) framework was proposed in the paper <a href="https://arxiv.org/abs/2303.04995" rel="nofollow">Text-Visual Prompting for Efficient 2D Temporal Video Grounding</a> by Yimeng Zhang, Xin Chen, Jinghan Jia, Sijia Liu, Ke Ding.',Se,Y,Yo="The abstract from the paper is the following:",Le,K,Ko="<em>In this paper, we study the problem of temporal video grounding (TVG), which aims to predict the starting/ending time points of moments described by a text sentence within a long untrimmed video. Benefiting from fine-grained 3D visual features, the TVG techniques have achieved remarkable progress in recent years. However, the high complexity of 3D convolutional neural networks (CNNs) makes extracting dense 3D visual features time-consuming, which calls for intensive memory and computing resources. Towards efficient TVG, we propose a novel text-visual prompting (TVP) framework, which incorporates optimized perturbation patterns (that we call ‘prompts’) into both visual inputs and textual features of a TVG model. In sharp contrast to 3D CNNs, we show that TVP allows us to effectively co-train vision encoder and language encoder in a 2D TVG model and improves the performance of cross-modal feature fusion using only low-complexity sparse 2D visual features. Further, we propose a Temporal-Distance IoU (TDIoU) loss for efficient learning of TVG. Experiments on two benchmark datasets, Charades-STA and ActivityNet Captions datasets, empirically show that the proposed TVP significantly boosts the performance of 2D TVG (e.g., 9.79% improvement on Charades-STA and 30.77% improvement on ActivityNet Captions) and achieves 5× inference acceleration over TVG using 3D visual features.</em>",qe,O,Oo="This research addresses temporal video grounding (TVG), which is the process of pinpointing the start and end times of specific events in a long video, as described by a text sentence. Text-visual prompting (TVP), is proposed to enhance TVG. TVP involves integrating specially designed patterns, known as ‘prompts’, into both the visual (image-based) and textual (word-based) input components of a TVG model. These prompts provide additional spatial-temporal context, improving the model’s ability to accurately determine event timings in the video. The approach employs 2D visual inputs in place of 3D ones. Although 3D inputs offer more spatial-temporal detail, they are also more time-consuming to process. The use of 2D inputs with the prompting method aims to provide similar levels of context and accuracy more efficiently.",De,W,et,Ye,ee,ot='TVP architecture. Taken from the <a href="https://arxiv.org/abs/2303.04995">original paper.</a>',Ke,oe,tt='This model was contributed by <a href="https://huggingface.co/Jiqing" rel="nofollow">Jiqing Feng</a>. The original code can be found <a href="https://github.com/intel/TVP" rel="nofollow">here</a>.',Oe,te,eo,ne,nt="Prompts are optimized perturbation patterns, which would be added to input video frames or text features. Universal set refers to using the same exact set of prompts for any input, this means that these prompts are added consistently to all video frames and text features, regardless of the input’s content.",oo,se,st="TVP consists of a visual encoder and cross-modal encoder. A universal set of visual prompts and text prompts to be integrated into sampled video frames and textual features, respectively. Specially, a set of different visual prompts are applied to uniformly-sampled frames of one untrimmed video in order.",to,re,rt=`The goal of this model is to incorporate trainable prompts into both visual inputs and textual features to temporal video grounding(TVG) problems.
In principle, one can apply any visual, cross-modal encoder in the proposed architecture.`,no,ae,at=`The <a href="/docs/transformers/pr_30510/en/model_doc/tvp#transformers.TvpProcessor">TvpProcessor</a> wraps <a href="/docs/transformers/pr_30510/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> and <a href="/docs/transformers/pr_30510/en/model_doc/tvp#transformers.TvpImageProcessor">TvpImageProcessor</a> into a single instance to both
encode the text and prepare the images respectively.`,so,ie,it='The following example shows how to run temporal video grounding using <a href="/docs/transformers/pr_30510/en/model_doc/tvp#transformers.TvpProcessor">TvpProcessor</a> and <a href="/docs/transformers/pr_30510/en/model_doc/tvp#transformers.TvpForVideoGrounding">TvpForVideoGrounding</a>.',ro,le,ao,de,lt="Tips:",io,ce,dt='<li>This implementation of TVP uses <a href="/docs/transformers/pr_30510/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> to generate text embeddings and Resnet-50 model to compute visual embeddings.</li> <li>Checkpoints for pre-trained <a href="https://huggingface.co/Intel/tvp-base" rel="nofollow">tvp-base</a> is released.</li> <li>Please refer to <a href="https://arxiv.org/pdf/2303.04995.pdf" rel="nofollow">Table 2</a> for TVP’s performance on Temporal Video Grounding task.</li>',lo,pe,co,J,me,Io,ke,ct=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_30510/en/model_doc/tvp#transformers.TvpModel">TvpModel</a>. It is used to instantiate an Tvp
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the Tvp
<a href="https://huggingface.co/Intel/tvp-base" rel="nofollow">Intel/tvp-base</a> architecture.`,Uo,Be,pt=`Configuration objects inherit from <a href="/docs/transformers/pr_30510/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_30510/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,jo,V,fe,Co,Ze,mt='Instantiate a <a href="/docs/transformers/pr_30510/en/model_doc/tvp#transformers.TvpConfig">TvpConfig</a> (or a derived class) from a pre-trained backbone model configuration.',xo,F,he,ko,Ge,ft='Serializes this instance to a Python dictionary. Override the default <a href="/docs/transformers/pr_30510/en/main_classes/configuration#transformers.PretrainedConfig.to_dict">to_dict()</a>.',po,ue,mo,B,ge,Bo,ze,ht="Constructs a Tvp image processor.",Zo,A,_e,Go,$e,ut="Preprocess an image or batch of images.",fo,Te,ho,I,Me,zo,We,gt="Constructs an TVP processor which wraps a TVP image processor and a Bert tokenizer into a single processor.",$o,Ve,_t=`<a href="/docs/transformers/pr_30510/en/model_doc/tvp#transformers.TvpProcessor">TvpProcessor</a> offers all the functionalities of <a href="/docs/transformers/pr_30510/en/model_doc/tvp#transformers.TvpImageProcessor">TvpImageProcessor</a> and <a href="/docs/transformers/pr_30510/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a>. See the
<a href="/docs/transformers/pr_30510/en/model_doc/tvp#transformers.TvpProcessor.__call__"><strong>call</strong>()</a> and <code>decode()</code> for more information.`,Wo,N,ve,Vo,Fe,Tt=`Main method to prepare for the model one or several sequences(s) and image(s). This method forwards the <code>text</code>
and <code>kwargs</code> arguments to BertTokenizerFast’s <a href="/docs/transformers/pr_30510/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__"><strong>call</strong>()</a> if <code>text</code> is not <code>None</code> to encode
the text. To prepare the image(s), this method forwards the <code>videos</code> and <code>kwargs</code> arguments to
TvpImageProcessor’s <a href="/docs/transformers/pr_30510/en/model_doc/levit#transformers.LevitFeatureExtractor.__call__"><strong>call</strong>()</a> if <code>videos</code> is not <code>None</code>. Please refer to the doctsring of
the above two methods for more information.`,uo,ye,go,Z,be,Fo,Ae,Mt=`The bare Tvp Model transformer outputting BaseModelOutputWithPooling object without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Ao,x,we,No,Ne,vt='The <a href="/docs/transformers/pr_30510/en/model_doc/tvp#transformers.TvpModel">TvpModel</a> forward method, overrides the <code>__call__</code> special method.',Ro,R,Xo,X,_o,Je,To,U,Ie,Po,Re,yt="Tvp Model with a video grounding head on top computing IoU, distance, and duration loss.",Ho,Xe,bt=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Eo,k,Ue,Qo,Pe,wt='The <a href="/docs/transformers/pr_30510/en/model_doc/tvp#transformers.TvpForVideoGrounding">TvpForVideoGrounding</a> forward method, overrides the <code>__call__</code> special method.',So,P,Lo,H,Mo,je,vo,Ee,yo;return v=new q({props:{title:"TVP",local:"tvp",headingTag:"h1"}}),w=new q({props:{title:"Overview",local:"overview",headingTag:"h2"}}),te=new q({props:{title:"Usage tips and examples",local:"usage-tips-and-examples",headingTag:"h2"}}),le=new qo({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> av
<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, TvpForVideoGrounding


<span class="hljs-keyword">def</span> <span class="hljs-title function_">pyav_decode</span>(<span class="hljs-params">container, sampling_rate, num_frames, clip_idx, num_clips, target_fps</span>):
    <span class="hljs-string">&#x27;&#x27;&#x27;
    Convert the video from its original fps to the target_fps and decode the video with PyAV decoder.
    Args:
        container (container): pyav container.
        sampling_rate (int): frame sampling rate (interval between two sampled frames).
        num_frames (int): number of frames to sample.
        clip_idx (int): if clip_idx is -1, perform random temporal sampling.
            If clip_idx is larger than -1, uniformly split the video to num_clips
            clips, and select the clip_idx-th video clip.
        num_clips (int): overall number of clips to uniformly sample from the given video.
        target_fps (int): the input video may have different fps, convert it to
            the target video fps before frame sampling.
    Returns:
        frames (tensor): decoded frames from the video. Return None if the no
            video stream was found.
        fps (float): the number of frames per second of the video.
    &#x27;&#x27;&#x27;</span>
    video = container.streams.video[<span class="hljs-number">0</span>]
    fps = <span class="hljs-built_in">float</span>(video.average_rate)
    clip_size = sampling_rate * num_frames / target_fps * fps
    delta = <span class="hljs-built_in">max</span>(num_frames - clip_size, <span class="hljs-number">0</span>)
    start_idx = delta * clip_idx / num_clips
    end_idx = start_idx + clip_size - <span class="hljs-number">1</span>
    timebase = video.duration / num_frames
    video_start_pts = <span class="hljs-built_in">int</span>(start_idx * timebase)
    video_end_pts = <span class="hljs-built_in">int</span>(end_idx * timebase)
    seek_offset = <span class="hljs-built_in">max</span>(video_start_pts - <span class="hljs-number">1024</span>, <span class="hljs-number">0</span>)
    container.seek(seek_offset, any_frame=<span class="hljs-literal">False</span>, backward=<span class="hljs-literal">True</span>, stream=video)
    frames = {}
    <span class="hljs-keyword">for</span> frame <span class="hljs-keyword">in</span> container.decode(video=<span class="hljs-number">0</span>):
        <span class="hljs-keyword">if</span> frame.pts &lt; video_start_pts:
            <span class="hljs-keyword">continue</span>
        frames[frame.pts] = frame
        <span class="hljs-keyword">if</span> frame.pts &gt; video_end_pts:
            <span class="hljs-keyword">break</span>
    frames = [frames[pts] <span class="hljs-keyword">for</span> pts <span class="hljs-keyword">in</span> <span class="hljs-built_in">sorted</span>(frames)]
    <span class="hljs-keyword">return</span> frames, fps


<span class="hljs-keyword">def</span> <span class="hljs-title function_">decode</span>(<span class="hljs-params">container, sampling_rate, num_frames, clip_idx, num_clips, target_fps</span>):
    <span class="hljs-string">&#x27;&#x27;&#x27;
    Decode the video and perform temporal sampling.
    Args:
        container (container): pyav container.
        sampling_rate (int): frame sampling rate (interval between two sampled frames).
        num_frames (int): number of frames to sample.
        clip_idx (int): if clip_idx is -1, perform random temporal sampling.
            If clip_idx is larger than -1, uniformly split the video to num_clips
            clips, and select the clip_idx-th video clip.
        num_clips (int): overall number of clips to uniformly sample from the given video.
        target_fps (int): the input video may have different fps, convert it to
            the target video fps before frame sampling.
    Returns:
        frames (tensor): decoded frames from the video.
    &#x27;&#x27;&#x27;</span>
    <span class="hljs-keyword">assert</span> clip_idx &gt;= -<span class="hljs-number">2</span>, <span class="hljs-string">&quot;Not a valied clip_idx {}&quot;</span>.<span class="hljs-built_in">format</span>(clip_idx)
    frames, fps = pyav_decode(container, sampling_rate, num_frames, clip_idx, num_clips, target_fps)
    clip_size = sampling_rate * num_frames / target_fps * fps
    index = np.linspace(<span class="hljs-number">0</span>, clip_size - <span class="hljs-number">1</span>, num_frames)
    index = np.clip(index, <span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(frames) - <span class="hljs-number">1</span>).astype(np.int64)
    frames = np.array([frames[idx].to_rgb().to_ndarray() <span class="hljs-keyword">for</span> idx <span class="hljs-keyword">in</span> index])
    frames = frames.transpose(<span class="hljs-number">0</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>)
    <span class="hljs-keyword">return</span> frames


file = hf_hub_download(repo_id=<span class="hljs-string">&quot;Intel/tvp_demo&quot;</span>, filename=<span class="hljs-string">&quot;AK2KG.mp4&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
model = TvpForVideoGrounding.from_pretrained(<span class="hljs-string">&quot;Intel/tvp-base&quot;</span>)

decoder_kwargs = <span class="hljs-built_in">dict</span>(
    container=av.<span class="hljs-built_in">open</span>(file, metadata_errors=<span class="hljs-string">&quot;ignore&quot;</span>),
    sampling_rate=<span class="hljs-number">1</span>,
    num_frames=model.config.num_frames,
    clip_idx=<span class="hljs-number">0</span>,
    num_clips=<span class="hljs-number">1</span>,
    target_fps=<span class="hljs-number">3</span>,
)
raw_sampled_frms = decode(**decoder_kwargs)

text = <span class="hljs-string">&quot;a person is sitting on a bed.&quot;</span>
processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;Intel/tvp-base&quot;</span>)
model_inputs = processor(
    text=[text], videos=<span class="hljs-built_in">list</span>(raw_sampled_frms), return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, max_text_length=<span class="hljs-number">100</span><span class="hljs-comment">#, size=size</span>
)

model_inputs[<span class="hljs-string">&quot;pixel_values&quot;</span>] = model_inputs[<span class="hljs-string">&quot;pixel_values&quot;</span>].to(model.dtype)
output = model(**model_inputs)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_video_duration</span>(<span class="hljs-params">filename</span>):
    cap = cv2.VideoCapture(filename)
    <span class="hljs-keyword">if</span> cap.isOpened():
        rate = cap.get(<span class="hljs-number">5</span>)
        frame_num = cap.get(<span class="hljs-number">7</span>)
        duration = frame_num/rate
        <span class="hljs-keyword">return</span> duration
    <span class="hljs-keyword">return</span> -<span class="hljs-number">1</span>

duration = get_video_duration(file)
start, end = processor.post_process_video_grounding(output.logits, duration)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;The time slot of the video corresponding to the text \\&quot;<span class="hljs-subst">{text}</span>\\&quot; is from <span class="hljs-subst">{start}</span>s to <span class="hljs-subst">{end}</span>s&quot;</span>)`,wrap:!1}}),pe=new q({props:{title:"TvpConfig",local:"transformers.TvpConfig",headingTag:"h2"}}),me=new G({props:{name:"class transformers.TvpConfig",anchor:"transformers.TvpConfig",parameters:[{name:"backbone_config",val:" = None"},{name:"backbone",val:" = None"},{name:"use_pretrained_backbone",val:" = False"},{name:"use_timm_backbone",val:" = False"},{name:"backbone_kwargs",val:" = None"},{name:"distance_loss_weight",val:" = 1.0"},{name:"duration_loss_weight",val:" = 0.1"},{name:"visual_prompter_type",val:" = 'framepad'"},{name:"visual_prompter_apply",val:" = 'replace'"},{name:"visual_prompt_size",val:" = 96"},{name:"max_img_size",val:" = 448"},{name:"num_frames",val:" = 48"},{name:"vocab_size",val:" = 30522"},{name:"hidden_size",val:" = 768"},{name:"intermediate_size",val:" = 3072"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"max_position_embeddings",val:" = 512"},{name:"max_grid_col_position_embeddings",val:" = 100"},{name:"max_grid_row_position_embeddings",val:" = 100"},{name:"hidden_dropout_prob",val:" = 0.1"},{name:"hidden_act",val:" = 'gelu'"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"initializer_range",val:" = 0.02"},{name:"attention_probs_dropout_prob",val:" = 0.1"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TvpConfig.backbone_config",description:`<strong>backbone_config</strong> (<code>PretrainedConfig</code> or <code>dict</code>, <em>optional</em>) &#x2014;
The configuration of the backbone model.`,name:"backbone_config"},{anchor:"transformers.TvpConfig.backbone",description:`<strong>backbone</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of backbone to use when <code>backbone_config</code> is <code>None</code>. If <code>use_pretrained_backbone</code> is <code>True</code>, this
will load the corresponding pretrained weights from the timm or transformers library. If <code>use_pretrained_backbone</code>
is <code>False</code>, this loads the backbone&#x2019;s config and uses that to initialize the backbone with random weights.`,name:"backbone"},{anchor:"transformers.TvpConfig.use_pretrained_backbone",description:`<strong>use_pretrained_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use pretrained weights for the backbone.`,name:"use_pretrained_backbone"},{anchor:"transformers.TvpConfig.use_timm_backbone",description:`<strong>use_timm_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to load <code>backbone</code> from the timm library. If <code>False</code>, the backbone is loaded from the transformers
library.`,name:"use_timm_backbone"},{anchor:"transformers.TvpConfig.backbone_kwargs",description:`<strong>backbone_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Keyword arguments to be passed to AutoBackbone when loading from a checkpoint
e.g. <code>{&apos;out_indices&apos;: (0, 1, 2, 3)}</code>. Cannot be specified if <code>backbone_config</code> is set.`,name:"backbone_kwargs"},{anchor:"transformers.TvpConfig.distance_loss_weight",description:`<strong>distance_loss_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The weight of distance loss.`,name:"distance_loss_weight"},{anchor:"transformers.TvpConfig.duration_loss_weight",description:`<strong>duration_loss_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The weight of duration loss.`,name:"duration_loss_weight"},{anchor:"transformers.TvpConfig.visual_prompter_type",description:`<strong>visual_prompter_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;framepad&quot;</code>) &#x2014;
Visual prompt type. The type of padding. Framepad means padding on each frame. Should be one of &#x201C;framepad&#x201D;
or &#x201C;framedownpad&#x201D;`,name:"visual_prompter_type"},{anchor:"transformers.TvpConfig.visual_prompter_apply",description:`<strong>visual_prompter_apply</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;replace&quot;</code>) &#x2014;
The way of applying visual prompt. Replace means use the value of prompt to change the original value in
visual inputs. Should be one of &#x201C;replace&#x201D;, or &#x201C;add&#x201D;, or &#x201C;remove&#x201D;.`,name:"visual_prompter_apply"},{anchor:"transformers.TvpConfig.visual_prompt_size",description:`<strong>visual_prompt_size</strong> (<code>int</code>, <em>optional</em>, defaults to 96) &#x2014;
The size of visual prompt.`,name:"visual_prompt_size"},{anchor:"transformers.TvpConfig.max_img_size",description:`<strong>max_img_size</strong> (<code>int</code>, <em>optional</em>, defaults to 448) &#x2014;
The maximum size of frame.`,name:"max_img_size"},{anchor:"transformers.TvpConfig.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, <em>optional</em>, defaults to 48) &#x2014;
The number of frames extracted from a video.`,name:"num_frames"},{anchor:"transformers.TvpConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 30522) &#x2014;
Vocabulary size of the Tvp text model. Defines the number of different tokens that can be represented by
the <code>inputs_ids</code> passed when calling <a href="/docs/transformers/pr_30510/en/model_doc/tvp#transformers.TvpModel">TvpModel</a>.`,name:"vocab_size"},{anchor:"transformers.TvpConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers.`,name:"hidden_size"},{anchor:"transformers.TvpConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.TvpConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.TvpConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.TvpConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The maximum sequence length that this model might ever be used with. Typically set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.TvpConfig.max_grid_col_position_embeddings",description:`<strong>max_grid_col_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The largest number of horizontal patches from a video frame.`,name:"max_grid_col_position_embeddings"},{anchor:"transformers.TvpConfig.max_grid_row_position_embeddings",description:`<strong>max_grid_row_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The largest number of vertical patches from a video frame.`,name:"max_grid_row_position_embeddings"},{anchor:"transformers.TvpConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability of hidden layers.`,name:"hidden_dropout_prob"},{anchor:"transformers.TvpConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> <code>&quot;quick_gelu&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.TvpConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.TvpConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.TvpConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability of attention layers.`,name:"attention_probs_dropout_prob"}],source:"https://github.com/huggingface/transformers/blob/vr_30510/src/transformers/models/tvp/configuration_tvp.py#L28"}}),fe=new G({props:{name:"from_backbone_config",anchor:"transformers.TvpConfig.from_backbone_config",parameters:[{name:"backbone_config",val:": PretrainedConfig"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TvpConfig.from_backbone_config.backbone_config",description:`<strong>backbone_config</strong> (<a href="/docs/transformers/pr_30510/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The backbone configuration.`,name:"backbone_config"}],source:"https://github.com/huggingface/transformers/blob/vr_30510/src/transformers/models/tvp/configuration_tvp.py#L175",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of a configuration object</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_30510/en/model_doc/tvp#transformers.TvpConfig"
>TvpConfig</a></p>
`}}),he=new G({props:{name:"to_dict",anchor:"transformers.TvpConfig.to_dict",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30510/src/transformers/models/tvp/configuration_tvp.py#L187",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of all the attributes that make up this configuration instance,</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, any]</code></p>
`}}),ue=new q({props:{title:"TvpImageProcessor",local:"transformers.TvpImageProcessor",headingTag:"h2"}}),ge=new G({props:{name:"class transformers.TvpImageProcessor",anchor:"transformers.TvpImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": Dict = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_center_crop",val:": bool = True"},{name:"crop_size",val:": Dict = None"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": Union = 0.00392156862745098"},{name:"do_pad",val:": bool = True"},{name:"pad_size",val:": Dict = None"},{name:"constant_values",val:": Union = 0"},{name:"pad_mode",val:": PaddingMode = <PaddingMode.CONSTANT: 'constant'>"},{name:"do_normalize",val:": bool = True"},{name:"do_flip_channel_order",val:": bool = True"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TvpImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by the
<code>do_resize</code> parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.TvpImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;longest_edge&quot; -- 448}</code>):
Size of the output image after resizing. The longest edge of the image will be resized to
<code>size[&quot;longest_edge&quot;]</code> while maintaining the aspect ratio of the original image. Can be overriden by
<code>size</code> in the <code>preprocess</code> method.`,name:"size"},{anchor:"transformers.TvpImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BILINEAR</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by the <code>resample</code> parameter in the
<code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.TvpImageProcessor.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to center crop the image to the specified <code>crop_size</code>. Can be overridden by the <code>do_center_crop</code>
parameter in the <code>preprocess</code> method.`,name:"do_center_crop"},{anchor:"transformers.TvpImageProcessor.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>{&quot;height&quot; -- 448, &quot;width&quot;: 448}</code>):
Size of the image after applying the center crop. Can be overridden by the <code>crop_size</code> parameter in the
<code>preprocess</code> method.`,name:"crop_size"},{anchor:"transformers.TvpImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the <code>do_rescale</code>
parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.TvpImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Defines the scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter
in the <code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.TvpImageProcessor.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to pad the image. Can be overridden by the <code>do_pad</code> parameter in the <code>preprocess</code> method.`,name:"do_pad"},{anchor:"transformers.TvpImageProcessor.pad_size",description:`<strong>pad_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>{&quot;height&quot; -- 448, &quot;width&quot;: 448}</code>):
Size of the image after applying the padding. Can be overridden by the <code>pad_size</code> parameter in the
<code>preprocess</code> method.`,name:"pad_size"},{anchor:"transformers.TvpImageProcessor.constant_values",description:`<strong>constant_values</strong> (<code>Union[float, Iterable[float]]</code>, <em>optional</em>, defaults to 0) &#x2014;
The fill value to use when padding the image.`,name:"constant_values"},{anchor:"transformers.TvpImageProcessor.pad_mode",description:`<strong>pad_mode</strong> (<code>PaddingMode</code>, <em>optional</em>, defaults to <code>PaddingMode.CONSTANT</code>) &#x2014;
Use what kind of mode in padding.`,name:"pad_mode"},{anchor:"transformers.TvpImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method.`,name:"do_normalize"},{anchor:"transformers.TvpImageProcessor.do_flip_channel_order",description:`<strong>do_flip_channel_order</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to flip the color channels from RGB to BGR. Can be overridden by the <code>do_flip_channel_order</code>
parameter in the <code>preprocess</code> method.`,name:"do_flip_channel_order"},{anchor:"transformers.TvpImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.TvpImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"}],source:"https://github.com/huggingface/transformers/blob/vr_30510/src/transformers/models/tvp/image_processing_tvp.py#L85"}}),_e=new G({props:{name:"preprocess",anchor:"transformers.TvpImageProcessor.preprocess",parameters:[{name:"videos",val:": Union"},{name:"do_resize",val:": bool = None"},{name:"size",val:": Dict = None"},{name:"resample",val:": Resampling = None"},{name:"do_center_crop",val:": bool = None"},{name:"crop_size",val:": Dict = None"},{name:"do_rescale",val:": bool = None"},{name:"rescale_factor",val:": float = None"},{name:"do_pad",val:": bool = None"},{name:"pad_size",val:": Dict = None"},{name:"constant_values",val:": Union = None"},{name:"pad_mode",val:": PaddingMode = None"},{name:"do_normalize",val:": bool = None"},{name:"do_flip_channel_order",val:": bool = None"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"return_tensors",val:": Union = None"},{name:"data_format",val:": ChannelDimension = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": Union = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TvpImageProcessor.preprocess.videos",description:`<strong>videos</strong> (<code>ImageInput</code> or <code>List[ImageInput]</code> or <code>List[List[ImageInput]]</code>) &#x2014;
Frames to preprocess.`,name:"videos"},{anchor:"transformers.TvpImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.TvpImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after applying resize.`,name:"size"},{anchor:"transformers.TvpImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>, Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.TvpImageProcessor.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_centre_crop</code>) &#x2014;
Whether to centre crop the image.`,name:"do_center_crop"},{anchor:"transformers.TvpImageProcessor.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the image after applying the centre crop.`,name:"crop_size"},{anchor:"transformers.TvpImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between [0 - 1].`,name:"do_rescale"},{anchor:"transformers.TvpImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.TvpImageProcessor.preprocess.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to pad the image. Can be overridden by the <code>do_pad</code> parameter in the <code>preprocess</code> method.`,name:"do_pad"},{anchor:"transformers.TvpImageProcessor.preprocess.pad_size",description:`<strong>pad_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>{&quot;height&quot; -- 448, &quot;width&quot;: 448}</code>):
Size of the image after applying the padding. Can be overridden by the <code>pad_size</code> parameter in the
<code>preprocess</code> method.`,name:"pad_size"},{anchor:"transformers.TvpImageProcessor.preprocess.constant_values",description:`<strong>constant_values</strong> (<code>Union[float, Iterable[float]]</code>, <em>optional</em>, defaults to 0) &#x2014;
The fill value to use when padding the image.`,name:"constant_values"},{anchor:"transformers.TvpImageProcessor.preprocess.pad_mode",description:`<strong>pad_mode</strong> (<code>PaddingMode</code>, <em>optional</em>, defaults to &#x201C;PaddingMode.CONSTANT&#x201D;) &#x2014;
Use what kind of mode in padding.`,name:"pad_mode"},{anchor:"transformers.TvpImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.TvpImageProcessor.preprocess.do_flip_channel_order",description:`<strong>do_flip_channel_order</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_flip_channel_order</code>) &#x2014;
Whether to flip the channel order of the image.`,name:"do_flip_channel_order"},{anchor:"transformers.TvpImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean.`,name:"image_mean"},{anchor:"transformers.TvpImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation.`,name:"image_std"},{anchor:"transformers.TvpImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.TvpImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the inferred channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.TvpImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/vr_30510/src/transformers/models/tvp/image_processing_tvp.py#L361"}}),Te=new q({props:{title:"TvpProcessor",local:"transformers.TvpProcessor",headingTag:"h2"}}),Me=new G({props:{name:"class transformers.TvpProcessor",anchor:"transformers.TvpProcessor",parameters:[{name:"image_processor",val:" = None"},{name:"tokenizer",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TvpProcessor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/pr_30510/en/model_doc/tvp#transformers.TvpImageProcessor">TvpImageProcessor</a>, <em>optional</em>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.TvpProcessor.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/pr_30510/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a>, <em>optional</em>) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"}],source:"https://github.com/huggingface/transformers/blob/vr_30510/src/transformers/models/tvp/processing_tvp.py#L23"}}),ve=new G({props:{name:"__call__",anchor:"transformers.TvpProcessor.__call__",parameters:[{name:"text",val:" = None"},{name:"videos",val:" = None"},{name:"return_tensors",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TvpProcessor.__call__.text",description:`<strong>text</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>) &#x2014;
The sequence or batch of sequences to be encoded. Each sequence can be a string or a list of strings
(pretokenized string). If the sequences are provided as list of strings (pretokenized), you must set
<code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text"},{anchor:"transformers.TvpProcessor.__call__.videos",description:`<strong>videos</strong> (<code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>, <code>List[torch.Tensor]</code>, <code>List[List[PIL.Image.Image]]</code>, <code>List[List[np.ndarrray]]</code>, &#x2014;
<code>List[List[torch.Tensor]]</code>): The video or batch of videos to be prepared. Each video should be a list
of frames, which can be either PIL images or NumPy arrays. In case of NumPy arrays/PyTorch tensors,
each frame should be of shape (H, W, C), where H and W are frame height and width, and C is a number of
channels.`,name:"videos"},{anchor:"transformers.TvpProcessor.__call__.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/pr_30510/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors of a particular framework. Acceptable values are:</p>
<ul>
<li><code>&apos;tf&apos;</code>: Return TensorFlow <code>tf.constant</code> objects.</li>
<li><code>&apos;pt&apos;</code>: Return PyTorch <code>torch.Tensor</code> objects.</li>
<li><code>&apos;np&apos;</code>: Return NumPy <code>np.ndarray</code> objects.</li>
<li><code>&apos;jax&apos;</code>: Return JAX <code>jnp.ndarray</code> objects.</li>
</ul>`,name:"return_tensors"}],source:"https://github.com/huggingface/transformers/blob/vr_30510/src/transformers/models/tvp/processing_tvp.py#L49",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_30510/en/main_classes/tokenizer#transformers.BatchEncoding"
>BatchEncoding</a> with the following fields:</p>
<ul>
<li><strong>input_ids</strong> — List of token ids to be fed to a model. Returned when <code>text</code> is not <code>None</code>.</li>
<li><strong>attention_mask</strong> — List of indices specifying which tokens should be attended to by the model (when
<code>return_attention_mask=True</code> or if <em>“attention_mask”</em> is in <code>self.model_input_names</code> and if <code>text</code> is not
<code>None</code>).</li>
<li><strong>pixel_values</strong> — Pixel values to be fed to a model. Returned when <code>videos</code> is not <code>None</code>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_30510/en/main_classes/tokenizer#transformers.BatchEncoding"
>BatchEncoding</a></p>
`}}),ye=new q({props:{title:"TvpModel",local:"transformers.TvpModel",headingTag:"h2"}}),be=new G({props:{name:"class transformers.TvpModel",anchor:"transformers.TvpModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.TvpModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30510/en/model_doc/tvp#transformers.TvpConfig">TvpConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_30510/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30510/src/transformers/models/tvp/modeling_tvp.py#L775"}}),we=new G({props:{name:"forward",anchor:"transformers.TvpModel.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"pixel_values",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"interpolate_pos_encoding",val:": bool = False"}],parametersDescription:[{anchor:"transformers.TvpModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Indices can be obtained using <a href="/docs/transformers/pr_30510/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See
<a href="/docs/transformers/pr_30510/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/pr_30510/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details. <a href="../glossary#input-ids">What are input
IDs?</a>`,name:"input_ids"},{anchor:"transformers.TvpModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_frames, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/pr_30510/en/model_doc/tvp#transformers.TvpImageProcessor">TvpImageProcessor</a>. See <a href="/docs/transformers/pr_30510/en/model_doc/levit#transformers.LevitFeatureExtractor.__call__">TvpImageProcessor.<strong>call</strong>()</a>
for details.`,name:"pixel_values"},{anchor:"transformers.TvpModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="../glossary#attention-mask">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"transformers.TvpModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TvpModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TvpModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TvpModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30510/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.TvpModel.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to interpolate the pre-trained image pad prompter encodings and positional encodings.`,name:"interpolate_pos_encoding"}],source:"https://github.com/huggingface/transformers/blob/vr_30510/src/transformers/models/tvp/modeling_tvp.py#L809",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_30510/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.tvp.configuration_tvp.TvpConfig'&gt;</code>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_30510/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),R=new Jt({props:{$$slots:{default:[Gt]},$$scope:{ctx:z}}}),X=new It({props:{anchor:"transformers.TvpModel.forward.example",$$slots:{default:[zt]},$$scope:{ctx:z}}}),Je=new q({props:{title:"TvpForVideoGrounding",local:"transformers.TvpForVideoGrounding",headingTag:"h2"}}),Ie=new G({props:{name:"class transformers.TvpForVideoGrounding",anchor:"transformers.TvpForVideoGrounding",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.TvpForVideoGrounding.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30510/en/model_doc/tvp#transformers.TvpConfig">TvpConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_30510/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30510/src/transformers/models/tvp/modeling_tvp.py#L900"}}),Ue=new G({props:{name:"forward",anchor:"transformers.TvpForVideoGrounding.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"pixel_values",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"labels",val:": Tuple = None"},{name:"head_mask",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"interpolate_pos_encoding",val:": bool = False"}],parametersDescription:[{anchor:"transformers.TvpForVideoGrounding.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Indices can be obtained using <a href="/docs/transformers/pr_30510/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See
<a href="/docs/transformers/pr_30510/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/pr_30510/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details. <a href="../glossary#input-ids">What are input
IDs?</a>`,name:"input_ids"},{anchor:"transformers.TvpForVideoGrounding.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_frames, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/pr_30510/en/model_doc/tvp#transformers.TvpImageProcessor">TvpImageProcessor</a>. See <a href="/docs/transformers/pr_30510/en/model_doc/levit#transformers.LevitFeatureExtractor.__call__">TvpImageProcessor.<strong>call</strong>()</a>
for details.`,name:"pixel_values"},{anchor:"transformers.TvpForVideoGrounding.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="../glossary#attention-mask">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"transformers.TvpForVideoGrounding.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TvpForVideoGrounding.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TvpForVideoGrounding.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TvpForVideoGrounding.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30510/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.TvpForVideoGrounding.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to interpolate the pre-trained image pad prompter encodings and positional encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.TvpForVideoGrounding.forward.labels",description:`<strong>labels</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, 3)</code>, <em>optional</em>) &#x2014;
The labels contains duration, start time, and end time of the video corresponding to the text.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_30510/src/transformers/models/tvp/modeling_tvp.py#L915",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.tvp.modeling_tvp.TvpVideoGroundingOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.tvp.configuration_tvp.TvpConfig'&gt;</code>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>return_loss</code> is <code>True</code>) — Temporal-Distance IoU loss for video grounding.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, 2)</code>) — Contains start_time/duration and end_time/duration. It is the time slot of the videos corresponding to the
input texts.</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of
the model at the output of each layer plus the optional initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.tvp.modeling_tvp.TvpVideoGroundingOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),P=new Jt({props:{$$slots:{default:[$t]},$$scope:{ctx:z}}}),H=new It({props:{anchor:"transformers.TvpForVideoGrounding.forward.example",$$slots:{default:[Wt]},$$scope:{ctx:z}}}),je=new Zt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/tvp.md"}}),{c(){d=a("meta"),y=s(),m=a("p"),M=s(),f(v.$$.fragment),c=s(),f(w.$$.fragment),Qe=s(),D=a("p"),D.innerHTML=Do,Se=s(),Y=a("p"),Y.textContent=Yo,Le=s(),K=a("p"),K.innerHTML=Ko,qe=s(),O=a("p"),O.textContent=Oo,De=s(),W=a("img"),Ye=s(),ee=a("small"),ee.innerHTML=ot,Ke=s(),oe=a("p"),oe.innerHTML=tt,Oe=s(),f(te.$$.fragment),eo=s(),ne=a("p"),ne.textContent=nt,oo=s(),se=a("p"),se.textContent=st,to=s(),re=a("p"),re.textContent=rt,no=s(),ae=a("p"),ae.innerHTML=at,so=s(),ie=a("p"),ie.innerHTML=it,ro=s(),f(le.$$.fragment),ao=s(),de=a("p"),de.textContent=lt,io=s(),ce=a("ul"),ce.innerHTML=dt,lo=s(),f(pe.$$.fragment),co=s(),J=a("div"),f(me.$$.fragment),Io=s(),ke=a("p"),ke.innerHTML=ct,Uo=s(),Be=a("p"),Be.innerHTML=pt,jo=s(),V=a("div"),f(fe.$$.fragment),Co=s(),Ze=a("p"),Ze.innerHTML=mt,xo=s(),F=a("div"),f(he.$$.fragment),ko=s(),Ge=a("p"),Ge.innerHTML=ft,po=s(),f(ue.$$.fragment),mo=s(),B=a("div"),f(ge.$$.fragment),Bo=s(),ze=a("p"),ze.textContent=ht,Zo=s(),A=a("div"),f(_e.$$.fragment),Go=s(),$e=a("p"),$e.textContent=ut,fo=s(),f(Te.$$.fragment),ho=s(),I=a("div"),f(Me.$$.fragment),zo=s(),We=a("p"),We.textContent=gt,$o=s(),Ve=a("p"),Ve.innerHTML=_t,Wo=s(),N=a("div"),f(ve.$$.fragment),Vo=s(),Fe=a("p"),Fe.innerHTML=Tt,uo=s(),f(ye.$$.fragment),go=s(),Z=a("div"),f(be.$$.fragment),Fo=s(),Ae=a("p"),Ae.innerHTML=Mt,Ao=s(),x=a("div"),f(we.$$.fragment),No=s(),Ne=a("p"),Ne.innerHTML=vt,Ro=s(),f(R.$$.fragment),Xo=s(),f(X.$$.fragment),_o=s(),f(Je.$$.fragment),To=s(),U=a("div"),f(Ie.$$.fragment),Po=s(),Re=a("p"),Re.textContent=yt,Ho=s(),Xe=a("p"),Xe.innerHTML=bt,Eo=s(),k=a("div"),f(Ue.$$.fragment),Qo=s(),Pe=a("p"),Pe.innerHTML=wt,So=s(),f(P.$$.fragment),Lo=s(),f(H.$$.fragment),Mo=s(),f(je.$$.fragment),vo=s(),Ee=a("p"),this.h()},l(e){const o=Bt("svelte-u9bgzb",document.head);d=i(o,"META",{name:!0,content:!0}),o.forEach(t),y=r(e),m=i(e,"P",{}),C(m).forEach(t),M=r(e),h(v.$$.fragment,e),c=r(e),h(w.$$.fragment,e),Qe=r(e),D=i(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-ru7f7y"&&(D.innerHTML=Do),Se=r(e),Y=i(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-vfdo9a"&&(Y.textContent=Yo),Le=r(e),K=i(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-ez3ksy"&&(K.innerHTML=Ko),qe=r(e),O=i(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-e6jl89"&&(O.textContent=Oo),De=r(e),W=i(e,"IMG",{src:!0,alt:!0,width:!0}),Ye=r(e),ee=i(e,"SMALL",{"data-svelte-h":!0}),p(ee)!=="svelte-5ezgfp"&&(ee.innerHTML=ot),Ke=r(e),oe=i(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-3zatzf"&&(oe.innerHTML=tt),Oe=r(e),h(te.$$.fragment,e),eo=r(e),ne=i(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-1cyrqov"&&(ne.textContent=nt),oo=r(e),se=i(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-1bgttui"&&(se.textContent=st),to=r(e),re=i(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-1w5jusu"&&(re.textContent=rt),no=r(e),ae=i(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-4loe9o"&&(ae.innerHTML=at),so=r(e),ie=i(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-ix9ehh"&&(ie.innerHTML=it),ro=r(e),h(le.$$.fragment,e),ao=r(e),de=i(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-axv494"&&(de.textContent=lt),io=r(e),ce=i(e,"UL",{"data-svelte-h":!0}),p(ce)!=="svelte-1qzw8ck"&&(ce.innerHTML=dt),lo=r(e),h(pe.$$.fragment,e),co=r(e),J=i(e,"DIV",{class:!0});var j=C(J);h(me.$$.fragment,j),Io=r(j),ke=i(j,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-1eepko4"&&(ke.innerHTML=ct),Uo=r(j),Be=i(j,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-1m8gk6z"&&(Be.innerHTML=pt),jo=r(j),V=i(j,"DIV",{class:!0});var Ce=C(V);h(fe.$$.fragment,Ce),Co=r(Ce),Ze=i(Ce,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-sl9tw3"&&(Ze.innerHTML=mt),Ce.forEach(t),xo=r(j),F=i(j,"DIV",{class:!0});var xe=C(F);h(he.$$.fragment,xe),ko=r(xe),Ge=i(xe,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-4u167z"&&(Ge.innerHTML=ft),xe.forEach(t),j.forEach(t),po=r(e),h(ue.$$.fragment,e),mo=r(e),B=i(e,"DIV",{class:!0});var $=C(B);h(ge.$$.fragment,$),Bo=r($),ze=i($,"P",{"data-svelte-h":!0}),p(ze)!=="svelte-18mjwp8"&&(ze.textContent=ht),Zo=r($),A=i($,"DIV",{class:!0});var bo=C(A);h(_e.$$.fragment,bo),Go=r(bo),$e=i(bo,"P",{"data-svelte-h":!0}),p($e)!=="svelte-1x3yxsa"&&($e.textContent=ut),bo.forEach(t),$.forEach(t),fo=r(e),h(Te.$$.fragment,e),ho=r(e),I=i(e,"DIV",{class:!0});var E=C(I);h(Me.$$.fragment,E),zo=r(E),We=i(E,"P",{"data-svelte-h":!0}),p(We)!=="svelte-zs1zlw"&&(We.textContent=gt),$o=r(E),Ve=i(E,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-a1ovb2"&&(Ve.innerHTML=_t),Wo=r(E),N=i(E,"DIV",{class:!0});var wo=C(N);h(ve.$$.fragment,wo),Vo=r(wo),Fe=i(wo,"P",{"data-svelte-h":!0}),p(Fe)!=="svelte-1ymp2cu"&&(Fe.innerHTML=Tt),wo.forEach(t),E.forEach(t),uo=r(e),h(ye.$$.fragment,e),go=r(e),Z=i(e,"DIV",{class:!0});var He=C(Z);h(be.$$.fragment,He),Fo=r(He),Ae=i(He,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-15idequ"&&(Ae.innerHTML=Mt),Ao=r(He),x=i(He,"DIV",{class:!0});var Q=C(x);h(we.$$.fragment,Q),No=r(Q),Ne=i(Q,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-12gv8je"&&(Ne.innerHTML=vt),Ro=r(Q),h(R.$$.fragment,Q),Xo=r(Q),h(X.$$.fragment,Q),Q.forEach(t),He.forEach(t),_o=r(e),h(Je.$$.fragment,e),To=r(e),U=i(e,"DIV",{class:!0});var S=C(U);h(Ie.$$.fragment,S),Po=r(S),Re=i(S,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-sl1gwa"&&(Re.textContent=yt),Ho=r(S),Xe=i(S,"P",{"data-svelte-h":!0}),p(Xe)!=="svelte-1gjh92c"&&(Xe.innerHTML=bt),Eo=r(S),k=i(S,"DIV",{class:!0});var L=C(k);h(Ue.$$.fragment,L),Qo=r(L),Pe=i(L,"P",{"data-svelte-h":!0}),p(Pe)!=="svelte-qypx7m"&&(Pe.innerHTML=wt),So=r(L),h(P.$$.fragment,L),Lo=r(L),h(H.$$.fragment,L),L.forEach(t),S.forEach(t),Mo=r(e),h(je.$$.fragment,e),vo=r(e),Ee=i(e,"P",{}),C(Ee).forEach(t),this.h()},h(){b(d,"name","hf:doc:metadata"),b(d,"content",Ft),jt(W.src,et="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/tvp_architecture.png")||b(W,"src",et),b(W,"alt","drawing"),b(W,"width","600"),b(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){l(document.head,d),n(e,y,o),n(e,m,o),n(e,M,o),u(v,e,o),n(e,c,o),u(w,e,o),n(e,Qe,o),n(e,D,o),n(e,Se,o),n(e,Y,o),n(e,Le,o),n(e,K,o),n(e,qe,o),n(e,O,o),n(e,De,o),n(e,W,o),n(e,Ye,o),n(e,ee,o),n(e,Ke,o),n(e,oe,o),n(e,Oe,o),u(te,e,o),n(e,eo,o),n(e,ne,o),n(e,oo,o),n(e,se,o),n(e,to,o),n(e,re,o),n(e,no,o),n(e,ae,o),n(e,so,o),n(e,ie,o),n(e,ro,o),u(le,e,o),n(e,ao,o),n(e,de,o),n(e,io,o),n(e,ce,o),n(e,lo,o),u(pe,e,o),n(e,co,o),n(e,J,o),u(me,J,null),l(J,Io),l(J,ke),l(J,Uo),l(J,Be),l(J,jo),l(J,V),u(fe,V,null),l(V,Co),l(V,Ze),l(J,xo),l(J,F),u(he,F,null),l(F,ko),l(F,Ge),n(e,po,o),u(ue,e,o),n(e,mo,o),n(e,B,o),u(ge,B,null),l(B,Bo),l(B,ze),l(B,Zo),l(B,A),u(_e,A,null),l(A,Go),l(A,$e),n(e,fo,o),u(Te,e,o),n(e,ho,o),n(e,I,o),u(Me,I,null),l(I,zo),l(I,We),l(I,$o),l(I,Ve),l(I,Wo),l(I,N),u(ve,N,null),l(N,Vo),l(N,Fe),n(e,uo,o),u(ye,e,o),n(e,go,o),n(e,Z,o),u(be,Z,null),l(Z,Fo),l(Z,Ae),l(Z,Ao),l(Z,x),u(we,x,null),l(x,No),l(x,Ne),l(x,Ro),u(R,x,null),l(x,Xo),u(X,x,null),n(e,_o,o),u(Je,e,o),n(e,To,o),n(e,U,o),u(Ie,U,null),l(U,Po),l(U,Re),l(U,Ho),l(U,Xe),l(U,Eo),l(U,k),u(Ue,k,null),l(k,Qo),l(k,Pe),l(k,So),u(P,k,null),l(k,Lo),u(H,k,null),n(e,Mo,o),u(je,e,o),n(e,vo,o),n(e,Ee,o),yo=!0},p(e,[o]){const j={};o&2&&(j.$$scope={dirty:o,ctx:e}),R.$set(j);const Ce={};o&2&&(Ce.$$scope={dirty:o,ctx:e}),X.$set(Ce);const xe={};o&2&&(xe.$$scope={dirty:o,ctx:e}),P.$set(xe);const $={};o&2&&($.$$scope={dirty:o,ctx:e}),H.$set($)},i(e){yo||(g(v.$$.fragment,e),g(w.$$.fragment,e),g(te.$$.fragment,e),g(le.$$.fragment,e),g(pe.$$.fragment,e),g(me.$$.fragment,e),g(fe.$$.fragment,e),g(he.$$.fragment,e),g(ue.$$.fragment,e),g(ge.$$.fragment,e),g(_e.$$.fragment,e),g(Te.$$.fragment,e),g(Me.$$.fragment,e),g(ve.$$.fragment,e),g(ye.$$.fragment,e),g(be.$$.fragment,e),g(we.$$.fragment,e),g(R.$$.fragment,e),g(X.$$.fragment,e),g(Je.$$.fragment,e),g(Ie.$$.fragment,e),g(Ue.$$.fragment,e),g(P.$$.fragment,e),g(H.$$.fragment,e),g(je.$$.fragment,e),yo=!0)},o(e){_(v.$$.fragment,e),_(w.$$.fragment,e),_(te.$$.fragment,e),_(le.$$.fragment,e),_(pe.$$.fragment,e),_(me.$$.fragment,e),_(fe.$$.fragment,e),_(he.$$.fragment,e),_(ue.$$.fragment,e),_(ge.$$.fragment,e),_(_e.$$.fragment,e),_(Te.$$.fragment,e),_(Me.$$.fragment,e),_(ve.$$.fragment,e),_(ye.$$.fragment,e),_(be.$$.fragment,e),_(we.$$.fragment,e),_(R.$$.fragment,e),_(X.$$.fragment,e),_(Je.$$.fragment,e),_(Ie.$$.fragment,e),_(Ue.$$.fragment,e),_(P.$$.fragment,e),_(H.$$.fragment,e),_(je.$$.fragment,e),yo=!1},d(e){e&&(t(y),t(m),t(M),t(c),t(Qe),t(D),t(Se),t(Y),t(Le),t(K),t(qe),t(O),t(De),t(W),t(Ye),t(ee),t(Ke),t(oe),t(Oe),t(eo),t(ne),t(oo),t(se),t(to),t(re),t(no),t(ae),t(so),t(ie),t(ro),t(ao),t(de),t(io),t(ce),t(lo),t(co),t(J),t(po),t(mo),t(B),t(fo),t(ho),t(I),t(uo),t(go),t(Z),t(_o),t(To),t(U),t(Mo),t(vo),t(Ee)),t(d),T(v,e),T(w,e),T(te,e),T(le,e),T(pe,e),T(me),T(fe),T(he),T(ue,e),T(ge),T(_e),T(Te,e),T(Me),T(ve),T(ye,e),T(be),T(we),T(R),T(X),T(Je,e),T(Ie),T(Ue),T(P),T(H),T(je,e)}}}const Ft='{"title":"TVP","local":"tvp","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips and examples","local":"usage-tips-and-examples","sections":[],"depth":2},{"title":"TvpConfig","local":"transformers.TvpConfig","sections":[],"depth":2},{"title":"TvpImageProcessor","local":"transformers.TvpImageProcessor","sections":[],"depth":2},{"title":"TvpProcessor","local":"transformers.TvpProcessor","sections":[],"depth":2},{"title":"TvpModel","local":"transformers.TvpModel","sections":[],"depth":2},{"title":"TvpForVideoGrounding","local":"transformers.TvpForVideoGrounding","sections":[],"depth":2}],"depth":1}';function At(z){return Ct(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class St extends xt{constructor(d){super(),kt(this,d,At,Vt,Ut,{})}}export{St as component};
