import{s as hs,n as us,o as cs}from"../chunks/scheduler.85c25b89.js";import{S as fs,i as gs,g as r,s,r as m,A as vs,h as a,f as n,c as o,j as b,u as p,x as d,k as x,l as cl,y as i,a as l,v as h,d as u,t as c,w as f}from"../chunks/index.c9bcf812.js";import{D as w}from"../chunks/Docstring.46c9d080.js";import{C as P}from"../chunks/CodeBlock.94efc595.js";import{H as M,E as ys}from"../chunks/EditOnGithub.ec73e7c7.js";function bs(fl){let _,xe,ye,$e,R,we,Z,gl="Text environments provide a learning ground for language agents. It allows a language model to use tools to accomplish a task such as using a Python interpreter to answer math questions or using a search index for trivia questions. Having access to tools allows language models to solve tasks that would be very hard for the models itself but can be trivial for the appropriate tools. A good example is arithmetics of large numbers that become a simple copy-paste task once you have access to a calculator.",Me,C,vl='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/textenv.png"/>',Te,G,yl="Let’s dive into how text environments work and start with tools!",_e,Q,Ce,W,bl="One of the core building blocks of text environments are tools that the model can use to solve tasks. In general tools can be any Python function that takes a string as input and returns string. The <code>TextEnvironment</code> offers two options for tools: either go with predefined tools from <code>transformers.Tool</code> or define your own function or class with <code>__call__</code> method. Let’s have a look at both!",ke,S,Ue,A,xl="Text environments fully support tools of the class <code>transformers.Tool</code>. The advantage of building tools in that framework is that they can easily be shared",je,D,Je,F,$l="These tools are either loaded from the hub or from a local folder. Using the tool is as simple as calling them with a text query:",He,Y,Ee,O,wl="Note that both input and return values are strings to enable easy usage with a language model.",qe,K,ze,tt,Ml="The following is an example of a tool that adds two integers:",Le,et,Ie,nt,Tl="We looked at basic examples such as a calculator but the principle holds for more complex tools as well such as a web search tool where you input the query and get the search results in return. Now let’s look at how the model can use the tools with the call syntax.",Ne,lt,Ve,st,_l="In order to have a unified way for the model to call a tool we created a simple syntax that looks as follows:",Xe,ot,Be,rt,Cl="There are a few special tokens involved so let’s decompose it: First the model can signal that it wants to use a tool by emitting the <code>&lt;request&gt;</code> token. After that we want to know the name of the tool to call which is done by enclosing the tool name with <code>&lt;&gt;</code> brackets. Once we know which tool to call the tool query follows which is in free text form. The <code>&lt;call&gt;</code> tokens signifies the end of the query and stops the model generation. At this point the model output is parsed and the query sent to the tool. The environment appends the tool response to the string followed by the <code>&lt;response&gt;</code> token to show the end the tool output.",Pe,at,kl="Let’s look at the concrete example of the calculator and assume its name is <code>Calculator</code> (more on how the name of a tool is inferred later):",Re,it,Ze,dt,Ul="Finally, the episode is ended and generation stops when the model generates <code>&lt;submit&gt;</code> which marks the interaction as completed.",Ge,mt,jl="Now let’s have a look how we can create a new text environment!",Qe,pt,We,ht,Se,ut,Jl="Let’s decompose the settings:",Ae,ct,Hl='<thead><tr><th align="left">Argument</th> <th align="left">Description</th></tr></thead> <tbody><tr><td align="left"><code>model</code></td> <td align="left">Language model to interact with the environment and generate requests.</td></tr> <tr><td align="left"><code>tokenizer</code></td> <td align="left">Tokenizer of language model handling tokenization of strings.</td></tr> <tr><td align="left"><code>tools</code></td> <td align="left"><code>list</code> of <code>dict</code> of tools. If former the name of the tool is inferred from class name and otherwise it’s the keys of the dictionary.</td></tr> <tr><td align="left"><code>reward_fn</code></td> <td align="left">A function that takes a string as input and returns. Can have extra arguments that are passed to <code>.run()</code> such as ground truth.</td></tr> <tr><td align="left"><code>prompt</code></td> <td align="left">Prompt to prepend to every task. Usually a few examples to demonstrate to the model how to use the tools in a few-shot fashion.</td></tr> <tr><td align="left"><code>max_turns</code></td> <td align="left">Maximum number of interactions between model and tools before episode ends.</td></tr> <tr><td align="left"><code>max_tool_response</code></td> <td align="left">The tool response is truncated to this number to avoid running out of model context.</td></tr> <tr><td align="left"><code>max_length</code></td> <td align="left">The maximum number of tokens to allow in an episode.</td></tr> <tr><td align="left"><code>generation_kwargs</code></td> <td align="left">Generation settings used by the language model.</td></tr></tbody>',De,ft,El="You can customize the environment to your needs and add custom tools and settings. Let’s see how you can use the environment to have the model interact with the available tools!",Fe,gt,Ye,vt,ql="To run a set of queries through the text environment one can simply use the <code>run</code> method.",Oe,yt,Ke,bt,zl="This will execute the model/tool feedback loop for each query until either no tool is called anymore, the maximum number of turns is reached or to maximum number of tokens in an episode is exceeded. The extra <code>kwargs</code> (e.g. <code>answers=answers</code> above) passed to <code>run</code> will be passed on to the reward function.",tn,xt,Ll="There are five objects that are returned by <code>run</code>:",en,$t,Il="<li><code>queries</code>: a list of the tokenized queries</li> <li><code>responses</code>: all tokens that have been generated withing the environment including model and tool tokens</li> <li><code>masks</code>: mask that indicates which tokens have been generated by the model and which tokens are generated by the tool</li> <li><code>rewards</code>: a list of reward for each query/response</li> <li><code>histories</code>: list of <code>TextHistory</code> objects, which are useful objects containing all the above and also the text equivalents</li>",nn,wt,Nl="The masks are crucial for training as we don’t want to optimize tokens that the model has not generated which are tokens produced by the tools.",ln,Mt,Vl="Next, we’ll train a PPO step with the generated responses!",sn,Tt,on,_t,Xl="Training on episodes from the <code>TextEnvironment</code> is straight forward and simply requires forwarding all the returned variables except the <code>TextHistory</code> objects to the <code>step</code> method:",rn,Ct,an,kt,dn,Ut,Bl="The <code>TextHistory</code> object stores the interactions between the model and the text environment. It stores tokens and text generated in each turn and their source in each turn (model or system) as well as rewards. Let’s go through the class attributes and methods.",mn,jt,pn,Jt,Pl="The following table summarises the available attributes of the <code>TextEnvironment</code> class:",hn,Ht,Rl='<thead><tr><th align="left">Attribute</th> <th align="left">Description</th></tr></thead> <tbody><tr><td align="left"><code>text</code></td> <td align="left">The full string of the text generated in the text environment with both model and system generated text.</td></tr> <tr><td align="left"><code>text_spans</code></td> <td align="left">A list of tuples with the spans for each model or system generated text segment.</td></tr> <tr><td align="left"><code>system_spans</code></td> <td align="left">A list of boolean values indicating if the segment is model or system generated.</td></tr> <tr><td align="left"><code>tokens</code></td> <td align="left">All tokens generated in text environment with both model and system generated tokens.</td></tr> <tr><td align="left"><code>token_spans</code></td> <td align="left">Similar to <code>text_spans</code> the <code>token_spans</code> indicate the boundaries of model andsystem generated tokens.</td></tr> <tr><td align="left"><code>token_masks</code></td> <td align="left">The token masks can be used to ignore system generated tokens by masking them.</td></tr> <tr><td align="left"><code>completed</code></td> <td align="left">Indicates if the interaction with the environment has completed.</td></tr> <tr><td align="left"><code>truncated</code></td> <td align="left">Indicates if the interaction with the environment has completed because max length was reached.</td></tr></tbody>',un,Et,Zl="With these attributes you can reconstruct every interaction of the model with the <code>TextEnvironment</code>. The <code>TextHistory</code> also lets you visualize the text history. Let’s have a look!",cn,qt,fn,zt,Gl='When the model interacts inside the <code>TextEnvironment</code> it can be useful to visualize and separate which parts of the text outputs were generated by the model and which parts come from the system and tools. For that purpose there are the two methods <a href="/docs/trl/pr_1795/en/text_environments#trl.TextHistory.show_text">TextHistory.show_text()</a> and <a href="/docs/trl/pr_1795/en/text_environments#trl.TextHistory.show_tokens">TextHistory.show_tokens()</a>. They print the text and tokens respectively and highlight the various segments using the <a href="https://github.com/Textualize/rich" rel="nofollow"><code>rich</code> libray</a> (make sure to install it before using these methods).',gn,Lt,Ql="You can see that the prompt is highlighted in gray, whereas system segments such as query and tool responses are highlighted in green. All segments generated by the model are highlighted in blue and in addition to the pure text output the reward is displayed as additional text in plum. Here an example of <code>show_text</code>:",vn,k,Wl='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/textenv_show_text.png" width="600"/>',yn,It,Sl="Sometimes there can be tricky tokenization related issues that are hidden when showing the decoded text. Thus <code>TextHistory</code> also offers an option to display the same highlighting on the tokens directly with <code>show_tokens</code>:",bn,U,Al='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/textenv_show_tokens.png" width="800"/>',xn,Nt,Dl="Note that you can turn on the colour legend by passing <code>show_legend=True</code>.",$n,Vt,wn,g,Xt,Xn,ee,Fl="The TextEnvironment enables interaction of a LLM with an environment using tools.",Bn,j,Bt,Pn,ne,Yl="Compute the reward for a list of histories.",Rn,J,Pt,Zn,le,Ol="Generate responses for a list of histories.",Gn,H,Rt,Qn,se,Kl="Parse request string. Expected format: <request><tool_name>query<call>",Wn,E,Zt,Sn,oe,ts="Run the environment on a list of queries.",An,q,Gt,Dn,re,es="Step the environment forward one turn.",Fn,z,Qt,Yn,ae,ns="Check if the current generation sequence has finished.",On,L,Wt,Kn,ie,ls="Check if the current generation sequences have finished.",Mn,v,St,tl,de,ss="The TextHistory class keeps track of the history of an interaction between the language model and the environment.",el,T,At,nl,me,os="Append a new segment to the history.",ll,pe,rs=`args:
text (<code>str</code>): The text of the new segment.
tokens (<code>torch.LongTensor</code>): The tokens of the new segment.
system (<code>bool</code>, <em>optional</em>): Whether the new segment is a system or user segment.`,sl,I,Dt,ol,he,as="Mark the history as completed.",rl,N,Ft,al,ue,is="Print the colour legend.",il,V,Yt,dl,ce,ds="Print the text history.",ml,X,Ot,pl,fe,ms="Print the history tokens.",hl,B,Kt,ul,ge,ps="Split the tokens into query and response tokens.",Tn,te,_n,be,Cn;return R=new M({props:{title:"Text Environments",local:"text-environments",headingTag:"h1"}}),Q=new M({props:{title:"Tools",local:"tools",headingTag:"h2"}}),S=new M({props:{title:"transformers.Tool",local:"transformerstool",headingTag:"h3"}}),D=new P({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGxvYWRfdG9vbCUwQSUwQSUyMyUyMHNpbXBsZSUyMGNhbGN1bGF0b3IlMjB0b29sJTIwdGhhdCUyMHJ1bnMlMjAlMkItJTJGKiUyMG9wZXJhdGlvbnMlMEFjYWxjX3Rvb2wlMjAlM0QlMjBsb2FkX3Rvb2woJTIyeWJlbGthZGElMkZzaW1wbGUtY2FsY3VsYXRvciUyMiklMEElMEElMjMlMjBweXRob24lMjBpbnRlcnByZXRlciUyMHRoYXQlMjBleGVjdXRlcyUyMHByb2dyYW0lMjBhbmQlMjByZXR1cm5zJTIwb3V0cHV0cyUwQXB5X3Rvb2wlMjAlM0QlMjBsb2FkX3Rvb2woJTIybHZ3ZXJyYSUyRnB5dGhvbi1pbnRlcnByZXRlciUyMiklMEElMEElMjMlMjB3aWtpcGVkaWElMjBzZWFyY2glMjBpbmRleCUyMHRoYXQlMjByZXR1cm5zJTIwYmVzdCUyMHNlYXJjaCUyMG1hdGNoJTBBd2lraV90b29sJTIwJTNEJTIwbG9hZF90b29sKCUyMnZ3eHl6am4lMkZweXNlcmluaS13aWtpcGVkaWEta2lsdC1kb2MlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> load_tool

<span class="hljs-comment"># simple calculator tool that runs +-/* operations</span>
calc_tool = load_tool(<span class="hljs-string">&quot;ybelkada/simple-calculator&quot;</span>)

<span class="hljs-comment"># python interpreter that executes program and returns outputs</span>
py_tool = load_tool(<span class="hljs-string">&quot;lvwerra/python-interpreter&quot;</span>)

<span class="hljs-comment"># wikipedia search index that returns best search match</span>
wiki_tool = load_tool(<span class="hljs-string">&quot;vwxyzjn/pyserini-wikipedia-kilt-doc&quot;</span>)`,wrap:!1}}),Y=new P({props:{code:"JTIyMC41JTIy",highlighted:`calc_tool(<span class="hljs-string">&quot;1/2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-string">&quot;0.5&quot;</span>`,wrap:!1}}),K=new M({props:{title:"Custom Tools",local:"custom-tools",headingTag:"h3"}}),et=new P({props:{code:"JTBBJTIyMiUyMg==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">add</span>(<span class="hljs-params">text</span>):
    int_1, int_2 = text.split(<span class="hljs-string">&quot;+&quot;</span>)
    result = <span class="hljs-built_in">int</span>(int_1) + <span class="hljs-built_in">int</span>(int_2)
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">str</span>(result)

<span class="hljs-built_in">print</span>(add(<span class="hljs-string">&quot;1+1&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-string">&quot;2&quot;</span>`,wrap:!1}}),lt=new M({props:{title:"Call syntax",local:"call-syntax",headingTag:"h3"}}),ot=new P({props:{code:"JTIyJTNDcmVxdWVzdCUzRSUzQ1RPT0xfTkFNRSUzRVFVRVJZJTNDY2FsbCUzRVRPT0xfUkVTUE9OU0UlM0NyZXNwb25zZSUzRSUyMg==",highlighted:'<span class="hljs-string">&quot;&lt;request&gt;&lt;TOOL_NAME&gt;QUERY&lt;call&gt;TOOL_RESPONSE&lt;response&gt;&quot;</span>',wrap:!1}}),it=new P({props:{code:"JTIyJTNDcmVxdWVzdCUzRSUzQ0NhbGN1bGF0b3IlM0UxJTJGMiUzQ2NhbGwlM0UwLjUlM0NyZXNwb25zZSUzRSUyMg==",highlighted:'<span class="hljs-string">&quot;&lt;request&gt;&lt;Calculator&gt;1/2&lt;call&gt;0.5&lt;response&gt;&quot;</span>',wrap:!1}}),pt=new M({props:{title:"Create a TextEnvironment",local:"create-a-textenvironment",headingTag:"h2"}}),ht=new P({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyJTIyJTIyJTVDJTBBV2hhdCUyMGlzJTIwMTMtMyUzRiUwQSUzQ3JlcXVlc3QlM0UlM0NTaW1wbGVDYWxjdWxhdG9yVG9vbCUzRTEzLTMlM0NjYWxsJTNFMTAuMCUzQ3Jlc3BvbnNlJTNFJTBBUmVzdWx0JTNEMTAlM0NzdWJtaXQlM0UlMEElMjIlMjIlMjIlMEElMEFkZWYlMjByZXdhcmRfZm4ocmVzdWx0JTJDJTIwYW5zd2VyKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMlNpbXBsaWZpZWQlMjByZXdhcmQlMjBmdW5jdGlvbiUyMHJldHVybmluZyUyMDElMjBpZiUyMHJlc3VsdCUyMG1hdGNoZXMlMjBhbnN3ZXIlMjBhbmQlMjAwJTIwb3RoZXJ3aXNlLiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMHJlc3VsdF9wYXJzZWQlMjAlM0QlMjByZXN1bHQuc3BsaXQoJTIyJTNEJTIyKSU1QjElNUQuc3BsaXQoJTIyJTNDJTIyKSU1QjAlNUQlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbnQocmVzdWx0X3BhcnNlZCUzRCUzRGFuc3dlciklMEElMEF0ZXh0X2VudiUyMCUzRCUyMFRleHRFbnZpcm9uZW1udCglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTIwJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlMjAlN0IlMjJTaW1wbGVDYWxjdWxhdG9yVG9vbCUyMiUzQSUyMGxvYWRfdG9vbCglMjJ5YmVsa2FkYSUyRnNpbXBsZS1jYWxjdWxhdG9yJTIyKSU3RCUyQyUwQSUyMCUyMCUyMCUyMHJld2FyZF9mbiUzRGV4YWN0X21hdGNoX3Jld2FyZCUyQyUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUyMCUwQSUyMCUyMCUyMCUyMG1heF90dXJucyUzRDElMEElMjAlMjAlMjAlMjBtYXhfdG9vbF9yZXNwb25zZSUzRDEwMCUwQSUyMCUyMCUyMCUyMGdlbmVyYXRpb25fa3dhcmdzJTNEJTdCJTIyZG9fc2FtcGxlJTIyJTNBJTIwJTIydHJ1ZSUyMiU3RCUwQSk=",highlighted:`prompt = <span class="hljs-string">&quot;&quot;&quot;\\
What is 13-3?
&lt;request&gt;&lt;SimpleCalculatorTool&gt;13-3&lt;call&gt;10.0&lt;response&gt;
Result=10&lt;submit&gt;
&quot;&quot;&quot;</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">reward_fn</span>(<span class="hljs-params">result, answer</span>):
    <span class="hljs-string">&quot;&quot;&quot;Simplified reward function returning 1 if result matches answer and 0 otherwise.&quot;&quot;&quot;</span>
    result_parsed = result.split(<span class="hljs-string">&quot;=&quot;</span>)[<span class="hljs-number">1</span>].split(<span class="hljs-string">&quot;&lt;&quot;</span>)[<span class="hljs-number">0</span>]
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">int</span>(result_parsed==answer)

text_env = TextEnvironemnt(
    model=model, 
    tokenizer=tokenizer,
    tools= {<span class="hljs-string">&quot;SimpleCalculatorTool&quot;</span>: load_tool(<span class="hljs-string">&quot;ybelkada/simple-calculator&quot;</span>)},
    reward_fn=exact_match_reward,
    prompt=prompt, 
    max_turns=<span class="hljs-number">1</span>
    max_tool_response=<span class="hljs-number">100</span>
    generation_kwargs={<span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-string">&quot;true&quot;</span>}
)`,wrap:!1}}),gt=new M({props:{title:"Run an Episode",local:"run-an-episode",headingTag:"h2"}}),yt=new P({props:{code:"cXVlcmllcyUyMCUzRCUyMCU1QiUyMldoYXQlMjBpcyUyMDElMkYyJTNGJTIyJTVEJTBBYW5zd2VycyUyMCUzRCUyMCU1QiUyMjAuNSUyMiU1RCUwQSUwQXF1ZXJpZXMlMkMlMjByZXNwb25zZXMlMkMlMjBtYXNrcyUyQyUyMHJld2FyZHMlMkMlMjBoaXN0b3JpZXMlMjAlM0QlMjB0ZXh0X2Vudi5ydW4ocXVlcmllcyUyQyUyMGFuc3dlcnMlM0RhbnN3ZXJzKQ==",highlighted:`queries = [<span class="hljs-string">&quot;What is 1/2?&quot;</span>]
answers = [<span class="hljs-string">&quot;0.5&quot;</span>]

queries, responses, masks, rewards, histories = text_env.run(queries, answers=answers)`,wrap:!1}}),Tt=new M({props:{title:"Train",local:"train",headingTag:"h3"}}),Ct=new P({props:{code:"dHJhaW5fc3RhdHMlMjAlM0QlMjBwcG9fdHJhaW5lci5zdGVwKHF1ZXJpZXMlMkMlMjByZXNwb25zZXMlMkMlMjByZXdhcmRzJTJDJTIwbWFza3Mp",highlighted:"train_stats = ppo_trainer.step(queries, responses, rewards, masks)",wrap:!1}}),kt=new M({props:{title:"TextHistory",local:"texthistory",headingTag:"h2"}}),jt=new M({props:{title:"Attributes",local:"attributes",headingTag:"h3"}}),qt=new M({props:{title:"Visualization",local:"visualization",headingTag:"h3"}}),Vt=new M({props:{title:"API Documentation",local:"trl.TextEnvironment",headingTag:"h2"}}),Xt=new w({props:{name:"class trl.TextEnvironment",anchor:"trl.TextEnvironment",parameters:[{name:"model",val:" = None"},{name:"tokenizer",val:" = None"},{name:"tools",val:" = None"},{name:"reward_fn",val:" = None"},{name:"prompt",val:" = None"},{name:"max_turns",val:" = 4"},{name:"max_tool_reponse",val:" = 100"},{name:"max_length",val:" = None"},{name:"generation_kwargs",val:" = None"}],source:"https://github.com/huggingface/trl/blob/vr_1795/trl/environment/base_environment.py#L209"}}),Bt=new w({props:{name:"compute_reward",anchor:"trl.TextEnvironment.compute_reward",parameters:[{name:"histories",val:""},{name:"**reward_kwargs",val:""}],source:"https://github.com/huggingface/trl/blob/vr_1795/trl/environment/base_environment.py#L359"}}),Pt=new w({props:{name:"generate",anchor:"trl.TextEnvironment.generate",parameters:[{name:"histories",val:""}],source:"https://github.com/huggingface/trl/blob/vr_1795/trl/environment/base_environment.py#L368"}}),Rt=new w({props:{name:"parse_tool_call",anchor:"trl.TextEnvironment.parse_tool_call",parameters:[{name:"text",val:""}],source:"https://github.com/huggingface/trl/blob/vr_1795/trl/environment/base_environment.py#L334"}}),Zt=new w({props:{name:"run",anchor:"trl.TextEnvironment.run",parameters:[{name:"queries",val:""},{name:"**rewards_kwargs",val:""}],parametersDescription:[{anchor:"trl.TextEnvironment.run.queries",description:"<strong>queries</strong> (list[str]) &#x2014; A list of queries to run the model in the environment on.",name:"queries"}],source:"https://github.com/huggingface/trl/blob/vr_1795/trl/environment/base_environment.py#L264"}}),Gt=new w({props:{name:"step",anchor:"trl.TextEnvironment.step",parameters:[{name:"history",val:""}],parametersDescription:[{anchor:"trl.TextEnvironment.step.history",description:"<strong>history</strong> (<code>TextHistory</code>) &#x2014; The history to step forward.",name:"history"}],source:"https://github.com/huggingface/trl/blob/vr_1795/trl/environment/base_environment.py#L297"}}),Qt=new w({props:{name:"task_end_check",anchor:"trl.TextEnvironment.task_end_check",parameters:[{name:"history",val:""},{name:"model_turn",val:" = True"}],source:"https://github.com/huggingface/trl/blob/vr_1795/trl/environment/base_environment.py#L394"}}),Wt=new w({props:{name:"tasks_end_check",anchor:"trl.TextEnvironment.tasks_end_check",parameters:[{name:"histories",val:""},{name:"model_turn",val:" = True"}],source:"https://github.com/huggingface/trl/blob/vr_1795/trl/environment/base_environment.py#L383"}}),St=new w({props:{name:"class trl.TextHistory",anchor:"trl.TextHistory",parameters:[{name:"text",val:""},{name:"tokens",val:""},{name:"system",val:" = True"}],source:"https://github.com/huggingface/trl/blob/vr_1795/trl/environment/base_environment.py#L60"}}),At=new w({props:{name:"append_segment",anchor:"trl.TextHistory.append_segment",parameters:[{name:"text",val:""},{name:"tokens",val:""},{name:"system",val:" = True"}],source:"https://github.com/huggingface/trl/blob/vr_1795/trl/environment/base_environment.py#L89"}}),Dt=new w({props:{name:"complete",anchor:"trl.TextHistory.complete",parameters:[{name:"truncated",val:" = False"}],source:"https://github.com/huggingface/trl/blob/vr_1795/trl/environment/base_environment.py#L117"}}),Ft=new w({props:{name:"show_colour_legend",anchor:"trl.TextHistory.show_colour_legend",parameters:[],source:"https://github.com/huggingface/trl/blob/vr_1795/trl/environment/base_environment.py#L190"}}),Yt=new w({props:{name:"show_text",anchor:"trl.TextHistory.show_text",parameters:[{name:"show_legend",val:" = False"}],source:"https://github.com/huggingface/trl/blob/vr_1795/trl/environment/base_environment.py#L143"}}),Ot=new w({props:{name:"show_tokens",anchor:"trl.TextHistory.show_tokens",parameters:[{name:"tokenizer",val:""},{name:"show_legend",val:" = False"}],source:"https://github.com/huggingface/trl/blob/vr_1795/trl/environment/base_environment.py#L165"}}),Kt=new w({props:{name:"split_query_response_tokens",anchor:"trl.TextHistory.split_query_response_tokens",parameters:[],source:"https://github.com/huggingface/trl/blob/vr_1795/trl/environment/base_environment.py#L132"}}),te=new ys({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/text_environments.md"}}),{c(){_=r("meta"),xe=s(),ye=r("p"),$e=s(),m(R.$$.fragment),we=s(),Z=r("p"),Z.textContent=gl,Me=s(),C=r("div"),C.innerHTML=vl,Te=s(),G=r("p"),G.textContent=yl,_e=s(),m(Q.$$.fragment),Ce=s(),W=r("p"),W.innerHTML=bl,ke=s(),m(S.$$.fragment),Ue=s(),A=r("p"),A.innerHTML=xl,je=s(),m(D.$$.fragment),Je=s(),F=r("p"),F.textContent=$l,He=s(),m(Y.$$.fragment),Ee=s(),O=r("p"),O.textContent=wl,qe=s(),m(K.$$.fragment),ze=s(),tt=r("p"),tt.textContent=Ml,Le=s(),m(et.$$.fragment),Ie=s(),nt=r("p"),nt.textContent=Tl,Ne=s(),m(lt.$$.fragment),Ve=s(),st=r("p"),st.textContent=_l,Xe=s(),m(ot.$$.fragment),Be=s(),rt=r("p"),rt.innerHTML=Cl,Pe=s(),at=r("p"),at.innerHTML=kl,Re=s(),m(it.$$.fragment),Ze=s(),dt=r("p"),dt.innerHTML=Ul,Ge=s(),mt=r("p"),mt.textContent=jl,Qe=s(),m(pt.$$.fragment),We=s(),m(ht.$$.fragment),Se=s(),ut=r("p"),ut.textContent=Jl,Ae=s(),ct=r("table"),ct.innerHTML=Hl,De=s(),ft=r("p"),ft.textContent=El,Fe=s(),m(gt.$$.fragment),Ye=s(),vt=r("p"),vt.innerHTML=ql,Oe=s(),m(yt.$$.fragment),Ke=s(),bt=r("p"),bt.innerHTML=zl,tn=s(),xt=r("p"),xt.innerHTML=Ll,en=s(),$t=r("ul"),$t.innerHTML=Il,nn=s(),wt=r("p"),wt.textContent=Nl,ln=s(),Mt=r("p"),Mt.textContent=Vl,sn=s(),m(Tt.$$.fragment),on=s(),_t=r("p"),_t.innerHTML=Xl,rn=s(),m(Ct.$$.fragment),an=s(),m(kt.$$.fragment),dn=s(),Ut=r("p"),Ut.innerHTML=Bl,mn=s(),m(jt.$$.fragment),pn=s(),Jt=r("p"),Jt.innerHTML=Pl,hn=s(),Ht=r("table"),Ht.innerHTML=Rl,un=s(),Et=r("p"),Et.innerHTML=Zl,cn=s(),m(qt.$$.fragment),fn=s(),zt=r("p"),zt.innerHTML=Gl,gn=s(),Lt=r("p"),Lt.innerHTML=Ql,vn=s(),k=r("div"),k.innerHTML=Wl,yn=s(),It=r("p"),It.innerHTML=Sl,bn=s(),U=r("div"),U.innerHTML=Al,xn=s(),Nt=r("p"),Nt.innerHTML=Dl,$n=s(),m(Vt.$$.fragment),wn=s(),g=r("div"),m(Xt.$$.fragment),Xn=s(),ee=r("p"),ee.textContent=Fl,Bn=s(),j=r("div"),m(Bt.$$.fragment),Pn=s(),ne=r("p"),ne.textContent=Yl,Rn=s(),J=r("div"),m(Pt.$$.fragment),Zn=s(),le=r("p"),le.textContent=Ol,Gn=s(),H=r("div"),m(Rt.$$.fragment),Qn=s(),se=r("p"),se.textContent=Kl,Wn=s(),E=r("div"),m(Zt.$$.fragment),Sn=s(),oe=r("p"),oe.textContent=ts,An=s(),q=r("div"),m(Gt.$$.fragment),Dn=s(),re=r("p"),re.textContent=es,Fn=s(),z=r("div"),m(Qt.$$.fragment),Yn=s(),ae=r("p"),ae.textContent=ns,On=s(),L=r("div"),m(Wt.$$.fragment),Kn=s(),ie=r("p"),ie.textContent=ls,Mn=s(),v=r("div"),m(St.$$.fragment),tl=s(),de=r("p"),de.textContent=ss,el=s(),T=r("div"),m(At.$$.fragment),nl=s(),me=r("p"),me.textContent=os,ll=s(),pe=r("p"),pe.innerHTML=rs,sl=s(),I=r("div"),m(Dt.$$.fragment),ol=s(),he=r("p"),he.textContent=as,rl=s(),N=r("div"),m(Ft.$$.fragment),al=s(),ue=r("p"),ue.textContent=is,il=s(),V=r("div"),m(Yt.$$.fragment),dl=s(),ce=r("p"),ce.textContent=ds,ml=s(),X=r("div"),m(Ot.$$.fragment),pl=s(),fe=r("p"),fe.textContent=ms,hl=s(),B=r("div"),m(Kt.$$.fragment),ul=s(),ge=r("p"),ge.textContent=ps,Tn=s(),m(te.$$.fragment),_n=s(),be=r("p"),this.h()},l(t){const e=vs("svelte-u9bgzb",document.head);_=a(e,"META",{name:!0,content:!0}),e.forEach(n),xe=o(t),ye=a(t,"P",{}),b(ye).forEach(n),$e=o(t),p(R.$$.fragment,t),we=o(t),Z=a(t,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-1xyqi3j"&&(Z.textContent=gl),Me=o(t),C=a(t,"DIV",{style:!0,"data-svelte-h":!0}),d(C)!=="svelte-1trtrmz"&&(C.innerHTML=vl),Te=o(t),G=a(t,"P",{"data-svelte-h":!0}),d(G)!=="svelte-1fzari6"&&(G.textContent=yl),_e=o(t),p(Q.$$.fragment,t),Ce=o(t),W=a(t,"P",{"data-svelte-h":!0}),d(W)!=="svelte-tw2sw7"&&(W.innerHTML=bl),ke=o(t),p(S.$$.fragment,t),Ue=o(t),A=a(t,"P",{"data-svelte-h":!0}),d(A)!=="svelte-ooeso0"&&(A.innerHTML=xl),je=o(t),p(D.$$.fragment,t),Je=o(t),F=a(t,"P",{"data-svelte-h":!0}),d(F)!=="svelte-n1kfsw"&&(F.textContent=$l),He=o(t),p(Y.$$.fragment,t),Ee=o(t),O=a(t,"P",{"data-svelte-h":!0}),d(O)!=="svelte-cvmhd6"&&(O.textContent=wl),qe=o(t),p(K.$$.fragment,t),ze=o(t),tt=a(t,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-16zvcez"&&(tt.textContent=Ml),Le=o(t),p(et.$$.fragment,t),Ie=o(t),nt=a(t,"P",{"data-svelte-h":!0}),d(nt)!=="svelte-1180ir7"&&(nt.textContent=Tl),Ne=o(t),p(lt.$$.fragment,t),Ve=o(t),st=a(t,"P",{"data-svelte-h":!0}),d(st)!=="svelte-11yatwq"&&(st.textContent=_l),Xe=o(t),p(ot.$$.fragment,t),Be=o(t),rt=a(t,"P",{"data-svelte-h":!0}),d(rt)!=="svelte-1jmhsjt"&&(rt.innerHTML=Cl),Pe=o(t),at=a(t,"P",{"data-svelte-h":!0}),d(at)!=="svelte-1swzwy8"&&(at.innerHTML=kl),Re=o(t),p(it.$$.fragment,t),Ze=o(t),dt=a(t,"P",{"data-svelte-h":!0}),d(dt)!=="svelte-1v8f0zk"&&(dt.innerHTML=Ul),Ge=o(t),mt=a(t,"P",{"data-svelte-h":!0}),d(mt)!=="svelte-14nr4ad"&&(mt.textContent=jl),Qe=o(t),p(pt.$$.fragment,t),We=o(t),p(ht.$$.fragment,t),Se=o(t),ut=a(t,"P",{"data-svelte-h":!0}),d(ut)!=="svelte-1sl46j2"&&(ut.textContent=Jl),Ae=o(t),ct=a(t,"TABLE",{"data-svelte-h":!0}),d(ct)!=="svelte-1ffep7v"&&(ct.innerHTML=Hl),De=o(t),ft=a(t,"P",{"data-svelte-h":!0}),d(ft)!=="svelte-yvijza"&&(ft.textContent=El),Fe=o(t),p(gt.$$.fragment,t),Ye=o(t),vt=a(t,"P",{"data-svelte-h":!0}),d(vt)!=="svelte-6qt7x3"&&(vt.innerHTML=ql),Oe=o(t),p(yt.$$.fragment,t),Ke=o(t),bt=a(t,"P",{"data-svelte-h":!0}),d(bt)!=="svelte-uwb7dt"&&(bt.innerHTML=zl),tn=o(t),xt=a(t,"P",{"data-svelte-h":!0}),d(xt)!=="svelte-a89imt"&&(xt.innerHTML=Ll),en=o(t),$t=a(t,"UL",{"data-svelte-h":!0}),d($t)!=="svelte-v1659j"&&($t.innerHTML=Il),nn=o(t),wt=a(t,"P",{"data-svelte-h":!0}),d(wt)!=="svelte-1fn2ypb"&&(wt.textContent=Nl),ln=o(t),Mt=a(t,"P",{"data-svelte-h":!0}),d(Mt)!=="svelte-jjlyr5"&&(Mt.textContent=Vl),sn=o(t),p(Tt.$$.fragment,t),on=o(t),_t=a(t,"P",{"data-svelte-h":!0}),d(_t)!=="svelte-1oiocxk"&&(_t.innerHTML=Xl),rn=o(t),p(Ct.$$.fragment,t),an=o(t),p(kt.$$.fragment,t),dn=o(t),Ut=a(t,"P",{"data-svelte-h":!0}),d(Ut)!=="svelte-11ulv39"&&(Ut.innerHTML=Bl),mn=o(t),p(jt.$$.fragment,t),pn=o(t),Jt=a(t,"P",{"data-svelte-h":!0}),d(Jt)!=="svelte-10b1zzx"&&(Jt.innerHTML=Pl),hn=o(t),Ht=a(t,"TABLE",{"data-svelte-h":!0}),d(Ht)!=="svelte-bubgue"&&(Ht.innerHTML=Rl),un=o(t),Et=a(t,"P",{"data-svelte-h":!0}),d(Et)!=="svelte-idwl5w"&&(Et.innerHTML=Zl),cn=o(t),p(qt.$$.fragment,t),fn=o(t),zt=a(t,"P",{"data-svelte-h":!0}),d(zt)!=="svelte-1k7auim"&&(zt.innerHTML=Gl),gn=o(t),Lt=a(t,"P",{"data-svelte-h":!0}),d(Lt)!=="svelte-129arh1"&&(Lt.innerHTML=Ql),vn=o(t),k=a(t,"DIV",{style:!0,"data-svelte-h":!0}),d(k)!=="svelte-11fs52k"&&(k.innerHTML=Wl),yn=o(t),It=a(t,"P",{"data-svelte-h":!0}),d(It)!=="svelte-r85xss"&&(It.innerHTML=Sl),bn=o(t),U=a(t,"DIV",{style:!0,"data-svelte-h":!0}),d(U)!=="svelte-wolnbf"&&(U.innerHTML=Al),xn=o(t),Nt=a(t,"P",{"data-svelte-h":!0}),d(Nt)!=="svelte-zesxnv"&&(Nt.innerHTML=Dl),$n=o(t),p(Vt.$$.fragment,t),wn=o(t),g=a(t,"DIV",{class:!0});var y=b(g);p(Xt.$$.fragment,y),Xn=o(y),ee=a(y,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-152alil"&&(ee.textContent=Fl),Bn=o(y),j=a(y,"DIV",{class:!0});var kn=b(j);p(Bt.$$.fragment,kn),Pn=o(kn),ne=a(kn,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-jbudbm"&&(ne.textContent=Yl),kn.forEach(n),Rn=o(y),J=a(y,"DIV",{class:!0});var Un=b(J);p(Pt.$$.fragment,Un),Zn=o(Un),le=a(Un,"P",{"data-svelte-h":!0}),d(le)!=="svelte-6c4d0o"&&(le.textContent=Ol),Un.forEach(n),Gn=o(y),H=a(y,"DIV",{class:!0});var jn=b(H);p(Rt.$$.fragment,jn),Qn=o(jn),se=a(jn,"P",{"data-svelte-h":!0}),d(se)!=="svelte-19cl563"&&(se.textContent=Kl),jn.forEach(n),Wn=o(y),E=a(y,"DIV",{class:!0});var Jn=b(E);p(Zt.$$.fragment,Jn),Sn=o(Jn),oe=a(Jn,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-qo76c0"&&(oe.textContent=ts),Jn.forEach(n),An=o(y),q=a(y,"DIV",{class:!0});var Hn=b(q);p(Gt.$$.fragment,Hn),Dn=o(Hn),re=a(Hn,"P",{"data-svelte-h":!0}),d(re)!=="svelte-12fu8ku"&&(re.textContent=es),Hn.forEach(n),Fn=o(y),z=a(y,"DIV",{class:!0});var En=b(z);p(Qt.$$.fragment,En),Yn=o(En),ae=a(En,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-crkk5y"&&(ae.textContent=ns),En.forEach(n),On=o(y),L=a(y,"DIV",{class:!0});var qn=b(L);p(Wt.$$.fragment,qn),Kn=o(qn),ie=a(qn,"P",{"data-svelte-h":!0}),d(ie)!=="svelte-d45cv9"&&(ie.textContent=ls),qn.forEach(n),y.forEach(n),Mn=o(t),v=a(t,"DIV",{class:!0});var $=b(v);p(St.$$.fragment,$),tl=o($),de=a($,"P",{"data-svelte-h":!0}),d(de)!=="svelte-1bq9un6"&&(de.textContent=ss),el=o($),T=a($,"DIV",{class:!0});var ve=b(T);p(At.$$.fragment,ve),nl=o(ve),me=a(ve,"P",{"data-svelte-h":!0}),d(me)!=="svelte-ra5f94"&&(me.textContent=os),ll=o(ve),pe=a(ve,"P",{"data-svelte-h":!0}),d(pe)!=="svelte-1mpvuud"&&(pe.innerHTML=rs),ve.forEach(n),sl=o($),I=a($,"DIV",{class:!0});var zn=b(I);p(Dt.$$.fragment,zn),ol=o(zn),he=a(zn,"P",{"data-svelte-h":!0}),d(he)!=="svelte-mmxwjp"&&(he.textContent=as),zn.forEach(n),rl=o($),N=a($,"DIV",{class:!0});var Ln=b(N);p(Ft.$$.fragment,Ln),al=o(Ln),ue=a(Ln,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-8cca1z"&&(ue.textContent=is),Ln.forEach(n),il=o($),V=a($,"DIV",{class:!0});var In=b(V);p(Yt.$$.fragment,In),dl=o(In),ce=a(In,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-emvawv"&&(ce.textContent=ds),In.forEach(n),ml=o($),X=a($,"DIV",{class:!0});var Nn=b(X);p(Ot.$$.fragment,Nn),pl=o(Nn),fe=a(Nn,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-13ama2g"&&(fe.textContent=ms),Nn.forEach(n),hl=o($),B=a($,"DIV",{class:!0});var Vn=b(B);p(Kt.$$.fragment,Vn),ul=o(Vn),ge=a(Vn,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-vyrtkr"&&(ge.textContent=ps),Vn.forEach(n),$.forEach(n),Tn=o(t),p(te.$$.fragment,t),_n=o(t),be=a(t,"P",{}),b(be).forEach(n),this.h()},h(){x(_,"name","hf:doc:metadata"),x(_,"content",xs),cl(C,"text-align","center"),cl(k,"text-align","center"),cl(U,"text-align","center"),x(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(g,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,e){i(document.head,_),l(t,xe,e),l(t,ye,e),l(t,$e,e),h(R,t,e),l(t,we,e),l(t,Z,e),l(t,Me,e),l(t,C,e),l(t,Te,e),l(t,G,e),l(t,_e,e),h(Q,t,e),l(t,Ce,e),l(t,W,e),l(t,ke,e),h(S,t,e),l(t,Ue,e),l(t,A,e),l(t,je,e),h(D,t,e),l(t,Je,e),l(t,F,e),l(t,He,e),h(Y,t,e),l(t,Ee,e),l(t,O,e),l(t,qe,e),h(K,t,e),l(t,ze,e),l(t,tt,e),l(t,Le,e),h(et,t,e),l(t,Ie,e),l(t,nt,e),l(t,Ne,e),h(lt,t,e),l(t,Ve,e),l(t,st,e),l(t,Xe,e),h(ot,t,e),l(t,Be,e),l(t,rt,e),l(t,Pe,e),l(t,at,e),l(t,Re,e),h(it,t,e),l(t,Ze,e),l(t,dt,e),l(t,Ge,e),l(t,mt,e),l(t,Qe,e),h(pt,t,e),l(t,We,e),h(ht,t,e),l(t,Se,e),l(t,ut,e),l(t,Ae,e),l(t,ct,e),l(t,De,e),l(t,ft,e),l(t,Fe,e),h(gt,t,e),l(t,Ye,e),l(t,vt,e),l(t,Oe,e),h(yt,t,e),l(t,Ke,e),l(t,bt,e),l(t,tn,e),l(t,xt,e),l(t,en,e),l(t,$t,e),l(t,nn,e),l(t,wt,e),l(t,ln,e),l(t,Mt,e),l(t,sn,e),h(Tt,t,e),l(t,on,e),l(t,_t,e),l(t,rn,e),h(Ct,t,e),l(t,an,e),h(kt,t,e),l(t,dn,e),l(t,Ut,e),l(t,mn,e),h(jt,t,e),l(t,pn,e),l(t,Jt,e),l(t,hn,e),l(t,Ht,e),l(t,un,e),l(t,Et,e),l(t,cn,e),h(qt,t,e),l(t,fn,e),l(t,zt,e),l(t,gn,e),l(t,Lt,e),l(t,vn,e),l(t,k,e),l(t,yn,e),l(t,It,e),l(t,bn,e),l(t,U,e),l(t,xn,e),l(t,Nt,e),l(t,$n,e),h(Vt,t,e),l(t,wn,e),l(t,g,e),h(Xt,g,null),i(g,Xn),i(g,ee),i(g,Bn),i(g,j),h(Bt,j,null),i(j,Pn),i(j,ne),i(g,Rn),i(g,J),h(Pt,J,null),i(J,Zn),i(J,le),i(g,Gn),i(g,H),h(Rt,H,null),i(H,Qn),i(H,se),i(g,Wn),i(g,E),h(Zt,E,null),i(E,Sn),i(E,oe),i(g,An),i(g,q),h(Gt,q,null),i(q,Dn),i(q,re),i(g,Fn),i(g,z),h(Qt,z,null),i(z,Yn),i(z,ae),i(g,On),i(g,L),h(Wt,L,null),i(L,Kn),i(L,ie),l(t,Mn,e),l(t,v,e),h(St,v,null),i(v,tl),i(v,de),i(v,el),i(v,T),h(At,T,null),i(T,nl),i(T,me),i(T,ll),i(T,pe),i(v,sl),i(v,I),h(Dt,I,null),i(I,ol),i(I,he),i(v,rl),i(v,N),h(Ft,N,null),i(N,al),i(N,ue),i(v,il),i(v,V),h(Yt,V,null),i(V,dl),i(V,ce),i(v,ml),i(v,X),h(Ot,X,null),i(X,pl),i(X,fe),i(v,hl),i(v,B),h(Kt,B,null),i(B,ul),i(B,ge),l(t,Tn,e),h(te,t,e),l(t,_n,e),l(t,be,e),Cn=!0},p:us,i(t){Cn||(u(R.$$.fragment,t),u(Q.$$.fragment,t),u(S.$$.fragment,t),u(D.$$.fragment,t),u(Y.$$.fragment,t),u(K.$$.fragment,t),u(et.$$.fragment,t),u(lt.$$.fragment,t),u(ot.$$.fragment,t),u(it.$$.fragment,t),u(pt.$$.fragment,t),u(ht.$$.fragment,t),u(gt.$$.fragment,t),u(yt.$$.fragment,t),u(Tt.$$.fragment,t),u(Ct.$$.fragment,t),u(kt.$$.fragment,t),u(jt.$$.fragment,t),u(qt.$$.fragment,t),u(Vt.$$.fragment,t),u(Xt.$$.fragment,t),u(Bt.$$.fragment,t),u(Pt.$$.fragment,t),u(Rt.$$.fragment,t),u(Zt.$$.fragment,t),u(Gt.$$.fragment,t),u(Qt.$$.fragment,t),u(Wt.$$.fragment,t),u(St.$$.fragment,t),u(At.$$.fragment,t),u(Dt.$$.fragment,t),u(Ft.$$.fragment,t),u(Yt.$$.fragment,t),u(Ot.$$.fragment,t),u(Kt.$$.fragment,t),u(te.$$.fragment,t),Cn=!0)},o(t){c(R.$$.fragment,t),c(Q.$$.fragment,t),c(S.$$.fragment,t),c(D.$$.fragment,t),c(Y.$$.fragment,t),c(K.$$.fragment,t),c(et.$$.fragment,t),c(lt.$$.fragment,t),c(ot.$$.fragment,t),c(it.$$.fragment,t),c(pt.$$.fragment,t),c(ht.$$.fragment,t),c(gt.$$.fragment,t),c(yt.$$.fragment,t),c(Tt.$$.fragment,t),c(Ct.$$.fragment,t),c(kt.$$.fragment,t),c(jt.$$.fragment,t),c(qt.$$.fragment,t),c(Vt.$$.fragment,t),c(Xt.$$.fragment,t),c(Bt.$$.fragment,t),c(Pt.$$.fragment,t),c(Rt.$$.fragment,t),c(Zt.$$.fragment,t),c(Gt.$$.fragment,t),c(Qt.$$.fragment,t),c(Wt.$$.fragment,t),c(St.$$.fragment,t),c(At.$$.fragment,t),c(Dt.$$.fragment,t),c(Ft.$$.fragment,t),c(Yt.$$.fragment,t),c(Ot.$$.fragment,t),c(Kt.$$.fragment,t),c(te.$$.fragment,t),Cn=!1},d(t){t&&(n(xe),n(ye),n($e),n(we),n(Z),n(Me),n(C),n(Te),n(G),n(_e),n(Ce),n(W),n(ke),n(Ue),n(A),n(je),n(Je),n(F),n(He),n(Ee),n(O),n(qe),n(ze),n(tt),n(Le),n(Ie),n(nt),n(Ne),n(Ve),n(st),n(Xe),n(Be),n(rt),n(Pe),n(at),n(Re),n(Ze),n(dt),n(Ge),n(mt),n(Qe),n(We),n(Se),n(ut),n(Ae),n(ct),n(De),n(ft),n(Fe),n(Ye),n(vt),n(Oe),n(Ke),n(bt),n(tn),n(xt),n(en),n($t),n(nn),n(wt),n(ln),n(Mt),n(sn),n(on),n(_t),n(rn),n(an),n(dn),n(Ut),n(mn),n(pn),n(Jt),n(hn),n(Ht),n(un),n(Et),n(cn),n(fn),n(zt),n(gn),n(Lt),n(vn),n(k),n(yn),n(It),n(bn),n(U),n(xn),n(Nt),n($n),n(wn),n(g),n(Mn),n(v),n(Tn),n(_n),n(be)),n(_),f(R,t),f(Q,t),f(S,t),f(D,t),f(Y,t),f(K,t),f(et,t),f(lt,t),f(ot,t),f(it,t),f(pt,t),f(ht,t),f(gt,t),f(yt,t),f(Tt,t),f(Ct,t),f(kt,t),f(jt,t),f(qt,t),f(Vt,t),f(Xt),f(Bt),f(Pt),f(Rt),f(Zt),f(Gt),f(Qt),f(Wt),f(St),f(At),f(Dt),f(Ft),f(Yt),f(Ot),f(Kt),f(te,t)}}}const xs='{"title":"Text Environments","local":"text-environments","sections":[{"title":"Tools","local":"tools","sections":[{"title":"transformers.Tool","local":"transformerstool","sections":[],"depth":3},{"title":"Custom Tools","local":"custom-tools","sections":[],"depth":3},{"title":"Call syntax","local":"call-syntax","sections":[],"depth":3}],"depth":2},{"title":"Create a TextEnvironment","local":"create-a-textenvironment","sections":[],"depth":2},{"title":"Run an Episode","local":"run-an-episode","sections":[{"title":"Train","local":"train","sections":[],"depth":3}],"depth":2},{"title":"TextHistory","local":"texthistory","sections":[{"title":"Attributes","local":"attributes","sections":[],"depth":3},{"title":"Visualization","local":"visualization","sections":[],"depth":3}],"depth":2},{"title":"API Documentation","local":"trl.TextEnvironment","sections":[],"depth":2}],"depth":1}';function $s(fl){return cs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ks extends fs{constructor(_){super(),gs(this,_,$s,bs,hs,{})}}export{ks as component};
