import{s as Ke,n as Oe,o as el}from"../chunks/scheduler.7bc62968.js";import{S as ll,i as sl,g as i,s as a,r as c,A as tl,h as o,f as s,c as n,j as Pe,u as r,x as m,k as P,y as al,a as t,v as p,d,t as y,w as M}from"../chunks/index.66556066.js";import{H as X,g as nl}from"../chunks/Heading.8f17e89c.js";import{C as L}from"../chunks/CodeBlock.a759539a.js";function il(Ge){let h,K,D,O,w,ee,f,ke='<code>timm</code>, also known as <a href="https://github.com/rwightman/pytorch-image-models" rel="nofollow">pytorch-image-models</a>, is an open-source collection of state-of-the-art PyTorch image models, pretrained weights, and utility scripts for training, inference, and validation.',le,g,He='This documentation focuses on <code>timm</code> functionality in the Hugging Face Hub instead of the <code>timm</code> library itself. For detailed information about the <code>timm</code> library, visit <a href="https://huggingface.co/docs/timm" rel="nofollow">its documentation</a>.',se,b,$e='You can find a number of <code>timm</code> models on the Hub using the filters on the left of the <a href="https://huggingface.co/models?library=timm&amp;sort=downloads" rel="nofollow">models page</a>.',te,U,Ve="All models on the Hub come with several useful features:",ae,j,_e='<li>An automatically generated model card, which model authors can complete with <a href="./model-cards">information about their model</a>.</li> <li>Metadata tags help users discover the relevant <code>timm</code> models.</li> <li>An <a href="./models-widgets">interactive widget</a> you can use to play with the model directly in the browser.</li> <li>An <a href="./models-inference">Inference API</a> that allows users to make inference requests.</li>',ne,I,ie,Z,Ye="Any <code>timm</code> model from the Hugging Face Hub can be loaded with a single line of code as long as you have <code>timm</code> installed! Once you’ve selected a model from the Hub, pass the model’s ID prefixed with <code>hf-hub:</code> to <code>timm</code>’s <code>create_model</code> method to download and instantiate the model.",oe,B,me,W,ze="If you want to see how to load a specific model, you can click <strong>Use in timm</strong> and you will be given a working snippet to load it!",ce,J,Qe='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/libraries-timm_snippet1.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/libraries-timm_snippet1-dark.png"/>',re,u,Se='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/libraries-timm_snippet2.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/libraries-timm_snippet2-dark.png"/>',pe,x,de,v,Ne="The snippet below shows how you can perform inference on a <code>timm</code> model loaded from the Hub:",ye,C,Me,G,Ae="This should leave you with a list of predictions, like this:",he,k,Je,H,ue,$,Re="You can share your <code>timm</code> models directly to the Hugging Face Hub. This will publish a new version of your model to the Hugging Face Hub, creating a model repo for you if it doesn’t already exist.",Te,V,Ee="Before pushing a model, make sure that you’ve logged in to Hugging Face:",we,_,fe,Y,Fe="Alternatively, if you prefer working from a Jupyter or Colaboratory notebook, once you’ve installed <code>huggingface_hub</code> you can log in with:",ge,z,be,Q,Le="Then, push your model using the <code>push_to_hf_hub</code> method:",Ue,S,je,N,Ie,A,Xe='All <code>timm</code> models on the Hub are automatically equipped with an <a href="./models-widgets">inference widget</a>, pictured below for <a href="https://huggingface.co/nateraw/timm-resnet50-beans" rel="nofollow">nateraw/timm-resnet50-beans</a>. Additionally, <code>timm</code> models are available through the <a href="./models-inference">Inference API</a>, which you can access through HTTP with cURL, Python’s <code>requests</code> library, or your preferred method for making network requests.',Ze,T,De='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/libraries-timm_widget.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/libraries-timm_widget-dark.png"/>',Be,R,We,E,xe,F,qe='<li>timm (pytorch-image-models) <a href="https://github.com/rwightman/pytorch-image-models" rel="nofollow">GitHub Repo</a>.</li> <li>timm <a href="https://huggingface.co/docs/timm" rel="nofollow">documentation</a>.</li> <li>Additional documentation at <a href="https://timm.fast.ai" rel="nofollow">timmdocs</a> by <a href="https://github.com/amaarora" rel="nofollow">Aman Arora</a>.</li> <li><a href="https://towardsdatascience.com/getting-started-with-pytorch-image-models-timm-a-practitioners-guide-4e77b4bf9055" rel="nofollow">Getting Started with PyTorch Image Models (timm): A Practitioner’s Guide</a> by <a href="https://github.com/Chris-hughes10" rel="nofollow">Chris Hughes</a>.</li>',ve,q,Ce;return w=new X({props:{title:"Using timm at Hugging Face",local:"using-timm-at-hugging-face",headingTag:"h1"}}),I=new X({props:{title:"Using existing models from the Hub",local:"using-existing-models-from-the-hub",headingTag:"h2"}}),B=new L({props:{code:"aW1wb3J0JTIwdGltbSUwQSUwQSUyMyUyMExvYWRpbmclMjBodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGdGltbSUyRmVjYV9uZm5ldF9sMCUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJTIyaGYtaHViJTNBdGltbSUyRmVjYV9uZm5ldF9sMCUyMiUyQyUyMHByZXRyYWluZWQlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">import</span> timm

<span class="hljs-comment"># Loading https://huggingface.co/timm/eca_nfnet_l0</span>
model = timm.create_model(<span class="hljs-string">&quot;hf-hub:timm/eca_nfnet_l0&quot;</span>, pretrained=<span class="hljs-literal">True</span>)`,wrap:!1}}),x=new X({props:{title:"Inference",local:"inference",headingTag:"h3"}}),C=new L({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> timm
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-comment"># Load from Hub 🔥</span>
model = timm.create_model(
    <span class="hljs-string">&#x27;hf-hub:nateraw/resnet50-oxford-iiit-pet&#x27;</span>,
    pretrained=<span class="hljs-literal">True</span>
)

<span class="hljs-comment"># Set model to eval mode for inference</span>
model.<span class="hljs-built_in">eval</span>()

<span class="hljs-comment"># Create Transform</span>
transform = create_transform(**resolve_data_config(model.pretrained_cfg, model=model))

<span class="hljs-comment"># Get the labels from the model config</span>
labels = model.pretrained_cfg[<span class="hljs-string">&#x27;labels&#x27;</span>]
top_k = <span class="hljs-built_in">min</span>(<span class="hljs-built_in">len</span>(labels), <span class="hljs-number">5</span>)

<span class="hljs-comment"># Use your own image file here...</span>
image = Image.<span class="hljs-built_in">open</span>(<span class="hljs-string">&#x27;boxer.jpg&#x27;</span>).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)

<span class="hljs-comment"># Process PIL image with transforms and add a batch dimension</span>
x = transform(image).unsqueeze(<span class="hljs-number">0</span>)

<span class="hljs-comment"># Pass inputs to model forward function to get outputs</span>
out = model(x)

<span class="hljs-comment"># Apply softmax to get predicted probabilities for each class</span>
probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)

<span class="hljs-comment"># Grab the values and indices of top 5 predicted classes</span>
values, indices = torch.topk(probabilities, top_k)

<span class="hljs-comment"># Prepare a nice dict of top k predictions</span>
predictions = [
    {<span class="hljs-string">&quot;label&quot;</span>: labels[i], <span class="hljs-string">&quot;score&quot;</span>: v.item()}
    <span class="hljs-keyword">for</span> i, v <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(indices, values)
]
<span class="hljs-built_in">print</span>(predictions)`,wrap:!1}}),k=new L({props:{code:"JTVCJTBBJTIwJTIwJTIwJTIwJTdCJ2xhYmVsJyUzQSUyMCdhbWVyaWNhbl9waXRfYnVsbF90ZXJyaWVyJyUyQyUyMCdzY29yZSclM0ElMjAwLjk5OTk5OTg4MDc5MDcxMDQlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0InbGFiZWwnJTNBJTIwJ3N0YWZmb3Jkc2hpcmVfYnVsbF90ZXJyaWVyJyUyQyUyMCdzY29yZSclM0ElMjAxLjAwMDAwMDAxNDkwMTE2MTJlLTA3JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJ2xhYmVsJyUzQSUyMCdtaW5pYXR1cmVfcGluc2NoZXInJTJDJTIwJ3Njb3JlJyUzQSUyMDEuMDAwMDAwMDE0OTAxMTYxMmUtMDclN0QlMkMlMEElMjAlMjAlMjAlMjAlN0InbGFiZWwnJTNBJTIwJ2NoaWh1YWh1YSclMkMlMjAnc2NvcmUnJTNBJTIwMS4wMDAwMDAwMTQ5MDExNjEyZS0wNyU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QidsYWJlbCclM0ElMjAnYmVhZ2xlJyUyQyUyMCdzY29yZSclM0ElMjAxLjAwMDAwMDAxNDkwMTE2MTJlLTA3JTdEJTBBJTVE",highlighted:`[
    {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;american_pit_bull_terrier&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9999998807907104</span>},
    {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;staffordshire_bull_terrier&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">1.0000000149011612e-07</span>},
    {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;miniature_pinscher&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">1.0000000149011612e-07</span>},
    {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;chihuahua&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">1.0000000149011612e-07</span>},
    {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;beagle&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">1.0000000149011612e-07</span>}
]`,wrap:!1}}),H=new X({props:{title:"Sharing your models",local:"sharing-your-models",headingTag:"h2"}}),_=new L({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwaHVnZ2luZ2ZhY2VfaHViJTBBaHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:`python -m pip install huggingface_hub
huggingface-cli login`,wrap:!1}}),z=new L({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login
notebook_login()`,wrap:!1}}),S=new L({props:{code:"aW1wb3J0JTIwdGltbSUwQSUwQSUyMyUyMEJ1aWxkJTIwb3IlMjBsb2FkJTIwYSUyMG1vZGVsJTJDJTIwZS5nLiUyMHRpbW0ncyUyMHByZXRyYWluZWQlMjByZXNuZXQxOCUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3Jlc25ldDE4JyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0Q0KSUwQSUwQSUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUwQSUyMyUyMCU1QkZpbmUlMjB0dW5lJTIweW91ciUyMG1vZGVsLi4uJTVEJTBBJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTBBJTBBJTIzJTIwUHVzaCUyMGl0JTIwdG8lMjB0aGUlMjAlRjAlOUYlQTQlOTclMjBIdWIlMEF0aW1tLm1vZGVscy5odWIucHVzaF90b19oZl9odWIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjAncmVzbmV0MTgtcmFuZG9tLWNsYXNzaWZpZXInJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWxfY29uZmlnJTNEJTdCJ2xhYmVscyclM0ElMjAlNUInYSclMkMlMjAnYiclMkMlMjAnYyclMkMlMjAnZCclNUQlN0QlMEEpJTBBJTBBJTIzJTIwTG9hZCUyMHlvdXIlMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBIdWIlMEFtb2RlbF9yZWxvYWRlZCUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCUwQSUyMCUyMCUyMCUyMCdoZi1odWIlM0ElM0N5b3VyLXVzZXJuYW1lJTNFJTJGcmVzbmV0MTgtcmFuZG9tLWNsYXNzaWZpZXInJTJDJTBBJTIwJTIwJTIwJTIwcHJldHJhaW5lZCUzRFRydWUlMEEp",highlighted:`<span class="hljs-keyword">import</span> timm

<span class="hljs-comment"># Build or load a model, e.g. timm&#x27;s pretrained resnet18</span>
model = timm.create_model(<span class="hljs-string">&#x27;resnet18&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=<span class="hljs-number">4</span>)

<span class="hljs-comment">###########################</span>
<span class="hljs-comment"># [Fine tune your model...]</span>
<span class="hljs-comment">###########################</span>

<span class="hljs-comment"># Push it to the 🤗 Hub</span>
timm.models.hub.push_to_hf_hub(
    model,
    <span class="hljs-string">&#x27;resnet18-random-classifier&#x27;</span>,
    model_config={<span class="hljs-string">&#x27;labels&#x27;</span>: [<span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;c&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>]}
)

<span class="hljs-comment"># Load your model from the Hub</span>
model_reloaded = timm.create_model(
    <span class="hljs-string">&#x27;hf-hub:&lt;your-username&gt;/resnet18-random-classifier&#x27;</span>,
    pretrained=<span class="hljs-literal">True</span>
)`,wrap:!1}}),N=new X({props:{title:"Inference Widget and API",local:"inference-widget-and-api",headingTag:"h2"}}),R=new L({props:{code:"Y3VybCUyMGh0dHBzJTNBJTJGJTJGYXBpLWluZmVyZW5jZS5odWdnaW5nZmFjZS5jbyUyRm1vZGVscyUyRm5hdGVyYXclMkZ0aW1tLXJlc25ldDUwLWJlYW5zJTIwJTVDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLVglMjBQT1NUJTIwJTVDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLS1kYXRhLWJpbmFyeSUyMCclNDBiZWFucy5qcGVnJyUyMCU1QyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC1IJTIwJTIyQXV0aG9yaXphdGlvbiUzQSUyMEJlYXJlciUyMCU3QiUyNEhGX0FQSV9UT0tFTiU3RCUyMiUwQSUyMyUyMCU1QiU3QiUyMmxhYmVsJTIyJTNBJTIyYW5ndWxhcl9sZWFmX3Nwb3QlMjIlMkMlMjJzY29yZSUyMiUzQTAuOTg0NTk0NzAyNzIwNjQyMSU3RCUyQyU3QiUyMmxhYmVsJTIyJTNBJTIyYmVhbl9ydXN0JTIyJTJDJTIyc2NvcmUlMjIlM0EwLjAxMzY4MzE1MDUyMjQxMDg3JTdEJTJDJTdCJTIybGFiZWwlMjIlM0ElMjJoZWFsdGh5JTIyJTJDJTIyc2NvcmUlMjIlM0EwLjAwMTcyMjA4NTg3MTczMzcyNSU3RCU1RA==",highlighted:`curl https://api-inference.huggingface.co/models/nateraw/timm-resnet50-beans \\
        -X POST \\
        --data-binary <span class="hljs-string">&#x27;@beans.jpeg&#x27;</span> \\
        -H <span class="hljs-string">&quot;Authorization: Bearer {<span class="hljs-variable">$HF_API_TOKEN</span>}&quot;</span>
<span class="hljs-comment"># [{&quot;label&quot;:&quot;angular_leaf_spot&quot;,&quot;score&quot;:0.9845947027206421},{&quot;label&quot;:&quot;bean_rust&quot;,&quot;score&quot;:0.01368315052241087},{&quot;label&quot;:&quot;healthy&quot;,&quot;score&quot;:0.001722085871733725}]</span>`,wrap:!1}}),E=new X({props:{title:"Additional resources",local:"additional-resources",headingTag:"h2"}}),{c(){h=i("meta"),K=a(),D=i("p"),O=a(),c(w.$$.fragment),ee=a(),f=i("p"),f.innerHTML=ke,le=a(),g=i("p"),g.innerHTML=He,se=a(),b=i("p"),b.innerHTML=$e,te=a(),U=i("p"),U.textContent=Ve,ae=a(),j=i("ol"),j.innerHTML=_e,ne=a(),c(I.$$.fragment),ie=a(),Z=i("p"),Z.innerHTML=Ye,oe=a(),c(B.$$.fragment),me=a(),W=i("p"),W.innerHTML=ze,ce=a(),J=i("div"),J.innerHTML=Qe,re=a(),u=i("div"),u.innerHTML=Se,pe=a(),c(x.$$.fragment),de=a(),v=i("p"),v.innerHTML=Ne,ye=a(),c(C.$$.fragment),Me=a(),G=i("p"),G.textContent=Ae,he=a(),c(k.$$.fragment),Je=a(),c(H.$$.fragment),ue=a(),$=i("p"),$.innerHTML=Re,Te=a(),V=i("p"),V.textContent=Ee,we=a(),c(_.$$.fragment),fe=a(),Y=i("p"),Y.innerHTML=Fe,ge=a(),c(z.$$.fragment),be=a(),Q=i("p"),Q.innerHTML=Le,Ue=a(),c(S.$$.fragment),je=a(),c(N.$$.fragment),Ie=a(),A=i("p"),A.innerHTML=Xe,Ze=a(),T=i("div"),T.innerHTML=De,Be=a(),c(R.$$.fragment),We=a(),c(E.$$.fragment),xe=a(),F=i("ul"),F.innerHTML=qe,ve=a(),q=i("p"),this.h()},l(e){const l=tl("svelte-u9bgzb",document.head);h=o(l,"META",{name:!0,content:!0}),l.forEach(s),K=n(e),D=o(e,"P",{}),Pe(D).forEach(s),O=n(e),r(w.$$.fragment,e),ee=n(e),f=o(e,"P",{"data-svelte-h":!0}),m(f)!=="svelte-1bz9zfk"&&(f.innerHTML=ke),le=n(e),g=o(e,"P",{"data-svelte-h":!0}),m(g)!=="svelte-1b9kavw"&&(g.innerHTML=He),se=n(e),b=o(e,"P",{"data-svelte-h":!0}),m(b)!=="svelte-19ixdpv"&&(b.innerHTML=$e),te=n(e),U=o(e,"P",{"data-svelte-h":!0}),m(U)!=="svelte-1uvi03j"&&(U.textContent=Ve),ae=n(e),j=o(e,"OL",{"data-svelte-h":!0}),m(j)!=="svelte-1dns05d"&&(j.innerHTML=_e),ne=n(e),r(I.$$.fragment,e),ie=n(e),Z=o(e,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-19q2wuk"&&(Z.innerHTML=Ye),oe=n(e),r(B.$$.fragment,e),me=n(e),W=o(e,"P",{"data-svelte-h":!0}),m(W)!=="svelte-1dv22ye"&&(W.innerHTML=ze),ce=n(e),J=o(e,"DIV",{class:!0,"data-svelte-h":!0}),m(J)!=="svelte-y8p227"&&(J.innerHTML=Qe),re=n(e),u=o(e,"DIV",{class:!0,"data-svelte-h":!0}),m(u)!=="svelte-1xvepxr"&&(u.innerHTML=Se),pe=n(e),r(x.$$.fragment,e),de=n(e),v=o(e,"P",{"data-svelte-h":!0}),m(v)!=="svelte-4jjk9c"&&(v.innerHTML=Ne),ye=n(e),r(C.$$.fragment,e),Me=n(e),G=o(e,"P",{"data-svelte-h":!0}),m(G)!=="svelte-1hfr7cw"&&(G.textContent=Ae),he=n(e),r(k.$$.fragment,e),Je=n(e),r(H.$$.fragment,e),ue=n(e),$=o(e,"P",{"data-svelte-h":!0}),m($)!=="svelte-1m2yz24"&&($.innerHTML=Re),Te=n(e),V=o(e,"P",{"data-svelte-h":!0}),m(V)!=="svelte-1ixi9lc"&&(V.textContent=Ee),we=n(e),r(_.$$.fragment,e),fe=n(e),Y=o(e,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-19plf33"&&(Y.innerHTML=Fe),ge=n(e),r(z.$$.fragment,e),be=n(e),Q=o(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-13bqgmd"&&(Q.innerHTML=Le),Ue=n(e),r(S.$$.fragment,e),je=n(e),r(N.$$.fragment,e),Ie=n(e),A=o(e,"P",{"data-svelte-h":!0}),m(A)!=="svelte-1suwl6q"&&(A.innerHTML=Xe),Ze=n(e),T=o(e,"DIV",{class:!0,"data-svelte-h":!0}),m(T)!=="svelte-11rs1r3"&&(T.innerHTML=De),Be=n(e),r(R.$$.fragment,e),We=n(e),r(E.$$.fragment,e),xe=n(e),F=o(e,"UL",{"data-svelte-h":!0}),m(F)!=="svelte-1o8g6cw"&&(F.innerHTML=qe),ve=n(e),q=o(e,"P",{}),Pe(q).forEach(s),this.h()},h(){P(h,"name","hf:doc:metadata"),P(h,"content",ol),P(J,"class","flex justify-center"),P(u,"class","flex justify-center"),P(T,"class","flex justify-center")},m(e,l){al(document.head,h),t(e,K,l),t(e,D,l),t(e,O,l),p(w,e,l),t(e,ee,l),t(e,f,l),t(e,le,l),t(e,g,l),t(e,se,l),t(e,b,l),t(e,te,l),t(e,U,l),t(e,ae,l),t(e,j,l),t(e,ne,l),p(I,e,l),t(e,ie,l),t(e,Z,l),t(e,oe,l),p(B,e,l),t(e,me,l),t(e,W,l),t(e,ce,l),t(e,J,l),t(e,re,l),t(e,u,l),t(e,pe,l),p(x,e,l),t(e,de,l),t(e,v,l),t(e,ye,l),p(C,e,l),t(e,Me,l),t(e,G,l),t(e,he,l),p(k,e,l),t(e,Je,l),p(H,e,l),t(e,ue,l),t(e,$,l),t(e,Te,l),t(e,V,l),t(e,we,l),p(_,e,l),t(e,fe,l),t(e,Y,l),t(e,ge,l),p(z,e,l),t(e,be,l),t(e,Q,l),t(e,Ue,l),p(S,e,l),t(e,je,l),p(N,e,l),t(e,Ie,l),t(e,A,l),t(e,Ze,l),t(e,T,l),t(e,Be,l),p(R,e,l),t(e,We,l),p(E,e,l),t(e,xe,l),t(e,F,l),t(e,ve,l),t(e,q,l),Ce=!0},p:Oe,i(e){Ce||(d(w.$$.fragment,e),d(I.$$.fragment,e),d(B.$$.fragment,e),d(x.$$.fragment,e),d(C.$$.fragment,e),d(k.$$.fragment,e),d(H.$$.fragment,e),d(_.$$.fragment,e),d(z.$$.fragment,e),d(S.$$.fragment,e),d(N.$$.fragment,e),d(R.$$.fragment,e),d(E.$$.fragment,e),Ce=!0)},o(e){y(w.$$.fragment,e),y(I.$$.fragment,e),y(B.$$.fragment,e),y(x.$$.fragment,e),y(C.$$.fragment,e),y(k.$$.fragment,e),y(H.$$.fragment,e),y(_.$$.fragment,e),y(z.$$.fragment,e),y(S.$$.fragment,e),y(N.$$.fragment,e),y(R.$$.fragment,e),y(E.$$.fragment,e),Ce=!1},d(e){e&&(s(K),s(D),s(O),s(ee),s(f),s(le),s(g),s(se),s(b),s(te),s(U),s(ae),s(j),s(ne),s(ie),s(Z),s(oe),s(me),s(W),s(ce),s(J),s(re),s(u),s(pe),s(de),s(v),s(ye),s(Me),s(G),s(he),s(Je),s(ue),s($),s(Te),s(V),s(we),s(fe),s(Y),s(ge),s(be),s(Q),s(Ue),s(je),s(Ie),s(A),s(Ze),s(T),s(Be),s(We),s(xe),s(F),s(ve),s(q)),s(h),M(w,e),M(I,e),M(B,e),M(x,e),M(C,e),M(k,e),M(H,e),M(_,e),M(z,e),M(S,e),M(N,e),M(R,e),M(E,e)}}}const ol='{"title":"Using timm at Hugging Face","local":"using-timm-at-hugging-face","sections":[{"title":"Using existing models from the Hub","local":"using-existing-models-from-the-hub","sections":[{"title":"Inference","local":"inference","sections":[],"depth":3}],"depth":2},{"title":"Sharing your models","local":"sharing-your-models","sections":[],"depth":2},{"title":"Inference Widget and API","local":"inference-widget-and-api","sections":[],"depth":2},{"title":"Additional resources","local":"additional-resources","sections":[],"depth":2}],"depth":1}';function ml(Ge){return el(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=nl}),[]}class yl extends ll{constructor(h){super(),sl(this,h,ml,il,Ke,{})}}export{yl as component};
