import{s as Gt,o as Zt,n as Wt}from"../chunks/scheduler.37c15a92.js";import{S as Ct,i as Rt,g as i,s,r as p,A as Ht,h as o,f as a,c as n,j as kt,u as d,x as c,k as Ut,y as It,a as l,v as m,d as h,t as u,w as f}from"../chunks/index.7cb9c9b8.js";import{T as _t}from"../chunks/Tip.d10b3fc9.js";import{Y as zt}from"../chunks/Youtube.8666c400.js";import{C as M}from"../chunks/CodeBlock.abae2786.js";import{C as Ft}from"../chunks/CourseFloatingBanner.df82c153.js";import{F as xt}from"../chunks/FrameworkSwitchCourse.97630871.js";import{H as tt,E as Et}from"../chunks/index.c99deea2.js";function Xt(J){let r,y='💡 If you want to automatically upload your model to the Hub during training, pass along <code>push_to_hub=True</code> in the <code>TrainingArguments</code>. We will learn more about this in <a href="/course/chapter4/3">Chapter 4</a>';return{c(){r=i("p"),r.innerHTML=y},l(w){r=o(w,"P",{"data-svelte-h":!0}),c(r)!=="svelte-zad74h"&&(r.innerHTML=y)},m(w,b){l(w,r,b)},p:Wt,d(w){w&&a(r)}}}function Vt(J){let r,y="✏️ <strong>Try it out!</strong> Fine-tune a model on the GLUE SST-2 dataset, using the data processing you did in section 2.";return{c(){r=i("p"),r.innerHTML=y},l(w){r=o(w,"P",{"data-svelte-h":!0}),c(r)!=="svelte-l3p571"&&(r.innerHTML=y)},m(w,b){l(w,r,b)},p:Wt,d(w){w&&a(r)}}}function Bt(J){let r,y,w,b,T,de,j,me,v,he,k,ue,U,at='🤗 Transformers provides a <code>Trainer</code> class to help you fine-tune any of the pretrained models it provides on your dataset. Once you’ve done all the data preprocessing work in the last section, you have just a few steps left to define the <code>Trainer</code>. The hardest part is likely to be preparing the environment to run <code>Trainer.train()</code>, as it will run very slowly on a CPU. If you don’t have a GPU set up, you can get access to free GPUs or TPUs on <a href="https://colab.research.google.com/" rel="nofollow">Google Colab</a>.',fe,_,lt="The code examples below assume you have already executed the examples in the previous section. Here is a short summary recapping what you need:",we,W,Me,G,ye,Z,st="The first step before we can define our <code>Trainer</code> is to define a <code>TrainingArguments</code> class that will contain all the hyperparameters the <code>Trainer</code> will use for training and evaluation. The only argument you have to provide is a directory where the trained model will be saved, as well as the checkpoints along the way. For all the rest, you can leave the defaults, which should work pretty well for a basic fine-tuning.",be,C,Te,g,ge,R,nt='The second step is to define our model. As in the <a href="/course/chapter2">previous chapter</a>, we will use the <code>AutoModelForSequenceClassification</code> class, with two labels:',$e,H,Je,I,it='You will notice that unlike in <a href="/course/chapter2">Chapter 2</a>, you get a warning after instantiating this pretrained model. This is because BERT has not been pretrained on classifying pairs of sentences, so the head of the pretrained model has been discarded and a new head suitable for sequence classification has been added instead. The warnings indicate that some weights were not used (the ones corresponding to the dropped pretraining head) and that some others were randomly initialized (the ones for the new head). It concludes by encouraging you to train the model, which is exactly what we are going to do now.',je,z,ot="Once we have our model, we can define a <code>Trainer</code> by passing it all the objects constructed up to now — the <code>model</code>, the <code>training_args</code>, the training and validation datasets, our <code>data_collator</code>, and our <code>processing_class</code> (e.g., a tokenizer, feature extractor, or processor):",ve,F,ke,x,rt="Note that when you pass a tokenizer as the <code>processing_class</code>, as we did here, the default <code>data_collator</code> used by the <code>Trainer</code> will be a <code>DataCollatorWithPadding</code> if the <code>processing_class</code> is a tokenizer or feature extractor, so you can skip the line <code>data_collator=data_collator</code> in this call. It was still important to show you this part of the processing in section 2!",Ue,E,ct="To fine-tune the model on our dataset, we just have to call the <code>train()</code> method of our <code>Trainer</code>:",_e,X,We,V,pt="This will start the fine-tuning (which should take a couple of minutes on a GPU) and report the training loss every 500 steps. It won’t, however, tell you how well (or badly) your model is performing. This is because:",Ge,B,dt="<li>We didn’t tell the <code>Trainer</code> to evaluate during training by setting <code>eval_strategy</code> in <code>TrainingArguments</code> to either <code>&quot;steps&quot;</code> (evaluate every <code>eval_steps</code>) or <code>&quot;epoch&quot;</code> (evaluate at the end of each epoch).</li> <li>We didn’t provide the <code>Trainer</code> with a <code>compute_metrics()</code> function to calculate a metric during said evaluation (otherwise the evaluation would just have printed the loss, which is not a very intuitive number).</li>",Ze,Y,Ce,N,mt="Let’s see how we can build a useful <code>compute_metrics()</code> function and use it the next time we train. The function must take an <code>EvalPrediction</code> object (which is a named tuple with a <code>predictions</code> field and a <code>label_ids</code> field) and will return a dictionary mapping strings to floats (the strings being the names of the metrics returned, and the floats their values). To get some predictions from our model, we can use the <code>Trainer.predict()</code> command:",Re,A,He,Q,Ie,L,ht="The output of the <code>predict()</code> method is another named tuple with three fields: <code>predictions</code>, <code>label_ids</code>, and <code>metrics</code>. The <code>metrics</code> field will just contain the loss on the dataset passed, as well as some time metrics (how long it took to predict, in total and on average). Once we complete our <code>compute_metrics()</code> function and pass it to the <code>Trainer</code>, that field will also contain the metrics returned by <code>compute_metrics()</code>.",ze,q,ut='As you can see, <code>predictions</code> is a two-dimensional array with shape 408 x 2 (408 being the number of elements in the dataset we used). Those are the logits for each element of the dataset we passed to <code>predict()</code> (as you saw in the <a href="/course/chapter2">previous chapter</a>, all Transformer models return logits). To transform them into predictions that we can compare to our labels, we need to take the index with the maximum value on the second axis:',Fe,P,xe,S,ft='We can now compare those <code>preds</code> to the labels. To build our <code>compute_metric()</code> function, we will rely on the metrics from the 🤗 <a href="https://github.com/huggingface/evaluate/" rel="nofollow">Evaluate</a> library. We can load the metrics associated with the MRPC dataset as easily as we loaded the dataset, this time with the <code>evaluate.load()</code> function. The object returned has a <code>compute()</code> method we can use to do the metric calculation:',Ee,D,Xe,K,Ve,O,wt='The exact results you get may vary, as the random initialization of the model head might change the metrics it achieved. Here, we can see our model has an accuracy of 85.78% on the validation set and an F1 score of 89.97. Those are the two metrics used to evaluate results on the MRPC dataset for the GLUE benchmark. The table in the <a href="https://arxiv.org/pdf/1810.04805.pdf" rel="nofollow">BERT paper</a> reported an F1 score of 88.9 for the base model. That was the <code>uncased</code> model while we are currently using the <code>cased</code> model, which explains the better result.',Be,ee,Mt="Wrapping everything together, we get our <code>compute_metrics()</code> function:",Ye,te,Ne,ae,yt="And to see it used in action to report metrics at the end of each epoch, here is how we define a new <code>Trainer</code> with this <code>compute_metrics()</code> function:",Ae,le,Qe,se,bt="Note that we create a new <code>TrainingArguments</code> with its <code>eval_strategy</code> set to <code>&quot;epoch&quot;</code> and a new model — otherwise, we would just be continuing the training of the model we have already trained. To launch a new training run, we execute:",Le,ne,qe,ie,Tt="This time, it will report the validation loss and metrics at the end of each epoch on top of the training loss. Again, the exact accuracy/F1 score you reach might be a bit different from what we found, because of the random head initialization of the model, but it should be in the same ballpark.",Pe,oe,gt="The <code>Trainer</code> will work out of the box on multiple GPUs or TPUs and provides lots of options, like mixed-precision training (use <code>fp16 = True</code> in your training arguments). We will go over everything it supports in Chapter 10.",Se,re,$t='This concludes the introduction to fine-tuning using the <code>Trainer</code> API. An example of doing this for most common NLP tasks will be given in <a href="/course/chapter7">Chapter 7</a>, but for now let’s look at how to do the same thing in pure PyTorch.',De,$,Ke,ce,Oe,pe,et;return T=new xt({props:{fw:J[0]}}),j=new tt({props:{title:"Fine-tuning a model with the Trainer API",local:"fine-tuning-a-model-with-the-trainer-api",headingTag:"h1"}}),v=new Ft({props:{chapter:3,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter3/section3.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter3/section3.ipynb"}]}}),k=new zt({props:{id:"nvBXf7s7vTI"}}),W=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyUwQSUwQXJhd19kYXRhc2V0cyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQSUwQWRlZiUyMHRva2VuaXplX2Z1bmN0aW9uKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGV4YW1wbGUlNUIlMjJzZW50ZW5jZTElMjIlNUQlMkMlMjBleGFtcGxlJTVCJTIyc2VudGVuY2UyJTIyJTVEJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpJTBBJTBBJTBBdG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwcmF3X2RhdGFzZXRzLm1hcCh0b2tlbml6ZV9mdW5jdGlvbiUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQWRhdGFfY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyh0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, DataCollatorWithPadding

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
checkpoint = <span class="hljs-string">&quot;bert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_function</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> tokenizer(example[<span class="hljs-string">&quot;sentence1&quot;</span>], example[<span class="hljs-string">&quot;sentence2&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(tokenize_function, batched=<span class="hljs-literal">True</span>)
data_collator = DataCollatorWithPadding(tokenizer=tokenizer)`,wrap:!1}}),G=new tt({props:{title:"Training",local:"training",headingTag:"h3"}}),C=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUyMnRlc3QtdHJhaW5lciUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments

training_args = TrainingArguments(<span class="hljs-string">&quot;test-trainer&quot;</span>)`,wrap:!1}}),g=new _t({props:{$$slots:{default:[Xt]},$$scope:{ctx:J}}}),H=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)`,wrap:!1}}),F=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluZXIlMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0R0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGRhdGFfY29sbGF0b3IlMkMlMEElMjAlMjAlMjAlMjBwcm9jZXNzaW5nX2NsYXNzJTNEdG9rZW5pemVyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer

trainer = Trainer(
    model,
    training_args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>],
    data_collator=data_collator,
    processing_class=tokenizer,
)`,wrap:!1}}),X=new M({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),Y=new tt({props:{title:"Evaluation",local:"evaluation",headingTag:"h3"}}),A=new M({props:{code:"cHJlZGljdGlvbnMlMjAlM0QlMjB0cmFpbmVyLnByZWRpY3QodG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydmFsaWRhdGlvbiUyMiU1RCklMEFwcmludChwcmVkaWN0aW9ucy5wcmVkaWN0aW9ucy5zaGFwZSUyQyUyMHByZWRpY3Rpb25zLmxhYmVsX2lkcy5zaGFwZSk=",highlighted:`predictions = trainer.predict(tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>])
<span class="hljs-built_in">print</span>(predictions.predictions.shape, predictions.label_ids.shape)`,wrap:!1}}),Q=new M({props:{code:"KDQwOCUyQyUyMDIpJTIwKDQwOCUyQyk=",highlighted:'(<span class="hljs-number">408</span>, <span class="hljs-number">2</span>) (<span class="hljs-number">408</span>,)',wrap:!1}}),P=new M({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBcHJlZHMlMjAlM0QlMjBucC5hcmdtYXgocHJlZGljdGlvbnMucHJlZGljdGlvbnMlMkMlMjBheGlzJTNELTEp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

preds = np.argmax(predictions.predictions, axis=-<span class="hljs-number">1</span>)`,wrap:!1}}),D=new M({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMmdsdWUlMjIlMkMlMjAlMjJtcnBjJTIyKSUwQW1ldHJpYy5jb21wdXRlKHByZWRpY3Rpb25zJTNEcHJlZHMlMkMlMjByZWZlcmVuY2VzJTNEcHJlZGljdGlvbnMubGFiZWxfaWRzKQ==",highlighted:`<span class="hljs-keyword">import</span> evaluate

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
metric.compute(predictions=preds, references=predictions.label_ids)`,wrap:!1}}),K=new M({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuODU3ODQzMTM3MjU0OTAxOSUyQyUyMCdmMSclM0ElMjAwLjg5OTY1Mzk3OTIzODc1NDIlN0Q=",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.8578431372549019</span>, <span class="hljs-string">&#x27;f1&#x27;</span>: <span class="hljs-number">0.8996539792387542</span>}',wrap:!1}}),te=new M({props:{code:"ZGVmJTIwY29tcHV0ZV9tZXRyaWNzKGV2YWxfcHJlZHMpJTNBJTBBJTIwJTIwJTIwJTIwbWV0cmljJTIwJTNEJTIwZXZhbHVhdGUubG9hZCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEElMjAlMjAlMjAlMjBsb2dpdHMlMkMlMjBsYWJlbHMlMjAlM0QlMjBldmFsX3ByZWRzJTBBJTIwJTIwJTIwJTIwcHJlZGljdGlvbnMlMjAlM0QlMjBucC5hcmdtYXgobG9naXRzJTJDJTIwYXhpcyUzRC0xKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG1ldHJpYy5jb21wdXRlKHByZWRpY3Rpb25zJTNEcHJlZGljdGlvbnMlMkMlMjByZWZlcmVuY2VzJTNEbGFiZWxzKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_preds</span>):
    metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
    logits, labels = eval_preds
    predictions = np.argmax(logits, axis=-<span class="hljs-number">1</span>)
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)`,wrap:!1}}),le=new M({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUyMnRlc3QtdHJhaW5lciUyMiUyQyUyMGV2YWxfc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMiklMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0R0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGRhdGFfY29sbGF0b3IlMkMlMEElMjAlMjAlMjAlMjBwcm9jZXNzaW5nX2NsYXNzJTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwY29tcHV0ZV9tZXRyaWNzJTNEY29tcHV0ZV9tZXRyaWNzJTJDJTBBKQ==",highlighted:`training_args = TrainingArguments(<span class="hljs-string">&quot;test-trainer&quot;</span>, eval_strategy=<span class="hljs-string">&quot;epoch&quot;</span>)
model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)

trainer = Trainer(
    model,
    training_args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>],
    data_collator=data_collator,
    processing_class=tokenizer,
    compute_metrics=compute_metrics,
)`,wrap:!1}}),ne=new M({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),$=new _t({props:{$$slots:{default:[Vt]},$$scope:{ctx:J}}}),ce=new Et({props:{source:"https://github.com/huggingface/course/blob/main/chapters/en/chapter3/3.mdx"}}),{c(){r=i("meta"),y=s(),w=i("p"),b=s(),p(T.$$.fragment),de=s(),p(j.$$.fragment),me=s(),p(v.$$.fragment),he=s(),p(k.$$.fragment),ue=s(),U=i("p"),U.innerHTML=at,fe=s(),_=i("p"),_.textContent=lt,we=s(),p(W.$$.fragment),Me=s(),p(G.$$.fragment),ye=s(),Z=i("p"),Z.innerHTML=st,be=s(),p(C.$$.fragment),Te=s(),p(g.$$.fragment),ge=s(),R=i("p"),R.innerHTML=nt,$e=s(),p(H.$$.fragment),Je=s(),I=i("p"),I.innerHTML=it,je=s(),z=i("p"),z.innerHTML=ot,ve=s(),p(F.$$.fragment),ke=s(),x=i("p"),x.innerHTML=rt,Ue=s(),E=i("p"),E.innerHTML=ct,_e=s(),p(X.$$.fragment),We=s(),V=i("p"),V.textContent=pt,Ge=s(),B=i("ol"),B.innerHTML=dt,Ze=s(),p(Y.$$.fragment),Ce=s(),N=i("p"),N.innerHTML=mt,Re=s(),p(A.$$.fragment),He=s(),p(Q.$$.fragment),Ie=s(),L=i("p"),L.innerHTML=ht,ze=s(),q=i("p"),q.innerHTML=ut,Fe=s(),p(P.$$.fragment),xe=s(),S=i("p"),S.innerHTML=ft,Ee=s(),p(D.$$.fragment),Xe=s(),p(K.$$.fragment),Ve=s(),O=i("p"),O.innerHTML=wt,Be=s(),ee=i("p"),ee.innerHTML=Mt,Ye=s(),p(te.$$.fragment),Ne=s(),ae=i("p"),ae.innerHTML=yt,Ae=s(),p(le.$$.fragment),Qe=s(),se=i("p"),se.innerHTML=bt,Le=s(),p(ne.$$.fragment),qe=s(),ie=i("p"),ie.textContent=Tt,Pe=s(),oe=i("p"),oe.innerHTML=gt,Se=s(),re=i("p"),re.innerHTML=$t,De=s(),p($.$$.fragment),Ke=s(),p(ce.$$.fragment),Oe=s(),pe=i("p"),this.h()},l(e){const t=Ht("svelte-u9bgzb",document.head);r=o(t,"META",{name:!0,content:!0}),t.forEach(a),y=n(e),w=o(e,"P",{}),kt(w).forEach(a),b=n(e),d(T.$$.fragment,e),de=n(e),d(j.$$.fragment,e),me=n(e),d(v.$$.fragment,e),he=n(e),d(k.$$.fragment,e),ue=n(e),U=o(e,"P",{"data-svelte-h":!0}),c(U)!=="svelte-fvu6dq"&&(U.innerHTML=at),fe=n(e),_=o(e,"P",{"data-svelte-h":!0}),c(_)!=="svelte-1r8y7hl"&&(_.textContent=lt),we=n(e),d(W.$$.fragment,e),Me=n(e),d(G.$$.fragment,e),ye=n(e),Z=o(e,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-bcd3tt"&&(Z.innerHTML=st),be=n(e),d(C.$$.fragment,e),Te=n(e),d(g.$$.fragment,e),ge=n(e),R=o(e,"P",{"data-svelte-h":!0}),c(R)!=="svelte-14s2mi5"&&(R.innerHTML=nt),$e=n(e),d(H.$$.fragment,e),Je=n(e),I=o(e,"P",{"data-svelte-h":!0}),c(I)!=="svelte-1q6lkxd"&&(I.innerHTML=it),je=n(e),z=o(e,"P",{"data-svelte-h":!0}),c(z)!=="svelte-66yjiw"&&(z.innerHTML=ot),ve=n(e),d(F.$$.fragment,e),ke=n(e),x=o(e,"P",{"data-svelte-h":!0}),c(x)!=="svelte-rix2wp"&&(x.innerHTML=rt),Ue=n(e),E=o(e,"P",{"data-svelte-h":!0}),c(E)!=="svelte-2dkplj"&&(E.innerHTML=ct),_e=n(e),d(X.$$.fragment,e),We=n(e),V=o(e,"P",{"data-svelte-h":!0}),c(V)!=="svelte-1u04gyz"&&(V.textContent=pt),Ge=n(e),B=o(e,"OL",{"data-svelte-h":!0}),c(B)!=="svelte-18ht4gg"&&(B.innerHTML=dt),Ze=n(e),d(Y.$$.fragment,e),Ce=n(e),N=o(e,"P",{"data-svelte-h":!0}),c(N)!=="svelte-h6pdaj"&&(N.innerHTML=mt),Re=n(e),d(A.$$.fragment,e),He=n(e),d(Q.$$.fragment,e),Ie=n(e),L=o(e,"P",{"data-svelte-h":!0}),c(L)!=="svelte-1jbqb9m"&&(L.innerHTML=ht),ze=n(e),q=o(e,"P",{"data-svelte-h":!0}),c(q)!=="svelte-w5buv0"&&(q.innerHTML=ut),Fe=n(e),d(P.$$.fragment,e),xe=n(e),S=o(e,"P",{"data-svelte-h":!0}),c(S)!=="svelte-1xta58a"&&(S.innerHTML=ft),Ee=n(e),d(D.$$.fragment,e),Xe=n(e),d(K.$$.fragment,e),Ve=n(e),O=o(e,"P",{"data-svelte-h":!0}),c(O)!=="svelte-59ywn7"&&(O.innerHTML=wt),Be=n(e),ee=o(e,"P",{"data-svelte-h":!0}),c(ee)!=="svelte-1ti0nhg"&&(ee.innerHTML=Mt),Ye=n(e),d(te.$$.fragment,e),Ne=n(e),ae=o(e,"P",{"data-svelte-h":!0}),c(ae)!=="svelte-yza6x"&&(ae.innerHTML=yt),Ae=n(e),d(le.$$.fragment,e),Qe=n(e),se=o(e,"P",{"data-svelte-h":!0}),c(se)!=="svelte-pb8m1o"&&(se.innerHTML=bt),Le=n(e),d(ne.$$.fragment,e),qe=n(e),ie=o(e,"P",{"data-svelte-h":!0}),c(ie)!=="svelte-18ebo35"&&(ie.textContent=Tt),Pe=n(e),oe=o(e,"P",{"data-svelte-h":!0}),c(oe)!=="svelte-ws0acz"&&(oe.innerHTML=gt),Se=n(e),re=o(e,"P",{"data-svelte-h":!0}),c(re)!=="svelte-10go40k"&&(re.innerHTML=$t),De=n(e),d($.$$.fragment,e),Ke=n(e),d(ce.$$.fragment,e),Oe=n(e),pe=o(e,"P",{}),kt(pe).forEach(a),this.h()},h(){Ut(r,"name","hf:doc:metadata"),Ut(r,"content",Yt)},m(e,t){It(document.head,r),l(e,y,t),l(e,w,t),l(e,b,t),m(T,e,t),l(e,de,t),m(j,e,t),l(e,me,t),m(v,e,t),l(e,he,t),m(k,e,t),l(e,ue,t),l(e,U,t),l(e,fe,t),l(e,_,t),l(e,we,t),m(W,e,t),l(e,Me,t),m(G,e,t),l(e,ye,t),l(e,Z,t),l(e,be,t),m(C,e,t),l(e,Te,t),m(g,e,t),l(e,ge,t),l(e,R,t),l(e,$e,t),m(H,e,t),l(e,Je,t),l(e,I,t),l(e,je,t),l(e,z,t),l(e,ve,t),m(F,e,t),l(e,ke,t),l(e,x,t),l(e,Ue,t),l(e,E,t),l(e,_e,t),m(X,e,t),l(e,We,t),l(e,V,t),l(e,Ge,t),l(e,B,t),l(e,Ze,t),m(Y,e,t),l(e,Ce,t),l(e,N,t),l(e,Re,t),m(A,e,t),l(e,He,t),m(Q,e,t),l(e,Ie,t),l(e,L,t),l(e,ze,t),l(e,q,t),l(e,Fe,t),m(P,e,t),l(e,xe,t),l(e,S,t),l(e,Ee,t),m(D,e,t),l(e,Xe,t),m(K,e,t),l(e,Ve,t),l(e,O,t),l(e,Be,t),l(e,ee,t),l(e,Ye,t),m(te,e,t),l(e,Ne,t),l(e,ae,t),l(e,Ae,t),m(le,e,t),l(e,Qe,t),l(e,se,t),l(e,Le,t),m(ne,e,t),l(e,qe,t),l(e,ie,t),l(e,Pe,t),l(e,oe,t),l(e,Se,t),l(e,re,t),l(e,De,t),m($,e,t),l(e,Ke,t),m(ce,e,t),l(e,Oe,t),l(e,pe,t),et=!0},p(e,[t]){const Jt={};t&1&&(Jt.fw=e[0]),T.$set(Jt);const jt={};t&2&&(jt.$$scope={dirty:t,ctx:e}),g.$set(jt);const vt={};t&2&&(vt.$$scope={dirty:t,ctx:e}),$.$set(vt)},i(e){et||(h(T.$$.fragment,e),h(j.$$.fragment,e),h(v.$$.fragment,e),h(k.$$.fragment,e),h(W.$$.fragment,e),h(G.$$.fragment,e),h(C.$$.fragment,e),h(g.$$.fragment,e),h(H.$$.fragment,e),h(F.$$.fragment,e),h(X.$$.fragment,e),h(Y.$$.fragment,e),h(A.$$.fragment,e),h(Q.$$.fragment,e),h(P.$$.fragment,e),h(D.$$.fragment,e),h(K.$$.fragment,e),h(te.$$.fragment,e),h(le.$$.fragment,e),h(ne.$$.fragment,e),h($.$$.fragment,e),h(ce.$$.fragment,e),et=!0)},o(e){u(T.$$.fragment,e),u(j.$$.fragment,e),u(v.$$.fragment,e),u(k.$$.fragment,e),u(W.$$.fragment,e),u(G.$$.fragment,e),u(C.$$.fragment,e),u(g.$$.fragment,e),u(H.$$.fragment,e),u(F.$$.fragment,e),u(X.$$.fragment,e),u(Y.$$.fragment,e),u(A.$$.fragment,e),u(Q.$$.fragment,e),u(P.$$.fragment,e),u(D.$$.fragment,e),u(K.$$.fragment,e),u(te.$$.fragment,e),u(le.$$.fragment,e),u(ne.$$.fragment,e),u($.$$.fragment,e),u(ce.$$.fragment,e),et=!1},d(e){e&&(a(y),a(w),a(b),a(de),a(me),a(he),a(ue),a(U),a(fe),a(_),a(we),a(Me),a(ye),a(Z),a(be),a(Te),a(ge),a(R),a($e),a(Je),a(I),a(je),a(z),a(ve),a(ke),a(x),a(Ue),a(E),a(_e),a(We),a(V),a(Ge),a(B),a(Ze),a(Ce),a(N),a(Re),a(He),a(Ie),a(L),a(ze),a(q),a(Fe),a(xe),a(S),a(Ee),a(Xe),a(Ve),a(O),a(Be),a(ee),a(Ye),a(Ne),a(ae),a(Ae),a(Qe),a(se),a(Le),a(qe),a(ie),a(Pe),a(oe),a(Se),a(re),a(De),a(Ke),a(Oe),a(pe)),a(r),f(T,e),f(j,e),f(v,e),f(k,e),f(W,e),f(G,e),f(C,e),f(g,e),f(H,e),f(F,e),f(X,e),f(Y,e),f(A,e),f(Q,e),f(P,e),f(D,e),f(K,e),f(te,e),f(le,e),f(ne,e),f($,e),f(ce,e)}}}const Yt='{"title":"Fine-tuning a model with the Trainer API","local":"fine-tuning-a-model-with-the-trainer-api","sections":[{"title":"Training","local":"training","sections":[],"depth":3},{"title":"Evaluation","local":"evaluation","sections":[],"depth":3}],"depth":1}';function Nt(J,r,y){let w="pt";return Zt(()=>{const b=new URLSearchParams(window.location.search);y(0,w=b.get("fw")||"pt")}),[w]}class Ot extends Ct{constructor(r){super(),Rt(this,r,Nt,Bt,Gt,{})}}export{Ot as component};
