import{s as ps,o as ms,n as E}from"../chunks/scheduler.7da89386.js";import{S as ds,i as cs,g as p,s as o,r as c,A as gs,h as m,f as a,c as i,j as I,u as g,x,k as w,y as t,a as d,v as u,d as _,t as f,w as h}from"../chunks/index.20910acc.js";import{D as P}from"../chunks/Docstring.836c2253.js";import{C as Y}from"../chunks/CodeBlock.143bd81e.js";import{E as B}from"../chunks/ExampleCodeBlock.ac04ff3b.js";import{H as k}from"../chunks/getInferenceSnippets.17a58e00.js";function us(N){let s,v="Examples:",y,l,b;return l=new Y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyME9SVFN0YWJsZU9SVERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTStableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = ORTStableORTDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){s=p("p"),s.textContent=v,y=o(),c(l.$$.fragment)},l(n){s=m(n,"P",{"data-svelte-h":!0}),x(s)!=="svelte-kvfsh7"&&(s.textContent=v),y=i(n),g(l.$$.fragment,n)},m(n,T){d(n,s,T),d(n,y,T),u(l,n,T),b=!0},p:E,i(n){b||(_(l.$$.fragment,n),b=!0)},o(n){f(l.$$.fragment,n),b=!1},d(n){n&&(a(s),a(y)),h(l,n)}}}function _s(N){let s,v="Examples:",y,l,b;return l=new Y({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEElMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVFN0YWJsZURpZmZ1c2lvbkltZzJJbWdQaXBlbGluZSUwQSUwQWRldmljZSUyMCUzRCUyMCUyMmN1ZGElMjIlMEFtb2RlbF9pZF9vcl9wYXRoJTIwJTNEJTIwJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyME9SVFN0YWJsZURpZmZ1c2lvbkltZzJJbWdQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWRfb3JfcGF0aCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byhkZXZpY2UpJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGQ29tcFZpcyUyRnN0YWJsZS1kaWZmdXNpb24lMkZtYWluJTJGYXNzZXRzJTJGc3RhYmxlLXNhbXBsZXMlMkZpbWcyaW1nJTJGc2tldGNoLW1vdW50YWlucy1pbnB1dC5qcGclMjIlMEElMEFyZXNwb25zZSUyMCUzRCUyMHJlcXVlc3RzLmdldCh1cmwpJTBBaW5pdF9pbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4oQnl0ZXNJTyhyZXNwb25zZS5jb250ZW50KSkuY29udmVydCglMjJSR0IlMjIpJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGluaXRfaW1hZ2UucmVzaXplKCg3NjglMkMlMjA1MTIpKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBmYW50YXN5JTIwbGFuZHNjYXBlJTJDJTIwdHJlbmRpbmclMjBvbiUyMGFydHN0YXRpb24lMjIlMEElMEFpbWFnZXMlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMHN0cmVuZ3RoJTNEMC43NSUyQyUyMGd1aWRhbmNlX3NjYWxlJTNENy41KS5pbWFnZXMlMEFpbWFnZXMlNUIwJTVELnNhdmUoJTIyZmFudGFzeV9sYW5kc2NhcGUucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTStableDiffusionImg2ImgPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_id_or_path = <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = ORTStableDiffusionImg2ImgPipeline.from_pretrained(model_id_or_path, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>response = requests.get(url)
<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = init_image.resize((<span class="hljs-number">768</span>, <span class="hljs-number">512</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A fantasy landscape, trending on artstation&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(prompt=prompt, image=init_image, strength=<span class="hljs-number">0.75</span>, guidance_scale=<span class="hljs-number">7.5</span>).images
<span class="hljs-meta">&gt;&gt;&gt; </span>images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;fantasy_landscape.png&quot;</span>)`,wrap:!1}}),{c(){s=p("p"),s.textContent=v,y=o(),c(l.$$.fragment)},l(n){s=m(n,"P",{"data-svelte-h":!0}),x(s)!=="svelte-kvfsh7"&&(s.textContent=v),y=i(n),g(l.$$.fragment,n)},m(n,T){d(n,s,T),d(n,y,T),u(l,n,T),b=!0},p:E,i(n){b||(_(l.$$.fragment,n),b=!0)},o(n){f(l.$$.fragment,n),b=!1},d(n){n&&(a(s),a(y)),h(l,n)}}}function fs(N){let s,v="Examples:",y,l,b;return l=new Y({props:{code:"aW1wb3J0JTIwUElMJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEElMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVFN0YWJsZURpZmZ1c2lvbklucGFpbnRQaXBlbGluZSUwQSUwQSUwQWRlZiUyMGRvd25sb2FkX2ltYWdlKHVybCklM0ElMEElMjAlMjAlMjAlMjByZXNwb25zZSUyMCUzRCUyMHJlcXVlc3RzLmdldCh1cmwpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwUElMLkltYWdlLm9wZW4oQnl0ZXNJTyhyZXNwb25zZS5jb250ZW50KSkuY29udmVydCglMjJSR0IlMjIpJTBBJTBBJTBBaW1nX3VybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRkNvbXBWaXMlMkZsYXRlbnQtZGlmZnVzaW9uJTJGbWFpbiUyRmRhdGElMkZpbnBhaW50aW5nX2V4YW1wbGVzJTJGb3ZlcnR1cmUtY3JlYXRpb25zLTVzSTZmUWdZSXVvLnBuZyUyMiUwQW1hc2tfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGQ29tcFZpcyUyRmxhdGVudC1kaWZmdXNpb24lMkZtYWluJTJGZGF0YSUyRmlucGFpbnRpbmdfZXhhbXBsZXMlMkZvdmVydHVyZS1jcmVhdGlvbnMtNXNJNmZRZ1lJdW9fbWFzay5wbmclMjIlMEElMEFpbml0X2ltYWdlJTIwJTNEJTIwZG93bmxvYWRfaW1hZ2UoaW1nX3VybCkucmVzaXplKCg1MTIlMkMlMjA1MTIpKSUwQW1hc2tfaW1hZ2UlMjAlM0QlMjBkb3dubG9hZF9pbWFnZShtYXNrX3VybCkucmVzaXplKCg1MTIlMkMlMjA1MTIpKSUwQSUwQXBpcGUlMjAlM0QlMjBPUlRTdGFibGVEaWZmdXNpb25JbnBhaW50UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24taW5wYWludGluZyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkZhY2UlMjBvZiUyMGElMjB5ZWxsb3clMjBjYXQlMkMlMjBoaWdoJTIwcmVzb2x1dGlvbiUyQyUyMHNpdHRpbmclMjBvbiUyMGElMjBwYXJrJTIwYmVuY2glMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTIwbWFza19pbWFnZSUzRG1hc2tfaW1hZ2UpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> PIL
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTStableDiffusionInpaintPipeline


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">download_image</span>(<span class="hljs-params">url</span>):
<span class="hljs-meta">... </span>    response = requests.get(url)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> PIL.Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span>img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = download_image(img_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_image = download_image(mask_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = ORTStableDiffusionInpaintPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-inpainting&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Face of a yellow cat, high resolution, sitting on a park bench&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt=prompt, image=init_image, mask_image=mask_image).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){s=p("p"),s.textContent=v,y=o(),c(l.$$.fragment)},l(n){s=m(n,"P",{"data-svelte-h":!0}),x(s)!=="svelte-kvfsh7"&&(s.textContent=v),y=i(n),g(l.$$.fragment,n)},m(n,T){d(n,s,T),d(n,y,T),u(l,n,T),b=!0},p:E,i(n){b||(_(l.$$.fragment,n),b=!0)},o(n){f(l.$$.fragment,n),b=!1},d(n){n&&(a(s),a(y)),h(l,n)}}}function hs(N){let s,v="Examples:",y,l,b;return l=new Y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwT1JUU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGUlMjAlM0QlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTStableDiffusionXLPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = ORTStableDiffusionXLPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){s=p("p"),s.textContent=v,y=o(),c(l.$$.fragment)},l(n){s=m(n,"P",{"data-svelte-h":!0}),x(s)!=="svelte-kvfsh7"&&(s.textContent=v),y=i(n),g(l.$$.fragment,n)},m(n,T){d(n,s,T),d(n,y,T),u(l,n,T),b=!0},p:E,i(n){b||(_(l.$$.fragment,n),b=!0)},o(n){f(l.$$.fragment,n),b=!1},d(n){n&&(a(s),a(y)),h(l,n)}}}function bs(N){let s,v="Examples:",y,l,b;return l=new Y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVFN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFwaXBlJTIwJTNEJTIwT1JUU3RhYmxlRGlmZnVzaW9uWExJbWcySW1nUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1yZWZpbmVyLTEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRnBhdHJpY2t2b25wbGF0ZW4lMkZpbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmFhX3hsJTJGMDAwMDAwMDA5LnBuZyUyMiUwQSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKHVybCkuY29udmVydCglMjJSR0IlMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTStableDiffusionXLImg2ImgPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = ORTStableDiffusionXLImg2ImgPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-refiner-1.0&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://huggingface.co/datasets/patrickvonplaten/images/resolve/main/aa_xl/000000009.png&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = load_image(url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt, image=init_image).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){s=p("p"),s.textContent=v,y=o(),c(l.$$.fragment)},l(n){s=m(n,"P",{"data-svelte-h":!0}),x(s)!=="svelte-kvfsh7"&&(s.textContent=v),y=i(n),g(l.$$.fragment,n)},m(n,T){d(n,s,T),d(n,y,T),u(l,n,T),b=!0},p:E,i(n){b||(_(l.$$.fragment,n),b=!0)},o(n){f(l.$$.fragment,n),b=!1},d(n){n&&(a(s),a(y)),h(l,n)}}}function ys(N){let s,v="Examples:",y,l,b;return l=new Y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVFN0YWJsZURpZmZ1c2lvblhMSW5wYWludFBpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFwaXBlJTIwJTNEJTIwT1JUU3RhYmxlRGlmZnVzaW9uWExJbnBhaW50UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBaW1nX3VybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRkNvbXBWaXMlMkZsYXRlbnQtZGlmZnVzaW9uJTJGbWFpbiUyRmRhdGElMkZpbnBhaW50aW5nX2V4YW1wbGVzJTJGb3ZlcnR1cmUtY3JlYXRpb25zLTVzSTZmUWdZSXVvLnBuZyUyMiUwQW1hc2tfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGQ29tcFZpcyUyRmxhdGVudC1kaWZmdXNpb24lMkZtYWluJTJGZGF0YSUyRmlucGFpbnRpbmdfZXhhbXBsZXMlMkZvdmVydHVyZS1jcmVhdGlvbnMtNXNJNmZRZ1lJdW9fbWFzay5wbmclMjIlMEElMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZShpbWdfdXJsKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFtYXNrX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZShtYXNrX3VybCkuY29udmVydCglMjJSR0IlMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMG1hamVzdGljJTIwdGlnZXIlMjBzaXR0aW5nJTIwb24lMjBhJTIwYmVuY2glMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTIwbWFza19pbWFnZSUzRG1hc2tfaW1hZ2UlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMjBzdHJlbmd0aCUzRDAuODAlMEEpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTStableDiffusionXLInpaintPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = ORTStableDiffusionXLInpaintPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = load_image(img_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_image = load_image(mask_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A majestic tiger sitting on a bench&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    prompt=prompt, image=init_image, mask_image=mask_image, num_inference_steps=<span class="hljs-number">50</span>, strength=<span class="hljs-number">0.80</span>
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){s=p("p"),s.textContent=v,y=o(),c(l.$$.fragment)},l(n){s=m(n,"P",{"data-svelte-h":!0}),x(s)!=="svelte-kvfsh7"&&(s.textContent=v),y=i(n),g(l.$$.fragment,n)},m(n,T){d(n,s,T),d(n,y,T),u(l,n,T),b=!0},p:E,i(n){b||(_(l.$$.fragment,n),b=!0)},o(n){f(l.$$.fragment,n),b=!1},d(n){n&&(a(s),a(y)),h(l,n)}}}function xs(N){let s,v="Examples:",y,l,b;return l=new Y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVFN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFwaXBlJTIwJTNEJTIwT1JUU3RhYmxlRGlmZnVzaW9uWExJbWcySW1nUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1yZWZpbmVyLTEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRnBhdHJpY2t2b25wbGF0ZW4lMkZpbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmFhX3hsJTJGMDAwMDAwMDA5LnBuZyUyMiUwQSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKHVybCkuY29udmVydCglMjJSR0IlMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTStableDiffusionXLImg2ImgPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = ORTStableDiffusionXLImg2ImgPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-refiner-1.0&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://huggingface.co/datasets/patrickvonplaten/images/resolve/main/aa_xl/000000009.png&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = load_image(url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt, image=init_image).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){s=p("p"),s.textContent=v,y=o(),c(l.$$.fragment)},l(n){s=m(n,"P",{"data-svelte-h":!0}),x(s)!=="svelte-kvfsh7"&&(s.textContent=v),y=i(n),g(l.$$.fragment,n)},m(n,T){d(n,s,T),d(n,y,T),u(l,n,T),b=!0},p:E,i(n){b||(_(l.$$.fragment,n),b=!0)},o(n){f(l.$$.fragment,n),b=!1},d(n){n&&(a(s),a(y)),h(l,n)}}}function Ts(N){let s,v="Examples:",y,l,b;return l=new Y({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlREaWZmdXNpb25QaXBlbGluZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZSUyMCUzRCUyME9SVERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJTaW1pYW5MdW8lMkZMQ01fRHJlYW1zaGFwZXJfdjclMjIpJTBBJTIzJTIwVG8lMjBzYXZlJTIwR1BVJTIwbWVtb3J5JTJDJTIwdG9yY2guZmxvYXQxNiUyMGNhbiUyMGJlJTIwdXNlZCUyQyUyMGJ1dCUyMGl0JTIwbWF5JTIwY29tcHJvbWlzZSUyMGltYWdlJTIwcXVhbGl0eS4lMEFwaXBlLnRvKHRvcmNoX2RldmljZSUzRCUyMmN1ZGElMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MzIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyU2VsZi1wb3J0cmFpdCUyMG9pbCUyMHBhaW50aW5nJTJDJTIwYSUyMGJlYXV0aWZ1bCUyMGN5Ym9yZyUyMHdpdGglMjBnb2xkZW4lMjBoYWlyJTJDJTIwOGslMjIlMEElMEElMjMlMjBDYW4lMjBiZSUyMHNldCUyMHRvJTIwMX41MCUyMHN0ZXBzLiUyMExDTSUyMHN1cHBvcnQlMjBmYXN0JTIwaW5mZXJlbmNlJTIwZXZlbiUyMCUzQyUzRCUyMDQlMjBzdGVwcy4lMjBSZWNvbW1lbmQlM0ElMjAxfjglMjBzdGVwcy4lMEFudW1faW5mZXJlbmNlX3N0ZXBzJTIwJTNEJTIwNCUwQWltYWdlcyUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRG51bV9pbmZlcmVuY2Vfc3RlcHMlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDguMCkuaW1hZ2VzJTBBaW1hZ2VzJTVCMCU1RC5zYXZlKCUyMmltYWdlLnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTDiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = ORTDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;SimianLuo/LCM_Dreamshaper_v7&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To save GPU memory, torch.float16 can be used, but it may compromise image quality.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(torch_device=<span class="hljs-string">&quot;cuda&quot;</span>, torch_dtype=torch.float32)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Self-portrait oil painting, a beautiful cyborg with golden hair, 8k&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Can be set to 1~50 steps. LCM support fast inference even &lt;= 4 steps. Recommend: 1~8 steps.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_inference_steps = <span class="hljs-number">4</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(prompt=prompt, num_inference_steps=num_inference_steps, guidance_scale=<span class="hljs-number">8.0</span>).images
<span class="hljs-meta">&gt;&gt;&gt; </span>images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;image.png&quot;</span>)`,wrap:!1}}),{c(){s=p("p"),s.textContent=v,y=o(),c(l.$$.fragment)},l(n){s=m(n,"P",{"data-svelte-h":!0}),x(s)!=="svelte-kvfsh7"&&(s.textContent=v),y=i(n),g(l.$$.fragment,n)},m(n,T){d(n,s,T),d(n,y,T),u(l,n,T),b=!0},p:E,i(n){b||(_(l.$$.fragment,n),b=!0)},o(n){f(l.$$.fragment,n),b=!1},d(n){n&&(a(s),a(y)),h(l,n)}}}function vs(N){let s,v="Examples:",y,l,b;return l=new Y({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRQaXBlbGluZUZvckltYWdlMkltYWdlJTBBaW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBQSUwlMEElMEFwaXBlJTIwJTNEJTIwT1JUUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTIyU2ltaWFuTHVvJTJGTENNX0RyZWFtc2hhcGVyX3Y3JTIyKSUwQSUyMyUyMFRvJTIwc2F2ZSUyMEdQVSUyMG1lbW9yeSUyQyUyMHRvcmNoLmZsb2F0MTYlMjBjYW4lMjBiZSUyMHVzZWQlMkMlMjBidXQlMjBpdCUyMG1heSUyMGNvbXByb21pc2UlMjBpbWFnZSUyMHF1YWxpdHkuJTBBcGlwZS50byh0b3JjaF9kZXZpY2UlM0QlMjJjdWRhJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDMyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkhpZ2glMjBhbHRpdHVkZSUyMHNub3d5JTIwbW91bnRhaW5zJTIyJTBBaW1hZ2UlMjAlM0QlMjBQSUwuSW1hZ2Uub3BlbiglMjIuJTJGc25vd3lfbW91bnRhaW5zLnBuZyUyMiklMEElMEElMjMlMjBDYW4lMjBiZSUyMHNldCUyMHRvJTIwMX41MCUyMHN0ZXBzLiUyMExDTSUyMHN1cHBvcnQlMjBmYXN0JTIwaW5mZXJlbmNlJTIwZXZlbiUyMCUzQyUzRCUyMDQlMjBzdGVwcy4lMjBSZWNvbW1lbmQlM0ElMjAxfjglMjBzdGVwcy4lMEFudW1faW5mZXJlbmNlX3N0ZXBzJTIwJTNEJTIwNCUwQWltYWdlcyUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0RpbWFnZSUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0RudW1faW5mZXJlbmNlX3N0ZXBzJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q4LjAlMEEpLmltYWdlcyUwQSUwQWltYWdlcyU1QjAlNUQuc2F2ZSglMjJpbWFnZS5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTPipelineForImage2Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> PIL

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = ORTPipelineForImage2Image.from_pretrained(<span class="hljs-string">&quot;SimianLuo/LCM_Dreamshaper_v7&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To save GPU memory, torch.float16 can be used, but it may compromise image quality.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(torch_device=<span class="hljs-string">&quot;cuda&quot;</span>, torch_dtype=torch.float32)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;High altitude snowy mountains&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = PIL.Image.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;./snowy_mountains.png&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Can be set to 1~50 steps. LCM support fast inference even &lt;= 4 steps. Recommend: 1~8 steps.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_inference_steps = <span class="hljs-number">4</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(
<span class="hljs-meta">... </span>    prompt=prompt, image=image, num_inference_steps=num_inference_steps, guidance_scale=<span class="hljs-number">8.0</span>
<span class="hljs-meta">... </span>).images

<span class="hljs-meta">&gt;&gt;&gt; </span>images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;image.png&quot;</span>)`,wrap:!1}}),{c(){s=p("p"),s.textContent=v,y=o(),c(l.$$.fragment)},l(n){s=m(n,"P",{"data-svelte-h":!0}),x(s)!=="svelte-kvfsh7"&&(s.textContent=v),y=i(n),g(l.$$.fragment,n)},m(n,T){d(n,s,T),d(n,y,T),u(l,n,T),b=!0},p:E,i(n){b||(_(l.$$.fragment,n),b=!0)},o(n){f(l.$$.fragment,n),b=!1},d(n){n&&(a(s),a(y)),h(l,n)}}}function Is(N){let s,v="Examples:",y,l,b;return l=new Y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBPUlRTdGFibGVEaWZmdXNpb24zUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi0zLW1lZGl1bS1kaWZmdXNlcnMlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBjYXQlMjBob2xkaW5nJTIwYSUyMHNpZ24lMjB0aGF0JTIwc2F5cyUyMGhlbGxvJTIwd29ybGQlMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0KS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJzZDMucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTStableDiffusion3Pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = ORTStableDiffusion3Pipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;sd3.png&quot;</span>)`,wrap:!1}}),{c(){s=p("p"),s.textContent=v,y=o(),c(l.$$.fragment)},l(n){s=m(n,"P",{"data-svelte-h":!0}),x(s)!=="svelte-kvfsh7"&&(s.textContent=v),y=i(n),g(l.$$.fragment,n)},m(n,T){d(n,s,T),d(n,y,T),u(l,n,T),b=!0},p:E,i(n){b||(_(l.$$.fragment,n),b=!0)},o(n){f(l.$$.fragment,n),b=!1},d(n){n&&(a(s),a(y)),h(l,n)}}}function ws(N){let s,v="Examples:",y,l,b;return l=new Y({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVFBpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQWRldmljZSUyMCUzRCUyMCUyMmN1ZGElMjIlMEFtb2RlbF9pZF9vcl9wYXRoJTIwJTNEJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTMtbWVkaXVtLWRpZmZ1c2VycyUyMiUwQXBpcGUlMjAlM0QlMjBPUlRQaXBlbGluZUZvckltYWdlMkltYWdlLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZF9vcl9wYXRoJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGUlMjAlM0QlMjBwaXBlLnRvKGRldmljZSklMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGc3RhYmxlLWRpZmZ1c2lvbiUyRm1haW4lMkZhc3NldHMlMkZzdGFibGUtc2FtcGxlcyUyRmltZzJpbWclMkZza2V0Y2gtbW91bnRhaW5zLWlucHV0LmpwZyUyMiUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKHVybCkucmVzaXplKCgxMDI0JTJDJTIwMTAyNCkpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyY2F0JTIwd2l6YXJkJTJDJTIwZ2FuZGFsZiUyQyUyMGxvcmQlMjBvZiUyMHRoZSUyMHJpbmdzJTJDJTIwZGV0YWlsZWQlMkMlMjBmYW50YXN5JTJDJTIwY3V0ZSUyQyUyMGFkb3JhYmxlJTJDJTIwUGl4YXIlMkMlMjBEaXNuZXklMkMlMjA4ayUyMiUwQSUwQWltYWdlcyUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTIwc3RyZW5ndGglM0QwLjk1JTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q3LjUpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTPipelineForImage2Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_id_or_path = <span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = ORTPipelineForImage2Image.from_pretrained(model_id_or_path, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = load_image(url).resize((<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;cat wizard, gandalf, lord of the rings, detailed, fantasy, cute, adorable, Pixar, Disney, 8k&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(prompt=prompt, image=init_image, strength=<span class="hljs-number">0.95</span>, guidance_scale=<span class="hljs-number">7.5</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){s=p("p"),s.textContent=v,y=o(),c(l.$$.fragment)},l(n){s=m(n,"P",{"data-svelte-h":!0}),x(s)!=="svelte-kvfsh7"&&(s.textContent=v),y=i(n),g(l.$$.fragment,n)},m(n,T){d(n,s,T),d(n,y,T),u(l,n,T),b=!0},p:E,i(n){b||(_(l.$$.fragment,n),b=!0)},o(n){f(l.$$.fragment,n),b=!1},d(n){n&&(a(s),a(y)),h(l,n)}}}function Ps(N){let s,v="Examples:",y,l,b;return l=new Y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVFN0YWJsZURpZmZ1c2lvbjNJbnBhaW50UGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQXBpcGUlMjAlM0QlMjBPUlRTdGFibGVEaWZmdXNpb24zSW5wYWludFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMy1tZWRpdW0tZGlmZnVzZXJzJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGUudG8oJTIyY3VkYSUyMiklMEFwcm9tcHQlMjAlM0QlMjAlMjJGYWNlJTIwb2YlMjBhJTIweWVsbG93JTIwY2F0JTJDJTIwaGlnaCUyMHJlc29sdXRpb24lMkMlMjBzaXR0aW5nJTIwb24lMjBhJTIwcGFyayUyMGJlbmNoJTIyJTBBaW1nX3VybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRkNvbXBWaXMlMkZsYXRlbnQtZGlmZnVzaW9uJTJGbWFpbiUyRmRhdGElMkZpbnBhaW50aW5nX2V4YW1wbGVzJTJGb3ZlcnR1cmUtY3JlYXRpb25zLTVzSTZmUWdZSXVvLnBuZyUyMiUwQW1hc2tfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGQ29tcFZpcyUyRmxhdGVudC1kaWZmdXNpb24lMkZtYWluJTJGZGF0YSUyRmlucGFpbnRpbmdfZXhhbXBsZXMlMkZvdmVydHVyZS1jcmVhdGlvbnMtNXNJNmZRZ1lJdW9fbWFzay5wbmclMjIlMEFzb3VyY2UlMjAlM0QlMjBsb2FkX2ltYWdlKGltZ191cmwpJTBBbWFzayUyMCUzRCUyMGxvYWRfaW1hZ2UobWFza191cmwpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEc291cmNlJTJDJTIwbWFza19pbWFnZSUzRG1hc2spLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMnNkM19pbnBhaW50aW5nLnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTStableDiffusion3InpaintPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = ORTStableDiffusion3InpaintPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Face of a yellow cat, high resolution, sitting on a park bench&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>source = load_image(img_url)
<span class="hljs-meta">&gt;&gt;&gt; </span>mask = load_image(mask_url)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt=prompt, image=source, mask_image=mask).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;sd3_inpainting.png&quot;</span>)`,wrap:!1}}),{c(){s=p("p"),s.textContent=v,y=o(),c(l.$$.fragment)},l(n){s=m(n,"P",{"data-svelte-h":!0}),x(s)!=="svelte-kvfsh7"&&(s.textContent=v),y=i(n),g(l.$$.fragment,n)},m(n,T){d(n,s,T),d(n,y,T),u(l,n,T),b=!0},p:E,i(n){b||(_(l.$$.fragment,n),b=!0)},o(n){f(l.$$.fragment,n),b=!1},d(n){n&&(a(s),a(y)),h(l,n)}}}function Ns(N){let s,v="Examples:",y,l,b;return l=new Y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVEZsdXhQaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBPUlRGbHV4UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLXNjaG5lbGwlMjIpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBjYXQlMjBob2xkaW5nJTIwYSUyMHNpZ24lMjB0aGF0JTIwc2F5cyUyMGhlbGxvJTIwd29ybGQlMjIlMEElMjMlMjBEZXBlbmRpbmclMjBvbiUyMHRoZSUyMHZhcmlhbnQlMjBiZWluZyUyMHVzZWQlMkMlMjB0aGUlMjBwaXBlbGluZSUyMGNhbGwlMjB3aWxsJTIwc2xpZ2h0bHklMjB2YXJ5LiUwQSUyMyUyMFJlZmVyJTIwdG8lMjB0aGUlMjBwaXBlbGluZSUyMGRvY3VtZW50YXRpb24lMjBmb3IlMjBtb3JlJTIwZGV0YWlscy4lMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDAuMCkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyZmx1eC5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTFluxPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = ORTFluxPipeline.from_pretrained(<span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Depending on the variant being used, the pipeline call will slightly vary.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Refer to the pipeline documentation for more details.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt, num_inference_steps=<span class="hljs-number">4</span>, guidance_scale=<span class="hljs-number">0.0</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;flux.png&quot;</span>)`,wrap:!1}}),{c(){s=p("p"),s.textContent=v,y=o(),c(l.$$.fragment)},l(n){s=m(n,"P",{"data-svelte-h":!0}),x(s)!=="svelte-kvfsh7"&&(s.textContent=v),y=i(n),g(l.$$.fragment,n)},m(n,T){d(n,s,T),d(n,y,T),u(l,n,T),b=!0},p:E,i(n){b||(_(l.$$.fragment,n),b=!0)},o(n){f(l.$$.fragment,n),b=!1},d(n){n&&(a(s),a(y)),h(l,n)}}}function ks(N){let s,v,y,l,b,n,T,Vt,je,la="The following classes are available for instantiating a diffusion pipeline class without needing to specify the task or architecture.",Qt,Xe,At,L,Ze,Uo,Jn,pa="Base class for all ONNX Runtime Pipelines.",Jo,jn,ma=`<code>ORTDiffusionPipeline</code> stores all components (models, schedulers, and processors) for diffusion pipelines and
provides methods for exporting, loading, downloading and saving models. It also includes methods to:`,jo,Xn,da="<li>move all ONNX Runtime sessions to the device of your choice</li> <li>enable/disable the progress bar for the denoising iteration</li> <li>handle ONNX Runtime io binding if used</li>",Xo,Zn,ca="Class attributes:",Zo,Gn,ga=`<li><strong>config_name</strong> (<code>str</code>) — The configuration filename that stores the class and module names of all the
diffusion pipeline’s components.</li> <li><strong>task</strong> (<code>str</code>) — A string that identifies the pipeline’s task.</li> <li><strong>library</strong> (<code>str</code>) — The library the pipeline is compatible with.</li> <li><strong>auto_model_class</strong> (<code>Type[DiffusionPipeline]</code>) — The corresponding/equivalent Diffusers pipeline class.</li>`,Go,ye,Ge,Wo,Wn,ua=`Instantiates a <code>ORTDiffusionPipeline</code> with ONNX Runtime sessions from a pretrained pipeline repo or directory.
This method can be used to export a diffusion pipeline to ONNX and/or load a pipeline with ONNX Runtime from a repo or a directory.`,Kt,We,eo,S,ze,zo,zn,_a=`<code>ORTPipelineForText2Image</code> is a generic pipeline class that instantiates a text-to-image pipeline class.
The specific underlying pipeline class is automatically selected from either the
<code>~ORTPipelineForText2Image.from_pretrained</code> or <code>~ORTPipelineForText2Image.from_pipe</code> methods.`,Fo,Fn,fa="This class cannot be instantiated using <code>__init__()</code> (throws an error).",Bo,Bn,ha="Class attributes:",Eo,En,ba=`<li><strong>config_name</strong> (<code>str</code>) — The configuration filename that stores the class and module names of all the
diffusion pipeline’s components.</li> <li><strong>auto_model_class</strong> (<code>Type[DiffusionPipeline]</code>) — The corresponding/equivalent Diffusers pipeline class.</li> <li><strong>ort_pipelines_mapping</strong> (<code>OrderedDict</code>) — The mapping between the model names/architectures and the
corresponding ORT pipeline class.</li>`,no,Fe,to,R,Be,Yo,Yn,ya=`<code>ORTPipelineForImage2Image</code> is a generic pipeline class that instantiates an image-to-image pipeline class. The
specific underlying pipeline class is automatically selected from either the
<code>~ORTPipelineForImage2Image.from_pretrained</code> or <code>~ORTPipelineForImage2Image.from_pipe</code> methods.`,Ho,Hn,xa="This class cannot be instantiated using <code>__init__()</code> (throws an error).",qo,qn,Ta="Class attributes:",Vo,Vn,va=`<li><strong>config_name</strong> (<code>str</code>) — The configuration filename that stores the class and module names of all the
diffusion pipeline’s components.</li> <li><strong>auto_model_class</strong> (<code>Type[DiffusionPipeline]</code>) — The corresponding/equivalent Diffusers pipeline class.</li> <li><strong>ort_pipelines_mapping</strong> (<code>OrderedDict</code>) — The mapping between the model names/architectures and the
corresponding ORT pipeline class.</li>`,oo,Ee,io,O,Ye,Qo,Qn,Ia=`<code>ORTPipelineForInpainting</code> is a generic pipeline class that instantiates an inpainting pipeline class. The
specific underlying pipeline class is automatically selected from either the
<code>~ORTPipelineForInpainting.from_pretrained</code> or <code>~ORTPipelineForInpainting.from_pipe</code> methods.`,Ao,An,wa="This class cannot be instantiated using <code>__init__()</code> (throws an error).",Ko,Kn,Pa="Class attributes:",ei,et,Na=`<li><strong>config_name</strong> (<code>str</code>) — The configuration filename that stores the class and module names of all the
diffusion pipeline’s components.</li> <li><strong>auto_model_class</strong> (<code>Type[DiffusionPipeline]</code>) — The corresponding/equivalent Diffusers pipeline class.</li> <li><strong>ort_pipelines_mapping</strong> (<code>OrderedDict</code>) — The mapping between the model names/architectures and the
corresponding ORT pipeline class.</li>`,ao,He,so,qe,ka="The following classes are available for instantiating a diffusion pipeline class for a specific task and architecture.",ro,Ve,lo,D,Qe,ni,nt,La=`ONNX Runtime-powered Pipeline for text-to-image generation using Stable Diffusion and corresponding to [StableDiffusionPipeline]
(<a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline" rel="nofollow">https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline</a>).`,ti,tt,Ma=`This Pipeline inherits from <code>ORTDiffusionPipeline</code> and is used to run inference with the ONNX Runtime.
The pipeline can be loaded from a pretrained pipeline using the generic <code>ORTDiffusionPipeline.from_pretrained</code> method.`,oi,te,Ae,ii,ot,Sa="The call function to the pipeline for generation.",ai,xe,po,Ke,mo,C,en,si,it,Ra=`ONNX Runtime-powered Pipeline for text-guided image-to-image generation using Stable Diffusion and corresponding to [StableDiffusionImg2ImgPipeline]
(<a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/img2img#diffusers.StableDiffusionImg2ImgPipeline" rel="nofollow">https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/img2img#diffusers.StableDiffusionImg2ImgPipeline</a>).`,ri,at,Oa=`This Pipeline inherits from <code>ORTDiffusionPipeline</code> and is used to run inference with the ONNX Runtime.
The pipeline can be loaded from a pretrained pipeline using the generic <code>ORTDiffusionPipeline.from_pretrained</code> method.`,li,oe,nn,pi,st,Da="The call function to the pipeline for generation.",mi,Te,co,tn,go,$,on,di,rt,Ca=`ONNX Runtime-powered Pipeline for text-guided image inpainting using Stable Diffusion and corresponding to [StableDiffusionInpaintPipeline]
(<a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline" rel="nofollow">https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline</a>).`,ci,lt,$a=`This Pipeline inherits from <code>ORTDiffusionPipeline</code> and is used to run inference with the ONNX Runtime.
The pipeline can be loaded from a pretrained pipeline using the generic <code>ORTDiffusionPipeline.from_pretrained</code> method.`,gi,ie,an,ui,pt,Ua="The call function to the pipeline for generation.",_i,ve,uo,sn,_o,U,rn,fi,mt,Ja=`ONNX Runtime-powered Pipeline for text-to-image generation using Stable Diffusion XL and corresponding to [StableDiffusionXLPipeline]
(<a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline" rel="nofollow">https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline</a>).`,hi,dt,ja=`This Pipeline inherits from <code>ORTDiffusionPipeline</code> and is used to run inference with the ONNX Runtime.
The pipeline can be loaded from a pretrained pipeline using the generic <code>ORTDiffusionPipeline.from_pretrained</code> method.`,bi,ae,ln,yi,ct,Xa="Function invoked when calling the pipeline for generation.",xi,Ie,fo,pn,ho,J,mn,Ti,gt,Za=`ONNX Runtime-powered Pipeline for text-guided image-to-image generation using Stable Diffusion XL and corresponding to [StableDiffusionXLImg2ImgPipeline]
(<a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLImg2ImgPipeline" rel="nofollow">https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLImg2ImgPipeline</a>).`,vi,ut,Ga=`This Pipeline inherits from <code>ORTDiffusionPipeline</code> and is used to run inference with the ONNX Runtime.
The pipeline can be loaded from a pretrained pipeline using the generic <code>ORTDiffusionPipeline.from_pretrained</code> method.`,Ii,se,dn,wi,_t,Wa="Function invoked when calling the pipeline for generation.",Pi,we,bo,cn,yo,j,gn,Ni,ft,za=`ONNX Runtime-powered Pipeline for text-guided image inpainting using Stable Diffusion XL and corresponding to [StableDiffusionXLInpaintPipeline]
(<a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLInpaintPipeline" rel="nofollow">https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLInpaintPipeline</a>).`,ki,ht,Fa=`This Pipeline inherits from <code>ORTDiffusionPipeline</code> and is used to run inference with the ONNX Runtime.
The pipeline can be loaded from a pretrained pipeline using the generic <code>ORTDiffusionPipeline.from_pretrained</code> method.`,Li,re,un,Mi,bt,Ba="Function invoked when calling the pipeline for generation.",Si,Pe,xo,_n,To,X,fn,Ri,yt,Ea=`ONNX Runtime-powered Pipeline for text-guided image-to-image generation using Stable Diffusion XL and corresponding to [StableDiffusionXLImg2ImgPipeline]
(<a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLImg2ImgPipeline" rel="nofollow">https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLImg2ImgPipeline</a>).`,Oi,xt,Ya=`This Pipeline inherits from <code>ORTDiffusionPipeline</code> and is used to run inference with the ONNX Runtime.
The pipeline can be loaded from a pretrained pipeline using the generic <code>ORTDiffusionPipeline.from_pretrained</code> method.`,Di,le,hn,Ci,Tt,Ha="Function invoked when calling the pipeline for generation.",$i,Ne,vo,bn,Io,Z,yn,Ui,vt,qa=`ONNX Runtime-powered Pipeline for text-to-image generation using a Latent Consistency Model and corresponding to [LatentConsistencyModelPipeline]
(<a href="https://huggingface.co/docs/diffusers/api/pipelines/latent_consistency_models#diffusers.LatentConsistencyModelPipeline" rel="nofollow">https://huggingface.co/docs/diffusers/api/pipelines/latent_consistency_models#diffusers.LatentConsistencyModelPipeline</a>).`,Ji,It,Va=`This Pipeline inherits from <code>ORTDiffusionPipeline</code> and is used to run inference with the ONNX Runtime.
The pipeline can be loaded from a pretrained pipeline using the generic <code>ORTDiffusionPipeline.from_pretrained</code> method.`,ji,pe,xn,Xi,wt,Qa="The call function to the pipeline for generation.",Zi,ke,wo,Tn,Po,G,vn,Gi,Pt,Aa=`ONNX Runtime-powered Pipeline for text-guided image-to-image generation using a Latent Consistency Model and corresponding to [LatentConsistencyModelImg2ImgPipeline]
(<a href="https://huggingface.co/docs/diffusers/api/pipelines/latent_consistency_models#diffusers.LatentConsistencyModelImg2ImgPipeline" rel="nofollow">https://huggingface.co/docs/diffusers/api/pipelines/latent_consistency_models#diffusers.LatentConsistencyModelImg2ImgPipeline</a>).`,Wi,Nt,Ka=`This Pipeline inherits from <code>ORTDiffusionPipeline</code> and is used to run inference with the ONNX Runtime.
The pipeline can be loaded from a pretrained pipeline using the generic <code>ORTDiffusionPipeline.from_pretrained</code> method.`,zi,me,In,Fi,kt,es="The call function to the pipeline for generation.",Bi,Le,No,wn,ko,H,Pn,Ei,Lt,ns=`ONNX Runtime-powered Pipeline for text-to-image generation using Stable Diffusion 3 and corresponding to <a href="https://huggingface.co/docs/diffusers/en/api/pipelines/stable_diffusion/stable_diffusion_3#diffusers.StableDiffusion3Pipeline" rel="nofollow">StableDiffusion3Pipeline</a>.
This Pipeline inherits from <code>ORTDiffusionPipeline</code> and is used to run inference with the ONNX Runtime.
The pipeline can be loaded from a pretrained pipeline using the generic <code>ORTDiffusionPipeline.from_pretrained</code> method.`,Yi,de,Nn,Hi,Mt,ts="Function invoked when calling the pipeline for generation.",qi,Me,Lo,kn,Mo,q,Ln,Vi,St,os=`ONNX Runtime-powered Pipeline for text-guided image-to-image generation using Stable Diffusion 3 and corresponding to <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_3#diffusers.StableDiffusion3Img2ImgPipeline" rel="nofollow">StableDiffusion3Img2ImgPipeline</a>.
This Pipeline inherits from <code>ORTDiffusionPipeline</code> and is used to run inference with the ONNX Runtime.
The pipeline can be loaded from a pretrained pipeline using the generic <code>ORTDiffusionPipeline.from_pretrained</code> method.`,Qi,ce,Mn,Ai,Rt,is="Function invoked when calling the pipeline for generation.",Ki,Se,So,Sn,Ro,V,Rn,ea,Ot,as=`ONNX Runtime-powered Pipeline for text-guided image inpainting using Stable Diffusion 3 and corresponding to <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_3#diffusers.StableDiffusion3InpaintPipeline" rel="nofollow">StableDiffusion3InpaintPipeline</a>.
This Pipeline inherits from <code>ORTDiffusionPipeline</code> and is used to run inference with the ONNX Runtime.
The pipeline can be loaded from a pretrained pipeline using the generic <code>ORTDiffusionPipeline.from_pretrained</code> method.`,na,ge,On,ta,Dt,ss="Function invoked when calling the pipeline for generation.",oa,Re,Oo,Dn,Do,Q,Cn,ia,Ct,rs=`ONNX Runtime-powered Pipeline for text-to-image generation using Flux and corresponding to <a href="https://huggingface.co/docs/diffusers/api/pipelines/flux#diffusers.FluxPipeline" rel="nofollow">FluxPipeline</a>.
This Pipeline inherits from <code>ORTDiffusionPipeline</code> and is used to run inference with the ONNX Runtime.
The pipeline can be loaded from a pretrained pipeline using the generic <code>ORTDiffusionPipeline.from_pretrained</code> method.`,aa,ue,$n,sa,$t,ls="Function invoked when calling the pipeline for generation.",ra,Oe,Co,qt,$o;return b=new k({props:{title:"ONNX Runtime Diffusion Pipelines",local:"onnx-runtime-diffusion-pipelines",headingTag:"h1"}}),T=new k({props:{title:"Generic ORT Diffusion Pipeline classes",local:"generic-ort-diffusion-pipeline-classes",headingTag:"h2"}}),Xe=new k({props:{title:"ORTDiffusionPipeline",local:"optimum.onnxruntime.ORTDiffusionPipeline",headingTag:"h3"}}),Ze=new P({props:{name:"class optimum.onnxruntime.ORTDiffusionPipeline",anchor:"optimum.onnxruntime.ORTDiffusionPipeline",parameters:[{name:"unet_session",val:": InferenceSession | None = None"},{name:"transformer_session",val:": InferenceSession | None = None"},{name:"vae_decoder_session",val:": InferenceSession | None = None"},{name:"vae_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_2_session",val:": InferenceSession | None = None"},{name:"text_encoder_3_session",val:": InferenceSession | None = None"},{name:"scheduler",val:": SchedulerMixin | None = None"},{name:"tokenizer",val:": CLIPTokenizer | None = None"},{name:"tokenizer_2",val:": CLIPTokenizer | None = None"},{name:"tokenizer_3",val:": CLIPTokenizer | None = None"},{name:"feature_extractor",val:": CLIPFeatureExtractor | None = None"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"add_watermarker",val:": bool | None = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_53/optimum/onnxruntime/modeling_diffusion.py#L87"}}),Ge=new P({props:{name:"from_pretrained",anchor:"optimum.onnxruntime.ORTDiffusionPipeline.from_pretrained",parameters:[{name:"model_name_or_path",val:": str | Path"},{name:"export",val:": bool | None = None"},{name:"provider",val:": str = 'CPUExecutionProvider'"},{name:"providers",val:": Sequence[str] | None = None"},{name:"provider_options",val:": Sequence[dict[str, Any]] | dict[str, Any] | None = None"},{name:"session_options",val:": SessionOptions | None = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTDiffusionPipeline.from_pretrained.model_name_or_path",description:`<strong>model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Path to a folder containing the model files or a hub repository id.`,name:"model_name_or_path"},{anchor:"optimum.onnxruntime.ORTDiffusionPipeline.from_pretrained.export",description:`<strong>export</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Whether to export the model from Diffusers to ONNX. If left to <code>None</code>, the model is exported only if no
ONNX files are found in the <code>model_name_or_path</code> folder. If set to <code>True</code>, the model is always exported. If set to
<code>False</code>, the model is never exported.`,name:"export"},{anchor:"optimum.onnxruntime.ORTDiffusionPipeline.from_pretrained.provider",description:`<strong>provider</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;CPUExecutionProvider&quot;</code>) &#x2014;
The execution provider for ONNX Runtime. Can be <code>&quot;CUDAExecutionProvider&quot;</code>, <code>&quot;DmlExecutionProvider&quot;</code>,
etc.`,name:"provider"},{anchor:"optimum.onnxruntime.ORTDiffusionPipeline.from_pretrained.providers",description:`<strong>providers</strong> (<code>Sequence[str]</code>, <em>optional</em>) &#x2014;
A list of execution providers for ONNX Runtime. Overrides <code>provider</code>.`,name:"providers"},{anchor:"optimum.onnxruntime.ORTDiffusionPipeline.from_pretrained.provider_options",description:`<strong>provider_options</strong> (<code>Union[Sequence[Dict[str, Any]], Dict[str, Any]]</code>, <em>optional</em>) &#x2014;
Options for each execution provider. Can be a single dictionary for the first provider or a list of
dictionaries for each provider. The order of the dictionaries should match the order of the providers.`,name:"provider_options"},{anchor:"optimum.onnxruntime.ORTDiffusionPipeline.from_pretrained.session_options",description:`<strong>session_options</strong> (<code>SessionOptions</code>, <em>optional</em>) &#x2014;
Options for the ONNX Runtime session. Can be used to set optimization levels, graph optimization,
etc.`,name:"session_options"},{anchor:"optimum.onnxruntime.ORTDiffusionPipeline.from_pretrained.use_io_binding",description:`<strong>use_io_binding</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to use IOBinding for the ONNX Runtime session. If set to <code>True</code>, it will use IOBinding for
input and output tensors.`,name:"use_io_binding"},{anchor:"optimum.onnxruntime.ORTDiffusionPipeline.from_pretrained.*kwargs",description:`*<strong>*kwargs</strong> &#x2014;
Can include the following:<ul>
<li>Export arguments (e.g., <code>slim</code>, <code>dtype</code>, <code>device</code>, <code>no_dynamic_axes</code>, etc.).</li>
<li>Hugging Face Hub arguments (e.g., <code>revision</code>, <code>cache_dir</code>, <code>force_download</code>, etc.).</li>
<li>Preloaded models or sessions for the different components of the pipeline (e.g., <code>vae_encoder_session</code>,
<code>vae_decoder_session</code>, <code>unet_session</code>, <code>transformer_session</code>, <code>image_encoder</code>, <code>safety_checker</code>, etc.).</li>
</ul>`,name:"*kwargs"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_53/optimum/onnxruntime/modeling_diffusion.py#L261",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The loaded pipeline with ONNX Runtime sessions.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ORTDiffusionPipeline</code></p>
`}}),We=new k({props:{title:"ORTPipelineForText2Image",local:"optimum.onnxruntime.ORTPipelineForText2Image",headingTag:"h3"}}),ze=new P({props:{name:"class optimum.onnxruntime.ORTPipelineForText2Image",anchor:"optimum.onnxruntime.ORTPipelineForText2Image",parameters:[],source:"https://github.com/huggingface/optimum-onnx/blob/vr_53/optimum/onnxruntime/modeling_diffusion.py#L1222"}}),Fe=new k({props:{title:"ORTPipelineForImage2Image",local:"optimum.onnxruntime.ORTPipelineForImage2Image",headingTag:"h3"}}),Be=new P({props:{name:"class optimum.onnxruntime.ORTPipelineForImage2Image",anchor:"optimum.onnxruntime.ORTPipelineForImage2Image",parameters:[],source:"https://github.com/huggingface/optimum-onnx/blob/vr_53/optimum/onnxruntime/modeling_diffusion.py#L1244"}}),Ee=new k({props:{title:"ORTPipelineForInpainting",local:"optimum.onnxruntime.ORTPipelineForInpainting",headingTag:"h3"}}),Ye=new P({props:{name:"class optimum.onnxruntime.ORTPipelineForInpainting",anchor:"optimum.onnxruntime.ORTPipelineForInpainting",parameters:[],source:"https://github.com/huggingface/optimum-onnx/blob/vr_53/optimum/onnxruntime/modeling_diffusion.py#L1265"}}),He=new k({props:{title:"Supported ORT Diffusion Pipeline classes",local:"supported-ort-diffusion-pipeline-classes",headingTag:"h2"}}),Ve=new k({props:{title:"ORTStableDiffusionPipeline",local:"optimum.onnxruntime.ORTStableDiffusionPipeline",headingTag:"h3"}}),Qe=new P({props:{name:"class optimum.onnxruntime.ORTStableDiffusionPipeline",anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline",parameters:[{name:"unet_session",val:": InferenceSession | None = None"},{name:"transformer_session",val:": InferenceSession | None = None"},{name:"vae_decoder_session",val:": InferenceSession | None = None"},{name:"vae_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_2_session",val:": InferenceSession | None = None"},{name:"text_encoder_3_session",val:": InferenceSession | None = None"},{name:"scheduler",val:": SchedulerMixin | None = None"},{name:"tokenizer",val:": CLIPTokenizer | None = None"},{name:"tokenizer_2",val:": CLIPTokenizer | None = None"},{name:"tokenizer_3",val:": CLIPTokenizer | None = None"},{name:"feature_extractor",val:": CLIPFeatureExtractor | None = None"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"add_watermarker",val:": bool | None = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_53/optimum/onnxruntime/modeling_diffusion.py#L900"}}),Ae=new P({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": typing.List[int] = None"},{name:"sigmas",val:": typing.List[float] = None"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"guidance_rescale",val:": float = 0.0"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://huggingface.co/papers/2010.02502" rel="nofollow">DDIM</a> paper. Only
applies to the <code>~schedulers.DDIMScheduler</code>, and is ignored in other schedulers.`,name:"eta"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.ip_adapter_image",description:"<strong>ip_adapter_image</strong> &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.",name:"ip_adapter_image"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should
contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to <code>True</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Guidance rescale factor from <a href="https://huggingface.co/papers/2305.08891" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a>. Guidance rescale factor should fix overexposure when
using zero terminal SNR.`,name:"guidance_rescale"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_53/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py#L778",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> or <code>tuple</code></p>
`}}),xe=new B({props:{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.example",$$slots:{default:[us]},$$scope:{ctx:N}}}),Ke=new k({props:{title:"ORTStableDiffusionImg2ImgPipeline",local:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline",headingTag:"h3"}}),en=new P({props:{name:"class optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline",anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline",parameters:[{name:"unet_session",val:": InferenceSession | None = None"},{name:"transformer_session",val:": InferenceSession | None = None"},{name:"vae_decoder_session",val:": InferenceSession | None = None"},{name:"vae_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_2_session",val:": InferenceSession | None = None"},{name:"text_encoder_3_session",val:": InferenceSession | None = None"},{name:"scheduler",val:": SchedulerMixin | None = None"},{name:"tokenizer",val:": CLIPTokenizer | None = None"},{name:"tokenizer_2",val:": CLIPTokenizer | None = None"},{name:"tokenizer_3",val:": CLIPTokenizer | None = None"},{name:"feature_extractor",val:": CLIPFeatureExtractor | None = None"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"add_watermarker",val:": bool | None = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_53/optimum/onnxruntime/modeling_diffusion.py#L911"}}),nn=new P({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"strength",val:": float = 0.8"},{name:"num_inference_steps",val:": typing.Optional[int] = 50"},{name:"timesteps",val:": typing.List[int] = None"},{name:"sigmas",val:": typing.List[float] = None"},{name:"guidance_scale",val:": typing.Optional[float] = 7.5"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": typing.Optional[float] = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"clip_skip",val:": int = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to be used as the starting point. For both
numpy array and pytorch tensor, the expected value range is between <code>[0, 1]</code> If it&#x2019;s a tensor or a list
or tensors, the expected shape should be <code>(B, C, H, W)</code> or <code>(C, H, W)</code>. If it is a numpy array or a
list of arrays, the expected shape should be <code>(B, H, W, C)</code> or <code>(H, W, C)</code> It can also accept image
latents as <code>image</code>, but if passing latents directly it is not encoded again.`,name:"image"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
Indicates extent to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code> is used as a
starting point and more noise is added the higher the <code>strength</code>. The number of denoising steps depends
on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the denoising
process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of 1
essentially ignores <code>image</code>.`,name:"strength"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference. This parameter is modulated by <code>strength</code>.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://huggingface.co/papers/2010.02502" rel="nofollow">DDIM</a> paper. Only
applies to the <code>~schedulers.DDIMScheduler</code>, and is ignored in other schedulers.`,name:"eta"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.ip_adapter_image",description:"<strong>ip_adapter_image</strong> &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.",name:"ip_adapter_image"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should
contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to <code>True</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_53/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_img2img.py#L858",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> or <code>tuple</code></p>
`}}),Te=new B({props:{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.example",$$slots:{default:[_s]},$$scope:{ctx:N}}}),tn=new k({props:{title:"ORTStableDiffusionInpaintPipeline",local:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline",headingTag:"h3"}}),on=new P({props:{name:"class optimum.onnxruntime.ORTStableDiffusionInpaintPipeline",anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline",parameters:[{name:"unet_session",val:": InferenceSession | None = None"},{name:"transformer_session",val:": InferenceSession | None = None"},{name:"vae_decoder_session",val:": InferenceSession | None = None"},{name:"vae_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_2_session",val:": InferenceSession | None = None"},{name:"text_encoder_3_session",val:": InferenceSession | None = None"},{name:"scheduler",val:": SchedulerMixin | None = None"},{name:"tokenizer",val:": CLIPTokenizer | None = None"},{name:"tokenizer_2",val:": CLIPTokenizer | None = None"},{name:"tokenizer_3",val:": CLIPTokenizer | None = None"},{name:"feature_extractor",val:": CLIPFeatureExtractor | None = None"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"add_watermarker",val:": bool | None = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_53/optimum/onnxruntime/modeling_diffusion.py#L922"}}),an=new P({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"mask_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"masked_image_latents",val:": Tensor = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"padding_mask_crop",val:": typing.Optional[int] = None"},{name:"strength",val:": float = 1.0"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": typing.List[int] = None"},{name:"sigmas",val:": typing.List[float] = None"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"clip_skip",val:": int = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to be inpainted (which parts of the image to
be masked out with <code>mask_image</code> and repainted according to <code>prompt</code>). For both numpy array and pytorch
tensor, the expected value range is between <code>[0, 1]</code> If it&#x2019;s a tensor or a list or tensors, the
expected shape should be <code>(B, C, H, W)</code> or <code>(C, H, W)</code>. If it is a numpy array or a list of arrays, the
expected shape should be <code>(B, H, W, C)</code> or <code>(H, W, C)</code> It can also accept image latents as <code>image</code>, but
if passing latents directly it is not encoded again.`,name:"image"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to mask <code>image</code>. White pixels in the mask
are repainted while black pixels are preserved. If <code>mask_image</code> is a PIL image, it is converted to a
single channel (luminance) before use. If it&#x2019;s a numpy array or pytorch tensor, it should contain one
color channel (L) instead of 3, so the expected shape for pytorch tensor would be <code>(B, 1, H, W)</code>, <code>(B, H, W)</code>, <code>(1, H, W)</code>, <code>(H, W)</code>. And for numpy array would be for <code>(B, H, W, 1)</code>, <code>(B, H, W)</code>, <code>(H, W, 1)</code>, or <code>(H, W)</code>.`,name:"mask_image"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.padding_mask_crop",description:`<strong>padding_mask_crop</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The size of margin in the crop to be applied to the image and masking. If <code>None</code>, no crop is applied to
image and mask_image. If <code>padding_mask_crop</code> is not <code>None</code>, it will first find a rectangular region
with the same aspect ration of the image and contains all masked area, and then expand that area based
on <code>padding_mask_crop</code>. The image and mask_image will then be cropped based on the expanded area before
resizing to the original image size for inpainting. This is useful when the masked area is small while
the image is large and contain information irrelevant for inpainting, such as background.`,name:"padding_mask_crop"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Indicates extent to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code> is used as a
starting point and more noise is added the higher the <code>strength</code>. The number of denoising steps depends
on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the denoising
process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of 1
essentially ignores <code>image</code>.`,name:"strength"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference. This parameter is modulated by <code>strength</code>.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://huggingface.co/papers/2010.02502" rel="nofollow">DDIM</a> paper. Only
applies to the <code>~schedulers.DDIMScheduler</code>, and is ignored in other schedulers.`,name:"eta"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.ip_adapter_image",description:"<strong>ip_adapter_image</strong> &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.",name:"ip_adapter_image"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should
contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to <code>True</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_53/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_inpaint.py#L880",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> or <code>tuple</code></p>
`}}),ve=new B({props:{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.example",$$slots:{default:[fs]},$$scope:{ctx:N}}}),sn=new k({props:{title:"ORTStableDiffusionXLPipeline",local:"optimum.onnxruntime.ORTStableDiffusionXLPipeline",headingTag:"h3"}}),rn=new P({props:{name:"class optimum.onnxruntime.ORTStableDiffusionXLPipeline",anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline",parameters:[{name:"unet_session",val:": InferenceSession | None = None"},{name:"transformer_session",val:": InferenceSession | None = None"},{name:"vae_decoder_session",val:": InferenceSession | None = None"},{name:"vae_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_2_session",val:": InferenceSession | None = None"},{name:"text_encoder_3_session",val:": InferenceSession | None = None"},{name:"scheduler",val:": SchedulerMixin | None = None"},{name:"tokenizer",val:": CLIPTokenizer | None = None"},{name:"tokenizer_2",val:": CLIPTokenizer | None = None"},{name:"tokenizer_3",val:": CLIPTokenizer | None = None"},{name:"feature_extractor",val:": CLIPFeatureExtractor | None = None"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"add_watermarker",val:": bool | None = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_53/optimum/onnxruntime/modeling_diffusion.py#L933"}}),ln=new P({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": typing.List[int] = None"},{name:"sigmas",val:": typing.List[float] = None"},{name:"denoising_end",val:": typing.Optional[float] = None"},{name:"guidance_scale",val:": float = 5.0"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"guidance_rescale",val:": float = 0.0"},{name:"original_size",val:": typing.Optional[typing.Tuple[int, int]] = None"},{name:"crops_coords_top_left",val:": typing.Tuple[int, int] = (0, 0)"},{name:"target_size",val:": typing.Optional[typing.Tuple[int, int]] = None"},{name:"negative_original_size",val:": typing.Optional[typing.Tuple[int, int]] = None"},{name:"negative_crops_coords_top_left",val:": typing.Tuple[int, int] = (0, 0)"},{name:"negative_target_size",val:": typing.Optional[typing.Tuple[int, int]] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders`,name:"prompt_2"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.
Anything below 512 pixels won&#x2019;t work well for
<a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a>
and checkpoints that are not specifically fine-tuned on low resolutions.`,name:"height"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.
Anything below 512 pixels won&#x2019;t work well for
<a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a>
and checkpoints that are not specifically fine-tuned on low resolutions.`,name:"width"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.denoising_end",description:`<strong>denoising_end</strong> (<code>float</code>, <em>optional</em>) &#x2014;
When specified, determines the fraction (between 0.0 and 1.0) of the total denoising process to be
completed before it is intentionally prematurely terminated. As a result, the returned sample will
still retain a substantial amount of noise as determined by the discrete timesteps selected by the
scheduler. The denoising_end parameter should ideally be utilized when this pipeline forms a part of a
&#x201C;Mixture of Denoisers&#x201D; multi-pipeline setup, as elaborated in <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_xl#refining-the-image-output" rel="nofollow"><strong>Refining the Image
Output</strong></a>`,name:"denoising_end"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 5.0) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>guidance_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Guidance scale is enabled by setting
<code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to
the text <code>prompt</code>, usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://huggingface.co/papers/2010.02502" rel="nofollow">https://huggingface.co/papers/2010.02502</a>. Only
applies to <code>schedulers.DDIMScheduler</code>, will be ignored for others.`,name:"eta"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.ip_adapter_image",description:"<strong>ip_adapter_image</strong> &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.",name:"ip_adapter_image"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should
contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to <code>True</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>diffusers.pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> instead
of a plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"cross_attention_kwargs"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Guidance rescale factor proposed by <a href="https://huggingface.co/papers/2305.08891" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a> <code>guidance_scale</code> is defined as <code>&#x3C6;</code> in equation 16. of
<a href="https://huggingface.co/papers/2305.08891" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a>. Guidance rescale factor should fix overexposure when
using zero terminal SNR.`,name:"guidance_rescale"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.original_size",description:`<strong>original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
If <code>original_size</code> is not the same as <code>target_size</code> the image will appear to be down- or upsampled.
<code>original_size</code> defaults to <code>(height, width)</code> if not specified. Part of SDXL&#x2019;s micro-conditioning as
explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"original_size"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.crops_coords_top_left",description:`<strong>crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
<code>crops_coords_top_left</code> can be used to generate an image that appears to be &#x201C;cropped&#x201D; from the position
<code>crops_coords_top_left</code> downwards. Favorable, well-centered images are usually achieved by setting
<code>crops_coords_top_left</code> to (0, 0). Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"crops_coords_top_left"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.target_size",description:`<strong>target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
For most cases, <code>target_size</code> should be set to the desired height and width of the generated image. If
not specified it will default to <code>(height, width)</code>. Part of SDXL&#x2019;s micro-conditioning as explained in
section 2.2 of <a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"target_size"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.negative_original_size",description:`<strong>negative_original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
To negatively condition the generation process based on a specific image resolution. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_original_size"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.negative_crops_coords_top_left",description:`<strong>negative_crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
To negatively condition the generation process based on a specific crop coordinates. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_crops_coords_top_left"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.negative_target_size",description:`<strong>negative_target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
To negatively condition the generation process based on a target image resolution. It should be as same
as the <code>target_size</code> for most cases. Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_target_size"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_53/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl.py#L836",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>diffusers.pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> if <code>return_dict</code> is True, otherwise a
<code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>diffusers.pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> or <code>tuple</code></p>
`}}),Ie=new B({props:{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.example",$$slots:{default:[hs]},$$scope:{ctx:N}}}),pn=new k({props:{title:"ORTStableDiffusionXLImg2ImgPipeline",local:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline",headingTag:"h3"}}),mn=new P({props:{name:"class optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline",anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline",parameters:[{name:"unet_session",val:": InferenceSession | None = None"},{name:"transformer_session",val:": InferenceSession | None = None"},{name:"vae_decoder_session",val:": InferenceSession | None = None"},{name:"vae_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_2_session",val:": InferenceSession | None = None"},{name:"text_encoder_3_session",val:": InferenceSession | None = None"},{name:"scheduler",val:": SchedulerMixin | None = None"},{name:"tokenizer",val:": CLIPTokenizer | None = None"},{name:"tokenizer_2",val:": CLIPTokenizer | None = None"},{name:"tokenizer_3",val:": CLIPTokenizer | None = None"},{name:"feature_extractor",val:": CLIPFeatureExtractor | None = None"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"add_watermarker",val:": bool | None = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_53/optimum/onnxruntime/modeling_diffusion.py#L956"}}),dn=new P({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"strength",val:": float = 0.3"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": typing.List[int] = None"},{name:"sigmas",val:": typing.List[float] = None"},{name:"denoising_start",val:": typing.Optional[float] = None"},{name:"denoising_end",val:": typing.Optional[float] = None"},{name:"guidance_scale",val:": float = 5.0"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"guidance_rescale",val:": float = 0.0"},{name:"original_size",val:": typing.Tuple[int, int] = None"},{name:"crops_coords_top_left",val:": typing.Tuple[int, int] = (0, 0)"},{name:"target_size",val:": typing.Tuple[int, int] = None"},{name:"negative_original_size",val:": typing.Optional[typing.Tuple[int, int]] = None"},{name:"negative_crops_coords_top_left",val:": typing.Tuple[int, int] = (0, 0)"},{name:"negative_target_size",val:": typing.Optional[typing.Tuple[int, int]] = None"},{name:"aesthetic_score",val:": float = 6.0"},{name:"negative_aesthetic_score",val:": float = 2.5"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders`,name:"prompt_2"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code> or <code>PIL.Image.Image</code> or <code>np.ndarray</code> or <code>List[torch.Tensor]</code> or <code>List[PIL.Image.Image]</code> or <code>List[np.ndarray]</code>) &#x2014;
The image(s) to modify with the pipeline.`,name:"image"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.3) &#x2014;
Conceptually, indicates how much to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code>
will be used as a starting point, adding more noise to it the larger the <code>strength</code>. The number of
denoising steps depends on the amount of noise initially added. When <code>strength</code> is 1, added noise will
be maximum and the denoising process will run for the full number of iterations specified in
<code>num_inference_steps</code>. A value of 1, therefore, essentially ignores <code>image</code>. Note that in the case of
<code>denoising_start</code> being declared as an integer, the value of <code>strength</code> will be ignored.`,name:"strength"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.denoising_start",description:`<strong>denoising_start</strong> (<code>float</code>, <em>optional</em>) &#x2014;
When specified, indicates the fraction (between 0.0 and 1.0) of the total denoising process to be
bypassed before it is initiated. Consequently, the initial part of the denoising process is skipped and
it is assumed that the passed <code>image</code> is a partly denoised image. Note that when this is specified,
strength will be ignored. The <code>denoising_start</code> parameter is particularly beneficial when this pipeline
is integrated into a &#x201C;Mixture of Denoisers&#x201D; multi-pipeline setup, as detailed in <a href="https://huggingface.co/docs/diffusers/using-diffusers/sdxl#refine-image-quality" rel="nofollow"><strong>Refine Image
Quality</strong></a>.`,name:"denoising_start"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.denoising_end",description:`<strong>denoising_end</strong> (<code>float</code>, <em>optional</em>) &#x2014;
When specified, determines the fraction (between 0.0 and 1.0) of the total denoising process to be
completed before it is intentionally prematurely terminated. As a result, the returned sample will
still retain a substantial amount of noise (ca. final 20% of timesteps still needed) and should be
denoised by a successor pipeline that has <code>denoising_start</code> set to 0.8 so that it only denoises the
final 20% of the scheduler. The denoising_end parameter should ideally be utilized when this pipeline
forms a part of a &#x201C;Mixture of Denoisers&#x201D; multi-pipeline setup, as elaborated in <a href="https://huggingface.co/docs/diffusers/using-diffusers/sdxl#refine-image-quality" rel="nofollow"><strong>Refine Image
Quality</strong></a>.`,name:"denoising_end"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>guidance_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Guidance scale is enabled by setting
<code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to
the text <code>prompt</code>, usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://huggingface.co/papers/2010.02502" rel="nofollow">https://huggingface.co/papers/2010.02502</a>. Only
applies to <code>schedulers.DDIMScheduler</code>, will be ignored for others.`,name:"eta"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.ip_adapter_image",description:"<strong>ip_adapter_image</strong> &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.",name:"ip_adapter_image"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should
contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to <code>True</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>diffusers.pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"cross_attention_kwargs"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Guidance rescale factor proposed by <a href="https://huggingface.co/papers/2305.08891" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a> <code>guidance_scale</code> is defined as <code>&#x3C6;</code> in equation 16. of
<a href="https://huggingface.co/papers/2305.08891" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a>. Guidance rescale factor should fix overexposure when
using zero terminal SNR.`,name:"guidance_rescale"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.original_size",description:`<strong>original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
If <code>original_size</code> is not the same as <code>target_size</code> the image will appear to be down- or upsampled.
<code>original_size</code> defaults to <code>(height, width)</code> if not specified. Part of SDXL&#x2019;s micro-conditioning as
explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"original_size"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.crops_coords_top_left",description:`<strong>crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
<code>crops_coords_top_left</code> can be used to generate an image that appears to be &#x201C;cropped&#x201D; from the position
<code>crops_coords_top_left</code> downwards. Favorable, well-centered images are usually achieved by setting
<code>crops_coords_top_left</code> to (0, 0). Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"crops_coords_top_left"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.target_size",description:`<strong>target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
For most cases, <code>target_size</code> should be set to the desired height and width of the generated image. If
not specified it will default to <code>(height, width)</code>. Part of SDXL&#x2019;s micro-conditioning as explained in
section 2.2 of <a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"target_size"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.negative_original_size",description:`<strong>negative_original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
To negatively condition the generation process based on a specific image resolution. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_original_size"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.negative_crops_coords_top_left",description:`<strong>negative_crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
To negatively condition the generation process based on a specific crop coordinates. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_crops_coords_top_left"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.negative_target_size",description:`<strong>negative_target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
To negatively condition the generation process based on a target image resolution. It should be as same
as the <code>target_size</code> for most cases. Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_target_size"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.aesthetic_score",description:`<strong>aesthetic_score</strong> (<code>float</code>, <em>optional</em>, defaults to 6.0) &#x2014;
Used to simulate an aesthetic score of the generated image by influencing the positive text condition.
Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"aesthetic_score"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.negative_aesthetic_score",description:`<strong>negative_aesthetic_score</strong> (<code>float</code>, <em>optional</em>, defaults to 2.5) &#x2014;
Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. Can be used to
simulate an aesthetic score of the generated image by influencing the negative text condition.`,name:"negative_aesthetic_score"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_53/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_img2img.py#L986",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>diffusers.pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> if <code>return_dict</code> is True, otherwise a
\`tuple. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>diffusers.pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> or <code>tuple</code></p>
`}}),we=new B({props:{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.example",$$slots:{default:[bs]},$$scope:{ctx:N}}}),cn=new k({props:{title:"ORTStableDiffusionXLInpaintPipeline",local:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline",headingTag:"h3"}}),gn=new P({props:{name:"class optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline",anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline",parameters:[{name:"unet_session",val:": InferenceSession | None = None"},{name:"transformer_session",val:": InferenceSession | None = None"},{name:"vae_decoder_session",val:": InferenceSession | None = None"},{name:"vae_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_2_session",val:": InferenceSession | None = None"},{name:"text_encoder_3_session",val:": InferenceSession | None = None"},{name:"scheduler",val:": SchedulerMixin | None = None"},{name:"tokenizer",val:": CLIPTokenizer | None = None"},{name:"tokenizer_2",val:": CLIPTokenizer | None = None"},{name:"tokenizer_3",val:": CLIPTokenizer | None = None"},{name:"feature_extractor",val:": CLIPFeatureExtractor | None = None"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"add_watermarker",val:": bool | None = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_53/optimum/onnxruntime/modeling_diffusion.py#L994"}}),un=new P({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"mask_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"masked_image_latents",val:": Tensor = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"padding_mask_crop",val:": typing.Optional[int] = None"},{name:"strength",val:": float = 0.9999"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": typing.List[int] = None"},{name:"sigmas",val:": typing.List[float] = None"},{name:"denoising_start",val:": typing.Optional[float] = None"},{name:"denoising_end",val:": typing.Optional[float] = None"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"guidance_rescale",val:": float = 0.0"},{name:"original_size",val:": typing.Tuple[int, int] = None"},{name:"crops_coords_top_left",val:": typing.Tuple[int, int] = (0, 0)"},{name:"target_size",val:": typing.Tuple[int, int] = None"},{name:"negative_original_size",val:": typing.Optional[typing.Tuple[int, int]] = None"},{name:"negative_crops_coords_top_left",val:": typing.Tuple[int, int] = (0, 0)"},{name:"negative_target_size",val:": typing.Optional[typing.Tuple[int, int]] = None"},{name:"aesthetic_score",val:": float = 6.0"},{name:"negative_aesthetic_score",val:": float = 2.5"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders`,name:"prompt_2"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.image",description:`<strong>image</strong> (<code>PIL.Image.Image</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch which will be inpainted, <em>i.e.</em> parts of the image will
be masked out with <code>mask_image</code> and repainted according to <code>prompt</code>.`,name:"image"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>PIL.Image.Image</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch, to mask <code>image</code>. White pixels in the mask will be
repainted, while black pixels will be preserved. If <code>mask_image</code> is a PIL image, it will be converted
to a single channel (luminance) before use. If it&#x2019;s a tensor, it should contain one color channel (L)
instead of 3, so the expected shape would be <code>(B, H, W, 1)</code>.`,name:"mask_image"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.
Anything below 512 pixels won&#x2019;t work well for
<a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a>
and checkpoints that are not specifically fine-tuned on low resolutions.`,name:"height"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.
Anything below 512 pixels won&#x2019;t work well for
<a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a>
and checkpoints that are not specifically fine-tuned on low resolutions.`,name:"width"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.padding_mask_crop",description:`<strong>padding_mask_crop</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The size of margin in the crop to be applied to the image and masking. If <code>None</code>, no crop is applied to
image and mask_image. If <code>padding_mask_crop</code> is not <code>None</code>, it will first find a rectangular region
with the same aspect ration of the image and contains all masked area, and then expand that area based
on <code>padding_mask_crop</code>. The image and mask_image will then be cropped based on the expanded area before
resizing to the original image size for inpainting. This is useful when the masked area is small while
the image is large and contain information irrelevant for inpainting, such as background.`,name:"padding_mask_crop"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.9999) &#x2014;
Conceptually, indicates how much to transform the masked portion of the reference <code>image</code>. Must be
between 0 and 1. <code>image</code> will be used as a starting point, adding more noise to it the larger the
<code>strength</code>. The number of denoising steps depends on the amount of noise initially added. When
<code>strength</code> is 1, added noise will be maximum and the denoising process will run for the full number of
iterations specified in <code>num_inference_steps</code>. A value of 1, therefore, essentially ignores the masked
portion of the reference <code>image</code>. Note that in the case of <code>denoising_start</code> being declared as an
integer, the value of <code>strength</code> will be ignored.`,name:"strength"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.denoising_start",description:`<strong>denoising_start</strong> (<code>float</code>, <em>optional</em>) &#x2014;
When specified, indicates the fraction (between 0.0 and 1.0) of the total denoising process to be
bypassed before it is initiated. Consequently, the initial part of the denoising process is skipped and
it is assumed that the passed <code>image</code> is a partly denoised image. Note that when this is specified,
strength will be ignored. The <code>denoising_start</code> parameter is particularly beneficial when this pipeline
is integrated into a &#x201C;Mixture of Denoisers&#x201D; multi-pipeline setup, as detailed in <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_xl#refining-the-image-output" rel="nofollow"><strong>Refining the Image
Output</strong></a>.`,name:"denoising_start"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.denoising_end",description:`<strong>denoising_end</strong> (<code>float</code>, <em>optional</em>) &#x2014;
When specified, determines the fraction (between 0.0 and 1.0) of the total denoising process to be
completed before it is intentionally prematurely terminated. As a result, the returned sample will
still retain a substantial amount of noise (ca. final 20% of timesteps still needed) and should be
denoised by a successor pipeline that has <code>denoising_start</code> set to 0.8 so that it only denoises the
final 20% of the scheduler. The denoising_end parameter should ideally be utilized when this pipeline
forms a part of a &#x201C;Mixture of Denoisers&#x201D; multi-pipeline setup, as elaborated in <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_xl#refining-the-image-output" rel="nofollow"><strong>Refining the Image
Output</strong></a>.`,name:"denoising_end"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>guidance_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Guidance scale is enabled by setting
<code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to
the text <code>prompt</code>, usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.ip_adapter_image",description:"<strong>ip_adapter_image</strong> &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.",name:"ip_adapter_image"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should
contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to <code>True</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://huggingface.co/papers/2010.02502" rel="nofollow">https://huggingface.co/papers/2010.02502</a>. Only
applies to <code>schedulers.DDIMScheduler</code>, will be ignored for others.`,name:"eta"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"cross_attention_kwargs"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.original_size",description:`<strong>original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
If <code>original_size</code> is not the same as <code>target_size</code> the image will appear to be down- or upsampled.
<code>original_size</code> defaults to <code>(height, width)</code> if not specified. Part of SDXL&#x2019;s micro-conditioning as
explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"original_size"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.crops_coords_top_left",description:`<strong>crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
<code>crops_coords_top_left</code> can be used to generate an image that appears to be &#x201C;cropped&#x201D; from the position
<code>crops_coords_top_left</code> downwards. Favorable, well-centered images are usually achieved by setting
<code>crops_coords_top_left</code> to (0, 0). Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"crops_coords_top_left"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.target_size",description:`<strong>target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
For most cases, <code>target_size</code> should be set to the desired height and width of the generated image. If
not specified it will default to <code>(height, width)</code>. Part of SDXL&#x2019;s micro-conditioning as explained in
section 2.2 of <a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"target_size"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.negative_original_size",description:`<strong>negative_original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
To negatively condition the generation process based on a specific image resolution. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_original_size"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.negative_crops_coords_top_left",description:`<strong>negative_crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
To negatively condition the generation process based on a specific crop coordinates. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_crops_coords_top_left"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.negative_target_size",description:`<strong>negative_target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
To negatively condition the generation process based on a target image resolution. It should be as same
as the <code>target_size</code> for most cases. Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_target_size"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.aesthetic_score",description:`<strong>aesthetic_score</strong> (<code>float</code>, <em>optional</em>, defaults to 6.0) &#x2014;
Used to simulate an aesthetic score of the generated image by influencing the positive text condition.
Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"aesthetic_score"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.negative_aesthetic_score",description:`<strong>negative_aesthetic_score</strong> (<code>float</code>, <em>optional</em>, defaults to 2.5) &#x2014;
Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. Can be used to
simulate an aesthetic score of the generated image by influencing the negative text condition.`,name:"negative_aesthetic_score"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_53/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_inpaint.py#L1091",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>diffusers.pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> if <code>return_dict</code> is True, otherwise a
<code>tuple. </code>tuple. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>diffusers.pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> or <code>tuple</code></p>
`}}),Pe=new B({props:{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.example",$$slots:{default:[ys]},$$scope:{ctx:N}}}),_n=new k({props:{title:"ORTStableDiffusionXLImg2ImgPipeline",local:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline",headingTag:"h3"}}),fn=new P({props:{name:"class optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline",anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline",parameters:[{name:"unet_session",val:": InferenceSession | None = None"},{name:"transformer_session",val:": InferenceSession | None = None"},{name:"vae_decoder_session",val:": InferenceSession | None = None"},{name:"vae_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_2_session",val:": InferenceSession | None = None"},{name:"text_encoder_3_session",val:": InferenceSession | None = None"},{name:"scheduler",val:": SchedulerMixin | None = None"},{name:"tokenizer",val:": CLIPTokenizer | None = None"},{name:"tokenizer_2",val:": CLIPTokenizer | None = None"},{name:"tokenizer_3",val:": CLIPTokenizer | None = None"},{name:"feature_extractor",val:": CLIPFeatureExtractor | None = None"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"add_watermarker",val:": bool | None = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_53/optimum/onnxruntime/modeling_diffusion.py#L956"}}),hn=new P({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"strength",val:": float = 0.3"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": typing.List[int] = None"},{name:"sigmas",val:": typing.List[float] = None"},{name:"denoising_start",val:": typing.Optional[float] = None"},{name:"denoising_end",val:": typing.Optional[float] = None"},{name:"guidance_scale",val:": float = 5.0"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"guidance_rescale",val:": float = 0.0"},{name:"original_size",val:": typing.Tuple[int, int] = None"},{name:"crops_coords_top_left",val:": typing.Tuple[int, int] = (0, 0)"},{name:"target_size",val:": typing.Tuple[int, int] = None"},{name:"negative_original_size",val:": typing.Optional[typing.Tuple[int, int]] = None"},{name:"negative_crops_coords_top_left",val:": typing.Tuple[int, int] = (0, 0)"},{name:"negative_target_size",val:": typing.Optional[typing.Tuple[int, int]] = None"},{name:"aesthetic_score",val:": float = 6.0"},{name:"negative_aesthetic_score",val:": float = 2.5"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders`,name:"prompt_2"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code> or <code>PIL.Image.Image</code> or <code>np.ndarray</code> or <code>List[torch.Tensor]</code> or <code>List[PIL.Image.Image]</code> or <code>List[np.ndarray]</code>) &#x2014;
The image(s) to modify with the pipeline.`,name:"image"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.3) &#x2014;
Conceptually, indicates how much to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code>
will be used as a starting point, adding more noise to it the larger the <code>strength</code>. The number of
denoising steps depends on the amount of noise initially added. When <code>strength</code> is 1, added noise will
be maximum and the denoising process will run for the full number of iterations specified in
<code>num_inference_steps</code>. A value of 1, therefore, essentially ignores <code>image</code>. Note that in the case of
<code>denoising_start</code> being declared as an integer, the value of <code>strength</code> will be ignored.`,name:"strength"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.denoising_start",description:`<strong>denoising_start</strong> (<code>float</code>, <em>optional</em>) &#x2014;
When specified, indicates the fraction (between 0.0 and 1.0) of the total denoising process to be
bypassed before it is initiated. Consequently, the initial part of the denoising process is skipped and
it is assumed that the passed <code>image</code> is a partly denoised image. Note that when this is specified,
strength will be ignored. The <code>denoising_start</code> parameter is particularly beneficial when this pipeline
is integrated into a &#x201C;Mixture of Denoisers&#x201D; multi-pipeline setup, as detailed in <a href="https://huggingface.co/docs/diffusers/using-diffusers/sdxl#refine-image-quality" rel="nofollow"><strong>Refine Image
Quality</strong></a>.`,name:"denoising_start"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.denoising_end",description:`<strong>denoising_end</strong> (<code>float</code>, <em>optional</em>) &#x2014;
When specified, determines the fraction (between 0.0 and 1.0) of the total denoising process to be
completed before it is intentionally prematurely terminated. As a result, the returned sample will
still retain a substantial amount of noise (ca. final 20% of timesteps still needed) and should be
denoised by a successor pipeline that has <code>denoising_start</code> set to 0.8 so that it only denoises the
final 20% of the scheduler. The denoising_end parameter should ideally be utilized when this pipeline
forms a part of a &#x201C;Mixture of Denoisers&#x201D; multi-pipeline setup, as elaborated in <a href="https://huggingface.co/docs/diffusers/using-diffusers/sdxl#refine-image-quality" rel="nofollow"><strong>Refine Image
Quality</strong></a>.`,name:"denoising_end"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>guidance_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Guidance scale is enabled by setting
<code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to
the text <code>prompt</code>, usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://huggingface.co/papers/2010.02502" rel="nofollow">https://huggingface.co/papers/2010.02502</a>. Only
applies to <code>schedulers.DDIMScheduler</code>, will be ignored for others.`,name:"eta"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.ip_adapter_image",description:"<strong>ip_adapter_image</strong> &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.",name:"ip_adapter_image"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should
contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to <code>True</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>diffusers.pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"cross_attention_kwargs"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Guidance rescale factor proposed by <a href="https://huggingface.co/papers/2305.08891" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a> <code>guidance_scale</code> is defined as <code>&#x3C6;</code> in equation 16. of
<a href="https://huggingface.co/papers/2305.08891" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a>. Guidance rescale factor should fix overexposure when
using zero terminal SNR.`,name:"guidance_rescale"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.original_size",description:`<strong>original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
If <code>original_size</code> is not the same as <code>target_size</code> the image will appear to be down- or upsampled.
<code>original_size</code> defaults to <code>(height, width)</code> if not specified. Part of SDXL&#x2019;s micro-conditioning as
explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"original_size"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.crops_coords_top_left",description:`<strong>crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
<code>crops_coords_top_left</code> can be used to generate an image that appears to be &#x201C;cropped&#x201D; from the position
<code>crops_coords_top_left</code> downwards. Favorable, well-centered images are usually achieved by setting
<code>crops_coords_top_left</code> to (0, 0). Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"crops_coords_top_left"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.target_size",description:`<strong>target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
For most cases, <code>target_size</code> should be set to the desired height and width of the generated image. If
not specified it will default to <code>(height, width)</code>. Part of SDXL&#x2019;s micro-conditioning as explained in
section 2.2 of <a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"target_size"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.negative_original_size",description:`<strong>negative_original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
To negatively condition the generation process based on a specific image resolution. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_original_size"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.negative_crops_coords_top_left",description:`<strong>negative_crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
To negatively condition the generation process based on a specific crop coordinates. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_crops_coords_top_left"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.negative_target_size",description:`<strong>negative_target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
To negatively condition the generation process based on a target image resolution. It should be as same
as the <code>target_size</code> for most cases. Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_target_size"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.aesthetic_score",description:`<strong>aesthetic_score</strong> (<code>float</code>, <em>optional</em>, defaults to 6.0) &#x2014;
Used to simulate an aesthetic score of the generated image by influencing the positive text condition.
Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"aesthetic_score"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.negative_aesthetic_score",description:`<strong>negative_aesthetic_score</strong> (<code>float</code>, <em>optional</em>, defaults to 2.5) &#x2014;
Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. Can be used to
simulate an aesthetic score of the generated image by influencing the negative text condition.`,name:"negative_aesthetic_score"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_53/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_img2img.py#L986",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>diffusers.pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> if <code>return_dict</code> is True, otherwise a
\`tuple. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>diffusers.pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> or <code>tuple</code></p>
`}}),Ne=new B({props:{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.example",$$slots:{default:[xs]},$$scope:{ctx:N}}}),bn=new k({props:{title:"ORTLatentConsistencyModelPipeline",local:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline",headingTag:"h3"}}),yn=new P({props:{name:"class optimum.onnxruntime.ORTLatentConsistencyModelPipeline",anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline",parameters:[{name:"unet_session",val:": InferenceSession | None = None"},{name:"transformer_session",val:": InferenceSession | None = None"},{name:"vae_decoder_session",val:": InferenceSession | None = None"},{name:"vae_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_2_session",val:": InferenceSession | None = None"},{name:"text_encoder_3_session",val:": InferenceSession | None = None"},{name:"scheduler",val:": SchedulerMixin | None = None"},{name:"tokenizer",val:": CLIPTokenizer | None = None"},{name:"tokenizer_2",val:": CLIPTokenizer | None = None"},{name:"tokenizer_3",val:": CLIPTokenizer | None = None"},{name:"feature_extractor",val:": CLIPFeatureExtractor | None = None"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"add_watermarker",val:": bool | None = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_53/optimum/onnxruntime/modeling_diffusion.py#L1032"}}),xn=new P({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 4"},{name:"original_inference_steps",val:": int = None"},{name:"timesteps",val:": typing.List[int] = None"},{name:"guidance_scale",val:": float = 8.5"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.original_inference_steps",description:`<strong>original_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The original number of inference steps use to generate a linearly-spaced timestep schedule, from which
we will draw <code>num_inference_steps</code> evenly spaced timesteps from as our final timestep schedule,
following the Skipping-Step method in the paper (see Section 4.3). If not set this will default to the
scheduler&#x2019;s <code>original_inference_steps</code> attribute.`,name:"original_inference_steps"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process. If not defined, equal spaced <code>num_inference_steps</code>
timesteps on the original LCM training/distillation timestep schedule are used. Must be in descending
order.`,name:"timesteps"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.
Note that the original latent consistency models paper uses a different CFG formulation where the
guidance scales are decreased by 1 (so in the paper formulation CFG is enabled when <code>guidance_scale &gt; 0</code>).`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.ip_adapter_image",description:`<strong>ip_adapter_image</strong> &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>):
Optional image input to work with IP Adapters.`,name:"ip_adapter_image"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should
contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to <code>True</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_53/diffusers/pipelines/latent_consistency_models/pipeline_latent_consistency_text2img.py#L640",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> or <code>tuple</code></p>
`}}),ke=new B({props:{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.example",$$slots:{default:[Ts]},$$scope:{ctx:N}}}),Tn=new k({props:{title:"ORTLatentConsistencyModelImg2ImgPipeline",local:"optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline",headingTag:"h3"}}),vn=new P({props:{name:"class optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline",anchor:"optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline",parameters:[{name:"unet_session",val:": InferenceSession | None = None"},{name:"transformer_session",val:": InferenceSession | None = None"},{name:"vae_decoder_session",val:": InferenceSession | None = None"},{name:"vae_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_2_session",val:": InferenceSession | None = None"},{name:"text_encoder_3_session",val:": InferenceSession | None = None"},{name:"scheduler",val:": SchedulerMixin | None = None"},{name:"tokenizer",val:": CLIPTokenizer | None = None"},{name:"tokenizer_2",val:": CLIPTokenizer | None = None"},{name:"tokenizer_3",val:": CLIPTokenizer | None = None"},{name:"feature_extractor",val:": CLIPFeatureExtractor | None = None"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"add_watermarker",val:": bool | None = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_53/optimum/onnxruntime/modeling_diffusion.py#L1043"}}),In=new P({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"num_inference_steps",val:": int = 4"},{name:"strength",val:": float = 0.8"},{name:"original_inference_steps",val:": int = None"},{name:"timesteps",val:": typing.List[int] = None"},{name:"guidance_scale",val:": float = 8.5"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline.__call__.original_inference_steps",description:`<strong>original_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The original number of inference steps use to generate a linearly-spaced timestep schedule, from which
we will draw <code>num_inference_steps</code> evenly spaced timesteps from as our final timestep schedule,
following the Skipping-Step method in the paper (see Section 4.3). If not set this will default to the
scheduler&#x2019;s <code>original_inference_steps</code> attribute.`,name:"original_inference_steps"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process. If not defined, equal spaced <code>num_inference_steps</code>
timesteps on the original LCM training/distillation timestep schedule are used. Must be in descending
order.`,name:"timesteps"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.
Note that the original latent consistency models paper uses a different CFG formulation where the
guidance scales are decreased by 1 (so in the paper formulation CFG is enabled when <code>guidance_scale &gt; 0</code>).`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline.__call__.ip_adapter_image",description:`<strong>ip_adapter_image</strong> &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>):
Optional image input to work with IP Adapters.`,name:"ip_adapter_image"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should
contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to <code>True</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_53/diffusers/pipelines/latent_consistency_models/pipeline_latent_consistency_img2img.py#L709",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> or <code>tuple</code></p>
`}}),Le=new B({props:{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline.__call__.example",$$slots:{default:[vs]},$$scope:{ctx:N}}}),wn=new k({props:{title:"ORTStableDiffusion3Pipeline",local:"optimum.onnxruntime.ORTStableDiffusion3Pipeline",headingTag:"h3"}}),Pn=new P({props:{name:"class optimum.onnxruntime.ORTStableDiffusion3Pipeline",anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline",parameters:[{name:"unet_session",val:": InferenceSession | None = None"},{name:"transformer_session",val:": InferenceSession | None = None"},{name:"vae_decoder_session",val:": InferenceSession | None = None"},{name:"vae_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_2_session",val:": InferenceSession | None = None"},{name:"text_encoder_3_session",val:": InferenceSession | None = None"},{name:"scheduler",val:": SchedulerMixin | None = None"},{name:"tokenizer",val:": CLIPTokenizer | None = None"},{name:"tokenizer_2",val:": CLIPTokenizer | None = None"},{name:"tokenizer_3",val:": CLIPTokenizer | None = None"},{name:"feature_extractor",val:": CLIPFeatureExtractor | None = None"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"add_watermarker",val:": bool | None = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_53/optimum/onnxruntime/modeling_diffusion.py#L1066"}}),Nn=new P({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"prompt_3",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 28"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": float = 7.0"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_3",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"joint_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 256"},{name:"skip_guidance_layers",val:": typing.List[int] = None"},{name:"skip_layer_guidance_scale",val:": float = 2.8"},{name:"skip_layer_guidance_stop",val:": float = 0.2"},{name:"skip_layer_guidance_start",val:": float = 0.01"},{name:"mu",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
will be used instead`,name:"prompt_2"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.prompt_3",description:`<strong>prompt_3</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_3</code> and <code>text_encoder_3</code>. If not defined, <code>prompt</code> is
will be used instead`,name:"prompt_3"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.0) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>guidance_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Guidance scale is enabled by setting
<code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to
the text <code>prompt</code>, usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used instead`,name:"negative_prompt_2"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.negative_prompt_3",description:`<strong>negative_prompt_3</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_3</code> and
<code>text_encoder_3</code>. If not defined, <code>negative_prompt</code> is used instead`,name:"negative_prompt_3"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.ip_adapter_image",description:`<strong>ip_adapter_image</strong> (<code>PipelineImageInput</code>, <em>optional</em>) &#x2014;
Optional image input to work with IP Adapters.`,name:"ip_adapter_image"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. Should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to
<code>True</code>. If not provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>diffusers.pipelines.stable_diffusion_3.StableDiffusion3PipelineOutput</code> instead of
a plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.joint_attention_kwargs",description:`<strong>joint_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"joint_attention_kwargs"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 256) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.skip_guidance_layers",description:`<strong>skip_guidance_layers</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
A list of integers that specify layers to skip during guidance. If not provided, all layers will be
used for guidance. If provided, the guidance will only be applied to the layers specified in the list.
Recommended value by StabiltyAI for Stable Diffusion 3.5 Medium is [7, 8, 9].`,name:"skip_guidance_layers"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.skip_layer_guidance_scale",description:`<strong>skip_layer_guidance_scale</strong> (<code>int</code>, <em>optional</em>) &#x2014; The scale of the guidance for the layers specified in
<code>skip_guidance_layers</code>. The guidance will be applied to the layers specified in <code>skip_guidance_layers</code>
with a scale of <code>skip_layer_guidance_scale</code>. The guidance will be applied to the rest of the layers
with a scale of <code>1</code>.`,name:"skip_layer_guidance_scale"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.skip_layer_guidance_stop",description:`<strong>skip_layer_guidance_stop</strong> (<code>int</code>, <em>optional</em>) &#x2014; The step at which the guidance for the layers specified in
<code>skip_guidance_layers</code> will stop. The guidance will be applied to the layers specified in
<code>skip_guidance_layers</code> until the fraction specified in <code>skip_layer_guidance_stop</code>. Recommended value by
StabiltyAI for Stable Diffusion 3.5 Medium is 0.2.`,name:"skip_layer_guidance_stop"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.skip_layer_guidance_start",description:`<strong>skip_layer_guidance_start</strong> (<code>int</code>, <em>optional</em>) &#x2014; The step at which the guidance for the layers specified in
<code>skip_guidance_layers</code> will start. The guidance will be applied to the layers specified in
<code>skip_guidance_layers</code> from the fraction specified in <code>skip_layer_guidance_start</code>. Recommended value by
StabiltyAI for Stable Diffusion 3.5 Medium is 0.01.`,name:"skip_layer_guidance_start"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.mu",description:"<strong>mu</strong> (<code>float</code>, <em>optional</em>) &#x2014; <code>mu</code> value used for <code>dynamic_shifting</code>.",name:"mu"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_53/diffusers/pipelines/stable_diffusion_3/pipeline_stable_diffusion_3.py#L772",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>diffusers.pipelines.stable_diffusion_3.StableDiffusion3PipelineOutput</code> if <code>return_dict</code> is True, otherwise a
<code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>diffusers.pipelines.stable_diffusion_3.StableDiffusion3PipelineOutput</code> or <code>tuple</code></p>
`}}),Me=new B({props:{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.example",$$slots:{default:[Is]},$$scope:{ctx:N}}}),kn=new k({props:{title:"ORTStableDiffusion3Img2ImgPipeline",local:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline",headingTag:"h3"}}),Ln=new P({props:{name:"class optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline",anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline",parameters:[{name:"unet_session",val:": InferenceSession | None = None"},{name:"transformer_session",val:": InferenceSession | None = None"},{name:"vae_decoder_session",val:": InferenceSession | None = None"},{name:"vae_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_2_session",val:": InferenceSession | None = None"},{name:"text_encoder_3_session",val:": InferenceSession | None = None"},{name:"scheduler",val:": SchedulerMixin | None = None"},{name:"tokenizer",val:": CLIPTokenizer | None = None"},{name:"tokenizer_2",val:": CLIPTokenizer | None = None"},{name:"tokenizer_3",val:": CLIPTokenizer | None = None"},{name:"feature_extractor",val:": CLIPFeatureExtractor | None = None"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"add_watermarker",val:": bool | None = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_53/optimum/onnxruntime/modeling_diffusion.py#L1074"}}),Mn=new P({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"prompt_3",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"strength",val:": float = 0.6"},{name:"num_inference_steps",val:": int = 50"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": float = 7.0"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_3",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": bool = True"},{name:"joint_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 256"},{name:"mu",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
will be used instead`,name:"prompt_2"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.prompt_3",description:`<strong>prompt_3</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_3</code> and <code>text_encoder_3</code>. If not defined, <code>prompt</code> is
will be used instead`,name:"prompt_3"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.transformer.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.transformer.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.0) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>guidance_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Guidance scale is enabled by setting
<code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to
the text <code>prompt</code>, usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used instead`,name:"negative_prompt_2"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.negative_prompt_3",description:`<strong>negative_prompt_3</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_3</code> and
<code>text_encoder_3</code>. If not defined, <code>negative_prompt</code> is used instead`,name:"negative_prompt_3"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.ip_adapter_image",description:`<strong>ip_adapter_image</strong> (<code>PipelineImageInput</code>, <em>optional</em>) &#x2014;
Optional image input to work with IP Adapters.`,name:"ip_adapter_image"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. Should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to
<code>True</code>. If not provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>diffusers.pipelines.stable_diffusion_3.StableDiffusion3PipelineOutput</code> instead of
a plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.joint_attention_kwargs",description:`<strong>joint_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"joint_attention_kwargs"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 256) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.mu",description:"<strong>mu</strong> (<code>float</code>, <em>optional</em>) &#x2014; <code>mu</code> value used for <code>dynamic_shifting</code>.",name:"mu"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_53/diffusers/pipelines/stable_diffusion_3/pipeline_stable_diffusion_3_img2img.py#L829",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>diffusers.pipelines.stable_diffusion_3.StableDiffusion3PipelineOutput</code> if <code>return_dict</code> is True, otherwise a
<code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>diffusers.pipelines.stable_diffusion_3.StableDiffusion3PipelineOutput</code> or <code>tuple</code></p>
`}}),Se=new B({props:{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.example",$$slots:{default:[ws]},$$scope:{ctx:N}}}),Sn=new k({props:{title:"ORTStableDiffusion3InpaintPipeline",local:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline",headingTag:"h3"}}),Rn=new P({props:{name:"class optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline",anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline",parameters:[{name:"unet_session",val:": InferenceSession | None = None"},{name:"transformer_session",val:": InferenceSession | None = None"},{name:"vae_decoder_session",val:": InferenceSession | None = None"},{name:"vae_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_2_session",val:": InferenceSession | None = None"},{name:"text_encoder_3_session",val:": InferenceSession | None = None"},{name:"scheduler",val:": SchedulerMixin | None = None"},{name:"tokenizer",val:": CLIPTokenizer | None = None"},{name:"tokenizer_2",val:": CLIPTokenizer | None = None"},{name:"tokenizer_3",val:": CLIPTokenizer | None = None"},{name:"feature_extractor",val:": CLIPFeatureExtractor | None = None"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"add_watermarker",val:": bool | None = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_53/optimum/onnxruntime/modeling_diffusion.py#L1093"}}),On=new P({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"prompt_3",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"mask_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"masked_image_latents",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"height",val:": int = None"},{name:"width",val:": int = None"},{name:"padding_mask_crop",val:": typing.Optional[int] = None"},{name:"strength",val:": float = 0.6"},{name:"num_inference_steps",val:": int = 50"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": float = 7.0"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_3",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"joint_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 256"},{name:"mu",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
will be used instead`,name:"prompt_2"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.prompt_3",description:`<strong>prompt_3</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_3</code> and <code>text_encoder_3</code>. If not defined, <code>prompt</code> is
will be used instead`,name:"prompt_3"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to be used as the starting point. For both
numpy array and pytorch tensor, the expected value range is between <code>[0, 1]</code> If it&#x2019;s a tensor or a list
or tensors, the expected shape should be <code>(B, C, H, W)</code> or <code>(C, H, W)</code>. If it is a numpy array or a
list of arrays, the expected shape should be <code>(B, H, W, C)</code> or <code>(H, W, C)</code> It can also accept image
latents as <code>image</code>, but if passing latents directly it is not encoded again.`,name:"image"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to mask <code>image</code>. White pixels in the mask
are repainted while black pixels are preserved. If <code>mask_image</code> is a PIL image, it is converted to a
single channel (luminance) before use. If it&#x2019;s a numpy array or pytorch tensor, it should contain one
color channel (L) instead of 3, so the expected shape for pytorch tensor would be <code>(B, 1, H, W)</code>, <code>(B, H, W)</code>, <code>(1, H, W)</code>, <code>(H, W)</code>. And for numpy array would be for <code>(B, H, W, 1)</code>, <code>(B, H, W)</code>, <code>(H, W, 1)</code>, or <code>(H, W)</code>.`,name:"mask_image"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.mask_image_latent",description:`<strong>mask_image_latent</strong> (<code>torch.Tensor</code>, <code>List[torch.Tensor]</code>) &#x2014;
<code>Tensor</code> representing an image batch to mask <code>image</code> generated by VAE. If not provided, the mask
latents tensor will ge generated by <code>mask_image</code>.`,name:"mask_image_latent"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.transformer.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.transformer.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.padding_mask_crop",description:`<strong>padding_mask_crop</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The size of margin in the crop to be applied to the image and masking. If <code>None</code>, no crop is applied to
image and mask_image. If <code>padding_mask_crop</code> is not <code>None</code>, it will first find a rectangular region
with the same aspect ration of the image and contains all masked area, and then expand that area based
on <code>padding_mask_crop</code>. The image and mask_image will then be cropped based on the expanded area before
resizing to the original image size for inpainting. This is useful when the masked area is small while
the image is large and contain information irrelevant for inpainting, such as background.`,name:"padding_mask_crop"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Indicates extent to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code> is used as a
starting point and more noise is added the higher the <code>strength</code>. The number of denoising steps depends
on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the denoising
process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of 1
essentially ignores <code>image</code>.`,name:"strength"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.0) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>guidance_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Guidance scale is enabled by setting
<code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to
the text <code>prompt</code>, usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used instead`,name:"negative_prompt_2"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.negative_prompt_3",description:`<strong>negative_prompt_3</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_3</code> and
<code>text_encoder_3</code>. If not defined, <code>negative_prompt</code> is used instead`,name:"negative_prompt_3"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.ip_adapter_image",description:`<strong>ip_adapter_image</strong> (<code>PipelineImageInput</code>, <em>optional</em>) &#x2014;
Optional image input to work with IP Adapters.`,name:"ip_adapter_image"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. Should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to
<code>True</code>. If not provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>diffusers.pipelines.stable_diffusion_3.StableDiffusion3PipelineOutput</code> instead of
a plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.joint_attention_kwargs",description:`<strong>joint_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"joint_attention_kwargs"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 256) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.mu",description:"<strong>mu</strong> (<code>float</code>, <em>optional</em>) &#x2014; <code>mu</code> value used for <code>dynamic_shifting</code>.",name:"mu"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_53/diffusers/pipelines/stable_diffusion_3/pipeline_stable_diffusion_3_inpaint.py#L921",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>diffusers.pipelines.stable_diffusion_3.StableDiffusion3PipelineOutput</code> if <code>return_dict</code> is True, otherwise a
<code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>diffusers.pipelines.stable_diffusion_3.StableDiffusion3PipelineOutput</code> or <code>tuple</code></p>
`}}),Re=new B({props:{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.example",$$slots:{default:[Ps]},$$scope:{ctx:N}}}),Dn=new k({props:{title:"ORTFluxPipeline",local:"optimum.onnxruntime.ORTFluxPipeline",headingTag:"h3"}}),Cn=new P({props:{name:"class optimum.onnxruntime.ORTFluxPipeline",anchor:"optimum.onnxruntime.ORTFluxPipeline",parameters:[{name:"unet_session",val:": InferenceSession | None = None"},{name:"transformer_session",val:": InferenceSession | None = None"},{name:"vae_decoder_session",val:": InferenceSession | None = None"},{name:"vae_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_2_session",val:": InferenceSession | None = None"},{name:"text_encoder_3_session",val:": InferenceSession | None = None"},{name:"scheduler",val:": SchedulerMixin | None = None"},{name:"tokenizer",val:": CLIPTokenizer | None = None"},{name:"tokenizer_2",val:": CLIPTokenizer | None = None"},{name:"tokenizer_3",val:": CLIPTokenizer | None = None"},{name:"feature_extractor",val:": CLIPFeatureExtractor | None = None"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"add_watermarker",val:": bool | None = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_53/optimum/onnxruntime/modeling_diffusion.py#L1101"}}),$n=new P({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"true_cfg_scale",val:": float = 1.0"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 28"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": float = 3.5"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"negative_ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"negative_ip_adapter_image_embeds",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"joint_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
will be used instead.`,name:"prompt_2"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>true_cfg_scale</code> is
not greater than <code>1</code>).`,name:"negative_prompt"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in all the text-encoders.`,name:"negative_prompt_2"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.true_cfg_scale",description:`<strong>true_cfg_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
True classifier-free guidance (guidance scale) is enabled when <code>true_cfg_scale</code> &gt; 1 and
<code>negative_prompt</code> is provided.`,name:"true_cfg_scale"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 3.5) &#x2014;
Embedded guiddance scale is enabled by setting <code>guidance_scale</code> &gt; 1. Higher <code>guidance_scale</code> encourages
a model to generate images more aligned with <code>prompt</code> at the expense of lower image quality.</p>
<p>Guidance-distilled models approximates true classifer-free guidance for <code>guidance_scale</code> &gt; 1. Refer to
the <a href="https://huggingface.co/papers/2210.03142" rel="nofollow">paper</a> to learn more.`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will be generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.ip_adapter_image",description:"<strong>ip_adapter_image</strong> &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.",name:"ip_adapter_image"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.negative_ip_adapter_image",description:`<strong>negative_ip_adapter_image</strong> &#x2014;
(<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.`,name:"negative_ip_adapter_image"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.negative_ip_adapter_image_embeds",description:`<strong>negative_ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"negative_ip_adapter_image_embeds"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>diffusers.pipelines.flux.FluxPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.joint_attention_kwargs",description:`<strong>joint_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"joint_attention_kwargs"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 512) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_53/diffusers/pipelines/flux/pipeline_flux.py#L627",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>diffusers.pipelines.flux.FluxPipelineOutput</code> if <code>return_dict</code>
is True, otherwise a <code>tuple</code>. When returning a tuple, the first element is a list with the generated
images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>diffusers.pipelines.flux.FluxPipelineOutput</code> or <code>tuple</code></p>
`}}),Oe=new B({props:{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.example",$$slots:{default:[Ns]},$$scope:{ctx:N}}}),{c(){s=p("meta"),v=o(),y=p("p"),l=o(),c(b.$$.fragment),n=o(),c(T.$$.fragment),Vt=o(),je=p("p"),je.textContent=la,Qt=o(),c(Xe.$$.fragment),At=o(),L=p("div"),c(Ze.$$.fragment),Uo=o(),Jn=p("p"),Jn.textContent=pa,Jo=o(),jn=p("p"),jn.innerHTML=ma,jo=o(),Xn=p("ul"),Xn.innerHTML=da,Xo=o(),Zn=p("p"),Zn.textContent=ca,Zo=o(),Gn=p("ul"),Gn.innerHTML=ga,Go=o(),ye=p("div"),c(Ge.$$.fragment),Wo=o(),Wn=p("p"),Wn.innerHTML=ua,Kt=o(),c(We.$$.fragment),eo=o(),S=p("div"),c(ze.$$.fragment),zo=o(),zn=p("p"),zn.innerHTML=_a,Fo=o(),Fn=p("p"),Fn.innerHTML=fa,Bo=o(),Bn=p("p"),Bn.textContent=ha,Eo=o(),En=p("ul"),En.innerHTML=ba,no=o(),c(Fe.$$.fragment),to=o(),R=p("div"),c(Be.$$.fragment),Yo=o(),Yn=p("p"),Yn.innerHTML=ya,Ho=o(),Hn=p("p"),Hn.innerHTML=xa,qo=o(),qn=p("p"),qn.textContent=Ta,Vo=o(),Vn=p("ul"),Vn.innerHTML=va,oo=o(),c(Ee.$$.fragment),io=o(),O=p("div"),c(Ye.$$.fragment),Qo=o(),Qn=p("p"),Qn.innerHTML=Ia,Ao=o(),An=p("p"),An.innerHTML=wa,Ko=o(),Kn=p("p"),Kn.textContent=Pa,ei=o(),et=p("ul"),et.innerHTML=Na,ao=o(),c(He.$$.fragment),so=o(),qe=p("p"),qe.textContent=ka,ro=o(),c(Ve.$$.fragment),lo=o(),D=p("div"),c(Qe.$$.fragment),ni=o(),nt=p("p"),nt.innerHTML=La,ti=o(),tt=p("p"),tt.innerHTML=Ma,oi=o(),te=p("div"),c(Ae.$$.fragment),ii=o(),ot=p("p"),ot.textContent=Sa,ai=o(),c(xe.$$.fragment),po=o(),c(Ke.$$.fragment),mo=o(),C=p("div"),c(en.$$.fragment),si=o(),it=p("p"),it.innerHTML=Ra,ri=o(),at=p("p"),at.innerHTML=Oa,li=o(),oe=p("div"),c(nn.$$.fragment),pi=o(),st=p("p"),st.textContent=Da,mi=o(),c(Te.$$.fragment),co=o(),c(tn.$$.fragment),go=o(),$=p("div"),c(on.$$.fragment),di=o(),rt=p("p"),rt.innerHTML=Ca,ci=o(),lt=p("p"),lt.innerHTML=$a,gi=o(),ie=p("div"),c(an.$$.fragment),ui=o(),pt=p("p"),pt.textContent=Ua,_i=o(),c(ve.$$.fragment),uo=o(),c(sn.$$.fragment),_o=o(),U=p("div"),c(rn.$$.fragment),fi=o(),mt=p("p"),mt.innerHTML=Ja,hi=o(),dt=p("p"),dt.innerHTML=ja,bi=o(),ae=p("div"),c(ln.$$.fragment),yi=o(),ct=p("p"),ct.textContent=Xa,xi=o(),c(Ie.$$.fragment),fo=o(),c(pn.$$.fragment),ho=o(),J=p("div"),c(mn.$$.fragment),Ti=o(),gt=p("p"),gt.innerHTML=Za,vi=o(),ut=p("p"),ut.innerHTML=Ga,Ii=o(),se=p("div"),c(dn.$$.fragment),wi=o(),_t=p("p"),_t.textContent=Wa,Pi=o(),c(we.$$.fragment),bo=o(),c(cn.$$.fragment),yo=o(),j=p("div"),c(gn.$$.fragment),Ni=o(),ft=p("p"),ft.innerHTML=za,ki=o(),ht=p("p"),ht.innerHTML=Fa,Li=o(),re=p("div"),c(un.$$.fragment),Mi=o(),bt=p("p"),bt.textContent=Ba,Si=o(),c(Pe.$$.fragment),xo=o(),c(_n.$$.fragment),To=o(),X=p("div"),c(fn.$$.fragment),Ri=o(),yt=p("p"),yt.innerHTML=Ea,Oi=o(),xt=p("p"),xt.innerHTML=Ya,Di=o(),le=p("div"),c(hn.$$.fragment),Ci=o(),Tt=p("p"),Tt.textContent=Ha,$i=o(),c(Ne.$$.fragment),vo=o(),c(bn.$$.fragment),Io=o(),Z=p("div"),c(yn.$$.fragment),Ui=o(),vt=p("p"),vt.innerHTML=qa,Ji=o(),It=p("p"),It.innerHTML=Va,ji=o(),pe=p("div"),c(xn.$$.fragment),Xi=o(),wt=p("p"),wt.textContent=Qa,Zi=o(),c(ke.$$.fragment),wo=o(),c(Tn.$$.fragment),Po=o(),G=p("div"),c(vn.$$.fragment),Gi=o(),Pt=p("p"),Pt.innerHTML=Aa,Wi=o(),Nt=p("p"),Nt.innerHTML=Ka,zi=o(),me=p("div"),c(In.$$.fragment),Fi=o(),kt=p("p"),kt.textContent=es,Bi=o(),c(Le.$$.fragment),No=o(),c(wn.$$.fragment),ko=o(),H=p("div"),c(Pn.$$.fragment),Ei=o(),Lt=p("p"),Lt.innerHTML=ns,Yi=o(),de=p("div"),c(Nn.$$.fragment),Hi=o(),Mt=p("p"),Mt.textContent=ts,qi=o(),c(Me.$$.fragment),Lo=o(),c(kn.$$.fragment),Mo=o(),q=p("div"),c(Ln.$$.fragment),Vi=o(),St=p("p"),St.innerHTML=os,Qi=o(),ce=p("div"),c(Mn.$$.fragment),Ai=o(),Rt=p("p"),Rt.textContent=is,Ki=o(),c(Se.$$.fragment),So=o(),c(Sn.$$.fragment),Ro=o(),V=p("div"),c(Rn.$$.fragment),ea=o(),Ot=p("p"),Ot.innerHTML=as,na=o(),ge=p("div"),c(On.$$.fragment),ta=o(),Dt=p("p"),Dt.textContent=ss,oa=o(),c(Re.$$.fragment),Oo=o(),c(Dn.$$.fragment),Do=o(),Q=p("div"),c(Cn.$$.fragment),ia=o(),Ct=p("p"),Ct.innerHTML=rs,aa=o(),ue=p("div"),c($n.$$.fragment),sa=o(),$t=p("p"),$t.textContent=ls,ra=o(),c(Oe.$$.fragment),Co=o(),qt=p("p"),this.h()},l(e){const r=gs("svelte-u9bgzb",document.head);s=m(r,"META",{name:!0,content:!0}),r.forEach(a),v=i(e),y=m(e,"P",{}),I(y).forEach(a),l=i(e),g(b.$$.fragment,e),n=i(e),g(T.$$.fragment,e),Vt=i(e),je=m(e,"P",{"data-svelte-h":!0}),x(je)!=="svelte-2mw8y3"&&(je.textContent=la),Qt=i(e),g(Xe.$$.fragment,e),At=i(e),L=m(e,"DIV",{class:!0});var M=I(L);g(Ze.$$.fragment,M),Uo=i(M),Jn=m(M,"P",{"data-svelte-h":!0}),x(Jn)!=="svelte-1qtjkwt"&&(Jn.textContent=pa),Jo=i(M),jn=m(M,"P",{"data-svelte-h":!0}),x(jn)!=="svelte-u7xuil"&&(jn.innerHTML=ma),jo=i(M),Xn=m(M,"UL",{"data-svelte-h":!0}),x(Xn)!=="svelte-2u2t1u"&&(Xn.innerHTML=da),Xo=i(M),Zn=m(M,"P",{"data-svelte-h":!0}),x(Zn)!=="svelte-wz8va1"&&(Zn.textContent=ca),Zo=i(M),Gn=m(M,"UL",{"data-svelte-h":!0}),x(Gn)!=="svelte-1hvf3l1"&&(Gn.innerHTML=ga),Go=i(M),ye=m(M,"DIV",{class:!0});var Un=I(ye);g(Ge.$$.fragment,Un),Wo=i(Un),Wn=m(Un,"P",{"data-svelte-h":!0}),x(Wn)!=="svelte-1hbzj91"&&(Wn.innerHTML=ua),Un.forEach(a),M.forEach(a),Kt=i(e),g(We.$$.fragment,e),eo=i(e),S=m(e,"DIV",{class:!0});var W=I(S);g(ze.$$.fragment,W),zo=i(W),zn=m(W,"P",{"data-svelte-h":!0}),x(zn)!=="svelte-1jrpxiq"&&(zn.innerHTML=_a),Fo=i(W),Fn=m(W,"P",{"data-svelte-h":!0}),x(Fn)!=="svelte-13laq45"&&(Fn.innerHTML=fa),Bo=i(W),Bn=m(W,"P",{"data-svelte-h":!0}),x(Bn)!=="svelte-wz8va1"&&(Bn.textContent=ha),Eo=i(W),En=m(W,"UL",{"data-svelte-h":!0}),x(En)!=="svelte-1ko87l2"&&(En.innerHTML=ba),W.forEach(a),no=i(e),g(Fe.$$.fragment,e),to=i(e),R=m(e,"DIV",{class:!0});var z=I(R);g(Be.$$.fragment,z),Yo=i(z),Yn=m(z,"P",{"data-svelte-h":!0}),x(Yn)!=="svelte-1dqytto"&&(Yn.innerHTML=ya),Ho=i(z),Hn=m(z,"P",{"data-svelte-h":!0}),x(Hn)!=="svelte-13laq45"&&(Hn.innerHTML=xa),qo=i(z),qn=m(z,"P",{"data-svelte-h":!0}),x(qn)!=="svelte-wz8va1"&&(qn.textContent=Ta),Vo=i(z),Vn=m(z,"UL",{"data-svelte-h":!0}),x(Vn)!=="svelte-1ko87l2"&&(Vn.innerHTML=va),z.forEach(a),oo=i(e),g(Ee.$$.fragment,e),io=i(e),O=m(e,"DIV",{class:!0});var F=I(O);g(Ye.$$.fragment,F),Qo=i(F),Qn=m(F,"P",{"data-svelte-h":!0}),x(Qn)!=="svelte-5947l"&&(Qn.innerHTML=Ia),Ao=i(F),An=m(F,"P",{"data-svelte-h":!0}),x(An)!=="svelte-13laq45"&&(An.innerHTML=wa),Ko=i(F),Kn=m(F,"P",{"data-svelte-h":!0}),x(Kn)!=="svelte-wz8va1"&&(Kn.textContent=Pa),ei=i(F),et=m(F,"UL",{"data-svelte-h":!0}),x(et)!=="svelte-1ko87l2"&&(et.innerHTML=Na),F.forEach(a),ao=i(e),g(He.$$.fragment,e),so=i(e),qe=m(e,"P",{"data-svelte-h":!0}),x(qe)!=="svelte-ivnoci"&&(qe.textContent=ka),ro=i(e),g(Ve.$$.fragment,e),lo=i(e),D=m(e,"DIV",{class:!0});var A=I(D);g(Qe.$$.fragment,A),ni=i(A),nt=m(A,"P",{"data-svelte-h":!0}),x(nt)!=="svelte-1x9iqrh"&&(nt.innerHTML=La),ti=i(A),tt=m(A,"P",{"data-svelte-h":!0}),x(tt)!=="svelte-13m37tj"&&(tt.innerHTML=Ma),oi=i(A),te=m(A,"DIV",{class:!0});var _e=I(te);g(Ae.$$.fragment,_e),ii=i(_e),ot=m(_e,"P",{"data-svelte-h":!0}),x(ot)!=="svelte-50j04k"&&(ot.textContent=Sa),ai=i(_e),g(xe.$$.fragment,_e),_e.forEach(a),A.forEach(a),po=i(e),g(Ke.$$.fragment,e),mo=i(e),C=m(e,"DIV",{class:!0});var K=I(C);g(en.$$.fragment,K),si=i(K),it=m(K,"P",{"data-svelte-h":!0}),x(it)!=="svelte-oult51"&&(it.innerHTML=Ra),ri=i(K),at=m(K,"P",{"data-svelte-h":!0}),x(at)!=="svelte-13m37tj"&&(at.innerHTML=Oa),li=i(K),oe=m(K,"DIV",{class:!0});var fe=I(oe);g(nn.$$.fragment,fe),pi=i(fe),st=m(fe,"P",{"data-svelte-h":!0}),x(st)!=="svelte-50j04k"&&(st.textContent=Da),mi=i(fe),g(Te.$$.fragment,fe),fe.forEach(a),K.forEach(a),co=i(e),g(tn.$$.fragment,e),go=i(e),$=m(e,"DIV",{class:!0});var ee=I($);g(on.$$.fragment,ee),di=i(ee),rt=m(ee,"P",{"data-svelte-h":!0}),x(rt)!=="svelte-1eh8stb"&&(rt.innerHTML=Ca),ci=i(ee),lt=m(ee,"P",{"data-svelte-h":!0}),x(lt)!=="svelte-13m37tj"&&(lt.innerHTML=$a),gi=i(ee),ie=m(ee,"DIV",{class:!0});var he=I(ie);g(an.$$.fragment,he),ui=i(he),pt=m(he,"P",{"data-svelte-h":!0}),x(pt)!=="svelte-50j04k"&&(pt.textContent=Ua),_i=i(he),g(ve.$$.fragment,he),he.forEach(a),ee.forEach(a),uo=i(e),g(sn.$$.fragment,e),_o=i(e),U=m(e,"DIV",{class:!0});var ne=I(U);g(rn.$$.fragment,ne),fi=i(ne),mt=m(ne,"P",{"data-svelte-h":!0}),x(mt)!=="svelte-1jjayuh"&&(mt.innerHTML=Ja),hi=i(ne),dt=m(ne,"P",{"data-svelte-h":!0}),x(dt)!=="svelte-13m37tj"&&(dt.innerHTML=ja),bi=i(ne),ae=m(ne,"DIV",{class:!0});var be=I(ae);g(ln.$$.fragment,be),yi=i(be),ct=m(be,"P",{"data-svelte-h":!0}),x(ct)!=="svelte-v78lg8"&&(ct.textContent=Xa),xi=i(be),g(Ie.$$.fragment,be),be.forEach(a),ne.forEach(a),fo=i(e),g(pn.$$.fragment,e),ho=i(e),J=m(e,"DIV",{class:!0});var De=I(J);g(mn.$$.fragment,De),Ti=i(De),gt=m(De,"P",{"data-svelte-h":!0}),x(gt)!=="svelte-1pfgv7z"&&(gt.innerHTML=Za),vi=i(De),ut=m(De,"P",{"data-svelte-h":!0}),x(ut)!=="svelte-13m37tj"&&(ut.innerHTML=Ga),Ii=i(De),se=m(De,"DIV",{class:!0});var Ut=I(se);g(dn.$$.fragment,Ut),wi=i(Ut),_t=m(Ut,"P",{"data-svelte-h":!0}),x(_t)!=="svelte-v78lg8"&&(_t.textContent=Wa),Pi=i(Ut),g(we.$$.fragment,Ut),Ut.forEach(a),De.forEach(a),bo=i(e),g(cn.$$.fragment,e),yo=i(e),j=m(e,"DIV",{class:!0});var Ce=I(j);g(gn.$$.fragment,Ce),Ni=i(Ce),ft=m(Ce,"P",{"data-svelte-h":!0}),x(ft)!=="svelte-1qflbvt"&&(ft.innerHTML=za),ki=i(Ce),ht=m(Ce,"P",{"data-svelte-h":!0}),x(ht)!=="svelte-13m37tj"&&(ht.innerHTML=Fa),Li=i(Ce),re=m(Ce,"DIV",{class:!0});var Jt=I(re);g(un.$$.fragment,Jt),Mi=i(Jt),bt=m(Jt,"P",{"data-svelte-h":!0}),x(bt)!=="svelte-v78lg8"&&(bt.textContent=Ba),Si=i(Jt),g(Pe.$$.fragment,Jt),Jt.forEach(a),Ce.forEach(a),xo=i(e),g(_n.$$.fragment,e),To=i(e),X=m(e,"DIV",{class:!0});var $e=I(X);g(fn.$$.fragment,$e),Ri=i($e),yt=m($e,"P",{"data-svelte-h":!0}),x(yt)!=="svelte-1pfgv7z"&&(yt.innerHTML=Ea),Oi=i($e),xt=m($e,"P",{"data-svelte-h":!0}),x(xt)!=="svelte-13m37tj"&&(xt.innerHTML=Ya),Di=i($e),le=m($e,"DIV",{class:!0});var jt=I(le);g(hn.$$.fragment,jt),Ci=i(jt),Tt=m(jt,"P",{"data-svelte-h":!0}),x(Tt)!=="svelte-v78lg8"&&(Tt.textContent=Ha),$i=i(jt),g(Ne.$$.fragment,jt),jt.forEach(a),$e.forEach(a),vo=i(e),g(bn.$$.fragment,e),Io=i(e),Z=m(e,"DIV",{class:!0});var Ue=I(Z);g(yn.$$.fragment,Ue),Ui=i(Ue),vt=m(Ue,"P",{"data-svelte-h":!0}),x(vt)!=="svelte-1rprww8"&&(vt.innerHTML=qa),Ji=i(Ue),It=m(Ue,"P",{"data-svelte-h":!0}),x(It)!=="svelte-13m37tj"&&(It.innerHTML=Va),ji=i(Ue),pe=m(Ue,"DIV",{class:!0});var Xt=I(pe);g(xn.$$.fragment,Xt),Xi=i(Xt),wt=m(Xt,"P",{"data-svelte-h":!0}),x(wt)!=="svelte-50j04k"&&(wt.textContent=Qa),Zi=i(Xt),g(ke.$$.fragment,Xt),Xt.forEach(a),Ue.forEach(a),wo=i(e),g(Tn.$$.fragment,e),Po=i(e),G=m(e,"DIV",{class:!0});var Je=I(G);g(vn.$$.fragment,Je),Gi=i(Je),Pt=m(Je,"P",{"data-svelte-h":!0}),x(Pt)!=="svelte-6bhs0q"&&(Pt.innerHTML=Aa),Wi=i(Je),Nt=m(Je,"P",{"data-svelte-h":!0}),x(Nt)!=="svelte-13m37tj"&&(Nt.innerHTML=Ka),zi=i(Je),me=m(Je,"DIV",{class:!0});var Zt=I(me);g(In.$$.fragment,Zt),Fi=i(Zt),kt=m(Zt,"P",{"data-svelte-h":!0}),x(kt)!=="svelte-50j04k"&&(kt.textContent=es),Bi=i(Zt),g(Le.$$.fragment,Zt),Zt.forEach(a),Je.forEach(a),No=i(e),g(wn.$$.fragment,e),ko=i(e),H=m(e,"DIV",{class:!0});var Gt=I(H);g(Pn.$$.fragment,Gt),Ei=i(Gt),Lt=m(Gt,"P",{"data-svelte-h":!0}),x(Lt)!=="svelte-17jsqoo"&&(Lt.innerHTML=ns),Yi=i(Gt),de=m(Gt,"DIV",{class:!0});var Wt=I(de);g(Nn.$$.fragment,Wt),Hi=i(Wt),Mt=m(Wt,"P",{"data-svelte-h":!0}),x(Mt)!=="svelte-v78lg8"&&(Mt.textContent=ts),qi=i(Wt),g(Me.$$.fragment,Wt),Wt.forEach(a),Gt.forEach(a),Lo=i(e),g(kn.$$.fragment,e),Mo=i(e),q=m(e,"DIV",{class:!0});var zt=I(q);g(Ln.$$.fragment,zt),Vi=i(zt),St=m(zt,"P",{"data-svelte-h":!0}),x(St)!=="svelte-1eozulm"&&(St.innerHTML=os),Qi=i(zt),ce=m(zt,"DIV",{class:!0});var Ft=I(ce);g(Mn.$$.fragment,Ft),Ai=i(Ft),Rt=m(Ft,"P",{"data-svelte-h":!0}),x(Rt)!=="svelte-v78lg8"&&(Rt.textContent=is),Ki=i(Ft),g(Se.$$.fragment,Ft),Ft.forEach(a),zt.forEach(a),So=i(e),g(Sn.$$.fragment,e),Ro=i(e),V=m(e,"DIV",{class:!0});var Bt=I(V);g(Rn.$$.fragment,Bt),ea=i(Bt),Ot=m(Bt,"P",{"data-svelte-h":!0}),x(Ot)!=="svelte-14iy8wp"&&(Ot.innerHTML=as),na=i(Bt),ge=m(Bt,"DIV",{class:!0});var Et=I(ge);g(On.$$.fragment,Et),ta=i(Et),Dt=m(Et,"P",{"data-svelte-h":!0}),x(Dt)!=="svelte-v78lg8"&&(Dt.textContent=ss),oa=i(Et),g(Re.$$.fragment,Et),Et.forEach(a),Bt.forEach(a),Oo=i(e),g(Dn.$$.fragment,e),Do=i(e),Q=m(e,"DIV",{class:!0});var Yt=I(Q);g(Cn.$$.fragment,Yt),ia=i(Yt),Ct=m(Yt,"P",{"data-svelte-h":!0}),x(Ct)!=="svelte-62pvfa"&&(Ct.innerHTML=rs),aa=i(Yt),ue=m(Yt,"DIV",{class:!0});var Ht=I(ue);g($n.$$.fragment,Ht),sa=i(Ht),$t=m(Ht,"P",{"data-svelte-h":!0}),x($t)!=="svelte-v78lg8"&&($t.textContent=ls),ra=i(Ht),g(Oe.$$.fragment,Ht),Ht.forEach(a),Yt.forEach(a),Co=i(e),qt=m(e,"P",{}),I(qt).forEach(a),this.h()},h(){w(s,"name","hf:doc:metadata"),w(s,"content",Ls),w(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,r){t(document.head,s),d(e,v,r),d(e,y,r),d(e,l,r),u(b,e,r),d(e,n,r),u(T,e,r),d(e,Vt,r),d(e,je,r),d(e,Qt,r),u(Xe,e,r),d(e,At,r),d(e,L,r),u(Ze,L,null),t(L,Uo),t(L,Jn),t(L,Jo),t(L,jn),t(L,jo),t(L,Xn),t(L,Xo),t(L,Zn),t(L,Zo),t(L,Gn),t(L,Go),t(L,ye),u(Ge,ye,null),t(ye,Wo),t(ye,Wn),d(e,Kt,r),u(We,e,r),d(e,eo,r),d(e,S,r),u(ze,S,null),t(S,zo),t(S,zn),t(S,Fo),t(S,Fn),t(S,Bo),t(S,Bn),t(S,Eo),t(S,En),d(e,no,r),u(Fe,e,r),d(e,to,r),d(e,R,r),u(Be,R,null),t(R,Yo),t(R,Yn),t(R,Ho),t(R,Hn),t(R,qo),t(R,qn),t(R,Vo),t(R,Vn),d(e,oo,r),u(Ee,e,r),d(e,io,r),d(e,O,r),u(Ye,O,null),t(O,Qo),t(O,Qn),t(O,Ao),t(O,An),t(O,Ko),t(O,Kn),t(O,ei),t(O,et),d(e,ao,r),u(He,e,r),d(e,so,r),d(e,qe,r),d(e,ro,r),u(Ve,e,r),d(e,lo,r),d(e,D,r),u(Qe,D,null),t(D,ni),t(D,nt),t(D,ti),t(D,tt),t(D,oi),t(D,te),u(Ae,te,null),t(te,ii),t(te,ot),t(te,ai),u(xe,te,null),d(e,po,r),u(Ke,e,r),d(e,mo,r),d(e,C,r),u(en,C,null),t(C,si),t(C,it),t(C,ri),t(C,at),t(C,li),t(C,oe),u(nn,oe,null),t(oe,pi),t(oe,st),t(oe,mi),u(Te,oe,null),d(e,co,r),u(tn,e,r),d(e,go,r),d(e,$,r),u(on,$,null),t($,di),t($,rt),t($,ci),t($,lt),t($,gi),t($,ie),u(an,ie,null),t(ie,ui),t(ie,pt),t(ie,_i),u(ve,ie,null),d(e,uo,r),u(sn,e,r),d(e,_o,r),d(e,U,r),u(rn,U,null),t(U,fi),t(U,mt),t(U,hi),t(U,dt),t(U,bi),t(U,ae),u(ln,ae,null),t(ae,yi),t(ae,ct),t(ae,xi),u(Ie,ae,null),d(e,fo,r),u(pn,e,r),d(e,ho,r),d(e,J,r),u(mn,J,null),t(J,Ti),t(J,gt),t(J,vi),t(J,ut),t(J,Ii),t(J,se),u(dn,se,null),t(se,wi),t(se,_t),t(se,Pi),u(we,se,null),d(e,bo,r),u(cn,e,r),d(e,yo,r),d(e,j,r),u(gn,j,null),t(j,Ni),t(j,ft),t(j,ki),t(j,ht),t(j,Li),t(j,re),u(un,re,null),t(re,Mi),t(re,bt),t(re,Si),u(Pe,re,null),d(e,xo,r),u(_n,e,r),d(e,To,r),d(e,X,r),u(fn,X,null),t(X,Ri),t(X,yt),t(X,Oi),t(X,xt),t(X,Di),t(X,le),u(hn,le,null),t(le,Ci),t(le,Tt),t(le,$i),u(Ne,le,null),d(e,vo,r),u(bn,e,r),d(e,Io,r),d(e,Z,r),u(yn,Z,null),t(Z,Ui),t(Z,vt),t(Z,Ji),t(Z,It),t(Z,ji),t(Z,pe),u(xn,pe,null),t(pe,Xi),t(pe,wt),t(pe,Zi),u(ke,pe,null),d(e,wo,r),u(Tn,e,r),d(e,Po,r),d(e,G,r),u(vn,G,null),t(G,Gi),t(G,Pt),t(G,Wi),t(G,Nt),t(G,zi),t(G,me),u(In,me,null),t(me,Fi),t(me,kt),t(me,Bi),u(Le,me,null),d(e,No,r),u(wn,e,r),d(e,ko,r),d(e,H,r),u(Pn,H,null),t(H,Ei),t(H,Lt),t(H,Yi),t(H,de),u(Nn,de,null),t(de,Hi),t(de,Mt),t(de,qi),u(Me,de,null),d(e,Lo,r),u(kn,e,r),d(e,Mo,r),d(e,q,r),u(Ln,q,null),t(q,Vi),t(q,St),t(q,Qi),t(q,ce),u(Mn,ce,null),t(ce,Ai),t(ce,Rt),t(ce,Ki),u(Se,ce,null),d(e,So,r),u(Sn,e,r),d(e,Ro,r),d(e,V,r),u(Rn,V,null),t(V,ea),t(V,Ot),t(V,na),t(V,ge),u(On,ge,null),t(ge,ta),t(ge,Dt),t(ge,oa),u(Re,ge,null),d(e,Oo,r),u(Dn,e,r),d(e,Do,r),d(e,Q,r),u(Cn,Q,null),t(Q,ia),t(Q,Ct),t(Q,aa),t(Q,ue),u($n,ue,null),t(ue,sa),t(ue,$t),t(ue,ra),u(Oe,ue,null),d(e,Co,r),d(e,qt,r),$o=!0},p(e,[r]){const M={};r&2&&(M.$$scope={dirty:r,ctx:e}),xe.$set(M);const Un={};r&2&&(Un.$$scope={dirty:r,ctx:e}),Te.$set(Un);const W={};r&2&&(W.$$scope={dirty:r,ctx:e}),ve.$set(W);const z={};r&2&&(z.$$scope={dirty:r,ctx:e}),Ie.$set(z);const F={};r&2&&(F.$$scope={dirty:r,ctx:e}),we.$set(F);const A={};r&2&&(A.$$scope={dirty:r,ctx:e}),Pe.$set(A);const _e={};r&2&&(_e.$$scope={dirty:r,ctx:e}),Ne.$set(_e);const K={};r&2&&(K.$$scope={dirty:r,ctx:e}),ke.$set(K);const fe={};r&2&&(fe.$$scope={dirty:r,ctx:e}),Le.$set(fe);const ee={};r&2&&(ee.$$scope={dirty:r,ctx:e}),Me.$set(ee);const he={};r&2&&(he.$$scope={dirty:r,ctx:e}),Se.$set(he);const ne={};r&2&&(ne.$$scope={dirty:r,ctx:e}),Re.$set(ne);const be={};r&2&&(be.$$scope={dirty:r,ctx:e}),Oe.$set(be)},i(e){$o||(_(b.$$.fragment,e),_(T.$$.fragment,e),_(Xe.$$.fragment,e),_(Ze.$$.fragment,e),_(Ge.$$.fragment,e),_(We.$$.fragment,e),_(ze.$$.fragment,e),_(Fe.$$.fragment,e),_(Be.$$.fragment,e),_(Ee.$$.fragment,e),_(Ye.$$.fragment,e),_(He.$$.fragment,e),_(Ve.$$.fragment,e),_(Qe.$$.fragment,e),_(Ae.$$.fragment,e),_(xe.$$.fragment,e),_(Ke.$$.fragment,e),_(en.$$.fragment,e),_(nn.$$.fragment,e),_(Te.$$.fragment,e),_(tn.$$.fragment,e),_(on.$$.fragment,e),_(an.$$.fragment,e),_(ve.$$.fragment,e),_(sn.$$.fragment,e),_(rn.$$.fragment,e),_(ln.$$.fragment,e),_(Ie.$$.fragment,e),_(pn.$$.fragment,e),_(mn.$$.fragment,e),_(dn.$$.fragment,e),_(we.$$.fragment,e),_(cn.$$.fragment,e),_(gn.$$.fragment,e),_(un.$$.fragment,e),_(Pe.$$.fragment,e),_(_n.$$.fragment,e),_(fn.$$.fragment,e),_(hn.$$.fragment,e),_(Ne.$$.fragment,e),_(bn.$$.fragment,e),_(yn.$$.fragment,e),_(xn.$$.fragment,e),_(ke.$$.fragment,e),_(Tn.$$.fragment,e),_(vn.$$.fragment,e),_(In.$$.fragment,e),_(Le.$$.fragment,e),_(wn.$$.fragment,e),_(Pn.$$.fragment,e),_(Nn.$$.fragment,e),_(Me.$$.fragment,e),_(kn.$$.fragment,e),_(Ln.$$.fragment,e),_(Mn.$$.fragment,e),_(Se.$$.fragment,e),_(Sn.$$.fragment,e),_(Rn.$$.fragment,e),_(On.$$.fragment,e),_(Re.$$.fragment,e),_(Dn.$$.fragment,e),_(Cn.$$.fragment,e),_($n.$$.fragment,e),_(Oe.$$.fragment,e),$o=!0)},o(e){f(b.$$.fragment,e),f(T.$$.fragment,e),f(Xe.$$.fragment,e),f(Ze.$$.fragment,e),f(Ge.$$.fragment,e),f(We.$$.fragment,e),f(ze.$$.fragment,e),f(Fe.$$.fragment,e),f(Be.$$.fragment,e),f(Ee.$$.fragment,e),f(Ye.$$.fragment,e),f(He.$$.fragment,e),f(Ve.$$.fragment,e),f(Qe.$$.fragment,e),f(Ae.$$.fragment,e),f(xe.$$.fragment,e),f(Ke.$$.fragment,e),f(en.$$.fragment,e),f(nn.$$.fragment,e),f(Te.$$.fragment,e),f(tn.$$.fragment,e),f(on.$$.fragment,e),f(an.$$.fragment,e),f(ve.$$.fragment,e),f(sn.$$.fragment,e),f(rn.$$.fragment,e),f(ln.$$.fragment,e),f(Ie.$$.fragment,e),f(pn.$$.fragment,e),f(mn.$$.fragment,e),f(dn.$$.fragment,e),f(we.$$.fragment,e),f(cn.$$.fragment,e),f(gn.$$.fragment,e),f(un.$$.fragment,e),f(Pe.$$.fragment,e),f(_n.$$.fragment,e),f(fn.$$.fragment,e),f(hn.$$.fragment,e),f(Ne.$$.fragment,e),f(bn.$$.fragment,e),f(yn.$$.fragment,e),f(xn.$$.fragment,e),f(ke.$$.fragment,e),f(Tn.$$.fragment,e),f(vn.$$.fragment,e),f(In.$$.fragment,e),f(Le.$$.fragment,e),f(wn.$$.fragment,e),f(Pn.$$.fragment,e),f(Nn.$$.fragment,e),f(Me.$$.fragment,e),f(kn.$$.fragment,e),f(Ln.$$.fragment,e),f(Mn.$$.fragment,e),f(Se.$$.fragment,e),f(Sn.$$.fragment,e),f(Rn.$$.fragment,e),f(On.$$.fragment,e),f(Re.$$.fragment,e),f(Dn.$$.fragment,e),f(Cn.$$.fragment,e),f($n.$$.fragment,e),f(Oe.$$.fragment,e),$o=!1},d(e){e&&(a(v),a(y),a(l),a(n),a(Vt),a(je),a(Qt),a(At),a(L),a(Kt),a(eo),a(S),a(no),a(to),a(R),a(oo),a(io),a(O),a(ao),a(so),a(qe),a(ro),a(lo),a(D),a(po),a(mo),a(C),a(co),a(go),a($),a(uo),a(_o),a(U),a(fo),a(ho),a(J),a(bo),a(yo),a(j),a(xo),a(To),a(X),a(vo),a(Io),a(Z),a(wo),a(Po),a(G),a(No),a(ko),a(H),a(Lo),a(Mo),a(q),a(So),a(Ro),a(V),a(Oo),a(Do),a(Q),a(Co),a(qt)),a(s),h(b,e),h(T,e),h(Xe,e),h(Ze),h(Ge),h(We,e),h(ze),h(Fe,e),h(Be),h(Ee,e),h(Ye),h(He,e),h(Ve,e),h(Qe),h(Ae),h(xe),h(Ke,e),h(en),h(nn),h(Te),h(tn,e),h(on),h(an),h(ve),h(sn,e),h(rn),h(ln),h(Ie),h(pn,e),h(mn),h(dn),h(we),h(cn,e),h(gn),h(un),h(Pe),h(_n,e),h(fn),h(hn),h(Ne),h(bn,e),h(yn),h(xn),h(ke),h(Tn,e),h(vn),h(In),h(Le),h(wn,e),h(Pn),h(Nn),h(Me),h(kn,e),h(Ln),h(Mn),h(Se),h(Sn,e),h(Rn),h(On),h(Re),h(Dn,e),h(Cn),h($n),h(Oe)}}}const Ls='{"title":"ONNX Runtime Diffusion Pipelines","local":"onnx-runtime-diffusion-pipelines","sections":[{"title":"Generic ORT Diffusion Pipeline classes","local":"generic-ort-diffusion-pipeline-classes","sections":[{"title":"ORTDiffusionPipeline","local":"optimum.onnxruntime.ORTDiffusionPipeline","sections":[],"depth":3},{"title":"ORTPipelineForText2Image","local":"optimum.onnxruntime.ORTPipelineForText2Image","sections":[],"depth":3},{"title":"ORTPipelineForImage2Image","local":"optimum.onnxruntime.ORTPipelineForImage2Image","sections":[],"depth":3},{"title":"ORTPipelineForInpainting","local":"optimum.onnxruntime.ORTPipelineForInpainting","sections":[],"depth":3}],"depth":2},{"title":"Supported ORT Diffusion Pipeline classes","local":"supported-ort-diffusion-pipeline-classes","sections":[{"title":"ORTStableDiffusionPipeline","local":"optimum.onnxruntime.ORTStableDiffusionPipeline","sections":[],"depth":3},{"title":"ORTStableDiffusionImg2ImgPipeline","local":"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline","sections":[],"depth":3},{"title":"ORTStableDiffusionInpaintPipeline","local":"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline","sections":[],"depth":3},{"title":"ORTStableDiffusionXLPipeline","local":"optimum.onnxruntime.ORTStableDiffusionXLPipeline","sections":[],"depth":3},{"title":"ORTStableDiffusionXLImg2ImgPipeline","local":"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline","sections":[],"depth":3},{"title":"ORTStableDiffusionXLInpaintPipeline","local":"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline","sections":[],"depth":3},{"title":"ORTStableDiffusionXLImg2ImgPipeline","local":"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline","sections":[],"depth":3},{"title":"ORTLatentConsistencyModelPipeline","local":"optimum.onnxruntime.ORTLatentConsistencyModelPipeline","sections":[],"depth":3},{"title":"ORTLatentConsistencyModelImg2ImgPipeline","local":"optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline","sections":[],"depth":3},{"title":"ORTStableDiffusion3Pipeline","local":"optimum.onnxruntime.ORTStableDiffusion3Pipeline","sections":[],"depth":3},{"title":"ORTStableDiffusion3Img2ImgPipeline","local":"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline","sections":[],"depth":3},{"title":"ORTStableDiffusion3InpaintPipeline","local":"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline","sections":[],"depth":3},{"title":"ORTFluxPipeline","local":"optimum.onnxruntime.ORTFluxPipeline","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ms(N){return ms(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Us extends ds{constructor(s){super(),cs(this,s,Ms,ks,ps,{})}}export{Us as component};
