import{s as Vo,o as Bo,n as _o}from"../chunks/scheduler.37c15a92.js";import{S as Qo,i as Wo,g as o,s as n,r as i,A as Ao,h as p,f as l,c as a,j as qo,u as c,x as r,k as pa,y as Ro,a as t,v as m,d as M,t as u,w as d}from"../chunks/index.2bf4358c.js";import{T as No}from"../chunks/Tip.363c041f.js";import{Y as Xo}from"../chunks/Youtube.1e50a667.js";import{C as y}from"../chunks/CodeBlock.4e987730.js";import{C as Go}from"../chunks/CourseFloatingBanner.6add7356.js";import{H as Ml}from"../chunks/Heading.8ada512a.js";import{E as Lo}from"../chunks/index.e71982be.js";function Ho(ul){let J,f=`<strong>Para ir más allá</strong> Si pruebas las dos versiones de los normalizadores previos en un string conteniendo un caracter unicode <code>u&quot;\\u0085&quot;</code>
de seguro notarás que los dos normalizadores no son exactamente equivalentes.
Para no sobre-complicar demasiado la version con <code>normalizers.Sequence</code>, no hemos incluido los reemplazos usando Expresiones Regulares (Regex) que el <code>BertNormalizer</code> requiere cuando el argumento <code>clean_text</code> se fija como <code>True</code> - lo cual es el comportamiento por defecto. Pero no te preocupes, es posible obtener la misma normalización sin usar el útil <code>BertNormalizer</code> agregando dos <code>normalizers.Replace</code> a la secuencia de normalizadores.`;return{c(){J=o("p"),J.innerHTML=f},l(j){J=p(j,"P",{"data-svelte-h":!0}),r(J)!=="svelte-18c2t8f"&&(J.innerHTML=f)},m(j,cl){t(j,J,cl)},p:_o,d(j){j&&l(J)}}}function Eo(ul){let J,f,j,cl,b,dl,U,yl,$,ra="Como hemos visto en las secciones previas, la tokenización está compuesta de varias etapas:",Jl,g,ia="<li>Normalización (cualquier limpieza del texto que se considere necesaria, tales como remover espacios o acentos, normalización Unicode, etc.)</li> <li>Pre-tokenización (separar la entrada en palabras)</li> <li>Pasar las entradas (inputs) por el modelo (usar las palabras pre-tokenizadas para producir una secuencia de tokens)</li> <li>Post-procesamiento (agregar tokens especiales del tokenizador, generando la máscara de atención (attention mask) y los IDs de tipo de token)</li>",jl,w,ca="Como recordatorio, acá hay otro vistazo al proceso en totalidad:",Tl,T,ma='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter6/tokenization_pipeline.svg" alt="The tokenization pipeline."/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter6/tokenization_pipeline-dark.svg" alt="The tokenization pipeline."/>',kl,h,Ma='La librería 🤗 Tokenizers ha sido construida para proveer varias opciones para cada una de esas etapas, las cuales se pueden mezclar y combinar. En esta sección veremos cómo podemos construir un tokenizador desde cero, opuesto al entrenamiento de un nuevo tokenizador a partir de uno existente como hicimos en la <a href="/course/chapter6/2">Sección 2</a>. Después de esto, serás capaz de construir cualquier tipo de tokenizador que puedas imaginar!',fl,x,bl,z,ua="De manera más precisa, la librería está construida a partir de una clase central <code>Tokenizer</code> con las unidades más básica reagrupadas en susbmódulos:",Ul,I,da='<li><code>normalizers</code> contiene todos los posibles tipos de <code>Normalizer</code> que puedes usar (la lista completa <a href="https://huggingface.co/docs/tokenizers/api/normalizers" rel="nofollow">aquí</a>).</li> <li><code>pre_tokenizers</code> contiene todos los posibles tipos de <code>PreTokenizer</code> que puedes usar (la lista completa <a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">aquí</a>).</li> <li><code>models</code> contiene los distintos tipos de <code>Model</code> que puedes usar, como <code>BPE</code>, <code>WordPiece</code>, and <code>Unigram</code> (la lista completa <a href="https://huggingface.co/docs/tokenizers/api/models" rel="nofollow">aquí</a>).</li> <li><code>trainers</code> contiene todos los distintos tipos de <code>Trainer</code> que puedes usar para entrenar tu modelo en un corpus (uno por cada tipo de modelo; la lista completa <a href="https://huggingface.co/docs/tokenizers/api/trainers" rel="nofollow">aquí</a>).</li> <li><code>post_processors</code> contiene varios tipos de <code>PostProcessor</code> que puedes usar (la lista completa <a href="https://huggingface.co/docs/tokenizers/api/post-processors" rel="nofollow">aquí</a>).</li> <li><code>decoders</code> contiene varios tipos de <code>Decoder</code> que puedes usar para decodificar las salidas de la tokenización (la lista completa <a href="https://huggingface.co/docs/tokenizers/components#decoders" rel="nofollow">aquí</a>).</li>',$l,C,ya='Puedes encontrar la lista completas de las unidades más básicas <a href="https://huggingface.co/docs/tokenizers/components" rel="nofollow">aquí</a>.',gl,v,wl,Z,Ja='Para entrenar nuestro nuevo tokenizador, usaremos un pequeño corpus de texto (para que los ejemplos se ejecuten rápido). Los pasos para adquirir el corpus son similares a los que tomamos al <a href="/course/chapter6/2">beginning of this chapter</a>, pero esta vez usaremos el conjunto de datos <a href="https://huggingface.co/datasets/wikitext" rel="nofollow">WikiText-2</a>:',hl,q,xl,V,ja="La función <code>get_training_corpus()</code> es un generador que entregará lotes de 1.000 textos, los cuales usaremos para entrenar el tokenizador.",zl,B,Ta="🤗 Tokenizers puedes también ser entrenada en archivos de textos directamente. Así es como podemos generar un archivo de texto conteniendo todos los textos/entradas de WikiText-2 que podemos usar localmente:",Il,_,Cl,Q,ka="A continuación mostraremos como construir tu propios propios tokenizadores BERT, GPT-2 y XLNet, bloque por bloque. Esto nos dará un ejemplo de cada una de los tres principales algoritmos de tokenización: WordPiece, BPE y Unigram. Empecemos con BERT!",vl,W,Zl,A,fa="Para construir un tokenizador con la librería 🤗 Tokenizers, empezamos instanciando un objeto <code>Tokenizer</code> con un <code>model</code>, luego fijamos sus atributos <code>normalizer</code>, <code>pre_tokenizer</code>, <code>post_processor</code>, y <code>decoder</code> a los valores que queremos.",ql,R,ba="Para este ejemplo, crearemos un <code>Tokenizer</code> con modelo WordPiece:",Vl,N,Bl,X,Ua="Tenemos que especificar el <code>unk_token</code> para que el modelo sepa que retornar si encuentra caracteres que no ha visto antes. Otros argumentos que podemos fijar acá incluyen el <code>vocab</code> de nuestro modelo (vamos a entrenar el modelo, por lo que no necesitamos fijar esto) y <code>max_input_chars_per_word</code>, el cual especifica el largo máximo para cada palabra (palabras más largas que el valor pasado se serpararán).",_l,G,$a="El primer paso de la tokenización es la normalizacion, así que empecemos con eso. Dado que BERT es ampliamente usado, hay un <code>BertNormalizer</code> con opciones clásicas que podemos fijar para BERT: <code>lowercase</code> (transformar a minúsculas) y <code>strip_accents</code> (eliminar acentos); <code>clean_text</code> para remover todos los caracteres de control y reemplazar espacios repetidos en uno solo; y <code>handle_chinese_chars</code> el cual coloca espacios alrededor de los caracteres en Chino. Para replicar el tokenizador <code>bert-base-uncased</code>, basta con fijar este normalizador:",Ql,L,Wl,H,ga="Sin embargo, en términos generales, cuando se construye un nuevo tokenizador no tendrás acceso a tan útil normalizador ya implementado en la librería 🤗 Tokenizers — por lo que veamos como crear el normalizador BERT a mano. La librería provee un normalizador <code>Lowercase</code> y un normalizador <code>StripAccents</code>, y puedes componer varios normalizadores usando un <code>Sequence</code> (secuencia):",Al,E,Rl,D,wa="También estamos usando un normalizador Unicode <code>NFD</code>, ya que de otra manera el normalizador <code>StripAccents</code> no reconocerá apropiadamente los caracteres acentuados y por lo tanto, no los eliminará.",Nl,S,ha="Como hemos visto antes, podemos usar el método <code>normalize_str()</code> del <code>normalizer</code> para chequear los efectos que tiene en un texto dado:",Xl,P,Gl,Y,Ll,k,Hl,F,xa="A continuación está la etapa de pre-tokenización. De nuevo, hay un <code>BertPreTokenizer</code> pre-hecho que podemos usar:",El,K,Dl,O,za="O podemos constuirlo desde cero:",Sl,ee,Pl,se,Ia="Nota que el pre-tokenizador <code>Whitespace</code> separa en espacios en blando y todos los caracteres que no son letras, dígitos o el guión bajo/guión al piso (_), por lo que técnicamente separa en espacios en blanco y puntuación:",Yl,le,Fl,te,Kl,ne,Ca="Si sólo quieres separar en espacios en blanco, deberías usar el pre-tokenizador <code>WhitespaceSplit</code>:",Ol,ae,et,oe,st,pe,va="Al igual que con los normalizadores, puedes un <code>Sequence</code> para componer varios pre-tokenizadores:",lt,re,tt,ie,nt,ce,Za="El siguiente paso en el pipeline de tokenización es pasar las entradas a través del modelo. Ya especificamos nuestro modelo en la inicialización, pero todavía necesitamos entrenarlo, lo cual requerirá un <code>WordPieceTrainer</code>. El aspecto principal a recordar cuando se instancia un entrenador (trainer) en 🤗 Tokenizers es que necesitas pasarle todos los tokens especiales que tiene la intención de usar — de otra manera no los agregará al vocabulario, dado que que no están en el corpus de entrenamiento:",at,me,ot,Me,qa="Al igual que especificar <code>vocab_size</code> y <code>special_tokens</code>, podemos fijar <code>min_frequency</code> (el número de veces que un token debe aparecer para ser incluido en el vocabulario) o cambiar <code>continuing_subword_prefix</code> (si queremos usar algo diferente a <code>##</code>).",pt,ue,Va="Para entrenar nuestro modelo usando el iterador que definimos antes, tenemos que ejecutar el siguiente comando:",rt,de,it,ye,Ba="También podemos usar archivos de texto para entrenar nuestro tokenizador, lo cual se vería así (reinicializamos el modelo con un <code>WordPiece</code> vacío de antemano):",ct,Je,mt,je,_a="En ambos casos, podemos probar el tokenizador en un texto llamando al método `encode:",Mt,Te,ut,ke,dt,fe,Qa="El <code>encoding</code> (codificación) obtenido es un objeto <code>Encoding</code>, el cual contiene todas las salidas necesarias del tokenizador y sus distintos atributos: <code>ids</code>, <code>type_ids</code>, <code>tokens</code>, <code>offsets</code>, <code>attention_mask</code>, <code>special_tokens_mask</code>, y <code>overflowing</code>.",yt,be,Wa="El último paso en el pipeline de tokenización es el post-procesamiento. Necesitamos agregar el token <code>[CLS]</code> al inicio y el token <code>[SEP]</code> al final (o después de cada oración, si tenemos un par de oraciones). Usaremos un <code>TemplateProcessor</code> para esto, pero primero necesitamos conocer los IDs de los tokens <code>[CLS]</code> y <code>[SEP]</code> en el vocabulario:",Jt,Ue,jt,$e,Tt,ge,Aa="Para escribir la plantilla (template) para un <code>TemplateProcessor</code>, tenemos que especificar como tratar una sóla oración y un par de oraciones. Para ambos, escribimos los tokens especiales que queremos usar; la primera oración se representa por <code>$A</code>, mientras que la segunda oración (si se está codificando un par) se representa por <code>$B</code>. Para cada uno de estos (tokens especiales y oraciones), también especificamos el ID del tipo de token correspondiente después de un dos puntos (:).",kt,we,Ra="La clásica plantilla para BERT se define como sigue:",ft,he,bt,xe,Na="Nota que necesitamos pasar los IDs de los tokens especiales, para que el tokenizador pueda convertirlos apropiadamente a sus IDs.",Ut,ze,Xa="Una vez que se agrega esto, volviendo a nuestro ejemplo anterior nos dará:",$t,Ie,gt,Ce,wt,ve,Ga="Y en un par de oraciones, obtenemos el resultado apropiado:",ht,Ze,xt,qe,zt,Ve,La="Ya casi finalizamos de construir este tokenizador desde cero — el último paso es incluir un decodificador:",It,Be,Ct,_e,Ha="Probemoslo en nuestro <code>encoding</code> previo:",vt,Qe,Zt,We,qt,Ae,Ea="Genial! Ahora podemos guardar nuestro tokenizador en un archivo JSON así:",Vt,Re,Bt,Ne,Da="Podemos cargar ese archivo en un objeto <code>Tokenizer</code> con el método <code>from_file()</code>:",_t,Xe,Qt,Ge,Sa="Para usar este tokenizador en 🤗 Transformers, tenemos que envolverlo en un <code>PreTrainedTokenizerFast</code>. Podemos usar una clase generica o, si nuestro tokenizador corresponde un modelo existente, usar esa clase (en este caso, <code>BertTokenizerFast</code>). Si aplicas esta lección para construir un tokenizador nuevo de paquete, tendrás que usar la primera opción.",Wt,Le,Pa="Para envolver el tokenizador en un <code>PreTrainedTokenizerFast</code>, podemos pasar el tokenizador que construimos como un <code>tokenizer_object</code> o pasar el archivo del tokenizador que guardarmos como <code>tokenizer_file</code>. El aspecto clave a recordar es que tenemos que manualmente fijar los tokens especiales, dado que la clase no puede inferir del objeto <code>tokenizer</code> qué token es el el token de enmascaramiento (mask token), el token <code>[CLS]</code>, etc.:",At,He,Rt,Ee,Ya="Si estás usando una clase de tokenizador específico (como <code>BertTokenizerFast</code>), sólo necesitarás especificar los tokens especiales diferentes a los que están por defecto (en este caso, ninguno):",Nt,De,Xt,Se,Fa="Luego puedes usar este tokenizador como cualquier otro tokenizador de 🤗 Transformers. Puedes guardarlo con el método <code>save_pretrained()</code>, o subirlo al Hub con el método <code>push_to_hub()</code>.",Gt,Pe,Ka="Ahora que hemos visto como construir el tokenizador WordPiece, hagamos lo mismo para un tokenizador BPE.  Iremos un poco más rápido dato que conoces todos los pasos, y sólo destacaremos las diferencias.",Lt,Ye,Ht,Fe,Oa="Ahora construyamos un tokenizador GPT-2. Al igual que el tokenizador BERT, empezamos inicializando un <code>Tokenizer</code> con un modelo BPE:",Et,Ke,Dt,Oe,eo="También al igual que BERT, podríamos inicializar este modelo con un vocabulario si tuviéramos uno (necesitaríamos pasar el <code>vocab</code> y <code>merges</code>, en este caso), pero dado que entrenaremos desde cero, no necesitaremos hacer eso. Tampoco necesitamos especificar <code>unk_token</code> porque GPT-2 utiliza un byte-level BPE, que no lo requiere.",St,es,so="GPT-2 no usa un normalizador, por lo que nos saltamos este paso y vamos directo a la pre-tokenización:",Pt,ss,Yt,ls,lo="La opción que agregada acá <code>ByteLevel</code> es para no agregar un espacio al inicio de una oración (el cuál es el valor por defecto). Podemos echar un vistazo a la pre-tokenización de un texto de ejemplo como antes:",Ft,ts,Kt,ns,Ot,as,to="A continuación está el modelo, el cual necesita entrenamiento. Para GPT-2, el único token especial es el token de final de texto (end-of-text):",en,os,sn,ps,no="Al igual que con el <code>WordPieceTrainer</code>, junto con <code>vocab_size</code> y <code>special_tokens</code>,  podemos especificar el <code>min_frequency</code> si queremos, o si tenemos un sufijo de fín de palabra (end-of-word suffix) (como <code>&lt;/w&gt;</code>), podemos fijarlo con <code>end_of_word_suffix</code>.",ln,rs,ao="Este tokenizador también se puede entrenar en archivos de textos:",tn,is,nn,cs,oo="Echemos un vistazo a la tokenización de un texto de muestra:",an,ms,on,Ms,pn,us,po="Aplicaremos el post-procesamiento byte-level para el tokenizador GPT-2 como sigue:",rn,ds,cn,ys,ro="La opción <code>trim_offsets = False</code> indica al post-procesador que deberíamos dejar los offsets de los tokens que comiencen con ‘Ġ’ sin modificar: De esta manera el inicio de los offsets apuntarán al espacio antes de la palabra, no el primer caracter de la palabra (dado que el espacio es técnicamente parte del token). Miremos el resultado con el texto que acabamos de codificar, donde <code>&#39;Ġtest&#39;</code> el token en el índice 4:",mn,Js,Mn,js,un,Ts,io="Finalmente, agregamos un decodificador byte-level:",dn,ks,yn,fs,co="y podemos chequear si funciona de manera apropiada:",Jn,bs,jn,Us,Tn,$s,mo="Genial! Ahora que estamos listos, podemos guardar el tokenizador como antes, y envolverlo en un <code>PreTrainedTokenizerFast</code> o <code>GPT2TokenizerFast</code> si queremos usarlo en 🤗 Transformers:",kn,gs,fn,ws,Mo="o:",bn,hs,Un,xs,uo="Como en el último ejemplo, mostraremos cómo construir un tokenizador Unigram desde cero.",$n,zs,gn,Is,yo="Construyamos un tokenizador XLNet. Al igual que los tokenizadores previos, empezamos inicializando un <code>Tokenizer</code> con un modelo Unigram:",wn,Cs,hn,vs,Jo="De nuevo, podríamos inicializar este modelo con un vocabulario si tuvieramos uno.",xn,Zs,jo="Para la normalización, XLNet utiliza unos pocos reemplazos (los cuales vienen de SentencePiece):",zn,qs,In,Vs,To="Esto reemplaza <code>“</code> y <code>”</code> con <code>”</code> y cualquier secuencia de dos o más espacios con un espacio simple, además remueve los acentos en el texto a tokenizar.",Cn,Bs,ko="El pre-tokenizador a usar para cualquier tokenizador SentencePiece es <code>Metaspace</code>:",vn,_s,Zn,Qs,fo="Podemos echar un vistazo a la pre-tokenización de un texto de ejemplo como antes:",qn,Ws,Vn,As,Bn,Rs,bo="A continuación está el modelo, el cuál necesita entrenamiento. XLNet tiene varios tokens especiales:",_n,Ns,Qn,Xs,Uo="Un argumento muy importante a no olvidar para el <code>UnigramTrainer</code> es el <code>unk_token</code>. También podemos pasarle otros argumentos específicos al algoritmo Unigram, tales como el <code>shrinking_factor</code> para cada paso donde removemos tokens (su valor por defecto es 0.75) o el <code>max_piece_length</code> para especificar el largo máximo de un token dado (su valor por defecto es 16).",Wn,Gs,$o="Este tokenizador también se puede entrenar en archivos de texto:",An,Ls,Rn,Hs,go="Ahora miremos la tokenización de un texto de muestra:",Nn,Es,Xn,Ds,Gn,Ss,wo="Una peculiariodad de XLNet es que coloca el token <code>&lt;cls&gt;</code> al final de la oración, con un ID de tipo de 2 (para distinguirlo de los otros tokens). Como el resultado el resultado se rellena a la izquierda (left padding). Podemos lidiar con todos los tokens especiales y el token de ID de tipo con una plantilla, al igual que BERT, pero primero tenemos que obtener los IDs de los tokens <code>&lt;cls&gt;</code> y <code>&lt;sep&gt;</code>:",Ln,Ps,Hn,Ys,En,Fs,ho="La plantilla se ve así:",Dn,Ks,Sn,Os,xo="Y podemos probar si funciona codificando un par de oraciones:",Pn,el,Yn,sl,Fn,ll,zo="Finalmente, agregamos el decodificador <code>Metaspace</code>:",Kn,tl,On,nl,Io="y estamos listos con este tokenizador! Podemos guardar el tokenizador como antes, y envolverlo en un <code>PreTrainedTokenizerFast</code> o <code>XLNetTokenizerFast</code> si queremos usarlo en 🤗 Transformers. Una cosa a notar al usar <code>PreTrainedTokenizerFast</code> es que además de los tokens especiales, necesitamos decirle a la librería 🤗 Transformers que rellene a la izquierda (agregar left padding):",ea,al,sa,ol,Co="O de manera alternativa:",la,pl,ta,rl,vo="Ahora que has visto como varias de nuestras unidades más básicas se usan para construir tokenizadores existentes, deberías ser capaz de escribir cualquier tokenizador que quieras con la librería 🤗 Tokenizers y ser capaz de usarlo en la librería 🤗 Transformers.",na,il,aa,ml,oa;return b=new Ml({props:{title:"Construir un tokenizador, bloque por bloque",local:"building-a-tokenizer-block-by-block",headingTag:"h1"}}),U=new Go({props:{chapter:6,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter6/section8.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter6/section8.ipynb"}]}}),x=new Xo({props:{id:"MR8tZm5ViWU"}}),v=new Ml({props:{title:"Adquirir un corpus",local:"acquiring-a-corpus",headingTag:"h2"}}),q=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJ3aWtpdGV4dCUyMiUyQyUyMG5hbWUlM0QlMjJ3aWtpdGV4dC0yLXJhdy12MSUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBJTBBJTBBZGVmJTIwZ2V0X3RyYWluaW5nX2NvcnB1cygpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMCUyQyUyMGxlbihkYXRhc2V0KSUyQyUyMDEwMDApJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweWllbGQlMjBkYXRhc2V0JTVCaSUyMCUzQSUyMGklMjAlMkIlMjAxMDAwJTVEJTVCJTIydGV4dCUyMiU1RA==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;wikitext&quot;</span>, name=<span class="hljs-string">&quot;wikitext-2-raw-v1&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_training_corpus</span>():
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(dataset), <span class="hljs-number">1000</span>):
        <span class="hljs-keyword">yield</span> dataset[i : i + <span class="hljs-number">1000</span>][<span class="hljs-string">&quot;text&quot;</span>]`,wrap:!1}}),_=new y({props:{code:"d2l0aCUyMG9wZW4oJTIyd2lraXRleHQtMi50eHQlMjIlMkMlMjAlMjJ3JTIyJTJDJTIwZW5jb2RpbmclM0QlMjJ1dGYtOCUyMiklMjBhcyUyMGYlM0ElMEElMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZShsZW4oZGF0YXNldCkpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZi53cml0ZShkYXRhc2V0JTVCaSU1RCU1QiUyMnRleHQlMjIlNUQlMjAlMkIlMjAlMjIlNUNuJTIyKQ==",highlighted:`<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>, encoding=<span class="hljs-string">&quot;utf-8&quot;</span>) <span class="hljs-keyword">as</span> f:
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(dataset)):
        f.write(dataset[i][<span class="hljs-string">&quot;text&quot;</span>] + <span class="hljs-string">&quot;\\n&quot;</span>)`,wrap:!1}}),W=new Ml({props:{title:"Construyendo un tokenizador WordPiece desde cero",local:"building-a-wordpiece-tokenizer-from-scratch",headingTag:"h2"}}),N=new y({props:{code:"ZnJvbSUyMHRva2VuaXplcnMlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwZGVjb2RlcnMlMkMlMEElMjAlMjAlMjAlMjBtb2RlbHMlMkMlMEElMjAlMjAlMjAlMjBub3JtYWxpemVycyUyQyUwQSUyMCUyMCUyMCUyMHByZV90b2tlbml6ZXJzJTJDJTBBJTIwJTIwJTIwJTIwcHJvY2Vzc29ycyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluZXJzJTJDJTBBJTIwJTIwJTIwJTIwVG9rZW5pemVyJTJDJTBBKSUwQSUwQXRva2VuaXplciUyMCUzRCUyMFRva2VuaXplcihtb2RlbHMuV29yZFBpZWNlKHVua190b2tlbiUzRCUyMiU1QlVOSyU1RCUyMikp",highlighted:`<span class="hljs-keyword">from</span> tokenizers <span class="hljs-keyword">import</span> (
    decoders,
    models,
    normalizers,
    pre_tokenizers,
    processors,
    trainers,
    Tokenizer,
)

tokenizer = Tokenizer(models.WordPiece(unk_token=<span class="hljs-string">&quot;[UNK]&quot;</span>))`,wrap:!1}}),L=new y({props:{code:"dG9rZW5pemVyLm5vcm1hbGl6ZXIlMjAlM0QlMjBub3JtYWxpemVycy5CZXJ0Tm9ybWFsaXplcihsb3dlcmNhc2UlM0RUcnVlKQ==",highlighted:'tokenizer.normalizer = normalizers.BertNormalizer(lowercase=<span class="hljs-literal">True</span>)',wrap:!1}}),E=new y({props:{code:"dG9rZW5pemVyLm5vcm1hbGl6ZXIlMjAlM0QlMjBub3JtYWxpemVycy5TZXF1ZW5jZSglMEElMjAlMjAlMjAlMjAlNUJub3JtYWxpemVycy5ORkQoKSUyQyUyMG5vcm1hbGl6ZXJzLkxvd2VyY2FzZSgpJTJDJTIwbm9ybWFsaXplcnMuU3RyaXBBY2NlbnRzKCklNUQlMEEp",highlighted:`tokenizer.normalizer = normalizers.<span class="hljs-type">Sequence</span>(
    [normalizers.NFD(), normalizers.Lowercase(), normalizers.StripAccents()]
)`,wrap:!1}}),P=new y({props:{code:"JTIzJTIwcHJpbnQodG9rZW5pemVyLm5vcm1hbGl6ZXIubm9ybWFsaXplX3N0ciglMjJIJUMzJUE5bGwlQzMlQjIlMjBoJUMzJUI0dyUyMGFyZSUyMCVDMyVCQyUzRiUyMikp",highlighted:'<span class="hljs-comment"># print(tokenizer.normalizer.normalize_str(&quot;Héllò hôw are ü?&quot;))</span>',wrap:!1}}),Y=new y({props:{code:"aGVsbG8lMjBob3clMjBhcmUlMjB1JTNG",highlighted:"hello how are u?",wrap:!1}}),k=new No({props:{$$slots:{default:[Ho]},$$scope:{ctx:ul}}}),K=new y({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5CZXJ0UHJlVG9rZW5pemVyKCk=",highlighted:"tokenizer.pre_tokenizer = pre_tokenizers.BertPreTokenizer()",wrap:!1}}),ee=new y({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5XaGl0ZXNwYWNlKCk=",highlighted:"tokenizer.pre_tokenizer = pre_tokenizers.Whitespace()",wrap:!1}}),le=new y({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIucHJlX3Rva2VuaXplX3N0ciglMjJMZXQncyUyMHRlc3QlMjBteSUyMHByZS10b2tlbml6ZXIuJTIyKQ==",highlighted:'tokenizer.pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test my pre-tokenizer.&quot;</span>)',wrap:!1}}),te=new y({props:{code:"JTVCKCdMZXQnJTJDJTIwKDAlMkMlMjAzKSklMkMlMjAoJTIyJyUyMiUyQyUyMCgzJTJDJTIwNCkpJTJDJTIwKCdzJyUyQyUyMCg0JTJDJTIwNSkpJTJDJTIwKCd0ZXN0JyUyQyUyMCg2JTJDJTIwMTApKSUyQyUyMCgnbXknJTJDJTIwKDExJTJDJTIwMTMpKSUyQyUyMCgncHJlJyUyQyUyMCgxNCUyQyUyMDE3KSklMkMlMEElMjAoJy0nJTJDJTIwKDE3JTJDJTIwMTgpKSUyQyUyMCgndG9rZW5pemVyJyUyQyUyMCgxOCUyQyUyMDI3KSklMkMlMjAoJy4nJTJDJTIwKDI3JTJDJTIwMjgpKSU1RA==",highlighted:`[(<span class="hljs-string">&#x27;Let&#x27;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">3</span>)), (<span class="hljs-string">&quot;&#x27;&quot;</span>, (<span class="hljs-number">3</span>, <span class="hljs-number">4</span>)), (<span class="hljs-string">&#x27;s&#x27;</span>, (<span class="hljs-number">4</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;test&#x27;</span>, (<span class="hljs-number">6</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;my&#x27;</span>, (<span class="hljs-number">11</span>, <span class="hljs-number">13</span>)), (<span class="hljs-string">&#x27;pre&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">17</span>)),
 (<span class="hljs-string">&#x27;-&#x27;</span>, (<span class="hljs-number">17</span>, <span class="hljs-number">18</span>)), (<span class="hljs-string">&#x27;tokenizer&#x27;</span>, (<span class="hljs-number">18</span>, <span class="hljs-number">27</span>)), (<span class="hljs-string">&#x27;.&#x27;</span>, (<span class="hljs-number">27</span>, <span class="hljs-number">28</span>))]`,wrap:!1}}),ae=new y({props:{code:"cHJlX3Rva2VuaXplciUyMCUzRCUyMHByZV90b2tlbml6ZXJzLldoaXRlc3BhY2VTcGxpdCgpJTBBcHJlX3Rva2VuaXplci5wcmVfdG9rZW5pemVfc3RyKCUyMkxldCdzJTIwdGVzdCUyMG15JTIwcHJlLXRva2VuaXplci4lMjIp",highlighted:`pre_tokenizer = pre_tokenizers.WhitespaceSplit()
pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test my pre-tokenizer.&quot;</span>)`,wrap:!1}}),oe=new y({props:{code:"JTVCKCUyMkxldCdzJTIyJTJDJTIwKDAlMkMlMjA1KSklMkMlMjAoJ3Rlc3QnJTJDJTIwKDYlMkMlMjAxMCkpJTJDJTIwKCdteSclMkMlMjAoMTElMkMlMjAxMykpJTJDJTIwKCdwcmUtdG9rZW5pemVyLiclMkMlMjAoMTQlMkMlMjAyOCkpJTVE",highlighted:'[(<span class="hljs-string">&quot;Let&#x27;s&quot;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;test&#x27;</span>, (<span class="hljs-number">6</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;my&#x27;</span>, (<span class="hljs-number">11</span>, <span class="hljs-number">13</span>)), (<span class="hljs-string">&#x27;pre-tokenizer.&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">28</span>))]',wrap:!1}}),re=new y({props:{code:"cHJlX3Rva2VuaXplciUyMCUzRCUyMHByZV90b2tlbml6ZXJzLlNlcXVlbmNlKCUwQSUyMCUyMCUyMCUyMCU1QnByZV90b2tlbml6ZXJzLldoaXRlc3BhY2VTcGxpdCgpJTJDJTIwcHJlX3Rva2VuaXplcnMuUHVuY3R1YXRpb24oKSU1RCUwQSklMEFwcmVfdG9rZW5pemVyLnByZV90b2tlbml6ZV9zdHIoJTIyTGV0J3MlMjB0ZXN0JTIwbXklMjBwcmUtdG9rZW5pemVyLiUyMik=",highlighted:`pre_tokenizer = pre_tokenizers.<span class="hljs-type">Sequence</span>(
    [pre_tokenizers.WhitespaceSplit(), pre_tokenizers.Punctuation()]
)
pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test my pre-tokenizer.&quot;</span>)`,wrap:!1}}),ie=new y({props:{code:"JTVCKCdMZXQnJTJDJTIwKDAlMkMlMjAzKSklMkMlMjAoJTIyJyUyMiUyQyUyMCgzJTJDJTIwNCkpJTJDJTIwKCdzJyUyQyUyMCg0JTJDJTIwNSkpJTJDJTIwKCd0ZXN0JyUyQyUyMCg2JTJDJTIwMTApKSUyQyUyMCgnbXknJTJDJTIwKDExJTJDJTIwMTMpKSUyQyUyMCgncHJlJyUyQyUyMCgxNCUyQyUyMDE3KSklMkMlMEElMjAoJy0nJTJDJTIwKDE3JTJDJTIwMTgpKSUyQyUyMCgndG9rZW5pemVyJyUyQyUyMCgxOCUyQyUyMDI3KSklMkMlMjAoJy4nJTJDJTIwKDI3JTJDJTIwMjgpKSU1RA==",highlighted:`[(<span class="hljs-string">&#x27;Let&#x27;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">3</span>)), (<span class="hljs-string">&quot;&#x27;&quot;</span>, (<span class="hljs-number">3</span>, <span class="hljs-number">4</span>)), (<span class="hljs-string">&#x27;s&#x27;</span>, (<span class="hljs-number">4</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;test&#x27;</span>, (<span class="hljs-number">6</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;my&#x27;</span>, (<span class="hljs-number">11</span>, <span class="hljs-number">13</span>)), (<span class="hljs-string">&#x27;pre&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">17</span>)),
 (<span class="hljs-string">&#x27;-&#x27;</span>, (<span class="hljs-number">17</span>, <span class="hljs-number">18</span>)), (<span class="hljs-string">&#x27;tokenizer&#x27;</span>, (<span class="hljs-number">18</span>, <span class="hljs-number">27</span>)), (<span class="hljs-string">&#x27;.&#x27;</span>, (<span class="hljs-number">27</span>, <span class="hljs-number">28</span>))]`,wrap:!1}}),me=new y({props:{code:"c3BlY2lhbF90b2tlbnMlMjAlM0QlMjAlNUIlMjIlNUJVTkslNUQlMjIlMkMlMjAlMjIlNUJQQUQlNUQlMjIlMkMlMjAlMjIlNUJDTFMlNUQlMjIlMkMlMjAlMjIlNUJTRVAlNUQlMjIlMkMlMjAlMjIlNUJNQVNLJTVEJTIyJTVEJTBBdHJhaW5lciUyMCUzRCUyMHRyYWluZXJzLldvcmRQaWVjZVRyYWluZXIodm9jYWJfc2l6ZSUzRDI1MDAwJTJDJTIwc3BlY2lhbF90b2tlbnMlM0RzcGVjaWFsX3Rva2Vucyk=",highlighted:`special_tokens = [<span class="hljs-string">&quot;[UNK]&quot;</span>, <span class="hljs-string">&quot;[PAD]&quot;</span>, <span class="hljs-string">&quot;[CLS]&quot;</span>, <span class="hljs-string">&quot;[SEP]&quot;</span>, <span class="hljs-string">&quot;[MASK]&quot;</span>]
trainer = trainers.WordPieceTrainer(vocab_size=<span class="hljs-number">25000</span>, special_tokens=special_tokens)`,wrap:!1}}),de=new y({props:{code:"dG9rZW5pemVyLnRyYWluX2Zyb21faXRlcmF0b3IoZ2V0X3RyYWluaW5nX2NvcnB1cygpJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:"tokenizer.train_from_iterator(get_training_corpus(), trainer=trainer)",wrap:!1}}),Je=new y({props:{code:"dG9rZW5pemVyLm1vZGVsJTIwJTNEJTIwbW9kZWxzLldvcmRQaWVjZSh1bmtfdG9rZW4lM0QlMjIlNUJVTkslNUQlMjIpJTBBdG9rZW5pemVyLnRyYWluKCU1QiUyMndpa2l0ZXh0LTIudHh0JTIyJTVEJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:`tokenizer.model = models.WordPiece(unk_token=<span class="hljs-string">&quot;[UNK]&quot;</span>)
tokenizer.train([<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>], trainer=trainer)`,wrap:!1}}),Te=new y({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQSUyMyUyMHByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-comment"># print(encoding.tokens)</span>`,wrap:!1}}),ke=new y({props:{code:"JTVCJ2xldCclMkMlMjAlMjInJTIyJTJDJTIwJ3MnJTJDJTIwJ3Rlc3QnJTJDJTIwJ3RoaXMnJTJDJTIwJ3RvayclMkMlMjAnJTIzJTIzZW5pJyUyQyUyMCclMjMlMjN6ZXInJTJDJTIwJy4nJTVE",highlighted:'[<span class="hljs-string">&#x27;let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;test&#x27;</span>, <span class="hljs-string">&#x27;this&#x27;</span>, <span class="hljs-string">&#x27;tok&#x27;</span>, <span class="hljs-string">&#x27;##eni&#x27;</span>, <span class="hljs-string">&#x27;##zer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),Ue=new y({props:{code:"Y2xzX3Rva2VuX2lkJTIwJTNEJTIwdG9rZW5pemVyLnRva2VuX3RvX2lkKCUyMiU1QkNMUyU1RCUyMiklMEFzZXBfdG9rZW5faWQlMjAlM0QlMjB0b2tlbml6ZXIudG9rZW5fdG9faWQoJTIyJTVCU0VQJTVEJTIyKSUwQSUyMyUyMHByaW50KGNsc190b2tlbl9pZCUyQyUyMHNlcF90b2tlbl9pZCk=",highlighted:`cls_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;[CLS]&quot;</span>)
sep_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;[SEP]&quot;</span>)
<span class="hljs-comment"># print(cls_token_id, sep_token_id)</span>`,wrap:!1}}),$e=new y({props:{code:"KDIlMkMlMjAzKQ==",highlighted:'(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>)',wrap:!1}}),he=new y({props:{code:"dG9rZW5pemVyLnBvc3RfcHJvY2Vzc29yJTIwJTNEJTIwcHJvY2Vzc29ycy5UZW1wbGF0ZVByb2Nlc3NpbmcoJTBBJTIwJTIwJTIwJTIwc2luZ2xlJTNEZiUyMiU1QkNMUyU1RCUzQTAlMjAlMjRBJTNBMCUyMCU1QlNFUCU1RCUzQTAlMjIlMkMlMEElMjAlMjAlMjAlMjBwYWlyJTNEZiUyMiU1QkNMUyU1RCUzQTAlMjAlMjRBJTNBMCUyMCU1QlNFUCU1RCUzQTAlMjAlMjRCJTNBMSUyMCU1QlNFUCU1RCUzQTElMjIlMkMlMEElMjAlMjAlMjAlMjBzcGVjaWFsX3Rva2VucyUzRCU1QiglMjIlNUJDTFMlNUQlMjIlMkMlMjBjbHNfdG9rZW5faWQpJTJDJTIwKCUyMiU1QlNFUCU1RCUyMiUyQyUyMHNlcF90b2tlbl9pZCklNUQlMkMlMEEp",highlighted:`tokenizer.post_processor = processors.TemplateProcessing(
    single=<span class="hljs-string">f&quot;[CLS]:0 $A:0 [SEP]:0&quot;</span>,
    pair=<span class="hljs-string">f&quot;[CLS]:0 $A:0 [SEP]:0 $B:1 [SEP]:1&quot;</span>,
    special_tokens=[(<span class="hljs-string">&quot;[CLS]&quot;</span>, cls_token_id), (<span class="hljs-string">&quot;[SEP]&quot;</span>, sep_token_id)],
)`,wrap:!1}}),Ie=new y({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQSUyMyUyMHByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-comment"># print(encoding.tokens)</span>`,wrap:!1}}),Ce=new y({props:{code:"JTVCJyU1QkNMUyU1RCclMkMlMjAnbGV0JyUyQyUyMCUyMiclMjIlMkMlMjAncyclMkMlMjAndGVzdCclMkMlMjAndGhpcyclMkMlMjAndG9rJyUyQyUyMCclMjMlMjNlbmknJTJDJTIwJyUyMyUyM3plciclMkMlMjAnLiclMkMlMjAnJTVCU0VQJTVEJyU1RA==",highlighted:'[<span class="hljs-string">&#x27;[CLS]&#x27;</span>, <span class="hljs-string">&#x27;let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;test&#x27;</span>, <span class="hljs-string">&#x27;this&#x27;</span>, <span class="hljs-string">&#x27;tok&#x27;</span>, <span class="hljs-string">&#x27;##eni&#x27;</span>, <span class="hljs-string">&#x27;##zer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;[SEP]&#x27;</span>]',wrap:!1}}),Ze=new y({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuLi4lMjIlMkMlMjAlMjJvbiUyMGElMjBwYWlyJTIwb2YlMjBzZW50ZW5jZXMuJTIyKSUwQSUyMyUyMHByaW50KGVuY29kaW5nLnRva2VucyklMEElMjMlMjBwcmludChlbmNvZGluZy50eXBlX2lkcyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer...&quot;</span>, <span class="hljs-string">&quot;on a pair of sentences.&quot;</span>)
<span class="hljs-comment"># print(encoding.tokens)</span>
<span class="hljs-comment"># print(encoding.type_ids)</span>`,wrap:!1}}),qe=new y({props:{code:"JTVCJyU1QkNMUyU1RCclMkMlMjAnbGV0JyUyQyUyMCUyMiclMjIlMkMlMjAncyclMkMlMjAndGVzdCclMkMlMjAndGhpcyclMkMlMjAndG9rJyUyQyUyMCclMjMlMjNlbmknJTJDJTIwJyUyMyUyM3plciclMkMlMjAnLi4uJyUyQyUyMCclNUJTRVAlNUQnJTJDJTIwJ29uJyUyQyUyMCdhJyUyQyUyMCdwYWlyJyUyQyUyMCdvZiclMkMlMjAnc2VudGVuY2VzJyUyQyUyMCcuJyUyQyUyMCclNUJTRVAlNUQnJTVEJTBBJTVCMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTVE",highlighted:`[<span class="hljs-string">&#x27;[CLS]&#x27;</span>, <span class="hljs-string">&#x27;let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;test&#x27;</span>, <span class="hljs-string">&#x27;this&#x27;</span>, <span class="hljs-string">&#x27;tok&#x27;</span>, <span class="hljs-string">&#x27;##eni&#x27;</span>, <span class="hljs-string">&#x27;##zer&#x27;</span>, <span class="hljs-string">&#x27;...&#x27;</span>, <span class="hljs-string">&#x27;[SEP]&#x27;</span>, <span class="hljs-string">&#x27;on&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;pair&#x27;</span>, <span class="hljs-string">&#x27;of&#x27;</span>, <span class="hljs-string">&#x27;sentences&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;[SEP]&#x27;</span>]
[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]`,wrap:!1}}),Be=new y({props:{code:"dG9rZW5pemVyLmRlY29kZXIlMjAlM0QlMjBkZWNvZGVycy5Xb3JkUGllY2UocHJlZml4JTNEJTIyJTIzJTIzJTIyKQ==",highlighted:'tokenizer.decoder = decoders.WordPiece(prefix=<span class="hljs-string">&quot;##&quot;</span>)',wrap:!1}}),Qe=new y({props:{code:"dG9rZW5pemVyLmRlY29kZShlbmNvZGluZy5pZHMp",highlighted:"tokenizer.decode(encoding.ids)",wrap:!1}}),We=new y({props:{code:"JTIybGV0J3MlMjB0ZXN0JTIwdGhpcyUyMHRva2VuaXplci4uLiUyMG9uJTIwYSUyMHBhaXIlMjBvZiUyMHNlbnRlbmNlcy4lMjI=",highlighted:'<span class="hljs-string">&quot;let&#x27;s test this tokenizer... on a pair of sentences.&quot;</span>',wrap:!1}}),Re=new y({props:{code:"dG9rZW5pemVyLnNhdmUoJTIydG9rZW5pemVyLmpzb24lMjIp",highlighted:'tokenizer.save(<span class="hljs-string">&quot;tokenizer.json&quot;</span>)',wrap:!1}}),Xe=new y({props:{code:"bmV3X3Rva2VuaXplciUyMCUzRCUyMFRva2VuaXplci5mcm9tX2ZpbGUoJTIydG9rZW5pemVyLmpzb24lMjIp",highlighted:'new_tokenizer = Tokenizer.from_file(<span class="hljs-string">&quot;tokenizer.json&quot;</span>)',wrap:!1}}),He=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBQcmVUcmFpbmVkVG9rZW5pemVyRmFzdCglMEElMjAlMjAlMjAlMjB0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwJTIzJTIwdG9rZW5pemVyX2ZpbGUlM0QlMjJ0b2tlbml6ZXIuanNvbiUyMiUyQyUyMCUyMyUyMFlvdSUyMGNhbiUyMGxvYWQlMjBmcm9tJTIwdGhlJTIwdG9rZW5pemVyJTIwZmlsZSUyQyUyMGFsdGVybmF0aXZlbHklMEElMjAlMjAlMjAlMjB1bmtfdG9rZW4lM0QlMjIlNUJVTkslNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBwYWRfdG9rZW4lM0QlMjIlNUJQQUQlNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBjbHNfdG9rZW4lM0QlMjIlNUJDTFMlNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBzZXBfdG9rZW4lM0QlMjIlNUJTRVAlNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXNrX3Rva2VuJTNEJTIyJTVCTUFTSyU1RCUyMiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedTokenizerFast

wrapped_tokenizer = PreTrainedTokenizerFast(
    tokenizer_object=tokenizer,
    <span class="hljs-comment"># tokenizer_file=&quot;tokenizer.json&quot;, # You can load from the tokenizer file, alternatively</span>
    unk_token=<span class="hljs-string">&quot;[UNK]&quot;</span>,
    pad_token=<span class="hljs-string">&quot;[PAD]&quot;</span>,
    cls_token=<span class="hljs-string">&quot;[CLS]&quot;</span>,
    sep_token=<span class="hljs-string">&quot;[SEP]&quot;</span>,
    mask_token=<span class="hljs-string">&quot;[MASK]&quot;</span>,
)`,wrap:!1}}),De=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlcnRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBCZXJ0VG9rZW5pemVyRmFzdCh0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertTokenizerFast

wrapped_tokenizer = BertTokenizerFast(tokenizer_object=tokenizer)`,wrap:!1}}),Ye=new Ml({props:{title:"Construyendo un tokenizador BPE desde cero",local:"building-a-bpe-tokenizer-from-scratch",headingTag:"h2"}}),Ke=new y({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwVG9rZW5pemVyKG1vZGVscy5CUEUoKSk=",highlighted:"tokenizer = Tokenizer(models.BPE())",wrap:!1}}),ss=new y({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5CeXRlTGV2ZWwoYWRkX3ByZWZpeF9zcGFjZSUzREZhbHNlKQ==",highlighted:'tokenizer.pre_tokenizer = pre_tokenizers.ByteLevel(add_prefix_space=<span class="hljs-literal">False</span>)',wrap:!1}}),ts=new y({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIucHJlX3Rva2VuaXplX3N0ciglMjJMZXQncyUyMHRlc3QlMjBwcmUtdG9rZW5pemF0aW9uISUyMik=",highlighted:'tokenizer.pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test pre-tokenization!&quot;</span>)',wrap:!1}}),ns=new y({props:{code:"JTVCKCdMZXQnJTJDJTIwKDAlMkMlMjAzKSklMkMlMjAoJTIyJ3MlMjIlMkMlMjAoMyUyQyUyMDUpKSUyQyUyMCgnJUM0JUEwdGVzdCclMkMlMjAoNSUyQyUyMDEwKSklMkMlMjAoJyVDNCVBMHByZSclMkMlMjAoMTAlMkMlMjAxNCkpJTJDJTIwKCctJyUyQyUyMCgxNCUyQyUyMDE1KSklMkMlMEElMjAoJ3Rva2VuaXphdGlvbiclMkMlMjAoMTUlMkMlMjAyNykpJTJDJTIwKCchJyUyQyUyMCgyNyUyQyUyMDI4KSklNUQ=",highlighted:`[(<span class="hljs-string">&#x27;Let&#x27;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">3</span>)), (<span class="hljs-string">&quot;&#x27;s&quot;</span>, (<span class="hljs-number">3</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;Ġtest&#x27;</span>, (<span class="hljs-number">5</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;Ġpre&#x27;</span>, (<span class="hljs-number">10</span>, <span class="hljs-number">14</span>)), (<span class="hljs-string">&#x27;-&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">15</span>)),
 (<span class="hljs-string">&#x27;tokenization&#x27;</span>, (<span class="hljs-number">15</span>, <span class="hljs-number">27</span>)), (<span class="hljs-string">&#x27;!&#x27;</span>, (<span class="hljs-number">27</span>, <span class="hljs-number">28</span>))]`,wrap:!1}}),os=new y({props:{code:"dHJhaW5lciUyMCUzRCUyMHRyYWluZXJzLkJwZVRyYWluZXIodm9jYWJfc2l6ZSUzRDI1MDAwJTJDJTIwc3BlY2lhbF90b2tlbnMlM0QlNUIlMjIlM0MlN0NlbmRvZnRleHQlN0MlM0UlMjIlNUQpJTBBdG9rZW5pemVyLnRyYWluX2Zyb21faXRlcmF0b3IoZ2V0X3RyYWluaW5nX2NvcnB1cygpJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:`trainer = trainers.BpeTrainer(vocab_size=<span class="hljs-number">25000</span>, special_tokens=[<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>])
tokenizer.train_from_iterator(get_training_corpus(), trainer=trainer)`,wrap:!1}}),is=new y({props:{code:"dG9rZW5pemVyLm1vZGVsJTIwJTNEJTIwbW9kZWxzLkJQRSgpJTBBdG9rZW5pemVyLnRyYWluKCU1QiUyMndpa2l0ZXh0LTIudHh0JTIyJTVEJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:`tokenizer.model = models.BPE()
tokenizer.train([<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>], trainer=trainer)`,wrap:!1}}),ms=new y({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQSUyMyUyMHByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-comment"># print(encoding.tokens)</span>`,wrap:!1}}),Ms=new y({props:{code:"JTVCJ0wnJTJDJTIwJ2V0JyUyQyUyMCUyMiclMjIlMkMlMjAncyclMkMlMjAnJUM0JUEwdGVzdCclMkMlMjAnJUM0JUEwdGhpcyclMkMlMjAnJUM0JUEwdG8nJTJDJTIwJ2tlbiclMkMlMjAnaXplciclMkMlMjAnLiclNUQ=",highlighted:'[<span class="hljs-string">&#x27;L&#x27;</span>, <span class="hljs-string">&#x27;et&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;Ġtest&#x27;</span>, <span class="hljs-string">&#x27;Ġthis&#x27;</span>, <span class="hljs-string">&#x27;Ġto&#x27;</span>, <span class="hljs-string">&#x27;ken&#x27;</span>, <span class="hljs-string">&#x27;izer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),ds=new y({props:{code:"dG9rZW5pemVyLnBvc3RfcHJvY2Vzc29yJTIwJTNEJTIwcHJvY2Vzc29ycy5CeXRlTGV2ZWwodHJpbV9vZmZzZXRzJTNERmFsc2Up",highlighted:'tokenizer.post_processor = processors.ByteLevel(trim_offsets=<span class="hljs-literal">False</span>)',wrap:!1}}),Js=new y({props:{code:"c2VudGVuY2UlMjAlM0QlMjAlMjJMZXQncyUyMHRlc3QlMjB0aGlzJTIwdG9rZW5pemVyLiUyMiUwQWVuY29kaW5nJTIwJTNEJTIwdG9rZW5pemVyLmVuY29kZShzZW50ZW5jZSklMEFzdGFydCUyQyUyMGVuZCUyMCUzRCUyMGVuY29kaW5nLm9mZnNldHMlNUI0JTVEJTBBc2VudGVuY2UlNUJzdGFydCUzQWVuZCU1RA==",highlighted:`sentence = <span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>
encoding = tokenizer.encode(sentence)
start, end = encoding.offsets[<span class="hljs-number">4</span>]
sentence[start:end]`,wrap:!1}}),js=new y({props:{code:"JyUyMHRlc3Qn",highlighted:'<span class="hljs-string">&#x27; test&#x27;</span>',wrap:!1}}),ks=new y({props:{code:"dG9rZW5pemVyLmRlY29kZXIlMjAlM0QlMjBkZWNvZGVycy5CeXRlTGV2ZWwoKQ==",highlighted:"tokenizer.decoder = decoders.ByteLevel()",wrap:!1}}),bs=new y({props:{code:"dG9rZW5pemVyLmRlY29kZShlbmNvZGluZy5pZHMp",highlighted:"tokenizer.decode(encoding.ids)",wrap:!1}}),Us=new y({props:{code:"JTIyTGV0J3MlMjB0ZXN0JTIwdGhpcyUyMHRva2VuaXplci4lMjI=",highlighted:'<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>',wrap:!1}}),gs=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBQcmVUcmFpbmVkVG9rZW5pemVyRmFzdCglMEElMjAlMjAlMjAlMjB0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwYm9zX3Rva2VuJTNEJTIyJTNDJTdDZW5kb2Z0ZXh0JTdDJTNFJTIyJTJDJTBBJTIwJTIwJTIwJTIwZW9zX3Rva2VuJTNEJTIyJTNDJTdDZW5kb2Z0ZXh0JTdDJTNFJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedTokenizerFast

wrapped_tokenizer = PreTrainedTokenizerFast(
    tokenizer_object=tokenizer,
    bos_token=<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>,
    eos_token=<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>,
)`,wrap:!1}}),hs=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdQVDJUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBHUFQyVG9rZW5pemVyRmFzdCh0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2TokenizerFast

wrapped_tokenizer = GPT2TokenizerFast(tokenizer_object=tokenizer)`,wrap:!1}}),zs=new Ml({props:{title:"Construyendo un tokenizador Unigran desde cero",local:"building-a-unigram-tokenizer-from-scratch",headingTag:"h2"}}),Cs=new y({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwVG9rZW5pemVyKG1vZGVscy5VbmlncmFtKCkp",highlighted:"tokenizer = Tokenizer(models.Unigram())",wrap:!1}}),qs=new y({props:{code:"ZnJvbSUyMHRva2VuaXplcnMlMjBpbXBvcnQlMjBSZWdleCUwQSUwQXRva2VuaXplci5ub3JtYWxpemVyJTIwJTNEJTIwbm9ybWFsaXplcnMuU2VxdWVuY2UoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9ybWFsaXplcnMuUmVwbGFjZSglMjIlNjAlNjAlMjIlMkMlMjAnJTIyJyklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub3JtYWxpemVycy5SZXBsYWNlKCUyMicnJTIyJTJDJTIwJyUyMicpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9ybWFsaXplcnMuTkZLRCgpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9ybWFsaXplcnMuU3RyaXBBY2NlbnRzKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub3JtYWxpemVycy5SZXBsYWNlKFJlZ2V4KCUyMiUyMCU3QjIlMkMlN0QlMjIpJTJDJTIwJTIyJTIwJTIyKSUyQyUwQSUyMCUyMCUyMCUyMCU1RCUwQSk=",highlighted:`<span class="hljs-keyword">from</span> tokenizers <span class="hljs-keyword">import</span> Regex

tokenizer.normalizer = normalizers.<span class="hljs-type">Sequence</span>(
    [
        normalizers.Replace(<span class="hljs-string">&quot;\`\`&quot;</span>, <span class="hljs-string">&#x27;&quot;&#x27;</span>),
        normalizers.Replace(<span class="hljs-string">&quot;&#x27;&#x27;&quot;</span>, <span class="hljs-string">&#x27;&quot;&#x27;</span>),
        normalizers.NFKD(),
        normalizers.StripAccents(),
        normalizers.Replace(Regex(<span class="hljs-string">&quot; {2,}&quot;</span>), <span class="hljs-string">&quot; &quot;</span>),
    ]
)`,wrap:!1}}),_s=new y({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5NZXRhc3BhY2UoKQ==",highlighted:"tokenizer.pre_tokenizer = pre_tokenizers.Metaspace()",wrap:!1}}),Ws=new y({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIucHJlX3Rva2VuaXplX3N0ciglMjJMZXQncyUyMHRlc3QlMjB0aGUlMjBwcmUtdG9rZW5pemVyISUyMik=",highlighted:'tokenizer.pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test the pre-tokenizer!&quot;</span>)',wrap:!1}}),As=new y({props:{code:"JTVCKCUyMiVFMiU5NiU4MUxldCdzJTIyJTJDJTIwKDAlMkMlMjA1KSklMkMlMjAoJyVFMiU5NiU4MXRlc3QnJTJDJTIwKDUlMkMlMjAxMCkpJTJDJTIwKCclRTIlOTYlODF0aGUnJTJDJTIwKDEwJTJDJTIwMTQpKSUyQyUyMCgnJUUyJTk2JTgxcHJlLXRva2VuaXplciEnJTJDJTIwKDE0JTJDJTIwMjkpKSU1RA==",highlighted:'[(<span class="hljs-string">&quot;▁Let&#x27;s&quot;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;▁test&#x27;</span>, (<span class="hljs-number">5</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;▁the&#x27;</span>, (<span class="hljs-number">10</span>, <span class="hljs-number">14</span>)), (<span class="hljs-string">&#x27;▁pre-tokenizer!&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">29</span>))]',wrap:!1}}),Ns=new y({props:{code:"c3BlY2lhbF90b2tlbnMlMjAlM0QlMjAlNUIlMjIlM0NjbHMlM0UlMjIlMkMlMjAlMjIlM0NzZXAlM0UlMjIlMkMlMjAlMjIlM0N1bmslM0UlMjIlMkMlMjAlMjIlM0NwYWQlM0UlMjIlMkMlMjAlMjIlM0NtYXNrJTNFJTIyJTJDJTIwJTIyJTNDcyUzRSUyMiUyQyUyMCUyMiUzQyUyRnMlM0UlMjIlNUQlMEF0cmFpbmVyJTIwJTNEJTIwdHJhaW5lcnMuVW5pZ3JhbVRyYWluZXIoJTBBJTIwJTIwJTIwJTIwdm9jYWJfc2l6ZSUzRDI1MDAwJTJDJTIwc3BlY2lhbF90b2tlbnMlM0RzcGVjaWFsX3Rva2VucyUyQyUyMHVua190b2tlbiUzRCUyMiUzQ3VuayUzRSUyMiUwQSklMEF0b2tlbml6ZXIudHJhaW5fZnJvbV9pdGVyYXRvcihnZXRfdHJhaW5pbmdfY29ycHVzKCklMkMlMjB0cmFpbmVyJTNEdHJhaW5lcik=",highlighted:`special_tokens = [<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;unk&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;pad&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;mask&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;s&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>]
trainer = trainers.UnigramTrainer(
    vocab_size=<span class="hljs-number">25000</span>, special_tokens=special_tokens, unk_token=<span class="hljs-string">&quot;&lt;unk&gt;&quot;</span>
)
tokenizer.train_from_iterator(get_training_corpus(), trainer=trainer)`,wrap:!1}}),Ls=new y({props:{code:"dG9rZW5pemVyLm1vZGVsJTIwJTNEJTIwbW9kZWxzLlVuaWdyYW0oKSUwQXRva2VuaXplci50cmFpbiglNUIlMjJ3aWtpdGV4dC0yLnR4dCUyMiU1RCUyQyUyMHRyYWluZXIlM0R0cmFpbmVyKQ==",highlighted:`tokenizer.model = models.Unigram()
tokenizer.train([<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>], trainer=trainer)`,wrap:!1}}),Es=new y({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQSUyMyUyMHByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-comment"># print(encoding.tokens)</span>`,wrap:!1}}),Ds=new y({props:{code:"JTVCJyVFMiU5NiU4MUxldCclMkMlMjAlMjInJTIyJTJDJTIwJ3MnJTJDJTIwJyVFMiU5NiU4MXRlc3QnJTJDJTIwJyVFMiU5NiU4MXRoaXMnJTJDJTIwJyVFMiU5NiU4MXRvJyUyQyUyMCdrZW4nJTJDJTIwJ2l6ZXInJTJDJTIwJy4nJTVE",highlighted:'[<span class="hljs-string">&#x27;▁Let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;▁test&#x27;</span>, <span class="hljs-string">&#x27;▁this&#x27;</span>, <span class="hljs-string">&#x27;▁to&#x27;</span>, <span class="hljs-string">&#x27;ken&#x27;</span>, <span class="hljs-string">&#x27;izer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),Ps=new y({props:{code:"Y2xzX3Rva2VuX2lkJTIwJTNEJTIwdG9rZW5pemVyLnRva2VuX3RvX2lkKCUyMiUzQ2NscyUzRSUyMiklMEFzZXBfdG9rZW5faWQlMjAlM0QlMjB0b2tlbml6ZXIudG9rZW5fdG9faWQoJTIyJTNDc2VwJTNFJTIyKSUwQSUyMyUyMHByaW50KGNsc190b2tlbl9pZCUyQyUyMHNlcF90b2tlbl9pZCk=",highlighted:`cls_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>)
sep_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>)
<span class="hljs-comment"># print(cls_token_id, sep_token_id)</span>`,wrap:!1}}),Ys=new y({props:{code:"MCUyMDE=",highlighted:'<span class="hljs-number">0</span> <span class="hljs-number">1</span>',wrap:!1}}),Ks=new y({props:{code:"dG9rZW5pemVyLnBvc3RfcHJvY2Vzc29yJTIwJTNEJTIwcHJvY2Vzc29ycy5UZW1wbGF0ZVByb2Nlc3NpbmcoJTBBJTIwJTIwJTIwJTIwc2luZ2xlJTNEJTIyJTI0QSUzQTAlMjAlM0NzZXAlM0UlM0EwJTIwJTNDY2xzJTNFJTNBMiUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhaXIlM0QlMjIlMjRBJTNBMCUyMCUzQ3NlcCUzRSUzQTAlMjAlMjRCJTNBMSUyMCUzQ3NlcCUzRSUzQTElMjAlM0NjbHMlM0UlM0EyJTIyJTJDJTBBJTIwJTIwJTIwJTIwc3BlY2lhbF90b2tlbnMlM0QlNUIoJTIyJTNDc2VwJTNFJTIyJTJDJTIwc2VwX3Rva2VuX2lkKSUyQyUyMCglMjIlM0NjbHMlM0UlMjIlMkMlMjBjbHNfdG9rZW5faWQpJTVEJTJDJTBBKQ==",highlighted:`tokenizer.post_processor = processors.TemplateProcessing(
    single=<span class="hljs-string">&quot;$A:0 &lt;sep&gt;:0 &lt;cls&gt;:2&quot;</span>,
    pair=<span class="hljs-string">&quot;$A:0 &lt;sep&gt;:0 $B:1 &lt;sep&gt;:1 &lt;cls&gt;:2&quot;</span>,
    special_tokens=[(<span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>, sep_token_id), (<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>, cls_token_id)],
)`,wrap:!1}}),el=new y({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuLi4lMjIlMkMlMjAlMjJvbiUyMGElMjBwYWlyJTIwb2YlMjBzZW50ZW5jZXMhJTIyKSUwQSUyMyUyMHByaW50KGVuY29kaW5nLnRva2VucyklMEElMjMlMjBwcmludChlbmNvZGluZy50eXBlX2lkcyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer...&quot;</span>, <span class="hljs-string">&quot;on a pair of sentences!&quot;</span>)
<span class="hljs-comment"># print(encoding.tokens)</span>
<span class="hljs-comment"># print(encoding.type_ids)</span>`,wrap:!1}}),sl=new y({props:{code:"JTVCJyVFMiU5NiU4MUxldCclMkMlMjAlMjInJTIyJTJDJTIwJ3MnJTJDJTIwJyVFMiU5NiU4MXRlc3QnJTJDJTIwJyVFMiU5NiU4MXRoaXMnJTJDJTIwJyVFMiU5NiU4MXRvJyUyQyUyMCdrZW4nJTJDJTIwJ2l6ZXInJTJDJTIwJy4nJTJDJTIwJy4nJTJDJTIwJy4nJTJDJTIwJyUzQ3NlcCUzRSclMkMlMjAnJUUyJTk2JTgxJyUyQyUyMCdvbiclMkMlMjAnJUUyJTk2JTgxJyUyQyUyMCdhJyUyQyUyMCclRTIlOTYlODFwYWlyJyUyQyUyMCUwQSUyMCUyMCclRTIlOTYlODFvZiclMkMlMjAnJUUyJTk2JTgxc2VudGVuY2UnJTJDJTIwJ3MnJTJDJTIwJyEnJTJDJTIwJyUzQ3NlcCUzRSclMkMlMjAnJTNDY2xzJTNFJyU1RCUwQSU1QjAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAyJTVE",highlighted:`[<span class="hljs-string">&#x27;▁Let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;▁test&#x27;</span>, <span class="hljs-string">&#x27;▁this&#x27;</span>, <span class="hljs-string">&#x27;▁to&#x27;</span>, <span class="hljs-string">&#x27;ken&#x27;</span>, <span class="hljs-string">&#x27;izer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;&lt;sep&gt;&#x27;</span>, <span class="hljs-string">&#x27;▁&#x27;</span>, <span class="hljs-string">&#x27;on&#x27;</span>, <span class="hljs-string">&#x27;▁&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;▁pair&#x27;</span>, 
  <span class="hljs-string">&#x27;▁of&#x27;</span>, <span class="hljs-string">&#x27;▁sentence&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;!&#x27;</span>, <span class="hljs-string">&#x27;&lt;sep&gt;&#x27;</span>, <span class="hljs-string">&#x27;&lt;cls&gt;&#x27;</span>]
[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>]`,wrap:!1}}),tl=new y({props:{code:"dG9rZW5pemVyLmRlY29kZXIlMjAlM0QlMjBkZWNvZGVycy5NZXRhc3BhY2UoKQ==",highlighted:"tokenizer.decoder = decoders.Metaspace()",wrap:!1}}),al=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBQcmVUcmFpbmVkVG9rZW5pemVyRmFzdCglMEElMjAlMjAlMjAlMjB0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwYm9zX3Rva2VuJTNEJTIyJTNDcyUzRSUyMiUyQyUwQSUyMCUyMCUyMCUyMGVvc190b2tlbiUzRCUyMiUzQyUyRnMlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjB1bmtfdG9rZW4lM0QlMjIlM0N1bmslM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBwYWRfdG9rZW4lM0QlMjIlM0NwYWQlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBjbHNfdG9rZW4lM0QlMjIlM0NjbHMlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBzZXBfdG9rZW4lM0QlMjIlM0NzZXAlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXNrX3Rva2VuJTNEJTIyJTNDbWFzayUzRSUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmdfc2lkZSUzRCUyMmxlZnQlMjIlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedTokenizerFast

wrapped_tokenizer = PreTrainedTokenizerFast(
    tokenizer_object=tokenizer,
    bos_token=<span class="hljs-string">&quot;&lt;s&gt;&quot;</span>,
    eos_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>,
    unk_token=<span class="hljs-string">&quot;&lt;unk&gt;&quot;</span>,
    pad_token=<span class="hljs-string">&quot;&lt;pad&gt;&quot;</span>,
    cls_token=<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>,
    sep_token=<span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>,
    mask_token=<span class="hljs-string">&quot;&lt;mask&gt;&quot;</span>,
    padding_side=<span class="hljs-string">&quot;left&quot;</span>,
)`,wrap:!1}}),pl=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFhMTmV0VG9rZW5pemVyRmFzdCUwQSUwQXdyYXBwZWRfdG9rZW5pemVyJTIwJTNEJTIwWExOZXRUb2tlbml6ZXJGYXN0KHRva2VuaXplcl9vYmplY3QlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> XLNetTokenizerFast

wrapped_tokenizer = XLNetTokenizerFast(tokenizer_object=tokenizer)`,wrap:!1}}),il=new Lo({props:{source:"https://github.com/huggingface/course/blob/main/chapters/es/chapter6/8.mdx"}}),{c(){J=o("meta"),f=n(),j=o("p"),cl=n(),i(b.$$.fragment),dl=n(),i(U.$$.fragment),yl=n(),$=o("p"),$.textContent=ra,Jl=n(),g=o("ul"),g.innerHTML=ia,jl=n(),w=o("p"),w.textContent=ca,Tl=n(),T=o("div"),T.innerHTML=ma,kl=n(),h=o("p"),h.innerHTML=Ma,fl=n(),i(x.$$.fragment),bl=n(),z=o("p"),z.innerHTML=ua,Ul=n(),I=o("ul"),I.innerHTML=da,$l=n(),C=o("p"),C.innerHTML=ya,gl=n(),i(v.$$.fragment),wl=n(),Z=o("p"),Z.innerHTML=Ja,hl=n(),i(q.$$.fragment),xl=n(),V=o("p"),V.innerHTML=ja,zl=n(),B=o("p"),B.textContent=Ta,Il=n(),i(_.$$.fragment),Cl=n(),Q=o("p"),Q.textContent=ka,vl=n(),i(W.$$.fragment),Zl=n(),A=o("p"),A.innerHTML=fa,ql=n(),R=o("p"),R.innerHTML=ba,Vl=n(),i(N.$$.fragment),Bl=n(),X=o("p"),X.innerHTML=Ua,_l=n(),G=o("p"),G.innerHTML=$a,Ql=n(),i(L.$$.fragment),Wl=n(),H=o("p"),H.innerHTML=ga,Al=n(),i(E.$$.fragment),Rl=n(),D=o("p"),D.innerHTML=wa,Nl=n(),S=o("p"),S.innerHTML=ha,Xl=n(),i(P.$$.fragment),Gl=n(),i(Y.$$.fragment),Ll=n(),i(k.$$.fragment),Hl=n(),F=o("p"),F.innerHTML=xa,El=n(),i(K.$$.fragment),Dl=n(),O=o("p"),O.textContent=za,Sl=n(),i(ee.$$.fragment),Pl=n(),se=o("p"),se.innerHTML=Ia,Yl=n(),i(le.$$.fragment),Fl=n(),i(te.$$.fragment),Kl=n(),ne=o("p"),ne.innerHTML=Ca,Ol=n(),i(ae.$$.fragment),et=n(),i(oe.$$.fragment),st=n(),pe=o("p"),pe.innerHTML=va,lt=n(),i(re.$$.fragment),tt=n(),i(ie.$$.fragment),nt=n(),ce=o("p"),ce.innerHTML=Za,at=n(),i(me.$$.fragment),ot=n(),Me=o("p"),Me.innerHTML=qa,pt=n(),ue=o("p"),ue.textContent=Va,rt=n(),i(de.$$.fragment),it=n(),ye=o("p"),ye.innerHTML=Ba,ct=n(),i(Je.$$.fragment),mt=n(),je=o("p"),je.textContent=_a,Mt=n(),i(Te.$$.fragment),ut=n(),i(ke.$$.fragment),dt=n(),fe=o("p"),fe.innerHTML=Qa,yt=n(),be=o("p"),be.innerHTML=Wa,Jt=n(),i(Ue.$$.fragment),jt=n(),i($e.$$.fragment),Tt=n(),ge=o("p"),ge.innerHTML=Aa,kt=n(),we=o("p"),we.textContent=Ra,ft=n(),i(he.$$.fragment),bt=n(),xe=o("p"),xe.textContent=Na,Ut=n(),ze=o("p"),ze.textContent=Xa,$t=n(),i(Ie.$$.fragment),gt=n(),i(Ce.$$.fragment),wt=n(),ve=o("p"),ve.textContent=Ga,ht=n(),i(Ze.$$.fragment),xt=n(),i(qe.$$.fragment),zt=n(),Ve=o("p"),Ve.textContent=La,It=n(),i(Be.$$.fragment),Ct=n(),_e=o("p"),_e.innerHTML=Ha,vt=n(),i(Qe.$$.fragment),Zt=n(),i(We.$$.fragment),qt=n(),Ae=o("p"),Ae.textContent=Ea,Vt=n(),i(Re.$$.fragment),Bt=n(),Ne=o("p"),Ne.innerHTML=Da,_t=n(),i(Xe.$$.fragment),Qt=n(),Ge=o("p"),Ge.innerHTML=Sa,Wt=n(),Le=o("p"),Le.innerHTML=Pa,At=n(),i(He.$$.fragment),Rt=n(),Ee=o("p"),Ee.innerHTML=Ya,Nt=n(),i(De.$$.fragment),Xt=n(),Se=o("p"),Se.innerHTML=Fa,Gt=n(),Pe=o("p"),Pe.textContent=Ka,Lt=n(),i(Ye.$$.fragment),Ht=n(),Fe=o("p"),Fe.innerHTML=Oa,Et=n(),i(Ke.$$.fragment),Dt=n(),Oe=o("p"),Oe.innerHTML=eo,St=n(),es=o("p"),es.textContent=so,Pt=n(),i(ss.$$.fragment),Yt=n(),ls=o("p"),ls.innerHTML=lo,Ft=n(),i(ts.$$.fragment),Kt=n(),i(ns.$$.fragment),Ot=n(),as=o("p"),as.textContent=to,en=n(),i(os.$$.fragment),sn=n(),ps=o("p"),ps.innerHTML=no,ln=n(),rs=o("p"),rs.textContent=ao,tn=n(),i(is.$$.fragment),nn=n(),cs=o("p"),cs.textContent=oo,an=n(),i(ms.$$.fragment),on=n(),i(Ms.$$.fragment),pn=n(),us=o("p"),us.textContent=po,rn=n(),i(ds.$$.fragment),cn=n(),ys=o("p"),ys.innerHTML=ro,mn=n(),i(Js.$$.fragment),Mn=n(),i(js.$$.fragment),un=n(),Ts=o("p"),Ts.textContent=io,dn=n(),i(ks.$$.fragment),yn=n(),fs=o("p"),fs.textContent=co,Jn=n(),i(bs.$$.fragment),jn=n(),i(Us.$$.fragment),Tn=n(),$s=o("p"),$s.innerHTML=mo,kn=n(),i(gs.$$.fragment),fn=n(),ws=o("p"),ws.textContent=Mo,bn=n(),i(hs.$$.fragment),Un=n(),xs=o("p"),xs.textContent=uo,$n=n(),i(zs.$$.fragment),gn=n(),Is=o("p"),Is.innerHTML=yo,wn=n(),i(Cs.$$.fragment),hn=n(),vs=o("p"),vs.textContent=Jo,xn=n(),Zs=o("p"),Zs.textContent=jo,zn=n(),i(qs.$$.fragment),In=n(),Vs=o("p"),Vs.innerHTML=To,Cn=n(),Bs=o("p"),Bs.innerHTML=ko,vn=n(),i(_s.$$.fragment),Zn=n(),Qs=o("p"),Qs.textContent=fo,qn=n(),i(Ws.$$.fragment),Vn=n(),i(As.$$.fragment),Bn=n(),Rs=o("p"),Rs.textContent=bo,_n=n(),i(Ns.$$.fragment),Qn=n(),Xs=o("p"),Xs.innerHTML=Uo,Wn=n(),Gs=o("p"),Gs.textContent=$o,An=n(),i(Ls.$$.fragment),Rn=n(),Hs=o("p"),Hs.textContent=go,Nn=n(),i(Es.$$.fragment),Xn=n(),i(Ds.$$.fragment),Gn=n(),Ss=o("p"),Ss.innerHTML=wo,Ln=n(),i(Ps.$$.fragment),Hn=n(),i(Ys.$$.fragment),En=n(),Fs=o("p"),Fs.textContent=ho,Dn=n(),i(Ks.$$.fragment),Sn=n(),Os=o("p"),Os.textContent=xo,Pn=n(),i(el.$$.fragment),Yn=n(),i(sl.$$.fragment),Fn=n(),ll=o("p"),ll.innerHTML=zo,Kn=n(),i(tl.$$.fragment),On=n(),nl=o("p"),nl.innerHTML=Io,ea=n(),i(al.$$.fragment),sa=n(),ol=o("p"),ol.textContent=Co,la=n(),i(pl.$$.fragment),ta=n(),rl=o("p"),rl.textContent=vo,na=n(),i(il.$$.fragment),aa=n(),ml=o("p"),this.h()},l(e){const s=Ao("svelte-u9bgzb",document.head);J=p(s,"META",{name:!0,content:!0}),s.forEach(l),f=a(e),j=p(e,"P",{}),qo(j).forEach(l),cl=a(e),c(b.$$.fragment,e),dl=a(e),c(U.$$.fragment,e),yl=a(e),$=p(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-c4sn0m"&&($.textContent=ra),Jl=a(e),g=p(e,"UL",{"data-svelte-h":!0}),r(g)!=="svelte-1l4zgfg"&&(g.innerHTML=ia),jl=a(e),w=p(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-1hd1nud"&&(w.textContent=ca),Tl=a(e),T=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(T)!=="svelte-oxfng3"&&(T.innerHTML=ma),kl=a(e),h=p(e,"P",{"data-svelte-h":!0}),r(h)!=="svelte-3rersg"&&(h.innerHTML=Ma),fl=a(e),c(x.$$.fragment,e),bl=a(e),z=p(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-9m97yz"&&(z.innerHTML=ua),Ul=a(e),I=p(e,"UL",{"data-svelte-h":!0}),r(I)!=="svelte-17qyz9s"&&(I.innerHTML=da),$l=a(e),C=p(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-tcxtnv"&&(C.innerHTML=ya),gl=a(e),c(v.$$.fragment,e),wl=a(e),Z=p(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-3ymujh"&&(Z.innerHTML=Ja),hl=a(e),c(q.$$.fragment,e),xl=a(e),V=p(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-17hqre7"&&(V.innerHTML=ja),zl=a(e),B=p(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-4mbep7"&&(B.textContent=Ta),Il=a(e),c(_.$$.fragment,e),Cl=a(e),Q=p(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-uc5c5n"&&(Q.textContent=ka),vl=a(e),c(W.$$.fragment,e),Zl=a(e),A=p(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-uoxffv"&&(A.innerHTML=fa),ql=a(e),R=p(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-151zz03"&&(R.innerHTML=ba),Vl=a(e),c(N.$$.fragment,e),Bl=a(e),X=p(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1h6kbn6"&&(X.innerHTML=Ua),_l=a(e),G=p(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-ohnr1y"&&(G.innerHTML=$a),Ql=a(e),c(L.$$.fragment,e),Wl=a(e),H=p(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-6x22b2"&&(H.innerHTML=ga),Al=a(e),c(E.$$.fragment,e),Rl=a(e),D=p(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1bulh92"&&(D.innerHTML=wa),Nl=a(e),S=p(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-4usyfw"&&(S.innerHTML=ha),Xl=a(e),c(P.$$.fragment,e),Gl=a(e),c(Y.$$.fragment,e),Ll=a(e),c(k.$$.fragment,e),Hl=a(e),F=p(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-zkwbvk"&&(F.innerHTML=xa),El=a(e),c(K.$$.fragment,e),Dl=a(e),O=p(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1bykxva"&&(O.textContent=za),Sl=a(e),c(ee.$$.fragment,e),Pl=a(e),se=p(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1k6p1d5"&&(se.innerHTML=Ia),Yl=a(e),c(le.$$.fragment,e),Fl=a(e),c(te.$$.fragment,e),Kl=a(e),ne=p(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1hcqn6e"&&(ne.innerHTML=Ca),Ol=a(e),c(ae.$$.fragment,e),et=a(e),c(oe.$$.fragment,e),st=a(e),pe=p(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1kd2nwi"&&(pe.innerHTML=va),lt=a(e),c(re.$$.fragment,e),tt=a(e),c(ie.$$.fragment,e),nt=a(e),ce=p(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1xv6o2w"&&(ce.innerHTML=Za),at=a(e),c(me.$$.fragment,e),ot=a(e),Me=p(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1yfizye"&&(Me.innerHTML=qa),pt=a(e),ue=p(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-4p4c5w"&&(ue.textContent=Va),rt=a(e),c(de.$$.fragment,e),it=a(e),ye=p(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1rsjop4"&&(ye.innerHTML=Ba),ct=a(e),c(Je.$$.fragment,e),mt=a(e),je=p(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-1fg2k9v"&&(je.textContent=_a),Mt=a(e),c(Te.$$.fragment,e),ut=a(e),c(ke.$$.fragment,e),dt=a(e),fe=p(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1prwuyc"&&(fe.innerHTML=Qa),yt=a(e),be=p(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-1t1my0l"&&(be.innerHTML=Wa),Jt=a(e),c(Ue.$$.fragment,e),jt=a(e),c($e.$$.fragment,e),Tt=a(e),ge=p(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1eny8n0"&&(ge.innerHTML=Aa),kt=a(e),we=p(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-9qx9f3"&&(we.textContent=Ra),ft=a(e),c(he.$$.fragment,e),bt=a(e),xe=p(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-1dwaoft"&&(xe.textContent=Na),Ut=a(e),ze=p(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-1qrqbvr"&&(ze.textContent=Xa),$t=a(e),c(Ie.$$.fragment,e),gt=a(e),c(Ce.$$.fragment,e),wt=a(e),ve=p(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-11qnfdl"&&(ve.textContent=Ga),ht=a(e),c(Ze.$$.fragment,e),xt=a(e),c(qe.$$.fragment,e),zt=a(e),Ve=p(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-1si3276"&&(Ve.textContent=La),It=a(e),c(Be.$$.fragment,e),Ct=a(e),_e=p(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-1nwzuqq"&&(_e.innerHTML=Ha),vt=a(e),c(Qe.$$.fragment,e),Zt=a(e),c(We.$$.fragment,e),qt=a(e),Ae=p(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-1976hlk"&&(Ae.textContent=Ea),Vt=a(e),c(Re.$$.fragment,e),Bt=a(e),Ne=p(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-1pwwmrj"&&(Ne.innerHTML=Da),_t=a(e),c(Xe.$$.fragment,e),Qt=a(e),Ge=p(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-u403ul"&&(Ge.innerHTML=Sa),Wt=a(e),Le=p(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-yt7pq9"&&(Le.innerHTML=Pa),At=a(e),c(He.$$.fragment,e),Rt=a(e),Ee=p(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-160nqc8"&&(Ee.innerHTML=Ya),Nt=a(e),c(De.$$.fragment,e),Xt=a(e),Se=p(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-1lt7h7v"&&(Se.innerHTML=Fa),Gt=a(e),Pe=p(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-p6wmxa"&&(Pe.textContent=Ka),Lt=a(e),c(Ye.$$.fragment,e),Ht=a(e),Fe=p(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-17bt26b"&&(Fe.innerHTML=Oa),Et=a(e),c(Ke.$$.fragment,e),Dt=a(e),Oe=p(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-vexupx"&&(Oe.innerHTML=eo),St=a(e),es=p(e,"P",{"data-svelte-h":!0}),r(es)!=="svelte-1lx47fv"&&(es.textContent=so),Pt=a(e),c(ss.$$.fragment,e),Yt=a(e),ls=p(e,"P",{"data-svelte-h":!0}),r(ls)!=="svelte-1b5szat"&&(ls.innerHTML=lo),Ft=a(e),c(ts.$$.fragment,e),Kt=a(e),c(ns.$$.fragment,e),Ot=a(e),as=p(e,"P",{"data-svelte-h":!0}),r(as)!=="svelte-871h2v"&&(as.textContent=to),en=a(e),c(os.$$.fragment,e),sn=a(e),ps=p(e,"P",{"data-svelte-h":!0}),r(ps)!=="svelte-15d27yh"&&(ps.innerHTML=no),ln=a(e),rs=p(e,"P",{"data-svelte-h":!0}),r(rs)!=="svelte-zcpxbz"&&(rs.textContent=ao),tn=a(e),c(is.$$.fragment,e),nn=a(e),cs=p(e,"P",{"data-svelte-h":!0}),r(cs)!=="svelte-cly4t1"&&(cs.textContent=oo),an=a(e),c(ms.$$.fragment,e),on=a(e),c(Ms.$$.fragment,e),pn=a(e),us=p(e,"P",{"data-svelte-h":!0}),r(us)!=="svelte-4t57mm"&&(us.textContent=po),rn=a(e),c(ds.$$.fragment,e),cn=a(e),ys=p(e,"P",{"data-svelte-h":!0}),r(ys)!=="svelte-1czzrf0"&&(ys.innerHTML=ro),mn=a(e),c(Js.$$.fragment,e),Mn=a(e),c(js.$$.fragment,e),un=a(e),Ts=p(e,"P",{"data-svelte-h":!0}),r(Ts)!=="svelte-liq0jx"&&(Ts.textContent=io),dn=a(e),c(ks.$$.fragment,e),yn=a(e),fs=p(e,"P",{"data-svelte-h":!0}),r(fs)!=="svelte-19w2n2j"&&(fs.textContent=co),Jn=a(e),c(bs.$$.fragment,e),jn=a(e),c(Us.$$.fragment,e),Tn=a(e),$s=p(e,"P",{"data-svelte-h":!0}),r($s)!=="svelte-1w7p86u"&&($s.innerHTML=mo),kn=a(e),c(gs.$$.fragment,e),fn=a(e),ws=p(e,"P",{"data-svelte-h":!0}),r(ws)!=="svelte-a9xxjb"&&(ws.textContent=Mo),bn=a(e),c(hs.$$.fragment,e),Un=a(e),xs=p(e,"P",{"data-svelte-h":!0}),r(xs)!=="svelte-o3khi"&&(xs.textContent=uo),$n=a(e),c(zs.$$.fragment,e),gn=a(e),Is=p(e,"P",{"data-svelte-h":!0}),r(Is)!=="svelte-ln1mp9"&&(Is.innerHTML=yo),wn=a(e),c(Cs.$$.fragment,e),hn=a(e),vs=p(e,"P",{"data-svelte-h":!0}),r(vs)!=="svelte-1jmvbhx"&&(vs.textContent=Jo),xn=a(e),Zs=p(e,"P",{"data-svelte-h":!0}),r(Zs)!=="svelte-160opgk"&&(Zs.textContent=jo),zn=a(e),c(qs.$$.fragment,e),In=a(e),Vs=p(e,"P",{"data-svelte-h":!0}),r(Vs)!=="svelte-1hs9eo0"&&(Vs.innerHTML=To),Cn=a(e),Bs=p(e,"P",{"data-svelte-h":!0}),r(Bs)!=="svelte-tu4mvx"&&(Bs.innerHTML=ko),vn=a(e),c(_s.$$.fragment,e),Zn=a(e),Qs=p(e,"P",{"data-svelte-h":!0}),r(Qs)!=="svelte-1mxfwt5"&&(Qs.textContent=fo),qn=a(e),c(Ws.$$.fragment,e),Vn=a(e),c(As.$$.fragment,e),Bn=a(e),Rs=p(e,"P",{"data-svelte-h":!0}),r(Rs)!=="svelte-zahnm2"&&(Rs.textContent=bo),_n=a(e),c(Ns.$$.fragment,e),Qn=a(e),Xs=p(e,"P",{"data-svelte-h":!0}),r(Xs)!=="svelte-mhtwbj"&&(Xs.innerHTML=Uo),Wn=a(e),Gs=p(e,"P",{"data-svelte-h":!0}),r(Gs)!=="svelte-1qn663c"&&(Gs.textContent=$o),An=a(e),c(Ls.$$.fragment,e),Rn=a(e),Hs=p(e,"P",{"data-svelte-h":!0}),r(Hs)!=="svelte-11n48oa"&&(Hs.textContent=go),Nn=a(e),c(Es.$$.fragment,e),Xn=a(e),c(Ds.$$.fragment,e),Gn=a(e),Ss=p(e,"P",{"data-svelte-h":!0}),r(Ss)!=="svelte-16wn66q"&&(Ss.innerHTML=wo),Ln=a(e),c(Ps.$$.fragment,e),Hn=a(e),c(Ys.$$.fragment,e),En=a(e),Fs=p(e,"P",{"data-svelte-h":!0}),r(Fs)!=="svelte-k790qk"&&(Fs.textContent=ho),Dn=a(e),c(Ks.$$.fragment,e),Sn=a(e),Os=p(e,"P",{"data-svelte-h":!0}),r(Os)!=="svelte-t673wg"&&(Os.textContent=xo),Pn=a(e),c(el.$$.fragment,e),Yn=a(e),c(sl.$$.fragment,e),Fn=a(e),ll=p(e,"P",{"data-svelte-h":!0}),r(ll)!=="svelte-1h1y1uq"&&(ll.innerHTML=zo),Kn=a(e),c(tl.$$.fragment,e),On=a(e),nl=p(e,"P",{"data-svelte-h":!0}),r(nl)!=="svelte-i4yxg4"&&(nl.innerHTML=Io),ea=a(e),c(al.$$.fragment,e),sa=a(e),ol=p(e,"P",{"data-svelte-h":!0}),r(ol)!=="svelte-fa4903"&&(ol.textContent=Co),la=a(e),c(pl.$$.fragment,e),ta=a(e),rl=p(e,"P",{"data-svelte-h":!0}),r(rl)!=="svelte-yoxjt1"&&(rl.textContent=vo),na=a(e),c(il.$$.fragment,e),aa=a(e),ml=p(e,"P",{}),qo(ml).forEach(l),this.h()},h(){pa(J,"name","hf:doc:metadata"),pa(J,"content",Do),pa(T,"class","flex justify-center")},m(e,s){Ro(document.head,J),t(e,f,s),t(e,j,s),t(e,cl,s),m(b,e,s),t(e,dl,s),m(U,e,s),t(e,yl,s),t(e,$,s),t(e,Jl,s),t(e,g,s),t(e,jl,s),t(e,w,s),t(e,Tl,s),t(e,T,s),t(e,kl,s),t(e,h,s),t(e,fl,s),m(x,e,s),t(e,bl,s),t(e,z,s),t(e,Ul,s),t(e,I,s),t(e,$l,s),t(e,C,s),t(e,gl,s),m(v,e,s),t(e,wl,s),t(e,Z,s),t(e,hl,s),m(q,e,s),t(e,xl,s),t(e,V,s),t(e,zl,s),t(e,B,s),t(e,Il,s),m(_,e,s),t(e,Cl,s),t(e,Q,s),t(e,vl,s),m(W,e,s),t(e,Zl,s),t(e,A,s),t(e,ql,s),t(e,R,s),t(e,Vl,s),m(N,e,s),t(e,Bl,s),t(e,X,s),t(e,_l,s),t(e,G,s),t(e,Ql,s),m(L,e,s),t(e,Wl,s),t(e,H,s),t(e,Al,s),m(E,e,s),t(e,Rl,s),t(e,D,s),t(e,Nl,s),t(e,S,s),t(e,Xl,s),m(P,e,s),t(e,Gl,s),m(Y,e,s),t(e,Ll,s),m(k,e,s),t(e,Hl,s),t(e,F,s),t(e,El,s),m(K,e,s),t(e,Dl,s),t(e,O,s),t(e,Sl,s),m(ee,e,s),t(e,Pl,s),t(e,se,s),t(e,Yl,s),m(le,e,s),t(e,Fl,s),m(te,e,s),t(e,Kl,s),t(e,ne,s),t(e,Ol,s),m(ae,e,s),t(e,et,s),m(oe,e,s),t(e,st,s),t(e,pe,s),t(e,lt,s),m(re,e,s),t(e,tt,s),m(ie,e,s),t(e,nt,s),t(e,ce,s),t(e,at,s),m(me,e,s),t(e,ot,s),t(e,Me,s),t(e,pt,s),t(e,ue,s),t(e,rt,s),m(de,e,s),t(e,it,s),t(e,ye,s),t(e,ct,s),m(Je,e,s),t(e,mt,s),t(e,je,s),t(e,Mt,s),m(Te,e,s),t(e,ut,s),m(ke,e,s),t(e,dt,s),t(e,fe,s),t(e,yt,s),t(e,be,s),t(e,Jt,s),m(Ue,e,s),t(e,jt,s),m($e,e,s),t(e,Tt,s),t(e,ge,s),t(e,kt,s),t(e,we,s),t(e,ft,s),m(he,e,s),t(e,bt,s),t(e,xe,s),t(e,Ut,s),t(e,ze,s),t(e,$t,s),m(Ie,e,s),t(e,gt,s),m(Ce,e,s),t(e,wt,s),t(e,ve,s),t(e,ht,s),m(Ze,e,s),t(e,xt,s),m(qe,e,s),t(e,zt,s),t(e,Ve,s),t(e,It,s),m(Be,e,s),t(e,Ct,s),t(e,_e,s),t(e,vt,s),m(Qe,e,s),t(e,Zt,s),m(We,e,s),t(e,qt,s),t(e,Ae,s),t(e,Vt,s),m(Re,e,s),t(e,Bt,s),t(e,Ne,s),t(e,_t,s),m(Xe,e,s),t(e,Qt,s),t(e,Ge,s),t(e,Wt,s),t(e,Le,s),t(e,At,s),m(He,e,s),t(e,Rt,s),t(e,Ee,s),t(e,Nt,s),m(De,e,s),t(e,Xt,s),t(e,Se,s),t(e,Gt,s),t(e,Pe,s),t(e,Lt,s),m(Ye,e,s),t(e,Ht,s),t(e,Fe,s),t(e,Et,s),m(Ke,e,s),t(e,Dt,s),t(e,Oe,s),t(e,St,s),t(e,es,s),t(e,Pt,s),m(ss,e,s),t(e,Yt,s),t(e,ls,s),t(e,Ft,s),m(ts,e,s),t(e,Kt,s),m(ns,e,s),t(e,Ot,s),t(e,as,s),t(e,en,s),m(os,e,s),t(e,sn,s),t(e,ps,s),t(e,ln,s),t(e,rs,s),t(e,tn,s),m(is,e,s),t(e,nn,s),t(e,cs,s),t(e,an,s),m(ms,e,s),t(e,on,s),m(Ms,e,s),t(e,pn,s),t(e,us,s),t(e,rn,s),m(ds,e,s),t(e,cn,s),t(e,ys,s),t(e,mn,s),m(Js,e,s),t(e,Mn,s),m(js,e,s),t(e,un,s),t(e,Ts,s),t(e,dn,s),m(ks,e,s),t(e,yn,s),t(e,fs,s),t(e,Jn,s),m(bs,e,s),t(e,jn,s),m(Us,e,s),t(e,Tn,s),t(e,$s,s),t(e,kn,s),m(gs,e,s),t(e,fn,s),t(e,ws,s),t(e,bn,s),m(hs,e,s),t(e,Un,s),t(e,xs,s),t(e,$n,s),m(zs,e,s),t(e,gn,s),t(e,Is,s),t(e,wn,s),m(Cs,e,s),t(e,hn,s),t(e,vs,s),t(e,xn,s),t(e,Zs,s),t(e,zn,s),m(qs,e,s),t(e,In,s),t(e,Vs,s),t(e,Cn,s),t(e,Bs,s),t(e,vn,s),m(_s,e,s),t(e,Zn,s),t(e,Qs,s),t(e,qn,s),m(Ws,e,s),t(e,Vn,s),m(As,e,s),t(e,Bn,s),t(e,Rs,s),t(e,_n,s),m(Ns,e,s),t(e,Qn,s),t(e,Xs,s),t(e,Wn,s),t(e,Gs,s),t(e,An,s),m(Ls,e,s),t(e,Rn,s),t(e,Hs,s),t(e,Nn,s),m(Es,e,s),t(e,Xn,s),m(Ds,e,s),t(e,Gn,s),t(e,Ss,s),t(e,Ln,s),m(Ps,e,s),t(e,Hn,s),m(Ys,e,s),t(e,En,s),t(e,Fs,s),t(e,Dn,s),m(Ks,e,s),t(e,Sn,s),t(e,Os,s),t(e,Pn,s),m(el,e,s),t(e,Yn,s),m(sl,e,s),t(e,Fn,s),t(e,ll,s),t(e,Kn,s),m(tl,e,s),t(e,On,s),t(e,nl,s),t(e,ea,s),m(al,e,s),t(e,sa,s),t(e,ol,s),t(e,la,s),m(pl,e,s),t(e,ta,s),t(e,rl,s),t(e,na,s),m(il,e,s),t(e,aa,s),t(e,ml,s),oa=!0},p(e,[s]){const Zo={};s&2&&(Zo.$$scope={dirty:s,ctx:e}),k.$set(Zo)},i(e){oa||(M(b.$$.fragment,e),M(U.$$.fragment,e),M(x.$$.fragment,e),M(v.$$.fragment,e),M(q.$$.fragment,e),M(_.$$.fragment,e),M(W.$$.fragment,e),M(N.$$.fragment,e),M(L.$$.fragment,e),M(E.$$.fragment,e),M(P.$$.fragment,e),M(Y.$$.fragment,e),M(k.$$.fragment,e),M(K.$$.fragment,e),M(ee.$$.fragment,e),M(le.$$.fragment,e),M(te.$$.fragment,e),M(ae.$$.fragment,e),M(oe.$$.fragment,e),M(re.$$.fragment,e),M(ie.$$.fragment,e),M(me.$$.fragment,e),M(de.$$.fragment,e),M(Je.$$.fragment,e),M(Te.$$.fragment,e),M(ke.$$.fragment,e),M(Ue.$$.fragment,e),M($e.$$.fragment,e),M(he.$$.fragment,e),M(Ie.$$.fragment,e),M(Ce.$$.fragment,e),M(Ze.$$.fragment,e),M(qe.$$.fragment,e),M(Be.$$.fragment,e),M(Qe.$$.fragment,e),M(We.$$.fragment,e),M(Re.$$.fragment,e),M(Xe.$$.fragment,e),M(He.$$.fragment,e),M(De.$$.fragment,e),M(Ye.$$.fragment,e),M(Ke.$$.fragment,e),M(ss.$$.fragment,e),M(ts.$$.fragment,e),M(ns.$$.fragment,e),M(os.$$.fragment,e),M(is.$$.fragment,e),M(ms.$$.fragment,e),M(Ms.$$.fragment,e),M(ds.$$.fragment,e),M(Js.$$.fragment,e),M(js.$$.fragment,e),M(ks.$$.fragment,e),M(bs.$$.fragment,e),M(Us.$$.fragment,e),M(gs.$$.fragment,e),M(hs.$$.fragment,e),M(zs.$$.fragment,e),M(Cs.$$.fragment,e),M(qs.$$.fragment,e),M(_s.$$.fragment,e),M(Ws.$$.fragment,e),M(As.$$.fragment,e),M(Ns.$$.fragment,e),M(Ls.$$.fragment,e),M(Es.$$.fragment,e),M(Ds.$$.fragment,e),M(Ps.$$.fragment,e),M(Ys.$$.fragment,e),M(Ks.$$.fragment,e),M(el.$$.fragment,e),M(sl.$$.fragment,e),M(tl.$$.fragment,e),M(al.$$.fragment,e),M(pl.$$.fragment,e),M(il.$$.fragment,e),oa=!0)},o(e){u(b.$$.fragment,e),u(U.$$.fragment,e),u(x.$$.fragment,e),u(v.$$.fragment,e),u(q.$$.fragment,e),u(_.$$.fragment,e),u(W.$$.fragment,e),u(N.$$.fragment,e),u(L.$$.fragment,e),u(E.$$.fragment,e),u(P.$$.fragment,e),u(Y.$$.fragment,e),u(k.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(le.$$.fragment,e),u(te.$$.fragment,e),u(ae.$$.fragment,e),u(oe.$$.fragment,e),u(re.$$.fragment,e),u(ie.$$.fragment,e),u(me.$$.fragment,e),u(de.$$.fragment,e),u(Je.$$.fragment,e),u(Te.$$.fragment,e),u(ke.$$.fragment,e),u(Ue.$$.fragment,e),u($e.$$.fragment,e),u(he.$$.fragment,e),u(Ie.$$.fragment,e),u(Ce.$$.fragment,e),u(Ze.$$.fragment,e),u(qe.$$.fragment,e),u(Be.$$.fragment,e),u(Qe.$$.fragment,e),u(We.$$.fragment,e),u(Re.$$.fragment,e),u(Xe.$$.fragment,e),u(He.$$.fragment,e),u(De.$$.fragment,e),u(Ye.$$.fragment,e),u(Ke.$$.fragment,e),u(ss.$$.fragment,e),u(ts.$$.fragment,e),u(ns.$$.fragment,e),u(os.$$.fragment,e),u(is.$$.fragment,e),u(ms.$$.fragment,e),u(Ms.$$.fragment,e),u(ds.$$.fragment,e),u(Js.$$.fragment,e),u(js.$$.fragment,e),u(ks.$$.fragment,e),u(bs.$$.fragment,e),u(Us.$$.fragment,e),u(gs.$$.fragment,e),u(hs.$$.fragment,e),u(zs.$$.fragment,e),u(Cs.$$.fragment,e),u(qs.$$.fragment,e),u(_s.$$.fragment,e),u(Ws.$$.fragment,e),u(As.$$.fragment,e),u(Ns.$$.fragment,e),u(Ls.$$.fragment,e),u(Es.$$.fragment,e),u(Ds.$$.fragment,e),u(Ps.$$.fragment,e),u(Ys.$$.fragment,e),u(Ks.$$.fragment,e),u(el.$$.fragment,e),u(sl.$$.fragment,e),u(tl.$$.fragment,e),u(al.$$.fragment,e),u(pl.$$.fragment,e),u(il.$$.fragment,e),oa=!1},d(e){e&&(l(f),l(j),l(cl),l(dl),l(yl),l($),l(Jl),l(g),l(jl),l(w),l(Tl),l(T),l(kl),l(h),l(fl),l(bl),l(z),l(Ul),l(I),l($l),l(C),l(gl),l(wl),l(Z),l(hl),l(xl),l(V),l(zl),l(B),l(Il),l(Cl),l(Q),l(vl),l(Zl),l(A),l(ql),l(R),l(Vl),l(Bl),l(X),l(_l),l(G),l(Ql),l(Wl),l(H),l(Al),l(Rl),l(D),l(Nl),l(S),l(Xl),l(Gl),l(Ll),l(Hl),l(F),l(El),l(Dl),l(O),l(Sl),l(Pl),l(se),l(Yl),l(Fl),l(Kl),l(ne),l(Ol),l(et),l(st),l(pe),l(lt),l(tt),l(nt),l(ce),l(at),l(ot),l(Me),l(pt),l(ue),l(rt),l(it),l(ye),l(ct),l(mt),l(je),l(Mt),l(ut),l(dt),l(fe),l(yt),l(be),l(Jt),l(jt),l(Tt),l(ge),l(kt),l(we),l(ft),l(bt),l(xe),l(Ut),l(ze),l($t),l(gt),l(wt),l(ve),l(ht),l(xt),l(zt),l(Ve),l(It),l(Ct),l(_e),l(vt),l(Zt),l(qt),l(Ae),l(Vt),l(Bt),l(Ne),l(_t),l(Qt),l(Ge),l(Wt),l(Le),l(At),l(Rt),l(Ee),l(Nt),l(Xt),l(Se),l(Gt),l(Pe),l(Lt),l(Ht),l(Fe),l(Et),l(Dt),l(Oe),l(St),l(es),l(Pt),l(Yt),l(ls),l(Ft),l(Kt),l(Ot),l(as),l(en),l(sn),l(ps),l(ln),l(rs),l(tn),l(nn),l(cs),l(an),l(on),l(pn),l(us),l(rn),l(cn),l(ys),l(mn),l(Mn),l(un),l(Ts),l(dn),l(yn),l(fs),l(Jn),l(jn),l(Tn),l($s),l(kn),l(fn),l(ws),l(bn),l(Un),l(xs),l($n),l(gn),l(Is),l(wn),l(hn),l(vs),l(xn),l(Zs),l(zn),l(In),l(Vs),l(Cn),l(Bs),l(vn),l(Zn),l(Qs),l(qn),l(Vn),l(Bn),l(Rs),l(_n),l(Qn),l(Xs),l(Wn),l(Gs),l(An),l(Rn),l(Hs),l(Nn),l(Xn),l(Gn),l(Ss),l(Ln),l(Hn),l(En),l(Fs),l(Dn),l(Sn),l(Os),l(Pn),l(Yn),l(Fn),l(ll),l(Kn),l(On),l(nl),l(ea),l(sa),l(ol),l(la),l(ta),l(rl),l(na),l(aa),l(ml)),l(J),d(b,e),d(U,e),d(x,e),d(v,e),d(q,e),d(_,e),d(W,e),d(N,e),d(L,e),d(E,e),d(P,e),d(Y,e),d(k,e),d(K,e),d(ee,e),d(le,e),d(te,e),d(ae,e),d(oe,e),d(re,e),d(ie,e),d(me,e),d(de,e),d(Je,e),d(Te,e),d(ke,e),d(Ue,e),d($e,e),d(he,e),d(Ie,e),d(Ce,e),d(Ze,e),d(qe,e),d(Be,e),d(Qe,e),d(We,e),d(Re,e),d(Xe,e),d(He,e),d(De,e),d(Ye,e),d(Ke,e),d(ss,e),d(ts,e),d(ns,e),d(os,e),d(is,e),d(ms,e),d(Ms,e),d(ds,e),d(Js,e),d(js,e),d(ks,e),d(bs,e),d(Us,e),d(gs,e),d(hs,e),d(zs,e),d(Cs,e),d(qs,e),d(_s,e),d(Ws,e),d(As,e),d(Ns,e),d(Ls,e),d(Es,e),d(Ds,e),d(Ps,e),d(Ys,e),d(Ks,e),d(el,e),d(sl,e),d(tl,e),d(al,e),d(pl,e),d(il,e)}}}const Do='{"title":"Construir un tokenizador, bloque por bloque","local":"building-a-tokenizer-block-by-block","sections":[{"title":"Adquirir un corpus","local":"acquiring-a-corpus","sections":[],"depth":2},{"title":"Construyendo un tokenizador WordPiece desde cero","local":"building-a-wordpiece-tokenizer-from-scratch","sections":[],"depth":2},{"title":"Construyendo un tokenizador BPE desde cero","local":"building-a-bpe-tokenizer-from-scratch","sections":[],"depth":2},{"title":"Construyendo un tokenizador Unigran desde cero","local":"building-a-unigram-tokenizer-from-scratch","sections":[],"depth":2}],"depth":1}';function So(ul){return Bo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class tp extends Qo{constructor(J){super(),Wo(this,J,So,Eo,Vo,{})}}export{tp as component};
