import{s as Jt,o as Ut,n as Tt}from"../chunks/scheduler.37c15a92.js";import{S as ft,i as Ct,g as m,s as a,r as i,A as gt,h as d,f as t,c as n,j as ut,u as o,x as y,k as wt,y as Zt,a as s,v as p,d as r,t as M,w as c,m as kt,n as It}from"../chunks/index.7cb9c9b8.js";import{T as bt}from"../chunks/Tip.d10b3fc9.js";import{Y as jt}from"../chunks/Youtube.8666c400.js";import{C as h}from"../chunks/CodeBlock.abae2786.js";import{C as Bt}from"../chunks/CourseFloatingBanner.df82c153.js";import{H as $e,E as $t}from"../chunks/index.71125d44.js";function Gt(ke){let u,w="✏️ <strong>Try it out!</strong> Modify the previous training loop to fine-tune your model on the SST-2 dataset.";return{c(){u=m("p"),u.innerHTML=w},l(b){u=d(b,"P",{"data-svelte-h":!0}),y(u)!=="svelte-14jbd71"&&(u.innerHTML=w)},m(b,Ie){s(b,u,Ie)},p:Tt,d(b){b&&t(u)}}}function Wt(ke){let u;return{c(){u=kt('⚠️ In order to benefit from the speed-up offered by Cloud TPUs, we recommend padding your samples to a fixed length with the `padding="max_length"` and `max_length` arguments of the tokenizer.')},l(w){u=It(w,'⚠️ In order to benefit from the speed-up offered by Cloud TPUs, we recommend padding your samples to a fixed length with the `padding="max_length"` and `max_length` arguments of the tokenizer.')},m(w,b){s(w,u,b)},d(w){w&&t(u)}}}function Xt(ke){let u,w,b,Ie,U,Ge,T,We,f,Xe,C,Nl="Now we’ll see how to achieve the same results as we did in the last section without using the <code>Trainer</code> class. Again, we assume you have done the data processing in section 2. Here is a short summary covering everything you will need:",ve,g,Re,Z,_e,k,zl="Before actually writing our training loop, we will need to define a few objects. The first ones are the dataloaders we will use to iterate over batches. But before we can define those dataloaders, we need to apply a bit of postprocessing to our <code>tokenized_datasets</code>, to take care of some things that the <code>Trainer</code> did for us automatically. Specifically, we need to:",Ye,I,El="<li>Remove the columns corresponding to values the model does not expect (like the <code>sentence1</code> and <code>sentence2</code> columns).</li> <li>Rename the column <code>label</code> to <code>labels</code> (because the model expects the argument to be named <code>labels</code>).</li> <li>Set the format of the datasets so they return PyTorch tensors instead of lists.</li>",Ae,B,Fl="Our <code>tokenized_datasets</code> has one method for each of those steps:",Ve,$,Ne,G,xl="We can then check that the result only has columns that our model will accept:",ze,W,Ee,X,Ql="Now that this is done, we can easily define our dataloaders:",Fe,v,xe,R,Hl="To quickly check there is no mistake in the data processing, we can inspect a batch like this:",Qe,_,He,Y,Se,A,Sl="Note that the actual shapes will probably be slightly different for you since we set <code>shuffle=True</code> for the training dataloader and we are padding to the maximum length inside the batch.",qe,V,ql="Now that we’re completely finished with data preprocessing (a satisfying yet elusive goal for any ML practitioner), let’s turn to the model. We instantiate it exactly as we did in the previous section:",Le,N,Ke,z,Ll="To make sure that everything will go smoothly during training, we pass our batch to this model:",De,E,Pe,F,Oe,x,Kl="All 🤗 Transformers models will return the loss when <code>labels</code> are provided, and we also get the logits (two for each input in our batch, so a tensor of size 8 x 2).",el,Q,Dl='We’re almost ready to write our training loop! We’re just missing two things: an optimizer and a learning rate scheduler. Since we are trying to replicate what the <code>Trainer</code> was doing by hand, we will use the same defaults. The optimizer used by the <code>Trainer</code> is <code>AdamW</code>, which is the same as Adam, but with a twist for weight decay regularization (see <a href="https://arxiv.org/abs/1711.05101" rel="nofollow">“Decoupled Weight Decay Regularization”</a> by Ilya Loshchilov and Frank Hutter):',ll,H,tl,S,Pl="Finally, the learning rate scheduler used by default is just a linear decay from the maximum value (5e-5) to 0. To properly define it, we need to know the number of training steps we will take, which is the number of epochs we want to run multiplied by the number of training batches (which is the length of our training dataloader). The <code>Trainer</code> uses three epochs by default, so we will follow that:",sl,q,al,L,nl,K,il,D,Ol="One last thing: we will want to use the GPU if we have access to one (on a CPU, training might take several hours instead of a couple of minutes). To do this, we define a <code>device</code> we will put our model and our batches on:",ol,P,pl,O,rl,ee,et="We are now ready to train! To get some sense of when training will be finished, we add a progress bar over our number of training steps, using the <code>tqdm</code> library:",Ml,le,cl,te,lt="You can see that the core of the training loop looks a lot like the one in the introduction. We didn’t ask for any reporting, so this training loop will not tell us anything about how the model fares. We need to add an evaluation loop for that.",ml,se,dl,ae,tt="As we did earlier, we will use a metric provided by the 🤗 Evaluate library. We’ve already seen the <code>metric.compute()</code> method, but metrics can actually accumulate batches for us as we go over the prediction loop with the method <code>add_batch()</code>. Once we have accumulated all the batches, we can get the final result with <code>metric.compute()</code>. Here’s how to implement all of this in an evaluation loop:",yl,ne,hl,ie,ul,oe,st="Again, your results will be slightly different because of the randomness in the model head initialization and the data shuffling, but they should be in the same ballpark.",wl,j,bl,pe,jl,re,Jl,Me,at='The training loop we defined earlier works fine on a single CPU or GPU. But using the <a href="https://github.com/huggingface/accelerate" rel="nofollow">🤗 Accelerate</a> library, with just a few adjustments we can enable distributed training on multiple GPUs or TPUs. Starting from the creation of the training and validation dataloaders, here is what our manual training loop looks like:',Ul,ce,Tl,me,nt="And here are the changes:",fl,de,Cl,ye,it="The first line to add is the import line. The second line instantiates an <code>Accelerator</code> object that will look at the environment and initialize the proper distributed setup. 🤗 Accelerate handles the device placement for you, so you can remove the lines that put the model on the device (or, if you prefer, change them to use <code>accelerator.device</code> instead of <code>device</code>).",gl,he,ot="Then the main bulk of the work is done in the line that sends the dataloaders, the model, and the optimizer to <code>accelerator.prepare()</code>. This will wrap those objects in the proper container to make sure your distributed training works as intended. The remaining changes to make are removing the line that puts the batch on the <code>device</code> (again, if you want to keep this you can just change it to use <code>accelerator.device</code>) and replacing <code>loss.backward()</code> with <code>accelerator.backward(loss)</code>.",Zl,J,kl,ue,pt="If you’d like to copy and paste it to play around, here’s what the complete training loop looks like with 🤗 Accelerate:",Il,we,Bl,be,rt="Putting this in a <code>train.py</code> script will make that script runnable on any kind of distributed setup. To try it out in your distributed setup, run the command:",$l,je,Gl,Je,Mt="which will prompt you to answer a few questions and dump your answers in a configuration file used by this command:",Wl,Ue,Xl,Te,ct="which will launch the distributed training.",vl,fe,mt="If you want to try this in a Notebook (for instance, to test it with TPUs on Colab), just paste the code in a <code>training_function()</code> and run a last cell with:",Rl,Ce,_l,ge,dt='You can find more examples in the <a href="https://github.com/huggingface/accelerate/tree/main/examples" rel="nofollow">🤗 Accelerate repo</a>.',Yl,Ze,Al,Be,Vl;return U=new $e({props:{title:"A full training",local:"a-full-training",headingTag:"h1"}}),T=new Bt({props:{chapter:3,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter3/section4.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter3/section4.ipynb"}]}}),f=new jt({props:{id:"Dh9CL8fyG80"}}),g=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyUwQSUwQXJhd19kYXRhc2V0cyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQSUwQWRlZiUyMHRva2VuaXplX2Z1bmN0aW9uKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGV4YW1wbGUlNUIlMjJzZW50ZW5jZTElMjIlNUQlMkMlMjBleGFtcGxlJTVCJTIyc2VudGVuY2UyJTIyJTVEJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpJTBBJTBBJTBBdG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwcmF3X2RhdGFzZXRzLm1hcCh0b2tlbml6ZV9mdW5jdGlvbiUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQWRhdGFfY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyh0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, DataCollatorWithPadding

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
checkpoint = <span class="hljs-string">&quot;bert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_function</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> tokenizer(example[<span class="hljs-string">&quot;sentence1&quot;</span>], example[<span class="hljs-string">&quot;sentence2&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(tokenize_function, batched=<span class="hljs-literal">True</span>)
data_collator = DataCollatorWithPadding(tokenizer=tokenizer)`,wrap:!1}}),Z=new $e({props:{title:"Prepare for training",local:"prepare-for-training",headingTag:"h3"}}),$=new h({props:{code:"dG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwdG9rZW5pemVkX2RhdGFzZXRzLnJlbW92ZV9jb2x1bW5zKCU1QiUyMnNlbnRlbmNlMSUyMiUyQyUyMCUyMnNlbnRlbmNlMiUyMiUyQyUyMCUyMmlkeCUyMiU1RCklMEF0b2tlbml6ZWRfZGF0YXNldHMlMjAlM0QlMjB0b2tlbml6ZWRfZGF0YXNldHMucmVuYW1lX2NvbHVtbiglMjJsYWJlbCUyMiUyQyUyMCUyMmxhYmVscyUyMiklMEF0b2tlbml6ZWRfZGF0YXNldHMuc2V0X2Zvcm1hdCglMjJ0b3JjaCUyMiklMEF0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ0cmFpbiUyMiU1RC5jb2x1bW5fbmFtZXM=",highlighted:`tokenized_datasets = tokenized_datasets.remove_columns([<span class="hljs-string">&quot;sentence1&quot;</span>, <span class="hljs-string">&quot;sentence2&quot;</span>, <span class="hljs-string">&quot;idx&quot;</span>])
tokenized_datasets = tokenized_datasets.rename_column(<span class="hljs-string">&quot;label&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>)
tokenized_datasets.set_format(<span class="hljs-string">&quot;torch&quot;</span>)
tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>].column_names`,wrap:!1}}),W=new h({props:{code:"JTVCJTIyYXR0ZW50aW9uX21hc2slMjIlMkMlMjAlMjJpbnB1dF9pZHMlMjIlMkMlMjAlMjJsYWJlbHMlMjIlMkMlMjAlMjJ0b2tlbl90eXBlX2lkcyUyMiU1RA==",highlighted:'[<span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>, <span class="hljs-string">&quot;token_type_ids&quot;</span>]',wrap:!1}}),v=new h({props:{code:"ZnJvbSUyMHRvcmNoLnV0aWxzLmRhdGElMjBpbXBvcnQlMjBEYXRhTG9hZGVyJTBBJTBBdHJhaW5fZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIoJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMjBzaHVmZmxlJTNEVHJ1ZSUyQyUyMGJhdGNoX3NpemUlM0Q4JTJDJTIwY29sbGF0ZV9mbiUzRGRhdGFfY29sbGF0b3IlMEEpJTBBZXZhbF9kYXRhbG9hZGVyJTIwJTNEJTIwRGF0YUxvYWRlciglMEElMjAlMjAlMjAlMjB0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTIwYmF0Y2hfc2l6ZSUzRDglMkMlMjBjb2xsYXRlX2ZuJTNEZGF0YV9jb2xsYXRvciUwQSk=",highlighted:`<span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader

train_dataloader = DataLoader(
    tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>], shuffle=<span class="hljs-literal">True</span>, batch_size=<span class="hljs-number">8</span>, collate_fn=data_collator
)
eval_dataloader = DataLoader(
    tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>], batch_size=<span class="hljs-number">8</span>, collate_fn=data_collator
)`,wrap:!1}}),_=new h({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjBicmVhayUwQSU3QmslM0ElMjB2LnNoYXBlJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0Q=",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
    <span class="hljs-keyword">break</span>
{k: v.shape <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}`,wrap:!1}}),Y=new h({props:{code:"JTdCJ2F0dGVudGlvbl9tYXNrJyUzQSUyMHRvcmNoLlNpemUoJTVCOCUyQyUyMDY1JTVEKSUyQyUwQSUyMCdpbnB1dF9pZHMnJTNBJTIwdG9yY2guU2l6ZSglNUI4JTJDJTIwNjUlNUQpJTJDJTBBJTIwJ2xhYmVscyclM0ElMjB0b3JjaC5TaXplKCU1QjglNUQpJTJDJTBBJTIwJ3Rva2VuX3R5cGVfaWRzJyUzQSUyMHRvcmNoLlNpemUoJTVCOCUyQyUyMDY1JTVEKSU3RA==",highlighted:`{<span class="hljs-string">&#x27;attention_mask&#x27;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>]),
 <span class="hljs-string">&#x27;input_ids&#x27;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>]),
 <span class="hljs-string">&#x27;labels&#x27;</span>: torch.Size([<span class="hljs-number">8</span>]),
 <span class="hljs-string">&#x27;token_type_ids&#x27;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>])}`,wrap:!1}}),N=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)`,wrap:!1}}),E=new h({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqYmF0Y2gpJTBBcHJpbnQob3V0cHV0cy5sb3NzJTJDJTIwb3V0cHV0cy5sb2dpdHMuc2hhcGUp",highlighted:`outputs = model(**batch)
<span class="hljs-built_in">print</span>(outputs.loss, outputs.logits.shape)`,wrap:!1}}),F=new h({props:{code:"dGVuc29yKDAuNTQ0MSUyQyUyMGdyYWRfZm4lM0QlM0NObGxMb3NzQmFja3dhcmQlM0UpJTIwdG9yY2guU2l6ZSglNUI4JTJDJTIwMiU1RCk=",highlighted:'tensor(<span class="hljs-number">0.5441</span>, grad_fn=&lt;NllLossBackward&gt;) torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">2</span>])',wrap:!1}}),H=new h({props:{code:"ZnJvbSUyMHRvcmNoLm9wdGltJTIwaW1wb3J0JTIwQWRhbVclMEElMEFvcHRpbWl6ZXIlMjAlM0QlMjBBZGFtVyhtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBsciUzRDVlLTUp",highlighted:`<span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW

optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">5e-5</span>)`,wrap:!1}}),q=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGdldF9zY2hlZHVsZXIlMEElMEFudW1fZXBvY2hzJTIwJTNEJTIwMyUwQW51bV90cmFpbmluZ19zdGVwcyUyMCUzRCUyMG51bV9lcG9jaHMlMjAqJTIwbGVuKHRyYWluX2RhdGFsb2FkZXIpJTBBbHJfc2NoZWR1bGVyJTIwJTNEJTIwZ2V0X3NjaGVkdWxlciglMEElMjAlMjAlMjAlMjAlMjJsaW5lYXIlMjIlMkMlMEElMjAlMjAlMjAlMjBvcHRpbWl6ZXIlM0RvcHRpbWl6ZXIlMkMlMEElMjAlMjAlMjAlMjBudW1fd2FybXVwX3N0ZXBzJTNEMCUyQyUwQSUyMCUyMCUyMCUyMG51bV90cmFpbmluZ19zdGVwcyUzRG51bV90cmFpbmluZ19zdGVwcyUyQyUwQSklMEFwcmludChudW1fdHJhaW5pbmdfc3RlcHMp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> get_scheduler

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dataloader)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)
<span class="hljs-built_in">print</span>(num_training_steps)`,wrap:!1}}),L=new h({props:{code:"MTM3Nw==",highlighted:'<span class="hljs-number">1377</span>',wrap:!1}}),K=new $e({props:{title:"The training loop",local:"the-training-loop",headingTag:"h3"}}),P=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFkZXZpY2UlMjAlM0QlMjB0b3JjaC5kZXZpY2UoJTIyY3VkYSUyMiklMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwdG9yY2guZGV2aWNlKCUyMmNwdSUyMiklMEFtb2RlbC50byhkZXZpY2UpJTBBZGV2aWNl",highlighted:`<span class="hljs-keyword">import</span> torch

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)
model.to(device)
device`,wrap:!1}}),O=new h({props:{code:"ZGV2aWNlKHR5cGUlM0QnY3VkYScp",highlighted:'device(<span class="hljs-built_in">type</span>=<span class="hljs-string">&#x27;cuda&#x27;</span>)',wrap:!1}}),le=new h({props:{code:"ZnJvbSUyMHRxZG0uYXV0byUyMGltcG9ydCUyMHRxZG0lMEElMEFwcm9ncmVzc19iYXIlMjAlM0QlMjB0cWRtKHJhbmdlKG51bV90cmFpbmluZ19zdGVwcykpJTBBJTBBbW9kZWwudHJhaW4oKSUwQWZvciUyMGVwb2NoJTIwaW4lMjByYW5nZShudW1fZXBvY2hzKSUzQSUwQSUyMCUyMCUyMCUyMGZvciUyMGJhdGNoJTIwaW4lMjB0cmFpbl9kYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2glMjAlM0QlMjAlN0JrJTNBJTIwdi50byhkZXZpY2UpJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcy5iYWNrd2FyZCgpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9ncmVzc19iYXIudXBkYXRlKDEp",highlighted:`<span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        outputs = model(**batch)
        loss = outputs.loss
        loss.backward()

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),se=new $e({props:{title:"The evaluation loop",local:"the-evaluation-loop",headingTag:"h3"}}),ne=new h({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMmdsdWUlMjIlMkMlMjAlMjJtcnBjJTIyKSUwQW1vZGVsLmV2YWwoKSUwQWZvciUyMGJhdGNoJTIwaW4lMjBldmFsX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwYmF0Y2guaXRlbXMoKSU3RCUwQSUyMCUyMCUyMCUyMHdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQSUyMCUyMCUyMCUyMHByZWRpY3Rpb25zJTIwJTNEJTIwdG9yY2guYXJnbWF4KGxvZ2l0cyUyQyUyMGRpbSUzRC0xKSUwQSUyMCUyMCUyMCUyMG1ldHJpYy5hZGRfYmF0Y2gocHJlZGljdGlvbnMlM0RwcmVkaWN0aW9ucyUyQyUyMHJlZmVyZW5jZXMlM0RiYXRjaCU1QiUyMmxhYmVscyUyMiU1RCklMEElMEFtZXRyaWMuY29tcHV0ZSgp",highlighted:`<span class="hljs-keyword">import</span> evaluate

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
model.<span class="hljs-built_in">eval</span>()
<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> eval_dataloader:
    batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
    <span class="hljs-keyword">with</span> torch.no_grad():
        outputs = model(**batch)

    logits = outputs.logits
    predictions = torch.argmax(logits, dim=-<span class="hljs-number">1</span>)
    metric.add_batch(predictions=predictions, references=batch[<span class="hljs-string">&quot;labels&quot;</span>])

metric.compute()`,wrap:!1}}),ie=new h({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuODQzMTM3MjU0OTAxOTYwOCUyQyUyMCdmMSclM0ElMjAwLjg5MDc4NDk4MjkzNTE1MzUlN0Q=",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.8431372549019608</span>, <span class="hljs-string">&#x27;f1&#x27;</span>: <span class="hljs-number">0.8907849829351535</span>}',wrap:!1}}),j=new bt({props:{$$slots:{default:[Gt]},$$scope:{ctx:ke}}}),pe=new $e({props:{title:"Supercharge your training loop with 🤗 Accelerate",local:"supercharge-your-training-loop-with-accelerate",headingTag:"h3"}}),re=new jt({props:{id:"s7dy8QRgjJ0"}}),ce=new h({props:{code:"ZnJvbSUyMHRvcmNoLm9wdGltJTIwaW1wb3J0JTIwQWRhbVclMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUyQyUyMGdldF9zY2hlZHVsZXIlMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMiklMEFvcHRpbWl6ZXIlMjAlM0QlMjBBZGFtVyhtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBsciUzRDNlLTUpJTBBJTBBZGV2aWNlJTIwJTNEJTIwdG9yY2guZGV2aWNlKCUyMmN1ZGElMjIpJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMHRvcmNoLmRldmljZSglMjJjcHUlMjIpJTBBbW9kZWwudG8oZGV2aWNlKSUwQSUwQW51bV9lcG9jaHMlMjAlM0QlMjAzJTBBbnVtX3RyYWluaW5nX3N0ZXBzJTIwJTNEJTIwbnVtX2Vwb2NocyUyMColMjBsZW4odHJhaW5fZGF0YWxvYWRlciklMEFscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfc2NoZWR1bGVyKCUwQSUyMCUyMCUyMCUyMCUyMmxpbmVhciUyMiUyQyUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0QwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEbnVtX3RyYWluaW5nX3N0ZXBzJTJDJTBBKSUwQSUwQXByb2dyZXNzX2JhciUyMCUzRCUyMHRxZG0ocmFuZ2UobnVtX3RyYWluaW5nX3N0ZXBzKSklMEElMEFtb2RlbC50cmFpbigpJTBBZm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG51bV9lcG9jaHMpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwYmF0Y2guaXRlbXMoKSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmJhdGNoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3MlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzLmJhY2t3YXJkKCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbHJfc2NoZWR1bGVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb2dyZXNzX2Jhci51cGRhdGUoMSk=",highlighted:`<span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification, get_scheduler

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)
optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">3e-5</span>)

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)
model.to(device)

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dataloader)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        outputs = model(**batch)
        loss = outputs.loss
        loss.backward()

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),de=new h({props:{code:"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",highlighted:`<span class="hljs-addition">+ from accelerate import Accelerator</span>
  from torch.optim import AdamW
  from transformers import AutoModelForSequenceClassification, get_scheduler

<span class="hljs-addition">+ accelerator = Accelerator()</span>

  model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=2)
  optimizer = AdamW(model.parameters(), lr=3e-5)

<span class="hljs-deletion">- device = torch.device(&quot;cuda&quot;) if torch.cuda.is_available() else torch.device(&quot;cpu&quot;)</span>
<span class="hljs-deletion">- model.to(device)</span>

<span class="hljs-addition">+ train_dataloader, eval_dataloader, model, optimizer = accelerator.prepare(</span>
<span class="hljs-addition">+     train_dataloader, eval_dataloader, model, optimizer</span>
<span class="hljs-addition">+ )</span>

  num_epochs = 3
  num_training_steps = num_epochs * len(train_dataloader)
  lr_scheduler = get_scheduler(
      &quot;linear&quot;,
      optimizer=optimizer,
      num_warmup_steps=0,
      num_training_steps=num_training_steps
  )

  progress_bar = tqdm(range(num_training_steps))

  model.train()
  for epoch in range(num_epochs):
      for batch in train_dataloader:
<span class="hljs-deletion">-         batch = {k: v.to(device) for k, v in batch.items()}</span>
          outputs = model(**batch)
          loss = outputs.loss
<span class="hljs-deletion">-         loss.backward()</span>
<span class="hljs-addition">+         accelerator.backward(loss)</span>

          optimizer.step()
          lr_scheduler.step()
          optimizer.zero_grad()
          progress_bar.update(1)`,wrap:!1}}),J=new bt({props:{$$slots:{default:[Wt]},$$scope:{ctx:ke}}}),we=new h({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjB0b3JjaC5vcHRpbSUyMGltcG9ydCUyMEFkYW1XJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMjBnZXRfc2NoZWR1bGVyJTBBJTBBYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcigpJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50JTJDJTIwbnVtX2xhYmVscyUzRDIpJTBBb3B0aW1pemVyJTIwJTNEJTIwQWRhbVcobW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0QzZS01KSUwQSUwQXRyYWluX2RsJTJDJTIwZXZhbF9kbCUyQyUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSglMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwZXZhbF9kYXRhbG9hZGVyJTJDJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMEEpJTBBJTBBbnVtX2Vwb2NocyUyMCUzRCUyMDMlMEFudW1fdHJhaW5pbmdfc3RlcHMlMjAlM0QlMjBudW1fZXBvY2hzJTIwKiUyMGxlbih0cmFpbl9kbCklMEFscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfc2NoZWR1bGVyKCUwQSUyMCUyMCUyMCUyMCUyMmxpbmVhciUyMiUyQyUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0QwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEbnVtX3RyYWluaW5nX3N0ZXBzJTJDJTBBKSUwQSUwQXByb2dyZXNzX2JhciUyMCUzRCUyMHRxZG0ocmFuZ2UobnVtX3RyYWluaW5nX3N0ZXBzKSklMEElMEFtb2RlbC50cmFpbigpJTBBZm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG51bV9lcG9jaHMpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RsJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqYmF0Y2gpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmJhY2t3YXJkKGxvc3MpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9ncmVzc19iYXIudXBkYXRlKDEp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification, get_scheduler

accelerator = Accelerator()

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)
optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">3e-5</span>)

train_dl, eval_dl, model, optimizer = accelerator.prepare(
    train_dataloader, eval_dataloader, model, optimizer
)

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dl)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dl:
        outputs = model(**batch)
        loss = outputs.loss
        accelerator.backward(loss)

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),je=new h({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),Ue=new h({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluLnB5",highlighted:'accelerate <span class="hljs-built_in">launch</span> train.py',wrap:!1}}),Ce=new h({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBub3RlYm9va19sYXVuY2hlciUwQSUwQW5vdGVib29rX2xhdW5jaGVyKHRyYWluaW5nX2Z1bmN0aW9uKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> notebook_launcher

notebook_launcher(training_function)`,wrap:!1}}),Ze=new $t({props:{source:"https://github.com/huggingface/course/blob/main/chapters/en/chapter3/4.mdx"}}),{c(){u=m("meta"),w=a(),b=m("p"),Ie=a(),i(U.$$.fragment),Ge=a(),i(T.$$.fragment),We=a(),i(f.$$.fragment),Xe=a(),C=m("p"),C.innerHTML=Nl,ve=a(),i(g.$$.fragment),Re=a(),i(Z.$$.fragment),_e=a(),k=m("p"),k.innerHTML=zl,Ye=a(),I=m("ul"),I.innerHTML=El,Ae=a(),B=m("p"),B.innerHTML=Fl,Ve=a(),i($.$$.fragment),Ne=a(),G=m("p"),G.textContent=xl,ze=a(),i(W.$$.fragment),Ee=a(),X=m("p"),X.textContent=Ql,Fe=a(),i(v.$$.fragment),xe=a(),R=m("p"),R.textContent=Hl,Qe=a(),i(_.$$.fragment),He=a(),i(Y.$$.fragment),Se=a(),A=m("p"),A.innerHTML=Sl,qe=a(),V=m("p"),V.textContent=ql,Le=a(),i(N.$$.fragment),Ke=a(),z=m("p"),z.textContent=Ll,De=a(),i(E.$$.fragment),Pe=a(),i(F.$$.fragment),Oe=a(),x=m("p"),x.innerHTML=Kl,el=a(),Q=m("p"),Q.innerHTML=Dl,ll=a(),i(H.$$.fragment),tl=a(),S=m("p"),S.innerHTML=Pl,sl=a(),i(q.$$.fragment),al=a(),i(L.$$.fragment),nl=a(),i(K.$$.fragment),il=a(),D=m("p"),D.innerHTML=Ol,ol=a(),i(P.$$.fragment),pl=a(),i(O.$$.fragment),rl=a(),ee=m("p"),ee.innerHTML=et,Ml=a(),i(le.$$.fragment),cl=a(),te=m("p"),te.textContent=lt,ml=a(),i(se.$$.fragment),dl=a(),ae=m("p"),ae.innerHTML=tt,yl=a(),i(ne.$$.fragment),hl=a(),i(ie.$$.fragment),ul=a(),oe=m("p"),oe.textContent=st,wl=a(),i(j.$$.fragment),bl=a(),i(pe.$$.fragment),jl=a(),i(re.$$.fragment),Jl=a(),Me=m("p"),Me.innerHTML=at,Ul=a(),i(ce.$$.fragment),Tl=a(),me=m("p"),me.textContent=nt,fl=a(),i(de.$$.fragment),Cl=a(),ye=m("p"),ye.innerHTML=it,gl=a(),he=m("p"),he.innerHTML=ot,Zl=a(),i(J.$$.fragment),kl=a(),ue=m("p"),ue.textContent=pt,Il=a(),i(we.$$.fragment),Bl=a(),be=m("p"),be.innerHTML=rt,$l=a(),i(je.$$.fragment),Gl=a(),Je=m("p"),Je.textContent=Mt,Wl=a(),i(Ue.$$.fragment),Xl=a(),Te=m("p"),Te.textContent=ct,vl=a(),fe=m("p"),fe.innerHTML=mt,Rl=a(),i(Ce.$$.fragment),_l=a(),ge=m("p"),ge.innerHTML=dt,Yl=a(),i(Ze.$$.fragment),Al=a(),Be=m("p"),this.h()},l(e){const l=gt("svelte-u9bgzb",document.head);u=d(l,"META",{name:!0,content:!0}),l.forEach(t),w=n(e),b=d(e,"P",{}),ut(b).forEach(t),Ie=n(e),o(U.$$.fragment,e),Ge=n(e),o(T.$$.fragment,e),We=n(e),o(f.$$.fragment,e),Xe=n(e),C=d(e,"P",{"data-svelte-h":!0}),y(C)!=="svelte-9c0ejj"&&(C.innerHTML=Nl),ve=n(e),o(g.$$.fragment,e),Re=n(e),o(Z.$$.fragment,e),_e=n(e),k=d(e,"P",{"data-svelte-h":!0}),y(k)!=="svelte-ci9pg7"&&(k.innerHTML=zl),Ye=n(e),I=d(e,"UL",{"data-svelte-h":!0}),y(I)!=="svelte-pk4vyx"&&(I.innerHTML=El),Ae=n(e),B=d(e,"P",{"data-svelte-h":!0}),y(B)!=="svelte-ey27a0"&&(B.innerHTML=Fl),Ve=n(e),o($.$$.fragment,e),Ne=n(e),G=d(e,"P",{"data-svelte-h":!0}),y(G)!=="svelte-trxw7x"&&(G.textContent=xl),ze=n(e),o(W.$$.fragment,e),Ee=n(e),X=d(e,"P",{"data-svelte-h":!0}),y(X)!=="svelte-11c0vnt"&&(X.textContent=Ql),Fe=n(e),o(v.$$.fragment,e),xe=n(e),R=d(e,"P",{"data-svelte-h":!0}),y(R)!=="svelte-11wtmu1"&&(R.textContent=Hl),Qe=n(e),o(_.$$.fragment,e),He=n(e),o(Y.$$.fragment,e),Se=n(e),A=d(e,"P",{"data-svelte-h":!0}),y(A)!=="svelte-q4m5oq"&&(A.innerHTML=Sl),qe=n(e),V=d(e,"P",{"data-svelte-h":!0}),y(V)!=="svelte-xq9k1z"&&(V.textContent=ql),Le=n(e),o(N.$$.fragment,e),Ke=n(e),z=d(e,"P",{"data-svelte-h":!0}),y(z)!=="svelte-1cfpt2v"&&(z.textContent=Ll),De=n(e),o(E.$$.fragment,e),Pe=n(e),o(F.$$.fragment,e),Oe=n(e),x=d(e,"P",{"data-svelte-h":!0}),y(x)!=="svelte-ynwaiq"&&(x.innerHTML=Kl),el=n(e),Q=d(e,"P",{"data-svelte-h":!0}),y(Q)!=="svelte-1my9rg2"&&(Q.innerHTML=Dl),ll=n(e),o(H.$$.fragment,e),tl=n(e),S=d(e,"P",{"data-svelte-h":!0}),y(S)!=="svelte-12ciodg"&&(S.innerHTML=Pl),sl=n(e),o(q.$$.fragment,e),al=n(e),o(L.$$.fragment,e),nl=n(e),o(K.$$.fragment,e),il=n(e),D=d(e,"P",{"data-svelte-h":!0}),y(D)!=="svelte-1331u4o"&&(D.innerHTML=Ol),ol=n(e),o(P.$$.fragment,e),pl=n(e),o(O.$$.fragment,e),rl=n(e),ee=d(e,"P",{"data-svelte-h":!0}),y(ee)!=="svelte-s26r6i"&&(ee.innerHTML=et),Ml=n(e),o(le.$$.fragment,e),cl=n(e),te=d(e,"P",{"data-svelte-h":!0}),y(te)!=="svelte-mcninq"&&(te.textContent=lt),ml=n(e),o(se.$$.fragment,e),dl=n(e),ae=d(e,"P",{"data-svelte-h":!0}),y(ae)!=="svelte-1sbu2u1"&&(ae.innerHTML=tt),yl=n(e),o(ne.$$.fragment,e),hl=n(e),o(ie.$$.fragment,e),ul=n(e),oe=d(e,"P",{"data-svelte-h":!0}),y(oe)!=="svelte-14qz8qy"&&(oe.textContent=st),wl=n(e),o(j.$$.fragment,e),bl=n(e),o(pe.$$.fragment,e),jl=n(e),o(re.$$.fragment,e),Jl=n(e),Me=d(e,"P",{"data-svelte-h":!0}),y(Me)!=="svelte-hmch84"&&(Me.innerHTML=at),Ul=n(e),o(ce.$$.fragment,e),Tl=n(e),me=d(e,"P",{"data-svelte-h":!0}),y(me)!=="svelte-1ysmkb9"&&(me.textContent=nt),fl=n(e),o(de.$$.fragment,e),Cl=n(e),ye=d(e,"P",{"data-svelte-h":!0}),y(ye)!=="svelte-1q9wsp0"&&(ye.innerHTML=it),gl=n(e),he=d(e,"P",{"data-svelte-h":!0}),y(he)!=="svelte-15cl91a"&&(he.innerHTML=ot),Zl=n(e),o(J.$$.fragment,e),kl=n(e),ue=d(e,"P",{"data-svelte-h":!0}),y(ue)!=="svelte-1g09gg4"&&(ue.textContent=pt),Il=n(e),o(we.$$.fragment,e),Bl=n(e),be=d(e,"P",{"data-svelte-h":!0}),y(be)!=="svelte-1476nx"&&(be.innerHTML=rt),$l=n(e),o(je.$$.fragment,e),Gl=n(e),Je=d(e,"P",{"data-svelte-h":!0}),y(Je)!=="svelte-qyc3dl"&&(Je.textContent=Mt),Wl=n(e),o(Ue.$$.fragment,e),Xl=n(e),Te=d(e,"P",{"data-svelte-h":!0}),y(Te)!=="svelte-1dc7y78"&&(Te.textContent=ct),vl=n(e),fe=d(e,"P",{"data-svelte-h":!0}),y(fe)!=="svelte-529dmx"&&(fe.innerHTML=mt),Rl=n(e),o(Ce.$$.fragment,e),_l=n(e),ge=d(e,"P",{"data-svelte-h":!0}),y(ge)!=="svelte-py198"&&(ge.innerHTML=dt),Yl=n(e),o(Ze.$$.fragment,e),Al=n(e),Be=d(e,"P",{}),ut(Be).forEach(t),this.h()},h(){wt(u,"name","hf:doc:metadata"),wt(u,"content",vt)},m(e,l){Zt(document.head,u),s(e,w,l),s(e,b,l),s(e,Ie,l),p(U,e,l),s(e,Ge,l),p(T,e,l),s(e,We,l),p(f,e,l),s(e,Xe,l),s(e,C,l),s(e,ve,l),p(g,e,l),s(e,Re,l),p(Z,e,l),s(e,_e,l),s(e,k,l),s(e,Ye,l),s(e,I,l),s(e,Ae,l),s(e,B,l),s(e,Ve,l),p($,e,l),s(e,Ne,l),s(e,G,l),s(e,ze,l),p(W,e,l),s(e,Ee,l),s(e,X,l),s(e,Fe,l),p(v,e,l),s(e,xe,l),s(e,R,l),s(e,Qe,l),p(_,e,l),s(e,He,l),p(Y,e,l),s(e,Se,l),s(e,A,l),s(e,qe,l),s(e,V,l),s(e,Le,l),p(N,e,l),s(e,Ke,l),s(e,z,l),s(e,De,l),p(E,e,l),s(e,Pe,l),p(F,e,l),s(e,Oe,l),s(e,x,l),s(e,el,l),s(e,Q,l),s(e,ll,l),p(H,e,l),s(e,tl,l),s(e,S,l),s(e,sl,l),p(q,e,l),s(e,al,l),p(L,e,l),s(e,nl,l),p(K,e,l),s(e,il,l),s(e,D,l),s(e,ol,l),p(P,e,l),s(e,pl,l),p(O,e,l),s(e,rl,l),s(e,ee,l),s(e,Ml,l),p(le,e,l),s(e,cl,l),s(e,te,l),s(e,ml,l),p(se,e,l),s(e,dl,l),s(e,ae,l),s(e,yl,l),p(ne,e,l),s(e,hl,l),p(ie,e,l),s(e,ul,l),s(e,oe,l),s(e,wl,l),p(j,e,l),s(e,bl,l),p(pe,e,l),s(e,jl,l),p(re,e,l),s(e,Jl,l),s(e,Me,l),s(e,Ul,l),p(ce,e,l),s(e,Tl,l),s(e,me,l),s(e,fl,l),p(de,e,l),s(e,Cl,l),s(e,ye,l),s(e,gl,l),s(e,he,l),s(e,Zl,l),p(J,e,l),s(e,kl,l),s(e,ue,l),s(e,Il,l),p(we,e,l),s(e,Bl,l),s(e,be,l),s(e,$l,l),p(je,e,l),s(e,Gl,l),s(e,Je,l),s(e,Wl,l),p(Ue,e,l),s(e,Xl,l),s(e,Te,l),s(e,vl,l),s(e,fe,l),s(e,Rl,l),p(Ce,e,l),s(e,_l,l),s(e,ge,l),s(e,Yl,l),p(Ze,e,l),s(e,Al,l),s(e,Be,l),Vl=!0},p(e,[l]){const yt={};l&2&&(yt.$$scope={dirty:l,ctx:e}),j.$set(yt);const ht={};l&2&&(ht.$$scope={dirty:l,ctx:e}),J.$set(ht)},i(e){Vl||(r(U.$$.fragment,e),r(T.$$.fragment,e),r(f.$$.fragment,e),r(g.$$.fragment,e),r(Z.$$.fragment,e),r($.$$.fragment,e),r(W.$$.fragment,e),r(v.$$.fragment,e),r(_.$$.fragment,e),r(Y.$$.fragment,e),r(N.$$.fragment,e),r(E.$$.fragment,e),r(F.$$.fragment,e),r(H.$$.fragment,e),r(q.$$.fragment,e),r(L.$$.fragment,e),r(K.$$.fragment,e),r(P.$$.fragment,e),r(O.$$.fragment,e),r(le.$$.fragment,e),r(se.$$.fragment,e),r(ne.$$.fragment,e),r(ie.$$.fragment,e),r(j.$$.fragment,e),r(pe.$$.fragment,e),r(re.$$.fragment,e),r(ce.$$.fragment,e),r(de.$$.fragment,e),r(J.$$.fragment,e),r(we.$$.fragment,e),r(je.$$.fragment,e),r(Ue.$$.fragment,e),r(Ce.$$.fragment,e),r(Ze.$$.fragment,e),Vl=!0)},o(e){M(U.$$.fragment,e),M(T.$$.fragment,e),M(f.$$.fragment,e),M(g.$$.fragment,e),M(Z.$$.fragment,e),M($.$$.fragment,e),M(W.$$.fragment,e),M(v.$$.fragment,e),M(_.$$.fragment,e),M(Y.$$.fragment,e),M(N.$$.fragment,e),M(E.$$.fragment,e),M(F.$$.fragment,e),M(H.$$.fragment,e),M(q.$$.fragment,e),M(L.$$.fragment,e),M(K.$$.fragment,e),M(P.$$.fragment,e),M(O.$$.fragment,e),M(le.$$.fragment,e),M(se.$$.fragment,e),M(ne.$$.fragment,e),M(ie.$$.fragment,e),M(j.$$.fragment,e),M(pe.$$.fragment,e),M(re.$$.fragment,e),M(ce.$$.fragment,e),M(de.$$.fragment,e),M(J.$$.fragment,e),M(we.$$.fragment,e),M(je.$$.fragment,e),M(Ue.$$.fragment,e),M(Ce.$$.fragment,e),M(Ze.$$.fragment,e),Vl=!1},d(e){e&&(t(w),t(b),t(Ie),t(Ge),t(We),t(Xe),t(C),t(ve),t(Re),t(_e),t(k),t(Ye),t(I),t(Ae),t(B),t(Ve),t(Ne),t(G),t(ze),t(Ee),t(X),t(Fe),t(xe),t(R),t(Qe),t(He),t(Se),t(A),t(qe),t(V),t(Le),t(Ke),t(z),t(De),t(Pe),t(Oe),t(x),t(el),t(Q),t(ll),t(tl),t(S),t(sl),t(al),t(nl),t(il),t(D),t(ol),t(pl),t(rl),t(ee),t(Ml),t(cl),t(te),t(ml),t(dl),t(ae),t(yl),t(hl),t(ul),t(oe),t(wl),t(bl),t(jl),t(Jl),t(Me),t(Ul),t(Tl),t(me),t(fl),t(Cl),t(ye),t(gl),t(he),t(Zl),t(kl),t(ue),t(Il),t(Bl),t(be),t($l),t(Gl),t(Je),t(Wl),t(Xl),t(Te),t(vl),t(fe),t(Rl),t(_l),t(ge),t(Yl),t(Al),t(Be)),t(u),c(U,e),c(T,e),c(f,e),c(g,e),c(Z,e),c($,e),c(W,e),c(v,e),c(_,e),c(Y,e),c(N,e),c(E,e),c(F,e),c(H,e),c(q,e),c(L,e),c(K,e),c(P,e),c(O,e),c(le,e),c(se,e),c(ne,e),c(ie,e),c(j,e),c(pe,e),c(re,e),c(ce,e),c(de,e),c(J,e),c(we,e),c(je,e),c(Ue,e),c(Ce,e),c(Ze,e)}}}const vt='{"title":"A full training","local":"a-full-training","sections":[{"title":"Prepare for training","local":"prepare-for-training","sections":[],"depth":3},{"title":"The training loop","local":"the-training-loop","sections":[],"depth":3},{"title":"The evaluation loop","local":"the-evaluation-loop","sections":[],"depth":3},{"title":"Supercharge your training loop with 🤗 Accelerate","local":"supercharge-your-training-loop-with-accelerate","sections":[],"depth":3}],"depth":1}';function Rt(ke){return Ut(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ft extends ft{constructor(u){super(),Ct(this,u,Rt,Xt,Jt,{})}}export{Ft as component};
