import{s as Je,f as ge,n as be,o as Ce}from"../chunks/scheduler.f7e1785c.js";import{S as Ie,i as Ae,g as o,s,r as Z,A as We,h as i,f as l,c as n,j as ie,u as G,x as r,k as c,y as ve,a,v as _,d as k,t as B,w as x}from"../chunks/index.9f8f0838.js";import{C as oe}from"../chunks/CodeBlock.4baef5d7.js";import{H as Ze,E as Ge}from"../chunks/getInferenceSnippets.ba5f4cd0.js";function _e(pe){let u,H,$,S,M,Y,m,re=`Now that we’ve fine-tuned a Whisper model for Dhivehi speech recognition, let’s go ahead and build a <a href="https://gradio.app" rel="nofollow">Gradio</a>
demo to showcase it to the community!`,Q,d,ue=`The first thing to do is load up the fine-tuned checkpoint using the <code>pipeline()</code> class - this is very familiar now from
the section on <a href="asr_models">pre-trained models</a>. You can change the <code>model_id</code> to the namespace of your fine-tuned
model on the Hugging Face Hub, or one of the pre-trained <a href="https://huggingface.co/models?sort=downloads&amp;search=openai%2Fwhisper-" rel="nofollow">Whisper models</a>
to perform zero-shot speech recognition:`,V,h,R,y,ce=`Secondly, we’ll define a function that takes the filepath for an audio input and passes it through the pipeline. Here,
the pipeline automatically takes care of loading the audio file, resampling it to the correct sampling rate, and running
inference with the model. We can then simply return the transcribed text as the output of the function. To ensure our
model can handle audio inputs of arbitrary length, we’ll enable <em>chunking</em> as described in the section
on <a href="asr_models">pre-trained models</a>:`,N,w,z,f,Me=`We’ll use the Gradio <a href="https://gradio.app/docs/#blocks" rel="nofollow">blocks</a> feature to launch two tabs on our demo: one for microphone
transcription, and the other for file upload.`,q,j,X,U,me="Finally, we launch the Gradio demo using the two blocks that we’ve just defined:",F,T,P,J,de="This will launch a Gradio demo similar to the one running on the Hugging Face Space:",L,p,he,K,g,ye="Should you wish to host your demo on the Hugging Face Hub, you can use this Space as a template for your fine-tuned model.",D,b,we='Click the link to duplicate the template demo to your account: <a href="https://huggingface.co/spaces/course-demos/whisper-small?duplicate=true" rel="nofollow">https://huggingface.co/spaces/course-demos/whisper-small?duplicate=true</a>',O,C,fe="We recommend giving your space a similar name to your fine-tuned model (e.g. whisper-small-dv-demo) and setting the visibility to “Public”.",ee,I,je=`Once you’ve duplicated the Space to your account, click “Files and versions” -> “app.py” -> “edit”. Then change the
model identifier to your fine-tuned model (line 6). Scroll to the bottom of the page and click “Commit changes to main”.
The demo will reboot, this time using your fine-tuned model. You can share this demo with your friends and family so that
they can use the model that you’ve trained!`,te,A,Ue='Checkout our video tutorial to get a better understanding of how to duplicate the Space 👉️ <a href="https://www.youtube.com/watch?v=VQYuvl6-9VE" rel="nofollow">YouTube Video</a>',le,W,Te="We look forward to seeing your demos on the Hub!",ae,v,se,E,ne;return M=new Ze({props:{title:"Build a demo with Gradio",local:"build-a-demo-with-gradio",headingTag:"h1"}}),h=new oe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJzYW5jaGl0LWdhbmRoaSUyRndoaXNwZXItc21hbGwtZHYlMjIlMjAlMjAlMjMlMjB1cGRhdGUlMjB3aXRoJTIweW91ciUyMG1vZGVsJTIwaWQlMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUoJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiUyQyUyMG1vZGVsJTNEbW9kZWxfaWQp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

model_id = <span class="hljs-string">&quot;sanchit-gandhi/whisper-small-dv&quot;</span>  <span class="hljs-comment"># update with your model id</span>
pipe = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=model_id)`,wrap:!1}}),w=new oe({props:{code:"ZGVmJTIwdHJhbnNjcmliZV9zcGVlY2goZmlsZXBhdGgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0JTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmaWxlcGF0aCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNEMjU2JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZ2VuZXJhdGVfa3dhcmdzJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGFzayUyMiUzQSUyMCUyMnRyYW5zY3JpYmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsYW5ndWFnZSUyMiUzQSUyMCUyMnNpbmhhbGVzZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUyMCUyMCUyMyUyMHVwZGF0ZSUyMHdpdGglMjB0aGUlMjBsYW5ndWFnZSUyMHlvdSd2ZSUyMGZpbmUtdHVuZWQlMjBvbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNodW5rX2xlbmd0aF9zJTNEMzAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEOCUyQyUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBvdXRwdXQlNUIlMjJ0ZXh0JTIyJTVE",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">transcribe_speech</span>(<span class="hljs-params">filepath</span>):
    output = pipe(
        filepath,
        max_new_tokens=<span class="hljs-number">256</span>,
        generate_kwargs={
            <span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>,
            <span class="hljs-string">&quot;language&quot;</span>: <span class="hljs-string">&quot;sinhalese&quot;</span>,
        },  <span class="hljs-comment"># update with the language you&#x27;ve fine-tuned on</span>
        chunk_length_s=<span class="hljs-number">30</span>,
        batch_size=<span class="hljs-number">8</span>,
    )
    <span class="hljs-keyword">return</span> output[<span class="hljs-string">&quot;text&quot;</span>]`,wrap:!1}}),j=new oe({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQWRlbW8lMjAlM0QlMjBnci5CbG9ja3MoKSUwQSUwQW1pY190cmFuc2NyaWJlJTIwJTNEJTIwZ3IuSW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGZuJTNEdHJhbnNjcmliZV9zcGVlY2glMkMlMEElMjAlMjAlMjAlMjBpbnB1dHMlM0Rnci5BdWRpbyhzb3VyY2VzJTNEJTIybWljcm9waG9uZSUyMiUyQyUyMHR5cGUlM0QlMjJmaWxlcGF0aCUyMiklMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRzJTNEZ3IuY29tcG9uZW50cy5UZXh0Ym94KCklMkMlMEEpJTBBJTBBZmlsZV90cmFuc2NyaWJlJTIwJTNEJTIwZ3IuSW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGZuJTNEdHJhbnNjcmliZV9zcGVlY2glMkMlMEElMjAlMjAlMjAlMjBpbnB1dHMlM0Rnci5BdWRpbyhzb3VyY2VzJTNEJTIydXBsb2FkJTIyJTJDJTIwdHlwZSUzRCUyMmZpbGVwYXRoJTIyKSUyQyUwQSUyMCUyMCUyMCUyMG91dHB1dHMlM0Rnci5jb21wb25lbnRzLlRleHRib3goKSUyQyUwQSk=",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

demo = gr.Blocks()

mic_transcribe = gr.Interface(
    fn=transcribe_speech,
    inputs=gr.Audio(sources=<span class="hljs-string">&quot;microphone&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>),
    outputs=gr.components.Textbox(),
)

file_transcribe = gr.Interface(
    fn=transcribe_speech,
    inputs=gr.Audio(sources=<span class="hljs-string">&quot;upload&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>),
    outputs=gr.components.Textbox(),
)`,wrap:!1}}),T=new oe({props:{code:"d2l0aCUyMGRlbW8lM0ElMEElMjAlMjAlMjAlMjBnci5UYWJiZWRJbnRlcmZhY2UoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCbWljX3RyYW5zY3JpYmUlMkMlMjBmaWxlX3RyYW5zY3JpYmUlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlMjJUcmFuc2NyaWJlJTIwTWljcm9waG9uZSUyMiUyQyUyMCUyMlRyYW5zY3JpYmUlMjBBdWRpbyUyMEZpbGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjApJTBBJTBBZGVtby5sYXVuY2goZGVidWclM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">with</span> demo:
    gr.TabbedInterface(
        [mic_transcribe, file_transcribe],
        [<span class="hljs-string">&quot;Transcribe Microphone&quot;</span>, <span class="hljs-string">&quot;Transcribe Audio File&quot;</span>],
    )

demo.launch(debug=<span class="hljs-literal">True</span>)`,wrap:!1}}),v=new Ge({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/en/chapter5/demo.mdx"}}),{c(){u=o("meta"),H=s(),$=o("p"),S=s(),Z(M.$$.fragment),Y=s(),m=o("p"),m.innerHTML=re,Q=s(),d=o("p"),d.innerHTML=ue,V=s(),Z(h.$$.fragment),R=s(),y=o("p"),y.innerHTML=ce,N=s(),Z(w.$$.fragment),z=s(),f=o("p"),f.innerHTML=Me,q=s(),Z(j.$$.fragment),X=s(),U=o("p"),U.textContent=me,F=s(),Z(T.$$.fragment),P=s(),J=o("p"),J.textContent=de,L=s(),p=o("iframe"),K=s(),g=o("p"),g.textContent=ye,D=s(),b=o("p"),b.innerHTML=we,O=s(),C=o("p"),C.textContent=fe,ee=s(),I=o("p"),I.textContent=je,te=s(),A=o("p"),A.innerHTML=Ue,le=s(),W=o("p"),W.textContent=Te,ae=s(),Z(v.$$.fragment),se=s(),E=o("p"),this.h()},l(e){const t=We("svelte-u9bgzb",document.head);u=i(t,"META",{name:!0,content:!0}),t.forEach(l),H=n(e),$=i(e,"P",{}),ie($).forEach(l),S=n(e),G(M.$$.fragment,e),Y=n(e),m=i(e,"P",{"data-svelte-h":!0}),r(m)!=="svelte-1q95dto"&&(m.innerHTML=re),Q=n(e),d=i(e,"P",{"data-svelte-h":!0}),r(d)!=="svelte-ldnoqw"&&(d.innerHTML=ue),V=n(e),G(h.$$.fragment,e),R=n(e),y=i(e,"P",{"data-svelte-h":!0}),r(y)!=="svelte-g873e4"&&(y.innerHTML=ce),N=n(e),G(w.$$.fragment,e),z=n(e),f=i(e,"P",{"data-svelte-h":!0}),r(f)!=="svelte-wlltyj"&&(f.innerHTML=Me),q=n(e),G(j.$$.fragment,e),X=n(e),U=i(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1s2jh73"&&(U.textContent=me),F=n(e),G(T.$$.fragment,e),P=n(e),J=i(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-10sf4ix"&&(J.textContent=de),L=n(e),p=i(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),ie(p).forEach(l),K=n(e),g=i(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-ojipak"&&(g.textContent=ye),D=n(e),b=i(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1uiun01"&&(b.innerHTML=we),O=n(e),C=i(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1oyez0p"&&(C.textContent=fe),ee=n(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-7essz6"&&(I.textContent=je),te=n(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-9wesld"&&(A.innerHTML=Ue),le=n(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1v4hd0t"&&(W.textContent=Te),ae=n(e),G(v.$$.fragment,e),se=n(e),E=i(e,"P",{}),ie(E).forEach(l),this.h()},h(){c(u,"name","hf:doc:metadata"),c(u,"content",ke),ge(p.src,he="https://course-demos-whisper-small.hf.space")||c(p,"src",he),c(p,"frameborder","0"),c(p,"height","450"),c(p,"title","Gradio app"),c(p,"class","container p-0 flex-grow space-iframe"),c(p,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),c(p,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads")},m(e,t){ve(document.head,u),a(e,H,t),a(e,$,t),a(e,S,t),_(M,e,t),a(e,Y,t),a(e,m,t),a(e,Q,t),a(e,d,t),a(e,V,t),_(h,e,t),a(e,R,t),a(e,y,t),a(e,N,t),_(w,e,t),a(e,z,t),a(e,f,t),a(e,q,t),_(j,e,t),a(e,X,t),a(e,U,t),a(e,F,t),_(T,e,t),a(e,P,t),a(e,J,t),a(e,L,t),a(e,p,t),a(e,K,t),a(e,g,t),a(e,D,t),a(e,b,t),a(e,O,t),a(e,C,t),a(e,ee,t),a(e,I,t),a(e,te,t),a(e,A,t),a(e,le,t),a(e,W,t),a(e,ae,t),_(v,e,t),a(e,se,t),a(e,E,t),ne=!0},p:be,i(e){ne||(k(M.$$.fragment,e),k(h.$$.fragment,e),k(w.$$.fragment,e),k(j.$$.fragment,e),k(T.$$.fragment,e),k(v.$$.fragment,e),ne=!0)},o(e){B(M.$$.fragment,e),B(h.$$.fragment,e),B(w.$$.fragment,e),B(j.$$.fragment,e),B(T.$$.fragment,e),B(v.$$.fragment,e),ne=!1},d(e){e&&(l(H),l($),l(S),l(Y),l(m),l(Q),l(d),l(V),l(R),l(y),l(N),l(z),l(f),l(q),l(X),l(U),l(F),l(P),l(J),l(L),l(p),l(K),l(g),l(D),l(b),l(O),l(C),l(ee),l(I),l(te),l(A),l(le),l(W),l(ae),l(se),l(E)),l(u),x(M,e),x(h,e),x(w,e),x(j,e),x(T,e),x(v,e)}}}const ke='{"title":"Build a demo with Gradio","local":"build-a-demo-with-gradio","sections":[],"depth":1}';function Be(pe){return Ce(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Se extends Ie{constructor(u){super(),Ae(this,u,Be,_e,Je,{})}}export{Se as component};
