import{s as Kn,o as Dn,n as ze}from"../chunks/scheduler.6062bdaf.js";import{S as On,i as es,g as c,s as a,r as o,A as ts,h as r,f as n,c as l,j as Fn,u as p,x as m,k as Pn,y as ns,a as s,v as g,d as f,t as h,w as u}from"../chunks/index.4bca734e.js";import{T as Le}from"../chunks/Tip.b9ac1f03.js";import{C as _}from"../chunks/CodeBlock.fa01571c.js";import{H as j,E as ss}from"../chunks/EditOnGithub.74ab2baa.js";function as(M){let i,y=`<a href="/docs/huggingface_hub/pr_2380/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> is a Python client making HTTP calls to our APIs. If you want to make the HTTP calls directly using
your preferred tool (curl, postman,…), please refer to the <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inference API</a>
or to the <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints</a> documentation pages.`,d,b,C=`For web development, a <a href="https://huggingface.co/docs/huggingface.js/inference/README" rel="nofollow">JS client</a> has been released.
If you are interested in game development, you might have a look at our <a href="https://github.com/huggingface/unity-api" rel="nofollow">C# project</a>.`;return{c(){i=c("p"),i.innerHTML=y,d=a(),b=c("p"),b.innerHTML=C},l(w){i=r(w,"P",{"data-svelte-h":!0}),m(i)!=="svelte-o9vxek"&&(i.innerHTML=y),d=l(w),b=r(w,"P",{"data-svelte-h":!0}),m(b)!=="svelte-22w7rm"&&(b.innerHTML=C)},m(w,$){s(w,i,$),s(w,d,$),s(w,b,$)},p:ze,d(w){w&&(n(i),n(d),n(b))}}}function ls(M){let i,y=`The API is designed to be simple. Not all parameters and options are available or described for the end user. Check out
<a href="https://huggingface.co/docs/api-inference/detailed_parameters" rel="nofollow">this page</a> if you are interested in learning more about
all the parameters available for each task.`;return{c(){i=c("p"),i.innerHTML=y},l(d){i=r(d,"P",{"data-svelte-h":!0}),m(i)!=="svelte-1o4uc5e"&&(i.innerHTML=y)},m(d,b){s(d,i,b)},p:ze,d(d){d&&n(i)}}}function is(M){let i,y=`There are more than 200k models on the Hugging Face Hub! Each task in the <a href="/docs/huggingface_hub/pr_2380/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> comes with a recommended
model. Be aware that the HF recommendation can change over time without prior notice. Therefore it is best to explicitly
set a model once you are decided. Also, in most cases you’ll be interested in finding a model specific to <em>your</em> needs.
Visit the <a href="https://huggingface.co/models" rel="nofollow">Models</a> page on the Hub to explore your possibilities.`;return{c(){i=c("p"),i.innerHTML=y},l(d){i=r(d,"P",{"data-svelte-h":!0}),m(i)!=="svelte-1m6pi49"&&(i.innerHTML=y)},m(d,b){s(d,i,b)},p:ze,d(d){d&&n(i)}}}function cs(M){let i,y=`Authentication is NOT mandatory when using the Inference API. However, authenticated users get a higher free-tier to
play with the service. Token is also mandatory if you want to run inference on your private models or on private
endpoints.`;return{c(){i=c("p"),i.textContent=y},l(d){i=r(d,"P",{"data-svelte-h":!0}),m(i)!=="svelte-7vtkgf"&&(i.textContent=y)},m(d,b){s(d,i,b)},p:ze,d(d){d&&n(i)}}}function rs(M){let i,y=`Check out the <a href="https://huggingface.co/tasks" rel="nofollow">Tasks</a> page to learn more about each task, how to use them, and the
most popular models for each task.`;return{c(){i=c("p"),i.innerHTML=y},l(d){i=r(d,"P",{"data-svelte-h":!0}),m(i)!=="svelte-1u4hr1j"&&(i.innerHTML=y)},m(d,b){s(d,i,b)},p:ze,d(d){d&&n(i)}}}function os(M){let i,y=`This is the recommended way to adapt your code to <a href="/docs/huggingface_hub/pr_2380/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>. It lets you benefit from the task-specific
methods like <code>feature_extraction</code>.`;return{c(){i=c("p"),i.innerHTML=y},l(d){i=r(d,"P",{"data-svelte-h":!0}),m(i)!=="svelte-lc0das"&&(i.innerHTML=y)},m(d,b){s(d,i,b)},p:ze,d(d){d&&n(i)}}}function ps(M){let i,y,d,b,C,w,$,gn=`Inference is the process of using a trained model to make predictions on new data. As this process can be compute-intensive,
running on a dedicated server can be an interesting option. The <code>huggingface_hub</code> library provides an easy way to call a
service that runs inference for hosted models. There are several services you can connect to:`,Re,x,fn=`<li><a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inference API</a>: a service that allows you to run accelerated inference
on Hugging Face’s infrastructure for free. This service is a fast way to get started, test different models, and
prototype AI products.</li> <li><a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints</a>: a product to easily deploy models to production.
Inference is run by Hugging Face in a dedicated, fully managed infrastructure on a cloud provider of your choice.</li>`,Xe,W,hn=`These services can be called with the <a href="/docs/huggingface_hub/pr_2380/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> object. It acts as a replacement for the legacy
<a href="/docs/huggingface_hub/pr_2380/en/package_reference/inference_client#huggingface_hub.InferenceApi">InferenceApi</a> client, adding specific support for tasks and handling inference on both
<a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inference API</a> and <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints</a>.
Learn how to migrate to the new client in the <a href="#legacy-inferenceapi-client">Legacy InferenceAPI client</a> section.`,Qe,I,Ae,v,Fe,G,un="Let’s get started with a text-to-image task:",Pe,V,Ke,q,dn='In the example above, we initialized an <a href="/docs/huggingface_hub/pr_2380/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> with the default parameters. The only thing you need to know is the <a href="#supported-tasks">task</a> you want to perform. By default, the client will connect to the Inference API and select a model to complete the task. In our example, we generated an image from a text prompt. The returned value is a <code>PIL.Image</code> object that can be saved to a file. For more details, check out the <a href="/docs/huggingface_hub/pr_2380/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_to_image">text_to_image()</a> documentation.',De,N,mn="Let’s now see an example using the <code>chat_completion</code> API. This task uses an LLM to generate a response from a list of messages:",Oe,B,et,S,yn='In this example, we specified which model we want to use (<code>&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</code>). You can find a list of compatible models <a href="https://huggingface.co/models?other=conversational&amp;sort=likes" rel="nofollow">on this page</a>. We then gave a list of messages to complete (here, a single question) and passed an additional parameter to API (<code>max_token=100</code>). The output is a <code>ChatCompletionOutput</code> object that follows the OpenAI specification. The generated content can be access with <code>output.choices[0].message.content</code>. For more details, check out the <a href="/docs/huggingface_hub/pr_2380/en/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">chat_completion()</a> documentation.',tt,U,nt,H,st,Y,bn="What if you want to use a specific model? You can specify it either as a parameter or directly at an instance level:",at,L,lt,Z,it,z,ct,E,_n=`The examples we saw above use the Serverless Inference API. This proves to be very useful for prototyping
and testing things quickly. Once you’re ready to deploy your model to production, you’ll need to use a dedicated infrastructure.
That’s where <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints</a> comes into play. It allows you to deploy
any model and expose it as a private API. Once deployed, you’ll get a URL that you can connect to using exactly the same
code as before, changing only the <code>model</code> parameter:`,rt,R,ot,X,pt,Q,jn=`Calls made with the <a href="/docs/huggingface_hub/pr_2380/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> can be authenticated using a <a href="https://huggingface.co/docs/hub/security-tokens" rel="nofollow">User Access Token</a>.
By default, it will use the token saved on your machine if you are logged in (check out
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">how to authenticate</a>). If you are not logged in, you can pass
your token as an instance parameter:`,gt,A,ft,T,ht,F,ut,P,Mn=`<a href="/docs/huggingface_hub/pr_2380/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>’s goal is to provide the easiest interface to run inference on Hugging Face models. It
has a simple API that supports the most common tasks. Here is a list of the currently supported tasks:`,dt,K,wn='<thead><tr><th>Domain</th> <th>Task</th> <th>Supported</th> <th>Documentation</th></tr></thead> <tbody><tr><td>Audio</td> <td><a href="https://huggingface.co/tasks/audio-classification" rel="nofollow">Audio Classification</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2380/en/package_reference/inference_client#huggingface_hub.InferenceClient.audio_classification">audio_classification()</a></td></tr> <tr><td>Audio</td> <td><a href="https://huggingface.co/tasks/audio-to-audio" rel="nofollow">Audio-to-Audio</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2380/en/package_reference/inference_client#huggingface_hub.InferenceClient.audio_to_audio">audio_to_audio()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/automatic-speech-recognition" rel="nofollow">Automatic Speech Recognition</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2380/en/package_reference/inference_client#huggingface_hub.InferenceClient.automatic_speech_recognition">automatic_speech_recognition()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/text-to-speech" rel="nofollow">Text-to-Speech</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2380/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_to_speech">text_to_speech()</a></td></tr> <tr><td>Computer Vision</td> <td><a href="https://huggingface.co/tasks/image-classification" rel="nofollow">Image Classification</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2380/en/package_reference/inference_client#huggingface_hub.InferenceClient.image_classification">image_classification()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/image-segmentation" rel="nofollow">Image Segmentation</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2380/en/package_reference/inference_client#huggingface_hub.InferenceClient.image_segmentation">image_segmentation()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/image-to-image" rel="nofollow">Image-to-Image</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2380/en/package_reference/inference_client#huggingface_hub.InferenceClient.image_to_image">image_to_image()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/image-to-text" rel="nofollow">Image-to-Text</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2380/en/package_reference/inference_client#huggingface_hub.InferenceClient.image_to_text">image_to_text()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/object-detection" rel="nofollow">Object Detection</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2380/en/package_reference/inference_client#huggingface_hub.InferenceClient.object_detection">object_detection()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/text-to-image" rel="nofollow">Text-to-Image</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2380/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_to_image">text_to_image()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/zero-shot-image-classification" rel="nofollow">Zero-Shot-Image-Classification</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2380/en/package_reference/inference_client#huggingface_hub.InferenceClient.zero_shot_image_classification">zero_shot_image_classification()</a></td></tr> <tr><td>Multimodal</td> <td><a href="https://huggingface.co/tasks/document-question-answering" rel="nofollow">Documentation Question Answering</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2380/en/package_reference/inference_client#huggingface_hub.InferenceClient.document_question_answering">document_question_answering()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/visual-question-answering" rel="nofollow">Visual Question Answering</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2380/en/package_reference/inference_client#huggingface_hub.InferenceClient.visual_question_answering">visual_question_answering()</a></td></tr> <tr><td>NLP</td> <td>Conversational</td> <td></td> <td><em>deprecated</em>, use Chat Completion</td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/text-generation" rel="nofollow">Chat Completion</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2380/en/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">chat_completion()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/feature-extraction" rel="nofollow">Feature Extraction</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2380/en/package_reference/inference_client#huggingface_hub.InferenceClient.feature_extraction">feature_extraction()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/fill-mask" rel="nofollow">Fill Mask</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2380/en/package_reference/inference_client#huggingface_hub.InferenceClient.fill_mask">fill_mask()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/question-answering" rel="nofollow">Question Answering</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2380/en/package_reference/inference_client#huggingface_hub.InferenceClient.question_answering">question_answering()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/sentence-similarity" rel="nofollow">Sentence Similarity</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2380/en/package_reference/inference_client#huggingface_hub.InferenceClient.sentence_similarity">sentence_similarity()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/summarization" rel="nofollow">Summarization</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2380/en/package_reference/inference_client#huggingface_hub.InferenceClient.summarization">summarization()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/table-question-answering" rel="nofollow">Table Question Answering</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2380/en/package_reference/inference_client#huggingface_hub.InferenceClient.table_question_answering">table_question_answering()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/text-classification" rel="nofollow">Text Classification</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2380/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_classification">text_classification()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/text-generation" rel="nofollow">Text Generation</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2380/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_generation">text_generation()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/token-classification" rel="nofollow">Token Classification</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2380/en/package_reference/inference_client#huggingface_hub.InferenceClient.token_classification">token_classification()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/translation" rel="nofollow">Translation</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2380/en/package_reference/inference_client#huggingface_hub.InferenceClient.translation">translation()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/zero-shot-classification" rel="nofollow">Zero Shot Classification</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2380/en/package_reference/inference_client#huggingface_hub.InferenceClient.zero_shot_classification">zero_shot_classification()</a></td></tr> <tr><td>Tabular</td> <td><a href="https://huggingface.co/tasks/tabular-classification" rel="nofollow">Tabular Classification</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2380/en/package_reference/inference_client#huggingface_hub.InferenceClient.tabular_classification">tabular_classification()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/tabular-regression" rel="nofollow">Tabular Regression</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2380/en/package_reference/inference_client#huggingface_hub.InferenceClient.tabular_regression">tabular_regression()</a></td></tr></tbody>',mt,k,yt,D,bt,O,$n=`However, it is not always possible to cover all use cases. For custom requests, the <a href="/docs/huggingface_hub/pr_2380/en/package_reference/inference_client#huggingface_hub.InferenceClient.post">InferenceClient.post()</a> method
gives you the flexibility to send any request to the Inference API. For example, you can specify how to parse the inputs
and outputs. In the example below, the generated image is returned as raw bytes instead of parsing it as a <code>PIL Image</code>.
This can be helpful if you don’t have <code>Pillow</code> installed in your setup and just care about the binary content of the
image. <a href="/docs/huggingface_hub/pr_2380/en/package_reference/inference_client#huggingface_hub.InferenceClient.post">InferenceClient.post()</a> is also useful to handle tasks that are not yet officially supported.`,_t,ee,jt,te,Mt,ne,Cn=`An async version of the client is also provided, based on <code>asyncio</code> and <code>aiohttp</code>. You can either install <code>aiohttp</code>
directly or use the <code>[inference]</code> extra:`,wt,se,$t,ae,In=`After installation all async API endpoints are available via <a href="/docs/huggingface_hub/pr_2380/en/package_reference/inference_client#huggingface_hub.AsyncInferenceClient">AsyncInferenceClient</a>. Its initialization and APIs are
strictly the same as the sync-only version.`,Ct,le,It,ie,Un='For more information about the <code>asyncio</code> module, please refer to the <a href="https://docs.python.org/3/library/asyncio.html" rel="nofollow">official documentation</a>.',Ut,ce,Zt,re,Zn='In the above section, we saw the main aspects of <a href="/docs/huggingface_hub/pr_2380/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>. Let’s dive into some more advanced tips.',Tt,oe,kt,pe,Tn="When doing inference, there are two main causes for a timeout:",Jt,ge,kn="<li>The inference process takes a long time to complete.</li> <li>The model is not available, for example when Inference API is loading it for the first time.</li>",xt,fe,Jn=`<a href="/docs/huggingface_hub/pr_2380/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> has a global <code>timeout</code> parameter to handle those two aspects. By default, it is set to <code>None</code>,
meaning that the client will wait indefinitely for the inference to complete. If you want more control in your workflow,
you can set it to a specific value in seconds. If the timeout delay expires, an <a href="/docs/huggingface_hub/pr_2380/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError">InferenceTimeoutError</a> is raised.
You can catch it and handle it in your code:`,Wt,he,vt,ue,Gt,de,xn=`Some tasks require binary inputs, for example, when dealing with images or audio files. In this case, <a href="/docs/huggingface_hub/pr_2380/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>
tries to be as permissive as possible and accept different types:`,Vt,me,Wn=`<li>raw <code>bytes</code></li> <li>a file-like object, opened as binary (<code>with open(&quot;audio.flac&quot;, &quot;rb&quot;) as f: ...</code>)</li> <li>a path (<code>str</code> or <code>Path</code>) pointing to a local file</li> <li>a URL (<code>str</code>) pointing to a remote file (e.g. <code>https://...</code>). In this case, the file will be downloaded locally before
sending it to the Inference API.</li>`,qt,ye,Nt,be,Bt,_e,vn=`<a href="/docs/huggingface_hub/pr_2380/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> acts as a replacement for the legacy <a href="/docs/huggingface_hub/pr_2380/en/package_reference/inference_client#huggingface_hub.InferenceApi">InferenceApi</a> client. It adds specific support for tasks and
handles inference on both <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inference API</a> and <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints</a>.`,St,je,Gn='Here is a short guide to help you migrate from <a href="/docs/huggingface_hub/pr_2380/en/package_reference/inference_client#huggingface_hub.InferenceApi">InferenceApi</a> to <a href="/docs/huggingface_hub/pr_2380/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>.',Ht,Me,Yt,we,Vn="Change from",Lt,$e,zt,Ce,qn="to",Et,Ie,Rt,Ue,Xt,Ze,Nn="Change from",Qt,Te,At,ke,Bn="to",Ft,Je,Pt,J,Kt,xe,Dt,We,Sn="Change from",Ot,ve,en,Ge,Hn="to",tn,Ve,nn,qe,sn,Ne,Yn="Change from",an,Be,ln,Se,Ln="to",cn,He,rn,Ye,on,Ee,pn;return C=new j({props:{title:"Run Inference on servers",local:"run-inference-on-servers",headingTag:"h1"}}),I=new Le({props:{$$slots:{default:[as]},$$scope:{ctx:M}}}),v=new j({props:{title:"Getting started",local:"getting-started",headingTag:"h2"}}),V=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBJTBBaW1hZ2UlMjAlM0QlMjBjbGllbnQudGV4dF90b19pbWFnZSglMjJBbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwdGhlJTIwbW9vbi4lMjIpJTBBaW1hZ2Uuc2F2ZSglMjJhc3Ryb25hdXQucG5nJTIyKSUyMCUyMCUyMyUyMCdpbWFnZSclMjBpcyUyMGElMjBQSUwuSW1hZ2UlMjBvYmplY3Q=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(<span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;astronaut.png&quot;</span>)  <span class="hljs-comment"># &#x27;image&#x27; is a PIL.Image object</span>`,wrap:!1}}),B=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwdGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTNGJTIyJTdEJTVEJTBBY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtOEItSW5zdHJ1Y3QlMjIpJTBBY2xpZW50LmNoYXRfY29tcGxldGlvbihtZXNzYWdlcyUyQyUyMG1heF90b2tlbnMlM0QxMDAp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>}]
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.chat_completion(messages, max_tokens=<span class="hljs-number">100</span>)
ChatCompletionOutput(
    choices=[
        ChatCompletionOutputComplete(
            finish_reason=<span class="hljs-string">&#x27;eos_token&#x27;</span>,
            index=<span class="hljs-number">0</span>,
            message=ChatCompletionOutputMessage(
                role=<span class="hljs-string">&#x27;assistant&#x27;</span>,
                content=<span class="hljs-string">&#x27;The capital of France is Paris.&#x27;</span>,
                name=<span class="hljs-literal">None</span>,
                tool_calls=<span class="hljs-literal">None</span>
            ),
            logprobs=<span class="hljs-literal">None</span>
        )
    ],
    created=<span class="hljs-number">1719907176</span>,
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&#x27;&#x27;</span>,
    model=<span class="hljs-string">&#x27;meta-llama/Meta-Llama-3-8B-Instruct&#x27;</span>,
    <span class="hljs-built_in">object</span>=<span class="hljs-string">&#x27;text_completion&#x27;</span>,
    system_fingerprint=<span class="hljs-string">&#x27;2.0.4-sha-f426a33&#x27;</span>,
    usage=ChatCompletionOutputUsage(
        completion_tokens=<span class="hljs-number">8</span>,
        prompt_tokens=<span class="hljs-number">17</span>,
        total_tokens=<span class="hljs-number">25</span>
    )
)`,wrap:!1}}),U=new Le({props:{warning:!0,$$slots:{default:[ls]},$$scope:{ctx:M}}}),H=new j({props:{title:"Using a specific model",local:"using-a-specific-model",headingTag:"h3"}}),L=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChtb2RlbCUzRCUyMnByb21wdGhlcm8lMkZvcGVuam91cm5leS12NCUyMiklMEFjbGllbnQudGV4dF90b19pbWFnZSguLi4pJTBBY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCklMEFjbGllbnQudGV4dF90b19pbWFnZSguLi4lMkMlMjBtb2RlbCUzRCUyMnByb21wdGhlcm8lMkZvcGVuam91cm5leS12NCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-comment"># Initialize client for a specific model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(model=<span class="hljs-string">&quot;prompthero/openjourney-v4&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_to_image(...)
<span class="hljs-comment"># Or use a generic client but pass your model as an argument</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_to_image(..., model=<span class="hljs-string">&quot;prompthero/openjourney-v4&quot;</span>)`,wrap:!1}}),Z=new Le({props:{$$slots:{default:[is]},$$scope:{ctx:M}}}),z=new j({props:{title:"Using a specific URL",local:"using-a-specific-url",headingTag:"h3"}}),R=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChtb2RlbCUzRCUyMmh0dHBzJTNBJTJGJTJGdXUxNDlyZXo2Z3c5ZWhlai5ldS13ZXN0LTEuYXdzLmVuZHBvaW50cy5odWdnaW5nZmFjZS5jbG91ZCUyRmRlZXBmbG95ZC1pZiUyMiklMEFjbGllbnQlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQoKSUwQWNsaWVudC50ZXh0X3RvX2ltYWdlKC4uLiUyQyUyMG1vZGVsJTNEJTIyaHR0cHMlM0ElMkYlMkZ1dTE0OXJlejZndzllaGVqLmV1LXdlc3QtMS5hd3MuZW5kcG9pbnRzLmh1Z2dpbmdmYWNlLmNsb3VkJTJGZGVlcGZsb3lkLWlmJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(model=<span class="hljs-string">&quot;https://uu149rez6gw9ehej.eu-west-1.aws.endpoints.huggingface.cloud/deepfloyd-if&quot;</span>)
<span class="hljs-comment"># or</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_to_image(..., model=<span class="hljs-string">&quot;https://uu149rez6gw9ehej.eu-west-1.aws.endpoints.huggingface.cloud/deepfloyd-if&quot;</span>)`,wrap:!1}}),X=new j({props:{title:"Authentication",local:"authentication",headingTag:"h3"}}),A=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCh0b2tlbiUzRCUyMmhmXyoqKiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(token=<span class="hljs-string">&quot;hf_***&quot;</span>)`,wrap:!1}}),T=new Le({props:{$$slots:{default:[cs]},$$scope:{ctx:M}}}),F=new j({props:{title:"Supported tasks",local:"supported-tasks",headingTag:"h2"}}),k=new Le({props:{$$slots:{default:[rs]},$$scope:{ctx:M}}}),D=new j({props:{title:"Custom requests",local:"custom-requests",headingTag:"h2"}}),ee=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBcmVzcG9uc2UlMjAlM0QlMjBjbGllbnQucG9zdChqc29uJTNEJTdCJTIyaW5wdXRzJTIyJTNBJTIwJTIyQW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMHRoZSUyMG1vb24uJTIyJTdEJTJDJTIwbW9kZWwlM0QlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMi0xJTIyKSUwQXJlc3BvbnNlLmNvbnRlbnQlMjAlMjMlMjByYXclMjBieXRlcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>response = client.post(json={<span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>}, model=<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.content <span class="hljs-comment"># raw bytes</span>
<span class="hljs-string">b&#x27;...&#x27;</span>`,wrap:!1}}),te=new j({props:{title:"Async client",local:"async-client",headingTag:"h2"}}),se=new _({props:{code:"cGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMGh1Z2dpbmdmYWNlX2h1YiU1QmluZmVyZW5jZSU1RCUwQSUyMyUyMG9yJTBBJTIzJTIwcGlwJTIwaW5zdGFsbCUyMGFpb2h0dHA=",highlighted:`pip install --upgrade huggingface_hub[inference]
<span class="hljs-comment"># or</span>
<span class="hljs-comment"># pip install aiohttp</span>`,wrap:!1}}),le=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQSUwQWltYWdlJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQudGV4dF90b19pbWFnZSglMjJBbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwdGhlJTIwbW9vbi4lMjIpJTBBaW1hZ2Uuc2F2ZSglMjJhc3Ryb25hdXQucG5nJTIyKSUwQSUwQWFzeW5jJTIwZm9yJTIwdG9rZW4lMjBpbiUyMGF3YWl0JTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMjJUaGUlMjBIdWdnaW5nZmFjZSUyMEh1YiUyMGlzJTIyJTJDJTIwc3RyZWFtJTNEVHJ1ZSklM0ElMEElMjAlMjAlMjAlMjBwcmludCh0b2tlbiUyQyUyMGVuZCUzRCUyMiUyMik=",highlighted:`<span class="hljs-comment"># Code must be run in a asyncio concurrent context.</span>
<span class="hljs-comment"># $ python -m asyncio</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-keyword">await</span> client.text_to_image(<span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;astronaut.png&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> <span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;The Huggingface Hub is&quot;</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(token, end=<span class="hljs-string">&quot;&quot;</span>)
 a platform <span class="hljs-keyword">for</span> sharing <span class="hljs-keyword">and</span> discussing ML-related content.`,wrap:!1}}),ce=new j({props:{title:"Advanced tips",local:"advanced-tips",headingTag:"h2"}}),oe=new j({props:{title:"Timeout",local:"timeout",headingTag:"h3"}}),he=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUyQyUyMEluZmVyZW5jZVRpbWVvdXRFcnJvciUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCh0aW1lb3V0JTNEMzApJTBBdHJ5JTNBJTBBJTIwJTIwJTIwJTIwY2xpZW50LnRleHRfdG9faW1hZ2UoLi4uKSUwQWV4Y2VwdCUyMEluZmVyZW5jZVRpbWVvdXRFcnJvciUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMkluZmVyZW5jZSUyMHRpbWVkJTIwb3V0JTIwYWZ0ZXIlMjAzMHMuJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient, InferenceTimeoutError
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(timeout=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">try</span>:
<span class="hljs-meta">... </span>    client.text_to_image(...)
<span class="hljs-meta">... </span><span class="hljs-keyword">except</span> InferenceTimeoutError:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Inference timed out after 30s.&quot;</span>)`,wrap:!1}}),ue=new j({props:{title:"Binary inputs",local:"binary-inputs",headingTag:"h3"}}),ye=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmltYWdlX2NsYXNzaWZpY2F0aW9uKCUyMmh0dHBzJTNBJTJGJTJGdXBsb2FkLndpa2ltZWRpYS5vcmclMkZ3aWtpcGVkaWElMkZjb21tb25zJTJGdGh1bWIlMkY0JTJGNDMlMkZDdXRlX2RvZy5qcGclMkYzMjBweC1DdXRlX2RvZy5qcGclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.image_classification(<span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>)
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9779096841812134</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;Blenheim spaniel&#x27;</span>}, ...]`,wrap:!1}}),be=new j({props:{title:"Legacy InferenceAPI client",local:"legacy-inferenceapi-client",headingTag:"h2"}}),Me=new j({props:{title:"Initialization",local:"initialization",headingTag:"h3"}}),$e=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUFwaSUwQWluZmVyZW5jZSUyMCUzRCUyMEluZmVyZW5jZUFwaShyZXBvX2lkJTNEJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIlMkMlMjB0b2tlbiUzREFQSV9UT0tFTik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceApi
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(repo_id=<span class="hljs-string">&quot;bert-base-uncased&quot;</span>, token=API_TOKEN)`,wrap:!1}}),Ie=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWluZmVyZW5jZSUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChtb2RlbCUzRCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyJTJDJTIwdG9rZW4lM0RBUElfVE9LRU4p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceClient(model=<span class="hljs-string">&quot;bert-base-uncased&quot;</span>, token=API_TOKEN)`,wrap:!1}}),Ue=new j({props:{title:"Run on a specific task",local:"run-on-a-specific-task",headingTag:"h3"}}),Te=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUFwaSUwQWluZmVyZW5jZSUyMCUzRCUyMEluZmVyZW5jZUFwaShyZXBvX2lkJTNEJTIycGFyYXBocmFzZS14bG0tci1tdWx0aWxpbmd1YWwtdjElMjIlMkMlMjB0YXNrJTNEJTIyZmVhdHVyZS1leHRyYWN0aW9uJTIyKSUwQWluZmVyZW5jZSguLi4p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceApi
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(repo_id=<span class="hljs-string">&quot;paraphrase-xlm-r-multilingual-v1&quot;</span>, task=<span class="hljs-string">&quot;feature-extraction&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(...)`,wrap:!1}}),Je=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWluZmVyZW5jZSUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBaW5mZXJlbmNlLmZlYXR1cmVfZXh0cmFjdGlvbiguLi4lMkMlMjBtb2RlbCUzRCUyMnBhcmFwaHJhc2UteGxtLXItbXVsdGlsaW5ndWFsLXYxJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>inference.feature_extraction(..., model=<span class="hljs-string">&quot;paraphrase-xlm-r-multilingual-v1&quot;</span>)`,wrap:!1}}),J=new Le({props:{$$slots:{default:[os]},$$scope:{ctx:M}}}),xe=new j({props:{title:"Run custom request",local:"run-custom-request",headingTag:"h3"}}),ve=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUFwaSUwQWluZmVyZW5jZSUyMCUzRCUyMEluZmVyZW5jZUFwaShyZXBvX2lkJTNEJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIpJTBBaW5mZXJlbmNlKGlucHV0cyUzRCUyMlRoZSUyMGdvYWwlMjBvZiUyMGxpZmUlMjBpcyUyMCU1Qk1BU0slNUQuJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceApi
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(repo_id=<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(inputs=<span class="hljs-string">&quot;The goal of life is [MASK].&quot;</span>)
[{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;the goal of life is life.&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.10933292657136917</span>, <span class="hljs-string">&#x27;token&#x27;</span>: <span class="hljs-number">2166</span>, <span class="hljs-string">&#x27;token_str&#x27;</span>: <span class="hljs-string">&#x27;life&#x27;</span>}]`,wrap:!1}}),Ve=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBcmVzcG9uc2UlMjAlM0QlMjBjbGllbnQucG9zdChqc29uJTNEJTdCJTIyaW5wdXRzJTIyJTNBJTIwJTIyVGhlJTIwZ29hbCUyMG9mJTIwbGlmZSUyMGlzJTIwJTVCTUFTSyU1RC4lMjIlN0QlMkMlMjBtb2RlbCUzRCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyKSUwQXJlc3BvbnNlLmpzb24oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>response = client.post(json={<span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;The goal of life is [MASK].&quot;</span>}, model=<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.json()
[{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;the goal of life is life.&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.10933292657136917</span>, <span class="hljs-string">&#x27;token&#x27;</span>: <span class="hljs-number">2166</span>, <span class="hljs-string">&#x27;token_str&#x27;</span>: <span class="hljs-string">&#x27;life&#x27;</span>}]`,wrap:!1}}),qe=new j({props:{title:"Run with parameters",local:"run-with-parameters",headingTag:"h3"}}),Be=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUFwaSUwQWluZmVyZW5jZSUyMCUzRCUyMEluZmVyZW5jZUFwaShyZXBvX2lkJTNEJTIydHlwZWZvcm0lMkZkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1tbmxpJTIyKSUwQWlucHV0cyUyMCUzRCUyMCUyMkhpJTJDJTIwSSUyMHJlY2VudGx5JTIwYm91Z2h0JTIwYSUyMGRldmljZSUyMGZyb20lMjB5b3VyJTIwY29tcGFueSUyMGJ1dCUyMGl0JTIwaXMlMjBub3QlMjB3b3JraW5nJTIwYXMlMjBhZHZlcnRpc2VkJTIwYW5kJTIwSSUyMHdvdWxkJTIwbGlrZSUyMHRvJTIwZ2V0JTIwcmVpbWJ1cnNlZCElMjIlMEFwYXJhbXMlMjAlM0QlMjAlN0IlMjJjYW5kaWRhdGVfbGFiZWxzJTIyJTNBJTVCJTIycmVmdW5kJTIyJTJDJTIwJTIybGVnYWwlMjIlMkMlMjAlMjJmYXElMjIlNUQlN0QlMEFpbmZlcmVuY2UoaW5wdXRzJTJDJTIwcGFyYW1zKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceApi
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(repo_id=<span class="hljs-string">&quot;typeform/distilbert-base-uncased-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = <span class="hljs-string">&quot;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>params = {<span class="hljs-string">&quot;candidate_labels&quot;</span>:[<span class="hljs-string">&quot;refund&quot;</span>, <span class="hljs-string">&quot;legal&quot;</span>, <span class="hljs-string">&quot;faq&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(inputs, params)
{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>: [<span class="hljs-string">&#x27;refund&#x27;</span>, <span class="hljs-string">&#x27;faq&#x27;</span>, <span class="hljs-string">&#x27;legal&#x27;</span>], <span class="hljs-string">&#x27;scores&#x27;</span>: [<span class="hljs-number">0.9378499388694763</span>, <span class="hljs-number">0.04914155602455139</span>, <span class="hljs-number">0.013008488342165947</span>]}`,wrap:!1}}),He=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBaW5wdXRzJTIwJTNEJTIwJTIySGklMkMlMjBJJTIwcmVjZW50bHklMjBib3VnaHQlMjBhJTIwZGV2aWNlJTIwZnJvbSUyMHlvdXIlMjBjb21wYW55JTIwYnV0JTIwaXQlMjBpcyUyMG5vdCUyMHdvcmtpbmclMjBhcyUyMGFkdmVydGlzZWQlMjBhbmQlMjBJJTIwd291bGQlMjBsaWtlJTIwdG8lMjBnZXQlMjByZWltYnVyc2VkISUyMiUwQXBhcmFtcyUyMCUzRCUyMCU3QiUyMmNhbmRpZGF0ZV9sYWJlbHMlMjIlM0ElNUIlMjJyZWZ1bmQlMjIlMkMlMjAlMjJsZWdhbCUyMiUyQyUyMCUyMmZhcSUyMiU1RCU3RCUwQXJlc3BvbnNlJTIwJTNEJTIwY2xpZW50LnBvc3QoanNvbiUzRCU3QiUyMmlucHV0cyUyMiUzQSUyMGlucHV0cyUyQyUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjBwYXJhbXMlN0QlMkMlMjBtb2RlbCUzRCUyMnR5cGVmb3JtJTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtbW5saSUyMiklMEFyZXNwb25zZS5qc29uKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = <span class="hljs-string">&quot;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>params = {<span class="hljs-string">&quot;candidate_labels&quot;</span>:[<span class="hljs-string">&quot;refund&quot;</span>, <span class="hljs-string">&quot;legal&quot;</span>, <span class="hljs-string">&quot;faq&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>response = client.post(json={<span class="hljs-string">&quot;inputs&quot;</span>: inputs, <span class="hljs-string">&quot;parameters&quot;</span>: params}, model=<span class="hljs-string">&quot;typeform/distilbert-base-uncased-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.json()
{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>: [<span class="hljs-string">&#x27;refund&#x27;</span>, <span class="hljs-string">&#x27;faq&#x27;</span>, <span class="hljs-string">&#x27;legal&#x27;</span>], <span class="hljs-string">&#x27;scores&#x27;</span>: [<span class="hljs-number">0.9378499388694763</span>, <span class="hljs-number">0.04914155602455139</span>, <span class="hljs-number">0.013008488342165947</span>]}`,wrap:!1}}),Ye=new ss({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/guides/inference.md"}}),{c(){i=c("meta"),y=a(),d=c("p"),b=a(),o(C.$$.fragment),w=a(),$=c("p"),$.innerHTML=gn,Re=a(),x=c("ul"),x.innerHTML=fn,Xe=a(),W=c("p"),W.innerHTML=hn,Qe=a(),o(I.$$.fragment),Ae=a(),o(v.$$.fragment),Fe=a(),G=c("p"),G.textContent=un,Pe=a(),o(V.$$.fragment),Ke=a(),q=c("p"),q.innerHTML=dn,De=a(),N=c("p"),N.innerHTML=mn,Oe=a(),o(B.$$.fragment),et=a(),S=c("p"),S.innerHTML=yn,tt=a(),o(U.$$.fragment),nt=a(),o(H.$$.fragment),st=a(),Y=c("p"),Y.textContent=bn,at=a(),o(L.$$.fragment),lt=a(),o(Z.$$.fragment),it=a(),o(z.$$.fragment),ct=a(),E=c("p"),E.innerHTML=_n,rt=a(),o(R.$$.fragment),ot=a(),o(X.$$.fragment),pt=a(),Q=c("p"),Q.innerHTML=jn,gt=a(),o(A.$$.fragment),ft=a(),o(T.$$.fragment),ht=a(),o(F.$$.fragment),ut=a(),P=c("p"),P.innerHTML=Mn,dt=a(),K=c("table"),K.innerHTML=wn,mt=a(),o(k.$$.fragment),yt=a(),o(D.$$.fragment),bt=a(),O=c("p"),O.innerHTML=$n,_t=a(),o(ee.$$.fragment),jt=a(),o(te.$$.fragment),Mt=a(),ne=c("p"),ne.innerHTML=Cn,wt=a(),o(se.$$.fragment),$t=a(),ae=c("p"),ae.innerHTML=In,Ct=a(),o(le.$$.fragment),It=a(),ie=c("p"),ie.innerHTML=Un,Ut=a(),o(ce.$$.fragment),Zt=a(),re=c("p"),re.innerHTML=Zn,Tt=a(),o(oe.$$.fragment),kt=a(),pe=c("p"),pe.textContent=Tn,Jt=a(),ge=c("ul"),ge.innerHTML=kn,xt=a(),fe=c("p"),fe.innerHTML=Jn,Wt=a(),o(he.$$.fragment),vt=a(),o(ue.$$.fragment),Gt=a(),de=c("p"),de.innerHTML=xn,Vt=a(),me=c("ul"),me.innerHTML=Wn,qt=a(),o(ye.$$.fragment),Nt=a(),o(be.$$.fragment),Bt=a(),_e=c("p"),_e.innerHTML=vn,St=a(),je=c("p"),je.innerHTML=Gn,Ht=a(),o(Me.$$.fragment),Yt=a(),we=c("p"),we.textContent=Vn,Lt=a(),o($e.$$.fragment),zt=a(),Ce=c("p"),Ce.textContent=qn,Et=a(),o(Ie.$$.fragment),Rt=a(),o(Ue.$$.fragment),Xt=a(),Ze=c("p"),Ze.textContent=Nn,Qt=a(),o(Te.$$.fragment),At=a(),ke=c("p"),ke.textContent=Bn,Ft=a(),o(Je.$$.fragment),Pt=a(),o(J.$$.fragment),Kt=a(),o(xe.$$.fragment),Dt=a(),We=c("p"),We.textContent=Sn,Ot=a(),o(ve.$$.fragment),en=a(),Ge=c("p"),Ge.textContent=Hn,tn=a(),o(Ve.$$.fragment),nn=a(),o(qe.$$.fragment),sn=a(),Ne=c("p"),Ne.textContent=Yn,an=a(),o(Be.$$.fragment),ln=a(),Se=c("p"),Se.textContent=Ln,cn=a(),o(He.$$.fragment),rn=a(),o(Ye.$$.fragment),on=a(),Ee=c("p"),this.h()},l(e){const t=ts("svelte-u9bgzb",document.head);i=r(t,"META",{name:!0,content:!0}),t.forEach(n),y=l(e),d=r(e,"P",{}),Fn(d).forEach(n),b=l(e),p(C.$$.fragment,e),w=l(e),$=r(e,"P",{"data-svelte-h":!0}),m($)!=="svelte-411gzg"&&($.innerHTML=gn),Re=l(e),x=r(e,"UL",{"data-svelte-h":!0}),m(x)!=="svelte-lzzf1y"&&(x.innerHTML=fn),Xe=l(e),W=r(e,"P",{"data-svelte-h":!0}),m(W)!=="svelte-3odvon"&&(W.innerHTML=hn),Qe=l(e),p(I.$$.fragment,e),Ae=l(e),p(v.$$.fragment,e),Fe=l(e),G=r(e,"P",{"data-svelte-h":!0}),m(G)!=="svelte-8lplub"&&(G.textContent=un),Pe=l(e),p(V.$$.fragment,e),Ke=l(e),q=r(e,"P",{"data-svelte-h":!0}),m(q)!=="svelte-md4tij"&&(q.innerHTML=dn),De=l(e),N=r(e,"P",{"data-svelte-h":!0}),m(N)!=="svelte-vygb47"&&(N.innerHTML=mn),Oe=l(e),p(B.$$.fragment,e),et=l(e),S=r(e,"P",{"data-svelte-h":!0}),m(S)!=="svelte-1p79pnp"&&(S.innerHTML=yn),tt=l(e),p(U.$$.fragment,e),nt=l(e),p(H.$$.fragment,e),st=l(e),Y=r(e,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-1npu22n"&&(Y.textContent=bn),at=l(e),p(L.$$.fragment,e),lt=l(e),p(Z.$$.fragment,e),it=l(e),p(z.$$.fragment,e),ct=l(e),E=r(e,"P",{"data-svelte-h":!0}),m(E)!=="svelte-cp0irx"&&(E.innerHTML=_n),rt=l(e),p(R.$$.fragment,e),ot=l(e),p(X.$$.fragment,e),pt=l(e),Q=r(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-7bexp9"&&(Q.innerHTML=jn),gt=l(e),p(A.$$.fragment,e),ft=l(e),p(T.$$.fragment,e),ht=l(e),p(F.$$.fragment,e),ut=l(e),P=r(e,"P",{"data-svelte-h":!0}),m(P)!=="svelte-1bhwudt"&&(P.innerHTML=Mn),dt=l(e),K=r(e,"TABLE",{"data-svelte-h":!0}),m(K)!=="svelte-1cbqdrs"&&(K.innerHTML=wn),mt=l(e),p(k.$$.fragment,e),yt=l(e),p(D.$$.fragment,e),bt=l(e),O=r(e,"P",{"data-svelte-h":!0}),m(O)!=="svelte-1nh3jww"&&(O.innerHTML=$n),_t=l(e),p(ee.$$.fragment,e),jt=l(e),p(te.$$.fragment,e),Mt=l(e),ne=r(e,"P",{"data-svelte-h":!0}),m(ne)!=="svelte-1gqwj00"&&(ne.innerHTML=Cn),wt=l(e),p(se.$$.fragment,e),$t=l(e),ae=r(e,"P",{"data-svelte-h":!0}),m(ae)!=="svelte-dg1fz5"&&(ae.innerHTML=In),Ct=l(e),p(le.$$.fragment,e),It=l(e),ie=r(e,"P",{"data-svelte-h":!0}),m(ie)!=="svelte-q492az"&&(ie.innerHTML=Un),Ut=l(e),p(ce.$$.fragment,e),Zt=l(e),re=r(e,"P",{"data-svelte-h":!0}),m(re)!=="svelte-l2xwlc"&&(re.innerHTML=Zn),Tt=l(e),p(oe.$$.fragment,e),kt=l(e),pe=r(e,"P",{"data-svelte-h":!0}),m(pe)!=="svelte-8gznjs"&&(pe.textContent=Tn),Jt=l(e),ge=r(e,"UL",{"data-svelte-h":!0}),m(ge)!=="svelte-ovc80h"&&(ge.innerHTML=kn),xt=l(e),fe=r(e,"P",{"data-svelte-h":!0}),m(fe)!=="svelte-1fl1r8m"&&(fe.innerHTML=Jn),Wt=l(e),p(he.$$.fragment,e),vt=l(e),p(ue.$$.fragment,e),Gt=l(e),de=r(e,"P",{"data-svelte-h":!0}),m(de)!=="svelte-y4y4ow"&&(de.innerHTML=xn),Vt=l(e),me=r(e,"UL",{"data-svelte-h":!0}),m(me)!=="svelte-vaeuct"&&(me.innerHTML=Wn),qt=l(e),p(ye.$$.fragment,e),Nt=l(e),p(be.$$.fragment,e),Bt=l(e),_e=r(e,"P",{"data-svelte-h":!0}),m(_e)!=="svelte-jdm3cn"&&(_e.innerHTML=vn),St=l(e),je=r(e,"P",{"data-svelte-h":!0}),m(je)!=="svelte-v29peu"&&(je.innerHTML=Gn),Ht=l(e),p(Me.$$.fragment,e),Yt=l(e),we=r(e,"P",{"data-svelte-h":!0}),m(we)!=="svelte-ft9vbs"&&(we.textContent=Vn),Lt=l(e),p($e.$$.fragment,e),zt=l(e),Ce=r(e,"P",{"data-svelte-h":!0}),m(Ce)!=="svelte-8wg17z"&&(Ce.textContent=qn),Et=l(e),p(Ie.$$.fragment,e),Rt=l(e),p(Ue.$$.fragment,e),Xt=l(e),Ze=r(e,"P",{"data-svelte-h":!0}),m(Ze)!=="svelte-ft9vbs"&&(Ze.textContent=Nn),Qt=l(e),p(Te.$$.fragment,e),At=l(e),ke=r(e,"P",{"data-svelte-h":!0}),m(ke)!=="svelte-8wg17z"&&(ke.textContent=Bn),Ft=l(e),p(Je.$$.fragment,e),Pt=l(e),p(J.$$.fragment,e),Kt=l(e),p(xe.$$.fragment,e),Dt=l(e),We=r(e,"P",{"data-svelte-h":!0}),m(We)!=="svelte-ft9vbs"&&(We.textContent=Sn),Ot=l(e),p(ve.$$.fragment,e),en=l(e),Ge=r(e,"P",{"data-svelte-h":!0}),m(Ge)!=="svelte-8wg17z"&&(Ge.textContent=Hn),tn=l(e),p(Ve.$$.fragment,e),nn=l(e),p(qe.$$.fragment,e),sn=l(e),Ne=r(e,"P",{"data-svelte-h":!0}),m(Ne)!=="svelte-ft9vbs"&&(Ne.textContent=Yn),an=l(e),p(Be.$$.fragment,e),ln=l(e),Se=r(e,"P",{"data-svelte-h":!0}),m(Se)!=="svelte-8wg17z"&&(Se.textContent=Ln),cn=l(e),p(He.$$.fragment,e),rn=l(e),p(Ye.$$.fragment,e),on=l(e),Ee=r(e,"P",{}),Fn(Ee).forEach(n),this.h()},h(){Pn(i,"name","hf:doc:metadata"),Pn(i,"content",gs)},m(e,t){ns(document.head,i),s(e,y,t),s(e,d,t),s(e,b,t),g(C,e,t),s(e,w,t),s(e,$,t),s(e,Re,t),s(e,x,t),s(e,Xe,t),s(e,W,t),s(e,Qe,t),g(I,e,t),s(e,Ae,t),g(v,e,t),s(e,Fe,t),s(e,G,t),s(e,Pe,t),g(V,e,t),s(e,Ke,t),s(e,q,t),s(e,De,t),s(e,N,t),s(e,Oe,t),g(B,e,t),s(e,et,t),s(e,S,t),s(e,tt,t),g(U,e,t),s(e,nt,t),g(H,e,t),s(e,st,t),s(e,Y,t),s(e,at,t),g(L,e,t),s(e,lt,t),g(Z,e,t),s(e,it,t),g(z,e,t),s(e,ct,t),s(e,E,t),s(e,rt,t),g(R,e,t),s(e,ot,t),g(X,e,t),s(e,pt,t),s(e,Q,t),s(e,gt,t),g(A,e,t),s(e,ft,t),g(T,e,t),s(e,ht,t),g(F,e,t),s(e,ut,t),s(e,P,t),s(e,dt,t),s(e,K,t),s(e,mt,t),g(k,e,t),s(e,yt,t),g(D,e,t),s(e,bt,t),s(e,O,t),s(e,_t,t),g(ee,e,t),s(e,jt,t),g(te,e,t),s(e,Mt,t),s(e,ne,t),s(e,wt,t),g(se,e,t),s(e,$t,t),s(e,ae,t),s(e,Ct,t),g(le,e,t),s(e,It,t),s(e,ie,t),s(e,Ut,t),g(ce,e,t),s(e,Zt,t),s(e,re,t),s(e,Tt,t),g(oe,e,t),s(e,kt,t),s(e,pe,t),s(e,Jt,t),s(e,ge,t),s(e,xt,t),s(e,fe,t),s(e,Wt,t),g(he,e,t),s(e,vt,t),g(ue,e,t),s(e,Gt,t),s(e,de,t),s(e,Vt,t),s(e,me,t),s(e,qt,t),g(ye,e,t),s(e,Nt,t),g(be,e,t),s(e,Bt,t),s(e,_e,t),s(e,St,t),s(e,je,t),s(e,Ht,t),g(Me,e,t),s(e,Yt,t),s(e,we,t),s(e,Lt,t),g($e,e,t),s(e,zt,t),s(e,Ce,t),s(e,Et,t),g(Ie,e,t),s(e,Rt,t),g(Ue,e,t),s(e,Xt,t),s(e,Ze,t),s(e,Qt,t),g(Te,e,t),s(e,At,t),s(e,ke,t),s(e,Ft,t),g(Je,e,t),s(e,Pt,t),g(J,e,t),s(e,Kt,t),g(xe,e,t),s(e,Dt,t),s(e,We,t),s(e,Ot,t),g(ve,e,t),s(e,en,t),s(e,Ge,t),s(e,tn,t),g(Ve,e,t),s(e,nn,t),g(qe,e,t),s(e,sn,t),s(e,Ne,t),s(e,an,t),g(Be,e,t),s(e,ln,t),s(e,Se,t),s(e,cn,t),g(He,e,t),s(e,rn,t),g(Ye,e,t),s(e,on,t),s(e,Ee,t),pn=!0},p(e,[t]){const zn={};t&2&&(zn.$$scope={dirty:t,ctx:e}),I.$set(zn);const En={};t&2&&(En.$$scope={dirty:t,ctx:e}),U.$set(En);const Rn={};t&2&&(Rn.$$scope={dirty:t,ctx:e}),Z.$set(Rn);const Xn={};t&2&&(Xn.$$scope={dirty:t,ctx:e}),T.$set(Xn);const Qn={};t&2&&(Qn.$$scope={dirty:t,ctx:e}),k.$set(Qn);const An={};t&2&&(An.$$scope={dirty:t,ctx:e}),J.$set(An)},i(e){pn||(f(C.$$.fragment,e),f(I.$$.fragment,e),f(v.$$.fragment,e),f(V.$$.fragment,e),f(B.$$.fragment,e),f(U.$$.fragment,e),f(H.$$.fragment,e),f(L.$$.fragment,e),f(Z.$$.fragment,e),f(z.$$.fragment,e),f(R.$$.fragment,e),f(X.$$.fragment,e),f(A.$$.fragment,e),f(T.$$.fragment,e),f(F.$$.fragment,e),f(k.$$.fragment,e),f(D.$$.fragment,e),f(ee.$$.fragment,e),f(te.$$.fragment,e),f(se.$$.fragment,e),f(le.$$.fragment,e),f(ce.$$.fragment,e),f(oe.$$.fragment,e),f(he.$$.fragment,e),f(ue.$$.fragment,e),f(ye.$$.fragment,e),f(be.$$.fragment,e),f(Me.$$.fragment,e),f($e.$$.fragment,e),f(Ie.$$.fragment,e),f(Ue.$$.fragment,e),f(Te.$$.fragment,e),f(Je.$$.fragment,e),f(J.$$.fragment,e),f(xe.$$.fragment,e),f(ve.$$.fragment,e),f(Ve.$$.fragment,e),f(qe.$$.fragment,e),f(Be.$$.fragment,e),f(He.$$.fragment,e),f(Ye.$$.fragment,e),pn=!0)},o(e){h(C.$$.fragment,e),h(I.$$.fragment,e),h(v.$$.fragment,e),h(V.$$.fragment,e),h(B.$$.fragment,e),h(U.$$.fragment,e),h(H.$$.fragment,e),h(L.$$.fragment,e),h(Z.$$.fragment,e),h(z.$$.fragment,e),h(R.$$.fragment,e),h(X.$$.fragment,e),h(A.$$.fragment,e),h(T.$$.fragment,e),h(F.$$.fragment,e),h(k.$$.fragment,e),h(D.$$.fragment,e),h(ee.$$.fragment,e),h(te.$$.fragment,e),h(se.$$.fragment,e),h(le.$$.fragment,e),h(ce.$$.fragment,e),h(oe.$$.fragment,e),h(he.$$.fragment,e),h(ue.$$.fragment,e),h(ye.$$.fragment,e),h(be.$$.fragment,e),h(Me.$$.fragment,e),h($e.$$.fragment,e),h(Ie.$$.fragment,e),h(Ue.$$.fragment,e),h(Te.$$.fragment,e),h(Je.$$.fragment,e),h(J.$$.fragment,e),h(xe.$$.fragment,e),h(ve.$$.fragment,e),h(Ve.$$.fragment,e),h(qe.$$.fragment,e),h(Be.$$.fragment,e),h(He.$$.fragment,e),h(Ye.$$.fragment,e),pn=!1},d(e){e&&(n(y),n(d),n(b),n(w),n($),n(Re),n(x),n(Xe),n(W),n(Qe),n(Ae),n(Fe),n(G),n(Pe),n(Ke),n(q),n(De),n(N),n(Oe),n(et),n(S),n(tt),n(nt),n(st),n(Y),n(at),n(lt),n(it),n(ct),n(E),n(rt),n(ot),n(pt),n(Q),n(gt),n(ft),n(ht),n(ut),n(P),n(dt),n(K),n(mt),n(yt),n(bt),n(O),n(_t),n(jt),n(Mt),n(ne),n(wt),n($t),n(ae),n(Ct),n(It),n(ie),n(Ut),n(Zt),n(re),n(Tt),n(kt),n(pe),n(Jt),n(ge),n(xt),n(fe),n(Wt),n(vt),n(Gt),n(de),n(Vt),n(me),n(qt),n(Nt),n(Bt),n(_e),n(St),n(je),n(Ht),n(Yt),n(we),n(Lt),n(zt),n(Ce),n(Et),n(Rt),n(Xt),n(Ze),n(Qt),n(At),n(ke),n(Ft),n(Pt),n(Kt),n(Dt),n(We),n(Ot),n(en),n(Ge),n(tn),n(nn),n(sn),n(Ne),n(an),n(ln),n(Se),n(cn),n(rn),n(on),n(Ee)),n(i),u(C,e),u(I,e),u(v,e),u(V,e),u(B,e),u(U,e),u(H,e),u(L,e),u(Z,e),u(z,e),u(R,e),u(X,e),u(A,e),u(T,e),u(F,e),u(k,e),u(D,e),u(ee,e),u(te,e),u(se,e),u(le,e),u(ce,e),u(oe,e),u(he,e),u(ue,e),u(ye,e),u(be,e),u(Me,e),u($e,e),u(Ie,e),u(Ue,e),u(Te,e),u(Je,e),u(J,e),u(xe,e),u(ve,e),u(Ve,e),u(qe,e),u(Be,e),u(He,e),u(Ye,e)}}}const gs='{"title":"Run Inference on servers","local":"run-inference-on-servers","sections":[{"title":"Getting started","local":"getting-started","sections":[{"title":"Using a specific model","local":"using-a-specific-model","sections":[],"depth":3},{"title":"Using a specific URL","local":"using-a-specific-url","sections":[],"depth":3},{"title":"Authentication","local":"authentication","sections":[],"depth":3}],"depth":2},{"title":"Supported tasks","local":"supported-tasks","sections":[],"depth":2},{"title":"Custom requests","local":"custom-requests","sections":[],"depth":2},{"title":"Async client","local":"async-client","sections":[],"depth":2},{"title":"Advanced tips","local":"advanced-tips","sections":[{"title":"Timeout","local":"timeout","sections":[],"depth":3},{"title":"Binary inputs","local":"binary-inputs","sections":[],"depth":3}],"depth":2},{"title":"Legacy InferenceAPI client","local":"legacy-inferenceapi-client","sections":[{"title":"Initialization","local":"initialization","sections":[],"depth":3},{"title":"Run on a specific task","local":"run-on-a-specific-task","sections":[],"depth":3},{"title":"Run custom request","local":"run-custom-request","sections":[],"depth":3},{"title":"Run with parameters","local":"run-with-parameters","sections":[],"depth":3}],"depth":2}],"depth":1}';function fs(M){return Dn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bs extends On{constructor(i){super(),es(this,i,fs,ps,Kn,{})}}export{bs as component};
