import{s as rs,o as ps,n as ms}from"../chunks/scheduler.25b97de1.js";import{S as us,i as cs,g as i,s as l,r as p,A as ds,h as o,f as s,c as n,j as os,u as m,x as r,k as Gt,y as hs,a,v as u,d as c,t as d,w as h}from"../chunks/index.d9030fc9.js";import{T as gs}from"../chunks/Tip.baa67368.js";import{C as f}from"../chunks/CodeBlock.e6cd0d95.js";import{D as Ms}from"../chunks/DocNotebookDropdown.5ea6cb78.js";import{H as M,E as ys}from"../chunks/EditOnGithub.91d95064.js";function fs(Ue){let g,j='If you’re interested in basic LLM usage, our high-level <a href="pipeline_tutorial"><code>Pipeline</code></a> interface is a great starting point. However, LLMs often require advanced features like quantization and fine control of the token selection step, which is best done through <a href="/docs/transformers/pr_31155/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>. Autoregressive generation with LLMs is also resource-intensive and should be executed on a GPU for adequate throughput.';return{c(){g=i("p"),g.innerHTML=j},l(y){g=o(y,"P",{"data-svelte-h":!0}),r(g)!=="svelte-2g3eka"&&(g.innerHTML=j)},m(y,je){a(y,g,je)},p:ms,d(y){y&&s(g)}}}function bs(Ue){let g,j,y,je,J,ke,U,Ze,k,_t="LLMs, or Large Language Models, are the key component behind text generation. In a nutshell, they consist of large pretrained transformer models trained to predict the next word (or, more precisely, token) given some input text. Since they predict one token at a time, you need to do something more elaborate to generate new sentences other than just calling the model — you need to do autoregressive generation.",Ie,Z,vt='Autoregressive generation is the inference-time procedure of iteratively calling a model with its own generated outputs, given a few initial inputs. In 🤗 Transformers, this is handled by the <a href="/docs/transformers/pr_31155/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> method, which is available to all models with generative capabilities.',Ge,I,$t="This tutorial will show you how to:",_e,G,Bt="<li>Generate text with an LLM</li> <li>Avoid common pitfalls</li> <li>Next steps to help you get the most out of your LLM</li>",ve,_,Wt="Before you begin, make sure you have all the necessary libraries installed:",$e,v,Be,$,We,B,Xt='A language model trained for <a href="tasks/language_modeling">causal language modeling</a> takes a sequence of text tokens as input and returns the probability distribution for the next token.',Xe,b,Vt='<video style="max-width: 90%; margin: auto;" autoplay="" loop="" muted="" playsinline="" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/assisted-generation/gif_1_1080p.mov"></video> <figcaption>&quot;Forward pass of an LLM&quot;</figcaption>',Ve,W,Rt="A critical aspect of autoregressive generation with LLMs is how to select the next token from this probability distribution. Anything goes in this step as long as you end up with a token for the next iteration. This means it can be as simple as selecting the most likely token from the probability distribution or as complex as applying a dozen transformations before sampling from the resulting distribution.",Re,w,xt='<video style="max-width: 90%; margin: auto;" autoplay="" loop="" muted="" playsinline="" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/assisted-generation/gif_2_1080p.mov"></video> <figcaption>&quot;Autoregressive generation iteratively selects the next token from a probability distribution to generate text&quot;</figcaption>',xe,X,Ct="The process depicted above is repeated iteratively until some stopping condition is reached. Ideally, the stopping condition is dictated by the model, which should learn when to output an end-of-sequence (<code>EOS</code>) token. If this is not the case, generation stops when some predefined maximum length is reached.",Ce,V,zt='Properly setting up the token selection step and the stopping condition is essential to make your model behave as you’d expect on your task. That is why we have a <a href="/docs/transformers/pr_31155/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a> file associated with each model, which contains a good default generative parameterization and is loaded alongside your model.',ze,R,Ht="Let’s talk code!",He,T,Le,x,Lt="First, you need to load the model.",qe,C,Fe,z,qt="You’ll notice two flags in the <code>from_pretrained</code> call:",Ne,H,Ft='<li><code>device_map</code> ensures the model is moved to your GPU(s)</li> <li><code>load_in_4bit</code> applies <a href="main_classes/quantization">4-bit dynamic quantization</a> to massively reduce the resource requirements</li>',Qe,L,Nt="There are other ways to initialize a model, but this is a good baseline to begin with an LLM.",Ee,q,Qt='Next, you need to preprocess your text input with a <a href="tokenizer_summary">tokenizer</a>.',Se,F,Ye,N,Et='The <code>model_inputs</code> variable holds the tokenized text input, as well as the attention mask. While <a href="/docs/transformers/pr_31155/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> does its best effort to infer the attention mask when it is not passed, we recommend passing it whenever possible for optimal results.',Ae,Q,St='After tokenizing the inputs, you can call the <a href="/docs/transformers/pr_31155/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> method to returns the generated tokens. The generated tokens then should be converted to text before printing.',Ke,E,Pe,S,Yt="Finally, you don’t need to do it one sequence at a time! You can batch your inputs, which will greatly improve the throughput at a small latency and memory cost. All you need to do is to make sure you pad your inputs properly (more on that below).",De,Y,Oe,A,At="And that’s it! In a few lines of code, you can harness the power of an LLM.",et,K,tt,P,Kt='There are many <a href="generation_strategies">generation strategies</a>, and sometimes the default values may not be appropriate for your use case. If your outputs aren’t aligned with what you’re expecting, we’ve created a list of the most common pitfalls and how to avoid them.',st,D,at,O,lt,ee,Pt='If not specified in the <a href="/docs/transformers/pr_31155/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a> file, <code>generate</code> returns up to 20 tokens by default. We highly recommend manually setting <code>max_new_tokens</code> in your <code>generate</code> call to control the maximum number of new tokens it can return. Keep in mind LLMs (more precisely, <a href="https://huggingface.co/learn/nlp-course/chapter1/6?fw=pt" rel="nofollow">decoder-only models</a>) also return the input prompt as part of the output.',nt,te,it,se,ot,ae,Dt='By default, and unless specified in the <a href="/docs/transformers/pr_31155/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a> file, <code>generate</code> selects the most likely token at each iteration (greedy decoding). Depending on your task, this may be undesirable; creative tasks like chatbots or writing an essay benefit from sampling. On the other hand, input-grounded tasks like audio transcription or translation benefit from greedy decoding. Enable sampling with <code>do_sample=True</code>, and you can learn more about this topic in this <a href="https://huggingface.co/blog/how-to-generate" rel="nofollow">blog post</a>.',rt,le,pt,ne,mt,ie,Ot='LLMs are <a href="https://huggingface.co/learn/nlp-course/chapter1/6?fw=pt" rel="nofollow">decoder-only</a> architectures, meaning they continue to iterate on your input prompt. If your inputs do not have the same length, they need to be padded. Since LLMs are not trained to continue from pad tokens, your input needs to be left-padded. Make sure you also don’t forget to pass the attention mask to generate!',ut,oe,ct,re,dt,pe,es='Some models and tasks expect a certain input prompt format to work properly. When this format is not applied, you will get a silent performance degradation: the model kinda works, but not as well as if you were following the expected prompt. More information about prompting, including which models and tasks need to be careful, is available in this <a href="tasks/prompting">guide</a>. Let’s see an example with a chat LLM, which makes use of <a href="chat_templating">chat templating</a>:',ht,me,gt,ue,Mt,ce,ts="While the autoregressive generation process is relatively straightforward, making the most out of your LLM can be a challenging endeavor because there are many moving parts. For your next steps to help you dive deeper into LLM usage and understanding:",yt,de,ft,he,ss='<li>Guide on how to <a href="generation_strategies">control different generation methods</a>, how to set up the generation configuration file, and how to stream the output;</li> <li><a href="llm_optims">Accelerating text generation</a>;</li> <li><a href="chat_templating">Prompt templates for chat LLMs</a>;</li> <li><a href="tasks/prompting">Prompt design guide</a>;</li> <li>API reference on <a href="/docs/transformers/pr_31155/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>, <a href="/docs/transformers/pr_31155/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>, and <a href="internal/generation_utils">generate-related classes</a>. Most of the classes, including the logits processors, have usage examples!</li>',bt,ge,wt,Me,as='<li><a href="https://huggingface.co/spaces/HuggingFaceH4/open_llm_leaderboard" rel="nofollow">Open LLM Leaderboard</a>, which focuses on the quality of the open-source models;</li> <li><a href="https://huggingface.co/spaces/optimum/llm-perf-leaderboard" rel="nofollow">Open LLM-Perf Leaderboard</a>, which focuses on LLM throughput.</li>',Tt,ye,jt,fe,ls='<li>Guide on how to <a href="llm_tutorial_optimization">optimize LLMs for speed and memory</a>;</li> <li>Guide on <a href="main_classes/quantization">quantization</a> such as bitsandbytes and autogptq, which shows you how to drastically reduce your memory requirements.</li>',Jt,be,Ut,we,ns='<li><a href="https://github.com/huggingface/optimum" rel="nofollow"><code>optimum</code></a>, an extension of 🤗 Transformers that optimizes for specific hardware devices.</li> <li><a href="https://github.com/outlines-dev/outlines" rel="nofollow"><code>outlines</code></a>, a library where you can constrain text generation (e.g. to generate JSON files);</li> <li><a href="https://github.com/huggingface/text-generation-inference" rel="nofollow"><code>text-generation-inference</code></a>, a production-ready server for LLMs;</li> <li><a href="https://github.com/oobabooga/text-generation-webui" rel="nofollow"><code>text-generation-webui</code></a>, a UI for text generation;</li>',kt,Te,Zt,Je,It;return J=new M({props:{title:"Generation with LLMs",local:"generation-with-llms",headingTag:"h1"}}),U=new Ms({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/llm_tutorial.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/llm_tutorial.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/llm_tutorial.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/llm_tutorial.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/llm_tutorial.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/llm_tutorial.ipynb"}]}}),v=new f({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGJpdHNhbmRieXRlcyUzRSUzRDAuMzkuMCUyMC1x",highlighted:"pip install transformers bitsandbytes&gt;=0.39.0 -q",wrap:!1}}),$=new M({props:{title:"Generate text",local:"generate-text",headingTag:"h2"}}),T=new gs({props:{$$slots:{default:[fs]},$$scope:{ctx:Ue}}}),C=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_4bit=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),F=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtaXN0cmFsYWklMkZNaXN0cmFsLTdCLXYwLjElMjIlMkMlMjBwYWRkaW5nX3NpZGUlM0QlMjJsZWZ0JTIyKSUwQW1vZGVsX2lucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJBJTIwbGlzdCUyMG9mJTIwY29sb3JzJTNBJTIwcmVkJTJDJTIwYmx1ZSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer([<span class="hljs-string">&quot;A list of colors: red, blue&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),E=new f({props:{code:"Z2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqbW9kZWxfaW5wdXRzKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;A list of colors: red, blue, green, yellow, orange, purple, pink,&#x27;</span>`,wrap:!1}}),Y=new f({props:{code:"dG9rZW5pemVyLnBhZF90b2tlbiUyMCUzRCUyMHRva2VuaXplci5lb3NfdG9rZW4lMjAlMjAlMjMlMjBNb3N0JTIwTExNcyUyMGRvbid0JTIwaGF2ZSUyMGElMjBwYWQlMjB0b2tlbiUyMGJ5JTIwZGVmYXVsdCUwQW1vZGVsX2lucHV0cyUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjAlNUIlMjJBJTIwbGlzdCUyMG9mJTIwY29sb3JzJTNBJTIwcmVkJTJDJTIwYmx1ZSUyMiUyQyUyMCUyMlBvcnR1Z2FsJTIwaXMlMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwcGFkZGluZyUzRFRydWUlMEEpLnRvKCUyMmN1ZGElMjIpJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqbW9kZWxfaW5wdXRzKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.pad_token = tokenizer.eos_token  <span class="hljs-comment"># Most LLMs don&#x27;t have a pad token by default</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer(
<span class="hljs-meta">... </span>    [<span class="hljs-string">&quot;A list of colors: red, blue&quot;</span>, <span class="hljs-string">&quot;Portugal is&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;A list of colors: red, blue, green, yellow, orange, purple, pink,&#x27;</span>,
<span class="hljs-string">&#x27;Portugal is a country in southwestern Europe, on the Iber&#x27;</span>]`,wrap:!1}}),K=new M({props:{title:"Common pitfalls",local:"common-pitfalls",headingTag:"h2"}}),D=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEF0b2tlbml6ZXIucGFkX3Rva2VuJTIwJTNEJTIwdG9rZW5pemVyLmVvc190b2tlbiUyMCUyMCUyMyUyME1vc3QlMjBMTE1zJTIwZG9uJ3QlMjBoYXZlJTIwYSUyMHBhZCUyMHRva2VuJTIwYnklMjBkZWZhdWx0JTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.pad_token = tokenizer.eos_token  <span class="hljs-comment"># Most LLMs don&#x27;t have a pad token by default</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_4bit=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),O=new M({props:{title:"Generated output is too short/long",local:"generated-output-is-too-shortlong",headingTag:"h3"}}),te=new f({props:{code:"bW9kZWxfaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkElMjBzZXF1ZW5jZSUyMG9mJTIwbnVtYmVycyUzQSUyMDElMkMlMjAyJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oJTIyY3VkYSUyMiklMEElMEElMjMlMjBCeSUyMGRlZmF1bHQlMkMlMjB0aGUlMjBvdXRwdXQlMjB3aWxsJTIwY29udGFpbiUyMHVwJTIwdG8lMjAyMCUyMHRva2VucyUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKm1vZGVsX2lucHV0cyklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEJTBBJTBBJTIzJTIwU2V0dGluZyUyMCU2MG1heF9uZXdfdG9rZW5zJTYwJTIwYWxsb3dzJTIweW91JTIwdG8lMjBjb250cm9sJTIwdGhlJTIwbWF4aW11bSUyMGxlbmd0aCUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKm1vZGVsX2lucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNENTApJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer([<span class="hljs-string">&quot;A sequence of numbers: 1, 2&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, the output will contain up to 20 tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;A sequence of numbers: 1, 2, 3, 4, 5&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Setting \`max_new_tokens\` allows you to control the maximum length</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs, max_new_tokens=<span class="hljs-number">50</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;A sequence of numbers: 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,&#x27;</span>`,wrap:!1}}),se=new M({props:{title:"Incorrect generation mode",local:"incorrect-generation-mode",headingTag:"h3"}}),le=new f({props:{code:"JTIzJTIwU2V0JTIwc2VlZCUyMG9yJTIwcmVwcm9kdWNpYmlsaXR5JTIwLS0lMjB5b3UlMjBkb24ndCUyMG5lZWQlMjB0aGlzJTIwdW5sZXNzJTIweW91JTIwd2FudCUyMGZ1bGwlMjByZXByb2R1Y2liaWxpdHklMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwc2V0X3NlZWQlMEFzZXRfc2VlZCg0MiklMEElMEFtb2RlbF9pbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIySSUyMGFtJTIwYSUyMGNhdC4lMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byglMjJjdWRhJTIyKSUwQSUwQSUyMyUyMExMTSUyMCUyQiUyMGdyZWVkeSUyMGRlY29kaW5nJTIwJTNEJTIwcmVwZXRpdGl2ZSUyQyUyMGJvcmluZyUyMG91dHB1dCUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKm1vZGVsX2lucHV0cyklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEJTBBJTBBJTIzJTIwV2l0aCUyMHNhbXBsaW5nJTJDJTIwdGhlJTIwb3V0cHV0JTIwYmVjb21lcyUyMG1vcmUlMjBjcmVhdGl2ZSElMEFnZW5lcmF0ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKiptb2RlbF9pbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Set seed or reproducibility -- you don&#x27;t need this unless you want full reproducibility</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> set_seed
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">42</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer([<span class="hljs-string">&quot;I am a cat.&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># LLM + greedy decoding = repetitive, boring output</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;I am a cat. I am a cat. I am a cat. I am a cat&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output becomes more creative!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;I am a cat.  Specifically, I am an indoor-only cat.  I&#x27;</span>`,wrap:!1}}),ne=new M({props:{title:"Wrong padding side",local:"wrong-padding-side",headingTag:"h3"}}),oe=new f({props:{code:"JTIzJTIwVGhlJTIwdG9rZW5pemVyJTIwaW5pdGlhbGl6ZWQlMjBhYm92ZSUyMGhhcyUyMHJpZ2h0LXBhZGRpbmclMjBhY3RpdmUlMjBieSUyMGRlZmF1bHQlM0ElMjB0aGUlMjAxc3QlMjBzZXF1ZW5jZSUyQyUwQSUyMyUyMHdoaWNoJTIwaXMlMjBzaG9ydGVyJTJDJTIwaGFzJTIwcGFkZGluZyUyMG9uJTIwdGhlJTIwcmlnaHQlMjBzaWRlLiUyMEdlbmVyYXRpb24lMjBmYWlscyUyMHRvJTIwY2FwdHVyZSUyMHRoZSUyMGxvZ2ljLiUwQW1vZGVsX2lucHV0cyUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjAlNUIlMjIxJTJDJTIwMiUyQyUyMDMlMjIlMkMlMjAlMjJBJTJDJTIwQiUyQyUyMEMlMkMlMjBEJTJDJTIwRSUyMiU1RCUyQyUyMHBhZGRpbmclM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUwQSkudG8oJTIyY3VkYSUyMiklMEFnZW5lcmF0ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKiptb2RlbF9pbnB1dHMpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQSUwQSUyMyUyMFdpdGglMjBsZWZ0LXBhZGRpbmclMkMlMjBpdCUyMHdvcmtzJTIwYXMlMjBleHBlY3RlZCElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtaXN0cmFsYWklMkZNaXN0cmFsLTdCLXYwLjElMjIlMkMlMjBwYWRkaW5nX3NpZGUlM0QlMjJsZWZ0JTIyKSUwQXRva2VuaXplci5wYWRfdG9rZW4lMjAlM0QlMjB0b2tlbml6ZXIuZW9zX3Rva2VuJTIwJTIwJTIzJTIwTW9zdCUyMExMTXMlMjBkb24ndCUyMGhhdmUlMjBhJTIwcGFkJTIwdG9rZW4lMjBieSUyMGRlZmF1bHQlMEFtb2RlbF9pbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTBBJTIwJTIwJTIwJTIwJTVCJTIyMSUyQyUyMDIlMkMlMjAzJTIyJTJDJTIwJTIyQSUyQyUyMEIlMkMlMjBDJTJDJTIwRCUyQyUyMEUlMjIlNUQlMkMlMjBwYWRkaW5nJTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMEEpLnRvKCUyMmN1ZGElMjIpJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqbW9kZWxfaW5wdXRzKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># The tokenizer initialized above has right-padding active by default: the 1st sequence,</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># which is shorter, has padding on the right side. Generation fails to capture the logic.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer(
<span class="hljs-meta">... </span>    [<span class="hljs-string">&quot;1, 2, 3&quot;</span>, <span class="hljs-string">&quot;A, B, C, D, E&quot;</span>], padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;1, 2, 33333333333&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With left-padding, it works as expected!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.pad_token = tokenizer.eos_token  <span class="hljs-comment"># Most LLMs don&#x27;t have a pad token by default</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer(
<span class="hljs-meta">... </span>    [<span class="hljs-string">&quot;1, 2, 3&quot;</span>, <span class="hljs-string">&quot;A, B, C, D, E&quot;</span>], padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;1, 2, 3, 4, 5, 6,&#x27;</span>`,wrap:!1}}),re=new M({props:{title:"Wrong prompt",local:"wrong-prompt",headingTag:"h3"}}),me=new f({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-alpha&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-alpha&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_4bit=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;&quot;&quot;How many helicopters can a human eat in one sitting? Reply as a thug.&quot;&quot;&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer([prompt], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_length = model_inputs.input_ids.shape[<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs, max_new_tokens=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(generated_ids[:, input_length:], skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-string">&quot;I&#x27;m not a thug, but i can tell you that a human cannot eat&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Oh no, it did not follow our instruction to reply as a thug! Let&#x27;s see what happens when we write</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># a better prompt and use the right template for this model (through \`tokenizer.apply_chat_template\`)</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a friendly chatbot who always responds in the style of a thug&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;How many helicopters can a human eat in one sitting?&quot;</span>},
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer.apply_chat_template(messages, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_length = model_inputs.shape[<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(model_inputs, do_sample=<span class="hljs-literal">True</span>, max_new_tokens=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(generated_ids[:, input_length:], skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-string">&#x27;None, you thug. How bout you try to focus on more useful questions?&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># As we can see, it followed a proper thug style 😎</span>`,wrap:!1}}),ue=new M({props:{title:"Further resources",local:"further-resources",headingTag:"h2"}}),de=new M({props:{title:"Advanced generate usage",local:"advanced-generate-usage",headingTag:"h3"}}),ge=new M({props:{title:"LLM leaderboards",local:"llm-leaderboards",headingTag:"h3"}}),ye=new M({props:{title:"Latency, throughput and memory utilization",local:"latency-throughput-and-memory-utilization",headingTag:"h3"}}),be=new M({props:{title:"Related libraries",local:"related-libraries",headingTag:"h3"}}),Te=new ys({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/llm_tutorial.md"}}),{c(){g=i("meta"),j=l(),y=i("p"),je=l(),p(J.$$.fragment),ke=l(),p(U.$$.fragment),Ze=l(),k=i("p"),k.textContent=_t,Ie=l(),Z=i("p"),Z.innerHTML=vt,Ge=l(),I=i("p"),I.textContent=$t,_e=l(),G=i("ul"),G.innerHTML=Bt,ve=l(),_=i("p"),_.textContent=Wt,$e=l(),p(v.$$.fragment),Be=l(),p($.$$.fragment),We=l(),B=i("p"),B.innerHTML=Xt,Xe=l(),b=i("figure"),b.innerHTML=Vt,Ve=l(),W=i("p"),W.textContent=Rt,Re=l(),w=i("figure"),w.innerHTML=xt,xe=l(),X=i("p"),X.innerHTML=Ct,Ce=l(),V=i("p"),V.innerHTML=zt,ze=l(),R=i("p"),R.textContent=Ht,He=l(),p(T.$$.fragment),Le=l(),x=i("p"),x.textContent=Lt,qe=l(),p(C.$$.fragment),Fe=l(),z=i("p"),z.innerHTML=qt,Ne=l(),H=i("ul"),H.innerHTML=Ft,Qe=l(),L=i("p"),L.textContent=Nt,Ee=l(),q=i("p"),q.innerHTML=Qt,Se=l(),p(F.$$.fragment),Ye=l(),N=i("p"),N.innerHTML=Et,Ae=l(),Q=i("p"),Q.innerHTML=St,Ke=l(),p(E.$$.fragment),Pe=l(),S=i("p"),S.textContent=Yt,De=l(),p(Y.$$.fragment),Oe=l(),A=i("p"),A.textContent=At,et=l(),p(K.$$.fragment),tt=l(),P=i("p"),P.innerHTML=Kt,st=l(),p(D.$$.fragment),at=l(),p(O.$$.fragment),lt=l(),ee=i("p"),ee.innerHTML=Pt,nt=l(),p(te.$$.fragment),it=l(),p(se.$$.fragment),ot=l(),ae=i("p"),ae.innerHTML=Dt,rt=l(),p(le.$$.fragment),pt=l(),p(ne.$$.fragment),mt=l(),ie=i("p"),ie.innerHTML=Ot,ut=l(),p(oe.$$.fragment),ct=l(),p(re.$$.fragment),dt=l(),pe=i("p"),pe.innerHTML=es,ht=l(),p(me.$$.fragment),gt=l(),p(ue.$$.fragment),Mt=l(),ce=i("p"),ce.textContent=ts,yt=l(),p(de.$$.fragment),ft=l(),he=i("ol"),he.innerHTML=ss,bt=l(),p(ge.$$.fragment),wt=l(),Me=i("ol"),Me.innerHTML=as,Tt=l(),p(ye.$$.fragment),jt=l(),fe=i("ol"),fe.innerHTML=ls,Jt=l(),p(be.$$.fragment),Ut=l(),we=i("ol"),we.innerHTML=ns,kt=l(),p(Te.$$.fragment),Zt=l(),Je=i("p"),this.h()},l(e){const t=ds("svelte-u9bgzb",document.head);g=o(t,"META",{name:!0,content:!0}),t.forEach(s),j=n(e),y=o(e,"P",{}),os(y).forEach(s),je=n(e),m(J.$$.fragment,e),ke=n(e),m(U.$$.fragment,e),Ze=n(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-tihwde"&&(k.textContent=_t),Ie=n(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-13c89zt"&&(Z.innerHTML=vt),Ge=n(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1g5tmp7"&&(I.textContent=$t),_e=n(e),G=o(e,"UL",{"data-svelte-h":!0}),r(G)!=="svelte-jbjjoq"&&(G.innerHTML=Bt),ve=n(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1c9nexd"&&(_.textContent=Wt),$e=n(e),m(v.$$.fragment,e),Be=n(e),m($.$$.fragment,e),We=n(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-e3t4o0"&&(B.innerHTML=Xt),Xe=n(e),b=o(e,"FIGURE",{class:!0,"data-svelte-h":!0}),r(b)!=="svelte-hjgddv"&&(b.innerHTML=Vt),Ve=n(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1qja5m9"&&(W.textContent=Rt),Re=n(e),w=o(e,"FIGURE",{class:!0,"data-svelte-h":!0}),r(w)!=="svelte-1uqc9hk"&&(w.innerHTML=xt),xe=n(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-pprvht"&&(X.innerHTML=Ct),Ce=n(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-obdxy5"&&(V.innerHTML=zt),ze=n(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1wpt61n"&&(R.textContent=Ht),He=n(e),m(T.$$.fragment,e),Le=n(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-17lmqvk"&&(x.textContent=Lt),qe=n(e),m(C.$$.fragment,e),Fe=n(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1ibsgq1"&&(z.innerHTML=qt),Ne=n(e),H=o(e,"UL",{"data-svelte-h":!0}),r(H)!=="svelte-1ut1fuh"&&(H.innerHTML=Ft),Qe=n(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-14llc8d"&&(L.textContent=Nt),Ee=n(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-9uk3l0"&&(q.innerHTML=Qt),Se=n(e),m(F.$$.fragment,e),Ye=n(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1jn61vl"&&(N.innerHTML=Et),Ae=n(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-2n8i8u"&&(Q.innerHTML=St),Ke=n(e),m(E.$$.fragment,e),Pe=n(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1p82il9"&&(S.textContent=Yt),De=n(e),m(Y.$$.fragment,e),Oe=n(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-wj0v9f"&&(A.textContent=At),et=n(e),m(K.$$.fragment,e),tt=n(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1h0ongv"&&(P.innerHTML=Kt),st=n(e),m(D.$$.fragment,e),at=n(e),m(O.$$.fragment,e),lt=n(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1cmsyv8"&&(ee.innerHTML=Pt),nt=n(e),m(te.$$.fragment,e),it=n(e),m(se.$$.fragment,e),ot=n(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-pduqmg"&&(ae.innerHTML=Dt),rt=n(e),m(le.$$.fragment,e),pt=n(e),m(ne.$$.fragment,e),mt=n(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1n0cu3a"&&(ie.innerHTML=Ot),ut=n(e),m(oe.$$.fragment,e),ct=n(e),m(re.$$.fragment,e),dt=n(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-136mw01"&&(pe.innerHTML=es),ht=n(e),m(me.$$.fragment,e),gt=n(e),m(ue.$$.fragment,e),Mt=n(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1w0my5d"&&(ce.textContent=ts),yt=n(e),m(de.$$.fragment,e),ft=n(e),he=o(e,"OL",{"data-svelte-h":!0}),r(he)!=="svelte-10q6c60"&&(he.innerHTML=ss),bt=n(e),m(ge.$$.fragment,e),wt=n(e),Me=o(e,"OL",{"data-svelte-h":!0}),r(Me)!=="svelte-x6edjm"&&(Me.innerHTML=as),Tt=n(e),m(ye.$$.fragment,e),jt=n(e),fe=o(e,"OL",{"data-svelte-h":!0}),r(fe)!=="svelte-15885m8"&&(fe.innerHTML=ls),Jt=n(e),m(be.$$.fragment,e),Ut=n(e),we=o(e,"OL",{"data-svelte-h":!0}),r(we)!=="svelte-s3xonn"&&(we.innerHTML=ns),kt=n(e),m(Te.$$.fragment,e),Zt=n(e),Je=o(e,"P",{}),os(Je).forEach(s),this.h()},h(){Gt(g,"name","hf:doc:metadata"),Gt(g,"content",ws),Gt(b,"class","image table text-center m-0 w-full"),Gt(w,"class","image table text-center m-0 w-full")},m(e,t){hs(document.head,g),a(e,j,t),a(e,y,t),a(e,je,t),u(J,e,t),a(e,ke,t),u(U,e,t),a(e,Ze,t),a(e,k,t),a(e,Ie,t),a(e,Z,t),a(e,Ge,t),a(e,I,t),a(e,_e,t),a(e,G,t),a(e,ve,t),a(e,_,t),a(e,$e,t),u(v,e,t),a(e,Be,t),u($,e,t),a(e,We,t),a(e,B,t),a(e,Xe,t),a(e,b,t),a(e,Ve,t),a(e,W,t),a(e,Re,t),a(e,w,t),a(e,xe,t),a(e,X,t),a(e,Ce,t),a(e,V,t),a(e,ze,t),a(e,R,t),a(e,He,t),u(T,e,t),a(e,Le,t),a(e,x,t),a(e,qe,t),u(C,e,t),a(e,Fe,t),a(e,z,t),a(e,Ne,t),a(e,H,t),a(e,Qe,t),a(e,L,t),a(e,Ee,t),a(e,q,t),a(e,Se,t),u(F,e,t),a(e,Ye,t),a(e,N,t),a(e,Ae,t),a(e,Q,t),a(e,Ke,t),u(E,e,t),a(e,Pe,t),a(e,S,t),a(e,De,t),u(Y,e,t),a(e,Oe,t),a(e,A,t),a(e,et,t),u(K,e,t),a(e,tt,t),a(e,P,t),a(e,st,t),u(D,e,t),a(e,at,t),u(O,e,t),a(e,lt,t),a(e,ee,t),a(e,nt,t),u(te,e,t),a(e,it,t),u(se,e,t),a(e,ot,t),a(e,ae,t),a(e,rt,t),u(le,e,t),a(e,pt,t),u(ne,e,t),a(e,mt,t),a(e,ie,t),a(e,ut,t),u(oe,e,t),a(e,ct,t),u(re,e,t),a(e,dt,t),a(e,pe,t),a(e,ht,t),u(me,e,t),a(e,gt,t),u(ue,e,t),a(e,Mt,t),a(e,ce,t),a(e,yt,t),u(de,e,t),a(e,ft,t),a(e,he,t),a(e,bt,t),u(ge,e,t),a(e,wt,t),a(e,Me,t),a(e,Tt,t),u(ye,e,t),a(e,jt,t),a(e,fe,t),a(e,Jt,t),u(be,e,t),a(e,Ut,t),a(e,we,t),a(e,kt,t),u(Te,e,t),a(e,Zt,t),a(e,Je,t),It=!0},p(e,[t]){const is={};t&2&&(is.$$scope={dirty:t,ctx:e}),T.$set(is)},i(e){It||(c(J.$$.fragment,e),c(U.$$.fragment,e),c(v.$$.fragment,e),c($.$$.fragment,e),c(T.$$.fragment,e),c(C.$$.fragment,e),c(F.$$.fragment,e),c(E.$$.fragment,e),c(Y.$$.fragment,e),c(K.$$.fragment,e),c(D.$$.fragment,e),c(O.$$.fragment,e),c(te.$$.fragment,e),c(se.$$.fragment,e),c(le.$$.fragment,e),c(ne.$$.fragment,e),c(oe.$$.fragment,e),c(re.$$.fragment,e),c(me.$$.fragment,e),c(ue.$$.fragment,e),c(de.$$.fragment,e),c(ge.$$.fragment,e),c(ye.$$.fragment,e),c(be.$$.fragment,e),c(Te.$$.fragment,e),It=!0)},o(e){d(J.$$.fragment,e),d(U.$$.fragment,e),d(v.$$.fragment,e),d($.$$.fragment,e),d(T.$$.fragment,e),d(C.$$.fragment,e),d(F.$$.fragment,e),d(E.$$.fragment,e),d(Y.$$.fragment,e),d(K.$$.fragment,e),d(D.$$.fragment,e),d(O.$$.fragment,e),d(te.$$.fragment,e),d(se.$$.fragment,e),d(le.$$.fragment,e),d(ne.$$.fragment,e),d(oe.$$.fragment,e),d(re.$$.fragment,e),d(me.$$.fragment,e),d(ue.$$.fragment,e),d(de.$$.fragment,e),d(ge.$$.fragment,e),d(ye.$$.fragment,e),d(be.$$.fragment,e),d(Te.$$.fragment,e),It=!1},d(e){e&&(s(j),s(y),s(je),s(ke),s(Ze),s(k),s(Ie),s(Z),s(Ge),s(I),s(_e),s(G),s(ve),s(_),s($e),s(Be),s(We),s(B),s(Xe),s(b),s(Ve),s(W),s(Re),s(w),s(xe),s(X),s(Ce),s(V),s(ze),s(R),s(He),s(Le),s(x),s(qe),s(Fe),s(z),s(Ne),s(H),s(Qe),s(L),s(Ee),s(q),s(Se),s(Ye),s(N),s(Ae),s(Q),s(Ke),s(Pe),s(S),s(De),s(Oe),s(A),s(et),s(tt),s(P),s(st),s(at),s(lt),s(ee),s(nt),s(it),s(ot),s(ae),s(rt),s(pt),s(mt),s(ie),s(ut),s(ct),s(dt),s(pe),s(ht),s(gt),s(Mt),s(ce),s(yt),s(ft),s(he),s(bt),s(wt),s(Me),s(Tt),s(jt),s(fe),s(Jt),s(Ut),s(we),s(kt),s(Zt),s(Je)),s(g),h(J,e),h(U,e),h(v,e),h($,e),h(T,e),h(C,e),h(F,e),h(E,e),h(Y,e),h(K,e),h(D,e),h(O,e),h(te,e),h(se,e),h(le,e),h(ne,e),h(oe,e),h(re,e),h(me,e),h(ue,e),h(de,e),h(ge,e),h(ye,e),h(be,e),h(Te,e)}}}const ws='{"title":"Generation with LLMs","local":"generation-with-llms","sections":[{"title":"Generate text","local":"generate-text","sections":[],"depth":2},{"title":"Common pitfalls","local":"common-pitfalls","sections":[{"title":"Generated output is too short/long","local":"generated-output-is-too-shortlong","sections":[],"depth":3},{"title":"Incorrect generation mode","local":"incorrect-generation-mode","sections":[],"depth":3},{"title":"Wrong padding side","local":"wrong-padding-side","sections":[],"depth":3},{"title":"Wrong prompt","local":"wrong-prompt","sections":[],"depth":3}],"depth":2},{"title":"Further resources","local":"further-resources","sections":[{"title":"Advanced generate usage","local":"advanced-generate-usage","sections":[],"depth":3},{"title":"LLM leaderboards","local":"llm-leaderboards","sections":[],"depth":3},{"title":"Latency, throughput and memory utilization","local":"latency-throughput-and-memory-utilization","sections":[],"depth":3},{"title":"Related libraries","local":"related-libraries","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ts(Ue){return ps(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Gs extends us{constructor(g){super(),cs(this,g,Ts,bs,rs,{})}}export{Gs as component};
