import{s as Eo,o as So,n as Tt}from"../chunks/scheduler.25b97de1.js";import{S as qo,i as Yo,g as s,s as n,r as u,A as Qo,h as a,f as i,c as o,j,u as f,x as d,k,y as t,a as p,v as h,d as _,t as b,w as y}from"../chunks/index.d9030fc9.js";import{T as On}from"../chunks/Tip.baa67368.js";import{D as J}from"../chunks/Docstring.e257edda.js";import{C as eo}from"../chunks/CodeBlock.e6cd0d95.js";import{E as Kn}from"../chunks/ExampleCodeBlock.20db4b6e.js";import{H as Do,E as Ao}from"../chunks/EditOnGithub.91d95064.js";function Po(Z){let l,G=`A large number of these flags control the logits or the stopping criteria of the generation. Make sure you check
the <a href="https://huggingface.co/docs/transformers/internal/generation_utils" rel="nofollow">generate-related classes</a> for a full
description of the possible manipulations, as well as examples of their usage.`;return{c(){l=s("p"),l.innerHTML=G},l(g){l=a(g,"P",{"data-svelte-h":!0}),d(l)!=="svelte-1lhagsi"&&(l.innerHTML=G)},m(g,m){p(g,l,m)},p:Tt,d(g){g&&i(l)}}}function Oo(Z){let l,G="Examples:",g,m,M;return m=new eo({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdlbmVyYXRpb25Db25maWclMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFnZW5lcmF0aW9uX2NvbmZpZyUyMCUzRCUyMEdlbmVyYXRpb25Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQSUwQSUyMyUyMEUuZy4lMjBjb25maWclMjB3YXMlMjBzYXZlZCUyMHVzaW5nJTIwKnNhdmVfcHJldHJhaW5lZCgnLiUyRnRlc3QlMkZzYXZlZF9tb2RlbCUyRicpKiUwQWdlbmVyYXRpb25fY29uZmlnLnNhdmVfcHJldHJhaW5lZCglMjIuJTJGdGVzdCUyRnNhdmVkX21vZGVsJTJGJTIyKSUwQWdlbmVyYXRpb25fY29uZmlnJTIwJTNEJTIwR2VuZXJhdGlvbkNvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRlc3QlMkZzYXZlZF9tb2RlbCUyRiUyMiklMEElMEElMjMlMjBZb3UlMjBjYW4lMjBhbHNvJTIwc3BlY2lmeSUyMGNvbmZpZ3VyYXRpb24lMjBuYW1lcyUyMHRvJTIweW91ciUyMGdlbmVyYXRpb24lMjBjb25maWd1cmF0aW9uJTIwZmlsZSUwQWdlbmVyYXRpb25fY29uZmlnLnNhdmVfcHJldHJhaW5lZCglMjIuJTJGdGVzdCUyRnNhdmVkX21vZGVsJTJGJTIyJTJDJTIwY29uZmlnX2ZpbGVfbmFtZSUzRCUyMm15X2NvbmZpZ3VyYXRpb24uanNvbiUyMiklMEFnZW5lcmF0aW9uX2NvbmZpZyUyMCUzRCUyMEdlbmVyYXRpb25Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZ0ZXN0JTJGc2F2ZWRfbW9kZWwlMkYlMjIlMkMlMjAlMjJteV9jb25maWd1cmF0aW9uLmpzb24lMjIpJTBBJTBBJTIzJTIwSWYlMjB5b3UnZCUyMGxpa2UlMjB0byUyMHRyeSUyMGElMjBtaW5vciUyMHZhcmlhdGlvbiUyMHRvJTIwYW4lMjBleGlzdGluZyUyMGNvbmZpZ3VyYXRpb24lMkMlMjB5b3UlMjBjYW4lMjBhbHNvJTIwcGFzcyUyMGdlbmVyYXRpb24lMEElMjMlMjBhcmd1bWVudHMlMjB0byUyMCU2MC5mcm9tX3ByZXRyYWluZWQoKSU2MC4lMjBCZSUyMG1pbmRmdWwlMjB0aGF0JTIwdHlwb3MlMjBhbmQlMjB1bnVzZWQlMjBhcmd1bWVudHMlMjB3aWxsJTIwYmUlMjBpZ25vcmVkJTBBZ2VuZXJhdGlvbl9jb25maWclMkMlMjB1bnVzZWRfa3dhcmdzJTIwJTNEJTIwR2VuZXJhdGlvbkNvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIlMkMlMjB0b3BfayUzRDElMkMlMjBmb28lM0RGYWxzZSUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjByZXR1cm5fdW51c2VkX2t3YXJncyUzRFRydWUlMEEpJTBBZ2VuZXJhdGlvbl9jb25maWcudG9wX2slMEElMEF1bnVzZWRfa3dhcmdz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GenerationConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config = GenerationConfig.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># E.g. config was saved using *save_pretrained(&#x27;./test/saved_model/&#x27;)*</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config.save_pretrained(<span class="hljs-string">&quot;./test/saved_model/&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config = GenerationConfig.from_pretrained(<span class="hljs-string">&quot;./test/saved_model/&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># You can also specify configuration names to your generation configuration file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config.save_pretrained(<span class="hljs-string">&quot;./test/saved_model/&quot;</span>, config_file_name=<span class="hljs-string">&quot;my_configuration.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config = GenerationConfig.from_pretrained(<span class="hljs-string">&quot;./test/saved_model/&quot;</span>, <span class="hljs-string">&quot;my_configuration.json&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If you&#x27;d like to try a minor variation to an existing configuration, you can also pass generation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># arguments to \`.from_pretrained()\`. Be mindful that typos and unused arguments will be ignored</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config, unused_kwargs = GenerationConfig.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;openai-community/gpt2&quot;</span>, top_k=<span class="hljs-number">1</span>, foo=<span class="hljs-literal">False</span>, do_sample=<span class="hljs-literal">True</span>, return_unused_kwargs=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config.top_k
<span class="hljs-number">1</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>unused_kwargs
{<span class="hljs-string">&#x27;foo&#x27;</span>: <span class="hljs-literal">False</span>}`,wrap:!1}}),{c(){l=s("p"),l.textContent=G,g=n(),u(m.$$.fragment)},l(r){l=a(r,"P",{"data-svelte-h":!0}),d(l)!=="svelte-kvfsh7"&&(l.textContent=G),g=o(r),f(m.$$.fragment,r)},m(r,w){p(r,l,w),p(r,g,w),h(m,r,w),M=!0},p:Tt,i(r){M||(_(m.$$.fragment,r),M=!0)},o(r){b(m.$$.fragment,r),M=!1},d(r){r&&(i(l),i(g)),y(m,r)}}}function Ko(Z){let l,G=`Most generation-controlling parameters are set in <code>generation_config</code> which, if not passed, will be set to the
model’s default generation configuration. You can override any <code>generation_config</code> by passing the corresponding
parameters to generate(), e.g. <code>.generate(inputs, num_beams=4, do_sample=True)</code>.`,g,m,M=`For an overview of generation strategies and code examples, check out the <a href="../generation_strategies">following
guide</a>.`;return{c(){l=s("p"),l.innerHTML=G,g=n(),m=s("p"),m.innerHTML=M},l(r){l=a(r,"P",{"data-svelte-h":!0}),d(l)!=="svelte-1c5u34l"&&(l.innerHTML=G),g=o(r),m=a(r,"P",{"data-svelte-h":!0}),d(m)!=="svelte-fvlq1g"&&(m.innerHTML=M)},m(r,w){p(r,l,w),p(r,g,w),p(r,m,w)},p:Tt,d(r){r&&(i(l),i(g),i(m))}}}function es(Z){let l,G="Examples:",g,m,M;return m=new eo({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2Tokenizer, AutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.pad_token_id = tokenizer.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today is&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Example 1: Print the scores for each token generated with Greedy Search</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">5</span>, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transition_scores = model.compute_transition_scores(
<span class="hljs-meta">... </span>    outputs.sequences, outputs.scores, normalize_logits=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># input_length is the length of the input prompt for decoder-only models, like the GPT family, and 1 for</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># encoder-decoder models, like BART or T5.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_length = <span class="hljs-number">1</span> <span class="hljs-keyword">if</span> model.config.is_encoder_decoder <span class="hljs-keyword">else</span> inputs.input_ids.shape[<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = outputs.sequences[:, input_length:]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> tok, score <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(generated_tokens[<span class="hljs-number">0</span>], transition_scores[<span class="hljs-number">0</span>]):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># | token | token string | log probability | probability</span>
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;| <span class="hljs-subst">{tok:5d}</span> | <span class="hljs-subst">{tokenizer.decode(tok):8s}</span> | <span class="hljs-subst">{score.numpy():<span class="hljs-number">.3</span>f}</span> | <span class="hljs-subst">{np.exp(score.numpy()):<span class="hljs-number">.2</span>%}</span>&quot;</span>)
|   <span class="hljs-number">262</span> |  the     | -<span class="hljs-number">1.414</span> | <span class="hljs-number">24.33</span>%
|  <span class="hljs-number">1110</span> |  day     | -<span class="hljs-number">2.609</span> | <span class="hljs-number">7.36</span>%
|   <span class="hljs-number">618</span> |  when    | -<span class="hljs-number">2.010</span> | <span class="hljs-number">13.40</span>%
|   <span class="hljs-number">356</span> |  we      | -<span class="hljs-number">1.859</span> | <span class="hljs-number">15.58</span>%
|   <span class="hljs-number">460</span> |  can     | -<span class="hljs-number">2.508</span> | <span class="hljs-number">8.14</span>%

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Example 2: Reconstruct the sequence scores from Beam Search</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">5</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    return_dict_in_generate=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    output_scores=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transition_scores = model.compute_transition_scores(
<span class="hljs-meta">... </span>    outputs.sequences, outputs.scores, outputs.beam_indices, normalize_logits=<span class="hljs-literal">False</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If you sum the generated tokens&#x27; scores and apply the length penalty, you&#x27;ll get the sequence scores.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Tip 1: recomputing the scores is only guaranteed to match with \`normalize_logits=False\`. Depending on the</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># use case, you might want to recompute it with \`normalize_logits=True\`.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Tip 2: the output length does NOT include the input length</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output_length = np.<span class="hljs-built_in">sum</span>(transition_scores.numpy() &lt; <span class="hljs-number">0</span>, axis=<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>length_penalty = model.generation_config.length_penalty
<span class="hljs-meta">&gt;&gt;&gt; </span>reconstructed_scores = transition_scores.<span class="hljs-built_in">sum</span>(axis=<span class="hljs-number">1</span>) / (output_length**length_penalty)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(np.allclose(outputs.sequences_scores, reconstructed_scores))
<span class="hljs-literal">True</span>`,wrap:!1}}),{c(){l=s("p"),l.textContent=G,g=n(),u(m.$$.fragment)},l(r){l=a(r,"P",{"data-svelte-h":!0}),d(l)!=="svelte-kvfsh7"&&(l.textContent=G),g=o(r),f(m.$$.fragment,r)},m(r,w){p(r,l,w),p(r,g,w),h(m,r,w),M=!0},p:Tt,i(r){M||(_(m.$$.fragment,r),M=!0)},o(r){b(m.$$.fragment,r),M=!1},d(r){r&&(i(l),i(g)),y(m,r)}}}function ts(Z){let l,G=`Most generation-controlling parameters are set in <code>generation_config</code> which, if not passed, will be set to the
model’s default generation configuration. You can override any <code>generation_config</code> by passing the corresponding
parameters to generate, e.g. <code>.generate(inputs, num_beams=4, do_sample=True)</code>.`,g,m,M=`For an overview of generation strategies and code examples, check out the <a href="../generation_strategies">following
guide</a>.`;return{c(){l=s("p"),l.innerHTML=G,g=n(),m=s("p"),m.innerHTML=M},l(r){l=a(r,"P",{"data-svelte-h":!0}),d(l)!=="svelte-1pahvb2"&&(l.innerHTML=G),g=o(r),m=a(r,"P",{"data-svelte-h":!0}),d(m)!=="svelte-fvlq1g"&&(m.innerHTML=M)},m(r,w){p(r,l,w),p(r,g,w),p(r,m,w)},p:Tt,d(r){r&&(i(l),i(g),i(m))}}}function ns(Z){let l,G="Examples:",g,m,M;return m=new eo({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2Tokenizer, TFAutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.pad_token_id = tokenizer.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today is&quot;</span>], return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Example 1: Print the scores for each token generated with Greedy Search</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">5</span>, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transition_scores = model.compute_transition_scores(
<span class="hljs-meta">... </span>    outputs.sequences, outputs.scores, normalize_logits=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># input_length is the length of the input prompt for decoder-only models, like the GPT family, and 1 for</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># encoder-decoder models, like BART or T5.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_length = <span class="hljs-number">1</span> <span class="hljs-keyword">if</span> model.config.is_encoder_decoder <span class="hljs-keyword">else</span> inputs.input_ids.shape[<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = outputs.sequences[:, input_length:]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> tok, score <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(generated_tokens[<span class="hljs-number">0</span>], transition_scores[<span class="hljs-number">0</span>]):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># | token | token string | logits | probability</span>
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;| <span class="hljs-subst">{tok:5d}</span> | <span class="hljs-subst">{tokenizer.decode(tok):8s}</span> | <span class="hljs-subst">{score.numpy():<span class="hljs-number">.3</span>f}</span> | <span class="hljs-subst">{np.exp(score.numpy()):<span class="hljs-number">.2</span>%}</span>&quot;</span>)
|   <span class="hljs-number">262</span> |  the     | -<span class="hljs-number">1.414</span> | <span class="hljs-number">24.33</span>%
|  <span class="hljs-number">1110</span> |  day     | -<span class="hljs-number">2.609</span> | <span class="hljs-number">7.36</span>%
|   <span class="hljs-number">618</span> |  when    | -<span class="hljs-number">2.010</span> | <span class="hljs-number">13.40</span>%
|   <span class="hljs-number">356</span> |  we      | -<span class="hljs-number">1.859</span> | <span class="hljs-number">15.58</span>%
|   <span class="hljs-number">460</span> |  can     | -<span class="hljs-number">2.508</span> | <span class="hljs-number">8.14</span>%

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Example 2: Reconstruct the sequence scores from Beam Search</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">5</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    return_dict_in_generate=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    output_scores=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transition_scores = model.compute_transition_scores(
<span class="hljs-meta">... </span>    outputs.sequences, outputs.scores, outputs.beam_indices, normalize_logits=<span class="hljs-literal">False</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If you sum the generated tokens&#x27; scores and apply the length penalty, you&#x27;ll get the sequence scores.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Tip: recomputing the scores is only guaranteed to match with \`normalize_logits=False\`. Depending on the</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># use case, you might want to recompute it with \`normalize_logits=True\`.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output_length = np.<span class="hljs-built_in">sum</span>(transition_scores.numpy() &lt; <span class="hljs-number">0</span>, axis=<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>length_penalty = model.generation_config.length_penalty
<span class="hljs-meta">&gt;&gt;&gt; </span>reconstructed_scores = np.<span class="hljs-built_in">sum</span>(transition_scores, axis=<span class="hljs-number">1</span>) / (output_length**length_penalty)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(np.allclose(outputs.sequences_scores, reconstructed_scores))
<span class="hljs-literal">True</span>`,wrap:!1}}),{c(){l=s("p"),l.textContent=G,g=n(),u(m.$$.fragment)},l(r){l=a(r,"P",{"data-svelte-h":!0}),d(l)!=="svelte-kvfsh7"&&(l.textContent=G),g=o(r),f(m.$$.fragment,r)},m(r,w){p(r,l,w),p(r,g,w),h(m,r,w),M=!0},p:Tt,i(r){M||(_(m.$$.fragment,r),M=!0)},o(r){b(m.$$.fragment,r),M=!1},d(r){r&&(i(l),i(g)),y(m,r)}}}function os(Z){let l,G,g,m,M,r,w,to="Each framework has a generate method for text generation implemented in their respective <code>GenerationMixin</code> class:",kt,ie,no='<li>PyTorch <a href="/docs/transformers/pr_27501/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> is implemented in <a href="/docs/transformers/pr_27501/en/main_classes/text_generation#transformers.GenerationMixin">GenerationMixin</a>.</li> <li>TensorFlow <a href="/docs/transformers/pr_27501/en/main_classes/text_generation#transformers.TFGenerationMixin.generate">generate()</a> is implemented in <a href="/docs/transformers/pr_27501/en/main_classes/text_generation#transformers.TFGenerationMixin">TFGenerationMixin</a>.</li> <li>Flax/JAX <a href="/docs/transformers/pr_27501/en/main_classes/text_generation#transformers.FlaxGenerationMixin.generate">generate()</a> is implemented in <a href="/docs/transformers/pr_27501/en/main_classes/text_generation#transformers.FlaxGenerationMixin">FlaxGenerationMixin</a>.</li>',Gt,le,oo=`Regardless of your framework of choice, you can parameterize the generate method with a <a href="/docs/transformers/pr_27501/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>
class instance. Please refer to this class for the complete list of generation parameters, which control the behavior
of the generation method.`,Jt,ce,so=`To learn how to inspect a model’s generation configuration, what are the defaults, how to change the parameters ad hoc,
and how to create and save a customized generation configuration, refer to the
<a href="../generation_strategies">text generation strategies guide</a>. The guide also explains how to use related features,
like token streaming.`,Ct,de,Ut,v,me,Yt,Xe,ao=`Class that holds a configuration for a generation task. A <code>generate</code> call supports the following generation methods
for text-decoder, text-to-text, speech-to-text, and vision-to-text models:`,Qt,Re,ro="<li><em>greedy decoding</em> if <code>num_beams=1</code> and <code>do_sample=False</code></li> <li><em>contrastive search</em> if <code>penalty_alpha&gt;0.</code> and <code>top_k&gt;1</code></li> <li><em>multinomial sampling</em> if <code>num_beams=1</code> and <code>do_sample=True</code></li> <li><em>beam-search decoding</em> if <code>num_beams&gt;1</code> and <code>do_sample=False</code></li> <li><em>beam-search multinomial sampling</em> if <code>num_beams&gt;1</code> and <code>do_sample=True</code></li> <li><em>diverse beam-search decoding</em> if <code>num_beams&gt;1</code> and <code>num_beam_groups&gt;1</code></li> <li><em>constrained beam-search decoding</em> if <code>constraints!=None</code> or <code>force_words_ids!=None</code></li> <li><em>assisted decoding</em> if <code>assistant_model</code> or <code>prompt_lookup_num_tokens</code> is passed to <code>.generate()</code></li>",At,Fe,io='To learn more about decoding strategies refer to the <a href="../generation_strategies">text generation strategies guide</a>.',Pt,E,Ot,z,pe,Kt,Ne,lo='Instantiate a <a href="/docs/transformers/pr_27501/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a> from a generation configuration file.',en,S,tn,q,ge,nn,Le,co=`Instantiates a <a href="/docs/transformers/pr_27501/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a> from a <a href="/docs/transformers/pr_27501/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>. This function is useful to convert legacy
<a href="/docs/transformers/pr_27501/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> objects, which may contain generation parameters, into a stand-alone <a href="/docs/transformers/pr_27501/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>.`,on,Y,ue,sn,De,mo=`Save a generation configuration object to the directory <code>save_directory</code>, so that it can be re-loaded using the
<a href="/docs/transformers/pr_27501/en/main_classes/text_generation#transformers.GenerationConfig.from_pretrained">from_pretrained()</a> class method.`,an,Q,fe,rn,Ee,po=`Updates attributes of this class instance with attributes from <code>kwargs</code> if they match existing attributes,
returning all the unused kwargs.`,ln,H,he,cn,Se,go=`Validates the values of the attributes of the <a href="/docs/transformers/pr_27501/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a> instance. Raises exceptions in the presence
of parameterization that can be detected as incorrect from the configuration instance alone.`,dn,qe,uo=`Note that some parameters not validated here are best validated at generate runtime, as they may depend on
other inputs and/or the model, such as parameters related to the generation length.`,mn,A,_e,pn,Ye,fo='Returns the generation mode triggered by the <a href="/docs/transformers/pr_27501/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a> instance.',Bt,T,be,gn,Qe,ho=`Class that holds arguments for watermark generation and should be passed into <code>GenerationConfig</code> during <code>generate</code>.
See <a href="https://arxiv.org/abs/2306.04634" rel="nofollow">this paper</a> for more details on the arguments.`,un,Ae,_o="Accepts the following keys:",fn,Pe,bo=`<li>greenlist_ratio (<code>float</code>):
Used for watermarking. The ratio of “green” tokens used to the vocabulary size. Defaults to 0.25.</li> <li>bias (<code>float</code>):
Used with watermarking. The bias added to the selected “green” tokens’ logits. Defaults to 2.0.</li> <li>hashing_key (<code>int</code>):
Hashing key used for watermarking. Defaults to 15485863 (the millionth prime).</li> <li>seeding_scheme (<code>str</code>):
Algorithm to use for watermarking. Accepts values:<ul><li>“lefthash” (default): “green” tokens selection depend on the last token (Algorithm 2 from the paper)</li> <li>“selfhash”: “green” tokens selection depends on the current token itself (Algorithm 3 from the paper)
The downside of this scheme is that it considers all possible next tokens and can be slower than “lefthash”.</li></ul></li> <li>context_width(<code>int</code>):
The context length of previous tokens to use in seeding. Higher context length makes watermarking more robust.</li>`,hn,P,ye,_n,Oe,yo="Constructs a WatermarkingConfig instance from a dictionary of parameters.",bn,O,Me,yn,Ke,Mo="Serializes this instance to a Python dictionary.",Mn,K,we,wn,et,wo="Save this instance to a JSON file.",vn,ee,ve,xn,tt,vo="Serializes this instance to a JSON formatted string.",Tn,te,xe,jn,nt,xo="Update the configuration attributes with new values.",$t,Te,To="## GenerationMixin[[transformers.GenerationMixin]]",Zt,C,je,kn,ot,jo='A class containing all functions for auto-regressive text generation, to be used as a mixin in <a href="/docs/transformers/pr_27501/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>.',Gn,st,ko='The class exposes <a href="/docs/transformers/pr_27501/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>, which can be used for:',Jn,at,Go="<li><em>greedy decoding</em> if <code>num_beams=1</code> and <code>do_sample=False</code></li> <li><em>contrastive search</em> if <code>penalty_alpha&gt;0</code> and <code>top_k&gt;1</code></li> <li><em>multinomial sampling</em> if <code>num_beams=1</code> and <code>do_sample=True</code></li> <li><em>beam-search decoding</em> if <code>num_beams&gt;1</code> and <code>do_sample=False</code></li> <li><em>beam-search multinomial sampling</em> if <code>num_beams&gt;1</code> and <code>do_sample=True</code></li> <li><em>diverse beam-search decoding</em> if <code>num_beams&gt;1</code> and <code>num_beam_groups&gt;1</code></li> <li><em>constrained beam-search decoding</em> if <code>constraints!=None</code> or <code>force_words_ids!=None</code></li> <li><em>assisted decoding</em> if <code>assistant_model</code> or <code>prompt_lookup_num_tokens</code> is passed to <code>.generate()</code></li>",Cn,rt,Jo='To learn more about decoding strategies refer to the <a href="../generation_strategies">text generation strategies guide</a>.',Un,X,ke,Bn,it,Co="Generates sequences of token ids for models with a language modeling head.",$n,ne,Zn,R,Ge,In,lt,Uo=`Computes the transition scores of sequences given the generation scores (and beam indices, if beam search was
used). This is a convenient method to quicky obtain the scores of the selected tokens at generation time.`,Wn,oe,It,Je,Bo="## TFGenerationMixin[[transformers.TFGenerationMixin]]",Wt,U,Ce,Vn,ct,$o='A class containing all of the functions supporting generation, to be used as a mixin in <a href="/docs/transformers/pr_27501/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>.',zn,dt,Zo='The class exposes <a href="/docs/transformers/pr_27501/en/main_classes/text_generation#transformers.TFGenerationMixin.generate">generate()</a>, which can be used for:',Hn,mt,Io=`<li><em>greedy decoding</em> by calling <code>greedy_search()</code> if <code>num_beams=1</code> and
<code>do_sample=False</code></li> <li><em>contrastive search</em> by calling <code>contrastive_search()</code> if <code>penalty_alpha&gt;0</code> and
<code>top_k&gt;1</code></li> <li><em>multinomial sampling</em> by calling <code>sample()</code> if <code>num_beams=1</code> and
<code>do_sample=True</code></li> <li><em>beam-search decoding</em> by calling <code>beam_search()</code> if <code>num_beams&gt;1</code></li>`,Xn,pt,Wo=`You do not need to call any of the above methods directly. Pass custom parameter values to ‘generate’ instead. To
learn more about decoding strategies refer to the <a href="../generation_strategies">text generation strategies guide</a>.`,Rn,F,Ue,Fn,gt,Vo="Generates sequences of token ids for models with a language modeling head.",Nn,se,Ln,N,Be,Dn,ut,zo=`Computes the transition scores of sequences given the generation scores (and beam indices, if beam search was
used). This is a convenient method to quicky obtain the scores of the selected tokens at generation time.`,En,ae,Vt,$e,Ho="## FlaxGenerationMixin[[transformers.FlaxGenerationMixin]]",zt,$,Ze,Sn,ft,Xo=`A class containing all functions for auto-regressive text generation, to be used as a mixin in
<a href="/docs/transformers/pr_27501/en/main_classes/model#transformers.FlaxPreTrainedModel">FlaxPreTrainedModel</a>.`,qn,ht,Ro='The class exposes <a href="/docs/transformers/pr_27501/en/main_classes/text_generation#transformers.FlaxGenerationMixin.generate">generate()</a>, which can be used for:',Yn,_t,Fo=`<li><em>greedy decoding</em> by calling <code>_greedy_search()</code> if <code>num_beams=1</code> and
<code>do_sample=False</code></li> <li><em>multinomial sampling</em> by calling <code>_sample()</code> if <code>num_beams=1</code> and
<code>do_sample=True</code></li> <li><em>beam-search decoding</em> by calling <code>_beam_search()</code> if <code>num_beams&gt;1</code> and
<code>do_sample=False</code></li>`,Qn,bt,No=`You do not need to call any of the above methods directly. Pass custom parameter values to ‘generate’ instead. To
learn more about decoding strategies refer to the <a href="../generation_strategies">text generation strategies guide</a>.`,An,re,Ie,Pn,yt,Lo="Generates sequences of token ids for models with a language modeling head.",Ht,We,Xt,jt,Rt;return M=new Do({props:{title:"Generation",local:"generation",headingTag:"h1"}}),de=new Do({props:{title:"GenerationConfig",local:"transformers.GenerationConfig",headingTag:"h2"}}),me=new J({props:{name:"class transformers.GenerationConfig",anchor:"transformers.GenerationConfig",parameters:[{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_27501/src/transformers/generation/configuration_utils.py#L70",parameterGroups:[{title:"Parameters that control the length of the output",parametersDescription:[{anchor:"transformers.GenerationConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
The maximum length the generated tokens can have. Corresponds to the length of the input prompt +
<code>max_new_tokens</code>. Its effect is overridden by <code>max_new_tokens</code>, if also set.`,name:"max_length"},{anchor:"transformers.GenerationConfig.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum numbers of tokens to generate, ignoring the number of tokens in the prompt.`,name:"max_new_tokens"},{anchor:"transformers.GenerationConfig.min_length",description:`<strong>min_length</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
The minimum length of the sequence to be generated. Corresponds to the length of the input prompt +
<code>min_new_tokens</code>. Its effect is overridden by <code>min_new_tokens</code>, if also set.`,name:"min_length"},{anchor:"transformers.GenerationConfig.min_new_tokens",description:`<strong>min_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum numbers of tokens to generate, ignoring the number of tokens in the prompt.`,name:"min_new_tokens"},{anchor:"transformers.GenerationConfig.early_stopping",description:`<strong>early_stopping</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Controls the stopping condition for beam-based methods, like beam-search. It accepts the following values:
<code>True</code>, where the generation stops as soon as there are <code>num_beams</code> complete candidates; <code>False</code>, where an
heuristic is applied and the generation stops when is it very unlikely to find better candidates;
<code>&quot;never&quot;</code>, where the beam search procedure only stops when there cannot be better candidates (canonical
beam search algorithm).`,name:"early_stopping"},{anchor:"transformers.GenerationConfig.max_time(float,",description:`<strong>max_time(<code>float</code>,</strong> <em>optional</em>) &#x2014;
The maximum amount of time you allow the computation to run for in seconds. generation will still finish
the current pass after allocated time has been passed.`,name:"max_time(float,"},{anchor:"transformers.GenerationConfig.stop_strings(`str",description:"<strong>stop_strings(`str</strong> or List[str]`, <em>optional</em>) &#x2014;\nA string or a list of strings that should terminate generation if the model outputs them.",name:"stop_strings(`str"}]},{title:"Parameters that control the generation strategy used",parametersDescription:[{anchor:"transformers.GenerationConfig.do_sample",description:`<strong>do_sample</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use sampling ; use greedy decoding otherwise.`,name:"do_sample"},{anchor:"transformers.GenerationConfig.num_beams",description:`<strong>num_beams</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of beams for beam search. 1 means no beam search.`,name:"num_beams"},{anchor:"transformers.GenerationConfig.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
<a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"transformers.GenerationConfig.penalty_alpha",description:`<strong>penalty_alpha</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The values balance the model confidence and the degeneration penalty in contrastive search decoding.`,name:"penalty_alpha"},{anchor:"transformers.GenerationConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should use the past last key/values attentions (if applicable to the model) to
speed up decoding.`,name:"use_cache"}]},{title:"Parameters for manipulation of the model output logits",parametersDescription:[{anchor:"transformers.GenerationConfig.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The value used to modulate the next token probabilities.`,name:"temperature"},{anchor:"transformers.GenerationConfig.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.GenerationConfig.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
If set to float &lt; 1, only the smallest set of most probable tokens with probabilities that add up to
<code>top_p</code> or higher are kept for generation.`,name:"top_p"},{anchor:"transformers.GenerationConfig.min_p",description:`<strong>min_p</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Minimum token probability, which will be scaled by the probability of the most likely token. It must be a
value between 0 and 1. Typical values are in the 0.01-0.2 range, comparably selective as setting <code>top_p</code> in
the 0.99-0.8 range (use the opposite of normal <code>top_p</code> values).`,name:"min_p"},{anchor:"transformers.GenerationConfig.typical_p",description:`<strong>typical_p</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Local typicality measures how similar the conditional probability of predicting a target token next is to
the expected conditional probability of predicting a random token next, given the partial text already
generated. If set to float &lt; 1, the smallest set of the most locally typical tokens with probabilities that
add up to <code>typical_p</code> or higher are kept for generation. See <a href="https://arxiv.org/pdf/2202.00666.pdf" rel="nofollow">this
paper</a> for more details.`,name:"typical_p"},{anchor:"transformers.GenerationConfig.epsilon_cutoff",description:`<strong>epsilon_cutoff</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
If set to float strictly between 0 and 1, only tokens with a conditional probability greater than
<code>epsilon_cutoff</code> will be sampled. In the paper, suggested values range from 3e-4 to 9e-4, depending on the
size of the model. See <a href="https://arxiv.org/abs/2210.15191" rel="nofollow">Truncation Sampling as Language Model
Desmoothing</a> for more details.`,name:"epsilon_cutoff"},{anchor:"transformers.GenerationConfig.eta_cutoff",description:`<strong>eta_cutoff</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Eta sampling is a hybrid of locally typical sampling and epsilon sampling. If set to float strictly between
0 and 1, a token is only considered if it is greater than either <code>eta_cutoff</code> or <code>sqrt(eta_cutoff) * exp(-entropy(softmax(next_token_logits)))</code>. The latter term is intuitively the expected next token
probability, scaled by <code>sqrt(eta_cutoff)</code>. In the paper, suggested values range from 3e-4 to 2e-3,
depending on the size of the model. See <a href="https://arxiv.org/abs/2210.15191" rel="nofollow">Truncation Sampling as Language Model
Desmoothing</a> for more details.`,name:"eta_cutoff"},{anchor:"transformers.GenerationConfig.diversity_penalty",description:`<strong>diversity_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
This value is subtracted from a beam&#x2019;s score if it generates a token same as any beam from other group at a
particular time. Note that <code>diversity_penalty</code> is only effective if <code>group beam search</code> is enabled.`,name:"diversity_penalty"},{anchor:"transformers.GenerationConfig.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"},{anchor:"transformers.GenerationConfig.encoder_repetition_penalty",description:`<strong>encoder_repetition_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The paramater for encoder_repetition_penalty. An exponential penalty on sequences that are not in the
original input. 1.0 means no penalty.`,name:"encoder_repetition_penalty"},{anchor:"transformers.GenerationConfig.length_penalty",description:`<strong>length_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to
the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log
likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while
<code>length_penalty</code> &lt; 0.0 encourages shorter sequences.`,name:"length_penalty"},{anchor:"transformers.GenerationConfig.no_repeat_ngram_size",description:`<strong>no_repeat_ngram_size</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If set to int &gt; 0, all ngrams of that size can only occur once.`,name:"no_repeat_ngram_size"},{anchor:"transformers.GenerationConfig.bad_words_ids(List[List[int]],",description:`<strong>bad_words_ids(<code>List[List[int]]</code>,</strong> <em>optional</em>) &#x2014;
List of list of token ids that are not allowed to be generated. Check
<a href="/docs/transformers/pr_27501/en/internal/generation_utils#transformers.NoBadWordsLogitsProcessor">NoBadWordsLogitsProcessor</a> for further documentation and examples.`,name:"bad_words_ids(List[List[int]],"},{anchor:"transformers.GenerationConfig.force_words_ids(List[List[int]]",description:`<strong>force_words_ids(<code>List[List[int]]</code></strong> or <code>List[List[List[int]]]</code>, <em>optional</em>) &#x2014;
List of token ids that must be generated. If given a <code>List[List[int]]</code>, this is treated as a simple list of
words that must be included, the opposite to <code>bad_words_ids</code>. If given <code>List[List[List[int]]]</code>, this
triggers a <a href="https://github.com/huggingface/transformers/issues/14081" rel="nofollow">disjunctive constraint</a>, where one
can allow different forms of each word.`,name:"force_words_ids(List[List[int]]"},{anchor:"transformers.GenerationConfig.renormalize_logits",description:`<strong>renormalize_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to renormalize the logits after applying all the logits processors or warpers (including the custom
ones). It&#x2019;s highly recommended to set this flag to <code>True</code> as the search algorithms suppose the score logits
are normalized but some logit processors or warpers break the normalization.`,name:"renormalize_logits"},{anchor:"transformers.GenerationConfig.constraints",description:`<strong>constraints</strong> (<code>List[Constraint]</code>, <em>optional</em>) &#x2014;
Custom constraints that can be added to the generation to ensure that the output will contain the use of
certain tokens as defined by <code>Constraint</code> objects, in the most sensible way possible.`,name:"constraints"},{anchor:"transformers.GenerationConfig.forced_bos_token_id",description:`<strong>forced_bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to <code>model.config.forced_bos_token_id</code>) &#x2014;
The id of the token to force as the first generated token after the <code>decoder_start_token_id</code>. Useful for
multilingual models like <a href="../model_doc/mbart">mBART</a> where the first generated token needs to be the target
language token.`,name:"forced_bos_token_id"},{anchor:"transformers.GenerationConfig.forced_eos_token_id",description:`<strong>forced_eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>, defaults to <code>model.config.forced_eos_token_id</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached. Optionally, use a
list to set multiple <em>end-of-sequence</em> tokens.`,name:"forced_eos_token_id"},{anchor:"transformers.GenerationConfig.remove_invalid_values",description:`<strong>remove_invalid_values</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>model.config.remove_invalid_values</code>) &#x2014;
Whether to remove possible <em>nan</em> and <em>inf</em> outputs of the model to prevent the generation method to crash.
Note that using <code>remove_invalid_values</code> can slow down generation.`,name:"remove_invalid_values"},{anchor:"transformers.GenerationConfig.exponential_decay_length_penalty",description:`<strong>exponential_decay_length_penalty</strong> (<code>tuple(int, float)</code>, <em>optional</em>) &#x2014;
This Tuple adds an exponentially increasing length penalty, after a certain amount of tokens have been
generated. The tuple shall consist of: <code>(start_index, decay_factor)</code> where <code>start_index</code> indicates where
penalty starts and <code>decay_factor</code> represents the factor of exponential decay`,name:"exponential_decay_length_penalty"},{anchor:"transformers.GenerationConfig.suppress_tokens",description:`<strong>suppress_tokens</strong>  (<code>List[int]</code>, <em>optional</em>) &#x2014;
A list of tokens that will be suppressed at generation. The <code>SupressTokens</code> logit processor will set their
log probs to <code>-inf</code> so that they are not sampled.`,name:"suppress_tokens"},{anchor:"transformers.GenerationConfig.begin_suppress_tokens",description:`<strong>begin_suppress_tokens</strong>  (<code>List[int]</code>, <em>optional</em>) &#x2014;
A list of tokens that will be suppressed at the beginning of the generation. The <code>SupressBeginTokens</code> logit
processor will set their log probs to <code>-inf</code> so that they are not sampled.`,name:"begin_suppress_tokens"},{anchor:"transformers.GenerationConfig.forced_decoder_ids",description:`<strong>forced_decoder_ids</strong> (<code>List[List[int]]</code>, <em>optional</em>) &#x2014;
A list of pairs of integers which indicates a mapping from generation indices to token indices that will be
forced before sampling. For example, <code>[[1, 123]]</code> means the second generated token will always be a token
of index 123.`,name:"forced_decoder_ids"},{anchor:"transformers.GenerationConfig.sequence_bias",description:`<strong>sequence_bias</strong> (<code>Dict[Tuple[int], float]</code>, <em>optional</em>)) &#x2014;
Dictionary that maps a sequence of tokens to its bias term. Positive biases increase the odds of the
sequence being selected, while negative biases do the opposite. Check
<a href="/docs/transformers/pr_27501/en/internal/generation_utils#transformers.SequenceBiasLogitsProcessor">SequenceBiasLogitsProcessor</a> for further documentation and examples.`,name:"sequence_bias"},{anchor:"transformers.GenerationConfig.token_healing",description:`<strong>token_healing</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Heal tail tokens of prompts by replacing them with their appropriate extensions.
This enhances the quality of completions for prompts affected by greedy tokenization bias.`,name:"token_healing"},{anchor:"transformers.GenerationConfig.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The guidance scale for classifier free guidance (CFG). CFG is enabled by setting <code>guidance_scale &gt; 1</code>.
Higher guidance scale encourages the model to generate samples that are more closely linked to the input
prompt, usually at the expense of poorer quality.`,name:"guidance_scale"},{anchor:"transformers.GenerationConfig.low_memory",description:`<strong>low_memory</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Switch to sequential beam search and sequential topk for contrastive search to reduce peak memory.
Used with beam search and contrastive search.`,name:"low_memory"},{anchor:"transformers.GenerationConfig.watermarking_config",description:`<strong>watermarking_config</strong> (Union[<code>WatermarkingConfig</code>, <code>dict</code>], <em>optional</em>) &#x2014;
Arguments used to watermark the model outputs by adding a small bias to randomly selected set of &#x201C;green&#x201D; tokens.
If passed as <code>Dict</code>, it will be converted to a <code>WatermarkingConfig</code> internally.
See <a href="https://arxiv.org/abs/2306.04634" rel="nofollow">this paper</a> for more details. Accepts the following keys:<ul>
<li>greenlist_ratio (<code>float</code>):
Used for watermarking. The ratio of &#x201C;green&#x201D; tokens used to the vocabulary size. Defaults to 0.25.</li>
<li>bias (<code>float</code>):
Used with watermarking. The bias added to the selected &#x201C;green&#x201D; tokens&#x2019; logits. Defaults to 2.0.</li>
<li>hashing_key (<code>int</code>):
Hahsing key used for watermarking. Defaults to 15485863 (the millionth prime).</li>
<li>seeding_scheme (<code>str</code>):
Algorithm to use for watermarking. Accepts values:<ul>
<li>&#x201C;lefthash&#x201D; (default): &#x201C;green&#x201D; tokens selection depend on the last token (Algorithm 2 from the paper)</li>
<li>&#x201C;selfhash&#x201D;: &#x201C;green&#x201D; tokens selection depends on the current token itself (Algorithm 3 from the paper)
The downside of this scheme is that it considers all possible next tokens and can be slower than &#x201C;lefthash&#x201D;.</li>
</ul></li>
<li>context_width(<code>int</code>):
The context length of previous tokens to use in seeding. Higher context length makes watermarking more robust.</li>
</ul>`,name:"watermarking_config"}]},{title:"Parameters that define the output variables of generate",parametersDescription:[{anchor:"transformers.GenerationConfig.num_return_sequences(int,",description:`<strong>num_return_sequences(<code>int</code>,</strong> <em>optional</em>, defaults to 1) &#x2014;
The number of independently computed returned sequences for each element in the batch.`,name:"num_return_sequences(int,"},{anchor:"transformers.GenerationConfig.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationConfig.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationConfig.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationConfig.output_logits",description:`<strong>output_logits</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the unprocessed prediction logit scores. See <code>logits</code> under returned tensors for
more details.`,name:"output_logits"},{anchor:"transformers.GenerationConfig.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_27501/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"}]},{title:"Special tokens that can be used at generation time",parametersDescription:[{anchor:"transformers.GenerationConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>beginning-of-sequence</em> token.`,name:"bos_token_id"},{anchor:"transformers.GenerationConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}]},{title:"Generation parameters exclusive to encoder-decoder models",parametersDescription:[{anchor:"transformers.GenerationConfig.encoder_no_repeat_ngram_size",description:`<strong>encoder_no_repeat_ngram_size</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If set to int &gt; 0, all ngrams of that size that occur in the <code>encoder_input_ids</code> cannot occur in the
<code>decoder_input_ids</code>.`,name:"encoder_no_repeat_ngram_size"},{anchor:"transformers.GenerationConfig.decoder_start_token_id",description:`<strong>decoder_start_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
If an encoder-decoder model starts decoding with a different token than <em>bos</em>, the id of that token or a list of length
<code>batch_size</code>. Indicating a list enables different start ids for each element in the batch
(e.g. multilingual models with different target languages in one batch)`,name:"decoder_start_token_id"}]},{title:"Generation parameters exclusive to assistant generation",parametersDescription:[{anchor:"transformers.GenerationConfig.num_assistant_tokens",description:`<strong>num_assistant_tokens</strong> (<code>int</code>, <em>optional</em>, defaults to 5) &#x2014;
Defines the number of <em>speculative tokens</em> that shall be generated by the assistant model before being
checked by the target model at each iteration. Higher values for <code>num_assistant_tokens</code> make the generation
more <em>speculative</em> : If the assistant model is performant larger speed-ups can be reached, if the assistant
model requires lots of corrections, lower speed-ups are reached.`,name:"num_assistant_tokens"},{anchor:"transformers.GenerationConfig.num_assistant_tokens_schedule",description:`<strong>num_assistant_tokens_schedule</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;heuristic&quot;</code>) &#x2014;
Defines the schedule at which max assistant tokens shall be changed during inference.<ul>
<li><code>&quot;heuristic&quot;</code>: When all speculative tokens are correct, increase <code>num_assistant_tokens</code> by 2 else
reduce by 1. <code>num_assistant_tokens</code> value is persistent over multiple generation calls with the same assistant model.</li>
<li><code>&quot;heuristic_transient&quot;</code>: Same as <code>&quot;heuristic&quot;</code> but <code>num_assistant_tokens</code> is reset to its initial value after each generation call.</li>
<li><code>&quot;constant&quot;</code>: <code>num_assistant_tokens</code> stays unchanged during generation</li>
</ul>`,name:"num_assistant_tokens_schedule"},{anchor:"transformers.GenerationConfig.prompt_lookup_num_tokens",description:`<strong>prompt_lookup_num_tokens</strong> (<code>int</code>, <em>optional</em>, default to <code>None</code>) &#x2014;
The number of tokens to be output as candidate tokens.`,name:"prompt_lookup_num_tokens"},{anchor:"transformers.GenerationConfig.max_matching_ngram_size",description:`<strong>max_matching_ngram_size</strong> (<code>int</code>, <em>optional</em>, default to <code>None</code>) &#x2014;
The maximum ngram size to be considered for matching in the prompt. Default to 2 if not provided.`,name:"max_matching_ngram_size"}]},{title:"Parameters specific to the caching mechanism",parametersDescription:[{anchor:"transformers.GenerationConfig.cache_implementation",description:`<strong>cache_implementation</strong> (<code>str</code>, <em>optional</em>, default to <code>None</code>) &#x2014;
Cache class that should be used when generating.`,name:"cache_implementation"},{anchor:"transformers.GenerationConfig.cache_config",description:`<strong>cache_config</strong> (<code>Union[CacheConfig, dict]</code>, <em>optional</em>, default to <code>None</code>) &#x2014;
Arguments used in the key-value cache class can be passed in <code>cache_config</code>. Can be passed as a <code>Dict</code> and
it will be converted to its repsective <code>CacheConfig</code> internally.
Otherwise can be passed as a <code>CacheConfig</code> class matching the indicated <code>cache_implementation</code>.`,name:"cache_config"},{anchor:"transformers.GenerationConfig.return_legacy_cache",description:`<strong>return_legacy_cache</strong> (<code>bool</code>, <em>optional</em>, default to <code>True</code>) &#x2014;
Whether to return the legacy or new format of the cache when <code>DynamicCache</code> is used by default.`,name:"return_legacy_cache"}]},{title:"Wild card",parametersDescription:[]}]}}),E=new On({props:{$$slots:{default:[Po]},$$scope:{ctx:Z}}}),pe=new J({props:{name:"from_pretrained",anchor:"transformers.GenerationConfig.from_pretrained",parameters:[{name:"pretrained_model_name",val:": Union"},{name:"config_file_name",val:": Union = None"},{name:"cache_dir",val:": Union = None"},{name:"force_download",val:": bool = False"},{name:"local_files_only",val:": bool = False"},{name:"token",val:": Union = None"},{name:"revision",val:": str = 'main'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationConfig.from_pretrained.pretrained_model_name",description:`<strong>pretrained_model_name</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained model configuration hosted inside a model repo on
huggingface.co.</li>
<li>a path to a <em>directory</em> containing a configuration file saved using the
<a href="/docs/transformers/pr_27501/en/main_classes/text_generation#transformers.GenerationConfig.save_pretrained">save_pretrained()</a> method, e.g., <code>./my_model_directory/</code>.</li>
</ul>`,name:"pretrained_model_name"},{anchor:"transformers.GenerationConfig.from_pretrained.config_file_name",description:`<strong>config_file_name</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>, defaults to <code>&quot;generation_config.json&quot;</code>) &#x2014;
Name of the generation configuration JSON file to be loaded from <code>pretrained_model_name</code>.`,name:"config_file_name"},{anchor:"transformers.GenerationConfig.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.GenerationConfig.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force to (re-)download the configuration files and override the cached versions if
they exist.
resume_download &#x2014;
Deprecated and ignored. All downloads are now resumed by default when possible.
Will be removed in v5 of Transformers.`,name:"force_download"},{anchor:"transformers.GenerationConfig.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}.</code> The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.GenerationConfig.from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, or not specified, will use
the token generated when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.GenerationConfig.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>To test a pull request you made on the Hub, you can pass \`revision=&#x201C;refs/pr/<pr_number>&#x201C;.</pr_number></p>

					</div>`,name:"revision"},{anchor:"transformers.GenerationConfig.from_pretrained.return_unused_kwargs",description:`<strong>return_unused_kwargs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>False</code>, then this function returns just the final configuration object.</p>
<p>If <code>True</code>, then this functions returns a <code>Tuple(config, unused_kwargs)</code> where <em>unused_kwargs</em> is a
dictionary consisting of the key/value pairs whose keys are not configuration attributes: i.e., the
part of <code>kwargs</code> which has not been used to update <code>config</code> and is otherwise ignored.`,name:"return_unused_kwargs"},{anchor:"transformers.GenerationConfig.from_pretrained.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the relevant files are located inside a subfolder of the model repo on huggingface.co, you can
specify the folder name here.`,name:"subfolder"},{anchor:"transformers.GenerationConfig.from_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
The values in kwargs of any keys which are configuration attributes will be used to override the loaded
values. Behavior concerning key/value pairs whose keys are <em>not</em> configuration attributes is controlled
by the <code>return_unused_kwargs</code> keyword parameter.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_27501/src/transformers/generation/configuration_utils.py#L780",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The configuration object instantiated from this pretrained model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_27501/en/main_classes/text_generation#transformers.GenerationConfig"
>GenerationConfig</a></p>
`}}),S=new Kn({props:{anchor:"transformers.GenerationConfig.from_pretrained.example",$$slots:{default:[Oo]},$$scope:{ctx:Z}}}),ge=new J({props:{name:"from_model_config",anchor:"transformers.GenerationConfig.from_model_config",parameters:[{name:"model_config",val:": PretrainedConfig"}],parametersDescription:[{anchor:"transformers.GenerationConfig.from_model_config.model_config",description:`<strong>model_config</strong> (<code>PretrainedConfig</code>) &#x2014;
The model config that will be used to instantiate the generation config.`,name:"model_config"}],source:"https://github.com/huggingface/transformers/blob/vr_27501/src/transformers/generation/configuration_utils.py#L1120",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The configuration object instantiated from those parameters.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_27501/en/main_classes/text_generation#transformers.GenerationConfig"
>GenerationConfig</a></p>
`}}),ue=new J({props:{name:"save_pretrained",anchor:"transformers.GenerationConfig.save_pretrained",parameters:[{name:"save_directory",val:": Union"},{name:"config_file_name",val:": Union = None"},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationConfig.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory where the configuration JSON file will be saved (will be created if it does not exist).`,name:"save_directory"},{anchor:"transformers.GenerationConfig.save_pretrained.config_file_name",description:`<strong>config_file_name</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>, defaults to <code>&quot;generation_config.json&quot;</code>) &#x2014;
Name of the generation configuration JSON file to be saved in <code>save_directory</code>.`,name:"config_file_name"},{anchor:"transformers.GenerationConfig.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"transformers.GenerationConfig.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional key word arguments passed along to the <a href="/docs/transformers/pr_27501/en/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_27501/src/transformers/generation/configuration_utils.py#L703"}}),fe=new J({props:{name:"update",anchor:"transformers.GenerationConfig.update",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationConfig.update.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Dictionary of attributes to tentatively update this class.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_27501/src/transformers/generation/configuration_utils.py#L1150",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary containing all the key-value pairs that were not used to update the instance.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),he=new J({props:{name:"validate",anchor:"transformers.GenerationConfig.validate",parameters:[{name:"is_init",val:" = False"}],parametersDescription:[{anchor:"transformers.GenerationConfig.validate.is_init",description:`<strong>is_init</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the validation is performed during the initialization of the instance.`,name:"is_init"}],source:"https://github.com/huggingface/transformers/blob/vr_27501/src/transformers/generation/configuration_utils.py#L500"}}),_e=new J({props:{name:"get_generation_mode",anchor:"transformers.GenerationConfig.get_generation_mode",parameters:[{name:"assistant_model",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.GenerationConfig.get_generation_mode.assistant_model",description:`<strong>assistant_model</strong> (<code>PreTrainedModel</code>, <em>optional</em>) &#x2014;
The assistant model to be used for assisted generation. If set, the generation mode will be
assisted generation.`,name:"assistant_model"}],source:"https://github.com/huggingface/transformers/blob/vr_27501/src/transformers/generation/configuration_utils.py#L452",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generation mode triggered by the instance.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>GenerationMode</code></p>
`}}),be=new J({props:{name:"class transformers.WatermarkingConfig",anchor:"transformers.WatermarkingConfig",parameters:[{name:"greenlist_ratio",val:": Optional = 0.25"},{name:"bias",val:": Optional = 2.0"},{name:"hashing_key",val:": Optional = 15485863"},{name:"seeding_scheme",val:": Optional = 'lefthash'"},{name:"context_width",val:": Optional = 1"}],source:"https://github.com/huggingface/transformers/blob/vr_27501/src/transformers/generation/configuration_utils.py#L1176"}}),ye=new J({props:{name:"from_dict",anchor:"transformers.WatermarkingConfig.from_dict",parameters:[{name:"config_dict",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.WatermarkingConfig.from_dict.config_dict",description:`<strong>config_dict</strong> (Dict[str, Any]) &#x2014; Dictionary containing configuration parameters.
**kwargs &#x2014; Additional keyword arguments to override dictionary values.`,name:"config_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_27501/src/transformers/generation/configuration_utils.py#L1212",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Instance of WatermarkingConfig constructed from the dictionary.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>WatermarkingConfig</p>
`}}),Me=new J({props:{name:"to_dict",anchor:"transformers.WatermarkingConfig.to_dict",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_27501/src/transformers/generation/configuration_utils.py#L1247",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of all the attributes that make up this configuration instance.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dict[str, Any]</p>
`}}),we=new J({props:{name:"to_json_file",anchor:"transformers.WatermarkingConfig.to_json_file",parameters:[{name:"json_file_path",val:": Union"}],parametersDescription:[{anchor:"transformers.WatermarkingConfig.to_json_file.json_file_path",description:"<strong>json_file_path</strong> (Union[str, os.PathLike]) &#x2014; Path to the JSON file in which this configuration instance&#x2019;s parameters will be saved.",name:"json_file_path"}],source:"https://github.com/huggingface/transformers/blob/vr_27501/src/transformers/generation/configuration_utils.py#L1234"}}),ve=new J({props:{name:"to_json_string",anchor:"transformers.WatermarkingConfig.to_json_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_27501/src/transformers/generation/configuration_utils.py#L1264",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>JSON formatted string representing the configuration instance.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>str</p>
`}}),xe=new J({props:{name:"update",anchor:"transformers.WatermarkingConfig.update",parameters:[{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_27501/src/transformers/generation/configuration_utils.py#L1273"}}),je=new J({props:{name:"class transformers.GenerationMixin",anchor:"transformers.GenerationMixin",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_27501/src/transformers/generation/utils.py#L347"}}),ke=new J({props:{name:"generate",anchor:"transformers.GenerationMixin.generate",parameters:[{name:"inputs",val:": Optional = None"},{name:"generation_config",val:": Optional = None"},{name:"logits_processor",val:": Optional = None"},{name:"stopping_criteria",val:": Optional = None"},{name:"prefix_allowed_tokens_fn",val:": Optional = None"},{name:"synced_gpus",val:": Optional = None"},{name:"assistant_model",val:": Optional = None"},{name:"streamer",val:": Optional = None"},{name:"negative_prompt_ids",val:": Optional = None"},{name:"negative_prompt_attention_mask",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.generate.inputs",description:`<strong>inputs</strong> (<code>torch.Tensor</code> of varying shape depending on the modality, <em>optional</em>) &#x2014;
The sequence used as a prompt for the generation or as model inputs to the encoder. If <code>None</code> the
method initializes it with <code>bos_token_id</code> and a batch size of 1. For decoder-only models <code>inputs</code>
should be in the format of <code>input_ids</code>. For encoder-decoder models <em>inputs</em> can represent any of
<code>input_ids</code>, <code>input_values</code>, <code>input_features</code>, or <code>pixel_values</code>.`,name:"inputs"},{anchor:"transformers.GenerationMixin.generate.generation_config",description:`<strong>generation_config</strong> (<a href="/docs/transformers/pr_27501/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>, <em>optional</em>) &#x2014;
The generation configuration to be used as base parametrization for the generation call. <code>**kwargs</code>
passed to generate matching the attributes of <code>generation_config</code> will override them. If
<code>generation_config</code> is not provided, the default will be used, which has the following loading
priority: 1) from the <code>generation_config.json</code> model file, if it exists; 2) from the model
configuration. Please note that unspecified parameters will inherit <a href="/docs/transformers/pr_27501/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>&#x2019;s
default values, whose documentation should be checked to parameterize generation.`,name:"generation_config"},{anchor:"transformers.GenerationMixin.generate.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
Custom logits processors that complement the default logits processors built from arguments and
generation config. If a logit processor is passed that is already created with the arguments or a
generation config an error is thrown. This feature is intended for advanced users.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.generate.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
Custom stopping criteria that complements the default stopping criteria built from arguments and a
generation config. If a stopping criteria is passed that is already created with the arguments or a
generation config an error is thrown. If your stopping criteria depends on the <code>scores</code> input, make
sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>. This feature is
intended for advanced users.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.generate.prefix_allowed_tokens_fn",description:`<strong>prefix_allowed_tokens_fn</strong> (<code>Callable[[int, torch.Tensor], List[int]]</code>, <em>optional</em>) &#x2014;
If provided, this function constraints the beam search to allowed tokens only at each step. If not
provided no constraint is applied. This function takes 2 arguments: the batch ID <code>batch_id</code> and
<code>input_ids</code>. It has to return a list with the allowed tokens for the next generation step conditioned
on the batch ID <code>batch_id</code> and the previously generated tokens <code>inputs_ids</code>. This argument is useful
for constrained generation conditioned on the prefix, as described in <a href="https://arxiv.org/abs/2010.00904" rel="nofollow">Autoregressive Entity
Retrieval</a>.`,name:"prefix_allowed_tokens_fn"},{anchor:"transformers.GenerationMixin.generate.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to continue running the while loop until max_length. Unless overridden this flag will be set to
<code>True</code> under DeepSpeed ZeRO Stage 3 multiple GPUs environment to avoid hanging if one GPU finished
generating before other GPUs. Otherwise it&#x2019;ll be set to <code>False</code>.`,name:"synced_gpus"},{anchor:"transformers.GenerationMixin.generate.assistant_model",description:`<strong>assistant_model</strong> (<code>PreTrainedModel</code>, <em>optional</em>) &#x2014;
An assistant model that can be used to accelerate generation. The assistant model must have the exact
same tokenizer. The acceleration is achieved when forecasting candidate tokens with the assistent model
is much faster than running generation with the model you&#x2019;re calling generate from. As such, the
assistant model should be much smaller.`,name:"assistant_model"},{anchor:"transformers.GenerationMixin.generate.streamer",description:`<strong>streamer</strong> (<code>BaseStreamer</code>, <em>optional</em>) &#x2014;
Streamer object that will be used to stream the generated sequences. Generated tokens are passed
through <code>streamer.put(token_ids)</code> and the streamer is responsible for any further processing.`,name:"streamer"},{anchor:"transformers.GenerationMixin.generate.negative_prompt_ids",description:`<strong>negative_prompt_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
The negative prompt needed for some processors such as CFG. The batch size must match the input batch
size. This is an experimental feature, subject to breaking API changes in future versions.`,name:"negative_prompt_ids"},{anchor:"transformers.GenerationMixin.generate.negative_prompt_attention_mask",description:`<strong>negative_prompt_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Attention_mask for <code>negative_prompt_ids</code>.`,name:"negative_prompt_attention_mask"},{anchor:"transformers.GenerationMixin.generate.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Ad hoc parametrization of <code>generation_config</code> and/or additional model-specific kwargs that will be
forwarded to the <code>forward</code> function of the model. If the model is an encoder-decoder model, encoder
specific kwargs should not be prefixed and decoder specific kwargs should be prefixed with <em>decoder_</em>.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_27501/src/transformers/generation/utils.py#L1531",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_27501/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> (if <code>return_dict_in_generate=True</code>
or when <code>config.return_dict_in_generate=True</code>) or a <code>torch.LongTensor</code>.</p>
<p>If the model is <em>not</em> an encoder-decoder model (<code>model.config.is_encoder_decoder=False</code>), the possible
<a
  href="/docs/transformers/pr_27501/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/pr_27501/en/internal/generation_utils#transformers.generation.GenerateDecoderOnlyOutput"
>GenerateDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/pr_27501/en/internal/generation_utils#transformers.generation.GenerateBeamDecoderOnlyOutput"
>GenerateBeamDecoderOnlyOutput</a></li>
</ul>
<p>If the model is an encoder-decoder model (<code>model.config.is_encoder_decoder=True</code>), the possible
<a
  href="/docs/transformers/pr_27501/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/pr_27501/en/internal/generation_utils#transformers.generation.GenerateEncoderDecoderOutput"
>GenerateEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/pr_27501/en/internal/generation_utils#transformers.generation.GenerateBeamEncoderDecoderOutput"
>GenerateBeamEncoderDecoderOutput</a></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_27501/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> or <code>torch.LongTensor</code></p>
`}}),ne=new On({props:{warning:!0,$$slots:{default:[Ko]},$$scope:{ctx:Z}}}),Ge=new J({props:{name:"compute_transition_scores",anchor:"transformers.GenerationMixin.compute_transition_scores",parameters:[{name:"sequences",val:": Tensor"},{name:"scores",val:": Tuple"},{name:"beam_indices",val:": Optional = None"},{name:"normalize_logits",val:": bool = False"}],parametersDescription:[{anchor:"transformers.GenerationMixin.compute_transition_scores.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or
shorter if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.GenerationMixin.compute_transition_scores.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code>) &#x2014;
Transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.GenerationMixin.compute_transition_scores.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>. Only required if a <code>num_beams&gt;1</code> at
generate-time.`,name:"beam_indices"},{anchor:"transformers.GenerationMixin.compute_transition_scores.normalize_logits",description:`<strong>normalize_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to normalize the logits (which, for legacy reasons, may be unnormalized).`,name:"normalize_logits"}],source:"https://github.com/huggingface/transformers/blob/vr_27501/src/transformers/generation/utils.py#L1011",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>torch.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code> containing
the transition scores (logits)</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),oe=new Kn({props:{anchor:"transformers.GenerationMixin.compute_transition_scores.example",$$slots:{default:[es]},$$scope:{ctx:Z}}}),Ce=new J({props:{name:"class transformers.TFGenerationMixin",anchor:"transformers.TFGenerationMixin",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_27501/src/transformers/generation/tf_utils.py#L444"}}),Ue=new J({props:{name:"generate",anchor:"transformers.TFGenerationMixin.generate",parameters:[{name:"inputs",val:": Optional = None"},{name:"generation_config",val:": Optional = None"},{name:"logits_processor",val:": Optional = None"},{name:"seed",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFGenerationMixin.generate.inputs",description:`<strong>inputs</strong> (<code>tf.Tensor</code> of varying shape depending on the modality, <em>optional</em>) &#x2014;
The sequence used as a prompt for the generation or as model inputs to the encoder. If <code>None</code> the
method initializes it with <code>bos_token_id</code> and a batch size of 1. For decoder-only models <code>inputs</code>
should of in the format of <code>input_ids</code>. For encoder-decoder models <em>inputs</em> can represent any of
<code>input_ids</code>, <code>input_values</code>, <code>input_features</code>, or <code>pixel_values</code>.`,name:"inputs"},{anchor:"transformers.TFGenerationMixin.generate.generation_config",description:`<strong>generation_config</strong> (<code>~generation.GenerationConfig</code>, <em>optional</em>) &#x2014;
The generation configuration to be used as base parametrization for the generation call. <code>**kwargs</code>
passed to generate matching the attributes of <code>generation_config</code> will override them. If
<code>generation_config</code> is not provided, the default will be used, which had the following loading
priority: 1) from the <code>generation_config.json</code> model file, if it exists; 2) from the model
configuration. Please note that unspecified parameters will inherit <a href="/docs/transformers/pr_27501/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>&#x2019;s
default values, whose documentation should be checked to parameterize generation.`,name:"generation_config"},{anchor:"transformers.TFGenerationMixin.generate.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
Custom logits processors that complement the default logits processors built from arguments and
generation config. If a logit processor is passed that is already created with the arguments or a
generation config an error is thrown. This feature is intended for advanced users.`,name:"logits_processor"},{anchor:"transformers.TFGenerationMixin.generate.seed",description:`<strong>seed</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Random seed to control sampling, containing two integers, used when <code>do_sample</code> is <code>True</code>. See the
<code>seed</code> argument from stateless functions in <code>tf.random</code>.`,name:"seed"},{anchor:"transformers.TFGenerationMixin.generate.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Ad hoc parametrization of <code>generate_config</code> and/or additional model-specific kwargs that will be
forwarded to the <code>forward</code> function of the model. If the model is an encoder-decoder model, encoder
specific kwargs should not be prefixed and decoder specific kwargs should be prefixed with <em>decoder_</em>.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_27501/src/transformers/generation/tf_utils.py#L645",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_27501/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> (if <code>return_dict_in_generate=True</code> or when
<code>config.return_dict_in_generate=True</code>) or a <code>tf.Tensor</code>.</p>
<p>If the model is <em>not</em> an encoder-decoder model (<code>model.config.is_encoder_decoder=False</code>), the possible
<a
  href="/docs/transformers/pr_27501/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/pr_27501/en/internal/generation_utils#transformers.generation.TFGreedySearchDecoderOnlyOutput"
>TFGreedySearchDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/pr_27501/en/internal/generation_utils#transformers.generation.TFSampleDecoderOnlyOutput"
>TFSampleDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/pr_27501/en/internal/generation_utils#transformers.generation.TFBeamSearchDecoderOnlyOutput"
>TFBeamSearchDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/pr_27501/en/internal/generation_utils#transformers.generation.TFBeamSampleDecoderOnlyOutput"
>TFBeamSampleDecoderOnlyOutput</a></li>
</ul>
<p>If the model is an encoder-decoder model (<code>model.config.is_encoder_decoder=True</code>), the possible
<a
  href="/docs/transformers/pr_27501/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/pr_27501/en/internal/generation_utils#transformers.generation.TFGreedySearchEncoderDecoderOutput"
>TFGreedySearchEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/pr_27501/en/internal/generation_utils#transformers.generation.TFSampleEncoderDecoderOutput"
>TFSampleEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/pr_27501/en/internal/generation_utils#transformers.generation.TFBeamSearchEncoderDecoderOutput"
>TFBeamSearchEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/pr_27501/en/internal/generation_utils#transformers.generation.TFBeamSampleEncoderDecoderOutput"
>TFBeamSampleEncoderDecoderOutput</a></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_27501/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> or <code>tf.Tensor</code></p>
`}}),se=new On({props:{warning:!0,$$slots:{default:[ts]},$$scope:{ctx:Z}}}),Be=new J({props:{name:"compute_transition_scores",anchor:"transformers.TFGenerationMixin.compute_transition_scores",parameters:[{name:"sequences",val:": Tensor"},{name:"scores",val:": Tuple"},{name:"beam_indices",val:": Optional = None"},{name:"normalize_logits",val:": bool = False"}],parametersDescription:[{anchor:"transformers.TFGenerationMixin.compute_transition_scores.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or
shorter if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.TFGenerationMixin.compute_transition_scores.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code>) &#x2014;
Transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens Tuple of
<code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token), with each
tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.TFGenerationMixin.compute_transition_scores.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>. Only required if a <code>num_beams&gt;1</code> at
generate-time.`,name:"beam_indices"},{anchor:"transformers.TFGenerationMixin.compute_transition_scores.normalize_logits",description:`<strong>normalize_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to normalize the logits (which, for legacy reasons, may be unnormalized).`,name:"normalize_logits"}],source:"https://github.com/huggingface/transformers/blob/vr_27501/src/transformers/generation/tf_utils.py#L477",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code> containing
the transition scores (logits)</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tf.Tensor</code></p>
`}}),ae=new Kn({props:{anchor:"transformers.TFGenerationMixin.compute_transition_scores.example",$$slots:{default:[ns]},$$scope:{ctx:Z}}}),Ze=new J({props:{name:"class transformers.FlaxGenerationMixin",anchor:"transformers.FlaxGenerationMixin",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_27501/src/transformers/generation/flax_utils.py#L130"}}),Ie=new J({props:{name:"generate",anchor:"transformers.FlaxGenerationMixin.generate",parameters:[{name:"input_ids",val:": Array"},{name:"generation_config",val:": Optional = None"},{name:"prng_key",val:": Optional = None"},{name:"trace",val:": bool = True"},{name:"params",val:": Optional = None"},{name:"logits_processor",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxGenerationMixin.generate.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.FlaxGenerationMixin.generate.generation_config",description:`<strong>generation_config</strong> (<code>~generation.GenerationConfig</code>, <em>optional</em>) &#x2014;
The generation configuration to be used as base parametrization for the generation call. <code>**kwargs</code>
passed to generate matching the attributes of <code>generation_config</code> will override them. If
<code>generation_config</code> is not provided, the default will be used, which had the following loading
priority: 1) from the <code>generation_config.json</code> model file, if it exists; 2) from the model
configuration. Please note that unspecified parameters will inherit <a href="/docs/transformers/pr_27501/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>&#x2019;s
default values, whose documentation should be checked to parameterize generation.`,name:"generation_config"},{anchor:"transformers.FlaxGenerationMixin.generate.trace",description:`<strong>trace</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to trace generation. Setting <code>trace=False</code> should only be used for debugging and will lead to a
considerably slower runtime.`,name:"trace"},{anchor:"transformers.FlaxGenerationMixin.generate.params",description:`<strong>params</strong> (<code>Dict[str, jnp.ndarray]</code>, <em>optional</em>) &#x2014;
Optionally the model parameters can be passed. Can be useful for parallelized generation.`,name:"params"},{anchor:"transformers.FlaxGenerationMixin.generate.logits_processor",description:`<strong>logits_processor</strong> (<code>FlaxLogitsProcessorList </code>, <em>optional</em>) &#x2014;
Custom logits processors that complement the default logits processors built from arguments and
generation config. If a logit processor is passed that is already created with the arguments or a
generation config an error is thrown. This feature is intended for advanced users.`,name:"logits_processor"},{anchor:"transformers.FlaxGenerationMixin.generate.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Ad hoc parametrization of <code>generate_config</code> and/or additional model-specific kwargs that will be
forwarded to the <code>forward</code> function of the model. If the model is an encoder-decoder model, encoder
specific kwargs should not be prefixed and decoder specific kwargs should be prefixed with <em>decoder_</em>.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_27501/src/transformers/generation/flax_utils.py#L268",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_27501/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a>.</p>
`}}),We=new Ao({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/main_classes/text_generation.md"}}),{c(){l=s("meta"),G=n(),g=s("p"),m=n(),u(M.$$.fragment),r=n(),w=s("p"),w.innerHTML=to,kt=n(),ie=s("ul"),ie.innerHTML=no,Gt=n(),le=s("p"),le.innerHTML=oo,Jt=n(),ce=s("p"),ce.innerHTML=so,Ct=n(),u(de.$$.fragment),Ut=n(),v=s("div"),u(me.$$.fragment),Yt=n(),Xe=s("p"),Xe.innerHTML=ao,Qt=n(),Re=s("ul"),Re.innerHTML=ro,At=n(),Fe=s("p"),Fe.innerHTML=io,Pt=n(),u(E.$$.fragment),Ot=n(),z=s("div"),u(pe.$$.fragment),Kt=n(),Ne=s("p"),Ne.innerHTML=lo,en=n(),u(S.$$.fragment),tn=n(),q=s("div"),u(ge.$$.fragment),nn=n(),Le=s("p"),Le.innerHTML=co,on=n(),Y=s("div"),u(ue.$$.fragment),sn=n(),De=s("p"),De.innerHTML=mo,an=n(),Q=s("div"),u(fe.$$.fragment),rn=n(),Ee=s("p"),Ee.innerHTML=po,ln=n(),H=s("div"),u(he.$$.fragment),cn=n(),Se=s("p"),Se.innerHTML=go,dn=n(),qe=s("p"),qe.textContent=uo,mn=n(),A=s("div"),u(_e.$$.fragment),pn=n(),Ye=s("p"),Ye.innerHTML=fo,Bt=n(),T=s("div"),u(be.$$.fragment),gn=n(),Qe=s("p"),Qe.innerHTML=ho,un=n(),Ae=s("p"),Ae.textContent=_o,fn=n(),Pe=s("ul"),Pe.innerHTML=bo,hn=n(),P=s("div"),u(ye.$$.fragment),_n=n(),Oe=s("p"),Oe.textContent=yo,bn=n(),O=s("div"),u(Me.$$.fragment),yn=n(),Ke=s("p"),Ke.textContent=Mo,Mn=n(),K=s("div"),u(we.$$.fragment),wn=n(),et=s("p"),et.textContent=wo,vn=n(),ee=s("div"),u(ve.$$.fragment),xn=n(),tt=s("p"),tt.textContent=vo,Tn=n(),te=s("div"),u(xe.$$.fragment),jn=n(),nt=s("p"),nt.textContent=xo,$t=n(),Te=s("p"),Te.textContent=To,Zt=n(),C=s("div"),u(je.$$.fragment),kn=n(),ot=s("p"),ot.innerHTML=jo,Gn=n(),st=s("p"),st.innerHTML=ko,Jn=n(),at=s("ul"),at.innerHTML=Go,Cn=n(),rt=s("p"),rt.innerHTML=Jo,Un=n(),X=s("div"),u(ke.$$.fragment),Bn=n(),it=s("p"),it.textContent=Co,$n=n(),u(ne.$$.fragment),Zn=n(),R=s("div"),u(Ge.$$.fragment),In=n(),lt=s("p"),lt.textContent=Uo,Wn=n(),u(oe.$$.fragment),It=n(),Je=s("p"),Je.textContent=Bo,Wt=n(),U=s("div"),u(Ce.$$.fragment),Vn=n(),ct=s("p"),ct.innerHTML=$o,zn=n(),dt=s("p"),dt.innerHTML=Zo,Hn=n(),mt=s("ul"),mt.innerHTML=Io,Xn=n(),pt=s("p"),pt.innerHTML=Wo,Rn=n(),F=s("div"),u(Ue.$$.fragment),Fn=n(),gt=s("p"),gt.textContent=Vo,Nn=n(),u(se.$$.fragment),Ln=n(),N=s("div"),u(Be.$$.fragment),Dn=n(),ut=s("p"),ut.textContent=zo,En=n(),u(ae.$$.fragment),Vt=n(),$e=s("p"),$e.textContent=Ho,zt=n(),$=s("div"),u(Ze.$$.fragment),Sn=n(),ft=s("p"),ft.innerHTML=Xo,qn=n(),ht=s("p"),ht.innerHTML=Ro,Yn=n(),_t=s("ul"),_t.innerHTML=Fo,Qn=n(),bt=s("p"),bt.innerHTML=No,An=n(),re=s("div"),u(Ie.$$.fragment),Pn=n(),yt=s("p"),yt.textContent=Lo,Ht=n(),u(We.$$.fragment),Xt=n(),jt=s("p"),this.h()},l(e){const c=Qo("svelte-u9bgzb",document.head);l=a(c,"META",{name:!0,content:!0}),c.forEach(i),G=o(e),g=a(e,"P",{}),j(g).forEach(i),m=o(e),f(M.$$.fragment,e),r=o(e),w=a(e,"P",{"data-svelte-h":!0}),d(w)!=="svelte-1lm9ezt"&&(w.innerHTML=to),kt=o(e),ie=a(e,"UL",{"data-svelte-h":!0}),d(ie)!=="svelte-dymtoe"&&(ie.innerHTML=no),Gt=o(e),le=a(e,"P",{"data-svelte-h":!0}),d(le)!=="svelte-1n3jupi"&&(le.innerHTML=oo),Jt=o(e),ce=a(e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-1wifwwe"&&(ce.innerHTML=so),Ct=o(e),f(de.$$.fragment,e),Ut=o(e),v=a(e,"DIV",{class:!0});var x=j(v);f(me.$$.fragment,x),Yt=o(x),Xe=a(x,"P",{"data-svelte-h":!0}),d(Xe)!=="svelte-14531m7"&&(Xe.innerHTML=ao),Qt=o(x),Re=a(x,"UL",{"data-svelte-h":!0}),d(Re)!=="svelte-v698gs"&&(Re.innerHTML=ro),At=o(x),Fe=a(x,"P",{"data-svelte-h":!0}),d(Fe)!=="svelte-1gtazd5"&&(Fe.innerHTML=io),Pt=o(x),f(E.$$.fragment,x),Ot=o(x),z=a(x,"DIV",{class:!0});var L=j(z);f(pe.$$.fragment,L),Kt=o(L),Ne=a(L,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-1e35hme"&&(Ne.innerHTML=lo),en=o(L),f(S.$$.fragment,L),L.forEach(i),tn=o(x),q=a(x,"DIV",{class:!0});var Ve=j(q);f(ge.$$.fragment,Ve),nn=o(Ve),Le=a(Ve,"P",{"data-svelte-h":!0}),d(Le)!=="svelte-1wa08nb"&&(Le.innerHTML=co),Ve.forEach(i),on=o(x),Y=a(x,"DIV",{class:!0});var ze=j(Y);f(ue.$$.fragment,ze),sn=o(ze),De=a(ze,"P",{"data-svelte-h":!0}),d(De)!=="svelte-xnkyt1"&&(De.innerHTML=mo),ze.forEach(i),an=o(x),Q=a(x,"DIV",{class:!0});var He=j(Q);f(fe.$$.fragment,He),rn=o(He),Ee=a(He,"P",{"data-svelte-h":!0}),d(Ee)!=="svelte-n0rwld"&&(Ee.innerHTML=po),He.forEach(i),ln=o(x),H=a(x,"DIV",{class:!0});var D=j(H);f(he.$$.fragment,D),cn=o(D),Se=a(D,"P",{"data-svelte-h":!0}),d(Se)!=="svelte-1c4gabm"&&(Se.innerHTML=go),dn=o(D),qe=a(D,"P",{"data-svelte-h":!0}),d(qe)!=="svelte-1rsok5m"&&(qe.textContent=uo),D.forEach(i),mn=o(x),A=a(x,"DIV",{class:!0});var Ft=j(A);f(_e.$$.fragment,Ft),pn=o(Ft),Ye=a(Ft,"P",{"data-svelte-h":!0}),d(Ye)!=="svelte-1je063f"&&(Ye.innerHTML=fo),Ft.forEach(i),x.forEach(i),Bt=o(e),T=a(e,"DIV",{class:!0});var B=j(T);f(be.$$.fragment,B),gn=o(B),Qe=a(B,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-8pa9bo"&&(Qe.innerHTML=ho),un=o(B),Ae=a(B,"P",{"data-svelte-h":!0}),d(Ae)!=="svelte-1wzt57b"&&(Ae.textContent=_o),fn=o(B),Pe=a(B,"UL",{"data-svelte-h":!0}),d(Pe)!=="svelte-vgskhd"&&(Pe.innerHTML=bo),hn=o(B),P=a(B,"DIV",{class:!0});var Nt=j(P);f(ye.$$.fragment,Nt),_n=o(Nt),Oe=a(Nt,"P",{"data-svelte-h":!0}),d(Oe)!=="svelte-1y8m4uy"&&(Oe.textContent=yo),Nt.forEach(i),bn=o(B),O=a(B,"DIV",{class:!0});var Lt=j(O);f(Me.$$.fragment,Lt),yn=o(Lt),Ke=a(Lt,"P",{"data-svelte-h":!0}),d(Ke)!=="svelte-1ww3wqq"&&(Ke.textContent=Mo),Lt.forEach(i),Mn=o(B),K=a(B,"DIV",{class:!0});var Dt=j(K);f(we.$$.fragment,Dt),wn=o(Dt),et=a(Dt,"P",{"data-svelte-h":!0}),d(et)!=="svelte-1g70y32"&&(et.textContent=wo),Dt.forEach(i),vn=o(B),ee=a(B,"DIV",{class:!0});var Et=j(ee);f(ve.$$.fragment,Et),xn=o(Et),tt=a(Et,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-1nsuc3n"&&(tt.textContent=vo),Et.forEach(i),Tn=o(B),te=a(B,"DIV",{class:!0});var St=j(te);f(xe.$$.fragment,St),jn=o(St),nt=a(St,"P",{"data-svelte-h":!0}),d(nt)!=="svelte-83t3pb"&&(nt.textContent=xo),St.forEach(i),B.forEach(i),$t=o(e),Te=a(e,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-1qq0u9g"&&(Te.textContent=To),Zt=o(e),C=a(e,"DIV",{class:!0});var I=j(C);f(je.$$.fragment,I),kn=o(I),ot=a(I,"P",{"data-svelte-h":!0}),d(ot)!=="svelte-qs7ncz"&&(ot.innerHTML=jo),Gn=o(I),st=a(I,"P",{"data-svelte-h":!0}),d(st)!=="svelte-1gsnqo2"&&(st.innerHTML=ko),Jn=o(I),at=a(I,"UL",{"data-svelte-h":!0}),d(at)!=="svelte-1655ho"&&(at.innerHTML=Go),Cn=o(I),rt=a(I,"P",{"data-svelte-h":!0}),d(rt)!=="svelte-1gtazd5"&&(rt.innerHTML=Jo),Un=o(I),X=a(I,"DIV",{class:!0});var Mt=j(X);f(ke.$$.fragment,Mt),Bn=o(Mt),it=a(Mt,"P",{"data-svelte-h":!0}),d(it)!=="svelte-s5ko3x"&&(it.textContent=Co),$n=o(Mt),f(ne.$$.fragment,Mt),Mt.forEach(i),Zn=o(I),R=a(I,"DIV",{class:!0});var wt=j(R);f(Ge.$$.fragment,wt),In=o(wt),lt=a(wt,"P",{"data-svelte-h":!0}),d(lt)!=="svelte-1om47tb"&&(lt.textContent=Uo),Wn=o(wt),f(oe.$$.fragment,wt),wt.forEach(i),I.forEach(i),It=o(e),Je=a(e,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-11o0eqc"&&(Je.textContent=Bo),Wt=o(e),U=a(e,"DIV",{class:!0});var W=j(U);f(Ce.$$.fragment,W),Vn=o(W),ct=a(W,"P",{"data-svelte-h":!0}),d(ct)!=="svelte-1mof5qh"&&(ct.innerHTML=$o),zn=o(W),dt=a(W,"P",{"data-svelte-h":!0}),d(dt)!=="svelte-119kkpw"&&(dt.innerHTML=Zo),Hn=o(W),mt=a(W,"UL",{"data-svelte-h":!0}),d(mt)!=="svelte-fx738d"&&(mt.innerHTML=Io),Xn=o(W),pt=a(W,"P",{"data-svelte-h":!0}),d(pt)!=="svelte-13kczdy"&&(pt.innerHTML=Wo),Rn=o(W),F=a(W,"DIV",{class:!0});var vt=j(F);f(Ue.$$.fragment,vt),Fn=o(vt),gt=a(vt,"P",{"data-svelte-h":!0}),d(gt)!=="svelte-s5ko3x"&&(gt.textContent=Vo),Nn=o(vt),f(se.$$.fragment,vt),vt.forEach(i),Ln=o(W),N=a(W,"DIV",{class:!0});var xt=j(N);f(Be.$$.fragment,xt),Dn=o(xt),ut=a(xt,"P",{"data-svelte-h":!0}),d(ut)!=="svelte-1om47tb"&&(ut.textContent=zo),En=o(xt),f(ae.$$.fragment,xt),xt.forEach(i),W.forEach(i),Vt=o(e),$e=a(e,"P",{"data-svelte-h":!0}),d($e)!=="svelte-1s7w8l8"&&($e.textContent=Ho),zt=o(e),$=a(e,"DIV",{class:!0});var V=j($);f(Ze.$$.fragment,V),Sn=o(V),ft=a(V,"P",{"data-svelte-h":!0}),d(ft)!=="svelte-1k5xa4p"&&(ft.innerHTML=Xo),qn=o(V),ht=a(V,"P",{"data-svelte-h":!0}),d(ht)!=="svelte-x4flff"&&(ht.innerHTML=Ro),Yn=o(V),_t=a(V,"UL",{"data-svelte-h":!0}),d(_t)!=="svelte-ffjx8e"&&(_t.innerHTML=Fo),Qn=o(V),bt=a(V,"P",{"data-svelte-h":!0}),d(bt)!=="svelte-13kczdy"&&(bt.innerHTML=No),An=o(V),re=a(V,"DIV",{class:!0});var qt=j(re);f(Ie.$$.fragment,qt),Pn=o(qt),yt=a(qt,"P",{"data-svelte-h":!0}),d(yt)!=="svelte-s5ko3x"&&(yt.textContent=Lo),qt.forEach(i),V.forEach(i),Ht=o(e),f(We.$$.fragment,e),Xt=o(e),jt=a(e,"P",{}),j(jt).forEach(i),this.h()},h(){k(l,"name","hf:doc:metadata"),k(l,"content",ss),k(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,c){t(document.head,l),p(e,G,c),p(e,g,c),p(e,m,c),h(M,e,c),p(e,r,c),p(e,w,c),p(e,kt,c),p(e,ie,c),p(e,Gt,c),p(e,le,c),p(e,Jt,c),p(e,ce,c),p(e,Ct,c),h(de,e,c),p(e,Ut,c),p(e,v,c),h(me,v,null),t(v,Yt),t(v,Xe),t(v,Qt),t(v,Re),t(v,At),t(v,Fe),t(v,Pt),h(E,v,null),t(v,Ot),t(v,z),h(pe,z,null),t(z,Kt),t(z,Ne),t(z,en),h(S,z,null),t(v,tn),t(v,q),h(ge,q,null),t(q,nn),t(q,Le),t(v,on),t(v,Y),h(ue,Y,null),t(Y,sn),t(Y,De),t(v,an),t(v,Q),h(fe,Q,null),t(Q,rn),t(Q,Ee),t(v,ln),t(v,H),h(he,H,null),t(H,cn),t(H,Se),t(H,dn),t(H,qe),t(v,mn),t(v,A),h(_e,A,null),t(A,pn),t(A,Ye),p(e,Bt,c),p(e,T,c),h(be,T,null),t(T,gn),t(T,Qe),t(T,un),t(T,Ae),t(T,fn),t(T,Pe),t(T,hn),t(T,P),h(ye,P,null),t(P,_n),t(P,Oe),t(T,bn),t(T,O),h(Me,O,null),t(O,yn),t(O,Ke),t(T,Mn),t(T,K),h(we,K,null),t(K,wn),t(K,et),t(T,vn),t(T,ee),h(ve,ee,null),t(ee,xn),t(ee,tt),t(T,Tn),t(T,te),h(xe,te,null),t(te,jn),t(te,nt),p(e,$t,c),p(e,Te,c),p(e,Zt,c),p(e,C,c),h(je,C,null),t(C,kn),t(C,ot),t(C,Gn),t(C,st),t(C,Jn),t(C,at),t(C,Cn),t(C,rt),t(C,Un),t(C,X),h(ke,X,null),t(X,Bn),t(X,it),t(X,$n),h(ne,X,null),t(C,Zn),t(C,R),h(Ge,R,null),t(R,In),t(R,lt),t(R,Wn),h(oe,R,null),p(e,It,c),p(e,Je,c),p(e,Wt,c),p(e,U,c),h(Ce,U,null),t(U,Vn),t(U,ct),t(U,zn),t(U,dt),t(U,Hn),t(U,mt),t(U,Xn),t(U,pt),t(U,Rn),t(U,F),h(Ue,F,null),t(F,Fn),t(F,gt),t(F,Nn),h(se,F,null),t(U,Ln),t(U,N),h(Be,N,null),t(N,Dn),t(N,ut),t(N,En),h(ae,N,null),p(e,Vt,c),p(e,$e,c),p(e,zt,c),p(e,$,c),h(Ze,$,null),t($,Sn),t($,ft),t($,qn),t($,ht),t($,Yn),t($,_t),t($,Qn),t($,bt),t($,An),t($,re),h(Ie,re,null),t(re,Pn),t(re,yt),p(e,Ht,c),h(We,e,c),p(e,Xt,c),p(e,jt,c),Rt=!0},p(e,[c]){const x={};c&2&&(x.$$scope={dirty:c,ctx:e}),E.$set(x);const L={};c&2&&(L.$$scope={dirty:c,ctx:e}),S.$set(L);const Ve={};c&2&&(Ve.$$scope={dirty:c,ctx:e}),ne.$set(Ve);const ze={};c&2&&(ze.$$scope={dirty:c,ctx:e}),oe.$set(ze);const He={};c&2&&(He.$$scope={dirty:c,ctx:e}),se.$set(He);const D={};c&2&&(D.$$scope={dirty:c,ctx:e}),ae.$set(D)},i(e){Rt||(_(M.$$.fragment,e),_(de.$$.fragment,e),_(me.$$.fragment,e),_(E.$$.fragment,e),_(pe.$$.fragment,e),_(S.$$.fragment,e),_(ge.$$.fragment,e),_(ue.$$.fragment,e),_(fe.$$.fragment,e),_(he.$$.fragment,e),_(_e.$$.fragment,e),_(be.$$.fragment,e),_(ye.$$.fragment,e),_(Me.$$.fragment,e),_(we.$$.fragment,e),_(ve.$$.fragment,e),_(xe.$$.fragment,e),_(je.$$.fragment,e),_(ke.$$.fragment,e),_(ne.$$.fragment,e),_(Ge.$$.fragment,e),_(oe.$$.fragment,e),_(Ce.$$.fragment,e),_(Ue.$$.fragment,e),_(se.$$.fragment,e),_(Be.$$.fragment,e),_(ae.$$.fragment,e),_(Ze.$$.fragment,e),_(Ie.$$.fragment,e),_(We.$$.fragment,e),Rt=!0)},o(e){b(M.$$.fragment,e),b(de.$$.fragment,e),b(me.$$.fragment,e),b(E.$$.fragment,e),b(pe.$$.fragment,e),b(S.$$.fragment,e),b(ge.$$.fragment,e),b(ue.$$.fragment,e),b(fe.$$.fragment,e),b(he.$$.fragment,e),b(_e.$$.fragment,e),b(be.$$.fragment,e),b(ye.$$.fragment,e),b(Me.$$.fragment,e),b(we.$$.fragment,e),b(ve.$$.fragment,e),b(xe.$$.fragment,e),b(je.$$.fragment,e),b(ke.$$.fragment,e),b(ne.$$.fragment,e),b(Ge.$$.fragment,e),b(oe.$$.fragment,e),b(Ce.$$.fragment,e),b(Ue.$$.fragment,e),b(se.$$.fragment,e),b(Be.$$.fragment,e),b(ae.$$.fragment,e),b(Ze.$$.fragment,e),b(Ie.$$.fragment,e),b(We.$$.fragment,e),Rt=!1},d(e){e&&(i(G),i(g),i(m),i(r),i(w),i(kt),i(ie),i(Gt),i(le),i(Jt),i(ce),i(Ct),i(Ut),i(v),i(Bt),i(T),i($t),i(Te),i(Zt),i(C),i(It),i(Je),i(Wt),i(U),i(Vt),i($e),i(zt),i($),i(Ht),i(Xt),i(jt)),i(l),y(M,e),y(de,e),y(me),y(E),y(pe),y(S),y(ge),y(ue),y(fe),y(he),y(_e),y(be),y(ye),y(Me),y(we),y(ve),y(xe),y(je),y(ke),y(ne),y(Ge),y(oe),y(Ce),y(Ue),y(se),y(Be),y(ae),y(Ze),y(Ie),y(We,e)}}}const ss='{"title":"Generation","local":"generation","sections":[{"title":"GenerationConfig","local":"transformers.GenerationConfig","sections":[],"depth":2}],"depth":1}';function as(Z){return So(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class gs extends qo{constructor(l){super(),Yo(this,l,as,os,Eo,{})}}export{gs as component};
