import{s as Be,o as Ge,n as gt}from"../chunks/scheduler.f6b352c8.js";import{S as ke,i as Le,g as y,s as p,r as f,A as _e,h as w,f as s,c as m,j as xe,u as d,x as U,k as Ce,y as We,a as n,v as h,d as u,t as $,w as g}from"../chunks/index.f94652f1.js";import{T as Re}from"../chunks/Tip.5f71ca1c.js";import{C as Mt}from"../chunks/CodeBlock.96e788b8.js";import{Q as x}from"../chunks/Question.8cb1d448.js";import{H as v,E as Ze}from"../chunks/getInferenceSnippets.8d17d7e7.js";import{H as Ie,a as wt}from"../chunks/HfOption.7a25f9de.js";function Ee(J){let o,M="<strong>Temporal Windows Explained:</strong>",c,l,r="<li><strong>Observation history</strong>: <code>[-0.2, -0.1, 0.0]</code> gives you 200ms, 100ms, and current observations</li> <li><strong>Action sequences</strong>: <code>[0.0, 0.1, 0.2]</code> provides current and next 2 actions (100ms apart)</li> <li><strong>Automatic padding</strong>: Missing frames at episode boundaries are handled automatically</li> <li><strong>Mask included</strong>: Know which frames are real vs. padded for proper training</li>",a,i,T="This is crucial for robot learning where decisions depend on recent history!";return{c(){o=y("p"),o.innerHTML=M,c=p(),l=y("ul"),l.innerHTML=r,a=p(),i=y("p"),i.textContent=T},l(b){o=w(b,"P",{"data-svelte-h":!0}),U(o)!=="svelte-hav3co"&&(o.innerHTML=M),c=m(b),l=w(b,"UL",{"data-svelte-h":!0}),U(l)!=="svelte-joa1a8"&&(l.innerHTML=r),a=m(b),i=w(b,"P",{"data-svelte-h":!0}),U(i)!=="svelte-dxtug3"&&(i.textContent=T)},m(b,j){n(b,o,j),n(b,c,j),n(b,l,j),n(b,a,j),n(b,i,j)},p:gt,d(b){b&&(s(o),s(c),s(l),s(a),s(i))}}}function Se(J){let o,M="<strong>Basic Behavioral Cloning</strong> (learn current action from current observation):",c,l,r;return l=new Mt({props:{code:"JTIzJTIwU2ltcGxlJTNBJTIwY3VycmVudCUyMG9ic2VydmF0aW9uJTIwJUUyJTg2JTkyJTIwY3VycmVudCUyMGFjdGlvbiUwQWRlbHRhX3RpbWVzdGFtcHMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJvYnNlcnZhdGlvbi5pbWFnZXMud3Jpc3RfY2FtZXJhJTIyJTNBJTIwJTVCMC4wJTVEJTJDJTIwJTIwJTIzJTIwSnVzdCUyMGN1cnJlbnQlMjBmcmFtZSUwQSUyMCUyMCUyMCUyMCUyMmFjdGlvbiUyMiUzQSUyMCU1QjAuMCU1RCUyMCUyMCUyMyUyMEp1c3QlMjBjdXJyZW50JTIwYWN0aW9uJTBBJTdEJTBBJTBBZGF0YXNldCUyMCUzRCUyMExlUm9ib3REYXRhc2V0KCUwQSUyMCUyMCUyMCUyMCUyMmxlcm9ib3QlMkZzdmxhX3NvMTAxX3BpY2twbGFjZSUyMiUyQyUyMCUwQSUyMCUyMCUyMCUyMGRlbHRhX3RpbWVzdGFtcHMlM0RkZWx0YV90aW1lc3RhbXBzJTBBKQ==",highlighted:`<span class="hljs-comment"># Simple: current observation → current action</span>
delta_timestamps = {
    <span class="hljs-string">&quot;observation.images.wrist_camera&quot;</span>: [<span class="hljs-number">0.0</span>],  <span class="hljs-comment"># Just current frame</span>
    <span class="hljs-string">&quot;action&quot;</span>: [<span class="hljs-number">0.0</span>]  <span class="hljs-comment"># Just current action</span>
}

dataset = LeRobotDataset(
    <span class="hljs-string">&quot;lerobot/svla_so101_pickplace&quot;</span>, 
    delta_timestamps=delta_timestamps
)`,wrap:!1}}),{c(){o=y("p"),o.innerHTML=M,c=p(),f(l.$$.fragment)},l(a){o=w(a,"P",{"data-svelte-h":!0}),U(o)!=="svelte-1fjvi9j"&&(o.innerHTML=M),c=m(a),d(l.$$.fragment,a)},m(a,i){n(a,o,i),n(a,c,i),h(l,a,i),r=!0},p:gt,i(a){r||(u(l.$$.fragment,a),r=!0)},o(a){$(l.$$.fragment,a),r=!1},d(a){a&&(s(o),s(c)),g(l,a)}}}function Xe(J){let o,M="<strong>History-Based BC</strong> (use observation history for better decisions):",c,l,r;return l=new Mt({props:{code:"JTIzJTIwVXNlJTIwb2JzZXJ2YXRpb24lMjBoaXN0b3J5JTIwZm9yJTIwY29udGV4dCUwQWRlbHRhX3RpbWVzdGFtcHMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJvYnNlcnZhdGlvbi5pbWFnZXMud3Jpc3RfY2FtZXJhJTIyJTNBJTIwJTVCLTAuMiUyQyUyMC0wLjElMkMlMjAwLjAlNUQlMkMlMjAlMjAlMjMlMjAyMDBtcyUyMGhpc3RvcnklMEElMjAlMjAlMjAlMjAlMjJhY3Rpb24lMjIlM0ElMjAlNUIwLjAlNUQlMjAlMjAlMjMlMjBDdXJyZW50JTIwYWN0aW9uJTBBJTdEJTBBJTBBZGF0YXNldCUyMCUzRCUyMExlUm9ib3REYXRhc2V0KCUwQSUyMCUyMCUyMCUyMCUyMmxlcm9ib3QlMkZzdmxhX3NvMTAxX3BpY2twbGFjZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGRlbHRhX3RpbWVzdGFtcHMlM0RkZWx0YV90aW1lc3RhbXBzJTBBKSUwQSUwQXNhbXBsZSUyMCUzRCUyMGRhdGFzZXQlNUIxMDAlNUQlMEElMjMlMjBJbWFnZXMlMjBzaGFwZSUzQSUyMCU1QjMlMkMlMjBDJTJDJTIwSCUyQyUyMFclNUQlMjAtJTIwMyUyMGhpc3RvcmljYWwlMjBmcmFtZXMlMEElMjMlMjBBY3Rpb24lMjBzaGFwZSUzQSUyMCU1QmFjdGlvbl9kaW0lNUQlMjAtJTIwc2luZ2xlJTIwY3VycmVudCUyMGFjdGlvbg==",highlighted:`<span class="hljs-comment"># Use observation history for context</span>
delta_timestamps = {
    <span class="hljs-string">&quot;observation.images.wrist_camera&quot;</span>: [-<span class="hljs-number">0.2</span>, -<span class="hljs-number">0.1</span>, <span class="hljs-number">0.0</span>],  <span class="hljs-comment"># 200ms history</span>
    <span class="hljs-string">&quot;action&quot;</span>: [<span class="hljs-number">0.0</span>]  <span class="hljs-comment"># Current action</span>
}

dataset = LeRobotDataset(
    <span class="hljs-string">&quot;lerobot/svla_so101_pickplace&quot;</span>,
    delta_timestamps=delta_timestamps
)

sample = dataset[<span class="hljs-number">100</span>]
<span class="hljs-comment"># Images shape: [3, C, H, W] - 3 historical frames</span>
<span class="hljs-comment"># Action shape: [action_dim] - single current action</span>`,wrap:!1}}),{c(){o=y("p"),o.innerHTML=M,c=p(),f(l.$$.fragment)},l(a){o=w(a,"P",{"data-svelte-h":!0}),U(o)!=="svelte-1vzsa0u"&&(o.innerHTML=M),c=m(a),d(l.$$.fragment,a)},m(a,i){n(a,o,i),n(a,c,i),h(l,a,i),r=!0},p:gt,i(a){r||(u(l.$$.fragment,a),r=!0)},o(a){$(l.$$.fragment,a),r=!1},d(a){a&&(s(o),s(c)),g(l,a)}}}function Ye(J){let o,M="<strong>Action Chunking</strong> (predict action sequences for smoother control):",c,l,r;return l=new Mt({props:{code:"JTIzJTIwUHJlZGljdCUyMG11bHRpcGxlJTIwZnV0dXJlJTIwYWN0aW9ucyUyMGF0JTIwb25jZSUwQWRlbHRhX3RpbWVzdGFtcHMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJvYnNlcnZhdGlvbi5pbWFnZXMud3Jpc3RfY2FtZXJhJTIyJTNBJTIwJTVCLTAuMSUyQyUyMDAuMCU1RCUyQyUyMCUyMCUyMyUyMFJlY2VudCUyMCUyQiUyMGN1cnJlbnQlMEElMjAlMjAlMjAlMjAlMjJhY3Rpb24lMjIlM0ElMjAlNUIwLjAlMkMlMjAwLjElMkMlMjAwLjIlMkMlMjAwLjMlNUQlMjAlMjAlMjMlMjBDdXJyZW50JTIwJTJCJTIwMyUyMGZ1dHVyZSUyMGFjdGlvbnMlMEElN0QlMEElMEFkYXRhc2V0JTIwJTNEJTIwTGVSb2JvdERhdGFzZXQoJTBBJTIwJTIwJTIwJTIwJTIybGVyb2JvdCUyRnN2bGFfc28xMDFfcGlja3BsYWNlJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGVsdGFfdGltZXN0YW1wcyUzRGRlbHRhX3RpbWVzdGFtcHMlMEEpJTBBJTBBc2FtcGxlJTIwJTNEJTIwZGF0YXNldCU1QjEwMCU1RCUyMCUwQSUyMyUyMEltYWdlcyUyMHNoYXBlJTNBJTIwJTVCMiUyQyUyMEMlMkMlMjBIJTJDJTIwVyU1RCUyMC0lMjAyJTIwb2JzZXJ2YXRpb24lMjBmcmFtZXMlMEElMjMlMjBBY3Rpb24lMjBzaGFwZSUzQSUyMCU1QjQlMkMlMjBhY3Rpb25fZGltJTVEJTIwLSUyMDQlMjBhY3Rpb24lMjBwcmVkaWN0aW9ucw==",highlighted:`<span class="hljs-comment"># Predict multiple future actions at once</span>
delta_timestamps = {
    <span class="hljs-string">&quot;observation.images.wrist_camera&quot;</span>: [-<span class="hljs-number">0.1</span>, <span class="hljs-number">0.0</span>],  <span class="hljs-comment"># Recent + current</span>
    <span class="hljs-string">&quot;action&quot;</span>: [<span class="hljs-number">0.0</span>, <span class="hljs-number">0.1</span>, <span class="hljs-number">0.2</span>, <span class="hljs-number">0.3</span>]  <span class="hljs-comment"># Current + 3 future actions</span>
}

dataset = LeRobotDataset(
    <span class="hljs-string">&quot;lerobot/svla_so101_pickplace&quot;</span>,
    delta_timestamps=delta_timestamps
)

sample = dataset[<span class="hljs-number">100</span>] 
<span class="hljs-comment"># Images shape: [2, C, H, W] - 2 observation frames</span>
<span class="hljs-comment"># Action shape: [4, action_dim] - 4 action predictions</span>`,wrap:!1}}),{c(){o=y("p"),o.innerHTML=M,c=p(),f(l.$$.fragment)},l(a){o=w(a,"P",{"data-svelte-h":!0}),U(o)!=="svelte-euuptz"&&(o.innerHTML=M),c=m(a),d(l.$$.fragment,a)},m(a,i){n(a,o,i),n(a,c,i),h(l,a,i),r=!0},p:gt,i(a){r||(u(l.$$.fragment,a),r=!0)},o(a){$(l.$$.fragment,a),r=!1},d(a){a&&(s(o),s(c)),g(l,a)}}}function Ne(J){let o,M,c,l,r,a;return o=new wt({props:{id:"temporal-windows",option:"basic-bc",$$slots:{default:[Se]},$$scope:{ctx:J}}}),c=new wt({props:{id:"temporal-windows",option:"history-bc",$$slots:{default:[Xe]},$$scope:{ctx:J}}}),r=new wt({props:{id:"temporal-windows",option:"action-chunking",$$slots:{default:[Ye]},$$scope:{ctx:J}}}),{c(){f(o.$$.fragment),M=p(),f(c.$$.fragment),l=p(),f(r.$$.fragment)},l(i){d(o.$$.fragment,i),M=m(i),d(c.$$.fragment,i),l=m(i),d(r.$$.fragment,i)},m(i,T){h(o,i,T),n(i,M,T),h(c,i,T),n(i,l,T),h(r,i,T),a=!0},p(i,T){const b={};T&2&&(b.$$scope={dirty:T,ctx:i}),o.$set(b);const j={};T&2&&(j.$$scope={dirty:T,ctx:i}),c.$set(j);const bt={};T&2&&(bt.$$scope={dirty:T,ctx:i}),r.$set(bt)},i(i){a||(u(o.$$.fragment,i),u(c.$$.fragment,i),u(r.$$.fragment,i),a=!0)},o(i){$(o.$$.fragment,i),$(c.$$.fragment,i),$(r.$$.fragment,i),a=!1},d(i){i&&(s(M),s(l)),g(o,i),g(c,i),g(r,i)}}}function Fe(J){let o,M="<strong>When to use streaming:</strong>",c,l,r="<li><strong>Dataset &gt; available storage</strong> - Stream datasets that don’t fit on your disk</li> <li><strong>Experimentation</strong> - Quickly try different datasets without downloading</li> <li><strong>Cloud training</strong> - Reduce startup time by streaming from Hugging Face Hub</li> <li><strong>Network available</strong> - Requires stable internet connection during training</li>",a,i,T="<strong>Performance:</strong> Streaming achieves 80-100 it/s with good connectivity!";return{c(){o=y("p"),o.innerHTML=M,c=p(),l=y("ul"),l.innerHTML=r,a=p(),i=y("p"),i.innerHTML=T},l(b){o=w(b,"P",{"data-svelte-h":!0}),U(o)!=="svelte-b5rbi5"&&(o.innerHTML=M),c=m(b),l=w(b,"UL",{"data-svelte-h":!0}),U(l)!=="svelte-2l60eu"&&(l.innerHTML=r),a=m(b),i=w(b,"P",{"data-svelte-h":!0}),U(i)!=="svelte-w3pth7"&&(i.innerHTML=T)},m(b,j){n(b,o,j),n(b,c,j),n(b,l,j),n(b,a,j),n(b,i,j)},p:gt,d(b){b&&(s(o),s(c),s(l),s(a),s(i))}}}function Qe(J){let o,M="<strong>Download Dataset</strong> (faster training, requires storage):",c,l,r;return l=new Mt({props:{code:"ZnJvbSUyMGxlcm9ib3QuZGF0YXNldHMubGVyb2JvdF9kYXRhc2V0JTIwaW1wb3J0JTIwTGVSb2JvdERhdGFzZXQlMEElMEElMjMlMjBEb3dubG9hZHMlMjBkYXRhc2V0JTIwdG8lMjBsb2NhbCUyMGNhY2hlJTBBZGF0YXNldCUyMCUzRCUyMExlUm9ib3REYXRhc2V0KCUyMmxlcm9ib3QlMkZzdmxhX3NvMTAxX3BpY2twbGFjZSUyMiklMEElMEElMjMlMjBGYXN0ZXN0JTIwYWNjZXNzJTIwYWZ0ZXIlMjBkb3dubG9hZCUwQXNhbXBsZSUyMCUzRCUyMGRhdGFzZXQlNUIxMDAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> lerobot.datasets.lerobot_dataset <span class="hljs-keyword">import</span> LeRobotDataset

<span class="hljs-comment"># Downloads dataset to local cache</span>
dataset = LeRobotDataset(<span class="hljs-string">&quot;lerobot/svla_so101_pickplace&quot;</span>)

<span class="hljs-comment"># Fastest access after download</span>
sample = dataset[<span class="hljs-number">100</span>]`,wrap:!1}}),{c(){o=y("p"),o.innerHTML=M,c=p(),f(l.$$.fragment)},l(a){o=w(a,"P",{"data-svelte-h":!0}),U(o)!=="svelte-15sgzp4"&&(o.innerHTML=M),c=m(a),d(l.$$.fragment,a)},m(a,i){n(a,o,i),n(a,c,i),h(l,a,i),r=!0},p:gt,i(a){r||(u(l.$$.fragment,a),r=!0)},o(a){$(l.$$.fragment,a),r=!1},d(a){a&&(s(o),s(c)),g(l,a)}}}function He(J){let o,M="<strong>Stream Dataset</strong> (no storage needed, requires internet):",c,l,r;return l=new Mt({props:{code:"ZnJvbSUyMGxlcm9ib3QuZGF0YXNldHMuc3RyZWFtaW5nX2RhdGFzZXQlMjBpbXBvcnQlMjBTdHJlYW1pbmdMZVJvYm90RGF0YXNldCUwQSUwQSUyMyUyMFN0cmVhbSUyMGRhdGElMjB3aXRob3V0JTIwZG93bmxvYWRpbmclMEFzdHJlYW1pbmdfZGF0YXNldCUyMCUzRCUyMFN0cmVhbWluZ0xlUm9ib3REYXRhc2V0KCUwQSUyMCUyMCUyMCUyMCUyMmxlcm9ib3QlMkZzdmxhX3NvMTAxX3BpY2twbGFjZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGRlbHRhX3RpbWVzdGFtcHMlM0RkZWx0YV90aW1lc3RhbXBzJTBBKSUwQSUwQSUyMyUyMFdvcmtzJTIwZXhhY3RseSUyMGxpa2UlMjByZWd1bGFyJTIwZGF0YXNldCUwQXNhbXBsZSUyMCUzRCUyMHN0cmVhbWluZ19kYXRhc2V0JTVCMTAwJTVE",highlighted:`<span class="hljs-keyword">from</span> lerobot.datasets.streaming_dataset <span class="hljs-keyword">import</span> StreamingLeRobotDataset

<span class="hljs-comment"># Stream data without downloading</span>
streaming_dataset = StreamingLeRobotDataset(
    <span class="hljs-string">&quot;lerobot/svla_so101_pickplace&quot;</span>,
    delta_timestamps=delta_timestamps
)

<span class="hljs-comment"># Works exactly like regular dataset</span>
sample = streaming_dataset[<span class="hljs-number">100</span>]`,wrap:!1}}),{c(){o=y("p"),o.innerHTML=M,c=p(),f(l.$$.fragment)},l(a){o=w(a,"P",{"data-svelte-h":!0}),U(o)!=="svelte-yrm5vi"&&(o.innerHTML=M),c=m(a),d(l.$$.fragment,a)},m(a,i){n(a,o,i),n(a,c,i),h(l,a,i),r=!0},p:gt,i(a){r||(u(l.$$.fragment,a),r=!0)},o(a){$(l.$$.fragment,a),r=!1},d(a){a&&(s(o),s(c)),g(l,a)}}}function Ae(J){let o,M,c,l;return o=new wt({props:{id:"dataset-loading",option:"download",$$slots:{default:[Qe]},$$scope:{ctx:J}}}),c=new wt({props:{id:"dataset-loading",option:"streaming",$$slots:{default:[He]},$$scope:{ctx:J}}}),{c(){f(o.$$.fragment),M=p(),f(c.$$.fragment)},l(r){d(o.$$.fragment,r),M=m(r),d(c.$$.fragment,r)},m(r,a){h(o,r,a),n(r,M,a),h(c,r,a),l=!0},p(r,a){const i={};a&2&&(i.$$scope={dirty:a,ctx:r}),o.$set(i);const T={};a&2&&(T.$$scope={dirty:a,ctx:r}),c.$set(T)},i(r){l||(u(o.$$.fragment,r),u(c.$$.fragment,r),l=!0)},o(r){$(o.$$.fragment,r),$(c.$$.fragment,r),l=!1},d(r){r&&s(M),g(o,r),g(c,r)}}}function ze(J){let o,M,c,l,r,a,i,T="This section shows how to access datasets hosted on Hugging Face using the LeRobotDataset class. We’ll start small and build up, so you can copy–paste the pattern that fits your use case.",b,j,bt="First, any dataset on the Hub that follows the three pillars (tabular, visual, relational metadata) can be accessed with a single instruction.",Tt,G,de="Why windows? Most reinforcement learning (RL) and behavioral cloning (BC) algorithms operate on stacks of observations and actions. For brevity, we refer to joint states and camera frames collectively as a single “frame.” For example, RL often uses a history of observations $o<em>{t-H_o:t}$ to mitigate partial observability, and BC typically regresses chunks of multiple actions ($a</em>{t:t+H_a}$) rather than single controls.",Ut,k,he="To support these training patterns, LeRobotDataset provides native temporal windowing. You define the time offsets (before/after) around any frame using <code>delta_timestamps</code>. Unavailable frames are padded and a mask is returned to filter padded elements. This all happens inside LeRobotDataset and is transparent to higher‑level wrappers like <code>torch.utils.data.DataLoader</code>.",jt,C,Jt,L,ue="Conveniently, by using LeRobotDataset with a PyTorch <code>DataLoader</code> one can automatically collate the individual sample dictionaries from the dataset into a single dictionary of batched tensors for downstream training or inference. LeRobotDataset also natively supports streaming mode for datasets. Users can stream data of a large dataset hosted on the Hugging Face Hub, with a one-line change in their implementation. Streaming datasets supports high-performance batch processing (ca. 80-100 it/s, varying on connectivity) and high levels of frames randomization, key features for practical BC algorithms which otherwise may be slow or operating on highly non-i.i.d. data. This feature is designed to improve on accessibility so that large datasets can be processed by users without requiring large amounts of memory and storage.",vt,_,$e="Here are different ways to set up temporal windows depending on your use case. Skim the options and pick one to start—switching later is just a change to the dictionary.",xt,R,Ct,W,Rt,I,It,B,Bt,Z,Gt,E,kt,S,Lt,X,_t,Y,ge="This simple API hides significant complexity:",Wt,N,Me="<li>✅ <strong>Multi-modal synchronization</strong> - Images and sensors perfectly aligned</li> <li>✅ <strong>Efficient storage</strong> - Compressed videos, memory-mapped arrays</li> <li>✅ <strong>Temporal handling</strong> - Easy access to observation/action sequences</li> <li>✅ <strong>Scalability</strong> - Same code works for small and massive datasets</li>",Zt,F,be="Compare this to traditional robotics data handling, which often requires:",Et,Q,ye="<li>Custom parsers for each data format</li> <li>Manual synchronization across modalities</li> <li>Complex buffering for temporal windows</li> <li>Platform-specific loading code</li>",St,H,we="LeRobotDataset <strong>standardizes and simplifies</strong> all of this!",Xt,A,Yt,z,Te="Test your understanding of LeRobot and its role in robot learning:",Nt,V,Ft,D,Qt,q,Ht,P,At,K,zt,O,Vt,tt,Dt,et,qt,at,Pt,st,Kt,nt,Ot,ot,te,it,ee,lt,ae,rt,se,pt,ne,mt,oe,ct,ie,ft,le,dt,re,ht,pe,ut,me,$t,ce,yt,fe;return r=new v({props:{title:"Code Example: Batching a (Streaming) Dataset",local:"code-example-batching-a-streaming-dataset",headingTag:"h1"}}),C=new Re({props:{$$slots:{default:[Ee]},$$scope:{ctx:J}}}),R=new Ie({props:{id:"temporal-windows",options:["basic-bc","history-bc","action-chunking"],$$slots:{default:[Ne]},$$scope:{ctx:J}}}),W=new v({props:{title:"Streaming Large Datasets",local:"streaming-large-datasets",headingTag:"h3"}}),I=new Re({props:{$$slots:{default:[Fe]},$$scope:{ctx:J}}}),B=new Ie({props:{id:"dataset-loading",options:["download","streaming"],$$slots:{default:[Ae]},$$scope:{ctx:J}}}),Z=new v({props:{title:"Training Integration",local:"training-integration",headingTag:"h2"}}),E=new v({props:{title:"PyTorch DataLoader",local:"pytorch-dataloader",headingTag:"h3"}}),S=new Mt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdG9yY2gudXRpbHMuZGF0YSUyMGltcG9ydCUyMERhdGFMb2FkZXIlMEElMEElMjMlMjBDcmVhdGUlMjBEYXRhTG9hZGVyJTIwZm9yJTIwdHJhaW5pbmclMEFkYXRhbG9hZGVyJTIwJTNEJTIwRGF0YUxvYWRlciglMEElMjAlMjAlMjAlMjBkYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwYmF0Y2hfc2l6ZSUzRDE2JTJDJTBBJTIwJTIwJTIwJTIwc2h1ZmZsZSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBudW1fd29ya2VycyUzRDQlMEEpJTBBJTBBJTIzJTIwVHJhaW5pbmclMjBsb29wJTBBZGV2aWNlJTIwJTNEJTIwdG9yY2guZGV2aWNlKCUyMmN1ZGElMjIlMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwJTIyY3B1JTIyKSUwQSUwQWZvciUyMGJhdGNoJTIwaW4lMjBkYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwTW92ZSUyMHRvJTIwZGV2aWNlJTBBJTIwJTIwJTIwJTIwb2JzZXJ2YXRpb25zJTIwJTNEJTIwYmF0Y2glNUIlMjJvYnNlcnZhdGlvbi5zdGF0ZSUyMiU1RC50byhkZXZpY2UpJTBBJTIwJTIwJTIwJTIwYWN0aW9ucyUyMCUzRCUyMGJhdGNoJTVCJTIyYWN0aW9uJTIyJTVELnRvKGRldmljZSklMEElMjAlMjAlMjAlMjBpbWFnZXMlMjAlM0QlMjBiYXRjaCU1QiUyMm9ic2VydmF0aW9uLmltYWdlcy53cmlzdF9jYW1lcmElMjIlNUQudG8oZGV2aWNlKSUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMFlvdXIlMjBtb2RlbCUyMHRyYWluaW5nJTIwaGVyZSUwQSUyMCUyMCUyMCUyMCUyMyUyMGxvc3MlMjAlM0QlMjBtb2RlbChvYnNlcnZhdGlvbnMlMkMlMjBpbWFnZXMlMkMlMjBhY3Rpb25zKSUwQSUyMCUyMCUyMCUyMCUyMyUyMGxvc3MuYmFja3dhcmQoKSUwQSUyMCUyMCUyMCUyMCUyMyUyMG9wdGltaXplci5zdGVwKCk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader

<span class="hljs-comment"># Create DataLoader for training</span>
dataloader = DataLoader(
    dataset,
    batch_size=<span class="hljs-number">16</span>,
    shuffle=<span class="hljs-literal">True</span>,
    num_workers=<span class="hljs-number">4</span>
)

<span class="hljs-comment"># Training loop</span>
device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>)

<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> dataloader:
    <span class="hljs-comment"># Move to device</span>
    observations = batch[<span class="hljs-string">&quot;observation.state&quot;</span>].to(device)
    actions = batch[<span class="hljs-string">&quot;action&quot;</span>].to(device)
    images = batch[<span class="hljs-string">&quot;observation.images.wrist_camera&quot;</span>].to(device)
    
    <span class="hljs-comment"># Your model training here</span>
    <span class="hljs-comment"># loss = model(observations, images, actions)</span>
    <span class="hljs-comment"># loss.backward()</span>
    <span class="hljs-comment"># optimizer.step()</span>`,wrap:!1}}),X=new v({props:{title:"Why This Matters",local:"why-this-matters",headingTag:"h2"}}),A=new v({props:{title:"Section Quiz",local:"section-quiz",headingTag:"h2"}}),V=new v({props:{title:"1. What makes LeRobot different from traditional robotics libraries?",local:"1-what-makes-lerobot-different-from-traditional-robotics-libraries",headingTag:"h3"}}),D=new x({props:{choices:[{text:"It only works with simulation environments.",explain:"LeRobot actually focuses on real-world robots and supports many physical platforms."},{text:"It provides end-to-end integration across the entire robotics stack with state-of-the-art learning algorithms.",explain:"LeRobot's key innovation is combining hardware control, data handling, and learning algorithms in one unified library.",correct:!0},{text:"It requires expensive industrial robots to function.",explain:"LeRobot focuses on accessible, low-cost robots to democratize robotics."},{text:"It only supports classical control methods.",explain:"LeRobot specifically focuses on learning-based approaches, not classical control."}]}}),q=new v({props:{title:"2. Which of the following is NOT a key component of LeRobot’s approach?",local:"2-which-of-the-following-is-not-a-key-component-of-lerobots-approach",headingTag:"h3"}}),P=new x({props:{choices:[{text:"Unified low-level robot configuration handling",explain:"This is indeed a key component that enables cross-platform compatibility."},{text:"Native robotics dataset format (LeRobotDataset)",explain:"LeRobotDataset is a central innovation of the library."},{text:"Requiring expert knowledge for each new robot platform",explain:"This is actually what LeRobot aims to eliminate - it reduces the expertise barrier.",correct:!0},{text:"State-of-the-art learning algorithms with PyTorch implementations",explain:"SOTA algorithms are a core feature of LeRobot."}]}}),K=new v({props:{title:"3. What is the main advantage of LeRobot’s optimized inference stack?",local:"3-what-is-the-main-advantage-of-lerobots-optimized-inference-stack",headingTag:"h3"}}),O=new x({props:{choices:[{text:"It makes training faster on GPUs.",explain:"The inference stack is about deployment, not training speed."},{text:"It reduces the memory requirements for storing datasets.",explain:"Memory reduction is handled by the dataset format, not the inference stack."},{text:"It decouples action planning from action execution for better real-time performance.",explain:"This separation is crucial for real-time robot control where millisecond delays matter.",correct:!0},{text:"It automatically generates training data from robot interactions.",explain:"Data generation is not handled by the inference stack."}]}}),tt=new v({props:{title:"4. Which types of robotic platforms does LeRobot support?",local:"4-which-types-of-robotic-platforms-does-lerobot-support",headingTag:"h3"}}),et=new x({props:{choices:[{text:"Only manipulation robots like robotic arms.",explain:"LeRobot supports much more than just manipulation platforms."},{text:"Manipulation, locomotion, and whole-body control platforms.",explain:"LeRobot supports the full spectrum of robotic platforms, from simple arms to complex humanoids.",correct:!0},{text:"Only robots that cost more than $10,000.",explain:"LeRobot focuses on accessible, low-cost platforms to democratize robotics."},{text:"Only robots manufactured by specific companies.",explain:"LeRobot supports open-source and accessible robots from various sources."}]}}),at=new v({props:{title:"5. What does “end-to-end integration with the robotics stack” mean in the context of LeRobot?",local:"5-what-does-end-to-end-integration-with-the-robotics-stack-mean-in-the-context-of-lerobot",headingTag:"h3"}}),st=new x({props:{choices:[{text:"It only handles high-level planning, not low-level control.",explain:"End-to-end means it covers everything from low-level control to high-level algorithms."},{text:"It covers everything from low-level hardware control to high-level learning algorithms.",explain:"This comprehensive coverage eliminates the need to integrate multiple separate tools.",correct:!0},{text:"It requires separate tools for data handling and model training.",explain:"End-to-end integration means you don't need separate tools - everything is unified."},{text:"It only works with specific operating systems.",explain:"Platform integration refers to robotics components, not operating systems."}]}}),nt=new v({props:{title:"6. What is the primary purpose of the delta_timestamps parameter in LeRobotDataset?",local:"6-what-is-the-primary-purpose-of-the-deltatimestamps-parameter-in-lerobotdataset",headingTag:"h3"}}),ot=new x({props:{choices:[{text:"It sets the frame rate for video recording.",explain:"Frame rates are stored in metadata, not controlled by delta_timestamps."},{text:"It defines temporal windows to access observation histories and action sequences.",explain:"delta_timestamps allows you to specify which time offsets to include, enabling access to past observations and future actions.",correct:!0},{text:"It synchronizes data across different robots.",explain:"Synchronization across robots is not handled by delta_timestamps."},{text:"It compresses video data for storage efficiency.",explain:"Video compression is handled separately in the dataset storage format."}]}}),it=new v({props:{title:"7. Which of the following best describes the three main components of LeRobotDataset?",local:"7-which-of-the-following-best-describes-the-three-main-components-of-lerobotdataset",headingTag:"h3"}}),lt=new x({props:{choices:[{text:"Images, Actions, and Rewards",explain:"While these are important data types, they don't describe the architectural components."},{text:"Tabular Data, Visual Data, and Metadata",explain:"These are the three architectural pillars: efficient storage for sensor data, compressed videos, and JSON metadata files.",correct:!0},{text:"Training, Validation, and Test sets",explain:"These are data splits, not the architectural components of the format."},{text:"Simulation, Real Robot, and Hybrid data",explain:"These describe data sources, not the storage architecture."}]}}),rt=new v({props:{title:"8. What happens when you use StreamingLeRobotDataset instead of LeRobotDataset ?",local:"8-what-happens-when-you-use-streaminglerobotdataset-instead-of-lerobotdataset-",headingTag:"h3"}}),pt=new x({props:{choices:[{text:"The data is automatically augmented for better training.",explain:"Streaming doesn't involve data augmentation - that's a separate preprocessing step."},{text:"The dataset is downloaded faster to your local machine.",explain:"Streaming actually avoids downloading the dataset entirely."},{text:"Data is streamed from the Hugging Face Hub without downloading, saving storage space.",explain:"StreamingLeRobotDataset allows you to process large datasets without downloading them locally.",correct:!0},{text:"The dataset is automatically split into train/validation sets.",explain:"Data splitting is independent of the streaming vs download choice."}]}}),mt=new v({props:{title:"9. In the context of robot learning, what does “temporal windowing” refer to?",local:"9-in-the-context-of-robot-learning-what-does-temporal-windowing-refer-to",headingTag:"h3"}}),ct=new x({props:{choices:[{text:"The time it takes to train a robot learning model.",explain:"Training time is not what temporal windowing refers to."},{text:"Accessing multiple time steps of observations and actions around a given frame.",explain:"Temporal windowing allows algorithms to use observation history and action sequences, crucial for robot learning.",correct:!0},{text:"The frequency at which robot sensors collect data.",explain:"Sensor frequency is separate from temporal windowing in datasets."},{text:"The duration of each robot episode or trajectory.",explain:"Episode duration is different from temporal windowing within episodes."}]}}),ft=new v({props:{title:"10. What is the main advantage of LeRobotDataset’s approach to storing video data?",local:"10-what-is-the-main-advantage-of-lerobotdatasets-approach-to-storing-video-data",headingTag:"h3"}}),dt=new x({props:{choices:[{text:"Videos are stored in the highest possible quality.",explain:"Quality isn't the main focus - efficiency and scalability are."},{text:"Each frame is stored as a separate file for easy access.",explain:"This would actually be inefficient - LeRobotDataset does the opposite."},{text:"Multiple episodes are concatenated into larger MP4 files to reduce file system stress.",explain:"This approach dramatically reduces the number of files, making storage more efficient for large datasets.",correct:!0},{text:"Videos are automatically compressed using AI algorithms.",explain:"Standard video compression is used, not AI-based compression."}]}}),ht=new v({props:{title:"11. Which statement about LeRobotDataset’s compatibility is correct?",local:"11-which-statement-about-lerobotdatasets-compatibility-is-correct",headingTag:"h3"}}),ut=new x({props:{choices:[{text:"It only works with specific robot brands like SO-100.",explain:"LeRobotDataset is designed to work across many different robot platforms."},{text:"It requires custom code for each new robot platform.",explain:"The unified format reduces the need for custom code per platform."},{text:"It integrates seamlessly with PyTorch DataLoader and Hugging Face ecosystems.",explain:"This integration makes it easy to use robotics data with existing ML workflows.",correct:!0},{text:"It only supports simulation data, not real robot data.",explain:"LeRobotDataset supports both simulation and real robot data."}]}}),$t=new Ze({props:{source:"https://github.com/huggingface/robotics-course/blob/main/units/en/unit1/4.mdx"}}),{c(){o=y("meta"),M=p(),c=y("p"),l=p(),f(r.$$.fragment),a=p(),i=y("p"),i.textContent=T,b=p(),j=y("p"),j.textContent=bt,Tt=p(),G=y("p"),G.innerHTML=de,Ut=p(),k=y("p"),k.innerHTML=he,jt=p(),f(C.$$.fragment),Jt=p(),L=y("p"),L.innerHTML=ue,vt=p(),_=y("p"),_.textContent=$e,xt=p(),f(R.$$.fragment),Ct=p(),f(W.$$.fragment),Rt=p(),f(I.$$.fragment),It=p(),f(B.$$.fragment),Bt=p(),f(Z.$$.fragment),Gt=p(),f(E.$$.fragment),kt=p(),f(S.$$.fragment),Lt=p(),f(X.$$.fragment),_t=p(),Y=y("p"),Y.textContent=ge,Wt=p(),N=y("ul"),N.innerHTML=Me,Zt=p(),F=y("p"),F.textContent=be,Et=p(),Q=y("ul"),Q.innerHTML=ye,St=p(),H=y("p"),H.innerHTML=we,Xt=p(),f(A.$$.fragment),Yt=p(),z=y("p"),z.textContent=Te,Nt=p(),f(V.$$.fragment),Ft=p(),f(D.$$.fragment),Qt=p(),f(q.$$.fragment),Ht=p(),f(P.$$.fragment),At=p(),f(K.$$.fragment),zt=p(),f(O.$$.fragment),Vt=p(),f(tt.$$.fragment),Dt=p(),f(et.$$.fragment),qt=p(),f(at.$$.fragment),Pt=p(),f(st.$$.fragment),Kt=p(),f(nt.$$.fragment),Ot=p(),f(ot.$$.fragment),te=p(),f(it.$$.fragment),ee=p(),f(lt.$$.fragment),ae=p(),f(rt.$$.fragment),se=p(),f(pt.$$.fragment),ne=p(),f(mt.$$.fragment),oe=p(),f(ct.$$.fragment),ie=p(),f(ft.$$.fragment),le=p(),f(dt.$$.fragment),re=p(),f(ht.$$.fragment),pe=p(),f(ut.$$.fragment),me=p(),f($t.$$.fragment),ce=p(),yt=y("p"),this.h()},l(t){const e=_e("svelte-u9bgzb",document.head);o=w(e,"META",{name:!0,content:!0}),e.forEach(s),M=m(t),c=w(t,"P",{}),xe(c).forEach(s),l=m(t),d(r.$$.fragment,t),a=m(t),i=w(t,"P",{"data-svelte-h":!0}),U(i)!=="svelte-ywbr5t"&&(i.textContent=T),b=m(t),j=w(t,"P",{"data-svelte-h":!0}),U(j)!=="svelte-15skck7"&&(j.textContent=bt),Tt=m(t),G=w(t,"P",{"data-svelte-h":!0}),U(G)!=="svelte-118jcm8"&&(G.innerHTML=de),Ut=m(t),k=w(t,"P",{"data-svelte-h":!0}),U(k)!=="svelte-1cblxco"&&(k.innerHTML=he),jt=m(t),d(C.$$.fragment,t),Jt=m(t),L=w(t,"P",{"data-svelte-h":!0}),U(L)!=="svelte-it421t"&&(L.innerHTML=ue),vt=m(t),_=w(t,"P",{"data-svelte-h":!0}),U(_)!=="svelte-12j5tg"&&(_.textContent=$e),xt=m(t),d(R.$$.fragment,t),Ct=m(t),d(W.$$.fragment,t),Rt=m(t),d(I.$$.fragment,t),It=m(t),d(B.$$.fragment,t),Bt=m(t),d(Z.$$.fragment,t),Gt=m(t),d(E.$$.fragment,t),kt=m(t),d(S.$$.fragment,t),Lt=m(t),d(X.$$.fragment,t),_t=m(t),Y=w(t,"P",{"data-svelte-h":!0}),U(Y)!=="svelte-13g30ke"&&(Y.textContent=ge),Wt=m(t),N=w(t,"UL",{"data-svelte-h":!0}),U(N)!=="svelte-grkgdm"&&(N.innerHTML=Me),Zt=m(t),F=w(t,"P",{"data-svelte-h":!0}),U(F)!=="svelte-b73vro"&&(F.textContent=be),Et=m(t),Q=w(t,"UL",{"data-svelte-h":!0}),U(Q)!=="svelte-11xetiz"&&(Q.innerHTML=ye),St=m(t),H=w(t,"P",{"data-svelte-h":!0}),U(H)!=="svelte-1dusnnt"&&(H.innerHTML=we),Xt=m(t),d(A.$$.fragment,t),Yt=m(t),z=w(t,"P",{"data-svelte-h":!0}),U(z)!=="svelte-1drt45h"&&(z.textContent=Te),Nt=m(t),d(V.$$.fragment,t),Ft=m(t),d(D.$$.fragment,t),Qt=m(t),d(q.$$.fragment,t),Ht=m(t),d(P.$$.fragment,t),At=m(t),d(K.$$.fragment,t),zt=m(t),d(O.$$.fragment,t),Vt=m(t),d(tt.$$.fragment,t),Dt=m(t),d(et.$$.fragment,t),qt=m(t),d(at.$$.fragment,t),Pt=m(t),d(st.$$.fragment,t),Kt=m(t),d(nt.$$.fragment,t),Ot=m(t),d(ot.$$.fragment,t),te=m(t),d(it.$$.fragment,t),ee=m(t),d(lt.$$.fragment,t),ae=m(t),d(rt.$$.fragment,t),se=m(t),d(pt.$$.fragment,t),ne=m(t),d(mt.$$.fragment,t),oe=m(t),d(ct.$$.fragment,t),ie=m(t),d(ft.$$.fragment,t),le=m(t),d(dt.$$.fragment,t),re=m(t),d(ht.$$.fragment,t),pe=m(t),d(ut.$$.fragment,t),me=m(t),d($t.$$.fragment,t),ce=m(t),yt=w(t,"P",{}),xe(yt).forEach(s),this.h()},h(){Ce(o,"name","hf:doc:metadata"),Ce(o,"content",Ve)},m(t,e){We(document.head,o),n(t,M,e),n(t,c,e),n(t,l,e),h(r,t,e),n(t,a,e),n(t,i,e),n(t,b,e),n(t,j,e),n(t,Tt,e),n(t,G,e),n(t,Ut,e),n(t,k,e),n(t,jt,e),h(C,t,e),n(t,Jt,e),n(t,L,e),n(t,vt,e),n(t,_,e),n(t,xt,e),h(R,t,e),n(t,Ct,e),h(W,t,e),n(t,Rt,e),h(I,t,e),n(t,It,e),h(B,t,e),n(t,Bt,e),h(Z,t,e),n(t,Gt,e),h(E,t,e),n(t,kt,e),h(S,t,e),n(t,Lt,e),h(X,t,e),n(t,_t,e),n(t,Y,e),n(t,Wt,e),n(t,N,e),n(t,Zt,e),n(t,F,e),n(t,Et,e),n(t,Q,e),n(t,St,e),n(t,H,e),n(t,Xt,e),h(A,t,e),n(t,Yt,e),n(t,z,e),n(t,Nt,e),h(V,t,e),n(t,Ft,e),h(D,t,e),n(t,Qt,e),h(q,t,e),n(t,Ht,e),h(P,t,e),n(t,At,e),h(K,t,e),n(t,zt,e),h(O,t,e),n(t,Vt,e),h(tt,t,e),n(t,Dt,e),h(et,t,e),n(t,qt,e),h(at,t,e),n(t,Pt,e),h(st,t,e),n(t,Kt,e),h(nt,t,e),n(t,Ot,e),h(ot,t,e),n(t,te,e),h(it,t,e),n(t,ee,e),h(lt,t,e),n(t,ae,e),h(rt,t,e),n(t,se,e),h(pt,t,e),n(t,ne,e),h(mt,t,e),n(t,oe,e),h(ct,t,e),n(t,ie,e),h(ft,t,e),n(t,le,e),h(dt,t,e),n(t,re,e),h(ht,t,e),n(t,pe,e),h(ut,t,e),n(t,me,e),h($t,t,e),n(t,ce,e),n(t,yt,e),fe=!0},p(t,[e]){const Ue={};e&2&&(Ue.$$scope={dirty:e,ctx:t}),C.$set(Ue);const je={};e&2&&(je.$$scope={dirty:e,ctx:t}),R.$set(je);const Je={};e&2&&(Je.$$scope={dirty:e,ctx:t}),I.$set(Je);const ve={};e&2&&(ve.$$scope={dirty:e,ctx:t}),B.$set(ve)},i(t){fe||(u(r.$$.fragment,t),u(C.$$.fragment,t),u(R.$$.fragment,t),u(W.$$.fragment,t),u(I.$$.fragment,t),u(B.$$.fragment,t),u(Z.$$.fragment,t),u(E.$$.fragment,t),u(S.$$.fragment,t),u(X.$$.fragment,t),u(A.$$.fragment,t),u(V.$$.fragment,t),u(D.$$.fragment,t),u(q.$$.fragment,t),u(P.$$.fragment,t),u(K.$$.fragment,t),u(O.$$.fragment,t),u(tt.$$.fragment,t),u(et.$$.fragment,t),u(at.$$.fragment,t),u(st.$$.fragment,t),u(nt.$$.fragment,t),u(ot.$$.fragment,t),u(it.$$.fragment,t),u(lt.$$.fragment,t),u(rt.$$.fragment,t),u(pt.$$.fragment,t),u(mt.$$.fragment,t),u(ct.$$.fragment,t),u(ft.$$.fragment,t),u(dt.$$.fragment,t),u(ht.$$.fragment,t),u(ut.$$.fragment,t),u($t.$$.fragment,t),fe=!0)},o(t){$(r.$$.fragment,t),$(C.$$.fragment,t),$(R.$$.fragment,t),$(W.$$.fragment,t),$(I.$$.fragment,t),$(B.$$.fragment,t),$(Z.$$.fragment,t),$(E.$$.fragment,t),$(S.$$.fragment,t),$(X.$$.fragment,t),$(A.$$.fragment,t),$(V.$$.fragment,t),$(D.$$.fragment,t),$(q.$$.fragment,t),$(P.$$.fragment,t),$(K.$$.fragment,t),$(O.$$.fragment,t),$(tt.$$.fragment,t),$(et.$$.fragment,t),$(at.$$.fragment,t),$(st.$$.fragment,t),$(nt.$$.fragment,t),$(ot.$$.fragment,t),$(it.$$.fragment,t),$(lt.$$.fragment,t),$(rt.$$.fragment,t),$(pt.$$.fragment,t),$(mt.$$.fragment,t),$(ct.$$.fragment,t),$(ft.$$.fragment,t),$(dt.$$.fragment,t),$(ht.$$.fragment,t),$(ut.$$.fragment,t),$($t.$$.fragment,t),fe=!1},d(t){t&&(s(M),s(c),s(l),s(a),s(i),s(b),s(j),s(Tt),s(G),s(Ut),s(k),s(jt),s(Jt),s(L),s(vt),s(_),s(xt),s(Ct),s(Rt),s(It),s(Bt),s(Gt),s(kt),s(Lt),s(_t),s(Y),s(Wt),s(N),s(Zt),s(F),s(Et),s(Q),s(St),s(H),s(Xt),s(Yt),s(z),s(Nt),s(Ft),s(Qt),s(Ht),s(At),s(zt),s(Vt),s(Dt),s(qt),s(Pt),s(Kt),s(Ot),s(te),s(ee),s(ae),s(se),s(ne),s(oe),s(ie),s(le),s(re),s(pe),s(me),s(ce),s(yt)),s(o),g(r,t),g(C,t),g(R,t),g(W,t),g(I,t),g(B,t),g(Z,t),g(E,t),g(S,t),g(X,t),g(A,t),g(V,t),g(D,t),g(q,t),g(P,t),g(K,t),g(O,t),g(tt,t),g(et,t),g(at,t),g(st,t),g(nt,t),g(ot,t),g(it,t),g(lt,t),g(rt,t),g(pt,t),g(mt,t),g(ct,t),g(ft,t),g(dt,t),g(ht,t),g(ut,t),g($t,t)}}}const Ve='{"title":"Code Example: Batching a (Streaming) Dataset","local":"code-example-batching-a-streaming-dataset","sections":[{"title":"Streaming Large Datasets","local":"streaming-large-datasets","sections":[],"depth":3},{"title":"Training Integration","local":"training-integration","sections":[{"title":"PyTorch DataLoader","local":"pytorch-dataloader","sections":[],"depth":3}],"depth":2},{"title":"Why This Matters","local":"why-this-matters","sections":[],"depth":2},{"title":"Section Quiz","local":"section-quiz","sections":[{"title":"1. What makes LeRobot different from traditional robotics libraries?","local":"1-what-makes-lerobot-different-from-traditional-robotics-libraries","sections":[],"depth":3},{"title":"2. Which of the following is NOT a key component of LeRobot’s approach?","local":"2-which-of-the-following-is-not-a-key-component-of-lerobots-approach","sections":[],"depth":3},{"title":"3. What is the main advantage of LeRobot’s optimized inference stack?","local":"3-what-is-the-main-advantage-of-lerobots-optimized-inference-stack","sections":[],"depth":3},{"title":"4. Which types of robotic platforms does LeRobot support?","local":"4-which-types-of-robotic-platforms-does-lerobot-support","sections":[],"depth":3},{"title":"5. What does “end-to-end integration with the robotics stack” mean in the context of LeRobot?","local":"5-what-does-end-to-end-integration-with-the-robotics-stack-mean-in-the-context-of-lerobot","sections":[],"depth":3},{"title":"6. What is the primary purpose of the delta_timestamps parameter in LeRobotDataset?","local":"6-what-is-the-primary-purpose-of-the-deltatimestamps-parameter-in-lerobotdataset","sections":[],"depth":3},{"title":"7. Which of the following best describes the three main components of LeRobotDataset?","local":"7-which-of-the-following-best-describes-the-three-main-components-of-lerobotdataset","sections":[],"depth":3},{"title":"8. What happens when you use StreamingLeRobotDataset instead of LeRobotDataset ?","local":"8-what-happens-when-you-use-streaminglerobotdataset-instead-of-lerobotdataset-","sections":[],"depth":3},{"title":"9. In the context of robot learning, what does “temporal windowing” refer to?","local":"9-in-the-context-of-robot-learning-what-does-temporal-windowing-refer-to","sections":[],"depth":3},{"title":"10. What is the main advantage of LeRobotDataset’s approach to storing video data?","local":"10-what-is-the-main-advantage-of-lerobotdatasets-approach-to-storing-video-data","sections":[],"depth":3},{"title":"11. Which statement about LeRobotDataset’s compatibility is correct?","local":"11-which-statement-about-lerobotdatasets-compatibility-is-correct","sections":[],"depth":3}],"depth":2}],"depth":1}';function De(J){return Ge(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class sa extends ke{constructor(o){super(),Le(this,o,De,ze,Be,{})}}export{sa as component};
