import{s as lo,f as io,n as so,o as mo}from"../chunks/scheduler.85c25b89.js";import{S as co,i as po,g as i,s as o,r as c,A as go,h as s,f as a,c as n,j as b,u as p,x as d,k as v,y as l,a as r,v as g,d as h,t as f,w as u}from"../chunks/index.c142fe32.js";import{D as C}from"../chunks/Docstring.e6639b56.js";import{C as ya}from"../chunks/CodeBlock.a5e95a57.js";import{H as $,E as ho}from"../chunks/EditOnGithub.a592e7aa.js";function fo(wa){let P,Ke,Ye,et,z,tt,I,Ta='<a href="https://huggingface.co/models?other=cpo,trl" rel="nofollow"><img src="https://img.shields.io/badge/All_models-CPO-blue"/></a>',at,H,ot,E,Oa='Contrastive Preference Optimization (CPO) as introduced in the paper <a href="https://huggingface.co/papers/2401.08417" rel="nofollow">Contrastive Preference Optimization: Pushing the Boundaries of LLM Performance in Machine Translation</a> by <a href="https://huggingface.co/haoranxu" rel="nofollow">Haoran Xu</a>, <a href="https://huggingface.co/amrsharaf" rel="nofollow">Amr Sharaf</a>, <a href="https://huggingface.co/yunmochen" rel="nofollow">Yunmo Chen</a>, Weiting Tan, Lingfeng Shen, Benjamin Van Durme, <a href="https://huggingface.co/Kenton" rel="nofollow">Kenton Murray</a>, and <a href="https://huggingface.co/ykim362" rel="nofollow">Young Jin Kim</a>. At a high-level, CPO trains models to avoid generating adequate, but not perfect translations in Machine Translation (MT) tasks. However, CPO is a general approximation to the DPO loss and can be applied to other domains like chat.',nt,D,xa="CPO aims to mitigate two fundamental shortcomings of SFT. First, SFT’s methodology of minimizing the discrepancy between predicted outputs and gold-standard references inherently caps model performance at the quality level of the training data. Secondly, SFT lacks a mechanism to prevent the model from rejecting mistakes in translations. The CPO objective is derived from the DPO objective.",rt,B,lt,J,Pa='This example demonstrates how to train a model using the CPO method. We use the <a href="https://huggingface.co/Qwen/Qwen2-0.5B-Instruct" rel="nofollow">Qwen 0.5B model</a> as the base model. We use the preference data from the <a href="https://huggingface.co/datasets/openbmb/UltraFeedback" rel="nofollow">UltraFeedback dataset</a>. You can view the data in the dataset here:',it,T,Ma,st,S,ka="Below is the script to train the model:",dt,Z,mt,A,Na="Execute the script using the following command:",ct,Q,pt,R,gt,V,Fa='CPO requires a <a href="dataset_formats#preference">preference dataset</a>. The <a href="/docs/trl/pr_1772/en/cpo_trainer#trl.CPOTrainer">CPOTrainer</a> supports both <a href="dataset_formats#conversational">conversational</a> and <a href="dataset_formats#standard">standard</a> dataset format. When provided with a conversational dataset, the trainer will automatically apply the chat template to the dataset.',ht,X,ft,Y,Ua='We provide an example script to train a model using the CPO method. The script is available in <a href="https://github.com/huggingface/trl/blob/main/examples/scripts/cpo.py" rel="nofollow"><code>examples/scripts/cpo.py</code></a>',ut,G,La='To test the CPO script with the <a href="https://huggingface.co/Qwen/Qwen2-0.5B-Instruct" rel="nofollow">Qwen2 0.5B model</a> on the <a href="https://huggingface.co/datasets/trl-lib/ultrafeedback_binarized" rel="nofollow">UltraFeedback dataset</a>, run the following command:',_t,K,vt,ee,bt,te,ja="While training and evaluating we record the following reward metrics:",Ct,ae,Wa="<li><code>rewards/chosen</code>: the mean log probabilities of the policy model for the chosen responses scaled by beta</li> <li><code>rewards/rejected</code>: the mean log probabilities of the policy model for the rejected responses scaled by beta</li> <li><code>rewards/accuracies</code>: mean of how often the chosen rewards are &gt; than the corresponding rejected rewards</li> <li><code>rewards/margins</code>: the mean difference between the chosen and corresponding rejected rewards</li> <li><code>nll_loss</code>: the mean negative log likelihood loss of the policy model for the chosen responses</li>",$t,oe,yt,ne,wt,re,qa='The <a href="https://huggingface.co/papers/2405.14734" rel="nofollow">SimPO</a> method is also implemented in the <a href="/docs/trl/pr_1772/en/cpo_trainer#trl.CPOTrainer">CPOTrainer</a>. SimPO is an alternative loss that adds a reward margin, allows for length normalization, and does not use BC regularization. To use this loss, we can use SimPO easily by turning on <code>loss_type=&quot;simpo&quot;</code> and <code>cpo_alpha=0</code> in the <a href="/docs/trl/pr_1772/en/cpo_trainer#trl.CPOConfig">CPOConfig</a>.',Tt,le,Ot,ie,za='We also offer the combined use of CPO and SimPO, which enables more stable training and improved performance. Learn more details at <a href="https://github.com/fe1ixxu/CPO_SIMPO" rel="nofollow">CPO-SimPO GitHub</a>. To use this method, simply enable SimPO by setting <code>loss_type=&quot;simpo&quot;</code> and a non-zero <code>cpo_alpha</code> in the <a href="/docs/trl/pr_1772/en/cpo_trainer#trl.CPOConfig">CPOConfig</a>.',xt,se,Pt,de,Ia='The CPO algorithm supports several loss functions. The loss function can be set using the <code>loss_type</code> parameter in the <a href="/docs/trl/pr_1772/en/cpo_trainer#trl.CPOConfig">CPOConfig</a>. The following loss functions are supported:',Mt,me,Ha='<thead><tr><th><code>loss_type=</code></th> <th>Description</th></tr></thead> <tbody><tr><td><code>&quot;sigmoid&quot;</code> (default)</td> <td>Given the preference data, we can fit a binary classifier according to the Bradley-Terry model and in fact the <a href="https://huggingface.co/papers/2305.18290" rel="nofollow">DPO</a> authors propose the sigmoid loss on the normalized likelihood via the <code>logsigmoid</code> to fit a logistic regression.</td></tr> <tr><td><code>&quot;hinge&quot;</code></td> <td>The <a href="https://huggingface.co/papers/2309.06657" rel="nofollow">RSO</a> authors propose to use a hinge loss on the normalized likelihood from the <a href="https://huggingface.co/papers/2305.10425" rel="nofollow">SLiC</a> paper. In this case, the <code>beta</code> is the reciprocal of the margin.</td></tr> <tr><td><code>&quot;ipo&quot;</code></td> <td>The <a href="https://huggingface.co/papers/2310.12036" rel="nofollow">IPO</a> authors provide a deeper theoretical understanding of the DPO algorithms and identify an issue with overfitting and propose an alternative loss. In this case, the <code>beta</code> is the reciprocal of the gap between the log-likelihood ratios of the chosen vs the rejected completion pair and thus the smaller the <code>beta</code> the larger this gaps is. As per the paper the loss is averaged over log-likelihoods of the completion (unlike DPO which is summed only).</td></tr></tbody>',kt,ce,Nt,pe,Ea=`MOEs are the most efficient if the load is about equally distributed between experts.<br/>
To ensure that we train MOEs similarly during preference-tuning, it is beneficial to add the auxiliary loss from the load balancer to the final loss.`,Ft,ge,Da=`This option is enabled by setting <code>output_router_logits=True</code> in the model config (e.g. <a href="https://huggingface.co/docs/transformers/main/en/model_doc/mixtral#transformers.MixtralConfig" rel="nofollow">MixtralConfig</a>).<br/>
To scale how much the auxiliary loss contributes to the total loss, use the hyperparameter <code>router_aux_loss_coef=...</code> (default: <code>0.001</code>) in the model config.`,Ut,he,Lt,m,fe,Qt,Ne,Ba="Initialize CPOTrainer.",Rt,M,ue,Vt,Fe,Ja=`Llama tokenizer does satisfy <code>enc(a + b) = enc(a) + enc(b)</code>.
It does ensure <code>enc(a + b) = enc(a) + enc(a + b)[len(enc(a)):]</code>.
Reference:
<a href="https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257" rel="nofollow">https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257</a>`,Xt,O,_e,Yt,Ue,Sa="Run the given model on the given batch of inputs, concatenating the chosen and rejected inputs together.",Gt,Le,Za="We do this to avoid doing two forward passes, because it’s faster for FSDP.",Kt,k,ve,ea,je,Aa="Concatenate the chosen and rejected inputs into a single tensor.",ta,N,be,aa,We,Qa="Compute the CPO loss for a batch of policy and reference model log probabilities.",oa,F,Ce,na,qe,Ra="Creates a draft of a model card using the information available to the <code>Trainer</code>.",ra,x,$e,la,ze,Va=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,ia,Ie,Xa="Works both with or without labels.",sa,U,ye,da,He,Ya="Generate samples from the model and reference model for the given batch of inputs.",ma,L,we,ca,Ee,Ga="Compute the log probabilities of the given labels under the given logits.",pa,j,Te,ga,De,Ka="Compute the CPO loss and other metrics for the given batch of inputs for train or test.",ha,W,Oe,fa,Be,eo="Log <code>logs</code> on the various objects watching training, including stored metrics.",ua,y,xe,_a,Je,to="Tokenize a single row from a CPO specific dataset.",va,Se,ao=`At this stage, we don’t convert to PyTorch tensors yet; we just handle the truncation
in case the prompt + chosen or prompt + rejected responses is/are too long. First
we truncate the prompt; if we’re still too long, we truncate the chosen/rejected.`,ba,Ze,oo=`We also create the labels for the chosen/rejected responses, which are of length equal to
the sum of the length of the prompt and the chosen/rejected response, with
label_pad_token_id  for the prompt tokens.`,jt,Pe,Wt,w,Me,Ca,Ae,no='Configuration class for the <a href="/docs/trl/pr_1772/en/cpo_trainer#trl.CPOTrainer">CPOTrainer</a>.',$a,Qe,ro=`Using <a href="https://huggingface.co/docs/transformers/main/en/internal/trainer_utils#transformers.HfArgumentParser" rel="nofollow">HfArgumentParser</a> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,qt,ke,zt,Ge,It;return z=new $({props:{title:"CPO Trainer",local:"cpo-trainer",headingTag:"h1"}}),H=new $({props:{title:"Overview",local:"overview",headingTag:"h2"}}),B=new $({props:{title:"Quick start",local:"quick-start",headingTag:"h2"}}),Z=new ya({props:{code:"JTIzJTIwdHJhaW5fY3BvLnB5JTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMENQT0NvbmZpZyUyQyUyMENQT1RyYWluZXIlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyUXdlbiUyRlF3ZW4yLTAuNUItSW5zdHJ1Y3QlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyUXdlbiUyRlF3ZW4yLTAuNUItSW5zdHJ1Y3QlMjIpJTBBdHJhaW5fZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJ0cmwtbGliJTJGdWx0cmFmZWVkYmFja19iaW5hcml6ZWQlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBDUE9Db25maWcob3V0cHV0X2RpciUzRCUyMlF3ZW4yLTAuNUItQ1BPJTIyJTJDJTIwbG9nZ2luZ19zdGVwcyUzRDEwKSUwQXRyYWluZXIlMjAlM0QlMjBDUE9UcmFpbmVyKG1vZGVsJTNEbW9kZWwlMkMlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUyMHByb2Nlc3NpbmdfY2xhc3MlM0R0b2tlbml6ZXIlMkMlMjB0cmFpbl9kYXRhc2V0JTNEdHJhaW5fZGF0YXNldCklMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-comment"># train_cpo.py</span>
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> CPOConfig, CPOTrainer
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)
train_dataset = load_dataset(<span class="hljs-string">&quot;trl-lib/ultrafeedback_binarized&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

training_args = CPOConfig(output_dir=<span class="hljs-string">&quot;Qwen2-0.5B-CPO&quot;</span>, logging_steps=<span class="hljs-number">10</span>)
trainer = CPOTrainer(model=model, args=training_args, processing_class=tokenizer, train_dataset=train_dataset)
trainer.train()`,wrap:!1}}),Q=new ya({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX2Nwby5weQ==",highlighted:"accelerate launch train_cpo.py",wrap:!1}}),R=new $({props:{title:"Expected dataset type",local:"expected-dataset-type",headingTag:"h2"}}),X=new $({props:{title:"Example script",local:"example-script",headingTag:"h2"}}),K=new ya({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMGV4YW1wbGVzJTJGc2NyaXB0cyUyRmNwby5weSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbW9kZWxfbmFtZV9vcl9wYXRoJTIwUXdlbiUyRlF3ZW4yLTAuNUItSW5zdHJ1Y3QlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWRhdGFzZXRfbmFtZSUyMHRybC1saWIlMkZ1bHRyYWZlZWRiYWNrX2JpbmFyaXplZCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbnVtX3RyYWluX2Vwb2NocyUyMDElMjAlNUMlMEElMjAlMjAlMjAlMjAtLWxvZ2dpbmdfc3RlcHMlMjAyNSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tb3V0cHV0X2RpciUyMFF3ZW4yLTAuNUItQ1BP",highlighted:`accelerate launch examples/scripts/cpo.py \\
    --model_name_or_path Qwen/Qwen2-0.5B-Instruct \\
    --dataset_name trl-lib/ultrafeedback_binarized \\
    --num_train_epochs 1 \\
    --logging_steps 25 \\
    --output_dir Qwen2-0.5B-CPO`,wrap:!1}}),ee=new $({props:{title:"Logged metrics",local:"logged-metrics",headingTag:"h2"}}),oe=new $({props:{title:"CPO variants",local:"cpo-variants",headingTag:"h2"}}),ne=new $({props:{title:"Simple Preference Optimization (SimPO)",local:"simple-preference-optimization-simpo",headingTag:"h3"}}),le=new $({props:{title:"CPO-SimPO",local:"cpo-simpo",headingTag:"h3"}}),se=new $({props:{title:"Loss functions",local:"loss-functions",headingTag:"h2"}}),ce=new $({props:{title:"For Mixture of Experts Models: Enabling the auxiliary loss",local:"for-mixture-of-experts-models-enabling-the-auxiliary-loss",headingTag:"h3"}}),he=new $({props:{title:"CPOTrainer",local:"trl.CPOTrainer",headingTag:"h2"}}),fe=new C({props:{name:"class trl.CPOTrainer",anchor:"trl.CPOTrainer",parameters:[{name:"model",val:": Union = None"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"processing_class",val:": Union = None"},{name:"model_init",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"}],parametersDescription:[{anchor:"trl.CPOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.CPOTrainer.args",description:`<strong>args</strong> (<code>CPOConfig</code>) &#x2014;
The CPO config arguments to use for training.`,name:"args"},{anchor:"trl.CPOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.CPOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.CPOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.CPOTrainer.processing_class",description:`<strong>processing_class</strong> (<code>PreTrainedTokenizerBase</code> or <code>BaseImageProcessor</code> or <code>FeatureExtractionMixin</code> or <code>ProcessorMixin</code>, <em>optional</em>) &#x2014;
Processing class used to process the data. If provided, will be used to automatically process the inputs
for the model, and it will be saved along the model to make it easier to rerun an interrupted training or
reuse the fine-tuned model.`,name:"processing_class"},{anchor:"trl.CPOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.CPOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.CPOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.CPOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.CPOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.CPOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"}],source:"https://github.com/huggingface/trl/blob/vr_1772/trl/trainer/cpo_trainer.py#L70"}}),ue=new C({props:{name:"build_tokenized_answer",anchor:"trl.CPOTrainer.build_tokenized_answer",parameters:[{name:"prompt",val:""},{name:"answer",val:""}],source:"https://github.com/huggingface/trl/blob/vr_1772/trl/trainer/cpo_trainer.py#L362"}}),_e=new C({props:{name:"concatenated_forward",anchor:"trl.CPOTrainer.concatenated_forward",parameters:[{name:"model",val:": Module"},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/vr_1772/trl/trainer/cpo_trainer.py#L709"}}),ve=new C({props:{name:"concatenated_inputs",anchor:"trl.CPOTrainer.concatenated_inputs",parameters:[{name:"batch",val:": Dict"},{name:"is_encoder_decoder",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = 0"},{name:"device",val:": Optional = None"}],source:"https://github.com/huggingface/trl/blob/vr_1772/trl/trainer/cpo_trainer.py#L558",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary containing the concatenated inputs under the key ‘concatenated_input_ids’.</p>
`}}),be=new C({props:{name:"cpo_loss",anchor:"trl.CPOTrainer.cpo_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"}],source:"https://github.com/huggingface/trl/blob/vr_1772/trl/trainer/cpo_trainer.py#L620",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards).
The losses tensor contains the CPO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of three tensors</p>
`}}),Ce=new C({props:{name:"create_model_card",anchor:"trl.CPOTrainer.create_model_card",parameters:[{name:"model_name",val:": Optional = None"},{name:"dataset_name",val:": Optional = None"},{name:"tags",val:": Union = None"}],parametersDescription:[{anchor:"trl.CPOTrainer.create_model_card.model_name",description:`<strong>model_name</strong> (<code>str</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The name of the model.`,name:"model_name"},{anchor:"trl.CPOTrainer.create_model_card.dataset_name",description:`<strong>dataset_name</strong> (<code>str</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The name of the dataset used for training.`,name:"dataset_name"},{anchor:"trl.CPOTrainer.create_model_card.tags",description:`<strong>tags</strong> (<code>str</code>, <code>List[str]</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Tags to be associated with the model card.`,name:"tags"}],source:"https://github.com/huggingface/trl/blob/vr_1772/trl/trainer/cpo_trainer.py#L1005"}}),$e=new C({props:{name:"evaluation_loop",anchor:"trl.CPOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": Optional = None"},{name:"ignore_keys",val:": Optional = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/vr_1772/trl/trainer/cpo_trainer.py#L918"}}),ye=new C({props:{name:"generate_from_model",anchor:"trl.CPOTrainer.generate_from_model",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/vr_1772/trl/trainer/cpo_trainer.py#L853"}}),we=new C({props:{name:"get_batch_logps",anchor:"trl.CPOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"average_log_prob",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/vr_1772/trl/trainer/cpo_trainer.py#L671",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (batch_size,) containing the average/sum log probabilities of the given labels under the given logits.</p>
`}}),Te=new C({props:{name:"get_batch_loss_metrics",anchor:"trl.CPOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"},{name:"train_eval",val:": Literal = 'train'"}],source:"https://github.com/huggingface/trl/blob/vr_1772/trl/trainer/cpo_trainer.py#L784"}}),Oe=new C({props:{name:"log",anchor:"trl.CPOTrainer.log",parameters:[{name:"logs",val:": Dict"}],parametersDescription:[{anchor:"trl.CPOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/vr_1772/trl/trainer/cpo_trainer.py#L966"}}),xe=new C({props:{name:"tokenize_row",anchor:"trl.CPOTrainer.tokenize_row",parameters:[{name:"feature",val:""},{name:"model",val:": Union = None"}],source:"https://github.com/huggingface/trl/blob/vr_1772/trl/trainer/cpo_trainer.py#L412"}}),Pe=new $({props:{title:"CPOConfig",local:"trl.CPOConfig",headingTag:"h2"}}),Me=new C({props:{name:"class trl.CPOConfig",anchor:"trl.CPOConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"torch_empty_cache_steps",val:": Optional = None"},{name:"learning_rate",val:": float = 1e-06"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Union = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"restore_callback_states_from_checkpoint",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Union = None"},{name:"deepspeed",val:": Union = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Union = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"include_for_metrics",val:": List = <factory>"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"evaluation_strategy",val:": Union = None"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"batch_eval_metrics",val:": bool = False"},{name:"eval_on_start",val:": bool = False"},{name:"use_liger_kernel",val:": Optional = False"},{name:"eval_use_gather_object",val:": Optional = False"},{name:"average_tokens_across_devices",val:": Optional = False"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_completion_length",val:": Optional = None"},{name:"beta",val:": float = 0.1"},{name:"label_smoothing",val:": float = 0.0"},{name:"loss_type",val:": Literal = 'sigmoid'"},{name:"disable_dropout",val:": bool = True"},{name:"cpo_alpha",val:": float = 1.0"},{name:"simpo_gamma",val:": float = 0.5"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": Optional = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"generate_during_eval",val:": bool = False"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"},{name:"dataset_num_proc",val:": Optional = None"}],parametersDescription:[{anchor:"trl.CPOConfig.learning_rate",description:`<strong>learning_rate</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1e-6</code>) &#x2014;
Initial learning rate for <code>AdamW</code> optimizer. The default value replaces that of
<a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">TrainingArguments</a>.`,name:"learning_rate"},{anchor:"trl.CPOConfig.max_length",description:`<strong>max_length</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Maximum length of the sequences (prompt + completion) in the batch. This argument is required if you want
to use the default data collator.`,name:"max_length"},{anchor:"trl.CPOConfig.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.CPOConfig.max_completion_length",description:`<strong>max_completion_length</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Maximum length of the completion. This argument is required if you want to use the default data collator
and your model is an encoder-decoder.`,name:"max_completion_length"},{anchor:"trl.CPOConfig.beta",description:`<strong>beta</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.1</code>) &#x2014;
Parameter controlling the deviation from the reference model. Higher &#x3B2; means less deviation from the
reference model. For the IPO loss (<code>loss_type=&quot;ipo&quot;</code>), &#x3B2; is the regularization parameter denoted by &#x3C4; in
the <a href="https://huggingface.co/papers/2310.12036" rel="nofollow">paper</a>.`,name:"beta"},{anchor:"trl.CPOConfig.label_smoothing",description:`<strong>label_smoothing</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.0</code>) &#x2014;
Label smoothing factor. This argument is required if you want to use the default data collator.`,name:"label_smoothing"},{anchor:"trl.CPOConfig.loss_type",description:`<strong>loss_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;sigmoid&quot;</code>) &#x2014;
Type of loss to use. Possible values are:</p>
<ul>
<li><code>&quot;sigmoid&quot;</code>: sigmoid loss from the original <a href="https://huggingface.co/papers/2305.18290" rel="nofollow">DPO</a> paper.</li>
<li><code>&quot;hinge&quot;</code>: hinge loss on the normalized likelihood from the <a href="https://huggingface.co/papers/2305.10425" rel="nofollow">SLiC</a> paper.</li>
<li><code>&quot;ipo&quot;</code>: IPO loss from the <a href="https://huggingface.co/papers/2310.12036" rel="nofollow">IPO</a> paper.</li>
<li><code>&quot;simpo&quot;</code>: SimPO loss from the <a href="https://huggingface.co/papers/2405.14734" rel="nofollow">SimPO</a> paper.</li>
</ul>`,name:"loss_type"},{anchor:"trl.CPOConfig.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to disable dropout in the model.`,name:"disable_dropout"},{anchor:"trl.CPOConfig.cpo_alpha",description:`<strong>cpo_alpha</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1.0</code>) &#x2014;
Weight of the BC regularizer in CPO training.`,name:"cpo_alpha"},{anchor:"trl.CPOConfig.simpo_gamma",description:`<strong>simpo_gamma</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.5</code>) &#x2014;
Target reward margin for the SimPO loss, used only when the <code>loss_type=&quot;simpo&quot;</code>.`,name:"simpo_gamma"},{anchor:"trl.CPOConfig.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to <code>-100</code>) &#x2014;
Label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.CPOConfig.padding_value",description:`<strong>padding_value</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Padding value to use. If <code>None</code>, the padding value of the tokenizer is used.`,name:"padding_value"},{anchor:"trl.CPOConfig.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>,<em>optional</em>,  defaults to <code>&quot;keep_end&quot;</code>) &#x2014;
Truncation mode to use when the prompt is too long. Possible values are <code>&quot;keep_end&quot;</code> or <code>&quot;keep_start&quot;</code>.
This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.CPOConfig.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, generates and logs completions from the model to W&amp;B during evaluation.`,name:"generate_during_eval"},{anchor:"trl.CPOConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>Optional[bool]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
When using the <code>model_init</code> argument (callable) to instantiate the model instead of the <code>model</code> argument,
you need to specify if the model returned by the callable is an encoder-decoder model.`,name:"is_encoder_decoder"},{anchor:"trl.CPOConfig.model_init_kwargs",description:`<strong>model_init_kwargs</strong> (<code>Optional[Dict[str, Any]]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Keyword arguments to pass to <code>AutoModelForCausalLM.from_pretrained</code> when instantiating the model from a
string.`,name:"model_init_kwargs"},{anchor:"trl.CPOConfig.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Number of processes to use for processing the dataset.`,name:"dataset_num_proc"}],source:"https://github.com/huggingface/trl/blob/vr_1772/trl/trainer/cpo_config.py#L20"}}),ke=new ho({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/cpo_trainer.mdx"}}),{c(){P=i("meta"),Ke=o(),Ye=i("p"),et=o(),c(z.$$.fragment),tt=o(),I=i("p"),I.innerHTML=Ta,at=o(),c(H.$$.fragment),ot=o(),E=i("p"),E.innerHTML=Oa,nt=o(),D=i("p"),D.textContent=xa,rt=o(),c(B.$$.fragment),lt=o(),J=i("p"),J.innerHTML=Pa,it=o(),T=i("iframe"),st=o(),S=i("p"),S.textContent=ka,dt=o(),c(Z.$$.fragment),mt=o(),A=i("p"),A.textContent=Na,ct=o(),c(Q.$$.fragment),pt=o(),c(R.$$.fragment),gt=o(),V=i("p"),V.innerHTML=Fa,ht=o(),c(X.$$.fragment),ft=o(),Y=i("p"),Y.innerHTML=Ua,ut=o(),G=i("p"),G.innerHTML=La,_t=o(),c(K.$$.fragment),vt=o(),c(ee.$$.fragment),bt=o(),te=i("p"),te.textContent=ja,Ct=o(),ae=i("ul"),ae.innerHTML=Wa,$t=o(),c(oe.$$.fragment),yt=o(),c(ne.$$.fragment),wt=o(),re=i("p"),re.innerHTML=qa,Tt=o(),c(le.$$.fragment),Ot=o(),ie=i("p"),ie.innerHTML=za,xt=o(),c(se.$$.fragment),Pt=o(),de=i("p"),de.innerHTML=Ia,Mt=o(),me=i("table"),me.innerHTML=Ha,kt=o(),c(ce.$$.fragment),Nt=o(),pe=i("p"),pe.innerHTML=Ea,Ft=o(),ge=i("p"),ge.innerHTML=Da,Ut=o(),c(he.$$.fragment),Lt=o(),m=i("div"),c(fe.$$.fragment),Qt=o(),Ne=i("p"),Ne.textContent=Ba,Rt=o(),M=i("div"),c(ue.$$.fragment),Vt=o(),Fe=i("p"),Fe.innerHTML=Ja,Xt=o(),O=i("div"),c(_e.$$.fragment),Yt=o(),Ue=i("p"),Ue.textContent=Sa,Gt=o(),Le=i("p"),Le.textContent=Za,Kt=o(),k=i("div"),c(ve.$$.fragment),ea=o(),je=i("p"),je.textContent=Aa,ta=o(),N=i("div"),c(be.$$.fragment),aa=o(),We=i("p"),We.textContent=Qa,oa=o(),F=i("div"),c(Ce.$$.fragment),na=o(),qe=i("p"),qe.innerHTML=Ra,ra=o(),x=i("div"),c($e.$$.fragment),la=o(),ze=i("p"),ze.innerHTML=Va,ia=o(),Ie=i("p"),Ie.textContent=Xa,sa=o(),U=i("div"),c(ye.$$.fragment),da=o(),He=i("p"),He.textContent=Ya,ma=o(),L=i("div"),c(we.$$.fragment),ca=o(),Ee=i("p"),Ee.textContent=Ga,pa=o(),j=i("div"),c(Te.$$.fragment),ga=o(),De=i("p"),De.textContent=Ka,ha=o(),W=i("div"),c(Oe.$$.fragment),fa=o(),Be=i("p"),Be.innerHTML=eo,ua=o(),y=i("div"),c(xe.$$.fragment),_a=o(),Je=i("p"),Je.textContent=to,va=o(),Se=i("p"),Se.textContent=ao,ba=o(),Ze=i("p"),Ze.textContent=oo,jt=o(),c(Pe.$$.fragment),Wt=o(),w=i("div"),c(Me.$$.fragment),Ca=o(),Ae=i("p"),Ae.innerHTML=no,$a=o(),Qe=i("p"),Qe.innerHTML=ro,qt=o(),c(ke.$$.fragment),zt=o(),Ge=i("p"),this.h()},l(e){const t=go("svelte-u9bgzb",document.head);P=s(t,"META",{name:!0,content:!0}),t.forEach(a),Ke=n(e),Ye=s(e,"P",{}),b(Ye).forEach(a),et=n(e),p(z.$$.fragment,e),tt=n(e),I=s(e,"P",{"data-svelte-h":!0}),d(I)!=="svelte-l2wng"&&(I.innerHTML=Ta),at=n(e),p(H.$$.fragment,e),ot=n(e),E=s(e,"P",{"data-svelte-h":!0}),d(E)!=="svelte-1t5xjlq"&&(E.innerHTML=Oa),nt=n(e),D=s(e,"P",{"data-svelte-h":!0}),d(D)!=="svelte-10wbspk"&&(D.textContent=xa),rt=n(e),p(B.$$.fragment,e),lt=n(e),J=s(e,"P",{"data-svelte-h":!0}),d(J)!=="svelte-16abj0b"&&(J.innerHTML=Pa),it=n(e),T=s(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),b(T).forEach(a),st=n(e),S=s(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-uqytq6"&&(S.textContent=ka),dt=n(e),p(Z.$$.fragment,e),mt=n(e),A=s(e,"P",{"data-svelte-h":!0}),d(A)!=="svelte-15hino8"&&(A.textContent=Na),ct=n(e),p(Q.$$.fragment,e),pt=n(e),p(R.$$.fragment,e),gt=n(e),V=s(e,"P",{"data-svelte-h":!0}),d(V)!=="svelte-ued253"&&(V.innerHTML=Fa),ht=n(e),p(X.$$.fragment,e),ft=n(e),Y=s(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-89szq"&&(Y.innerHTML=Ua),ut=n(e),G=s(e,"P",{"data-svelte-h":!0}),d(G)!=="svelte-1u4mdq5"&&(G.innerHTML=La),_t=n(e),p(K.$$.fragment,e),vt=n(e),p(ee.$$.fragment,e),bt=n(e),te=s(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-132s7j9"&&(te.textContent=ja),Ct=n(e),ae=s(e,"UL",{"data-svelte-h":!0}),d(ae)!=="svelte-yjg2sp"&&(ae.innerHTML=Wa),$t=n(e),p(oe.$$.fragment,e),yt=n(e),p(ne.$$.fragment,e),wt=n(e),re=s(e,"P",{"data-svelte-h":!0}),d(re)!=="svelte-jimcml"&&(re.innerHTML=qa),Tt=n(e),p(le.$$.fragment,e),Ot=n(e),ie=s(e,"P",{"data-svelte-h":!0}),d(ie)!=="svelte-142b3kx"&&(ie.innerHTML=za),xt=n(e),p(se.$$.fragment,e),Pt=n(e),de=s(e,"P",{"data-svelte-h":!0}),d(de)!=="svelte-ryd5gp"&&(de.innerHTML=Ia),Mt=n(e),me=s(e,"TABLE",{"data-svelte-h":!0}),d(me)!=="svelte-geackf"&&(me.innerHTML=Ha),kt=n(e),p(ce.$$.fragment,e),Nt=n(e),pe=s(e,"P",{"data-svelte-h":!0}),d(pe)!=="svelte-14px1ga"&&(pe.innerHTML=Ea),Ft=n(e),ge=s(e,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-11it1aj"&&(ge.innerHTML=Da),Ut=n(e),p(he.$$.fragment,e),Lt=n(e),m=s(e,"DIV",{class:!0});var _=b(m);p(fe.$$.fragment,_),Qt=n(_),Ne=s(_,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-1qqtmoh"&&(Ne.textContent=Ba),Rt=n(_),M=s(_,"DIV",{class:!0});var Ht=b(M);p(ue.$$.fragment,Ht),Vt=n(Ht),Fe=s(Ht,"P",{"data-svelte-h":!0}),d(Fe)!=="svelte-mcz8nm"&&(Fe.innerHTML=Ja),Ht.forEach(a),Xt=n(_),O=s(_,"DIV",{class:!0});var Re=b(O);p(_e.$$.fragment,Re),Yt=n(Re),Ue=s(Re,"P",{"data-svelte-h":!0}),d(Ue)!=="svelte-16i1nac"&&(Ue.textContent=Sa),Gt=n(Re),Le=s(Re,"P",{"data-svelte-h":!0}),d(Le)!=="svelte-tgti68"&&(Le.textContent=Za),Re.forEach(a),Kt=n(_),k=s(_,"DIV",{class:!0});var Et=b(k);p(ve.$$.fragment,Et),ea=n(Et),je=s(Et,"P",{"data-svelte-h":!0}),d(je)!=="svelte-1cvsgkk"&&(je.textContent=Aa),Et.forEach(a),ta=n(_),N=s(_,"DIV",{class:!0});var Dt=b(N);p(be.$$.fragment,Dt),aa=n(Dt),We=s(Dt,"P",{"data-svelte-h":!0}),d(We)!=="svelte-1l2rxe2"&&(We.textContent=Qa),Dt.forEach(a),oa=n(_),F=s(_,"DIV",{class:!0});var Bt=b(F);p(Ce.$$.fragment,Bt),na=n(Bt),qe=s(Bt,"P",{"data-svelte-h":!0}),d(qe)!=="svelte-1mh859w"&&(qe.innerHTML=Ra),Bt.forEach(a),ra=n(_),x=s(_,"DIV",{class:!0});var Ve=b(x);p($e.$$.fragment,Ve),la=n(Ve),ze=s(Ve,"P",{"data-svelte-h":!0}),d(ze)!=="svelte-8qlty5"&&(ze.innerHTML=Va),ia=n(Ve),Ie=s(Ve,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-1tyo99t"&&(Ie.textContent=Xa),Ve.forEach(a),sa=n(_),U=s(_,"DIV",{class:!0});var Jt=b(U);p(ye.$$.fragment,Jt),da=n(Jt),He=s(Jt,"P",{"data-svelte-h":!0}),d(He)!=="svelte-18uwvbi"&&(He.textContent=Ya),Jt.forEach(a),ma=n(_),L=s(_,"DIV",{class:!0});var St=b(L);p(we.$$.fragment,St),ca=n(St),Ee=s(St,"P",{"data-svelte-h":!0}),d(Ee)!=="svelte-4nmimv"&&(Ee.textContent=Ga),St.forEach(a),pa=n(_),j=s(_,"DIV",{class:!0});var Zt=b(j);p(Te.$$.fragment,Zt),ga=n(Zt),De=s(Zt,"P",{"data-svelte-h":!0}),d(De)!=="svelte-4kzfyw"&&(De.textContent=Ka),Zt.forEach(a),ha=n(_),W=s(_,"DIV",{class:!0});var At=b(W);p(Oe.$$.fragment,At),fa=n(At),Be=s(At,"P",{"data-svelte-h":!0}),d(Be)!=="svelte-nqksfz"&&(Be.innerHTML=eo),At.forEach(a),ua=n(_),y=s(_,"DIV",{class:!0});var q=b(y);p(xe.$$.fragment,q),_a=n(q),Je=s(q,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-1a53vwp"&&(Je.textContent=to),va=n(q),Se=s(q,"P",{"data-svelte-h":!0}),d(Se)!=="svelte-1mn1gnw"&&(Se.textContent=ao),ba=n(q),Ze=s(q,"P",{"data-svelte-h":!0}),d(Ze)!=="svelte-1xvpyih"&&(Ze.textContent=oo),q.forEach(a),_.forEach(a),jt=n(e),p(Pe.$$.fragment,e),Wt=n(e),w=s(e,"DIV",{class:!0});var Xe=b(w);p(Me.$$.fragment,Xe),Ca=n(Xe),Ae=s(Xe,"P",{"data-svelte-h":!0}),d(Ae)!=="svelte-o77j95"&&(Ae.innerHTML=no),$a=n(Xe),Qe=s(Xe,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-ekuf1t"&&(Qe.innerHTML=ro),Xe.forEach(a),qt=n(e),p(ke.$$.fragment,e),zt=n(e),Ge=s(e,"P",{}),b(Ge).forEach(a),this.h()},h(){v(P,"name","hf:doc:metadata"),v(P,"content",uo),io(T.src,Ma="https://huggingface.co/datasets/trl-lib/ultrafeedback_binarized/embed/viewer/default/train?row=0")||v(T,"src",Ma),v(T,"frameborder","0"),v(T,"width","100%"),v(T,"height","560px"),v(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(m,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){l(document.head,P),r(e,Ke,t),r(e,Ye,t),r(e,et,t),g(z,e,t),r(e,tt,t),r(e,I,t),r(e,at,t),g(H,e,t),r(e,ot,t),r(e,E,t),r(e,nt,t),r(e,D,t),r(e,rt,t),g(B,e,t),r(e,lt,t),r(e,J,t),r(e,it,t),r(e,T,t),r(e,st,t),r(e,S,t),r(e,dt,t),g(Z,e,t),r(e,mt,t),r(e,A,t),r(e,ct,t),g(Q,e,t),r(e,pt,t),g(R,e,t),r(e,gt,t),r(e,V,t),r(e,ht,t),g(X,e,t),r(e,ft,t),r(e,Y,t),r(e,ut,t),r(e,G,t),r(e,_t,t),g(K,e,t),r(e,vt,t),g(ee,e,t),r(e,bt,t),r(e,te,t),r(e,Ct,t),r(e,ae,t),r(e,$t,t),g(oe,e,t),r(e,yt,t),g(ne,e,t),r(e,wt,t),r(e,re,t),r(e,Tt,t),g(le,e,t),r(e,Ot,t),r(e,ie,t),r(e,xt,t),g(se,e,t),r(e,Pt,t),r(e,de,t),r(e,Mt,t),r(e,me,t),r(e,kt,t),g(ce,e,t),r(e,Nt,t),r(e,pe,t),r(e,Ft,t),r(e,ge,t),r(e,Ut,t),g(he,e,t),r(e,Lt,t),r(e,m,t),g(fe,m,null),l(m,Qt),l(m,Ne),l(m,Rt),l(m,M),g(ue,M,null),l(M,Vt),l(M,Fe),l(m,Xt),l(m,O),g(_e,O,null),l(O,Yt),l(O,Ue),l(O,Gt),l(O,Le),l(m,Kt),l(m,k),g(ve,k,null),l(k,ea),l(k,je),l(m,ta),l(m,N),g(be,N,null),l(N,aa),l(N,We),l(m,oa),l(m,F),g(Ce,F,null),l(F,na),l(F,qe),l(m,ra),l(m,x),g($e,x,null),l(x,la),l(x,ze),l(x,ia),l(x,Ie),l(m,sa),l(m,U),g(ye,U,null),l(U,da),l(U,He),l(m,ma),l(m,L),g(we,L,null),l(L,ca),l(L,Ee),l(m,pa),l(m,j),g(Te,j,null),l(j,ga),l(j,De),l(m,ha),l(m,W),g(Oe,W,null),l(W,fa),l(W,Be),l(m,ua),l(m,y),g(xe,y,null),l(y,_a),l(y,Je),l(y,va),l(y,Se),l(y,ba),l(y,Ze),r(e,jt,t),g(Pe,e,t),r(e,Wt,t),r(e,w,t),g(Me,w,null),l(w,Ca),l(w,Ae),l(w,$a),l(w,Qe),r(e,qt,t),g(ke,e,t),r(e,zt,t),r(e,Ge,t),It=!0},p:so,i(e){It||(h(z.$$.fragment,e),h(H.$$.fragment,e),h(B.$$.fragment,e),h(Z.$$.fragment,e),h(Q.$$.fragment,e),h(R.$$.fragment,e),h(X.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(oe.$$.fragment,e),h(ne.$$.fragment,e),h(le.$$.fragment,e),h(se.$$.fragment,e),h(ce.$$.fragment,e),h(he.$$.fragment,e),h(fe.$$.fragment,e),h(ue.$$.fragment,e),h(_e.$$.fragment,e),h(ve.$$.fragment,e),h(be.$$.fragment,e),h(Ce.$$.fragment,e),h($e.$$.fragment,e),h(ye.$$.fragment,e),h(we.$$.fragment,e),h(Te.$$.fragment,e),h(Oe.$$.fragment,e),h(xe.$$.fragment,e),h(Pe.$$.fragment,e),h(Me.$$.fragment,e),h(ke.$$.fragment,e),It=!0)},o(e){f(z.$$.fragment,e),f(H.$$.fragment,e),f(B.$$.fragment,e),f(Z.$$.fragment,e),f(Q.$$.fragment,e),f(R.$$.fragment,e),f(X.$$.fragment,e),f(K.$$.fragment,e),f(ee.$$.fragment,e),f(oe.$$.fragment,e),f(ne.$$.fragment,e),f(le.$$.fragment,e),f(se.$$.fragment,e),f(ce.$$.fragment,e),f(he.$$.fragment,e),f(fe.$$.fragment,e),f(ue.$$.fragment,e),f(_e.$$.fragment,e),f(ve.$$.fragment,e),f(be.$$.fragment,e),f(Ce.$$.fragment,e),f($e.$$.fragment,e),f(ye.$$.fragment,e),f(we.$$.fragment,e),f(Te.$$.fragment,e),f(Oe.$$.fragment,e),f(xe.$$.fragment,e),f(Pe.$$.fragment,e),f(Me.$$.fragment,e),f(ke.$$.fragment,e),It=!1},d(e){e&&(a(Ke),a(Ye),a(et),a(tt),a(I),a(at),a(ot),a(E),a(nt),a(D),a(rt),a(lt),a(J),a(it),a(T),a(st),a(S),a(dt),a(mt),a(A),a(ct),a(pt),a(gt),a(V),a(ht),a(ft),a(Y),a(ut),a(G),a(_t),a(vt),a(bt),a(te),a(Ct),a(ae),a($t),a(yt),a(wt),a(re),a(Tt),a(Ot),a(ie),a(xt),a(Pt),a(de),a(Mt),a(me),a(kt),a(Nt),a(pe),a(Ft),a(ge),a(Ut),a(Lt),a(m),a(jt),a(Wt),a(w),a(qt),a(zt),a(Ge)),a(P),u(z,e),u(H,e),u(B,e),u(Z,e),u(Q,e),u(R,e),u(X,e),u(K,e),u(ee,e),u(oe,e),u(ne,e),u(le,e),u(se,e),u(ce,e),u(he,e),u(fe),u(ue),u(_e),u(ve),u(be),u(Ce),u($e),u(ye),u(we),u(Te),u(Oe),u(xe),u(Pe,e),u(Me),u(ke,e)}}}const uo='{"title":"CPO Trainer","local":"cpo-trainer","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Quick start","local":"quick-start","sections":[],"depth":2},{"title":"Expected dataset type","local":"expected-dataset-type","sections":[],"depth":2},{"title":"Example script","local":"example-script","sections":[],"depth":2},{"title":"Logged metrics","local":"logged-metrics","sections":[],"depth":2},{"title":"CPO variants","local":"cpo-variants","sections":[{"title":"Simple Preference Optimization (SimPO)","local":"simple-preference-optimization-simpo","sections":[],"depth":3},{"title":"CPO-SimPO","local":"cpo-simpo","sections":[],"depth":3}],"depth":2},{"title":"Loss functions","local":"loss-functions","sections":[{"title":"For Mixture of Experts Models: Enabling the auxiliary loss","local":"for-mixture-of-experts-models-enabling-the-auxiliary-loss","sections":[],"depth":3}],"depth":2},{"title":"CPOTrainer","local":"trl.CPOTrainer","sections":[],"depth":2},{"title":"CPOConfig","local":"trl.CPOConfig","sections":[],"depth":2}],"depth":1}';function _o(wa){return mo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class wo extends co{constructor(P){super(),po(this,P,_o,fo,lo,{})}}export{wo as component};
