import{s as yi,f as Ti,n as gi,o as wi}from"../chunks/scheduler.85c25b89.js";import{S as Ji,i as _i,g as o,s as l,r as p,A as bi,h as i,f as a,c as s,j as k,u as d,x as r,k as T,l as fi,y,a as n,v as c,d as m,t as u,w as h}from"../chunks/index.c142fe32.js";import{D as ka}from"../chunks/Docstring.e6639b56.js";import{C as M}from"../chunks/CodeBlock.a5e95a57.js";import{H as f,E as Ui}from"../chunks/EditOnGithub.a592e7aa.js";function ji(Zs){let b,Fa,Ca,xa,F,$a,x,Bs='<a href="https://huggingface.co/models?other=sft,trl" rel="nofollow"><img src="https://img.shields.io/badge/All_models-SFT-blue"/></a>',Ga,$,Ns="Supervised fine-tuning (or SFT for short) is a crucial step in RLHF. In TRL we provide an easy-to-use API to create your SFT models and train them with few lines of code on your dataset.",Za,G,qs=`Check out a complete flexible example at <a href="https://github.com/huggingface/trl/tree/main/examples/scripts/sft.py" rel="nofollow"><code>examples/scripts/sft.py</code></a>.
Experimental support for Vision Language Models is also included in the example <a href="https://github.com/huggingface/trl/tree/main/examples/scripts/sft_vlm.py" rel="nofollow"><code>examples/scripts/sft_vlm.py</code></a>.`,Ba,Z,Na,B,Rs=`If you have a dataset hosted on the 🤗 Hub, you can easily fine-tune your SFT model using <a href="/docs/trl/pr_1772/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> from TRL. Let us assume your dataset is <code>imdb</code>, the text you want to predict is inside the <code>text</code> field of the dataset, and you want to fine-tune the <code>facebook/opt-350m</code> model.
The following code-snippet takes care of all the data pre-processing and training for you:`,qa,N,Ra,q,As="Make sure to pass the correct value for <code>max_seq_length</code> as the default value will be set to <code>min(tokenizer.model_max_length, 1024)</code>.",Aa,R,Es="You can also construct a model outside of the trainer and pass it as follows:",Ea,A,Wa,E,Ws='The above snippets will use the default training arguments from the <a href="/docs/trl/pr_1772/en/sft_trainer#trl.SFTConfig">SFTConfig</a> class. If you want to modify the defaults pass in your modification to the <code>SFTConfig</code> constructor and pass them to the trainer via the <code>args</code> argument.',Xa,W,Sa,X,za,S,Xs=`You can use the <code>DataCollatorForCompletionOnlyLM</code> to train your model on the generated prompts only. Note that this works only in the case when <code>packing=False</code>.
To instantiate that collator for instruction data, pass a response template and the tokenizer. Here is an example of how it would work to fine-tune <code>opt-350m</code> on completions only on the CodeAlpaca dataset:`,Qa,z,Va,Q,Ss="To instantiate that collator for assistant style conversation data, pass a response template, an instruction template and the tokenizer. Here is an example of how it would work to fine-tune <code>opt-350m</code> on assistant completions only on the Open Assistant Guanaco dataset:",Ha,V,La,H,zs="Make sure to have a <code>pad_token_id</code> which is different from <code>eos_token_id</code> which can result in the model not properly predicting EOS (End of Sentence) tokens during generation.",Ya,L,Da,Y,Qs="Some tokenizers like Llama 2 (<code>meta-llama/Llama-2-XXb-hf</code>) tokenize sequences differently depending on whether they have context or not. For example:",Pa,D,Oa,P,Vs="In this case, and due to lack of context in <code>response_template</code>, the same string (”### Assistant:”) is tokenized differently:",Ka,O,Hs="<li>Text (with context): <code>[2277, 29937, 4007, 22137, 29901]</code></li> <li><code>response_template</code> (without context): <code>[835, 4007, 22137, 29901]</code></li>",tn,K,Ls="This will lead to an error when the <code>DataCollatorForCompletionOnlyLM</code> does not find the <code>response_template</code> in the dataset example text:",en,tt,an,et,Ys="To solve this, you can tokenize the <code>response_template</code> with the same context as in the dataset, truncate it as needed and pass the <code>token_ids</code> directly to the <code>response_template</code> argument of the <code>DataCollatorForCompletionOnlyLM</code> class. For example:",nn,at,ln,nt,sn,lt,Ds=`Adding special tokens to a language model is crucial for training chat models. These tokens are added between the different roles in a conversation, such as the user, assistant, and system and help the model recognize the structure and flow of a conversation. This setup is essential for enabling the model to generate coherent and contextually appropriate responses in a chat environment.
The <code>setup_chat_format()</code> function in <code>trl</code> easily sets up a model and tokenizer for conversational AI tasks. This function:`,on,st,Ps='<li>Adds special tokens to the tokenizer, e.g. <code>&lt;|im_start|&gt;</code> and <code>&lt;|im_end|&gt;</code>, to indicate the start and end of a conversation.</li> <li>Resizes the model’s embedding layer to accommodate the new tokens.</li> <li>Sets the <code>chat_template</code> of the tokenizer, which is used to format the input data into a chat-like format. The default is <code>chatml</code> from OpenAI.</li> <li><em>optionally</em> you can pass <code>resize_to_multiple_of</code> to resize the embedding layer to a multiple of the <code>resize_to_multiple_of</code> argument, e.g. 64. If you want to see more formats being supported in the future, please open a GitHub issue on <a href="https://github.com/huggingface/trl" rel="nofollow">trl</a></li>',rn,ot,pn,it,Os="With our model and tokenizer set up, we can now fine-tune our model on a conversational dataset. Below is an example of how a dataset can be formatted for fine-tuning.",dn,rt,cn,pt,Ks='The <a href="/docs/trl/pr_1772/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> supports popular dataset formats. This allows you to pass the dataset to the trainer without any pre-processing directly. The following formats are supported:',mn,dt,to="<li>conversational format</li>",un,ct,hn,mt,eo="<li>instruction format</li>",Mn,ut,fn,ht,ao='If your dataset uses one of the above formats, you can directly pass it to the trainer without pre-processing. The <a href="/docs/trl/pr_1772/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> will then format the dataset for you using the defined format from the model’s tokenizer with the <a href="https://huggingface.co/docs/transformers/main/en/chat_templating#templates-for-chat-models" rel="nofollow">apply_chat_template</a> method.',yn,Mt,Tn,ft,no="If the dataset is not in one of those format you can either preprocess the dataset to match the formatting or pass a formatting function to the SFTTrainer to do it for you. Let’s have a look.",gn,yt,wn,Tt,lo=`For instruction fine-tuning, it is quite common to have two columns inside the dataset: one for the prompt &amp; the other for the response.
This allows people to format examples like <a href="https://github.com/tatsu-lab/stanford_alpaca" rel="nofollow">Stanford-Alpaca</a> did as follows:`,Jn,gt,_n,wt,so="Let us assume your dataset has two fields, <code>question</code> and <code>answer</code>. Therefore you can just run:",bn,Jt,Un,_t,oo='To properly format your input make sure to process all the examples by looping over them and returning a list of processed text. Check out a full example of how to use SFTTrainer on alpaca dataset <a href="https://github.com/huggingface/trl/pull/444#issue-1760952763" rel="nofollow">here</a>',jn,bt,vn,Ut,io='<a href="/docs/trl/pr_1772/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> supports <em>example packing</em>, where multiple short examples are packed in the same input sequence to increase training efficiency. This is done with the <code>ConstantLengthDataset</code> utility class that returns constant length chunks of tokens from a stream of examples. To enable the usage of this dataset class, simply pass <code>packing=True</code> to the <a href="/docs/trl/pr_1772/en/sft_trainer#trl.SFTConfig">SFTConfig</a> constructor.',Cn,jt,In,vt,ro=`Note that if you use a packed dataset and if you pass <code>max_steps</code> in the training arguments you will probably train your models for more than few epochs, depending on the way you have configured the packed dataset and the training protocol. Double check that you know and understand what you are doing.
If you don’t want to pack your <code>eval_dataset</code>, you can pass <code>eval_packing=False</code> to the <code>SFTConfig</code> init method.`,kn,Ct,Fn,It,po="If your dataset has several fields that you want to combine, for example if the dataset has <code>question</code> and <code>answer</code> fields and you want to combine them, you can pass a formatting function to the trainer that will take care of that. For example:",xn,kt,$n,Ft,co='You can also customize the <code>ConstantLengthDataset</code> much more by directly passing the arguments to the <a href="/docs/trl/pr_1772/en/sft_trainer#trl.SFTConfig">SFTConfig</a> constructor. Please refer to that class’ signature for more information.',Gn,xt,Zn,$t,mo='You can directly pass the kwargs of the <code>from_pretrained()</code> method to the <a href="/docs/trl/pr_1772/en/sft_trainer#trl.SFTConfig">SFTConfig</a>. For example, if you want to load a model in a different precision, analogous to',Bn,Gt,Nn,Zt,uo="Note that all keyword arguments of <code>from_pretrained()</code> are supported.",qn,Bt,Rn,Nt,ho="We also support tight integration with 🤗 PEFT library so that any user can conveniently train adapters and share them on the Hub instead of training the entire model",An,qt,En,Rt,Mo="You can also continue training your <code>PeftModel</code>. For that, first load a <code>PeftModel</code> outside <code>SFTTrainer</code> and pass it directly to the trainer without the <code>peft_config</code> argument being passed.",Wn,At,Xn,Et,fo="For that, you need to first load your 8 bit model outside the Trainer and pass a <code>PeftConfig</code> to the trainer. For example:",Sn,Wt,zn,Xt,Qn,St,yo=`You can benefit from Flash Attention 1 & 2 using SFTTrainer out of the box with minimal changes of code.
First, to make sure you have all the latest features from transformers, install transformers from source`,Vn,zt,Hn,Qt,To=`Note that Flash Attention only works on GPU now and under half-precision regime (when using adapters, base model loaded in half-precision)
Note also both features are perfectly compatible with other tools such as quantization.`,Ln,Vt,Yn,Ht,go="For Flash Attention 1 you can use the <code>BetterTransformer</code> API and force-dispatch the API to use Flash Attention kernel. First, install the latest optimum package:",Dn,Lt,Pn,Yt,wo="Once you have loaded your model, wrap the <code>trainer.train()</code> call under the <code>with torch.backends.cuda.sdp_kernel(enable_flash=True, enable_math=False, enable_mem_efficient=False):</code> context manager:",On,Dt,Kn,Pt,Jo="Note that you cannot train your model using Flash Attention 1 on an arbitrary dataset as <code>torch.scaled_dot_product_attention</code> does not support training with padding tokens if you use Flash Attention kernels. Therefore you can only use that feature with <code>packing=True</code>. If your dataset contains padding tokens, consider switching to Flash Attention 2 integration.",tl,Ot,_o="Below are some numbers you can get in terms of speedup and memory efficiency, using Flash Attention 1, on a single NVIDIA-T4 16GB.",el,Kt,bo="<thead><tr><th>use_flash_attn_1</th> <th>model_name</th> <th>max_seq_len</th> <th>batch_size</th> <th>time per training step</th></tr></thead> <tbody><tr><td>x</td> <td>facebook/opt-350m</td> <td>2048</td> <td>8</td> <td>~59.1s</td></tr> <tr><td></td> <td>facebook/opt-350m</td> <td>2048</td> <td>8</td> <td><strong>OOM</strong></td></tr> <tr><td>x</td> <td>facebook/opt-350m</td> <td>2048</td> <td>4</td> <td>~30.3s</td></tr> <tr><td></td> <td>facebook/opt-350m</td> <td>2048</td> <td>4</td> <td>~148.9s</td></tr></tbody>",al,te,nl,ee,Uo="To use Flash Attention 2, first install the latest <code>flash-attn</code> package:",ll,ae,sl,ne,jo="And add <code>attn_implementation=&quot;flash_attention_2&quot;</code> when calling <code>from_pretrained</code>:",ol,le,il,se,vo=`If you don’t use quantization, make sure your model is loaded in half-precision and dispatch your model on a supported GPU device.
After loading your model, you can either train it as it is, or attach adapters and train adapters on it in case your model is quantized.`,rl,oe,Co="In contrast to Flash Attention 1, the integration makes it possible to train your model on an arbitrary dataset that also includes padding tokens.",pl,ie,dl,re,Io="We included a utility function to create your model.",cl,g,pe,vs,ya,ko="Configuration class for the models.",Cs,Ta,Fo=`Using <a href="https://huggingface.co/docs/transformers/main/en/internal/trainer_utils#transformers.HfArgumentParser" rel="nofollow">HfArgumentParser</a> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,ml,de,ul,ce,hl,me,xo='NEFTune is a technique to boost the performance of chat models and was introduced by the paper <a href="https://huggingface.co/papers/2310.05914" rel="nofollow">“NEFTune: Noisy Embeddings Improve Instruction Finetuning”</a> from Jain et al. it consists of adding noise to the embedding vectors during training. According to the abstract of the paper:',Ml,ue,$o="<p>Standard finetuning of LLaMA-2-7B using Alpaca achieves 29.79% on AlpacaEval, which rises to 64.69% using noisy embeddings. NEFTune also improves over strong baselines on modern instruction datasets. Models trained with Evol-Instruct see a 10% improvement, with ShareGPT an 8% improvement, and with OpenPlatypus an 8% improvement. Even powerful models further refined with RLHF such as LLaMA-2-Chat benefit from additional training with NEFTune.</p>",fl,j,Go='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/neft-screenshot.png"/>',yl,he,Zo="To use it in <code>SFTTrainer</code> simply pass <code>neftune_noise_alpha</code> when creating your <code>SFTConfig</code> instance. Note that to avoid any surprising behaviour, NEFTune is disabled after training to retrieve back the original behaviour of the embedding layer.",Tl,Me,gl,fe,Bo='We have tested NEFTune by training <code>mistralai/Mistral-7B-v0.1</code> on the <a href="https://huggingface.co/datasets/timdettmers/openassistant-guanaco" rel="nofollow">OpenAssistant dataset</a> and validated that using NEFTune led to a performance boost of ~25% on MT Bench.',wl,v,No='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/trl-neftune-mistral-7b.png"/>',Jl,ye,qo='Note however, that the amount of performance gain is <em>dataset dependent</em> and in particular, applying NEFTune on synthetic datasets like <a href="https://huggingface.co/datasets/stingning/ultrachat" rel="nofollow">UltraChat</a> typically produces smaller gains.',_l,Te,bl,ge,Ro='You can further accelerate QLoRA / LoRA (2x faster, 60% less memory) using the <a href="https://github.com/unslothai/unsloth" rel="nofollow"><code>unsloth</code></a> library that is fully compatible with <code>SFTTrainer</code>. Currently <code>unsloth</code> supports only Llama (Yi, TinyLlama, Qwen, Deepseek etc) and Mistral architectures. Some benchmarks on 1x A100 listed below:',Ul,we,Ao="<thead><tr><th>1 A100 40GB</th> <th>Dataset</th> <th>🤗</th> <th>🤗 + Flash Attention 2</th> <th>🦥 Unsloth</th> <th>🦥 VRAM saved</th></tr></thead> <tbody><tr><td>Code Llama 34b</td> <td>Slim Orca</td> <td>1x</td> <td>1.01x</td> <td><strong>1.94x</strong></td> <td>-22.7%</td></tr> <tr><td>Llama-2 7b</td> <td>Slim Orca</td> <td>1x</td> <td>0.96x</td> <td><strong>1.87x</strong></td> <td>-39.3%</td></tr> <tr><td>Mistral 7b</td> <td>Slim Orca</td> <td>1x</td> <td>1.17x</td> <td><strong>1.88x</strong></td> <td>-65.9%</td></tr> <tr><td>Tiny Llama 1.1b</td> <td>Alpaca</td> <td>1x</td> <td>1.55x</td> <td><strong>2.74x</strong></td> <td>-57.8%</td></tr></tbody>",jl,Je,Eo='First install <code>unsloth</code> according to the <a href="https://github.com/unslothai/unsloth" rel="nofollow">official documentation</a>. Once installed, you can incorporate unsloth into your workflow in a very simple manner; instead of loading <code>AutoModelForCausalLM</code>, you just need to load a <code>FastLanguageModel</code> as follows:',vl,_e,Cl,be,Wo='The saved model is fully compatible with Hugging Face’s transformers library. Learn more about unsloth in their <a href="https://github.com/unslothai/unsloth" rel="nofollow">official repository</a>.',Il,Ue,kl,je,Xo='<a href="https://github.com/linkedin/Liger-Kernel" rel="nofollow">Liger Kernel</a> is a collection of Triton kernels designed specifically for LLM training. It can effectively increase multi-GPU training throughput by 20% and reduces memory usage by 60%. That way, we can <strong>4x</strong> our context length, as described in the benchmark below. They have implemented Hugging Face Compatible <code>RMSNorm</code>, <code>RoPE</code>, <code>SwiGLU</code>, <code>CrossEntropy</code>, <code>FusedLinearCrossEntropy</code>, and more to come. The kernel works out of the box with <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">Flash Attention</a>, <a href="https://pytorch.org/tutorials/intermediate/FSDP_tutorial.html" rel="nofollow">PyTorch FSDP</a>, and <a href="https://github.com/microsoft/DeepSpeed" rel="nofollow">Microsoft DeepSpeed</a>.',Fl,ve,So="With great memory reduction, you can potentially turn off cpu_offloading or gradient checkpointing to further boost the performance.",xl,Ce,zo='<thead><tr><th>Speed Up</th> <th>Memory Reduction</th></tr></thead> <tbody><tr><td><img src="https://raw.githubusercontent.com/linkedin/Liger-Kernel/main/docs/images/e2e-tps.png" alt="Speed up"/></td> <td><img src="https://raw.githubusercontent.com/linkedin/Liger-Kernel/main/docs/images/e2e-memory.png" alt="Memory"/></td></tr></tbody>',$l,Ie,Qo="<li>To use Liger-Kernel in <code>SFTTrainer</code>, first install by</li>",Gl,ke,Zl,C,Vo='<li>Once installed, set <code>use_liger</code> in <a href="/docs/trl/pr_1772/en/sft_trainer#trl.SFTConfig">SFTConfig</a>. No other changes are needed!</li>',Bl,Fe,Nl,xe,Ho='To learn more about Liger-Kernel, visit their <a href="https://github.com/linkedin/Liger-Kernel/" rel="nofollow">official repository</a>.',ql,$e,Rl,Ge,Lo="Pay attention to the following best practices when training a model with that trainer:",Al,Ze,Yo='<li><a href="/docs/trl/pr_1772/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> always pads by default the sequences to the <code>max_seq_length</code> argument of the <a href="/docs/trl/pr_1772/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a>. If none is passed, the trainer will retrieve that value from the tokenizer. Some tokenizers do not provide a default value, so there is a check to retrieve the minimum between 2048 and that value. Make sure to check it before training.</li> <li>For training adapters in 8bit, you might need to tweak the arguments of the <code>prepare_model_for_kbit_training</code> method from PEFT, hence we advise users to use <code>prepare_in_int8_kwargs</code> field, or create the <code>PeftModel</code> outside the <a href="/docs/trl/pr_1772/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> and pass it.</li> <li>For a more memory-efficient training using adapters, you can load the base model in 8bit, for that simply add <code>load_in_8bit</code> argument when creating the <a href="/docs/trl/pr_1772/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a>, or create a base model in 8bit outside the trainer and pass it.</li> <li>If you create a model outside the trainer, make sure to not pass to the trainer any additional keyword arguments that are relative to <code>from_pretrained()</code> method.</li>',El,Be,Wl,Ne,Do='Trainer (and thus SFTTrainer) supports multi-GPU training. If you run your script with <code>python script.py</code> it will default to using DP as the strategy, which may be <a href="https://github.com/huggingface/trl/issues/1303" rel="nofollow">slower than expected</a>. To use DDP (which is generally recommended, see <a href="https://huggingface.co/docs/transformers/en/perf_train_gpu_many?select-gpu=Accelerate#data-parallelism" rel="nofollow">here</a> for more info) you must launch the script with <code>python -m torch.distributed.launch script.py</code> or <code>accelerate launch script.py</code>. For DDP to work you must also check the following:',Xl,qe,Po='<li>If you’re using gradient_checkpointing, add the following to the TrainingArguments: <code>gradient_checkpointing_kwargs={&#39;use_reentrant&#39;:False}</code> (more info <a href="https://github.com/huggingface/transformers/issues/26969" rel="nofollow">here</a></li> <li>Ensure that the model is placed on the correct device:</li>',Sl,Re,zl,Ae,Ql,Ee,Oo="You may experience some issues with GPTQ Quantization after completing training. Lowering <code>gradient_accumulation_steps</code> to <code>4</code> will resolve most issues during the quantization process to GPTQ format.",Vl,We,Hl,Xe,Ko='<code>SFTTrainer</code> does not inherently support vision-language data. However, we provide a guide on how to tweak the trainer to support vision-language data. Specifically, you need to use a custom data collator that is compatible with vision-language data. This guide outlines the steps to make these adjustments. For a concrete example, refer to the script <a href="https://github.com/huggingface/trl/blob/main/examples/scripts/sft_vlm.py" rel="nofollow"><code>examples/scripts/sft_vlm.py</code></a> which demonstrates how to fine-tune the LLaVA 1.5 model on the <a href="https://huggingface.co/datasets/HuggingFaceH4/llava-instruct-mix-vsft" rel="nofollow">HuggingFaceH4/llava-instruct-mix-vsft</a> dataset.',Ll,Se,Yl,ze,ti="The data format is flexible, provided it is compatible with the custom collator that we will define later. A common approach is to use conversational data. Given that the data includes both text and images, the format needs to be adjusted accordingly. Below is an example of a conversational data format involving both text and images:",Dl,Qe,Pl,Ve,ei="To illustrate how this data format will be processed using the LLaVA model, you can use the following code:",Ol,He,Kl,Le,ai="The output will be formatted as follows:",ts,Ye,es,_,ni,as,De,ns,Pe,li="Unlike the default behavior of <code>SFTTrainer</code>, processing multi-modal data is done on the fly during the data collation process. To do this, you need to define a custom collator that processes both the text and images. This collator must take a list of examples as input (see the previous section for an example of the data format) and return a batch of processed data. Below is an example of such a collator:",ls,Oe,ss,Ke,si="We can verify that the collator works as expected by running the following code:",os,ta,is,ea,rs,aa,oi="Now that we have prepared the data and defined the collator, we can proceed with training the model. To ensure that the data is not processed as text-only, we need to set a couple of arguments in the <code>SFTConfig</code>, specifically <code>remove_unused_columns</code> and <code>skip_prepare_dataset</code> to <code>True</code> to avoid the default processing of the dataset. Below is an example of how to set up the <code>SFTTrainer</code>.",ps,na,ds,la,ii='A full example of training LLaVa 1.5 on the <a href="https://huggingface.co/datasets/HuggingFaceH4/llava-instruct-mix-vsft" rel="nofollow">HuggingFaceH4/llava-instruct-mix-vsft</a> dataset can be found in the script <a href="https://github.com/huggingface/trl/blob/main/examples/scripts/sft_vlm.py" rel="nofollow"><code>examples/scripts/sft_vlm.py</code></a>.',cs,sa,ri='<li><a href="https://wandb.ai/huggingface/trl/runs/2b2c5l7s" rel="nofollow">Experiment tracking</a></li> <li><a href="https://huggingface.co/HuggingFaceH4/sft-llava-1.5-7b-hf" rel="nofollow">Trained model</a></li>',ms,oa,us,w,ia,Is,ga,pi=`Class definition of the Supervised Finetuning Trainer (SFT Trainer).
This class is a wrapper around the <code>transformers.Trainer</code> class and inherits all of its attributes and methods.
The trainer takes care of properly initializing the PeftModel in case a user passes a <code>PeftConfig</code> object.`,ks,I,ra,Fs,wa,di="Creates a draft of a model card using the information available to the <code>Trainer</code>.",hs,pa,Ms,J,da,xs,Ja,ci='Configuration class for the <a href="/docs/trl/pr_1772/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a>.',$s,_a,mi=`Using <a href="https://huggingface.co/docs/transformers/main/en/internal/trainer_utils#transformers.HfArgumentParser" rel="nofollow">HfArgumentParser</a> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,fs,ca,ys,ma,ui="In the SFTTrainer we smartly support <code>datasets.IterableDataset</code> in addition to other style datasets. This is useful if you are using large corpora that you do not want to save all to disk. The data will be tokenized and processed on the fly, even when packing is enabled.",Ts,ua,hi="Additionally, in the SFTTrainer, we support pre-tokenized datasets if they are <code>datasets.Dataset</code> or <code>datasets.IterableDataset</code>. In other words, if such a dataset has a column of <code>input_ids</code>, no further processing (tokenization or packing) will be done, and the dataset will be used as-is. This can be useful if you have pretokenized your dataset outside of this script and want to re-use it directly.",gs,ha,ws,U,Ma,Gs,ba,Mi=`Iterable dataset that returns constant length chunks of tokens from stream of text files.
The dataset also formats the text before tokenization with a specific format that is provided
by the user.`,Js,fa,_s,Ia,bs;return F=new f({props:{title:"Supervised Fine-tuning Trainer",local:"supervised-fine-tuning-trainer",headingTag:"h1"}}),Z=new f({props:{title:"Quickstart",local:"quickstart",headingTag:"h2"}}),N=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVENvbmZpZyUyQyUyMFNGVFRyYWluZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMnN0YW5mb3JkbmxwJTJGaW1kYiUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFNGVENvbmZpZyglMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRDUxMiUyQyUwQSUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0QlMjIlMkZ0bXAlMjIlMkMlMEEpJTBBdHJhaW5lciUyMCUzRCUyMFNGVFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEEpJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer

dataset = load_dataset(<span class="hljs-string">&quot;stanfordnlp/imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

training_args = SFTConfig(
    max_seq_length=<span class="hljs-number">512</span>,
    output_dir=<span class="hljs-string">&quot;/tmp&quot;</span>,
)
trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    args=training_args,
)
trainer.train()`,wrap:!1}}),A=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVENvbmZpZyUyQyUyMFNGVFRyYWluZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMnN0YW5mb3JkbmxwJTJGaW1kYiUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEF0cmFpbmluZ19hcmdzJTIwJTNEJTIwU0ZUQ29uZmlnKG91dHB1dF9kaXIlM0QlMjIlMkZ0bXAlMjIpJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNGVFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBKSUwQSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer

dataset = load_dataset(<span class="hljs-string">&quot;stanfordnlp/imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

training_args = SFTConfig(output_dir=<span class="hljs-string">&quot;/tmp&quot;</span>)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    args=training_args,
)

trainer.train()`,wrap:!1}}),W=new f({props:{title:"Advanced usage",local:"advanced-usage",headingTag:"h2"}}),X=new f({props:{title:"Train on completions only",local:"train-on-completions-only",headingTag:"h3"}}),z=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBTRlRDb25maWclMkMlMjBTRlRUcmFpbmVyJTJDJTIwRGF0YUNvbGxhdG9yRm9yQ29tcGxldGlvbk9ubHlMTSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIybHVjYXNtY2NhYmUtbG1pJTJGQ29kZUFscGFjYS0yMGslMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEFkZWYlMjBmb3JtYXR0aW5nX3Byb21wdHNfZnVuYyhleGFtcGxlKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dF90ZXh0cyUyMCUzRCUyMCU1QiU1RCUwQSUyMCUyMCUyMCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKGxlbihleGFtcGxlJTVCJ2luc3RydWN0aW9uJyU1RCkpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGV4dCUyMCUzRCUyMGYlMjIlMjMlMjMlMjMlMjBRdWVzdGlvbiUzQSUyMCU3QmV4YW1wbGUlNUInaW5zdHJ1Y3Rpb24nJTVEJTVCaSU1RCU3RCU1Q24lMjAlMjMlMjMlMjMlMjBBbnN3ZXIlM0ElMjAlN0JleGFtcGxlJTVCJ291dHB1dCclNUQlNUJpJTVEJTdEJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0X3RleHRzLmFwcGVuZCh0ZXh0KSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG91dHB1dF90ZXh0cyUwQSUwQXJlc3BvbnNlX3RlbXBsYXRlJTIwJTNEJTIwJTIyJTIwJTIzJTIzJTIzJTIwQW5zd2VyJTNBJTIyJTBBY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JGb3JDb21wbGV0aW9uT25seUxNKHJlc3BvbnNlX3RlbXBsYXRlJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEU0ZUQ29uZmlnKG91dHB1dF9kaXIlM0QlMjIlMkZ0bXAlMjIpJTJDJTBBJTIwJTIwJTIwJTIwZm9ybWF0dGluZ19mdW5jJTNEZm9ybWF0dGluZ19wcm9tcHRzX2Z1bmMlMkMlMEElMjAlMjAlMjAlMjBkYXRhX2NvbGxhdG9yJTNEY29sbGF0b3IlMkMlMEEpJTBBJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer, DataCollatorForCompletionOnlyLM

dataset = load_dataset(<span class="hljs-string">&quot;lucasmccabe-lmi/CodeAlpaca-20k&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_prompts_func</span>(<span class="hljs-params">example</span>):
    output_texts = []
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(example[<span class="hljs-string">&#x27;instruction&#x27;</span>])):
        text = <span class="hljs-string">f&quot;### Question: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;instruction&#x27;</span>][i]}</span>\\n ### Answer: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;output&#x27;</span>][i]}</span>&quot;</span>
        output_texts.append(text)
    <span class="hljs-keyword">return</span> output_texts

response_template = <span class="hljs-string">&quot; ### Answer:&quot;</span>
collator = DataCollatorForCompletionOnlyLM(response_template, tokenizer=tokenizer)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    args=SFTConfig(output_dir=<span class="hljs-string">&quot;/tmp&quot;</span>),
    formatting_func=formatting_prompts_func,
    data_collator=collator,
)

trainer.train()`,wrap:!1}}),V=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBTRlRDb25maWclMkMlMjBTRlRUcmFpbmVyJTJDJTIwRGF0YUNvbGxhdG9yRm9yQ29tcGxldGlvbk9ubHlMTSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIydGltZGV0dG1lcnMlMkZvcGVuYXNzaXN0YW50LWd1YW5hY28lMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEFpbnN0cnVjdGlvbl90ZW1wbGF0ZSUyMCUzRCUyMCUyMiUyMyUyMyUyMyUyMEh1bWFuJTNBJTIyJTBBcmVzcG9uc2VfdGVtcGxhdGUlMjAlM0QlMjAlMjIlMjMlMjMlMjMlMjBBc3Npc3RhbnQlM0ElMjIlMEFjb2xsYXRvciUyMCUzRCUyMERhdGFDb2xsYXRvckZvckNvbXBsZXRpb25Pbmx5TE0oaW5zdHJ1Y3Rpb25fdGVtcGxhdGUlM0RpbnN0cnVjdGlvbl90ZW1wbGF0ZSUyQyUyMHJlc3BvbnNlX3RlbXBsYXRlJTNEcmVzcG9uc2VfdGVtcGxhdGUlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMjBtbG0lM0RGYWxzZSklMEElMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0RTRlRDb25maWcob3V0cHV0X2RpciUzRCUyMiUyRnRtcCUyMiklMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0Rjb2xsYXRvciUyQyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer, DataCollatorForCompletionOnlyLM

dataset = load_dataset(<span class="hljs-string">&quot;timdettmers/openassistant-guanaco&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

instruction_template = <span class="hljs-string">&quot;### Human:&quot;</span>
response_template = <span class="hljs-string">&quot;### Assistant:&quot;</span>
collator = DataCollatorForCompletionOnlyLM(instruction_template=instruction_template, response_template=response_template, tokenizer=tokenizer, mlm=<span class="hljs-literal">False</span>)

trainer = SFTTrainer(
    model,
    args=SFTConfig(output_dir=<span class="hljs-string">&quot;/tmp&quot;</span>),
    train_dataset=dataset,
    data_collator=collator,
)

trainer.train()`,wrap:!1}}),L=new f({props:{title:"Using token_ids directly for response_template",local:"using-tokenids-directly-for-responsetemplate",headingTag:"h4"}}),D=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1oZiUyMiklMEElMEFkZWYlMjBwcmludF90b2tlbnNfd2l0aF9pZHModHh0KSUzQSUwQSUyMCUyMCUyMCUyMHRva2VucyUyMCUzRCUyMHRva2VuaXplci50b2tlbml6ZSh0eHQlMkMlMjBhZGRfc3BlY2lhbF90b2tlbnMlM0RGYWxzZSklMEElMjAlMjAlMjAlMjB0b2tlbl9pZHMlMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKHR4dCUyQyUyMGFkZF9zcGVjaWFsX3Rva2VucyUzREZhbHNlKSUwQSUyMCUyMCUyMCUyMHByaW50KGxpc3QoemlwKHRva2VucyUyQyUyMHRva2VuX2lkcykpKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMiUyMiUyMiUyMyUyMyUyMyUyMFVzZXIlM0ElMjBIZWxsbyU1Q24lNUNuJTIzJTIzJTIzJTIwQXNzaXN0YW50JTNBJTIwSGklMkMlMjBob3clMjBjYW4lMjBJJTIwaGVscCUyMHlvdSUzRiUyMiUyMiUyMiUwQXByaW50X3Rva2Vuc193aXRoX2lkcyhwcm9tcHQpJTIwJTIwJTIzJTIwJTVCLi4uJTJDJTIwKCclRTIlOTYlODFIZWxsbyclMkMlMjAxNTA0MyklMkMlMjAoJyUzQzB4MEElM0UnJTJDJTIwMTMpJTJDJTIwKCclM0MweDBBJTNFJyUyQyUyMDEzKSUyQyUyMCgnJTIzJTIzJyUyQyUyMDIyNzcpJTJDJTIwKCclMjMnJTJDJTIwMjk5MzcpJTJDJTIwKCclRTIlOTYlODFBc3MnJTJDJTIwNDAwNyklMkMlMjAoJ2lzdGFudCclMkMlMjAyMjEzNyklMkMlMjAoJyUzQSclMkMlMjAyOTkwMSklMkMlMjAuLi4lNUQlMEElMEFyZXNwb25zZV90ZW1wbGF0ZSUyMCUzRCUyMCUyMiUyMyUyMyUyMyUyMEFzc2lzdGFudCUzQSUyMiUwQXByaW50X3Rva2Vuc193aXRoX2lkcyhyZXNwb25zZV90ZW1wbGF0ZSklMjAlMjAlMjMlMjAlNUIoJyVFMiU5NiU4MSUyMyUyMyUyMyclMkMlMjA4MzUpJTJDJTIwKCclRTIlOTYlODFBc3MnJTJDJTIwNDAwNyklMkMlMjAoJ2lzdGFudCclMkMlMjAyMjEzNyklMkMlMjAoJyUzQSclMkMlMjAyOTkwMSklNUQ=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-hf&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">print_tokens_with_ids</span>(<span class="hljs-params">txt</span>):
    tokens = tokenizer.tokenize(txt, add_special_tokens=<span class="hljs-literal">False</span>)
    token_ids = tokenizer.encode(txt, add_special_tokens=<span class="hljs-literal">False</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-built_in">list</span>(<span class="hljs-built_in">zip</span>(tokens, token_ids)))

prompt = <span class="hljs-string">&quot;&quot;&quot;### User: Hello\\n\\n### Assistant: Hi, how can I help you?&quot;&quot;&quot;</span>
print_tokens_with_ids(prompt)  <span class="hljs-comment"># [..., (&#x27;▁Hello&#x27;, 15043), (&#x27;&lt;0x0A&gt;&#x27;, 13), (&#x27;&lt;0x0A&gt;&#x27;, 13), (&#x27;##&#x27;, 2277), (&#x27;#&#x27;, 29937), (&#x27;▁Ass&#x27;, 4007), (&#x27;istant&#x27;, 22137), (&#x27;:&#x27;, 29901), ...]</span>

response_template = <span class="hljs-string">&quot;### Assistant:&quot;</span>
print_tokens_with_ids(response_template)  <span class="hljs-comment"># [(&#x27;▁###&#x27;, 835), (&#x27;▁Ass&#x27;, 4007), (&#x27;istant&#x27;, 22137), (&#x27;:&#x27;, 29901)]</span>`,wrap:!1}}),tt=new M({props:{code:"UnVudGltZUVycm9yJTNBJTIwQ291bGQlMjBub3QlMjBmaW5kJTIwcmVzcG9uc2UlMjBrZXklMjAlNUI4MzUlMkMlMjA0MDA3JTJDJTIwMjIxMzclMkMlMjAyOTkwMSU1RCUyMGluJTIwdG9rZW4lMjBJRHMlMjB0ZW5zb3IoJTVCJTIwJTIwJTIwJTIwMSUyQyUyMCUyMCUyMDgzNSUyQyUyMCUyMC4uLiU1RCk=",highlighted:'RuntimeError: Could not find response key <span class="hljs-selector-attr">[835, 4007, 22137, 29901]</span> <span class="hljs-keyword">in</span> token IDs <span class="hljs-built_in">tensor</span>(<span class="hljs-selector-attr">[    1,   835,  ...]</span>)',wrap:!1}}),at=new M({props:{code:"cmVzcG9uc2VfdGVtcGxhdGVfd2l0aF9jb250ZXh0JTIwJTNEJTIwJTIyJTVDbiUyMyUyMyUyMyUyMEFzc2lzdGFudCUzQSUyMiUyMCUyMCUyMyUyMFdlJTIwYWRkZWQlMjBjb250ZXh0JTIwaGVyZSUzQSUyMCUyMiU1Q24lMjIuJTIwVGhpcyUyMGlzJTIwZW5vdWdoJTIwZm9yJTIwdGhpcyUyMHRva2VuaXplciUwQXJlc3BvbnNlX3RlbXBsYXRlX2lkcyUyMCUzRCUyMHRva2VuaXplci5lbmNvZGUocmVzcG9uc2VfdGVtcGxhdGVfd2l0aF9jb250ZXh0JTJDJTIwYWRkX3NwZWNpYWxfdG9rZW5zJTNERmFsc2UpJTVCMiUzQSU1RCUyMCUyMCUyMyUyME5vdyUyMHdlJTIwaGF2ZSUyMGl0JTIwbGlrZSUyMGluJTIwdGhlJTIwZGF0YXNldCUyMHRleHRzJTNBJTIwJTYwJTVCMjI3NyUyQyUyMDI5OTM3JTJDJTIwNDAwNyUyQyUyMDIyMTM3JTJDJTIwMjk5MDElNUQlNjAlMEElMEFkYXRhX2NvbGxhdG9yJTIwJTNEJTIwRGF0YUNvbGxhdG9yRm9yQ29tcGxldGlvbk9ubHlMTShyZXNwb25zZV90ZW1wbGF0ZV9pZHMlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`response_template_with_context = <span class="hljs-string">&quot;\\n### Assistant:&quot;</span>  <span class="hljs-comment"># We added context here: &quot;\\n&quot;. This is enough for this tokenizer</span>
response_template_ids = tokenizer.encode(response_template_with_context, add_special_tokens=<span class="hljs-literal">False</span>)[<span class="hljs-number">2</span>:]  <span class="hljs-comment"># Now we have it like in the dataset texts: \`[2277, 29937, 4007, 22137, 29901]\`</span>

data_collator = DataCollatorForCompletionOnlyLM(response_template_ids, tokenizer=tokenizer)`,wrap:!1}}),nt=new f({props:{title:"Add Special Tokens for Chat Format",local:"add-special-tokens-for-chat-format",headingTag:"h3"}}),ot=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBzZXR1cF9jaGF0X2Zvcm1hdCUwQSUwQSUyMyUyMExvYWQlMjBtb2RlbCUyMGFuZCUyMHRva2VuaXplciUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEElMjMlMjBTZXQlMjB1cCUyMHRoZSUyMGNoYXQlMjBmb3JtYXQlMjB3aXRoJTIwZGVmYXVsdCUyMCdjaGF0bWwnJTIwZm9ybWF0JTBBbW9kZWwlMkMlMjB0b2tlbml6ZXIlMjAlM0QlMjBzZXR1cF9jaGF0X2Zvcm1hdChtb2RlbCUyQyUyMHRva2VuaXplciklMEE=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> setup_chat_format

<span class="hljs-comment"># Load model and tokenizer</span>
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

<span class="hljs-comment"># Set up the chat format with default &#x27;chatml&#x27; format</span>
model, tokenizer = setup_chat_format(model, tokenizer)
`,wrap:!1}}),rt=new f({props:{title:"Dataset format support",local:"dataset-format-support",headingTag:"h3"}}),ct=new M({props:{code:"JTdCJTIybWVzc2FnZXMlMjIlM0ElMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGhlbHBmdWwlMjIlN0QlMkMlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0J3MlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlM0YlMjIlN0QlMkMlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMi4uLiUyMiU3RCU1RCU3RCUwQSU3QiUyMm1lc3NhZ2VzJTIyJTNBJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBoZWxwZnVsJTIyJTdEJTJDJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hvJTIwd3JvdGUlMjAnUm9tZW8lMjBhbmQlMjBKdWxpZXQnJTNGJTIyJTdEJTJDJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjIuLi4lMjIlN0QlNUQlN0QlMEElN0IlMjJtZXNzYWdlcyUyMiUzQSUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwaGVscGZ1bCUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhvdyUyMGZhciUyMGlzJTIwdGhlJTIwTW9vbiUyMGZyb20lMjBFYXJ0aCUzRiUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyLi4uJTIyJTdEJTVEJTdE",highlighted:`<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;messages&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;system&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;You are helpful&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;What&#x27;s the capital of France?&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;assistant&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;...&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;messages&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;system&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;You are helpful&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Who wrote &#x27;Romeo and Juliet&#x27;?&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;assistant&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;...&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;messages&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;system&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;You are helpful&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;How far is the Moon from Earth?&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;assistant&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;...&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">}</span>`,wrap:!1}}),ut=new M({props:{code:"JTdCJTIycHJvbXB0JTIyJTNBJTIwJTIyJTNDcHJvbXB0JTIwdGV4dCUzRSUyMiUyQyUyMCUyMmNvbXBsZXRpb24lMjIlM0ElMjAlMjIlM0NpZGVhbCUyMGdlbmVyYXRlZCUyMHRleHQlM0UlMjIlN0QlMEElN0IlMjJwcm9tcHQlMjIlM0ElMjAlMjIlM0Nwcm9tcHQlMjB0ZXh0JTNFJTIyJTJDJTIwJTIyY29tcGxldGlvbiUyMiUzQSUyMCUyMiUzQ2lkZWFsJTIwZ2VuZXJhdGVkJTIwdGV4dCUzRSUyMiU3RCUwQSU3QiUyMnByb21wdCUyMiUzQSUyMCUyMiUzQ3Byb21wdCUyMHRleHQlM0UlMjIlMkMlMjAlMjJjb21wbGV0aW9uJTIyJTNBJTIwJTIyJTNDaWRlYWwlMjBnZW5lcmF0ZWQlMjB0ZXh0JTNFJTIyJTdE",highlighted:`<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;prompt&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;prompt text&gt;&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;completion&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;ideal generated text&gt;&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;prompt&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;prompt text&gt;&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;completion&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;ideal generated text&gt;&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;prompt&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;prompt text&gt;&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;completion&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;ideal generated text&gt;&quot;</span><span class="hljs-punctuation">}</span>`,wrap:!1}}),Mt=new M({props:{code:"JTBBJTBBJTBB",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer

...

<span class="hljs-comment"># load jsonl dataset</span>
dataset = load_dataset(<span class="hljs-string">&quot;json&quot;</span>, data_files=<span class="hljs-string">&quot;path/to/dataset.jsonl&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-comment"># load dataset from the HuggingFace Hub</span>
dataset = load_dataset(<span class="hljs-string">&quot;philschmid/dolly-15k-oai-style&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

...

training_args = SFTConfig(packing=<span class="hljs-literal">True</span>)
trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    args=training_args,
    train_dataset=dataset,
)`,wrap:!1}}),yt=new f({props:{title:"Format your input prompts",local:"format-your-input-prompts",headingTag:"h3"}}),gt=new M({props:{code:"QmVsb3clMjBpcyUyMGFuJTIwaW5zdHJ1Y3Rpb24lMjAuLi4lMEElMEElMjMlMjMlMjMlMjBJbnN0cnVjdGlvbiUwQSU3QnByb21wdCU3RCUwQSUwQSUyMyUyMyUyMyUyMFJlc3BvbnNlJTNBJTBBJTdCY29tcGxldGlvbiU3RA==",highlighted:`Below is an instruction ...

<span class="hljs-comment">### Instruction</span>
{prompt}

<span class="hljs-comment">### Response:</span>
{completion}`,wrap:!1}}),Jt=new M({props:{code:"JTBB",highlighted:`...
<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_prompts_func</span>(<span class="hljs-params">example</span>):
    output_texts = []
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(example[<span class="hljs-string">&#x27;question&#x27;</span>])):
        text = <span class="hljs-string">f&quot;### Question: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;question&#x27;</span>][i]}</span>\\n ### Answer: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;answer&#x27;</span>][i]}</span>&quot;</span>
        output_texts.append(text)
    <span class="hljs-keyword">return</span> output_texts

trainer = SFTTrainer(
    model,
    args=training_args,
    train_dataset=dataset,
    formatting_func=formatting_prompts_func,
)

trainer.train()`,wrap:!1}}),bt=new f({props:{title:"Packing dataset ( ConstantLengthDataset )",local:"packing-dataset--constantlengthdataset-",headingTag:"h3"}}),jt=new M({props:{code:"JTBB",highlighted:`...
training_args = SFTConfig(packing=<span class="hljs-literal">True</span>)

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    args=training_args
)

trainer.train()`,wrap:!1}}),Ct=new f({props:{title:"Customize your prompts using packed dataset",local:"customize-your-prompts-using-packed-dataset",headingTag:"h4"}}),kt=new M({props:{code:"ZGVmJTIwZm9ybWF0dGluZ19mdW5jKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwdGV4dCUyMCUzRCUyMGYlMjIlMjMlMjMlMjMlMjBRdWVzdGlvbiUzQSUyMCU3QmV4YW1wbGUlNUIncXVlc3Rpb24nJTVEJTdEJTVDbiUyMCUyMyUyMyUyMyUyMEFuc3dlciUzQSUyMCU3QmV4YW1wbGUlNUInYW5zd2VyJyU1RCU3RCUyMiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRleHQlMEElMEF0cmFpbmluZ19hcmdzJTIwJTNEJTIwU0ZUQ29uZmlnKHBhY2tpbmclM0RUcnVlKSUwQXRyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwZm9ybWF0dGluZ19mdW5jJTNEZm9ybWF0dGluZ19mdW5jJTBBKSUwQSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_func</span>(<span class="hljs-params">example</span>):
    text = <span class="hljs-string">f&quot;### Question: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;question&#x27;</span>]}</span>\\n ### Answer: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;answer&#x27;</span>]}</span>&quot;</span>
    <span class="hljs-keyword">return</span> text

training_args = SFTConfig(packing=<span class="hljs-literal">True</span>)
trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    args=training_args,
    formatting_func=formatting_func
)

trainer.train()`,wrap:!1}}),xt=new f({props:{title:"Control over the pretrained model",local:"control-over-the-pretrained-model",headingTag:"h3"}}),Gt=new M({props:{code:"JTBBJTBB",highlighted:`model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>, torch_dtype=torch.bfloat16)

...

training_args = SFTConfig(
    model_init_kwargs={
        <span class="hljs-string">&quot;torch_dtype&quot;</span>: <span class="hljs-string">&quot;bfloat16&quot;</span>,
    },
    output_dir=<span class="hljs-string">&quot;/tmp&quot;</span>,
)
trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    args=training_args,
)

trainer.train()`,wrap:!1}}),Bt=new f({props:{title:"Training adapters",local:"training-adapters",headingTag:"h3"}}),qt=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVENvbmZpZyUyQyUyMFNGVFRyYWluZXIlMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMExvcmFDb25maWclMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMnN0YW5mb3JkbmxwJTJGaW1kYiUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0QzMiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfZHJvcG91dCUzRDAuMDUlMkMlMEElMjAlMjAlMjAlMjBiaWFzJTNEJTIybm9uZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRhc2tfdHlwZSUzRCUyMkNBVVNBTF9MTSUyMiUyQyUwQSklMEElMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjAlMjJFbGV1dGhlckFJJTJGZ3B0LW5lby0xMjVtJTIyJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEU0ZUQ29uZmlnKG91dHB1dF9kaXIlM0QlMjIlMkZ0bXAlMjIpJTJDJTBBJTIwJTIwJTIwJTIwcGVmdF9jb25maWclM0RwZWZ0X2NvbmZpZyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

dataset = load_dataset(<span class="hljs-string">&quot;stanfordnlp/imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

peft_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

trainer = SFTTrainer(
    <span class="hljs-string">&quot;EleutherAI/gpt-neo-125m&quot;</span>,
    train_dataset=dataset,
    args=SFTConfig(output_dir=<span class="hljs-string">&quot;/tmp&quot;</span>),
    peft_config=peft_config
)

trainer.train()`,wrap:!1}}),At=new f({props:{title:"Training adapters with base 8 bit models",local:"training-adapters-with-base-8-bit-models",headingTag:"h3"}}),Wt=new M({props:{code:"JTBBJTBBJTBB",highlighted:`...

peft_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;EleutherAI/gpt-neo-125m&quot;</span>,
    load_in_8bit=<span class="hljs-literal">True</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    args=SFTConfig(),
    peft_config=peft_config,
)

trainer.train()`,wrap:!1}}),Xt=new f({props:{title:"Using Flash Attention and Flash Attention 2",local:"using-flash-attention-and-flash-attention-2",headingTag:"h2"}}),zt=new M({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZ2l0JTJCaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZ0cmFuc2Zvcm1lcnMuZ2l0",highlighted:"pip install -U git+https://github.com/huggingface/transformers.git",wrap:!1}}),Vt=new f({props:{title:"Using Flash-Attention 1",local:"using-flash-attention-1",headingTag:"h3"}}),Lt=new M({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwb3B0aW11bQ==",highlighted:"pip install -U optimum",wrap:!1}}),Dt=new M({props:{code:"",highlighted:`...

<span class="hljs-addition">+ with torch.backends.cuda.sdp_kernel(enable_flash=True, enable_math=False, enable_mem_efficient=False):</span>
    trainer.train()`,wrap:!1}}),te=new f({props:{title:"Using Flash Attention-2",local:"using-flash-attention-2",headingTag:"h3"}}),ae=new M({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZmxhc2gtYXR0bg==",highlighted:"pip install -U flash-attn",wrap:!1}}),le=new M({props:{code:"bW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRCUyMmZsYXNoX2F0dGVudGlvbl8yJTIyJTBBKQ==",highlighted:`model = AutoModelForCausalLM.from_pretrained(
    model_id,
    load_in_4bit=<span class="hljs-literal">True</span>,
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>
)`,wrap:!1}}),ie=new f({props:{title:"Using model creation utility",local:"trl.ModelConfig",headingTag:"h3"}}),pe=new ka({props:{name:"class trl.ModelConfig",anchor:"trl.ModelConfig",parameters:[{name:"model_name_or_path",val:": Optional = None"},{name:"model_revision",val:": str = 'main'"},{name:"torch_dtype",val:": Optional = None"},{name:"trust_remote_code",val:": bool = False"},{name:"attn_implementation",val:": Optional = None"},{name:"use_peft",val:": bool = False"},{name:"lora_r",val:": int = 16"},{name:"lora_alpha",val:": int = 32"},{name:"lora_dropout",val:": float = 0.05"},{name:"lora_target_modules",val:": Optional = None"},{name:"lora_modules_to_save",val:": Optional = None"},{name:"lora_task_type",val:": str = 'CAUSAL_LM'"},{name:"use_rslora",val:": bool = False"},{name:"load_in_8bit",val:": bool = False"},{name:"load_in_4bit",val:": bool = False"},{name:"bnb_4bit_quant_type",val:": Literal = 'nf4'"},{name:"use_bnb_nested_quant",val:": bool = False"}],parametersDescription:[{anchor:"trl.ModelConfig.model_name_or_path",description:`<strong>model_name_or_path</strong> (<code>Optional[str]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Model checkpoint for weights initialization.`,name:"model_name_or_path"},{anchor:"trl.ModelConfig.model_revision",description:`<strong>model_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
Specific model version to use. It can be a branch name, a tag name, or a commit id.`,name:"model_revision"},{anchor:"trl.ModelConfig.torch_dtype",description:`<strong>torch_dtype</strong> (<code>Optional[Literal[&quot;auto&quot;, &quot;bfloat16&quot;, &quot;float16&quot;, &quot;float32&quot;]]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Override the default <code>torch.dtype</code> and load the model under this dtype. Possible values are</p>
<ul>
<li><code>&quot;bfloat16&quot;</code>: <code>torch.bfloat16</code></li>
<li><code>&quot;float16&quot;</code>: <code>torch.float16</code></li>
<li><code>&quot;float32&quot;</code>: <code>torch.float32</code></li>
<li><code>&quot;auto&quot;</code>: Automatically derive the dtype from the model&#x2019;s weights.</li>
</ul>`,name:"torch_dtype"},{anchor:"trl.ModelConfig.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to allow for custom models defined on the Hub in their own modeling files. This option should only
be set to <code>True</code> for repositories you trust and in which you have read the code, as it will execute code
present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"trl.ModelConfig.attn_implementation",description:`<strong>attn_implementation</strong> (<code>Optional[str]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Which attention implementation to use. You can run <code>--attn_implementation=flash_attention_2</code>, in which case
you must install this manually by running <code>pip install flash-attn --no-build-isolation</code>.`,name:"attn_implementation"},{anchor:"trl.ModelConfig.use_peft",description:`<strong>use_peft</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use PEFT for training.`,name:"use_peft"},{anchor:"trl.ModelConfig.lora_r",description:`<strong>lora_r</strong> (<code>int</code>, <em>optional</em>, defaults to <code>16</code>) &#x2014;
LoRA R value.`,name:"lora_r"},{anchor:"trl.ModelConfig.lora_alpha",description:`<strong>lora_alpha</strong> (<code>int</code>, <em>optional</em>, defaults to <code>32</code>) &#x2014;
LoRA alpha.`,name:"lora_alpha"},{anchor:"trl.ModelConfig.lora_dropout",description:`<strong>lora_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.05</code>) &#x2014;
LoRA dropout.`,name:"lora_dropout"},{anchor:"trl.ModelConfig.lora_target_modules",description:`<strong>lora_target_modules</strong> (<code>Optional[Union[str, List[str]]]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
LoRA target modules.`,name:"lora_target_modules"},{anchor:"trl.ModelConfig.lora_modules_to_save",description:`<strong>lora_modules_to_save</strong> (<code>Optional[List[str]]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Model layers to unfreeze &amp; train.`,name:"lora_modules_to_save"},{anchor:"trl.ModelConfig.lora_task_type",description:`<strong>lora_task_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;CAUSAL_LM&quot;</code>) &#x2014;
Task type to pass for LoRA (use <code>&quot;SEQ_CLS&quot;</code> for reward modeling).`,name:"lora_task_type"},{anchor:"trl.ModelConfig.use_rslora",description:`<strong>use_rslora</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use Rank-Stabilized LoRA, which sets the adapter scaling factor to <code>lora_alpha/&#x221A;r</code>, instead of
the original default value of <code>lora_alpha/r</code>.`,name:"use_rslora"},{anchor:"trl.ModelConfig.load_in_8bit",description:`<strong>load_in_8bit</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use 8 bit precision for the base model. Works only with LoRA.`,name:"load_in_8bit"},{anchor:"trl.ModelConfig.load_in_4bit",description:`<strong>load_in_4bit</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use 4 bit precision for the base model. Works only with LoRA.`,name:"load_in_4bit"},{anchor:"trl.ModelConfig.bnb_4bit_quant_type",description:`<strong>bnb_4bit_quant_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;nf4&quot;</code>) &#x2014;
Quantization type (<code>&quot;fp4&quot;</code> or <code>&quot;nf4&quot;</code>).`,name:"bnb_4bit_quant_type"},{anchor:"trl.ModelConfig.use_bnb_nested_quant",description:`<strong>use_bnb_nested_quant</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use nested quantization.`,name:"use_bnb_nested_quant"}],source:"https://github.com/huggingface/trl/blob/vr_1772/trl/trainer/model_config.py#L19"}}),de=new M({props:{code:"ZnJvbSUyMHRybCUyMGltcG9ydCUyME1vZGVsQ29uZmlnJTJDJTIwU0ZUVHJhaW5lciUyQyUyMGdldF9rYml0X2RldmljZV9tYXAlMkMlMjBnZXRfcGVmdF9jb25maWclMkMlMjBnZXRfcXVhbnRpemF0aW9uX2NvbmZpZyUwQW1vZGVsX2NvbmZpZyUyMCUzRCUyME1vZGVsQ29uZmlnKCUwQSUyMCUyMCUyMCUyMG1vZGVsX25hbWVfb3JfcGF0aCUzRCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIlMEElMjAlMjAlMjAlMjBhdHRuX2ltcGxlbWVudGF0aW9uJTNETm9uZSUyQyUyMCUyMyUyMG9yJTIwJTIyZmxhc2hfYXR0ZW50aW9uXzIlMjIlMEEpJTBBdG9yY2hfZHR5cGUlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwbW9kZWxfY29uZmlnLnRvcmNoX2R0eXBlJTBBJTIwJTIwJTIwJTIwaWYlMjBtb2RlbF9jb25maWcudG9yY2hfZHR5cGUlMjBpbiUyMCU1QiUyMmF1dG8lMjIlMkMlMjBOb25lJTVEJTBBJTIwJTIwJTIwJTIwZWxzZSUyMGdldGF0dHIodG9yY2glMkMlMjBtb2RlbF9jb25maWcudG9yY2hfZHR5cGUpJTBBKSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBnZXRfcXVhbnRpemF0aW9uX2NvbmZpZyhtb2RlbF9jb25maWcpJTBBbW9kZWxfa3dhcmdzJTIwJTNEJTIwZGljdCglMEElMjAlMjAlMjAlMjByZXZpc2lvbiUzRG1vZGVsX2NvbmZpZy5tb2RlbF9yZXZpc2lvbiUyQyUwQSUyMCUyMCUyMCUyMHRydXN0X3JlbW90ZV9jb2RlJTNEbW9kZWxfY29uZmlnLnRydXN0X3JlbW90ZV9jb2RlJTJDJTBBJTIwJTIwJTIwJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRG1vZGVsX2NvbmZpZy5hdHRuX2ltcGxlbWVudGF0aW9uJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaF9kdHlwZSUyQyUwQSUyMCUyMCUyMCUyMHVzZV9jYWNoZSUzREZhbHNlJTIwaWYlMjB0cmFpbmluZ19hcmdzLmdyYWRpZW50X2NoZWNrcG9pbnRpbmclMjBlbHNlJTIwVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0RnZXRfa2JpdF9kZXZpY2VfbWFwKCklMjBpZiUyMHF1YW50aXphdGlvbl9jb25maWclMjBpcyUyMG5vdCUyME5vbmUlMjBlbHNlJTIwTm9uZSUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudGl6YXRpb25fY29uZmlnJTJDJTBBKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2NvbmZpZy5tb2RlbF9uYW1lX29yX3BhdGglMkMlMjAqKm1vZGVsX2t3YXJncyklMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjAuLi4lMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsX2NvbmZpZy5tb2RlbF9uYW1lX29yX3BhdGglMkMlMEElMjAlMjAlMjAlMjBwZWZ0X2NvbmZpZyUzRGdldF9wZWZ0X2NvbmZpZyhtb2RlbF9jb25maWcpJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> ModelConfig, SFTTrainer, get_kbit_device_map, get_peft_config, get_quantization_config
model_config = ModelConfig(
    model_name_or_path=<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>
    attn_implementation=<span class="hljs-literal">None</span>, <span class="hljs-comment"># or &quot;flash_attention_2&quot;</span>
)
torch_dtype = (
    model_config.torch_dtype
    <span class="hljs-keyword">if</span> model_config.torch_dtype <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;auto&quot;</span>, <span class="hljs-literal">None</span>]
    <span class="hljs-keyword">else</span> <span class="hljs-built_in">getattr</span>(torch, model_config.torch_dtype)
)
quantization_config = get_quantization_config(model_config)
model_kwargs = <span class="hljs-built_in">dict</span>(
    revision=model_config.model_revision,
    trust_remote_code=model_config.trust_remote_code,
    attn_implementation=model_config.attn_implementation,
    torch_dtype=torch_dtype,
    use_cache=<span class="hljs-literal">False</span> <span class="hljs-keyword">if</span> training_args.gradient_checkpointing <span class="hljs-keyword">else</span> <span class="hljs-literal">True</span>,
    device_map=get_kbit_device_map() <span class="hljs-keyword">if</span> quantization_config <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>,
    quantization_config=quantization_config,
)
model = AutoModelForCausalLM.from_pretrained(model_config.model_name_or_path, **model_kwargs)
trainer = SFTTrainer(
    ...,
    model=model_config.model_name_or_path,
    peft_config=get_peft_config(model_config),
)`,wrap:!1}}),ce=new f({props:{title:"Enhance the model’s performances using NEFTune",local:"enhance-the-models-performances-using-neftune",headingTag:"h3"}}),Me=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVENvbmZpZyUyQyUyMFNGVFRyYWluZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMnN0YW5mb3JkbmxwJTJGaW1kYiUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFNGVENvbmZpZyglMEElMjAlMjAlMjAlMjBuZWZ0dW5lX25vaXNlX2FscGhhJTNENSUyQyUwQSklMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjAlMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUwQSklMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer

dataset = load_dataset(<span class="hljs-string">&quot;stanfordnlp/imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

training_args = SFTConfig(
    neftune_noise_alpha=<span class="hljs-number">5</span>,
)
trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    args=training_args,
)
trainer.train()`,wrap:!1}}),Te=new f({props:{title:"Accelerate fine-tuning 2x using unsloth",local:"accelerate-fine-tuning-2x-using-unsloth",headingTag:"h3"}}),_e=new M({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer
<span class="hljs-keyword">from</span> unsloth <span class="hljs-keyword">import</span> FastLanguageModel

max_seq_length = <span class="hljs-number">2048</span> <span class="hljs-comment"># Supports automatic RoPE Scaling, so choose any number</span>

<span class="hljs-comment"># Load model</span>
model, tokenizer = FastLanguageModel.from_pretrained(
    model_name=<span class="hljs-string">&quot;unsloth/mistral-7b&quot;</span>,
    max_seq_length=max_seq_length,
    dtype=<span class="hljs-literal">None</span>,  <span class="hljs-comment"># None for auto detection. Float16 for Tesla T4, V100, Bfloat16 for Ampere+</span>
    load_in_4bit=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Use 4bit quantization to reduce memory usage. Can be False</span>
    <span class="hljs-comment"># token = &quot;hf_...&quot;, # use one if using gated models like meta-llama/Llama-2-7b-hf</span>
)

<span class="hljs-comment"># Do model patching and add fast LoRA weights</span>
model = FastLanguageModel.get_peft_model(
    model,
    r=<span class="hljs-number">16</span>,
    target_modules=[
        <span class="hljs-string">&quot;q_proj&quot;</span>,
        <span class="hljs-string">&quot;k_proj&quot;</span>,
        <span class="hljs-string">&quot;v_proj&quot;</span>,
        <span class="hljs-string">&quot;o_proj&quot;</span>,
        <span class="hljs-string">&quot;gate_proj&quot;</span>,
        <span class="hljs-string">&quot;up_proj&quot;</span>,
        <span class="hljs-string">&quot;down_proj&quot;</span>,
    ],
    lora_alpha=<span class="hljs-number">16</span>,
    lora_dropout=<span class="hljs-number">0</span>,  <span class="hljs-comment"># Dropout = 0 is currently optimized</span>
    bias=<span class="hljs-string">&quot;none&quot;</span>,  <span class="hljs-comment"># Bias = &quot;none&quot; is currently optimized</span>
    use_gradient_checkpointing=<span class="hljs-literal">True</span>,
    random_state=<span class="hljs-number">3407</span>,
)

training_args = SFTConfig(output_dir=<span class="hljs-string">&quot;./output&quot;</span>, max_seq_length=max_seq_length)

trainer = SFTTrainer(
    model=model,
    args=training_args,
    train_dataset=dataset,
)
trainer.train()`,wrap:!1}}),Ue=new f({props:{title:"Liger-Kernel: Increase 20% throughput and reduces 60% memory for multi-GPU training",local:"liger-kernel-increase-20-throughput-and-reduces-60-memory-for-multi-gpu-training",headingTag:"h2"}}),ke=new M({props:{code:"cGlwJTIwaW5zdGFsbCUyMGxpZ2VyLWtlcm5lbA==",highlighted:"pip install liger-kernel",wrap:!1}}),Fe=new M({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFNGVENvbmZpZyglMEElMjAlMjB1c2VfbGlnZXIlM0RUcnVlJTBBKQ==",highlighted:`training_args = SFTConfig(
  use_liger=<span class="hljs-literal">True</span>
)`,wrap:!1}}),$e=new f({props:{title:"Best practices",local:"best-practices",headingTag:"h2"}}),Be=new f({props:{title:"Multi-GPU Training",local:"multi-gpu-training",headingTag:"h2"}}),Re=new M({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBQYXJ0aWFsU3RhdGUlMEFkZXZpY2Vfc3RyaW5nJTIwJTNEJTIwUGFydGlhbFN0YXRlKCkucHJvY2Vzc19pbmRleCUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlN0InJyUzQWRldmljZV9zdHJpbmclN0QlMEEp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> PartialState
device_string = PartialState().process_index
model = AutoModelForCausalLM.from_pretrained(
     ...
    device_map={<span class="hljs-string">&#x27;&#x27;</span>:device_string}
)`,wrap:!1}}),Ae=new f({props:{title:"GPTQ Conversion",local:"gptq-conversion",headingTag:"h2"}}),We=new f({props:{title:"Extending SFTTrainer for Vision Language Models",local:"extending-sfttrainer-for-vision-language-models",headingTag:"h2"}}),Se=new f({props:{title:"Preparing the Data",local:"preparing-the-data",headingTag:"h3"}}),Qe=new M({props:{code:"aW1hZ2VzJTIwJTNEJTIwJTVCJTIyb2JhbWEucG5nJTIyJTVEJTBBbWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydGV4dCUyMiUyQyUyMCUyMnRleHQlMjIlM0ElMjAlMjJXaG8lMjBpcyUyMHRoaXMlM0YlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIyaW1hZ2UlMjIlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJ0ZXh0JTIyJTJDJTIwJTIydGV4dCUyMiUzQSUyMCUyMkJhcmFjayUyME9iYW1hJTIyJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIydHlwZSUyMiUzQSUyMCUyMnRleHQlMjIlMkMlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwaGUlMjBmYW1vdXMlMjBmb3IlM0YlMjIlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJ0ZXh0JTIyJTJDJTIwJTIydGV4dCUyMiUzQSUyMCUyMkhlJTIwaXMlMjB0aGUlMjA0NHRoJTIwUHJlc2lkZW50JTIwb2YlMjB0aGUlMjBVbml0ZWQlMjBTdGF0ZXMuJTIyJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTVE",highlighted:`images = [<span class="hljs-string">&quot;obama.png&quot;</span>]
messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Who is this?&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>}
        ]
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Barack Obama&quot;</span>}
        ]
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What is he famous for?&quot;</span>}
        ]
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;He is the 44th President of the United States.&quot;</span>}
        ]
    }
]`,wrap:!1}}),He=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJsbGF2YS1oZiUyRmxsYXZhLTEuNS03Yi1oZiUyMiklMEFwcmludChwcm9jZXNzb3IuYXBwbHlfY2hhdF90ZW1wbGF0ZShtZXNzYWdlcyUyQyUyMHRva2VuaXplJTNERmFsc2UpKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-1.5-7b-hf&quot;</span>)
<span class="hljs-built_in">print</span>(processor.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>))`,wrap:!1}}),Ye=new M({props:{code:"V2hvJTIwaXMlMjB0aGlzJTNGJTIwQVNTSVNUQU5UJTNBJTIwQmFyYWNrJTIwT2JhbWElMjBVU0VSJTNBJTIwV2hhdCUyMGlzJTIwaGUlMjBmYW1vdXMlMjBmb3IlM0YlMjBBU1NJU1RBTlQlM0ElMjBIZSUyMGlzJTIwdGhlJTIwNDR0aCUyMFByZXNpZGVudCUyMG9mJTIwdGhlJTIwVW5pdGVkJTIwU3RhdGVzLiUyMA==",highlighted:"Who is this? ASSISTANT: Barack Obama USER: What is he famous for? ASSISTANT: He is the 44th President of the United States. ",wrap:!1}}),De=new f({props:{title:"A custom collator for processing multi-modal data",local:"a-custom-collator-for-processing-multi-modal-data",headingTag:"h3"}}),Oe=new M({props:{code:"ZGVmJTIwY29sbGF0ZV9mbihleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBHZXQlMjB0aGUlMjB0ZXh0cyUyMGFuZCUyMGltYWdlcyUyQyUyMGFuZCUyMGFwcGx5JTIwdGhlJTIwY2hhdCUyMHRlbXBsYXRlJTBBJTIwJTIwJTIwJTIwdGV4dHMlMjAlM0QlMjAlNUJwcm9jZXNzb3IuYXBwbHlfY2hhdF90ZW1wbGF0ZShleGFtcGxlJTVCJTIybWVzc2FnZXMlMjIlNUQlMkMlMjB0b2tlbml6ZSUzREZhbHNlKSUyMGZvciUyMGV4YW1wbGUlMjBpbiUyMGV4YW1wbGVzJTVEJTBBJTIwJTIwJTIwJTIwaW1hZ2VzJTIwJTNEJTIwJTVCZXhhbXBsZSU1QiUyMmltYWdlcyUyMiU1RCU1QjAlNUQlMjBmb3IlMjBleGFtcGxlJTIwaW4lMjBleGFtcGxlcyU1RCUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFRva2VuaXplJTIwdGhlJTIwdGV4dHMlMjBhbmQlMjBwcm9jZXNzJTIwdGhlJTIwaW1hZ2VzJTBBJTIwJTIwJTIwJTIwYmF0Y2glMjAlM0QlMjBwcm9jZXNzb3IodGV4dHMlMkMlMjBpbWFnZXMlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwcGFkZGluZyUzRFRydWUpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwVGhlJTIwbGFiZWxzJTIwYXJlJTIwdGhlJTIwaW5wdXRfaWRzJTJDJTIwYW5kJTIwd2UlMjBtYXNrJTIwdGhlJTIwcGFkZGluZyUyMHRva2VucyUyMGluJTIwdGhlJTIwbG9zcyUyMGNvbXB1dGF0aW9uJTBBJTIwJTIwJTIwJTIwbGFiZWxzJTIwJTNEJTIwYmF0Y2glNUIlMjJpbnB1dF9pZHMlMjIlNUQuY2xvbmUoKSUwQSUyMCUyMCUyMCUyMGxhYmVscyU1QmxhYmVscyUyMCUzRCUzRCUyMHByb2Nlc3Nvci50b2tlbml6ZXIucGFkX3Rva2VuX2lkJTVEJTIwJTNEJTIwLTEwMCUwQSUyMCUyMCUyMCUyMGJhdGNoJTVCJTIybGFiZWxzJTIyJTVEJTIwJTNEJTIwbGFiZWxzJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYmF0Y2g=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">collate_fn</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-comment"># Get the texts and images, and apply the chat template</span>
    texts = [processor.apply_chat_template(example[<span class="hljs-string">&quot;messages&quot;</span>], tokenize=<span class="hljs-literal">False</span>) <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> examples]
    images = [example[<span class="hljs-string">&quot;images&quot;</span>][<span class="hljs-number">0</span>] <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> examples]

    <span class="hljs-comment"># Tokenize the texts and process the images</span>
    batch = processor(texts, images, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>)

    <span class="hljs-comment"># The labels are the input_ids, and we mask the padding tokens in the loss computation</span>
    labels = batch[<span class="hljs-string">&quot;input_ids&quot;</span>].clone()
    labels[labels == processor.tokenizer.pad_token_id] = -<span class="hljs-number">100</span>
    batch[<span class="hljs-string">&quot;labels&quot;</span>] = labels

    <span class="hljs-keyword">return</span> batch`,wrap:!1}}),ta=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJIdWdnaW5nRmFjZUg0JTJGbGxhdmEtaW5zdHJ1Y3QtbWl4LXZzZnQlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQWV4YW1wbGVzJTIwJTNEJTIwJTVCZGF0YXNldCU1QjAlNUQlMkMlMjBkYXRhc2V0JTVCMSU1RCU1RCUyMCUyMCUyMyUyMEp1c3QlMjB0d28lMjBleGFtcGxlcyUyMGZvciUyMHRoZSUyMHNha2UlMjBvZiUyMHRoZSUyMGV4YW1wbGUlMEFjb2xsYXRlZF9kYXRhJTIwJTNEJTIwY29sbGF0ZV9mbihleGFtcGxlcyklMEFwcmludChjb2xsYXRlZF9kYXRhLmtleXMoKSklMjAlMjAlMjMlMjBkaWN0X2tleXMoJTVCJ2lucHV0X2lkcyclMkMlMjAnYXR0ZW50aW9uX21hc2snJTJDJTIwJ3BpeGVsX3ZhbHVlcyclMkMlMjAnbGFiZWxzJyU1RCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;HuggingFaceH4/llava-instruct-mix-vsft&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
examples = [dataset[<span class="hljs-number">0</span>], dataset[<span class="hljs-number">1</span>]]  <span class="hljs-comment"># Just two examples for the sake of the example</span>
collated_data = collate_fn(examples)
<span class="hljs-built_in">print</span>(collated_data.keys())  <span class="hljs-comment"># dict_keys([&#x27;input_ids&#x27;, &#x27;attention_mask&#x27;, &#x27;pixel_values&#x27;, &#x27;labels&#x27;])</span>`,wrap:!1}}),ea=new f({props:{title:"Training the vision-language model",local:"training-the-vision-language-model",headingTag:"h3"}}),na=new M({props:{code:"dHJhaW5pbmdfYXJncy5yZW1vdmVfdW51c2VkX2NvbHVtbnMlMjAlM0QlMjBGYWxzZSUwQXRyYWluaW5nX2FyZ3MuZGF0YXNldF9rd2FyZ3MlMjAlM0QlMjAlN0IlMjJza2lwX3ByZXBhcmVfZGF0YXNldCUyMiUzQSUyMFRydWUlN0QlMEElMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjBkYXRhX2NvbGxhdG9yJTNEY29sbGF0ZV9mbiUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0R0cmFpbl9kYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwcHJvY2Vzc2luZ19jbGFzcyUzRHByb2Nlc3Nvci50b2tlbml6ZXIlMkMlMEEp",highlighted:`training_args.remove_unused_columns = <span class="hljs-literal">False</span>
training_args.dataset_kwargs = {<span class="hljs-string">&quot;skip_prepare_dataset&quot;</span>: <span class="hljs-literal">True</span>}

trainer = SFTTrainer(
    model=model,
    args=training_args,
    data_collator=collate_fn,
    train_dataset=train_dataset,
    processing_class=processor.tokenizer,
)`,wrap:!1}}),oa=new f({props:{title:"SFTTrainer",local:"trl.SFTTrainer",headingTag:"h2"}}),ia=new ka({props:{name:"class trl.SFTTrainer",anchor:"trl.SFTTrainer",parameters:[{name:"model",val:": Union = None"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"processing_class",val:": Union = None"},{name:"model_init",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"formatting_func",val:": Optional = None"}],parametersDescription:[{anchor:"trl.SFTTrainer.model",description:`<strong>model</strong> (Union[<code>transformers.PreTrainedModel</code>, <code>nn.Module</code>, <code>str</code>]) &#x2014;
The model to train, can be a <code>PreTrainedModel</code>, a <code>torch.nn.Module</code> or a string with the model name to
load from cache or download. The model can be also converted to a <code>PeftModel</code> if a <code>PeftConfig</code> object is
passed to the <code>peft_config</code> argument.`,name:"model"},{anchor:"trl.SFTTrainer.args",description:`<strong>args</strong> (<code>Optional[SFTConfig]</code>) &#x2014;
The arguments to tweak for training. Will default to a basic instance of <a href="/docs/trl/pr_1772/en/sft_trainer#trl.SFTConfig">SFTConfig</a> with the <code>output_dir</code>
set to a directory named <em>tmp_trainer</em> in the current directory if not provided.`,name:"args"},{anchor:"trl.SFTTrainer.data_collator",description:`<strong>data_collator</strong> (<code>Optional[transformers.DataCollator]</code>) &#x2014;
The data collator to use for training.`,name:"data_collator"},{anchor:"trl.SFTTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>Optional[datasets.Dataset]</code>) &#x2014;
The dataset to use for training. We recommend users to use <code>trl.trainer.ConstantLengthDataset</code> to create their dataset.`,name:"train_dataset"},{anchor:"trl.SFTTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (Optional[Union[<code>datasets.Dataset</code>, Dict[<code>str</code>, <code>datasets.Dataset</code>]]]) &#x2014;
The dataset to use for evaluation. We recommend users to use <code>trl.trainer.ConstantLengthDataset</code> to create their dataset.`,name:"eval_dataset"},{anchor:"trl.SFTTrainer.processing_class",description:`<strong>processing_class</strong> (<code>PreTrainedTokenizerBase</code> or <code>BaseImageProcessor</code> or <code>FeatureExtractionMixin</code> or <code>ProcessorMixin</code>, <em>optional</em>) &#x2014;
Processing class used to process the data. If provided, will be used to automatically process the inputs
for the model, and it will be saved along the model to make it easier to rerun an interrupted training or
reuse the fine-tuned model.
This supercedes the <code>tokenizer</code> argument, which is now deprecated.`,name:"processing_class"},{anchor:"trl.SFTTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.SFTTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[transformers.EvalPrediction], Dict]</code>, <em>optional</em> defaults to None) &#x2014;
The function used to compute metrics during evaluation. It should return a dictionary mapping metric names to metric values.
If not specified, only the loss will be computed during evaluation.`,name:"compute_metrics"},{anchor:"trl.SFTTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.SFTTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.SFTTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.SFTTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Optional[PeftConfig]</code>) &#x2014;
The PeftConfig object to use to initialize the PeftModel.`,name:"peft_config"},{anchor:"trl.SFTTrainer.formatting_func",description:`<strong>formatting_func</strong> (<code>Optional[Callable]</code>) &#x2014;
The formatting function to be used for creating the <code>ConstantLengthDataset</code>.`,name:"formatting_func"}],source:"https://github.com/huggingface/trl/blob/vr_1772/trl/trainer/sft_trainer.py#L65"}}),ra=new ka({props:{name:"create_model_card",anchor:"trl.SFTTrainer.create_model_card",parameters:[{name:"model_name",val:": Optional = None"},{name:"dataset_name",val:": Optional = None"},{name:"tags",val:": Union = None"}],parametersDescription:[{anchor:"trl.SFTTrainer.create_model_card.model_name",description:`<strong>model_name</strong> (<code>str</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The name of the model.`,name:"model_name"},{anchor:"trl.SFTTrainer.create_model_card.dataset_name",description:`<strong>dataset_name</strong> (<code>str</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The name of the dataset used for training.`,name:"dataset_name"},{anchor:"trl.SFTTrainer.create_model_card.tags",description:`<strong>tags</strong> (<code>str</code>, <code>List[str]</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Tags to be associated with the model card.`,name:"tags"}],source:"https://github.com/huggingface/trl/blob/vr_1772/trl/trainer/sft_trainer.py#L502"}}),pa=new f({props:{title:"SFTConfig",local:"trl.SFTConfig",headingTag:"h2"}}),da=new ka({props:{name:"class trl.SFTConfig",anchor:"trl.SFTConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"torch_empty_cache_steps",val:": Optional = None"},{name:"learning_rate",val:": float = 2e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Union = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"restore_callback_states_from_checkpoint",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Union = None"},{name:"deepspeed",val:": Union = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Union = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"include_for_metrics",val:": List = <factory>"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"evaluation_strategy",val:": Union = None"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"batch_eval_metrics",val:": bool = False"},{name:"eval_on_start",val:": bool = False"},{name:"use_liger_kernel",val:": Optional = False"},{name:"eval_use_gather_object",val:": Optional = False"},{name:"average_tokens_across_devices",val:": Optional = False"},{name:"dataset_text_field",val:": str = 'text'"},{name:"packing",val:": bool = False"},{name:"max_seq_length",val:": Optional = None"},{name:"dataset_num_proc",val:": Optional = None"},{name:"dataset_batch_size",val:": int = 1000"},{name:"model_init_kwargs",val:": Optional = None"},{name:"dataset_kwargs",val:": Optional = None"},{name:"eval_packing",val:": Optional = None"},{name:"num_of_sequences",val:": int = 1024"},{name:"chars_per_token",val:": float = 3.6"},{name:"use_liger",val:": bool = False"}],parametersDescription:[{anchor:"trl.SFTConfig.dataset_text_field",description:`<strong>dataset_text_field</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;text&quot;</code>) &#x2014;
Name of the text field of the dataset. If provided, the trainer will automatically create a
<code>ConstantLengthDataset</code> based on <code>dataset_text_field</code>.`,name:"dataset_text_field"},{anchor:"trl.SFTConfig.packing",description:`<strong>packing</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Controls whether the <code>ConstantLengthDataset</code> packs the sequences of the dataset.`,name:"packing"},{anchor:"trl.SFTConfig.learning_rate",description:`<strong>learning_rate</strong> (<code>float</code>, <em>optional</em>, defaults to <code>2e-5</code>) &#x2014;
Initial learning rate for <code>AdamW</code> optimizer. The default value replaces that of <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">TrainingArguments</a>.`,name:"learning_rate"},{anchor:"trl.SFTConfig.max_seq_length",description:`<strong>max_seq_length</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Maximum sequence length for the <code>ConstantLengthDataset</code> and for automatically creating the dataset. If
<code>None</code>, it uses the smaller value between <code>tokenizer.model_max_length</code> and <code>1024</code>.`,name:"max_seq_length"},{anchor:"trl.SFTConfig.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Number of processes to use for processing the dataset. Only used when <code>packing=False</code>.`,name:"dataset_num_proc"},{anchor:"trl.SFTConfig.dataset_batch_size",description:`<strong>dataset_batch_size</strong> (<code>Union[int, None]</code>, <em>optional</em>, defaults to <code>1000</code>) &#x2014;
Number of examples to tokenize per batch. If <code>dataset_batch_size &lt;= 0</code> or <code>dataset_batch_size is None</code>,
tokenizes the full dataset as a single batch.`,name:"dataset_batch_size"},{anchor:"trl.SFTConfig.model_init_kwargs",description:`<strong>model_init_kwargs</strong> (<code>Optional[Dict[str, Any]]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Keyword arguments to pass to <code>AutoModelForCausalLM.from_pretrained</code> when instantiating the model from a
string.`,name:"model_init_kwargs"},{anchor:"trl.SFTConfig.dataset_kwargs",description:`<strong>dataset_kwargs</strong> (<code>Optional[Dict[str, Any]]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Dictionary of optional keyword arguments to pass when creating packed or non-packed datasets.`,name:"dataset_kwargs"},{anchor:"trl.SFTConfig.eval_packing",description:`<strong>eval_packing</strong> (<code>Optional[bool]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Whether to pack the eval dataset. If <code>None</code>, uses the same value as <code>packing</code>.`,name:"eval_packing"},{anchor:"trl.SFTConfig.num_of_sequences",description:`<strong>num_of_sequences</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1024</code>) &#x2014;
Number of sequences to use for the <code>ConstantLengthDataset</code>.`,name:"num_of_sequences"},{anchor:"trl.SFTConfig.chars_per_token",description:`<strong>chars_per_token</strong> (<code>float</code>, <em>optional</em>, defaults to <code>3.6</code>) &#x2014;
Number of characters per token to use for the <code>ConstantLengthDataset</code>. See
<a href="https://github.com/huggingface/trl/blob/08f550674c553c36c51d1027613c29f14f3676a5/examples/stack_llama/scripts/supervised_finetuning.py#L53" rel="nofollow">chars_token_ratio</a> for more details.`,name:"chars_per_token"},{anchor:"trl.SFTConfig.use_liger",description:`<strong>use_liger</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Monkey patch the model with Liger kernels to increase throughput and reduce memory usage.`,name:"use_liger"}],source:"https://github.com/huggingface/trl/blob/vr_1772/trl/trainer/sft_config.py#L20"}}),ca=new f({props:{title:"Datasets",local:"datasets",headingTag:"h2"}}),ha=new f({props:{title:"ConstantLengthDataset",local:"trl.trainer.ConstantLengthDataset",headingTag:"h3"}}),Ma=new ka({props:{name:"class trl.trainer.ConstantLengthDataset",anchor:"trl.trainer.ConstantLengthDataset",parameters:[{name:"tokenizer",val:""},{name:"dataset",val:""},{name:"dataset_text_field",val:" = None"},{name:"formatting_func",val:" = None"},{name:"infinite",val:" = False"},{name:"seq_length",val:" = 1024"},{name:"num_of_sequences",val:" = 1024"},{name:"chars_per_token",val:" = 3.6"},{name:"eos_token_id",val:" = 0"},{name:"shuffle",val:" = True"},{name:"append_concat_token",val:" = True"},{name:"add_special_tokens",val:" = True"}],parametersDescription:[{anchor:"trl.trainer.ConstantLengthDataset.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizer</code>) &#x2014;
The processor used for processing the data.`,name:"tokenizer"},{anchor:"trl.trainer.ConstantLengthDataset.dataset",description:`<strong>dataset</strong> (<code>dataset.Dataset</code>) &#x2014;
Dataset with text files.`,name:"dataset"},{anchor:"trl.trainer.ConstantLengthDataset.dataset_text_field",description:`<strong>dataset_text_field</strong> (<code>Optional[str]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Name of the field in the dataset that contains the text. Only one of <code>dataset_text_field</code> and
<code>formatting_func</code> should be provided.`,name:"dataset_text_field"},{anchor:"trl.trainer.ConstantLengthDataset.formatting_func",description:`<strong>formatting_func</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Function that formats the text before tokenization. Usually it is recommended to have follows a certain
pattern such as <code>&quot;### Question: {question} ### Answer: {answer}&quot;</code>. Only one of <code>dataset_text_field</code> and
<code>formatting_func</code> should be provided.`,name:"formatting_func"},{anchor:"trl.trainer.ConstantLengthDataset.infinite",description:`<strong>infinite</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If True the iterator is reset after dataset reaches end else stops.`,name:"infinite"},{anchor:"trl.trainer.ConstantLengthDataset.seq_length",description:`<strong>seq_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1024</code>) &#x2014;
Length of token sequences to return.`,name:"seq_length"},{anchor:"trl.trainer.ConstantLengthDataset.num_of_sequences",description:`<strong>num_of_sequences</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1024</code>) &#x2014;
Number of token sequences to keep in buffer.`,name:"num_of_sequences"},{anchor:"trl.trainer.ConstantLengthDataset.chars_per_token",description:`<strong>chars_per_token</strong> (<code>int</code>, <em>optional</em>, defaults to <code>3.6</code>) &#x2014;
Number of characters per token used to estimate number of tokens in text buffer.`,name:"chars_per_token"},{anchor:"trl.trainer.ConstantLengthDataset.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to <code>0</code>) &#x2014;
Id of the end of sequence token if the passed tokenizer does not have an EOS token.`,name:"eos_token_id"},{anchor:"trl.trainer.ConstantLengthDataset.shuffle",description:`<strong>shuffle</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Shuffle the examples before they are returned`,name:"shuffle"},{anchor:"trl.trainer.ConstantLengthDataset.append_concat_token",description:`<strong>append_concat_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If true, appends <code>eos_token_id</code> at the end of each sample being packed.`,name:"append_concat_token"},{anchor:"trl.trainer.ConstantLengthDataset.add_special_tokens",description:`<strong>add_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If true, tokenizers adds special tokens to each sample being packed.`,name:"add_special_tokens"}],source:"https://github.com/huggingface/trl/blob/vr_1772/trl/trainer/utils.py#L542"}}),fa=new Ui({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/sft_trainer.mdx"}}),{c(){b=o("meta"),Fa=l(),Ca=o("p"),xa=l(),p(F.$$.fragment),$a=l(),x=o("p"),x.innerHTML=Bs,Ga=l(),$=o("p"),$.textContent=Ns,Za=l(),G=o("p"),G.innerHTML=qs,Ba=l(),p(Z.$$.fragment),Na=l(),B=o("p"),B.innerHTML=Rs,qa=l(),p(N.$$.fragment),Ra=l(),q=o("p"),q.innerHTML=As,Aa=l(),R=o("p"),R.textContent=Es,Ea=l(),p(A.$$.fragment),Wa=l(),E=o("p"),E.innerHTML=Ws,Xa=l(),p(W.$$.fragment),Sa=l(),p(X.$$.fragment),za=l(),S=o("p"),S.innerHTML=Xs,Qa=l(),p(z.$$.fragment),Va=l(),Q=o("p"),Q.innerHTML=Ss,Ha=l(),p(V.$$.fragment),La=l(),H=o("p"),H.innerHTML=zs,Ya=l(),p(L.$$.fragment),Da=l(),Y=o("p"),Y.innerHTML=Qs,Pa=l(),p(D.$$.fragment),Oa=l(),P=o("p"),P.innerHTML=Vs,Ka=l(),O=o("ul"),O.innerHTML=Hs,tn=l(),K=o("p"),K.innerHTML=Ls,en=l(),p(tt.$$.fragment),an=l(),et=o("p"),et.innerHTML=Ys,nn=l(),p(at.$$.fragment),ln=l(),p(nt.$$.fragment),sn=l(),lt=o("p"),lt.innerHTML=Ds,on=l(),st=o("ul"),st.innerHTML=Ps,rn=l(),p(ot.$$.fragment),pn=l(),it=o("p"),it.textContent=Os,dn=l(),p(rt.$$.fragment),cn=l(),pt=o("p"),pt.innerHTML=Ks,mn=l(),dt=o("ul"),dt.innerHTML=to,un=l(),p(ct.$$.fragment),hn=l(),mt=o("ul"),mt.innerHTML=eo,Mn=l(),p(ut.$$.fragment),fn=l(),ht=o("p"),ht.innerHTML=ao,yn=l(),p(Mt.$$.fragment),Tn=l(),ft=o("p"),ft.textContent=no,gn=l(),p(yt.$$.fragment),wn=l(),Tt=o("p"),Tt.innerHTML=lo,Jn=l(),p(gt.$$.fragment),_n=l(),wt=o("p"),wt.innerHTML=so,bn=l(),p(Jt.$$.fragment),Un=l(),_t=o("p"),_t.innerHTML=oo,jn=l(),p(bt.$$.fragment),vn=l(),Ut=o("p"),Ut.innerHTML=io,Cn=l(),p(jt.$$.fragment),In=l(),vt=o("p"),vt.innerHTML=ro,kn=l(),p(Ct.$$.fragment),Fn=l(),It=o("p"),It.innerHTML=po,xn=l(),p(kt.$$.fragment),$n=l(),Ft=o("p"),Ft.innerHTML=co,Gn=l(),p(xt.$$.fragment),Zn=l(),$t=o("p"),$t.innerHTML=mo,Bn=l(),p(Gt.$$.fragment),Nn=l(),Zt=o("p"),Zt.innerHTML=uo,qn=l(),p(Bt.$$.fragment),Rn=l(),Nt=o("p"),Nt.textContent=ho,An=l(),p(qt.$$.fragment),En=l(),Rt=o("p"),Rt.innerHTML=Mo,Wn=l(),p(At.$$.fragment),Xn=l(),Et=o("p"),Et.innerHTML=fo,Sn=l(),p(Wt.$$.fragment),zn=l(),p(Xt.$$.fragment),Qn=l(),St=o("p"),St.textContent=yo,Vn=l(),p(zt.$$.fragment),Hn=l(),Qt=o("p"),Qt.textContent=To,Ln=l(),p(Vt.$$.fragment),Yn=l(),Ht=o("p"),Ht.innerHTML=go,Dn=l(),p(Lt.$$.fragment),Pn=l(),Yt=o("p"),Yt.innerHTML=wo,On=l(),p(Dt.$$.fragment),Kn=l(),Pt=o("p"),Pt.innerHTML=Jo,tl=l(),Ot=o("p"),Ot.textContent=_o,el=l(),Kt=o("table"),Kt.innerHTML=bo,al=l(),p(te.$$.fragment),nl=l(),ee=o("p"),ee.innerHTML=Uo,ll=l(),p(ae.$$.fragment),sl=l(),ne=o("p"),ne.innerHTML=jo,ol=l(),p(le.$$.fragment),il=l(),se=o("p"),se.textContent=vo,rl=l(),oe=o("p"),oe.textContent=Co,pl=l(),p(ie.$$.fragment),dl=l(),re=o("p"),re.textContent=Io,cl=l(),g=o("div"),p(pe.$$.fragment),vs=l(),ya=o("p"),ya.textContent=ko,Cs=l(),Ta=o("p"),Ta.innerHTML=Fo,ml=l(),p(de.$$.fragment),ul=l(),p(ce.$$.fragment),hl=l(),me=o("p"),me.innerHTML=xo,Ml=l(),ue=o("blockquote"),ue.innerHTML=$o,fl=l(),j=o("div"),j.innerHTML=Go,yl=l(),he=o("p"),he.innerHTML=Zo,Tl=l(),p(Me.$$.fragment),gl=l(),fe=o("p"),fe.innerHTML=Bo,wl=l(),v=o("div"),v.innerHTML=No,Jl=l(),ye=o("p"),ye.innerHTML=qo,_l=l(),p(Te.$$.fragment),bl=l(),ge=o("p"),ge.innerHTML=Ro,Ul=l(),we=o("table"),we.innerHTML=Ao,jl=l(),Je=o("p"),Je.innerHTML=Eo,vl=l(),p(_e.$$.fragment),Cl=l(),be=o("p"),be.innerHTML=Wo,Il=l(),p(Ue.$$.fragment),kl=l(),je=o("p"),je.innerHTML=Xo,Fl=l(),ve=o("p"),ve.textContent=So,xl=l(),Ce=o("table"),Ce.innerHTML=zo,$l=l(),Ie=o("ol"),Ie.innerHTML=Qo,Gl=l(),p(ke.$$.fragment),Zl=l(),C=o("ol"),C.innerHTML=Vo,Bl=l(),p(Fe.$$.fragment),Nl=l(),xe=o("p"),xe.innerHTML=Ho,ql=l(),p($e.$$.fragment),Rl=l(),Ge=o("p"),Ge.textContent=Lo,Al=l(),Ze=o("ul"),Ze.innerHTML=Yo,El=l(),p(Be.$$.fragment),Wl=l(),Ne=o("p"),Ne.innerHTML=Do,Xl=l(),qe=o("ul"),qe.innerHTML=Po,Sl=l(),p(Re.$$.fragment),zl=l(),p(Ae.$$.fragment),Ql=l(),Ee=o("p"),Ee.innerHTML=Oo,Vl=l(),p(We.$$.fragment),Hl=l(),Xe=o("p"),Xe.innerHTML=Ko,Ll=l(),p(Se.$$.fragment),Yl=l(),ze=o("p"),ze.textContent=ti,Dl=l(),p(Qe.$$.fragment),Pl=l(),Ve=o("p"),Ve.textContent=ei,Ol=l(),p(He.$$.fragment),Kl=l(),Le=o("p"),Le.textContent=ai,ts=l(),p(Ye.$$.fragment),es=l(),_=o("iframe"),as=l(),p(De.$$.fragment),ns=l(),Pe=o("p"),Pe.innerHTML=li,ls=l(),p(Oe.$$.fragment),ss=l(),Ke=o("p"),Ke.textContent=si,os=l(),p(ta.$$.fragment),is=l(),p(ea.$$.fragment),rs=l(),aa=o("p"),aa.innerHTML=oi,ps=l(),p(na.$$.fragment),ds=l(),la=o("p"),la.innerHTML=ii,cs=l(),sa=o("ul"),sa.innerHTML=ri,ms=l(),p(oa.$$.fragment),us=l(),w=o("div"),p(ia.$$.fragment),Is=l(),ga=o("p"),ga.innerHTML=pi,ks=l(),I=o("div"),p(ra.$$.fragment),Fs=l(),wa=o("p"),wa.innerHTML=di,hs=l(),p(pa.$$.fragment),Ms=l(),J=o("div"),p(da.$$.fragment),xs=l(),Ja=o("p"),Ja.innerHTML=ci,$s=l(),_a=o("p"),_a.innerHTML=mi,fs=l(),p(ca.$$.fragment),ys=l(),ma=o("p"),ma.innerHTML=ui,Ts=l(),ua=o("p"),ua.innerHTML=hi,gs=l(),p(ha.$$.fragment),ws=l(),U=o("div"),p(Ma.$$.fragment),Gs=l(),ba=o("p"),ba.textContent=Mi,Js=l(),p(fa.$$.fragment),_s=l(),Ia=o("p"),this.h()},l(t){const e=bi("svelte-u9bgzb",document.head);b=i(e,"META",{name:!0,content:!0}),e.forEach(a),Fa=s(t),Ca=i(t,"P",{}),k(Ca).forEach(a),xa=s(t),d(F.$$.fragment,t),$a=s(t),x=i(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-hpmjx0"&&(x.innerHTML=Bs),Ga=s(t),$=i(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-o839x3"&&($.textContent=Ns),Za=s(t),G=i(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1lsssrb"&&(G.innerHTML=qs),Ba=s(t),d(Z.$$.fragment,t),Na=s(t),B=i(t,"P",{"data-svelte-h":!0}),r(B)!=="svelte-syrqsz"&&(B.innerHTML=Rs),qa=s(t),d(N.$$.fragment,t),Ra=s(t),q=i(t,"P",{"data-svelte-h":!0}),r(q)!=="svelte-4l7u4"&&(q.innerHTML=As),Aa=s(t),R=i(t,"P",{"data-svelte-h":!0}),r(R)!=="svelte-ulikv8"&&(R.textContent=Es),Ea=s(t),d(A.$$.fragment,t),Wa=s(t),E=i(t,"P",{"data-svelte-h":!0}),r(E)!=="svelte-74zptc"&&(E.innerHTML=Ws),Xa=s(t),d(W.$$.fragment,t),Sa=s(t),d(X.$$.fragment,t),za=s(t),S=i(t,"P",{"data-svelte-h":!0}),r(S)!=="svelte-13sbeoj"&&(S.innerHTML=Xs),Qa=s(t),d(z.$$.fragment,t),Va=s(t),Q=i(t,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1a743rp"&&(Q.innerHTML=Ss),Ha=s(t),d(V.$$.fragment,t),La=s(t),H=i(t,"P",{"data-svelte-h":!0}),r(H)!=="svelte-rjhq4r"&&(H.innerHTML=zs),Ya=s(t),d(L.$$.fragment,t),Da=s(t),Y=i(t,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-12zdtxn"&&(Y.innerHTML=Qs),Pa=s(t),d(D.$$.fragment,t),Oa=s(t),P=i(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-xlwe87"&&(P.innerHTML=Vs),Ka=s(t),O=i(t,"UL",{"data-svelte-h":!0}),r(O)!=="svelte-1enki0k"&&(O.innerHTML=Hs),tn=s(t),K=i(t,"P",{"data-svelte-h":!0}),r(K)!=="svelte-14yxh0m"&&(K.innerHTML=Ls),en=s(t),d(tt.$$.fragment,t),an=s(t),et=i(t,"P",{"data-svelte-h":!0}),r(et)!=="svelte-hvnyie"&&(et.innerHTML=Ys),nn=s(t),d(at.$$.fragment,t),ln=s(t),d(nt.$$.fragment,t),sn=s(t),lt=i(t,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-1ccg0zx"&&(lt.innerHTML=Ds),on=s(t),st=i(t,"UL",{"data-svelte-h":!0}),r(st)!=="svelte-ebt5re"&&(st.innerHTML=Ps),rn=s(t),d(ot.$$.fragment,t),pn=s(t),it=i(t,"P",{"data-svelte-h":!0}),r(it)!=="svelte-1hmfl2q"&&(it.textContent=Os),dn=s(t),d(rt.$$.fragment,t),cn=s(t),pt=i(t,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-1lkqmby"&&(pt.innerHTML=Ks),mn=s(t),dt=i(t,"UL",{"data-svelte-h":!0}),r(dt)!=="svelte-5iwuvk"&&(dt.innerHTML=to),un=s(t),d(ct.$$.fragment,t),hn=s(t),mt=i(t,"UL",{"data-svelte-h":!0}),r(mt)!=="svelte-23l1e6"&&(mt.innerHTML=eo),Mn=s(t),d(ut.$$.fragment,t),fn=s(t),ht=i(t,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-eewt56"&&(ht.innerHTML=ao),yn=s(t),d(Mt.$$.fragment,t),Tn=s(t),ft=i(t,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-145h0zs"&&(ft.textContent=no),gn=s(t),d(yt.$$.fragment,t),wn=s(t),Tt=i(t,"P",{"data-svelte-h":!0}),r(Tt)!=="svelte-cqsf2h"&&(Tt.innerHTML=lo),Jn=s(t),d(gt.$$.fragment,t),_n=s(t),wt=i(t,"P",{"data-svelte-h":!0}),r(wt)!=="svelte-l25vq0"&&(wt.innerHTML=so),bn=s(t),d(Jt.$$.fragment,t),Un=s(t),_t=i(t,"P",{"data-svelte-h":!0}),r(_t)!=="svelte-j2xlt3"&&(_t.innerHTML=oo),jn=s(t),d(bt.$$.fragment,t),vn=s(t),Ut=i(t,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-ygxruy"&&(Ut.innerHTML=io),Cn=s(t),d(jt.$$.fragment,t),In=s(t),vt=i(t,"P",{"data-svelte-h":!0}),r(vt)!=="svelte-t5o0mn"&&(vt.innerHTML=ro),kn=s(t),d(Ct.$$.fragment,t),Fn=s(t),It=i(t,"P",{"data-svelte-h":!0}),r(It)!=="svelte-iejqw3"&&(It.innerHTML=po),xn=s(t),d(kt.$$.fragment,t),$n=s(t),Ft=i(t,"P",{"data-svelte-h":!0}),r(Ft)!=="svelte-yt3pkz"&&(Ft.innerHTML=co),Gn=s(t),d(xt.$$.fragment,t),Zn=s(t),$t=i(t,"P",{"data-svelte-h":!0}),r($t)!=="svelte-1314v3f"&&($t.innerHTML=mo),Bn=s(t),d(Gt.$$.fragment,t),Nn=s(t),Zt=i(t,"P",{"data-svelte-h":!0}),r(Zt)!=="svelte-1su7aih"&&(Zt.innerHTML=uo),qn=s(t),d(Bt.$$.fragment,t),Rn=s(t),Nt=i(t,"P",{"data-svelte-h":!0}),r(Nt)!=="svelte-9vpjkk"&&(Nt.textContent=ho),An=s(t),d(qt.$$.fragment,t),En=s(t),Rt=i(t,"P",{"data-svelte-h":!0}),r(Rt)!=="svelte-pwdaav"&&(Rt.innerHTML=Mo),Wn=s(t),d(At.$$.fragment,t),Xn=s(t),Et=i(t,"P",{"data-svelte-h":!0}),r(Et)!=="svelte-11pydf"&&(Et.innerHTML=fo),Sn=s(t),d(Wt.$$.fragment,t),zn=s(t),d(Xt.$$.fragment,t),Qn=s(t),St=i(t,"P",{"data-svelte-h":!0}),r(St)!=="svelte-fyvvsj"&&(St.textContent=yo),Vn=s(t),d(zt.$$.fragment,t),Hn=s(t),Qt=i(t,"P",{"data-svelte-h":!0}),r(Qt)!=="svelte-yypgof"&&(Qt.textContent=To),Ln=s(t),d(Vt.$$.fragment,t),Yn=s(t),Ht=i(t,"P",{"data-svelte-h":!0}),r(Ht)!=="svelte-yugu96"&&(Ht.innerHTML=go),Dn=s(t),d(Lt.$$.fragment,t),Pn=s(t),Yt=i(t,"P",{"data-svelte-h":!0}),r(Yt)!=="svelte-1qms4cl"&&(Yt.innerHTML=wo),On=s(t),d(Dt.$$.fragment,t),Kn=s(t),Pt=i(t,"P",{"data-svelte-h":!0}),r(Pt)!=="svelte-qe5zfz"&&(Pt.innerHTML=Jo),tl=s(t),Ot=i(t,"P",{"data-svelte-h":!0}),r(Ot)!=="svelte-69u1rz"&&(Ot.textContent=_o),el=s(t),Kt=i(t,"TABLE",{"data-svelte-h":!0}),r(Kt)!=="svelte-8fq96j"&&(Kt.innerHTML=bo),al=s(t),d(te.$$.fragment,t),nl=s(t),ee=i(t,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1rqlm78"&&(ee.innerHTML=Uo),ll=s(t),d(ae.$$.fragment,t),sl=s(t),ne=i(t,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-14s96xo"&&(ne.innerHTML=jo),ol=s(t),d(le.$$.fragment,t),il=s(t),se=i(t,"P",{"data-svelte-h":!0}),r(se)!=="svelte-vfpk19"&&(se.textContent=vo),rl=s(t),oe=i(t,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-162zeem"&&(oe.textContent=Co),pl=s(t),d(ie.$$.fragment,t),dl=s(t),re=i(t,"P",{"data-svelte-h":!0}),r(re)!=="svelte-u9yx96"&&(re.textContent=Io),cl=s(t),g=i(t,"DIV",{class:!0});var Ua=k(g);d(pe.$$.fragment,Ua),vs=s(Ua),ya=i(Ua,"P",{"data-svelte-h":!0}),r(ya)!=="svelte-21rjm6"&&(ya.textContent=ko),Cs=s(Ua),Ta=i(Ua,"P",{"data-svelte-h":!0}),r(Ta)!=="svelte-ekuf1t"&&(Ta.innerHTML=Fo),Ua.forEach(a),ml=s(t),d(de.$$.fragment,t),ul=s(t),d(ce.$$.fragment,t),hl=s(t),me=i(t,"P",{"data-svelte-h":!0}),r(me)!=="svelte-8q8jbt"&&(me.innerHTML=xo),Ml=s(t),ue=i(t,"BLOCKQUOTE",{"data-svelte-h":!0}),r(ue)!=="svelte-1ejl1pl"&&(ue.innerHTML=$o),fl=s(t),j=i(t,"DIV",{style:!0,"data-svelte-h":!0}),r(j)!=="svelte-1wkjgyb"&&(j.innerHTML=Go),yl=s(t),he=i(t,"P",{"data-svelte-h":!0}),r(he)!=="svelte-15c39pv"&&(he.innerHTML=Zo),Tl=s(t),d(Me.$$.fragment,t),gl=s(t),fe=i(t,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-sqj12"&&(fe.innerHTML=Bo),wl=s(t),v=i(t,"DIV",{style:!0,"data-svelte-h":!0}),r(v)!=="svelte-a1m5gi"&&(v.innerHTML=No),Jl=s(t),ye=i(t,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-rwofnh"&&(ye.innerHTML=qo),_l=s(t),d(Te.$$.fragment,t),bl=s(t),ge=i(t,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1q1m1nw"&&(ge.innerHTML=Ro),Ul=s(t),we=i(t,"TABLE",{"data-svelte-h":!0}),r(we)!=="svelte-lj2wpp"&&(we.innerHTML=Ao),jl=s(t),Je=i(t,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1p74c9x"&&(Je.innerHTML=Eo),vl=s(t),d(_e.$$.fragment,t),Cl=s(t),be=i(t,"P",{"data-svelte-h":!0}),r(be)!=="svelte-1o18rwj"&&(be.innerHTML=Wo),Il=s(t),d(Ue.$$.fragment,t),kl=s(t),je=i(t,"P",{"data-svelte-h":!0}),r(je)!=="svelte-1tpy3c1"&&(je.innerHTML=Xo),Fl=s(t),ve=i(t,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-wsouej"&&(ve.textContent=So),xl=s(t),Ce=i(t,"TABLE",{"data-svelte-h":!0}),r(Ce)!=="svelte-1jpb79"&&(Ce.innerHTML=zo),$l=s(t),Ie=i(t,"OL",{"data-svelte-h":!0}),r(Ie)!=="svelte-10hwsos"&&(Ie.innerHTML=Qo),Gl=s(t),d(ke.$$.fragment,t),Zl=s(t),C=i(t,"OL",{start:!0,"data-svelte-h":!0}),r(C)!=="svelte-1fon54"&&(C.innerHTML=Vo),Bl=s(t),d(Fe.$$.fragment,t),Nl=s(t),xe=i(t,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-1h5mxii"&&(xe.innerHTML=Ho),ql=s(t),d($e.$$.fragment,t),Rl=s(t),Ge=i(t,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-g801h1"&&(Ge.textContent=Lo),Al=s(t),Ze=i(t,"UL",{"data-svelte-h":!0}),r(Ze)!=="svelte-32v8yp"&&(Ze.innerHTML=Yo),El=s(t),d(Be.$$.fragment,t),Wl=s(t),Ne=i(t,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-s3xf41"&&(Ne.innerHTML=Do),Xl=s(t),qe=i(t,"UL",{"data-svelte-h":!0}),r(qe)!=="svelte-19jsxq"&&(qe.innerHTML=Po),Sl=s(t),d(Re.$$.fragment,t),zl=s(t),d(Ae.$$.fragment,t),Ql=s(t),Ee=i(t,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-xofzi2"&&(Ee.innerHTML=Oo),Vl=s(t),d(We.$$.fragment,t),Hl=s(t),Xe=i(t,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-gz974t"&&(Xe.innerHTML=Ko),Ll=s(t),d(Se.$$.fragment,t),Yl=s(t),ze=i(t,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-58v4pe"&&(ze.textContent=ti),Dl=s(t),d(Qe.$$.fragment,t),Pl=s(t),Ve=i(t,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-1i9g14v"&&(Ve.textContent=ei),Ol=s(t),d(He.$$.fragment,t),Kl=s(t),Le=i(t,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-aegjvb"&&(Le.textContent=ai),ts=s(t),d(Ye.$$.fragment,t),es=s(t),_=i(t,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),k(_).forEach(a),as=s(t),d(De.$$.fragment,t),ns=s(t),Pe=i(t,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-1y2dzof"&&(Pe.innerHTML=li),ls=s(t),d(Oe.$$.fragment,t),ss=s(t),Ke=i(t,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-ezw63w"&&(Ke.textContent=si),os=s(t),d(ta.$$.fragment,t),is=s(t),d(ea.$$.fragment,t),rs=s(t),aa=i(t,"P",{"data-svelte-h":!0}),r(aa)!=="svelte-yvalkp"&&(aa.innerHTML=oi),ps=s(t),d(na.$$.fragment,t),ds=s(t),la=i(t,"P",{"data-svelte-h":!0}),r(la)!=="svelte-bk6pmc"&&(la.innerHTML=ii),cs=s(t),sa=i(t,"UL",{"data-svelte-h":!0}),r(sa)!=="svelte-ata0nu"&&(sa.innerHTML=ri),ms=s(t),d(oa.$$.fragment,t),us=s(t),w=i(t,"DIV",{class:!0});var ja=k(w);d(ia.$$.fragment,ja),Is=s(ja),ga=i(ja,"P",{"data-svelte-h":!0}),r(ga)!=="svelte-14oyph8"&&(ga.innerHTML=pi),ks=s(ja),I=i(ja,"DIV",{class:!0});var Us=k(I);d(ra.$$.fragment,Us),Fs=s(Us),wa=i(Us,"P",{"data-svelte-h":!0}),r(wa)!=="svelte-1mh859w"&&(wa.innerHTML=di),Us.forEach(a),ja.forEach(a),hs=s(t),d(pa.$$.fragment,t),Ms=s(t),J=i(t,"DIV",{class:!0});var va=k(J);d(da.$$.fragment,va),xs=s(va),Ja=i(va,"P",{"data-svelte-h":!0}),r(Ja)!=="svelte-7z1xa8"&&(Ja.innerHTML=ci),$s=s(va),_a=i(va,"P",{"data-svelte-h":!0}),r(_a)!=="svelte-ekuf1t"&&(_a.innerHTML=mi),va.forEach(a),fs=s(t),d(ca.$$.fragment,t),ys=s(t),ma=i(t,"P",{"data-svelte-h":!0}),r(ma)!=="svelte-16l6c3u"&&(ma.innerHTML=ui),Ts=s(t),ua=i(t,"P",{"data-svelte-h":!0}),r(ua)!=="svelte-k5kqyl"&&(ua.innerHTML=hi),gs=s(t),d(ha.$$.fragment,t),ws=s(t),U=i(t,"DIV",{class:!0});var js=k(U);d(Ma.$$.fragment,js),Gs=s(js),ba=i(js,"P",{"data-svelte-h":!0}),r(ba)!=="svelte-1dlriq1"&&(ba.textContent=Mi),js.forEach(a),Js=s(t),d(fa.$$.fragment,t),_s=s(t),Ia=i(t,"P",{}),k(Ia).forEach(a),this.h()},h(){T(b,"name","hf:doc:metadata"),T(b,"content",vi),T(g,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),fi(j,"text-align","center"),fi(v,"text-align","center"),T(C,"start","2"),Ti(_.src,ni="https://huggingface.co/datasets/HuggingFaceH4/llava-instruct-mix-vsft/embed/viewer/default/train")||T(_,"src",ni),T(_,"frameborder","0"),T(_,"width","100%"),T(_,"height","560px"),T(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,e){y(document.head,b),n(t,Fa,e),n(t,Ca,e),n(t,xa,e),c(F,t,e),n(t,$a,e),n(t,x,e),n(t,Ga,e),n(t,$,e),n(t,Za,e),n(t,G,e),n(t,Ba,e),c(Z,t,e),n(t,Na,e),n(t,B,e),n(t,qa,e),c(N,t,e),n(t,Ra,e),n(t,q,e),n(t,Aa,e),n(t,R,e),n(t,Ea,e),c(A,t,e),n(t,Wa,e),n(t,E,e),n(t,Xa,e),c(W,t,e),n(t,Sa,e),c(X,t,e),n(t,za,e),n(t,S,e),n(t,Qa,e),c(z,t,e),n(t,Va,e),n(t,Q,e),n(t,Ha,e),c(V,t,e),n(t,La,e),n(t,H,e),n(t,Ya,e),c(L,t,e),n(t,Da,e),n(t,Y,e),n(t,Pa,e),c(D,t,e),n(t,Oa,e),n(t,P,e),n(t,Ka,e),n(t,O,e),n(t,tn,e),n(t,K,e),n(t,en,e),c(tt,t,e),n(t,an,e),n(t,et,e),n(t,nn,e),c(at,t,e),n(t,ln,e),c(nt,t,e),n(t,sn,e),n(t,lt,e),n(t,on,e),n(t,st,e),n(t,rn,e),c(ot,t,e),n(t,pn,e),n(t,it,e),n(t,dn,e),c(rt,t,e),n(t,cn,e),n(t,pt,e),n(t,mn,e),n(t,dt,e),n(t,un,e),c(ct,t,e),n(t,hn,e),n(t,mt,e),n(t,Mn,e),c(ut,t,e),n(t,fn,e),n(t,ht,e),n(t,yn,e),c(Mt,t,e),n(t,Tn,e),n(t,ft,e),n(t,gn,e),c(yt,t,e),n(t,wn,e),n(t,Tt,e),n(t,Jn,e),c(gt,t,e),n(t,_n,e),n(t,wt,e),n(t,bn,e),c(Jt,t,e),n(t,Un,e),n(t,_t,e),n(t,jn,e),c(bt,t,e),n(t,vn,e),n(t,Ut,e),n(t,Cn,e),c(jt,t,e),n(t,In,e),n(t,vt,e),n(t,kn,e),c(Ct,t,e),n(t,Fn,e),n(t,It,e),n(t,xn,e),c(kt,t,e),n(t,$n,e),n(t,Ft,e),n(t,Gn,e),c(xt,t,e),n(t,Zn,e),n(t,$t,e),n(t,Bn,e),c(Gt,t,e),n(t,Nn,e),n(t,Zt,e),n(t,qn,e),c(Bt,t,e),n(t,Rn,e),n(t,Nt,e),n(t,An,e),c(qt,t,e),n(t,En,e),n(t,Rt,e),n(t,Wn,e),c(At,t,e),n(t,Xn,e),n(t,Et,e),n(t,Sn,e),c(Wt,t,e),n(t,zn,e),c(Xt,t,e),n(t,Qn,e),n(t,St,e),n(t,Vn,e),c(zt,t,e),n(t,Hn,e),n(t,Qt,e),n(t,Ln,e),c(Vt,t,e),n(t,Yn,e),n(t,Ht,e),n(t,Dn,e),c(Lt,t,e),n(t,Pn,e),n(t,Yt,e),n(t,On,e),c(Dt,t,e),n(t,Kn,e),n(t,Pt,e),n(t,tl,e),n(t,Ot,e),n(t,el,e),n(t,Kt,e),n(t,al,e),c(te,t,e),n(t,nl,e),n(t,ee,e),n(t,ll,e),c(ae,t,e),n(t,sl,e),n(t,ne,e),n(t,ol,e),c(le,t,e),n(t,il,e),n(t,se,e),n(t,rl,e),n(t,oe,e),n(t,pl,e),c(ie,t,e),n(t,dl,e),n(t,re,e),n(t,cl,e),n(t,g,e),c(pe,g,null),y(g,vs),y(g,ya),y(g,Cs),y(g,Ta),n(t,ml,e),c(de,t,e),n(t,ul,e),c(ce,t,e),n(t,hl,e),n(t,me,e),n(t,Ml,e),n(t,ue,e),n(t,fl,e),n(t,j,e),n(t,yl,e),n(t,he,e),n(t,Tl,e),c(Me,t,e),n(t,gl,e),n(t,fe,e),n(t,wl,e),n(t,v,e),n(t,Jl,e),n(t,ye,e),n(t,_l,e),c(Te,t,e),n(t,bl,e),n(t,ge,e),n(t,Ul,e),n(t,we,e),n(t,jl,e),n(t,Je,e),n(t,vl,e),c(_e,t,e),n(t,Cl,e),n(t,be,e),n(t,Il,e),c(Ue,t,e),n(t,kl,e),n(t,je,e),n(t,Fl,e),n(t,ve,e),n(t,xl,e),n(t,Ce,e),n(t,$l,e),n(t,Ie,e),n(t,Gl,e),c(ke,t,e),n(t,Zl,e),n(t,C,e),n(t,Bl,e),c(Fe,t,e),n(t,Nl,e),n(t,xe,e),n(t,ql,e),c($e,t,e),n(t,Rl,e),n(t,Ge,e),n(t,Al,e),n(t,Ze,e),n(t,El,e),c(Be,t,e),n(t,Wl,e),n(t,Ne,e),n(t,Xl,e),n(t,qe,e),n(t,Sl,e),c(Re,t,e),n(t,zl,e),c(Ae,t,e),n(t,Ql,e),n(t,Ee,e),n(t,Vl,e),c(We,t,e),n(t,Hl,e),n(t,Xe,e),n(t,Ll,e),c(Se,t,e),n(t,Yl,e),n(t,ze,e),n(t,Dl,e),c(Qe,t,e),n(t,Pl,e),n(t,Ve,e),n(t,Ol,e),c(He,t,e),n(t,Kl,e),n(t,Le,e),n(t,ts,e),c(Ye,t,e),n(t,es,e),n(t,_,e),n(t,as,e),c(De,t,e),n(t,ns,e),n(t,Pe,e),n(t,ls,e),c(Oe,t,e),n(t,ss,e),n(t,Ke,e),n(t,os,e),c(ta,t,e),n(t,is,e),c(ea,t,e),n(t,rs,e),n(t,aa,e),n(t,ps,e),c(na,t,e),n(t,ds,e),n(t,la,e),n(t,cs,e),n(t,sa,e),n(t,ms,e),c(oa,t,e),n(t,us,e),n(t,w,e),c(ia,w,null),y(w,Is),y(w,ga),y(w,ks),y(w,I),c(ra,I,null),y(I,Fs),y(I,wa),n(t,hs,e),c(pa,t,e),n(t,Ms,e),n(t,J,e),c(da,J,null),y(J,xs),y(J,Ja),y(J,$s),y(J,_a),n(t,fs,e),c(ca,t,e),n(t,ys,e),n(t,ma,e),n(t,Ts,e),n(t,ua,e),n(t,gs,e),c(ha,t,e),n(t,ws,e),n(t,U,e),c(Ma,U,null),y(U,Gs),y(U,ba),n(t,Js,e),c(fa,t,e),n(t,_s,e),n(t,Ia,e),bs=!0},p:gi,i(t){bs||(m(F.$$.fragment,t),m(Z.$$.fragment,t),m(N.$$.fragment,t),m(A.$$.fragment,t),m(W.$$.fragment,t),m(X.$$.fragment,t),m(z.$$.fragment,t),m(V.$$.fragment,t),m(L.$$.fragment,t),m(D.$$.fragment,t),m(tt.$$.fragment,t),m(at.$$.fragment,t),m(nt.$$.fragment,t),m(ot.$$.fragment,t),m(rt.$$.fragment,t),m(ct.$$.fragment,t),m(ut.$$.fragment,t),m(Mt.$$.fragment,t),m(yt.$$.fragment,t),m(gt.$$.fragment,t),m(Jt.$$.fragment,t),m(bt.$$.fragment,t),m(jt.$$.fragment,t),m(Ct.$$.fragment,t),m(kt.$$.fragment,t),m(xt.$$.fragment,t),m(Gt.$$.fragment,t),m(Bt.$$.fragment,t),m(qt.$$.fragment,t),m(At.$$.fragment,t),m(Wt.$$.fragment,t),m(Xt.$$.fragment,t),m(zt.$$.fragment,t),m(Vt.$$.fragment,t),m(Lt.$$.fragment,t),m(Dt.$$.fragment,t),m(te.$$.fragment,t),m(ae.$$.fragment,t),m(le.$$.fragment,t),m(ie.$$.fragment,t),m(pe.$$.fragment,t),m(de.$$.fragment,t),m(ce.$$.fragment,t),m(Me.$$.fragment,t),m(Te.$$.fragment,t),m(_e.$$.fragment,t),m(Ue.$$.fragment,t),m(ke.$$.fragment,t),m(Fe.$$.fragment,t),m($e.$$.fragment,t),m(Be.$$.fragment,t),m(Re.$$.fragment,t),m(Ae.$$.fragment,t),m(We.$$.fragment,t),m(Se.$$.fragment,t),m(Qe.$$.fragment,t),m(He.$$.fragment,t),m(Ye.$$.fragment,t),m(De.$$.fragment,t),m(Oe.$$.fragment,t),m(ta.$$.fragment,t),m(ea.$$.fragment,t),m(na.$$.fragment,t),m(oa.$$.fragment,t),m(ia.$$.fragment,t),m(ra.$$.fragment,t),m(pa.$$.fragment,t),m(da.$$.fragment,t),m(ca.$$.fragment,t),m(ha.$$.fragment,t),m(Ma.$$.fragment,t),m(fa.$$.fragment,t),bs=!0)},o(t){u(F.$$.fragment,t),u(Z.$$.fragment,t),u(N.$$.fragment,t),u(A.$$.fragment,t),u(W.$$.fragment,t),u(X.$$.fragment,t),u(z.$$.fragment,t),u(V.$$.fragment,t),u(L.$$.fragment,t),u(D.$$.fragment,t),u(tt.$$.fragment,t),u(at.$$.fragment,t),u(nt.$$.fragment,t),u(ot.$$.fragment,t),u(rt.$$.fragment,t),u(ct.$$.fragment,t),u(ut.$$.fragment,t),u(Mt.$$.fragment,t),u(yt.$$.fragment,t),u(gt.$$.fragment,t),u(Jt.$$.fragment,t),u(bt.$$.fragment,t),u(jt.$$.fragment,t),u(Ct.$$.fragment,t),u(kt.$$.fragment,t),u(xt.$$.fragment,t),u(Gt.$$.fragment,t),u(Bt.$$.fragment,t),u(qt.$$.fragment,t),u(At.$$.fragment,t),u(Wt.$$.fragment,t),u(Xt.$$.fragment,t),u(zt.$$.fragment,t),u(Vt.$$.fragment,t),u(Lt.$$.fragment,t),u(Dt.$$.fragment,t),u(te.$$.fragment,t),u(ae.$$.fragment,t),u(le.$$.fragment,t),u(ie.$$.fragment,t),u(pe.$$.fragment,t),u(de.$$.fragment,t),u(ce.$$.fragment,t),u(Me.$$.fragment,t),u(Te.$$.fragment,t),u(_e.$$.fragment,t),u(Ue.$$.fragment,t),u(ke.$$.fragment,t),u(Fe.$$.fragment,t),u($e.$$.fragment,t),u(Be.$$.fragment,t),u(Re.$$.fragment,t),u(Ae.$$.fragment,t),u(We.$$.fragment,t),u(Se.$$.fragment,t),u(Qe.$$.fragment,t),u(He.$$.fragment,t),u(Ye.$$.fragment,t),u(De.$$.fragment,t),u(Oe.$$.fragment,t),u(ta.$$.fragment,t),u(ea.$$.fragment,t),u(na.$$.fragment,t),u(oa.$$.fragment,t),u(ia.$$.fragment,t),u(ra.$$.fragment,t),u(pa.$$.fragment,t),u(da.$$.fragment,t),u(ca.$$.fragment,t),u(ha.$$.fragment,t),u(Ma.$$.fragment,t),u(fa.$$.fragment,t),bs=!1},d(t){t&&(a(Fa),a(Ca),a(xa),a($a),a(x),a(Ga),a($),a(Za),a(G),a(Ba),a(Na),a(B),a(qa),a(Ra),a(q),a(Aa),a(R),a(Ea),a(Wa),a(E),a(Xa),a(Sa),a(za),a(S),a(Qa),a(Va),a(Q),a(Ha),a(La),a(H),a(Ya),a(Da),a(Y),a(Pa),a(Oa),a(P),a(Ka),a(O),a(tn),a(K),a(en),a(an),a(et),a(nn),a(ln),a(sn),a(lt),a(on),a(st),a(rn),a(pn),a(it),a(dn),a(cn),a(pt),a(mn),a(dt),a(un),a(hn),a(mt),a(Mn),a(fn),a(ht),a(yn),a(Tn),a(ft),a(gn),a(wn),a(Tt),a(Jn),a(_n),a(wt),a(bn),a(Un),a(_t),a(jn),a(vn),a(Ut),a(Cn),a(In),a(vt),a(kn),a(Fn),a(It),a(xn),a($n),a(Ft),a(Gn),a(Zn),a($t),a(Bn),a(Nn),a(Zt),a(qn),a(Rn),a(Nt),a(An),a(En),a(Rt),a(Wn),a(Xn),a(Et),a(Sn),a(zn),a(Qn),a(St),a(Vn),a(Hn),a(Qt),a(Ln),a(Yn),a(Ht),a(Dn),a(Pn),a(Yt),a(On),a(Kn),a(Pt),a(tl),a(Ot),a(el),a(Kt),a(al),a(nl),a(ee),a(ll),a(sl),a(ne),a(ol),a(il),a(se),a(rl),a(oe),a(pl),a(dl),a(re),a(cl),a(g),a(ml),a(ul),a(hl),a(me),a(Ml),a(ue),a(fl),a(j),a(yl),a(he),a(Tl),a(gl),a(fe),a(wl),a(v),a(Jl),a(ye),a(_l),a(bl),a(ge),a(Ul),a(we),a(jl),a(Je),a(vl),a(Cl),a(be),a(Il),a(kl),a(je),a(Fl),a(ve),a(xl),a(Ce),a($l),a(Ie),a(Gl),a(Zl),a(C),a(Bl),a(Nl),a(xe),a(ql),a(Rl),a(Ge),a(Al),a(Ze),a(El),a(Wl),a(Ne),a(Xl),a(qe),a(Sl),a(zl),a(Ql),a(Ee),a(Vl),a(Hl),a(Xe),a(Ll),a(Yl),a(ze),a(Dl),a(Pl),a(Ve),a(Ol),a(Kl),a(Le),a(ts),a(es),a(_),a(as),a(ns),a(Pe),a(ls),a(ss),a(Ke),a(os),a(is),a(rs),a(aa),a(ps),a(ds),a(la),a(cs),a(sa),a(ms),a(us),a(w),a(hs),a(Ms),a(J),a(fs),a(ys),a(ma),a(Ts),a(ua),a(gs),a(ws),a(U),a(Js),a(_s),a(Ia)),a(b),h(F,t),h(Z,t),h(N,t),h(A,t),h(W,t),h(X,t),h(z,t),h(V,t),h(L,t),h(D,t),h(tt,t),h(at,t),h(nt,t),h(ot,t),h(rt,t),h(ct,t),h(ut,t),h(Mt,t),h(yt,t),h(gt,t),h(Jt,t),h(bt,t),h(jt,t),h(Ct,t),h(kt,t),h(xt,t),h(Gt,t),h(Bt,t),h(qt,t),h(At,t),h(Wt,t),h(Xt,t),h(zt,t),h(Vt,t),h(Lt,t),h(Dt,t),h(te,t),h(ae,t),h(le,t),h(ie,t),h(pe),h(de,t),h(ce,t),h(Me,t),h(Te,t),h(_e,t),h(Ue,t),h(ke,t),h(Fe,t),h($e,t),h(Be,t),h(Re,t),h(Ae,t),h(We,t),h(Se,t),h(Qe,t),h(He,t),h(Ye,t),h(De,t),h(Oe,t),h(ta,t),h(ea,t),h(na,t),h(oa,t),h(ia),h(ra),h(pa,t),h(da),h(ca,t),h(ha,t),h(Ma),h(fa,t)}}}const vi='{"title":"Supervised Fine-tuning Trainer","local":"supervised-fine-tuning-trainer","sections":[{"title":"Quickstart","local":"quickstart","sections":[],"depth":2},{"title":"Advanced usage","local":"advanced-usage","sections":[{"title":"Train on completions only","local":"train-on-completions-only","sections":[{"title":"Using token_ids directly for response_template","local":"using-tokenids-directly-for-responsetemplate","sections":[],"depth":4}],"depth":3},{"title":"Add Special Tokens for Chat Format","local":"add-special-tokens-for-chat-format","sections":[],"depth":3},{"title":"Dataset format support","local":"dataset-format-support","sections":[],"depth":3},{"title":"Format your input prompts","local":"format-your-input-prompts","sections":[],"depth":3},{"title":"Packing dataset ( ConstantLengthDataset )","local":"packing-dataset--constantlengthdataset-","sections":[{"title":"Customize your prompts using packed dataset","local":"customize-your-prompts-using-packed-dataset","sections":[],"depth":4}],"depth":3},{"title":"Control over the pretrained model","local":"control-over-the-pretrained-model","sections":[],"depth":3},{"title":"Training adapters","local":"training-adapters","sections":[],"depth":3},{"title":"Training adapters with base 8 bit models","local":"training-adapters-with-base-8-bit-models","sections":[],"depth":3}],"depth":2},{"title":"Using Flash Attention and Flash Attention 2","local":"using-flash-attention-and-flash-attention-2","sections":[{"title":"Using Flash-Attention 1","local":"using-flash-attention-1","sections":[],"depth":3},{"title":"Using Flash Attention-2","local":"using-flash-attention-2","sections":[],"depth":3},{"title":"Using model creation utility","local":"trl.ModelConfig","sections":[],"depth":3},{"title":"Enhance the model’s performances using NEFTune","local":"enhance-the-models-performances-using-neftune","sections":[],"depth":3},{"title":"Accelerate fine-tuning 2x using unsloth","local":"accelerate-fine-tuning-2x-using-unsloth","sections":[],"depth":3}],"depth":2},{"title":"Liger-Kernel: Increase 20% throughput and reduces 60% memory for multi-GPU training","local":"liger-kernel-increase-20-throughput-and-reduces-60-memory-for-multi-gpu-training","sections":[],"depth":2},{"title":"Best practices","local":"best-practices","sections":[],"depth":2},{"title":"Multi-GPU Training","local":"multi-gpu-training","sections":[],"depth":2},{"title":"GPTQ Conversion","local":"gptq-conversion","sections":[],"depth":2},{"title":"Extending SFTTrainer for Vision Language Models","local":"extending-sfttrainer-for-vision-language-models","sections":[{"title":"Preparing the Data","local":"preparing-the-data","sections":[],"depth":3},{"title":"A custom collator for processing multi-modal data","local":"a-custom-collator-for-processing-multi-modal-data","sections":[],"depth":3},{"title":"Training the vision-language model","local":"training-the-vision-language-model","sections":[],"depth":3}],"depth":2},{"title":"SFTTrainer","local":"trl.SFTTrainer","sections":[],"depth":2},{"title":"SFTConfig","local":"trl.SFTConfig","sections":[],"depth":2},{"title":"Datasets","local":"datasets","sections":[{"title":"ConstantLengthDataset","local":"trl.trainer.ConstantLengthDataset","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ci(Zs){return wi(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Gi extends Ji{constructor(b){super(),_i(this,b,Ci,ji,yi,{})}}export{Gi as component};
