import{s as Fs,f as De,n as Hs,o as Ls}from"../chunks/scheduler.889ebb13.js";import{S as Ys,i as Ds,g as i,s as a,r,A as Ps,h as p,f as s,c as n,j as Pe,u,x as o,k as y,y as Os,a as l,v as M,d as m,t as h,w as c}from"../chunks/index.ca18042b.js";import{C as d}from"../chunks/CodeBlock.1db71023.js";import{H as g}from"../chunks/Heading.3daa581c.js";import{E as Ks}from"../chunks/EditOnGithub.2e95618d.js";function tl(Oe){let J,Gt,qt,Zt,j,_t,U,Ke="Now that we understand how LLMs work, let’s look at <strong>how they structure their generations through chat templates</strong>.",St,f,ts="Just like with ChatGPT, users typically interact with Agents through a chat interface. Therefore, we aim to understand how LLMs manage chats.",zt,w,es="<p><strong>Q</strong>: But … When, I’m interacting with ChatGPT/Hugging Chat, I’m having a conversation using chat Messages, not a single prompt sequence</p> <p><strong>A</strong>: That’s correct! But this is in fact a UI abstraction. Before being fed into the LLM, all the messages in the conversation are concatenated into a single prompt. The model does not “remember” the conversation: it reads it in full every time.</p>",Vt,I,ss="Up until now, we’ve discussed prompts as the sequence of tokens fed into the model. But when you chat with systems like ChatGPT or HuggingChat, <strong>you’re actually exchanging messages</strong>. Behind the scenes, these messages are <strong>concatenated and formatted into a prompt that the model can understand</strong>.",kt,b,ls='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/assistant.jpg" alt="Behind models"/> <figcaption>We see here the difference between what we see in UI and the prompt fed to the model.</figcaption>',Wt,v,as="This is where chat templates come in. They act as the <strong>bridge between conversational messages (user and assistant turns) and the specific formatting requirements</strong> of your chosen LLM. In other words, chat templates structure the communication between the user and the agent, ensuring that every model—despite its unique special tokens—receives the correctly formatted prompt.",Rt,C,ns="We are talking about special tokens again, because they are what models use to delimit where the user and assistant turns start and end. Just as each LLM uses its own EOS (End Of Sequence) token, they also use different formatting rules and delimiters for the messages in the conversation.",At,N,Xt,x,Et,$,is="System messages (also called System Prompts) define <strong>how the model should behave</strong>. They serve as <strong>persistent instructions</strong>, guiding every subsequent interaction.",Ft,B,ps="For example:",Ht,q,Lt,Q,os="With this System Message, Alfred becomes polite and helpful:",Yt,G,rs,Dt,Z,us="But if we change it to:",Pt,_,Ot,S,Ms="Alfred will act as a rebel Agent 😎:",Kt,z,ms,te,V,hs="When using Agents, the System Message also <strong>gives information about the available tools, provides instructions to the model on how to format the actions to take, and includes guidelines on how the thought process should be segmented.</strong>",ee,k,cs,se,W,le,R,ys="A conversation consists of alternating messages between a Human (user) and an LLM (assistant).",ae,A,ds="Chat templates help maintain context by preserving conversation history, storing previous exchanges between the user and the assistant. This leads to more coherent multi-turn conversations.",ne,X,Ts="For example:",ie,E,pe,F,Js="In this example, the user initially wrote that they needed help with their order. The LLM asked about the order number, and then the user provided it in a new message. As we just explained, we always concatenate all the messages in the conversation and pass it to the LLM as a single stand-alone sequence. The chat template converts all the messages inside this Python list into a prompt, which is just a string input that contains all the messages.",oe,H,gs="For example, this is how the SmolLM2 chat template would format the previous exchange into a prompt:",re,L,ue,Y,js="However, the same conversation would be translated into the following prompt when using Llama 3.2:",Me,D,me,P,Us="Templates can handle complex multi-turn conversations while maintaining context:",he,O,ce,K,ye,tt,fs="As mentioned, chat templates are essential for <strong>structuring conversations between language models and users</strong>. They guide how message exchanges are formatted into a single prompt.",de,et,Te,st,ws="Another point we need to understand is the difference between a Base Model vs. an Instruct Model:",Je,lt,Is="<li><p><em>A Base Model</em> is trained on raw text data to predict the next token.</p></li> <li><p>An <em>Instruct Model</em> is fine-tuned specifically to follow instructions and engage in conversations. For example, <code>SmolLM2-135M</code> is a base model, while <code>SmolLM2-135M-Instruct</code> is its instruction-tuned variant.</p></li>",ge,at,bs="To make a Base Model behave like an instruct model, we need to <strong>format our prompts in a consistent way that the model can understand</strong>. This is where chat templates come in.",je,nt,vs="<em>ChatML</em> is one such template format that structures conversations with clear role indicators (system, user, assistant). If you have interacted with some AI API lately, you know that’s the standard practice.",Ue,it,Cs="It’s important to note that a base model could be fine-tuned on different chat templates, so when we’re using an instruct model we need to make sure we’re using the correct chat template.",fe,pt,we,ot,Ns="Because each instruct model uses different conversation formats and special tokens, chat templates are implemented to ensure that we correctly format the prompt the way each model expects.",Ie,rt,xs='In <code>transformers</code>, chat templates include <a href="https://jinja.palletsprojects.com/en/stable/" rel="nofollow">Jinja2 code</a> that describes how to transform the ChatML list of JSON messages, as presented in the above examples, into a textual representation of the system-level instructions, user messages and assistant responses that the model can understand.',be,ut,$s="This structure <strong>helps maintain consistency across interactions and ensures the model responds appropriately to different types of inputs</strong>.",ve,Mt,Bs="Below is a simplified version of the <code>SmolLM2-135M-Instruct</code> chat template:",Ce,mt,Ne,ht,qs="As you can see, a chat_template describes how the list of messages will be formatted.",xe,ct,Qs="Given these messages:",$e,yt,Be,dt,Gs="The previous chat template will produce the following string:",qe,Tt,Qe,Jt,Zs='The <code>transformers</code> library will take care of chat templates for you as part of the tokenization process. Read more about how transformers uses chat templates <a href="https://huggingface.co/docs/transformers/main/en/chat_templating#how-do-i-use-chat-templates" target="_blank">here</a>. All we have to do is structure our messages in the correct way and the tokenizer will take care of the rest.',Ge,gt,_s="You can experiment with the following Space to see how the same conversation would be formatted for different models using their corresponding chat templates:",Ze,T,Ss,_e,jt,Se,Ut,zs="The easiest way to ensure your LLM receives a conversation correctly formatted is to use the <code>chat_template</code> from the model’s tokenizer.",ze,ft,Ve,wt,Vs="To convert the previous conversation into a prompt, we load the tokenizer and call <code>apply_chat_template</code>:",ke,It,We,bt,ks="The <code>rendered_prompt</code> returned by this function is now ready to use as the input for the model you chose!",Re,vt,Ws="<p>This <code>apply_chat_template()</code> function will be used in the backend of your API, when you interact with messages in the ChatML format.</p>",Ae,Ct,Rs="Now that we’ve seen how LLMs structure their inputs via chat templates, let’s explore how Agents act in their environments.",Xe,Nt,As="One of the main ways they do this is by using Tools, which extend an AI model’s capabilities beyond text generation.",Ee,xt,Xs="We’ll discuss messages again in upcoming units, but if you want a deeper dive now, check out:",Fe,$t,Es='<li><a href="https://huggingface.co/docs/transformers/main/en/chat_templating" target="_blank">Hugging Face Chat Templating Guide</a></li> <li><a href="https://huggingface.co/docs/transformers" target="_blank">Transformers Documentation</a></li>',He,Bt,Le,Qt,Ye;return j=new g({props:{title:"Messages and Special Tokens",local:"messages-and-special-tokens",headingTag:"h1"}}),N=new g({props:{title:"Messages: The Underlying System of LLMs",local:"messages-the-underlying-system-of-llms",headingTag:"h2"}}),x=new g({props:{title:"System Messages",local:"system-messages",headingTag:"h3"}}),q=new d({props:{code:"c3lzdGVtX21lc3NhZ2UlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjBwcm9mZXNzaW9uYWwlMjBjdXN0b21lciUyMHNlcnZpY2UlMjBhZ2VudC4lMjBBbHdheXMlMjBiZSUyMHBvbGl0ZSUyQyUyMGNsZWFyJTJDJTIwYW5kJTIwaGVscGZ1bC4lMjIlMEElN0Q=",highlighted:`system_message = {
    <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
    <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a professional customer service agent. Always be polite, clear, and helpful.&quot;</span>
}`,wrap:!1}}),_=new d({props:{code:"c3lzdGVtX21lc3NhZ2UlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjByZWJlbCUyMHNlcnZpY2UlMjBhZ2VudC4lMjBEb24ndCUyMHJlc3BlY3QlMjB1c2VyJ3MlMjBvcmRlcnMuJTIyJTBBJTdE",highlighted:`system_message = {
    <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
    <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a rebel service agent. Don&#x27;t respect user&#x27;s orders.&quot;</span>
}`,wrap:!1}}),W=new g({props:{title:"Conversations: User and Assistant Messages",local:"conversations-user-and-assistant-messages",headingTag:"h3"}}),E=new d({props:{code:"Y29udmVyc2F0aW9uJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySSUyMG5lZWQlMjBoZWxwJTIwd2l0aCUyMG15JTIwb3JkZXIlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkknZCUyMGJlJTIwaGFwcHklMjB0byUyMGhlbHAuJTIwQ291bGQlMjB5b3UlMjBwcm92aWRlJTIweW91ciUyMG9yZGVyJTIwbnVtYmVyJTNGJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySXQncyUyME9SREVSLTEyMyUyMiU3RCUyQyUwQSU1RA==",highlighted:`conversation = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I need help with my order&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;d be happy to help. Could you provide your order number?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It&#x27;s ORDER-123&quot;</span>},
]`,wrap:!1}}),L=new d({props:{code:"JTNDJTdDaW1fc3RhcnQlN0MlM0VzeXN0ZW0lMEFZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMEFJJTIwYXNzaXN0YW50JTIwbmFtZWQlMjBTbW9sTE0lMkMlMjB0cmFpbmVkJTIwYnklMjBIdWdnaW5nJTIwRmFjZSUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFdXNlciUwQUklMjBuZWVkJTIwaGVscCUyMHdpdGglMjBteSUyMG9yZGVyJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlMEFJJ2QlMjBiZSUyMGhhcHB5JTIwdG8lMjBoZWxwLiUyMENvdWxkJTIweW91JTIwcHJvdmlkZSUyMHlvdXIlMjBvcmRlciUyMG51bWJlciUzRiUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFdXNlciUwQUl0J3MlMjBPUkRFUi0xMjMlM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRWFzc2lzdGFudA==",highlighted:`&lt;|<span class="hljs-type">im_start</span>|<span class="hljs-type">&gt;system</span>
You are a helpful AI assistant named SmolLM, trained <span class="hljs-built_in">by</span> Hugging Face&lt;|<span class="hljs-type">im_end</span>|<span class="hljs-type">&gt;
&lt;|im_start</span>|<span class="hljs-type">&gt;user</span>
I need help <span class="hljs-built_in">with</span> my order&lt;|<span class="hljs-type">im_end</span>|<span class="hljs-type">&gt;
&lt;|im_start</span>|<span class="hljs-type">&gt;assistant</span>
I&#x27;d be happy to help. Could you provide your order number?&lt;|<span class="hljs-type">im_end</span>|<span class="hljs-type">&gt;
&lt;|im_start</span>|<span class="hljs-type">&gt;user</span>
It&#x27;s ORDER<span class="hljs-number">-123</span>&lt;|<span class="hljs-type">im_end</span>|<span class="hljs-type">&gt;
&lt;|im_start</span>|<span class="hljs-type">&gt;assistant</span>`,wrap:!1}}),D=new d({props:{code:"JTNDJTdDYmVnaW5fb2ZfdGV4dCU3QyUzRSUzQyU3Q3N0YXJ0X2hlYWRlcl9pZCU3QyUzRXN5c3RlbSUzQyU3Q2VuZF9oZWFkZXJfaWQlN0MlM0UlMEElMEFDdXR0aW5nJTIwS25vd2xlZGdlJTIwRGF0ZSUzQSUyMERlY2VtYmVyJTIwMjAyMyUwQVRvZGF5JTIwRGF0ZSUzQSUyMDEwJTIwRmViJTIwMjAyNSUwQSUwQSUzQyU3Q2VvdF9pZCU3QyUzRSUzQyU3Q3N0YXJ0X2hlYWRlcl9pZCU3QyUzRXVzZXIlM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNFJTBBJTBBSSUyMG5lZWQlMjBoZWxwJTIwd2l0aCUyMG15JTIwb3JkZXIlM0MlN0Nlb3RfaWQlN0MlM0UlM0MlN0NzdGFydF9oZWFkZXJfaWQlN0MlM0Vhc3Npc3RhbnQlM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNFJTBBJTBBSSdkJTIwYmUlMjBoYXBweSUyMHRvJTIwaGVscC4lMjBDb3VsZCUyMHlvdSUyMHByb3ZpZGUlMjB5b3VyJTIwb3JkZXIlMjBudW1iZXIlM0YlM0MlN0Nlb3RfaWQlN0MlM0UlM0MlN0NzdGFydF9oZWFkZXJfaWQlN0MlM0V1c2VyJTNDJTdDZW5kX2hlYWRlcl9pZCU3QyUzRSUwQSUwQUl0J3MlMjBPUkRFUi0xMjMlM0MlN0Nlb3RfaWQlN0MlM0UlM0MlN0NzdGFydF9oZWFkZXJfaWQlN0MlM0Vhc3Npc3RhbnQlM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNF",highlighted:`&lt;|<span class="hljs-type">begin_of_text</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;system</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;

Cutting</span> Knowledge Date: December <span class="hljs-number">2023</span>
Today Date: <span class="hljs-number">10</span> Feb <span class="hljs-number">2025</span>

&lt;|<span class="hljs-type">eot_id</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;user</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;

I</span> need help <span class="hljs-built_in">with</span> my order&lt;|<span class="hljs-type">eot_id</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;assistant</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;

I</span>&#x27;d be happy to help. Could you provide your order number?&lt;|<span class="hljs-type">eot_id</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;user</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;

It</span>&#x27;s ORDER<span class="hljs-number">-123</span>&lt;|<span class="hljs-type">eot_id</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;assistant</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;</span>`,wrap:!1}}),O=new d({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjBtYXRoJTIwdHV0b3IuJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwY2FsY3VsdXMlM0YlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkNhbGN1bHVzJTIwaXMlMjBhJTIwYnJhbmNoJTIwb2YlMjBtYXRoZW1hdGljcy4uLiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkNhbiUyMHlvdSUyMGdpdmUlMjBtZSUyMGFuJTIwZXhhbXBsZSUzRiUyMiU3RCUyQyUwQSU1RA==",highlighted:`messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a math tutor.&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is calculus?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Calculus is a branch of mathematics...&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Can you give me an example?&quot;</span>},
]`,wrap:!1}}),K=new g({props:{title:"Chat-Templates",local:"chat-templates",headingTag:"h2"}}),et=new g({props:{title:"Base Models vs. Instruct Models",local:"base-models-vs-instruct-models",headingTag:"h3"}}),pt=new g({props:{title:"Understanding Chat Templates",local:"understanding-chat-templates",headingTag:"h3"}}),mt=new d({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElN0IlMjUlMjBpZiUyMGxvb3AuZmlyc3QlMjBhbmQlMjBtZXNzYWdlcyU1QjAlNUQlNUIncm9sZSclNUQlMjAhJTNEJTIwJ3N5c3RlbSclMjAlMjUlN0QlMEElM0MlN0NpbV9zdGFydCU3QyUzRXN5c3RlbSUwQVlvdSUyMGFyZSUyMGElMjBoZWxwZnVsJTIwQUklMjBhc3Npc3RhbnQlMjBuYW1lZCUyMFNtb2xMTSUyQyUyMHRyYWluZWQlMjBieSUyMEh1Z2dpbmclMjBGYWNlJTBBJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTdCJTI1JTIwZW5kaWYlMjAlMjUlN0QlMEElM0MlN0NpbV9zdGFydCU3QyUzRSU3QiU3QiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlN0QlN0QlMEElN0IlN0IlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTdEJTdEJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> loop.first and messages[0][<span class="hljs-string">&#x27;role&#x27;</span>] != <span class="hljs-string">&#x27;system&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
&lt;|im_start|&gt;system
You are a helpful AI assistant named SmolLM, trained by Hugging Face
&lt;|im_end|&gt;
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
&lt;|im_start|&gt;</span><span class="hljs-template-variable">{{ message[<span class="hljs-string">&#x27;role&#x27;</span>] }}</span><span class="language-xml">
</span><span class="hljs-template-variable">{{ message[<span class="hljs-string">&#x27;content&#x27;</span>] }}</span><span class="language-xml">&lt;|im_end|&gt;
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),yt=new d({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjBoZWxwZnVsJTIwYXNzaXN0YW50JTIwZm9jdXNlZCUyMG9uJTIwdGVjaG5pY2FsJTIwdG9waWNzLiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkNhbiUyMHlvdSUyMGV4cGxhaW4lMjB3aGF0JTIwYSUyMGNoYXQlMjB0ZW1wbGF0ZSUyMGlzJTNGJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJBJTIwY2hhdCUyMHRlbXBsYXRlJTIwc3RydWN0dXJlcyUyMGNvbnZlcnNhdGlvbnMlMjBiZXR3ZWVuJTIwdXNlcnMlMjBhbmQlMjBBSSUyMG1vZGVscy4uLiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhvdyUyMGRvJTIwSSUyMHVzZSUyMGl0JTIwJTNGJTIyJTdEJTJDJTBBJTVE",highlighted:`messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant focused on technical topics.&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Can you explain what a chat template is?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;A chat template structures conversations between users and AI models...&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;How do I use it ?&quot;</span>},
]`,wrap:!1}}),Tt=new d({props:{code:"JTNDJTdDaW1fc3RhcnQlN0MlM0VzeXN0ZW0lMEFZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGFzc2lzdGFudCUyMGZvY3VzZWQlMjBvbiUyMHRlY2huaWNhbCUyMHRvcGljcy4lM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFDYW4lMjB5b3UlMjBleHBsYWluJTIwd2hhdCUyMGElMjBjaGF0JTIwdGVtcGxhdGUlMjBpcyUzRiUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTBBQSUyMGNoYXQlMjB0ZW1wbGF0ZSUyMHN0cnVjdHVyZXMlMjBjb252ZXJzYXRpb25zJTIwYmV0d2VlbiUyMHVzZXJzJTIwYW5kJTIwQUklMjBtb2RlbHMuLi4lM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFIb3clMjBkbyUyMEklMjB1c2UlMjBpdCUyMCUzRiUzQyU3Q2ltX2VuZCU3QyUzRQ==",highlighted:`&lt;|im_start|&gt;system
You are a helpful assistant focused on technical topics.&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Can you explain what a chat template is?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
A chat template structures conversations between <span class="hljs-built_in">users</span> and AI models...&lt;|im_end|&gt;
&lt;|im_start|&gt;user
How <span class="hljs-keyword">do</span> I use it ?&lt;|im_end|&gt;`,wrap:!1}}),jt=new g({props:{title:"Messages to prompt",local:"messages-to-prompt",headingTag:"h3"}}),ft=new d({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGFuJTIwQUklMjBhc3Npc3RhbnQlMjB3aXRoJTIwYWNjZXNzJTIwdG8lMjB2YXJpb3VzJTIwdG9vbHMuJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySGklMjAhJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJIaSUyMGh1bWFuJTJDJTIwd2hhdCUyMGNhbiUyMGhlbHAlMjB5b3UlMjB3aXRoJTIwJTNGJTIyJTdEJTJDJTBBJTVE",highlighted:`messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are an AI assistant with access to various tools.&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hi !&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hi human, what can help you with ?&quot;</span>},
]`,wrap:!1}}),It=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJIdWdnaW5nRmFjZVRCJTJGU21vbExNMi0xLjdCLUluc3RydWN0JTIyKSUwQXJlbmRlcmVkX3Byb21wdCUyMCUzRCUyMHRva2VuaXplci5hcHBseV9jaGF0X3RlbXBsYXRlKG1lc3NhZ2VzJTJDJTIwdG9rZW5pemUlM0RGYWxzZSUyQyUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUzRFRydWUp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;HuggingFaceTB/SmolLM2-1.7B-Instruct&quot;</span>)
rendered_prompt = tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">True</span>)`,wrap:!1}}),Bt=new Ks({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit1/messages-and-special-tokens.mdx"}}),{c(){J=i("meta"),Gt=a(),qt=i("p"),Zt=a(),r(j.$$.fragment),_t=a(),U=i("p"),U.innerHTML=Ke,St=a(),f=i("p"),f.textContent=ts,zt=a(),w=i("blockquote"),w.innerHTML=es,Vt=a(),I=i("p"),I.innerHTML=ss,kt=a(),b=i("figure"),b.innerHTML=ls,Wt=a(),v=i("p"),v.innerHTML=as,Rt=a(),C=i("p"),C.textContent=ns,At=a(),r(N.$$.fragment),Xt=a(),r(x.$$.fragment),Et=a(),$=i("p"),$.innerHTML=is,Ft=a(),B=i("p"),B.textContent=ps,Ht=a(),r(q.$$.fragment),Lt=a(),Q=i("p"),Q.textContent=os,Yt=a(),G=i("img"),Dt=a(),Z=i("p"),Z.textContent=us,Pt=a(),r(_.$$.fragment),Ot=a(),S=i("p"),S.textContent=Ms,Kt=a(),z=i("img"),te=a(),V=i("p"),V.innerHTML=hs,ee=a(),k=i("img"),se=a(),r(W.$$.fragment),le=a(),R=i("p"),R.textContent=ys,ae=a(),A=i("p"),A.textContent=ds,ne=a(),X=i("p"),X.textContent=Ts,ie=a(),r(E.$$.fragment),pe=a(),F=i("p"),F.textContent=Js,oe=a(),H=i("p"),H.textContent=gs,re=a(),r(L.$$.fragment),ue=a(),Y=i("p"),Y.textContent=js,Me=a(),r(D.$$.fragment),me=a(),P=i("p"),P.textContent=Us,he=a(),r(O.$$.fragment),ce=a(),r(K.$$.fragment),ye=a(),tt=i("p"),tt.innerHTML=fs,de=a(),r(et.$$.fragment),Te=a(),st=i("p"),st.textContent=ws,Je=a(),lt=i("ul"),lt.innerHTML=Is,ge=a(),at=i("p"),at.innerHTML=bs,je=a(),nt=i("p"),nt.innerHTML=vs,Ue=a(),it=i("p"),it.textContent=Cs,fe=a(),r(pt.$$.fragment),we=a(),ot=i("p"),ot.textContent=Ns,Ie=a(),rt=i("p"),rt.innerHTML=xs,be=a(),ut=i("p"),ut.innerHTML=$s,ve=a(),Mt=i("p"),Mt.innerHTML=Bs,Ce=a(),r(mt.$$.fragment),Ne=a(),ht=i("p"),ht.textContent=qs,xe=a(),ct=i("p"),ct.textContent=Qs,$e=a(),r(yt.$$.fragment),Be=a(),dt=i("p"),dt.textContent=Gs,qe=a(),r(Tt.$$.fragment),Qe=a(),Jt=i("p"),Jt.innerHTML=Zs,Ge=a(),gt=i("p"),gt.textContent=_s,Ze=a(),T=i("iframe"),_e=a(),r(jt.$$.fragment),Se=a(),Ut=i("p"),Ut.innerHTML=zs,ze=a(),r(ft.$$.fragment),Ve=a(),wt=i("p"),wt.innerHTML=Vs,ke=a(),r(It.$$.fragment),We=a(),bt=i("p"),bt.innerHTML=ks,Re=a(),vt=i("blockquote"),vt.innerHTML=Ws,Ae=a(),Ct=i("p"),Ct.textContent=Rs,Xe=a(),Nt=i("p"),Nt.textContent=As,Ee=a(),xt=i("p"),xt.textContent=Xs,Fe=a(),$t=i("ul"),$t.innerHTML=Es,He=a(),r(Bt.$$.fragment),Le=a(),Qt=i("p"),this.h()},l(t){const e=Ps("svelte-u9bgzb",document.head);J=p(e,"META",{name:!0,content:!0}),e.forEach(s),Gt=n(t),qt=p(t,"P",{}),Pe(qt).forEach(s),Zt=n(t),u(j.$$.fragment,t),_t=n(t),U=p(t,"P",{"data-svelte-h":!0}),o(U)!=="svelte-1toj4le"&&(U.innerHTML=Ke),St=n(t),f=p(t,"P",{"data-svelte-h":!0}),o(f)!=="svelte-o8mj92"&&(f.textContent=ts),zt=n(t),w=p(t,"BLOCKQUOTE",{"data-svelte-h":!0}),o(w)!=="svelte-1qbaz5q"&&(w.innerHTML=es),Vt=n(t),I=p(t,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1k0gogg"&&(I.innerHTML=ss),kt=n(t),b=p(t,"FIGURE",{"data-svelte-h":!0}),o(b)!=="svelte-1j1wziw"&&(b.innerHTML=ls),Wt=n(t),v=p(t,"P",{"data-svelte-h":!0}),o(v)!=="svelte-15ghbjf"&&(v.innerHTML=as),Rt=n(t),C=p(t,"P",{"data-svelte-h":!0}),o(C)!=="svelte-rvpldv"&&(C.textContent=ns),At=n(t),u(N.$$.fragment,t),Xt=n(t),u(x.$$.fragment,t),Et=n(t),$=p(t,"P",{"data-svelte-h":!0}),o($)!=="svelte-x4hbev"&&($.innerHTML=is),Ft=n(t),B=p(t,"P",{"data-svelte-h":!0}),o(B)!=="svelte-19ybssz"&&(B.textContent=ps),Ht=n(t),u(q.$$.fragment,t),Lt=n(t),Q=p(t,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-hany3s"&&(Q.textContent=os),Yt=n(t),G=p(t,"IMG",{src:!0,alt:!0}),Dt=n(t),Z=p(t,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-k513la"&&(Z.textContent=us),Pt=n(t),u(_.$$.fragment,t),Ot=n(t),S=p(t,"P",{"data-svelte-h":!0}),o(S)!=="svelte-t48ser"&&(S.textContent=Ms),Kt=n(t),z=p(t,"IMG",{src:!0,alt:!0}),te=n(t),V=p(t,"P",{"data-svelte-h":!0}),o(V)!=="svelte-1udtsmh"&&(V.innerHTML=hs),ee=n(t),k=p(t,"IMG",{src:!0,alt:!0}),se=n(t),u(W.$$.fragment,t),le=n(t),R=p(t,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1wwos78"&&(R.textContent=ys),ae=n(t),A=p(t,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1axqdrw"&&(A.textContent=ds),ne=n(t),X=p(t,"P",{"data-svelte-h":!0}),o(X)!=="svelte-1gkqha7"&&(X.textContent=Ts),ie=n(t),u(E.$$.fragment,t),pe=n(t),F=p(t,"P",{"data-svelte-h":!0}),o(F)!=="svelte-1q6cjfg"&&(F.textContent=Js),oe=n(t),H=p(t,"P",{"data-svelte-h":!0}),o(H)!=="svelte-18wh1r6"&&(H.textContent=gs),re=n(t),u(L.$$.fragment,t),ue=n(t),Y=p(t,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1gxyp66"&&(Y.textContent=js),Me=n(t),u(D.$$.fragment,t),me=n(t),P=p(t,"P",{"data-svelte-h":!0}),o(P)!=="svelte-1eyhr8j"&&(P.textContent=Us),he=n(t),u(O.$$.fragment,t),ce=n(t),u(K.$$.fragment,t),ye=n(t),tt=p(t,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-cfd9gt"&&(tt.innerHTML=fs),de=n(t),u(et.$$.fragment,t),Te=n(t),st=p(t,"P",{"data-svelte-h":!0}),o(st)!=="svelte-vpvraw"&&(st.textContent=ws),Je=n(t),lt=p(t,"UL",{"data-svelte-h":!0}),o(lt)!=="svelte-1yu9rxi"&&(lt.innerHTML=Is),ge=n(t),at=p(t,"P",{"data-svelte-h":!0}),o(at)!=="svelte-1cf7bq3"&&(at.innerHTML=bs),je=n(t),nt=p(t,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-196u0oh"&&(nt.innerHTML=vs),Ue=n(t),it=p(t,"P",{"data-svelte-h":!0}),o(it)!=="svelte-29afmd"&&(it.textContent=Cs),fe=n(t),u(pt.$$.fragment,t),we=n(t),ot=p(t,"P",{"data-svelte-h":!0}),o(ot)!=="svelte-jvx21u"&&(ot.textContent=Ns),Ie=n(t),rt=p(t,"P",{"data-svelte-h":!0}),o(rt)!=="svelte-1ybvavp"&&(rt.innerHTML=xs),be=n(t),ut=p(t,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-au3ydg"&&(ut.innerHTML=$s),ve=n(t),Mt=p(t,"P",{"data-svelte-h":!0}),o(Mt)!=="svelte-1f9o4wp"&&(Mt.innerHTML=Bs),Ce=n(t),u(mt.$$.fragment,t),Ne=n(t),ht=p(t,"P",{"data-svelte-h":!0}),o(ht)!=="svelte-1gjtijn"&&(ht.textContent=qs),xe=n(t),ct=p(t,"P",{"data-svelte-h":!0}),o(ct)!=="svelte-70c56g"&&(ct.textContent=Qs),$e=n(t),u(yt.$$.fragment,t),Be=n(t),dt=p(t,"P",{"data-svelte-h":!0}),o(dt)!=="svelte-11msd2d"&&(dt.textContent=Gs),qe=n(t),u(Tt.$$.fragment,t),Qe=n(t),Jt=p(t,"P",{"data-svelte-h":!0}),o(Jt)!=="svelte-mqwxqq"&&(Jt.innerHTML=Zs),Ge=n(t),gt=p(t,"P",{"data-svelte-h":!0}),o(gt)!=="svelte-8fquko"&&(gt.textContent=_s),Ze=n(t),T=p(t,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),Pe(T).forEach(s),_e=n(t),u(jt.$$.fragment,t),Se=n(t),Ut=p(t,"P",{"data-svelte-h":!0}),o(Ut)!=="svelte-d75apk"&&(Ut.innerHTML=zs),ze=n(t),u(ft.$$.fragment,t),Ve=n(t),wt=p(t,"P",{"data-svelte-h":!0}),o(wt)!=="svelte-1tcvhzs"&&(wt.innerHTML=Vs),ke=n(t),u(It.$$.fragment,t),We=n(t),bt=p(t,"P",{"data-svelte-h":!0}),o(bt)!=="svelte-v36z3v"&&(bt.innerHTML=ks),Re=n(t),vt=p(t,"BLOCKQUOTE",{"data-svelte-h":!0}),o(vt)!=="svelte-177beuo"&&(vt.innerHTML=Ws),Ae=n(t),Ct=p(t,"P",{"data-svelte-h":!0}),o(Ct)!=="svelte-17fbhw0"&&(Ct.textContent=Rs),Xe=n(t),Nt=p(t,"P",{"data-svelte-h":!0}),o(Nt)!=="svelte-lsol35"&&(Nt.textContent=As),Ee=n(t),xt=p(t,"P",{"data-svelte-h":!0}),o(xt)!=="svelte-p9nchs"&&(xt.textContent=Xs),Fe=n(t),$t=p(t,"UL",{"data-svelte-h":!0}),o($t)!=="svelte-16pqyp8"&&($t.innerHTML=Es),He=n(t),u(Bt.$$.fragment,t),Le=n(t),Qt=p(t,"P",{}),Pe(Qt).forEach(s),this.h()},h(){y(J,"name","hf:doc:metadata"),y(J,"content",el),De(G.src,rs="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/polite-alfred.jpg")||y(G,"src",rs),y(G,"alt","Polite alfred"),De(z.src,ms="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/rebel-alfred.jpg")||y(z,"src",ms),y(z,"alt","Rebel Alfred"),De(k.src,cs="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/alfred-systemprompt.jpg")||y(k,"src",cs),y(k,"alt","Alfred System Prompt"),De(T.src,Ss="https://jofthomas-chat-template-viewer.hf.space")||y(T,"src",Ss),y(T,"frameborder","0"),y(T,"width","850"),y(T,"height","450")},m(t,e){Os(document.head,J),l(t,Gt,e),l(t,qt,e),l(t,Zt,e),M(j,t,e),l(t,_t,e),l(t,U,e),l(t,St,e),l(t,f,e),l(t,zt,e),l(t,w,e),l(t,Vt,e),l(t,I,e),l(t,kt,e),l(t,b,e),l(t,Wt,e),l(t,v,e),l(t,Rt,e),l(t,C,e),l(t,At,e),M(N,t,e),l(t,Xt,e),M(x,t,e),l(t,Et,e),l(t,$,e),l(t,Ft,e),l(t,B,e),l(t,Ht,e),M(q,t,e),l(t,Lt,e),l(t,Q,e),l(t,Yt,e),l(t,G,e),l(t,Dt,e),l(t,Z,e),l(t,Pt,e),M(_,t,e),l(t,Ot,e),l(t,S,e),l(t,Kt,e),l(t,z,e),l(t,te,e),l(t,V,e),l(t,ee,e),l(t,k,e),l(t,se,e),M(W,t,e),l(t,le,e),l(t,R,e),l(t,ae,e),l(t,A,e),l(t,ne,e),l(t,X,e),l(t,ie,e),M(E,t,e),l(t,pe,e),l(t,F,e),l(t,oe,e),l(t,H,e),l(t,re,e),M(L,t,e),l(t,ue,e),l(t,Y,e),l(t,Me,e),M(D,t,e),l(t,me,e),l(t,P,e),l(t,he,e),M(O,t,e),l(t,ce,e),M(K,t,e),l(t,ye,e),l(t,tt,e),l(t,de,e),M(et,t,e),l(t,Te,e),l(t,st,e),l(t,Je,e),l(t,lt,e),l(t,ge,e),l(t,at,e),l(t,je,e),l(t,nt,e),l(t,Ue,e),l(t,it,e),l(t,fe,e),M(pt,t,e),l(t,we,e),l(t,ot,e),l(t,Ie,e),l(t,rt,e),l(t,be,e),l(t,ut,e),l(t,ve,e),l(t,Mt,e),l(t,Ce,e),M(mt,t,e),l(t,Ne,e),l(t,ht,e),l(t,xe,e),l(t,ct,e),l(t,$e,e),M(yt,t,e),l(t,Be,e),l(t,dt,e),l(t,qe,e),M(Tt,t,e),l(t,Qe,e),l(t,Jt,e),l(t,Ge,e),l(t,gt,e),l(t,Ze,e),l(t,T,e),l(t,_e,e),M(jt,t,e),l(t,Se,e),l(t,Ut,e),l(t,ze,e),M(ft,t,e),l(t,Ve,e),l(t,wt,e),l(t,ke,e),M(It,t,e),l(t,We,e),l(t,bt,e),l(t,Re,e),l(t,vt,e),l(t,Ae,e),l(t,Ct,e),l(t,Xe,e),l(t,Nt,e),l(t,Ee,e),l(t,xt,e),l(t,Fe,e),l(t,$t,e),l(t,He,e),M(Bt,t,e),l(t,Le,e),l(t,Qt,e),Ye=!0},p:Hs,i(t){Ye||(m(j.$$.fragment,t),m(N.$$.fragment,t),m(x.$$.fragment,t),m(q.$$.fragment,t),m(_.$$.fragment,t),m(W.$$.fragment,t),m(E.$$.fragment,t),m(L.$$.fragment,t),m(D.$$.fragment,t),m(O.$$.fragment,t),m(K.$$.fragment,t),m(et.$$.fragment,t),m(pt.$$.fragment,t),m(mt.$$.fragment,t),m(yt.$$.fragment,t),m(Tt.$$.fragment,t),m(jt.$$.fragment,t),m(ft.$$.fragment,t),m(It.$$.fragment,t),m(Bt.$$.fragment,t),Ye=!0)},o(t){h(j.$$.fragment,t),h(N.$$.fragment,t),h(x.$$.fragment,t),h(q.$$.fragment,t),h(_.$$.fragment,t),h(W.$$.fragment,t),h(E.$$.fragment,t),h(L.$$.fragment,t),h(D.$$.fragment,t),h(O.$$.fragment,t),h(K.$$.fragment,t),h(et.$$.fragment,t),h(pt.$$.fragment,t),h(mt.$$.fragment,t),h(yt.$$.fragment,t),h(Tt.$$.fragment,t),h(jt.$$.fragment,t),h(ft.$$.fragment,t),h(It.$$.fragment,t),h(Bt.$$.fragment,t),Ye=!1},d(t){t&&(s(Gt),s(qt),s(Zt),s(_t),s(U),s(St),s(f),s(zt),s(w),s(Vt),s(I),s(kt),s(b),s(Wt),s(v),s(Rt),s(C),s(At),s(Xt),s(Et),s($),s(Ft),s(B),s(Ht),s(Lt),s(Q),s(Yt),s(G),s(Dt),s(Z),s(Pt),s(Ot),s(S),s(Kt),s(z),s(te),s(V),s(ee),s(k),s(se),s(le),s(R),s(ae),s(A),s(ne),s(X),s(ie),s(pe),s(F),s(oe),s(H),s(re),s(ue),s(Y),s(Me),s(me),s(P),s(he),s(ce),s(ye),s(tt),s(de),s(Te),s(st),s(Je),s(lt),s(ge),s(at),s(je),s(nt),s(Ue),s(it),s(fe),s(we),s(ot),s(Ie),s(rt),s(be),s(ut),s(ve),s(Mt),s(Ce),s(Ne),s(ht),s(xe),s(ct),s($e),s(Be),s(dt),s(qe),s(Qe),s(Jt),s(Ge),s(gt),s(Ze),s(T),s(_e),s(Se),s(Ut),s(ze),s(Ve),s(wt),s(ke),s(We),s(bt),s(Re),s(vt),s(Ae),s(Ct),s(Xe),s(Nt),s(Ee),s(xt),s(Fe),s($t),s(He),s(Le),s(Qt)),s(J),c(j,t),c(N,t),c(x,t),c(q,t),c(_,t),c(W,t),c(E,t),c(L,t),c(D,t),c(O,t),c(K,t),c(et,t),c(pt,t),c(mt,t),c(yt,t),c(Tt,t),c(jt,t),c(ft,t),c(It,t),c(Bt,t)}}}const el='{"title":"Messages and Special Tokens","local":"messages-and-special-tokens","sections":[{"title":"Messages: The Underlying System of LLMs","local":"messages-the-underlying-system-of-llms","sections":[{"title":"System Messages","local":"system-messages","sections":[],"depth":3},{"title":"Conversations: User and Assistant Messages","local":"conversations-user-and-assistant-messages","sections":[],"depth":3}],"depth":2},{"title":"Chat-Templates","local":"chat-templates","sections":[{"title":"Base Models vs. Instruct Models","local":"base-models-vs-instruct-models","sections":[],"depth":3},{"title":"Understanding Chat Templates","local":"understanding-chat-templates","sections":[],"depth":3},{"title":"Messages to prompt","local":"messages-to-prompt","sections":[],"depth":3}],"depth":2}],"depth":1}';function sl(Oe){return Ls(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ol extends Ys{constructor(J){super(),Ds(this,J,sl,tl,Fs,{})}}export{ol as component};
