import{s as ze,n as _e,o as Fe}from"../chunks/scheduler.889ebb13.js";import{S as $e,i as Ye,g as i,s as n,r as c,A as Le,h as M,f as t,c as a,j as Se,u as p,x as o,k as xe,y as De,a as s,v as y,d as j,t as u,w as m}from"../chunks/index.ca18042b.js";import{C as He}from"../chunks/CodeBlock.1db71023.js";import{C as Pe}from"../chunks/CourseFloatingBanner.bff79cca.js";import{H as _}from"../chunks/Heading.3daa581c.js";import{E as Ke}from"../chunks/EditOnGithub.2e95618d.js";function Oe(be){let r,F,H,$,h,Y,d,L,U,ge="Retrieval Augmented Generation (RAG) systems combine the capabilities of data retrieval and generation models to provide context-aware responses. For example, a user’s query is passed to a search engine, and the retrieved results are given to the model with the query. The model then generates a response based on the query and retrieved information.",D,J,Ie="Agentic RAG (Retrieval-Augmented Generation) extends traditional RAG systems by <strong>combining autonomous agents with dynamic knowledge retrieval</strong>.",P,T,Be="While traditional RAG systems use an LLM to answer queries based on retrieved data, agentic RAG <strong>enables intelligent control of both retrieval and generation processes, improving efficiency and accuracy</strong>.",K,w,fe="Traditional RAG systems face key limitations, such as <strong>relying on a single retrieval step</strong> and focusing on direct semantic similarity with the user’s query, which may overlook relevant information.",O,b,Ae="Agentic RAG addresses these issues by allowing the agent to autonomously formulate search queries, critique retrieved results, and conduct multiple retrieval steps for a more tailored and comprehensive output.",ee,g,le,I,ve="Let’s build a simple agent that can search the web using DuckDuckGo. This agent will retrieve information and synthesize responses to answer queries. With Agentic RAG, Alfred’s agent can:",te,B,Ce="<li>Search for latest superhero party trends</li> <li>Refine results to include luxury elements</li> <li>Synthesize information into a complete plan</li>",se,f,Ge="Here’s how Alfred’s agent can achieve this:",ne,A,ae,v,Ze="The agent follows this process:",ie,C,Re="<li><strong>Analyzes the Request:</strong> Alfred’s agent identifies the key elements of the query—luxury superhero-themed party planning, with focus on decor, entertainment, and catering.</li> <li><strong>Performs Retrieval:</strong>  The agent leverages DuckDuckGo to search for the most relevant and up-to-date information, ensuring it aligns with Alfred’s refined preferences for a luxurious event.</li> <li><strong>Synthesizes Information:</strong> After gathering the results, the agent processes them into a cohesive, actionable plan for Alfred, covering all aspects of the party.</li> <li><strong>Stores for Future Reference:</strong> The agent stores the retrieved information for easy access when planning future events, optimizing efficiency in subsequent tasks.</li>",Me,G,oe,Z,ke="For specialized tasks, a custom knowledge base can be invaluable. Let’s create a tool that queries a vector database of technical documentation or specialized knowledge. Using semantic search, the agent can find the most relevant information for Alfred’s needs.",re,R,Ve="This approach combines predefined knowledge with semantic search to provide context-aware solutions for event planning. With specialized knowledge access, Alfred can perfect every detail of the party.",ce,k,pe,V,Ee="This enhanced agent can:",ye,E,Qe="<li>First check the documentation for relevant information</li> <li>Combine insights from the knowledge base</li> <li>Maintain conversation context through memory</li>",je,Q,ue,q,qe="When building agentic RAG systems, the agent can employ sophisticated strategies like:",me,W,We="<li><strong>Query Reformulation:</strong> Instead of using the raw user query, the agent can craft optimized search terms that better match the target documents</li> <li><strong>Multi-Step Retrieval</strong> The agent can perform multiple searches, using initial results to inform subsequent queries</li> <li><strong>Source Integration</strong> Information can be combined from multiple sources like web search and local documentation</li> <li><strong>Result Validation</strong> Retrieved content can be analyzed for relevance and accuracy before being included in responses</li>",he,X,Xe="Effective agentic RAG systems require careful consideration of several key aspects. The agent <strong>should select between available tools based on the query type and context</strong>. Memory systems help maintain conversation history and avoid repetitive retrievals. Having fallback strategies ensures the system can still provide value even when primary retrieval methods fail. Additionally, implementing validation steps helps ensure the accuracy and relevance of retrieved information.",de,N,Ue,S,Ne='<li><a href="https://huggingface.co/learn/cookbook/agent_rag" rel="nofollow">Agentic RAG: turbocharge your RAG with query reformulation and self-query! 🚀</a> - Recipe for developing an Agentic RAG system using smolagents.</li>',Je,x,Te,z,we;return h=new Pe({props:{chapter:2,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/agents-course/blob/main/notebooks/unit2/smolagents/smolagents_retrieval_agents.ipynb"}]}}),d=new _({props:{title:"Building Agentic RAG Systems",local:"building-agentic-rag-systems",headingTag:"h1"}}),g=new _({props:{title:"Basic Retrieval with DuckDuckGo",local:"basic-retrieval-with-duckduckgo",headingTag:"h2"}}),A=new He({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBEdWNrRHVja0dvU2VhcmNoVG9vbCUyQyUyMEhmQXBpTW9kZWwlMEElMEElMjMlMjBJbml0aWFsaXplJTIwdGhlJTIwc2VhcmNoJTIwdG9vbCUwQXNlYXJjaF90b29sJTIwJTNEJTIwRHVja0R1Y2tHb1NlYXJjaFRvb2woKSUwQSUwQSUyMyUyMEluaXRpYWxpemUlMjB0aGUlMjBtb2RlbCUwQW1vZGVsJTIwJTNEJTIwSGZBcGlNb2RlbCgpJTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMjAlM0QlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCc2VhcmNoX3Rvb2wlNUQlMEEpJTBBJTBBJTIzJTIwRXhhbXBsZSUyMHVzYWdlJTBBcmVzcG9uc2UlMjAlM0QlMjBhZ2VudC5ydW4oJTBBJTIwJTIwJTIwJTIwJTIyU2VhcmNoJTIwZm9yJTIwbHV4dXJ5JTIwc3VwZXJoZXJvLXRoZW1lZCUyMHBhcnR5JTIwaWRlYXMlMkMlMjBpbmNsdWRpbmclMjBkZWNvcmF0aW9ucyUyQyUyMGVudGVydGFpbm1lbnQlMkMlMjBhbmQlMjBjYXRlcmluZy4lMjIlMEEpJTBBcHJpbnQocmVzcG9uc2Up",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, HfApiModel

<span class="hljs-comment"># Initialize the search tool</span>
search_tool = DuckDuckGoSearchTool()

<span class="hljs-comment"># Initialize the model</span>
model = HfApiModel()

agent = CodeAgent(
    model = model,
    tools=[search_tool]
)

<span class="hljs-comment"># Example usage</span>
response = agent.run(
    <span class="hljs-string">&quot;Search for luxury superhero-themed party ideas, including decorations, entertainment, and catering.&quot;</span>
)
<span class="hljs-built_in">print</span>(response)`,wrap:!1}}),G=new _({props:{title:"Custom Knowledge Base Tool",local:"custom-knowledge-base-tool",headingTag:"h2"}}),k=new He({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> langchain.docstore.document <span class="hljs-keyword">import</span> Document
<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool
<span class="hljs-keyword">from</span> langchain_community.retrievers <span class="hljs-keyword">import</span> BM25Retriever
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, HfApiModel

<span class="hljs-keyword">class</span> <span class="hljs-title class_">PartyPlanningRetrieverTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;party_planning_retriever&quot;</span>
    description = <span class="hljs-string">&quot;Uses semantic search to retrieve relevant party planning ideas for Alfred’s superhero-themed party at Wayne Manor.&quot;</span>
    inputs = {
        <span class="hljs-string">&quot;query&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The query to perform. This should be a query related to party planning or superhero themes.&quot;</span>,
        }
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, docs, **kwargs</span>):
        <span class="hljs-built_in">super</span>().__init__(**kwargs)
        self.retriever = BM25Retriever.from_documents(
            docs, k=<span class="hljs-number">5</span>  <span class="hljs-comment"># Retrieve the top 5 documents</span>
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-keyword">assert</span> <span class="hljs-built_in">isinstance</span>(query, <span class="hljs-built_in">str</span>), <span class="hljs-string">&quot;Your search query must be a string&quot;</span>

        docs = self.retriever.invoke(
            query,
        )
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\nRetrieved ideas:\\n&quot;</span> + <span class="hljs-string">&quot;&quot;</span>.join(
            [
                <span class="hljs-string">f&quot;\\n\\n===== Idea <span class="hljs-subst">{<span class="hljs-built_in">str</span>(i)}</span> =====\\n&quot;</span> + doc.page_content
                <span class="hljs-keyword">for</span> i, doc <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(docs)
            ]
        )

<span class="hljs-comment"># Simulate a knowledge base about party planning</span>
party_ideas = [
    {<span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;A superhero-themed masquerade ball with luxury decor, including gold accents and velvet curtains.&quot;</span>, <span class="hljs-string">&quot;source&quot;</span>: <span class="hljs-string">&quot;Party Ideas 1&quot;</span>},
    {<span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Hire a professional DJ who can play themed music for superheroes like Batman and Wonder Woman.&quot;</span>, <span class="hljs-string">&quot;source&quot;</span>: <span class="hljs-string">&quot;Entertainment Ideas&quot;</span>},
    {<span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;For catering, serve dishes named after superheroes, like &#x27;The Hulk&#x27;s Green Smoothie&#x27; and &#x27;Iron Man&#x27;s Power Steak.&#x27;&quot;</span>, <span class="hljs-string">&quot;source&quot;</span>: <span class="hljs-string">&quot;Catering Ideas&quot;</span>},
    {<span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Decorate with iconic superhero logos and projections of Gotham and other superhero cities around the venue.&quot;</span>, <span class="hljs-string">&quot;source&quot;</span>: <span class="hljs-string">&quot;Decoration Ideas&quot;</span>},
    {<span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Interactive experiences with VR where guests can engage in superhero simulations or compete in themed games.&quot;</span>, <span class="hljs-string">&quot;source&quot;</span>: <span class="hljs-string">&quot;Entertainment Ideas&quot;</span>}
]

source_docs = [
    Document(page_content=doc[<span class="hljs-string">&quot;text&quot;</span>], metadata={<span class="hljs-string">&quot;source&quot;</span>: doc[<span class="hljs-string">&quot;source&quot;</span>]})
    <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> party_ideas
]

<span class="hljs-comment"># Split the documents into smaller chunks for more efficient search</span>
text_splitter = RecursiveCharacterTextSplitter(
    chunk_size=<span class="hljs-number">500</span>,
    chunk_overlap=<span class="hljs-number">50</span>,
    add_start_index=<span class="hljs-literal">True</span>,
    strip_whitespace=<span class="hljs-literal">True</span>,
    separators=[<span class="hljs-string">&quot;\\n\\n&quot;</span>, <span class="hljs-string">&quot;\\n&quot;</span>, <span class="hljs-string">&quot;.&quot;</span>, <span class="hljs-string">&quot; &quot;</span>, <span class="hljs-string">&quot;&quot;</span>],
)
docs_processed = text_splitter.split_documents(source_docs)

<span class="hljs-comment"># Create the retriever tool</span>
party_planning_retriever = PartyPlanningRetrieverTool(docs_processed)

<span class="hljs-comment"># Initialize the agent</span>
agent = CodeAgent(tools=[party_planning_retriever], model=HfApiModel())

<span class="hljs-comment"># Example usage</span>
response = agent.run(
    <span class="hljs-string">&quot;Find ideas for a luxury superhero-themed party, including entertainment, catering, and decoration options.&quot;</span>
)

<span class="hljs-built_in">print</span>(response)`,wrap:!1}}),Q=new _({props:{title:"Enhanced Retrieval Capabilities",local:"enhanced-retrieval-capabilities",headingTag:"h2"}}),N=new _({props:{title:"Resources",local:"resources",headingTag:"h2"}}),x=new Ke({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit2/smolagents/retrieval_agents.mdx"}}),{c(){r=i("meta"),F=n(),H=i("p"),$=n(),c(h.$$.fragment),Y=n(),c(d.$$.fragment),L=n(),U=i("p"),U.textContent=ge,D=n(),J=i("p"),J.innerHTML=Ie,P=n(),T=i("p"),T.innerHTML=Be,K=n(),w=i("p"),w.innerHTML=fe,O=n(),b=i("p"),b.textContent=Ae,ee=n(),c(g.$$.fragment),le=n(),I=i("p"),I.textContent=ve,te=n(),B=i("ul"),B.innerHTML=Ce,se=n(),f=i("p"),f.textContent=Ge,ne=n(),c(A.$$.fragment),ae=n(),v=i("p"),v.textContent=Ze,ie=n(),C=i("ol"),C.innerHTML=Re,Me=n(),c(G.$$.fragment),oe=n(),Z=i("p"),Z.textContent=ke,re=n(),R=i("p"),R.textContent=Ve,ce=n(),c(k.$$.fragment),pe=n(),V=i("p"),V.textContent=Ee,ye=n(),E=i("ol"),E.innerHTML=Qe,je=n(),c(Q.$$.fragment),ue=n(),q=i("p"),q.textContent=qe,me=n(),W=i("ol"),W.innerHTML=We,he=n(),X=i("p"),X.innerHTML=Xe,de=n(),c(N.$$.fragment),Ue=n(),S=i("ul"),S.innerHTML=Ne,Je=n(),c(x.$$.fragment),Te=n(),z=i("p"),this.h()},l(e){const l=Le("svelte-u9bgzb",document.head);r=M(l,"META",{name:!0,content:!0}),l.forEach(t),F=a(e),H=M(e,"P",{}),Se(H).forEach(t),$=a(e),p(h.$$.fragment,e),Y=a(e),p(d.$$.fragment,e),L=a(e),U=M(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-wavrhk"&&(U.textContent=ge),D=a(e),J=M(e,"P",{"data-svelte-h":!0}),o(J)!=="svelte-113063o"&&(J.innerHTML=Ie),P=a(e),T=M(e,"P",{"data-svelte-h":!0}),o(T)!=="svelte-u5f09e"&&(T.innerHTML=Be),K=a(e),w=M(e,"P",{"data-svelte-h":!0}),o(w)!=="svelte-124380o"&&(w.innerHTML=fe),O=a(e),b=M(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1lb37r2"&&(b.textContent=Ae),ee=a(e),p(g.$$.fragment,e),le=a(e),I=M(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1uinlt6"&&(I.textContent=ve),te=a(e),B=M(e,"UL",{"data-svelte-h":!0}),o(B)!=="svelte-4vqfph"&&(B.innerHTML=Ce),se=a(e),f=M(e,"P",{"data-svelte-h":!0}),o(f)!=="svelte-jm6fh2"&&(f.textContent=Ge),ne=a(e),p(A.$$.fragment,e),ae=a(e),v=M(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-21wqo5"&&(v.textContent=Ze),ie=a(e),C=M(e,"OL",{"data-svelte-h":!0}),o(C)!=="svelte-sf2q8s"&&(C.innerHTML=Re),Me=a(e),p(G.$$.fragment,e),oe=a(e),Z=M(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1jei959"&&(Z.textContent=ke),re=a(e),R=M(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-10x3i2g"&&(R.textContent=Ve),ce=a(e),p(k.$$.fragment,e),pe=a(e),V=M(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-17lgk8z"&&(V.textContent=Ee),ye=a(e),E=M(e,"OL",{"data-svelte-h":!0}),o(E)!=="svelte-19rqcrr"&&(E.innerHTML=Qe),je=a(e),p(Q.$$.fragment,e),ue=a(e),q=M(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-gryz7r"&&(q.textContent=qe),me=a(e),W=M(e,"OL",{"data-svelte-h":!0}),o(W)!=="svelte-1pxkx51"&&(W.innerHTML=We),he=a(e),X=M(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-qnv9nq"&&(X.innerHTML=Xe),de=a(e),p(N.$$.fragment,e),Ue=a(e),S=M(e,"UL",{"data-svelte-h":!0}),o(S)!=="svelte-1myvltt"&&(S.innerHTML=Ne),Je=a(e),p(x.$$.fragment,e),Te=a(e),z=M(e,"P",{}),Se(z).forEach(t),this.h()},h(){xe(r,"name","hf:doc:metadata"),xe(r,"content",el)},m(e,l){De(document.head,r),s(e,F,l),s(e,H,l),s(e,$,l),y(h,e,l),s(e,Y,l),y(d,e,l),s(e,L,l),s(e,U,l),s(e,D,l),s(e,J,l),s(e,P,l),s(e,T,l),s(e,K,l),s(e,w,l),s(e,O,l),s(e,b,l),s(e,ee,l),y(g,e,l),s(e,le,l),s(e,I,l),s(e,te,l),s(e,B,l),s(e,se,l),s(e,f,l),s(e,ne,l),y(A,e,l),s(e,ae,l),s(e,v,l),s(e,ie,l),s(e,C,l),s(e,Me,l),y(G,e,l),s(e,oe,l),s(e,Z,l),s(e,re,l),s(e,R,l),s(e,ce,l),y(k,e,l),s(e,pe,l),s(e,V,l),s(e,ye,l),s(e,E,l),s(e,je,l),y(Q,e,l),s(e,ue,l),s(e,q,l),s(e,me,l),s(e,W,l),s(e,he,l),s(e,X,l),s(e,de,l),y(N,e,l),s(e,Ue,l),s(e,S,l),s(e,Je,l),y(x,e,l),s(e,Te,l),s(e,z,l),we=!0},p:_e,i(e){we||(j(h.$$.fragment,e),j(d.$$.fragment,e),j(g.$$.fragment,e),j(A.$$.fragment,e),j(G.$$.fragment,e),j(k.$$.fragment,e),j(Q.$$.fragment,e),j(N.$$.fragment,e),j(x.$$.fragment,e),we=!0)},o(e){u(h.$$.fragment,e),u(d.$$.fragment,e),u(g.$$.fragment,e),u(A.$$.fragment,e),u(G.$$.fragment,e),u(k.$$.fragment,e),u(Q.$$.fragment,e),u(N.$$.fragment,e),u(x.$$.fragment,e),we=!1},d(e){e&&(t(F),t(H),t($),t(Y),t(L),t(U),t(D),t(J),t(P),t(T),t(K),t(w),t(O),t(b),t(ee),t(le),t(I),t(te),t(B),t(se),t(f),t(ne),t(ae),t(v),t(ie),t(C),t(Me),t(oe),t(Z),t(re),t(R),t(ce),t(pe),t(V),t(ye),t(E),t(je),t(ue),t(q),t(me),t(W),t(he),t(X),t(de),t(Ue),t(S),t(Je),t(Te),t(z)),t(r),m(h,e),m(d,e),m(g,e),m(A,e),m(G,e),m(k,e),m(Q,e),m(N,e),m(x,e)}}}const el='{"title":"Building Agentic RAG Systems","local":"building-agentic-rag-systems","sections":[{"title":"Basic Retrieval with DuckDuckGo","local":"basic-retrieval-with-duckduckgo","sections":[],"depth":2},{"title":"Custom Knowledge Base Tool","local":"custom-knowledge-base-tool","sections":[],"depth":2},{"title":"Enhanced Retrieval Capabilities","local":"enhanced-retrieval-capabilities","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function ll(be){return Fe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ol extends $e{constructor(r){super(),Ye(this,r,ll,Oe,ze,{})}}export{ol as component};
