import{s as fs,n as js,o as Ms}from"../chunks/scheduler.9f522b10.js";import{S as ys,i as ws,g as p,s as l,r as c,A as Ts,h as i,f as a,c as n,j as bs,u as r,x as h,k as Q,y as Js,a as e,v as u,d as g,t as d,w as b}from"../chunks/index.4a68349c.js";import{C as v}from"../chunks/CodeBlock.46fa3bb1.js";import{H as ns,E as Us}from"../chunks/getInferenceSnippets.ff325272.js";function Zs(ps){let m,F,X,V,f,H,o,is='<img alt="Open In Colab" class="!m-0" src="https://colab.research.google.com/assets/colab-badge.svg"/>',Y,j,os='<code>Safetensors</code> is really fast. Let’s compare it against <code>PyTorch</code> by loading <a href="https://huggingface.co/gpt2" rel="nofollow">gpt2</a> weights. To run the <a href="#gpu-benchmark">GPU benchmark</a>, make sure your machine has GPU or you have selected <code>GPU runtime</code> if you are using Google Colab.',N,M,ms="Before you begin, make sure you have all the necessary libraries installed:",q,y,x,w,cs="Let’s start by importing all the packages that will be used:",S,T,E,J,rs="Download safetensors & torch weights for gpt2:",L,U,P,Z,A,_,z,G,hs=`This speedup is due to the fact that this library avoids unnecessary copies by mapping the file directly. It is actually possible to do on <a href="https://gist.github.com/Narsil/3edeec2669a5e94e4707aa0f901d2282" rel="nofollow">pure pytorch</a>.
The currently shown speedup was gotten on:`,K,W,us="<li>OS: Ubuntu 18.04.6 LTS</li> <li>CPU: Intel(R) Xeon(R) CPU @ 2.00GHz</li>",D,B,O,$,ss,I,gs=`The speedup works because this library is able to skip unnecessary CPU allocations. It is unfortunately not replicable in pure pytorch as far as we know. The library works by memory mapping the file, creating the tensor empty with pytorch and calling <code>cudaMemcpy</code> directly to move the tensor directly on the GPU.
The currently shown speedup was gotten on:`,ts,k,ds="<li>OS: Ubuntu 18.04.6 LTS.</li> <li>GPU: Tesla T4</li> <li>Driver Version: 460.32.03</li> <li>CUDA Version: 11.2</li>",as,R,es,C,ls;return f=new ns({props:{title:"Speed Comparison",local:"speed-comparison",headingTag:"h1"}}),y=new v({props:{code:"cGlwJTIwaW5zdGFsbCUyMHNhZmV0ZW5zb3JzJTIwaHVnZ2luZ2ZhY2VfaHViJTIwdG9yY2g=",highlighted:"pip install safetensors huggingface_hub torch",wrap:!1}}),T=new v({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjBkYXRldGltZSUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBoZl9odWJfZG93bmxvYWQlMEFmcm9tJTIwc2FmZXRlbnNvcnMudG9yY2glMjBpbXBvcnQlMjBsb2FkX2ZpbGUlMEFpbXBvcnQlMjB0b3JjaA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> os
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> datetime
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> safetensors.torch <span class="hljs-keyword">import</span> load_file
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch`,wrap:!1}}),U=new v({props:{code:"c2ZfZmlsZW5hbWUlMjAlM0QlMjBoZl9odWJfZG93bmxvYWQoJTIyZ3B0MiUyMiUyQyUyMGZpbGVuYW1lJTNEJTIybW9kZWwuc2FmZXRlbnNvcnMlMjIpJTBBcHRfZmlsZW5hbWUlMjAlM0QlMjBoZl9odWJfZG93bmxvYWQoJTIyZ3B0MiUyMiUyQyUyMGZpbGVuYW1lJTNEJTIycHl0b3JjaF9tb2RlbC5iaW4lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>sf_filename = hf_hub_download(<span class="hljs-string">&quot;gpt2&quot;</span>, filename=<span class="hljs-string">&quot;model.safetensors&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pt_filename = hf_hub_download(<span class="hljs-string">&quot;gpt2&quot;</span>, filename=<span class="hljs-string">&quot;pytorch_model.bin&quot;</span>)`,wrap:!1}}),Z=new ns({props:{title:"CPU benchmark",local:"cpu-benchmark",headingTag:"h3"}}),_=new v({props:{code:"c3RhcnRfc3QlMjAlM0QlMjBkYXRldGltZS5kYXRldGltZS5ub3coKSUwQXdlaWdodHMlMjAlM0QlMjBsb2FkX2ZpbGUoc2ZfZmlsZW5hbWUlMkMlMjBkZXZpY2UlM0QlMjJjcHUlMjIpJTBBbG9hZF90aW1lX3N0JTIwJTNEJTIwZGF0ZXRpbWUuZGF0ZXRpbWUubm93KCklMjAtJTIwc3RhcnRfc3QlMEFwcmludChmJTIyTG9hZGVkJTIwc2FmZXRlbnNvcnMlMjAlN0Jsb2FkX3RpbWVfc3QlN0QlMjIpJTBBJTBBc3RhcnRfcHQlMjAlM0QlMjBkYXRldGltZS5kYXRldGltZS5ub3coKSUwQXdlaWdodHMlMjAlM0QlMjB0b3JjaC5sb2FkKHB0X2ZpbGVuYW1lJTJDJTIwbWFwX2xvY2F0aW9uJTNEJTIyY3B1JTIyKSUwQWxvYWRfdGltZV9wdCUyMCUzRCUyMGRhdGV0aW1lLmRhdGV0aW1lLm5vdygpJTIwLSUyMHN0YXJ0X3B0JTBBcHJpbnQoZiUyMkxvYWRlZCUyMHB5dG9yY2glMjAlN0Jsb2FkX3RpbWVfcHQlN0QlMjIpJTBBJTBBcHJpbnQoZiUyMm9uJTIwQ1BVJTJDJTIwc2FmZXRlbnNvcnMlMjBpcyUyMGZhc3RlciUyMHRoYW4lMjBweXRvcmNoJTIwYnklM0ElMjAlN0Jsb2FkX3RpbWVfcHQlMkZsb2FkX3RpbWVfc3QlM0EuMWYlN0QlMjBYJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>start_st = datetime.datetime.now()
<span class="hljs-meta">&gt;&gt;&gt; </span>weights = load_file(sf_filename, device=<span class="hljs-string">&quot;cpu&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>load_time_st = datetime.datetime.now() - start_st
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Loaded safetensors <span class="hljs-subst">{load_time_st}</span>&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>start_pt = datetime.datetime.now()
<span class="hljs-meta">&gt;&gt;&gt; </span>weights = torch.load(pt_filename, map_location=<span class="hljs-string">&quot;cpu&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>load_time_pt = datetime.datetime.now() - start_pt
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Loaded pytorch <span class="hljs-subst">{load_time_pt}</span>&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;on CPU, safetensors is faster than pytorch by: <span class="hljs-subst">{load_time_pt/load_time_st:<span class="hljs-number">.1</span>f}</span> X&quot;</span>)
Loaded safetensors <span class="hljs-number">0</span>:<span class="hljs-number">00</span>:<span class="hljs-number">00.004015</span>
Loaded pytorch <span class="hljs-number">0</span>:<span class="hljs-number">00</span>:<span class="hljs-number">00.307460</span>
on CPU, safetensors <span class="hljs-keyword">is</span> faster than pytorch by: <span class="hljs-number">76.6</span> X`,wrap:!1}}),B=new ns({props:{title:"GPU benchmark",local:"gpu-benchmark",headingTag:"h3"}}),$=new v({props:{code:"JTIzJTIwVGhpcyUyMGlzJTIwcmVxdWlyZWQlMjBiZWNhdXNlJTIwdGhpcyUyMGZlYXR1cmUlMjBoYXNuJ3QlMjBiZWVuJTIwZnVsbHklMjB2ZXJpZmllZCUyMHlldCUyQyUyMGJ1dCUyMCUwQSUyMyUyMGl0J3MlMjBiZWVuJTIwdGVzdGVkJTIwb24lMjBtYW55JTIwZGlmZmVyZW50JTIwZW52aXJvbm1lbnRzJTBBb3MuZW52aXJvbiU1QiUyMlNBRkVURU5TT1JTX0ZBU1RfR1BVJTIyJTVEJTIwJTNEJTIwJTIyMSUyMiUwQSUwQSUyMyUyMENVREElMjBzdGFydHVwJTIwb3V0JTIwb2YlMjB0aGUlMjBtZWFzdXJlbWVudCUwQXRvcmNoLnplcm9zKCgyJTJDJTIwMikpLmN1ZGEoKSUwQSUwQXN0YXJ0X3N0JTIwJTNEJTIwZGF0ZXRpbWUuZGF0ZXRpbWUubm93KCklMEF3ZWlnaHRzJTIwJTNEJTIwbG9hZF9maWxlKHNmX2ZpbGVuYW1lJTJDJTIwZGV2aWNlJTNEJTIyY3VkYSUzQTAlMjIpJTBBbG9hZF90aW1lX3N0JTIwJTNEJTIwZGF0ZXRpbWUuZGF0ZXRpbWUubm93KCklMjAtJTIwc3RhcnRfc3QlMEFwcmludChmJTIyTG9hZGVkJTIwc2FmZXRlbnNvcnMlMjAlN0Jsb2FkX3RpbWVfc3QlN0QlMjIpJTBBJTBBc3RhcnRfcHQlMjAlM0QlMjBkYXRldGltZS5kYXRldGltZS5ub3coKSUwQXdlaWdodHMlMjAlM0QlMjB0b3JjaC5sb2FkKHB0X2ZpbGVuYW1lJTJDJTIwbWFwX2xvY2F0aW9uJTNEJTIyY3VkYSUzQTAlMjIpJTBBbG9hZF90aW1lX3B0JTIwJTNEJTIwZGF0ZXRpbWUuZGF0ZXRpbWUubm93KCklMjAtJTIwc3RhcnRfcHQlMEFwcmludChmJTIyTG9hZGVkJTIwcHl0b3JjaCUyMCU3QmxvYWRfdGltZV9wdCU3RCUyMiklMEElMEFwcmludChmJTIyb24lMjBHUFUlMkMlMjBzYWZldGVuc29ycyUyMGlzJTIwZmFzdGVyJTIwdGhhbiUyMHB5dG9yY2glMjBieSUzQSUyMCU3QmxvYWRfdGltZV9wdCUyRmxvYWRfdGltZV9zdCUzQS4xZiU3RCUyMFglMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This is required because this feature hasn&#x27;t been fully verified yet, but </span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># it&#x27;s been tested on many different environments</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>os.environ[<span class="hljs-string">&quot;SAFETENSORS_FAST_GPU&quot;</span>] = <span class="hljs-string">&quot;1&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># CUDA startup out of the measurement</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>torch.zeros((<span class="hljs-number">2</span>, <span class="hljs-number">2</span>)).cuda()

<span class="hljs-meta">&gt;&gt;&gt; </span>start_st = datetime.datetime.now()
<span class="hljs-meta">&gt;&gt;&gt; </span>weights = load_file(sf_filename, device=<span class="hljs-string">&quot;cuda:0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>load_time_st = datetime.datetime.now() - start_st
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Loaded safetensors <span class="hljs-subst">{load_time_st}</span>&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>start_pt = datetime.datetime.now()
<span class="hljs-meta">&gt;&gt;&gt; </span>weights = torch.load(pt_filename, map_location=<span class="hljs-string">&quot;cuda:0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>load_time_pt = datetime.datetime.now() - start_pt
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Loaded pytorch <span class="hljs-subst">{load_time_pt}</span>&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;on GPU, safetensors is faster than pytorch by: <span class="hljs-subst">{load_time_pt/load_time_st:<span class="hljs-number">.1</span>f}</span> X&quot;</span>)
Loaded safetensors <span class="hljs-number">0</span>:<span class="hljs-number">00</span>:<span class="hljs-number">00.165206</span>
Loaded pytorch <span class="hljs-number">0</span>:<span class="hljs-number">00</span>:<span class="hljs-number">00.353889</span>
on GPU, safetensors <span class="hljs-keyword">is</span> faster than pytorch by: <span class="hljs-number">2.1</span> X`,wrap:!1}}),R=new Us({props:{source:"https://github.com/huggingface/safetensors/blob/main/docs/source/speed.mdx"}}),{c(){m=p("meta"),F=l(),X=p("p"),V=l(),c(f.$$.fragment),H=l(),o=p("a"),o.innerHTML=is,Y=l(),j=p("p"),j.innerHTML=os,N=l(),M=p("p"),M.textContent=ms,q=l(),c(y.$$.fragment),x=l(),w=p("p"),w.textContent=cs,S=l(),c(T.$$.fragment),E=l(),J=p("p"),J.textContent=rs,L=l(),c(U.$$.fragment),P=l(),c(Z.$$.fragment),A=l(),c(_.$$.fragment),z=l(),G=p("p"),G.innerHTML=hs,K=l(),W=p("ul"),W.innerHTML=us,D=l(),c(B.$$.fragment),O=l(),c($.$$.fragment),ss=l(),I=p("p"),I.innerHTML=gs,ts=l(),k=p("ul"),k.innerHTML=ds,as=l(),c(R.$$.fragment),es=l(),C=p("p"),this.h()},l(s){const t=Ts("svelte-u9bgzb",document.head);m=i(t,"META",{name:!0,content:!0}),t.forEach(a),F=n(s),X=i(s,"P",{}),bs(X).forEach(a),V=n(s),r(f.$$.fragment,s),H=n(s),o=i(s,"A",{href:!0,target:!0,class:!0,"data-svelte-h":!0}),h(o)!=="svelte-lfr1jd"&&(o.innerHTML=is),Y=n(s),j=i(s,"P",{"data-svelte-h":!0}),h(j)!=="svelte-1f2qiql"&&(j.innerHTML=os),N=n(s),M=i(s,"P",{"data-svelte-h":!0}),h(M)!=="svelte-1c9nexd"&&(M.textContent=ms),q=n(s),r(y.$$.fragment,s),x=n(s),w=i(s,"P",{"data-svelte-h":!0}),h(w)!=="svelte-x2g6fp"&&(w.textContent=cs),S=n(s),r(T.$$.fragment,s),E=n(s),J=i(s,"P",{"data-svelte-h":!0}),h(J)!=="svelte-ppqluq"&&(J.textContent=rs),L=n(s),r(U.$$.fragment,s),P=n(s),r(Z.$$.fragment,s),A=n(s),r(_.$$.fragment,s),z=n(s),G=i(s,"P",{"data-svelte-h":!0}),h(G)!=="svelte-12qeleu"&&(G.innerHTML=hs),K=n(s),W=i(s,"UL",{"data-svelte-h":!0}),h(W)!=="svelte-1truf0w"&&(W.innerHTML=us),D=n(s),r(B.$$.fragment,s),O=n(s),r($.$$.fragment,s),ss=n(s),I=i(s,"P",{"data-svelte-h":!0}),h(I)!=="svelte-1c8g3ot"&&(I.innerHTML=gs),ts=n(s),k=i(s,"UL",{"data-svelte-h":!0}),h(k)!=="svelte-1emnou5"&&(k.innerHTML=ds),as=n(s),r(R.$$.fragment,s),es=n(s),C=i(s,"P",{}),bs(C).forEach(a),this.h()},h(){Q(m,"name","hf:doc:metadata"),Q(m,"content",_s),Q(o,"href","https://colab.research.google.com/github/huggingface/notebooks/blob/main/safetensors_doc/en/speed.ipynb"),Q(o,"target","_blank"),Q(o,"class","absolute z-10 right-0 top-0")},m(s,t){Js(document.head,m),e(s,F,t),e(s,X,t),e(s,V,t),u(f,s,t),e(s,H,t),e(s,o,t),e(s,Y,t),e(s,j,t),e(s,N,t),e(s,M,t),e(s,q,t),u(y,s,t),e(s,x,t),e(s,w,t),e(s,S,t),u(T,s,t),e(s,E,t),e(s,J,t),e(s,L,t),u(U,s,t),e(s,P,t),u(Z,s,t),e(s,A,t),u(_,s,t),e(s,z,t),e(s,G,t),e(s,K,t),e(s,W,t),e(s,D,t),u(B,s,t),e(s,O,t),u($,s,t),e(s,ss,t),e(s,I,t),e(s,ts,t),e(s,k,t),e(s,as,t),u(R,s,t),e(s,es,t),e(s,C,t),ls=!0},p:js,i(s){ls||(g(f.$$.fragment,s),g(y.$$.fragment,s),g(T.$$.fragment,s),g(U.$$.fragment,s),g(Z.$$.fragment,s),g(_.$$.fragment,s),g(B.$$.fragment,s),g($.$$.fragment,s),g(R.$$.fragment,s),ls=!0)},o(s){d(f.$$.fragment,s),d(y.$$.fragment,s),d(T.$$.fragment,s),d(U.$$.fragment,s),d(Z.$$.fragment,s),d(_.$$.fragment,s),d(B.$$.fragment,s),d($.$$.fragment,s),d(R.$$.fragment,s),ls=!1},d(s){s&&(a(F),a(X),a(V),a(H),a(o),a(Y),a(j),a(N),a(M),a(q),a(x),a(w),a(S),a(E),a(J),a(L),a(P),a(A),a(z),a(G),a(K),a(W),a(D),a(O),a(ss),a(I),a(ts),a(k),a(as),a(es),a(C)),a(m),b(f,s),b(y,s),b(T,s),b(U,s),b(Z,s),b(_,s),b(B,s),b($,s),b(R,s)}}}const _s='{"title":"Speed Comparison","local":"speed-comparison","sections":[{"title":"CPU benchmark","local":"cpu-benchmark","sections":[],"depth":3},{"title":"GPU benchmark","local":"gpu-benchmark","sections":[],"depth":3}],"depth":1}';function Gs(ps){return Ms(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ks extends ys{constructor(m){super(),ws(this,m,Gs,Zs,fs,{})}}export{ks as component};
