import{s as It,n as gt,o as bt}from"../chunks/scheduler.7bc62968.js";import{S as Ct,i as Bt,g as M,s as e,r as c,m as ne,A as Gt,h as p,f as a,c as t,j as h,x as o,u as r,n as ee,k as te,y as i,a as n,v as J,d as y,t as j,w as T}from"../chunks/index.66556066.js";import{C as U}from"../chunks/CodeBlock.5372f996.js";import{H as w,E as ft}from"../chunks/getInferenceSnippets.4c17d703.js";function Zt(Me){let B,xl,Hl,_l,Z,pe='<br/> <picture><source media="(prefers-color-scheme: dark)" srcset="https://huggingface.co/datasets/huggingface/documentation-images/raw/main/huggingfacejs-dark.svg"/> <source media="(prefers-color-scheme: light)" srcset="https://huggingface.co/datasets/huggingface/documentation-images/raw/main/huggingfacejs-light.svg"/> <img alt="huggingface javascript library logo" src="https://huggingface.co/datasets/huggingface/documentation-images/raw/main/huggingfacejs-light.svg" width="376" height="59" style="max-width: 100%;"/></picture> <br/> <br/>',zl,N,Ll,W,oe="Welcome to the official Hugging Face JavaScript libraries! This is your one-stop shop for seamlessly integrating the power of Hugging Face into your JavaScript projects. Whether you’re building web applications, Node.js backends, or exploring AI in new frontiers like Deno and Bun, our libraries provide the tools you need.",$l,A,ie="<strong>What can you do with these libraries?</strong>",ql,R,ce="<li><strong>Run Inference with Ease:</strong> Access over 100,000 machine learning models for a vast array of tasks. From text generation and image classification to audio processing and beyond, tap into cutting-edge AI with just a few lines of code.</li> <li><strong>Interact with the Hugging Face Hub:</strong> Programmatically manage your models, datasets, and Spaces. Create repositories, upload files, and stay connected to the vibrant Hugging Face ecosystem.</li> <li><strong>Leverage Specialized Tools:</strong> Work with specific file formats like GGUF and DDUF, utilize Jinja templating for chat applications, and much more.</li>",Kl,S,re="<strong>Why choose Hugging Face JS?</strong>",Dl,Y,Je="<li><strong>TypeScript First:</strong> Enjoy the benefits of static typing for robust and maintainable code.</li> <li><strong>Modern JavaScript:</strong> Designed for modern environments (Node.js &gt;= 18, Deno, Bun, and contemporary browsers) to minimize dependencies and maximize performance.</li> <li><strong>Community Driven:</strong> We’re constantly evolving! Your feedback and contributions are invaluable in shaping the future of these libraries.</li>",Ol,V,ye="<strong>Get a taste of what’s possible:</strong>",Pl,Q,sa,F,la,H,je="Excited to see Hugging Face JS in action? Let’s get you started with a super simple text generation example. This will take just a few minutes!",aa,X,Te="<strong>Goal:</strong> Ask an AI to complete a sentence for you.",na,x,Ue="<strong>Environment:</strong> We’ll use Node.js for this example. Make sure you have it installed!",ea,_,he="<strong>Steps:</strong>",ta,m,z,ml,we=`<strong>Create a Project Folder &amp; Initialize:</strong>
Open your terminal and run:`,Gn,L,fn,$,ul,me=`<strong>Install <code>@huggingface/inference</code>:</strong>
This library lets you run AI models.`,Zn,q,kn,K,dl,ue="<strong>Get Your Hugging Face Access Token (Important!):</strong>",En,d,Il,de='Go to your <a href="https://huggingface.co/settings/tokens" rel="nofollow">Hugging Face account settings</a>.',vn,gl,Ie="Click “New token”. Give it a name (e.g., “my-js-app-token”) and assign it the “read” role.",Nn,bl,ge="Copy the generated token. <strong>Treat this like a password!</strong>",Wn,g,An,D,Rn,Cl,be="hf_YOUR_COPIED_TOKEN_HERE",Sn,Bl,Ce="For real projects, use a <code>.env</code> file or other secure methods to manage tokens.",Yn,G,Gl,Be=`<strong>Create Your JavaScript File:</strong>
Create a file named <code>index.js</code> in your <code>my-hf-js-app</code> folder and add this code:`,Vn,O,Qn,fl,Ge=`<em>Note: This example uses ES Modules (<code>import</code>). Your <code>package.json</code> should have <code>&quot;type&quot;: &quot;module&quot;</code> or you can save the file as <code>index.mjs</code>.</em>
To add <code>&quot;type&quot;: &quot;module&quot;</code> to <code>package.json</code>, you can do it manually or run:
<code>npm pkg set type=&quot;module&quot;</code>`,Fn,f,Zl,fe=`<strong>Run Your Code!</strong>
Back in your terminal (in the <code>my-hf-js-app</code> directory):`,Hn,P,Xn,kl,Ze="You should see the AI complete your sentence! How cool is that? 😎",Ma,ss,ke="You’ve officially run your first AI task using Hugging Face JS! From here, you can explore more models, different AI tasks, and integrate this power into your own applications.",pa,oa,ia,ls,ca,as,Ee="The Quick Start got you running, but let’s look at the standard installation methods for different project types.",ra,ns,Ja,es,ve="Pick the installation method that fits your development style:",ya,ts,Ne="<strong>1. For Node.js, Bun, or Web Projects (using a bundler like Webpack or Vite):</strong>",ja,Ms,We="Use your favorite package manager (<code>npm</code>, <code>yarn</code>, or <code>pnpm</code>) to add the libraries.",Ta,ps,Ae="Install only the packages you need. For example, to use AI models and manage your Hugging Face Hub repositories:",Ua,os,ha,is,Re="Then, import them into your TypeScript or JavaScript code:",wa,cs,ma,rs,Se="<strong>2. For Plain JavaScript in the Browser (using a CDN):</strong>",ua,Js,Ye="No build step? No problem! You can use our libraries directly in your HTML files. We recommend using ES modules for this.",da,ys,Ia,js,Ve='<strong>Important Note:</strong> Replace <code>LATEST_VERSION</code> with the current latest version number of each package (e.g., <code>@4.0.6</code>). You can find this on <a href="https://www.npmjs.com/package/@huggingface/inference" rel="nofollow">npm</a>. Be cautious with your Hugging Face token in client-side browser code; it’s often better to have a backend make authenticated API calls.',ga,Ts,Qe="<strong>3. For Deno Projects:</strong>",ba,Us,Fe="Deno makes it easy to use modules directly from URLs. You can use CDNs like esm.sh or import directly from npm:",Ca,hs,Ba,ws,Ga,ms,He="Your Hugging Face token is your key to accessing models and managing your Hub account. <strong>Protect it like a password!</strong>",fa,us,Xe="<li><strong>Best Practice:</strong> Use environment variables (e.g., <code>({}).HF_TOKEN</code> in Node.js, <code>Deno.env.get(&quot;HF_TOKEN&quot;)</code> in Deno).</li> <li>For local development, <code>dotenv</code> (npm package) is great for loading variables from a <code>.env</code> file (make sure to add <code>.env</code> to your <code>.gitignore</code>!).</li> <li><strong>Avoid hardcoding tokens directly in your source code</strong>, especially if the code will be public or shared.</li>",Za,ds,ka,Is,xe="The Quick Start showed a Node.js example. The core logic is similar across environments once you have the <code>InferenceClient</code> initialized.",Ea,gs,_e="Here’s the Node.js example again for reference, focusing on the AI part:",va,b,El,ze="<p><strong>Ensure Token is Set:</strong> (As shown in the Quick Start or via <code>.env</code>)</p>",xn,bs,vl,Le="<strong>Write the Code:</strong>",_n,Cs,zn,Bs,Nl,$e="<strong>Run It:</strong> (Assuming <code>HF_TOKEN</code> is set in your terminal session)",Ln,Gs,Na,fs,qe="Now you’re equipped with the installation know-how! Let’s explore what these libraries can do.",Wa,Zs,Aa,ks,Ke="This repository is your gateway to a powerful suite of JavaScript libraries, meticulously crafted to connect your projects with the vast Hugging Face ecosystem. All libraries are written in TypeScript, ensuring type safety and a great developer experience, and they compile to standard JavaScript for broad compatibility.",Ra,Es,De="Here’s a breakdown of the tools at your disposal:",Sa,vs,Oe='<li><strong><code>@huggingface/inference</code></strong>: (<a href="inference/README">Dive into the Docs</a> | <a href="https://www.npmjs.com/package/@huggingface/inference" rel="nofollow">See on npm</a>)<ul><li><strong>Purpose:</strong> Your primary tool for running AI models. This is where the magic happens!</li> <li><strong>Key Features:</strong><ul><li>🧠 Access tens of thousands of pre-trained models for a huge variety of tasks: text generation, image creation, code completion, summarization, translation, audio processing, and much more.</li> <li>🚀 Supports multiple inference providers:<ul><li>Hugging Face’s own Inference API (free tier available for many models).</li> <li>Dedicated Inference Endpoints (for production-grade performance and reliability).</li> <li>Third-party services like Replicate, Cohere, Together AI, and others, giving you flexibility and access to even more specialized hardware.</li></ul></li> <li>💻 Works seamlessly in Node.js, browsers, Deno, and Bun.</li></ul></li></ul></li> <li><strong><code>@huggingface/hub</code></strong>: (<a href="hub/README">Dive into the Docs</a> | <a href="https://www.npmjs.com/package/@huggingface/hub" rel="nofollow">See on npm</a>)<ul><li><strong>Purpose:</strong> Programmatically manage your models, datasets, and Spaces on the Hugging Face Hub.</li> <li><strong>Key Features:</strong><ul><li>📁 Create, update, and delete repositories (for models, datasets, or Spaces).</li> <li>📤 Upload and download files (like model weights, configuration files, or datasets).</li> <li>🔍 List repository contents, manage branches, and interact with repository metadata.</li></ul></li></ul></li> <li><strong><code>@huggingface/agents</code></strong> (formerly part of <code>@huggingface/mcp-client</code>): (<a href="agents/README">Dive into the Docs</a> | <a href="https://www.npmjs.com/package/@huggingface/agents" rel="nofollow">See on npm</a>)<ul><li><strong>Purpose:</strong> Build sophisticated AI agents that can reason, plan, and use tools to accomplish complex tasks.</li> <li><strong>Key Features:</strong><ul><li>🤖 Provides a framework for creating agents powered by Large Language Models (LLMs).</li> <li>🛠️ Enables agents to use “tools” (custom functions or external APIs) to gather information or perform actions (e.g., web search, calculations, interacting with other services).</li> <li>dibangun on top of <code>@huggingface/inference</code> for model interaction.</li></ul></li></ul></li> <li><strong><code>@huggingface/gguf</code></strong>: (<a href="gguf/README">Dive into the Docs</a> | <a href="https://www.npmjs.com/package/@huggingface/gguf" rel="nofollow">See on npm</a>)<ul><li><strong>Purpose:</strong> Work with GGUF (GPT-Generated Unified Format) model files.</li> <li><strong>Key Features:</strong> A robust JavaScript parser for the GGUF format, which is highly popular for running LLMs efficiently on CPUs and various hardware. It can even parse GGUF files hosted remotely without downloading the entire file.</li></ul></li> <li><strong><code>@huggingface/dduf</code></strong>: (<a href="dduf/README">Dive into the Docs</a> | <a href="https://www.npmjs.com/package/@huggingface/dduf" rel="nofollow">See on npm</a>)<ul><li><strong>Purpose:</strong> Similar to <code>@huggingface/gguf</code>, but for DDUF files.</li> <li><strong>Key Features:</strong> A parser for DDUF (Diffusers Unified Format), often used with diffusion models (especially for image generation tasks).</li></ul></li> <li><strong><code>@huggingface/tasks</code></strong>: (<a href="tasks/README">Dive into the Docs</a> | <a href="https://www.npmjs.com/package/@huggingface/tasks" rel="nofollow">See on npm</a>)<ul><li><strong>Purpose:</strong> Contains the definitions and metadata for standard AI tasks and other primitives used across the Hugging Face Hub.</li> <li><strong>Key Features:</strong> This is the canonical source for information like “pipeline tasks” (e.g., <code>text-generation</code>, <code>image-classification</code>), model library names (e.g., <code>transformers</code>, <code>diffusers</code>), widget examples, and more. Essential if you’re building tools that deeply integrate with the Hub’s structure.</li></ul></li> <li><strong><code>@huggingface/jinja</code></strong>: (<a href="jinja/README">Dive into the Docs</a> | <a href="https://www.npmjs.com/package/@huggingface/jinja" rel="nofollow">See on npm</a>)<ul><li><strong>Purpose:</strong> A JavaScript implementation of the Jinja templating engine.</li> <li><strong>Key Features:</strong> Many LLMs expect their inputs (prompts) to be formatted using Jinja templates, especially for chat applications. This library allows you to render those templates correctly in your JavaScript environment.</li></ul></li> <li><strong><code>@huggingface/space-header</code></strong>: (<a href="space-header/README">Dive into the Docs</a> | <a href="https://www.npmjs.com/package/@huggingface/space-header" rel="nofollow">See on npm</a>)<ul><li><strong>Purpose:</strong> Embed the standard Hugging Face Space header component in your own web applications.</li> <li><strong>Key Features:</strong> Easily include the familiar <code>mini_header</code> from Hugging Face Spaces into your projects, even if they are hosted outside the Hugging Face platform, providing a consistent look and feel.</li></ul></li> <li><strong><code>@huggingface/ollama-utils</code></strong>: (<a href="ollama-utils/README">Dive into the Docs</a> | <a href="https://www.npmjs.com/package/@huggingface/ollama-utils" rel="nofollow">See on npm</a>)<ul><li><strong>Purpose:</strong> Utilities to improve compatibility and integration with Ollama.</li> <li><strong>Key Features:</strong> Provides tools to help align models running via Ollama (a popular tool for running LLMs locally) with the Hugging Face Hub ecosystem, particularly around chat templates and model metadata.</li></ul></li>',Ya,Ns,Pe="<strong>✨ Built for the Modern Web &amp; Beyond:</strong>",Va,Ws,st="We embrace modern JavaScript to deliver libraries that are:",Qa,As,lt="<li><strong>Lean &amp; Efficient:</strong> Minimizing unnecessary polyfills and dependencies.</li> <li><strong>Versatile:</strong> Optimized for a wide range of environments:<ul><li><strong>Browsers:</strong> Latest versions of Chrome, Firefox, Safari, and Edge.</li> <li><strong>Node.js:</strong> Version 18 or newer is recommended.</li> <li><strong>Deno &amp; Bun:</strong> First-class support for these exciting new runtimes.</li></ul></li>",Fa,Rs,at="<strong>🤝 We Value Your Voice!</strong>",Ha,Ss,nt="These libraries are a community effort. Your feedback, bug reports, and feature ideas are what drive improvement and innovation.",Xa,Ys,et='<li>Encounter an issue or have a suggestion? Please <strong><a href="https://github.com/huggingface/huggingface.js/issues" rel="nofollow">open an issue on GitHub</a></strong>!</li> <li>Want to contribute directly? That’s amazing! Check out our <a href="CONTRIBUTING">CONTRIBUTING.md</a> guide.</li>',xa,Vs,_a,Qs,tt='Let’s explore more practical ways to use our core libraries. Remember to have your Hugging Face access token handy (and secure!). You can create one in your <a href="https://huggingface.co/settings/tokens" rel="nofollow">Hugging Face account settings</a>.',za,Fs,La,Hs,Mt="Let’s dive into more examples with the <code>@huggingface/inference</code> library. This is your go-to for making AI models do cool things!",$a,Xs,qa,xs,Ka,_s,pt="The <code>@huggingface/hub</code> library helps you manage your models, datasets, and Spaces programmatically.",Da,zs,Oa,Ls,Pa,$s,ot="The <code>@huggingface/mcp-client</code> is for more advanced use cases, like creating AI agents that can use tools to perform actions.",sn,qs,ln,Ks,it="These examples are designed to be more illustrative and easier to understand. Remember to install necessary libraries (<code>@huggingface/inference</code>, <code>@huggingface/hub</code>, <code>@huggingface/mcp-client</code>) and set up your <code>HF_TOKEN</code> environment variable.",an,Ds,ct="Explore the individual <code>README.md</code> files within each <code>packages/*</code> directory for even more detailed documentation on each library.",nn,Os,en,Ps,rt="We believe in the power of community! Your contributions, feedback, and ideas are what make these libraries great.",tn,sl,Jt='<li><strong>Found a bug? Have a feature idea?</strong> Please <a href="https://github.com/huggingface/huggingface.js/issues" rel="nofollow">open an issue</a>!</li> <li><strong>Want to contribute code?</strong> That’s fantastic! Check out our <a href="CONTRIBUTING">CONTRIBUTING.md</a> guide to get started.</li>',Mn,ll,pn,al,yt="If you’re ready to dive into the code and contribute:",on,u,nl,Wl,jt="<strong>Enable Corepack:</strong> This tool helps manage <code>pnpm</code>, our package manager.",$n,el,qn,tl,Al,Tt="<strong>Install All Dependencies:</strong> From the root of this monorepo:",Kn,Ml,Dn,I,Rl,Ut="<strong>Code Quality Checks:</strong> We use Prettier for formatting and ESLint for linting.",On,pl,Pn,Sl,ht="To automatically fix formatting issues:",se,ol,le,il,Yl,wt=`<strong>Running Tests:</strong>
Ensure all tests pass before submitting a pull request:`,ae,cl,cn,rl,rn,Jl,mt="To build all packages:",Jn,yl,yn,jl,ut="This command will generate ESM (ECMAScript Modules) and CJS (CommonJS) JavaScript files in the <code>dist</code> directory of each package (e.g., <code>packages/inference/dist/index.mjs</code> and <code>packages/inference/dist/index.js</code>).",jn,Tl,Tn,Ul,dt='These libraries are licensed under the <a href="LICENSE">LICENSE</a> file in the root of this repository.',Un,hl,hn,Xl,wn;return N=new w({props:{title:"Hugging Face JS Libraries: Supercharge Your JavaScript AI Applications!",local:"hugging-face-js-libraries-supercharge-your-javascript-ai-applications",headingTag:"h1"}}),Q=new U({props:{code:"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",highlighted:`<span class="hljs-comment">// Programmatically interact with the Hub</span>
<span class="hljs-keyword">import</span> { createRepo, uploadFile } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">await</span> <span class="hljs-title function_">createRepo</span>({
  <span class="hljs-attr">repo</span>: { <span class="hljs-attr">type</span>: <span class="hljs-string">&quot;model&quot;</span>, <span class="hljs-attr">name</span>: <span class="hljs-string">&quot;my-user/nlp-model&quot;</span> },
  <span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_TOKEN</span> <span class="hljs-comment">// Your Hugging Face access token</span>
});

<span class="hljs-keyword">await</span> <span class="hljs-title function_">uploadFile</span>({
  <span class="hljs-attr">repo</span>: <span class="hljs-string">&quot;my-user/nlp-model&quot;</span>,
  <span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_TOKEN</span>,
  <span class="hljs-attr">file</span>: {
    <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;pytorch_model.bin&quot;</span>,
    <span class="hljs-attr">content</span>: <span class="hljs-keyword">new</span> <span class="hljs-title class_">Blob</span>([<span class="hljs-string">&quot;mock model data&quot;</span>]) <span class="hljs-comment">// Example with a Blob</span>
  }
});

<span class="hljs-comment">// Run AI models for various tasks</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">InferenceClient</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/inference&quot;</span>;

<span class="hljs-keyword">const</span> inference = <span class="hljs-keyword">new</span> <span class="hljs-title class_">InferenceClient</span>(<span class="hljs-variable constant_">HF_TOKEN</span>); <span class="hljs-comment">// Your Hugging Face Token</span>

<span class="hljs-comment">// Example: Chat with an AI model</span>
<span class="hljs-keyword">const</span> { choices } = <span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">chatCompletion</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;meta-llama/Llama-3.1-8B-Instruct&quot;</span>, <span class="hljs-comment">// Choose your model</span>
  <span class="hljs-attr">provider</span>: <span class="hljs-string">&quot;sambanova&quot;</span>, <span class="hljs-comment">// Optionally, specify a provider like Sambanova, Together AI, etc.</span>
  <span class="hljs-attr">messages</span>: [{ <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span> }],
  <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">512</span>, <span class="hljs-comment">// Control the length of the response</span>
});
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(choices[<span class="hljs-number">0</span>].<span class="hljs-property">message</span>.<span class="hljs-property">content</span>); <span class="hljs-comment">// Display the AI&#x27;s message</span>

<span class="hljs-comment">// Example: Generate an image from text</span>
<span class="hljs-keyword">const</span> imageBlob = <span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">textToImage</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>, <span class="hljs-comment">// Choose your image generation model</span>
  <span class="hljs-attr">provider</span>: <span class="hljs-string">&quot;replicate&quot;</span>, <span class="hljs-comment">// Optionally, specify a provider</span>
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&quot;A vibrant painting of a futuristic city&quot;</span>,
});
<span class="hljs-comment">// imageBlob now contains the image data (e.g., display it on a webpage or save it)</span>

<span class="hljs-comment">// ...and explore many other AI tasks!</span>`,wrap:!1}}),F=new w({props:{title:"🚀 Quick Start: Your First AI Adventure in 5 Minutes! 🌟",local:"-quick-start-your-first-ai-adventure-in-5-minutes-",headingTag:"h2"}}),L=new U({props:{code:"bWtkaXIlMjBteS1oZi1qcy1hcHAlMEFjZCUyMG15LWhmLWpzLWFwcCUwQW5wbSUyMGluaXQlMjAteSUwQSUyMyUyMFRoaXMlMjBjcmVhdGVzJTIwYSUyMHBhY2thZ2UuanNvbiUyMGZpbGU=",highlighted:`<span class="hljs-built_in">mkdir</span> my-hf-js-app
<span class="hljs-built_in">cd</span> my-hf-js-app
npm init -y
<span class="hljs-comment"># This creates a package.json file</span>`,wrap:!1}}),q=new U({props:{code:"bnBtJTIwaW5zdGFsbCUyMCU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNl",highlighted:"npm install @huggingface/inference",wrap:!1}}),D=new U({props:{code:"JTIzJTIwT24lMjBtYWNPUyUyRkxpbnV4JTBBZXhwb3J0JTIwSEZfVE9LRU4lM0QlMjJoZl9ZT1VSX0NPUElFRF9UT0tFTl9IRVJFJTIyJTBBJTIzJTIwT24lMjBXaW5kb3dzJTIwKENvbW1hbmQlMjBQcm9tcHQpJTBBJTIzJTIwc2V0JTIwSEZfVE9LRU4lM0RoZl9ZT1VSX0NPUElFRF9UT0tFTl9IRVJFJTBBJTIzJTIwT24lMjBXaW5kb3dzJTIwKFBvd2VyU2hlbGwpJTBBJTIzJTIwJTI0ZW52JTNBSEZfVE9LRU4lM0QlMjJoZl9ZT1VSX0NPUElFRF9UT0tFTl9IRVJFJTIy",highlighted:`<span class="hljs-comment"># On macOS/Linux</span>
<span class="hljs-built_in">export</span> HF_TOKEN=<span class="hljs-string">&quot;hf_YOUR_COPIED_TOKEN_HERE&quot;</span>
<span class="hljs-comment"># On Windows (Command Prompt)</span>
<span class="hljs-comment"># set HF_TOKEN=hf_YOUR_COPIED_TOKEN_HERE</span>
<span class="hljs-comment"># On Windows (PowerShell)</span>
<span class="hljs-comment"># $env:HF_TOKEN=&quot;hf_YOUR_COPIED_TOKEN_HERE&quot;</span>`,wrap:!1}}),O=new U({props:{code:"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",highlighted:`<span class="hljs-comment">// index.js</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">InferenceClient</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/inference&quot;</span>;

<span class="hljs-keyword">async</span> <span class="hljs-keyword">function</span> <span class="hljs-title function_">runMyFirstAi</span>(<span class="hljs-params"></span>) {
  <span class="hljs-comment">// Get your Hugging Face token from the environment variable</span>
  <span class="hljs-keyword">const</span> hfToken = process.<span class="hljs-property">env</span>.<span class="hljs-property">HF_TOKEN</span>;

  <span class="hljs-keyword">if</span> (!hfToken) {
    <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">error</span>(<span class="hljs-string">&quot;🚨 Hugging Face token (HF_TOKEN) is not set!&quot;</span>);
    <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">&quot;Please set it as an environment variable.&quot;</span>);
    <span class="hljs-keyword">return</span>;
  }

  <span class="hljs-comment">// Initialize the Inference Client</span>
  <span class="hljs-keyword">const</span> client = <span class="hljs-keyword">new</span> <span class="hljs-title class_">InferenceClient</span>(hfToken);
  <span class="hljs-keyword">const</span> model = <span class="hljs-string">&quot;gpt2&quot;</span>; <span class="hljs-comment">// A classic, widely available text generation model</span>

  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">\`🤖 Asking model &quot;<span class="hljs-subst">\${model}</span>&quot; to complete a sentence...\`</span>);

  <span class="hljs-keyword">try</span> {
    <span class="hljs-keyword">const</span> response = <span class="hljs-keyword">await</span> client.<span class="hljs-title function_">textGeneration</span>({
      <span class="hljs-attr">model</span>: model,
      <span class="hljs-attr">inputs</span>: <span class="hljs-string">&quot;The best thing about coding is &quot;</span>, <span class="hljs-comment">// Your sentence starter</span>
      <span class="hljs-attr">parameters</span>: {
        <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">20</span>, <span class="hljs-comment">// How many new words the AI should add</span>
      },
    });

    <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">&quot;\\n✨ AI says:&quot;</span>);
    <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(response.<span class="hljs-property">generated_text</span>);
    <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">&quot;\\n🎉 You just ran your first AI task with Hugging Face JS!&quot;</span>);

  } <span class="hljs-keyword">catch</span> (error) {
    <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">error</span>(<span class="hljs-string">&quot;😭 Oh no, something went wrong:&quot;</span>, error.<span class="hljs-property">message</span>);
    <span class="hljs-keyword">if</span> (error.<span class="hljs-property">message</span>.<span class="hljs-title function_">includes</span>(<span class="hljs-string">&quot;authorization&quot;</span>)) {
      <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">error</span>(<span class="hljs-string">&quot;Check if your HF_TOKEN is correct and has &#x27;read&#x27; permissions.&quot;</span>);
    }
  }
}

<span class="hljs-title function_">runMyFirstAi</span>();`,wrap:!1}}),P=new U({props:{code:"bm9kZSUyMGluZGV4Lmpz",highlighted:"node index.js",wrap:!1}}),ls=new w({props:{title:"📚 Digging Deeper: Installation & Setup Options",local:"-digging-deeper-installation--setup-options",headingTag:"h2"}}),ns=new w({props:{title:"Installation: Add Hugging Face JS to Your Project",local:"installation-add-hugging-face-js-to-your-project",headingTag:"h3"}}),os=new U({props:{code:"bnBtJTIwaW5zdGFsbCUyMCU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNlJTIwJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMEElMjMlMjBPciUyMHlhcm4lMjBhZGQlMjAlNDBodWdnaW5nZmFjZSUyRmluZmVyZW5jZSUyMCU0MGh1Z2dpbmdmYWNlJTJGaHViJTBBJTIzJTIwT3IlMjBwbnBtJTIwYWRkJTIwJTQwaHVnZ2luZ2ZhY2UlMkZpbmZlcmVuY2UlMjAlNDBodWdnaW5nZmFjZSUyRmh1Yg==",highlighted:`npm install @huggingface/inference @huggingface/hub
<span class="hljs-comment"># Or yarn add @huggingface/inference @huggingface/hub</span>
<span class="hljs-comment"># Or pnpm add @huggingface/inference @huggingface/hub</span>`,wrap:!1}}),cs=new U({props:{code:"JTJGJTJGJTIwRm9yJTIwdXNpbmclMjBBSSUyMG1vZGVscyUwQWltcG9ydCUyMCU3QiUyMEluZmVyZW5jZUNsaWVudCUyMCU3RCUyMGZyb20lMjAlMjIlNDBodWdnaW5nZmFjZSUyRmluZmVyZW5jZSUyMiUzQiUwQSUyRiUyRiUyMEZvciUyMG1hbmFnaW5nJTIwSHViJTIwcmVwb3NpdG9yaWVzJTIwKGxpa2UlMjBjcmVhdGluZyUyMHJlcG9zJTJDJTIwdXBsb2FkaW5nJTIwZmlsZXMpJTBBaW1wb3J0JTIwJTdCJTIwY3JlYXRlUmVwbyUyQyUyMGxpc3RGaWxlcyUyMCU3RCUyMGZyb20lMjAlMjIlNDBodWdnaW5nZmFjZSUyRmh1YiUyMiUzQiUwQSUyRiUyRiUyMFlvdSUyMGNhbiUyMGFsc28lMjBpbXBvcnQlMjBzcGVjaWZpYyUyMHR5cGVzJTIwaWYlMjB5b3UncmUlMjB1c2luZyUyMFR5cGVTY3JpcHQlMEFpbXBvcnQlMjB0eXBlJTIwJTdCJTIwUmVwb0lkJTIwJTdEJTIwZnJvbSUyMCUyMiU0MGh1Z2dpbmdmYWNlJTJGaHViJTIyJTNC",highlighted:`<span class="hljs-comment">// For using AI models</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">InferenceClient</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/inference&quot;</span>;
<span class="hljs-comment">// For managing Hub repositories (like creating repos, uploading files)</span>
<span class="hljs-keyword">import</span> { createRepo, listFiles } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;
<span class="hljs-comment">// You can also import specific types if you&#x27;re using TypeScript</span>
<span class="hljs-keyword">import</span> <span class="hljs-keyword">type</span> { <span class="hljs-title class_">RepoId</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;`,wrap:!1}}),ys=new U({props:{code:"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",highlighted:`<span class="hljs-tag">&lt;<span class="hljs-name">script</span> <span class="hljs-attr">type</span>=<span class="hljs-string">&quot;module&quot;</span>&gt;</span><span class="language-javascript">
  <span class="hljs-comment">// Import the functions you need from the latest versions on a CDN</span>
  <span class="hljs-comment">// Always check for the latest version on npm!</span>
  <span class="hljs-keyword">import</span> { <span class="hljs-title class_">InferenceClient</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;https://cdn.jsdelivr.net/npm/@huggingface/inference@LATEST_VERSION/+esm&#x27;</span>;
  <span class="hljs-keyword">import</span> { listFiles } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://cdn.jsdelivr.net/npm/@huggingface/hub@LATEST_VERSION/+esm&quot;</span>;

  <span class="hljs-keyword">const</span> <span class="hljs-variable constant_">HF_TOKEN</span> = <span class="hljs-string">&quot;your_hf_token_here&quot;</span>; <span class="hljs-comment">// IMPORTANT: Secure your token, especially in client-side code!</span>
  <span class="hljs-keyword">const</span> inference = <span class="hljs-keyword">new</span> <span class="hljs-title class_">InferenceClient</span>(<span class="hljs-variable constant_">HF_TOKEN</span>);

  <span class="hljs-keyword">async</span> <span class="hljs-keyword">function</span> <span class="hljs-title function_">runBrowserExample</span>(<span class="hljs-params"></span>) {
    <span class="hljs-keyword">try</span> {
      <span class="hljs-comment">// Example: List files in the public &quot;gpt2&quot; model repository</span>
      <span class="hljs-keyword">const</span> files = <span class="hljs-keyword">await</span> <span class="hljs-title function_">listFiles</span>({ <span class="hljs-attr">repo</span>: <span class="hljs-string">&quot;gpt2&quot;</span> }); <span class="hljs-comment">// No token needed for public repos</span>
      <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">&quot;Files in gpt2 model repo:&quot;</span>, files.<span class="hljs-title function_">map</span>(<span class="hljs-function"><span class="hljs-params">file</span> =&gt;</span> file.<span class="hljs-property">path</span>));

      <span class="hljs-comment">// Example: Run a simple text generation task (using a public model)</span>
      <span class="hljs-keyword">const</span> { generated_text } = <span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">textGeneration</span>({
        <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;gpt2&quot;</span>,
        <span class="hljs-attr">inputs</span>: <span class="hljs-string">&quot;Once upon a time&quot;</span>,
      });
      <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">&quot;AI generated text:&quot;</span>, generated_text);
    } <span class="hljs-keyword">catch</span> (error) {
      <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">error</span>(<span class="hljs-string">&quot;Error in browser example:&quot;</span>, error);
    }
  }
  <span class="hljs-title function_">runBrowserExample</span>();
</span><span class="hljs-tag">&lt;/<span class="hljs-name">script</span>&gt;</span>`,wrap:!1}}),hs=new U({props:{code:"JTJGJTJGJTIwT3B0aW9uJTIwMSUzQSUyMEltcG9ydCUyMGZyb20lMjBlc20uc2glMjAoYSUyMHBvcHVsYXIlMjBDRE4lMjBmb3IlMjBFUyUyMG1vZHVsZXMpJTBBaW1wb3J0JTIwJTdCJTIwSW5mZXJlbmNlQ2xpZW50JTIwJTdEJTIwZnJvbSUyMCUyMmh0dHBzJTNBJTJGJTJGZXNtLnNoJTJGJTQwaHVnZ2luZ2ZhY2UlMkZpbmZlcmVuY2UlMjIlM0IlMEFpbXBvcnQlMjAlN0IlMjBjcmVhdGVSZXBvJTJDJTIwbGlzdEZpbGVzJTIwJTdEJTIwZnJvbSUyMCUyMmh0dHBzJTNBJTJGJTJGZXNtLnNoJTJGJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjIlM0IlMEElMEElMkYlMkYlMjBPcHRpb24lMjAyJTNBJTIwSW1wb3J0JTIwZGlyZWN0bHklMjBmcm9tJTIwbnBtJTIwKERlbm8lMjBzdXBwb3J0cyUyMHRoaXMhKSUwQSUyRiUyRiUyMGltcG9ydCUyMCU3QiUyMEluZmVyZW5jZUNsaWVudCUyMCU3RCUyMGZyb20lMjAlMjJucG0lM0ElNDBodWdnaW5nZmFjZSUyRmluZmVyZW5jZSUyMiUzQiUwQSUyRiUyRiUyMGltcG9ydCUyMCU3QiUyMGNyZWF0ZVJlcG8lMkMlMjBsaXN0RmlsZXMlMjAlN0QlMjBmcm9tJTIwJTIybnBtJTNBJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjIlM0IlMEElMEElMkYlMkYlMjBJdCdzJTIwYmVzdCUyMHRvJTIwbWFuYWdlJTIweW91ciUyMEh1Z2dpbmclMjBGYWNlJTIwdG9rZW4lMjB1c2luZyUyMGVudmlyb25tZW50JTIwdmFyaWFibGVzJTIwaW4lMjBEZW5vJTBBY29uc3QlMjBIRl9UT0tFTiUyMCUzRCUyMERlbm8uZW52LmdldCglMjJIRl9UT0tFTiUyMiklM0IlMEFpZiUyMCghSEZfVE9LRU4pJTIwJTdCJTBBJTIwJTIwY29uc29sZS53YXJuKCUyMkhGX1RPS0VOJTIwZW52aXJvbm1lbnQlMjB2YXJpYWJsZSUyMG5vdCUyMHNldC4lMjBTb21lJTIwb3BlcmF0aW9ucyUyMG1pZ2h0JTIwZmFpbC4lMjIpJTNCJTBBJTdEJTBBJTBBY29uc3QlMjBpbmZlcmVuY2UlMjAlM0QlMjBuZXclMjBJbmZlcmVuY2VDbGllbnQoSEZfVE9LRU4pJTNCJTBBJTBBYXN5bmMlMjBmdW5jdGlvbiUyMHJ1bkRlbm9FeGFtcGxlKCklMjAlN0IlMEElMjAlMjBjb25zdCUyMCU3QiUyMGNob2ljZXMlMjAlN0QlMjAlM0QlMjBhd2FpdCUyMGluZmVyZW5jZS5jaGF0Q29tcGxldGlvbiglN0IlMEElMjAlMjAlMjAlMjBtb2RlbCUzQSUyMCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItSW5zdHJ1Y3QtdjAuMSUyMiUyQyUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNBJTIwJTVCJTdCJTIwcm9sZSUzQSUyMCUyMnVzZXIlMjIlMkMlMjBjb250ZW50JTNBJTIwJTIyV2hhdCdzJTIwdGhlJTIwd2VhdGhlciUyMGxpa2UlMjBpbiUyMFBhcmlzJTNGJTIyJTIwJTdEJTVEJTJDJTBBJTIwJTIwJTdEKSUzQiUwQSUyMCUyMGNvbnNvbGUubG9nKCUyMkFJJTIwcmVzcG9uc2UlM0ElMjIlMkMlMjBjaG9pY2VzJTVCMCU1RC5tZXNzYWdlLmNvbnRlbnQpJTNCJTBBJTdEJTBBcnVuRGVub0V4YW1wbGUoKSUzQg==",highlighted:`<span class="hljs-comment">// Option 1: Import from esm.sh (a popular CDN for ES modules)</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">InferenceClient</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/inference&quot;</span>;
<span class="hljs-keyword">import</span> { createRepo, listFiles } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/hub&quot;</span>;

<span class="hljs-comment">// Option 2: Import directly from npm (Deno supports this!)</span>
<span class="hljs-comment">// import { InferenceClient } from &quot;npm:@huggingface/inference&quot;;</span>
<span class="hljs-comment">// import { createRepo, listFiles } from &quot;npm:@huggingface/hub&quot;;</span>

<span class="hljs-comment">// It&#x27;s best to manage your Hugging Face token using environment variables in Deno</span>
<span class="hljs-keyword">const</span> <span class="hljs-variable constant_">HF_TOKEN</span> = <span class="hljs-title class_">Deno</span>.<span class="hljs-property">env</span>.<span class="hljs-title function_">get</span>(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>);
<span class="hljs-keyword">if</span> (!<span class="hljs-variable constant_">HF_TOKEN</span>) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">warn</span>(<span class="hljs-string">&quot;HF_TOKEN environment variable not set. Some operations might fail.&quot;</span>);
}

<span class="hljs-keyword">const</span> inference = <span class="hljs-keyword">new</span> <span class="hljs-title class_">InferenceClient</span>(<span class="hljs-variable constant_">HF_TOKEN</span>);

<span class="hljs-keyword">async</span> <span class="hljs-keyword">function</span> <span class="hljs-title function_">runDenoExample</span>(<span class="hljs-params"></span>) {
  <span class="hljs-keyword">const</span> { choices } = <span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">chatCompletion</span>({
    <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;mistralai/Mistral-7B-Instruct-v0.1&quot;</span>,
    <span class="hljs-attr">messages</span>: [{ <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;What&#x27;s the weather like in Paris?&quot;</span> }],
  });
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">&quot;AI response:&quot;</span>, choices[<span class="hljs-number">0</span>].<span class="hljs-property">message</span>.<span class="hljs-property">content</span>);
}
<span class="hljs-title function_">runDenoExample</span>();`,wrap:!1}}),ws=new w({props:{title:"🔑 Secure Your Hugging Face Token!",local:"-secure-your-hugging-face-token",headingTag:"h3"}}),ds=new w({props:{title:"Your First AI Task (Revisited): Text Generation",local:"your-first-ai-task-revisited-text-generation",headingTag:"h3"}}),Cs=new U({props:{code:"JTJGJTJGJTIwbXlBaUFwcC50cyUyMChvciUyMC5qcyUyMHdpdGglMjAlMjJ0eXBlJTIyJTNBJTIwJTIybW9kdWxlJTIyJTIwaW4lMjBwYWNrYWdlLmpzb24pJTBBaW1wb3J0JTIwJTdCJTIwSW5mZXJlbmNlQ2xpZW50JTIwJTdEJTIwZnJvbSUyMCUyMiU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNlJTIyJTNCJTBBJTBBY29uc3QlMjBIRl9UT0tFTiUyMCUzRCUyMHByb2Nlc3MuZW52LkhGX1RPS0VOJTNCJTIwJTJGJTJGJTIwRnJvbSUyMGVudmlyb25tZW50JTBBJTBBaWYlMjAoIUhGX1RPS0VOKSUyMCU3QiUwQSUyMCUyMHRocm93JTIwbmV3JTIwRXJyb3IoJTIySHVnZ2luZyUyMEZhY2UlMjB0b2tlbiUyMChIRl9UT0tFTiklMjBpcyUyMG5vdCUyMHNldC4lMjIpJTNCJTBBJTdEJTBBJTBBY29uc3QlMjBjbGllbnQlMjAlM0QlMjBuZXclMjBJbmZlcmVuY2VDbGllbnQoSEZfVE9LRU4pJTNCJTBBJTBBYXN5bmMlMjBmdW5jdGlvbiUyMGdlbmVyYXRlU3RvcnlPcGVuaW5nKCklMjAlN0IlMEElMjAlMjB0cnklMjAlN0IlMEElMjAlMjAlMjAlMjBjb25zdCUyMHJlc3BvbnNlJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQudGV4dEdlbmVyYXRpb24oJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWwlM0ElMjAlMjJncHQyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXRzJTNBJTIwJTIySW4lMjBhJTIwd29ybGQlMjB3aGVyZSUyMGRyYWdvbnMlMjBydWxlJTIwdGhlJTIwc2tpZXMlMkMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwYXJhbWV0ZXJzJTNBJTIwJTdCJTIwbWF4X25ld190b2tlbnMlM0ElMjA1MCUyQyUyMHRlbXBlcmF0dXJlJTNBJTIwMC43JTIwJTdEJTBBJTIwJTIwJTIwJTIwJTdEKSUzQiUwQSUyMCUyMCUyMCUyMGNvbnNvbGUubG9nKCUyMkFJJ3MlMjBzdG9yeSUyMG9wZW5pbmclM0ElMjIlMkMlMjByZXNwb25zZS5nZW5lcmF0ZWRfdGV4dCklM0IlMEElMjAlMjAlN0QlMjBjYXRjaCUyMChlcnJvciklMjAlN0IlMEElMjAlMjAlMjAlMjBjb25zb2xlLmVycm9yKCUyMkVycm9yJTIwZ2VuZXJhdGluZyUyMHRleHQlM0ElMjIlMkMlMjBlcnJvci5tZXNzYWdlKSUzQiUwQSUyMCUyMCU3RCUwQSU3RCUwQWdlbmVyYXRlU3RvcnlPcGVuaW5nKCklM0I=",highlighted:`<span class="hljs-comment">// myAiApp.ts (or .js with &quot;type&quot;: &quot;module&quot; in package.json)</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">InferenceClient</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/inference&quot;</span>;

<span class="hljs-keyword">const</span> <span class="hljs-variable constant_">HF_TOKEN</span> = process.<span class="hljs-property">env</span>.<span class="hljs-property">HF_TOKEN</span>; <span class="hljs-comment">// From environment</span>

<span class="hljs-keyword">if</span> (!<span class="hljs-variable constant_">HF_TOKEN</span>) {
  <span class="hljs-keyword">throw</span> <span class="hljs-keyword">new</span> <span class="hljs-title class_">Error</span>(<span class="hljs-string">&quot;Hugging Face token (HF_TOKEN) is not set.&quot;</span>);
}

<span class="hljs-keyword">const</span> client = <span class="hljs-keyword">new</span> <span class="hljs-title class_">InferenceClient</span>(<span class="hljs-variable constant_">HF_TOKEN</span>);

<span class="hljs-keyword">async</span> <span class="hljs-keyword">function</span> <span class="hljs-title function_">generateStoryOpening</span>(<span class="hljs-params"></span>) {
  <span class="hljs-keyword">try</span> {
    <span class="hljs-keyword">const</span> response = <span class="hljs-keyword">await</span> client.<span class="hljs-title function_">textGeneration</span>({
      <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;gpt2&quot;</span>,
      <span class="hljs-attr">inputs</span>: <span class="hljs-string">&quot;In a world where dragons rule the skies,&quot;</span>,
      <span class="hljs-attr">parameters</span>: { <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">50</span>, <span class="hljs-attr">temperature</span>: <span class="hljs-number">0.7</span> }
    });
    <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">&quot;AI&#x27;s story opening:&quot;</span>, response.<span class="hljs-property">generated_text</span>);
  } <span class="hljs-keyword">catch</span> (error) {
    <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">error</span>(<span class="hljs-string">&quot;Error generating text:&quot;</span>, error.<span class="hljs-property">message</span>);
  }
}
<span class="hljs-title function_">generateStoryOpening</span>();`,wrap:!1}}),Gs=new U({props:{code:"JTIzJTIwSWYlMjBUeXBlU2NyaXB0JTNBJTIwbnB4JTIwdHMtbm9kZSUyMG15QWlBcHAudHMlMEElMjMlMjBJZiUyMEphdmFTY3JpcHQlM0ElMjBub2RlJTIwbXlBaUFwcC5qcw==",highlighted:`<span class="hljs-comment"># If TypeScript: npx ts-node myAiApp.ts</span>
<span class="hljs-comment"># If JavaScript: node myAiApp.js</span>`,wrap:!1}}),Zs=new w({props:{title:"🛠️ Explore Our JavaScript Toolkit for AI",local:"-explore-our-javascript-toolkit-for-ai",headingTag:"h2"}}),Vs=new w({props:{title:"💡 Diving Deeper: Code Examples & Use Cases",local:"-diving-deeper-code-examples--use-cases",headingTag:"h2"}}),Fs=new w({props:{title:"@huggingface/inference Unleashed: More AI Tasks",local:"huggingfaceinference-unleashed-more-ai-tasks",headingTag:"h3"}}),Xs=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">InferenceClient</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/inference&quot;</span>;
<span class="hljs-comment">// For saving files in Node.js, if you want to try that:</span>
<span class="hljs-comment">// import { writeFile } from &#x27;fs/promises&#x27;;</span>
<span class="hljs-comment">// import { Buffer } from &#x27;buffer&#x27;; // Needed for arrayBuffer to Buffer conversion</span>

<span class="hljs-keyword">const</span> <span class="hljs-variable constant_">HF_TOKEN</span> = process.<span class="hljs-property">env</span>.<span class="hljs-property">HF_TOKEN</span>; <span class="hljs-comment">// Keep your token in environment variables!</span>
<span class="hljs-keyword">if</span> (!<span class="hljs-variable constant_">HF_TOKEN</span>) {
  <span class="hljs-keyword">throw</span> <span class="hljs-keyword">new</span> <span class="hljs-title class_">Error</span>(<span class="hljs-string">&quot;HF_TOKEN is not set in environment variables.&quot;</span>);
}

<span class="hljs-keyword">const</span> client = <span class="hljs-keyword">new</span> <span class="hljs-title class_">InferenceClient</span>(<span class="hljs-variable constant_">HF_TOKEN</span>);

<span class="hljs-keyword">async</span> <span class="hljs-keyword">function</span> <span class="hljs-title function_">exploreAiTasks</span>(<span class="hljs-params"></span>) {
  <span class="hljs-keyword">try</span> {
    <span class="hljs-comment">// 1. Chat with an AI (Chat Completion)</span>
    <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">&quot;💬 Let&#x27;s chat with an AI...&quot;</span>);
    <span class="hljs-keyword">const</span> chatResponse = <span class="hljs-keyword">await</span> client.<span class="hljs-title function_">chatCompletion</span>({
      <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;mistralai/Mistral-7B-Instruct-v0.2&quot;</span>, <span class="hljs-comment">// A popular open chat model</span>
      <span class="hljs-attr">messages</span>: [{ <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;What are three fun facts about JavaScript?&quot;</span> }],
      <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">200</span>, <span class="hljs-comment">// Control how long the AI&#x27;s response can be</span>
    });
    <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">&quot;AI says:&quot;</span>, chatResponse.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>].<span class="hljs-property">message</span>.<span class="hljs-property">content</span>);

    <span class="hljs-comment">// 2. Streaming Chat: Get responses word-by-word (or token-by-token)</span>
    <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">&quot;\\n💬 Streaming a poem from the AI...&quot;</span>);
    process.<span class="hljs-property">stdout</span>.<span class="hljs-title function_">write</span>(<span class="hljs-string">&quot;AI&#x27;s poem: &quot;</span>);
    <span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> chunk <span class="hljs-keyword">of</span> client.<span class="hljs-title function_">chatCompletionStream</span>({
      <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>, <span class="hljs-comment">// Another good chat model</span>
      <span class="hljs-attr">messages</span>: [{ <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Write a short, funny poem about a confused robot.&quot;</span> }],
      <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">100</span>,
    })) {
      <span class="hljs-comment">// \`chunk.choices[0].delta.content\` gives you the new part of the message</span>
      process.<span class="hljs-property">stdout</span>.<span class="hljs-title function_">write</span>(chunk.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>]?.<span class="hljs-property">delta</span>?.<span class="hljs-property">content</span> || <span class="hljs-string">&quot;&quot;</span>);
    }
    process.<span class="hljs-property">stdout</span>.<span class="hljs-title function_">write</span>(<span class="hljs-string">&quot;\\n&quot;</span>);

    <span class="hljs-comment">// 3. Using a Different Provider (e.g., Replicate, Together AI)</span>
    <span class="hljs-comment">//    You might need an API key for that provider.</span>
    <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">&quot;\\n🖼️ Generating an image using a Replicate model...&quot;</span>);
    <span class="hljs-keyword">const</span> imageResult = <span class="hljs-keyword">await</span> client.<span class="hljs-title function_">textToImage</span>({
      <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, <span class="hljs-comment">// This model ID is often found on the provider&#x27;s site</span>
      <span class="hljs-attr">inputs</span>: <span class="hljs-string">&quot;A majestic lion wearing a crown, photorealistic&quot;</span>,
      <span class="hljs-attr">provider</span>: <span class="hljs-string">&quot;replicate&quot;</span>, <span class="hljs-comment">// Specify the provider</span>
      <span class="hljs-comment">// providerToken: ({}).REPLICATE_API_TOKEN, // If the provider needs its own token</span>
    });
    <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">&quot;Image generated! It&#x27;s a Blob. In a browser, you could create an Object URL and show it in an &lt;img&gt; tag.&quot;</span>);
    <span class="hljs-comment">// Example: Saving the image in Node.js (uncomment fs/promises and Buffer imports above)</span>
    <span class="hljs-comment">// const imageBuffer = Buffer.from(await imageResult.arrayBuffer());</span>
    <span class="hljs-comment">// await writeFile(&#x27;lion_king.png&#x27;, imageBuffer);</span>
    <span class="hljs-comment">// console.log(&quot;Image saved as lion_king.png&quot;);</span>


    <span class="hljs-comment">// 4. Translate Text</span>
    <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">&quot;\\n🌐 Translating text...&quot;</span>);
    <span class="hljs-keyword">const</span> translationResult = <span class="hljs-keyword">await</span> client.<span class="hljs-title function_">translation</span>({
      <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;facebook/nllb-200-distilled-600M&quot;</span>, <span class="hljs-comment">// A powerful translation model</span>
      <span class="hljs-attr">inputs</span>: <span class="hljs-string">&quot;Hello, world! JavaScript is fun.&quot;</span>,
      <span class="hljs-attr">parameters</span>: {
        <span class="hljs-attr">src_lang</span>: <span class="hljs-string">&quot;eng_Latn&quot;</span>, <span class="hljs-comment">// Source language (English)</span>
        <span class="hljs-attr">tgt_lang</span>: <span class="hljs-string">&quot;fra_Latn&quot;</span>, <span class="hljs-comment">// Target language (French)</span>
      },
    });
    <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">\`Original: <span class="hljs-subst">\${translationResult[<span class="hljs-number">0</span>].original_text}</span>\`</span>);
    <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">\`Translation (to French): <span class="hljs-subst">\${translationResult[<span class="hljs-number">0</span>].translation_text}</span>\`</span>);


    <span class="hljs-comment">// 5. Image to Text (Image Captioning)</span>
    <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">&quot;\\n📝 Generating a caption for an image...&quot;</span>);
    <span class="hljs-keyword">const</span> imageUrlForCaption = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Narsil/image_dummy/raw/main/parrots.png&#x27;</span>; <span class="hljs-comment">// An example image URL</span>
    <span class="hljs-keyword">const</span> imageBlobForCaption = <span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> <span class="hljs-title function_">fetch</span>(imageUrlForCaption)).<span class="hljs-title function_">blob</span>(); <span class="hljs-comment">// Download the image data</span>

    <span class="hljs-keyword">const</span> captionResult = <span class="hljs-keyword">await</span> client.<span class="hljs-title function_">imageToText</span>({
      <span class="hljs-attr">data</span>: imageBlobForCaption,
      <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;Salesforce/blip-image-captioning-large&#x27;</span>, <span class="hljs-comment">// A good image captioning model</span>
    });
    <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">&quot;Image caption:&quot;</span>, captionResult.<span class="hljs-property">generated_text</span>);


    <span class="hljs-comment">// 6. Using Your Own Dedicated Inference Endpoint</span>
    <span class="hljs-comment">//    If you have a paid Inference Endpoint on Hugging Face for better performance/reliability.</span>
    <span class="hljs-comment">//    The endpoint URL looks something like: https://your-endpoint-name.region.vendor.endpoints.huggingface.cloud</span>
    <span class="hljs-comment">// console.log(&quot;\\n⚡ Using a dedicated Inference Endpoint for text generation...&quot;);</span>
    <span class="hljs-comment">// const myEndpointUrl = ({}).MY_INFERENCE_ENDPOINT_URL;</span>
    <span class="hljs-comment">// if (myEndpointUrl) {</span>
    <span class="hljs-comment">//   const endpointClient = client.endpoint(myEndpointUrl);</span>
    <span class="hljs-comment">//   const endpointResponse = await endpointClient.textGeneration({</span>
    <span class="hljs-comment">//     inputs: &quot;The future of AI is &quot;,</span>
    <span class="hljs-comment">//     parameters: { max_new_tokens: 20 }</span>
    <span class="hljs-comment">//   });</span>
    <span class="hljs-comment">//   console.log(&quot;Response from dedicated endpoint:&quot;, endpointResponse.generated_text);</span>
    <span class="hljs-comment">// } else {</span>
    <span class="hljs-comment">//   console.log(&quot;(Skipping dedicated endpoint example as MY_INFERENCE_ENDPOINT_URL is not set)&quot;);</span>
    <span class="hljs-comment">// }</span>

  } <span class="hljs-keyword">catch</span> (error) {
    <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">error</span>(<span class="hljs-string">&quot;💥 An error occurred during inference examples:&quot;</span>, error.<span class="hljs-property">message</span>);
  }
}

<span class="hljs-title function_">exploreAiTasks</span>();`,wrap:!1}}),xs=new w({props:{title:"@huggingface/hub in Action: Managing Your AI Assets",local:"huggingfacehub-in-action-managing-your-ai-assets",headingTag:"h3"}}),zs=new U({props:{code:"aW1wb3J0JTIwJTdCJTBBJTIwJTIwY3JlYXRlUmVwbyUyQyUwQSUyMCUyMHVwbG9hZEZpbGUlMkMlMEElMjAlMjBkZWxldGVGaWxlcyUyQyUwQSUyMCUyMGxpc3RGaWxlcyUyQyUwQSUyMCUyMCUyRiUyRiUyMGRlbGV0ZVJlcG8lMjAlMkYlMkYlMjBDYXJlZnVsJTIwd2l0aCUyMHRoaXMlMjBvbmUhJTBBJTdEJTIwZnJvbSUyMCUyMiU0MGh1Z2dpbmdmYWNlJTJGaHViJTIyJTNCJTBBJTBBY29uc3QlMjBIRl9UT0tFTiUyMCUzRCUyMHByb2Nlc3MuZW52LkhGX1RPS0VOJTNCJTBBaWYlMjAoIUhGX1RPS0VOKSUyMCU3QiUwQSUyMCUyMHRocm93JTIwbmV3JTIwRXJyb3IoJTIySEZfVE9LRU4lMjBpcyUyMG5vdCUyMHNldCUyMGZvciUyMEh1YiUyMGV4YW1wbGVzLiUyMiklM0IlMEElN0QlMEElMEFhc3luYyUyMGZ1bmN0aW9uJTIwbWFuYWdlTXlIdWJBc3NldHMoKSUyMCU3QiUwQSUyMCUyMHRyeSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyRiUyRiUyMENyZWF0ZSUyMGElMjB1bmlxdWUlMjByZXBvc2l0b3J5JTIwbmFtZSUyMChlLmcuJTJDJTIwdXNpbmclMjB5b3VyJTIwdXNlcm5hbWUlMjBhbmQlMjBhJTIwdGltZXN0YW1wKSUwQSUyMCUyMCUyMCUyMCUyRiUyRiUyMFJlcGxhY2UlMjAlMjJ5b3VyLXVzZXJuYW1lJTIyJTIwd2l0aCUyMHlvdXIlMjBhY3R1YWwlMjBIdWdnaW5nJTIwRmFjZSUyMHVzZXJuYW1lISUwQSUyMCUyMCUyMCUyMGNvbnN0JTIwcmVwb05hbWUlMjAlM0QlMjAlNjB5b3VyLXVzZXJuYW1lJTJGbXktanMtdGVzdC1tb2RlbC0lMjQlN0JEYXRlLm5vdygpJTdEJTYwJTNCJTBBJTIwJTIwJTIwJTIwY29uc3QlMjByZXBvVXJsJTIwJTNEJTIwJTYwaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRiUyNCU3QnJlcG9OYW1lJTdEJTYwJTNCJTBBJTBBJTIwJTIwJTIwJTIwJTJGJTJGJTIwMS4lMjBDcmVhdGUlMjBhJTIwbmV3JTIwKHByaXZhdGUpJTIwbW9kZWwlMjByZXBvc2l0b3J5JTBBJTIwJTIwJTIwJTIwY29uc29sZS5sb2coJTYwJUUyJTlDJUE4JTIwQ3JlYXRpbmclMjBhJTIwbmV3JTIwcHJpdmF0ZSUyMHJlcG9zaXRvcnklM0ElMjAlMjQlN0JyZXBvTmFtZSU3RCU2MCklM0IlMEElMjAlMjAlMjAlMjBhd2FpdCUyMGNyZWF0ZVJlcG8oJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwcmVwbyUzQSUyMHJlcG9OYW1lJTJDJTIwJTJGJTJGJTIwWW91JTIwY2FuJTIwYWxzbyUyMHVzZSUyMCU3QiUyMHR5cGUlM0ElMjAlMjJtb2RlbCUyMiUyQyUyMG5hbWUlM0ElMjByZXBvTmFtZSUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMGFjY2Vzc1Rva2VuJTNBJTIwSEZfVE9LRU4lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwcml2YXRlJTNBJTIwdHJ1ZSUyQyUyMCUyRiUyRiUyME1ha2UlMjBpdCUyMHByaXZhdGUlMEElMjAlMjAlMjAlMjAlMjAlMjBzcGFjZVNkayUzQSUyMCUyMmdyYWRpbyUyMiUyMCUyRiUyRiUyMEV4YW1wbGUlM0ElMjBpZiUyMGl0J3MlMjBhJTIwU3BhY2UlMkMlMjBzcGVjaWZ5JTIwU0RLJTIwKGdyYWRpbyUyQyUyMHN0cmVhbWxpdCUyQyUyMGRvY2tlciUyQyUyMHN0YXRpYyklMEElMjAlMjAlMjAlMjAlN0QpJTNCJTBBJTIwJTIwJTIwJTIwY29uc29sZS5sb2coJTYwUmVwb3NpdG9yeSUyMGNyZWF0ZWQhJTIwVmlzaXQlMjBpdCUyMGF0JTNBJTIwJTI0JTdCcmVwb1VybCU3RCU2MCklM0IlMEElMEElMjAlMjAlMjAlMjAlMkYlMkYlMjAyLiUyMFVwbG9hZCUyMGZpbGVzJTIwdG8lMjB5b3VyJTIwbmV3JTIwcmVwb3NpdG9yeSUwQSUyMCUyMCUyMCUyMGNvbnNvbGUubG9nKCUyMiU1Q24lRTIlQUMlODYlRUYlQjglOEYlMjBVcGxvYWRpbmclMjBhJTIwZHVtbXklMjBtb2RlbCUyMGZpbGUlMjBhbmQlMjBhJTIwUkVBRE1FLi4uJTIyKSUzQiUwQSUwQSUyMCUyMCUyMCUyMCUyRiUyRiUyMENyZWF0ZSUyMHNvbWUlMjBkdW1teSUyMGZpbGUlMjBjb250ZW50JTIwKGFzJTIwYSUyMEJsb2IpJTBBJTIwJTIwJTIwJTIwY29uc3QlMjBkdW1teU1vZGVsQ29udGVudCUyMCUzRCUyMG5ldyUyMEJsb2IoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTVCJTIyVGhpcyUyMGlzJTIwYSUyMHBsYWNlaG9sZGVyJTIwZm9yJTIwYSUyMG1vZGVsJTIwZmlsZS4lMjBDb250ZW50JTNBJTIwJTIyJTIwJTJCJTIwTWF0aC5yYW5kb20oKSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMHR5cGUlM0ElMjAlMjJ0ZXh0JTJGcGxhaW4lMjIlMjAlN0QlMEElMjAlMjAlMjAlMjApJTNCJTBBJTIwJTIwJTIwJTIwYXdhaXQlMjB1cGxvYWRGaWxlKCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMHJlcG8lM0ElMjByZXBvTmFtZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGFjY2Vzc1Rva2VuJTNBJTIwSEZfVE9LRU4lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBmaWxlJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGF0aCUzQSUyMCUyMm1vZGVsX3YxLnR4dCUyMiUyQyUyMCUyRiUyRiUyMFBhdGglMjBpbnNpZGUlMjB5b3VyJTIwcmVwb3NpdG9yeSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbnRlbnQlM0ElMjBkdW1teU1vZGVsQ29udGVudCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3RCklM0IlMEElMjAlMjAlMjAlMjBjb25zb2xlLmxvZyglMjJVcGxvYWRlZCUyMG1vZGVsX3YxLnR4dCUyMiklM0IlMEElMEElMjAlMjAlMjAlMjBjb25zdCUyMHJlYWRtZUZpbGVDb250ZW50JTIwJTNEJTIwbmV3JTIwQmxvYiglMEElMjAlMjAlMjAlMjAlMjAlMjAlNUIlNjAlMjMlMjBNeSUyMEF3ZXNvbWUlMjBKUyUyME1vZGVsJTVDbiU1Q25UaGlzJTIwbW9kZWwlMjB3YXMlMjBjcmVhdGVkJTIwYW5kJTIwbWFuYWdlZCUyMHVzaW5nJTIwdGhlJTIwJTVDJTYwJTQwaHVnZ2luZ2ZhY2UlMkZodWIlNUMlNjAlMjBsaWJyYXJ5ISU2MCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMHR5cGUlM0ElMjAlMjJ0ZXh0JTJGbWFya2Rvd24lMjIlMjAlN0QlMEElMjAlMjAlMjAlMjApJTNCJTBBJTIwJTIwJTIwJTIwYXdhaXQlMjB1cGxvYWRGaWxlKCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMHJlcG8lM0ElMjByZXBvTmFtZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGFjY2Vzc1Rva2VuJTNBJTIwSEZfVE9LRU4lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBmaWxlJTNBJTIwJTdCJTIwcGF0aCUzQSUyMCUyMlJFQURNRS5tZCUyMiUyQyUyMGNvbnRlbnQlM0ElMjByZWFkbWVGaWxlQ29udGVudCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3RCklM0IlMEElMjAlMjAlMjAlMjBjb25zb2xlLmxvZyglMjJVcGxvYWRlZCUyMFJFQURNRS5tZC4lMjBDaGVjayUyMHlvdXIlMjByZXBvJTIwb25saW5lISUyMiklM0IlMEElMEElMjAlMjAlMjAlMjAlMkYlMkYlMjAzLiUyMExpc3QlMjBmaWxlcyUyMGluJTIwdGhlJTIwcmVwb3NpdG9yeSUwQSUyMCUyMCUyMCUyMGNvbnNvbGUubG9nKCUyMiU1Q24lRjAlOUYlOTMlODQlMjBMaXN0aW5nJTIwZmlsZXMlMjBpbiUyMHRoZSUyMHJlcG9zaXRvcnkuLi4lMjIpJTNCJTBBJTIwJTIwJTIwJTIwY29uc3QlMjBmaWxlc0luUmVwbyUyMCUzRCUyMGF3YWl0JTIwbGlzdEZpbGVzKCU3QiUyMHJlcG8lM0ElMjByZXBvTmFtZSUyQyUyMGFjY2Vzc1Rva2VuJTNBJTIwSEZfVE9LRU4lMjAlN0QpJTNCJTBBJTIwJTIwJTIwJTIwY29uc29sZS5sb2coJTIyRmlsZXMlMjBmb3VuZCUzQSUyMiUyQyUyMGZpbGVzSW5SZXBvLm1hcChmJTIwJTNEJTNFJTIwZi5wYXRoKS5qb2luKCUyMiUyQyUyMCUyMikpJTNCJTBBJTBBJTIwJTIwJTIwJTIwJTJGJTJGJTIwNC4lMjBEZWxldGUlMjBhJTIwc3BlY2lmaWMlMjBmaWxlJTBBJTIwJTIwJTIwJTIwY29uc29sZS5sb2coJTIyJTVDbiVGMCU5RiU5NyU5MSVFRiVCOCU4RiUyMERlbGV0aW5nJTIwbW9kZWxfdjEudHh0Li4uJTIyKSUzQiUwQSUyMCUyMCUyMCUyMGF3YWl0JTIwZGVsZXRlRmlsZXMoJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwcmVwbyUzQSUyMHJlcG9OYW1lJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYWNjZXNzVG9rZW4lM0ElMjBIRl9UT0tFTiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHBhdGhzJTNBJTIwJTVCJTIybW9kZWxfdjEudHh0JTIyJTVEJTJDJTIwJTJGJTJGJTIwQ2FuJTIwYmUlMjBhbiUyMGFycmF5JTIwb2YlMjBwYXRocyUwQSUyMCUyMCUyMCUyMCU3RCklM0IlMEElMjAlMjAlMjAlMjBjb25zb2xlLmxvZyglMjJtb2RlbF92MS50eHQlMjBkZWxldGVkLiUyMiklM0IlMEElMEElMjAlMjAlMjAlMjAlMkYlMkYlMjBMaXN0JTIwZmlsZXMlMjBhZ2FpbiUyMHRvJTIwc2VlJTIwdGhlJTIwY2hhbmdlJTBBJTIwJTIwJTIwJTIwY29uc3QlMjBmaWxlc0FmdGVyRGVsZXRlJTIwJTNEJTIwYXdhaXQlMjBsaXN0RmlsZXMoJTdCJTIwcmVwbyUzQSUyMHJlcG9OYW1lJTJDJTIwYWNjZXNzVG9rZW4lM0ElMjBIRl9UT0tFTiUyMCU3RCklM0IlMEElMjAlMjAlMjAlMjBjb25zb2xlLmxvZyglMjJGaWxlcyUyMHJlbWFpbmluZyUzQSUyMiUyQyUyMGZpbGVzQWZ0ZXJEZWxldGUubWFwKGYlMjAlM0QlM0UlMjBmLnBhdGgpLmpvaW4oJTIyJTJDJTIwJTIyKSUyMCU3QyU3QyUyMCUyMk5vbmUlMjIpJTNCJTBBJTBBJTIwJTIwJTIwJTIwJTJGJTJGJTIwNS4lMjBJTVBPUlRBTlQlM0ElMjBDbGVhbmluZyUyMHVwJTIwKGRlbGV0aW5nJTIwdGhlJTIwdGVzdCUyMHJlcG9zaXRvcnkpJTBBJTIwJTIwJTIwJTIwJTJGJTJGJTIwJTIwJTIwJTIwQmUlMjB2ZXJ5JTIwY2FyZWZ1bCUyMHdpdGglMjBkZWxldGVSZXBvJTIwaW4lMjByZWFsJTIwcHJvamVjdHMhJTBBJTIwJTIwJTIwJTIwJTJGJTJGJTIwY29uc29sZS5sb2coJTYwJTVDbiVGMCU5RiVBNyVCOSUyMENsZWFuaW5nJTIwdXAlM0ElMjBEZWxldGluZyUyMHJlcG9zaXRvcnklMjAlMjQlN0JyZXBvTmFtZSU3RC4uLiU2MCklM0IlMEElMjAlMjAlMjAlMjAlMkYlMkYlMjBhd2FpdCUyMGRlbGV0ZVJlcG8oJTdCJTIwcmVwbyUzQSUyMHJlcG9OYW1lJTJDJTIwYWNjZXNzVG9rZW4lM0ElMjBIRl9UT0tFTiUyMCU3RCklM0IlMEElMjAlMjAlMjAlMjAlMkYlMkYlMjBjb25zb2xlLmxvZyglNjBSZXBvc2l0b3J5JTIwJTI0JTdCcmVwb05hbWUlN0QlMjBkZWxldGVkLiUyMChFeGFtcGxlJTIwY2xlYW51cCklNjApJTNCJTBBJTBBJTIwJTIwJTdEJTIwY2F0Y2glMjAoZXJyb3IpJTIwJTdCJTBBJTIwJTIwJTIwJTIwY29uc29sZS5lcnJvciglMjIlRjAlOUYlOTIlQTUlMjBBbiUyMGVycm9yJTIwb2NjdXJyZWQlMjBkdXJpbmclMjBIdWIlMjBleGFtcGxlcyUzQSUyMiUyQyUyMGVycm9yLm1lc3NhZ2UpJTNCJTBBJTIwJTIwJTdEJTBBJTdEJTBBJTBBbWFuYWdlTXlIdWJBc3NldHMoKSUzQiUwQSUwQSUyRiUyRiUyMEV4YW1wbGUlMjBmb3IlMjBpbnRlcmFjdGluZyUyMHdpdGglMjBhJTIwU3BhY2UlMjAoZS5nLiUyQyUyMGRlbGV0aW5nJTIwZmlsZXMpJTBBYXN5bmMlMjBmdW5jdGlvbiUyMG1hbmFnZU15U3BhY2UoKSUyMCU3QiUwQSUyMCUyMCUyRiUyRiUyMGNvbnN0JTIwc3BhY2VSZXBvJTIwJTNEJTIwJTdCJTIwdHlwZSUzQSUyMCUyMnNwYWNlJTIyJTIwYXMlMjBjb25zdCUyQyUyMG5hbWUlM0ElMjAlMjJ5b3VyLXVzZXJuYW1lJTJGeW91ci1zcGFjZS1uYW1lJTIyJTIwJTdEJTNCJTBBJTIwJTIwJTJGJTJGJTIwY29uc29sZS5sb2coJTYwJTVDbiVGMCU5RiU5NyU5MSVFRiVCOCU4RiUyMERlbGV0aW5nJTIwZmlsZXMlMjBmcm9tJTIwU3BhY2UlM0ElMjAlMjQlN0JzcGFjZVJlcG8ubmFtZSU3RCU2MCklM0IlMEElMjAlMjAlMkYlMkYlMjB0cnklMjAlN0IlMEElMjAlMjAlMkYlMkYlMjAlMjAlMjBhd2FpdCUyMGRlbGV0ZUZpbGVzKCU3QiUwQSUyMCUyMCUyRiUyRiUyMCUyMCUyMCUyMCUyMHJlcG8lM0ElMjBzcGFjZVJlcG8lMkMlMjAlMkYlMkYlMjBvciUyMCUyMnNwYWNlcyUyRnlvdXItdXNlcm5hbWUlMkZ5b3VyLXNwYWNlLW5hbWUlMjIlMEElMjAlMjAlMkYlMkYlMjAlMjAlMjAlMjAlMjBhY2Nlc3NUb2tlbiUzQSUyMEhGX1RPS0VOJTJDJTBBJTIwJTIwJTJGJTJGJTIwJTIwJTIwJTIwJTIwcGF0aHMlM0ElMjAlNUIlMjJvbGRfY29uZmlnLmpzb24lMjIlMkMlMjAlMjJ0ZW1wX2RhdGEuY3N2JTIyJTVEJTBBJTIwJTIwJTJGJTJGJTIwJTIwJTIwJTdEKSUzQiUwQSUyMCUyMCUyRiUyRiUyMCUyMCUyMGNvbnNvbGUubG9nKCUyMkZpbGVzJTIwZGVsZXRlZCUyMGZyb20lMjB0aGUlMjBTcGFjZS4lMjIpJTNCJTBBJTIwJTIwJTJGJTJGJTIwJTdEJTIwY2F0Y2glMjAoZXJyb3IpJTIwJTdCJTBBJTIwJTIwJTJGJTJGJTIwJTIwJTIwY29uc29sZS5lcnJvciglNjBGYWlsZWQlMjB0byUyMGRlbGV0ZSUyMGZpbGVzJTIwZnJvbSUyMFNwYWNlJTNBJTIwJTI0JTdCZXJyb3IubWVzc2FnZSU3RCU2MCklM0IlMEElMjAlMjAlMkYlMkYlMjAlN0QlMEElN0QlMEElMkYlMkYlMjBtYW5hZ2VNeVNwYWNlKCklM0I=",highlighted:`<span class="hljs-keyword">import</span> {
  createRepo,
  uploadFile,
  deleteFiles,
  listFiles,
  <span class="hljs-comment">// deleteRepo // Careful with this one!</span>
} <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> <span class="hljs-variable constant_">HF_TOKEN</span> = process.<span class="hljs-property">env</span>.<span class="hljs-property">HF_TOKEN</span>;
<span class="hljs-keyword">if</span> (!<span class="hljs-variable constant_">HF_TOKEN</span>) {
  <span class="hljs-keyword">throw</span> <span class="hljs-keyword">new</span> <span class="hljs-title class_">Error</span>(<span class="hljs-string">&quot;HF_TOKEN is not set for Hub examples.&quot;</span>);
}

<span class="hljs-keyword">async</span> <span class="hljs-keyword">function</span> <span class="hljs-title function_">manageMyHubAssets</span>(<span class="hljs-params"></span>) {
  <span class="hljs-keyword">try</span> {
    <span class="hljs-comment">// Create a unique repository name (e.g., using your username and a timestamp)</span>
    <span class="hljs-comment">// Replace &quot;your-username&quot; with your actual Hugging Face username!</span>
    <span class="hljs-keyword">const</span> repoName = <span class="hljs-string">\`your-username/my-js-test-model-<span class="hljs-subst">\${<span class="hljs-built_in">Date</span>.now()}</span>\`</span>;
    <span class="hljs-keyword">const</span> repoUrl = <span class="hljs-string">\`https://huggingface.co/<span class="hljs-subst">\${repoName}</span>\`</span>;

    <span class="hljs-comment">// 1. Create a new (private) model repository</span>
    <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">\`✨ Creating a new private repository: <span class="hljs-subst">\${repoName}</span>\`</span>);
    <span class="hljs-keyword">await</span> <span class="hljs-title function_">createRepo</span>({
      <span class="hljs-attr">repo</span>: repoName, <span class="hljs-comment">// You can also use { type: &quot;model&quot;, name: repoName }</span>
      <span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_TOKEN</span>,
      <span class="hljs-attr">private</span>: <span class="hljs-literal">true</span>, <span class="hljs-comment">// Make it private</span>
      <span class="hljs-attr">spaceSdk</span>: <span class="hljs-string">&quot;gradio&quot;</span> <span class="hljs-comment">// Example: if it&#x27;s a Space, specify SDK (gradio, streamlit, docker, static)</span>
    });
    <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">\`Repository created! Visit it at: <span class="hljs-subst">\${repoUrl}</span>\`</span>);

    <span class="hljs-comment">// 2. Upload files to your new repository</span>
    <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">&quot;\\n⬆️ Uploading a dummy model file and a README...&quot;</span>);

    <span class="hljs-comment">// Create some dummy file content (as a Blob)</span>
    <span class="hljs-keyword">const</span> dummyModelContent = <span class="hljs-keyword">new</span> <span class="hljs-title class_">Blob</span>(
      [<span class="hljs-string">&quot;This is a placeholder for a model file. Content: &quot;</span> + <span class="hljs-title class_">Math</span>.<span class="hljs-title function_">random</span>()],
      { <span class="hljs-attr">type</span>: <span class="hljs-string">&quot;text/plain&quot;</span> }
    );
    <span class="hljs-keyword">await</span> <span class="hljs-title function_">uploadFile</span>({
      <span class="hljs-attr">repo</span>: repoName,
      <span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_TOKEN</span>,
      <span class="hljs-attr">file</span>: {
        <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;model_v1.txt&quot;</span>, <span class="hljs-comment">// Path inside your repository</span>
        <span class="hljs-attr">content</span>: dummyModelContent,
      },
    });
    <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">&quot;Uploaded model_v1.txt&quot;</span>);

    <span class="hljs-keyword">const</span> readmeFileContent = <span class="hljs-keyword">new</span> <span class="hljs-title class_">Blob</span>(
      [<span class="hljs-string">\`# My Awesome JS Model\\n\\nThis model was created and managed using the \\\`@huggingface/hub\\\` library!\`</span>],
      { <span class="hljs-attr">type</span>: <span class="hljs-string">&quot;text/markdown&quot;</span> }
    );
    <span class="hljs-keyword">await</span> <span class="hljs-title function_">uploadFile</span>({
      <span class="hljs-attr">repo</span>: repoName,
      <span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_TOKEN</span>,
      <span class="hljs-attr">file</span>: { <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;README.md&quot;</span>, <span class="hljs-attr">content</span>: readmeFileContent },
    });
    <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">&quot;Uploaded README.md. Check your repo online!&quot;</span>);

    <span class="hljs-comment">// 3. List files in the repository</span>
    <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">&quot;\\n📄 Listing files in the repository...&quot;</span>);
    <span class="hljs-keyword">const</span> filesInRepo = <span class="hljs-keyword">await</span> <span class="hljs-title function_">listFiles</span>({ <span class="hljs-attr">repo</span>: repoName, <span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_TOKEN</span> });
    <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">&quot;Files found:&quot;</span>, filesInRepo.<span class="hljs-title function_">map</span>(<span class="hljs-function"><span class="hljs-params">f</span> =&gt;</span> f.<span class="hljs-property">path</span>).<span class="hljs-title function_">join</span>(<span class="hljs-string">&quot;, &quot;</span>));

    <span class="hljs-comment">// 4. Delete a specific file</span>
    <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">&quot;\\n🗑️ Deleting model_v1.txt...&quot;</span>);
    <span class="hljs-keyword">await</span> <span class="hljs-title function_">deleteFiles</span>({
      <span class="hljs-attr">repo</span>: repoName,
      <span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_TOKEN</span>,
      <span class="hljs-attr">paths</span>: [<span class="hljs-string">&quot;model_v1.txt&quot;</span>], <span class="hljs-comment">// Can be an array of paths</span>
    });
    <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">&quot;model_v1.txt deleted.&quot;</span>);

    <span class="hljs-comment">// List files again to see the change</span>
    <span class="hljs-keyword">const</span> filesAfterDelete = <span class="hljs-keyword">await</span> <span class="hljs-title function_">listFiles</span>({ <span class="hljs-attr">repo</span>: repoName, <span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_TOKEN</span> });
    <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">&quot;Files remaining:&quot;</span>, filesAfterDelete.<span class="hljs-title function_">map</span>(<span class="hljs-function"><span class="hljs-params">f</span> =&gt;</span> f.<span class="hljs-property">path</span>).<span class="hljs-title function_">join</span>(<span class="hljs-string">&quot;, &quot;</span>) || <span class="hljs-string">&quot;None&quot;</span>);

    <span class="hljs-comment">// 5. IMPORTANT: Cleaning up (deleting the test repository)</span>
    <span class="hljs-comment">//    Be very careful with deleteRepo in real projects!</span>
    <span class="hljs-comment">// console.log(\`\\n🧹 Cleaning up: Deleting repository \${repoName}...\`);</span>
    <span class="hljs-comment">// await deleteRepo({ repo: repoName, accessToken: HF_TOKEN });</span>
    <span class="hljs-comment">// console.log(\`Repository \${repoName} deleted. (Example cleanup)\`);</span>

  } <span class="hljs-keyword">catch</span> (error) {
    <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">error</span>(<span class="hljs-string">&quot;💥 An error occurred during Hub examples:&quot;</span>, error.<span class="hljs-property">message</span>);
  }
}

<span class="hljs-title function_">manageMyHubAssets</span>();

<span class="hljs-comment">// Example for interacting with a Space (e.g., deleting files)</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">function</span> <span class="hljs-title function_">manageMySpace</span>(<span class="hljs-params"></span>) {
  <span class="hljs-comment">// const spaceRepo = { type: &quot;space&quot; as const, name: &quot;your-username/your-space-name&quot; };</span>
  <span class="hljs-comment">// console.log(\`\\n🗑️ Deleting files from Space: \${spaceRepo.name}\`);</span>
  <span class="hljs-comment">// try {</span>
  <span class="hljs-comment">//   await deleteFiles({</span>
  <span class="hljs-comment">//     repo: spaceRepo, // or &quot;spaces/your-username/your-space-name&quot;</span>
  <span class="hljs-comment">//     accessToken: HF_TOKEN,</span>
  <span class="hljs-comment">//     paths: [&quot;old_config.json&quot;, &quot;temp_data.csv&quot;]</span>
  <span class="hljs-comment">//   });</span>
  <span class="hljs-comment">//   console.log(&quot;Files deleted from the Space.&quot;);</span>
  <span class="hljs-comment">// } catch (error) {</span>
  <span class="hljs-comment">//   console.error(\`Failed to delete files from Space: \${error.message}\`);</span>
  <span class="hljs-comment">// }</span>
}
<span class="hljs-comment">// manageMySpace();</span>`,wrap:!1}}),Ls=new w({props:{title:"@huggingface/mcp-client : Building AI Agents",local:"huggingfacemcp-client--building-ai-agents",headingTag:"h3"}}),qs=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">Agent</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@huggingface/mcp-client&#x27;</span>;

<span class="hljs-keyword">const</span> <span class="hljs-variable constant_">HF_TOKEN</span> = process.<span class="hljs-property">env</span>.<span class="hljs-property">HF_TOKEN</span>;
<span class="hljs-keyword">if</span> (!<span class="hljs-variable constant_">HF_TOKEN</span>) {
  <span class="hljs-keyword">throw</span> <span class="hljs-keyword">new</span> <span class="hljs-title class_">Error</span>(<span class="hljs-string">&quot;HF_TOKEN is not set for MCP Agent examples.&quot;</span>);
}

<span class="hljs-keyword">async</span> <span class="hljs-keyword">function</span> <span class="hljs-title function_">useAiAgent</span>(<span class="hljs-params"></span>) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">&quot;🤖 Initializing an AI Agent...&quot;</span>);
  <span class="hljs-keyword">try</span> {
    <span class="hljs-keyword">const</span> agent = <span class="hljs-keyword">new</span> <span class="hljs-title class_">Agent</span>({
      <span class="hljs-comment">// Provider for the underlying Language Model</span>
      <span class="hljs-attr">provider</span>: <span class="hljs-string">&quot;huggingface&quot;</span>, <span class="hljs-comment">// Or &quot;auto&quot;, or another like &quot;openai&quot;, &quot;anthropic&quot; (may need specific API keys)</span>
      <span class="hljs-comment">// Model that is good at following instructions and using tools</span>
      <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>,
      <span class="hljs-attr">apiKey</span>: <span class="hljs-variable constant_">HF_TOKEN</span>, <span class="hljs-comment">// Token for the LLM provider (Hugging Face in this case)</span>

      <span class="hljs-comment">// Servers provide tools to the agent (e.g., web browsing, code execution).</span>
      <span class="hljs-comment">// This is an advanced setup. For this example, we&#x27;ll run without external tools.</span>
      <span class="hljs-comment">// servers: [</span>
      <span class="hljs-comment">//   {</span>
      <span class="hljs-comment">//     // Example: Playwright MCP for web browsing capabilities</span>
      <span class="hljs-comment">//     command: &quot;npx&quot;, // Command to start the tool server</span>
      <span class="hljs-comment">//     args: [&quot;@playwright/mcp@latest&quot;], // Arguments for the command</span>
      <span class="hljs-comment">//   },</span>
      <span class="hljs-comment">// ],</span>
    });

    <span class="hljs-comment">// If you had tool servers, you might load their capabilities:</span>
    <span class="hljs-comment">// await agent.loadTools();</span>
    <span class="hljs-comment">// console.log(&quot;Agent&#x27;s available tools:&quot;, agent.tools.map(t =&gt; t.name));</span>

    <span class="hljs-keyword">const</span> userQuery = <span class="hljs-string">&quot;What is the Hugging Face Hub and what can I do there?&quot;</span>;
    <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">\`\\n👤 User asks: &quot;<span class="hljs-subst">\${userQuery}</span>&quot;\`</span>);

    process.<span class="hljs-property">stdout</span>.<span class="hljs-title function_">write</span>(<span class="hljs-string">&quot;🤖 Agent is thinking... Response: &quot;</span>);
    <span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> chunk <span class="hljs-keyword">of</span> agent.<span class="hljs-title function_">run</span>(userQuery)) {
      <span class="hljs-comment">// The structure of \`chunk\` depends on what the agent is doing:</span>
      <span class="hljs-comment">// - If it&#x27;s the LLM generating text: chunk will have \`choices\`</span>
      <span class="hljs-comment">// - If it&#x27;s calling a tool: chunk will have \`type: &quot;tool-call&quot;\`</span>
      <span class="hljs-comment">// - If it&#x27;s returning a tool&#x27;s result: chunk will have \`type: &quot;tool-result&quot;\`</span>

      <span class="hljs-keyword">if</span> (chunk.<span class="hljs-property">choices</span> &amp;&amp; chunk.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>]?.<span class="hljs-property">delta</span>?.<span class="hljs-property">content</span>) {
        process.<span class="hljs-property">stdout</span>.<span class="hljs-title function_">write</span>(chunk.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>].<span class="hljs-property">delta</span>.<span class="hljs-property">content</span>);
      } <span class="hljs-keyword">else</span> <span class="hljs-keyword">if</span> (chunk.<span class="hljs-property">type</span> === <span class="hljs-string">&quot;tool-call&quot;</span>) {
        <span class="hljs-comment">// In a real scenario, you&#x27;d execute the tool call here.</span>
        process.<span class="hljs-property">stdout</span>.<span class="hljs-title function_">write</span>(<span class="hljs-string">\`\\n[Agent wants to call tool: <span class="hljs-subst">\${chunk.toolName}</span> with args: <span class="hljs-subst">\${<span class="hljs-built_in">JSON</span>.stringify(chunk.toolArgs)}</span>]\`</span>);
        <span class="hljs-comment">// ... then feed the result back to the agent.</span>
      }
      <span class="hljs-comment">// Add more handling for other chunk types as needed.</span>
    }
    process.<span class="hljs-property">stdout</span>.<span class="hljs-title function_">write</span>(<span class="hljs-string">&quot;\\n&quot;</span>);
    <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">&quot;\\n✅ Agent run finished.&quot;</span>);

  } <span class="hljs-keyword">catch</span> (error) {
    <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">error</span>(<span class="hljs-string">&quot;💥 An error occurred with the AI Agent:&quot;</span>, error.<span class="hljs-property">message</span>);
  }
}

<span class="hljs-title function_">useAiAgent</span>();`,wrap:!1}}),Os=new w({props:{title:"Join the Community & Contribute!",local:"join-the-community--contribute",headingTag:"h2"}}),ll=new w({props:{title:"Setting Up Your Development Environment",local:"setting-up-your-development-environment",headingTag:"h3"}}),el=new U({props:{code:"c3VkbyUyMGNvcmVwYWNrJTIwZW5hYmxlJTIwJTIzJTIwWW91JTIwbWlnaHQlMjBub3QlMjBuZWVkJTIwc3VkbyUyMGRlcGVuZGluZyUyMG9uJTIweW91ciUyMHNldHVw",highlighted:"sudo corepack enable # You might not need sudo depending on your setup",wrap:!1}}),Ml=new U({props:{code:"cG5wbSUyMGluc3RhbGw=",highlighted:"pnpm install",wrap:!1}}),pl=new U({props:{code:"cG5wbSUyMC1yJTIwZm9ybWF0JTNBY2hlY2slMEFwbnBtJTIwLXIlMjBsaW50JTNBY2hlY2s=",highlighted:`pnpm -r format:check
pnpm -r lint:check`,wrap:!1}}),ol=new U({props:{code:"cG5wbSUyMC1yJTIwZm9ybWF0",highlighted:"pnpm -r format",wrap:!1}}),cl=new U({props:{code:"cG5wbSUyMC1yJTIwdGVzdA==",highlighted:"pnpm -r test",wrap:!1}}),rl=new w({props:{title:"Building the Libraries",local:"building-the-libraries",headingTag:"h3"}}),yl=new U({props:{code:"cG5wbSUyMC1yJTIwYnVpbGQ=",highlighted:"pnpm -r build",wrap:!1}}),Tl=new w({props:{title:"License",local:"license",headingTag:"h2"}}),hl=new ft({props:{source:"https://github.com/huggingface/huggingface.js/blob/main/docs/index.md"}}),{c(){B=M("meta"),xl=e(),Hl=M("p"),_l=e(),Z=M("p"),Z.innerHTML=pe,zl=e(),c(N.$$.fragment),Ll=e(),W=M("p"),W.textContent=oe,$l=e(),A=M("p"),A.innerHTML=ie,ql=e(),R=M("ul"),R.innerHTML=ce,Kl=e(),S=M("p"),S.innerHTML=re,Dl=e(),Y=M("ul"),Y.innerHTML=Je,Ol=e(),V=M("p"),V.innerHTML=ye,Pl=e(),c(Q.$$.fragment),sa=e(),c(F.$$.fragment),la=e(),H=M("p"),H.textContent=je,aa=e(),X=M("p"),X.innerHTML=Te,na=e(),x=M("p"),x.innerHTML=Ue,ea=e(),_=M("p"),_.innerHTML=he,ta=e(),m=M("ol"),z=M("li"),ml=M("p"),ml.innerHTML=we,Gn=e(),c(L.$$.fragment),fn=e(),$=M("li"),ul=M("p"),ul.innerHTML=me,Zn=e(),c(q.$$.fragment),kn=e(),K=M("li"),dl=M("p"),dl.innerHTML=ue,En=e(),d=M("ul"),Il=M("li"),Il.innerHTML=de,vn=e(),gl=M("li"),gl.textContent=Ie,Nn=e(),bl=M("li"),bl.innerHTML=ge,Wn=e(),g=M("li"),An=ne(`For this quick start, we’ll set it as an environment variable in your terminal:
	`),c(D.$$.fragment),Rn=ne("(Replace "),Cl=M("code"),Cl.textContent=be,Sn=ne(` with your actual token)
`),Bl=M("em"),Bl.innerHTML=Ce,Yn=e(),G=M("li"),Gl=M("p"),Gl.innerHTML=Be,Vn=e(),c(O.$$.fragment),Qn=e(),fl=M("p"),fl.innerHTML=Ge,Fn=e(),f=M("li"),Zl=M("p"),Zl.innerHTML=fe,Hn=e(),c(P.$$.fragment),Xn=e(),kl=M("p"),kl.textContent=Ze,Ma=e(),ss=M("p"),ss.textContent=ke,pa=e(),oa=M("hr"),ia=e(),c(ls.$$.fragment),ca=e(),as=M("p"),as.textContent=Ee,ra=e(),c(ns.$$.fragment),Ja=e(),es=M("p"),es.textContent=ve,ya=e(),ts=M("p"),ts.innerHTML=Ne,ja=e(),Ms=M("p"),Ms.innerHTML=We,Ta=e(),ps=M("p"),ps.textContent=Ae,Ua=e(),c(os.$$.fragment),ha=e(),is=M("p"),is.textContent=Re,wa=e(),c(cs.$$.fragment),ma=e(),rs=M("p"),rs.innerHTML=Se,ua=e(),Js=M("p"),Js.textContent=Ye,da=e(),c(ys.$$.fragment),Ia=e(),js=M("p"),js.innerHTML=Ve,ga=e(),Ts=M("p"),Ts.innerHTML=Qe,ba=e(),Us=M("p"),Us.textContent=Fe,Ca=e(),c(hs.$$.fragment),Ba=e(),c(ws.$$.fragment),Ga=e(),ms=M("p"),ms.innerHTML=He,fa=e(),us=M("ul"),us.innerHTML=Xe,Za=e(),c(ds.$$.fragment),ka=e(),Is=M("p"),Is.innerHTML=xe,Ea=e(),gs=M("p"),gs.textContent=_e,va=e(),b=M("ol"),El=M("li"),El.innerHTML=ze,xn=e(),bs=M("li"),vl=M("p"),vl.innerHTML=Le,_n=e(),c(Cs.$$.fragment),zn=e(),Bs=M("li"),Nl=M("p"),Nl.innerHTML=$e,Ln=e(),c(Gs.$$.fragment),Na=e(),fs=M("p"),fs.textContent=qe,Wa=e(),c(Zs.$$.fragment),Aa=e(),ks=M("p"),ks.textContent=Ke,Ra=e(),Es=M("p"),Es.textContent=De,Sa=e(),vs=M("ul"),vs.innerHTML=Oe,Ya=e(),Ns=M("p"),Ns.innerHTML=Pe,Va=e(),Ws=M("p"),Ws.textContent=st,Qa=e(),As=M("ul"),As.innerHTML=lt,Fa=e(),Rs=M("p"),Rs.innerHTML=at,Ha=e(),Ss=M("p"),Ss.textContent=nt,Xa=e(),Ys=M("ul"),Ys.innerHTML=et,xa=e(),c(Vs.$$.fragment),_a=e(),Qs=M("p"),Qs.innerHTML=tt,za=e(),c(Fs.$$.fragment),La=e(),Hs=M("p"),Hs.innerHTML=Mt,$a=e(),c(Xs.$$.fragment),qa=e(),c(xs.$$.fragment),Ka=e(),_s=M("p"),_s.innerHTML=pt,Da=e(),c(zs.$$.fragment),Oa=e(),c(Ls.$$.fragment),Pa=e(),$s=M("p"),$s.innerHTML=ot,sn=e(),c(qs.$$.fragment),ln=e(),Ks=M("p"),Ks.innerHTML=it,an=e(),Ds=M("p"),Ds.innerHTML=ct,nn=e(),c(Os.$$.fragment),en=e(),Ps=M("p"),Ps.textContent=rt,tn=e(),sl=M("ul"),sl.innerHTML=Jt,Mn=e(),c(ll.$$.fragment),pn=e(),al=M("p"),al.textContent=yt,on=e(),u=M("ol"),nl=M("li"),Wl=M("p"),Wl.innerHTML=jt,$n=e(),c(el.$$.fragment),qn=e(),tl=M("li"),Al=M("p"),Al.innerHTML=Tt,Kn=e(),c(Ml.$$.fragment),Dn=e(),I=M("li"),Rl=M("p"),Rl.innerHTML=Ut,On=e(),c(pl.$$.fragment),Pn=e(),Sl=M("p"),Sl.textContent=ht,se=e(),c(ol.$$.fragment),le=e(),il=M("li"),Yl=M("p"),Yl.innerHTML=wt,ae=e(),c(cl.$$.fragment),cn=e(),c(rl.$$.fragment),rn=e(),Jl=M("p"),Jl.textContent=mt,Jn=e(),c(yl.$$.fragment),yn=e(),jl=M("p"),jl.innerHTML=ut,jn=e(),c(Tl.$$.fragment),Tn=e(),Ul=M("p"),Ul.innerHTML=dt,Un=e(),c(hl.$$.fragment),hn=e(),Xl=M("p"),this.h()},l(s){const l=Gt("svelte-u9bgzb",document.head);B=p(l,"META",{name:!0,content:!0}),l.forEach(a),xl=t(s),Hl=p(s,"P",{}),h(Hl).forEach(a),_l=t(s),Z=p(s,"P",{align:!0,"data-svelte-h":!0}),o(Z)!=="svelte-9rngw"&&(Z.innerHTML=pe),zl=t(s),r(N.$$.fragment,s),Ll=t(s),W=p(s,"P",{"data-svelte-h":!0}),o(W)!=="svelte-yereeb"&&(W.textContent=oe),$l=t(s),A=p(s,"P",{"data-svelte-h":!0}),o(A)!=="svelte-10obrw4"&&(A.innerHTML=ie),ql=t(s),R=p(s,"UL",{"data-svelte-h":!0}),o(R)!=="svelte-hhrztu"&&(R.innerHTML=ce),Kl=t(s),S=p(s,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1i0yv6o"&&(S.innerHTML=re),Dl=t(s),Y=p(s,"UL",{"data-svelte-h":!0}),o(Y)!=="svelte-ahm88u"&&(Y.innerHTML=Je),Ol=t(s),V=p(s,"P",{"data-svelte-h":!0}),o(V)!=="svelte-194wyqj"&&(V.innerHTML=ye),Pl=t(s),r(Q.$$.fragment,s),sa=t(s),r(F.$$.fragment,s),la=t(s),H=p(s,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1c91j71"&&(H.textContent=je),aa=t(s),X=p(s,"P",{"data-svelte-h":!0}),o(X)!=="svelte-d5h8tq"&&(X.innerHTML=Te),na=t(s),x=p(s,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1d9gt1s"&&(x.innerHTML=Ue),ea=t(s),_=p(s,"P",{"data-svelte-h":!0}),o(_)!=="svelte-flprvc"&&(_.innerHTML=he),ta=t(s),m=p(s,"OL",{});var C=h(m);z=p(C,"LI",{});var mn=h(z);ml=p(mn,"P",{"data-svelte-h":!0}),o(ml)!=="svelte-1g0m6a8"&&(ml.innerHTML=we),Gn=t(mn),r(L.$$.fragment,mn),mn.forEach(a),fn=t(C),$=p(C,"LI",{});var un=h($);ul=p(un,"P",{"data-svelte-h":!0}),o(ul)!=="svelte-2qniiu"&&(ul.innerHTML=me),Zn=t(un),r(q.$$.fragment,un),un.forEach(a),kn=t(C),K=p(C,"LI",{});var dn=h(K);dl=p(dn,"P",{"data-svelte-h":!0}),o(dl)!=="svelte-sn0hm3"&&(dl.innerHTML=ue),En=t(dn),d=p(dn,"UL",{});var k=h(d);Il=p(k,"LI",{"data-svelte-h":!0}),o(Il)!=="svelte-19hkjk5"&&(Il.innerHTML=de),vn=t(k),gl=p(k,"LI",{"data-svelte-h":!0}),o(gl)!=="svelte-1xsealh"&&(gl.textContent=Ie),Nn=t(k),bl=p(k,"LI",{"data-svelte-h":!0}),o(bl)!=="svelte-1rux4tb"&&(bl.innerHTML=ge),Wn=t(k),g=p(k,"LI",{});var wl=h(g);An=ee(wl,`For this quick start, we’ll set it as an environment variable in your terminal:
	`),r(D.$$.fragment,wl),Rn=ee(wl,"(Replace "),Cl=p(wl,"CODE",{"data-svelte-h":!0}),o(Cl)!=="svelte-1jzd2m8"&&(Cl.textContent=be),Sn=ee(wl,` with your actual token)
`),Bl=p(wl,"EM",{"data-svelte-h":!0}),o(Bl)!=="svelte-7ihdj7"&&(Bl.innerHTML=Ce),wl.forEach(a),k.forEach(a),dn.forEach(a),Yn=t(C),G=p(C,"LI",{});var Vl=h(G);Gl=p(Vl,"P",{"data-svelte-h":!0}),o(Gl)!=="svelte-1nlecio"&&(Gl.innerHTML=Be),Vn=t(Vl),r(O.$$.fragment,Vl),Qn=t(Vl),fl=p(Vl,"P",{"data-svelte-h":!0}),o(fl)!=="svelte-qeszhw"&&(fl.innerHTML=Ge),Vl.forEach(a),Fn=t(C),f=p(C,"LI",{});var Ql=h(f);Zl=p(Ql,"P",{"data-svelte-h":!0}),o(Zl)!=="svelte-dmugnw"&&(Zl.innerHTML=fe),Hn=t(Ql),r(P.$$.fragment,Ql),Xn=t(Ql),kl=p(Ql,"P",{"data-svelte-h":!0}),o(kl)!=="svelte-q9bimo"&&(kl.textContent=Ze),Ql.forEach(a),C.forEach(a),Ma=t(s),ss=p(s,"P",{"data-svelte-h":!0}),o(ss)!=="svelte-vejunr"&&(ss.textContent=ke),pa=t(s),oa=p(s,"HR",{}),ia=t(s),r(ls.$$.fragment,s),ca=t(s),as=p(s,"P",{"data-svelte-h":!0}),o(as)!=="svelte-1hpgt0y"&&(as.textContent=Ee),ra=t(s),r(ns.$$.fragment,s),Ja=t(s),es=p(s,"P",{"data-svelte-h":!0}),o(es)!=="svelte-1hdyy4p"&&(es.textContent=ve),ya=t(s),ts=p(s,"P",{"data-svelte-h":!0}),o(ts)!=="svelte-1dw0u95"&&(ts.innerHTML=Ne),ja=t(s),Ms=p(s,"P",{"data-svelte-h":!0}),o(Ms)!=="svelte-22111m"&&(Ms.innerHTML=We),Ta=t(s),ps=p(s,"P",{"data-svelte-h":!0}),o(ps)!=="svelte-1s9as6v"&&(ps.textContent=Ae),Ua=t(s),r(os.$$.fragment,s),ha=t(s),is=p(s,"P",{"data-svelte-h":!0}),o(is)!=="svelte-xld2b7"&&(is.textContent=Re),wa=t(s),r(cs.$$.fragment,s),ma=t(s),rs=p(s,"P",{"data-svelte-h":!0}),o(rs)!=="svelte-lu9z90"&&(rs.innerHTML=Se),ua=t(s),Js=p(s,"P",{"data-svelte-h":!0}),o(Js)!=="svelte-1dux2hu"&&(Js.textContent=Ye),da=t(s),r(ys.$$.fragment,s),Ia=t(s),js=p(s,"P",{"data-svelte-h":!0}),o(js)!=="svelte-1i3kqnd"&&(js.innerHTML=Ve),ga=t(s),Ts=p(s,"P",{"data-svelte-h":!0}),o(Ts)!=="svelte-1ihmwvb"&&(Ts.innerHTML=Qe),ba=t(s),Us=p(s,"P",{"data-svelte-h":!0}),o(Us)!=="svelte-j3ak9j"&&(Us.textContent=Fe),Ca=t(s),r(hs.$$.fragment,s),Ba=t(s),r(ws.$$.fragment,s),Ga=t(s),ms=p(s,"P",{"data-svelte-h":!0}),o(ms)!=="svelte-2tp0ok"&&(ms.innerHTML=He),fa=t(s),us=p(s,"UL",{"data-svelte-h":!0}),o(us)!=="svelte-1iatnhv"&&(us.innerHTML=Xe),Za=t(s),r(ds.$$.fragment,s),ka=t(s),Is=p(s,"P",{"data-svelte-h":!0}),o(Is)!=="svelte-x5awss"&&(Is.innerHTML=xe),Ea=t(s),gs=p(s,"P",{"data-svelte-h":!0}),o(gs)!=="svelte-1z0qd7b"&&(gs.textContent=_e),va=t(s),b=p(s,"OL",{});var Fl=h(b);El=p(Fl,"LI",{"data-svelte-h":!0}),o(El)!=="svelte-7rce0j"&&(El.innerHTML=ze),xn=t(Fl),bs=p(Fl,"LI",{});var In=h(bs);vl=p(In,"P",{"data-svelte-h":!0}),o(vl)!=="svelte-16si1ow"&&(vl.innerHTML=Le),_n=t(In),r(Cs.$$.fragment,In),In.forEach(a),zn=t(Fl),Bs=p(Fl,"LI",{});var gn=h(Bs);Nl=p(gn,"P",{"data-svelte-h":!0}),o(Nl)!=="svelte-4hzsmo"&&(Nl.innerHTML=$e),Ln=t(gn),r(Gs.$$.fragment,gn),gn.forEach(a),Fl.forEach(a),Na=t(s),fs=p(s,"P",{"data-svelte-h":!0}),o(fs)!=="svelte-1fqbh9j"&&(fs.textContent=qe),Wa=t(s),r(Zs.$$.fragment,s),Aa=t(s),ks=p(s,"P",{"data-svelte-h":!0}),o(ks)!=="svelte-1all3dg"&&(ks.textContent=Ke),Ra=t(s),Es=p(s,"P",{"data-svelte-h":!0}),o(Es)!=="svelte-1bdjx4s"&&(Es.textContent=De),Sa=t(s),vs=p(s,"UL",{"data-svelte-h":!0}),o(vs)!=="svelte-1v43pk5"&&(vs.innerHTML=Oe),Ya=t(s),Ns=p(s,"P",{"data-svelte-h":!0}),o(Ns)!=="svelte-pkx2cd"&&(Ns.innerHTML=Pe),Va=t(s),Ws=p(s,"P",{"data-svelte-h":!0}),o(Ws)!=="svelte-mmcxlt"&&(Ws.textContent=st),Qa=t(s),As=p(s,"UL",{"data-svelte-h":!0}),o(As)!=="svelte-65ium7"&&(As.innerHTML=lt),Fa=t(s),Rs=p(s,"P",{"data-svelte-h":!0}),o(Rs)!=="svelte-116npiv"&&(Rs.innerHTML=at),Ha=t(s),Ss=p(s,"P",{"data-svelte-h":!0}),o(Ss)!=="svelte-1j12ogw"&&(Ss.textContent=nt),Xa=t(s),Ys=p(s,"UL",{"data-svelte-h":!0}),o(Ys)!=="svelte-dgx31w"&&(Ys.innerHTML=et),xa=t(s),r(Vs.$$.fragment,s),_a=t(s),Qs=p(s,"P",{"data-svelte-h":!0}),o(Qs)!=="svelte-e10mbo"&&(Qs.innerHTML=tt),za=t(s),r(Fs.$$.fragment,s),La=t(s),Hs=p(s,"P",{"data-svelte-h":!0}),o(Hs)!=="svelte-112z0v5"&&(Hs.innerHTML=Mt),$a=t(s),r(Xs.$$.fragment,s),qa=t(s),r(xs.$$.fragment,s),Ka=t(s),_s=p(s,"P",{"data-svelte-h":!0}),o(_s)!=="svelte-1h3175d"&&(_s.innerHTML=pt),Da=t(s),r(zs.$$.fragment,s),Oa=t(s),r(Ls.$$.fragment,s),Pa=t(s),$s=p(s,"P",{"data-svelte-h":!0}),o($s)!=="svelte-1nd9b03"&&($s.innerHTML=ot),sn=t(s),r(qs.$$.fragment,s),ln=t(s),Ks=p(s,"P",{"data-svelte-h":!0}),o(Ks)!=="svelte-1t4mx4"&&(Ks.innerHTML=it),an=t(s),Ds=p(s,"P",{"data-svelte-h":!0}),o(Ds)!=="svelte-1ritjwh"&&(Ds.innerHTML=ct),nn=t(s),r(Os.$$.fragment,s),en=t(s),Ps=p(s,"P",{"data-svelte-h":!0}),o(Ps)!=="svelte-7f49hr"&&(Ps.textContent=rt),tn=t(s),sl=p(s,"UL",{"data-svelte-h":!0}),o(sl)!=="svelte-1xlxvhx"&&(sl.innerHTML=Jt),Mn=t(s),r(ll.$$.fragment,s),pn=t(s),al=p(s,"P",{"data-svelte-h":!0}),o(al)!=="svelte-1x52wck"&&(al.textContent=yt),on=t(s),u=p(s,"OL",{});var E=h(u);nl=p(E,"LI",{});var bn=h(nl);Wl=p(bn,"P",{"data-svelte-h":!0}),o(Wl)!=="svelte-1fp9khq"&&(Wl.innerHTML=jt),$n=t(bn),r(el.$$.fragment,bn),bn.forEach(a),qn=t(E),tl=p(E,"LI",{});var Cn=h(tl);Al=p(Cn,"P",{"data-svelte-h":!0}),o(Al)!=="svelte-erm56j"&&(Al.innerHTML=Tt),Kn=t(Cn),r(Ml.$$.fragment,Cn),Cn.forEach(a),Dn=t(E),I=p(E,"LI",{});var v=h(I);Rl=p(v,"P",{"data-svelte-h":!0}),o(Rl)!=="svelte-fvwwdm"&&(Rl.innerHTML=Ut),On=t(v),r(pl.$$.fragment,v),Pn=t(v),Sl=p(v,"P",{"data-svelte-h":!0}),o(Sl)!=="svelte-1utyq6k"&&(Sl.textContent=ht),se=t(v),r(ol.$$.fragment,v),v.forEach(a),le=t(E),il=p(E,"LI",{});var Bn=h(il);Yl=p(Bn,"P",{"data-svelte-h":!0}),o(Yl)!=="svelte-1kdhot8"&&(Yl.innerHTML=wt),ae=t(Bn),r(cl.$$.fragment,Bn),Bn.forEach(a),E.forEach(a),cn=t(s),r(rl.$$.fragment,s),rn=t(s),Jl=p(s,"P",{"data-svelte-h":!0}),o(Jl)!=="svelte-a4dml1"&&(Jl.textContent=mt),Jn=t(s),r(yl.$$.fragment,s),yn=t(s),jl=p(s,"P",{"data-svelte-h":!0}),o(jl)!=="svelte-vp5zdj"&&(jl.innerHTML=ut),jn=t(s),r(Tl.$$.fragment,s),Tn=t(s),Ul=p(s,"P",{"data-svelte-h":!0}),o(Ul)!=="svelte-1491cik"&&(Ul.innerHTML=dt),Un=t(s),r(hl.$$.fragment,s),hn=t(s),Xl=p(s,"P",{}),h(Xl).forEach(a),this.h()},h(){te(B,"name","hf:doc:metadata"),te(B,"content",kt),te(Z,"align","center")},m(s,l){i(document.head,B),n(s,xl,l),n(s,Hl,l),n(s,_l,l),n(s,Z,l),n(s,zl,l),J(N,s,l),n(s,Ll,l),n(s,W,l),n(s,$l,l),n(s,A,l),n(s,ql,l),n(s,R,l),n(s,Kl,l),n(s,S,l),n(s,Dl,l),n(s,Y,l),n(s,Ol,l),n(s,V,l),n(s,Pl,l),J(Q,s,l),n(s,sa,l),J(F,s,l),n(s,la,l),n(s,H,l),n(s,aa,l),n(s,X,l),n(s,na,l),n(s,x,l),n(s,ea,l),n(s,_,l),n(s,ta,l),n(s,m,l),i(m,z),i(z,ml),i(z,Gn),J(L,z,null),i(m,fn),i(m,$),i($,ul),i($,Zn),J(q,$,null),i(m,kn),i(m,K),i(K,dl),i(K,En),i(K,d),i(d,Il),i(d,vn),i(d,gl),i(d,Nn),i(d,bl),i(d,Wn),i(d,g),i(g,An),J(D,g,null),i(g,Rn),i(g,Cl),i(g,Sn),i(g,Bl),i(m,Yn),i(m,G),i(G,Gl),i(G,Vn),J(O,G,null),i(G,Qn),i(G,fl),i(m,Fn),i(m,f),i(f,Zl),i(f,Hn),J(P,f,null),i(f,Xn),i(f,kl),n(s,Ma,l),n(s,ss,l),n(s,pa,l),n(s,oa,l),n(s,ia,l),J(ls,s,l),n(s,ca,l),n(s,as,l),n(s,ra,l),J(ns,s,l),n(s,Ja,l),n(s,es,l),n(s,ya,l),n(s,ts,l),n(s,ja,l),n(s,Ms,l),n(s,Ta,l),n(s,ps,l),n(s,Ua,l),J(os,s,l),n(s,ha,l),n(s,is,l),n(s,wa,l),J(cs,s,l),n(s,ma,l),n(s,rs,l),n(s,ua,l),n(s,Js,l),n(s,da,l),J(ys,s,l),n(s,Ia,l),n(s,js,l),n(s,ga,l),n(s,Ts,l),n(s,ba,l),n(s,Us,l),n(s,Ca,l),J(hs,s,l),n(s,Ba,l),J(ws,s,l),n(s,Ga,l),n(s,ms,l),n(s,fa,l),n(s,us,l),n(s,Za,l),J(ds,s,l),n(s,ka,l),n(s,Is,l),n(s,Ea,l),n(s,gs,l),n(s,va,l),n(s,b,l),i(b,El),i(b,xn),i(b,bs),i(bs,vl),i(bs,_n),J(Cs,bs,null),i(b,zn),i(b,Bs),i(Bs,Nl),i(Bs,Ln),J(Gs,Bs,null),n(s,Na,l),n(s,fs,l),n(s,Wa,l),J(Zs,s,l),n(s,Aa,l),n(s,ks,l),n(s,Ra,l),n(s,Es,l),n(s,Sa,l),n(s,vs,l),n(s,Ya,l),n(s,Ns,l),n(s,Va,l),n(s,Ws,l),n(s,Qa,l),n(s,As,l),n(s,Fa,l),n(s,Rs,l),n(s,Ha,l),n(s,Ss,l),n(s,Xa,l),n(s,Ys,l),n(s,xa,l),J(Vs,s,l),n(s,_a,l),n(s,Qs,l),n(s,za,l),J(Fs,s,l),n(s,La,l),n(s,Hs,l),n(s,$a,l),J(Xs,s,l),n(s,qa,l),J(xs,s,l),n(s,Ka,l),n(s,_s,l),n(s,Da,l),J(zs,s,l),n(s,Oa,l),J(Ls,s,l),n(s,Pa,l),n(s,$s,l),n(s,sn,l),J(qs,s,l),n(s,ln,l),n(s,Ks,l),n(s,an,l),n(s,Ds,l),n(s,nn,l),J(Os,s,l),n(s,en,l),n(s,Ps,l),n(s,tn,l),n(s,sl,l),n(s,Mn,l),J(ll,s,l),n(s,pn,l),n(s,al,l),n(s,on,l),n(s,u,l),i(u,nl),i(nl,Wl),i(nl,$n),J(el,nl,null),i(u,qn),i(u,tl),i(tl,Al),i(tl,Kn),J(Ml,tl,null),i(u,Dn),i(u,I),i(I,Rl),i(I,On),J(pl,I,null),i(I,Pn),i(I,Sl),i(I,se),J(ol,I,null),i(u,le),i(u,il),i(il,Yl),i(il,ae),J(cl,il,null),n(s,cn,l),J(rl,s,l),n(s,rn,l),n(s,Jl,l),n(s,Jn,l),J(yl,s,l),n(s,yn,l),n(s,jl,l),n(s,jn,l),J(Tl,s,l),n(s,Tn,l),n(s,Ul,l),n(s,Un,l),J(hl,s,l),n(s,hn,l),n(s,Xl,l),wn=!0},p:gt,i(s){wn||(y(N.$$.fragment,s),y(Q.$$.fragment,s),y(F.$$.fragment,s),y(L.$$.fragment,s),y(q.$$.fragment,s),y(D.$$.fragment,s),y(O.$$.fragment,s),y(P.$$.fragment,s),y(ls.$$.fragment,s),y(ns.$$.fragment,s),y(os.$$.fragment,s),y(cs.$$.fragment,s),y(ys.$$.fragment,s),y(hs.$$.fragment,s),y(ws.$$.fragment,s),y(ds.$$.fragment,s),y(Cs.$$.fragment,s),y(Gs.$$.fragment,s),y(Zs.$$.fragment,s),y(Vs.$$.fragment,s),y(Fs.$$.fragment,s),y(Xs.$$.fragment,s),y(xs.$$.fragment,s),y(zs.$$.fragment,s),y(Ls.$$.fragment,s),y(qs.$$.fragment,s),y(Os.$$.fragment,s),y(ll.$$.fragment,s),y(el.$$.fragment,s),y(Ml.$$.fragment,s),y(pl.$$.fragment,s),y(ol.$$.fragment,s),y(cl.$$.fragment,s),y(rl.$$.fragment,s),y(yl.$$.fragment,s),y(Tl.$$.fragment,s),y(hl.$$.fragment,s),wn=!0)},o(s){j(N.$$.fragment,s),j(Q.$$.fragment,s),j(F.$$.fragment,s),j(L.$$.fragment,s),j(q.$$.fragment,s),j(D.$$.fragment,s),j(O.$$.fragment,s),j(P.$$.fragment,s),j(ls.$$.fragment,s),j(ns.$$.fragment,s),j(os.$$.fragment,s),j(cs.$$.fragment,s),j(ys.$$.fragment,s),j(hs.$$.fragment,s),j(ws.$$.fragment,s),j(ds.$$.fragment,s),j(Cs.$$.fragment,s),j(Gs.$$.fragment,s),j(Zs.$$.fragment,s),j(Vs.$$.fragment,s),j(Fs.$$.fragment,s),j(Xs.$$.fragment,s),j(xs.$$.fragment,s),j(zs.$$.fragment,s),j(Ls.$$.fragment,s),j(qs.$$.fragment,s),j(Os.$$.fragment,s),j(ll.$$.fragment,s),j(el.$$.fragment,s),j(Ml.$$.fragment,s),j(pl.$$.fragment,s),j(ol.$$.fragment,s),j(cl.$$.fragment,s),j(rl.$$.fragment,s),j(yl.$$.fragment,s),j(Tl.$$.fragment,s),j(hl.$$.fragment,s),wn=!1},d(s){s&&(a(xl),a(Hl),a(_l),a(Z),a(zl),a(Ll),a(W),a($l),a(A),a(ql),a(R),a(Kl),a(S),a(Dl),a(Y),a(Ol),a(V),a(Pl),a(sa),a(la),a(H),a(aa),a(X),a(na),a(x),a(ea),a(_),a(ta),a(m),a(Ma),a(ss),a(pa),a(oa),a(ia),a(ca),a(as),a(ra),a(Ja),a(es),a(ya),a(ts),a(ja),a(Ms),a(Ta),a(ps),a(Ua),a(ha),a(is),a(wa),a(ma),a(rs),a(ua),a(Js),a(da),a(Ia),a(js),a(ga),a(Ts),a(ba),a(Us),a(Ca),a(Ba),a(Ga),a(ms),a(fa),a(us),a(Za),a(ka),a(Is),a(Ea),a(gs),a(va),a(b),a(Na),a(fs),a(Wa),a(Aa),a(ks),a(Ra),a(Es),a(Sa),a(vs),a(Ya),a(Ns),a(Va),a(Ws),a(Qa),a(As),a(Fa),a(Rs),a(Ha),a(Ss),a(Xa),a(Ys),a(xa),a(_a),a(Qs),a(za),a(La),a(Hs),a($a),a(qa),a(Ka),a(_s),a(Da),a(Oa),a(Pa),a($s),a(sn),a(ln),a(Ks),a(an),a(Ds),a(nn),a(en),a(Ps),a(tn),a(sl),a(Mn),a(pn),a(al),a(on),a(u),a(cn),a(rn),a(Jl),a(Jn),a(yn),a(jl),a(jn),a(Tn),a(Ul),a(Un),a(hn),a(Xl)),a(B),T(N,s),T(Q,s),T(F,s),T(L),T(q),T(D),T(O),T(P),T(ls,s),T(ns,s),T(os,s),T(cs,s),T(ys,s),T(hs,s),T(ws,s),T(ds,s),T(Cs),T(Gs),T(Zs,s),T(Vs,s),T(Fs,s),T(Xs,s),T(xs,s),T(zs,s),T(Ls,s),T(qs,s),T(Os,s),T(ll,s),T(el),T(Ml),T(pl),T(ol),T(cl),T(rl,s),T(yl,s),T(Tl,s),T(hl,s)}}}const kt='{"title":"Hugging Face JS Libraries: Supercharge Your JavaScript AI Applications!","local":"hugging-face-js-libraries-supercharge-your-javascript-ai-applications","sections":[{"title":"🚀 Quick Start: Your First AI Adventure in 5 Minutes! 🌟","local":"-quick-start-your-first-ai-adventure-in-5-minutes-","sections":[],"depth":2},{"title":"📚 Digging Deeper: Installation & Setup Options","local":"-digging-deeper-installation--setup-options","sections":[{"title":"Installation: Add Hugging Face JS to Your Project","local":"installation-add-hugging-face-js-to-your-project","sections":[],"depth":3},{"title":"🔑 Secure Your Hugging Face Token!","local":"-secure-your-hugging-face-token","sections":[],"depth":3},{"title":"Your First AI Task (Revisited): Text Generation","local":"your-first-ai-task-revisited-text-generation","sections":[],"depth":3}],"depth":2},{"title":"🛠️ Explore Our JavaScript Toolkit for AI","local":"-explore-our-javascript-toolkit-for-ai","sections":[],"depth":2},{"title":"💡 Diving Deeper: Code Examples & Use Cases","local":"-diving-deeper-code-examples--use-cases","sections":[{"title":"@huggingface/inference Unleashed: More AI Tasks","local":"huggingfaceinference-unleashed-more-ai-tasks","sections":[],"depth":3},{"title":"@huggingface/hub in Action: Managing Your AI Assets","local":"huggingfacehub-in-action-managing-your-ai-assets","sections":[],"depth":3},{"title":"@huggingface/mcp-client : Building AI Agents","local":"huggingfacemcp-client--building-ai-agents","sections":[],"depth":3}],"depth":2},{"title":"Join the Community & Contribute!","local":"join-the-community--contribute","sections":[{"title":"Setting Up Your Development Environment","local":"setting-up-your-development-environment","sections":[],"depth":3},{"title":"Building the Libraries","local":"building-the-libraries","sections":[],"depth":3}],"depth":2},{"title":"License","local":"license","sections":[],"depth":2}],"depth":1}';function Et(Me){return bt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rt extends Ct{constructor(B){super(),Bt(this,B,Et,Zt,It,{})}}export{Rt as component};
