import{s as Ns,f as _l,n as Es,o as Ps}from"../chunks/scheduler.37c15a92.js";import{S as Fs,i as Ds,g as u,s as n,r as M,A as Ks,h as a,f as l,c as i,j as Gl,u as p,x as o,k as m,y as Ll,a as s,v as r,d as c,t as T,w as y}from"../chunks/index.2bf4358c.js";import{C as U}from"../chunks/CodeBlock.4e987730.js";import{H as ke}from"../chunks/Heading.8ada512a.js";import{E as Os}from"../chunks/getInferenceSnippets.d4d07d1e.js";function en(Hl){let J,Fe,Ee,De,d,Ke,I,Sl,Oe,j,$l="Un aspect crucial des agents d’IA est leur capacité à prendre des <strong>actions</strong>. Comme nous l’avons vu, cela se fait par l’utilisation des <strong>outils</strong>.",et,C,Rl="Dans cette section, nous verrons ce que sont les outils, comment les concevoir efficacement, et comment les intégrer dans votre agent via le message système.",tt,f,Ql="En fournissant à votre agent les bons outils — et en décrivant clairement le fonctionnement de ces outils — vous pouvez augmenter de manière spectaculaire ce que votre IA peut accomplir. Plongeons-nous dedans !",lt,b,st,v,Zl="Un <strong>outil est une fonction fournie au LLM</strong>. Cette fonction doit remplir un <strong>objectif clair</strong>.",nt,x,zl="Voici quelques outils couramment utilisés dans les agents d’IA :",it,A,Xl="<thead><tr><th>Outil</th> <th>Description</th></tr></thead> <tbody><tr><td>Recherche Web</td> <td>Permet à l’agent de récupérer des informations à jour depuis Internet.</td></tr> <tr><td>Génération d’images</td> <td>Crée des images à partir de descriptions textuelles.</td></tr> <tr><td>Récupération</td> <td>Récupère des informations à partir d’une source externe.</td></tr> <tr><td>Interface API</td> <td>Interagit avec une API externe (GitHub, YouTube, Spotify, etc.).</td></tr></tbody>",ut,B,Vl="Ce ne sont que des exemples, car en réalité, vous pouvez créer un outil pour n’importe quel cas d’utilisation !",at,q,Yl="Un bon outil doit être quelque chose qui <strong>complémente la puissance d’un LLM</strong>.",ot,h,Wl="Par exemple, si vous devez effectuer des opérations arithmétiques, fournir un <strong>outil calculatrice</strong> à votre LLM donnera de meilleurs résultats que de se fier aux capacités natives du modèle.",Mt,_,kl="De plus, <strong>les LLMs prédisent la complétion d’une invite en se basant sur leurs données d’entraînement</strong>, ce qui signifie que leur connaissance interne n’inclut que les événements antérieurs à leur entraînement. Par conséquent, si votre agent a besoin de données à jour, vous devez les fournir via un outil.",pt,g,Nl="Par exemple, si vous demandez directement à un LLM (sans outil de recherche) la météo d’aujourd’hui, le LLM pourrait inventer une météo aléatoire.",rt,G,El,ct,L,Pl="<li><p>Un outil doit contenir :</p> <ul><li>Une <strong>description textuelle de ce que fait la fonction</strong>.</li> <li>Un <em>callable</em> (quelque chose pour effectuer une action).</li> <li>Des <em>arguments</em> avec typage.</li> <li>(Optionnel) Des sorties avec typage.</li></ul></li>",Tt,H,yt,S,Fl="Comme nous l’avons vu, les LLMs ne peuvent recevoir que des entrées textuelles et générer des sorties textuelles. Ils ne peuvent pas appeler des outils par eux-mêmes. Par <em>fournir des outils à un Agent</em>, nous <strong>enseignons</strong> au LLM l’existence des outils et lui demandons de générer du texte qui invoquera ces outils lorsqu’il en aura besoin. Par exemple, si nous fournissons un outil pour vérifier la météo d’un lieu via Internet, puis que nous demandons au LLM la météo à Paris, le LLM reconnaîtra que cette question constitue une opportunité pertinente pour utiliser l’outil “météo” que nous lui avons enseigné. Le LLM générera du <em>texte</em>, sous forme de code, pour invoquer cet outil. Il incombe à l’<strong>Agent</strong> d’analyser la sortie du LLM, de reconnaître qu’un appel à un outil est requis, et d’invoquer l’outil au nom du LLM. La sortie de l’outil sera ensuite renvoyée au LLM, qui composera sa réponse finale pour l’utilisateur.",mt,$,Dl="La sortie d’un appel d’outil est un autre type de message dans la conversation. Les étapes d’appel d’outil ne sont généralement pas montrées à l’utilisateur : l’Agent récupère la conversation, appelle l’(les) outil(s), obtient les sorties, les ajoute en tant que nouveau message dans la conversation, et renvoie la conversation mise à jour au LLM. Du point de vue de l’utilisateur, c’est comme si le LLM avait utilisé l’outil, mais en réalité, c’est notre code applicatif (l’<strong>Agent</strong>) qui l’a fait.",Jt,R,Kl="Nous parlerons beaucoup plus de ce processus lors de sessions futures.",Ut,Q,wt,Z,Ol="La réponse complète peut sembler complexe, mais nous utilisons essentiellement le prompt système pour fournir au modèle des descriptions textuelles des outils disponibles :",dt,z,es,It,X,ts="Pour que cela fonctionne, nous devons être très précis et rigoureux concernant :",jt,V,ls="<li><strong>Ce que fait l’outil</strong></li> <li><strong>Les entrées exactes qu’il attend</strong></li>",Ct,Y,ss="C’est la raison pour laquelle les descriptions d’outils sont généralement fournies en utilisant des structures expressives mais précises, telles que des langages informatiques ou du JSON. Il n’est pas <em>nécessaire</em> de procéder ainsi, tout format précis et cohérent fonctionnerait.",ft,W,ns="Si cela semble trop théorique, comprenons-le à travers un exemple concret.",bt,k,is="Nous allons implémenter un outil <strong>calculatrice</strong> simplifié qui se contentera de multiplier deux entiers. Voici une implémentation en Python :",vt,N,xt,E,us="Ainsi, notre outil s’appelle <code>calculator</code>, il <strong>multiplie deux entiers</strong>, et il requiert les entrées suivantes :",At,P,as="<li><strong><code>a</code></strong> (<em>int</em>): Un entier.</li> <li><strong><code>b</code></strong> (<em>int</em>): Un entier.</li>",Bt,F,os="La sortie de l’outil est un autre nombre entier que nous pouvons décrire ainsi :",qt,D,Ms="<li>(<em>int</em>): Le produit de <code>a</code> et <code>b</code>.</li>",ht,K,ps="Tous ces détails sont importants. Rassemblons-les dans une chaîne de texte qui décrit notre outil pour que le LLM puisse le comprendre.",_t,O,gt,ee,rs="<p><strong>Rappel :</strong> Cette description textuelle est <em>ce que nous voulons que le LLM sache à propos de l’outil</em>.</p>",Gt,te,cs="Lorsque nous passons la chaîne précédente dans l’entrée du LLM, le modèle la reconnaîtra comme un outil et saura quelles entrées fournir et ce qu’il doit attendre en sortie.",Lt,le,Ts="Si nous souhaitons fournir des outils supplémentaires, nous devons rester cohérents et utiliser toujours le même format. Ce processus peut être fragile, et nous pourrions accidentellement négliger certains détails.",Ht,se,ys="Existe-t-il une meilleure méthode ?",St,ne,$t,ie,ms="Notre outil a été écrit en Python, et l’implémentation fournit déjà tout ce dont nous avons besoin :",Rt,ue,Js="<li>Un nom descriptif de ce qu’il fait : <code>calculator</code></li> <li>Une description plus détaillée, fournie par le commentaire docstring de la fonction : <code>Multiplie deux entiers.</code></li> <li>Les entrées et leur type : la fonction attend clairement deux <code>int</code>.</li> <li>Le type de la sortie.</li>",Qt,ae,Us="Il y a une raison pour laquelle on utilise des langages de programmation : ils sont expressifs, concis et précis.",Zt,oe,ws="Nous pourrions fournir le code source Python comme <em>spécification</em> de l’outil pour le LLM, mais la manière dont l’outil est implémenté n’a pas d’importance. Tout ce qui compte, c’est son nom, ce qu’il fait, les entrées qu’il attend et la sortie qu’il fournit.",zt,Me,ds="Nous tirerons parti des fonctionnalités d’introspection de Python pour exploiter le code source et construire automatiquement une description de l’outil. Tout ce dont nous avons besoin, c’est que l’implémentation de l’outil utilise des annotations de types, des docstrings et des noms de fonction pertinents. Nous écrirons un peu de code pour extraire les parties pertinentes du code source.",Xt,pe,Is="Une fois cela fait, il nous suffira d’utiliser un décorateur Python pour indiquer que la fonction <code>calculator</code> est un outil :",Vt,re,Yt,ce,js="Notez le décorateur <code>@tool</code> avant la définition de la fonction.",Wt,Te,Cs="Avec l’implémentation que nous verrons ensuite, nous serons capables d’extraire automatiquement le texte suivant à partir du code source :",kt,ye,Nt,me,fs="Comme vous pouvez le constater, c’est la même chose que nous avons écrit manuellement précédemment !",Et,Je,Pt,Ue,bs="Nous créons une classe générique <code>Tool</code> que nous pouvons réutiliser chaque fois que nous avons besoin d’utiliser un outil.",Ft,we,vs="<p><strong>Avertissement :</strong> Cette implémentation d’exemple est fictive mais ressemble de près aux implémentations réelles dans la plupart des bibliothèques.</p>",Dt,de,Kt,Ie,xs="Cela peut sembler compliqué, mais en y allant pas à pas, nous pouvons voir ce qu’elle fait. Nous définissons une classe <strong><code>Tool</code></strong> qui inclut :",Ot,je,As="<li><strong><code>name</code></strong> (<em>str</em>): Le nom de l’outil.</li> <li><strong><code>description</code></strong> (<em>str</em>): Une brève description de ce que fait l’outil.</li> <li><strong><code>function</code></strong> (<em>callable</em>): La fonction que l’outil exécute.</li> <li><strong><code>arguments</code></strong> (<em>list</em>): Les paramètres d’entrée attendus.</li> <li><strong><code>outputs</code></strong> (<em>str</em> ou <em>list</em>): Les sorties attendues de l’outil.</li> <li><strong><code>__call__()</code></strong> : Appelle la fonction lorsque l’instance de l’outil est invoquée.</li> <li><strong><code>to_string()</code></strong> : Convertit les attributs de l’outil en une représentation textuelle.</li>",el,Ce,Bs="Nous pourrions créer un outil avec cette classe en utilisant le code suivant :",tl,fe,ll,be,qs="Mais nous pouvons également utiliser le module <code>inspect</code> de Python pour récupérer toutes les informations pour nous ! C’est ce que fait le décorateur <code>@tool</code>.",sl,ve,hs="<p>Si cela vous intéresse, vous pouvez afficher la section suivante pour voir l’implémentation du décorateur.</p>",nl,w,Ne,_s="code du décorateur",gl,xe,il,Ae,gs="Pour réitérer, avec ce décorateur en place, nous pouvons implémenter notre outil comme ceci :",ul,Be,al,qe,Gs="Et nous pouvons utiliser la méthode <code>to_string</code> de <code>Tool</code> pour récupérer automatiquement un texte adapté à être utilisé comme description d’un outil pour un LLM :",ol,he,Ml,_e,Ls="La description est <strong>injectée</strong> dans le prompt système. Prenant l’exemple avec lequel nous avons commencé cette section, voici à quoi cela ressemblerait après avoir remplacé le <code>tools_description</code> :",pl,ge,Hs,rl,Ge,Ss='Dans la section <a href="actions">Actions</a>, nous en apprendrons plus sur la façon dont un Agent peut <strong>appeler</strong> cet outil que nous venons de créer.',cl,Tl,yl,Le,$s="Les outils jouent un rôle crucial dans l’amélioration des capacités des agents d’IA.",ml,He,Jl,Se,Rs=`Model Context Protocol (MCP) est un <strong>protocole ouvert</strong> qui standardise la manière dont les applications <strong>fournissent des outils aux LLMs</strong>.
MCP offre :`,Ul,$e,Qs="<li>Une liste croissante d’intégrations pré-construites que votre LLM peut directement utiliser</li> <li>La flexibilité de changer entre fournisseurs et vendeurs de LLM</li> <li>Les meilleures pratiques pour sécuriser vos données dans votre infrastructure</li>",wl,Re,Zs="Cela signifie que <strong>tout framework implémentant MCP peut utiliser les outils définis dans le protocole</strong>, éliminant le besoin de réimplémenter la même interface d’outils pour chaque framework.",dl,Qe,zs='Si vous voulez approfondir MCP, vous pouvez consulter notre <a href="https://huggingface.co/learn/mcp-course/" rel="nofollow">cours gratuit MCP</a>.',Il,jl,Cl,Ze,Xs="Les outils jouent un rôle crucial dans l’amélioration des capacités des agents IA.",fl,ze,Vs="Pour résumer, nous avons appris :",bl,Xe,Ys="<li><p><em>Ce que sont les outils</em> : des fonctions qui offrent des capacités supplémentaires aux LLMs, comme effectuer des calculs ou accéder à des données externes.</p></li> <li><p><em>Comment définir un outil</em> : en fournissant une description textuelle claire, des entrées, des sorties, et une fonction exécutable.</p></li> <li><p><em>Pourquoi les outils sont essentiels</em> : ils permettent aux Agents de surmonter les limites de l’entraînement statique des modèles, de gérer des tâches en temps réel, et d’effectuer des actions spécialisées.</p></li>",vl,Ve,Ws='Maintenant, nous pouvons passer au <a href="agent-steps-and-structure">Workflow de l’Agent</a> où vous verrez comment un Agent observe, réfléchit et agit. Cela <strong>rassemble tout ce que nous avons vu jusqu’à présent</strong> et prépare le terrain pour créer votre propre Agent IA entièrement fonctionnel.',xl,Ye,ks="Mais d’abord, il est temps pour un autre court quiz !",Al,We,Bl,Pe,ql;return d=new ke({props:{title:"Qu’est-ce que les Outils ?",local:"quest-ce-que-les-outils-",headingTag:"h1"}}),b=new ke({props:{title:"Qu’est-ce que les outils d’IA ?",local:"quest-ce-que-les-outils-dia-",headingTag:"h2"}}),H=new ke({props:{title:"Comment fonctionnent les outils ?",local:"comment-fonctionnent-les-outils-",headingTag:"h2"}}),Q=new ke({props:{title:"Comment fournir des outils à un LLM ?",local:"comment-fournir-des-outils-à-un-llm-",headingTag:"h2"}}),N=new U({props:{code:"ZGVmJTIwY2FsY3VsYXRvcihhJTNBJTIwaW50JTJDJTIwYiUzQSUyMGludCklMjAtJTNFJTIwaW50JTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyTXVsdGlwbGllJTIwZGV1eCUyMGVudGllcnMuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYSUyMColMjBiJTBBJTBBcHJpbnQoY2FsY3VsYXRvci50b19zdHJpbmcoKSk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculator</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiplie deux entiers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

<span class="hljs-built_in">print</span>(calculator.to_string())`,wrap:!1}}),O=new U({props:{code:"Tm9tJTIwZGUlMjBsJ291dGlsJTNBJTIwY2FsY3VsYXRvciUyQyUyMERlc2NyaXB0aW9uJTNBJTIwTXVsdGlwbGllJTIwZGV1eCUyMGVudGllcnMuJTJDJTIwQXJndW1lbnRzJTNBJTIwYSUzQSUyMGludCUyQyUyMGIlM0ElMjBpbnQlMkMlMjBTb3J0aWVzJTNBJTIwaW50",highlighted:'<span class="hljs-type">Nom</span> de l&#x27;outil: calculator, <span class="hljs-type">Description</span>: <span class="hljs-type">Multiplie</span> deux entiers., <span class="hljs-type">Arguments</span>: a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span>, <span class="hljs-type">Sorties</span>: <span class="hljs-built_in">int</span>',wrap:!1}}),ne=new ke({props:{title:"Sections d’auto-formatage des outils",local:"sections-dauto-formatage-des-outils",headingTag:"h3"}}),re=new U({props:{code:"JTQwdG9vbCUwQWRlZiUyMGNhbGN1bGF0b3IoYSUzQSUyMGludCUyQyUyMGIlM0ElMjBpbnQpJTIwLSUzRSUyMGludCUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMk11bHRpcGxpZSUyMGRldXglMjBlbnRpZXJzLiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGElMjAqJTIwYiUwQSUwQXByaW50KGNhbGN1bGF0b3IudG9fc3RyaW5nKCkp",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculator</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiplie deux entiers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

<span class="hljs-built_in">print</span>(calculator.to_string())`,wrap:!1}}),ye=new U({props:{code:"Tm9tJTIwZGUlMjBsJ291dGlsJTNBJTIwY2FsY3VsYXRvciUyQyUyMERlc2NyaXB0aW9uJTNBJTIwTXVsdGlwbGllJTIwZGV1eCUyMGVudGllcnMuJTJDJTIwQXJndW1lbnRzJTNBJTIwYSUzQSUyMGludCUyQyUyMGIlM0ElMjBpbnQlMkMlMjBTb3J0aWVzJTNBJTIwaW50",highlighted:'<span class="hljs-type">Nom</span> de l&#x27;outil: calculator, <span class="hljs-type">Description</span>: <span class="hljs-type">Multiplie</span> deux entiers., <span class="hljs-type">Arguments</span>: a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span>, <span class="hljs-type">Sorties</span>: <span class="hljs-built_in">int</span>',wrap:!1}}),Je=new ke({props:{title:"Implémentation générique d’un outil",local:"implémentation-générique-dun-outil",headingTag:"h3"}}),de=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">Tool</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Une classe représentant un morceau de code réutilisable (Outil).
    
    Attributs:
        name (str): Nom de l&#x27;outil.
        description (str): Une description textuelle de ce que fait l&#x27;outil.
        func (callable): La fonction que cet outil encapsule.
        arguments (list): Une liste d&#x27;arguments.
        outputs (str ou list): Le(s) type(s) de retour de la fonction encapsulée.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, 
                 name: <span class="hljs-built_in">str</span>, 
                 description: <span class="hljs-built_in">str</span>, 
                 func: <span class="hljs-built_in">callable</span>, 
                 arguments: <span class="hljs-built_in">list</span>,
                 outputs: <span class="hljs-built_in">str</span></span>):
        self.name = name
        self.description = description
        self.func = func
        self.arguments = arguments
        self.outputs = outputs

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">to_string</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-string">&quot;&quot;&quot;
        Retourne une représentation sous forme de chaîne de l&#x27;outil, 
        incluant son nom, sa description, ses arguments, et ses sorties.
        &quot;&quot;&quot;</span>
        args_str = <span class="hljs-string">&quot;, &quot;</span>.join([
            <span class="hljs-string">f&quot;<span class="hljs-subst">{arg_name}</span>: <span class="hljs-subst">{arg_type}</span>&quot;</span> <span class="hljs-keyword">for</span> arg_name, arg_type <span class="hljs-keyword">in</span> self.arguments
        ])
        
        <span class="hljs-keyword">return</span> (
            <span class="hljs-string">f&quot;Tool Name: <span class="hljs-subst">{self.name}</span>,&quot;</span>
            <span class="hljs-string">f&quot; Description: <span class="hljs-subst">{self.description}</span>,&quot;</span>
            <span class="hljs-string">f&quot; Arguments: <span class="hljs-subst">{args_str}</span>,&quot;</span>
            <span class="hljs-string">f&quot; Outputs: <span class="hljs-subst">{self.outputs}</span>&quot;</span>
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, *args, **kwargs</span>):
        <span class="hljs-string">&quot;&quot;&quot;
        Invoque la fonction sous-jacente (callable) avec les arguments fournis.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> self.func(*args, **kwargs)`,wrap:!1}}),fe=new U({props:{code:"Y2FsY3VsYXRvcl90b29sJTIwJTNEJTIwVG9vbCglMEElMjAlMjAlMjAlMjAlMjJjYWxjdWxhdG9yJTIyJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwbm9tJTBBJTIwJTIwJTIwJTIwJTIyTXVsdGlwbGllJTIwZGV1eCUyMGVudGllcnMuJTIyJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwZGVzY3JpcHRpb24lMEElMjAlMjAlMjAlMjBjYWxjdWxhdG9yJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwZm9uY3Rpb24lMjAlQzMlQTAlMjBhcHBlbGVyJTBBJTIwJTIwJTIwJTIwJTVCKCUyMmElMjIlMkMlMjAlMjJpbnQlMjIpJTJDJTIwKCUyMmIlMjIlMkMlMjAlMjJpbnQlMjIpJTVEJTJDJTIwJTIwJTIwJTIzJTIwZW50ciVDMyVBOWVzJTIwKG5vbXMlMjBldCUyMHR5cGVzKSUwQSUyMCUyMCUyMCUyMCUyMmludCUyMiUyQyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMHNvcnRpZSUwQSk=",highlighted:`calculator_tool = Tool(
    <span class="hljs-string">&quot;calculator&quot;</span>,                   <span class="hljs-comment"># nom</span>
    <span class="hljs-string">&quot;Multiplie deux entiers.&quot;</span>,      <span class="hljs-comment"># description</span>
    calculator,                     <span class="hljs-comment"># fonction à appeler</span>
    [(<span class="hljs-string">&quot;a&quot;</span>, <span class="hljs-string">&quot;int&quot;</span>), (<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;int&quot;</span>)],   <span class="hljs-comment"># entrées (noms et types)</span>
    <span class="hljs-string">&quot;int&quot;</span>,                          <span class="hljs-comment"># sortie</span>
)`,wrap:!1}}),xe=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">tool</span>(<span class="hljs-params">func</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Un décorateur qui crée une instance de Tool à partir de la fonction donnée.
    &quot;&quot;&quot;</span>
    <span class="hljs-comment"># Récupérer la signature de la fonction</span>
    signature = inspect.signature(func)
    
    <span class="hljs-comment"># Extraire les paires (nom_param, annotation_param) pour les entrées</span>
    arguments = []
    <span class="hljs-keyword">for</span> param <span class="hljs-keyword">in</span> signature.parameters.values():
        annotation_name = (
            param.annotation.__name__ 
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">hasattr</span>(param.annotation, <span class="hljs-string">&#x27;__name__&#x27;</span>) 
            <span class="hljs-keyword">else</span> <span class="hljs-built_in">str</span>(param.annotation)
        )
        arguments.append((param.name, annotation_name))
    
    <span class="hljs-comment"># Déterminer l&#x27;annotation de retour</span>
    return_annotation = signature.return_annotation
    <span class="hljs-keyword">if</span> return_annotation <span class="hljs-keyword">is</span> inspect._empty:
        outputs = <span class="hljs-string">&quot;Pas d&#x27;annotation de retour&quot;</span>
    <span class="hljs-keyword">else</span>:
        outputs = (
            return_annotation.__name__ 
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">hasattr</span>(return_annotation, <span class="hljs-string">&#x27;__name__&#x27;</span>) 
            <span class="hljs-keyword">else</span> <span class="hljs-built_in">str</span>(return_annotation)
        )
    
    <span class="hljs-comment"># Utiliser la docstring de la fonction comme description (par défaut si vide)</span>
    description = func.__doc__ <span class="hljs-keyword">or</span> <span class="hljs-string">&quot;No description provided.&quot;</span>
    
    <span class="hljs-comment"># Le nom de la fonction devient le nom de l&#x27;outil</span>
    name = func.__name__
    
    <span class="hljs-comment"># Retourner une nouvelle instance de Tool</span>
    <span class="hljs-keyword">return</span> Tool(
        name=name, 
        description=description, 
        func=func, 
        arguments=arguments, 
        outputs=outputs
    )`,wrap:!1}}),Be=new U({props:{code:"JTQwdG9vbCUwQWRlZiUyMGNhbGN1bGF0b3IoYSUzQSUyMGludCUyQyUyMGIlM0ElMjBpbnQpJTIwLSUzRSUyMGludCUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMk11bHRpcGxpZSUyMGRldXglMjBlbnRpZXJzLiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGElMjAqJTIwYiUwQSUwQXByaW50KGNhbGN1bGF0b3IudG9fc3RyaW5nKCkp",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculator</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiplie deux entiers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

<span class="hljs-built_in">print</span>(calculator.to_string())`,wrap:!1}}),he=new U({props:{code:"Tm9tJTIwZGUlMjBsJ291dGlsJTNBJTIwY2FsY3VsYXRvciUyQyUyMERlc2NyaXB0aW9uJTNBJTIwTXVsdGlwbGllJTIwZGV1eCUyMGVudGllcnMuJTJDJTIwQXJndW1lbnRzJTNBJTIwYSUzQSUyMGludCUyQyUyMGIlM0ElMjBpbnQlMkMlMjBTb3J0aWVzJTNBJTIwaW50",highlighted:'<span class="hljs-type">Nom</span> de l&#x27;outil: calculator, <span class="hljs-type">Description</span>: <span class="hljs-type">Multiplie</span> deux entiers., <span class="hljs-type">Arguments</span>: a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span>, <span class="hljs-type">Sorties</span>: <span class="hljs-built_in">int</span>',wrap:!1}}),He=new ke({props:{title:"Model Context Protocol (MCP) : une interface d’outils unifiée",local:"model-context-protocol-mcp--une-interface-doutils-unifiée",headingTag:"h3"}}),We=new Os({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/fr/unit1/tools.mdx"}}),{c(){J=u("meta"),Fe=n(),Ee=u("p"),De=n(),M(d.$$.fragment),Ke=n(),I=u("img"),Oe=n(),j=u("p"),j.innerHTML=$l,et=n(),C=u("p"),C.textContent=Rl,tt=n(),f=u("p"),f.textContent=Ql,lt=n(),M(b.$$.fragment),st=n(),v=u("p"),v.innerHTML=Zl,nt=n(),x=u("p"),x.textContent=zl,it=n(),A=u("table"),A.innerHTML=Xl,ut=n(),B=u("p"),B.textContent=Vl,at=n(),q=u("p"),q.innerHTML=Yl,ot=n(),h=u("p"),h.innerHTML=Wl,Mt=n(),_=u("p"),_.innerHTML=kl,pt=n(),g=u("p"),g.textContent=Nl,rt=n(),G=u("img"),ct=n(),L=u("ul"),L.innerHTML=Pl,Tt=n(),M(H.$$.fragment),yt=n(),S=u("p"),S.innerHTML=Fl,mt=n(),$=u("p"),$.innerHTML=Dl,Jt=n(),R=u("p"),R.textContent=Kl,Ut=n(),M(Q.$$.fragment),wt=n(),Z=u("p"),Z.textContent=Ol,dt=n(),z=u("img"),It=n(),X=u("p"),X.textContent=ts,jt=n(),V=u("ol"),V.innerHTML=ls,Ct=n(),Y=u("p"),Y.innerHTML=ss,ft=n(),W=u("p"),W.textContent=ns,bt=n(),k=u("p"),k.innerHTML=is,vt=n(),M(N.$$.fragment),xt=n(),E=u("p"),E.innerHTML=us,At=n(),P=u("ul"),P.innerHTML=as,Bt=n(),F=u("p"),F.textContent=os,qt=n(),D=u("ul"),D.innerHTML=Ms,ht=n(),K=u("p"),K.textContent=ps,_t=n(),M(O.$$.fragment),gt=n(),ee=u("blockquote"),ee.innerHTML=rs,Gt=n(),te=u("p"),te.textContent=cs,Lt=n(),le=u("p"),le.textContent=Ts,Ht=n(),se=u("p"),se.textContent=ys,St=n(),M(ne.$$.fragment),$t=n(),ie=u("p"),ie.textContent=ms,Rt=n(),ue=u("ul"),ue.innerHTML=Js,Qt=n(),ae=u("p"),ae.textContent=Us,Zt=n(),oe=u("p"),oe.innerHTML=ws,zt=n(),Me=u("p"),Me.textContent=ds,Xt=n(),pe=u("p"),pe.innerHTML=Is,Vt=n(),M(re.$$.fragment),Yt=n(),ce=u("p"),ce.innerHTML=js,Wt=n(),Te=u("p"),Te.textContent=Cs,kt=n(),M(ye.$$.fragment),Nt=n(),me=u("p"),me.textContent=fs,Et=n(),M(Je.$$.fragment),Pt=n(),Ue=u("p"),Ue.innerHTML=bs,Ft=n(),we=u("blockquote"),we.innerHTML=vs,Dt=n(),M(de.$$.fragment),Kt=n(),Ie=u("p"),Ie.innerHTML=xs,Ot=n(),je=u("ul"),je.innerHTML=As,el=n(),Ce=u("p"),Ce.textContent=Bs,tl=n(),M(fe.$$.fragment),ll=n(),be=u("p"),be.innerHTML=qs,sl=n(),ve=u("blockquote"),ve.innerHTML=hs,nl=n(),w=u("details"),Ne=u("summary"),Ne.textContent=_s,gl=n(),M(xe.$$.fragment),il=n(),Ae=u("p"),Ae.textContent=gs,ul=n(),M(Be.$$.fragment),al=n(),qe=u("p"),qe.innerHTML=Gs,ol=n(),M(he.$$.fragment),Ml=n(),_e=u("p"),_e.innerHTML=Ls,pl=n(),ge=u("img"),rl=n(),Ge=u("p"),Ge.innerHTML=Ss,cl=n(),Tl=u("hr"),yl=n(),Le=u("p"),Le.textContent=$s,ml=n(),M(He.$$.fragment),Jl=n(),Se=u("p"),Se.innerHTML=Rs,Ul=n(),$e=u("ul"),$e.innerHTML=Qs,wl=n(),Re=u("p"),Re.innerHTML=Zs,dl=n(),Qe=u("p"),Qe.innerHTML=zs,Il=n(),jl=u("hr"),Cl=n(),Ze=u("p"),Ze.textContent=Xs,fl=n(),ze=u("p"),ze.textContent=Vs,bl=n(),Xe=u("ul"),Xe.innerHTML=Ys,vl=n(),Ve=u("p"),Ve.innerHTML=Ws,xl=n(),Ye=u("p"),Ye.textContent=ks,Al=n(),M(We.$$.fragment),Bl=n(),Pe=u("p"),this.h()},l(e){const t=Ks("svelte-u9bgzb",document.head);J=a(t,"META",{name:!0,content:!0}),t.forEach(l),Fe=i(e),Ee=a(e,"P",{}),Gl(Ee).forEach(l),De=i(e),p(d.$$.fragment,e),Ke=i(e),I=a(e,"IMG",{src:!0,alt:!0}),Oe=i(e),j=a(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-fbzjl9"&&(j.innerHTML=$l),et=i(e),C=a(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-qjlsrw"&&(C.textContent=Rl),tt=i(e),f=a(e,"P",{"data-svelte-h":!0}),o(f)!=="svelte-1lpseza"&&(f.textContent=Ql),lt=i(e),p(b.$$.fragment,e),st=i(e),v=a(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-cvxsx9"&&(v.innerHTML=Zl),nt=i(e),x=a(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-ieki45"&&(x.textContent=zl),it=i(e),A=a(e,"TABLE",{"data-svelte-h":!0}),o(A)!=="svelte-o18hhl"&&(A.innerHTML=Xl),ut=i(e),B=a(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-1578lad"&&(B.textContent=Vl),at=i(e),q=a(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-zavgkk"&&(q.innerHTML=Yl),ot=i(e),h=a(e,"P",{"data-svelte-h":!0}),o(h)!=="svelte-4l0xuv"&&(h.innerHTML=Wl),Mt=i(e),_=a(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-1p1us6f"&&(_.innerHTML=kl),pt=i(e),g=a(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-1doz4nr"&&(g.textContent=Nl),rt=i(e),G=a(e,"IMG",{src:!0,alt:!0}),ct=i(e),L=a(e,"UL",{"data-svelte-h":!0}),o(L)!=="svelte-9qhixw"&&(L.innerHTML=Pl),Tt=i(e),p(H.$$.fragment,e),yt=i(e),S=a(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-157eeqr"&&(S.innerHTML=Fl),mt=i(e),$=a(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-88283q"&&($.innerHTML=Dl),Jt=i(e),R=a(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-psbfmd"&&(R.textContent=Kl),Ut=i(e),p(Q.$$.fragment,e),wt=i(e),Z=a(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-ux12xw"&&(Z.textContent=Ol),dt=i(e),z=a(e,"IMG",{src:!0,alt:!0}),It=i(e),X=a(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-1l232mj"&&(X.textContent=ts),jt=i(e),V=a(e,"OL",{"data-svelte-h":!0}),o(V)!=="svelte-mo4qti"&&(V.innerHTML=ls),Ct=i(e),Y=a(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-geocds"&&(Y.innerHTML=ss),ft=i(e),W=a(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-6capc4"&&(W.textContent=ns),bt=i(e),k=a(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-17522mu"&&(k.innerHTML=is),vt=i(e),p(N.$$.fragment,e),xt=i(e),E=a(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-b5enmt"&&(E.innerHTML=us),At=i(e),P=a(e,"UL",{"data-svelte-h":!0}),o(P)!=="svelte-ym5xkp"&&(P.innerHTML=as),Bt=i(e),F=a(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-i6tzj8"&&(F.textContent=os),qt=i(e),D=a(e,"UL",{"data-svelte-h":!0}),o(D)!=="svelte-eem86h"&&(D.innerHTML=Ms),ht=i(e),K=a(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-1bsj63c"&&(K.textContent=ps),_t=i(e),p(O.$$.fragment,e),gt=i(e),ee=a(e,"BLOCKQUOTE",{"data-svelte-h":!0}),o(ee)!=="svelte-xgy7yp"&&(ee.innerHTML=rs),Gt=i(e),te=a(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-t0nt59"&&(te.textContent=cs),Lt=i(e),le=a(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-1kxkz2u"&&(le.textContent=Ts),Ht=i(e),se=a(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-ojbeji"&&(se.textContent=ys),St=i(e),p(ne.$$.fragment,e),$t=i(e),ie=a(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-f16tzr"&&(ie.textContent=ms),Rt=i(e),ue=a(e,"UL",{"data-svelte-h":!0}),o(ue)!=="svelte-m90lk1"&&(ue.innerHTML=Js),Qt=i(e),ae=a(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-1etx7od"&&(ae.textContent=Us),Zt=i(e),oe=a(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-fvbzuf"&&(oe.innerHTML=ws),zt=i(e),Me=a(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-dbo8tr"&&(Me.textContent=ds),Xt=i(e),pe=a(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-gayksv"&&(pe.innerHTML=Is),Vt=i(e),p(re.$$.fragment,e),Yt=i(e),ce=a(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-fc7lom"&&(ce.innerHTML=js),Wt=i(e),Te=a(e,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-15dwiii"&&(Te.textContent=Cs),kt=i(e),p(ye.$$.fragment,e),Nt=i(e),me=a(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-41gbqm"&&(me.textContent=fs),Et=i(e),p(Je.$$.fragment,e),Pt=i(e),Ue=a(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-1ux3i79"&&(Ue.innerHTML=bs),Ft=i(e),we=a(e,"BLOCKQUOTE",{"data-svelte-h":!0}),o(we)!=="svelte-1qs5ksd"&&(we.innerHTML=vs),Dt=i(e),p(de.$$.fragment,e),Kt=i(e),Ie=a(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-v6nit1"&&(Ie.innerHTML=xs),Ot=i(e),je=a(e,"UL",{"data-svelte-h":!0}),o(je)!=="svelte-19ugnw6"&&(je.innerHTML=As),el=i(e),Ce=a(e,"P",{"data-svelte-h":!0}),o(Ce)!=="svelte-59sgl4"&&(Ce.textContent=Bs),tl=i(e),p(fe.$$.fragment,e),ll=i(e),be=a(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-1glbf26"&&(be.innerHTML=qs),sl=i(e),ve=a(e,"BLOCKQUOTE",{"data-svelte-h":!0}),o(ve)!=="svelte-1xl9l5i"&&(ve.innerHTML=hs),nl=i(e),w=a(e,"DETAILS",{});var hl=Gl(w);Ne=a(hl,"SUMMARY",{"data-svelte-h":!0}),o(Ne)!=="svelte-14dl2fo"&&(Ne.textContent=_s),gl=i(hl),p(xe.$$.fragment,hl),hl.forEach(l),il=i(e),Ae=a(e,"P",{"data-svelte-h":!0}),o(Ae)!=="svelte-1p3ayi2"&&(Ae.textContent=gs),ul=i(e),p(Be.$$.fragment,e),al=i(e),qe=a(e,"P",{"data-svelte-h":!0}),o(qe)!=="svelte-bs59s"&&(qe.innerHTML=Gs),ol=i(e),p(he.$$.fragment,e),Ml=i(e),_e=a(e,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-8f521d"&&(_e.innerHTML=Ls),pl=i(e),ge=a(e,"IMG",{src:!0,alt:!0}),rl=i(e),Ge=a(e,"P",{"data-svelte-h":!0}),o(Ge)!=="svelte-1ka4xoa"&&(Ge.innerHTML=Ss),cl=i(e),Tl=a(e,"HR",{}),yl=i(e),Le=a(e,"P",{"data-svelte-h":!0}),o(Le)!=="svelte-1rnyx6r"&&(Le.textContent=$s),ml=i(e),p(He.$$.fragment,e),Jl=i(e),Se=a(e,"P",{"data-svelte-h":!0}),o(Se)!=="svelte-vzi5tg"&&(Se.innerHTML=Rs),Ul=i(e),$e=a(e,"UL",{"data-svelte-h":!0}),o($e)!=="svelte-cvddem"&&($e.innerHTML=Qs),wl=i(e),Re=a(e,"P",{"data-svelte-h":!0}),o(Re)!=="svelte-1z5qs3"&&(Re.innerHTML=Zs),dl=i(e),Qe=a(e,"P",{"data-svelte-h":!0}),o(Qe)!=="svelte-1mrtyq8"&&(Qe.innerHTML=zs),Il=i(e),jl=a(e,"HR",{}),Cl=i(e),Ze=a(e,"P",{"data-svelte-h":!0}),o(Ze)!=="svelte-1oxm6zw"&&(Ze.textContent=Xs),fl=i(e),ze=a(e,"P",{"data-svelte-h":!0}),o(ze)!=="svelte-13rq5ja"&&(ze.textContent=Vs),bl=i(e),Xe=a(e,"UL",{"data-svelte-h":!0}),o(Xe)!=="svelte-yddv7r"&&(Xe.innerHTML=Ys),vl=i(e),Ve=a(e,"P",{"data-svelte-h":!0}),o(Ve)!=="svelte-1jkejiy"&&(Ve.innerHTML=Ws),xl=i(e),Ye=a(e,"P",{"data-svelte-h":!0}),o(Ye)!=="svelte-gu9wbg"&&(Ye.textContent=ks),Al=i(e),p(We.$$.fragment,e),Bl=i(e),Pe=a(e,"P",{}),Gl(Pe).forEach(l),this.h()},h(){m(J,"name","hf:doc:metadata"),m(J,"content",tn),_l(I.src,Sl="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/whiteboard-check-2.jpg")||m(I,"src",Sl),m(I,"alt","Planification de l'Unité 1"),_l(G.src,El="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/weather.jpg")||m(G,"src",El),m(G,"alt","Météo"),_l(z.src,es="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/Agent_system_prompt.png")||m(z,"src",es),m(z,"alt","Prompt système pour les outils"),_l(ge.src,Hs="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/Agent_system_prompt_tools.png")||m(ge,"src",Hs),m(ge,"alt","Prompt système pour les outils")},m(e,t){Ll(document.head,J),s(e,Fe,t),s(e,Ee,t),s(e,De,t),r(d,e,t),s(e,Ke,t),s(e,I,t),s(e,Oe,t),s(e,j,t),s(e,et,t),s(e,C,t),s(e,tt,t),s(e,f,t),s(e,lt,t),r(b,e,t),s(e,st,t),s(e,v,t),s(e,nt,t),s(e,x,t),s(e,it,t),s(e,A,t),s(e,ut,t),s(e,B,t),s(e,at,t),s(e,q,t),s(e,ot,t),s(e,h,t),s(e,Mt,t),s(e,_,t),s(e,pt,t),s(e,g,t),s(e,rt,t),s(e,G,t),s(e,ct,t),s(e,L,t),s(e,Tt,t),r(H,e,t),s(e,yt,t),s(e,S,t),s(e,mt,t),s(e,$,t),s(e,Jt,t),s(e,R,t),s(e,Ut,t),r(Q,e,t),s(e,wt,t),s(e,Z,t),s(e,dt,t),s(e,z,t),s(e,It,t),s(e,X,t),s(e,jt,t),s(e,V,t),s(e,Ct,t),s(e,Y,t),s(e,ft,t),s(e,W,t),s(e,bt,t),s(e,k,t),s(e,vt,t),r(N,e,t),s(e,xt,t),s(e,E,t),s(e,At,t),s(e,P,t),s(e,Bt,t),s(e,F,t),s(e,qt,t),s(e,D,t),s(e,ht,t),s(e,K,t),s(e,_t,t),r(O,e,t),s(e,gt,t),s(e,ee,t),s(e,Gt,t),s(e,te,t),s(e,Lt,t),s(e,le,t),s(e,Ht,t),s(e,se,t),s(e,St,t),r(ne,e,t),s(e,$t,t),s(e,ie,t),s(e,Rt,t),s(e,ue,t),s(e,Qt,t),s(e,ae,t),s(e,Zt,t),s(e,oe,t),s(e,zt,t),s(e,Me,t),s(e,Xt,t),s(e,pe,t),s(e,Vt,t),r(re,e,t),s(e,Yt,t),s(e,ce,t),s(e,Wt,t),s(e,Te,t),s(e,kt,t),r(ye,e,t),s(e,Nt,t),s(e,me,t),s(e,Et,t),r(Je,e,t),s(e,Pt,t),s(e,Ue,t),s(e,Ft,t),s(e,we,t),s(e,Dt,t),r(de,e,t),s(e,Kt,t),s(e,Ie,t),s(e,Ot,t),s(e,je,t),s(e,el,t),s(e,Ce,t),s(e,tl,t),r(fe,e,t),s(e,ll,t),s(e,be,t),s(e,sl,t),s(e,ve,t),s(e,nl,t),s(e,w,t),Ll(w,Ne),Ll(w,gl),r(xe,w,null),s(e,il,t),s(e,Ae,t),s(e,ul,t),r(Be,e,t),s(e,al,t),s(e,qe,t),s(e,ol,t),r(he,e,t),s(e,Ml,t),s(e,_e,t),s(e,pl,t),s(e,ge,t),s(e,rl,t),s(e,Ge,t),s(e,cl,t),s(e,Tl,t),s(e,yl,t),s(e,Le,t),s(e,ml,t),r(He,e,t),s(e,Jl,t),s(e,Se,t),s(e,Ul,t),s(e,$e,t),s(e,wl,t),s(e,Re,t),s(e,dl,t),s(e,Qe,t),s(e,Il,t),s(e,jl,t),s(e,Cl,t),s(e,Ze,t),s(e,fl,t),s(e,ze,t),s(e,bl,t),s(e,Xe,t),s(e,vl,t),s(e,Ve,t),s(e,xl,t),s(e,Ye,t),s(e,Al,t),r(We,e,t),s(e,Bl,t),s(e,Pe,t),ql=!0},p:Es,i(e){ql||(c(d.$$.fragment,e),c(b.$$.fragment,e),c(H.$$.fragment,e),c(Q.$$.fragment,e),c(N.$$.fragment,e),c(O.$$.fragment,e),c(ne.$$.fragment,e),c(re.$$.fragment,e),c(ye.$$.fragment,e),c(Je.$$.fragment,e),c(de.$$.fragment,e),c(fe.$$.fragment,e),c(xe.$$.fragment,e),c(Be.$$.fragment,e),c(he.$$.fragment,e),c(He.$$.fragment,e),c(We.$$.fragment,e),ql=!0)},o(e){T(d.$$.fragment,e),T(b.$$.fragment,e),T(H.$$.fragment,e),T(Q.$$.fragment,e),T(N.$$.fragment,e),T(O.$$.fragment,e),T(ne.$$.fragment,e),T(re.$$.fragment,e),T(ye.$$.fragment,e),T(Je.$$.fragment,e),T(de.$$.fragment,e),T(fe.$$.fragment,e),T(xe.$$.fragment,e),T(Be.$$.fragment,e),T(he.$$.fragment,e),T(He.$$.fragment,e),T(We.$$.fragment,e),ql=!1},d(e){e&&(l(Fe),l(Ee),l(De),l(Ke),l(I),l(Oe),l(j),l(et),l(C),l(tt),l(f),l(lt),l(st),l(v),l(nt),l(x),l(it),l(A),l(ut),l(B),l(at),l(q),l(ot),l(h),l(Mt),l(_),l(pt),l(g),l(rt),l(G),l(ct),l(L),l(Tt),l(yt),l(S),l(mt),l($),l(Jt),l(R),l(Ut),l(wt),l(Z),l(dt),l(z),l(It),l(X),l(jt),l(V),l(Ct),l(Y),l(ft),l(W),l(bt),l(k),l(vt),l(xt),l(E),l(At),l(P),l(Bt),l(F),l(qt),l(D),l(ht),l(K),l(_t),l(gt),l(ee),l(Gt),l(te),l(Lt),l(le),l(Ht),l(se),l(St),l($t),l(ie),l(Rt),l(ue),l(Qt),l(ae),l(Zt),l(oe),l(zt),l(Me),l(Xt),l(pe),l(Vt),l(Yt),l(ce),l(Wt),l(Te),l(kt),l(Nt),l(me),l(Et),l(Pt),l(Ue),l(Ft),l(we),l(Dt),l(Kt),l(Ie),l(Ot),l(je),l(el),l(Ce),l(tl),l(ll),l(be),l(sl),l(ve),l(nl),l(w),l(il),l(Ae),l(ul),l(al),l(qe),l(ol),l(Ml),l(_e),l(pl),l(ge),l(rl),l(Ge),l(cl),l(Tl),l(yl),l(Le),l(ml),l(Jl),l(Se),l(Ul),l($e),l(wl),l(Re),l(dl),l(Qe),l(Il),l(jl),l(Cl),l(Ze),l(fl),l(ze),l(bl),l(Xe),l(vl),l(Ve),l(xl),l(Ye),l(Al),l(Bl),l(Pe)),l(J),y(d,e),y(b,e),y(H,e),y(Q,e),y(N,e),y(O,e),y(ne,e),y(re,e),y(ye,e),y(Je,e),y(de,e),y(fe,e),y(xe),y(Be,e),y(he,e),y(He,e),y(We,e)}}}const tn='{"title":"Qu’est-ce que les Outils ?","local":"quest-ce-que-les-outils-","sections":[{"title":"Qu’est-ce que les outils d’IA ?","local":"quest-ce-que-les-outils-dia-","sections":[],"depth":2},{"title":"Comment fonctionnent les outils ?","local":"comment-fonctionnent-les-outils-","sections":[],"depth":2},{"title":"Comment fournir des outils à un LLM ?","local":"comment-fournir-des-outils-à-un-llm-","sections":[{"title":"Sections d’auto-formatage des outils","local":"sections-dauto-formatage-des-outils","sections":[],"depth":3},{"title":"Implémentation générique d’un outil","local":"implémentation-générique-dun-outil","sections":[],"depth":3},{"title":"Model Context Protocol (MCP) : une interface d’outils unifiée","local":"model-context-protocol-mcp--une-interface-doutils-unifiée","sections":[],"depth":3}],"depth":2}],"depth":1}';function ln(Hl){return Ps(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Mn extends Fs{constructor(J){super(),Ds(this,J,ln,en,Ns,{})}}export{Mn as component};
