import{s as Ae,f as ke,o as Ie,n as Le}from"../chunks/scheduler.37c15a92.js";import{S as Ee,i as He,g as i,s as a,r as M,A as Pe,h as o,f as n,c as l,j as Je,u as y,x as r,k as at,y as Ze,a as s,v as w,d as C,t as v,w as x,m as Be,n as Se}from"../chunks/index.2bf4358c.js";import{T as Ge}from"../chunks/Tip.363c041f.js";import{C as _e}from"../chunks/CodeBlock.4e987730.js";import{H as Qt}from"../chunks/Heading.8ada512a.js";import{E as Fe}from"../chunks/getInferenceSnippets.d4d07d1e.js";function We(it){let p,c,d="We’ll cover how actions are represented (using JSON or code), the importance of the stop and parse approach, and introduce different types of agents.";return{c(){p=Be(`In this section, we explore the concrete steps an AI agent takes to interact with its environment. 
`),c=i("p"),c.textContent=d},l(u){p=Se(u,`In this section, we explore the concrete steps an AI agent takes to interact with its environment. 
`),c=o(u,"P",{"data-svelte-h":!0}),r(c)!=="svelte-1st7yzx"&&(c.textContent=d)},m(u,h){s(u,p,h),s(u,c,h)},p:Le,d(u){u&&(n(p),n(c))}}}function qe(it){let p,c,d,u,h,ot,m,rt,T,Yt="Actions are the concrete steps an <strong>AI agent takes to interact with its environment</strong>.",pt,j,Ot="Whether it’s browsing the web for information or controlling a physical device, each action is a deliberate operation executed by the agent.",ct,b,Dt="For example, an agent assisting with customer service might retrieve customer data, offer support articles, or transfer issues to a human representative.",ut,U,ht,$,Kt="There are multiple types of Agents that take actions differently:",dt,J,te="<thead><tr><th>Type of Agent</th> <th>Description</th></tr></thead> <tbody><tr><td>JSON Agent</td> <td>The Action to take is specified in JSON format.</td></tr> <tr><td>Code Agent</td> <td>The Agent writes a code block that is interpreted externally.</td></tr> <tr><td>Function-calling Agent</td> <td>It is a subcategory of the JSON Agent which has been fine-tuned to generate a new message for each action.</td></tr></tbody>",mt,_,ee="Actions themselves can serve many purposes:",ft,A,ne="<thead><tr><th>Type of Action</th> <th>Description</th></tr></thead> <tbody><tr><td>Information Gathering</td> <td>Performing web searches, querying databases, or retrieving documents.</td></tr> <tr><td>Tool Usage</td> <td>Making API calls, running calculations, and executing code.</td></tr> <tr><td>Environment Interaction</td> <td>Manipulating digital interfaces or controlling physical devices.</td></tr> <tr><td>Communication</td> <td>Engaging with users via chat or collaborating with other agents.</td></tr></tbody>",gt,k,se="The LLM only handles text and uses it to describe the action it wants to take and the parameters to supply to the tool. For an agent to work properly, the LLM must STOP generating new tokens after emitting all the tokens to define a complete Action. This passes control from the LLM back to the agent and ensures the result is parseable - whether the intended format is JSON, code, or function-calling.",Mt,I,yt,L,ae="One key method for implementing actions is the <strong>stop and parse approach</strong>. This method ensures that the agent’s output is structured and predictable:",wt,E,le="<li><strong>Generation in a Structured Format</strong>:</li>",Ct,H,ie="The agent outputs its intended action in a clear, predetermined format (JSON or code).",vt,f,oe="<li><strong>Halting Further Generation</strong>:</li>",xt,P,re="Once the text defining the action has been emitted, <strong>the LLM stops generating additional tokens</strong>. This prevents extra or erroneous output.",Tt,g,pe="<li><strong>Parsing the Output</strong>:</li>",jt,Z,ce="An external parser reads the formatted action, determines which Tool to call, and extracts the required parameters.",bt,B,ue="For example, an agent needing to check the weather might output:",Ut,S,$t,G,he="The framework can then easily parse the name of the function to call and the arguments to apply.",Jt,F,de="This clear, machine-readable format minimizes errors and enables external tools to accurately process the agent’s command.",_t,W,me=`Note: Function-calling agents operate similarly by structuring each action so that a designated function is invoked with the correct arguments.
We’ll dive deeper into those types of Agents in a future Unit.`,At,q,kt,N,fe=`An alternative approach is using <em>Code Agents</em>.
The idea is: <strong>instead of outputting a simple JSON object</strong>, a Code Agent generates an <strong>executable code block—typically in a high-level language like Python</strong>.`,It,R,ge,Lt,V,Me="This approach offers several advantages:",Et,X,ye="<li><strong>Expressiveness:</strong> Code can naturally represent complex logic, including loops, conditionals, and nested functions, providing greater flexibility than JSON.</li> <li><strong>Modularity and Reusability:</strong> Generated code can include functions and modules that are reusable across different actions or tasks.</li> <li><strong>Enhanced Debuggability:</strong> With a well-defined programming syntax, code errors are often easier to detect and correct.</li> <li><strong>Direct Integration:</strong> Code Agents can integrate directly with external libraries and APIs, enabling more complex operations such as data processing or real-time decision making.</li>",Ht,z,we=`You must keep in mind that executing LLM-generated code may pose security risks, from prompt injection to the execution of harmful code.
That’s why it’s recommended to use AI agent frameworks like <code>smolagents</code> that integrate default safeguards.
If you want to know more about the risks and how to mitigate them, <a href="https://huggingface.co/docs/smolagents/tutorials/secure_code_execution" rel="nofollow">please have a look at this dedicated section</a>.`,Pt,Q,Ce="For example, a Code Agent tasked with fetching the weather might generate the following Python snippet:",Zt,Y,Bt,O,ve="In this example, the Code Agent:",St,D,xe="<li>Retrieves weather data <strong>via an API call</strong>,</li> <li>Processes the response,</li> <li>And uses the print() function to output a final answer.</li>",Gt,K,Te="This method <strong>also follows the stop and parse approach</strong> by clearly delimiting the code block and signaling when execution is complete (here, by printing the final_answer).",Ft,Wt,qt,tt,je="We learned that Actions bridge an agent’s internal reasoning and its real-world interactions by executing clear, structured tasks—whether through JSON, code, or function calls.",Nt,et,be="This deliberate execution ensures that each action is precise and ready for external processing via the stop and parse approach. In the next section, we will explore Observations to see how agents capture and integrate feedback from their environment.",Rt,nt,Ue="After this, we will <strong>finally be ready to build our first Agent!</strong>",Vt,st,Xt,lt,zt;return h=new Qt({props:{title:"Actions:  Enabling the Agent to Engage with Its Environment",local:"actions-enabling-the-agent-to-engage-with-its-environment",headingTag:"h1"}}),m=new Ge({props:{$$slots:{default:[We]},$$scope:{ctx:it}}}),U=new Qt({props:{title:"Types of Agent Actions",local:"types-of-agent-actions",headingTag:"h2"}}),I=new Qt({props:{title:"The Stop and Parse Approach",local:"the-stop-and-parse-approach",headingTag:"h2"}}),S=new _e({props:{code:"VGhvdWdodCUzQSUyMEklMjBuZWVkJTIwdG8lMjBjaGVjayUyMHRoZSUyMGN1cnJlbnQlMjB3ZWF0aGVyJTIwZm9yJTIwTmV3JTIwWW9yay4lMEFBY3Rpb24lMjAlM0ElMEElN0IlMEElMjAlMjAlMjJhY3Rpb24lMjIlM0ElMjAlMjJnZXRfd2VhdGhlciUyMiUyQyUwQSUyMCUyMCUyMmFjdGlvbl9pbnB1dCUyMiUzQSUyMCU3QiUyMmxvY2F0aW9uJTIyJTNBJTIwJTIyTmV3JTIwWW9yayUyMiU3RCUwQSU3RA==",highlighted:`Thought<span class="hljs-punctuation">:</span> I need to check the current weather for New York.
Action <span class="hljs-punctuation">:</span>
<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;action&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;get_weather&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;action_input&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;location&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;New York&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),q=new Qt({props:{title:"Code Agents",local:"code-agents",headingTag:"h2"}}),Y=new _e({props:{code:"JTIzJTIwQ29kZSUyMEFnZW50JTIwRXhhbXBsZSUzQSUyMFJldHJpZXZlJTIwV2VhdGhlciUyMEluZm9ybWF0aW9uJTBBZGVmJTIwZ2V0X3dlYXRoZXIoY2l0eSklM0ElMEElMjAlMjAlMjAlMjBpbXBvcnQlMjByZXF1ZXN0cyUwQSUyMCUyMCUyMCUyMGFwaV91cmwlMjAlM0QlMjBmJTIyaHR0cHMlM0ElMkYlMkZhcGkud2VhdGhlci5jb20lMkZ2MSUyRmxvY2F0aW9uJTJGJTdCY2l0eSU3RCUzRmFwaUtleSUzRFlPVVJfQVBJX0tFWSUyMiUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KGFwaV91cmwpJTBBJTIwJTIwJTIwJTIwaWYlMjByZXNwb25zZS5zdGF0dXNfY29kZSUyMCUzRCUzRCUyMDIwMCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRhdGElMjAlM0QlMjByZXNwb25zZS5qc29uKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBkYXRhLmdldCglMjJ3ZWF0aGVyJTIyJTJDJTIwJTIyTm8lMjB3ZWF0aGVyJTIwaW5mb3JtYXRpb24lMjBhdmFpbGFibGUlMjIpJTBBJTIwJTIwJTIwJTIwZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCUyMkVycm9yJTNBJTIwVW5hYmxlJTIwdG8lMjBmZXRjaCUyMHdlYXRoZXIlMjBkYXRhLiUyMiUwQSUwQSUyMyUyMEV4ZWN1dGUlMjB0aGUlMjBmdW5jdGlvbiUyMGFuZCUyMHByZXBhcmUlMjB0aGUlMjBmaW5hbCUyMGFuc3dlciUwQXJlc3VsdCUyMCUzRCUyMGdldF93ZWF0aGVyKCUyMk5ldyUyMFlvcmslMjIpJTBBZmluYWxfYW5zd2VyJTIwJTNEJTIwZiUyMlRoZSUyMGN1cnJlbnQlMjB3ZWF0aGVyJTIwaW4lMjBOZXclMjBZb3JrJTIwaXMlM0ElMjAlN0JyZXN1bHQlN0QlMjIlMEFwcmludChmaW5hbF9hbnN3ZXIp",highlighted:`<span class="hljs-comment"># Code Agent Example: Retrieve Weather Information</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather</span>(<span class="hljs-params">city</span>):
    <span class="hljs-keyword">import</span> requests
    api_url = <span class="hljs-string">f&quot;https://api.weather.com/v1/location/<span class="hljs-subst">{city}</span>?apiKey=YOUR_API_KEY&quot;</span>
    response = requests.get(api_url)
    <span class="hljs-keyword">if</span> response.status_code == <span class="hljs-number">200</span>:
        data = response.json()
        <span class="hljs-keyword">return</span> data.get(<span class="hljs-string">&quot;weather&quot;</span>, <span class="hljs-string">&quot;No weather information available&quot;</span>)
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Error: Unable to fetch weather data.&quot;</span>

<span class="hljs-comment"># Execute the function and prepare the final answer</span>
result = get_weather(<span class="hljs-string">&quot;New York&quot;</span>)
final_answer = <span class="hljs-string">f&quot;The current weather in New York is: <span class="hljs-subst">{result}</span>&quot;</span>
<span class="hljs-built_in">print</span>(final_answer)`,wrap:!1}}),st=new Fe({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit1/actions.mdx"}}),{c(){p=i("meta"),c=a(),d=i("p"),u=a(),M(h.$$.fragment),ot=a(),M(m.$$.fragment),rt=a(),T=i("p"),T.innerHTML=Yt,pt=a(),j=i("p"),j.textContent=Ot,ct=a(),b=i("p"),b.textContent=Dt,ut=a(),M(U.$$.fragment),ht=a(),$=i("p"),$.textContent=Kt,dt=a(),J=i("table"),J.innerHTML=te,mt=a(),_=i("p"),_.textContent=ee,ft=a(),A=i("table"),A.innerHTML=ne,gt=a(),k=i("p"),k.textContent=se,Mt=a(),M(I.$$.fragment),yt=a(),L=i("p"),L.innerHTML=ae,wt=a(),E=i("ol"),E.innerHTML=le,Ct=a(),H=i("p"),H.textContent=ie,vt=a(),f=i("ol"),f.innerHTML=oe,xt=a(),P=i("p"),P.innerHTML=re,Tt=a(),g=i("ol"),g.innerHTML=pe,jt=a(),Z=i("p"),Z.textContent=ce,bt=a(),B=i("p"),B.textContent=ue,Ut=a(),M(S.$$.fragment),$t=a(),G=i("p"),G.textContent=he,Jt=a(),F=i("p"),F.textContent=de,_t=a(),W=i("p"),W.textContent=me,At=a(),M(q.$$.fragment),kt=a(),N=i("p"),N.innerHTML=fe,It=a(),R=i("img"),Lt=a(),V=i("p"),V.textContent=Me,Et=a(),X=i("ul"),X.innerHTML=ye,Ht=a(),z=i("p"),z.innerHTML=we,Pt=a(),Q=i("p"),Q.textContent=Ce,Zt=a(),M(Y.$$.fragment),Bt=a(),O=i("p"),O.textContent=ve,St=a(),D=i("ul"),D.innerHTML=xe,Gt=a(),K=i("p"),K.innerHTML=Te,Ft=a(),Wt=i("hr"),qt=a(),tt=i("p"),tt.textContent=je,Nt=a(),et=i("p"),et.textContent=be,Rt=a(),nt=i("p"),nt.innerHTML=Ue,Vt=a(),M(st.$$.fragment),Xt=a(),lt=i("p"),this.h()},l(t){const e=Pe("svelte-u9bgzb",document.head);p=o(e,"META",{name:!0,content:!0}),e.forEach(n),c=l(t),d=o(t,"P",{}),Je(d).forEach(n),u=l(t),y(h.$$.fragment,t),ot=l(t),y(m.$$.fragment,t),rt=l(t),T=o(t,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1d9hktj"&&(T.innerHTML=Yt),pt=l(t),j=o(t,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1tl5mip"&&(j.textContent=Ot),ct=l(t),b=o(t,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1ubetp8"&&(b.textContent=Dt),ut=l(t),y(U.$$.fragment,t),ht=l(t),$=o(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-1wlcwgd"&&($.textContent=Kt),dt=l(t),J=o(t,"TABLE",{"data-svelte-h":!0}),r(J)!=="svelte-3ls1cj"&&(J.innerHTML=te),mt=l(t),_=o(t,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1xp7kgk"&&(_.textContent=ee),ft=l(t),A=o(t,"TABLE",{"data-svelte-h":!0}),r(A)!=="svelte-4604oy"&&(A.innerHTML=ne),gt=l(t),k=o(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-172oujm"&&(k.textContent=se),Mt=l(t),y(I.$$.fragment,t),yt=l(t),L=o(t,"P",{"data-svelte-h":!0}),r(L)!=="svelte-a9as0m"&&(L.innerHTML=ae),wt=l(t),E=o(t,"OL",{"data-svelte-h":!0}),r(E)!=="svelte-1nmidra"&&(E.innerHTML=le),Ct=l(t),H=o(t,"P",{"data-svelte-h":!0}),r(H)!=="svelte-l3tk2o"&&(H.textContent=ie),vt=l(t),f=o(t,"OL",{start:!0,"data-svelte-h":!0}),r(f)!=="svelte-j1mwkc"&&(f.innerHTML=oe),xt=l(t),P=o(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1hxxesc"&&(P.innerHTML=re),Tt=l(t),g=o(t,"OL",{start:!0,"data-svelte-h":!0}),r(g)!=="svelte-w7r926"&&(g.innerHTML=pe),jt=l(t),Z=o(t,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-191aaii"&&(Z.textContent=ce),bt=l(t),B=o(t,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1exbnez"&&(B.textContent=ue),Ut=l(t),y(S.$$.fragment,t),$t=l(t),G=o(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1j4o5aq"&&(G.textContent=he),Jt=l(t),F=o(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1so9m39"&&(F.textContent=de),_t=l(t),W=o(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1k8g2zy"&&(W.textContent=me),At=l(t),y(q.$$.fragment,t),kt=l(t),N=o(t,"P",{"data-svelte-h":!0}),r(N)!=="svelte-19f0lzf"&&(N.innerHTML=fe),It=l(t),R=o(t,"IMG",{src:!0,alt:!0}),Lt=l(t),V=o(t,"P",{"data-svelte-h":!0}),r(V)!=="svelte-rsd8hl"&&(V.textContent=Me),Et=l(t),X=o(t,"UL",{"data-svelte-h":!0}),r(X)!=="svelte-1t80mrq"&&(X.innerHTML=ye),Ht=l(t),z=o(t,"P",{"data-svelte-h":!0}),r(z)!=="svelte-6v19zm"&&(z.innerHTML=we),Pt=l(t),Q=o(t,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-qjq0mw"&&(Q.textContent=Ce),Zt=l(t),y(Y.$$.fragment,t),Bt=l(t),O=o(t,"P",{"data-svelte-h":!0}),r(O)!=="svelte-pfpi4"&&(O.textContent=ve),St=l(t),D=o(t,"UL",{"data-svelte-h":!0}),r(D)!=="svelte-b7upo8"&&(D.innerHTML=xe),Gt=l(t),K=o(t,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1v0y8k3"&&(K.innerHTML=Te),Ft=l(t),Wt=o(t,"HR",{}),qt=l(t),tt=o(t,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-b7m3f6"&&(tt.textContent=je),Nt=l(t),et=o(t,"P",{"data-svelte-h":!0}),r(et)!=="svelte-h8bvqv"&&(et.textContent=be),Rt=l(t),nt=o(t,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-14ocnmz"&&(nt.innerHTML=Ue),Vt=l(t),y(st.$$.fragment,t),Xt=l(t),lt=o(t,"P",{}),Je(lt).forEach(n),this.h()},h(){at(p,"name","hf:doc:metadata"),at(p,"content",Ne),at(f,"start","2"),at(g,"start","3"),ke(R.src,ge="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/code-vs-json-actions.png")||at(R,"src",ge),at(R,"alt","Code Agents")},m(t,e){Ze(document.head,p),s(t,c,e),s(t,d,e),s(t,u,e),w(h,t,e),s(t,ot,e),w(m,t,e),s(t,rt,e),s(t,T,e),s(t,pt,e),s(t,j,e),s(t,ct,e),s(t,b,e),s(t,ut,e),w(U,t,e),s(t,ht,e),s(t,$,e),s(t,dt,e),s(t,J,e),s(t,mt,e),s(t,_,e),s(t,ft,e),s(t,A,e),s(t,gt,e),s(t,k,e),s(t,Mt,e),w(I,t,e),s(t,yt,e),s(t,L,e),s(t,wt,e),s(t,E,e),s(t,Ct,e),s(t,H,e),s(t,vt,e),s(t,f,e),s(t,xt,e),s(t,P,e),s(t,Tt,e),s(t,g,e),s(t,jt,e),s(t,Z,e),s(t,bt,e),s(t,B,e),s(t,Ut,e),w(S,t,e),s(t,$t,e),s(t,G,e),s(t,Jt,e),s(t,F,e),s(t,_t,e),s(t,W,e),s(t,At,e),w(q,t,e),s(t,kt,e),s(t,N,e),s(t,It,e),s(t,R,e),s(t,Lt,e),s(t,V,e),s(t,Et,e),s(t,X,e),s(t,Ht,e),s(t,z,e),s(t,Pt,e),s(t,Q,e),s(t,Zt,e),w(Y,t,e),s(t,Bt,e),s(t,O,e),s(t,St,e),s(t,D,e),s(t,Gt,e),s(t,K,e),s(t,Ft,e),s(t,Wt,e),s(t,qt,e),s(t,tt,e),s(t,Nt,e),s(t,et,e),s(t,Rt,e),s(t,nt,e),s(t,Vt,e),w(st,t,e),s(t,Xt,e),s(t,lt,e),zt=!0},p(t,[e]){const $e={};e&2&&($e.$$scope={dirty:e,ctx:t}),m.$set($e)},i(t){zt||(C(h.$$.fragment,t),C(m.$$.fragment,t),C(U.$$.fragment,t),C(I.$$.fragment,t),C(S.$$.fragment,t),C(q.$$.fragment,t),C(Y.$$.fragment,t),C(st.$$.fragment,t),zt=!0)},o(t){v(h.$$.fragment,t),v(m.$$.fragment,t),v(U.$$.fragment,t),v(I.$$.fragment,t),v(S.$$.fragment,t),v(q.$$.fragment,t),v(Y.$$.fragment,t),v(st.$$.fragment,t),zt=!1},d(t){t&&(n(c),n(d),n(u),n(ot),n(rt),n(T),n(pt),n(j),n(ct),n(b),n(ut),n(ht),n($),n(dt),n(J),n(mt),n(_),n(ft),n(A),n(gt),n(k),n(Mt),n(yt),n(L),n(wt),n(E),n(Ct),n(H),n(vt),n(f),n(xt),n(P),n(Tt),n(g),n(jt),n(Z),n(bt),n(B),n(Ut),n($t),n(G),n(Jt),n(F),n(_t),n(W),n(At),n(kt),n(N),n(It),n(R),n(Lt),n(V),n(Et),n(X),n(Ht),n(z),n(Pt),n(Q),n(Zt),n(Bt),n(O),n(St),n(D),n(Gt),n(K),n(Ft),n(Wt),n(qt),n(tt),n(Nt),n(et),n(Rt),n(nt),n(Vt),n(Xt),n(lt)),n(p),x(h,t),x(m,t),x(U,t),x(I,t),x(S,t),x(q,t),x(Y,t),x(st,t)}}}const Ne='{"title":"Actions:  Enabling the Agent to Engage with Its Environment","local":"actions-enabling-the-agent-to-engage-with-its-environment","sections":[{"title":"Types of Agent Actions","local":"types-of-agent-actions","sections":[],"depth":2},{"title":"The Stop and Parse Approach","local":"the-stop-and-parse-approach","sections":[],"depth":2},{"title":"Code Agents","local":"code-agents","sections":[],"depth":2}],"depth":1}';function Re(it){return Ie(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class De extends Ee{constructor(p){super(),He(this,p,Re,qe,Ae,{})}}export{De as component};
