import{s as nl,n as al,o as ol}from"../chunks/scheduler.65852ee5.js";import{S as il,i as rl,g as o,s as n,r as c,A as cl,h as i,f as l,c as a,j as ll,u as p,x as r,k as sl,y as pl,a as s,v as d,d as u,t as m,w as h}from"../chunks/index.aa74147d.js";import{D as dl,C as y}from"../chunks/DocNotebookDropdown.479f4286.js";import{H as we,E as ul}from"../chunks/EditOnGithub.4eda6a96.js";function ml(Ut){let M,Te,be,fe,w,je,b,Ue,J,gt='<em>Authored by: <a href="https://github.com/MKhalusova" rel="nofollow">Maria Khalusova</a></em>',ge,T,It='If you’re new to RAG, please explore the basics of RAG first in <a href="https://huggingface.co/learn/cookbook/rag_zephyr_langchain" rel="nofollow">this other notebook</a>, and then come back here to learn about building RAG with custom data.',Ie,f,Zt="Whether you’re building your own RAG-based personal assistant, a pet project, or an enterprise RAG system, you will quickly discover that a lot of important knowledge is stored in various formats like PDFs, emails, Markdown files, PowerPoint presentations, HTML pages, Word documents, and so on.",Ze,j,Bt=`How do you preprocess all of this data in a way that you can use it for RAG?
In this quick tutorial, you’ll learn how to build a RAG system that will incorporate data from multiple data types. You’ll use <a href="https://github.com/Unstructured-IO/unstructured" rel="nofollow">Unstructured</a> for data preprocessing, open-source models from Hugging Face Hub for embeddings and text generation, ChromaDB as a vector store, and LangChain for bringing everything together.`,Be,U,Gt="Let’s go! We’ll begin by installing the required dependencies:",Ge,g,We,I,Wt="Next, let’s get a mix of documents. Suppose, I want to build a RAG system that’ll help me manage pests in my garden. For this purpose, I’ll use diverse documents that cover the topic of IPM (integrated pest management):",ve,Z,vt="<li>PDF: <code>https://www.gov.nl.ca/ecc/files/env-protection-pesticides-business-manuals-applic-chapter7.pdf</code></li> <li>Powerpoint: <code>https://ipm.ifas.ufl.edu/pdfs/Citrus_IPM_090913.pptx</code></li> <li>EPUB: <code>https://www.gutenberg.org/ebooks/45957</code></li> <li>HTML: <code>https://blog.fifthroom.com/what-to-do-about-harmful-garden-and-plant-insects-and-pests.html</code></li>",Re,B,Rt="Feel free to use your own documents for your topic of choice from the list of document types supported by Unstructured: <code>.eml</code>, <code>.html</code>, <code>.md</code>, <code>.msg</code>, <code>.rst</code>, <code>.rtf</code>, <code>.txt</code>, <code>.xml</code>, <code>.png</code>, <code>.jpg</code>, <code>.jpeg</code>, <code>.tiff</code>, <code>.bmp</code>, <code>.heic</code>, <code>.csv</code>, <code>.doc</code>, <code>.docx</code>, <code>.epub</code>, <code>.odt</code>, <code>.pdf</code>, <code>.ppt</code>, <code>.pptx</code>, <code>.tsv</code>, <code>.xlsx</code>.",ke,G,Ce,W,Xe,v,kt=`You can use the Unstructured library to preprocess documents one by one, and write your own script to walk through a directory, but it’s easier to use a Local source connector to ingest all documents in a given directory. Unstructured can ingest documents from local directories, S3 buckets, blob storage, SFTP, and many other places your documents might be stored in. The ingestion from those sources will be very similar differing mostly in authentication options.
Here you’ll use Local source connector, but feel free to explore other options in the <a href="https://docs.unstructured.io/open-source/ingest/source-connectors/overview" rel="nofollow">Unstructured documentation</a>.`,xe,R,Ct='Optionally, you can also choose a <a href="https://docs.unstructured.io/open-source/ingest/destination-connectors/overview" rel="nofollow">destination</a> for the processed documents - this could be MongoDB, Pinecone, Weaviate, etc. In this notebook, we’ll keep everything local.',Ve,k,$e,C,_e,X,Xt=`INFO: NumExpr defaulting to 2 threads.
`,Ye,x,xt="Let’s take a closer look at the configs that we have here.",He,V,Vt="<code>ProcessorConfig</code> controls various aspects of the processing pipeline, including output locations, number of workers, error handling behavior, logging verbosity and more. The only mandatory parameter here is the <code>output_dir</code> - the local directory where you want to store the outputs.",Ne,$,$t="<code>ReadConfig</code> can be used to customize the data reading process for different scenarios, such as re-downloading data, preserving downloaded files, or limiting the number of documents processed. In most cases the default <code>ReadConfig</code> will work.",Qe,_,_t=`In the <code>PartitionConfig</code> you can choose whether to partition the documents locally or via API. This example uses API, and for this reason requires Unstructured API key. You can get yours <a href="https://unstructured.io/api-key-free" rel="nofollow">here</a>.  The free Unstructured API is capped at 1000 pages, and offers better OCR models for image-based documents than a local installation of Unstructured.
If you remove these two parameters, the documents will be processed locally, but you may need to install additional dependencies if the documents require OCR and/or document understanding models. Namely, you may need to install poppler and tesseract in this case, which you can get with brew:`,Fe,Y,ze,H,Yt='If you’re on Windows, you can find alternative installation instructions in the <a href="https://docs.unstructured.io/open-source/installation/full-installation" rel="nofollow">Unstructured docs</a>.',Ee,N,Ht="Finally, in the <code>SimpleLocalConfig</code> you need to specify where your original documents reside, and whether you want to walk through the directory recursively.",Ae,Q,Nt=`Once the documents are processed you’ll find 4 json files in the <code>local-ingest-output</code> directory, one per document that was processed.
Unstructured partitions all types of documents in a uniform manner, and returns json with document elements.`,Se,F,Qt='<a href="https://docs.unstructured.io/api-reference/api-services/document-elements" rel="nofollow">Document elements</a> have a type, e.g. <code>NarrativeText</code>, <code>Title</code>, or <code>Table</code>, they contain the extracted text, and metadata that Unstructured was able to obtain. Some metadata is common for all elements, such as filename of the document the element is from. Other metadata depends on file type or element type. For example, a <code>Table</code> element will contain table’s representation as html in the metadata, and metadata for emails will contain information about senders and recipients.',Le,z,Ft="Let’s import element objects from these json files.",qe,E,Pe,A,zt="Now that that you have extracted the elements from the documents, you can chunk them to fit the context window of the embeddings model.",De,S,Ke,L,Et="If you are familiar with chunking methods that split long text documents into smaller chunks, you’ll notice that Unstructured’s chunking methods slightly differ, since the partitioning step already divides an entire document into its structural elements: titles, list items, tables, text, etc. By partitioning documents this way, you can avoid a situation where unrelated pieces of text end up in the same element, and then same chunk.",Oe,q,At="Now, when you chunk the document elements with Unstructured, individual elements are already small so they will only be split if they exceed the desired maximum chunk size. Otherwise, they will remain as is. You can also optionally choose to combine consecutive text elements such as list items, for instance, that will together fit within chunk size limit.",et,P,tt,D,St="The chunks are ready for RAG. To use them with LangChain, you can easily convert Unstructured elements to LangChain documents.",lt,K,st,O,nt,ee,Lt='This example uses ChromaDB as a vector store and <a href="https://huggingface.co/BAAI/bge-base-en-v1.5" rel="nofollow"><code>BAAI/bge-base-en-v1.5</code></a> embeddings model, feel free to use any other vector store.',at,te,ot,le,qt="If you plan to use a gated model from the Hugging Face Hub, be it an embeddings or text generation model, you’ll need to authenticate yourself with your Hugging Face token, which you can get in your Hugging Face profile’s settings.",it,se,rt,ne,ct,ae,Pt=`Let’s bring everything together and build RAG with LangChain.
In this example we’ll be using <a href="https://huggingface.co/meta-llama/Meta-Llama-3-8B-Instruct" rel="nofollow"><code>Llama-3-8B-Instruct</code></a> from Meta. To make sure it can run smoothly in the free T4 runtime from Google Colab, you’ll need to quantize it.`,pt,oe,dt,ie,ut,re,mt,ce,Dt="Now that you have your RAG chain, let’s ask it about aphids. Are they a pest in my garden?",ht,pe,yt,de,Kt="Output:",Mt,ue,wt,me,Ot="This looks like a promising start! Now that you know the basics of preprocessing complex unstructured data for RAG, you can continue improving upon this example. Here are some ideas:",bt,he,el='<li>You can connect to a different source to ingest the documents from, for example, an S3 bucket.</li> <li>You can add <code>return_source_documents=True</code> in the <code>qa_chain</code> arguments to make the chain return the documents that were passed to the prompt as context. This can be useful to understand what sources were used to generate the answer.</li> <li>If you want to leverage the elements metadata at the retrieval stage, consider using Hugging Face agents and creating a custom retriever tool as described in <a href="https://huggingface.co/learn/cookbook/agents#2--rag-with-iterative-query-refinement--source-selection" rel="nofollow">this other notebook</a>.</li> <li>There are many things you could do to improve search results. For instance, you could use Hybrid search instead of a single similarity-search retriever. Hybrid search combines multiple search algorithms to improve the accuracy and relevance of search results. Typically it’s a combination of keyword-based search algorithms with vector search methods.</li>',Jt,ye,tl="Have fun building RAG applications with Unstructured data!",Tt,Me,ft,Je,jt;return w=new dl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/indentation_update/notebooks/en/rag_with_unstructured_data.ipynb"}]}}),b=new we({props:{title:"Building RAG with Custom Unstructured Data",local:"building-rag-with-custom-unstructured-data",headingTag:"h1"}}),g=new y({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMHRvcmNoJTIwdHJhbnNmb3JtZXJzJTIwYWNjZWxlcmF0ZSUyMGJpdHNhbmRieXRlcyUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycyUyMHVuc3RydWN0dXJlZCU1QmFsbC1kb2NzJTVEJTIwbGFuZ2NoYWluJTIwY2hyb21hZGIlMjBsYW5nY2hhaW5fY29tbXVuaXR5",highlighted:'!pip install -q torch transformers accelerate bitsandbytes sentence-transformers unstructured[<span class="hljs-built_in">all</span>-docs] langchain chromadb langchain_community',wrap:!1}}),G=new y({props:{code:"IW1rZGlyJTIwLXAlMjAlMjIuJTJGZG9jdW1lbnRzJTIyJTBBIXdnZXQlMjBodHRwcyUzQSUyRiUyRnd3dy5nb3YubmwuY2ElMkZlY2MlMkZmaWxlcyUyRmVudi1wcm90ZWN0aW9uLXBlc3RpY2lkZXMtYnVzaW5lc3MtbWFudWFscy1hcHBsaWMtY2hhcHRlcjcucGRmJTIwLU8lMjAlMjIuJTJGZG9jdW1lbnRzJTJGZW52LXByb3RlY3Rpb24tcGVzdGljaWRlcy1idXNpbmVzcy1tYW51YWxzLWFwcGxpYy1jaGFwdGVyNy5wZGYlMjIlMEEhd2dldCUyMGh0dHBzJTNBJTJGJTJGaXBtLmlmYXMudWZsLmVkdSUyRnBkZnMlMkZDaXRydXNfSVBNXzA5MDkxMy5wcHR4JTIwLU8lMjAlMjIuJTJGZG9jdW1lbnRzJTJGQ2l0cnVzX0lQTV8wOTA5MTMucHB0eCUyMiUwQSF3Z2V0JTIwaHR0cHMlM0ElMkYlMkZ3d3cuZ3V0ZW5iZXJnLm9yZyUyRmVib29rcyUyRjQ1OTU3LmVwdWIzLmltYWdlcyUyMC1PJTIwJTIyLiUyRmRvY3VtZW50cyUyRjQ1OTU3LmVwdWIlMjIlMEEhd2dldCUyMGh0dHBzJTNBJTJGJTJGYmxvZy5maWZ0aHJvb20uY29tJTJGd2hhdC10by1kby1hYm91dC1oYXJtZnVsLWdhcmRlbi1hbmQtcGxhbnQtaW5zZWN0cy1hbmQtcGVzdHMuaHRtbCUyMC1PJTIwJTIyLiUyRmRvY3VtZW50cyUyRndoYXQtdG8tZG8tYWJvdXQtaGFybWZ1bC1nYXJkZW4tYW5kLXBsYW50LWluc2VjdHMtYW5kLXBlc3RzLmh0bWwlMjI=",highlighted:`!mkdir -p <span class="hljs-string">&quot;./documents&quot;</span>
!wget https://www.gov.nl.ca/ecc/files/env-protection-pesticides-business-manuals-applic-chapter7.pdf -O <span class="hljs-string">&quot;./documents/env-protection-pesticides-business-manuals-applic-chapter7.pdf&quot;</span>
!wget https://ipm.ifas.ufl.edu/pdfs/Citrus_IPM_090913.pptx -O <span class="hljs-string">&quot;./documents/Citrus_IPM_090913.pptx&quot;</span>
!wget https://www.gutenberg.org/ebooks/<span class="hljs-number">45957.</span>epub3.images -O <span class="hljs-string">&quot;./documents/45957.epub&quot;</span>
!wget https://blog.fifthroom.com/what-to-do-about-harmful-garden-<span class="hljs-keyword">and</span>-plant-insects-<span class="hljs-keyword">and</span>-pests.html -O <span class="hljs-string">&quot;./documents/what-to-do-about-harmful-garden-and-plant-insects-and-pests.html&quot;</span>`,wrap:!1}}),W=new we({props:{title:"Unstructured data preprocessing",local:"unstructured-data-preprocessing",headingTag:"h2"}}),k=new y({props:{code:"JTIzJTIwT3B0aW9uYWwlMjBjZWxsJTIwdG8lMjByZWR1Y2UlMjB0aGUlMjBhbW91bnQlMjBvZiUyMGxvZ3MlMEElMEFpbXBvcnQlMjBsb2dnaW5nJTBBJTBBbG9nZ2VyJTIwJTNEJTIwbG9nZ2luZy5nZXRMb2dnZXIoJTIydW5zdHJ1Y3R1cmVkLmluZ2VzdCUyMiklMEFsb2dnZXIucm9vdC5yZW1vdmVIYW5kbGVyKGxvZ2dlci5yb290LmhhbmRsZXJzJTVCMCU1RCk=",highlighted:`<span class="hljs-comment"># Optional cell to reduce the amount of logs</span>

<span class="hljs-keyword">import</span> logging

logger = logging.getLogger(<span class="hljs-string">&quot;unstructured.ingest&quot;</span>)
logger.root.removeHandler(logger.root.handlers[<span class="hljs-number">0</span>])`,wrap:!1}}),C=new y({props:{code:"aW1wb3J0JTIwb3MlMEElMEFmcm9tJTIwdW5zdHJ1Y3R1cmVkLmluZ2VzdC5jb25uZWN0b3IubG9jYWwlMjBpbXBvcnQlMjBTaW1wbGVMb2NhbENvbmZpZyUwQWZyb20lMjB1bnN0cnVjdHVyZWQuaW5nZXN0LmludGVyZmFjZXMlMjBpbXBvcnQlMjBQYXJ0aXRpb25Db25maWclMkMlMjBQcm9jZXNzb3JDb25maWclMkMlMjBSZWFkQ29uZmlnJTBBZnJvbSUyMHVuc3RydWN0dXJlZC5pbmdlc3QucnVubmVyJTIwaW1wb3J0JTIwTG9jYWxSdW5uZXIlMEElMEFvdXRwdXRfcGF0aCUyMCUzRCUyMCUyMi4lMkZsb2NhbC1pbmdlc3Qtb3V0cHV0JTIyJTBBJTBBcnVubmVyJTIwJTNEJTIwTG9jYWxSdW5uZXIoJTBBJTIwJTIwJTIwJTIwcHJvY2Vzc29yX2NvbmZpZyUzRFByb2Nlc3NvckNvbmZpZyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBsb2dzJTIwdmVyYm9zaXR5JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdmVyYm9zZSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjB0aGUlMjBsb2NhbCUyMGRpcmVjdG9yeSUyMHRvJTIwc3RvcmUlMjBvdXRwdXRzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRG91dHB1dF9wYXRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX3Byb2Nlc3NlcyUzRDIlMkMlMEElMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwcmVhZF9jb25maWclM0RSZWFkQ29uZmlnKCklMkMlMEElMjAlMjAlMjAlMjBwYXJ0aXRpb25fY29uZmlnJTNEUGFydGl0aW9uQ29uZmlnKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhcnRpdGlvbl9ieV9hcGklM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMllPVVJfVU5TVFJVQ1RVUkVEX0FQSV9LRVklMjIlMkMlMEElMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwY29ubmVjdG9yX2NvbmZpZyUzRFNpbXBsZUxvY2FsQ29uZmlnKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0X3BhdGglM0QlMjIuJTJGZG9jdW1lbnRzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwd2hldGhlciUyMHRvJTIwZ2V0JTIwdGhlJTIwZG9jdW1lbnRzJTIwcmVjdXJzaXZlbHklMjBmcm9tJTIwZ2l2ZW4lMjBkaXJlY3RvcnklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZWN1cnNpdmUlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMCklMkMlMEEpJTBBcnVubmVyLnJ1bigp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> os

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> unstructured.ingest.connector.local <span class="hljs-keyword">import</span> SimpleLocalConfig
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> unstructured.ingest.interfaces <span class="hljs-keyword">import</span> PartitionConfig, ProcessorConfig, ReadConfig
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> unstructured.ingest.runner <span class="hljs-keyword">import</span> LocalRunner

<span class="hljs-meta">&gt;&gt;&gt; </span>output_path = <span class="hljs-string">&quot;./local-ingest-output&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>runner = LocalRunner(
<span class="hljs-meta">... </span>    processor_config=ProcessorConfig(
<span class="hljs-meta">... </span>        <span class="hljs-comment"># logs verbosity</span>
<span class="hljs-meta">... </span>        verbose=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>        <span class="hljs-comment"># the local directory to store outputs</span>
<span class="hljs-meta">... </span>        output_dir=output_path,
<span class="hljs-meta">... </span>        num_processes=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    ),
<span class="hljs-meta">... </span>    read_config=ReadConfig(),
<span class="hljs-meta">... </span>    partition_config=PartitionConfig(
<span class="hljs-meta">... </span>        partition_by_api=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>        api_key=<span class="hljs-string">&quot;YOUR_UNSTRUCTURED_API_KEY&quot;</span>,
<span class="hljs-meta">... </span>    ),
<span class="hljs-meta">... </span>    connector_config=SimpleLocalConfig(
<span class="hljs-meta">... </span>        input_path=<span class="hljs-string">&quot;./documents&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-comment"># whether to get the documents recursively from given directory</span>
<span class="hljs-meta">... </span>        recursive=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    ),
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>runner.run()`,wrap:!1}}),Y=new y({props:{code:"IWJyZXclMjBpbnN0YWxsJTIwcG9wcGxlciUwQSFicmV3JTIwaW5zdGFsbCUyMHRlc3NlcmFjdA==",highlighted:`!<span class="hljs-keyword">brew </span><span class="hljs-keyword">install </span>poppler
!<span class="hljs-keyword">brew </span><span class="hljs-keyword">install </span>tesseract`,wrap:!1}}),E=new y({props:{code:"ZnJvbSUyMHVuc3RydWN0dXJlZC5zdGFnaW5nLmJhc2UlMjBpbXBvcnQlMjBlbGVtZW50c19mcm9tX2pzb24lMEElMEFlbGVtZW50cyUyMCUzRCUyMCU1QiU1RCUwQSUwQWZvciUyMGZpbGVuYW1lJTIwaW4lMjBvcy5saXN0ZGlyKG91dHB1dF9wYXRoKSUzQSUwQSUyMCUyMCUyMCUyMGZpbGVwYXRoJTIwJTNEJTIwb3MucGF0aC5qb2luKG91dHB1dF9wYXRoJTJDJTIwZmlsZW5hbWUpJTBBJTIwJTIwJTIwJTIwZWxlbWVudHMuZXh0ZW5kKGVsZW1lbnRzX2Zyb21fanNvbihmaWxlcGF0aCkp",highlighted:`<span class="hljs-keyword">from</span> unstructured.staging.base <span class="hljs-keyword">import</span> elements_from_json

elements = []

<span class="hljs-keyword">for</span> filename <span class="hljs-keyword">in</span> os.listdir(output_path):
    filepath = os.path.join(output_path, filename)
    elements.extend(elements_from_json(filepath))`,wrap:!1}}),S=new we({props:{title:"Chunking",local:"chunking",headingTag:"h2"}}),P=new y({props:{code:"ZnJvbSUyMHVuc3RydWN0dXJlZC5jaHVua2luZy50aXRsZSUyMGltcG9ydCUyMGNodW5rX2J5X3RpdGxlJTBBJTBBY2h1bmtlZF9lbGVtZW50cyUyMCUzRCUyMGNodW5rX2J5X3RpdGxlKCUwQSUyMCUyMCUyMCUyMGVsZW1lbnRzJTJDJTBBJTIwJTIwJTIwJTIwJTIzJTIwbWF4aW11bSUyMGZvciUyMGNodW5rJTIwc2l6ZSUwQSUyMCUyMCUyMCUyMG1heF9jaGFyYWN0ZXJzJTNENTEyJTJDJTBBJTIwJTIwJTIwJTIwJTIzJTIwWW91JTIwY2FuJTIwY2hvb3NlJTIwdG8lMjBjb21iaW5lJTIwY29uc2VjdXRpdmUlMjBlbGVtZW50cyUyMHRoYXQlMjBhcmUlMjB0b28lMjBzbWFsbCUwQSUyMCUyMCUyMCUyMCUyMyUyMGUuZy4lMjBpbmRpdmlkdWFsJTIwbGlzdCUyMGl0ZW1zJTBBJTIwJTIwJTIwJTIwY29tYmluZV90ZXh0X3VuZGVyX25fY2hhcnMlM0QyMDAlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> unstructured.chunking.title <span class="hljs-keyword">import</span> chunk_by_title

chunked_elements = chunk_by_title(
    elements,
    <span class="hljs-comment"># maximum for chunk size</span>
    max_characters=<span class="hljs-number">512</span>,
    <span class="hljs-comment"># You can choose to combine consecutive elements that are too small</span>
    <span class="hljs-comment"># e.g. individual list items</span>
    combine_text_under_n_chars=<span class="hljs-number">200</span>,
)`,wrap:!1}}),K=new y({props:{code:"ZnJvbSUyMGxhbmdjaGFpbl9jb3JlLmRvY3VtZW50cyUyMGltcG9ydCUyMERvY3VtZW50JTBBJTBBZG9jdW1lbnRzJTIwJTNEJTIwJTVCJTVEJTBBZm9yJTIwY2h1bmtlZF9lbGVtZW50JTIwaW4lMjBjaHVua2VkX2VsZW1lbnRzJTNBJTBBJTIwJTIwJTIwJTIwbWV0YWRhdGElMjAlM0QlMjBjaHVua2VkX2VsZW1lbnQubWV0YWRhdGEudG9fZGljdCgpJTBBJTIwJTIwJTIwJTIwbWV0YWRhdGElNUIlMjJzb3VyY2UlMjIlNUQlMjAlM0QlMjBtZXRhZGF0YSU1QiUyMmZpbGVuYW1lJTIyJTVEJTBBJTIwJTIwJTIwJTIwZGVsJTIwbWV0YWRhdGElNUIlMjJsYW5ndWFnZXMlMjIlNUQlMEElMjAlMjAlMjAlMjBkb2N1bWVudHMuYXBwZW5kKERvY3VtZW50KHBhZ2VfY29udGVudCUzRGNodW5rZWRfZWxlbWVudC50ZXh0JTJDJTIwbWV0YWRhdGElM0RtZXRhZGF0YSkp",highlighted:`<span class="hljs-keyword">from</span> langchain_core.documents <span class="hljs-keyword">import</span> Document

documents = []
<span class="hljs-keyword">for</span> chunked_element <span class="hljs-keyword">in</span> chunked_elements:
    metadata = chunked_element.metadata.to_dict()
    metadata[<span class="hljs-string">&quot;source&quot;</span>] = metadata[<span class="hljs-string">&quot;filename&quot;</span>]
    <span class="hljs-keyword">del</span> metadata[<span class="hljs-string">&quot;languages&quot;</span>]
    documents.append(Document(page_content=chunked_element.text, metadata=metadata))`,wrap:!1}}),O=new we({props:{title:"Setting up the retriever",local:"setting-up-the-retriever",headingTag:"h2"}}),te=new y({props:{code:"ZnJvbSUyMGxhbmdjaGFpbl9jb21tdW5pdHkudmVjdG9yc3RvcmVzJTIwaW1wb3J0JTIwQ2hyb21hJTBBZnJvbSUyMGxhbmdjaGFpbi5lbWJlZGRpbmdzJTIwaW1wb3J0JTIwSHVnZ2luZ0ZhY2VFbWJlZGRpbmdzJTBBJTBBZnJvbSUyMGxhbmdjaGFpbi52ZWN0b3JzdG9yZXMlMjBpbXBvcnQlMjB1dGlscyUyMGFzJTIwY2hyb21hdXRpbHMlMEElMEElMjMlMjBDaHJvbWFEQiUyMGRvZXNuJ3QlMjBzdXBwb3J0JTIwY29tcGxleCUyMG1ldGFkYXRhJTJDJTIwZS5nLiUyMGxpc3RzJTJDJTIwc28lMjB3ZSUyMGRyb3AlMjBpdCUyMGhlcmUuJTBBJTIzJTIwSWYlMjB5b3UncmUlMjB1c2luZyUyMGElMjBkaWZmZXJlbnQlMjB2ZWN0b3IlMjBzdG9yZSUyQyUyMHlvdSUyMG1heSUyMG5vdCUyMG5lZWQlMjB0byUyMGRvJTIwdGhpcyUwQWRvY3MlMjAlM0QlMjBjaHJvbWF1dGlscy5maWx0ZXJfY29tcGxleF9tZXRhZGF0YShkb2N1bWVudHMpJTBBJTBBZW1iZWRkaW5ncyUyMCUzRCUyMEh1Z2dpbmdGYWNlRW1iZWRkaW5ncyhtb2RlbF9uYW1lJTNEJTIyQkFBSSUyRmJnZS1iYXNlLWVuLXYxLjUlMjIpJTBBdmVjdG9yc3RvcmUlMjAlM0QlMjBDaHJvbWEuZnJvbV9kb2N1bWVudHMoZG9jdW1lbnRzJTJDJTIwZW1iZWRkaW5ncyklMEFyZXRyaWV2ZXIlMjAlM0QlMjB2ZWN0b3JzdG9yZS5hc19yZXRyaWV2ZXIoc2VhcmNoX3R5cGUlM0QlMjJzaW1pbGFyaXR5JTIyJTJDJTIwc2VhcmNoX2t3YXJncyUzRCU3QiUyMmslMjIlM0ElMjAzJTdEKQ==",highlighted:`<span class="hljs-keyword">from</span> langchain_community.vectorstores <span class="hljs-keyword">import</span> Chroma
<span class="hljs-keyword">from</span> langchain.embeddings <span class="hljs-keyword">import</span> HuggingFaceEmbeddings

<span class="hljs-keyword">from</span> langchain.vectorstores <span class="hljs-keyword">import</span> utils <span class="hljs-keyword">as</span> chromautils

<span class="hljs-comment"># ChromaDB doesn&#x27;t support complex metadata, e.g. lists, so we drop it here.</span>
<span class="hljs-comment"># If you&#x27;re using a different vector store, you may not need to do this</span>
docs = chromautils.filter_complex_metadata(documents)

embeddings = HuggingFaceEmbeddings(model_name=<span class="hljs-string">&quot;BAAI/bge-base-en-v1.5&quot;</span>)
vectorstore = Chroma.from_documents(documents, embeddings)
retriever = vectorstore.as_retriever(search_type=<span class="hljs-string">&quot;similarity&quot;</span>, search_kwargs={<span class="hljs-string">&quot;k&quot;</span>: <span class="hljs-number">3</span>})`,wrap:!1}}),se=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),ne=new we({props:{title:"RAG with LangChain",local:"rag-with-langchain",headingTag:"h2"}}),oe=new y({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5wcm9tcHRzJTIwaW1wb3J0JTIwUHJvbXB0VGVtcGxhdGUlMEFmcm9tJTIwbGFuZ2NoYWluLmxsbXMlMjBpbXBvcnQlMjBIdWdnaW5nRmFjZVBpcGVsaW5lJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBZnJvbSUyMGxhbmdjaGFpbi5jaGFpbnMlMjBpbXBvcnQlMjBSZXRyaWV2YWxRQQ==",highlighted:`<span class="hljs-keyword">from</span> langchain.prompts <span class="hljs-keyword">import</span> PromptTemplate
<span class="hljs-keyword">from</span> langchain.llms <span class="hljs-keyword">import</span> HuggingFacePipeline
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, BitsAndBytesConfig
<span class="hljs-keyword">from</span> langchain.chains <span class="hljs-keyword">import</span> RetrievalQA`,wrap:!1}}),ie=new y({props:{code:"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",highlighted:`model_name = <span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>

bnb_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>, bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>, bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>, bnb_4bit_compute_dtype=torch.bfloat16
)

model = AutoModelForCausalLM.from_pretrained(model_name, quantization_config=bnb_config)
tokenizer = AutoTokenizer.from_pretrained(model_name)

terminators = [tokenizer.eos_token_id, tokenizer.convert_tokens_to_ids(<span class="hljs-string">&quot;&lt;|eot_id|&gt;&quot;</span>)]

text_generation_pipeline = pipeline(
    model=model,
    tokenizer=tokenizer,
    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
    temperature=<span class="hljs-number">0.2</span>,
    do_sample=<span class="hljs-literal">True</span>,
    repetition_penalty=<span class="hljs-number">1.1</span>,
    return_full_text=<span class="hljs-literal">False</span>,
    max_new_tokens=<span class="hljs-number">200</span>,
    eos_token_id=terminators,
)

llm = HuggingFacePipeline(pipeline=text_generation_pipeline)

prompt_template = <span class="hljs-string">&quot;&quot;&quot;
&lt;|start_header_id|&gt;user&lt;|end_header_id|&gt;
You are an assistant for answering questions using provided context.
You are given the extracted parts of a long document and a question. Provide a conversational answer.
If you don&#x27;t know the answer, just say &quot;I do not know.&quot; Don&#x27;t make up an answer.
Question: {question}
Context: {context}&lt;|eot_id|&gt;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;
&quot;&quot;&quot;</span>

prompt = PromptTemplate(
    input_variables=[<span class="hljs-string">&quot;context&quot;</span>, <span class="hljs-string">&quot;question&quot;</span>],
    template=prompt_template,
)


qa_chain = RetrievalQA.from_chain_type(llm, retriever=retriever, chain_type_kwargs={<span class="hljs-string">&quot;prompt&quot;</span>: prompt})`,wrap:!1}}),re=new we({props:{title:"Results and next steps",local:"results-and-next-steps",headingTag:"h2"}}),pe=new y({props:{code:"cXVlc3Rpb24lMjAlM0QlMjAlMjJBcmUlMjBhcGhpZHMlMjBhJTIwcGVzdCUzRiUyMiUwQSUwQXFhX2NoYWluLmludm9rZShxdWVzdGlvbiklNUIlMjJyZXN1bHQlMjIlNUQ=",highlighted:`question = <span class="hljs-string">&quot;Are aphids a pest?&quot;</span>

qa_chain.invoke(question)[<span class="hljs-string">&quot;result&quot;</span>]`,wrap:!1}}),ue=new y({props:{code:"WWVzJTJDJTIwYXBoaWRzJTIwYXJlJTIwY29uc2lkZXJlZCUyMHBlc3RzJTIwYmVjYXVzZSUyMHRoZXklMjBmZWVkJTIwb24lMjB0aGUlMjBudXRyaWVudC1yaWNoJTIwbGlxdWlkcyUyMHdpdGhpbiUyMHBsYW50cyUyQyUyMGNhdXNpbmclMjBkYW1hZ2UlMjBhbmQlMjBwb3RlbnRpYWxseSUyMHNwcmVhZGluZyUyMGRpc2Vhc2UuJTIwSW4lMjBmYWN0JTJDJTIwdGhleSdyZSUyMGtub3duJTIwdG8lMjBtdWx0aXBseSUyMHF1aWNrbHklMkMlMjB3aGljaCUyMGlzJTIwd2h5JTIwaXQncyUyMGVzc2VudGlhbCUyMHRvJTIwY29udHJvbCUyMHRoZW0lMjBwcm9tcHRseS4lMjBBcyUyMG1lbnRpb25lZCUyMGluJTIwdGhlJTIwdGV4dCUyQyUyMGFwaGlkcyUyMGNhbiUyMGFsc28lMjBhdHRyYWN0JTIwYW50cyUyQyUyMHdoaWNoJTIwYXJlJTIwYXR0cmFjdGVkJTIwdG8lMjB0aGUlMjBzd2VldCUyQyUyMHN0aWNreSUyMHN1YnN0YW5jZSUyMHRoZXklMjBwcm9kdWNlJTIwY2FsbGVkJTIwaG9uZXlkZXcuJTIwU28lMkMlMjB5ZXMlMkMlMjBhcGhpZHMlMjBhcmUlMjBpbmRlZWQlMjBhJTIwcGVzdCUyMHRoYXQlMjByZXF1aXJlcyUyMGF0dGVudGlvbiUyMHRvJTIwcHJldmVudCUyMGZ1cnRoZXIlMjBoYXJtJTIwdG8lMjB5b3VyJTIwcGxhbnRzIQ==",highlighted:'Yes, aphids are considered pests because they feed on the nutrient-rich liquids within plants, causing damage and potentially spreading disease. In fact, they<span class="hljs-string">&#x27;re known to multiply quickly, which is why it&#x27;</span>s essential to control them promptly. As mentioned <span class="hljs-keyword">in</span> the text, aphids can also attract ants, <span class="hljs-built_in">which</span> are attracted to the sweet, sticky substance they produce called honeydew. So, <span class="hljs-built_in">yes</span>, aphids are indeed a pest that requires attention to prevent further harm to your plants!',wrap:!1}}),Me=new ul({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/rag_with_unstructured_data.md"}}),{c(){M=o("meta"),Te=n(),be=o("p"),fe=n(),c(w.$$.fragment),je=n(),c(b.$$.fragment),Ue=n(),J=o("p"),J.innerHTML=gt,ge=n(),T=o("p"),T.innerHTML=It,Ie=n(),f=o("p"),f.textContent=Zt,Ze=n(),j=o("p"),j.innerHTML=Bt,Be=n(),U=o("p"),U.textContent=Gt,Ge=n(),c(g.$$.fragment),We=n(),I=o("p"),I.textContent=Wt,ve=n(),Z=o("ul"),Z.innerHTML=vt,Re=n(),B=o("p"),B.innerHTML=Rt,ke=n(),c(G.$$.fragment),Ce=n(),c(W.$$.fragment),Xe=n(),v=o("p"),v.innerHTML=kt,xe=n(),R=o("p"),R.innerHTML=Ct,Ve=n(),c(k.$$.fragment),$e=n(),c(C.$$.fragment),_e=n(),X=o("pre"),X.textContent=Xt,Ye=n(),x=o("p"),x.textContent=xt,He=n(),V=o("p"),V.innerHTML=Vt,Ne=n(),$=o("p"),$.innerHTML=$t,Qe=n(),_=o("p"),_.innerHTML=_t,Fe=n(),c(Y.$$.fragment),ze=n(),H=o("p"),H.innerHTML=Yt,Ee=n(),N=o("p"),N.innerHTML=Ht,Ae=n(),Q=o("p"),Q.innerHTML=Nt,Se=n(),F=o("p"),F.innerHTML=Qt,Le=n(),z=o("p"),z.textContent=Ft,qe=n(),c(E.$$.fragment),Pe=n(),A=o("p"),A.textContent=zt,De=n(),c(S.$$.fragment),Ke=n(),L=o("p"),L.textContent=Et,Oe=n(),q=o("p"),q.textContent=At,et=n(),c(P.$$.fragment),tt=n(),D=o("p"),D.textContent=St,lt=n(),c(K.$$.fragment),st=n(),c(O.$$.fragment),nt=n(),ee=o("p"),ee.innerHTML=Lt,at=n(),c(te.$$.fragment),ot=n(),le=o("p"),le.textContent=qt,it=n(),c(se.$$.fragment),rt=n(),c(ne.$$.fragment),ct=n(),ae=o("p"),ae.innerHTML=Pt,pt=n(),c(oe.$$.fragment),dt=n(),c(ie.$$.fragment),ut=n(),c(re.$$.fragment),mt=n(),ce=o("p"),ce.textContent=Dt,ht=n(),c(pe.$$.fragment),yt=n(),de=o("p"),de.textContent=Kt,Mt=n(),c(ue.$$.fragment),wt=n(),me=o("p"),me.textContent=Ot,bt=n(),he=o("ul"),he.innerHTML=el,Jt=n(),ye=o("p"),ye.textContent=tl,Tt=n(),c(Me.$$.fragment),ft=n(),Je=o("p"),this.h()},l(e){const t=cl("svelte-u9bgzb",document.head);M=i(t,"META",{name:!0,content:!0}),t.forEach(l),Te=a(e),be=i(e,"P",{}),ll(be).forEach(l),fe=a(e),p(w.$$.fragment,e),je=a(e),p(b.$$.fragment,e),Ue=a(e),J=i(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-26mfp8"&&(J.innerHTML=gt),ge=a(e),T=i(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1634vfe"&&(T.innerHTML=It),Ie=a(e),f=i(e,"P",{"data-svelte-h":!0}),r(f)!=="svelte-1qci2tz"&&(f.textContent=Zt),Ze=a(e),j=i(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-3xwkhu"&&(j.innerHTML=Bt),Be=a(e),U=i(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1w15t57"&&(U.textContent=Gt),Ge=a(e),p(g.$$.fragment,e),We=a(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-hffqba"&&(I.textContent=Wt),ve=a(e),Z=i(e,"UL",{"data-svelte-h":!0}),r(Z)!=="svelte-1g2z5vq"&&(Z.innerHTML=vt),Re=a(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1d3ly9c"&&(B.innerHTML=Rt),ke=a(e),p(G.$$.fragment,e),Ce=a(e),p(W.$$.fragment,e),Xe=a(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-3uyhm5"&&(v.innerHTML=kt),xe=a(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-14xbuq6"&&(R.innerHTML=Ct),Ve=a(e),p(k.$$.fragment,e),$e=a(e),p(C.$$.fragment,e),_e=a(e),X=i(e,"PRE",{"data-svelte-h":!0}),r(X)!=="svelte-v64b1c"&&(X.textContent=Xt),Ye=a(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1bdx5k2"&&(x.textContent=xt),He=a(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-9g2j19"&&(V.innerHTML=Vt),Ne=a(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1j049ps"&&($.innerHTML=$t),Qe=a(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-45jyya"&&(_.innerHTML=_t),Fe=a(e),p(Y.$$.fragment,e),ze=a(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-ewm525"&&(H.innerHTML=Yt),Ee=a(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1wt80e0"&&(N.innerHTML=Ht),Ae=a(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-9x3e13"&&(Q.innerHTML=Nt),Se=a(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-n92gq9"&&(F.innerHTML=Qt),Le=a(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-2t53hk"&&(z.textContent=Ft),qe=a(e),p(E.$$.fragment,e),Pe=a(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-x3hyox"&&(A.textContent=zt),De=a(e),p(S.$$.fragment,e),Ke=a(e),L=i(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1mlxzmt"&&(L.textContent=Et),Oe=a(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1hwgds0"&&(q.textContent=At),et=a(e),p(P.$$.fragment,e),tt=a(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1j40r14"&&(D.textContent=St),lt=a(e),p(K.$$.fragment,e),st=a(e),p(O.$$.fragment,e),nt=a(e),ee=i(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1r2fx9j"&&(ee.innerHTML=Lt),at=a(e),p(te.$$.fragment,e),ot=a(e),le=i(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1cyhdx7"&&(le.textContent=qt),it=a(e),p(se.$$.fragment,e),rt=a(e),p(ne.$$.fragment,e),ct=a(e),ae=i(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-3710om"&&(ae.innerHTML=Pt),pt=a(e),p(oe.$$.fragment,e),dt=a(e),p(ie.$$.fragment,e),ut=a(e),p(re.$$.fragment,e),mt=a(e),ce=i(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-u2l4ip"&&(ce.textContent=Dt),ht=a(e),p(pe.$$.fragment,e),yt=a(e),de=i(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1wuxk0l"&&(de.textContent=Kt),Mt=a(e),p(ue.$$.fragment,e),wt=a(e),me=i(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1rxjghx"&&(me.textContent=Ot),bt=a(e),he=i(e,"UL",{"data-svelte-h":!0}),r(he)!=="svelte-112y9e5"&&(he.innerHTML=el),Jt=a(e),ye=i(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1g8numv"&&(ye.textContent=tl),Tt=a(e),p(Me.$$.fragment,e),ft=a(e),Je=i(e,"P",{}),ll(Je).forEach(l),this.h()},h(){sl(M,"name","hf:doc:metadata"),sl(M,"content",hl)},m(e,t){pl(document.head,M),s(e,Te,t),s(e,be,t),s(e,fe,t),d(w,e,t),s(e,je,t),d(b,e,t),s(e,Ue,t),s(e,J,t),s(e,ge,t),s(e,T,t),s(e,Ie,t),s(e,f,t),s(e,Ze,t),s(e,j,t),s(e,Be,t),s(e,U,t),s(e,Ge,t),d(g,e,t),s(e,We,t),s(e,I,t),s(e,ve,t),s(e,Z,t),s(e,Re,t),s(e,B,t),s(e,ke,t),d(G,e,t),s(e,Ce,t),d(W,e,t),s(e,Xe,t),s(e,v,t),s(e,xe,t),s(e,R,t),s(e,Ve,t),d(k,e,t),s(e,$e,t),d(C,e,t),s(e,_e,t),s(e,X,t),s(e,Ye,t),s(e,x,t),s(e,He,t),s(e,V,t),s(e,Ne,t),s(e,$,t),s(e,Qe,t),s(e,_,t),s(e,Fe,t),d(Y,e,t),s(e,ze,t),s(e,H,t),s(e,Ee,t),s(e,N,t),s(e,Ae,t),s(e,Q,t),s(e,Se,t),s(e,F,t),s(e,Le,t),s(e,z,t),s(e,qe,t),d(E,e,t),s(e,Pe,t),s(e,A,t),s(e,De,t),d(S,e,t),s(e,Ke,t),s(e,L,t),s(e,Oe,t),s(e,q,t),s(e,et,t),d(P,e,t),s(e,tt,t),s(e,D,t),s(e,lt,t),d(K,e,t),s(e,st,t),d(O,e,t),s(e,nt,t),s(e,ee,t),s(e,at,t),d(te,e,t),s(e,ot,t),s(e,le,t),s(e,it,t),d(se,e,t),s(e,rt,t),d(ne,e,t),s(e,ct,t),s(e,ae,t),s(e,pt,t),d(oe,e,t),s(e,dt,t),d(ie,e,t),s(e,ut,t),d(re,e,t),s(e,mt,t),s(e,ce,t),s(e,ht,t),d(pe,e,t),s(e,yt,t),s(e,de,t),s(e,Mt,t),d(ue,e,t),s(e,wt,t),s(e,me,t),s(e,bt,t),s(e,he,t),s(e,Jt,t),s(e,ye,t),s(e,Tt,t),d(Me,e,t),s(e,ft,t),s(e,Je,t),jt=!0},p:al,i(e){jt||(u(w.$$.fragment,e),u(b.$$.fragment,e),u(g.$$.fragment,e),u(G.$$.fragment,e),u(W.$$.fragment,e),u(k.$$.fragment,e),u(C.$$.fragment,e),u(Y.$$.fragment,e),u(E.$$.fragment,e),u(S.$$.fragment,e),u(P.$$.fragment,e),u(K.$$.fragment,e),u(O.$$.fragment,e),u(te.$$.fragment,e),u(se.$$.fragment,e),u(ne.$$.fragment,e),u(oe.$$.fragment,e),u(ie.$$.fragment,e),u(re.$$.fragment,e),u(pe.$$.fragment,e),u(ue.$$.fragment,e),u(Me.$$.fragment,e),jt=!0)},o(e){m(w.$$.fragment,e),m(b.$$.fragment,e),m(g.$$.fragment,e),m(G.$$.fragment,e),m(W.$$.fragment,e),m(k.$$.fragment,e),m(C.$$.fragment,e),m(Y.$$.fragment,e),m(E.$$.fragment,e),m(S.$$.fragment,e),m(P.$$.fragment,e),m(K.$$.fragment,e),m(O.$$.fragment,e),m(te.$$.fragment,e),m(se.$$.fragment,e),m(ne.$$.fragment,e),m(oe.$$.fragment,e),m(ie.$$.fragment,e),m(re.$$.fragment,e),m(pe.$$.fragment,e),m(ue.$$.fragment,e),m(Me.$$.fragment,e),jt=!1},d(e){e&&(l(Te),l(be),l(fe),l(je),l(Ue),l(J),l(ge),l(T),l(Ie),l(f),l(Ze),l(j),l(Be),l(U),l(Ge),l(We),l(I),l(ve),l(Z),l(Re),l(B),l(ke),l(Ce),l(Xe),l(v),l(xe),l(R),l(Ve),l($e),l(_e),l(X),l(Ye),l(x),l(He),l(V),l(Ne),l($),l(Qe),l(_),l(Fe),l(ze),l(H),l(Ee),l(N),l(Ae),l(Q),l(Se),l(F),l(Le),l(z),l(qe),l(Pe),l(A),l(De),l(Ke),l(L),l(Oe),l(q),l(et),l(tt),l(D),l(lt),l(st),l(nt),l(ee),l(at),l(ot),l(le),l(it),l(rt),l(ct),l(ae),l(pt),l(dt),l(ut),l(mt),l(ce),l(ht),l(yt),l(de),l(Mt),l(wt),l(me),l(bt),l(he),l(Jt),l(ye),l(Tt),l(ft),l(Je)),l(M),h(w,e),h(b,e),h(g,e),h(G,e),h(W,e),h(k,e),h(C,e),h(Y,e),h(E,e),h(S,e),h(P,e),h(K,e),h(O,e),h(te,e),h(se,e),h(ne,e),h(oe,e),h(ie,e),h(re,e),h(pe,e),h(ue,e),h(Me,e)}}}const hl='{"title":"Building RAG with Custom Unstructured Data","local":"building-rag-with-custom-unstructured-data","sections":[{"title":"Unstructured data preprocessing","local":"unstructured-data-preprocessing","sections":[],"depth":2},{"title":"Chunking","local":"chunking","sections":[],"depth":2},{"title":"Setting up the retriever","local":"setting-up-the-retriever","sections":[],"depth":2},{"title":"RAG with LangChain","local":"rag-with-langchain","sections":[],"depth":2},{"title":"Results and next steps","local":"results-and-next-steps","sections":[],"depth":2}],"depth":1}';function yl(Ut){return ol(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Tl extends il{constructor(M){super(),rl(this,M,yl,ml,nl,{})}}export{Tl as component};
