import{s as Zl,o as Wl,n as Bs}from"../chunks/scheduler.8c3d61f6.js";import{S as Cl,i as vl,g as i,s as a,r as c,A as Bl,h as o,f as s,c as n,j as Il,u as m,x as p,k as w,y as kl,a as l,v as M,d,t as y,w as u}from"../chunks/index.da70eac4.js";import{T as vs}from"../chunks/Tip.1d9b8c37.js";import{C as f}from"../chunks/CodeBlock.00a903b3.js";import{D as _l}from"../chunks/DocNotebookDropdown.02900f6b.js";import{H as T,E as Gl}from"../chunks/EditOnGithub.1e64e623.js";function Xl(g){let r,J="This is not an exhaustive guide on prompt engineering, but it will help you understand the necessary parts of a good prompt. We encourage you to continue experimenting with different prompts and combine them in new ways to see what works best. As you write more prompts, you’ll develop an intuition for what works and what doesn’t!";return{c(){r=i("p"),r.textContent=J},l(h){r=o(h,"P",{"data-svelte-h":!0}),p(r)!=="svelte-18ymcu1"&&(r.textContent=J)},m(h,b){l(h,r,b)},p:Bs,d(h){h&&s(r)}}}function $l(g){let r,J='You should also use a <a href="https://www.crosslabs.org//blog/diffusion-with-offset-noise" rel="nofollow"><em>offset noise</em></a> LoRA to improve the contrast in bright and dark images and create better lighting overall. This <a href="https://hf.co/stabilityai/stable-diffusion-xl-base-1.0/blob/main/sd_xl_offset_example-lora_1.0.safetensors" rel="nofollow">LoRA</a> is available from <a href="https://hf.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a>.';return{c(){r=i("p"),r.innerHTML=J},l(h){r=o(h,"P",{"data-svelte-h":!0}),p(r)!=="svelte-14yr5uj"&&(r.innerHTML=J)},m(h,b){l(h,r,b)},p:Bs,d(h){h&&s(r)}}}function Vl(g){let r,J='If your favorite pipeline doesn’t have a <code>prompt_embeds</code> parameter, please open an <a href="https://github.com/huggingface/diffusers/issues/new/choose" rel="nofollow">issue</a> so we can add it!';return{c(){r=i("p"),r.innerHTML=J},l(h){r=o(h,"P",{"data-svelte-h":!0}),p(r)!=="svelte-nya19q"&&(r.innerHTML=J)},m(h,b){l(h,r,b)},p:Bs,d(h){h&&s(r)}}}function Rl(g){let r,J="<code>+</code> corresponds to the value <code>1.1</code>, <code>++</code> corresponds to <code>1.1^2</code>, and so on. Similarly, <code>-</code> corresponds to <code>0.9</code> and <code>--</code> corresponds to <code>0.9^2</code>. Feel free to experiment with adding more <code>+</code> or <code>-</code> in your prompt!";return{c(){r=i("p"),r.innerHTML=J},l(h){r=o(h,"P",{"data-svelte-h":!0}),p(r)!=="svelte-1dn4vb7"&&(r.innerHTML=J)},m(h,b){l(h,r,b)},p:Bs,d(h){h&&s(r)}}}function ql(g){let r,J,h,b,q,Oe,x,et,H,ks="Prompts are important because they describe what you want a diffusion model to generate. The best prompts are detailed, specific, and well-structured to help the model realize your vision. But crafting a great prompt takes time and effort and sometimes it may not be enough because language and words can be imprecise. This is where you need to boost your prompt with other techniques, such as prompt enhancing and prompt weighting, to get the results you want.",tt,Q,_s="This guide will show you how you can use these prompt techniques to generate high-quality images with lower effort and adjust the weight of certain keywords in a prompt.",st,N,lt,U,at,Y,Gs="New diffusion models do a pretty good job of generating high-quality images from a basic prompt, but it is still important to create a well-written prompt to get the best results. Here are a few tips for writing a good prompt:",nt,F,Xs="<li>What is the image <em>medium</em>? Is it a photo, a painting, a 3D illustration, or something else?</li> <li>What is the image <em>subject</em>? Is it a person, animal, object, or scene?</li> <li>What <em>details</em> would you like to see in the image? This is where you can get really creative and have a lot of fun experimenting with different words to bring your image to life. For example, what is the lighting like? What is the vibe and aesthetic? What kind of art or illustration style are you looking for? The more specific and precise words you use, the better the model will understand what you want to generate.</li>",it,j,$s='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/plain-prompt.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">&quot;A photo of a banana-shaped couch in a living room&quot;</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/detail-prompt.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">&quot;A vibrant yellow banana-shaped couch sits in a cozy living room, its curve cradling a pile of colorful cushions. on the wooden floor, a patterned rug adds a touch of eclectic charm, and a potted plant sits in the corner, reaching towards the sunlight filtering through the windows&quot;</figcaption></div>',ot,E,pt,z,Vs="Prompt enhancing is a technique for quickly improving prompt quality without spending too much effort constructing one. It uses a model like GPT2 pretrained on Stable Diffusion text prompts to automatically enrich a prompt with additional important keywords to generate high-quality images.",rt,S,Rs="The technique works by curating a list of specific keywords and forcing the model to generate those words to enhance the original prompt. This way, your prompt can be “a cat” and GPT2 can enhance the prompt to “cinematic film still of a cat basking in the sun on a roof in Turkey, highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain quality sharp focus beautiful detailed intricate stunning amazing epic”.",ct,I,mt,A,qs='Start by defining certain styles and a list of words (you can check out a more comprehensive list of <a href="https://hf.co/LykosAI/GPT-Prompt-Expansion-Fooocus-v2/blob/main/positive.txt" rel="nofollow">words</a> and <a href="https://github.com/lllyasviel/Fooocus/tree/main/sdxl_styles" rel="nofollow">styles</a> used by Fooocus) to enhance a prompt with.',Mt,L,dt,D,xs="You may have noticed in the <code>words</code> list, there are certain words that can be paired together to create something more meaningful. For example, the words “high” and “quality” can be combined to create “high quality”. Let’s pair these words together and remove the words that can’t be paired.",yt,P,ut,K,Hs='Next, implement a custom <a href="https://huggingface.co/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor" rel="nofollow">LogitsProcessor</a> class that assigns tokens in the <code>words</code> list a value of 0 and assigns tokens not in the <code>words</code> list a negative value so they aren’t picked during generation. This way, generation is biased towards words in the <code>words</code> list. After a word from the list is used, it is also assigned a negative value so it isn’t picked again.',ht,O,ft,ee,Qs="Combine the prompt and the <code>cinematic</code> style prompt defined in the <code>styles</code> dictionary earlier.",Jt,te,wt,se,Ns='Load a GPT2 tokenizer and model from the <a href="https://huggingface.co/Gustavosta/MagicPrompt-Stable-Diffusion" rel="nofollow">Gustavosta/MagicPrompt-Stable-Diffusion</a> checkpoint (this specific checkpoint is trained to generate prompts) to enhance the prompt.',bt,le,gt,ae,Ys="Then you can combine the input prompt and the generated prompt. Feel free to take a look at what the generated prompt (<code>generated_part</code>) is, the word pairs that were found (<code>pairs</code>), and the remaining words (<code>words</code>). This is all packed together in the <code>enhanced_prompt</code>.",Tt,ne,Ut,ie,Fs="Finally, load a pipeline and the offset noise LoRA with a <em>low weight</em> to generate an image with the enhanced prompt.",jt,oe,It,Z,Es='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/non-enhanced-prompt.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">&quot;a cat basking in the sun on a roof in Turkey&quot;</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/enhanced-prompt.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">&quot;cinematic film still of a cat basking in the sun on a roof in Turkey, highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain&quot;</figcaption></div>',Zt,pe,Wt,re,zs='Prompt weighting provides a way to emphasize or de-emphasize certain parts of a prompt, allowing for more control over the generated image. A prompt can include several concepts, which gets turned into contextualized text embeddings. The embeddings are used by the model to condition its cross-attention layers to generate an image (read the Stable Diffusion <a href="https://huggingface.co/blog/stable_diffusion" rel="nofollow">blog post</a> to learn more about how it works).',Ct,ce,Ss='Prompt weighting works by increasing or decreasing the scale of the text embedding vector that corresponds to its concept in the prompt because you may not necessarily want the model to focus on all concepts equally. The easiest way to prepare the prompt-weighted embeddings is to use <a href="https://github.com/damian0815/compel" rel="nofollow">Compel</a>, a text prompt-weighting and blending library. Once you have the prompt-weighted embeddings, you can pass them to any pipeline that has a <a href="https://huggingface.co/docs/diffusers/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline.__call__.prompt_embeds" rel="nofollow"><code>prompt_embeds</code></a> (and optionally <a href="https://huggingface.co/docs/diffusers/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline.__call__.negative_prompt_embeds" rel="nofollow"><code>negative_prompt_embeds</code></a>) parameter, such as <a href="/docs/diffusers/pr_10037/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>, <a href="/docs/diffusers/pr_10037/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetPipeline">StableDiffusionControlNetPipeline</a>, and <a href="/docs/diffusers/pr_10037/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline">StableDiffusionXLPipeline</a>.',vt,W,Bt,me,As="This guide will show you how to weight and blend your prompts with Compel in 🤗 Diffusers.",kt,Me,Ls="Before you begin, make sure you have the latest version of Compel installed:",_t,de,Gt,ye,Ds='For this guide, let’s generate an image with the prompt <code>&quot;a red cat playing with a ball&quot;</code> using the <a href="/docs/diffusers/pr_10037/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>:',Xt,ue,$t,C,Ps='<img class="rounded-xl" src="https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/compel/forest_0.png"/>',Vt,he,Rt,fe,Ks='You’ll notice there is no “ball” in the image! Let’s use compel to upweight the concept of “ball” in the prompt. Create a <a href="https://github.com/damian0815/compel/blob/main/doc/compel.md#compel-objects" rel="nofollow"><code>Compel</code></a> object, and pass it a tokenizer and text encoder:',qt,Je,xt,we,Os="compel uses <code>+</code> or <code>-</code> to increase or decrease the weight of a word in the prompt. To increase the weight of “ball”:",Ht,v,Qt,be,Nt,ge,el="Pass the prompt to <code>compel_proc</code> to create the new prompt embeddings which are passed to the pipeline:",Yt,Te,Ft,B,tl='<img class="rounded-xl" src="https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/compel/forest_1.png"/>',Et,Ue,sl="To downweight parts of the prompt, use the <code>-</code> suffix:",zt,je,St,k,ll='<img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/compel-neg.png"/>',At,Ie,al="You can even up or downweight multiple concepts in the same prompt:",Lt,Ze,Dt,_,nl='<img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/compel-pos-neg.png"/>',Pt,We,Kt,Ce,il="You can also create a weighted <em>blend</em> of prompts by adding <code>.blend()</code> to a list of prompts and passing it some weights. Your blend may not always produce the result you expect because it breaks some assumptions about how the text encoder functions, so just have fun and experiment with it!",Ot,ve,es,G,ol='<img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/compel-blend.png"/>',ts,Be,ss,ke,pl="A conjunction diffuses each prompt independently and concatenates their results by their weighted sum. Add <code>.and()</code> to the end of a list of prompts to create a conjunction:",ls,_e,as,X,rl='<img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/compel-conj.png"/>',ns,Ge,is,Xe,cl='<a href="../training/text_inversion">Textual inversion</a> is a technique for learning a specific concept from some images which you can use to generate new images conditioned on that concept.',os,$e,ml='Create a pipeline and use the <a href="/docs/diffusers/pr_10037/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> function to load the textual inversion embeddings (feel free to browse the <a href="https://huggingface.co/spaces/sd-concepts-library/stable-diffusion-conceptualizer" rel="nofollow">Stable Diffusion Conceptualizer</a> for 100+ trained concepts):',ps,Ve,rs,Re,Ml="Compel provides a <code>DiffusersTextualInversionManager</code> class to simplify prompt weighting with textual inversion. Instantiate <code>DiffusersTextualInversionManager</code> and pass it to the <code>Compel</code> class:",cs,qe,ms,xe,dl="Incorporate the concept to condition a prompt with using the <code>&lt;concept&gt;</code> syntax:",Ms,He,ds,$,yl='<img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/compel-text-inversion.png"/>',ys,Qe,us,Ne,ul='<a href="../training/dreambooth">DreamBooth</a> is a technique for generating contextualized images of a subject given just a few images of the subject to train on. It is similar to textual inversion, but DreamBooth trains the full model whereas textual inversion only fine-tunes the text embeddings. This means you should use <a href="/docs/diffusers/pr_10037/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> to load the DreamBooth model (feel free to browse the <a href="https://huggingface.co/sd-dreambooth-library" rel="nofollow">Stable Diffusion Dreambooth Concepts Library</a> for 100+ trained models):',hs,Ye,fs,Fe,hl="Create a <code>Compel</code> class with a tokenizer and text encoder, and pass your prompt to it. Depending on the model you use, you’ll need to incorporate the model’s unique identifier into your prompt. For example, the <code>dndcoverart-v1</code> model uses the identifier <code>dndcoverart</code>:",Js,Ee,ws,V,fl='<img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/compel-dreambooth.png"/>',bs,ze,gs,Se,Jl="Stable Diffusion XL (SDXL) has two tokenizers and text encoders so it’s usage is a bit different. To address this, you should pass both tokenizers and encoders to the <code>Compel</code> class:",Ts,Ae,Us,Le,wl='This time, let’s upweight “ball” by a factor of 1.5 for the first prompt, and downweight “ball” by 0.6 for the second prompt. The <a href="/docs/diffusers/pr_10037/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline">StableDiffusionXLPipeline</a> also requires <a href="https://huggingface.co/docs/diffusers/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLInpaintPipeline.__call__.pooled_prompt_embeds" rel="nofollow"><code>pooled_prompt_embeds</code></a> (and optionally <a href="https://huggingface.co/docs/diffusers/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLInpaintPipeline.__call__.negative_pooled_prompt_embeds" rel="nofollow"><code>negative_pooled_prompt_embeds</code></a>) so you should pass those to the pipeline along with the conditioning tensors:',js,De,Is,R,bl='<div><img class="rounded-xl" src="https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/compel/sdxl_ball1.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">&quot;a red cat playing with a (ball)1.5&quot;</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/compel/sdxl_ball2.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">&quot;a red cat playing with a (ball)0.6&quot;</figcaption></div>',Zs,Pe,Ws,Ke,Cs;return q=new T({props:{title:"Prompt techniques",local:"prompt-techniques",headingTag:"h1"}}),x=new _l({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/weighted_prompts.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/weighted_prompts.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/weighted_prompts.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/weighted_prompts.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/weighted_prompts.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/weighted_prompts.ipynb"}]}}),N=new T({props:{title:"Prompt engineering",local:"prompt-engineering",headingTag:"h2"}}),U=new vs({props:{warning:!1,$$slots:{default:[Xl]},$$scope:{ctx:g}}}),E=new T({props:{title:"Prompt enhancing with GPT2",local:"prompt-enhancing-with-gpt2",headingTag:"h2"}}),I=new vs({props:{warning:!1,$$slots:{default:[$l]},$$scope:{ctx:g}}}),L=new f({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GenerationConfig, GPT2LMHeadModel, GPT2Tokenizer, LogitsProcessor, LogitsProcessorList
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline

styles = {
    <span class="hljs-string">&quot;cinematic&quot;</span>: <span class="hljs-string">&quot;cinematic film still of {prompt}, highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain&quot;</span>,
    <span class="hljs-string">&quot;anime&quot;</span>: <span class="hljs-string">&quot;anime artwork of {prompt}, anime style, key visual, vibrant, studio anime, highly detailed&quot;</span>,
    <span class="hljs-string">&quot;photographic&quot;</span>: <span class="hljs-string">&quot;cinematic photo of {prompt}, 35mm photograph, film, professional, 4k, highly detailed&quot;</span>,
    <span class="hljs-string">&quot;comic&quot;</span>: <span class="hljs-string">&quot;comic of {prompt}, graphic illustration, comic art, graphic novel art, vibrant, highly detailed&quot;</span>,
    <span class="hljs-string">&quot;lineart&quot;</span>: <span class="hljs-string">&quot;line art drawing {prompt}, professional, sleek, modern, minimalist, graphic, line art, vector graphics&quot;</span>,
    <span class="hljs-string">&quot;pixelart&quot;</span>: <span class="hljs-string">&quot; pixel-art {prompt}, low-res, blocky, pixel art style, 8-bit graphics&quot;</span>,
}

words = [
    <span class="hljs-string">&quot;aesthetic&quot;</span>, <span class="hljs-string">&quot;astonishing&quot;</span>, <span class="hljs-string">&quot;beautiful&quot;</span>, <span class="hljs-string">&quot;breathtaking&quot;</span>, <span class="hljs-string">&quot;composition&quot;</span>, <span class="hljs-string">&quot;contrasted&quot;</span>, <span class="hljs-string">&quot;epic&quot;</span>, <span class="hljs-string">&quot;moody&quot;</span>, <span class="hljs-string">&quot;enhanced&quot;</span>,
    <span class="hljs-string">&quot;exceptional&quot;</span>, <span class="hljs-string">&quot;fascinating&quot;</span>, <span class="hljs-string">&quot;flawless&quot;</span>, <span class="hljs-string">&quot;glamorous&quot;</span>, <span class="hljs-string">&quot;glorious&quot;</span>, <span class="hljs-string">&quot;illumination&quot;</span>, <span class="hljs-string">&quot;impressive&quot;</span>, <span class="hljs-string">&quot;improved&quot;</span>,
    <span class="hljs-string">&quot;inspirational&quot;</span>, <span class="hljs-string">&quot;magnificent&quot;</span>, <span class="hljs-string">&quot;majestic&quot;</span>, <span class="hljs-string">&quot;hyperrealistic&quot;</span>, <span class="hljs-string">&quot;smooth&quot;</span>, <span class="hljs-string">&quot;sharp&quot;</span>, <span class="hljs-string">&quot;focus&quot;</span>, <span class="hljs-string">&quot;stunning&quot;</span>, <span class="hljs-string">&quot;detailed&quot;</span>,
    <span class="hljs-string">&quot;intricate&quot;</span>, <span class="hljs-string">&quot;dramatic&quot;</span>, <span class="hljs-string">&quot;high&quot;</span>, <span class="hljs-string">&quot;quality&quot;</span>, <span class="hljs-string">&quot;perfect&quot;</span>, <span class="hljs-string">&quot;light&quot;</span>, <span class="hljs-string">&quot;ultra&quot;</span>, <span class="hljs-string">&quot;highly&quot;</span>, <span class="hljs-string">&quot;radiant&quot;</span>, <span class="hljs-string">&quot;satisfying&quot;</span>,
    <span class="hljs-string">&quot;soothing&quot;</span>, <span class="hljs-string">&quot;sophisticated&quot;</span>, <span class="hljs-string">&quot;stylish&quot;</span>, <span class="hljs-string">&quot;sublime&quot;</span>, <span class="hljs-string">&quot;terrific&quot;</span>, <span class="hljs-string">&quot;touching&quot;</span>, <span class="hljs-string">&quot;timeless&quot;</span>, <span class="hljs-string">&quot;wonderful&quot;</span>, <span class="hljs-string">&quot;unbelievable&quot;</span>,
    <span class="hljs-string">&quot;elegant&quot;</span>, <span class="hljs-string">&quot;awesome&quot;</span>, <span class="hljs-string">&quot;amazing&quot;</span>, <span class="hljs-string">&quot;dynamic&quot;</span>, <span class="hljs-string">&quot;trendy&quot;</span>,
]`,wrap:!1}}),P=new f({props:{code:"d29yZF9wYWlycyUyMCUzRCUyMCU1QiUyMmhpZ2hseSUyMGRldGFpbGVkJTIyJTJDJTIwJTIyaGlnaCUyMHF1YWxpdHklMjIlMkMlMjAlMjJlbmhhbmNlZCUyMHF1YWxpdHklMjIlMkMlMjAlMjJwZXJmZWN0JTIwY29tcG9zaXRpb24lMjIlMkMlMjAlMjJkeW5hbWljJTIwbGlnaHQlMjIlNUQlMEElMEFkZWYlMjBmaW5kX2FuZF9vcmRlcl9wYWlycyhzJTJDJTIwcGFpcnMpJTNBJTBBJTIwJTIwJTIwJTIwd29yZHMlMjAlM0QlMjBzLnNwbGl0KCklMEElMjAlMjAlMjAlMjBmb3VuZF9wYWlycyUyMCUzRCUyMCU1QiU1RCUwQSUyMCUyMCUyMCUyMGZvciUyMHBhaXIlMjBpbiUyMHBhaXJzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGFpcl93b3JkcyUyMCUzRCUyMHBhaXIuc3BsaXQoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwcGFpcl93b3JkcyU1QjAlNUQlMjBpbiUyMHdvcmRzJTIwYW5kJTIwcGFpcl93b3JkcyU1QjElNUQlMjBpbiUyMHdvcmRzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm91bmRfcGFpcnMuYXBwZW5kKHBhaXIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd29yZHMucmVtb3ZlKHBhaXJfd29yZHMlNUIwJTVEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdvcmRzLnJlbW92ZShwYWlyX3dvcmRzJTVCMSU1RCklMEElMEElMjAlMjAlMjAlMjBmb3IlMjB3b3JkJTIwaW4lMjB3b3JkcyU1QiUzQSU1RCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMHBhaXIlMjBpbiUyMHBhaXJzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjB3b3JkJTIwaW4lMjBwYWlyLnNwbGl0KCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3b3Jkcy5yZW1vdmUod29yZCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBicmVhayUwQSUyMCUyMCUyMCUyMG9yZGVyZWRfcGFpcnMlMjAlM0QlMjAlMjIlMkMlMjAlMjIuam9pbihmb3VuZF9wYWlycyklMEElMjAlMjAlMjAlMjByZW1haW5pbmdfcyUyMCUzRCUyMCUyMiUyQyUyMCUyMi5qb2luKHdvcmRzKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG9yZGVyZWRfcGFpcnMlMkMlMjByZW1haW5pbmdfcw==",highlighted:`word_pairs = [<span class="hljs-string">&quot;highly detailed&quot;</span>, <span class="hljs-string">&quot;high quality&quot;</span>, <span class="hljs-string">&quot;enhanced quality&quot;</span>, <span class="hljs-string">&quot;perfect composition&quot;</span>, <span class="hljs-string">&quot;dynamic light&quot;</span>]

<span class="hljs-keyword">def</span> <span class="hljs-title function_">find_and_order_pairs</span>(<span class="hljs-params">s, pairs</span>):
    words = s.split()
    found_pairs = []
    <span class="hljs-keyword">for</span> pair <span class="hljs-keyword">in</span> pairs:
        pair_words = pair.split()
        <span class="hljs-keyword">if</span> pair_words[<span class="hljs-number">0</span>] <span class="hljs-keyword">in</span> words <span class="hljs-keyword">and</span> pair_words[<span class="hljs-number">1</span>] <span class="hljs-keyword">in</span> words:
            found_pairs.append(pair)
            words.remove(pair_words[<span class="hljs-number">0</span>])
            words.remove(pair_words[<span class="hljs-number">1</span>])

    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> words[:]:
        <span class="hljs-keyword">for</span> pair <span class="hljs-keyword">in</span> pairs:
            <span class="hljs-keyword">if</span> word <span class="hljs-keyword">in</span> pair.split():
                words.remove(word)
                <span class="hljs-keyword">break</span>
    ordered_pairs = <span class="hljs-string">&quot;, &quot;</span>.join(found_pairs)
    remaining_s = <span class="hljs-string">&quot;, &quot;</span>.join(words)
    <span class="hljs-keyword">return</span> ordered_pairs, remaining_s`,wrap:!1}}),O=new f({props:{code:"Y2xhc3MlMjBDdXN0b21Mb2dpdHNQcm9jZXNzb3IoTG9naXRzUHJvY2Vzc29yKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBiaWFzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuYmlhcyUyMCUzRCUyMGJpYXMlMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2NhbGxfXyhzZWxmJTJDJTIwaW5wdXRfaWRzJTJDJTIwc2NvcmVzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbGVuKGlucHV0X2lkcy5zaGFwZSklMjAlM0QlM0QlMjAyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGFzdF90b2tlbl9pZCUyMCUzRCUyMGlucHV0X2lkcyU1QjAlMkMlMjAtMSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuYmlhcyU1Qmxhc3RfdG9rZW5faWQlNUQlMjAlM0QlMjAtMWUxMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHNjb3JlcyUyMCUyQiUyMHNlbGYuYmlhcyUwQSUwQXdvcmRfaWRzJTIwJTNEJTIwJTVCdG9rZW5pemVyLmVuY29kZSh3b3JkJTJDJTIwYWRkX3ByZWZpeF9zcGFjZSUzRFRydWUpJTVCMCU1RCUyMGZvciUyMHdvcmQlMjBpbiUyMHdvcmRzJTVEJTBBYmlhcyUyMCUzRCUyMHRvcmNoLmZ1bGwoKHRva2VuaXplci52b2NhYl9zaXplJTJDKSUyQyUyMC1mbG9hdCglMjJJbmYlMjIpKS50byglMjJjdWRhJTIyKSUwQWJpYXMlNUJ3b3JkX2lkcyU1RCUyMCUzRCUyMDAlMEFwcm9jZXNzb3IlMjAlM0QlMjBDdXN0b21Mb2dpdHNQcm9jZXNzb3IoYmlhcyklMEFwcm9jZXNzb3JfbGlzdCUyMCUzRCUyMExvZ2l0c1Byb2Nlc3Nvckxpc3QoJTVCcHJvY2Vzc29yJTVEKQ==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">CustomLogitsProcessor</span>(<span class="hljs-title class_ inherited__">LogitsProcessor</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, bias</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.bias = bias

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, input_ids, scores</span>):
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(input_ids.shape) == <span class="hljs-number">2</span>:
            last_token_id = input_ids[<span class="hljs-number">0</span>, -<span class="hljs-number">1</span>]
            self.bias[last_token_id] = -<span class="hljs-number">1e10</span>
        <span class="hljs-keyword">return</span> scores + self.bias

word_ids = [tokenizer.encode(word, add_prefix_space=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>] <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> words]
bias = torch.full((tokenizer.vocab_size,), -<span class="hljs-built_in">float</span>(<span class="hljs-string">&quot;Inf&quot;</span>)).to(<span class="hljs-string">&quot;cuda&quot;</span>)
bias[word_ids] = <span class="hljs-number">0</span>
processor = CustomLogitsProcessor(bias)
processor_list = LogitsProcessorList([processor])`,wrap:!1}}),te=new f({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyYSUyMGNhdCUyMGJhc2tpbmclMjBpbiUyMHRoZSUyMHN1biUyMG9uJTIwYSUyMHJvb2YlMjBpbiUyMFR1cmtleSUyMiUwQXN0eWxlJTIwJTNEJTIwJTIyY2luZW1hdGljJTIyJTBBJTBBcHJvbXB0JTIwJTNEJTIwc3R5bGVzJTVCc3R5bGUlNUQuZm9ybWF0KHByb21wdCUzRHByb21wdCklMEFwcm9tcHQlMEElMjJjaW5lbWF0aWMlMjBmaWxtJTIwc3RpbGwlMjBvZiUyMGElMjBjYXQlMjBiYXNraW5nJTIwaW4lMjB0aGUlMjBzdW4lMjBvbiUyMGElMjByb29mJTIwaW4lMjBUdXJrZXklMkMlMjBoaWdobHklMjBkZXRhaWxlZCUyQyUyMGhpZ2glMjBidWRnZXQlMjBob2xseXdvb2QlMjBtb3ZpZSUyQyUyMGNpbmVtYXNjb3BlJTJDJTIwbW9vZHklMkMlMjBlcGljJTJDJTIwZ29yZ2VvdXMlMkMlMjBmaWxtJTIwZ3JhaW4lMjI=",highlighted:`prompt = <span class="hljs-string">&quot;a cat basking in the sun on a roof in Turkey&quot;</span>
style = <span class="hljs-string">&quot;cinematic&quot;</span>

prompt = styles[style].<span class="hljs-built_in">format</span>(prompt=prompt)
prompt
<span class="hljs-string">&quot;cinematic film still of a cat basking in the sun on a roof in Turkey, highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain&quot;</span>`,wrap:!1}}),le=new f({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwR1BUMlRva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyR3VzdGF2b3N0YSUyRk1hZ2ljUHJvbXB0LVN0YWJsZS1EaWZmdXNpb24lMjIpJTBBbW9kZWwlMjAlM0QlMjBHUFQyTE1IZWFkTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMkd1c3Rhdm9zdGElMkZNYWdpY1Byb21wdC1TdGFibGUtRGlmZnVzaW9uJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KS50byglMEElMjAlMjAlMjAlMjAlMjJjdWRhJTIyJTBBKSUwQW1vZGVsLmV2YWwoKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byglMjJjdWRhJTIyKSUwQXRva2VuX2NvdW50JTIwJTNEJTIwaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVELnNoYXBlJTVCMSU1RCUwQW1heF9uZXdfdG9rZW5zJTIwJTNEJTIwNTAlMjAtJTIwdG9rZW5fY291bnQlMEElMEFnZW5lcmF0aW9uX2NvbmZpZyUyMCUzRCUyMEdlbmVyYXRpb25Db25maWcoJTBBJTIwJTIwJTIwJTIwcGVuYWx0eV9hbHBoYSUzRDAuNyUyQyUwQSUyMCUyMCUyMCUyMHRvcF9rJTNENTAlMkMlMEElMjAlMjAlMjAlMjBlb3NfdG9rZW5faWQlM0Rtb2RlbC5jb25maWcuZW9zX3Rva2VuX2lkJTJDJTBBJTIwJTIwJTIwJTIwcGFkX3Rva2VuX2lkJTNEbW9kZWwuY29uZmlnLmVvc190b2tlbl9pZCUyQyUwQSUyMCUyMCUyMCUyMHBhZF90b2tlbiUzRG1vZGVsLmNvbmZpZy5wYWRfdG9rZW5faWQlMkMlMEElMjAlMjAlMjAlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTBBKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBnZW5lcmF0ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXRfaWRzJTNEaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXR0ZW50aW9uX21hc2slM0RpbnB1dHMlNUIlMjJhdHRlbnRpb25fbWFzayUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNEbWF4X25ld190b2tlbnMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnZW5lcmF0aW9uX2NvbmZpZyUzRGdlbmVyYXRpb25fY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9naXRzX3Byb2Nlc3NvciUzRHByb2NjZXNvcl9saXN0JTJDJTBBJTIwJTIwJTIwJTIwKQ==",highlighted:`tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&quot;Gustavosta/MagicPrompt-Stable-Diffusion&quot;</span>)
model = GPT2LMHeadModel.from_pretrained(<span class="hljs-string">&quot;Gustavosta/MagicPrompt-Stable-Diffusion&quot;</span>, torch_dtype=torch.float16).to(
    <span class="hljs-string">&quot;cuda&quot;</span>
)
model.<span class="hljs-built_in">eval</span>()

inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
token_count = inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[<span class="hljs-number">1</span>]
max_new_tokens = <span class="hljs-number">50</span> - token_count

generation_config = GenerationConfig(
    penalty_alpha=<span class="hljs-number">0.7</span>,
    top_k=<span class="hljs-number">50</span>,
    eos_token_id=model.config.eos_token_id,
    pad_token_id=model.config.eos_token_id,
    pad_token=model.config.pad_token_id,
    do_sample=<span class="hljs-literal">True</span>,
)

<span class="hljs-keyword">with</span> torch.no_grad():
    generated_ids = model.generate(
        input_ids=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>],
        attention_mask=inputs[<span class="hljs-string">&quot;attention_mask&quot;</span>],
        max_new_tokens=max_new_tokens,
        generation_config=generation_config,
        logits_processor=proccesor_list,
    )`,wrap:!1}}),ne=new f({props:{code:"b3V0cHV0X3Rva2VucyUyMCUzRCUyMCU1QnRva2VuaXplci5kZWNvZGUoZ2VuZXJhdGVkX2lkJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTIwZm9yJTIwZ2VuZXJhdGVkX2lkJTIwaW4lMjBnZW5lcmF0ZWRfaWRzJTVEJTBBaW5wdXRfcGFydCUyQyUyMGdlbmVyYXRlZF9wYXJ0JTIwJTNEJTIwb3V0cHV0X3Rva2VucyU1QjAlNUQlNUIlM0ElMjBsZW4ocHJvbXB0KSU1RCUyQyUyMG91dHB1dF90b2tlbnMlNUIwJTVEJTVCbGVuKHByb21wdCklMjAlM0ElNUQlMEFwYWlycyUyQyUyMHdvcmRzJTIwJTNEJTIwZmluZF9hbmRfb3JkZXJfcGFpcnMoZ2VuZXJhdGVkX3BhcnQlMkMlMjB3b3JkX3BhaXJzKSUwQWZvcm1hdHRlZF9nZW5lcmF0ZWRfcGFydCUyMCUzRCUyMHBhaXJzJTIwJTJCJTIwJTIyJTJDJTIwJTIyJTIwJTJCJTIwd29yZHMlMEFlbmhhbmNlZF9wcm9tcHQlMjAlM0QlMjBpbnB1dF9wYXJ0JTIwJTJCJTIwJTIyJTJDJTIwJTIyJTIwJTJCJTIwZm9ybWF0dGVkX2dlbmVyYXRlZF9wYXJ0JTBBZW5oYW5jZWRfcHJvbXB0JTBBJTVCJTIyY2luZW1hdGljJTIwZmlsbSUyMHN0aWxsJTIwb2YlMjBhJTIwY2F0JTIwYmFza2luZyUyMGluJTIwdGhlJTIwc3VuJTIwb24lMjBhJTIwcm9vZiUyMGluJTIwVHVya2V5JTJDJTIwaGlnaGx5JTIwZGV0YWlsZWQlMkMlMjBoaWdoJTIwYnVkZ2V0JTIwaG9sbHl3b29kJTIwbW92aWUlMkMlMjBjaW5lbWFzY29wZSUyQyUyMG1vb2R5JTJDJTIwZXBpYyUyQyUyMGdvcmdlb3VzJTJDJTIwZmlsbSUyMGdyYWluJTIwcXVhbGl0eSUyMHNoYXJwJTIwZm9jdXMlMjBiZWF1dGlmdWwlMjBkZXRhaWxlZCUyMGludHJpY2F0ZSUyMHN0dW5uaW5nJTIwYW1hemluZyUyMGVwaWMlMjIlNUQ=",highlighted:`output_tokens = [tokenizer.decode(generated_id, skip_special_tokens=<span class="hljs-literal">True</span>) <span class="hljs-keyword">for</span> generated_id <span class="hljs-keyword">in</span> generated_ids]
input_part, generated_part = output_tokens[<span class="hljs-number">0</span>][: <span class="hljs-built_in">len</span>(prompt)], output_tokens[<span class="hljs-number">0</span>][<span class="hljs-built_in">len</span>(prompt) :]
pairs, words = find_and_order_pairs(generated_part, word_pairs)
formatted_generated_part = pairs + <span class="hljs-string">&quot;, &quot;</span> + words
enhanced_prompt = input_part + <span class="hljs-string">&quot;, &quot;</span> + formatted_generated_part
enhanced_prompt
[<span class="hljs-string">&quot;cinematic film still of a cat basking in the sun on a roof in Turkey, highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain quality sharp focus beautiful detailed intricate stunning amazing epic&quot;</span>]`,wrap:!1}}),oe=new f({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJSdW5EaWZmdXNpb24lMkZKdWdnZXJuYXV0LVhMLXY5JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBcGlwZWxpbmUubG9hZF9sb3JhX3dlaWdodHMoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTBBJTIwJTIwJTIwJTIwd2VpZ2h0X25hbWUlM0QlMjJzZF94bF9vZmZzZXRfZXhhbXBsZS1sb3JhXzEuMC5zYWZldGVuc29ycyUyMiUyQyUwQSUyMCUyMCUyMCUyMGFkYXB0ZXJfbmFtZSUzRCUyMm9mZnNldCUyMiUyQyUwQSklMEFwaXBlbGluZS5zZXRfYWRhcHRlcnMoJTVCJTIyb2Zmc2V0JTIyJTVEJTJDJTIwYWRhcHRlcl93ZWlnaHRzJTNEJTVCMC4yJTVEKSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwZW5oYW5jZWRfcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0QxMTUyJTJDJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNEODk2JTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q3LjUlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjUlMkMlMEEpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`pipeline = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;RunDiffusion/Juggernaut-XL-v9&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipeline.load_lora_weights(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    weight_name=<span class="hljs-string">&quot;sd_xl_offset_example-lora_1.0.safetensors&quot;</span>,
    adapter_name=<span class="hljs-string">&quot;offset&quot;</span>,
)
pipeline.set_adapters([<span class="hljs-string">&quot;offset&quot;</span>], adapter_weights=[<span class="hljs-number">0.2</span>])

image = pipeline(
    enhanced_prompt,
    width=<span class="hljs-number">1152</span>,
    height=<span class="hljs-number">896</span>,
    guidance_scale=<span class="hljs-number">7.5</span>,
    num_inference_steps=<span class="hljs-number">25</span>,
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),pe=new T({props:{title:"Prompt weighting",local:"prompt-weighting",headingTag:"h2"}}),W=new vs({props:{$$slots:{default:[Vl]},$$scope:{ctx:g}}}),de=new f({props:{code:"JTIzJTIwdW5jb21tZW50JTIwdG8lMjBpbnN0YWxsJTIwaW4lMjBDb2xhYiUwQSUyMyFwaXAlMjBpbnN0YWxsJTIwY29tcGVsJTIwLS11cGdyYWRl",highlighted:`<span class="hljs-comment"># uncomment to install in Colab</span>
<span class="hljs-comment">#!pip install compel --upgrade</span>`,wrap:!1}}),ue=new f({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTJDJTIwVW5pUENNdWx0aXN0ZXBTY2hlZHVsZXIlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyQ29tcFZpcyUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNCUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjBVbmlQQ011bHRpc3RlcFNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjByZWQlMjBjYXQlMjBwbGF5aW5nJTIwd2l0aCUyMGElMjBiYWxsJTIyJTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmNwdSUyMikubWFudWFsX3NlZWQoMzMpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUyQyUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyMCkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline, UniPCMultistepScheduler
<span class="hljs-keyword">import</span> torch

pipe = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)
pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;a red cat playing with a ball&quot;</span>

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">33</span>)

image = pipe(prompt, generator=generator, num_inference_steps=<span class="hljs-number">20</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),he=new T({props:{title:"Weighting",local:"weighting",headingTag:"h3"}}),Je=new f({props:{code:"ZnJvbSUyMGNvbXBlbCUyMGltcG9ydCUyMENvbXBlbCUwQSUwQWNvbXBlbF9wcm9jJTIwJTNEJTIwQ29tcGVsKHRva2VuaXplciUzRHBpcGUudG9rZW5pemVyJTJDJTIwdGV4dF9lbmNvZGVyJTNEcGlwZS50ZXh0X2VuY29kZXIp",highlighted:`<span class="hljs-keyword">from</span> compel <span class="hljs-keyword">import</span> Compel

compel_proc = Compel(tokenizer=pipe.tokenizer, text_encoder=pipe.text_encoder)`,wrap:!1}}),v=new vs({props:{$$slots:{default:[Rl]},$$scope:{ctx:g}}}),be=new f({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyYSUyMHJlZCUyMGNhdCUyMHBsYXlpbmclMjB3aXRoJTIwYSUyMGJhbGwlMkIlMkIlMjI=",highlighted:'prompt = <span class="hljs-string">&quot;a red cat playing with a ball++&quot;</span>',wrap:!1}}),Te=new f({props:{code:"cHJvbXB0X2VtYmVkcyUyMCUzRCUyMGNvbXBlbF9wcm9jKHByb21wdCklMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZCgzMyklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0X2VtYmVkcyUzRHByb21wdF9lbWJlZHMlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjApLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`prompt_embeds = compel_proc(prompt)
generator = torch.manual_seed(<span class="hljs-number">33</span>)

image = pipe(prompt_embeds=prompt_embeds, generator=generator, num_inference_steps=<span class="hljs-number">20</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),je=new f({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyYSUyMHJlZC0tLS0tLS0lMjBjYXQlMjBwbGF5aW5nJTIwd2l0aCUyMGElMjBiYWxsJTIyJTBBcHJvbXB0X2VtYmVkcyUyMCUzRCUyMGNvbXBlbF9wcm9jKHByb21wdCklMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZCgzMyklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0X2VtYmVkcyUzRHByb21wdF9lbWJlZHMlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjApLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`prompt = <span class="hljs-string">&quot;a red------- cat playing with a ball&quot;</span>
prompt_embeds = compel_proc(prompt)

generator = torch.manual_seed(<span class="hljs-number">33</span>)

image = pipe(prompt_embeds=prompt_embeds, generator=generator, num_inference_steps=<span class="hljs-number">20</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),Ze=new f({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyYSUyMHJlZCUyMGNhdCUyQiUyQiUyMHBsYXlpbmclMjB3aXRoJTIwYSUyMGJhbGwtLS0tJTIyJTBBcHJvbXB0X2VtYmVkcyUyMCUzRCUyMGNvbXBlbF9wcm9jKHByb21wdCklMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZCgzMyklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0X2VtYmVkcyUzRHByb21wdF9lbWJlZHMlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjApLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`prompt = <span class="hljs-string">&quot;a red cat++ playing with a ball----&quot;</span>
prompt_embeds = compel_proc(prompt)

generator = torch.manual_seed(<span class="hljs-number">33</span>)

image = pipe(prompt_embeds=prompt_embeds, generator=generator, num_inference_steps=<span class="hljs-number">20</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),We=new T({props:{title:"Blending",local:"blending",headingTag:"h3"}}),ve=new f({props:{code:"cHJvbXB0X2VtYmVkcyUyMCUzRCUyMGNvbXBlbF9wcm9jKCcoJTIyYSUyMHJlZCUyMGNhdCUyMHBsYXlpbmclMjB3aXRoJTIwYSUyMGJhbGwlMjIlMkMlMjAlMjJqdW5nbGUlMjIpLmJsZW5kKDAuNyUyQyUyMDAuOCknKSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjdWRhJTIyKS5tYW51YWxfc2VlZCgzMyklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0X2VtYmVkcyUzRHByb21wdF9lbWJlZHMlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjApLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`prompt_embeds = compel_proc(<span class="hljs-string">&#x27;(&quot;a red cat playing with a ball&quot;, &quot;jungle&quot;).blend(0.7, 0.8)&#x27;</span>)
generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">33</span>)

image = pipe(prompt_embeds=prompt_embeds, generator=generator, num_inference_steps=<span class="hljs-number">20</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),Be=new T({props:{title:"Conjunction",local:"conjunction",headingTag:"h3"}}),_e=new f({props:{code:"cHJvbXB0X2VtYmVkcyUyMCUzRCUyMGNvbXBlbF9wcm9jKCclNUIlMjJhJTIwcmVkJTIwY2F0JTIyJTJDJTIwJTIycGxheWluZyUyMHdpdGglMjBhJTIyJTJDJTIwJTIyYmFsbCUyMiU1RC5hbmQoKScpJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmN1ZGElMjIpLm1hbnVhbF9zZWVkKDU1KSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHRfZW1iZWRzJTNEcHJvbXB0X2VtYmVkcyUyQyUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyMCkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`prompt_embeds = compel_proc(<span class="hljs-string">&#x27;[&quot;a red cat&quot;, &quot;playing with a&quot;, &quot;ball&quot;].and()&#x27;</span>)
generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">55</span>)

image = pipe(prompt_embeds=prompt_embeds, generator=generator, num_inference_steps=<span class="hljs-number">20</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),Ge=new T({props:{title:"Textual inversion",local:"textual-inversion",headingTag:"h3"}}),Ve=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwY29tcGVsJTIwaW1wb3J0JTIwQ29tcGVsJTJDJTIwRGlmZnVzZXJzVGV4dHVhbEludmVyc2lvbk1hbmFnZXIlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMikudG8oJTIyY3VkYSUyMiklMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyc2QtY29uY2VwdHMtbGlicmFyeSUyRm1pZGpvdXJuZXktc3R5bGUlMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">from</span> compel <span class="hljs-keyword">import</span> Compel, DiffusersTextualInversionManager

pipe = StableDiffusionPipeline.from_pretrained(
  <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16,
  use_safetensors=<span class="hljs-literal">True</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.load_textual_inversion(<span class="hljs-string">&quot;sd-concepts-library/midjourney-style&quot;</span>)`,wrap:!1}}),qe=new f({props:{code:"dGV4dHVhbF9pbnZlcnNpb25fbWFuYWdlciUyMCUzRCUyMERpZmZ1c2Vyc1RleHR1YWxJbnZlcnNpb25NYW5hZ2VyKHBpcGUpJTBBY29tcGVsX3Byb2MlMjAlM0QlMjBDb21wZWwoJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEcGlwZS50b2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjB0ZXh0X2VuY29kZXIlM0RwaXBlLnRleHRfZW5jb2RlciUyQyUwQSUyMCUyMCUyMCUyMHRleHR1YWxfaW52ZXJzaW9uX21hbmFnZXIlM0R0ZXh0dWFsX2ludmVyc2lvbl9tYW5hZ2VyKQ==",highlighted:`textual_inversion_manager = DiffusersTextualInversionManager(pipe)
compel_proc = Compel(
    tokenizer=pipe.tokenizer,
    text_encoder=pipe.text_encoder,
    textual_inversion_manager=textual_inversion_manager)`,wrap:!1}}),He=new f({props:{code:"cHJvbXB0X2VtYmVkcyUyMCUzRCUyMGNvbXBlbF9wcm9jKCcoJTIyQSUyMHJlZCUyMGNhdCUyQiUyQiUyMHBsYXlpbmclMjB3aXRoJTIwYSUyMGJhbGwlMjAlM0NtaWRqb3VybmV5LXN0eWxlJTNFJTIyKScpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdF9lbWJlZHMlM0Rwcm9tcHRfZW1iZWRzKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`prompt_embeds = compel_proc(<span class="hljs-string">&#x27;(&quot;A red cat++ playing with a ball &lt;midjourney-style&gt;&quot;)&#x27;</span>)

image = pipe(prompt_embeds=prompt_embeds).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),Qe=new T({props:{title:"DreamBooth",local:"dreambooth",headingTag:"h3"}}),Ye=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBVbmlQQ011bHRpc3RlcFNjaGVkdWxlciUwQWZyb20lMjBjb21wZWwlMjBpbXBvcnQlMjBDb21wZWwlMEElMEFwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnNkLWRyZWFtYm9vdGgtbGlicmFyeSUyRmRuZGNvdmVyYXJ0LXYxJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KS50byglMjJjdWRhJTIyKSUwQXBpcGUuc2NoZWR1bGVyJTIwJTNEJTIwVW5pUENNdWx0aXN0ZXBTY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZS5zY2hlZHVsZXIuY29uZmlnKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, UniPCMultistepScheduler
<span class="hljs-keyword">from</span> compel <span class="hljs-keyword">import</span> Compel

pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;sd-dreambooth-library/dndcoverart-v1&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)`,wrap:!1}}),Ee=new f({props:{code:"Y29tcGVsX3Byb2MlMjAlM0QlMjBDb21wZWwodG9rZW5pemVyJTNEcGlwZS50b2tlbml6ZXIlMkMlMjB0ZXh0X2VuY29kZXIlM0RwaXBlLnRleHRfZW5jb2RlciklMEFwcm9tcHRfZW1iZWRzJTIwJTNEJTIwY29tcGVsX3Byb2MoJyglMjJtYWdhemluZSUyMGNvdmVyJTIwb2YlMjBhJTIwZG5kY292ZXJhcnQlMjBkcmFnb24lMkMlMjBoaWdoJTIwcXVhbGl0eSUyQyUyMGludHJpY2F0ZSUyMGRldGFpbHMlMkMlMjBsYXJyeSUyMGVsbW9yZSUyMGFydCUyMHN0eWxlJTIyKS5hbmQoKScpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdF9lbWJlZHMlM0Rwcm9tcHRfZW1iZWRzKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`compel_proc = Compel(tokenizer=pipe.tokenizer, text_encoder=pipe.text_encoder)
prompt_embeds = compel_proc(<span class="hljs-string">&#x27;(&quot;magazine cover of a dndcoverart dragon, high quality, intricate details, larry elmore art style&quot;).and()&#x27;</span>)
image = pipe(prompt_embeds=prompt_embeds).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),ze=new T({props:{title:"Stable Diffusion XL",local:"stable-diffusion-xl",headingTag:"h3"}}),Ae=new f({props:{code:"ZnJvbSUyMGNvbXBlbCUyMGltcG9ydCUyMENvbXBlbCUyQyUyMFJldHVybmVkRW1iZWRkaW5nc1R5cGUlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbWFrZV9pbWFnZV9ncmlkJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMEElMjAlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUwQSUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEElMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBY29tcGVsJTIwJTNEJTIwQ29tcGVsKCUwQSUyMCUyMHRva2VuaXplciUzRCU1QnBpcGVsaW5lLnRva2VuaXplciUyQyUyMHBpcGVsaW5lLnRva2VuaXplcl8yJTVEJTIwJTJDJTBBJTIwJTIwdGV4dF9lbmNvZGVyJTNEJTVCcGlwZWxpbmUudGV4dF9lbmNvZGVyJTJDJTIwcGlwZWxpbmUudGV4dF9lbmNvZGVyXzIlNUQlMkMlMEElMjAlMjByZXR1cm5lZF9lbWJlZGRpbmdzX3R5cGUlM0RSZXR1cm5lZEVtYmVkZGluZ3NUeXBlLlBFTlVMVElNQVRFX0hJRERFTl9TVEFURVNfTk9OX05PUk1BTElaRUQlMkMlMEElMjAlMjByZXF1aXJlc19wb29sZWQlM0QlNUJGYWxzZSUyQyUyMFRydWUlNUQlMEEp",highlighted:`<span class="hljs-keyword">from</span> compel <span class="hljs-keyword">import</span> Compel, ReturnedEmbeddingsType
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid
<span class="hljs-keyword">import</span> torch

pipeline = DiffusionPipeline.from_pretrained(
  <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
  variant=<span class="hljs-string">&quot;fp16&quot;</span>,
  use_safetensors=<span class="hljs-literal">True</span>,
  torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

compel = Compel(
  tokenizer=[pipeline.tokenizer, pipeline.tokenizer_2] ,
  text_encoder=[pipeline.text_encoder, pipeline.text_encoder_2],
  returned_embeddings_type=ReturnedEmbeddingsType.PENULTIMATE_HIDDEN_STATES_NON_NORMALIZED,
  requires_pooled=[<span class="hljs-literal">False</span>, <span class="hljs-literal">True</span>]
)`,wrap:!1}}),De=new f({props:{code:"JTIzJTIwYXBwbHklMjB3ZWlnaHRzJTBBcHJvbXB0JTIwJTNEJTIwJTVCJTIyYSUyMHJlZCUyMGNhdCUyMHBsYXlpbmclMjB3aXRoJTIwYSUyMChiYWxsKTEuNSUyMiUyQyUyMCUyMmElMjByZWQlMjBjYXQlMjBwbGF5aW5nJTIwd2l0aCUyMGElMjAoYmFsbCkwLjYlMjIlNUQlMEFjb25kaXRpb25pbmclMkMlMjBwb29sZWQlMjAlM0QlMjBjb21wZWwocHJvbXB0KSUwQSUwQSUyMyUyMGdlbmVyYXRlJTIwaW1hZ2UlMEFnZW5lcmF0b3IlMjAlM0QlMjAlNUJ0b3JjaC5HZW5lcmF0b3IoKS5tYW51YWxfc2VlZCgzMyklMjBmb3IlMjBfJTIwaW4lMjByYW5nZShsZW4ocHJvbXB0KSklNUQlMEFpbWFnZXMlMjAlM0QlMjBwaXBlbGluZShwcm9tcHRfZW1iZWRzJTNEY29uZGl0aW9uaW5nJTJDJTIwcG9vbGVkX3Byb21wdF9lbWJlZHMlM0Rwb29sZWQlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMzApLmltYWdlcyUwQW1ha2VfaW1hZ2VfZ3JpZChpbWFnZXMlMkMlMjByb3dzJTNEMSUyQyUyMGNvbHMlM0QyKQ==",highlighted:`<span class="hljs-comment"># apply weights</span>
prompt = [<span class="hljs-string">&quot;a red cat playing with a (ball)1.5&quot;</span>, <span class="hljs-string">&quot;a red cat playing with a (ball)0.6&quot;</span>]
conditioning, pooled = compel(prompt)

<span class="hljs-comment"># generate image</span>
generator = [torch.Generator().manual_seed(<span class="hljs-number">33</span>) <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(prompt))]
images = pipeline(prompt_embeds=conditioning, pooled_prompt_embeds=pooled, generator=generator, num_inference_steps=<span class="hljs-number">30</span>).images
make_image_grid(images, rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),Pe=new Gl({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/weighted_prompts.md"}}),{c(){r=i("meta"),J=a(),h=i("p"),b=a(),c(q.$$.fragment),Oe=a(),c(x.$$.fragment),et=a(),H=i("p"),H.textContent=ks,tt=a(),Q=i("p"),Q.textContent=_s,st=a(),c(N.$$.fragment),lt=a(),c(U.$$.fragment),at=a(),Y=i("p"),Y.textContent=Gs,nt=a(),F=i("ol"),F.innerHTML=Xs,it=a(),j=i("div"),j.innerHTML=$s,ot=a(),c(E.$$.fragment),pt=a(),z=i("p"),z.textContent=Vs,rt=a(),S=i("p"),S.textContent=Rs,ct=a(),c(I.$$.fragment),mt=a(),A=i("p"),A.innerHTML=qs,Mt=a(),c(L.$$.fragment),dt=a(),D=i("p"),D.innerHTML=xs,yt=a(),c(P.$$.fragment),ut=a(),K=i("p"),K.innerHTML=Hs,ht=a(),c(O.$$.fragment),ft=a(),ee=i("p"),ee.innerHTML=Qs,Jt=a(),c(te.$$.fragment),wt=a(),se=i("p"),se.innerHTML=Ns,bt=a(),c(le.$$.fragment),gt=a(),ae=i("p"),ae.innerHTML=Ys,Tt=a(),c(ne.$$.fragment),Ut=a(),ie=i("p"),ie.innerHTML=Fs,jt=a(),c(oe.$$.fragment),It=a(),Z=i("div"),Z.innerHTML=Es,Zt=a(),c(pe.$$.fragment),Wt=a(),re=i("p"),re.innerHTML=zs,Ct=a(),ce=i("p"),ce.innerHTML=Ss,vt=a(),c(W.$$.fragment),Bt=a(),me=i("p"),me.textContent=As,kt=a(),Me=i("p"),Me.textContent=Ls,_t=a(),c(de.$$.fragment),Gt=a(),ye=i("p"),ye.innerHTML=Ds,Xt=a(),c(ue.$$.fragment),$t=a(),C=i("div"),C.innerHTML=Ps,Vt=a(),c(he.$$.fragment),Rt=a(),fe=i("p"),fe.innerHTML=Ks,qt=a(),c(Je.$$.fragment),xt=a(),we=i("p"),we.innerHTML=Os,Ht=a(),c(v.$$.fragment),Qt=a(),c(be.$$.fragment),Nt=a(),ge=i("p"),ge.innerHTML=el,Yt=a(),c(Te.$$.fragment),Ft=a(),B=i("div"),B.innerHTML=tl,Et=a(),Ue=i("p"),Ue.innerHTML=sl,zt=a(),c(je.$$.fragment),St=a(),k=i("div"),k.innerHTML=ll,At=a(),Ie=i("p"),Ie.textContent=al,Lt=a(),c(Ze.$$.fragment),Dt=a(),_=i("div"),_.innerHTML=nl,Pt=a(),c(We.$$.fragment),Kt=a(),Ce=i("p"),Ce.innerHTML=il,Ot=a(),c(ve.$$.fragment),es=a(),G=i("div"),G.innerHTML=ol,ts=a(),c(Be.$$.fragment),ss=a(),ke=i("p"),ke.innerHTML=pl,ls=a(),c(_e.$$.fragment),as=a(),X=i("div"),X.innerHTML=rl,ns=a(),c(Ge.$$.fragment),is=a(),Xe=i("p"),Xe.innerHTML=cl,os=a(),$e=i("p"),$e.innerHTML=ml,ps=a(),c(Ve.$$.fragment),rs=a(),Re=i("p"),Re.innerHTML=Ml,cs=a(),c(qe.$$.fragment),ms=a(),xe=i("p"),xe.innerHTML=dl,Ms=a(),c(He.$$.fragment),ds=a(),$=i("div"),$.innerHTML=yl,ys=a(),c(Qe.$$.fragment),us=a(),Ne=i("p"),Ne.innerHTML=ul,hs=a(),c(Ye.$$.fragment),fs=a(),Fe=i("p"),Fe.innerHTML=hl,Js=a(),c(Ee.$$.fragment),ws=a(),V=i("div"),V.innerHTML=fl,bs=a(),c(ze.$$.fragment),gs=a(),Se=i("p"),Se.innerHTML=Jl,Ts=a(),c(Ae.$$.fragment),Us=a(),Le=i("p"),Le.innerHTML=wl,js=a(),c(De.$$.fragment),Is=a(),R=i("div"),R.innerHTML=bl,Zs=a(),c(Pe.$$.fragment),Ws=a(),Ke=i("p"),this.h()},l(e){const t=Bl("svelte-u9bgzb",document.head);r=o(t,"META",{name:!0,content:!0}),t.forEach(s),J=n(e),h=o(e,"P",{}),Il(h).forEach(s),b=n(e),m(q.$$.fragment,e),Oe=n(e),m(x.$$.fragment,e),et=n(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1kbqxv6"&&(H.textContent=ks),tt=n(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-6johch"&&(Q.textContent=_s),st=n(e),m(N.$$.fragment,e),lt=n(e),m(U.$$.fragment,e),at=n(e),Y=o(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1c7rxt1"&&(Y.textContent=Gs),nt=n(e),F=o(e,"OL",{"data-svelte-h":!0}),p(F)!=="svelte-1cs1rnw"&&(F.innerHTML=Xs),it=n(e),j=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(j)!=="svelte-ahartp"&&(j.innerHTML=$s),ot=n(e),m(E.$$.fragment,e),pt=n(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-dttsfg"&&(z.textContent=Vs),rt=n(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-j8rp3s"&&(S.textContent=Rs),ct=n(e),m(I.$$.fragment,e),mt=n(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-l7cdn9"&&(A.innerHTML=qs),Mt=n(e),m(L.$$.fragment,e),dt=n(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-i0sn10"&&(D.innerHTML=xs),yt=n(e),m(P.$$.fragment,e),ut=n(e),K=o(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-117it8a"&&(K.innerHTML=Hs),ht=n(e),m(O.$$.fragment,e),ft=n(e),ee=o(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-3e511v"&&(ee.innerHTML=Qs),Jt=n(e),m(te.$$.fragment,e),wt=n(e),se=o(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-1kowtsg"&&(se.innerHTML=Ns),bt=n(e),m(le.$$.fragment,e),gt=n(e),ae=o(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-r4gy79"&&(ae.innerHTML=Ys),Tt=n(e),m(ne.$$.fragment,e),Ut=n(e),ie=o(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-14szpok"&&(ie.innerHTML=Fs),jt=n(e),m(oe.$$.fragment,e),It=n(e),Z=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(Z)!=="svelte-12k1k80"&&(Z.innerHTML=Es),Zt=n(e),m(pe.$$.fragment,e),Wt=n(e),re=o(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-1tre73w"&&(re.innerHTML=zs),Ct=n(e),ce=o(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-4ar53f"&&(ce.innerHTML=Ss),vt=n(e),m(W.$$.fragment,e),Bt=n(e),me=o(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-xw5jy8"&&(me.textContent=As),kt=n(e),Me=o(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-1tbon0u"&&(Me.textContent=Ls),_t=n(e),m(de.$$.fragment,e),Gt=n(e),ye=o(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-172qqyu"&&(ye.innerHTML=Ds),Xt=n(e),m(ue.$$.fragment,e),$t=n(e),C=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(C)!=="svelte-1brza9b"&&(C.innerHTML=Ps),Vt=n(e),m(he.$$.fragment,e),Rt=n(e),fe=o(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-137cdqc"&&(fe.innerHTML=Ks),qt=n(e),m(Je.$$.fragment,e),xt=n(e),we=o(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-18ay2r3"&&(we.innerHTML=Os),Ht=n(e),m(v.$$.fragment,e),Qt=n(e),m(be.$$.fragment,e),Nt=n(e),ge=o(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-vulem2"&&(ge.innerHTML=el),Yt=n(e),m(Te.$$.fragment,e),Ft=n(e),B=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(B)!=="svelte-17zkpq4"&&(B.innerHTML=tl),Et=n(e),Ue=o(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-gxkdpi"&&(Ue.innerHTML=sl),zt=n(e),m(je.$$.fragment,e),St=n(e),k=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(k)!=="svelte-1d7lfen"&&(k.innerHTML=ll),At=n(e),Ie=o(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-1f6exw0"&&(Ie.textContent=al),Lt=n(e),m(Ze.$$.fragment,e),Dt=n(e),_=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(_)!=="svelte-1qezu4q"&&(_.innerHTML=nl),Pt=n(e),m(We.$$.fragment,e),Kt=n(e),Ce=o(e,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-1oxm60"&&(Ce.innerHTML=il),Ot=n(e),m(ve.$$.fragment,e),es=n(e),G=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(G)!=="svelte-8v41o8"&&(G.innerHTML=ol),ts=n(e),m(Be.$$.fragment,e),ss=n(e),ke=o(e,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-tjkp7t"&&(ke.innerHTML=pl),ls=n(e),m(_e.$$.fragment,e),as=n(e),X=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(X)!=="svelte-1ycuwub"&&(X.innerHTML=rl),ns=n(e),m(Ge.$$.fragment,e),is=n(e),Xe=o(e,"P",{"data-svelte-h":!0}),p(Xe)!=="svelte-lcas44"&&(Xe.innerHTML=cl),os=n(e),$e=o(e,"P",{"data-svelte-h":!0}),p($e)!=="svelte-1vv35fo"&&($e.innerHTML=ml),ps=n(e),m(Ve.$$.fragment,e),rs=n(e),Re=o(e,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-h0g1y9"&&(Re.innerHTML=Ml),cs=n(e),m(qe.$$.fragment,e),ms=n(e),xe=o(e,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-1fkpura"&&(xe.innerHTML=dl),Ms=n(e),m(He.$$.fragment,e),ds=n(e),$=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p($)!=="svelte-1awripq"&&($.innerHTML=yl),ys=n(e),m(Qe.$$.fragment,e),us=n(e),Ne=o(e,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-12rvdwg"&&(Ne.innerHTML=ul),hs=n(e),m(Ye.$$.fragment,e),fs=n(e),Fe=o(e,"P",{"data-svelte-h":!0}),p(Fe)!=="svelte-1le33cx"&&(Fe.innerHTML=hl),Js=n(e),m(Ee.$$.fragment,e),ws=n(e),V=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(V)!=="svelte-zvft88"&&(V.innerHTML=fl),bs=n(e),m(ze.$$.fragment,e),gs=n(e),Se=o(e,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-xo93eu"&&(Se.innerHTML=Jl),Ts=n(e),m(Ae.$$.fragment,e),Us=n(e),Le=o(e,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-1cznnp3"&&(Le.innerHTML=wl),js=n(e),m(De.$$.fragment,e),Is=n(e),R=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(R)!=="svelte-idvlgw"&&(R.innerHTML=bl),Zs=n(e),m(Pe.$$.fragment,e),Ws=n(e),Ke=o(e,"P",{}),Il(Ke).forEach(s),this.h()},h(){w(r,"name","hf:doc:metadata"),w(r,"content",xl),w(j,"class","flex gap-4"),w(Z,"class","flex gap-4"),w(C,"class","flex justify-center"),w(B,"class","flex justify-center"),w(k,"class","flex justify-center"),w(_,"class","flex justify-center"),w(G,"class","flex justify-center"),w(X,"class","flex justify-center"),w($,"class","flex justify-center"),w(V,"class","flex justify-center"),w(R,"class","flex gap-4")},m(e,t){kl(document.head,r),l(e,J,t),l(e,h,t),l(e,b,t),M(q,e,t),l(e,Oe,t),M(x,e,t),l(e,et,t),l(e,H,t),l(e,tt,t),l(e,Q,t),l(e,st,t),M(N,e,t),l(e,lt,t),M(U,e,t),l(e,at,t),l(e,Y,t),l(e,nt,t),l(e,F,t),l(e,it,t),l(e,j,t),l(e,ot,t),M(E,e,t),l(e,pt,t),l(e,z,t),l(e,rt,t),l(e,S,t),l(e,ct,t),M(I,e,t),l(e,mt,t),l(e,A,t),l(e,Mt,t),M(L,e,t),l(e,dt,t),l(e,D,t),l(e,yt,t),M(P,e,t),l(e,ut,t),l(e,K,t),l(e,ht,t),M(O,e,t),l(e,ft,t),l(e,ee,t),l(e,Jt,t),M(te,e,t),l(e,wt,t),l(e,se,t),l(e,bt,t),M(le,e,t),l(e,gt,t),l(e,ae,t),l(e,Tt,t),M(ne,e,t),l(e,Ut,t),l(e,ie,t),l(e,jt,t),M(oe,e,t),l(e,It,t),l(e,Z,t),l(e,Zt,t),M(pe,e,t),l(e,Wt,t),l(e,re,t),l(e,Ct,t),l(e,ce,t),l(e,vt,t),M(W,e,t),l(e,Bt,t),l(e,me,t),l(e,kt,t),l(e,Me,t),l(e,_t,t),M(de,e,t),l(e,Gt,t),l(e,ye,t),l(e,Xt,t),M(ue,e,t),l(e,$t,t),l(e,C,t),l(e,Vt,t),M(he,e,t),l(e,Rt,t),l(e,fe,t),l(e,qt,t),M(Je,e,t),l(e,xt,t),l(e,we,t),l(e,Ht,t),M(v,e,t),l(e,Qt,t),M(be,e,t),l(e,Nt,t),l(e,ge,t),l(e,Yt,t),M(Te,e,t),l(e,Ft,t),l(e,B,t),l(e,Et,t),l(e,Ue,t),l(e,zt,t),M(je,e,t),l(e,St,t),l(e,k,t),l(e,At,t),l(e,Ie,t),l(e,Lt,t),M(Ze,e,t),l(e,Dt,t),l(e,_,t),l(e,Pt,t),M(We,e,t),l(e,Kt,t),l(e,Ce,t),l(e,Ot,t),M(ve,e,t),l(e,es,t),l(e,G,t),l(e,ts,t),M(Be,e,t),l(e,ss,t),l(e,ke,t),l(e,ls,t),M(_e,e,t),l(e,as,t),l(e,X,t),l(e,ns,t),M(Ge,e,t),l(e,is,t),l(e,Xe,t),l(e,os,t),l(e,$e,t),l(e,ps,t),M(Ve,e,t),l(e,rs,t),l(e,Re,t),l(e,cs,t),M(qe,e,t),l(e,ms,t),l(e,xe,t),l(e,Ms,t),M(He,e,t),l(e,ds,t),l(e,$,t),l(e,ys,t),M(Qe,e,t),l(e,us,t),l(e,Ne,t),l(e,hs,t),M(Ye,e,t),l(e,fs,t),l(e,Fe,t),l(e,Js,t),M(Ee,e,t),l(e,ws,t),l(e,V,t),l(e,bs,t),M(ze,e,t),l(e,gs,t),l(e,Se,t),l(e,Ts,t),M(Ae,e,t),l(e,Us,t),l(e,Le,t),l(e,js,t),M(De,e,t),l(e,Is,t),l(e,R,t),l(e,Zs,t),M(Pe,e,t),l(e,Ws,t),l(e,Ke,t),Cs=!0},p(e,[t]){const gl={};t&2&&(gl.$$scope={dirty:t,ctx:e}),U.$set(gl);const Tl={};t&2&&(Tl.$$scope={dirty:t,ctx:e}),I.$set(Tl);const Ul={};t&2&&(Ul.$$scope={dirty:t,ctx:e}),W.$set(Ul);const jl={};t&2&&(jl.$$scope={dirty:t,ctx:e}),v.$set(jl)},i(e){Cs||(d(q.$$.fragment,e),d(x.$$.fragment,e),d(N.$$.fragment,e),d(U.$$.fragment,e),d(E.$$.fragment,e),d(I.$$.fragment,e),d(L.$$.fragment,e),d(P.$$.fragment,e),d(O.$$.fragment,e),d(te.$$.fragment,e),d(le.$$.fragment,e),d(ne.$$.fragment,e),d(oe.$$.fragment,e),d(pe.$$.fragment,e),d(W.$$.fragment,e),d(de.$$.fragment,e),d(ue.$$.fragment,e),d(he.$$.fragment,e),d(Je.$$.fragment,e),d(v.$$.fragment,e),d(be.$$.fragment,e),d(Te.$$.fragment,e),d(je.$$.fragment,e),d(Ze.$$.fragment,e),d(We.$$.fragment,e),d(ve.$$.fragment,e),d(Be.$$.fragment,e),d(_e.$$.fragment,e),d(Ge.$$.fragment,e),d(Ve.$$.fragment,e),d(qe.$$.fragment,e),d(He.$$.fragment,e),d(Qe.$$.fragment,e),d(Ye.$$.fragment,e),d(Ee.$$.fragment,e),d(ze.$$.fragment,e),d(Ae.$$.fragment,e),d(De.$$.fragment,e),d(Pe.$$.fragment,e),Cs=!0)},o(e){y(q.$$.fragment,e),y(x.$$.fragment,e),y(N.$$.fragment,e),y(U.$$.fragment,e),y(E.$$.fragment,e),y(I.$$.fragment,e),y(L.$$.fragment,e),y(P.$$.fragment,e),y(O.$$.fragment,e),y(te.$$.fragment,e),y(le.$$.fragment,e),y(ne.$$.fragment,e),y(oe.$$.fragment,e),y(pe.$$.fragment,e),y(W.$$.fragment,e),y(de.$$.fragment,e),y(ue.$$.fragment,e),y(he.$$.fragment,e),y(Je.$$.fragment,e),y(v.$$.fragment,e),y(be.$$.fragment,e),y(Te.$$.fragment,e),y(je.$$.fragment,e),y(Ze.$$.fragment,e),y(We.$$.fragment,e),y(ve.$$.fragment,e),y(Be.$$.fragment,e),y(_e.$$.fragment,e),y(Ge.$$.fragment,e),y(Ve.$$.fragment,e),y(qe.$$.fragment,e),y(He.$$.fragment,e),y(Qe.$$.fragment,e),y(Ye.$$.fragment,e),y(Ee.$$.fragment,e),y(ze.$$.fragment,e),y(Ae.$$.fragment,e),y(De.$$.fragment,e),y(Pe.$$.fragment,e),Cs=!1},d(e){e&&(s(J),s(h),s(b),s(Oe),s(et),s(H),s(tt),s(Q),s(st),s(lt),s(at),s(Y),s(nt),s(F),s(it),s(j),s(ot),s(pt),s(z),s(rt),s(S),s(ct),s(mt),s(A),s(Mt),s(dt),s(D),s(yt),s(ut),s(K),s(ht),s(ft),s(ee),s(Jt),s(wt),s(se),s(bt),s(gt),s(ae),s(Tt),s(Ut),s(ie),s(jt),s(It),s(Z),s(Zt),s(Wt),s(re),s(Ct),s(ce),s(vt),s(Bt),s(me),s(kt),s(Me),s(_t),s(Gt),s(ye),s(Xt),s($t),s(C),s(Vt),s(Rt),s(fe),s(qt),s(xt),s(we),s(Ht),s(Qt),s(Nt),s(ge),s(Yt),s(Ft),s(B),s(Et),s(Ue),s(zt),s(St),s(k),s(At),s(Ie),s(Lt),s(Dt),s(_),s(Pt),s(Kt),s(Ce),s(Ot),s(es),s(G),s(ts),s(ss),s(ke),s(ls),s(as),s(X),s(ns),s(is),s(Xe),s(os),s($e),s(ps),s(rs),s(Re),s(cs),s(ms),s(xe),s(Ms),s(ds),s($),s(ys),s(us),s(Ne),s(hs),s(fs),s(Fe),s(Js),s(ws),s(V),s(bs),s(gs),s(Se),s(Ts),s(Us),s(Le),s(js),s(Is),s(R),s(Zs),s(Ws),s(Ke)),s(r),u(q,e),u(x,e),u(N,e),u(U,e),u(E,e),u(I,e),u(L,e),u(P,e),u(O,e),u(te,e),u(le,e),u(ne,e),u(oe,e),u(pe,e),u(W,e),u(de,e),u(ue,e),u(he,e),u(Je,e),u(v,e),u(be,e),u(Te,e),u(je,e),u(Ze,e),u(We,e),u(ve,e),u(Be,e),u(_e,e),u(Ge,e),u(Ve,e),u(qe,e),u(He,e),u(Qe,e),u(Ye,e),u(Ee,e),u(ze,e),u(Ae,e),u(De,e),u(Pe,e)}}}const xl='{"title":"Prompt techniques","local":"prompt-techniques","sections":[{"title":"Prompt engineering","local":"prompt-engineering","sections":[],"depth":2},{"title":"Prompt enhancing with GPT2","local":"prompt-enhancing-with-gpt2","sections":[],"depth":2},{"title":"Prompt weighting","local":"prompt-weighting","sections":[{"title":"Weighting","local":"weighting","sections":[],"depth":3},{"title":"Blending","local":"blending","sections":[],"depth":3},{"title":"Conjunction","local":"conjunction","sections":[],"depth":3},{"title":"Textual inversion","local":"textual-inversion","sections":[],"depth":3},{"title":"DreamBooth","local":"dreambooth","sections":[],"depth":3},{"title":"Stable Diffusion XL","local":"stable-diffusion-xl","sections":[],"depth":3}],"depth":2}],"depth":1}';function Hl(g){return Wl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Sl extends Cl{constructor(r){super(),vl(this,r,Hl,ql,Zl,{})}}export{Sl as component};
