import{s as es,o as ls,n as ea}from"../chunks/scheduler.8c3d61f6.js";import{S as ts,i as as,g as i,s,r as o,A as ss,h as m,f as t,c as n,j as Oa,u as r,x as p,k as h,y as ns,a,v as c,d,t as g,w as y}from"../chunks/index.da70eac4.js";import{T as Ot}from"../chunks/Tip.1d9b8c37.js";import{C as b}from"../chunks/CodeBlock.00a903b3.js";import{D as is}from"../chunks/DocNotebookDropdown.02900f6b.js";import{H as f,E as ms}from"../chunks/EditOnGithub.1e64e623.js";function ps(w){let u,J='You’ll notice throughout the guide, we use <a href="/docs/diffusers/pr_10005/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> and <a href="/docs/diffusers/pr_10005/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_xformers_memory_efficient_attention">enable_xformers_memory_efficient_attention()</a>, to save memory and increase inference speed. If you’re using PyTorch 2.0, then you don’t need to call <a href="/docs/diffusers/pr_10005/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_xformers_memory_efficient_attention">enable_xformers_memory_efficient_attention()</a> on your pipeline because it’ll already be using PyTorch 2.0’s native <a href="../optimization/torch2.0#scaled-dot-product-attention">scaled-dot product attention</a>.';return{c(){u=i("p"),u.innerHTML=J},l(M){u=m(M,"P",{"data-svelte-h":!0}),p(u)!=="svelte-zkaaec"&&(u.innerHTML=J)},m(M,Z){a(M,u,Z)},p:ea,d(M){M&&t(u)}}}function os(w){let u,J="It is important to specify <code>output_type=&quot;latent&quot;</code> in the pipeline to keep all the outputs in latent space to avoid an unnecessary decode-encode step. This only works if the chained pipelines are using the same VAE.";return{c(){u=i("p"),u.innerHTML=J},l(M){u=m(M,"P",{"data-svelte-h":!0}),p(u)!=="svelte-185do9q"&&(u.innerHTML=J)},m(M,Z){a(M,u,Z)},p:ea,d(M){M&&t(u)}}}function rs(w){let u,J="It is important to specify <code>output_type=&quot;latent&quot;</code> in the pipeline to keep all the outputs in <em>latent</em> space to avoid an unnecessary decode-encode step. This only works if the chained pipelines are using the same VAE.";return{c(){u=i("p"),u.innerHTML=J},l(M){u=m(M,"P",{"data-svelte-h":!0}),p(u)!=="svelte-vp1871"&&(u.innerHTML=J)},m(M,Z){a(M,u,Z)},p:ea,d(M){M&&t(u)}}}function cs(w){let u,J,M,Z,Q,cl,$,dl,R,la='Image-to-image is similar to <a href="conditional_image_generation">text-to-image</a>, but in addition to a prompt, you can also pass an initial image as a starting point for the diffusion process. The initial image is encoded to latent space and noise is added to it. Then the latent diffusion model takes a prompt and the noisy latent image, predicts the added noise, and removes the predicted noise from the initial latent image to get the new latent image. Lastly, a decoder decodes the new latent image back into an image.',gl,S,ta="With 🤗 Diffusers, this is as easy as 1-2-3:",yl,C,aa='<li>Load a checkpoint into the <a href="/docs/diffusers/pr_10005/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForImage2Image">AutoPipelineForImage2Image</a> class; this pipeline automatically handles loading the correct pipeline class  based on the checkpoint:</li>',ul,Y,bl,U,Ml,T,sa="<li>Load an image to pass to the pipeline:</li>",fl,N,Jl,W,na="<li>Pass a prompt and image to the pipeline to generate an image:</li>",hl,H,Zl,G,ia='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/cat.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">initial image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',wl,z,Ul,E,ma='The most popular image-to-image models are <a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5" rel="nofollow">Stable Diffusion v1.5</a>, <a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">Stable Diffusion XL (SDXL)</a>, and <a href="https://huggingface.co/kandinsky-community/kandinsky-2-2-decoder" rel="nofollow">Kandinsky 2.2</a>. The results from the Stable Diffusion and Kandinsky models vary due to their architecture differences and training process; you can generally expect SDXL to produce higher quality images than Stable Diffusion v1.5. Let’s take a quick look at how to use each of these models and compare their results.',Tl,q,Wl,L,pa="Stable Diffusion v1.5 is a latent diffusion model initialized from an earlier checkpoint, and further finetuned for 595K steps on 512x512 images. To use this pipeline for image-to-image, you’ll need to prepare an initial image to pass to the pipeline. Then you can pass a prompt and the image to the pipeline to generate a new image:",Gl,D,jl,j,oa='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">initial image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-sdv1.5.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',vl,P,Il,A,ra='SDXL is a more powerful version of the Stable Diffusion model. It uses a larger base model, and an additional refiner model to increase the quality of the base model’s output. Read the <a href="sdxl">SDXL</a> guide for a more detailed walkthrough of how to use this model, and other techniques it uses to produce high quality images.',Bl,K,Vl,v,ca='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-sdxl-init.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">initial image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-sdxl.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',xl,O,_l,ee,da="The Kandinsky model is different from the Stable Diffusion models because it uses an image prior model to create image embeddings. The embeddings help create a better alignment between text and images, allowing the latent diffusion model to generate better images.",Xl,le,ga="The simplest way to use Kandinsky 2.2 is:",kl,te,Fl,I,ya='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">initial image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-kandinsky.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',Ql,ae,$l,se,ua="There are several important parameters you can configure in the pipeline that’ll affect the image generation process and image quality. Let’s take a closer look at what these parameters do and how changing them affects the output.",Rl,ne,Sl,ie,ba="<code>strength</code> is one of the most important parameters to consider and it’ll have a huge impact on your generated image. It determines how much the generated image resembles the initial image. In other words:",Cl,me,Ma="<li>📈 a higher <code>strength</code> value gives the model more “creativity” to generate an image that’s different from the initial image; a <code>strength</code> value of 1.0 means the initial image is more or less ignored</li> <li>📉 a lower <code>strength</code> value means the generated image is more similar to the initial image</li>",Yl,pe,fa="The <code>strength</code> and <code>num_inference_steps</code> parameters are related because <code>strength</code> determines the number of noise steps to add. For example, if the <code>num_inference_steps</code> is 50 and <code>strength</code> is 0.8, then this means adding 40 (50 * 0.8) steps of noise to the initial image and then denoising for 40 steps to get the newly generated image.",Nl,oe,Hl,B,Ja='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-strength-0.4.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">strength = 0.4</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-strength-0.6.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">strength = 0.6</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-strength-1.0.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">strength = 1.0</figcaption></div>',zl,re,El,ce,ha="The <code>guidance_scale</code> parameter is used to control how closely aligned the generated image and text prompt are. A higher <code>guidance_scale</code> value means your generated image is more aligned with the prompt, while a lower <code>guidance_scale</code> value means your generated image has more space to deviate from the prompt.",ql,de,Za="You can combine <code>guidance_scale</code> with <code>strength</code> for even more precise control over how expressive the model is. For example, combine a high <code>strength + guidance_scale</code> for maximum creativity or use a combination of low <code>strength</code> and low <code>guidance_scale</code> to generate an image that resembles the initial image but is not as strictly bound to the prompt.",Ll,ge,Dl,V,wa='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-guidance-0.1.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">guidance_scale = 0.1</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-guidance-3.0.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">guidance_scale = 5.0</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-guidance-7.5.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">guidance_scale = 10.0</figcaption></div>',Pl,ye,Al,ue,Ua="A negative prompt conditions the model to <em>not</em> include things in an image, and it can be used to improve image quality or modify an image. For example, you can improve image quality by including negative prompts like “poor details” or “blurry” to encourage the model to generate a higher quality image. Or you can modify an image by specifying things to exclude from an image.",Kl,be,Ol,x,Ta='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-negative-1.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">negative_prompt = &quot;ugly, deformed, disfigured, poor details, bad anatomy&quot;</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-negative-2.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">negative_prompt = &quot;jungle&quot;</figcaption></div>',et,Me,lt,fe,Wa="There are some other interesting ways you can use an image-to-image pipeline aside from just generating an image (although that is pretty cool too). You can take it a step further and chain it with other pipelines.",tt,Je,at,he,Ga="Chaining a text-to-image and image-to-image pipeline allows you to generate an image from text and use the generated image as the initial image for the image-to-image pipeline. This is useful if you want to generate an image entirely from scratch. For example, let’s chain a Stable Diffusion and a Kandinsky model.",st,Ze,ja="Start by generating an image with the text-to-image pipeline:",nt,we,it,Ue,va="Now you can pass this generated image to the image-to-image pipeline:",mt,Te,pt,We,ot,Ge,Ia="You can also chain multiple image-to-image pipelines together to create more interesting images. This can be useful for iteratively performing style transfer on an image, generating short GIFs, restoring color to an image, or restoring missing areas of an image.",rt,je,Ba="Start by generating an image:",ct,ve,dt,_,gt,Ie,Va='Pass the latent output from this pipeline to the next pipeline to generate an image in a <a href="https://huggingface.co/ogkalu/Comic-Diffusion" rel="nofollow">comic book art style</a>:',yt,Be,ut,Ve,xa='Repeat one more time to generate the final image in a <a href="https://huggingface.co/kohbanye/pixel-art-style" rel="nofollow">pixel art style</a>:',bt,xe,Mt,_e,ft,Xe,_a="Another way you can chain your image-to-image pipeline is with an upscaler and super-resolution pipeline to really increase the level of details in an image.",Jt,ke,Xa="Start with an image-to-image pipeline:",ht,Fe,Zt,X,wt,Qe,ka="Chain it to an upscaler pipeline to increase the image resolution:",Ut,$e,Tt,Re,Fa="Finally, chain it to a super-resolution pipeline to further enhance the resolution:",Wt,Se,Gt,Ce,jt,Ye,Qa="Trying to generate an image that looks exactly the way you want can be difficult, which is why controlled generation techniques and models are so useful. While you can use the <code>negative_prompt</code> to partially control image generation, there are more robust methods like prompt weighting and ControlNets.",vt,Ne,It,He,$a='Prompt weighting allows you to scale the representation of each concept in a prompt. For example, in a prompt like “Astronaut in a jungle, cold color palette, muted colors, detailed, 8k”, you can choose to increase or decrease the embeddings of “astronaut” and “jungle”. The <a href="https://github.com/damian0815/compel" rel="nofollow">Compel</a> library provides a simple syntax for adjusting prompt weights and generating the embeddings. You can learn how to create the embeddings in the <a href="weighted_prompts">Prompt weighting</a> guide.',Bt,ze,Ra='<a href="/docs/diffusers/pr_10005/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForImage2Image">AutoPipelineForImage2Image</a> has a <code>prompt_embeds</code> (and <code>negative_prompt_embeds</code> if you’re using a negative prompt) parameter where you can pass the embeddings which replaces the <code>prompt</code> parameter.',Vt,Ee,xt,qe,_t,Le,Sa="ControlNets provide a more flexible and accurate way to control image generation because you can use an additional conditioning image. The conditioning image can be a canny image, depth map, image segmentation, and even scribbles! Whatever type of conditioning image you choose, the ControlNet generates an image that preserves the information in it.",Xt,De,Ca="For example, let’s condition an image with a depth map to keep the spatial information in the image.",kt,Pe,Ft,Ae,Ya='Load a ControlNet model conditioned on depth maps and the <a href="/docs/diffusers/pr_10005/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForImage2Image">AutoPipelineForImage2Image</a>:',Qt,Ke,$t,Oe,Na="Now generate a new image conditioned on the depth map, initial image, and prompt:",Rt,el,St,k,Ha='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">initial image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/lllyasviel/control_v11f1p_sd15_depth/resolve/main/images/control.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">depth image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-controlnet.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">ControlNet image</figcaption></div>',Ct,ll,za='Let’s apply a new <a href="https://huggingface.co/nitrosocke/elden-ring-diffusion" rel="nofollow">style</a> to the image generated from the ControlNet by chaining it with an image-to-image pipeline:',Yt,tl,Nt,F,Ea='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-elden-ring.png"/>',Ht,al,zt,sl,qa='Running diffusion models is computationally expensive and intensive, but with a few optimization tricks, it is entirely possible to run them on consumer and free-tier GPUs. For example, you can use a more memory-efficient form of attention such as PyTorch 2.0’s <a href="../optimization/torch2.0#scaled-dot-product-attention">scaled-dot product attention</a> or <a href="../optimization/xformers">xFormers</a> (you can use one or the other, but there’s no need to use both). You can also offload the model to the GPU while the other pipeline components wait on the CPU.',Et,nl,qt,il,La='With <a href="../optimization/torch2.0#torchcompile"><code>torch.compile</code></a>, you can boost your inference speed even more by wrapping your UNet with it:',Lt,ml,Dt,pl,Da='To learn more, take a look at the <a href="../optimization/memory">Reduce memory usage</a> and <a href="../optimization/torch2.0">Torch 2.0</a> guides.',Pt,ol,At,rl,Kt;return Q=new f({props:{title:"Image-to-image",local:"image-to-image",headingTag:"h1"}}),$=new is({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/img2img.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/img2img.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/img2img.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/img2img.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/img2img.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/img2img.ipynb"}]}}),Y=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUyQyUyMG1ha2VfaW1hZ2VfZ3JpZCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0yLWRlY29kZXIlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweEZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIweW91JTIwaGF2ZSUyMFB5VG9yY2glMjAyLjAlMjBvciUyMGhpZ2hlciUyMGluc3RhbGxlZCUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()`,wrap:!1}}),U=new Ot({props:{$$slots:{default:[ps]},$$scope:{ctx:w}}}),N=new b({props:{code:"aW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGY2F0LnBuZyUyMik=",highlighted:'init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/cat.png&quot;</span>)',wrap:!1}}),H=new b({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyY2F0JTIwd2l6YXJkJTJDJTIwZ2FuZGFsZiUyQyUyMGxvcmQlMjBvZiUyMHRoZSUyMHJpbmdzJTJDJTIwZGV0YWlsZWQlMkMlMjBmYW50YXN5JTJDJTIwY3V0ZSUyQyUyMGFkb3JhYmxlJTJDJTIwUGl4YXIlMkMlMjBEaXNuZXklMkMlMjA4ayUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlKS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDIp",highlighted:`prompt = <span class="hljs-string">&quot;cat wizard, gandalf, lord of the rings, detailed, fantasy, cute, adorable, Pixar, Disney, 8k&quot;</span>
image = pipeline(prompt, image=init_image).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),z=new f({props:{title:"Popular models",local:"popular-models",headingTag:"h2"}}),q=new f({props:{title:"Stable Diffusion v1.5",local:"stable-diffusion-v15",headingTag:"h3"}}),D=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbWFrZV9pbWFnZV9ncmlkJTJDJTIwbG9hZF9pbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUyMyUyMHJlbW92ZSUyMGZvbGxvd2luZyUyMGxpbmUlMjBpZiUyMHhGb3JtZXJzJTIwaXMlMjBub3QlMjBpbnN0YWxsZWQlMjBvciUyMHlvdSUyMGhhdmUlMjBQeVRvcmNoJTIwMi4wJTIwb3IlMjBoaWdoZXIlMjBpbnN0YWxsZWQlMEFwaXBlbGluZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUwQSUyMyUyMHByZXBhcmUlMjBpbWFnZSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmltZzJpbWctaW5pdC5wbmclMjIlMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSh1cmwpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQSUwQSUyMyUyMHBhc3MlMjBwcm9tcHQlMjBhbmQlMjBpbWFnZSUyMHRvJTIwcGlwZWxpbmUlMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSkuaW1hZ2VzJTVCMCU1RCUwQW1ha2VfaW1hZ2VfZ3JpZCglNUJpbml0X2ltYWdlJTJDJTIwaW1hZ2UlNUQlMkMlMjByb3dzJTNEMSUyQyUyMGNvbHMlM0QyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid, load_image

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># prepare image</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png&quot;</span>
init_image = load_image(url)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>

<span class="hljs-comment"># pass prompt and image to pipeline</span>
image = pipeline(prompt, image=init_image).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),P=new f({props:{title:"Stable Diffusion XL (SDXL)",local:"stable-diffusion-xl-sdxl",headingTag:"h3"}}),K=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbWFrZV9pbWFnZV9ncmlkJTJDJTIwbG9hZF9pbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1yZWZpbmVyLTEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUyMyUyMHJlbW92ZSUyMGZvbGxvd2luZyUyMGxpbmUlMjBpZiUyMHhGb3JtZXJzJTIwaXMlMjBub3QlMjBpbnN0YWxsZWQlMjBvciUyMHlvdSUyMGhhdmUlMjBQeVRvcmNoJTIwMi4wJTIwb3IlMjBoaWdoZXIlMjBpbnN0YWxsZWQlMEFwaXBlbGluZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUwQSUyMyUyMHByZXBhcmUlMjBpbWFnZSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmltZzJpbWctc2R4bC1pbml0LnBuZyUyMiUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKHVybCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBc3Ryb25hdXQlMjBpbiUyMGElMjBqdW5nbGUlMkMlMjBjb2xkJTIwY29sb3IlMjBwYWxldHRlJTJDJTIwbXV0ZWQlMjBjb2xvcnMlMkMlMjBkZXRhaWxlZCUyQyUyMDhrJTIyJTBBJTBBJTIzJTIwcGFzcyUyMHByb21wdCUyMGFuZCUyMGltYWdlJTIwdG8lMjBwaXBlbGluZSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTIwc3RyZW5ndGglM0QwLjUpLmltYWdlcyU1QjAlNUQlMEFtYWtlX2ltYWdlX2dyaWQoJTVCaW5pdF9pbWFnZSUyQyUyMGltYWdlJTVEJTJDJTIwcm93cyUzRDElMkMlMjBjb2xzJTNEMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid, load_image

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-refiner-1.0&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># prepare image</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-sdxl-init.png&quot;</span>
init_image = load_image(url)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>

<span class="hljs-comment"># pass prompt and image to pipeline</span>
image = pipeline(prompt, image=init_image, strength=<span class="hljs-number">0.5</span>).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),O=new f({props:{title:"Kandinsky 2.2",local:"kandinsky-22",headingTag:"h3"}}),te=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbWFrZV9pbWFnZV9ncmlkJTJDJTIwbG9hZF9pbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0yLWRlY29kZXIlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweEZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIweW91JTIwaGF2ZSUyMFB5VG9yY2glMjAyLjAlMjBvciUyMGhpZ2hlciUyMGluc3RhbGxlZCUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBJTIzJTIwcHJlcGFyZSUyMGltYWdlJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaW1nMmltZy1pbml0LnBuZyUyMiUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKHVybCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBc3Ryb25hdXQlMjBpbiUyMGElMjBqdW5nbGUlMkMlMjBjb2xkJTIwY29sb3IlMjBwYWxldHRlJTJDJTIwbXV0ZWQlMjBjb2xvcnMlMkMlMjBkZXRhaWxlZCUyQyUyMDhrJTIyJTBBJTBBJTIzJTIwcGFzcyUyMHByb21wdCUyMGFuZCUyMGltYWdlJTIwdG8lMjBwaXBlbGluZSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlKS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid, load_image

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># prepare image</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png&quot;</span>
init_image = load_image(url)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>

<span class="hljs-comment"># pass prompt and image to pipeline</span>
image = pipeline(prompt, image=init_image).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),ae=new f({props:{title:"Configure pipeline parameters",local:"configure-pipeline-parameters",headingTag:"h2"}}),ne=new f({props:{title:"Strength",local:"strength",headingTag:"h3"}}),oe=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbWFrZV9pbWFnZV9ncmlkJTJDJTIwbG9hZF9pbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUyMyUyMHJlbW92ZSUyMGZvbGxvd2luZyUyMGxpbmUlMjBpZiUyMHhGb3JtZXJzJTIwaXMlMjBub3QlMjBpbnN0YWxsZWQlMjBvciUyMHlvdSUyMGhhdmUlMjBQeVRvcmNoJTIwMi4wJTIwb3IlMjBoaWdoZXIlMjBpbnN0YWxsZWQlMEFwaXBlbGluZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUwQSUyMyUyMHByZXBhcmUlMjBpbWFnZSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmltZzJpbWctaW5pdC5wbmclMjIlMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSh1cmwpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQSUwQSUyMyUyMHBhc3MlMjBwcm9tcHQlMjBhbmQlMjBpbWFnZSUyMHRvJTIwcGlwZWxpbmUlMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMHN0cmVuZ3RoJTNEMC44KS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid, load_image

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># prepare image</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png&quot;</span>
init_image = load_image(url)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>

<span class="hljs-comment"># pass prompt and image to pipeline</span>
image = pipeline(prompt, image=init_image, strength=<span class="hljs-number">0.8</span>).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),re=new f({props:{title:"Guidance scale",local:"guidance-scale",headingTag:"h3"}}),ge=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbWFrZV9pbWFnZV9ncmlkJTJDJTIwbG9hZF9pbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUyMyUyMHJlbW92ZSUyMGZvbGxvd2luZyUyMGxpbmUlMjBpZiUyMHhGb3JtZXJzJTIwaXMlMjBub3QlMjBpbnN0YWxsZWQlMjBvciUyMHlvdSUyMGhhdmUlMjBQeVRvcmNoJTIwMi4wJTIwb3IlMjBoaWdoZXIlMjBpbnN0YWxsZWQlMEFwaXBlbGluZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUwQSUyMyUyMHByZXBhcmUlMjBpbWFnZSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmltZzJpbWctaW5pdC5wbmclMjIlMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSh1cmwpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQSUwQSUyMyUyMHBhc3MlMjBwcm9tcHQlMjBhbmQlMjBpbWFnZSUyMHRvJTIwcGlwZWxpbmUlMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEOC4wKS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid, load_image

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># prepare image</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png&quot;</span>
init_image = load_image(url)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>

<span class="hljs-comment"># pass prompt and image to pipeline</span>
image = pipeline(prompt, image=init_image, guidance_scale=<span class="hljs-number">8.0</span>).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),ye=new f({props:{title:"Negative prompt",local:"negative-prompt",headingTag:"h3"}}),be=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbWFrZV9pbWFnZV9ncmlkJTJDJTIwbG9hZF9pbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1yZWZpbmVyLTEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUyMyUyMHJlbW92ZSUyMGZvbGxvd2luZyUyMGxpbmUlMjBpZiUyMHhGb3JtZXJzJTIwaXMlMjBub3QlMjBpbnN0YWxsZWQlMjBvciUyMHlvdSUyMGhhdmUlMjBQeVRvcmNoJTIwMi4wJTIwb3IlMjBoaWdoZXIlMjBpbnN0YWxsZWQlMEFwaXBlbGluZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUwQSUyMyUyMHByZXBhcmUlMjBpbWFnZSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmltZzJpbWctaW5pdC5wbmclMjIlMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSh1cmwpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQW5lZ2F0aXZlX3Byb21wdCUyMCUzRCUyMCUyMnVnbHklMkMlMjBkZWZvcm1lZCUyQyUyMGRpc2ZpZ3VyZWQlMkMlMjBwb29yJTIwZGV0YWlscyUyQyUyMGJhZCUyMGFuYXRvbXklMjIlMEElMEElMjMlMjBwYXNzJTIwcHJvbXB0JTIwYW5kJTIwaW1hZ2UlMjB0byUyMHBpcGVsaW5lJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBuZWdhdGl2ZV9wcm9tcHQlM0RuZWdhdGl2ZV9wcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UpLmltYWdlcyU1QjAlNUQlMEFtYWtlX2ltYWdlX2dyaWQoJTVCaW5pdF9pbWFnZSUyQyUyMGltYWdlJTVEJTJDJTIwcm93cyUzRDElMkMlMjBjb2xzJTNEMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid, load_image

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-refiner-1.0&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># prepare image</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png&quot;</span>
init_image = load_image(url)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
negative_prompt = <span class="hljs-string">&quot;ugly, deformed, disfigured, poor details, bad anatomy&quot;</span>

<span class="hljs-comment"># pass prompt and image to pipeline</span>
image = pipeline(prompt, negative_prompt=negative_prompt, image=init_image).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),Me=new f({props:{title:"Chained image-to-image pipelines",local:"chained-image-to-image-pipelines",headingTag:"h2"}}),Je=new f({props:{title:"Text-to-image-to-image",local:"text-to-image-to-image",headingTag:"h3"}}),we=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMkMlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMG1ha2VfaW1hZ2VfZ3JpZCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweEZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIweW91JTIwaGF2ZSUyMFB5VG9yY2glMjAyLjAlMjBvciUyMGhpZ2hlciUyMGluc3RhbGxlZCUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBdGV4dDJpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUyMkFzdHJvbmF1dCUyMGluJTIwYSUyMGp1bmdsZSUyQyUyMGNvbGQlMjBjb2xvciUyMHBhbGV0dGUlMkMlMjBtdXRlZCUyMGNvbG9ycyUyQyUyMGRldGFpbGVkJTJDJTIwOGslMjIpLmltYWdlcyU1QjAlNUQlMEF0ZXh0MmltYWdl",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image, AutoPipelineForImage2Image
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid

pipeline = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

text2image = pipeline(<span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>).images[<span class="hljs-number">0</span>]
text2image`,wrap:!1}}),Te=new b({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIya2FuZGluc2t5LWNvbW11bml0eSUyRmthbmRpbnNreS0yLTItZGVjb2RlciUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBcGlwZWxpbmUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMjMlMjByZW1vdmUlMjBmb2xsb3dpbmclMjBsaW5lJTIwaWYlMjB4Rm9ybWVycyUyMGlzJTIwbm90JTIwaW5zdGFsbGVkJTIwb3IlMjB5b3UlMjBoYXZlJTIwUHlUb3JjaCUyMDIuMCUyMG9yJTIwaGlnaGVyJTIwaW5zdGFsbGVkJTBBcGlwZWxpbmUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKCklMEElMEFpbWFnZTJpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUyMkFzdHJvbmF1dCUyMGluJTIwYSUyMGp1bmdsZSUyQyUyMGNvbGQlMjBjb2xvciUyMHBhbGV0dGUlMkMlMjBtdXRlZCUyMGNvbG9ycyUyQyUyMGRldGFpbGVkJTJDJTIwOGslMjIlMkMlMjBpbWFnZSUzRHRleHQyaW1hZ2UpLmltYWdlcyU1QjAlNUQlMEFtYWtlX2ltYWdlX2dyaWQoJTVCdGV4dDJpbWFnZSUyQyUyMGltYWdlMmltYWdlJTVEJTJDJTIwcm93cyUzRDElMkMlMjBjb2xzJTNEMik=",highlighted:`pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

image2image = pipeline(<span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>, image=text2image).images[<span class="hljs-number">0</span>]
make_image_grid([text2image, image2image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),We=new f({props:{title:"Image-to-image-to-image",local:"image-to-image-to-image",headingTag:"h3"}}),ve=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbWFrZV9pbWFnZV9ncmlkJTJDJTIwbG9hZF9pbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUyMyUyMHJlbW92ZSUyMGZvbGxvd2luZyUyMGxpbmUlMjBpZiUyMHhGb3JtZXJzJTIwaXMlMjBub3QlMjBpbnN0YWxsZWQlMjBvciUyMHlvdSUyMGhhdmUlMjBQeVRvcmNoJTIwMi4wJTIwb3IlMjBoaWdoZXIlMjBpbnN0YWxsZWQlMEFwaXBlbGluZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUwQSUyMyUyMHByZXBhcmUlMjBpbWFnZSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmltZzJpbWctaW5pdC5wbmclMjIlMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSh1cmwpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQSUwQSUyMyUyMHBhc3MlMjBwcm9tcHQlMjBhbmQlMjBpbWFnZSUyMHRvJTIwcGlwZWxpbmUlMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMG91dHB1dF90eXBlJTNEJTIybGF0ZW50JTIyKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid, load_image

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># prepare image</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png&quot;</span>
init_image = load_image(url)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>

<span class="hljs-comment"># pass prompt and image to pipeline</span>
image = pipeline(prompt, image=init_image, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),_=new Ot({props:{$$slots:{default:[os]},$$scope:{ctx:w}}}),Be=new b({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyb2drYWx1JTJGQ29taWMtRGlmZnVzaW9uJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweEZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIweW91JTIwaGF2ZSUyMFB5VG9yY2glMjAyLjAlMjBvciUyMGhpZ2hlciUyMGluc3RhbGxlZCUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBJTIzJTIwbmVlZCUyMHRvJTIwaW5jbHVkZSUyMHRoZSUyMHRva2VuJTIwJTIyY2hhcmxpZWJvJTIwYXJ0c3R5bGUlMjIlMjBpbiUyMHRoZSUyMHByb21wdCUyMHRvJTIwdXNlJTIwdGhpcyUyMGNoZWNrcG9pbnQlMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUyMkFzdHJvbmF1dCUyMGluJTIwYSUyMGp1bmdsZSUyQyUyMGNoYXJsaWVibyUyMGFydHN0eWxlJTIyJTJDJTIwaW1hZ2UlM0RpbWFnZSUyQyUyMG91dHB1dF90eXBlJTNEJTIybGF0ZW50JTIyKS5pbWFnZXMlNUIwJTVE",highlighted:`pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;ogkalu/Comic-Diffusion&quot;</span>, torch_dtype=torch.float16
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># need to include the token &quot;charliebo artstyle&quot; in the prompt to use this checkpoint</span>
image = pipeline(<span class="hljs-string">&quot;Astronaut in a jungle, charliebo artstyle&quot;</span>, image=image, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),xe=new b({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIya29oYmFueWUlMkZwaXhlbC1hcnQtc3R5bGUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZWxpbmUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMjMlMjByZW1vdmUlMjBmb2xsb3dpbmclMjBsaW5lJTIwaWYlMjB4Rm9ybWVycyUyMGlzJTIwbm90JTIwaW5zdGFsbGVkJTIwb3IlMjB5b3UlMjBoYXZlJTIwUHlUb3JjaCUyMDIuMCUyMG9yJTIwaGlnaGVyJTIwaW5zdGFsbGVkJTBBcGlwZWxpbmUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKCklMEElMEElMjMlMjBuZWVkJTIwdG8lMjBpbmNsdWRlJTIwdGhlJTIwdG9rZW4lMjAlMjJwaXhlbGFydHN0eWxlJTIyJTIwaW4lMjB0aGUlMjBwcm9tcHQlMjB0byUyMHVzZSUyMHRoaXMlMjBjaGVja3BvaW50JTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMjJBc3Ryb25hdXQlMjBpbiUyMGElMjBqdW5nbGUlMkMlMjBwaXhlbGFydHN0eWxlJTIyJTJDJTIwaW1hZ2UlM0RpbWFnZSkuaW1hZ2VzJTVCMCU1RCUwQW1ha2VfaW1hZ2VfZ3JpZCglNUJpbml0X2ltYWdlJTJDJTIwaW1hZ2UlNUQlMkMlMjByb3dzJTNEMSUyQyUyMGNvbHMlM0QyKQ==",highlighted:`pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;kohbanye/pixel-art-style&quot;</span>, torch_dtype=torch.float16
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># need to include the token &quot;pixelartstyle&quot; in the prompt to use this checkpoint</span>
image = pipeline(<span class="hljs-string">&quot;Astronaut in a jungle, pixelartstyle&quot;</span>, image=image).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),_e=new f({props:{title:"Image-to-upscaler-to-super-resolution",local:"image-to-upscaler-to-super-resolution",headingTag:"h3"}}),Fe=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbWFrZV9pbWFnZV9ncmlkJTJDJTIwbG9hZF9pbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUyMyUyMHJlbW92ZSUyMGZvbGxvd2luZyUyMGxpbmUlMjBpZiUyMHhGb3JtZXJzJTIwaXMlMjBub3QlMjBpbnN0YWxsZWQlMjBvciUyMHlvdSUyMGhhdmUlMjBQeVRvcmNoJTIwMi4wJTIwb3IlMjBoaWdoZXIlMjBpbnN0YWxsZWQlMEFwaXBlbGluZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUwQSUyMyUyMHByZXBhcmUlMjBpbWFnZSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmltZzJpbWctaW5pdC5wbmclMjIlMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSh1cmwpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQSUwQSUyMyUyMHBhc3MlMjBwcm9tcHQlMjBhbmQlMjBpbWFnZSUyMHRvJTIwcGlwZWxpbmUlMEFpbWFnZV8xJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTIwb3V0cHV0X3R5cGUlM0QlMjJsYXRlbnQlMjIpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid, load_image

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># prepare image</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png&quot;</span>
init_image = load_image(url)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>

<span class="hljs-comment"># pass prompt and image to pipeline</span>
image_1 = pipeline(prompt, image=init_image, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),X=new Ot({props:{$$slots:{default:[rs]},$$scope:{ctx:w}}}),$e=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkxhdGVudFVwc2NhbGVQaXBlbGluZSUwQSUwQXVwc2NhbGVyJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uTGF0ZW50VXBzY2FsZVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnNkLXgyLWxhdGVudC11cHNjYWxlciUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSklMEF1cHNjYWxlci5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQXVwc2NhbGVyLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBaW1hZ2VfMiUyMCUzRCUyMHVwc2NhbGVyKHByb21wdCUyQyUyMGltYWdlJTNEaW1hZ2VfMSUyQyUyMG91dHB1dF90eXBlJTNEJTIybGF0ZW50JTIyKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionLatentUpscalePipeline

upscaler = StableDiffusionLatentUpscalePipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/sd-x2-latent-upscaler&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
upscaler.enable_model_cpu_offload()
upscaler.enable_xformers_memory_efficient_attention()

image_2 = upscaler(prompt, image=image_1, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Se=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblVwc2NhbGVQaXBlbGluZSUwQSUwQXN1cGVyX3JlcyUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblVwc2NhbGVQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXg0LXVwc2NhbGVyJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKSUwQXN1cGVyX3Jlcy5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQXN1cGVyX3Jlcy5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUwQWltYWdlXzMlMjAlM0QlMjBzdXBlcl9yZXMocHJvbXB0JTJDJTIwaW1hZ2UlM0RpbWFnZV8yKS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBpbWFnZV8zLnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSklNUQlMkMlMjByb3dzJTNEMSUyQyUyMGNvbHMlM0QyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionUpscalePipeline

super_res = StableDiffusionUpscalePipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-x4-upscaler&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
super_res.enable_model_cpu_offload()
super_res.enable_xformers_memory_efficient_attention()

image_3 = super_res(prompt, image=image_2).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image_3.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),Ce=new f({props:{title:"Control image generation",local:"control-image-generation",headingTag:"h2"}}),Ne=new f({props:{title:"Prompt weighting",local:"prompt-weighting",headingTag:"h3"}}),Ee=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBcGlwZWxpbmUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMjMlMjByZW1vdmUlMjBmb2xsb3dpbmclMjBsaW5lJTIwaWYlMjB4Rm9ybWVycyUyMGlzJTIwbm90JTIwaW5zdGFsbGVkJTIwb3IlMjB5b3UlMjBoYXZlJTIwUHlUb3JjaCUyMDIuMCUyMG9yJTIwaGlnaGVyJTIwaW5zdGFsbGVkJTBBcGlwZWxpbmUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKCklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdF9lbWJlZHMlM0Rwcm9tcHRfZW1iZWRzJTJDJTIwJTIzJTIwZ2VuZXJhdGVkJTIwZnJvbSUyMENvbXBlbCUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdF9lbWJlZHMlM0RuZWdhdGl2ZV9wcm9tcHRfZW1iZWRzJTJDJTIwJTIzJTIwZ2VuZXJhdGVkJTIwZnJvbSUyMENvbXBlbCUwQSUyMCUyMCUyMCUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUwQSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

image = pipeline(prompt_embeds=prompt_embeds, <span class="hljs-comment"># generated from Compel</span>
    negative_prompt_embeds=negative_prompt_embeds, <span class="hljs-comment"># generated from Compel</span>
    image=init_image,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),qe=new f({props:{title:"ControlNet",local:"controlnet",headingTag:"h3"}}),Pe=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMkMlMjBtYWtlX2ltYWdlX2dyaWQlMEElMEElMjMlMjBwcmVwYXJlJTIwaW1hZ2UlMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpbWcyaW1nLWluaXQucG5nJTIyJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UodXJsKSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBpbml0X2ltYWdlLnJlc2l6ZSgoOTU4JTJDJTIwOTYwKSklMjAlMjMlMjByZXNpemUlMjB0byUyMGRlcHRoJTIwaW1hZ2UlMjBkaW1lbnNpb25zJTBBZGVwdGhfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZsbGx5YXN2aWVsJTJGY29udHJvbF92MTFmMXBfc2QxNV9kZXB0aCUyRnJlc29sdmUlMkZtYWluJTJGaW1hZ2VzJTJGY29udHJvbC5wbmclMjIpJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBkZXB0aF9pbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDIp",highlighted:`<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

<span class="hljs-comment"># prepare image</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png&quot;</span>
init_image = load_image(url)
init_image = init_image.resize((<span class="hljs-number">958</span>, <span class="hljs-number">960</span>)) <span class="hljs-comment"># resize to depth image dimensions</span>
depth_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/lllyasviel/control_v11f1p_sd15_depth/resolve/main/images/control.png&quot;</span>)
make_image_grid([init_image, depth_image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),Ke=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMENvbnRyb2xOZXRNb2RlbCUyQyUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBaW1wb3J0JTIwdG9yY2glMEElMEFjb250cm9sbmV0JTIwJTNEJTIwQ29udHJvbE5ldE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJsbGx5YXN2aWVsJTJGY29udHJvbF92MTFmMXBfc2QxNV9kZXB0aCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSklMEFwaXBlbGluZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjBjb250cm9sbmV0JTNEY29udHJvbG5ldCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUyMyUyMHJlbW92ZSUyMGZvbGxvd2luZyUyMGxpbmUlMjBpZiUyMHhGb3JtZXJzJTIwaXMlMjBub3QlMjBpbnN0YWxsZWQlMjBvciUyMHlvdSUyMGhhdmUlMjBQeVRvcmNoJTIwMi4wJTIwb3IlMjBoaWdoZXIlMjBpbnN0YWxsZWQlMEFwaXBlbGluZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> ControlNetModel, AutoPipelineForImage2Image
<span class="hljs-keyword">import</span> torch

controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/control_v11f1p_sd15_depth&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)
pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()`,wrap:!1}}),el=new b({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQWltYWdlX2NvbnRyb2xfbmV0JTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTIwY29udHJvbF9pbWFnZSUzRGRlcHRoX2ltYWdlKS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBkZXB0aF9pbWFnZSUyQyUyMGltYWdlX2NvbnRyb2xfbmV0JTVEJTJDJTIwcm93cyUzRDElMkMlMjBjb2xzJTNEMyk=",highlighted:`prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
image_control_net = pipeline(prompt, image=init_image, control_image=depth_image).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, depth_image, image_control_net], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`,wrap:!1}}),tl=new b({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybml0cm9zb2NrZSUyRmVsZGVuLXJpbmctZGlmZnVzaW9uJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweEZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIweW91JTIwaGF2ZSUyMFB5VG9yY2glMjAyLjAlMjBvciUyMGhpZ2hlciUyMGluc3RhbGxlZCUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyZWxkZW4lMjByaW5nJTIwc3R5bGUlMjBhc3Ryb25hdXQlMjBpbiUyMGElMjBqdW5nbGUlMjIlMjAlMjMlMjBpbmNsdWRlJTIwdGhlJTIwdG9rZW4lMjAlMjJlbGRlbiUyMHJpbmclMjBzdHlsZSUyMiUyMGluJTIwdGhlJTIwcHJvbXB0JTBBbmVnYXRpdmVfcHJvbXB0JTIwJTNEJTIwJTIydWdseSUyQyUyMGRlZm9ybWVkJTJDJTIwZGlzZmlndXJlZCUyQyUyMHBvb3IlMjBkZXRhaWxzJTJDJTIwYmFkJTIwYW5hdG9teSUyMiUwQSUwQWltYWdlX2VsZGVuX3JpbmclMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBuZWdhdGl2ZV9wcm9tcHQlM0RuZWdhdGl2ZV9wcm9tcHQlMkMlMjBpbWFnZSUzRGltYWdlX2NvbnRyb2xfbmV0JTJDJTIwc3RyZW5ndGglM0QwLjQ1JTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QxMC41KS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBkZXB0aF9pbWFnZSUyQyUyMGltYWdlX2NvbnRyb2xfbmV0JTJDJTIwaW1hZ2VfZWxkZW5fcmluZyU1RCUyQyUyMHJvd3MlM0QyJTJDJTIwY29scyUzRDIp",highlighted:`pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;nitrosocke/elden-ring-diffusion&quot;</span>, torch_dtype=torch.float16,
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

prompt = <span class="hljs-string">&quot;elden ring style astronaut in a jungle&quot;</span> <span class="hljs-comment"># include the token &quot;elden ring style&quot; in the prompt</span>
negative_prompt = <span class="hljs-string">&quot;ugly, deformed, disfigured, poor details, bad anatomy&quot;</span>

image_elden_ring = pipeline(prompt, negative_prompt=negative_prompt, image=image_control_net, strength=<span class="hljs-number">0.45</span>, guidance_scale=<span class="hljs-number">10.5</span>).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, depth_image, image_control_net, image_elden_ring], rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),al=new f({props:{title:"Optimize",local:"optimize",headingTag:"h2"}}),nl=new b({props:{code:"JTJCJTIwcGlwZWxpbmUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMkIlMjBwaXBlbGluZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKQ==",highlighted:`<span class="hljs-addition">+ pipeline.enable_model_cpu_offload()</span>
<span class="hljs-addition">+ pipeline.enable_xformers_memory_efficient_attention()</span>`,wrap:!1}}),ml=new b({props:{code:"cGlwZWxpbmUudW5ldCUyMCUzRCUyMHRvcmNoLmNvbXBpbGUocGlwZWxpbmUudW5ldCUyQyUyMG1vZGUlM0QlMjJyZWR1Y2Utb3ZlcmhlYWQlMjIlMkMlMjBmdWxsZ3JhcGglM0RUcnVlKQ==",highlighted:'pipeline.unet = torch.<span class="hljs-built_in">compile</span>(pipeline.unet, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)',wrap:!1}}),ol=new ms({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/img2img.md"}}),{c(){u=i("meta"),J=s(),M=i("p"),Z=s(),o(Q.$$.fragment),cl=s(),o($.$$.fragment),dl=s(),R=i("p"),R.innerHTML=la,gl=s(),S=i("p"),S.textContent=ta,yl=s(),C=i("ol"),C.innerHTML=aa,ul=s(),o(Y.$$.fragment),bl=s(),o(U.$$.fragment),Ml=s(),T=i("ol"),T.innerHTML=sa,fl=s(),o(N.$$.fragment),Jl=s(),W=i("ol"),W.innerHTML=na,hl=s(),o(H.$$.fragment),Zl=s(),G=i("div"),G.innerHTML=ia,wl=s(),o(z.$$.fragment),Ul=s(),E=i("p"),E.innerHTML=ma,Tl=s(),o(q.$$.fragment),Wl=s(),L=i("p"),L.textContent=pa,Gl=s(),o(D.$$.fragment),jl=s(),j=i("div"),j.innerHTML=oa,vl=s(),o(P.$$.fragment),Il=s(),A=i("p"),A.innerHTML=ra,Bl=s(),o(K.$$.fragment),Vl=s(),v=i("div"),v.innerHTML=ca,xl=s(),o(O.$$.fragment),_l=s(),ee=i("p"),ee.textContent=da,Xl=s(),le=i("p"),le.textContent=ga,kl=s(),o(te.$$.fragment),Fl=s(),I=i("div"),I.innerHTML=ya,Ql=s(),o(ae.$$.fragment),$l=s(),se=i("p"),se.textContent=ua,Rl=s(),o(ne.$$.fragment),Sl=s(),ie=i("p"),ie.innerHTML=ba,Cl=s(),me=i("ul"),me.innerHTML=Ma,Yl=s(),pe=i("p"),pe.innerHTML=fa,Nl=s(),o(oe.$$.fragment),Hl=s(),B=i("div"),B.innerHTML=Ja,zl=s(),o(re.$$.fragment),El=s(),ce=i("p"),ce.innerHTML=ha,ql=s(),de=i("p"),de.innerHTML=Za,Ll=s(),o(ge.$$.fragment),Dl=s(),V=i("div"),V.innerHTML=wa,Pl=s(),o(ye.$$.fragment),Al=s(),ue=i("p"),ue.innerHTML=Ua,Kl=s(),o(be.$$.fragment),Ol=s(),x=i("div"),x.innerHTML=Ta,et=s(),o(Me.$$.fragment),lt=s(),fe=i("p"),fe.textContent=Wa,tt=s(),o(Je.$$.fragment),at=s(),he=i("p"),he.textContent=Ga,st=s(),Ze=i("p"),Ze.textContent=ja,nt=s(),o(we.$$.fragment),it=s(),Ue=i("p"),Ue.textContent=va,mt=s(),o(Te.$$.fragment),pt=s(),o(We.$$.fragment),ot=s(),Ge=i("p"),Ge.textContent=Ia,rt=s(),je=i("p"),je.textContent=Ba,ct=s(),o(ve.$$.fragment),dt=s(),o(_.$$.fragment),gt=s(),Ie=i("p"),Ie.innerHTML=Va,yt=s(),o(Be.$$.fragment),ut=s(),Ve=i("p"),Ve.innerHTML=xa,bt=s(),o(xe.$$.fragment),Mt=s(),o(_e.$$.fragment),ft=s(),Xe=i("p"),Xe.textContent=_a,Jt=s(),ke=i("p"),ke.textContent=Xa,ht=s(),o(Fe.$$.fragment),Zt=s(),o(X.$$.fragment),wt=s(),Qe=i("p"),Qe.textContent=ka,Ut=s(),o($e.$$.fragment),Tt=s(),Re=i("p"),Re.textContent=Fa,Wt=s(),o(Se.$$.fragment),Gt=s(),o(Ce.$$.fragment),jt=s(),Ye=i("p"),Ye.innerHTML=Qa,vt=s(),o(Ne.$$.fragment),It=s(),He=i("p"),He.innerHTML=$a,Bt=s(),ze=i("p"),ze.innerHTML=Ra,Vt=s(),o(Ee.$$.fragment),xt=s(),o(qe.$$.fragment),_t=s(),Le=i("p"),Le.textContent=Sa,Xt=s(),De=i("p"),De.textContent=Ca,kt=s(),o(Pe.$$.fragment),Ft=s(),Ae=i("p"),Ae.innerHTML=Ya,Qt=s(),o(Ke.$$.fragment),$t=s(),Oe=i("p"),Oe.textContent=Na,Rt=s(),o(el.$$.fragment),St=s(),k=i("div"),k.innerHTML=Ha,Ct=s(),ll=i("p"),ll.innerHTML=za,Yt=s(),o(tl.$$.fragment),Nt=s(),F=i("div"),F.innerHTML=Ea,Ht=s(),o(al.$$.fragment),zt=s(),sl=i("p"),sl.innerHTML=qa,Et=s(),o(nl.$$.fragment),qt=s(),il=i("p"),il.innerHTML=La,Lt=s(),o(ml.$$.fragment),Dt=s(),pl=i("p"),pl.innerHTML=Da,Pt=s(),o(ol.$$.fragment),At=s(),rl=i("p"),this.h()},l(e){const l=ss("svelte-u9bgzb",document.head);u=m(l,"META",{name:!0,content:!0}),l.forEach(t),J=n(e),M=m(e,"P",{}),Oa(M).forEach(t),Z=n(e),r(Q.$$.fragment,e),cl=n(e),r($.$$.fragment,e),dl=n(e),R=m(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-190i437"&&(R.innerHTML=la),gl=n(e),S=m(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-18jurtu"&&(S.textContent=ta),yl=n(e),C=m(e,"OL",{"data-svelte-h":!0}),p(C)!=="svelte-w5ewrz"&&(C.innerHTML=aa),ul=n(e),r(Y.$$.fragment,e),bl=n(e),r(U.$$.fragment,e),Ml=n(e),T=m(e,"OL",{start:!0,"data-svelte-h":!0}),p(T)!=="svelte-1yttwto"&&(T.innerHTML=sa),fl=n(e),r(N.$$.fragment,e),Jl=n(e),W=m(e,"OL",{start:!0,"data-svelte-h":!0}),p(W)!=="svelte-17g0twj"&&(W.innerHTML=na),hl=n(e),r(H.$$.fragment,e),Zl=n(e),G=m(e,"DIV",{class:!0,"data-svelte-h":!0}),p(G)!=="svelte-192ix8m"&&(G.innerHTML=ia),wl=n(e),r(z.$$.fragment,e),Ul=n(e),E=m(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-c2zerw"&&(E.innerHTML=ma),Tl=n(e),r(q.$$.fragment,e),Wl=n(e),L=m(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-23k6o9"&&(L.textContent=pa),Gl=n(e),r(D.$$.fragment,e),jl=n(e),j=m(e,"DIV",{class:!0,"data-svelte-h":!0}),p(j)!=="svelte-muzf0t"&&(j.innerHTML=oa),vl=n(e),r(P.$$.fragment,e),Il=n(e),A=m(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-x0iv90"&&(A.innerHTML=ra),Bl=n(e),r(K.$$.fragment,e),Vl=n(e),v=m(e,"DIV",{class:!0,"data-svelte-h":!0}),p(v)!=="svelte-1ki51a7"&&(v.innerHTML=ca),xl=n(e),r(O.$$.fragment,e),_l=n(e),ee=m(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-c3e484"&&(ee.textContent=da),Xl=n(e),le=m(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-tfl439"&&(le.textContent=ga),kl=n(e),r(te.$$.fragment,e),Fl=n(e),I=m(e,"DIV",{class:!0,"data-svelte-h":!0}),p(I)!=="svelte-1tge0cq"&&(I.innerHTML=ya),Ql=n(e),r(ae.$$.fragment,e),$l=n(e),se=m(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-j0fbzb"&&(se.textContent=ua),Rl=n(e),r(ne.$$.fragment,e),Sl=n(e),ie=m(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-1bx3wp7"&&(ie.innerHTML=ba),Cl=n(e),me=m(e,"UL",{"data-svelte-h":!0}),p(me)!=="svelte-1oz5aud"&&(me.innerHTML=Ma),Yl=n(e),pe=m(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-wy7ow0"&&(pe.innerHTML=fa),Nl=n(e),r(oe.$$.fragment,e),Hl=n(e),B=m(e,"DIV",{class:!0,"data-svelte-h":!0}),p(B)!=="svelte-1hvatx7"&&(B.innerHTML=Ja),zl=n(e),r(re.$$.fragment,e),El=n(e),ce=m(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-mfa26b"&&(ce.innerHTML=ha),ql=n(e),de=m(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-1629z5b"&&(de.innerHTML=Za),Ll=n(e),r(ge.$$.fragment,e),Dl=n(e),V=m(e,"DIV",{class:!0,"data-svelte-h":!0}),p(V)!=="svelte-k63kz7"&&(V.innerHTML=wa),Pl=n(e),r(ye.$$.fragment,e),Al=n(e),ue=m(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-1qpoxoh"&&(ue.innerHTML=Ua),Kl=n(e),r(be.$$.fragment,e),Ol=n(e),x=m(e,"DIV",{class:!0,"data-svelte-h":!0}),p(x)!=="svelte-1fvp45w"&&(x.innerHTML=Ta),et=n(e),r(Me.$$.fragment,e),lt=n(e),fe=m(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-bxn4p5"&&(fe.textContent=Wa),tt=n(e),r(Je.$$.fragment,e),at=n(e),he=m(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-xxuxjq"&&(he.textContent=Ga),st=n(e),Ze=m(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-1edszux"&&(Ze.textContent=ja),nt=n(e),r(we.$$.fragment,e),it=n(e),Ue=m(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-3cniud"&&(Ue.textContent=va),mt=n(e),r(Te.$$.fragment,e),pt=n(e),r(We.$$.fragment,e),ot=n(e),Ge=m(e,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-1r5hoyw"&&(Ge.textContent=Ia),rt=n(e),je=m(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-19cg56z"&&(je.textContent=Ba),ct=n(e),r(ve.$$.fragment,e),dt=n(e),r(_.$$.fragment,e),gt=n(e),Ie=m(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-clpsz0"&&(Ie.innerHTML=Va),yt=n(e),r(Be.$$.fragment,e),ut=n(e),Ve=m(e,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-w98xng"&&(Ve.innerHTML=xa),bt=n(e),r(xe.$$.fragment,e),Mt=n(e),r(_e.$$.fragment,e),ft=n(e),Xe=m(e,"P",{"data-svelte-h":!0}),p(Xe)!=="svelte-1ojjd40"&&(Xe.textContent=_a),Jt=n(e),ke=m(e,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-18merz0"&&(ke.textContent=Xa),ht=n(e),r(Fe.$$.fragment,e),Zt=n(e),r(X.$$.fragment,e),wt=n(e),Qe=m(e,"P",{"data-svelte-h":!0}),p(Qe)!=="svelte-cmxlpu"&&(Qe.textContent=ka),Ut=n(e),r($e.$$.fragment,e),Tt=n(e),Re=m(e,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-vr292z"&&(Re.textContent=Fa),Wt=n(e),r(Se.$$.fragment,e),Gt=n(e),r(Ce.$$.fragment,e),jt=n(e),Ye=m(e,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-14io5mk"&&(Ye.innerHTML=Qa),vt=n(e),r(Ne.$$.fragment,e),It=n(e),He=m(e,"P",{"data-svelte-h":!0}),p(He)!=="svelte-10g432e"&&(He.innerHTML=$a),Bt=n(e),ze=m(e,"P",{"data-svelte-h":!0}),p(ze)!=="svelte-jivwv0"&&(ze.innerHTML=Ra),Vt=n(e),r(Ee.$$.fragment,e),xt=n(e),r(qe.$$.fragment,e),_t=n(e),Le=m(e,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-1enrnw9"&&(Le.textContent=Sa),Xt=n(e),De=m(e,"P",{"data-svelte-h":!0}),p(De)!=="svelte-1dqw2pd"&&(De.textContent=Ca),kt=n(e),r(Pe.$$.fragment,e),Ft=n(e),Ae=m(e,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-103dgzy"&&(Ae.innerHTML=Ya),Qt=n(e),r(Ke.$$.fragment,e),$t=n(e),Oe=m(e,"P",{"data-svelte-h":!0}),p(Oe)!=="svelte-kmdmdi"&&(Oe.textContent=Na),Rt=n(e),r(el.$$.fragment,e),St=n(e),k=m(e,"DIV",{class:!0,"data-svelte-h":!0}),p(k)!=="svelte-nm98y9"&&(k.innerHTML=Ha),Ct=n(e),ll=m(e,"P",{"data-svelte-h":!0}),p(ll)!=="svelte-77whwd"&&(ll.innerHTML=za),Yt=n(e),r(tl.$$.fragment,e),Nt=n(e),F=m(e,"DIV",{class:!0,"data-svelte-h":!0}),p(F)!=="svelte-9lkq3b"&&(F.innerHTML=Ea),Ht=n(e),r(al.$$.fragment,e),zt=n(e),sl=m(e,"P",{"data-svelte-h":!0}),p(sl)!=="svelte-1abeb6"&&(sl.innerHTML=qa),Et=n(e),r(nl.$$.fragment,e),qt=n(e),il=m(e,"P",{"data-svelte-h":!0}),p(il)!=="svelte-1bncb5f"&&(il.innerHTML=La),Lt=n(e),r(ml.$$.fragment,e),Dt=n(e),pl=m(e,"P",{"data-svelte-h":!0}),p(pl)!=="svelte-10imubo"&&(pl.innerHTML=Da),Pt=n(e),r(ol.$$.fragment,e),At=n(e),rl=m(e,"P",{}),Oa(rl).forEach(t),this.h()},h(){h(u,"name","hf:doc:metadata"),h(u,"content",ds),h(T,"start","2"),h(W,"start","3"),h(G,"class","flex gap-4"),h(j,"class","flex gap-4"),h(v,"class","flex gap-4"),h(I,"class","flex gap-4"),h(B,"class","flex flex-row gap-4"),h(V,"class","flex flex-row gap-4"),h(x,"class","flex flex-row gap-4"),h(k,"class","flex flex-row gap-4"),h(F,"class","flex justify-center")},m(e,l){ns(document.head,u),a(e,J,l),a(e,M,l),a(e,Z,l),c(Q,e,l),a(e,cl,l),c($,e,l),a(e,dl,l),a(e,R,l),a(e,gl,l),a(e,S,l),a(e,yl,l),a(e,C,l),a(e,ul,l),c(Y,e,l),a(e,bl,l),c(U,e,l),a(e,Ml,l),a(e,T,l),a(e,fl,l),c(N,e,l),a(e,Jl,l),a(e,W,l),a(e,hl,l),c(H,e,l),a(e,Zl,l),a(e,G,l),a(e,wl,l),c(z,e,l),a(e,Ul,l),a(e,E,l),a(e,Tl,l),c(q,e,l),a(e,Wl,l),a(e,L,l),a(e,Gl,l),c(D,e,l),a(e,jl,l),a(e,j,l),a(e,vl,l),c(P,e,l),a(e,Il,l),a(e,A,l),a(e,Bl,l),c(K,e,l),a(e,Vl,l),a(e,v,l),a(e,xl,l),c(O,e,l),a(e,_l,l),a(e,ee,l),a(e,Xl,l),a(e,le,l),a(e,kl,l),c(te,e,l),a(e,Fl,l),a(e,I,l),a(e,Ql,l),c(ae,e,l),a(e,$l,l),a(e,se,l),a(e,Rl,l),c(ne,e,l),a(e,Sl,l),a(e,ie,l),a(e,Cl,l),a(e,me,l),a(e,Yl,l),a(e,pe,l),a(e,Nl,l),c(oe,e,l),a(e,Hl,l),a(e,B,l),a(e,zl,l),c(re,e,l),a(e,El,l),a(e,ce,l),a(e,ql,l),a(e,de,l),a(e,Ll,l),c(ge,e,l),a(e,Dl,l),a(e,V,l),a(e,Pl,l),c(ye,e,l),a(e,Al,l),a(e,ue,l),a(e,Kl,l),c(be,e,l),a(e,Ol,l),a(e,x,l),a(e,et,l),c(Me,e,l),a(e,lt,l),a(e,fe,l),a(e,tt,l),c(Je,e,l),a(e,at,l),a(e,he,l),a(e,st,l),a(e,Ze,l),a(e,nt,l),c(we,e,l),a(e,it,l),a(e,Ue,l),a(e,mt,l),c(Te,e,l),a(e,pt,l),c(We,e,l),a(e,ot,l),a(e,Ge,l),a(e,rt,l),a(e,je,l),a(e,ct,l),c(ve,e,l),a(e,dt,l),c(_,e,l),a(e,gt,l),a(e,Ie,l),a(e,yt,l),c(Be,e,l),a(e,ut,l),a(e,Ve,l),a(e,bt,l),c(xe,e,l),a(e,Mt,l),c(_e,e,l),a(e,ft,l),a(e,Xe,l),a(e,Jt,l),a(e,ke,l),a(e,ht,l),c(Fe,e,l),a(e,Zt,l),c(X,e,l),a(e,wt,l),a(e,Qe,l),a(e,Ut,l),c($e,e,l),a(e,Tt,l),a(e,Re,l),a(e,Wt,l),c(Se,e,l),a(e,Gt,l),c(Ce,e,l),a(e,jt,l),a(e,Ye,l),a(e,vt,l),c(Ne,e,l),a(e,It,l),a(e,He,l),a(e,Bt,l),a(e,ze,l),a(e,Vt,l),c(Ee,e,l),a(e,xt,l),c(qe,e,l),a(e,_t,l),a(e,Le,l),a(e,Xt,l),a(e,De,l),a(e,kt,l),c(Pe,e,l),a(e,Ft,l),a(e,Ae,l),a(e,Qt,l),c(Ke,e,l),a(e,$t,l),a(e,Oe,l),a(e,Rt,l),c(el,e,l),a(e,St,l),a(e,k,l),a(e,Ct,l),a(e,ll,l),a(e,Yt,l),c(tl,e,l),a(e,Nt,l),a(e,F,l),a(e,Ht,l),c(al,e,l),a(e,zt,l),a(e,sl,l),a(e,Et,l),c(nl,e,l),a(e,qt,l),a(e,il,l),a(e,Lt,l),c(ml,e,l),a(e,Dt,l),a(e,pl,l),a(e,Pt,l),c(ol,e,l),a(e,At,l),a(e,rl,l),Kt=!0},p(e,[l]){const Pa={};l&2&&(Pa.$$scope={dirty:l,ctx:e}),U.$set(Pa);const Aa={};l&2&&(Aa.$$scope={dirty:l,ctx:e}),_.$set(Aa);const Ka={};l&2&&(Ka.$$scope={dirty:l,ctx:e}),X.$set(Ka)},i(e){Kt||(d(Q.$$.fragment,e),d($.$$.fragment,e),d(Y.$$.fragment,e),d(U.$$.fragment,e),d(N.$$.fragment,e),d(H.$$.fragment,e),d(z.$$.fragment,e),d(q.$$.fragment,e),d(D.$$.fragment,e),d(P.$$.fragment,e),d(K.$$.fragment,e),d(O.$$.fragment,e),d(te.$$.fragment,e),d(ae.$$.fragment,e),d(ne.$$.fragment,e),d(oe.$$.fragment,e),d(re.$$.fragment,e),d(ge.$$.fragment,e),d(ye.$$.fragment,e),d(be.$$.fragment,e),d(Me.$$.fragment,e),d(Je.$$.fragment,e),d(we.$$.fragment,e),d(Te.$$.fragment,e),d(We.$$.fragment,e),d(ve.$$.fragment,e),d(_.$$.fragment,e),d(Be.$$.fragment,e),d(xe.$$.fragment,e),d(_e.$$.fragment,e),d(Fe.$$.fragment,e),d(X.$$.fragment,e),d($e.$$.fragment,e),d(Se.$$.fragment,e),d(Ce.$$.fragment,e),d(Ne.$$.fragment,e),d(Ee.$$.fragment,e),d(qe.$$.fragment,e),d(Pe.$$.fragment,e),d(Ke.$$.fragment,e),d(el.$$.fragment,e),d(tl.$$.fragment,e),d(al.$$.fragment,e),d(nl.$$.fragment,e),d(ml.$$.fragment,e),d(ol.$$.fragment,e),Kt=!0)},o(e){g(Q.$$.fragment,e),g($.$$.fragment,e),g(Y.$$.fragment,e),g(U.$$.fragment,e),g(N.$$.fragment,e),g(H.$$.fragment,e),g(z.$$.fragment,e),g(q.$$.fragment,e),g(D.$$.fragment,e),g(P.$$.fragment,e),g(K.$$.fragment,e),g(O.$$.fragment,e),g(te.$$.fragment,e),g(ae.$$.fragment,e),g(ne.$$.fragment,e),g(oe.$$.fragment,e),g(re.$$.fragment,e),g(ge.$$.fragment,e),g(ye.$$.fragment,e),g(be.$$.fragment,e),g(Me.$$.fragment,e),g(Je.$$.fragment,e),g(we.$$.fragment,e),g(Te.$$.fragment,e),g(We.$$.fragment,e),g(ve.$$.fragment,e),g(_.$$.fragment,e),g(Be.$$.fragment,e),g(xe.$$.fragment,e),g(_e.$$.fragment,e),g(Fe.$$.fragment,e),g(X.$$.fragment,e),g($e.$$.fragment,e),g(Se.$$.fragment,e),g(Ce.$$.fragment,e),g(Ne.$$.fragment,e),g(Ee.$$.fragment,e),g(qe.$$.fragment,e),g(Pe.$$.fragment,e),g(Ke.$$.fragment,e),g(el.$$.fragment,e),g(tl.$$.fragment,e),g(al.$$.fragment,e),g(nl.$$.fragment,e),g(ml.$$.fragment,e),g(ol.$$.fragment,e),Kt=!1},d(e){e&&(t(J),t(M),t(Z),t(cl),t(dl),t(R),t(gl),t(S),t(yl),t(C),t(ul),t(bl),t(Ml),t(T),t(fl),t(Jl),t(W),t(hl),t(Zl),t(G),t(wl),t(Ul),t(E),t(Tl),t(Wl),t(L),t(Gl),t(jl),t(j),t(vl),t(Il),t(A),t(Bl),t(Vl),t(v),t(xl),t(_l),t(ee),t(Xl),t(le),t(kl),t(Fl),t(I),t(Ql),t($l),t(se),t(Rl),t(Sl),t(ie),t(Cl),t(me),t(Yl),t(pe),t(Nl),t(Hl),t(B),t(zl),t(El),t(ce),t(ql),t(de),t(Ll),t(Dl),t(V),t(Pl),t(Al),t(ue),t(Kl),t(Ol),t(x),t(et),t(lt),t(fe),t(tt),t(at),t(he),t(st),t(Ze),t(nt),t(it),t(Ue),t(mt),t(pt),t(ot),t(Ge),t(rt),t(je),t(ct),t(dt),t(gt),t(Ie),t(yt),t(ut),t(Ve),t(bt),t(Mt),t(ft),t(Xe),t(Jt),t(ke),t(ht),t(Zt),t(wt),t(Qe),t(Ut),t(Tt),t(Re),t(Wt),t(Gt),t(jt),t(Ye),t(vt),t(It),t(He),t(Bt),t(ze),t(Vt),t(xt),t(_t),t(Le),t(Xt),t(De),t(kt),t(Ft),t(Ae),t(Qt),t($t),t(Oe),t(Rt),t(St),t(k),t(Ct),t(ll),t(Yt),t(Nt),t(F),t(Ht),t(zt),t(sl),t(Et),t(qt),t(il),t(Lt),t(Dt),t(pl),t(Pt),t(At),t(rl)),t(u),y(Q,e),y($,e),y(Y,e),y(U,e),y(N,e),y(H,e),y(z,e),y(q,e),y(D,e),y(P,e),y(K,e),y(O,e),y(te,e),y(ae,e),y(ne,e),y(oe,e),y(re,e),y(ge,e),y(ye,e),y(be,e),y(Me,e),y(Je,e),y(we,e),y(Te,e),y(We,e),y(ve,e),y(_,e),y(Be,e),y(xe,e),y(_e,e),y(Fe,e),y(X,e),y($e,e),y(Se,e),y(Ce,e),y(Ne,e),y(Ee,e),y(qe,e),y(Pe,e),y(Ke,e),y(el,e),y(tl,e),y(al,e),y(nl,e),y(ml,e),y(ol,e)}}}const ds='{"title":"Image-to-image","local":"image-to-image","sections":[{"title":"Popular models","local":"popular-models","sections":[{"title":"Stable Diffusion v1.5","local":"stable-diffusion-v15","sections":[],"depth":3},{"title":"Stable Diffusion XL (SDXL)","local":"stable-diffusion-xl-sdxl","sections":[],"depth":3},{"title":"Kandinsky 2.2","local":"kandinsky-22","sections":[],"depth":3}],"depth":2},{"title":"Configure pipeline parameters","local":"configure-pipeline-parameters","sections":[{"title":"Strength","local":"strength","sections":[],"depth":3},{"title":"Guidance scale","local":"guidance-scale","sections":[],"depth":3},{"title":"Negative prompt","local":"negative-prompt","sections":[],"depth":3}],"depth":2},{"title":"Chained image-to-image pipelines","local":"chained-image-to-image-pipelines","sections":[{"title":"Text-to-image-to-image","local":"text-to-image-to-image","sections":[],"depth":3},{"title":"Image-to-image-to-image","local":"image-to-image-to-image","sections":[],"depth":3},{"title":"Image-to-upscaler-to-super-resolution","local":"image-to-upscaler-to-super-resolution","sections":[],"depth":3}],"depth":2},{"title":"Control image generation","local":"control-image-generation","sections":[{"title":"Prompt weighting","local":"prompt-weighting","sections":[],"depth":3},{"title":"ControlNet","local":"controlnet","sections":[],"depth":3}],"depth":2},{"title":"Optimize","local":"optimize","sections":[],"depth":2}],"depth":1}';function gs(w){return ls(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class hs extends ts{constructor(u){super(),as(this,u,gs,cs,es,{})}}export{hs as component};
