import{s as it,n as rt,o as pt}from"../chunks/scheduler.f6319a2a.js";import{S as Mt,i as ct,g as o,s as n,r as M,A as ut,h as i,f as l,c as a,j as at,u as c,x as r,k as ot,y as dt,a as s,v as u,d,t as y,w as m}from"../chunks/index.85aa684c.js";import{C as L}from"../chunks/CodeBlock.3400fc53.js";import{D as yt}from"../chunks/DocNotebookDropdown.3fc3604b.js";import{H as mt,E as wt}from"../chunks/index.9e1e6fd7.js";function ht(Ge){let p,K,P,O,w,ee,h,te,J,xe="Retrieval-Augmented-Generation (RAG) is “using an LLM to answer a user query, but basing the answer on information retrieved from a knowledge base”. It has many advantages over using a vanilla or fine-tuned LLM: to name a few, it allows to ground the answer on true facts and reduce confabulations, it allows to provide the LLM with domain-specific knowledge, and it allows fine-grained control of access to information from the knowledge base.",le,T,Ne="But vanilla RAG has limitations, most importantly these two:",se,b,We="<li>It performs only one retrieval step: if the results are bad, the generation in turn will be bad.</li> <li>Semantic similarity is computed with the user query as a reference, which might be suboptimal: for instance, the user query will often be a question and the document containing the true answer will be in affirmative voice, so its similarity score will be downgraded compared to other source documents in the interrogative form, leading to a risk of missing the relevant information.</li>",ne,j,qe="We can alleviate these problems by making a RAG agent: very simply, an agent armed with a retriever tool!",ae,U,Ve="This agent will: ✅ Formulate the query itself and ✅ Critique to re-retrieve if needed.",oe,f,Qe="So it should naively recover some advanced RAG techniques!",ie,I,Xe=`<li>Instead of directly using the user query as the reference in semantic search, the agent formulates itself a reference sentence that can be closer to the targeted documents, as in <a href="https://huggingface.co/papers/2212.10496" rel="nofollow">HyDE</a>.
The agent can use the generated snippets and re-retrieve if needed, as in <a href="https://docs.llamaindex.ai/en/stable/examples/evaluation/RetryQuery/" rel="nofollow">Self-Query</a>.</li>`,re,g,He="Let’s build this system. 🛠️",pe,C,$e="Run the line below to install required dependencies:",Me,v,ce,Z,Ee=`To call Inference Providers, you will need a valid token as your environment variable <code>HF_TOKEN</code>.
We use python-dotenv to load it.`,ue,k,de,B,Se="We first load a knowledge base on which we want to perform RAG: this dataset is a compilation of the documentation pages for many Hugging Face libraries, stored as markdown. We will keep only the documentation for the <code>transformers</code> library.",ye,R,Fe="Then prepare the knowledge base by processing the dataset and storing it into a vector database to be used by the retriever.",me,A,ze='We use <a href="https://python.langchain.com/docs/introduction/" rel="nofollow">LangChain</a> for its excellent vector database utilities.',we,_,he,G,Ye="Now the documents are ready.",Je,x,Le="So let’s build our agentic RAG system!",Te,N,Pe="👉 We only need a RetrieverTool that our agent can leverage to retrieve information from the knowledge base.",be,W,De='Since we need to add a vectordb as an attribute of the tool, we cannot simply use the simple tool constructor with a <code>@tool</code> decorator: so we will follow the advanced setup highlighted in the <a href="../tutorials/tools">tools tutorial</a>.',je,q,Ue,V,Ke=`We have used BM25, a classic retrieval method, because it’s lightning fast to setup.
To improve retrieval accuracy, you could use replace BM25 with semantic search using vector representations for documents: thus you can head to the <a href="https://huggingface.co/spaces/mteb/leaderboard" rel="nofollow">MTEB Leaderboard</a> to select a good embedding model.`,fe,Q,Oe="Now it’s straightforward to create an agent that leverages this <code>retriever_tool</code>!",Ie,X,et="The agent will need these arguments upon initialization:",ge,H,tt=`<li><code>tools</code>: a list of tools that the agent will be able to call.</li> <li><code>model</code>: the LLM that powers the agent.
Our <code>model</code> must be a callable that takes as input a list of messages and returns text. It also needs to accept a stop_sequences argument that indicates when to stop its generation. For convenience, we directly use the HfEngine class provided in the package to get a LLM engine that calls Hugging Face’s Inference API.</li>`,Ce,$,lt='<p>[!NOTE] To use a specific model, pass it like this: <code>InferenceClientModel(model_id=&quot;meta-llama/Llama-3.3-70B-Instruct&quot;)</code>. The Inference API hosts models based on various criteria, and deployed models may be updated or replaced without prior notice. Learn more about it <a href="https://huggingface.co/docs/api-inference/supported-models" rel="nofollow">here</a>.</p>',ve,E,Ze,S,st="Upon initializing the CodeAgent, it has been automatically given a default system prompt that tells the LLM engine to process step-by-step and generate tool calls as code snippets, but you could replace this prompt template with your own as needed.",ke,F,nt="Then when its <code>.run()</code> method is launched, the agent takes care of calling the LLM engine, and executing the tool calls, all in a loop that ends only when tool <code>final_answer</code> is called with the final answer as its argument.",Be,z,Re,Y,Ae,D,_e;return w=new mt({props:{title:"Agentic RAG",local:"agentic-rag",headingTag:"h1"}}),h=new yt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/rag.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/rag.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/rag.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/rag.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/rag.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/rag.ipynb"}]}}),v=new L({props:{code:"IXBpcCUyMGluc3RhbGwlMjBzbW9sYWdlbnRzJTIwcGFuZGFzJTIwbGFuZ2NoYWluJTIwbGFuZ2NoYWluLWNvbW11bml0eSUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycyUyMGRhdGFzZXRzJTIwcHl0aG9uLWRvdGVudiUyMHJhbmtfYm0yNSUyMC0tdXBncmFkZSUyMC1x",highlighted:"!pip install smolagents pandas langchain langchain-community sentence-transformers datasets python-dotenv rank_bm25 --upgrade -q",wrap:!1}}),k=new L({props:{code:"ZnJvbSUyMGRvdGVudiUyMGltcG9ydCUyMGxvYWRfZG90ZW52JTBBbG9hZF9kb3RlbnYoKQ==",highlighted:`<span class="hljs-keyword">from</span> dotenv <span class="hljs-keyword">import</span> load_dotenv
load_dotenv()`,wrap:!1}}),_=new L({props:{code:"aW1wb3J0JTIwZGF0YXNldHMlMEFmcm9tJTIwbGFuZ2NoYWluLmRvY3N0b3JlLmRvY3VtZW50JTIwaW1wb3J0JTIwRG9jdW1lbnQlMEFmcm9tJTIwbGFuZ2NoYWluLnRleHRfc3BsaXR0ZXIlMjBpbXBvcnQlMjBSZWN1cnNpdmVDaGFyYWN0ZXJUZXh0U3BsaXR0ZXIlMEFmcm9tJTIwbGFuZ2NoYWluX2NvbW11bml0eS5yZXRyaWV2ZXJzJTIwaW1wb3J0JTIwQk0yNVJldHJpZXZlciUwQSUwQWtub3dsZWRnZV9iYXNlJTIwJTNEJTIwZGF0YXNldHMubG9hZF9kYXRhc2V0KCUyMm0tcmljJTJGaHVnZ2luZ2ZhY2VfZG9jJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEFrbm93bGVkZ2VfYmFzZSUyMCUzRCUyMGtub3dsZWRnZV9iYXNlLmZpbHRlcihsYW1iZGElMjByb3clM0ElMjByb3clNUIlMjJzb3VyY2UlMjIlNUQuc3RhcnRzd2l0aCglMjJodWdnaW5nZmFjZSUyRnRyYW5zZm9ybWVycyUyMikpJTBBJTBBc291cmNlX2RvY3MlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjBEb2N1bWVudChwYWdlX2NvbnRlbnQlM0Rkb2MlNUIlMjJ0ZXh0JTIyJTVEJTJDJTIwbWV0YWRhdGElM0QlN0IlMjJzb3VyY2UlMjIlM0ElMjBkb2MlNUIlMjJzb3VyY2UlMjIlNUQuc3BsaXQoJTIyJTJGJTIyKSU1QjElNUQlN0QpJTBBJTIwJTIwJTIwJTIwZm9yJTIwZG9jJTIwaW4lMjBrbm93bGVkZ2VfYmFzZSUwQSU1RCUwQSUwQXRleHRfc3BsaXR0ZXIlMjAlM0QlMjBSZWN1cnNpdmVDaGFyYWN0ZXJUZXh0U3BsaXR0ZXIoJTBBJTIwJTIwJTIwJTIwY2h1bmtfc2l6ZSUzRDUwMCUyQyUwQSUyMCUyMCUyMCUyMGNodW5rX292ZXJsYXAlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMGFkZF9zdGFydF9pbmRleCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBzdHJpcF93aGl0ZXNwYWNlJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHNlcGFyYXRvcnMlM0QlNUIlMjIlNUNuJTVDbiUyMiUyQyUyMCUyMiU1Q24lMjIlMkMlMjAlMjIuJTIyJTJDJTIwJTIyJTIwJTIyJTJDJTIwJTIyJTIyJTVEJTJDJTBBKSUwQWRvY3NfcHJvY2Vzc2VkJTIwJTNEJTIwdGV4dF9zcGxpdHRlci5zcGxpdF9kb2N1bWVudHMoc291cmNlX2RvY3Mp",highlighted:`<span class="hljs-keyword">import</span> datasets
<span class="hljs-keyword">from</span> langchain.docstore.document <span class="hljs-keyword">import</span> Document
<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter
<span class="hljs-keyword">from</span> langchain_community.retrievers <span class="hljs-keyword">import</span> BM25Retriever

knowledge_base = datasets.load_dataset(<span class="hljs-string">&quot;m-ric/huggingface_doc&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
knowledge_base = knowledge_base.<span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> row: row[<span class="hljs-string">&quot;source&quot;</span>].startswith(<span class="hljs-string">&quot;huggingface/transformers&quot;</span>))

source_docs = [
    Document(page_content=doc[<span class="hljs-string">&quot;text&quot;</span>], metadata={<span class="hljs-string">&quot;source&quot;</span>: doc[<span class="hljs-string">&quot;source&quot;</span>].split(<span class="hljs-string">&quot;/&quot;</span>)[<span class="hljs-number">1</span>]})
    <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> knowledge_base
]

text_splitter = RecursiveCharacterTextSplitter(
    chunk_size=<span class="hljs-number">500</span>,
    chunk_overlap=<span class="hljs-number">50</span>,
    add_start_index=<span class="hljs-literal">True</span>,
    strip_whitespace=<span class="hljs-literal">True</span>,
    separators=[<span class="hljs-string">&quot;\\n\\n&quot;</span>, <span class="hljs-string">&quot;\\n&quot;</span>, <span class="hljs-string">&quot;.&quot;</span>, <span class="hljs-string">&quot; &quot;</span>, <span class="hljs-string">&quot;&quot;</span>],
)
docs_processed = text_splitter.split_documents(source_docs)`,wrap:!1}}),q=new L({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool

<span class="hljs-keyword">class</span> <span class="hljs-title class_">RetrieverTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;retriever&quot;</span>
    description = <span class="hljs-string">&quot;Uses semantic search to retrieve the parts of transformers documentation that could be most relevant to answer your query.&quot;</span>
    inputs = {
        <span class="hljs-string">&quot;query&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The query to perform. This should be semantically close to your target documents. Use the affirmative form rather than a question.&quot;</span>,
        }
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, docs, **kwargs</span>):
        <span class="hljs-built_in">super</span>().__init__(**kwargs)
        self.retriever = BM25Retriever.from_documents(
            docs, k=<span class="hljs-number">10</span>
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-keyword">assert</span> <span class="hljs-built_in">isinstance</span>(query, <span class="hljs-built_in">str</span>), <span class="hljs-string">&quot;Your search query must be a string&quot;</span>

        docs = self.retriever.invoke(
            query,
        )
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\nRetrieved documents:\\n&quot;</span> + <span class="hljs-string">&quot;&quot;</span>.join(
            [
                <span class="hljs-string">f&quot;\\n\\n===== Document <span class="hljs-subst">{<span class="hljs-built_in">str</span>(i)}</span> =====\\n&quot;</span> + doc.page_content
                <span class="hljs-keyword">for</span> i, doc <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(docs)
            ]
        )

retriever_tool = RetrieverTool(docs_processed)`,wrap:!1}}),E=new L({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCcmV0cmlldmVyX3Rvb2wlNUQlMkMlMjBtb2RlbCUzREluZmVyZW5jZUNsaWVudE1vZGVsKCklMkMlMjBtYXhfc3RlcHMlM0Q0JTJDJTIwdmVyYm9zaXR5X2xldmVsJTNEMiUwQSk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

agent = CodeAgent(
    tools=[retriever_tool], model=InferenceClientModel(), max_steps=<span class="hljs-number">4</span>, verbosity_level=<span class="hljs-number">2</span>
)`,wrap:!1}}),z=new L({props:{code:"YWdlbnRfb3V0cHV0JTIwJTNEJTIwYWdlbnQucnVuKCUyMkZvciUyMGElMjB0cmFuc2Zvcm1lcnMlMjBtb2RlbCUyMHRyYWluaW5nJTJDJTIwd2hpY2glMjBpcyUyMHNsb3dlciUyQyUyMHRoZSUyMGZvcndhcmQlMjBvciUyMHRoZSUyMGJhY2t3YXJkJTIwcGFzcyUzRiUyMiklMEElMEFwcmludCglMjJGaW5hbCUyMG91dHB1dCUzQSUyMiklMEFwcmludChhZ2VudF9vdXRwdXQp",highlighted:`agent_output = agent.run(<span class="hljs-string">&quot;For a transformers model training, which is slower, the forward or the backward pass?&quot;</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Final output:&quot;</span>)
<span class="hljs-built_in">print</span>(agent_output)`,wrap:!1}}),Y=new wt({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/examples/rag.mdx"}}),{c(){p=o("meta"),K=n(),P=o("p"),O=n(),M(w.$$.fragment),ee=n(),M(h.$$.fragment),te=n(),J=o("p"),J.textContent=xe,le=n(),T=o("p"),T.textContent=Ne,se=n(),b=o("ul"),b.innerHTML=We,ne=n(),j=o("p"),j.textContent=qe,ae=n(),U=o("p"),U.textContent=Ve,oe=n(),f=o("p"),f.textContent=Qe,ie=n(),I=o("ul"),I.innerHTML=Xe,re=n(),g=o("p"),g.textContent=He,pe=n(),C=o("p"),C.textContent=$e,Me=n(),M(v.$$.fragment),ce=n(),Z=o("p"),Z.innerHTML=Ee,ue=n(),M(k.$$.fragment),de=n(),B=o("p"),B.innerHTML=Se,ye=n(),R=o("p"),R.textContent=Fe,me=n(),A=o("p"),A.innerHTML=ze,we=n(),M(_.$$.fragment),he=n(),G=o("p"),G.textContent=Ye,Je=n(),x=o("p"),x.textContent=Le,Te=n(),N=o("p"),N.textContent=Pe,be=n(),W=o("p"),W.innerHTML=De,je=n(),M(q.$$.fragment),Ue=n(),V=o("p"),V.innerHTML=Ke,fe=n(),Q=o("p"),Q.innerHTML=Oe,Ie=n(),X=o("p"),X.textContent=et,ge=n(),H=o("ul"),H.innerHTML=tt,Ce=n(),$=o("blockquote"),$.innerHTML=lt,ve=n(),M(E.$$.fragment),Ze=n(),S=o("p"),S.textContent=st,ke=n(),F=o("p"),F.innerHTML=nt,Be=n(),M(z.$$.fragment),Re=n(),M(Y.$$.fragment),Ae=n(),D=o("p"),this.h()},l(e){const t=ut("svelte-u9bgzb",document.head);p=i(t,"META",{name:!0,content:!0}),t.forEach(l),K=a(e),P=i(e,"P",{}),at(P).forEach(l),O=a(e),c(w.$$.fragment,e),ee=a(e),c(h.$$.fragment,e),te=a(e),J=i(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-vj58on"&&(J.textContent=xe),le=a(e),T=i(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-le6dse"&&(T.textContent=Ne),se=a(e),b=i(e,"UL",{"data-svelte-h":!0}),r(b)!=="svelte-1sknqqb"&&(b.innerHTML=We),ne=a(e),j=i(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-c8ziqp"&&(j.textContent=qe),ae=a(e),U=i(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1oxrjf8"&&(U.textContent=Ve),oe=a(e),f=i(e,"P",{"data-svelte-h":!0}),r(f)!=="svelte-i3m4dm"&&(f.textContent=Qe),ie=a(e),I=i(e,"UL",{"data-svelte-h":!0}),r(I)!=="svelte-1hcft9j"&&(I.innerHTML=Xe),re=a(e),g=i(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-18mh92s"&&(g.textContent=He),pe=a(e),C=i(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-16cuoal"&&(C.textContent=$e),Me=a(e),c(v.$$.fragment,e),ce=a(e),Z=i(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-14ije4u"&&(Z.innerHTML=Ee),ue=a(e),c(k.$$.fragment,e),de=a(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-pnr043"&&(B.innerHTML=Se),ye=a(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-10fmib9"&&(R.textContent=Fe),me=a(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-15ubgr3"&&(A.innerHTML=ze),we=a(e),c(_.$$.fragment,e),he=a(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-zjg126"&&(G.textContent=Ye),Je=a(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-q3vnxy"&&(x.textContent=Le),Te=a(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-151azqv"&&(N.textContent=Pe),be=a(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-16enqdj"&&(W.innerHTML=De),je=a(e),c(q.$$.fragment,e),Ue=a(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1rtfitb"&&(V.innerHTML=Ke),fe=a(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1o6dxyl"&&(Q.innerHTML=Oe),Ie=a(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-14g5yev"&&(X.textContent=et),ge=a(e),H=i(e,"UL",{"data-svelte-h":!0}),r(H)!=="svelte-krum96"&&(H.innerHTML=tt),Ce=a(e),$=i(e,"BLOCKQUOTE",{"data-svelte-h":!0}),r($)!=="svelte-30qoyn"&&($.innerHTML=lt),ve=a(e),c(E.$$.fragment,e),Ze=a(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-45t4kd"&&(S.textContent=st),ke=a(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1ytp34t"&&(F.innerHTML=nt),Be=a(e),c(z.$$.fragment,e),Re=a(e),c(Y.$$.fragment,e),Ae=a(e),D=i(e,"P",{}),at(D).forEach(l),this.h()},h(){ot(p,"name","hf:doc:metadata"),ot(p,"content",Jt)},m(e,t){dt(document.head,p),s(e,K,t),s(e,P,t),s(e,O,t),u(w,e,t),s(e,ee,t),u(h,e,t),s(e,te,t),s(e,J,t),s(e,le,t),s(e,T,t),s(e,se,t),s(e,b,t),s(e,ne,t),s(e,j,t),s(e,ae,t),s(e,U,t),s(e,oe,t),s(e,f,t),s(e,ie,t),s(e,I,t),s(e,re,t),s(e,g,t),s(e,pe,t),s(e,C,t),s(e,Me,t),u(v,e,t),s(e,ce,t),s(e,Z,t),s(e,ue,t),u(k,e,t),s(e,de,t),s(e,B,t),s(e,ye,t),s(e,R,t),s(e,me,t),s(e,A,t),s(e,we,t),u(_,e,t),s(e,he,t),s(e,G,t),s(e,Je,t),s(e,x,t),s(e,Te,t),s(e,N,t),s(e,be,t),s(e,W,t),s(e,je,t),u(q,e,t),s(e,Ue,t),s(e,V,t),s(e,fe,t),s(e,Q,t),s(e,Ie,t),s(e,X,t),s(e,ge,t),s(e,H,t),s(e,Ce,t),s(e,$,t),s(e,ve,t),u(E,e,t),s(e,Ze,t),s(e,S,t),s(e,ke,t),s(e,F,t),s(e,Be,t),u(z,e,t),s(e,Re,t),u(Y,e,t),s(e,Ae,t),s(e,D,t),_e=!0},p:rt,i(e){_e||(d(w.$$.fragment,e),d(h.$$.fragment,e),d(v.$$.fragment,e),d(k.$$.fragment,e),d(_.$$.fragment,e),d(q.$$.fragment,e),d(E.$$.fragment,e),d(z.$$.fragment,e),d(Y.$$.fragment,e),_e=!0)},o(e){y(w.$$.fragment,e),y(h.$$.fragment,e),y(v.$$.fragment,e),y(k.$$.fragment,e),y(_.$$.fragment,e),y(q.$$.fragment,e),y(E.$$.fragment,e),y(z.$$.fragment,e),y(Y.$$.fragment,e),_e=!1},d(e){e&&(l(K),l(P),l(O),l(ee),l(te),l(J),l(le),l(T),l(se),l(b),l(ne),l(j),l(ae),l(U),l(oe),l(f),l(ie),l(I),l(re),l(g),l(pe),l(C),l(Me),l(ce),l(Z),l(ue),l(de),l(B),l(ye),l(R),l(me),l(A),l(we),l(he),l(G),l(Je),l(x),l(Te),l(N),l(be),l(W),l(je),l(Ue),l(V),l(fe),l(Q),l(Ie),l(X),l(ge),l(H),l(Ce),l($),l(ve),l(Ze),l(S),l(ke),l(F),l(Be),l(Re),l(Ae),l(D)),l(p),m(w,e),m(h,e),m(v,e),m(k,e),m(_,e),m(q,e),m(E,e),m(z,e),m(Y,e)}}}const Jt='{"title":"Agentic RAG","local":"agentic-rag","sections":[],"depth":1}';function Tt(Ge){return pt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class gt extends Mt{constructor(p){super(),ct(this,p,Tt,ht,it,{})}}export{gt as component};
