import{s as G1,n as X1,o as Z1}from"../chunks/scheduler.0219f8bd.js";import{S as e_,i as t_,g as i,s as o,r as a,A as l_,h as r,f as l,c as n,j as h,u as m,x as d,k as u,y as s_,a as s,v as p,d as c,t as T,w as f}from"../chunks/index.f61edf3b.js";import{C as zn}from"../chunks/CodeBlock.38e566ae.js";import{H as _,E as o_}from"../chunks/EditOnGithub.48fa589f.js";function n_(xT){let $,kn,Un,Jn,v,En,b,jn,y,CT="Helper module for <code>Tensor</code> processing.",Dn,M,HT=`These functions and classes are only used internally,
meaning an end-user shouldn’t need to access anything here.`,In,x,LT='<li><a href="#module_utils/tensor">utils/tensor</a><ul><li><em>static</em><ul><li><a href="#module_utils/tensor.Tensor">.Tensor</a><ul><li><a href="#new_module_utils/tensor.Tensor_new"><code>new Tensor(...args)</code></a></li> <li><a href="#module_utils/tensor.Tensor+dims"><code>.dims</code></a> : <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+type"><code>.type</code></a> : <a href="#DataType"><code>DataType</code></a></li> <li><a href="#module_utils/tensor.Tensor+data"><code>.data</code></a> : <code>DataArray</code></li> <li><a href="#module_utils/tensor.Tensor+size"><code>.size</code></a> : <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+location"><code>.location</code></a> : <code>string</code></li> <li><a href="#module_utils/tensor.Tensor+Symbol.iterator"><code>.Symbol.iterator()</code></a> ⇒ <code>Iterator</code></li> <li><a href="#module_utils/tensor.Tensor+_getitem"><code>._getitem(index)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+indexOf"><code>.indexOf(item)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+_subarray"><code>._subarray(index, iterSize, iterDims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+item"><code>.item()</code></a> ⇒ <code>number</code> | <code>bigint</code></li> <li><a href="#module_utils/tensor.Tensor+tolist"><code>.tolist()</code></a> ⇒ <code>Array</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid"><code>.sigmoid()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid_"><code>.sigmoid_()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+map"><code>.map(callback)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+map_"><code>.map_(callback)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+mul"><code>.mul(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+mul_"><code>.mul_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+div"><code>.div(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+div_"><code>.div_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+add"><code>.add(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+add_"><code>.add_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sub"><code>.sub(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sub_"><code>.sub_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+clone"><code>.clone()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+slice"><code>.slice(...slices)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+permute"><code>.permute(...dims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sum"><code>.sum([dim], keepdim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+norm"><code>.norm([p], [dim], [keepdim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize_"><code>.normalize_([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize"><code>.normalize([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+stride"><code>.stride()</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+squeeze"><code>.squeeze([dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+squeeze_"><code>.squeeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze"><code>.unsqueeze(dim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze_"><code>.unsqueeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten_"><code>.flatten_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten"><code>.flatten(start_dim, end_dim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+view"><code>.view(...dims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+clamp_"><code>.clamp_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+clamp"><code>.clamp(min, max)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+round_"><code>.round_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+round"><code>.round()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+to"><code>.to(type)</code></a> ⇒ <code>Tensor</code></li></ul></li> <li><a href="#module_utils/tensor.permute"><code>.permute(tensor, axes)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.interpolate"><code>.interpolate(input, size, mode, align_corners)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.interpolate_4d"><code>.interpolate_4d(input, options)</code></a> ⇒ <code>Promise.&lt;Tensor&gt;</code></li> <li><a href="#module_utils/tensor.matmul"><code>.matmul(a, b)</code></a> ⇒ <code>Promise.&lt;Tensor&gt;</code></li> <li><a href="#module_utils/tensor.rfft"><code>.rfft(x, a)</code></a> ⇒ <code>Promise.&lt;Tensor&gt;</code></li> <li><a href="#module_utils/tensor.topk"><code>.topk(x, k)</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/tensor.mean_pooling"><code>.mean_pooling(last_hidden_state, attention_mask)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.layer_norm"><code>.layer_norm(input, normalized_shape, options)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.cat"><code>.cat(tensors, dim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.stack"><code>.stack(tensors, dim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.std_mean"><code>.std_mean(input, dim, correction, keepdim)</code></a> ⇒ <code>Array.&lt;Tensor&gt;</code></li> <li><a href="#module_utils/tensor.mean"><code>.mean(input, dim, keepdim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.full"><code>.full(size, fill_value)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.ones"><code>.ones(size)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.ones_like"><code>.ones_like(tensor)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.zeros"><code>.zeros(size)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.zeros_like"><code>.zeros_like(tensor)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.quantize_embeddings"><code>.quantize_embeddings(tensor, precision)</code></a> ⇒ <code>Tensor</code></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/tensor..args%5B0%5D"><code>~args[0]</code></a> : <code>ONNXTensor</code></li> <li><a href="#module_utils/tensor..reshape"><code>~reshape(data, dimensions)</code></a> ⇒ <code>*</code><ul><li><a href="#module_utils/tensor..reshape..reshapedArray"><code>~reshapedArray</code></a> : <code>any</code></li></ul></li> <li><a href="#module_utils/tensor..DataArray"><code>~DataArray</code></a> : <code>*</code></li> <li><a href="#module_utils/tensor..NestArray"><code>~NestArray</code></a> : <code>*</code></li></ul></li></ul></li>',qn,Kn,Bn,C,Nn,H,Qn,L,wT='<strong>Kind</strong>: static class of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',Vn,w,AT='<li><a href="#module_utils/tensor.Tensor">.Tensor</a><ul><li><a href="#new_module_utils/tensor.Tensor_new"><code>new Tensor(...args)</code></a></li> <li><a href="#module_utils/tensor.Tensor+dims"><code>.dims</code></a> : <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+type"><code>.type</code></a> : <a href="#DataType"><code>DataType</code></a></li> <li><a href="#module_utils/tensor.Tensor+data"><code>.data</code></a> : <code>DataArray</code></li> <li><a href="#module_utils/tensor.Tensor+size"><code>.size</code></a> : <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+location"><code>.location</code></a> : <code>string</code></li> <li><a href="#module_utils/tensor.Tensor+Symbol.iterator"><code>.Symbol.iterator()</code></a> ⇒ <code>Iterator</code></li> <li><a href="#module_utils/tensor.Tensor+_getitem"><code>._getitem(index)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+indexOf"><code>.indexOf(item)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+_subarray"><code>._subarray(index, iterSize, iterDims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+item"><code>.item()</code></a> ⇒ <code>number</code> | <code>bigint</code></li> <li><a href="#module_utils/tensor.Tensor+tolist"><code>.tolist()</code></a> ⇒ <code>Array</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid"><code>.sigmoid()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid_"><code>.sigmoid_()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+map"><code>.map(callback)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+map_"><code>.map_(callback)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+mul"><code>.mul(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+mul_"><code>.mul_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+div"><code>.div(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+div_"><code>.div_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+add"><code>.add(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+add_"><code>.add_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sub"><code>.sub(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sub_"><code>.sub_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+clone"><code>.clone()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+slice"><code>.slice(...slices)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+permute"><code>.permute(...dims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sum"><code>.sum([dim], keepdim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+norm"><code>.norm([p], [dim], [keepdim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize_"><code>.normalize_([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize"><code>.normalize([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+stride"><code>.stride()</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+squeeze"><code>.squeeze([dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+squeeze_"><code>.squeeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze"><code>.unsqueeze(dim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze_"><code>.unsqueeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten_"><code>.flatten_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten"><code>.flatten(start_dim, end_dim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+view"><code>.view(...dims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+clamp_"><code>.clamp_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+clamp"><code>.clamp(min, max)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+round_"><code>.round_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+round"><code>.round()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+to"><code>.to(type)</code></a> ⇒ <code>Tensor</code></li></ul></li>',Sn,On,Fn,A,Yn,g,Wn,P,gT="Create a new Tensor or copy an existing Tensor.",Gn,z,PT="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>...args</td><td><code>*</code></td></tr></tbody>",Xn,Zn,ei,U,ti,R,li,k,zT="Dimensions of the tensor.",si,J,UT='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',oi,ni,ii,E,ri,j,di,D,RT="Type of the tensor.",ui,I,kT='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',ai,mi,pi,q,ci,K,Ti,B,JT="The data stored in the tensor.",fi,N,ET='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',hi,_i,$i,Q,vi,V,bi,S,jT="The number of elements in the tensor.",yi,O,DT='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Mi,xi,Ci,F,Hi,Y,Li,W,IT="The location of the tensor data.",wi,G,qT='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Ai,gi,Pi,X,zi,Z,Ui,ee,KT=`Returns an iterator object for iterating over the tensor data in row-major order.
If the tensor has more than one dimension, the iterator will yield subarrays.`,Ri,te,BT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Iterator</code> - An iterator object for iterating over the tensor data in row-major order.',ki,Ji,Ei,le,ji,se,Di,oe,NT="Index into a Tensor object.",Ii,ne,QT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The data at the specified index.',qi,ie,VT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>index</td><td><code>number</code></td><td><p>The index to access.</p></td></tr></tbody>",Ki,Bi,Ni,re,Qi,de,Vi,ue,ST='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>number</code> - The index of the first occurrence of item in the tensor data.',Si,ae,OT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>item</td><td><code>number</code> | <code>bigint</code></td><td><p>The item to search for in the tensor</p></td></tr></tbody>",Oi,Fi,Yi,me,Wi,pe,Gi,ce,FT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Xi,Te,YT="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>index</td><td><code>number</code></td> </tr><tr><td>iterSize</td><td><code>number</code></td> </tr><tr><td>iterDims</td><td><code>any</code></td></tr></tbody>",Zi,er,tr,fe,lr,he,sr,_e,WT=`Returns the value of this tensor as a standard JavaScript Number. This only works
for tensors with one element. For other cases, see <code>Tensor.tolist()</code>.`,or,$e,GT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>number</code> | <code>bigint</code> - The value of this tensor as a standard JavaScript Number.<br/> <strong>Throws</strong>:',nr,ve,XT="<li><code>Error</code> If the tensor has more than one element.</li>",ir,rr,dr,be,ur,ye,ar,Me,ZT="Convert tensor data to a n-dimensional JS list",mr,xe,ef='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',pr,cr,Tr,Ce,fr,He,hr,Le,tf="Return a new Tensor with the sigmoid function applied to each element.",_r,we,lf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The tensor with the sigmoid function applied.',$r,vr,br,Ae,yr,ge,Mr,Pe,sf="Applies the sigmoid function to the tensor in place.",xr,ze,of='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns <code>this</code>.',Cr,Hr,Lr,Ue,wr,Re,Ar,ke,nf="Return a new Tensor with a callback function applied to each element.",gr,Je,rf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - A new Tensor with the callback function applied to each element.',Pr,Ee,df=`<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>callback</td><td><code>function</code></td><td><p>The function to apply to each element. It should take three arguments:
                             the current element, its index, and the tensor&#39;s data array.</p></td></tr></tbody>`,zr,Ur,Rr,je,kr,De,Jr,Ie,uf="Apply a callback function to each element of the tensor in place.",Er,qe,af='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns <code>this</code>.',jr,Ke,mf=`<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>callback</td><td><code>function</code></td><td><p>The function to apply to each element. It should take three arguments:
                             the current element, its index, and the tensor&#39;s data array.</p></td></tr></tbody>`,Dr,Ir,qr,Be,Kr,Ne,Br,Qe,pf="Return a new Tensor with every element multiplied by a constant.",Nr,Ve,cf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The new tensor.',Qr,Se,Tf="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to multiply by.</p></td></tr></tbody>",Vr,Sr,Or,Oe,Fr,Fe,Yr,Ye,ff="Multiply the tensor by a constant in place.",Wr,We,hf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns <code>this</code>.',Gr,Ge,_f="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to multiply by.</p></td></tr></tbody>",Xr,Zr,ed,Xe,td,Ze,ld,et,$f="Return a new Tensor with every element divided by a constant.",sd,tt,vf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The new tensor.',od,lt,bf="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to divide by.</p></td></tr></tbody>",nd,id,rd,st,dd,ot,ud,nt,yf="Divide the tensor by a constant in place.",ad,it,Mf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns <code>this</code>.',md,rt,xf="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to divide by.</p></td></tr></tbody>",pd,cd,Td,dt,fd,ut,hd,at,Cf="Return a new Tensor with every element added by a constant.",_d,mt,Hf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The new tensor.',$d,pt,Lf="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to add by.</p></td></tr></tbody>",vd,bd,yd,ct,Md,Tt,xd,ft,wf="Add the tensor by a constant in place.",Cd,ht,Af='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns <code>this</code>.',Hd,_t,gf="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to add by.</p></td></tr></tbody>",Ld,wd,Ad,$t,gd,vt,Pd,bt,Pf="Return a new Tensor with every element subtracted by a constant.",zd,yt,zf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The new tensor.',Ud,Mt,Uf="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to subtract by.</p></td></tr></tbody>",Rd,kd,Jd,xt,Ed,Ct,jd,Ht,Rf="Subtract the tensor by a constant in place.",Dd,Lt,kf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns <code>this</code>.',Id,wt,Jf="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to subtract by.</p></td></tr></tbody>",qd,Kd,Bd,At,Nd,gt,Qd,Pt,Ef="Creates a deep copy of the current Tensor.",Vd,zt,jf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - A new Tensor with the same type, data, and dimensions as the original.',Sd,Od,Fd,Ut,Yd,Rt,Wd,kt,Df="Performs a slice operation on the Tensor along specified dimensions.",Gd,Jt,If="Consider a Tensor that has a dimension of [4, 7]:",Xd,Et,Zd,jt,qf=`We can slice against the two dims of row and column, for instance in this
case we can start at the second element, and return to the second last,
like this:`,eu,Dt,tu,It,Kf="which would return:",lu,qt,su,Kt,Bf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - A new Tensor containing the selected elements.<br/> <strong>Throws</strong>:',ou,Bt,Nf="<li><code>Error</code> If the slice input is invalid.</li>",nu,Nt,Qf="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...slices</td><td><code>number</code> | <code>Array&lt;number&gt;</code> | <code>null</code></td><td><p>The slice specifications for each dimension.</p> <ul><li>If a number is given, then a single element is selected.</li> <li>If an array of two numbers is given, then a range of elements [start, end (exclusive)] is selected.</li> <li>If null is given, then the entire dimension is selected.</li></ul></td></tr></tbody>",iu,ru,du,Qt,uu,Vt,au,St,Vf="Return a permuted version of this Tensor, according to the provided dimensions.",mu,Ot,Sf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The permuted tensor.',pu,Ft,Of="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...dims</td><td><code>number</code></td><td><p>Dimensions to permute.</p></td></tr></tbody>",cu,Tu,fu,Yt,hu,Wt,_u,Gt,Ff="Returns the sum of each row of the input tensor in the given dimension dim.",$u,Xt,Yf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: The summed tensor',vu,Zt,Wf="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>The dimension or dimensions to reduce. If <code>null</code>, all dimensions are reduced.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether the output tensor has <code>dim</code> retained or not.</p></td></tr></tbody>",bu,yu,Mu,el,xu,tl,Cu,ll,Gf="Returns the matrix norm or vector norm of a given tensor.",Hu,sl,Xf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The norm of the tensor.',Lu,ol,Zf=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code> | <code>string</code></td><td><code>&#39;fro&#39;</code></td><td><p>The order of norm</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>Specifies which dimension of the tensor to calculate the norm across.
If dim is None, the norm will be calculated across all dimensions of input.</p></td> </tr><tr><td>[keepdim]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether the output tensors have dim retained or not.</p></td></tr></tbody>`,wu,Au,gu,nl,Pu,il,zu,rl,eh="Performs <code>L_p</code> normalization of inputs over specified dimension. Operates in place.",Uu,dl,th='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - <code>this</code> for operation chaining.',Ru,ul,lh="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code></td><td><code>2</code></td><td><p>The exponent value in the norm formulation</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code>1</code></td><td><p>The dimension to reduce</p></td></tr></tbody>",ku,Ju,Eu,al,ju,ml,Du,pl,sh="Performs <code>L_p</code> normalization of inputs over specified dimension.",Iu,cl,oh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The normalized tensor.',qu,Tl,nh="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code></td><td><code>2</code></td><td><p>The exponent value in the norm formulation</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code>1</code></td><td><p>The dimension to reduce</p></td></tr></tbody>",Ku,Bu,Nu,fl,Qu,hl,Vu,_l,ih=`Compute and return the stride of this tensor.
Stride is the jump necessary to go from one element to the next one in the specified dimension dim.`,Su,$l,rh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - The stride of this tensor.',Ou,Fu,Yu,vl,Wu,bl,Gu,yl,dh="Returns a tensor with all specified dimensions of input of size 1 removed.",Xu,Ml,uh=`NOTE: The returned tensor shares the storage with the input tensor, so changing the contents of one will change the contents of the other.
If you would like a copy, use <code>tensor.clone()</code> before squeezing.`,Zu,xl,ah='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The squeezed tensor',ea,Cl,mh="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>If given, the input will be squeezed only in the specified dimensions.</p></td></tr></tbody>",ta,la,sa,Hl,oa,Ll,na,wl,ph='In-place version of @see <a href="Tensor.squeeze">Tensor.squeeze</a>',ia,Al,ch='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',ra,da,ua,gl,aa,Pl,ma,zl,Th="Returns a new tensor with a dimension of size one inserted at the specified position.",pa,Ul,fh="NOTE: The returned tensor shares the same underlying data with this tensor.",ca,Rl,hh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The unsqueezed tensor',Ta,kl,_h="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>dim</td><td><code>number</code></td><td><code></code></td><td><p>The index at which to insert the singleton dimension</p></td></tr></tbody>",fa,ha,_a,Jl,$a,El,va,jl,$h='In-place version of @see <a href="Tensor.unsqueeze">Tensor.unsqueeze</a>',ba,Dl,vh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',ya,Ma,xa,Il,Ca,ql,Ha,Kl,bh='In-place version of @see <a href="Tensor.flatten">Tensor.flatten</a>',La,Bl,yh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',wa,Aa,ga,Nl,Pa,Ql,za,Vl,Mh=`Flattens input by reshaping it into a one-dimensional tensor.
If <code>start_dim</code> or <code>end_dim</code> are passed, only dimensions starting with <code>start_dim</code>
and ending with <code>end_dim</code> are flattened. The order of elements in input is unchanged.`,Ua,Sl,xh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The flattened tensor.',Ra,Ol,Ch="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>start_dim</td><td><code>number</code></td><td><code>0</code></td><td><p>the first dim to flatten</p></td> </tr><tr><td>end_dim</td><td><code>number</code></td><td></td><td><p>the last dim to flatten</p></td></tr></tbody>",ka,Ja,Ea,Fl,ja,Yl,Da,Wl,Hh="Returns a new tensor with the same data as the <code>self</code> tensor but of a different <code>shape</code>.",Ia,Gl,Lh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The tensor with the same data but different shape',qa,Xl,wh="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...dims</td><td><code>number</code></td><td><p>the desired size</p></td></tr></tbody>",Ka,Ba,Na,Zl,Qa,es,Va,ts,Ah='In-place version of @see <a href="Tensor.clamp">Tensor.clamp</a>',Sa,ls,gh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Oa,Fa,Ya,ss,Wa,os,Ga,ns,Ph="Clamps all elements in input into the range [ min, max ]",Xa,is,zh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - the output tensor.',Za,rs,Uh="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>min</td><td><code>number</code></td><td><p>lower-bound of the range to be clamped to</p></td> </tr><tr><td>max</td><td><code>number</code></td><td><p>upper-bound of the range to be clamped to</p></td></tr></tbody>",em,tm,lm,ds,sm,us,om,as,Rh='In-place version of @see <a href="Tensor.round">Tensor.round</a>',nm,ms,kh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',im,rm,dm,ps,um,cs,am,Ts,Jh="Rounds elements of input to the nearest integer.",mm,fs,Eh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - the output tensor.',pm,cm,Tm,hs,fm,_s,hm,$s,jh="Performs Tensor dtype conversion.",_m,vs,Dh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The converted tensor.',$m,bs,Ih='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>type</td><td><code><a href="#DataType">DataType</a></code></td><td><p>The desired data type.</p></td></tr></tbody>',vm,bm,ym,ys,Mm,Ms,xm,xs,qh="Permutes a tensor according to the provided axes.",Cm,Cs,Kh='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The permuted tensor.',Hm,Hs,Bh="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code>any</code></td><td><p>The input tensor to permute.</p></td> </tr><tr><td>axes</td><td><code>Array</code></td><td><p>The axes to permute the tensor along.</p></td></tr></tbody>",Lm,wm,Am,Ls,gm,ws,Pm,As,Nh="Interpolates an Tensor to the given size.",zm,gs,Qh='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The interpolated tensor.',Um,Ps,Vh="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td><p>The input tensor to interpolate. Data must be channel-first (i.e., [c, h, w])</p></td> </tr><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>The output size of the image</p></td> </tr><tr><td>mode</td><td><code>string</code></td><td><p>The interpolation mode</p></td> </tr><tr><td>align_corners</td><td><code>boolean</code></td><td><p>Whether to align corners.</p></td></tr></tbody>",Rm,km,Jm,zs,Em,Us,jm,Rs,Sh=`Down/up samples the input.
Inspired by <a href="https://pytorch.org/docs/stable/generated/torch.nn.functional.interpolate.html" rel="nofollow">https://pytorch.org/docs/stable/generated/torch.nn.functional.interpolate.html</a>.`,Dm,ks,Oh='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Tensor&gt;</code> - The interpolated tensor.',Im,Js,Fh="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td></td><td><p>the input tensor</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>the options for the interpolation</p></td> </tr><tr><td>[options.size]</td><td><code>*</code></td><td><code></code></td><td><p>output spatial size.</p></td> </tr><tr><td>[options.mode]</td><td><code>&quot;bilinear&quot;</code> | <code>&quot;bicubic&quot;</code></td><td><code>&#39;bilinear&#39;</code></td><td><p>algorithm used for upsampling</p></td></tr></tbody>",qm,Km,Bm,Es,Nm,js,Qm,Ds,Yh=`Matrix product of two tensors.
Inspired by <a href="https://pytorch.org/docs/stable/generated/torch.matmul.html" rel="nofollow">https://pytorch.org/docs/stable/generated/torch.matmul.html</a>`,Vm,Is,Wh='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Tensor&gt;</code> - The matrix product of the two tensors.',Sm,qs,Gh="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>a</td><td><code>Tensor</code></td><td><p>the first tensor to be multiplied</p></td> </tr><tr><td>b</td><td><code>Tensor</code></td><td><p>the second tensor to be multiplied</p></td></tr></tbody>",Om,Fm,Ym,Ks,Wm,Bs,Gm,Ns,Xh=`Computes the one dimensional Fourier transform of real-valued input.
Inspired by <a href="https://pytorch.org/docs/stable/generated/torch.fft.rfft.html" rel="nofollow">https://pytorch.org/docs/stable/generated/torch.fft.rfft.html</a>`,Xm,Qs,Zh='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Tensor&gt;</code> - the output tensor.',Zm,Vs,e1="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>x</td><td><code>Tensor</code></td><td><p>the real input tensor</p></td> </tr><tr><td>a</td><td><code>Tensor</code></td><td><p>The dimension along which to take the one dimensional real FFT.</p></td></tr></tbody>",ep,tp,lp,Ss,sp,Os,op,Fs,t1=`Returns the k largest elements of the given input tensor.
Inspired by <a href="https://pytorch.org/docs/stable/generated/torch.topk.html" rel="nofollow">https://pytorch.org/docs/stable/generated/torch.topk.html</a>`,np,Ys,l1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>*</code> - the output tuple of (Tensor, LongTensor) of top-k elements and their indices.',ip,Ws,s1="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>x</td><td><code>Tensor</code></td><td><p>the input tensor</p></td> </tr><tr><td>k</td><td><code>number</code></td><td><p>the k in &quot;top-k&quot;</p></td></tr></tbody>",rp,dp,up,Gs,ap,Xs,mp,Zs,o1="Perform mean pooling of the last hidden state followed by a normalization step.",pp,eo,n1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns a new Tensor of shape [batchSize, embedDim].',cp,to,i1="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>last_hidden_state</td><td><code>Tensor</code></td><td><p>Tensor of shape [batchSize, seqLength, embedDim]</p></td> </tr><tr><td>attention_mask</td><td><code>Tensor</code></td><td><p>Tensor of shape [batchSize, seqLength]</p></td></tr></tbody>",Tp,fp,hp,lo,_p,so,$p,oo,r1="Apply Layer Normalization for last certain number of dimensions.",vp,no,d1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The normalized tensor.',bp,io,u1="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td></td><td><p>The input tensor</p></td> </tr><tr><td>normalized_shape</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>input shape from an expected input of size</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>The options for the layer normalization</p></td> </tr><tr><td>[options.eps]</td><td><code>number</code></td><td><code>1e-5</code></td><td><p>A value added to the denominator for numerical stability.</p></td></tr></tbody>",yp,Mp,xp,ro,Cp,uo,Hp,ao,a1="Concatenates an array of tensors along a specified dimension.",Lp,mo,m1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The concatenated tensor.',wp,po,p1="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensors</td><td><code>Array.&lt;Tensor&gt;</code></td><td><p>The array of tensors to concatenate.</p></td> </tr><tr><td>dim</td><td><code>number</code></td><td><p>The dimension to concatenate along.</p></td></tr></tbody>",Ap,gp,Pp,co,zp,To,Up,fo,c1="Stack an array of tensors along a specified dimension.",Rp,ho,T1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The stacked tensor.',kp,_o,f1="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensors</td><td><code>Array.&lt;Tensor&gt;</code></td><td><p>The array of tensors to stack.</p></td> </tr><tr><td>dim</td><td><code>number</code></td><td><p>The dimension to stack along.</p></td></tr></tbody>",Jp,Ep,jp,$o,Dp,vo,Ip,bo,h1="Calculates the standard deviation and mean over the dimensions specified by dim. dim can be a single dimension or <code>null</code> to reduce over all dimensions.",qp,yo,_1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;Tensor&gt;</code> - A tuple of (std, mean) tensors.',Kp,Mo,$1="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td><p>the input tenso</p></td> </tr><tr><td>dim</td><td><code>number</code> | <code>null</code></td><td><p>the dimension to reduce. If None, all dimensions are reduced.</p></td> </tr><tr><td>correction</td><td><code>number</code></td><td><p>difference between the sample size and sample degrees of freedom. Defaults to Bessel&#39;s correction, correction=1.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><p>whether the output tensor has dim retained or not.</p></td></tr></tbody>",Bp,Np,Qp,xo,Vp,Co,Sp,Ho,v1="Returns the mean value of each row of the input tensor in the given dimension dim.",Op,Lo,b1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - A new tensor with means taken along the specified dimension.',Fp,wo,y1="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td><p>the input tensor.</p></td> </tr><tr><td>dim</td><td><code>number</code> | <code>null</code></td><td><p>the dimension to reduce.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><p>whether the output tensor has dim retained or not.</p></td></tr></tbody>",Yp,Wp,Gp,Ao,Xp,go,Zp,Po,M1="Creates a tensor of size size filled with fill_value. The tensor’s dtype is inferred from fill_value.",ec,zo,x1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The filled tensor.',tc,Uo,C1="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>A sequence of integers defining the shape of the output tensor.</p></td> </tr><tr><td>fill_value</td><td><code>number</code> | <code>bigint</code> | <code>boolean</code></td><td><p>The value to fill the output tensor with.</p></td></tr></tbody>",lc,sc,oc,Ro,nc,ko,ic,Jo,H1="Returns a tensor filled with the scalar value 1, with the shape defined by the variable argument size.",rc,Eo,L1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The ones tensor.',dc,jo,w1="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>A sequence of integers defining the shape of the output tensor.</p></td></tr></tbody>",uc,ac,mc,Do,pc,Io,cc,qo,A1="Returns a tensor filled with the scalar value 1, with the same size as input.",Tc,Ko,g1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The ones tensor.',fc,Bo,P1="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code>Tensor</code></td><td><p>The size of input will determine size of the output tensor.</p></td></tr></tbody>",hc,_c,$c,No,vc,Qo,bc,Vo,z1="Returns a tensor filled with the scalar value 0, with the shape defined by the variable argument size.",yc,So,U1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The zeros tensor.',Mc,Oo,R1="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>A sequence of integers defining the shape of the output tensor.</p></td></tr></tbody>",xc,Cc,Hc,Fo,Lc,Yo,wc,Wo,k1="Returns a tensor filled with the scalar value 0, with the same size as input.",Ac,Go,J1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The zeros tensor.',gc,Xo,E1="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code>Tensor</code></td><td><p>The size of input will determine size of the output tensor.</p></td></tr></tbody>",Pc,zc,Uc,Zo,Rc,en,kc,tn,j1="Quantizes the embeddings tensor to binary or unsigned binary precision.",Jc,ln,D1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The quantized tensor.',Ec,sn,I1="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code>Tensor</code></td><td><p>The tensor to quantize.</p></td> </tr><tr><td>precision</td><td><code>&#39;binary&#39;</code> | <code>&#39;ubinary&#39;</code></td><td><p>The precision to use for quantization.</p></td></tr></tbody>",jc,Dc,Ic,on,qc,nn,Kc,rn,q1='<strong>Kind</strong>: inner property of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',Bc,Nc,Qc,dn,Vc,un,Sc,an,K1="Reshapes a 1-dimensional array into an n-dimensional array, according to the provided dimensions.",Oc,mn,B1='<strong>Kind</strong>: inner method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The reshaped array.',Fc,pn,N1="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Array&lt;T&gt;</code> | <code>DataArray</code></td><td><p>The input array to reshape.</p></td> </tr><tr><td>dimensions</td><td><code>DIM</code></td><td><p>The target shape/dimensions.</p></td></tr></tbody>",Yc,cn,Q1="<strong>Example</strong>",Wc,Tn,Gc,Xc,Zc,fn,eT,hn,tT,_n,V1='<strong>Kind</strong>: inner property of <a href="#module_utils/tensor..reshape"><code>reshape</code></a>',lT,sT,oT,$n,nT,vn,iT,bn,S1='<strong>Kind</strong>: inner typedef of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',rT,dT,uT,yn,aT,Mn,mT,xn,O1="This creates a nested array of a given type and depth (see examples).",pT,Cn,F1='<strong>Kind</strong>: inner typedef of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Example</strong>',cT,Hn,TT,Ln,Y1="<strong>Example</strong>",fT,wn,hT,An,W1="<strong>Example</strong>",_T,gn,$T,vT,bT,Pn,yT,Rn,MT;return b=new _({props:{title:"utils/tensor",local:"utilstensor",headingTag:"h1"}}),H=new _({props:{title:"utils/tensor.Tensor",local:"utilstensortensor",headingTag:"h2"}}),g=new _({props:{title:"new Tensor(...args)",local:"new-tensorargs",headingTag:"h3"}}),R=new _({props:{title:"tensor.dims : <code> Array. < number > </code>",local:"tensordims--code-array--number--code",headingTag:"h3"}}),j=new _({props:{title:"tensor.type : <code> DataType </code>",local:"tensortype--code-datatype-code",headingTag:"h3"}}),K=new _({props:{title:"tensor.data : <code> DataArray </code>",local:"tensordata--code-dataarray-code",headingTag:"h3"}}),V=new _({props:{title:"tensor.size : <code> number </code>",local:"tensorsize--code-number-code",headingTag:"h3"}}),Y=new _({props:{title:"tensor.location : <code> string </code>",local:"tensorlocation--code-string-code",headingTag:"h3"}}),Z=new _({props:{title:"tensor.Symbol.iterator() ⇒ <code> Iterator </code>",local:"tensorsymboliterator--code-iterator-code",headingTag:"h3"}}),se=new _({props:{title:"tensor._getitem(index) ⇒ <code> Tensor </code>",local:"tensorgetitemindex--code-tensor-code",headingTag:"h3"}}),de=new _({props:{title:"tensor.indexOf(item) ⇒ <code> number </code>",local:"tensorindexofitem--code-number-code",headingTag:"h3"}}),pe=new _({props:{title:"tensor._subarray(index, iterSize, iterDims) ⇒ <code> Tensor </code>",local:"tensorsubarrayindex-itersize-iterdims--code-tensor-code",headingTag:"h3"}}),he=new _({props:{title:"tensor.item() ⇒ <code> number </code> | <code> bigint </code>",local:"tensoritem--code-number-code--code-bigint-code",headingTag:"h3"}}),ye=new _({props:{title:"tensor.tolist() ⇒ <code> Array </code>",local:"tensortolist--code-array-code",headingTag:"h3"}}),He=new _({props:{title:"tensor.sigmoid() ⇒ <code> Tensor </code>",local:"tensorsigmoid--code-tensor-code",headingTag:"h3"}}),ge=new _({props:{title:"tensor.sigmoid_() ⇒ <code> Tensor </code>",local:"tensorsigmoid--code-tensor-code",headingTag:"h3"}}),Re=new _({props:{title:"tensor.map(callback) ⇒ <code> Tensor </code>",local:"tensormapcallback--code-tensor-code",headingTag:"h3"}}),De=new _({props:{title:"tensor.map_(callback) ⇒ <code> Tensor </code>",local:"tensormapcallback--code-tensor-code",headingTag:"h3"}}),Ne=new _({props:{title:"tensor.mul(val) ⇒ <code> Tensor </code>",local:"tensormulval--code-tensor-code",headingTag:"h3"}}),Fe=new _({props:{title:"tensor.mul_(val) ⇒ <code> Tensor </code>",local:"tensormulval--code-tensor-code",headingTag:"h3"}}),Ze=new _({props:{title:"tensor.div(val) ⇒ <code> Tensor </code>",local:"tensordivval--code-tensor-code",headingTag:"h3"}}),ot=new _({props:{title:"tensor.div_(val) ⇒ <code> Tensor </code>",local:"tensordivval--code-tensor-code",headingTag:"h3"}}),ut=new _({props:{title:"tensor.add(val) ⇒ <code> Tensor </code>",local:"tensoraddval--code-tensor-code",headingTag:"h3"}}),Tt=new _({props:{title:"tensor.add_(val) ⇒ <code> Tensor </code>",local:"tensoraddval--code-tensor-code",headingTag:"h3"}}),vt=new _({props:{title:"tensor.sub(val) ⇒ <code> Tensor </code>",local:"tensorsubval--code-tensor-code",headingTag:"h3"}}),Ct=new _({props:{title:"tensor.sub_(val) ⇒ <code> Tensor </code>",local:"tensorsubval--code-tensor-code",headingTag:"h3"}}),gt=new _({props:{title:"tensor.clone() ⇒ <code> Tensor </code>",local:"tensorclone--code-tensor-code",headingTag:"h3"}}),Rt=new _({props:{title:"tensor.slice(...slices) ⇒ <code> Tensor </code>",local:"tensorsliceslices--code-tensor-code",headingTag:"h3"}}),Et=new zn({props:{code:"JTVCJTIwMSUyQyUyMCUyMDIlMkMlMjAlMjAzJTJDJTIwJTIwNCUyQyUyMCUyMDUlMkMlMjAlMjA2JTJDJTIwJTIwNyU1RCUwQSU1QiUyMDglMkMlMjAlMjA5JTJDJTIwMTAlMkMlMjAxMSUyQyUyMDEyJTJDJTIwMTMlMkMlMjAxNCU1RCUwQSU1QjE1JTJDJTIwMTYlMkMlMjAxNyUyQyUyMDE4JTJDJTIwMTklMkMlMjAyMCUyQyUyMDIxJTVEJTBBJTVCMjIlMkMlMjAyMyUyQyUyMDI0JTJDJTIwMjUlMkMlMjAyNiUyQyUyMDI3JTJDJTIwMjglNUQ=",highlighted:`<span class="hljs-string">[ 1,  2,  3,  4,  5,  6,  7]</span>
<span class="hljs-string">[ 8,  9, 10, 11, 12, 13, 14]</span>
<span class="hljs-string">[15, 16, 17, 18, 19, 20, 21]</span>
<span class="hljs-string">[22, 23, 24, 25, 26, 27, 28]</span>`,wrap:!1}}),Dt=new zn({props:{code:"dGVuc29yLnNsaWNlKCU1QjElMkMlMjAtMSU1RCUyQyUyMCU1QjElMkMlMjAtMSU1RCklM0I=",highlighted:'<span class="hljs-attribute">tensor</span>.slice([<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>],<span class="hljs-meta"> [1, -1]);</span>',wrap:!1}}),qt=new zn({props:{code:"JTVCJTIwJTIwOSUyQyUyMDEwJTJDJTIwMTElMkMlMjAxMiUyQyUyMDEzJTIwJTVEJTBBJTVCJTIwMTYlMkMlMjAxNyUyQyUyMDE4JTJDJTIwMTklMkMlMjAyMCUyMCU1RA==",highlighted:`<span class="hljs-string">[  9, 10, 11, 12, 13 ]</span>
<span class="hljs-string">[ 16, 17, 18, 19, 20 ]</span>`,wrap:!1}}),Vt=new _({props:{title:"tensor.permute(...dims) ⇒ <code> Tensor </code>",local:"tensorpermutedims--code-tensor-code",headingTag:"h3"}}),Wt=new _({props:{title:"tensor.sum([dim], keepdim) ⇒",local:"tensorsumdim-keepdim-",headingTag:"h3"}}),tl=new _({props:{title:"tensor.norm([p], [dim], [keepdim]) ⇒ <code> Tensor </code>",local:"tensornormp-dim-keepdim--code-tensor-code",headingTag:"h3"}}),il=new _({props:{title:"tensor.normalize_([p], [dim]) ⇒ <code> Tensor </code>",local:"tensornormalizep-dim--code-tensor-code",headingTag:"h3"}}),ml=new _({props:{title:"tensor.normalize([p], [dim]) ⇒ <code> Tensor </code>",local:"tensornormalizep-dim--code-tensor-code",headingTag:"h3"}}),hl=new _({props:{title:"tensor.stride() ⇒ <code> Array. < number > </code>",local:"tensorstride--code-array--number--code",headingTag:"h3"}}),bl=new _({props:{title:"tensor.squeeze([dim]) ⇒ <code> Tensor </code>",local:"tensorsqueezedim--code-tensor-code",headingTag:"h3"}}),Ll=new _({props:{title:"tensor.squeeze_()",local:"tensorsqueeze",headingTag:"h3"}}),Pl=new _({props:{title:"tensor.unsqueeze(dim) ⇒ <code> Tensor </code>",local:"tensorunsqueezedim--code-tensor-code",headingTag:"h3"}}),El=new _({props:{title:"tensor.unsqueeze_()",local:"tensorunsqueeze",headingTag:"h3"}}),ql=new _({props:{title:"tensor.flatten_()",local:"tensorflatten",headingTag:"h3"}}),Ql=new _({props:{title:"tensor.flatten(start_dim, end_dim) ⇒ <code> Tensor </code>",local:"tensorflattenstartdim-enddim--code-tensor-code",headingTag:"h3"}}),Yl=new _({props:{title:"tensor.view(...dims) ⇒ <code> Tensor </code>",local:"tensorviewdims--code-tensor-code",headingTag:"h3"}}),es=new _({props:{title:"tensor.clamp_()",local:"tensorclamp",headingTag:"h3"}}),os=new _({props:{title:"tensor.clamp(min, max) ⇒ <code> Tensor </code>",local:"tensorclampmin-max--code-tensor-code",headingTag:"h3"}}),us=new _({props:{title:"tensor.round_()",local:"tensorround",headingTag:"h3"}}),cs=new _({props:{title:"tensor.round() ⇒ <code> Tensor </code>",local:"tensorround--code-tensor-code",headingTag:"h3"}}),_s=new _({props:{title:"tensor.to(type) ⇒ <code> Tensor </code>",local:"tensortotype--code-tensor-code",headingTag:"h3"}}),Ms=new _({props:{title:"utils/tensor.permute(tensor, axes) ⇒ <code> Tensor </code>",local:"utilstensorpermutetensor-axes--code-tensor-code",headingTag:"h2"}}),ws=new _({props:{title:"utils/tensor.interpolate(input, size, mode, align_corners) ⇒ <code> Tensor </code>",local:"utilstensorinterpolateinput-size-mode-aligncorners--code-tensor-code",headingTag:"h2"}}),Us=new _({props:{title:"utils/tensor.interpolate_4d(input, options) ⇒ <code> Promise. < Tensor > </code>",local:"utilstensorinterpolate4dinput-options--code-promise--tensor--code",headingTag:"h2"}}),js=new _({props:{title:"utils/tensor.matmul(a, b) ⇒ <code> Promise. < Tensor > </code>",local:"utilstensormatmula-b--code-promise--tensor--code",headingTag:"h2"}}),Bs=new _({props:{title:"utils/tensor.rfft(x, a) ⇒ <code> Promise. < Tensor > </code>",local:"utilstensorrfftx-a--code-promise--tensor--code",headingTag:"h2"}}),Os=new _({props:{title:"utils/tensor.topk(x, k) ⇒ <code> * </code>",local:"utilstensortopkx-k--code--code",headingTag:"h2"}}),Xs=new _({props:{title:"utils/tensor.mean_pooling(last_hidden_state, attention_mask) ⇒ <code> Tensor </code>",local:"utilstensormeanpoolinglasthiddenstate-attentionmask--code-tensor-code",headingTag:"h2"}}),so=new _({props:{title:"utils/tensor.layer_norm(input, normalized_shape, options) ⇒ <code> Tensor </code>",local:"utilstensorlayernorminput-normalizedshape-options--code-tensor-code",headingTag:"h2"}}),uo=new _({props:{title:"utils/tensor.cat(tensors, dim) ⇒ <code> Tensor </code>",local:"utilstensorcattensors-dim--code-tensor-code",headingTag:"h2"}}),To=new _({props:{title:"utils/tensor.stack(tensors, dim) ⇒ <code> Tensor </code>",local:"utilstensorstacktensors-dim--code-tensor-code",headingTag:"h2"}}),vo=new _({props:{title:"utils/tensor.std_mean(input, dim, correction, keepdim) ⇒ <code> Array. < Tensor > </code>",local:"utilstensorstdmeaninput-dim-correction-keepdim--code-array--tensor--code",headingTag:"h2"}}),Co=new _({props:{title:"utils/tensor.mean(input, dim, keepdim) ⇒ <code> Tensor </code>",local:"utilstensormeaninput-dim-keepdim--code-tensor-code",headingTag:"h2"}}),go=new _({props:{title:"utils/tensor.full(size, fill_value) ⇒ <code> Tensor </code>",local:"utilstensorfullsize-fillvalue--code-tensor-code",headingTag:"h2"}}),ko=new _({props:{title:"utils/tensor.ones(size) ⇒ <code> Tensor </code>",local:"utilstensoronessize--code-tensor-code",headingTag:"h2"}}),Io=new _({props:{title:"utils/tensor.ones_like(tensor) ⇒ <code> Tensor </code>",local:"utilstensoronesliketensor--code-tensor-code",headingTag:"h2"}}),Qo=new _({props:{title:"utils/tensor.zeros(size) ⇒ <code> Tensor </code>",local:"utilstensorzerossize--code-tensor-code",headingTag:"h2"}}),Yo=new _({props:{title:"utils/tensor.zeros_like(tensor) ⇒ <code> Tensor </code>",local:"utilstensorzerosliketensor--code-tensor-code",headingTag:"h2"}}),en=new _({props:{title:"utils/tensor.quantize_embeddings(tensor, precision) ⇒ <code> Tensor </code>",local:"utilstensorquantizeembeddingstensor-precision--code-tensor-code",headingTag:"h2"}}),nn=new _({props:{title:"utils/tensor~args[0] : <code> ONNXTensor </code>",local:"utilstensorargs0--code-onnxtensor-code",headingTag:"h2"}}),un=new _({props:{title:"utils/tensor~reshape(data, dimensions) ⇒ <code> * </code>",local:"utilstensorreshapedata-dimensions--code--code",headingTag:"h2"}}),Tn=new zn({props:{code:"cmVzaGFwZSglNUIxMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUyQyUyMCU1QjElMjAlMjAlMjAlMjAlMjAlMjAlNUQpJTNCJTIwJTJGJTJGJTIwVHlwZSUzQSUyMG51bWJlciU1QiU1RCUyMCUyMCUyMCUyMCUyMCUyMFZhbHVlJTNBJTIwJTVCMTAlNUQlMEElMjAlMjByZXNoYXBlKCU1QjElMkMlMjAyJTJDJTIwMyUyQyUyMDQlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMjAlNUIyJTJDJTIwMiUyMCUyMCUyMCU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTIwJTIwJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTVEJTBBJTIwJTIwcmVzaGFwZSglNUIxJTJDJTIwMiUyQyUyMDMlMkMlMjA0JTJDJTIwNSUyQyUyMDYlMkMlMjA3JTJDJTIwOCU1RCUyQyUyMCU1QjIlMkMlMjAyJTJDJTIwMiU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTVCJTVEJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTVEJTJDJTIwJTVCJTVCNSUyQyUyMDYlNUQlMkMlMjAlNUI3JTJDJTIwOCU1RCU1RCU1RCUwQSUyMCUyMHJlc2hhcGUoJTVCMSUyQyUyMDIlMkMlMjAzJTJDJTIwNCUyQyUyMDUlMkMlMjA2JTJDJTIwNyUyQyUyMDglNUQlMkMlMjAlNUI0JTJDJTIwMiUyMCUyMCUyMCU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTIwJTIwJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTJDJTIwJTVCNSUyQyUyMDYlNUQlMkMlMjAlNUI3JTJDJTIwOCU1RCU1RA==",highlighted:`<span class="hljs-title function_">reshape</span>([<span class="hljs-number">10</span>                    ], [<span class="hljs-number">1</span>      ]); <span class="hljs-comment">// Type: number[]      Value: [10]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>            ], [<span class="hljs-number">2</span>, <span class="hljs-number">2</span>   ]); <span class="hljs-comment">// Type: number[][]    Value: [[1, 2], [3, 4]]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>], [<span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>]); <span class="hljs-comment">// Type: number[][][]  Value: [[[1, 2], [3, 4]], [[5, 6], [7, 8]]]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>], [<span class="hljs-number">4</span>, <span class="hljs-number">2</span>   ]); <span class="hljs-comment">// Type: number[][]    Value: [[1, 2], [3, 4], [5, 6], [7, 8]]</span>`,wrap:!1}}),hn=new _({props:{title:"reshape~reshapedArray : <code> any </code>",local:"reshapereshapedarray--code-any-code",headingTag:"h3"}}),vn=new _({props:{title:"utils/tensor~DataArray : <code> * </code>",local:"utilstensordataarray--code--code",headingTag:"h2"}}),Mn=new _({props:{title:"utils/tensor~NestArray : <code> * </code>",local:"utilstensornestarray--code--code",headingTag:"h2"}}),Hn=new zn({props:{code:"TmVzdEFycmF5JTNDc3RyaW5nJTJDJTIwMSUzRSUzQiUyMCUyRiUyRiUyMHN0cmluZyU1QiU1RA==",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;string, <span class="hljs-number">1</span>&gt;; <span class="hljs-comment">// string[]</span>',wrap:!1}}),wn=new zn({props:{code:"TmVzdEFycmF5JTNDbnVtYmVyJTJDJTIwMiUzRSUzQiUyMCUyRiUyRiUyMG51bWJlciU1QiU1RCU1QiU1RA==",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;number, <span class="hljs-number">2</span>&gt;; <span class="hljs-comment">// number[][]</span>',wrap:!1}}),gn=new zn({props:{code:"TmVzdEFycmF5JTNDc3RyaW5nJTJDJTIwMyUzRSUzQiUyMCUyRiUyRiUyMHN0cmluZyU1QiU1RCU1QiU1RCU1QiU1RCUyMGV0Yy4=",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;string, <span class="hljs-number">3</span>&gt;; <span class="hljs-comment">// string[][][] etc.</span>',wrap:!1}}),Pn=new o_({props:{source:"https://github.com/huggingface/transformers.js/blob/main/docs/source/api/utils/tensor.md"}}),{c(){$=i("meta"),kn=o(),Un=i("p"),Jn=o(),v=i("a"),En=o(),a(b.$$.fragment),jn=o(),y=i("p"),y.innerHTML=CT,Dn=o(),M=i("p"),M.textContent=HT,In=o(),x=i("ul"),x.innerHTML=LT,qn=o(),Kn=i("hr"),Bn=o(),C=i("a"),Nn=o(),a(H.$$.fragment),Qn=o(),L=i("p"),L.innerHTML=wT,Vn=o(),w=i("ul"),w.innerHTML=AT,Sn=o(),On=i("hr"),Fn=o(),A=i("a"),Yn=o(),a(g.$$.fragment),Wn=o(),P=i("p"),P.textContent=gT,Gn=o(),z=i("table"),z.innerHTML=PT,Xn=o(),Zn=i("hr"),ei=o(),U=i("a"),ti=o(),a(R.$$.fragment),li=o(),k=i("p"),k.textContent=zT,si=o(),J=i("p"),J.innerHTML=UT,oi=o(),ni=i("hr"),ii=o(),E=i("a"),ri=o(),a(j.$$.fragment),di=o(),D=i("p"),D.textContent=RT,ui=o(),I=i("p"),I.innerHTML=kT,ai=o(),mi=i("hr"),pi=o(),q=i("a"),ci=o(),a(K.$$.fragment),Ti=o(),B=i("p"),B.textContent=JT,fi=o(),N=i("p"),N.innerHTML=ET,hi=o(),_i=i("hr"),$i=o(),Q=i("a"),vi=o(),a(V.$$.fragment),bi=o(),S=i("p"),S.textContent=jT,yi=o(),O=i("p"),O.innerHTML=DT,Mi=o(),xi=i("hr"),Ci=o(),F=i("a"),Hi=o(),a(Y.$$.fragment),Li=o(),W=i("p"),W.textContent=IT,wi=o(),G=i("p"),G.innerHTML=qT,Ai=o(),gi=i("hr"),Pi=o(),X=i("a"),zi=o(),a(Z.$$.fragment),Ui=o(),ee=i("p"),ee.textContent=KT,Ri=o(),te=i("p"),te.innerHTML=BT,ki=o(),Ji=i("hr"),Ei=o(),le=i("a"),ji=o(),a(se.$$.fragment),Di=o(),oe=i("p"),oe.textContent=NT,Ii=o(),ne=i("p"),ne.innerHTML=QT,qi=o(),ie=i("table"),ie.innerHTML=VT,Ki=o(),Bi=i("hr"),Ni=o(),re=i("a"),Qi=o(),a(de.$$.fragment),Vi=o(),ue=i("p"),ue.innerHTML=ST,Si=o(),ae=i("table"),ae.innerHTML=OT,Oi=o(),Fi=i("hr"),Yi=o(),me=i("a"),Wi=o(),a(pe.$$.fragment),Gi=o(),ce=i("p"),ce.innerHTML=FT,Xi=o(),Te=i("table"),Te.innerHTML=YT,Zi=o(),er=i("hr"),tr=o(),fe=i("a"),lr=o(),a(he.$$.fragment),sr=o(),_e=i("p"),_e.innerHTML=WT,or=o(),$e=i("p"),$e.innerHTML=GT,nr=o(),ve=i("ul"),ve.innerHTML=XT,ir=o(),rr=i("hr"),dr=o(),be=i("a"),ur=o(),a(ye.$$.fragment),ar=o(),Me=i("p"),Me.textContent=ZT,mr=o(),xe=i("p"),xe.innerHTML=ef,pr=o(),cr=i("hr"),Tr=o(),Ce=i("a"),fr=o(),a(He.$$.fragment),hr=o(),Le=i("p"),Le.textContent=tf,_r=o(),we=i("p"),we.innerHTML=lf,$r=o(),vr=i("hr"),br=o(),Ae=i("a"),yr=o(),a(ge.$$.fragment),Mr=o(),Pe=i("p"),Pe.textContent=sf,xr=o(),ze=i("p"),ze.innerHTML=of,Cr=o(),Hr=i("hr"),Lr=o(),Ue=i("a"),wr=o(),a(Re.$$.fragment),Ar=o(),ke=i("p"),ke.textContent=nf,gr=o(),Je=i("p"),Je.innerHTML=rf,Pr=o(),Ee=i("table"),Ee.innerHTML=df,zr=o(),Ur=i("hr"),Rr=o(),je=i("a"),kr=o(),a(De.$$.fragment),Jr=o(),Ie=i("p"),Ie.textContent=uf,Er=o(),qe=i("p"),qe.innerHTML=af,jr=o(),Ke=i("table"),Ke.innerHTML=mf,Dr=o(),Ir=i("hr"),qr=o(),Be=i("a"),Kr=o(),a(Ne.$$.fragment),Br=o(),Qe=i("p"),Qe.textContent=pf,Nr=o(),Ve=i("p"),Ve.innerHTML=cf,Qr=o(),Se=i("table"),Se.innerHTML=Tf,Vr=o(),Sr=i("hr"),Or=o(),Oe=i("a"),Fr=o(),a(Fe.$$.fragment),Yr=o(),Ye=i("p"),Ye.textContent=ff,Wr=o(),We=i("p"),We.innerHTML=hf,Gr=o(),Ge=i("table"),Ge.innerHTML=_f,Xr=o(),Zr=i("hr"),ed=o(),Xe=i("a"),td=o(),a(Ze.$$.fragment),ld=o(),et=i("p"),et.textContent=$f,sd=o(),tt=i("p"),tt.innerHTML=vf,od=o(),lt=i("table"),lt.innerHTML=bf,nd=o(),id=i("hr"),rd=o(),st=i("a"),dd=o(),a(ot.$$.fragment),ud=o(),nt=i("p"),nt.textContent=yf,ad=o(),it=i("p"),it.innerHTML=Mf,md=o(),rt=i("table"),rt.innerHTML=xf,pd=o(),cd=i("hr"),Td=o(),dt=i("a"),fd=o(),a(ut.$$.fragment),hd=o(),at=i("p"),at.textContent=Cf,_d=o(),mt=i("p"),mt.innerHTML=Hf,$d=o(),pt=i("table"),pt.innerHTML=Lf,vd=o(),bd=i("hr"),yd=o(),ct=i("a"),Md=o(),a(Tt.$$.fragment),xd=o(),ft=i("p"),ft.textContent=wf,Cd=o(),ht=i("p"),ht.innerHTML=Af,Hd=o(),_t=i("table"),_t.innerHTML=gf,Ld=o(),wd=i("hr"),Ad=o(),$t=i("a"),gd=o(),a(vt.$$.fragment),Pd=o(),bt=i("p"),bt.textContent=Pf,zd=o(),yt=i("p"),yt.innerHTML=zf,Ud=o(),Mt=i("table"),Mt.innerHTML=Uf,Rd=o(),kd=i("hr"),Jd=o(),xt=i("a"),Ed=o(),a(Ct.$$.fragment),jd=o(),Ht=i("p"),Ht.textContent=Rf,Dd=o(),Lt=i("p"),Lt.innerHTML=kf,Id=o(),wt=i("table"),wt.innerHTML=Jf,qd=o(),Kd=i("hr"),Bd=o(),At=i("a"),Nd=o(),a(gt.$$.fragment),Qd=o(),Pt=i("p"),Pt.textContent=Ef,Vd=o(),zt=i("p"),zt.innerHTML=jf,Sd=o(),Od=i("hr"),Fd=o(),Ut=i("a"),Yd=o(),a(Rt.$$.fragment),Wd=o(),kt=i("p"),kt.textContent=Df,Gd=o(),Jt=i("p"),Jt.textContent=If,Xd=o(),a(Et.$$.fragment),Zd=o(),jt=i("p"),jt.textContent=qf,eu=o(),a(Dt.$$.fragment),tu=o(),It=i("p"),It.textContent=Kf,lu=o(),a(qt.$$.fragment),su=o(),Kt=i("p"),Kt.innerHTML=Bf,ou=o(),Bt=i("ul"),Bt.innerHTML=Nf,nu=o(),Nt=i("table"),Nt.innerHTML=Qf,iu=o(),ru=i("hr"),du=o(),Qt=i("a"),uu=o(),a(Vt.$$.fragment),au=o(),St=i("p"),St.textContent=Vf,mu=o(),Ot=i("p"),Ot.innerHTML=Sf,pu=o(),Ft=i("table"),Ft.innerHTML=Of,cu=o(),Tu=i("hr"),fu=o(),Yt=i("a"),hu=o(),a(Wt.$$.fragment),_u=o(),Gt=i("p"),Gt.textContent=Ff,$u=o(),Xt=i("p"),Xt.innerHTML=Yf,vu=o(),Zt=i("table"),Zt.innerHTML=Wf,bu=o(),yu=i("hr"),Mu=o(),el=i("a"),xu=o(),a(tl.$$.fragment),Cu=o(),ll=i("p"),ll.textContent=Gf,Hu=o(),sl=i("p"),sl.innerHTML=Xf,Lu=o(),ol=i("table"),ol.innerHTML=Zf,wu=o(),Au=i("hr"),gu=o(),nl=i("a"),Pu=o(),a(il.$$.fragment),zu=o(),rl=i("p"),rl.innerHTML=eh,Uu=o(),dl=i("p"),dl.innerHTML=th,Ru=o(),ul=i("table"),ul.innerHTML=lh,ku=o(),Ju=i("hr"),Eu=o(),al=i("a"),ju=o(),a(ml.$$.fragment),Du=o(),pl=i("p"),pl.innerHTML=sh,Iu=o(),cl=i("p"),cl.innerHTML=oh,qu=o(),Tl=i("table"),Tl.innerHTML=nh,Ku=o(),Bu=i("hr"),Nu=o(),fl=i("a"),Qu=o(),a(hl.$$.fragment),Vu=o(),_l=i("p"),_l.textContent=ih,Su=o(),$l=i("p"),$l.innerHTML=rh,Ou=o(),Fu=i("hr"),Yu=o(),vl=i("a"),Wu=o(),a(bl.$$.fragment),Gu=o(),yl=i("p"),yl.textContent=dh,Xu=o(),Ml=i("p"),Ml.innerHTML=uh,Zu=o(),xl=i("p"),xl.innerHTML=ah,ea=o(),Cl=i("table"),Cl.innerHTML=mh,ta=o(),la=i("hr"),sa=o(),Hl=i("a"),oa=o(),a(Ll.$$.fragment),na=o(),wl=i("p"),wl.innerHTML=ph,ia=o(),Al=i("p"),Al.innerHTML=ch,ra=o(),da=i("hr"),ua=o(),gl=i("a"),aa=o(),a(Pl.$$.fragment),ma=o(),zl=i("p"),zl.textContent=Th,pa=o(),Ul=i("p"),Ul.textContent=fh,ca=o(),Rl=i("p"),Rl.innerHTML=hh,Ta=o(),kl=i("table"),kl.innerHTML=_h,fa=o(),ha=i("hr"),_a=o(),Jl=i("a"),$a=o(),a(El.$$.fragment),va=o(),jl=i("p"),jl.innerHTML=$h,ba=o(),Dl=i("p"),Dl.innerHTML=vh,ya=o(),Ma=i("hr"),xa=o(),Il=i("a"),Ca=o(),a(ql.$$.fragment),Ha=o(),Kl=i("p"),Kl.innerHTML=bh,La=o(),Bl=i("p"),Bl.innerHTML=yh,wa=o(),Aa=i("hr"),ga=o(),Nl=i("a"),Pa=o(),a(Ql.$$.fragment),za=o(),Vl=i("p"),Vl.innerHTML=Mh,Ua=o(),Sl=i("p"),Sl.innerHTML=xh,Ra=o(),Ol=i("table"),Ol.innerHTML=Ch,ka=o(),Ja=i("hr"),Ea=o(),Fl=i("a"),ja=o(),a(Yl.$$.fragment),Da=o(),Wl=i("p"),Wl.innerHTML=Hh,Ia=o(),Gl=i("p"),Gl.innerHTML=Lh,qa=o(),Xl=i("table"),Xl.innerHTML=wh,Ka=o(),Ba=i("hr"),Na=o(),Zl=i("a"),Qa=o(),a(es.$$.fragment),Va=o(),ts=i("p"),ts.innerHTML=Ah,Sa=o(),ls=i("p"),ls.innerHTML=gh,Oa=o(),Fa=i("hr"),Ya=o(),ss=i("a"),Wa=o(),a(os.$$.fragment),Ga=o(),ns=i("p"),ns.textContent=Ph,Xa=o(),is=i("p"),is.innerHTML=zh,Za=o(),rs=i("table"),rs.innerHTML=Uh,em=o(),tm=i("hr"),lm=o(),ds=i("a"),sm=o(),a(us.$$.fragment),om=o(),as=i("p"),as.innerHTML=Rh,nm=o(),ms=i("p"),ms.innerHTML=kh,im=o(),rm=i("hr"),dm=o(),ps=i("a"),um=o(),a(cs.$$.fragment),am=o(),Ts=i("p"),Ts.textContent=Jh,mm=o(),fs=i("p"),fs.innerHTML=Eh,pm=o(),cm=i("hr"),Tm=o(),hs=i("a"),fm=o(),a(_s.$$.fragment),hm=o(),$s=i("p"),$s.textContent=jh,_m=o(),vs=i("p"),vs.innerHTML=Dh,$m=o(),bs=i("table"),bs.innerHTML=Ih,vm=o(),bm=i("hr"),ym=o(),ys=i("a"),Mm=o(),a(Ms.$$.fragment),xm=o(),xs=i("p"),xs.textContent=qh,Cm=o(),Cs=i("p"),Cs.innerHTML=Kh,Hm=o(),Hs=i("table"),Hs.innerHTML=Bh,Lm=o(),wm=i("hr"),Am=o(),Ls=i("a"),gm=o(),a(ws.$$.fragment),Pm=o(),As=i("p"),As.textContent=Nh,zm=o(),gs=i("p"),gs.innerHTML=Qh,Um=o(),Ps=i("table"),Ps.innerHTML=Vh,Rm=o(),km=i("hr"),Jm=o(),zs=i("a"),Em=o(),a(Us.$$.fragment),jm=o(),Rs=i("p"),Rs.innerHTML=Sh,Dm=o(),ks=i("p"),ks.innerHTML=Oh,Im=o(),Js=i("table"),Js.innerHTML=Fh,qm=o(),Km=i("hr"),Bm=o(),Es=i("a"),Nm=o(),a(js.$$.fragment),Qm=o(),Ds=i("p"),Ds.innerHTML=Yh,Vm=o(),Is=i("p"),Is.innerHTML=Wh,Sm=o(),qs=i("table"),qs.innerHTML=Gh,Om=o(),Fm=i("hr"),Ym=o(),Ks=i("a"),Wm=o(),a(Bs.$$.fragment),Gm=o(),Ns=i("p"),Ns.innerHTML=Xh,Xm=o(),Qs=i("p"),Qs.innerHTML=Zh,Zm=o(),Vs=i("table"),Vs.innerHTML=e1,ep=o(),tp=i("hr"),lp=o(),Ss=i("a"),sp=o(),a(Os.$$.fragment),op=o(),Fs=i("p"),Fs.innerHTML=t1,np=o(),Ys=i("p"),Ys.innerHTML=l1,ip=o(),Ws=i("table"),Ws.innerHTML=s1,rp=o(),dp=i("hr"),up=o(),Gs=i("a"),ap=o(),a(Xs.$$.fragment),mp=o(),Zs=i("p"),Zs.textContent=o1,pp=o(),eo=i("p"),eo.innerHTML=n1,cp=o(),to=i("table"),to.innerHTML=i1,Tp=o(),fp=i("hr"),hp=o(),lo=i("a"),_p=o(),a(so.$$.fragment),$p=o(),oo=i("p"),oo.textContent=r1,vp=o(),no=i("p"),no.innerHTML=d1,bp=o(),io=i("table"),io.innerHTML=u1,yp=o(),Mp=i("hr"),xp=o(),ro=i("a"),Cp=o(),a(uo.$$.fragment),Hp=o(),ao=i("p"),ao.textContent=a1,Lp=o(),mo=i("p"),mo.innerHTML=m1,wp=o(),po=i("table"),po.innerHTML=p1,Ap=o(),gp=i("hr"),Pp=o(),co=i("a"),zp=o(),a(To.$$.fragment),Up=o(),fo=i("p"),fo.textContent=c1,Rp=o(),ho=i("p"),ho.innerHTML=T1,kp=o(),_o=i("table"),_o.innerHTML=f1,Jp=o(),Ep=i("hr"),jp=o(),$o=i("a"),Dp=o(),a(vo.$$.fragment),Ip=o(),bo=i("p"),bo.innerHTML=h1,qp=o(),yo=i("p"),yo.innerHTML=_1,Kp=o(),Mo=i("table"),Mo.innerHTML=$1,Bp=o(),Np=i("hr"),Qp=o(),xo=i("a"),Vp=o(),a(Co.$$.fragment),Sp=o(),Ho=i("p"),Ho.textContent=v1,Op=o(),Lo=i("p"),Lo.innerHTML=b1,Fp=o(),wo=i("table"),wo.innerHTML=y1,Yp=o(),Wp=i("hr"),Gp=o(),Ao=i("a"),Xp=o(),a(go.$$.fragment),Zp=o(),Po=i("p"),Po.textContent=M1,ec=o(),zo=i("p"),zo.innerHTML=x1,tc=o(),Uo=i("table"),Uo.innerHTML=C1,lc=o(),sc=i("hr"),oc=o(),Ro=i("a"),nc=o(),a(ko.$$.fragment),ic=o(),Jo=i("p"),Jo.textContent=H1,rc=o(),Eo=i("p"),Eo.innerHTML=L1,dc=o(),jo=i("table"),jo.innerHTML=w1,uc=o(),ac=i("hr"),mc=o(),Do=i("a"),pc=o(),a(Io.$$.fragment),cc=o(),qo=i("p"),qo.textContent=A1,Tc=o(),Ko=i("p"),Ko.innerHTML=g1,fc=o(),Bo=i("table"),Bo.innerHTML=P1,hc=o(),_c=i("hr"),$c=o(),No=i("a"),vc=o(),a(Qo.$$.fragment),bc=o(),Vo=i("p"),Vo.textContent=z1,yc=o(),So=i("p"),So.innerHTML=U1,Mc=o(),Oo=i("table"),Oo.innerHTML=R1,xc=o(),Cc=i("hr"),Hc=o(),Fo=i("a"),Lc=o(),a(Yo.$$.fragment),wc=o(),Wo=i("p"),Wo.textContent=k1,Ac=o(),Go=i("p"),Go.innerHTML=J1,gc=o(),Xo=i("table"),Xo.innerHTML=E1,Pc=o(),zc=i("hr"),Uc=o(),Zo=i("a"),Rc=o(),a(en.$$.fragment),kc=o(),tn=i("p"),tn.textContent=j1,Jc=o(),ln=i("p"),ln.innerHTML=D1,Ec=o(),sn=i("table"),sn.innerHTML=I1,jc=o(),Dc=i("hr"),Ic=o(),on=i("a"),qc=o(),a(nn.$$.fragment),Kc=o(),rn=i("p"),rn.innerHTML=q1,Bc=o(),Nc=i("hr"),Qc=o(),dn=i("a"),Vc=o(),a(un.$$.fragment),Sc=o(),an=i("p"),an.textContent=K1,Oc=o(),mn=i("p"),mn.innerHTML=B1,Fc=o(),pn=i("table"),pn.innerHTML=N1,Yc=o(),cn=i("p"),cn.innerHTML=Q1,Wc=o(),a(Tn.$$.fragment),Gc=o(),Xc=i("hr"),Zc=o(),fn=i("a"),eT=o(),a(hn.$$.fragment),tT=o(),_n=i("p"),_n.innerHTML=V1,lT=o(),sT=i("hr"),oT=o(),$n=i("a"),nT=o(),a(vn.$$.fragment),iT=o(),bn=i("p"),bn.innerHTML=S1,rT=o(),dT=i("hr"),uT=o(),yn=i("a"),aT=o(),a(Mn.$$.fragment),mT=o(),xn=i("p"),xn.textContent=O1,pT=o(),Cn=i("p"),Cn.innerHTML=F1,cT=o(),a(Hn.$$.fragment),TT=o(),Ln=i("p"),Ln.innerHTML=Y1,fT=o(),a(wn.$$.fragment),hT=o(),An=i("p"),An.innerHTML=W1,_T=o(),a(gn.$$.fragment),$T=o(),vT=i("hr"),bT=o(),a(Pn.$$.fragment),yT=o(),Rn=i("p"),this.h()},l(e){const t=l_("svelte-u9bgzb",document.head);$=r(t,"META",{name:!0,content:!0}),t.forEach(l),kn=n(e),Un=r(e,"P",{}),h(Un).forEach(l),Jn=n(e),v=r(e,"A",{id:!0,class:!0}),h(v).forEach(l),En=n(e),m(b.$$.fragment,e),jn=n(e),y=r(e,"P",{"data-svelte-h":!0}),d(y)!=="svelte-uw4y1m"&&(y.innerHTML=CT),Dn=n(e),M=r(e,"P",{"data-svelte-h":!0}),d(M)!=="svelte-il3kl8"&&(M.textContent=HT),In=n(e),x=r(e,"UL",{"data-svelte-h":!0}),d(x)!=="svelte-2n8eri"&&(x.innerHTML=LT),qn=n(e),Kn=r(e,"HR",{}),Bn=n(e),C=r(e,"A",{id:!0,class:!0}),h(C).forEach(l),Nn=n(e),m(H.$$.fragment,e),Qn=n(e),L=r(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-1ugrfrw"&&(L.innerHTML=wT),Vn=n(e),w=r(e,"UL",{"data-svelte-h":!0}),d(w)!=="svelte-1qh50n3"&&(w.innerHTML=AT),Sn=n(e),On=r(e,"HR",{}),Fn=n(e),A=r(e,"A",{id:!0,class:!0}),h(A).forEach(l),Yn=n(e),m(g.$$.fragment,e),Wn=n(e),P=r(e,"P",{"data-svelte-h":!0}),d(P)!=="svelte-55wecd"&&(P.textContent=gT),Gn=n(e),z=r(e,"TABLE",{"data-svelte-h":!0}),d(z)!=="svelte-ee7emz"&&(z.innerHTML=PT),Xn=n(e),Zn=r(e,"HR",{}),ei=n(e),U=r(e,"A",{id:!0,class:!0}),h(U).forEach(l),ti=n(e),m(R.$$.fragment,e),li=n(e),k=r(e,"P",{"data-svelte-h":!0}),d(k)!=="svelte-1gc2rt4"&&(k.textContent=zT),si=n(e),J=r(e,"P",{"data-svelte-h":!0}),d(J)!=="svelte-10qzguj"&&(J.innerHTML=UT),oi=n(e),ni=r(e,"HR",{}),ii=n(e),E=r(e,"A",{id:!0,class:!0}),h(E).forEach(l),ri=n(e),m(j.$$.fragment,e),di=n(e),D=r(e,"P",{"data-svelte-h":!0}),d(D)!=="svelte-81y0bb"&&(D.textContent=RT),ui=n(e),I=r(e,"P",{"data-svelte-h":!0}),d(I)!=="svelte-10qzguj"&&(I.innerHTML=kT),ai=n(e),mi=r(e,"HR",{}),pi=n(e),q=r(e,"A",{id:!0,class:!0}),h(q).forEach(l),ci=n(e),m(K.$$.fragment,e),Ti=n(e),B=r(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-1eqabt7"&&(B.textContent=JT),fi=n(e),N=r(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-10qzguj"&&(N.innerHTML=ET),hi=n(e),_i=r(e,"HR",{}),$i=n(e),Q=r(e,"A",{id:!0,class:!0}),h(Q).forEach(l),vi=n(e),m(V.$$.fragment,e),bi=n(e),S=r(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-krrt97"&&(S.textContent=jT),yi=n(e),O=r(e,"P",{"data-svelte-h":!0}),d(O)!=="svelte-10qzguj"&&(O.innerHTML=DT),Mi=n(e),xi=r(e,"HR",{}),Ci=n(e),F=r(e,"A",{id:!0,class:!0}),h(F).forEach(l),Hi=n(e),m(Y.$$.fragment,e),Li=n(e),W=r(e,"P",{"data-svelte-h":!0}),d(W)!=="svelte-1iaptgl"&&(W.textContent=IT),wi=n(e),G=r(e,"P",{"data-svelte-h":!0}),d(G)!=="svelte-10qzguj"&&(G.innerHTML=qT),Ai=n(e),gi=r(e,"HR",{}),Pi=n(e),X=r(e,"A",{id:!0,class:!0}),h(X).forEach(l),zi=n(e),m(Z.$$.fragment,e),Ui=n(e),ee=r(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-1adn56z"&&(ee.textContent=KT),Ri=n(e),te=r(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-1gxgvk6"&&(te.innerHTML=BT),ki=n(e),Ji=r(e,"HR",{}),Ei=n(e),le=r(e,"A",{id:!0,class:!0}),h(le).forEach(l),ji=n(e),m(se.$$.fragment,e),Di=n(e),oe=r(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-1u97xg1"&&(oe.textContent=NT),Ii=n(e),ne=r(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-1afa2dz"&&(ne.innerHTML=QT),qi=n(e),ie=r(e,"TABLE",{"data-svelte-h":!0}),d(ie)!=="svelte-1kq04ga"&&(ie.innerHTML=VT),Ki=n(e),Bi=r(e,"HR",{}),Ni=n(e),re=r(e,"A",{id:!0,class:!0}),h(re).forEach(l),Qi=n(e),m(de.$$.fragment,e),Vi=n(e),ue=r(e,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-1cg22af"&&(ue.innerHTML=ST),Si=n(e),ae=r(e,"TABLE",{"data-svelte-h":!0}),d(ae)!=="svelte-1hful42"&&(ae.innerHTML=OT),Oi=n(e),Fi=r(e,"HR",{}),Yi=n(e),me=r(e,"A",{id:!0,class:!0}),h(me).forEach(l),Wi=n(e),m(pe.$$.fragment,e),Gi=n(e),ce=r(e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-1mr58c3"&&(ce.innerHTML=FT),Xi=n(e),Te=r(e,"TABLE",{"data-svelte-h":!0}),d(Te)!=="svelte-153ftfy"&&(Te.innerHTML=YT),Zi=n(e),er=r(e,"HR",{}),tr=n(e),fe=r(e,"A",{id:!0,class:!0}),h(fe).forEach(l),lr=n(e),m(he.$$.fragment,e),sr=n(e),_e=r(e,"P",{"data-svelte-h":!0}),d(_e)!=="svelte-13nzfs3"&&(_e.innerHTML=WT),or=n(e),$e=r(e,"P",{"data-svelte-h":!0}),d($e)!=="svelte-11rv1mu"&&($e.innerHTML=GT),nr=n(e),ve=r(e,"UL",{"data-svelte-h":!0}),d(ve)!=="svelte-5t2sg3"&&(ve.innerHTML=XT),ir=n(e),rr=r(e,"HR",{}),dr=n(e),be=r(e,"A",{id:!0,class:!0}),h(be).forEach(l),ur=n(e),m(ye.$$.fragment,e),ar=n(e),Me=r(e,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-87xdyr"&&(Me.textContent=ZT),mr=n(e),xe=r(e,"P",{"data-svelte-h":!0}),d(xe)!=="svelte-1mr58c3"&&(xe.innerHTML=ef),pr=n(e),cr=r(e,"HR",{}),Tr=n(e),Ce=r(e,"A",{id:!0,class:!0}),h(Ce).forEach(l),fr=n(e),m(He.$$.fragment,e),hr=n(e),Le=r(e,"P",{"data-svelte-h":!0}),d(Le)!=="svelte-2wti2w"&&(Le.textContent=tf),_r=n(e),we=r(e,"P",{"data-svelte-h":!0}),d(we)!=="svelte-kpq7mo"&&(we.innerHTML=lf),$r=n(e),vr=r(e,"HR",{}),br=n(e),Ae=r(e,"A",{id:!0,class:!0}),h(Ae).forEach(l),yr=n(e),m(ge.$$.fragment,e),Mr=n(e),Pe=r(e,"P",{"data-svelte-h":!0}),d(Pe)!=="svelte-1edu6c8"&&(Pe.textContent=sf),xr=n(e),ze=r(e,"P",{"data-svelte-h":!0}),d(ze)!=="svelte-1hc4oxa"&&(ze.innerHTML=of),Cr=n(e),Hr=r(e,"HR",{}),Lr=n(e),Ue=r(e,"A",{id:!0,class:!0}),h(Ue).forEach(l),wr=n(e),m(Re.$$.fragment,e),Ar=n(e),ke=r(e,"P",{"data-svelte-h":!0}),d(ke)!=="svelte-az0crx"&&(ke.textContent=nf),gr=n(e),Je=r(e,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-r66g1b"&&(Je.innerHTML=rf),Pr=n(e),Ee=r(e,"TABLE",{"data-svelte-h":!0}),d(Ee)!=="svelte-1ok4yhn"&&(Ee.innerHTML=df),zr=n(e),Ur=r(e,"HR",{}),Rr=n(e),je=r(e,"A",{id:!0,class:!0}),h(je).forEach(l),kr=n(e),m(De.$$.fragment,e),Jr=n(e),Ie=r(e,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-jlfq15"&&(Ie.textContent=uf),Er=n(e),qe=r(e,"P",{"data-svelte-h":!0}),d(qe)!=="svelte-1hc4oxa"&&(qe.innerHTML=af),jr=n(e),Ke=r(e,"TABLE",{"data-svelte-h":!0}),d(Ke)!=="svelte-1ok4yhn"&&(Ke.innerHTML=mf),Dr=n(e),Ir=r(e,"HR",{}),qr=n(e),Be=r(e,"A",{id:!0,class:!0}),h(Be).forEach(l),Kr=n(e),m(Ne.$$.fragment,e),Br=n(e),Qe=r(e,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-xg80lg"&&(Qe.textContent=pf),Nr=n(e),Ve=r(e,"P",{"data-svelte-h":!0}),d(Ve)!=="svelte-1aygav2"&&(Ve.innerHTML=cf),Qr=n(e),Se=r(e,"TABLE",{"data-svelte-h":!0}),d(Se)!=="svelte-1tbtmqd"&&(Se.innerHTML=Tf),Vr=n(e),Sr=r(e,"HR",{}),Or=n(e),Oe=r(e,"A",{id:!0,class:!0}),h(Oe).forEach(l),Fr=n(e),m(Fe.$$.fragment,e),Yr=n(e),Ye=r(e,"P",{"data-svelte-h":!0}),d(Ye)!=="svelte-1i12x1s"&&(Ye.textContent=ff),Wr=n(e),We=r(e,"P",{"data-svelte-h":!0}),d(We)!=="svelte-1hc4oxa"&&(We.innerHTML=hf),Gr=n(e),Ge=r(e,"TABLE",{"data-svelte-h":!0}),d(Ge)!=="svelte-1tbtmqd"&&(Ge.innerHTML=_f),Xr=n(e),Zr=r(e,"HR",{}),ed=n(e),Xe=r(e,"A",{id:!0,class:!0}),h(Xe).forEach(l),td=n(e),m(Ze.$$.fragment,e),ld=n(e),et=r(e,"P",{"data-svelte-h":!0}),d(et)!=="svelte-45kvaw"&&(et.textContent=$f),sd=n(e),tt=r(e,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-1aygav2"&&(tt.innerHTML=vf),od=n(e),lt=r(e,"TABLE",{"data-svelte-h":!0}),d(lt)!=="svelte-46t58i"&&(lt.innerHTML=bf),nd=n(e),id=r(e,"HR",{}),rd=n(e),st=r(e,"A",{id:!0,class:!0}),h(st).forEach(l),dd=n(e),m(ot.$$.fragment,e),ud=n(e),nt=r(e,"P",{"data-svelte-h":!0}),d(nt)!=="svelte-6s524n"&&(nt.textContent=yf),ad=n(e),it=r(e,"P",{"data-svelte-h":!0}),d(it)!=="svelte-1hc4oxa"&&(it.innerHTML=Mf),md=n(e),rt=r(e,"TABLE",{"data-svelte-h":!0}),d(rt)!=="svelte-46t58i"&&(rt.innerHTML=xf),pd=n(e),cd=r(e,"HR",{}),Td=n(e),dt=r(e,"A",{id:!0,class:!0}),h(dt).forEach(l),fd=n(e),m(ut.$$.fragment,e),hd=n(e),at=r(e,"P",{"data-svelte-h":!0}),d(at)!=="svelte-1hl64jn"&&(at.textContent=Cf),_d=n(e),mt=r(e,"P",{"data-svelte-h":!0}),d(mt)!=="svelte-1aygav2"&&(mt.innerHTML=Hf),$d=n(e),pt=r(e,"TABLE",{"data-svelte-h":!0}),d(pt)!=="svelte-1p5444"&&(pt.innerHTML=Lf),vd=n(e),bd=r(e,"HR",{}),yd=n(e),ct=r(e,"A",{id:!0,class:!0}),h(ct).forEach(l),Md=n(e),m(Tt.$$.fragment,e),xd=n(e),ft=r(e,"P",{"data-svelte-h":!0}),d(ft)!=="svelte-bbf4x3"&&(ft.textContent=wf),Cd=n(e),ht=r(e,"P",{"data-svelte-h":!0}),d(ht)!=="svelte-1hc4oxa"&&(ht.innerHTML=Af),Hd=n(e),_t=r(e,"TABLE",{"data-svelte-h":!0}),d(_t)!=="svelte-1p5444"&&(_t.innerHTML=gf),Ld=n(e),wd=r(e,"HR",{}),Ad=n(e),$t=r(e,"A",{id:!0,class:!0}),h($t).forEach(l),gd=n(e),m(vt.$$.fragment,e),Pd=n(e),bt=r(e,"P",{"data-svelte-h":!0}),d(bt)!=="svelte-wbrx6g"&&(bt.textContent=Pf),zd=n(e),yt=r(e,"P",{"data-svelte-h":!0}),d(yt)!=="svelte-1aygav2"&&(yt.innerHTML=zf),Ud=n(e),Mt=r(e,"TABLE",{"data-svelte-h":!0}),d(Mt)!=="svelte-flm2g1"&&(Mt.innerHTML=Uf),Rd=n(e),kd=r(e,"HR",{}),Jd=n(e),xt=r(e,"A",{id:!0,class:!0}),h(xt).forEach(l),Ed=n(e),m(Ct.$$.fragment,e),jd=n(e),Ht=r(e,"P",{"data-svelte-h":!0}),d(Ht)!=="svelte-wqxtec"&&(Ht.textContent=Rf),Dd=n(e),Lt=r(e,"P",{"data-svelte-h":!0}),d(Lt)!=="svelte-1hc4oxa"&&(Lt.innerHTML=kf),Id=n(e),wt=r(e,"TABLE",{"data-svelte-h":!0}),d(wt)!=="svelte-flm2g1"&&(wt.innerHTML=Jf),qd=n(e),Kd=r(e,"HR",{}),Bd=n(e),At=r(e,"A",{id:!0,class:!0}),h(At).forEach(l),Nd=n(e),m(gt.$$.fragment,e),Qd=n(e),Pt=r(e,"P",{"data-svelte-h":!0}),d(Pt)!=="svelte-zftqbb"&&(Pt.textContent=Ef),Vd=n(e),zt=r(e,"P",{"data-svelte-h":!0}),d(zt)!=="svelte-ct2ucb"&&(zt.innerHTML=jf),Sd=n(e),Od=r(e,"HR",{}),Fd=n(e),Ut=r(e,"A",{id:!0,class:!0}),h(Ut).forEach(l),Yd=n(e),m(Rt.$$.fragment,e),Wd=n(e),kt=r(e,"P",{"data-svelte-h":!0}),d(kt)!=="svelte-yalim1"&&(kt.textContent=Df),Gd=n(e),Jt=r(e,"P",{"data-svelte-h":!0}),d(Jt)!=="svelte-v4sb1d"&&(Jt.textContent=If),Xd=n(e),m(Et.$$.fragment,e),Zd=n(e),jt=r(e,"P",{"data-svelte-h":!0}),d(jt)!=="svelte-1qggjsc"&&(jt.textContent=qf),eu=n(e),m(Dt.$$.fragment,e),tu=n(e),It=r(e,"P",{"data-svelte-h":!0}),d(It)!=="svelte-gtrr4w"&&(It.textContent=Kf),lu=n(e),m(qt.$$.fragment,e),su=n(e),Kt=r(e,"P",{"data-svelte-h":!0}),d(Kt)!=="svelte-1m25983"&&(Kt.innerHTML=Bf),ou=n(e),Bt=r(e,"UL",{"data-svelte-h":!0}),d(Bt)!=="svelte-2ixnrf"&&(Bt.innerHTML=Nf),nu=n(e),Nt=r(e,"TABLE",{"data-svelte-h":!0}),d(Nt)!=="svelte-xutatr"&&(Nt.innerHTML=Qf),iu=n(e),ru=r(e,"HR",{}),du=n(e),Qt=r(e,"A",{id:!0,class:!0}),h(Qt).forEach(l),uu=n(e),m(Vt.$$.fragment,e),au=n(e),St=r(e,"P",{"data-svelte-h":!0}),d(St)!=="svelte-1g8ouql"&&(St.textContent=Vf),mu=n(e),Ot=r(e,"P",{"data-svelte-h":!0}),d(Ot)!=="svelte-1scc4l4"&&(Ot.innerHTML=Sf),pu=n(e),Ft=r(e,"TABLE",{"data-svelte-h":!0}),d(Ft)!=="svelte-1p49qvp"&&(Ft.innerHTML=Of),cu=n(e),Tu=r(e,"HR",{}),fu=n(e),Yt=r(e,"A",{id:!0,class:!0}),h(Yt).forEach(l),hu=n(e),m(Wt.$$.fragment,e),_u=n(e),Gt=r(e,"P",{"data-svelte-h":!0}),d(Gt)!=="svelte-yjryb1"&&(Gt.textContent=Ff),$u=n(e),Xt=r(e,"P",{"data-svelte-h":!0}),d(Xt)!=="svelte-xtr8tc"&&(Xt.innerHTML=Yf),vu=n(e),Zt=r(e,"TABLE",{"data-svelte-h":!0}),d(Zt)!=="svelte-6xvdso"&&(Zt.innerHTML=Wf),bu=n(e),yu=r(e,"HR",{}),Mu=n(e),el=r(e,"A",{id:!0,class:!0}),h(el).forEach(l),xu=n(e),m(tl.$$.fragment,e),Cu=n(e),ll=r(e,"P",{"data-svelte-h":!0}),d(ll)!=="svelte-1okfsqx"&&(ll.textContent=Gf),Hu=n(e),sl=r(e,"P",{"data-svelte-h":!0}),d(sl)!=="svelte-1t556pk"&&(sl.innerHTML=Xf),Lu=n(e),ol=r(e,"TABLE",{"data-svelte-h":!0}),d(ol)!=="svelte-13m2wni"&&(ol.innerHTML=Zf),wu=n(e),Au=r(e,"HR",{}),gu=n(e),nl=r(e,"A",{id:!0,class:!0}),h(nl).forEach(l),Pu=n(e),m(il.$$.fragment,e),zu=n(e),rl=r(e,"P",{"data-svelte-h":!0}),d(rl)!=="svelte-1htpbrk"&&(rl.innerHTML=eh),Uu=n(e),dl=r(e,"P",{"data-svelte-h":!0}),d(dl)!=="svelte-1t0m8l6"&&(dl.innerHTML=th),Ru=n(e),ul=r(e,"TABLE",{"data-svelte-h":!0}),d(ul)!=="svelte-1qi99pl"&&(ul.innerHTML=lh),ku=n(e),Ju=r(e,"HR",{}),Eu=n(e),al=r(e,"A",{id:!0,class:!0}),h(al).forEach(l),ju=n(e),m(ml.$$.fragment,e),Du=n(e),pl=r(e,"P",{"data-svelte-h":!0}),d(pl)!=="svelte-1ztgqp"&&(pl.innerHTML=sh),Iu=n(e),cl=r(e,"P",{"data-svelte-h":!0}),d(cl)!=="svelte-mvb39p"&&(cl.innerHTML=oh),qu=n(e),Tl=r(e,"TABLE",{"data-svelte-h":!0}),d(Tl)!=="svelte-1qi99pl"&&(Tl.innerHTML=nh),Ku=n(e),Bu=r(e,"HR",{}),Nu=n(e),fl=r(e,"A",{id:!0,class:!0}),h(fl).forEach(l),Qu=n(e),m(hl.$$.fragment,e),Vu=n(e),_l=r(e,"P",{"data-svelte-h":!0}),d(_l)!=="svelte-1a7u185"&&(_l.textContent=ih),Su=n(e),$l=r(e,"P",{"data-svelte-h":!0}),d($l)!=="svelte-1eu3doh"&&($l.innerHTML=rh),Ou=n(e),Fu=r(e,"HR",{}),Yu=n(e),vl=r(e,"A",{id:!0,class:!0}),h(vl).forEach(l),Wu=n(e),m(bl.$$.fragment,e),Gu=n(e),yl=r(e,"P",{"data-svelte-h":!0}),d(yl)!=="svelte-qls17b"&&(yl.textContent=dh),Xu=n(e),Ml=r(e,"P",{"data-svelte-h":!0}),d(Ml)!=="svelte-5nabmy"&&(Ml.innerHTML=uh),Zu=n(e),xl=r(e,"P",{"data-svelte-h":!0}),d(xl)!=="svelte-muvb5c"&&(xl.innerHTML=ah),ea=n(e),Cl=r(e,"TABLE",{"data-svelte-h":!0}),d(Cl)!=="svelte-52pnzr"&&(Cl.innerHTML=mh),ta=n(e),la=r(e,"HR",{}),sa=n(e),Hl=r(e,"A",{id:!0,class:!0}),h(Hl).forEach(l),oa=n(e),m(Ll.$$.fragment,e),na=n(e),wl=r(e,"P",{"data-svelte-h":!0}),d(wl)!=="svelte-19w0pic"&&(wl.innerHTML=ph),ia=n(e),Al=r(e,"P",{"data-svelte-h":!0}),d(Al)!=="svelte-1mr58c3"&&(Al.innerHTML=ch),ra=n(e),da=r(e,"HR",{}),ua=n(e),gl=r(e,"A",{id:!0,class:!0}),h(gl).forEach(l),aa=n(e),m(Pl.$$.fragment,e),ma=n(e),zl=r(e,"P",{"data-svelte-h":!0}),d(zl)!=="svelte-18ws76n"&&(zl.textContent=Th),pa=n(e),Ul=r(e,"P",{"data-svelte-h":!0}),d(Ul)!=="svelte-1tnr5gm"&&(Ul.textContent=fh),ca=n(e),Rl=r(e,"P",{"data-svelte-h":!0}),d(Rl)!=="svelte-1si6y4t"&&(Rl.innerHTML=hh),Ta=n(e),kl=r(e,"TABLE",{"data-svelte-h":!0}),d(kl)!=="svelte-1u9lyxp"&&(kl.innerHTML=_h),fa=n(e),ha=r(e,"HR",{}),_a=n(e),Jl=r(e,"A",{id:!0,class:!0}),h(Jl).forEach(l),$a=n(e),m(El.$$.fragment,e),va=n(e),jl=r(e,"P",{"data-svelte-h":!0}),d(jl)!=="svelte-1b9ygao"&&(jl.innerHTML=$h),ba=n(e),Dl=r(e,"P",{"data-svelte-h":!0}),d(Dl)!=="svelte-1mr58c3"&&(Dl.innerHTML=vh),ya=n(e),Ma=r(e,"HR",{}),xa=n(e),Il=r(e,"A",{id:!0,class:!0}),h(Il).forEach(l),Ca=n(e),m(ql.$$.fragment,e),Ha=n(e),Kl=r(e,"P",{"data-svelte-h":!0}),d(Kl)!=="svelte-1vkr5xo"&&(Kl.innerHTML=bh),La=n(e),Bl=r(e,"P",{"data-svelte-h":!0}),d(Bl)!=="svelte-1mr58c3"&&(Bl.innerHTML=yh),wa=n(e),Aa=r(e,"HR",{}),ga=n(e),Nl=r(e,"A",{id:!0,class:!0}),h(Nl).forEach(l),Pa=n(e),m(Ql.$$.fragment,e),za=n(e),Vl=r(e,"P",{"data-svelte-h":!0}),d(Vl)!=="svelte-1gguudf"&&(Vl.innerHTML=Mh),Ua=n(e),Sl=r(e,"P",{"data-svelte-h":!0}),d(Sl)!=="svelte-6vkfxj"&&(Sl.innerHTML=xh),Ra=n(e),Ol=r(e,"TABLE",{"data-svelte-h":!0}),d(Ol)!=="svelte-z6whez"&&(Ol.innerHTML=Ch),ka=n(e),Ja=r(e,"HR",{}),Ea=n(e),Fl=r(e,"A",{id:!0,class:!0}),h(Fl).forEach(l),ja=n(e),m(Yl.$$.fragment,e),Da=n(e),Wl=r(e,"P",{"data-svelte-h":!0}),d(Wl)!=="svelte-d6gvut"&&(Wl.innerHTML=Hh),Ia=n(e),Gl=r(e,"P",{"data-svelte-h":!0}),d(Gl)!=="svelte-18n9ux4"&&(Gl.innerHTML=Lh),qa=n(e),Xl=r(e,"TABLE",{"data-svelte-h":!0}),d(Xl)!=="svelte-jj58dd"&&(Xl.innerHTML=wh),Ka=n(e),Ba=r(e,"HR",{}),Na=n(e),Zl=r(e,"A",{id:!0,class:!0}),h(Zl).forEach(l),Qa=n(e),m(es.$$.fragment,e),Va=n(e),ts=r(e,"P",{"data-svelte-h":!0}),d(ts)!=="svelte-1adolpg"&&(ts.innerHTML=Ah),Sa=n(e),ls=r(e,"P",{"data-svelte-h":!0}),d(ls)!=="svelte-1mr58c3"&&(ls.innerHTML=gh),Oa=n(e),Fa=r(e,"HR",{}),Ya=n(e),ss=r(e,"A",{id:!0,class:!0}),h(ss).forEach(l),Wa=n(e),m(os.$$.fragment,e),Ga=n(e),ns=r(e,"P",{"data-svelte-h":!0}),d(ns)!=="svelte-1hm8vtj"&&(ns.textContent=Ph),Xa=n(e),is=r(e,"P",{"data-svelte-h":!0}),d(is)!=="svelte-1ywpke5"&&(is.innerHTML=zh),Za=n(e),rs=r(e,"TABLE",{"data-svelte-h":!0}),d(rs)!=="svelte-9ff0sy"&&(rs.innerHTML=Uh),em=n(e),tm=r(e,"HR",{}),lm=n(e),ds=r(e,"A",{id:!0,class:!0}),h(ds).forEach(l),sm=n(e),m(us.$$.fragment,e),om=n(e),as=r(e,"P",{"data-svelte-h":!0}),d(as)!=="svelte-1e6kzks"&&(as.innerHTML=Rh),nm=n(e),ms=r(e,"P",{"data-svelte-h":!0}),d(ms)!=="svelte-1mr58c3"&&(ms.innerHTML=kh),im=n(e),rm=r(e,"HR",{}),dm=n(e),ps=r(e,"A",{id:!0,class:!0}),h(ps).forEach(l),um=n(e),m(cs.$$.fragment,e),am=n(e),Ts=r(e,"P",{"data-svelte-h":!0}),d(Ts)!=="svelte-t5k6jp"&&(Ts.textContent=Jh),mm=n(e),fs=r(e,"P",{"data-svelte-h":!0}),d(fs)!=="svelte-1ywpke5"&&(fs.innerHTML=Eh),pm=n(e),cm=r(e,"HR",{}),Tm=n(e),hs=r(e,"A",{id:!0,class:!0}),h(hs).forEach(l),fm=n(e),m(_s.$$.fragment,e),hm=n(e),$s=r(e,"P",{"data-svelte-h":!0}),d($s)!=="svelte-avw2a1"&&($s.textContent=jh),_m=n(e),vs=r(e,"P",{"data-svelte-h":!0}),d(vs)!=="svelte-16q99cu"&&(vs.innerHTML=Dh),$m=n(e),bs=r(e,"TABLE",{"data-svelte-h":!0}),d(bs)!=="svelte-jj5vaa"&&(bs.innerHTML=Ih),vm=n(e),bm=r(e,"HR",{}),ym=n(e),ys=r(e,"A",{id:!0,class:!0}),h(ys).forEach(l),Mm=n(e),m(Ms.$$.fragment,e),xm=n(e),xs=r(e,"P",{"data-svelte-h":!0}),d(xs)!=="svelte-167n5bd"&&(xs.textContent=qh),Cm=n(e),Cs=r(e,"P",{"data-svelte-h":!0}),d(Cs)!=="svelte-1pz529g"&&(Cs.innerHTML=Kh),Hm=n(e),Hs=r(e,"TABLE",{"data-svelte-h":!0}),d(Hs)!=="svelte-1oyadc3"&&(Hs.innerHTML=Bh),Lm=n(e),wm=r(e,"HR",{}),Am=n(e),Ls=r(e,"A",{id:!0,class:!0}),h(Ls).forEach(l),gm=n(e),m(ws.$$.fragment,e),Pm=n(e),As=r(e,"P",{"data-svelte-h":!0}),d(As)!=="svelte-fju8tm"&&(As.textContent=Nh),zm=n(e),gs=r(e,"P",{"data-svelte-h":!0}),d(gs)!=="svelte-13s6o0v"&&(gs.innerHTML=Qh),Um=n(e),Ps=r(e,"TABLE",{"data-svelte-h":!0}),d(Ps)!=="svelte-8i278m"&&(Ps.innerHTML=Vh),Rm=n(e),km=r(e,"HR",{}),Jm=n(e),zs=r(e,"A",{id:!0,class:!0}),h(zs).forEach(l),Em=n(e),m(Us.$$.fragment,e),jm=n(e),Rs=r(e,"P",{"data-svelte-h":!0}),d(Rs)!=="svelte-18v04la"&&(Rs.innerHTML=Sh),Dm=n(e),ks=r(e,"P",{"data-svelte-h":!0}),d(ks)!=="svelte-16ws0dc"&&(ks.innerHTML=Oh),Im=n(e),Js=r(e,"TABLE",{"data-svelte-h":!0}),d(Js)!=="svelte-14k2n4x"&&(Js.innerHTML=Fh),qm=n(e),Km=r(e,"HR",{}),Bm=n(e),Es=r(e,"A",{id:!0,class:!0}),h(Es).forEach(l),Nm=n(e),m(js.$$.fragment,e),Qm=n(e),Ds=r(e,"P",{"data-svelte-h":!0}),d(Ds)!=="svelte-1yvow13"&&(Ds.innerHTML=Yh),Vm=n(e),Is=r(e,"P",{"data-svelte-h":!0}),d(Is)!=="svelte-13n2k7m"&&(Is.innerHTML=Wh),Sm=n(e),qs=r(e,"TABLE",{"data-svelte-h":!0}),d(qs)!=="svelte-1ha3siw"&&(qs.innerHTML=Gh),Om=n(e),Fm=r(e,"HR",{}),Ym=n(e),Ks=r(e,"A",{id:!0,class:!0}),h(Ks).forEach(l),Wm=n(e),m(Bs.$$.fragment,e),Gm=n(e),Ns=r(e,"P",{"data-svelte-h":!0}),d(Ns)!=="svelte-19dtamh"&&(Ns.innerHTML=Xh),Xm=n(e),Qs=r(e,"P",{"data-svelte-h":!0}),d(Qs)!=="svelte-1nr5iz8"&&(Qs.innerHTML=Zh),Zm=n(e),Vs=r(e,"TABLE",{"data-svelte-h":!0}),d(Vs)!=="svelte-1hw4pq9"&&(Vs.innerHTML=e1),ep=n(e),tp=r(e,"HR",{}),lp=n(e),Ss=r(e,"A",{id:!0,class:!0}),h(Ss).forEach(l),sp=n(e),m(Os.$$.fragment,e),op=n(e),Fs=r(e,"P",{"data-svelte-h":!0}),d(Fs)!=="svelte-bd7moq"&&(Fs.innerHTML=t1),np=n(e),Ys=r(e,"P",{"data-svelte-h":!0}),d(Ys)!=="svelte-jyg3bg"&&(Ys.innerHTML=l1),ip=n(e),Ws=r(e,"TABLE",{"data-svelte-h":!0}),d(Ws)!=="svelte-1sdadnq"&&(Ws.innerHTML=s1),rp=n(e),dp=r(e,"HR",{}),up=n(e),Gs=r(e,"A",{id:!0,class:!0}),h(Gs).forEach(l),ap=n(e),m(Xs.$$.fragment,e),mp=n(e),Zs=r(e,"P",{"data-svelte-h":!0}),d(Zs)!=="svelte-11ei68w"&&(Zs.textContent=o1),pp=n(e),eo=r(e,"P",{"data-svelte-h":!0}),d(eo)!=="svelte-1p3llh"&&(eo.innerHTML=n1),cp=n(e),to=r(e,"TABLE",{"data-svelte-h":!0}),d(to)!=="svelte-1xe0vb8"&&(to.innerHTML=i1),Tp=n(e),fp=r(e,"HR",{}),hp=n(e),lo=r(e,"A",{id:!0,class:!0}),h(lo).forEach(l),_p=n(e),m(so.$$.fragment,e),$p=n(e),oo=r(e,"P",{"data-svelte-h":!0}),d(oo)!=="svelte-7ivim4"&&(oo.textContent=r1),vp=n(e),no=r(e,"P",{"data-svelte-h":!0}),d(no)!=="svelte-151n4qz"&&(no.innerHTML=d1),bp=n(e),io=r(e,"TABLE",{"data-svelte-h":!0}),d(io)!=="svelte-iprxta"&&(io.innerHTML=u1),yp=n(e),Mp=r(e,"HR",{}),xp=n(e),ro=r(e,"A",{id:!0,class:!0}),h(ro).forEach(l),Cp=n(e),m(uo.$$.fragment,e),Hp=n(e),ao=r(e,"P",{"data-svelte-h":!0}),d(ao)!=="svelte-k6p1db"&&(ao.textContent=a1),Lp=n(e),mo=r(e,"P",{"data-svelte-h":!0}),d(mo)!=="svelte-1o30xnd"&&(mo.innerHTML=m1),wp=n(e),po=r(e,"TABLE",{"data-svelte-h":!0}),d(po)!=="svelte-101obk2"&&(po.innerHTML=p1),Ap=n(e),gp=r(e,"HR",{}),Pp=n(e),co=r(e,"A",{id:!0,class:!0}),h(co).forEach(l),zp=n(e),m(To.$$.fragment,e),Up=n(e),fo=r(e,"P",{"data-svelte-h":!0}),d(fo)!=="svelte-8afo9v"&&(fo.textContent=c1),Rp=n(e),ho=r(e,"P",{"data-svelte-h":!0}),d(ho)!=="svelte-1vvmhgz"&&(ho.innerHTML=T1),kp=n(e),_o=r(e,"TABLE",{"data-svelte-h":!0}),d(_o)!=="svelte-wz2jkw"&&(_o.innerHTML=f1),Jp=n(e),Ep=r(e,"HR",{}),jp=n(e),$o=r(e,"A",{id:!0,class:!0}),h($o).forEach(l),Dp=n(e),m(vo.$$.fragment,e),Ip=n(e),bo=r(e,"P",{"data-svelte-h":!0}),d(bo)!=="svelte-11plveb"&&(bo.innerHTML=h1),qp=n(e),yo=r(e,"P",{"data-svelte-h":!0}),d(yo)!=="svelte-1wu8g4g"&&(yo.innerHTML=_1),Kp=n(e),Mo=r(e,"TABLE",{"data-svelte-h":!0}),d(Mo)!=="svelte-1vsvca3"&&(Mo.innerHTML=$1),Bp=n(e),Np=r(e,"HR",{}),Qp=n(e),xo=r(e,"A",{id:!0,class:!0}),h(xo).forEach(l),Vp=n(e),m(Co.$$.fragment,e),Sp=n(e),Ho=r(e,"P",{"data-svelte-h":!0}),d(Ho)!=="svelte-17f4oxi"&&(Ho.textContent=v1),Op=n(e),Lo=r(e,"P",{"data-svelte-h":!0}),d(Lo)!=="svelte-2yq8vx"&&(Lo.innerHTML=b1),Fp=n(e),wo=r(e,"TABLE",{"data-svelte-h":!0}),d(wo)!=="svelte-m4z8c4"&&(wo.innerHTML=y1),Yp=n(e),Wp=r(e,"HR",{}),Gp=n(e),Ao=r(e,"A",{id:!0,class:!0}),h(Ao).forEach(l),Xp=n(e),m(go.$$.fragment,e),Zp=n(e),Po=r(e,"P",{"data-svelte-h":!0}),d(Po)!=="svelte-10qu7f7"&&(Po.textContent=M1),ec=n(e),zo=r(e,"P",{"data-svelte-h":!0}),d(zo)!=="svelte-14iug9a"&&(zo.innerHTML=x1),tc=n(e),Uo=r(e,"TABLE",{"data-svelte-h":!0}),d(Uo)!=="svelte-1xtb381"&&(Uo.innerHTML=C1),lc=n(e),sc=r(e,"HR",{}),oc=n(e),Ro=r(e,"A",{id:!0,class:!0}),h(Ro).forEach(l),nc=n(e),m(ko.$$.fragment,e),ic=n(e),Jo=r(e,"P",{"data-svelte-h":!0}),d(Jo)!=="svelte-1ayje0f"&&(Jo.textContent=H1),rc=n(e),Eo=r(e,"P",{"data-svelte-h":!0}),d(Eo)!=="svelte-1ywifoz"&&(Eo.innerHTML=L1),dc=n(e),jo=r(e,"TABLE",{"data-svelte-h":!0}),d(jo)!=="svelte-gyxne1"&&(jo.innerHTML=w1),uc=n(e),ac=r(e,"HR",{}),mc=n(e),Do=r(e,"A",{id:!0,class:!0}),h(Do).forEach(l),pc=n(e),m(Io.$$.fragment,e),cc=n(e),qo=r(e,"P",{"data-svelte-h":!0}),d(qo)!=="svelte-1wvb8sq"&&(qo.textContent=A1),Tc=n(e),Ko=r(e,"P",{"data-svelte-h":!0}),d(Ko)!=="svelte-1ywifoz"&&(Ko.innerHTML=g1),fc=n(e),Bo=r(e,"TABLE",{"data-svelte-h":!0}),d(Bo)!=="svelte-1fk5fng"&&(Bo.innerHTML=P1),hc=n(e),_c=r(e,"HR",{}),$c=n(e),No=r(e,"A",{id:!0,class:!0}),h(No).forEach(l),vc=n(e),m(Qo.$$.fragment,e),bc=n(e),Vo=r(e,"P",{"data-svelte-h":!0}),d(Vo)!=="svelte-1798kaw"&&(Vo.textContent=z1),yc=n(e),So=r(e,"P",{"data-svelte-h":!0}),d(So)!=="svelte-11aypax"&&(So.innerHTML=U1),Mc=n(e),Oo=r(e,"TABLE",{"data-svelte-h":!0}),d(Oo)!=="svelte-gyxne1"&&(Oo.innerHTML=R1),xc=n(e),Cc=r(e,"HR",{}),Hc=n(e),Fo=r(e,"A",{id:!0,class:!0}),h(Fo).forEach(l),Lc=n(e),m(Yo.$$.fragment,e),wc=n(e),Wo=r(e,"P",{"data-svelte-h":!0}),d(Wo)!=="svelte-9nnpip"&&(Wo.textContent=k1),Ac=n(e),Go=r(e,"P",{"data-svelte-h":!0}),d(Go)!=="svelte-11aypax"&&(Go.innerHTML=J1),gc=n(e),Xo=r(e,"TABLE",{"data-svelte-h":!0}),d(Xo)!=="svelte-1fk5fng"&&(Xo.innerHTML=E1),Pc=n(e),zc=r(e,"HR",{}),Uc=n(e),Zo=r(e,"A",{id:!0,class:!0}),h(Zo).forEach(l),Rc=n(e),m(en.$$.fragment,e),kc=n(e),tn=r(e,"P",{"data-svelte-h":!0}),d(tn)!=="svelte-185sm1b"&&(tn.textContent=j1),Jc=n(e),ln=r(e,"P",{"data-svelte-h":!0}),d(ln)!=="svelte-1y8qzzr"&&(ln.innerHTML=D1),Ec=n(e),sn=r(e,"TABLE",{"data-svelte-h":!0}),d(sn)!=="svelte-1v01t7k"&&(sn.innerHTML=I1),jc=n(e),Dc=r(e,"HR",{}),Ic=n(e),on=r(e,"A",{id:!0,class:!0}),h(on).forEach(l),qc=n(e),m(nn.$$.fragment,e),Kc=n(e),rn=r(e,"P",{"data-svelte-h":!0}),d(rn)!=="svelte-12loz97"&&(rn.innerHTML=q1),Bc=n(e),Nc=r(e,"HR",{}),Qc=n(e),dn=r(e,"A",{id:!0,class:!0}),h(dn).forEach(l),Vc=n(e),m(un.$$.fragment,e),Sc=n(e),an=r(e,"P",{"data-svelte-h":!0}),d(an)!=="svelte-40isdg"&&(an.textContent=K1),Oc=n(e),mn=r(e,"P",{"data-svelte-h":!0}),d(mn)!=="svelte-tlsa2h"&&(mn.innerHTML=B1),Fc=n(e),pn=r(e,"TABLE",{"data-svelte-h":!0}),d(pn)!=="svelte-17343p6"&&(pn.innerHTML=N1),Yc=n(e),cn=r(e,"P",{"data-svelte-h":!0}),d(cn)!=="svelte-1aswmub"&&(cn.innerHTML=Q1),Wc=n(e),m(Tn.$$.fragment,e),Gc=n(e),Xc=r(e,"HR",{}),Zc=n(e),fn=r(e,"A",{id:!0,class:!0}),h(fn).forEach(l),eT=n(e),m(hn.$$.fragment,e),tT=n(e),_n=r(e,"P",{"data-svelte-h":!0}),d(_n)!=="svelte-kp31r8"&&(_n.innerHTML=V1),lT=n(e),sT=r(e,"HR",{}),oT=n(e),$n=r(e,"A",{id:!0,class:!0}),h($n).forEach(l),nT=n(e),m(vn.$$.fragment,e),iT=n(e),bn=r(e,"P",{"data-svelte-h":!0}),d(bn)!=="svelte-1fs9no9"&&(bn.innerHTML=S1),rT=n(e),dT=r(e,"HR",{}),uT=n(e),yn=r(e,"A",{id:!0,class:!0}),h(yn).forEach(l),aT=n(e),m(Mn.$$.fragment,e),mT=n(e),xn=r(e,"P",{"data-svelte-h":!0}),d(xn)!=="svelte-2mif9c"&&(xn.textContent=O1),pT=n(e),Cn=r(e,"P",{"data-svelte-h":!0}),d(Cn)!=="svelte-1jas2kw"&&(Cn.innerHTML=F1),cT=n(e),m(Hn.$$.fragment,e),TT=n(e),Ln=r(e,"P",{"data-svelte-h":!0}),d(Ln)!=="svelte-1aswmub"&&(Ln.innerHTML=Y1),fT=n(e),m(wn.$$.fragment,e),hT=n(e),An=r(e,"P",{"data-svelte-h":!0}),d(An)!=="svelte-1aswmub"&&(An.innerHTML=W1),_T=n(e),m(gn.$$.fragment,e),$T=n(e),vT=r(e,"HR",{}),bT=n(e),m(Pn.$$.fragment,e),yT=n(e),Rn=r(e,"P",{}),h(Rn).forEach(l),this.h()},h(){u($,"name","hf:doc:metadata"),u($,"content",i_),u(v,"id","module_utils/tensor"),u(v,"class","group"),u(C,"id","module_utils/tensor.Tensor"),u(C,"class","group"),u(A,"id","new_module_utils/tensor.Tensor_new"),u(A,"class","group"),u(U,"id","module_utils/tensor.Tensor+dims"),u(U,"class","group"),u(E,"id","module_utils/tensor.Tensor+type"),u(E,"class","group"),u(q,"id","module_utils/tensor.Tensor+data"),u(q,"class","group"),u(Q,"id","module_utils/tensor.Tensor+size"),u(Q,"class","group"),u(F,"id","module_utils/tensor.Tensor+location"),u(F,"class","group"),u(X,"id","module_utils/tensor.Tensor+Symbol.iterator"),u(X,"class","group"),u(le,"id","module_utils/tensor.Tensor+_getitem"),u(le,"class","group"),u(re,"id","module_utils/tensor.Tensor+indexOf"),u(re,"class","group"),u(me,"id","module_utils/tensor.Tensor+_subarray"),u(me,"class","group"),u(fe,"id","module_utils/tensor.Tensor+item"),u(fe,"class","group"),u(be,"id","module_utils/tensor.Tensor+tolist"),u(be,"class","group"),u(Ce,"id","module_utils/tensor.Tensor+sigmoid"),u(Ce,"class","group"),u(Ae,"id","module_utils/tensor.Tensor+sigmoid_"),u(Ae,"class","group"),u(Ue,"id","module_utils/tensor.Tensor+map"),u(Ue,"class","group"),u(je,"id","module_utils/tensor.Tensor+map_"),u(je,"class","group"),u(Be,"id","module_utils/tensor.Tensor+mul"),u(Be,"class","group"),u(Oe,"id","module_utils/tensor.Tensor+mul_"),u(Oe,"class","group"),u(Xe,"id","module_utils/tensor.Tensor+div"),u(Xe,"class","group"),u(st,"id","module_utils/tensor.Tensor+div_"),u(st,"class","group"),u(dt,"id","module_utils/tensor.Tensor+add"),u(dt,"class","group"),u(ct,"id","module_utils/tensor.Tensor+add_"),u(ct,"class","group"),u($t,"id","module_utils/tensor.Tensor+sub"),u($t,"class","group"),u(xt,"id","module_utils/tensor.Tensor+sub_"),u(xt,"class","group"),u(At,"id","module_utils/tensor.Tensor+clone"),u(At,"class","group"),u(Ut,"id","module_utils/tensor.Tensor+slice"),u(Ut,"class","group"),u(Qt,"id","module_utils/tensor.Tensor+permute"),u(Qt,"class","group"),u(Yt,"id","module_utils/tensor.Tensor+sum"),u(Yt,"class","group"),u(el,"id","module_utils/tensor.Tensor+norm"),u(el,"class","group"),u(nl,"id","module_utils/tensor.Tensor+normalize_"),u(nl,"class","group"),u(al,"id","module_utils/tensor.Tensor+normalize"),u(al,"class","group"),u(fl,"id","module_utils/tensor.Tensor+stride"),u(fl,"class","group"),u(vl,"id","module_utils/tensor.Tensor+squeeze"),u(vl,"class","group"),u(Hl,"id","module_utils/tensor.Tensor+squeeze_"),u(Hl,"class","group"),u(gl,"id","module_utils/tensor.Tensor+unsqueeze"),u(gl,"class","group"),u(Jl,"id","module_utils/tensor.Tensor+unsqueeze_"),u(Jl,"class","group"),u(Il,"id","module_utils/tensor.Tensor+flatten_"),u(Il,"class","group"),u(Nl,"id","module_utils/tensor.Tensor+flatten"),u(Nl,"class","group"),u(Fl,"id","module_utils/tensor.Tensor+view"),u(Fl,"class","group"),u(Zl,"id","module_utils/tensor.Tensor+clamp_"),u(Zl,"class","group"),u(ss,"id","module_utils/tensor.Tensor+clamp"),u(ss,"class","group"),u(ds,"id","module_utils/tensor.Tensor+round_"),u(ds,"class","group"),u(ps,"id","module_utils/tensor.Tensor+round"),u(ps,"class","group"),u(hs,"id","module_utils/tensor.Tensor+to"),u(hs,"class","group"),u(ys,"id","module_utils/tensor.permute"),u(ys,"class","group"),u(Ls,"id","module_utils/tensor.interpolate"),u(Ls,"class","group"),u(zs,"id","module_utils/tensor.interpolate_4d"),u(zs,"class","group"),u(Es,"id","module_utils/tensor.matmul"),u(Es,"class","group"),u(Ks,"id","module_utils/tensor.rfft"),u(Ks,"class","group"),u(Ss,"id","module_utils/tensor.topk"),u(Ss,"class","group"),u(Gs,"id","module_utils/tensor.mean_pooling"),u(Gs,"class","group"),u(lo,"id","module_utils/tensor.layer_norm"),u(lo,"class","group"),u(ro,"id","module_utils/tensor.cat"),u(ro,"class","group"),u(co,"id","module_utils/tensor.stack"),u(co,"class","group"),u($o,"id","module_utils/tensor.std_mean"),u($o,"class","group"),u(xo,"id","module_utils/tensor.mean"),u(xo,"class","group"),u(Ao,"id","module_utils/tensor.full"),u(Ao,"class","group"),u(Ro,"id","module_utils/tensor.ones"),u(Ro,"class","group"),u(Do,"id","module_utils/tensor.ones_like"),u(Do,"class","group"),u(No,"id","module_utils/tensor.zeros"),u(No,"class","group"),u(Fo,"id","module_utils/tensor.zeros_like"),u(Fo,"class","group"),u(Zo,"id","module_utils/tensor.quantize_embeddings"),u(Zo,"class","group"),u(on,"id","module_utils/tensor..args[0]"),u(on,"class","group"),u(dn,"id","module_utils/tensor..reshape"),u(dn,"class","group"),u(fn,"id","module_utils/tensor..reshape..reshapedArray"),u(fn,"class","group"),u($n,"id","module_utils/tensor..DataArray"),u($n,"class","group"),u(yn,"id","module_utils/tensor..NestArray"),u(yn,"class","group")},m(e,t){s_(document.head,$),s(e,kn,t),s(e,Un,t),s(e,Jn,t),s(e,v,t),s(e,En,t),p(b,e,t),s(e,jn,t),s(e,y,t),s(e,Dn,t),s(e,M,t),s(e,In,t),s(e,x,t),s(e,qn,t),s(e,Kn,t),s(e,Bn,t),s(e,C,t),s(e,Nn,t),p(H,e,t),s(e,Qn,t),s(e,L,t),s(e,Vn,t),s(e,w,t),s(e,Sn,t),s(e,On,t),s(e,Fn,t),s(e,A,t),s(e,Yn,t),p(g,e,t),s(e,Wn,t),s(e,P,t),s(e,Gn,t),s(e,z,t),s(e,Xn,t),s(e,Zn,t),s(e,ei,t),s(e,U,t),s(e,ti,t),p(R,e,t),s(e,li,t),s(e,k,t),s(e,si,t),s(e,J,t),s(e,oi,t),s(e,ni,t),s(e,ii,t),s(e,E,t),s(e,ri,t),p(j,e,t),s(e,di,t),s(e,D,t),s(e,ui,t),s(e,I,t),s(e,ai,t),s(e,mi,t),s(e,pi,t),s(e,q,t),s(e,ci,t),p(K,e,t),s(e,Ti,t),s(e,B,t),s(e,fi,t),s(e,N,t),s(e,hi,t),s(e,_i,t),s(e,$i,t),s(e,Q,t),s(e,vi,t),p(V,e,t),s(e,bi,t),s(e,S,t),s(e,yi,t),s(e,O,t),s(e,Mi,t),s(e,xi,t),s(e,Ci,t),s(e,F,t),s(e,Hi,t),p(Y,e,t),s(e,Li,t),s(e,W,t),s(e,wi,t),s(e,G,t),s(e,Ai,t),s(e,gi,t),s(e,Pi,t),s(e,X,t),s(e,zi,t),p(Z,e,t),s(e,Ui,t),s(e,ee,t),s(e,Ri,t),s(e,te,t),s(e,ki,t),s(e,Ji,t),s(e,Ei,t),s(e,le,t),s(e,ji,t),p(se,e,t),s(e,Di,t),s(e,oe,t),s(e,Ii,t),s(e,ne,t),s(e,qi,t),s(e,ie,t),s(e,Ki,t),s(e,Bi,t),s(e,Ni,t),s(e,re,t),s(e,Qi,t),p(de,e,t),s(e,Vi,t),s(e,ue,t),s(e,Si,t),s(e,ae,t),s(e,Oi,t),s(e,Fi,t),s(e,Yi,t),s(e,me,t),s(e,Wi,t),p(pe,e,t),s(e,Gi,t),s(e,ce,t),s(e,Xi,t),s(e,Te,t),s(e,Zi,t),s(e,er,t),s(e,tr,t),s(e,fe,t),s(e,lr,t),p(he,e,t),s(e,sr,t),s(e,_e,t),s(e,or,t),s(e,$e,t),s(e,nr,t),s(e,ve,t),s(e,ir,t),s(e,rr,t),s(e,dr,t),s(e,be,t),s(e,ur,t),p(ye,e,t),s(e,ar,t),s(e,Me,t),s(e,mr,t),s(e,xe,t),s(e,pr,t),s(e,cr,t),s(e,Tr,t),s(e,Ce,t),s(e,fr,t),p(He,e,t),s(e,hr,t),s(e,Le,t),s(e,_r,t),s(e,we,t),s(e,$r,t),s(e,vr,t),s(e,br,t),s(e,Ae,t),s(e,yr,t),p(ge,e,t),s(e,Mr,t),s(e,Pe,t),s(e,xr,t),s(e,ze,t),s(e,Cr,t),s(e,Hr,t),s(e,Lr,t),s(e,Ue,t),s(e,wr,t),p(Re,e,t),s(e,Ar,t),s(e,ke,t),s(e,gr,t),s(e,Je,t),s(e,Pr,t),s(e,Ee,t),s(e,zr,t),s(e,Ur,t),s(e,Rr,t),s(e,je,t),s(e,kr,t),p(De,e,t),s(e,Jr,t),s(e,Ie,t),s(e,Er,t),s(e,qe,t),s(e,jr,t),s(e,Ke,t),s(e,Dr,t),s(e,Ir,t),s(e,qr,t),s(e,Be,t),s(e,Kr,t),p(Ne,e,t),s(e,Br,t),s(e,Qe,t),s(e,Nr,t),s(e,Ve,t),s(e,Qr,t),s(e,Se,t),s(e,Vr,t),s(e,Sr,t),s(e,Or,t),s(e,Oe,t),s(e,Fr,t),p(Fe,e,t),s(e,Yr,t),s(e,Ye,t),s(e,Wr,t),s(e,We,t),s(e,Gr,t),s(e,Ge,t),s(e,Xr,t),s(e,Zr,t),s(e,ed,t),s(e,Xe,t),s(e,td,t),p(Ze,e,t),s(e,ld,t),s(e,et,t),s(e,sd,t),s(e,tt,t),s(e,od,t),s(e,lt,t),s(e,nd,t),s(e,id,t),s(e,rd,t),s(e,st,t),s(e,dd,t),p(ot,e,t),s(e,ud,t),s(e,nt,t),s(e,ad,t),s(e,it,t),s(e,md,t),s(e,rt,t),s(e,pd,t),s(e,cd,t),s(e,Td,t),s(e,dt,t),s(e,fd,t),p(ut,e,t),s(e,hd,t),s(e,at,t),s(e,_d,t),s(e,mt,t),s(e,$d,t),s(e,pt,t),s(e,vd,t),s(e,bd,t),s(e,yd,t),s(e,ct,t),s(e,Md,t),p(Tt,e,t),s(e,xd,t),s(e,ft,t),s(e,Cd,t),s(e,ht,t),s(e,Hd,t),s(e,_t,t),s(e,Ld,t),s(e,wd,t),s(e,Ad,t),s(e,$t,t),s(e,gd,t),p(vt,e,t),s(e,Pd,t),s(e,bt,t),s(e,zd,t),s(e,yt,t),s(e,Ud,t),s(e,Mt,t),s(e,Rd,t),s(e,kd,t),s(e,Jd,t),s(e,xt,t),s(e,Ed,t),p(Ct,e,t),s(e,jd,t),s(e,Ht,t),s(e,Dd,t),s(e,Lt,t),s(e,Id,t),s(e,wt,t),s(e,qd,t),s(e,Kd,t),s(e,Bd,t),s(e,At,t),s(e,Nd,t),p(gt,e,t),s(e,Qd,t),s(e,Pt,t),s(e,Vd,t),s(e,zt,t),s(e,Sd,t),s(e,Od,t),s(e,Fd,t),s(e,Ut,t),s(e,Yd,t),p(Rt,e,t),s(e,Wd,t),s(e,kt,t),s(e,Gd,t),s(e,Jt,t),s(e,Xd,t),p(Et,e,t),s(e,Zd,t),s(e,jt,t),s(e,eu,t),p(Dt,e,t),s(e,tu,t),s(e,It,t),s(e,lu,t),p(qt,e,t),s(e,su,t),s(e,Kt,t),s(e,ou,t),s(e,Bt,t),s(e,nu,t),s(e,Nt,t),s(e,iu,t),s(e,ru,t),s(e,du,t),s(e,Qt,t),s(e,uu,t),p(Vt,e,t),s(e,au,t),s(e,St,t),s(e,mu,t),s(e,Ot,t),s(e,pu,t),s(e,Ft,t),s(e,cu,t),s(e,Tu,t),s(e,fu,t),s(e,Yt,t),s(e,hu,t),p(Wt,e,t),s(e,_u,t),s(e,Gt,t),s(e,$u,t),s(e,Xt,t),s(e,vu,t),s(e,Zt,t),s(e,bu,t),s(e,yu,t),s(e,Mu,t),s(e,el,t),s(e,xu,t),p(tl,e,t),s(e,Cu,t),s(e,ll,t),s(e,Hu,t),s(e,sl,t),s(e,Lu,t),s(e,ol,t),s(e,wu,t),s(e,Au,t),s(e,gu,t),s(e,nl,t),s(e,Pu,t),p(il,e,t),s(e,zu,t),s(e,rl,t),s(e,Uu,t),s(e,dl,t),s(e,Ru,t),s(e,ul,t),s(e,ku,t),s(e,Ju,t),s(e,Eu,t),s(e,al,t),s(e,ju,t),p(ml,e,t),s(e,Du,t),s(e,pl,t),s(e,Iu,t),s(e,cl,t),s(e,qu,t),s(e,Tl,t),s(e,Ku,t),s(e,Bu,t),s(e,Nu,t),s(e,fl,t),s(e,Qu,t),p(hl,e,t),s(e,Vu,t),s(e,_l,t),s(e,Su,t),s(e,$l,t),s(e,Ou,t),s(e,Fu,t),s(e,Yu,t),s(e,vl,t),s(e,Wu,t),p(bl,e,t),s(e,Gu,t),s(e,yl,t),s(e,Xu,t),s(e,Ml,t),s(e,Zu,t),s(e,xl,t),s(e,ea,t),s(e,Cl,t),s(e,ta,t),s(e,la,t),s(e,sa,t),s(e,Hl,t),s(e,oa,t),p(Ll,e,t),s(e,na,t),s(e,wl,t),s(e,ia,t),s(e,Al,t),s(e,ra,t),s(e,da,t),s(e,ua,t),s(e,gl,t),s(e,aa,t),p(Pl,e,t),s(e,ma,t),s(e,zl,t),s(e,pa,t),s(e,Ul,t),s(e,ca,t),s(e,Rl,t),s(e,Ta,t),s(e,kl,t),s(e,fa,t),s(e,ha,t),s(e,_a,t),s(e,Jl,t),s(e,$a,t),p(El,e,t),s(e,va,t),s(e,jl,t),s(e,ba,t),s(e,Dl,t),s(e,ya,t),s(e,Ma,t),s(e,xa,t),s(e,Il,t),s(e,Ca,t),p(ql,e,t),s(e,Ha,t),s(e,Kl,t),s(e,La,t),s(e,Bl,t),s(e,wa,t),s(e,Aa,t),s(e,ga,t),s(e,Nl,t),s(e,Pa,t),p(Ql,e,t),s(e,za,t),s(e,Vl,t),s(e,Ua,t),s(e,Sl,t),s(e,Ra,t),s(e,Ol,t),s(e,ka,t),s(e,Ja,t),s(e,Ea,t),s(e,Fl,t),s(e,ja,t),p(Yl,e,t),s(e,Da,t),s(e,Wl,t),s(e,Ia,t),s(e,Gl,t),s(e,qa,t),s(e,Xl,t),s(e,Ka,t),s(e,Ba,t),s(e,Na,t),s(e,Zl,t),s(e,Qa,t),p(es,e,t),s(e,Va,t),s(e,ts,t),s(e,Sa,t),s(e,ls,t),s(e,Oa,t),s(e,Fa,t),s(e,Ya,t),s(e,ss,t),s(e,Wa,t),p(os,e,t),s(e,Ga,t),s(e,ns,t),s(e,Xa,t),s(e,is,t),s(e,Za,t),s(e,rs,t),s(e,em,t),s(e,tm,t),s(e,lm,t),s(e,ds,t),s(e,sm,t),p(us,e,t),s(e,om,t),s(e,as,t),s(e,nm,t),s(e,ms,t),s(e,im,t),s(e,rm,t),s(e,dm,t),s(e,ps,t),s(e,um,t),p(cs,e,t),s(e,am,t),s(e,Ts,t),s(e,mm,t),s(e,fs,t),s(e,pm,t),s(e,cm,t),s(e,Tm,t),s(e,hs,t),s(e,fm,t),p(_s,e,t),s(e,hm,t),s(e,$s,t),s(e,_m,t),s(e,vs,t),s(e,$m,t),s(e,bs,t),s(e,vm,t),s(e,bm,t),s(e,ym,t),s(e,ys,t),s(e,Mm,t),p(Ms,e,t),s(e,xm,t),s(e,xs,t),s(e,Cm,t),s(e,Cs,t),s(e,Hm,t),s(e,Hs,t),s(e,Lm,t),s(e,wm,t),s(e,Am,t),s(e,Ls,t),s(e,gm,t),p(ws,e,t),s(e,Pm,t),s(e,As,t),s(e,zm,t),s(e,gs,t),s(e,Um,t),s(e,Ps,t),s(e,Rm,t),s(e,km,t),s(e,Jm,t),s(e,zs,t),s(e,Em,t),p(Us,e,t),s(e,jm,t),s(e,Rs,t),s(e,Dm,t),s(e,ks,t),s(e,Im,t),s(e,Js,t),s(e,qm,t),s(e,Km,t),s(e,Bm,t),s(e,Es,t),s(e,Nm,t),p(js,e,t),s(e,Qm,t),s(e,Ds,t),s(e,Vm,t),s(e,Is,t),s(e,Sm,t),s(e,qs,t),s(e,Om,t),s(e,Fm,t),s(e,Ym,t),s(e,Ks,t),s(e,Wm,t),p(Bs,e,t),s(e,Gm,t),s(e,Ns,t),s(e,Xm,t),s(e,Qs,t),s(e,Zm,t),s(e,Vs,t),s(e,ep,t),s(e,tp,t),s(e,lp,t),s(e,Ss,t),s(e,sp,t),p(Os,e,t),s(e,op,t),s(e,Fs,t),s(e,np,t),s(e,Ys,t),s(e,ip,t),s(e,Ws,t),s(e,rp,t),s(e,dp,t),s(e,up,t),s(e,Gs,t),s(e,ap,t),p(Xs,e,t),s(e,mp,t),s(e,Zs,t),s(e,pp,t),s(e,eo,t),s(e,cp,t),s(e,to,t),s(e,Tp,t),s(e,fp,t),s(e,hp,t),s(e,lo,t),s(e,_p,t),p(so,e,t),s(e,$p,t),s(e,oo,t),s(e,vp,t),s(e,no,t),s(e,bp,t),s(e,io,t),s(e,yp,t),s(e,Mp,t),s(e,xp,t),s(e,ro,t),s(e,Cp,t),p(uo,e,t),s(e,Hp,t),s(e,ao,t),s(e,Lp,t),s(e,mo,t),s(e,wp,t),s(e,po,t),s(e,Ap,t),s(e,gp,t),s(e,Pp,t),s(e,co,t),s(e,zp,t),p(To,e,t),s(e,Up,t),s(e,fo,t),s(e,Rp,t),s(e,ho,t),s(e,kp,t),s(e,_o,t),s(e,Jp,t),s(e,Ep,t),s(e,jp,t),s(e,$o,t),s(e,Dp,t),p(vo,e,t),s(e,Ip,t),s(e,bo,t),s(e,qp,t),s(e,yo,t),s(e,Kp,t),s(e,Mo,t),s(e,Bp,t),s(e,Np,t),s(e,Qp,t),s(e,xo,t),s(e,Vp,t),p(Co,e,t),s(e,Sp,t),s(e,Ho,t),s(e,Op,t),s(e,Lo,t),s(e,Fp,t),s(e,wo,t),s(e,Yp,t),s(e,Wp,t),s(e,Gp,t),s(e,Ao,t),s(e,Xp,t),p(go,e,t),s(e,Zp,t),s(e,Po,t),s(e,ec,t),s(e,zo,t),s(e,tc,t),s(e,Uo,t),s(e,lc,t),s(e,sc,t),s(e,oc,t),s(e,Ro,t),s(e,nc,t),p(ko,e,t),s(e,ic,t),s(e,Jo,t),s(e,rc,t),s(e,Eo,t),s(e,dc,t),s(e,jo,t),s(e,uc,t),s(e,ac,t),s(e,mc,t),s(e,Do,t),s(e,pc,t),p(Io,e,t),s(e,cc,t),s(e,qo,t),s(e,Tc,t),s(e,Ko,t),s(e,fc,t),s(e,Bo,t),s(e,hc,t),s(e,_c,t),s(e,$c,t),s(e,No,t),s(e,vc,t),p(Qo,e,t),s(e,bc,t),s(e,Vo,t),s(e,yc,t),s(e,So,t),s(e,Mc,t),s(e,Oo,t),s(e,xc,t),s(e,Cc,t),s(e,Hc,t),s(e,Fo,t),s(e,Lc,t),p(Yo,e,t),s(e,wc,t),s(e,Wo,t),s(e,Ac,t),s(e,Go,t),s(e,gc,t),s(e,Xo,t),s(e,Pc,t),s(e,zc,t),s(e,Uc,t),s(e,Zo,t),s(e,Rc,t),p(en,e,t),s(e,kc,t),s(e,tn,t),s(e,Jc,t),s(e,ln,t),s(e,Ec,t),s(e,sn,t),s(e,jc,t),s(e,Dc,t),s(e,Ic,t),s(e,on,t),s(e,qc,t),p(nn,e,t),s(e,Kc,t),s(e,rn,t),s(e,Bc,t),s(e,Nc,t),s(e,Qc,t),s(e,dn,t),s(e,Vc,t),p(un,e,t),s(e,Sc,t),s(e,an,t),s(e,Oc,t),s(e,mn,t),s(e,Fc,t),s(e,pn,t),s(e,Yc,t),s(e,cn,t),s(e,Wc,t),p(Tn,e,t),s(e,Gc,t),s(e,Xc,t),s(e,Zc,t),s(e,fn,t),s(e,eT,t),p(hn,e,t),s(e,tT,t),s(e,_n,t),s(e,lT,t),s(e,sT,t),s(e,oT,t),s(e,$n,t),s(e,nT,t),p(vn,e,t),s(e,iT,t),s(e,bn,t),s(e,rT,t),s(e,dT,t),s(e,uT,t),s(e,yn,t),s(e,aT,t),p(Mn,e,t),s(e,mT,t),s(e,xn,t),s(e,pT,t),s(e,Cn,t),s(e,cT,t),p(Hn,e,t),s(e,TT,t),s(e,Ln,t),s(e,fT,t),p(wn,e,t),s(e,hT,t),s(e,An,t),s(e,_T,t),p(gn,e,t),s(e,$T,t),s(e,vT,t),s(e,bT,t),p(Pn,e,t),s(e,yT,t),s(e,Rn,t),MT=!0},p:X1,i(e){MT||(c(b.$$.fragment,e),c(H.$$.fragment,e),c(g.$$.fragment,e),c(R.$$.fragment,e),c(j.$$.fragment,e),c(K.$$.fragment,e),c(V.$$.fragment,e),c(Y.$$.fragment,e),c(Z.$$.fragment,e),c(se.$$.fragment,e),c(de.$$.fragment,e),c(pe.$$.fragment,e),c(he.$$.fragment,e),c(ye.$$.fragment,e),c(He.$$.fragment,e),c(ge.$$.fragment,e),c(Re.$$.fragment,e),c(De.$$.fragment,e),c(Ne.$$.fragment,e),c(Fe.$$.fragment,e),c(Ze.$$.fragment,e),c(ot.$$.fragment,e),c(ut.$$.fragment,e),c(Tt.$$.fragment,e),c(vt.$$.fragment,e),c(Ct.$$.fragment,e),c(gt.$$.fragment,e),c(Rt.$$.fragment,e),c(Et.$$.fragment,e),c(Dt.$$.fragment,e),c(qt.$$.fragment,e),c(Vt.$$.fragment,e),c(Wt.$$.fragment,e),c(tl.$$.fragment,e),c(il.$$.fragment,e),c(ml.$$.fragment,e),c(hl.$$.fragment,e),c(bl.$$.fragment,e),c(Ll.$$.fragment,e),c(Pl.$$.fragment,e),c(El.$$.fragment,e),c(ql.$$.fragment,e),c(Ql.$$.fragment,e),c(Yl.$$.fragment,e),c(es.$$.fragment,e),c(os.$$.fragment,e),c(us.$$.fragment,e),c(cs.$$.fragment,e),c(_s.$$.fragment,e),c(Ms.$$.fragment,e),c(ws.$$.fragment,e),c(Us.$$.fragment,e),c(js.$$.fragment,e),c(Bs.$$.fragment,e),c(Os.$$.fragment,e),c(Xs.$$.fragment,e),c(so.$$.fragment,e),c(uo.$$.fragment,e),c(To.$$.fragment,e),c(vo.$$.fragment,e),c(Co.$$.fragment,e),c(go.$$.fragment,e),c(ko.$$.fragment,e),c(Io.$$.fragment,e),c(Qo.$$.fragment,e),c(Yo.$$.fragment,e),c(en.$$.fragment,e),c(nn.$$.fragment,e),c(un.$$.fragment,e),c(Tn.$$.fragment,e),c(hn.$$.fragment,e),c(vn.$$.fragment,e),c(Mn.$$.fragment,e),c(Hn.$$.fragment,e),c(wn.$$.fragment,e),c(gn.$$.fragment,e),c(Pn.$$.fragment,e),MT=!0)},o(e){T(b.$$.fragment,e),T(H.$$.fragment,e),T(g.$$.fragment,e),T(R.$$.fragment,e),T(j.$$.fragment,e),T(K.$$.fragment,e),T(V.$$.fragment,e),T(Y.$$.fragment,e),T(Z.$$.fragment,e),T(se.$$.fragment,e),T(de.$$.fragment,e),T(pe.$$.fragment,e),T(he.$$.fragment,e),T(ye.$$.fragment,e),T(He.$$.fragment,e),T(ge.$$.fragment,e),T(Re.$$.fragment,e),T(De.$$.fragment,e),T(Ne.$$.fragment,e),T(Fe.$$.fragment,e),T(Ze.$$.fragment,e),T(ot.$$.fragment,e),T(ut.$$.fragment,e),T(Tt.$$.fragment,e),T(vt.$$.fragment,e),T(Ct.$$.fragment,e),T(gt.$$.fragment,e),T(Rt.$$.fragment,e),T(Et.$$.fragment,e),T(Dt.$$.fragment,e),T(qt.$$.fragment,e),T(Vt.$$.fragment,e),T(Wt.$$.fragment,e),T(tl.$$.fragment,e),T(il.$$.fragment,e),T(ml.$$.fragment,e),T(hl.$$.fragment,e),T(bl.$$.fragment,e),T(Ll.$$.fragment,e),T(Pl.$$.fragment,e),T(El.$$.fragment,e),T(ql.$$.fragment,e),T(Ql.$$.fragment,e),T(Yl.$$.fragment,e),T(es.$$.fragment,e),T(os.$$.fragment,e),T(us.$$.fragment,e),T(cs.$$.fragment,e),T(_s.$$.fragment,e),T(Ms.$$.fragment,e),T(ws.$$.fragment,e),T(Us.$$.fragment,e),T(js.$$.fragment,e),T(Bs.$$.fragment,e),T(Os.$$.fragment,e),T(Xs.$$.fragment,e),T(so.$$.fragment,e),T(uo.$$.fragment,e),T(To.$$.fragment,e),T(vo.$$.fragment,e),T(Co.$$.fragment,e),T(go.$$.fragment,e),T(ko.$$.fragment,e),T(Io.$$.fragment,e),T(Qo.$$.fragment,e),T(Yo.$$.fragment,e),T(en.$$.fragment,e),T(nn.$$.fragment,e),T(un.$$.fragment,e),T(Tn.$$.fragment,e),T(hn.$$.fragment,e),T(vn.$$.fragment,e),T(Mn.$$.fragment,e),T(Hn.$$.fragment,e),T(wn.$$.fragment,e),T(gn.$$.fragment,e),T(Pn.$$.fragment,e),MT=!1},d(e){e&&(l(kn),l(Un),l(Jn),l(v),l(En),l(jn),l(y),l(Dn),l(M),l(In),l(x),l(qn),l(Kn),l(Bn),l(C),l(Nn),l(Qn),l(L),l(Vn),l(w),l(Sn),l(On),l(Fn),l(A),l(Yn),l(Wn),l(P),l(Gn),l(z),l(Xn),l(Zn),l(ei),l(U),l(ti),l(li),l(k),l(si),l(J),l(oi),l(ni),l(ii),l(E),l(ri),l(di),l(D),l(ui),l(I),l(ai),l(mi),l(pi),l(q),l(ci),l(Ti),l(B),l(fi),l(N),l(hi),l(_i),l($i),l(Q),l(vi),l(bi),l(S),l(yi),l(O),l(Mi),l(xi),l(Ci),l(F),l(Hi),l(Li),l(W),l(wi),l(G),l(Ai),l(gi),l(Pi),l(X),l(zi),l(Ui),l(ee),l(Ri),l(te),l(ki),l(Ji),l(Ei),l(le),l(ji),l(Di),l(oe),l(Ii),l(ne),l(qi),l(ie),l(Ki),l(Bi),l(Ni),l(re),l(Qi),l(Vi),l(ue),l(Si),l(ae),l(Oi),l(Fi),l(Yi),l(me),l(Wi),l(Gi),l(ce),l(Xi),l(Te),l(Zi),l(er),l(tr),l(fe),l(lr),l(sr),l(_e),l(or),l($e),l(nr),l(ve),l(ir),l(rr),l(dr),l(be),l(ur),l(ar),l(Me),l(mr),l(xe),l(pr),l(cr),l(Tr),l(Ce),l(fr),l(hr),l(Le),l(_r),l(we),l($r),l(vr),l(br),l(Ae),l(yr),l(Mr),l(Pe),l(xr),l(ze),l(Cr),l(Hr),l(Lr),l(Ue),l(wr),l(Ar),l(ke),l(gr),l(Je),l(Pr),l(Ee),l(zr),l(Ur),l(Rr),l(je),l(kr),l(Jr),l(Ie),l(Er),l(qe),l(jr),l(Ke),l(Dr),l(Ir),l(qr),l(Be),l(Kr),l(Br),l(Qe),l(Nr),l(Ve),l(Qr),l(Se),l(Vr),l(Sr),l(Or),l(Oe),l(Fr),l(Yr),l(Ye),l(Wr),l(We),l(Gr),l(Ge),l(Xr),l(Zr),l(ed),l(Xe),l(td),l(ld),l(et),l(sd),l(tt),l(od),l(lt),l(nd),l(id),l(rd),l(st),l(dd),l(ud),l(nt),l(ad),l(it),l(md),l(rt),l(pd),l(cd),l(Td),l(dt),l(fd),l(hd),l(at),l(_d),l(mt),l($d),l(pt),l(vd),l(bd),l(yd),l(ct),l(Md),l(xd),l(ft),l(Cd),l(ht),l(Hd),l(_t),l(Ld),l(wd),l(Ad),l($t),l(gd),l(Pd),l(bt),l(zd),l(yt),l(Ud),l(Mt),l(Rd),l(kd),l(Jd),l(xt),l(Ed),l(jd),l(Ht),l(Dd),l(Lt),l(Id),l(wt),l(qd),l(Kd),l(Bd),l(At),l(Nd),l(Qd),l(Pt),l(Vd),l(zt),l(Sd),l(Od),l(Fd),l(Ut),l(Yd),l(Wd),l(kt),l(Gd),l(Jt),l(Xd),l(Zd),l(jt),l(eu),l(tu),l(It),l(lu),l(su),l(Kt),l(ou),l(Bt),l(nu),l(Nt),l(iu),l(ru),l(du),l(Qt),l(uu),l(au),l(St),l(mu),l(Ot),l(pu),l(Ft),l(cu),l(Tu),l(fu),l(Yt),l(hu),l(_u),l(Gt),l($u),l(Xt),l(vu),l(Zt),l(bu),l(yu),l(Mu),l(el),l(xu),l(Cu),l(ll),l(Hu),l(sl),l(Lu),l(ol),l(wu),l(Au),l(gu),l(nl),l(Pu),l(zu),l(rl),l(Uu),l(dl),l(Ru),l(ul),l(ku),l(Ju),l(Eu),l(al),l(ju),l(Du),l(pl),l(Iu),l(cl),l(qu),l(Tl),l(Ku),l(Bu),l(Nu),l(fl),l(Qu),l(Vu),l(_l),l(Su),l($l),l(Ou),l(Fu),l(Yu),l(vl),l(Wu),l(Gu),l(yl),l(Xu),l(Ml),l(Zu),l(xl),l(ea),l(Cl),l(ta),l(la),l(sa),l(Hl),l(oa),l(na),l(wl),l(ia),l(Al),l(ra),l(da),l(ua),l(gl),l(aa),l(ma),l(zl),l(pa),l(Ul),l(ca),l(Rl),l(Ta),l(kl),l(fa),l(ha),l(_a),l(Jl),l($a),l(va),l(jl),l(ba),l(Dl),l(ya),l(Ma),l(xa),l(Il),l(Ca),l(Ha),l(Kl),l(La),l(Bl),l(wa),l(Aa),l(ga),l(Nl),l(Pa),l(za),l(Vl),l(Ua),l(Sl),l(Ra),l(Ol),l(ka),l(Ja),l(Ea),l(Fl),l(ja),l(Da),l(Wl),l(Ia),l(Gl),l(qa),l(Xl),l(Ka),l(Ba),l(Na),l(Zl),l(Qa),l(Va),l(ts),l(Sa),l(ls),l(Oa),l(Fa),l(Ya),l(ss),l(Wa),l(Ga),l(ns),l(Xa),l(is),l(Za),l(rs),l(em),l(tm),l(lm),l(ds),l(sm),l(om),l(as),l(nm),l(ms),l(im),l(rm),l(dm),l(ps),l(um),l(am),l(Ts),l(mm),l(fs),l(pm),l(cm),l(Tm),l(hs),l(fm),l(hm),l($s),l(_m),l(vs),l($m),l(bs),l(vm),l(bm),l(ym),l(ys),l(Mm),l(xm),l(xs),l(Cm),l(Cs),l(Hm),l(Hs),l(Lm),l(wm),l(Am),l(Ls),l(gm),l(Pm),l(As),l(zm),l(gs),l(Um),l(Ps),l(Rm),l(km),l(Jm),l(zs),l(Em),l(jm),l(Rs),l(Dm),l(ks),l(Im),l(Js),l(qm),l(Km),l(Bm),l(Es),l(Nm),l(Qm),l(Ds),l(Vm),l(Is),l(Sm),l(qs),l(Om),l(Fm),l(Ym),l(Ks),l(Wm),l(Gm),l(Ns),l(Xm),l(Qs),l(Zm),l(Vs),l(ep),l(tp),l(lp),l(Ss),l(sp),l(op),l(Fs),l(np),l(Ys),l(ip),l(Ws),l(rp),l(dp),l(up),l(Gs),l(ap),l(mp),l(Zs),l(pp),l(eo),l(cp),l(to),l(Tp),l(fp),l(hp),l(lo),l(_p),l($p),l(oo),l(vp),l(no),l(bp),l(io),l(yp),l(Mp),l(xp),l(ro),l(Cp),l(Hp),l(ao),l(Lp),l(mo),l(wp),l(po),l(Ap),l(gp),l(Pp),l(co),l(zp),l(Up),l(fo),l(Rp),l(ho),l(kp),l(_o),l(Jp),l(Ep),l(jp),l($o),l(Dp),l(Ip),l(bo),l(qp),l(yo),l(Kp),l(Mo),l(Bp),l(Np),l(Qp),l(xo),l(Vp),l(Sp),l(Ho),l(Op),l(Lo),l(Fp),l(wo),l(Yp),l(Wp),l(Gp),l(Ao),l(Xp),l(Zp),l(Po),l(ec),l(zo),l(tc),l(Uo),l(lc),l(sc),l(oc),l(Ro),l(nc),l(ic),l(Jo),l(rc),l(Eo),l(dc),l(jo),l(uc),l(ac),l(mc),l(Do),l(pc),l(cc),l(qo),l(Tc),l(Ko),l(fc),l(Bo),l(hc),l(_c),l($c),l(No),l(vc),l(bc),l(Vo),l(yc),l(So),l(Mc),l(Oo),l(xc),l(Cc),l(Hc),l(Fo),l(Lc),l(wc),l(Wo),l(Ac),l(Go),l(gc),l(Xo),l(Pc),l(zc),l(Uc),l(Zo),l(Rc),l(kc),l(tn),l(Jc),l(ln),l(Ec),l(sn),l(jc),l(Dc),l(Ic),l(on),l(qc),l(Kc),l(rn),l(Bc),l(Nc),l(Qc),l(dn),l(Vc),l(Sc),l(an),l(Oc),l(mn),l(Fc),l(pn),l(Yc),l(cn),l(Wc),l(Gc),l(Xc),l(Zc),l(fn),l(eT),l(tT),l(_n),l(lT),l(sT),l(oT),l($n),l(nT),l(iT),l(bn),l(rT),l(dT),l(uT),l(yn),l(aT),l(mT),l(xn),l(pT),l(Cn),l(cT),l(TT),l(Ln),l(fT),l(hT),l(An),l(_T),l($T),l(vT),l(bT),l(yT),l(Rn)),l($),f(b,e),f(H,e),f(g,e),f(R,e),f(j,e),f(K,e),f(V,e),f(Y,e),f(Z,e),f(se,e),f(de,e),f(pe,e),f(he,e),f(ye,e),f(He,e),f(ge,e),f(Re,e),f(De,e),f(Ne,e),f(Fe,e),f(Ze,e),f(ot,e),f(ut,e),f(Tt,e),f(vt,e),f(Ct,e),f(gt,e),f(Rt,e),f(Et,e),f(Dt,e),f(qt,e),f(Vt,e),f(Wt,e),f(tl,e),f(il,e),f(ml,e),f(hl,e),f(bl,e),f(Ll,e),f(Pl,e),f(El,e),f(ql,e),f(Ql,e),f(Yl,e),f(es,e),f(os,e),f(us,e),f(cs,e),f(_s,e),f(Ms,e),f(ws,e),f(Us,e),f(js,e),f(Bs,e),f(Os,e),f(Xs,e),f(so,e),f(uo,e),f(To,e),f(vo,e),f(Co,e),f(go,e),f(ko,e),f(Io,e),f(Qo,e),f(Yo,e),f(en,e),f(nn,e),f(un,e),f(Tn,e),f(hn,e),f(vn,e),f(Mn,e),f(Hn,e),f(wn,e),f(gn,e),f(Pn,e)}}}const i_='{"title":"utils/tensor","local":"utilstensor","sections":[{"title":"utils/tensor.Tensor","local":"utilstensortensor","sections":[{"title":"new Tensor(...args)","local":"new-tensorargs","sections":[],"depth":3},{"title":"tensor.dims : <code> Array. < number > </code>","local":"tensordims--code-array--number--code","sections":[],"depth":3},{"title":"tensor.type : <code> DataType </code>","local":"tensortype--code-datatype-code","sections":[],"depth":3},{"title":"tensor.data : <code> DataArray </code>","local":"tensordata--code-dataarray-code","sections":[],"depth":3},{"title":"tensor.size : <code> number </code>","local":"tensorsize--code-number-code","sections":[],"depth":3},{"title":"tensor.location : <code> string </code>","local":"tensorlocation--code-string-code","sections":[],"depth":3},{"title":"tensor.Symbol.iterator() ⇒ <code> Iterator </code>","local":"tensorsymboliterator--code-iterator-code","sections":[],"depth":3},{"title":"tensor._getitem(index) ⇒ <code> Tensor </code>","local":"tensorgetitemindex--code-tensor-code","sections":[],"depth":3},{"title":"tensor.indexOf(item) ⇒ <code> number </code>","local":"tensorindexofitem--code-number-code","sections":[],"depth":3},{"title":"tensor._subarray(index, iterSize, iterDims) ⇒ <code> Tensor </code>","local":"tensorsubarrayindex-itersize-iterdims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.item() ⇒ <code> number </code> | <code> bigint </code>","local":"tensoritem--code-number-code--code-bigint-code","sections":[],"depth":3},{"title":"tensor.tolist() ⇒ <code> Array </code>","local":"tensortolist--code-array-code","sections":[],"depth":3},{"title":"tensor.sigmoid() ⇒ <code> Tensor </code>","local":"tensorsigmoid--code-tensor-code","sections":[],"depth":3},{"title":"tensor.sigmoid_() ⇒ <code> Tensor </code>","local":"tensorsigmoid--code-tensor-code","sections":[],"depth":3},{"title":"tensor.map(callback) ⇒ <code> Tensor </code>","local":"tensormapcallback--code-tensor-code","sections":[],"depth":3},{"title":"tensor.map_(callback) ⇒ <code> Tensor </code>","local":"tensormapcallback--code-tensor-code","sections":[],"depth":3},{"title":"tensor.mul(val) ⇒ <code> Tensor </code>","local":"tensormulval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.mul_(val) ⇒ <code> Tensor </code>","local":"tensormulval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.div(val) ⇒ <code> Tensor </code>","local":"tensordivval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.div_(val) ⇒ <code> Tensor </code>","local":"tensordivval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.add(val) ⇒ <code> Tensor </code>","local":"tensoraddval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.add_(val) ⇒ <code> Tensor </code>","local":"tensoraddval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.sub(val) ⇒ <code> Tensor </code>","local":"tensorsubval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.sub_(val) ⇒ <code> Tensor </code>","local":"tensorsubval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.clone() ⇒ <code> Tensor </code>","local":"tensorclone--code-tensor-code","sections":[],"depth":3},{"title":"tensor.slice(...slices) ⇒ <code> Tensor </code>","local":"tensorsliceslices--code-tensor-code","sections":[],"depth":3},{"title":"tensor.permute(...dims) ⇒ <code> Tensor </code>","local":"tensorpermutedims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.sum([dim], keepdim) ⇒","local":"tensorsumdim-keepdim-","sections":[],"depth":3},{"title":"tensor.norm([p], [dim], [keepdim]) ⇒ <code> Tensor </code>","local":"tensornormp-dim-keepdim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.normalize_([p], [dim]) ⇒ <code> Tensor </code>","local":"tensornormalizep-dim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.normalize([p], [dim]) ⇒ <code> Tensor </code>","local":"tensornormalizep-dim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.stride() ⇒ <code> Array. < number > </code>","local":"tensorstride--code-array--number--code","sections":[],"depth":3},{"title":"tensor.squeeze([dim]) ⇒ <code> Tensor </code>","local":"tensorsqueezedim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.squeeze_()","local":"tensorsqueeze","sections":[],"depth":3},{"title":"tensor.unsqueeze(dim) ⇒ <code> Tensor </code>","local":"tensorunsqueezedim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.unsqueeze_()","local":"tensorunsqueeze","sections":[],"depth":3},{"title":"tensor.flatten_()","local":"tensorflatten","sections":[],"depth":3},{"title":"tensor.flatten(start_dim, end_dim) ⇒ <code> Tensor </code>","local":"tensorflattenstartdim-enddim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.view(...dims) ⇒ <code> Tensor </code>","local":"tensorviewdims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.clamp_()","local":"tensorclamp","sections":[],"depth":3},{"title":"tensor.clamp(min, max) ⇒ <code> Tensor </code>","local":"tensorclampmin-max--code-tensor-code","sections":[],"depth":3},{"title":"tensor.round_()","local":"tensorround","sections":[],"depth":3},{"title":"tensor.round() ⇒ <code> Tensor </code>","local":"tensorround--code-tensor-code","sections":[],"depth":3},{"title":"tensor.to(type) ⇒ <code> Tensor </code>","local":"tensortotype--code-tensor-code","sections":[],"depth":3}],"depth":2},{"title":"utils/tensor.permute(tensor, axes) ⇒ <code> Tensor </code>","local":"utilstensorpermutetensor-axes--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.interpolate(input, size, mode, align_corners) ⇒ <code> Tensor </code>","local":"utilstensorinterpolateinput-size-mode-aligncorners--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.interpolate_4d(input, options) ⇒ <code> Promise. < Tensor > </code>","local":"utilstensorinterpolate4dinput-options--code-promise--tensor--code","sections":[],"depth":2},{"title":"utils/tensor.matmul(a, b) ⇒ <code> Promise. < Tensor > </code>","local":"utilstensormatmula-b--code-promise--tensor--code","sections":[],"depth":2},{"title":"utils/tensor.rfft(x, a) ⇒ <code> Promise. < Tensor > </code>","local":"utilstensorrfftx-a--code-promise--tensor--code","sections":[],"depth":2},{"title":"utils/tensor.topk(x, k) ⇒ <code> * </code>","local":"utilstensortopkx-k--code--code","sections":[],"depth":2},{"title":"utils/tensor.mean_pooling(last_hidden_state, attention_mask) ⇒ <code> Tensor </code>","local":"utilstensormeanpoolinglasthiddenstate-attentionmask--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.layer_norm(input, normalized_shape, options) ⇒ <code> Tensor </code>","local":"utilstensorlayernorminput-normalizedshape-options--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.cat(tensors, dim) ⇒ <code> Tensor </code>","local":"utilstensorcattensors-dim--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.stack(tensors, dim) ⇒ <code> Tensor </code>","local":"utilstensorstacktensors-dim--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.std_mean(input, dim, correction, keepdim) ⇒ <code> Array. < Tensor > </code>","local":"utilstensorstdmeaninput-dim-correction-keepdim--code-array--tensor--code","sections":[],"depth":2},{"title":"utils/tensor.mean(input, dim, keepdim) ⇒ <code> Tensor </code>","local":"utilstensormeaninput-dim-keepdim--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.full(size, fill_value) ⇒ <code> Tensor </code>","local":"utilstensorfullsize-fillvalue--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.ones(size) ⇒ <code> Tensor </code>","local":"utilstensoronessize--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.ones_like(tensor) ⇒ <code> Tensor </code>","local":"utilstensoronesliketensor--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.zeros(size) ⇒ <code> Tensor </code>","local":"utilstensorzerossize--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.zeros_like(tensor) ⇒ <code> Tensor </code>","local":"utilstensorzerosliketensor--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.quantize_embeddings(tensor, precision) ⇒ <code> Tensor </code>","local":"utilstensorquantizeembeddingstensor-precision--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor~args[0] : <code> ONNXTensor </code>","local":"utilstensorargs0--code-onnxtensor-code","sections":[],"depth":2},{"title":"utils/tensor~reshape(data, dimensions) ⇒ <code> * </code>","local":"utilstensorreshapedata-dimensions--code--code","sections":[{"title":"reshape~reshapedArray : <code> any </code>","local":"reshapereshapedarray--code-any-code","sections":[],"depth":3}],"depth":2},{"title":"utils/tensor~DataArray : <code> * </code>","local":"utilstensordataarray--code--code","sections":[],"depth":2},{"title":"utils/tensor~NestArray : <code> * </code>","local":"utilstensornestarray--code--code","sections":[],"depth":2}],"depth":1}';function r_(xT){return Z1(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class p_ extends e_{constructor($){super(),t_(this,$,r_,n_,G1,{})}}export{p_ as component};
