import{s as $i,n as vi,o as _i}from"../chunks/scheduler.0219f8bd.js";import{S as Ti,i as bi,g as d,s as i,r as n,A as Ci,h as o,f as a,c as m,j as g,u,x as s,k as r,y as xi,a as l,v as c,d as p,t as f,w}from"../chunks/index.f61edf3b.js";import{C as Hi}from"../chunks/CodeBlock.38e566ae.js";import{H as h,E as Li}from"../chunks/EditOnGithub.48fa589f.js";function yi(bl){let R,at,et,lt,I,it,$,mt,v,Cl="Helper module for image processing.",dt,_,xl=`These functions and classes are only used internally,
meaning an end-user shouldn’t need to access anything here.`,ot,T,Hl='<li><a href="#module_utils/image">utils/image</a><ul><li><em>static</em><ul><li><a href="#module_utils/image.RawImage">.RawImage</a><ul><li><a href="#new_module_utils/image.RawImage_new"><code>new RawImage(data, width, height, channels)</code></a></li> <li><em>instance</em><ul><li><a href="#module_utils/image.RawImage+size"><code>.size</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/image.RawImage+grayscale"><code>.grayscale()</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+rgb"><code>.rgb()</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+rgba"><code>.rgba()</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+resize"><code>.resize(width, height, options)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_utils/image.RawImage+split"><code>.split()</code></a> ⇒ <code>Array.&lt;RawImage&gt;</code></li> <li><a href="#module_utils/image.RawImage+clone"><code>.clone()</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+convert"><code>.convert(numChannels)</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+save"><code>.save(path)</code></a></li></ul></li> <li><em>static</em><ul><li><a href="#module_utils/image.RawImage.read"><code>.read(input)</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/image.RawImage.fromCanvas"><code>.fromCanvas(canvas)</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage.fromURL"><code>.fromURL(url)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_utils/image.RawImage.fromBlob"><code>.fromBlob(blob)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_utils/image.RawImage.fromTensor"><code>.fromTensor(tensor)</code></a></li></ul></li></ul></li> <li><a href="#module_utils/image.load_image"><code>.load_image</code></a></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/image..CONTENT_TYPE_MAP"><code>~CONTENT_TYPE_MAP</code></a></li></ul></li></ul></li>',st,rt,nt,b,gt,C,ut,x,Ll='<strong>Kind</strong>: static class of <a href="#module_utils/image"><code>utils/image</code></a>',ct,H,yl='<li><a href="#module_utils/image.RawImage">.RawImage</a><ul><li><a href="#new_module_utils/image.RawImage_new"><code>new RawImage(data, width, height, channels)</code></a></li> <li><em>instance</em><ul><li><a href="#module_utils/image.RawImage+size"><code>.size</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/image.RawImage+grayscale"><code>.grayscale()</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+rgb"><code>.rgb()</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+rgba"><code>.rgba()</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+resize"><code>.resize(width, height, options)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_utils/image.RawImage+split"><code>.split()</code></a> ⇒ <code>Array.&lt;RawImage&gt;</code></li> <li><a href="#module_utils/image.RawImage+clone"><code>.clone()</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+convert"><code>.convert(numChannels)</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+save"><code>.save(path)</code></a></li></ul></li> <li><em>static</em><ul><li><a href="#module_utils/image.RawImage.read"><code>.read(input)</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/image.RawImage.fromCanvas"><code>.fromCanvas(canvas)</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage.fromURL"><code>.fromURL(url)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_utils/image.RawImage.fromBlob"><code>.fromBlob(blob)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_utils/image.RawImage.fromTensor"><code>.fromTensor(tensor)</code></a></li></ul></li></ul></li>',pt,ft,wt,L,ht,y,Rt,M,Ml="Create a new <code>RawImage</code> object.",It,P,Pl="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Uint8ClampedArray</code> | <code>Uint8Array</code></td><td><p>The pixel data.</p></td> </tr><tr><td>width</td><td><code>number</code></td><td><p>The width of the image.</p></td> </tr><tr><td>height</td><td><code>number</code></td><td><p>The height of the image.</p></td> </tr><tr><td>channels</td><td><code>1</code> | <code>2</code> | <code>3</code> | <code>4</code></td><td><p>The number of channels.</p></td></tr></tbody>",$t,vt,_t,A,Tt,E,bt,z,Al="Returns the size of the image (width, height).",Ct,j,El='<strong>Kind</strong>: instance property of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>*</code> - The size of the image (width, height).',xt,Ht,Lt,U,yt,B,Mt,K,zl="Convert the image to grayscale format.",Pt,k,jl='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>RawImage</code> - <code>this</code> to support chaining.',At,Et,zt,Y,jt,J,Ut,N,Ul="Convert the image to RGB format.",Bt,q,Bl='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>RawImage</code> - <code>this</code> to support chaining.',Kt,kt,Yt,G,Jt,S,Nt,O,Kl="Convert the image to RGBA format.",qt,Z,kl='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>RawImage</code> - <code>this</code> to support chaining.',Gt,St,Ot,D,Zt,W,Dt,F,Yl="Resize the image to the given dimensions. This method uses the canvas API to perform the resizing.",Wt,V,Jl='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;RawImage&gt;</code> - <code>this</code> to support chaining.',Ft,Q,Nl="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>width</td><td><code>number</code></td><td><p>The width of the new image. <code>null</code> or <code>-1</code> will preserve the aspect ratio.</p></td> </tr><tr><td>height</td><td><code>number</code></td><td><p>The height of the new image. <code>null</code> or <code>-1</code> will preserve the aspect ratio.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td><p>Additional options for resizing.</p></td> </tr><tr><td>[options.resample]</td><td><code>0</code> | <code>1</code> | <code>2</code> | <code>3</code> | <code>4</code> | <code>5</code> | <code>string</code></td><td><p>The resampling method to use.</p></td></tr></tbody>",Vt,Qt,Xt,X,ea,ee,ta,te,ql=`Split this image into individual bands. This method returns an array of individual image bands from an image.
For example, splitting an “RGB” image creates three new images each containing a copy of one of the original bands (red, green, blue).`,aa,ae,Gl='Inspired by PIL’s <code>Image.split()</code> <a href="https://pillow.readthedocs.io/en/latest/reference/Image.html#PIL.Image.Image.split" rel="nofollow">function</a>.',la,le,Sl='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;RawImage&gt;</code> - An array containing bands.',ia,ma,da,ie,oa,me,sa,de,Ol="Clone the image",ra,oe,Zl='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>RawImage</code> - The cloned image',na,ga,ua,se,ca,re,pa,ne,Dl="Helper method for converting image to have a certain number of channels",fa,ge,Wl='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>RawImage</code> - <code>this</code> to support chaining.',wa,ue,Fl="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>numChannels</td><td><code>number</code></td><td><p>The number of channels. Must be 1, 3, or 4.</p></td></tr></tbody>",ha,Ra,Ia,ce,$a,pe,va,fe,Vl="Save the image to the given path.",_a,we,Ql='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a>',Ta,he,Xl="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>path</td><td><code>string</code></td><td><p>The path to save the image to.</p></td></tr></tbody>",ba,Ca,xa,Re,Ha,Ie,La,$e,ei="Helper method for reading an image from a variety of input types.",ya,ve,ti='<strong>Kind</strong>: static method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>*</code> - The image object.',Ma,_e,ai="<strong>Example:</strong> Read image from a URL.",Pa,Te,Aa,be,li="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>input</td><td><code>RawImage</code> | <code>string</code> | <code>URL</code></td></tr></tbody>",Ea,za,ja,Ce,Ua,xe,Ba,He,ii="Read an image from a canvas.",Ka,Le,mi='<strong>Kind</strong>: static method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>RawImage</code> - The image object.',ka,ye,di="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>canvas</td><td><code>HTMLCanvasElement</code> | <code>OffscreenCanvas</code></td><td><p>The canvas to read the image from.</p></td></tr></tbody>",Ya,Ja,Na,Me,qa,Pe,Ga,Ae,oi="Read an image from a URL or file path.",Sa,Ee,si='<strong>Kind</strong>: static method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;RawImage&gt;</code> - The image object.',Oa,ze,ri="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>url</td><td><code>string</code> | <code>URL</code></td><td><p>The URL or file path to read the image from.</p></td></tr></tbody>",Za,Da,Wa,je,Fa,Ue,Va,Be,ni="Helper method to create a new Image from a blob.",Qa,Ke,gi='<strong>Kind</strong>: static method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;RawImage&gt;</code> - The image object.',Xa,ke,ui="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>blob</td><td><code>Blob</code></td><td><p>The blob to read the image from.</p></td></tr></tbody>",el,tl,al,Ye,ll,Je,il,Ne,ci="Helper method to create a new Image from a tensor",ml,qe,pi='<strong>Kind</strong>: static method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a>',dl,Ge,fi="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>tensor</td><td><code>Tensor</code></td></tr></tbody>",ol,sl,rl,Se,nl,Oe,gl,Ze,wi="Helper function to load an image from a URL, path, etc.",ul,De,hi='<strong>Kind</strong>: static constant of <a href="#module_utils/image"><code>utils/image</code></a>',cl,pl,fl,We,wl,Fe,hl,Ve,Ri="Mapping from file extensions to MIME types.",Rl,Qe,Ii='<strong>Kind</strong>: inner constant of <a href="#module_utils/image"><code>utils/image</code></a>',Il,$l,vl,Xe,_l,tt,Tl;return $=new h({props:{title:"utils/image",local:"utilsimage",headingTag:"h1"}}),C=new h({props:{title:"utils/image.RawImage",local:"utilsimagerawimage",headingTag:"h2"}}),y=new h({props:{title:"new RawImage(data, width, height, channels)",local:"new-rawimagedata-width-height-channels",headingTag:"h3"}}),E=new h({props:{title:"rawImage.size ⇒ <code> * </code>",local:"rawimagesize--code--code",headingTag:"h3"}}),B=new h({props:{title:"rawImage.grayscale() ⇒ <code> RawImage </code>",local:"rawimagegrayscale--code-rawimage-code",headingTag:"h3"}}),J=new h({props:{title:"rawImage.rgb() ⇒ <code> RawImage </code>",local:"rawimagergb--code-rawimage-code",headingTag:"h3"}}),S=new h({props:{title:"rawImage.rgba() ⇒ <code> RawImage </code>",local:"rawimagergba--code-rawimage-code",headingTag:"h3"}}),W=new h({props:{title:"rawImage.resize(width, height, options) ⇒ <code> Promise. < RawImage > </code>",local:"rawimageresizewidth-height-options--code-promise--rawimage--code",headingTag:"h3"}}),ee=new h({props:{title:"rawImage.split() ⇒ <code> Array. < RawImage > </code>",local:"rawimagesplit--code-array--rawimage--code",headingTag:"h3"}}),me=new h({props:{title:"rawImage.clone() ⇒ <code> RawImage </code>",local:"rawimageclone--code-rawimage-code",headingTag:"h3"}}),re=new h({props:{title:"rawImage.convert(numChannels) ⇒ <code> RawImage </code>",local:"rawimageconvertnumchannels--code-rawimage-code",headingTag:"h3"}}),pe=new h({props:{title:"rawImage.save(path)",local:"rawimagesavepath",headingTag:"h3"}}),Ie=new h({props:{title:"RawImage.read(input) ⇒ <code> * </code>",local:"rawimagereadinput--code--code",headingTag:"h3"}}),Te=new Hi({props:{code:"bGV0JTIwaW1hZ2UlMjAlM0QlMjBhd2FpdCUyMFJhd0ltYWdlLnJlYWQoJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZmb290YmFsbC1tYXRjaC5qcGcnKSUzQiUwQSUyRiUyRiUyMFJhd0ltYWdlJTIw",highlighted:`<span class="hljs-keyword">let</span> image = <span class="hljs-keyword">await</span> <span class="hljs-title class_">RawImage</span>.<span class="hljs-title function_">read</span>(<span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/football-match.jpg&#x27;</span>);
<span class="hljs-comment">// RawImage </span>`,wrap:!1}}),xe=new h({props:{title:"RawImage.fromCanvas(canvas) ⇒ <code> RawImage </code>",local:"rawimagefromcanvascanvas--code-rawimage-code",headingTag:"h3"}}),Pe=new h({props:{title:"RawImage.fromURL(url) ⇒ <code> Promise. < RawImage > </code>",local:"rawimagefromurlurl--code-promise--rawimage--code",headingTag:"h3"}}),Ue=new h({props:{title:"RawImage.fromBlob(blob) ⇒ <code> Promise. < RawImage > </code>",local:"rawimagefromblobblob--code-promise--rawimage--code",headingTag:"h3"}}),Je=new h({props:{title:"RawImage.fromTensor(tensor)",local:"rawimagefromtensortensor",headingTag:"h3"}}),Oe=new h({props:{title:"utils/image.load_image",local:"utilsimageloadimage",headingTag:"h2"}}),Fe=new h({props:{title:"utils/image~CONTENT_TYPE_MAP",local:"utilsimagecontenttypemap",headingTag:"h2"}}),Xe=new Li({props:{source:"https://github.com/huggingface/transformers.js/blob/main/docs/source/api/utils/image.md"}}),{c(){R=d("meta"),at=i(),et=d("p"),lt=i(),I=d("a"),it=i(),n($.$$.fragment),mt=i(),v=d("p"),v.textContent=Cl,dt=i(),_=d("p"),_.textContent=xl,ot=i(),T=d("ul"),T.innerHTML=Hl,st=i(),rt=d("hr"),nt=i(),b=d("a"),gt=i(),n(C.$$.fragment),ut=i(),x=d("p"),x.innerHTML=Ll,ct=i(),H=d("ul"),H.innerHTML=yl,pt=i(),ft=d("hr"),wt=i(),L=d("a"),ht=i(),n(y.$$.fragment),Rt=i(),M=d("p"),M.innerHTML=Ml,It=i(),P=d("table"),P.innerHTML=Pl,$t=i(),vt=d("hr"),_t=i(),A=d("a"),Tt=i(),n(E.$$.fragment),bt=i(),z=d("p"),z.textContent=Al,Ct=i(),j=d("p"),j.innerHTML=El,xt=i(),Ht=d("hr"),Lt=i(),U=d("a"),yt=i(),n(B.$$.fragment),Mt=i(),K=d("p"),K.textContent=zl,Pt=i(),k=d("p"),k.innerHTML=jl,At=i(),Et=d("hr"),zt=i(),Y=d("a"),jt=i(),n(J.$$.fragment),Ut=i(),N=d("p"),N.textContent=Ul,Bt=i(),q=d("p"),q.innerHTML=Bl,Kt=i(),kt=d("hr"),Yt=i(),G=d("a"),Jt=i(),n(S.$$.fragment),Nt=i(),O=d("p"),O.textContent=Kl,qt=i(),Z=d("p"),Z.innerHTML=kl,Gt=i(),St=d("hr"),Ot=i(),D=d("a"),Zt=i(),n(W.$$.fragment),Dt=i(),F=d("p"),F.textContent=Yl,Wt=i(),V=d("p"),V.innerHTML=Jl,Ft=i(),Q=d("table"),Q.innerHTML=Nl,Vt=i(),Qt=d("hr"),Xt=i(),X=d("a"),ea=i(),n(ee.$$.fragment),ta=i(),te=d("p"),te.textContent=ql,aa=i(),ae=d("p"),ae.innerHTML=Gl,la=i(),le=d("p"),le.innerHTML=Sl,ia=i(),ma=d("hr"),da=i(),ie=d("a"),oa=i(),n(me.$$.fragment),sa=i(),de=d("p"),de.textContent=Ol,ra=i(),oe=d("p"),oe.innerHTML=Zl,na=i(),ga=d("hr"),ua=i(),se=d("a"),ca=i(),n(re.$$.fragment),pa=i(),ne=d("p"),ne.textContent=Dl,fa=i(),ge=d("p"),ge.innerHTML=Wl,wa=i(),ue=d("table"),ue.innerHTML=Fl,ha=i(),Ra=d("hr"),Ia=i(),ce=d("a"),$a=i(),n(pe.$$.fragment),va=i(),fe=d("p"),fe.textContent=Vl,_a=i(),we=d("p"),we.innerHTML=Ql,Ta=i(),he=d("table"),he.innerHTML=Xl,ba=i(),Ca=d("hr"),xa=i(),Re=d("a"),Ha=i(),n(Ie.$$.fragment),La=i(),$e=d("p"),$e.textContent=ei,ya=i(),ve=d("p"),ve.innerHTML=ti,Ma=i(),_e=d("p"),_e.innerHTML=ai,Pa=i(),n(Te.$$.fragment),Aa=i(),be=d("table"),be.innerHTML=li,Ea=i(),za=d("hr"),ja=i(),Ce=d("a"),Ua=i(),n(xe.$$.fragment),Ba=i(),He=d("p"),He.textContent=ii,Ka=i(),Le=d("p"),Le.innerHTML=mi,ka=i(),ye=d("table"),ye.innerHTML=di,Ya=i(),Ja=d("hr"),Na=i(),Me=d("a"),qa=i(),n(Pe.$$.fragment),Ga=i(),Ae=d("p"),Ae.textContent=oi,Sa=i(),Ee=d("p"),Ee.innerHTML=si,Oa=i(),ze=d("table"),ze.innerHTML=ri,Za=i(),Da=d("hr"),Wa=i(),je=d("a"),Fa=i(),n(Ue.$$.fragment),Va=i(),Be=d("p"),Be.textContent=ni,Qa=i(),Ke=d("p"),Ke.innerHTML=gi,Xa=i(),ke=d("table"),ke.innerHTML=ui,el=i(),tl=d("hr"),al=i(),Ye=d("a"),ll=i(),n(Je.$$.fragment),il=i(),Ne=d("p"),Ne.textContent=ci,ml=i(),qe=d("p"),qe.innerHTML=pi,dl=i(),Ge=d("table"),Ge.innerHTML=fi,ol=i(),sl=d("hr"),rl=i(),Se=d("a"),nl=i(),n(Oe.$$.fragment),gl=i(),Ze=d("p"),Ze.textContent=wi,ul=i(),De=d("p"),De.innerHTML=hi,cl=i(),pl=d("hr"),fl=i(),We=d("a"),wl=i(),n(Fe.$$.fragment),hl=i(),Ve=d("p"),Ve.textContent=Ri,Rl=i(),Qe=d("p"),Qe.innerHTML=Ii,Il=i(),$l=d("hr"),vl=i(),n(Xe.$$.fragment),_l=i(),tt=d("p"),this.h()},l(e){const t=Ci("svelte-u9bgzb",document.head);R=o(t,"META",{name:!0,content:!0}),t.forEach(a),at=m(e),et=o(e,"P",{}),g(et).forEach(a),lt=m(e),I=o(e,"A",{id:!0,class:!0}),g(I).forEach(a),it=m(e),u($.$$.fragment,e),mt=m(e),v=o(e,"P",{"data-svelte-h":!0}),s(v)!=="svelte-1uts7np"&&(v.textContent=Cl),dt=m(e),_=o(e,"P",{"data-svelte-h":!0}),s(_)!=="svelte-il3kl8"&&(_.textContent=xl),ot=m(e),T=o(e,"UL",{"data-svelte-h":!0}),s(T)!=="svelte-17tfpwl"&&(T.innerHTML=Hl),st=m(e),rt=o(e,"HR",{}),nt=m(e),b=o(e,"A",{id:!0,class:!0}),g(b).forEach(a),gt=m(e),u(C.$$.fragment,e),ut=m(e),x=o(e,"P",{"data-svelte-h":!0}),s(x)!=="svelte-f7iksk"&&(x.innerHTML=Ll),ct=m(e),H=o(e,"UL",{"data-svelte-h":!0}),s(H)!=="svelte-shgyzw"&&(H.innerHTML=yl),pt=m(e),ft=o(e,"HR",{}),wt=m(e),L=o(e,"A",{id:!0,class:!0}),g(L).forEach(a),ht=m(e),u(y.$$.fragment,e),Rt=m(e),M=o(e,"P",{"data-svelte-h":!0}),s(M)!=="svelte-36fe9a"&&(M.innerHTML=Ml),It=m(e),P=o(e,"TABLE",{"data-svelte-h":!0}),s(P)!=="svelte-vkeoul"&&(P.innerHTML=Pl),$t=m(e),vt=o(e,"HR",{}),_t=m(e),A=o(e,"A",{id:!0,class:!0}),g(A).forEach(a),Tt=m(e),u(E.$$.fragment,e),bt=m(e),z=o(e,"P",{"data-svelte-h":!0}),s(z)!=="svelte-2j0n9s"&&(z.textContent=Al),Ct=m(e),j=o(e,"P",{"data-svelte-h":!0}),s(j)!=="svelte-gwg1mu"&&(j.innerHTML=El),xt=m(e),Ht=o(e,"HR",{}),Lt=m(e),U=o(e,"A",{id:!0,class:!0}),g(U).forEach(a),yt=m(e),u(B.$$.fragment,e),Mt=m(e),K=o(e,"P",{"data-svelte-h":!0}),s(K)!=="svelte-1owjjfe"&&(K.textContent=zl),Pt=m(e),k=o(e,"P",{"data-svelte-h":!0}),s(k)!=="svelte-11e9r18"&&(k.innerHTML=jl),At=m(e),Et=o(e,"HR",{}),zt=m(e),Y=o(e,"A",{id:!0,class:!0}),g(Y).forEach(a),jt=m(e),u(J.$$.fragment,e),Ut=m(e),N=o(e,"P",{"data-svelte-h":!0}),s(N)!=="svelte-qyo04e"&&(N.textContent=Ul),Bt=m(e),q=o(e,"P",{"data-svelte-h":!0}),s(q)!=="svelte-11e9r18"&&(q.innerHTML=Bl),Kt=m(e),kt=o(e,"HR",{}),Yt=m(e),G=o(e,"A",{id:!0,class:!0}),g(G).forEach(a),Jt=m(e),u(S.$$.fragment,e),Nt=m(e),O=o(e,"P",{"data-svelte-h":!0}),s(O)!=="svelte-19kp14j"&&(O.textContent=Kl),qt=m(e),Z=o(e,"P",{"data-svelte-h":!0}),s(Z)!=="svelte-11e9r18"&&(Z.innerHTML=kl),Gt=m(e),St=o(e,"HR",{}),Ot=m(e),D=o(e,"A",{id:!0,class:!0}),g(D).forEach(a),Zt=m(e),u(W.$$.fragment,e),Dt=m(e),F=o(e,"P",{"data-svelte-h":!0}),s(F)!=="svelte-s4dm9o"&&(F.textContent=Yl),Wt=m(e),V=o(e,"P",{"data-svelte-h":!0}),s(V)!=="svelte-1jh8cjr"&&(V.innerHTML=Jl),Ft=m(e),Q=o(e,"TABLE",{"data-svelte-h":!0}),s(Q)!=="svelte-h7uulu"&&(Q.innerHTML=Nl),Vt=m(e),Qt=o(e,"HR",{}),Xt=m(e),X=o(e,"A",{id:!0,class:!0}),g(X).forEach(a),ea=m(e),u(ee.$$.fragment,e),ta=m(e),te=o(e,"P",{"data-svelte-h":!0}),s(te)!=="svelte-2m63ix"&&(te.textContent=ql),aa=m(e),ae=o(e,"P",{"data-svelte-h":!0}),s(ae)!=="svelte-k44jcf"&&(ae.innerHTML=Gl),la=m(e),le=o(e,"P",{"data-svelte-h":!0}),s(le)!=="svelte-1jdggat"&&(le.innerHTML=Sl),ia=m(e),ma=o(e,"HR",{}),da=m(e),ie=o(e,"A",{id:!0,class:!0}),g(ie).forEach(a),oa=m(e),u(me.$$.fragment,e),sa=m(e),de=o(e,"P",{"data-svelte-h":!0}),s(de)!=="svelte-1eu6jk3"&&(de.textContent=Ol),ra=m(e),oe=o(e,"P",{"data-svelte-h":!0}),s(oe)!=="svelte-1w4hta5"&&(oe.innerHTML=Zl),na=m(e),ga=o(e,"HR",{}),ua=m(e),se=o(e,"A",{id:!0,class:!0}),g(se).forEach(a),ca=m(e),u(re.$$.fragment,e),pa=m(e),ne=o(e,"P",{"data-svelte-h":!0}),s(ne)!=="svelte-5ze294"&&(ne.textContent=Dl),fa=m(e),ge=o(e,"P",{"data-svelte-h":!0}),s(ge)!=="svelte-11e9r18"&&(ge.innerHTML=Wl),wa=m(e),ue=o(e,"TABLE",{"data-svelte-h":!0}),s(ue)!=="svelte-1hxqxaq"&&(ue.innerHTML=Fl),ha=m(e),Ra=o(e,"HR",{}),Ia=m(e),ce=o(e,"A",{id:!0,class:!0}),g(ce).forEach(a),$a=m(e),u(pe.$$.fragment,e),va=m(e),fe=o(e,"P",{"data-svelte-h":!0}),s(fe)!=="svelte-119su55"&&(fe.textContent=Vl),_a=m(e),we=o(e,"P",{"data-svelte-h":!0}),s(we)!=="svelte-1epyezb"&&(we.innerHTML=Ql),Ta=m(e),he=o(e,"TABLE",{"data-svelte-h":!0}),s(he)!=="svelte-1h4z9xq"&&(he.innerHTML=Xl),ba=m(e),Ca=o(e,"HR",{}),xa=m(e),Re=o(e,"A",{id:!0,class:!0}),g(Re).forEach(a),Ha=m(e),u(Ie.$$.fragment,e),La=m(e),$e=o(e,"P",{"data-svelte-h":!0}),s($e)!=="svelte-5659h9"&&($e.textContent=ei),ya=m(e),ve=o(e,"P",{"data-svelte-h":!0}),s(ve)!=="svelte-1800vfp"&&(ve.innerHTML=ti),Ma=m(e),_e=o(e,"P",{"data-svelte-h":!0}),s(_e)!=="svelte-14z54gq"&&(_e.innerHTML=ai),Pa=m(e),u(Te.$$.fragment,e),Aa=m(e),be=o(e,"TABLE",{"data-svelte-h":!0}),s(be)!=="svelte-eqolu5"&&(be.innerHTML=li),Ea=m(e),za=o(e,"HR",{}),ja=m(e),Ce=o(e,"A",{id:!0,class:!0}),g(Ce).forEach(a),Ua=m(e),u(xe.$$.fragment,e),Ba=m(e),He=o(e,"P",{"data-svelte-h":!0}),s(He)!=="svelte-mjjjch"&&(He.textContent=ii),Ka=m(e),Le=o(e,"P",{"data-svelte-h":!0}),s(Le)!=="svelte-hagi3s"&&(Le.innerHTML=mi),ka=m(e),ye=o(e,"TABLE",{"data-svelte-h":!0}),s(ye)!=="svelte-hzvu44"&&(ye.innerHTML=di),Ya=m(e),Ja=o(e,"HR",{}),Na=m(e),Me=o(e,"A",{id:!0,class:!0}),g(Me).forEach(a),qa=m(e),u(Pe.$$.fragment,e),Ga=m(e),Ae=o(e,"P",{"data-svelte-h":!0}),s(Ae)!=="svelte-1355z3u"&&(Ae.textContent=oi),Sa=m(e),Ee=o(e,"P",{"data-svelte-h":!0}),s(Ee)!=="svelte-10btw3j"&&(Ee.innerHTML=si),Oa=m(e),ze=o(e,"TABLE",{"data-svelte-h":!0}),s(ze)!=="svelte-ncveta"&&(ze.innerHTML=ri),Za=m(e),Da=o(e,"HR",{}),Wa=m(e),je=o(e,"A",{id:!0,class:!0}),g(je).forEach(a),Fa=m(e),u(Ue.$$.fragment,e),Va=m(e),Be=o(e,"P",{"data-svelte-h":!0}),s(Be)!=="svelte-1s704mu"&&(Be.textContent=ni),Qa=m(e),Ke=o(e,"P",{"data-svelte-h":!0}),s(Ke)!=="svelte-10btw3j"&&(Ke.innerHTML=gi),Xa=m(e),ke=o(e,"TABLE",{"data-svelte-h":!0}),s(ke)!=="svelte-34rbhe"&&(ke.innerHTML=ui),el=m(e),tl=o(e,"HR",{}),al=m(e),Ye=o(e,"A",{id:!0,class:!0}),g(Ye).forEach(a),ll=m(e),u(Je.$$.fragment,e),il=m(e),Ne=o(e,"P",{"data-svelte-h":!0}),s(Ne)!=="svelte-nwy2y"&&(Ne.textContent=ci),ml=m(e),qe=o(e,"P",{"data-svelte-h":!0}),s(qe)!=="svelte-sl3vqa"&&(qe.innerHTML=pi),dl=m(e),Ge=o(e,"TABLE",{"data-svelte-h":!0}),s(Ge)!=="svelte-10oxyio"&&(Ge.innerHTML=fi),ol=m(e),sl=o(e,"HR",{}),rl=m(e),Se=o(e,"A",{id:!0,class:!0}),g(Se).forEach(a),nl=m(e),u(Oe.$$.fragment,e),gl=m(e),Ze=o(e,"P",{"data-svelte-h":!0}),s(Ze)!=="svelte-eu8o7o"&&(Ze.textContent=wi),ul=m(e),De=o(e,"P",{"data-svelte-h":!0}),s(De)!=="svelte-1ricti2"&&(De.innerHTML=hi),cl=m(e),pl=o(e,"HR",{}),fl=m(e),We=o(e,"A",{id:!0,class:!0}),g(We).forEach(a),wl=m(e),u(Fe.$$.fragment,e),hl=m(e),Ve=o(e,"P",{"data-svelte-h":!0}),s(Ve)!=="svelte-15u13r6"&&(Ve.textContent=Ri),Rl=m(e),Qe=o(e,"P",{"data-svelte-h":!0}),s(Qe)!=="svelte-1cwm6ga"&&(Qe.innerHTML=Ii),Il=m(e),$l=o(e,"HR",{}),vl=m(e),u(Xe.$$.fragment,e),_l=m(e),tt=o(e,"P",{}),g(tt).forEach(a),this.h()},h(){r(R,"name","hf:doc:metadata"),r(R,"content",Mi),r(I,"id","module_utils/image"),r(I,"class","group"),r(b,"id","module_utils/image.RawImage"),r(b,"class","group"),r(L,"id","new_module_utils/image.RawImage_new"),r(L,"class","group"),r(A,"id","module_utils/image.RawImage+size"),r(A,"class","group"),r(U,"id","module_utils/image.RawImage+grayscale"),r(U,"class","group"),r(Y,"id","module_utils/image.RawImage+rgb"),r(Y,"class","group"),r(G,"id","module_utils/image.RawImage+rgba"),r(G,"class","group"),r(D,"id","module_utils/image.RawImage+resize"),r(D,"class","group"),r(X,"id","module_utils/image.RawImage+split"),r(X,"class","group"),r(ie,"id","module_utils/image.RawImage+clone"),r(ie,"class","group"),r(se,"id","module_utils/image.RawImage+convert"),r(se,"class","group"),r(ce,"id","module_utils/image.RawImage+save"),r(ce,"class","group"),r(Re,"id","module_utils/image.RawImage.read"),r(Re,"class","group"),r(Ce,"id","module_utils/image.RawImage.fromCanvas"),r(Ce,"class","group"),r(Me,"id","module_utils/image.RawImage.fromURL"),r(Me,"class","group"),r(je,"id","module_utils/image.RawImage.fromBlob"),r(je,"class","group"),r(Ye,"id","module_utils/image.RawImage.fromTensor"),r(Ye,"class","group"),r(Se,"id","module_utils/image.load_image"),r(Se,"class","group"),r(We,"id","module_utils/image..CONTENT_TYPE_MAP"),r(We,"class","group")},m(e,t){xi(document.head,R),l(e,at,t),l(e,et,t),l(e,lt,t),l(e,I,t),l(e,it,t),c($,e,t),l(e,mt,t),l(e,v,t),l(e,dt,t),l(e,_,t),l(e,ot,t),l(e,T,t),l(e,st,t),l(e,rt,t),l(e,nt,t),l(e,b,t),l(e,gt,t),c(C,e,t),l(e,ut,t),l(e,x,t),l(e,ct,t),l(e,H,t),l(e,pt,t),l(e,ft,t),l(e,wt,t),l(e,L,t),l(e,ht,t),c(y,e,t),l(e,Rt,t),l(e,M,t),l(e,It,t),l(e,P,t),l(e,$t,t),l(e,vt,t),l(e,_t,t),l(e,A,t),l(e,Tt,t),c(E,e,t),l(e,bt,t),l(e,z,t),l(e,Ct,t),l(e,j,t),l(e,xt,t),l(e,Ht,t),l(e,Lt,t),l(e,U,t),l(e,yt,t),c(B,e,t),l(e,Mt,t),l(e,K,t),l(e,Pt,t),l(e,k,t),l(e,At,t),l(e,Et,t),l(e,zt,t),l(e,Y,t),l(e,jt,t),c(J,e,t),l(e,Ut,t),l(e,N,t),l(e,Bt,t),l(e,q,t),l(e,Kt,t),l(e,kt,t),l(e,Yt,t),l(e,G,t),l(e,Jt,t),c(S,e,t),l(e,Nt,t),l(e,O,t),l(e,qt,t),l(e,Z,t),l(e,Gt,t),l(e,St,t),l(e,Ot,t),l(e,D,t),l(e,Zt,t),c(W,e,t),l(e,Dt,t),l(e,F,t),l(e,Wt,t),l(e,V,t),l(e,Ft,t),l(e,Q,t),l(e,Vt,t),l(e,Qt,t),l(e,Xt,t),l(e,X,t),l(e,ea,t),c(ee,e,t),l(e,ta,t),l(e,te,t),l(e,aa,t),l(e,ae,t),l(e,la,t),l(e,le,t),l(e,ia,t),l(e,ma,t),l(e,da,t),l(e,ie,t),l(e,oa,t),c(me,e,t),l(e,sa,t),l(e,de,t),l(e,ra,t),l(e,oe,t),l(e,na,t),l(e,ga,t),l(e,ua,t),l(e,se,t),l(e,ca,t),c(re,e,t),l(e,pa,t),l(e,ne,t),l(e,fa,t),l(e,ge,t),l(e,wa,t),l(e,ue,t),l(e,ha,t),l(e,Ra,t),l(e,Ia,t),l(e,ce,t),l(e,$a,t),c(pe,e,t),l(e,va,t),l(e,fe,t),l(e,_a,t),l(e,we,t),l(e,Ta,t),l(e,he,t),l(e,ba,t),l(e,Ca,t),l(e,xa,t),l(e,Re,t),l(e,Ha,t),c(Ie,e,t),l(e,La,t),l(e,$e,t),l(e,ya,t),l(e,ve,t),l(e,Ma,t),l(e,_e,t),l(e,Pa,t),c(Te,e,t),l(e,Aa,t),l(e,be,t),l(e,Ea,t),l(e,za,t),l(e,ja,t),l(e,Ce,t),l(e,Ua,t),c(xe,e,t),l(e,Ba,t),l(e,He,t),l(e,Ka,t),l(e,Le,t),l(e,ka,t),l(e,ye,t),l(e,Ya,t),l(e,Ja,t),l(e,Na,t),l(e,Me,t),l(e,qa,t),c(Pe,e,t),l(e,Ga,t),l(e,Ae,t),l(e,Sa,t),l(e,Ee,t),l(e,Oa,t),l(e,ze,t),l(e,Za,t),l(e,Da,t),l(e,Wa,t),l(e,je,t),l(e,Fa,t),c(Ue,e,t),l(e,Va,t),l(e,Be,t),l(e,Qa,t),l(e,Ke,t),l(e,Xa,t),l(e,ke,t),l(e,el,t),l(e,tl,t),l(e,al,t),l(e,Ye,t),l(e,ll,t),c(Je,e,t),l(e,il,t),l(e,Ne,t),l(e,ml,t),l(e,qe,t),l(e,dl,t),l(e,Ge,t),l(e,ol,t),l(e,sl,t),l(e,rl,t),l(e,Se,t),l(e,nl,t),c(Oe,e,t),l(e,gl,t),l(e,Ze,t),l(e,ul,t),l(e,De,t),l(e,cl,t),l(e,pl,t),l(e,fl,t),l(e,We,t),l(e,wl,t),c(Fe,e,t),l(e,hl,t),l(e,Ve,t),l(e,Rl,t),l(e,Qe,t),l(e,Il,t),l(e,$l,t),l(e,vl,t),c(Xe,e,t),l(e,_l,t),l(e,tt,t),Tl=!0},p:vi,i(e){Tl||(p($.$$.fragment,e),p(C.$$.fragment,e),p(y.$$.fragment,e),p(E.$$.fragment,e),p(B.$$.fragment,e),p(J.$$.fragment,e),p(S.$$.fragment,e),p(W.$$.fragment,e),p(ee.$$.fragment,e),p(me.$$.fragment,e),p(re.$$.fragment,e),p(pe.$$.fragment,e),p(Ie.$$.fragment,e),p(Te.$$.fragment,e),p(xe.$$.fragment,e),p(Pe.$$.fragment,e),p(Ue.$$.fragment,e),p(Je.$$.fragment,e),p(Oe.$$.fragment,e),p(Fe.$$.fragment,e),p(Xe.$$.fragment,e),Tl=!0)},o(e){f($.$$.fragment,e),f(C.$$.fragment,e),f(y.$$.fragment,e),f(E.$$.fragment,e),f(B.$$.fragment,e),f(J.$$.fragment,e),f(S.$$.fragment,e),f(W.$$.fragment,e),f(ee.$$.fragment,e),f(me.$$.fragment,e),f(re.$$.fragment,e),f(pe.$$.fragment,e),f(Ie.$$.fragment,e),f(Te.$$.fragment,e),f(xe.$$.fragment,e),f(Pe.$$.fragment,e),f(Ue.$$.fragment,e),f(Je.$$.fragment,e),f(Oe.$$.fragment,e),f(Fe.$$.fragment,e),f(Xe.$$.fragment,e),Tl=!1},d(e){e&&(a(at),a(et),a(lt),a(I),a(it),a(mt),a(v),a(dt),a(_),a(ot),a(T),a(st),a(rt),a(nt),a(b),a(gt),a(ut),a(x),a(ct),a(H),a(pt),a(ft),a(wt),a(L),a(ht),a(Rt),a(M),a(It),a(P),a($t),a(vt),a(_t),a(A),a(Tt),a(bt),a(z),a(Ct),a(j),a(xt),a(Ht),a(Lt),a(U),a(yt),a(Mt),a(K),a(Pt),a(k),a(At),a(Et),a(zt),a(Y),a(jt),a(Ut),a(N),a(Bt),a(q),a(Kt),a(kt),a(Yt),a(G),a(Jt),a(Nt),a(O),a(qt),a(Z),a(Gt),a(St),a(Ot),a(D),a(Zt),a(Dt),a(F),a(Wt),a(V),a(Ft),a(Q),a(Vt),a(Qt),a(Xt),a(X),a(ea),a(ta),a(te),a(aa),a(ae),a(la),a(le),a(ia),a(ma),a(da),a(ie),a(oa),a(sa),a(de),a(ra),a(oe),a(na),a(ga),a(ua),a(se),a(ca),a(pa),a(ne),a(fa),a(ge),a(wa),a(ue),a(ha),a(Ra),a(Ia),a(ce),a($a),a(va),a(fe),a(_a),a(we),a(Ta),a(he),a(ba),a(Ca),a(xa),a(Re),a(Ha),a(La),a($e),a(ya),a(ve),a(Ma),a(_e),a(Pa),a(Aa),a(be),a(Ea),a(za),a(ja),a(Ce),a(Ua),a(Ba),a(He),a(Ka),a(Le),a(ka),a(ye),a(Ya),a(Ja),a(Na),a(Me),a(qa),a(Ga),a(Ae),a(Sa),a(Ee),a(Oa),a(ze),a(Za),a(Da),a(Wa),a(je),a(Fa),a(Va),a(Be),a(Qa),a(Ke),a(Xa),a(ke),a(el),a(tl),a(al),a(Ye),a(ll),a(il),a(Ne),a(ml),a(qe),a(dl),a(Ge),a(ol),a(sl),a(rl),a(Se),a(nl),a(gl),a(Ze),a(ul),a(De),a(cl),a(pl),a(fl),a(We),a(wl),a(hl),a(Ve),a(Rl),a(Qe),a(Il),a($l),a(vl),a(_l),a(tt)),a(R),w($,e),w(C,e),w(y,e),w(E,e),w(B,e),w(J,e),w(S,e),w(W,e),w(ee,e),w(me,e),w(re,e),w(pe,e),w(Ie,e),w(Te,e),w(xe,e),w(Pe,e),w(Ue,e),w(Je,e),w(Oe,e),w(Fe,e),w(Xe,e)}}}const Mi='{"title":"utils/image","local":"utilsimage","sections":[{"title":"utils/image.RawImage","local":"utilsimagerawimage","sections":[{"title":"new RawImage(data, width, height, channels)","local":"new-rawimagedata-width-height-channels","sections":[],"depth":3},{"title":"rawImage.size ⇒ <code> * </code>","local":"rawimagesize--code--code","sections":[],"depth":3},{"title":"rawImage.grayscale() ⇒ <code> RawImage </code>","local":"rawimagegrayscale--code-rawimage-code","sections":[],"depth":3},{"title":"rawImage.rgb() ⇒ <code> RawImage </code>","local":"rawimagergb--code-rawimage-code","sections":[],"depth":3},{"title":"rawImage.rgba() ⇒ <code> RawImage </code>","local":"rawimagergba--code-rawimage-code","sections":[],"depth":3},{"title":"rawImage.resize(width, height, options) ⇒ <code> Promise. < RawImage > </code>","local":"rawimageresizewidth-height-options--code-promise--rawimage--code","sections":[],"depth":3},{"title":"rawImage.split() ⇒ <code> Array. < RawImage > </code>","local":"rawimagesplit--code-array--rawimage--code","sections":[],"depth":3},{"title":"rawImage.clone() ⇒ <code> RawImage </code>","local":"rawimageclone--code-rawimage-code","sections":[],"depth":3},{"title":"rawImage.convert(numChannels) ⇒ <code> RawImage </code>","local":"rawimageconvertnumchannels--code-rawimage-code","sections":[],"depth":3},{"title":"rawImage.save(path)","local":"rawimagesavepath","sections":[],"depth":3},{"title":"RawImage.read(input) ⇒ <code> * </code>","local":"rawimagereadinput--code--code","sections":[],"depth":3},{"title":"RawImage.fromCanvas(canvas) ⇒ <code> RawImage </code>","local":"rawimagefromcanvascanvas--code-rawimage-code","sections":[],"depth":3},{"title":"RawImage.fromURL(url) ⇒ <code> Promise. < RawImage > </code>","local":"rawimagefromurlurl--code-promise--rawimage--code","sections":[],"depth":3},{"title":"RawImage.fromBlob(blob) ⇒ <code> Promise. < RawImage > </code>","local":"rawimagefromblobblob--code-promise--rawimage--code","sections":[],"depth":3},{"title":"RawImage.fromTensor(tensor)","local":"rawimagefromtensortensor","sections":[],"depth":3}],"depth":2},{"title":"utils/image.load_image","local":"utilsimageloadimage","sections":[],"depth":2},{"title":"utils/image~CONTENT_TYPE_MAP","local":"utilsimagecontenttypemap","sections":[],"depth":2}],"depth":1}';function Pi(bl){return _i(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ui extends Ti{constructor(R){super(),bi(this,R,Pi,yi,$i,{})}}export{Ui as component};
