import{s as _t,n as Et,o as Zt}from"../chunks/scheduler.37c15a92.js";import{S as vt,i as kt,g as i,s as n,r,A as xt,h as p,f as l,c as a,j as It,u as m,x as o,k as Rt,y as Bt,a as s,v as c,d as M,t as d,w as y}from"../chunks/index.2bf4358c.js";import{C as yt}from"../chunks/CodeBlock.4f5fc1ad.js";import{H as Y,E as Wt}from"../chunks/EditOnGithub.8916dc7c.js";function Xt(ut){let u,Q,F,S,w,A,h,wt="In this page, we’ll learn how to implement Group Relative Policy Optimization (GRPO) using the Transformer Reinforcement Learning (TRL) library. We’ll focus on practical implementation with minimal code.",H,f,ht="We’ll explore the core concepts of GRPO as they are embodied in TRL’s GRPOTrainer, using snippets from the official TRL documentation to guide us.",P,U,ft="First, let’s remind ourselves of some of the important concepts of GRPO algorithm:",V,j,Ut="<li>Group Formation: The model generates multiple completions for each prompt.</li> <li>Preference Learning: The model uses a reward function to compare the completions and select the best one.</li> <li>Training Configuration: The model uses a configuration to control the training process.</li>",N,T,jt="What do we need to do to implement GRPO?",q,J,Tt="<li>Define a dataset of prompts and completions.</li> <li>Define a reward function that takes a list of completions and returns a list of rewards.</li> <li>Configure the training process with a GRPOConfig.</li> <li>Train the model using the GRPOTrainer.</li>",L,g,Jt="Here’s a minimal example to get started with GRPO training:",O,C,D,G,K,b,tt,$,gt="Your dataset should contain prompts that the model will respond to. The GRPO trainer will generate multiple completions for each prompt and use the reward function to compare them.",et,I,lt,R,Ct="The reward function is crucial - it determines how the model learns. Here are two practical examples:",st,_,nt,E,at,Z,Gt="Key parameters to consider in <code>GRPOConfig</code>:",it,v,pt,k,ot,x,bt="<li><strong>Memory Management</strong>: Adjust <code>per_device_train_batch_size</code> and <code>gradient_accumulation_steps</code> based on your GPU memory.</li> <li><strong>Speed</strong>: Enable <code>use_vllm=True</code> for faster generation if your model is supported.</li> <li><strong>Monitoring</strong>: Watch the logged metrics during training:<ul><li><code>reward</code>: Average reward across completions</li> <li><code>reward_std</code>: Standard deviation within reward groups</li> <li><code>kl</code>: KL divergence from reference model</li></ul></li>",rt,B,mt,W,$t="In the next section, you will follow an exercise to implement GRPO in TRL.",ct,X,Mt,z,dt;return w=new Y({props:{title:"Implementing GRPO in TRL",local:"implementing-grpo-in-trl",headingTag:"h1"}}),C=new yt({props:{code:"ZnJvbSUyMHRybCUyMGltcG9ydCUyMEdSUE9UcmFpbmVyJTJDJTIwR1JQT0NvbmZpZyUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQSUyMyUyMDEuJTIwTG9hZCUyMHlvdXIlMjBkYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJ5b3VyX2RhdGFzZXQlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQSUwQSUyMyUyMDIuJTIwRGVmaW5lJTIwYSUyMHNpbXBsZSUyMHJld2FyZCUyMGZ1bmN0aW9uJTBBZGVmJTIwcmV3YXJkX2Z1bmMoY29tcGxldGlvbnMlMkMlMjAqKmt3YXJncyklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJFeGFtcGxlJTNBJTIwUmV3YXJkJTIwbG9uZ2VyJTIwY29tcGxldGlvbnMlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlNUJmbG9hdChsZW4oY29tcGxldGlvbikpJTIwZm9yJTIwY29tcGxldGlvbiUyMGluJTIwY29tcGxldGlvbnMlNUQlMEElMEElMEElMjMlMjAzLiUyMENvbmZpZ3VyZSUyMHRyYWluaW5nJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMEdSUE9Db25maWcoJTBBJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRCUyMm91dHB1dCUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV90cmFpbl9lcG9jaHMlM0QzJTJDJTBBJTIwJTIwJTIwJTIwcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTNENCUyQyUwQSUyMCUyMCUyMCUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDIlMkMlMEElMjAlMjAlMjAlMjBsb2dnaW5nX3N0ZXBzJTNEMTAlMkMlMEEpJTBBJTBBJTIzJTIwNC4lMjBJbml0aWFsaXplJTIwYW5kJTIwdHJhaW4lMEF0cmFpbmVyJTIwJTNEJTIwR1JQT1RyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJ5b3VyX21vZGVsJTIyJTJDJTIwJTIwJTIzJTIwZS5nLiUyMCUyMlF3ZW4lMkZRd2VuMi0wLjVCLUluc3RydWN0JTIyJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMHJld2FyZF9mdW5jcyUzRHJld2FyZF9mdW5jJTJDJTBBKSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> GRPOTrainer, GRPOConfig
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># 1. Load your dataset</span>
dataset = load_dataset(<span class="hljs-string">&quot;your_dataset&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)


<span class="hljs-comment"># 2. Define a simple reward function</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">reward_func</span>(<span class="hljs-params">completions, **kwargs</span>):
    <span class="hljs-string">&quot;&quot;&quot;Example: Reward longer completions&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> [<span class="hljs-built_in">float</span>(<span class="hljs-built_in">len</span>(completion)) <span class="hljs-keyword">for</span> completion <span class="hljs-keyword">in</span> completions]


<span class="hljs-comment"># 3. Configure training</span>
training_args = GRPOConfig(
    output_dir=<span class="hljs-string">&quot;output&quot;</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    per_device_train_batch_size=<span class="hljs-number">4</span>,
    gradient_accumulation_steps=<span class="hljs-number">2</span>,
    logging_steps=<span class="hljs-number">10</span>,
)

<span class="hljs-comment"># 4. Initialize and train</span>
trainer = GRPOTrainer(
    model=<span class="hljs-string">&quot;your_model&quot;</span>,  <span class="hljs-comment"># e.g. &quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>
    args=training_args,
    train_dataset=dataset,
    reward_funcs=reward_func,
)
trainer.train()`,wrap:!1}}),G=new Y({props:{title:"Key Components",local:"key-components",headingTag:"h2"}}),b=new Y({props:{title:"1. Dataset Format",local:"1-dataset-format",headingTag:"h3"}}),I=new Y({props:{title:"2. Reward Function",local:"2-reward-function",headingTag:"h3"}}),_=new yt({props:{code:"JTIzJTIwRXhhbXBsZSUyMDElM0ElMjBSZXdhcmQlMjBiYXNlZCUyMG9uJTIwY29tcGxldGlvbiUyMGxlbmd0aCUwQWRlZiUyMHJld2FyZF9sZW5ndGgoY29tcGxldGlvbnMlMkMlMjAqKmt3YXJncyklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlNUJmbG9hdChsZW4oY29tcGxldGlvbikpJTIwZm9yJTIwY29tcGxldGlvbiUyMGluJTIwY29tcGxldGlvbnMlNUQlMEElMEElMEElMjMlMjBFeGFtcGxlJTIwMiUzQSUyMFJld2FyZCUyMGJhc2VkJTIwb24lMjBtYXRjaGluZyUyMGElMjBwYXR0ZXJuJTBBaW1wb3J0JTIwcmUlMEElMEElMEFkZWYlMjByZXdhcmRfZm9ybWF0KGNvbXBsZXRpb25zJTJDJTIwKiprd2FyZ3MpJTNBJTBBJTIwJTIwJTIwJTIwcGF0dGVybiUyMCUzRCUyMHIlMjIlNUUlM0N0aGluayUzRS4qJTNGJTNDJTJGdGhpbmslM0UlM0NhbnN3ZXIlM0UuKiUzRiUzQyUyRmFuc3dlciUzRSUyNCUyMiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU1QjEuMCUyMGlmJTIwcmUubWF0Y2gocGF0dGVybiUyQyUyMGMpJTIwZWxzZSUyMDAuMCUyMGZvciUyMGMlMjBpbiUyMGNvbXBsZXRpb25zJTVE",highlighted:`<span class="hljs-comment"># Example 1: Reward based on completion length</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">reward_length</span>(<span class="hljs-params">completions, **kwargs</span>):
    <span class="hljs-keyword">return</span> [<span class="hljs-built_in">float</span>(<span class="hljs-built_in">len</span>(completion)) <span class="hljs-keyword">for</span> completion <span class="hljs-keyword">in</span> completions]


<span class="hljs-comment"># Example 2: Reward based on matching a pattern</span>
<span class="hljs-keyword">import</span> re


<span class="hljs-keyword">def</span> <span class="hljs-title function_">reward_format</span>(<span class="hljs-params">completions, **kwargs</span>):
    pattern = <span class="hljs-string">r&quot;^&lt;think&gt;.*?&lt;/think&gt;&lt;answer&gt;.*?&lt;/answer&gt;$&quot;</span>
    <span class="hljs-keyword">return</span> [<span class="hljs-number">1.0</span> <span class="hljs-keyword">if</span> re.<span class="hljs-keyword">match</span>(pattern, c) <span class="hljs-keyword">else</span> <span class="hljs-number">0.0</span> <span class="hljs-keyword">for</span> c <span class="hljs-keyword">in</span> completions]`,wrap:!1}}),E=new Y({props:{title:"3. Training Configuration",local:"3-training-configuration",headingTag:"h3"}}),v=new yt({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMEdSUE9Db25maWcoJTBBJTIwJTIwJTIwJTIwJTIzJTIwRXNzZW50aWFsJTIwcGFyYW1ldGVycyUwQSUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0QlMjJvdXRwdXQlMjIlMkMlMEElMjAlMjAlMjAlMjBudW1fdHJhaW5fZXBvY2hzJTNEMyUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMkMlMEElMjAlMjAlMjAlMjAlMjMlMjBPcHRpb25hbCUyMGJ1dCUyMHVzZWZ1bCUwQSUyMCUyMCUyMCUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDIlMkMlMEElMjAlMjAlMjAlMjBsZWFybmluZ19yYXRlJTNEMWUtNSUyQyUwQSUyMCUyMCUyMCUyMGxvZ2dpbmdfc3RlcHMlM0QxMCUyQyUwQSUyMCUyMCUyMCUyMCUyMyUyMEdSUE8lMjBzcGVjaWZpYyUyMChvcHRpb25hbCklMEElMjAlMjAlMjAlMjB1c2VfdmxsbSUzRFRydWUlMkMlMjAlMjAlMjMlMjBTcGVlZCUyMHVwJTIwZ2VuZXJhdGlvbiUwQSk=",highlighted:`training_args = GRPOConfig(
    <span class="hljs-comment"># Essential parameters</span>
    output_dir=<span class="hljs-string">&quot;output&quot;</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    per_device_train_batch_size=<span class="hljs-number">4</span>,
    <span class="hljs-comment"># Optional but useful</span>
    gradient_accumulation_steps=<span class="hljs-number">2</span>,
    learning_rate=<span class="hljs-number">1e-5</span>,
    logging_steps=<span class="hljs-number">10</span>,
    <span class="hljs-comment"># GRPO specific (optional)</span>
    use_vllm=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Speed up generation</span>
)`,wrap:!1}}),k=new Y({props:{title:"Tips for Success",local:"tips-for-success",headingTag:"h2"}}),B=new Y({props:{title:"That’s it!",local:"thats-it",headingTag:"h2"}}),X=new Wt({props:{source:"https://github.com/huggingface/course/blob/main/chapters/en/chapter13/4.mdx"}}),{c(){u=i("meta"),Q=n(),F=i("p"),S=n(),r(w.$$.fragment),A=n(),h=i("p"),h.textContent=wt,H=n(),f=i("p"),f.textContent=ht,P=n(),U=i("p"),U.textContent=ft,V=n(),j=i("ul"),j.innerHTML=Ut,N=n(),T=i("p"),T.textContent=jt,q=n(),J=i("ul"),J.innerHTML=Tt,L=n(),g=i("p"),g.textContent=Jt,O=n(),r(C.$$.fragment),D=n(),r(G.$$.fragment),K=n(),r(b.$$.fragment),tt=n(),$=i("p"),$.textContent=gt,et=n(),r(I.$$.fragment),lt=n(),R=i("p"),R.textContent=Ct,st=n(),r(_.$$.fragment),nt=n(),r(E.$$.fragment),at=n(),Z=i("p"),Z.innerHTML=Gt,it=n(),r(v.$$.fragment),pt=n(),r(k.$$.fragment),ot=n(),x=i("ol"),x.innerHTML=bt,rt=n(),r(B.$$.fragment),mt=n(),W=i("p"),W.textContent=$t,ct=n(),r(X.$$.fragment),Mt=n(),z=i("p"),this.h()},l(t){const e=xt("svelte-u9bgzb",document.head);u=p(e,"META",{name:!0,content:!0}),e.forEach(l),Q=a(t),F=p(t,"P",{}),It(F).forEach(l),S=a(t),m(w.$$.fragment,t),A=a(t),h=p(t,"P",{"data-svelte-h":!0}),o(h)!=="svelte-v9iq5e"&&(h.textContent=wt),H=a(t),f=p(t,"P",{"data-svelte-h":!0}),o(f)!=="svelte-iqdzey"&&(f.textContent=ht),P=a(t),U=p(t,"P",{"data-svelte-h":!0}),o(U)!=="svelte-14hk95q"&&(U.textContent=ft),V=a(t),j=p(t,"UL",{"data-svelte-h":!0}),o(j)!=="svelte-1vzuxki"&&(j.innerHTML=Ut),N=a(t),T=p(t,"P",{"data-svelte-h":!0}),o(T)!=="svelte-pzoe2y"&&(T.textContent=jt),q=a(t),J=p(t,"UL",{"data-svelte-h":!0}),o(J)!=="svelte-iqt7sy"&&(J.innerHTML=Tt),L=a(t),g=p(t,"P",{"data-svelte-h":!0}),o(g)!=="svelte-ac9u4w"&&(g.textContent=Jt),O=a(t),m(C.$$.fragment,t),D=a(t),m(G.$$.fragment,t),K=a(t),m(b.$$.fragment,t),tt=a(t),$=p(t,"P",{"data-svelte-h":!0}),o($)!=="svelte-1pnmwnq"&&($.textContent=gt),et=a(t),m(I.$$.fragment,t),lt=a(t),R=p(t,"P",{"data-svelte-h":!0}),o(R)!=="svelte-ths948"&&(R.textContent=Ct),st=a(t),m(_.$$.fragment,t),nt=a(t),m(E.$$.fragment,t),at=a(t),Z=p(t,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1uukcnx"&&(Z.innerHTML=Gt),it=a(t),m(v.$$.fragment,t),pt=a(t),m(k.$$.fragment,t),ot=a(t),x=p(t,"OL",{"data-svelte-h":!0}),o(x)!=="svelte-4ukx5l"&&(x.innerHTML=bt),rt=a(t),m(B.$$.fragment,t),mt=a(t),W=p(t,"P",{"data-svelte-h":!0}),o(W)!=="svelte-chd5s6"&&(W.textContent=$t),ct=a(t),m(X.$$.fragment,t),Mt=a(t),z=p(t,"P",{}),It(z).forEach(l),this.h()},h(){Rt(u,"name","hf:doc:metadata"),Rt(u,"content",Yt)},m(t,e){Bt(document.head,u),s(t,Q,e),s(t,F,e),s(t,S,e),c(w,t,e),s(t,A,e),s(t,h,e),s(t,H,e),s(t,f,e),s(t,P,e),s(t,U,e),s(t,V,e),s(t,j,e),s(t,N,e),s(t,T,e),s(t,q,e),s(t,J,e),s(t,L,e),s(t,g,e),s(t,O,e),c(C,t,e),s(t,D,e),c(G,t,e),s(t,K,e),c(b,t,e),s(t,tt,e),s(t,$,e),s(t,et,e),c(I,t,e),s(t,lt,e),s(t,R,e),s(t,st,e),c(_,t,e),s(t,nt,e),c(E,t,e),s(t,at,e),s(t,Z,e),s(t,it,e),c(v,t,e),s(t,pt,e),c(k,t,e),s(t,ot,e),s(t,x,e),s(t,rt,e),c(B,t,e),s(t,mt,e),s(t,W,e),s(t,ct,e),c(X,t,e),s(t,Mt,e),s(t,z,e),dt=!0},p:Et,i(t){dt||(M(w.$$.fragment,t),M(C.$$.fragment,t),M(G.$$.fragment,t),M(b.$$.fragment,t),M(I.$$.fragment,t),M(_.$$.fragment,t),M(E.$$.fragment,t),M(v.$$.fragment,t),M(k.$$.fragment,t),M(B.$$.fragment,t),M(X.$$.fragment,t),dt=!0)},o(t){d(w.$$.fragment,t),d(C.$$.fragment,t),d(G.$$.fragment,t),d(b.$$.fragment,t),d(I.$$.fragment,t),d(_.$$.fragment,t),d(E.$$.fragment,t),d(v.$$.fragment,t),d(k.$$.fragment,t),d(B.$$.fragment,t),d(X.$$.fragment,t),dt=!1},d(t){t&&(l(Q),l(F),l(S),l(A),l(h),l(H),l(f),l(P),l(U),l(V),l(j),l(N),l(T),l(q),l(J),l(L),l(g),l(O),l(D),l(K),l(tt),l($),l(et),l(lt),l(R),l(st),l(nt),l(at),l(Z),l(it),l(pt),l(ot),l(x),l(rt),l(mt),l(W),l(ct),l(Mt),l(z)),l(u),y(w,t),y(C,t),y(G,t),y(b,t),y(I,t),y(_,t),y(E,t),y(v,t),y(k,t),y(B,t),y(X,t)}}}const Yt='{"title":"Implementing GRPO in TRL","local":"implementing-grpo-in-trl","sections":[{"title":"Key Components","local":"key-components","sections":[{"title":"1. Dataset Format","local":"1-dataset-format","sections":[],"depth":3},{"title":"2. Reward Function","local":"2-reward-function","sections":[],"depth":3},{"title":"3. Training Configuration","local":"3-training-configuration","sections":[],"depth":3}],"depth":2},{"title":"Tips for Success","local":"tips-for-success","sections":[],"depth":2},{"title":"That’s it!","local":"thats-it","sections":[],"depth":2}],"depth":1}';function Ft(ut){return Zt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ht extends vt{constructor(u){super(),kt(this,u,Ft,Xt,_t,{})}}export{Ht as component};
