import{s as _l,n as Pl,o as Ol}from"../chunks/scheduler.37c15a92.js";import{S as Dl,i as Kl,g as u,s as a,r as i,A as lt,h as d,f as e,c as n,j as ql,u as p,x as h,k as Hl,y as tt,a as s,v as m,d as o,t as r,w as M}from"../chunks/index.2bf4358c.js";import{C as y}from"../chunks/CodeBlock.4f5fc1ad.js";import{H as c}from"../chunks/Heading.8ada512a.js";import{E as et}from"../chunks/EditOnGithub.9958bcdc.js";function st(Ql){let g,ll,D,tl,J,el,f,kl="In this chapter, we’ll explore three popular tools for running LLMs locally: Ollama, LMStudio, and llama.cpp. Each tool offers unique advantages for local inference, making them suitable for different use cases.",sl,j,al,w,vl="Ollama is a modern tool that makes it easy to get up and running with large language models locally. It provides a simple interface for running, managing, and customizing various open-source models.",nl,U,il,T,pl,$,ml,b,ol,I,rl,C,Ml,B,cl,G,ul,E,dl,A,Vl="LMStudio is a desktop application that provides a user-friendly interface for running and fine-tuning language models locally. It’s particularly useful for those who prefer a GUI over command-line tools.",gl,W,hl,x,Yl="<li><p><strong>Model Management</strong></p> <ul><li>Download and manage models</li> <li>Convert between formats</li> <li>Model fine-tuning interface</li></ul></li> <li><p><strong>Inference Interface</strong></p> <ul><li>Chat interface</li> <li>Parameter adjustment</li> <li>Response streaming</li></ul></li> <li><p><strong>Performance Tools</strong></p> <ul><li>Memory usage monitoring</li> <li>Speed benchmarking</li> <li>GPU utilization tracking</li></ul></li>",yl,S,Jl,Z,fl,R,jl,Q,Ll="llama.cpp is a powerful C++ implementation for running LLMs efficiently on consumer hardware. It’s particularly known for its optimization and quantization capabilities.",wl,k,Ul,v,Tl,V,$l,Y,bl,L,Il,z,Cl,N,Bl,X,zl="Here’s a comparison of key features across the three tools:",Gl,F,Nl="<thead><tr><th>Feature</th> <th>Ollama</th> <th>LMStudio</th> <th>llama.cpp</th></tr></thead> <tbody><tr><td>Ease of Use</td> <td>Very Easy</td> <td>Very Easy</td> <td>Advanced</td></tr> <tr><td>UI Interface</td> <td>CLI</td> <td>GUI</td> <td>CLI</td></tr> <tr><td>Performance</td> <td>Good</td> <td>Good</td> <td>Excellent</td></tr> <tr><td>Customization</td> <td>Good</td> <td>Limited</td> <td>Extensive</td></tr> <tr><td>Memory Usage</td> <td>Moderate</td> <td>Moderate</td> <td>Very Low</td></tr> <tr><td>API Compatibility</td> <td>REST API</td> <td>OpenAI API</td> <td>C++/Python</td></tr></tbody>",El,q,Al,H,Xl="<li><p><strong>Model Selection</strong></p> <ul><li>Choose appropriate model sizes</li> <li>Consider hardware constraints</li> <li>Balance quality and speed</li></ul></li> <li><p><strong>Resource Management</strong></p> <ul><li>Monitor memory usage</li> <li>Manage GPU resources</li> <li>Handle concurrent requests</li></ul></li> <li><p><strong>Integration Patterns</strong></p> <ul><li>Use appropriate APIs</li> <li>Implement error handling</li> <li>Manage connection pooling</li></ul></li>",Wl,_,xl,P,Fl='<li><a href="https://ollama.ai/docs" rel="nofollow">Ollama Documentation</a></li> <li><a href="https://lmstudio.ai" rel="nofollow">LMStudio Website</a></li> <li><a href="https://github.com/ggerganov/llama.cpp" rel="nofollow">llama.cpp GitHub</a></li> <li><a href="https://huggingface.co/models" rel="nofollow">Hugging Face Model Hub</a></li> <li><a href="https://huggingface.co/docs/transformers/installation" rel="nofollow">Local LLM Deployment Guide</a></li>',Sl,O,Zl,K,Rl;return J=new c({props:{title:"Local Inference Tools: Ollama, LMStudio, and llama.cpp",local:"local-inference-tools-ollama-lmstudio-and-llamacpp",headingTag:"h1"}}),j=new c({props:{title:"Ollama",local:"ollama",headingTag:"h2"}}),U=new c({props:{title:"Installing Ollama",local:"installing-ollama",headingTag:"h3"}}),T=new y({props:{code:"JTIzJTIwbWFjT1MlMjBvciUyMExpbnV4JTBBY3VybCUyMGh0dHBzJTNBJTJGJTJGb2xsYW1hLmFpJTJGaW5zdGFsbC5zaCUyMCU3QyUyMHNoJTBBJTBBJTIzJTIwV2luZG93cyUwQSUyMyUyMERvd25sb2FkJTIwZnJvbSUyMGh0dHBzJTNBJTJGJTJGb2xsYW1hLmFpJTJGZG93bmxvYWQ=",highlighted:`<span class="hljs-comment"># macOS or Linux</span>
curl https://ollama.ai/install.sh | sh

<span class="hljs-comment"># Windows</span>
<span class="hljs-comment"># Download from https://ollama.ai/download</span>`,wrap:!1}}),$=new c({props:{title:"Basic Usage",local:"basic-usage",headingTag:"h3"}}),b=new y({props:{code:"JTIzJTIwUHVsbCUyMGFuZCUyMHJ1biUyMGElMjBtb2RlbCUwQW9sbGFtYSUyMHJ1biUyMGxsYW1hMiUwQSUwQSUyMyUyMFJ1biUyMHdpdGglMjBzcGVjaWZpYyUyMHBhcmFtZXRlcnMlMEFvbGxhbWElMjBydW4lMjBsbGFtYTIlMjAlMjJXaGF0JTIwaXMlMjBtYWNoaW5lJTIwbGVhcm5pbmclM0YlMjIlMjAlNUMlMEElMjAlMjAtLXRlbXBlcmF0dXJlJTIwMC43JTIwJTVDJTBBJTIwJTIwLS10b3AtcCUyMDAuOQ==",highlighted:`<span class="hljs-comment"># Pull and run a model</span>
ollama run llama2

<span class="hljs-comment"># Run with specific parameters</span>
ollama run llama2 <span class="hljs-string">&quot;What is machine learning?&quot;</span> \\
  --temperature 0.7 \\
  --top-p 0.9`,wrap:!1}}),I=new c({props:{title:"Python Integration",local:"python-integration",headingTag:"h3"}}),C=new y({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEElMEFkZWYlMjBnZW5lcmF0ZV90ZXh0KHByb21wdCklM0ElMEElMjAlMjAlMjAlMjByZXNwb25zZSUyMCUzRCUyMHJlcXVlc3RzLnBvc3QoJ2h0dHAlM0ElMkYlMkZsb2NhbGhvc3QlM0ExMTQzNCUyRmFwaSUyRmdlbmVyYXRlJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGpzb24lM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAnbW9kZWwnJTNBJTIwJ2xsYW1hMiclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAncHJvbXB0JyUzQSUyMHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCdzdHJlYW0nJTNBJTIwRmFsc2UlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwcmVzcG9uc2UuanNvbigpJTVCJ3Jlc3BvbnNlJyU1RCUwQSUwQSUyMyUyMEV4YW1wbGUlMjB1c2FnZSUwQXJlc3BvbnNlJTIwJTNEJTIwZ2VuZXJhdGVfdGV4dCglMjJFeHBsYWluJTIwcXVhbnR1bSUyMGNvbXB1dGluZyUyMiklMEFwcmludChyZXNwb25zZSk=",highlighted:`<span class="hljs-keyword">import</span> requests

<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_text</span>(<span class="hljs-params">prompt</span>):
    response = requests.post(<span class="hljs-string">&#x27;http://localhost:11434/api/generate&#x27;</span>,
        json={
            <span class="hljs-string">&#x27;model&#x27;</span>: <span class="hljs-string">&#x27;llama2&#x27;</span>,
            <span class="hljs-string">&#x27;prompt&#x27;</span>: prompt,
            <span class="hljs-string">&#x27;stream&#x27;</span>: <span class="hljs-literal">False</span>
        }
    )
    <span class="hljs-keyword">return</span> response.json()[<span class="hljs-string">&#x27;response&#x27;</span>]

<span class="hljs-comment"># Example usage</span>
response = generate_text(<span class="hljs-string">&quot;Explain quantum computing&quot;</span>)
<span class="hljs-built_in">print</span>(response)`,wrap:!1}}),B=new c({props:{title:"Custom Model Definition",local:"custom-model-definition",headingTag:"h3"}}),G=new y({props:{code:"JTIzJTIwbW9kZWxmaWxlJTBBRlJPTSUyMGxsYW1hMiUwQVBBUkFNRVRFUiUyMHRlbXBlcmF0dXJlJTIwMC43JTBBUEFSQU1FVEVSJTIwdG9wX3AlMjAwLjklMEFTWVNURU0lMjBZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMEFJJTIwYXNzaXN0YW50LiUwQSUwQSUyMyUyMEJ1aWxkJTIwdGhlJTIwbW9kZWwlMEFvbGxhbWElMjBjcmVhdGUlMjBjdXN0b20tYXNzaXN0YW50JTIwLWYlMjBtb2RlbGZpbGU=",highlighted:`<span class="hljs-comment"># modelfile</span>
<span class="hljs-string">FROM</span> <span class="hljs-string">llama2</span>
<span class="hljs-string">PARAMETER</span> <span class="hljs-string">temperature</span> <span class="hljs-number">0.7</span>
<span class="hljs-string">PARAMETER</span> <span class="hljs-string">top_p</span> <span class="hljs-number">0.9</span>
<span class="hljs-string">SYSTEM</span> <span class="hljs-string">You</span> <span class="hljs-string">are</span> <span class="hljs-string">a</span> <span class="hljs-string">helpful</span> <span class="hljs-string">AI</span> <span class="hljs-string">assistant.</span>

<span class="hljs-comment"># Build the model</span>
<span class="hljs-string">ollama</span> <span class="hljs-string">create</span> <span class="hljs-string">custom-assistant</span> <span class="hljs-string">-f</span> <span class="hljs-string">modelfile</span>`,wrap:!1}}),E=new c({props:{title:"LMStudio",local:"lmstudio",headingTag:"h2"}}),W=new c({props:{title:"Key Features",local:"key-features",headingTag:"h3"}}),S=new c({props:{title:"API Integration",local:"api-integration",headingTag:"h3"}}),Z=new y({props:{code:"ZnJvbSUyMG9wZW5haSUyMGltcG9ydCUyME9wZW5BSSUwQSUwQSUyMyUyMENvbm5lY3QlMjB0byUyMExNU3R1ZGlvJ3MlMjBPcGVuQUktY29tcGF0aWJsZSUyMEFQSSUwQWNsaWVudCUyMCUzRCUyME9wZW5BSSglMEElMjAlMjAlMjAlMjBiYXNlX3VybCUzRCUyMmh0dHAlM0ElMkYlMkZsb2NhbGhvc3QlM0ExMjM0JTJGdjElMjIlMkMlMEElMjAlMjAlMjAlMjBhcGlfa2V5JTNEJTIybm90LW5lZWRlZCUyMiUwQSklMEElMEElMjMlMjBHZW5lcmF0ZSUyMHRleHQlMEFjb21wbGV0aW9uJTIwJTNEJTIwY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIybG9jYWwtbW9kZWwlMjIlMkMlMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBhc3Npc3RhbnQuJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwZGVlcCUyMGxlYXJuaW5nJTNGJTIyJTdEJTBBJTIwJTIwJTIwJTIwJTVEJTBBKSUwQXByaW50KGNvbXBsZXRpb24uY2hvaWNlcyU1QjAlNUQubWVzc2FnZS5jb250ZW50KQ==",highlighted:`<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

<span class="hljs-comment"># Connect to LMStudio&#x27;s OpenAI-compatible API</span>
client = OpenAI(
    base_url=<span class="hljs-string">&quot;http://localhost:1234/v1&quot;</span>,
    api_key=<span class="hljs-string">&quot;not-needed&quot;</span>
)

<span class="hljs-comment"># Generate text</span>
completion = client.chat.completions.create(
    model=<span class="hljs-string">&quot;local-model&quot;</span>,
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span>},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is deep learning?&quot;</span>}
    ]
)
<span class="hljs-built_in">print</span>(completion.choices[<span class="hljs-number">0</span>].message.content)`,wrap:!1}}),R=new c({props:{title:"llama.cpp",local:"llamacpp",headingTag:"h2"}}),k=new c({props:{title:"Building from Source",local:"building-from-source",headingTag:"h3"}}),v=new y({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZnZ2VyZ2Fub3YlMkZsbGFtYS5jcHAlMEFjZCUyMGxsYW1hLmNwcCUwQW1ha2U=",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/ggerganov/llama.cpp
<span class="hljs-built_in">cd</span> llama.cpp
make`,wrap:!1}}),V=new c({props:{title:"Model Quantization",local:"model-quantization",headingTag:"h3"}}),Y=new y({props:{code:"JTIzJTIwUXVhbnRpemUlMjBhJTIwbW9kZWwlMjB0byUyMDQtYml0JTBBLiUyRnF1YW50aXplJTIwLiUyRm1vZGVscyUyRjdCJTJGZ2dtbC1tb2RlbC1mMTYuYmluJTIwJTVDJTBBJTIwJTIwJTIwJTIwLiUyRm1vZGVscyUyRjdCJTJGZ2dtbC1tb2RlbC1xNF8wLmJpbiUyMHE0XzAlMEElMEElMjMlMjBSdW4lMjBpbmZlcmVuY2UlMEEuJTJGbWFpbiUyMC1tJTIwLiUyRm1vZGVscyUyRjdCJTJGZ2dtbC1tb2RlbC1xNF8wLmJpbiUyMCU1QyUwQSUyMCUyMCUyMCUyMC1uJTIwMTI4JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS10ZW1wJTIwMC43JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1yZXBlYXRfcGVuYWx0eSUyMDEuMSUyMCU1QyUwQSUyMCUyMCUyMCUyMC1wJTIwJTIyV2hhdCUyMGlzJTIwYXJ0aWZpY2lhbCUyMGludGVsbGlnZW5jZSUzRiUyMg==",highlighted:`<span class="hljs-comment"># Quantize a model to 4-bit</span>
./quantize ./models/7B/ggml-model-f16.bin \\
    ./models/7B/ggml-model-q4_0.bin q4_0

<span class="hljs-comment"># Run inference</span>
./main -m ./models/7B/ggml-model-q4_0.bin \\
    -n 128 \\
    --temp 0.7 \\
    --repeat_penalty 1.1 \\
    -p <span class="hljs-string">&quot;What is artificial intelligence?&quot;</span>`,wrap:!1}}),L=new c({props:{title:"Python Bindings",local:"python-bindings",headingTag:"h3"}}),z=new y({props:{code:"ZnJvbSUyMGxsYW1hX2NwcCUyMGltcG9ydCUyMExsYW1hJTBBJTBBJTIzJTIwSW5pdGlhbGl6ZSUyMHRoZSUyMG1vZGVsJTBBbGxtJTIwJTNEJTIwTGxhbWEoJTBBJTIwJTIwJTIwJTIwbW9kZWxfcGF0aCUzRCUyMi4lMkZtb2RlbHMlMkY3QiUyRmdnbWwtbW9kZWwtcTRfMC5iaW4lMjIlMkMlMEElMjAlMjAlMjAlMjBuX2N0eCUzRDIwNDglMkMlMEElMjAlMjAlMjAlMjBuX3RocmVhZHMlM0Q0JTBBKSUwQSUwQSUyMyUyMEdlbmVyYXRlJTIwdGV4dCUwQW91dHB1dCUyMCUzRCUyMGxsbSglMEElMjAlMjAlMjAlMjAlMjJFeHBsYWluJTIwaG93JTIwbmV1cmFsJTIwbmV0d29ya3MlMjB3b3JrJTIyJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3Rva2VucyUzRDEwMCUyQyUwQSUyMCUyMCUyMCUyMHRlbXBlcmF0dXJlJTNEMC43JTJDJTBBJTIwJTIwJTIwJTIwdG9wX3AlM0QwLjk1JTBBKSUwQXByaW50KG91dHB1dCU1QidjaG9pY2VzJyU1RCU1QjAlNUQlNUIndGV4dCclNUQp",highlighted:`<span class="hljs-keyword">from</span> llama_cpp <span class="hljs-keyword">import</span> Llama

<span class="hljs-comment"># Initialize the model</span>
llm = Llama(
    model_path=<span class="hljs-string">&quot;./models/7B/ggml-model-q4_0.bin&quot;</span>,
    n_ctx=<span class="hljs-number">2048</span>,
    n_threads=<span class="hljs-number">4</span>
)

<span class="hljs-comment"># Generate text</span>
output = llm(
    <span class="hljs-string">&quot;Explain how neural networks work&quot;</span>,
    max_tokens=<span class="hljs-number">100</span>,
    temperature=<span class="hljs-number">0.7</span>,
    top_p=<span class="hljs-number">0.95</span>
)
<span class="hljs-built_in">print</span>(output[<span class="hljs-string">&#x27;choices&#x27;</span>][<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;text&#x27;</span>])`,wrap:!1}}),N=new c({props:{title:"Comparing the Tools",local:"comparing-the-tools",headingTag:"h2"}}),q=new c({props:{title:"Best Practices",local:"best-practices",headingTag:"h2"}}),_=new c({props:{title:"Resources",local:"resources",headingTag:"h2"}}),O=new et({props:{source:"https://github.com/huggingface/course/blob/main/chapters/en/chapter12/7.mdx"}}),{c(){g=u("meta"),ll=a(),D=u("p"),tl=a(),i(J.$$.fragment),el=a(),f=u("p"),f.textContent=kl,sl=a(),i(j.$$.fragment),al=a(),w=u("p"),w.textContent=vl,nl=a(),i(U.$$.fragment),il=a(),i(T.$$.fragment),pl=a(),i($.$$.fragment),ml=a(),i(b.$$.fragment),ol=a(),i(I.$$.fragment),rl=a(),i(C.$$.fragment),Ml=a(),i(B.$$.fragment),cl=a(),i(G.$$.fragment),ul=a(),i(E.$$.fragment),dl=a(),A=u("p"),A.textContent=Vl,gl=a(),i(W.$$.fragment),hl=a(),x=u("ol"),x.innerHTML=Yl,yl=a(),i(S.$$.fragment),Jl=a(),i(Z.$$.fragment),fl=a(),i(R.$$.fragment),jl=a(),Q=u("p"),Q.textContent=Ll,wl=a(),i(k.$$.fragment),Ul=a(),i(v.$$.fragment),Tl=a(),i(V.$$.fragment),$l=a(),i(Y.$$.fragment),bl=a(),i(L.$$.fragment),Il=a(),i(z.$$.fragment),Cl=a(),i(N.$$.fragment),Bl=a(),X=u("p"),X.textContent=zl,Gl=a(),F=u("table"),F.innerHTML=Nl,El=a(),i(q.$$.fragment),Al=a(),H=u("ol"),H.innerHTML=Xl,Wl=a(),i(_.$$.fragment),xl=a(),P=u("ul"),P.innerHTML=Fl,Sl=a(),i(O.$$.fragment),Zl=a(),K=u("p"),this.h()},l(l){const t=lt("svelte-u9bgzb",document.head);g=d(t,"META",{name:!0,content:!0}),t.forEach(e),ll=n(l),D=d(l,"P",{}),ql(D).forEach(e),tl=n(l),p(J.$$.fragment,l),el=n(l),f=d(l,"P",{"data-svelte-h":!0}),h(f)!=="svelte-19n63ts"&&(f.textContent=kl),sl=n(l),p(j.$$.fragment,l),al=n(l),w=d(l,"P",{"data-svelte-h":!0}),h(w)!=="svelte-11035zz"&&(w.textContent=vl),nl=n(l),p(U.$$.fragment,l),il=n(l),p(T.$$.fragment,l),pl=n(l),p($.$$.fragment,l),ml=n(l),p(b.$$.fragment,l),ol=n(l),p(I.$$.fragment,l),rl=n(l),p(C.$$.fragment,l),Ml=n(l),p(B.$$.fragment,l),cl=n(l),p(G.$$.fragment,l),ul=n(l),p(E.$$.fragment,l),dl=n(l),A=d(l,"P",{"data-svelte-h":!0}),h(A)!=="svelte-1f20apv"&&(A.textContent=Vl),gl=n(l),p(W.$$.fragment,l),hl=n(l),x=d(l,"OL",{"data-svelte-h":!0}),h(x)!=="svelte-f5xcnm"&&(x.innerHTML=Yl),yl=n(l),p(S.$$.fragment,l),Jl=n(l),p(Z.$$.fragment,l),fl=n(l),p(R.$$.fragment,l),jl=n(l),Q=d(l,"P",{"data-svelte-h":!0}),h(Q)!=="svelte-1hgd56f"&&(Q.textContent=Ll),wl=n(l),p(k.$$.fragment,l),Ul=n(l),p(v.$$.fragment,l),Tl=n(l),p(V.$$.fragment,l),$l=n(l),p(Y.$$.fragment,l),bl=n(l),p(L.$$.fragment,l),Il=n(l),p(z.$$.fragment,l),Cl=n(l),p(N.$$.fragment,l),Bl=n(l),X=d(l,"P",{"data-svelte-h":!0}),h(X)!=="svelte-1xspie2"&&(X.textContent=zl),Gl=n(l),F=d(l,"TABLE",{"data-svelte-h":!0}),h(F)!=="svelte-1p4qvm9"&&(F.innerHTML=Nl),El=n(l),p(q.$$.fragment,l),Al=n(l),H=d(l,"OL",{"data-svelte-h":!0}),h(H)!=="svelte-1kvgd9a"&&(H.innerHTML=Xl),Wl=n(l),p(_.$$.fragment,l),xl=n(l),P=d(l,"UL",{"data-svelte-h":!0}),h(P)!=="svelte-1kngho3"&&(P.innerHTML=Fl),Sl=n(l),p(O.$$.fragment,l),Zl=n(l),K=d(l,"P",{}),ql(K).forEach(e),this.h()},h(){Hl(g,"name","hf:doc:metadata"),Hl(g,"content",at)},m(l,t){tt(document.head,g),s(l,ll,t),s(l,D,t),s(l,tl,t),m(J,l,t),s(l,el,t),s(l,f,t),s(l,sl,t),m(j,l,t),s(l,al,t),s(l,w,t),s(l,nl,t),m(U,l,t),s(l,il,t),m(T,l,t),s(l,pl,t),m($,l,t),s(l,ml,t),m(b,l,t),s(l,ol,t),m(I,l,t),s(l,rl,t),m(C,l,t),s(l,Ml,t),m(B,l,t),s(l,cl,t),m(G,l,t),s(l,ul,t),m(E,l,t),s(l,dl,t),s(l,A,t),s(l,gl,t),m(W,l,t),s(l,hl,t),s(l,x,t),s(l,yl,t),m(S,l,t),s(l,Jl,t),m(Z,l,t),s(l,fl,t),m(R,l,t),s(l,jl,t),s(l,Q,t),s(l,wl,t),m(k,l,t),s(l,Ul,t),m(v,l,t),s(l,Tl,t),m(V,l,t),s(l,$l,t),m(Y,l,t),s(l,bl,t),m(L,l,t),s(l,Il,t),m(z,l,t),s(l,Cl,t),m(N,l,t),s(l,Bl,t),s(l,X,t),s(l,Gl,t),s(l,F,t),s(l,El,t),m(q,l,t),s(l,Al,t),s(l,H,t),s(l,Wl,t),m(_,l,t),s(l,xl,t),s(l,P,t),s(l,Sl,t),m(O,l,t),s(l,Zl,t),s(l,K,t),Rl=!0},p:Pl,i(l){Rl||(o(J.$$.fragment,l),o(j.$$.fragment,l),o(U.$$.fragment,l),o(T.$$.fragment,l),o($.$$.fragment,l),o(b.$$.fragment,l),o(I.$$.fragment,l),o(C.$$.fragment,l),o(B.$$.fragment,l),o(G.$$.fragment,l),o(E.$$.fragment,l),o(W.$$.fragment,l),o(S.$$.fragment,l),o(Z.$$.fragment,l),o(R.$$.fragment,l),o(k.$$.fragment,l),o(v.$$.fragment,l),o(V.$$.fragment,l),o(Y.$$.fragment,l),o(L.$$.fragment,l),o(z.$$.fragment,l),o(N.$$.fragment,l),o(q.$$.fragment,l),o(_.$$.fragment,l),o(O.$$.fragment,l),Rl=!0)},o(l){r(J.$$.fragment,l),r(j.$$.fragment,l),r(U.$$.fragment,l),r(T.$$.fragment,l),r($.$$.fragment,l),r(b.$$.fragment,l),r(I.$$.fragment,l),r(C.$$.fragment,l),r(B.$$.fragment,l),r(G.$$.fragment,l),r(E.$$.fragment,l),r(W.$$.fragment,l),r(S.$$.fragment,l),r(Z.$$.fragment,l),r(R.$$.fragment,l),r(k.$$.fragment,l),r(v.$$.fragment,l),r(V.$$.fragment,l),r(Y.$$.fragment,l),r(L.$$.fragment,l),r(z.$$.fragment,l),r(N.$$.fragment,l),r(q.$$.fragment,l),r(_.$$.fragment,l),r(O.$$.fragment,l),Rl=!1},d(l){l&&(e(ll),e(D),e(tl),e(el),e(f),e(sl),e(al),e(w),e(nl),e(il),e(pl),e(ml),e(ol),e(rl),e(Ml),e(cl),e(ul),e(dl),e(A),e(gl),e(hl),e(x),e(yl),e(Jl),e(fl),e(jl),e(Q),e(wl),e(Ul),e(Tl),e($l),e(bl),e(Il),e(Cl),e(Bl),e(X),e(Gl),e(F),e(El),e(Al),e(H),e(Wl),e(xl),e(P),e(Sl),e(Zl),e(K)),e(g),M(J,l),M(j,l),M(U,l),M(T,l),M($,l),M(b,l),M(I,l),M(C,l),M(B,l),M(G,l),M(E,l),M(W,l),M(S,l),M(Z,l),M(R,l),M(k,l),M(v,l),M(V,l),M(Y,l),M(L,l),M(z,l),M(N,l),M(q,l),M(_,l),M(O,l)}}}const at='{"title":"Local Inference Tools: Ollama, LMStudio, and llama.cpp","local":"local-inference-tools-ollama-lmstudio-and-llamacpp","sections":[{"title":"Ollama","local":"ollama","sections":[{"title":"Installing Ollama","local":"installing-ollama","sections":[],"depth":3},{"title":"Basic Usage","local":"basic-usage","sections":[],"depth":3},{"title":"Python Integration","local":"python-integration","sections":[],"depth":3},{"title":"Custom Model Definition","local":"custom-model-definition","sections":[],"depth":3}],"depth":2},{"title":"LMStudio","local":"lmstudio","sections":[{"title":"Key Features","local":"key-features","sections":[],"depth":3},{"title":"API Integration","local":"api-integration","sections":[],"depth":3}],"depth":2},{"title":"llama.cpp","local":"llamacpp","sections":[{"title":"Building from Source","local":"building-from-source","sections":[],"depth":3},{"title":"Model Quantization","local":"model-quantization","sections":[],"depth":3},{"title":"Python Bindings","local":"python-bindings","sections":[],"depth":3}],"depth":2},{"title":"Comparing the Tools","local":"comparing-the-tools","sections":[],"depth":2},{"title":"Best Practices","local":"best-practices","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function nt(Ql){return Ol(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Mt extends Dl{constructor(g){super(),Kl(this,g,nt,st,_l,{})}}export{Mt as component};
