import{s as Ke,n as Oe,o as es}from"../chunks/scheduler.37c15a92.js";import{S as ss,i as ts,g as i,s as n,r as M,A as ls,h as p,f as t,c as a,j as Le,u as r,x as o,k as De,y as ns,a as l,v as y,d as J,t as c,w as m}from"../chunks/index.2bf4358c.js";import{C as D}from"../chunks/CodeBlock.4f5fc1ad.js";import{H as T}from"../chunks/Heading.8ada512a.js";import{E as as}from"../chunks/EditOnGithub.9958bcdc.js";function is(xe){let U,K,Y,O,w,ee,u,Qe="The <code>pipeline</code> abstraction in 🤗 Transformers provides a simple way to run inference with any model from the Hugging Face Hub. It handles all the preprocessing and postprocessing steps, making it easy to use models without deep knowledge of their architecture or requirements.",se,h,te,I,He="Hugging Face pipelines streamline the machine learning workflow by automating three critical stages between raw input and human-readable output:",le,j,Ee=`<strong>Preprocessing Stage</strong>
The pipeline first prepares your raw inputs for the model. This varies by input type:`,ne,C,We="<li>Text inputs undergo tokenization to convert words into model-friendly token IDs</li> <li>Images are resized and normalized to match model requirements</li> <li>Audio is processed through feature extraction to create spectrograms or other representations</li>",ae,d,ke=`<strong>Model Inference</strong>
During the forward pass, the pipeline:`,ie,g,Xe="<li>Handles batching of inputs automatically for efficient processing</li> <li>Places computation on the optimal device (CPU/GPU)</li> <li>Applies performance optimizations like half-precision (FP16) inference where supported</li>",pe,f,_e=`<strong>Postprocessing Stage</strong>
Finally, the pipeline converts raw model outputs into useful results:`,Me,b,Ae="<li>Decodes token IDs back into readable text</li> <li>Transforms logits into probability scores</li> <li>Formats outputs according to the specific task (e.g., classification labels, generated text)</li>",re,B,Re="This abstraction lets you focus on your application logic while the pipeline handles the technical complexity of model inference.",oe,$,ye,Z,Ne="Here’s how to use a pipeline for text generation:",Je,G,ce,V,me,v,Te,x,Ue,Q,we,H,ue,E,he,W,Se="Pipelines can efficiently handle multiple inputs through batching:",Ie,k,je,X,Ce,_,ze="Here’s how to integrate a pipeline into a FastAPI application:",de,A,ge,R,fe,N,qe="While pipelines are great for prototyping and small-scale deployments, they have some limitations:",be,S,Fe="<li>Limited optimization options compared to dedicated serving solutions</li> <li>No built-in support for advanced features like dynamic batching</li> <li>May not be suitable for high-throughput production workloads</li>",Be,z,Pe="For production deployments with high throughput requirements, consider using Text Generation Inference (TGI) or other specialized serving solutions.",$e,q,Ze,F,Ye='<li><a href="https://huggingface.co/docs/transformers/en/pipeline_tutorial" rel="nofollow">Hugging Face Pipeline Tutorial</a></li> <li><a href="https://huggingface.co/docs/transformers/en/main_classes/pipelines" rel="nofollow">Pipeline API Reference</a></li> <li><a href="https://huggingface.co/docs/transformers/en/main_classes/text_generation" rel="nofollow">Text Generation Parameters</a></li> <li><a href="https://huggingface.co/docs/transformers/en/perf_infer_gpu_one" rel="nofollow">Model Quantization Guide</a></li>',Ge,P,Ve,L,ve;return w=new T({props:{title:"Basic Pipeline Inference",local:"basic-pipeline-inference",headingTag:"h1"}}),h=new T({props:{title:"How Pipelines Work",local:"how-pipelines-work",headingTag:"h2"}}),$=new T({props:{title:"Basic Usage",local:"basic-usage",headingTag:"h2"}}),G=new D({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBJTIzJTIwQ3JlYXRlJTIwYSUyMHBpcGVsaW5lJTIwd2l0aCUyMGElMjBzcGVjaWZpYyUyMG1vZGVsJTBBZ2VuZXJhdG9yJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIydGV4dC1nZW5lcmF0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJIdWdnaW5nRmFjZVRCJTJGU21vbExNMi0xLjdCLUluc3RydWN0JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0QlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMEEpJTBBJTBBJTIzJTIwR2VuZXJhdGUlMjB0ZXh0JTBBcmVzcG9uc2UlMjAlM0QlMjBnZW5lcmF0b3IoJTBBJTIwJTIwJTIwJTIwJTIyV3JpdGUlMjBhJTIwc2hvcnQlMjBwb2VtJTIwYWJvdXQlMjBjb2RpbmclM0ElMjIlMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDEwMCUyQyUwQSUyMCUyMCUyMCUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDAuNyUwQSklMEFwcmludChyZXNwb25zZSU1QjAlNUQlNUInZ2VuZXJhdGVkX3RleHQnJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-comment"># Create a pipeline with a specific model</span>
generator = pipeline(
    <span class="hljs-string">&quot;text-generation&quot;</span>,
    model=<span class="hljs-string">&quot;HuggingFaceTB/SmolLM2-1.7B-Instruct&quot;</span>,
    torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>
)

<span class="hljs-comment"># Generate text</span>
response = generator(
    <span class="hljs-string">&quot;Write a short poem about coding:&quot;</span>,
    max_new_tokens=<span class="hljs-number">100</span>,
    do_sample=<span class="hljs-literal">True</span>,
    temperature=<span class="hljs-number">0.7</span>
)
<span class="hljs-built_in">print</span>(response[<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;generated_text&#x27;</span>])`,wrap:!1}}),V=new T({props:{title:"Key Configuration Options",local:"key-configuration-options",headingTag:"h2"}}),v=new T({props:{title:"Model Loading",local:"model-loading",headingTag:"h3"}}),x=new D({props:{code:"JTIzJTIwQ1BVJTIwaW5mZXJlbmNlJTBBZ2VuZXJhdG9yJTIwJTNEJTIwcGlwZWxpbmUoJTIydGV4dC1nZW5lcmF0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJIdWdnaW5nRmFjZVRCJTJGU21vbExNMi0xLjdCLUluc3RydWN0JTIyJTJDJTIwZGV2aWNlJTNEJTIyY3B1JTIyKSUwQSUwQSUyMyUyMEdQVSUyMGluZmVyZW5jZSUyMChkZXZpY2UlMjAwKSUwQWdlbmVyYXRvciUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQtZ2VuZXJhdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIySHVnZ2luZ0ZhY2VUQiUyRlNtb2xMTTItMS43Qi1JbnN0cnVjdCUyMiUyQyUyMGRldmljZSUzRDApJTBBJTBBJTIzJTIwQXV0b21hdGljJTIwZGV2aWNlJTIwcGxhY2VtZW50JTBBZ2VuZXJhdG9yJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIydGV4dC1nZW5lcmF0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJIdWdnaW5nRmFjZVRCJTJGU21vbExNMi0xLjdCLUluc3RydWN0JTIyJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRCUyMmF1dG8lMjIlMEEp",highlighted:`<span class="hljs-comment"># CPU inference</span>
generator = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, model=<span class="hljs-string">&quot;HuggingFaceTB/SmolLM2-1.7B-Instruct&quot;</span>, device=<span class="hljs-string">&quot;cpu&quot;</span>)

<span class="hljs-comment"># GPU inference (device 0)</span>
generator = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, model=<span class="hljs-string">&quot;HuggingFaceTB/SmolLM2-1.7B-Instruct&quot;</span>, device=<span class="hljs-number">0</span>)

<span class="hljs-comment"># Automatic device placement</span>
generator = pipeline(
    <span class="hljs-string">&quot;text-generation&quot;</span>,
    model=<span class="hljs-string">&quot;HuggingFaceTB/SmolLM2-1.7B-Instruct&quot;</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>
)`,wrap:!1}}),Q=new T({props:{title:"Generation Parameters",local:"generation-parameters",headingTag:"h3"}}),H=new D({props:{code:"cmVzcG9uc2UlMjAlM0QlMjBnZW5lcmF0b3IoJTBBJTIwJTIwJTIwJTIwJTIyVHJhbnNsYXRlJTIwdGhpcyUyMHRvJTIwRnJlbmNoJTNBJTIyJTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QxMDAlMkMlMjAlMjAlMjAlMjAlMjAlMjMlMjBNYXhpbXVtJTIwbGVuZ3RoJTIwb2YlMjBnZW5lcmF0ZWQlMjB0ZXh0JTBBJTIwJTIwJTIwJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFVzZSUyMHNhbXBsaW5nJTIwaW5zdGVhZCUyMG9mJTIwZ3JlZWR5JTIwZGVjb2RpbmclMEElMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDAuNyUyQyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMENvbnRyb2wlMjByYW5kb21uZXNzJTIwKGhpZ2hlciUyMCUzRCUyMG1vcmUlMjByYW5kb20pJTBBJTIwJTIwJTIwJTIwdG9wX2slM0Q1MCUyQyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMExpbWl0JTIwdG8lMjB0b3AlMjBrJTIwdG9rZW5zJTBBJTIwJTIwJTIwJTIwdG9wX3AlM0QwLjk1JTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwTnVjbGV1cyUyMHNhbXBsaW5nJTIwdGhyZXNob2xkJTBBJTIwJTIwJTIwJTIwbnVtX3JldHVybl9zZXF1ZW5jZXMlM0QxJTIwJTIwJTIzJTIwTnVtYmVyJTIwb2YlMjBkaWZmZXJlbnQlMjBnZW5lcmF0aW9ucyUwQSk=",highlighted:`response = generator(
    <span class="hljs-string">&quot;Translate this to French:&quot;</span>,
    max_new_tokens=<span class="hljs-number">100</span>,     <span class="hljs-comment"># Maximum length of generated text</span>
    do_sample=<span class="hljs-literal">True</span>,         <span class="hljs-comment"># Use sampling instead of greedy decoding</span>
    temperature=<span class="hljs-number">0.7</span>,        <span class="hljs-comment"># Control randomness (higher = more random)</span>
    top_k=<span class="hljs-number">50</span>,               <span class="hljs-comment"># Limit to top k tokens</span>
    top_p=<span class="hljs-number">0.95</span>,             <span class="hljs-comment"># Nucleus sampling threshold</span>
    num_return_sequences=<span class="hljs-number">1</span>  <span class="hljs-comment"># Number of different generations</span>
)`,wrap:!1}}),E=new T({props:{title:"Processing Multiple Inputs",local:"processing-multiple-inputs",headingTag:"h2"}}),k=new D({props:{code:"JTIzJTIwUHJlcGFyZSUyMG11bHRpcGxlJTIwcHJvbXB0cyUwQXByb21wdHMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJXcml0ZSUyMGElMjBoYWlrdSUyMGFib3V0JTIwcHJvZ3JhbW1pbmclM0ElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJFeHBsYWluJTIwd2hhdCUyMGFuJTIwQVBJJTIwaXMlM0ElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJXcml0ZSUyMGElMjBzaG9ydCUyMHN0b3J5JTIwYWJvdXQlMjBhJTIwcm9ib3QlM0ElMjIlMEElNUQlMEElMEElMjMlMjBQcm9jZXNzJTIwYWxsJTIwcHJvbXB0cyUyMGVmZmljaWVudGx5JTBBcmVzcG9uc2VzJTIwJTNEJTIwZ2VuZXJhdG9yKCUwQSUyMCUyMCUyMCUyMHByb21wdHMlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNENCUyQyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyME51bWJlciUyMG9mJTIwcHJvbXB0cyUyMHRvJTIwcHJvY2VzcyUyMHRvZ2V0aGVyJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QxMDAlMkMlMEElMjAlMjAlMjAlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwdGVtcGVyYXR1cmUlM0QwLjclMEEpJTBBJTBBJTIzJTIwUHJpbnQlMjByZXN1bHRzJTBBZm9yJTIwcHJvbXB0JTJDJTIwcmVzcG9uc2UlMjBpbiUyMHppcChwcm9tcHRzJTJDJTIwcmVzcG9uc2VzKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJQcm9tcHQlM0ElMjAlN0Jwcm9tcHQlN0QlMjIpJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMlJlc3BvbnNlJTNBJTIwJTdCcmVzcG9uc2UlNUIwJTVEJTVCJ2dlbmVyYXRlZF90ZXh0JyU1RCU3RCU1Q24lMjIp",highlighted:`<span class="hljs-comment"># Prepare multiple prompts</span>
prompts = [
    <span class="hljs-string">&quot;Write a haiku about programming:&quot;</span>,
    <span class="hljs-string">&quot;Explain what an API is:&quot;</span>,
    <span class="hljs-string">&quot;Write a short story about a robot:&quot;</span>
]

<span class="hljs-comment"># Process all prompts efficiently</span>
responses = generator(
    prompts,
    batch_size=<span class="hljs-number">4</span>,              <span class="hljs-comment"># Number of prompts to process together</span>
    max_new_tokens=<span class="hljs-number">100</span>,
    do_sample=<span class="hljs-literal">True</span>,
    temperature=<span class="hljs-number">0.7</span>
)

<span class="hljs-comment"># Print results</span>
<span class="hljs-keyword">for</span> prompt, response <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(prompts, responses):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Prompt: <span class="hljs-subst">{prompt}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Response: <span class="hljs-subst">{response[<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;generated_text&#x27;</span>]}</span>\\n&quot;</span>)`,wrap:!1}}),X=new T({props:{title:"Web Server Integration",local:"web-server-integration",headingTag:"h2"}}),A=new D({props:{code:"ZnJvbSUyMGZhc3RhcGklMjBpbXBvcnQlMjBGYXN0QVBJJTJDJTIwSFRUUEV4Y2VwdGlvbiUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBwaXBlbGluZSUwQWltcG9ydCUyMHV2aWNvcm4lMEElMEFhcHAlMjAlM0QlMjBGYXN0QVBJKCklMEElMEElMjMlMjBJbml0aWFsaXplJTIwcGlwZWxpbmUlMjBnbG9iYWxseSUwQWdlbmVyYXRvciUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMnRleHQtZ2VuZXJhdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIySHVnZ2luZ0ZhY2VUQiUyRlNtb2xMTTItMS43Qi1JbnN0cnVjdCUyMiUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTBBKSUwQSUwQSU0MGFwcC5wb3N0KCUyMiUyRmdlbmVyYXRlJTIyKSUwQWFzeW5jJTIwZGVmJTIwZ2VuZXJhdGVfdGV4dChwcm9tcHQlM0ElMjBzdHIpJTNBJTBBJTIwJTIwJTIwJTIwdHJ5JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBub3QlMjBwcm9tcHQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByYWlzZSUyMEhUVFBFeGNlcHRpb24oc3RhdHVzX2NvZGUlM0Q0MDAlMkMlMjBkZXRhaWwlM0QlMjJObyUyMHByb21wdCUyMHByb3ZpZGVkJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwZ2VuZXJhdG9yKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNEMTAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRlbXBlcmF0dXJlJTNEMC43JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMmdlbmVyYXRlZF90ZXh0JTIyJTNBJTIwcmVzcG9uc2UlNUIwJTVEJTVCJ2dlbmVyYXRlZF90ZXh0JyU1RCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMGV4Y2VwdCUyMEV4Y2VwdGlvbiUyMGFzJTIwZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJhaXNlJTIwSFRUUEV4Y2VwdGlvbihzdGF0dXNfY29kZSUzRDUwMCUyQyUyMGRldGFpbCUzRHN0cihlKSklMEElMEFpZiUyMF9fbmFtZV9fJTIwJTNEJTNEJTIwJTIyX19tYWluX18lMjIlM0ElMEElMjAlMjAlMjAlMjB1dmljb3JuLnJ1bihhcHAlMkMlMjBob3N0JTNEJTIyMC4wLjAuMCUyMiUyQyUyMHBvcnQlM0Q1MDAwKQ==",highlighted:`<span class="hljs-keyword">from</span> fastapi <span class="hljs-keyword">import</span> FastAPI, HTTPException
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> uvicorn

app = FastAPI()

<span class="hljs-comment"># Initialize pipeline globally</span>
generator = pipeline(
    <span class="hljs-string">&quot;text-generation&quot;</span>,
    model=<span class="hljs-string">&quot;HuggingFaceTB/SmolLM2-1.7B-Instruct&quot;</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>
)

<span class="hljs-meta">@app.post(<span class="hljs-params"><span class="hljs-string">&quot;/generate&quot;</span></span>)</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_text</span>(<span class="hljs-params">prompt: <span class="hljs-built_in">str</span></span>):
    <span class="hljs-keyword">try</span>:
        <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> prompt:
            <span class="hljs-keyword">raise</span> HTTPException(status_code=<span class="hljs-number">400</span>, detail=<span class="hljs-string">&quot;No prompt provided&quot;</span>)
            
        response = generator(
            prompt,
            max_new_tokens=<span class="hljs-number">100</span>,
            do_sample=<span class="hljs-literal">True</span>,
            temperature=<span class="hljs-number">0.7</span>
        )
        
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;generated_text&quot;</span>: response[<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;generated_text&#x27;</span>]}
        
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">raise</span> HTTPException(status_code=<span class="hljs-number">500</span>, detail=<span class="hljs-built_in">str</span>(e))

<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    uvicorn.run(app, host=<span class="hljs-string">&quot;0.0.0.0&quot;</span>, port=<span class="hljs-number">5000</span>)`,wrap:!1}}),R=new T({props:{title:"Limitations",local:"limitations",headingTag:"h2"}}),q=new T({props:{title:"Resources",local:"resources",headingTag:"h2"}}),P=new as({props:{source:"https://github.com/huggingface/course/blob/main/chapters/en/chapter12/4.mdx"}}),{c(){U=i("meta"),K=n(),Y=i("p"),O=n(),M(w.$$.fragment),ee=n(),u=i("p"),u.innerHTML=Qe,se=n(),M(h.$$.fragment),te=n(),I=i("p"),I.textContent=He,le=n(),j=i("p"),j.innerHTML=Ee,ne=n(),C=i("ul"),C.innerHTML=We,ae=n(),d=i("p"),d.innerHTML=ke,ie=n(),g=i("ul"),g.innerHTML=Xe,pe=n(),f=i("p"),f.innerHTML=_e,Me=n(),b=i("ul"),b.innerHTML=Ae,re=n(),B=i("p"),B.textContent=Re,oe=n(),M($.$$.fragment),ye=n(),Z=i("p"),Z.textContent=Ne,Je=n(),M(G.$$.fragment),ce=n(),M(V.$$.fragment),me=n(),M(v.$$.fragment),Te=n(),M(x.$$.fragment),Ue=n(),M(Q.$$.fragment),we=n(),M(H.$$.fragment),ue=n(),M(E.$$.fragment),he=n(),W=i("p"),W.textContent=Se,Ie=n(),M(k.$$.fragment),je=n(),M(X.$$.fragment),Ce=n(),_=i("p"),_.textContent=ze,de=n(),M(A.$$.fragment),ge=n(),M(R.$$.fragment),fe=n(),N=i("p"),N.textContent=qe,be=n(),S=i("ul"),S.innerHTML=Fe,Be=n(),z=i("p"),z.textContent=Pe,$e=n(),M(q.$$.fragment),Ze=n(),F=i("ul"),F.innerHTML=Ye,Ge=n(),M(P.$$.fragment),Ve=n(),L=i("p"),this.h()},l(e){const s=ls("svelte-u9bgzb",document.head);U=p(s,"META",{name:!0,content:!0}),s.forEach(t),K=a(e),Y=p(e,"P",{}),Le(Y).forEach(t),O=a(e),r(w.$$.fragment,e),ee=a(e),u=p(e,"P",{"data-svelte-h":!0}),o(u)!=="svelte-rax1ue"&&(u.innerHTML=Qe),se=a(e),r(h.$$.fragment,e),te=a(e),I=p(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1usr11c"&&(I.textContent=He),le=a(e),j=p(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-h6hv6g"&&(j.innerHTML=Ee),ne=a(e),C=p(e,"UL",{"data-svelte-h":!0}),o(C)!=="svelte-1aijdbu"&&(C.innerHTML=We),ae=a(e),d=p(e,"P",{"data-svelte-h":!0}),o(d)!=="svelte-dz2eey"&&(d.innerHTML=ke),ie=a(e),g=p(e,"UL",{"data-svelte-h":!0}),o(g)!=="svelte-1ybt7x2"&&(g.innerHTML=Xe),pe=a(e),f=p(e,"P",{"data-svelte-h":!0}),o(f)!=="svelte-12p1oi5"&&(f.innerHTML=_e),Me=a(e),b=p(e,"UL",{"data-svelte-h":!0}),o(b)!=="svelte-p8o0uz"&&(b.innerHTML=Ae),re=a(e),B=p(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-8vpk5f"&&(B.textContent=Re),oe=a(e),r($.$$.fragment,e),ye=a(e),Z=p(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-9ur79t"&&(Z.textContent=Ne),Je=a(e),r(G.$$.fragment,e),ce=a(e),r(V.$$.fragment,e),me=a(e),r(v.$$.fragment,e),Te=a(e),r(x.$$.fragment,e),Ue=a(e),r(Q.$$.fragment,e),we=a(e),r(H.$$.fragment,e),ue=a(e),r(E.$$.fragment,e),he=a(e),W=p(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-d0u6qp"&&(W.textContent=Se),Ie=a(e),r(k.$$.fragment,e),je=a(e),r(X.$$.fragment,e),Ce=a(e),_=p(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-1vxnvyk"&&(_.textContent=ze),de=a(e),r(A.$$.fragment,e),ge=a(e),r(R.$$.fragment,e),fe=a(e),N=p(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1yey8rx"&&(N.textContent=qe),be=a(e),S=p(e,"UL",{"data-svelte-h":!0}),o(S)!=="svelte-1r3qjxq"&&(S.innerHTML=Fe),Be=a(e),z=p(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-2szgb8"&&(z.textContent=Pe),$e=a(e),r(q.$$.fragment,e),Ze=a(e),F=p(e,"UL",{"data-svelte-h":!0}),o(F)!=="svelte-fwfybo"&&(F.innerHTML=Ye),Ge=a(e),r(P.$$.fragment,e),Ve=a(e),L=p(e,"P",{}),Le(L).forEach(t),this.h()},h(){De(U,"name","hf:doc:metadata"),De(U,"content",ps)},m(e,s){ns(document.head,U),l(e,K,s),l(e,Y,s),l(e,O,s),y(w,e,s),l(e,ee,s),l(e,u,s),l(e,se,s),y(h,e,s),l(e,te,s),l(e,I,s),l(e,le,s),l(e,j,s),l(e,ne,s),l(e,C,s),l(e,ae,s),l(e,d,s),l(e,ie,s),l(e,g,s),l(e,pe,s),l(e,f,s),l(e,Me,s),l(e,b,s),l(e,re,s),l(e,B,s),l(e,oe,s),y($,e,s),l(e,ye,s),l(e,Z,s),l(e,Je,s),y(G,e,s),l(e,ce,s),y(V,e,s),l(e,me,s),y(v,e,s),l(e,Te,s),y(x,e,s),l(e,Ue,s),y(Q,e,s),l(e,we,s),y(H,e,s),l(e,ue,s),y(E,e,s),l(e,he,s),l(e,W,s),l(e,Ie,s),y(k,e,s),l(e,je,s),y(X,e,s),l(e,Ce,s),l(e,_,s),l(e,de,s),y(A,e,s),l(e,ge,s),y(R,e,s),l(e,fe,s),l(e,N,s),l(e,be,s),l(e,S,s),l(e,Be,s),l(e,z,s),l(e,$e,s),y(q,e,s),l(e,Ze,s),l(e,F,s),l(e,Ge,s),y(P,e,s),l(e,Ve,s),l(e,L,s),ve=!0},p:Oe,i(e){ve||(J(w.$$.fragment,e),J(h.$$.fragment,e),J($.$$.fragment,e),J(G.$$.fragment,e),J(V.$$.fragment,e),J(v.$$.fragment,e),J(x.$$.fragment,e),J(Q.$$.fragment,e),J(H.$$.fragment,e),J(E.$$.fragment,e),J(k.$$.fragment,e),J(X.$$.fragment,e),J(A.$$.fragment,e),J(R.$$.fragment,e),J(q.$$.fragment,e),J(P.$$.fragment,e),ve=!0)},o(e){c(w.$$.fragment,e),c(h.$$.fragment,e),c($.$$.fragment,e),c(G.$$.fragment,e),c(V.$$.fragment,e),c(v.$$.fragment,e),c(x.$$.fragment,e),c(Q.$$.fragment,e),c(H.$$.fragment,e),c(E.$$.fragment,e),c(k.$$.fragment,e),c(X.$$.fragment,e),c(A.$$.fragment,e),c(R.$$.fragment,e),c(q.$$.fragment,e),c(P.$$.fragment,e),ve=!1},d(e){e&&(t(K),t(Y),t(O),t(ee),t(u),t(se),t(te),t(I),t(le),t(j),t(ne),t(C),t(ae),t(d),t(ie),t(g),t(pe),t(f),t(Me),t(b),t(re),t(B),t(oe),t(ye),t(Z),t(Je),t(ce),t(me),t(Te),t(Ue),t(we),t(ue),t(he),t(W),t(Ie),t(je),t(Ce),t(_),t(de),t(ge),t(fe),t(N),t(be),t(S),t(Be),t(z),t($e),t(Ze),t(F),t(Ge),t(Ve),t(L)),t(U),m(w,e),m(h,e),m($,e),m(G,e),m(V,e),m(v,e),m(x,e),m(Q,e),m(H,e),m(E,e),m(k,e),m(X,e),m(A,e),m(R,e),m(q,e),m(P,e)}}}const ps='{"title":"Basic Pipeline Inference","local":"basic-pipeline-inference","sections":[{"title":"How Pipelines Work","local":"how-pipelines-work","sections":[],"depth":2},{"title":"Basic Usage","local":"basic-usage","sections":[],"depth":2},{"title":"Key Configuration Options","local":"key-configuration-options","sections":[{"title":"Model Loading","local":"model-loading","sections":[],"depth":3},{"title":"Generation Parameters","local":"generation-parameters","sections":[],"depth":3}],"depth":2},{"title":"Processing Multiple Inputs","local":"processing-multiple-inputs","sections":[],"depth":2},{"title":"Web Server Integration","local":"web-server-integration","sections":[],"depth":2},{"title":"Limitations","local":"limitations","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function Ms(xe){return es(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ms extends ss{constructor(U){super(),ts(this,U,Ms,is,Ke,{})}}export{ms as component};
