import{s as Fl,o as Dl,n as Ll}from"../chunks/scheduler.65852ee5.js";import{S as Pl,i as Ol,g as i,s as n,r,A as Kl,h as o,f as l,c as a,j as Xl,u as M,x as p,k as Sl,l as es,y as ts,a as s,v as J,d as c,t as d,w as T}from"../chunks/index.aa74147d.js";import{T as Yl}from"../chunks/Tip.bb8ccac8.js";import{D as ls,C as m}from"../chunks/DocNotebookDropdown.479f4286.js";import{H as j,E as ss}from"../chunks/EditOnGithub.4eda6a96.js";function ns(Re){let u,h="In-memory can only be used for quick-prototyping and tests. It is a Python implementation of the Qdrant server methods.";return{c(){u=i("p"),u.textContent=h},l(w){u=o(w,"P",{"data-svelte-h":!0}),p(u)!=="svelte-1xbb3g2"&&(u.textContent=h)},m(w,I){s(w,u,I)},p:Ll,d(w){w&&l(u)}}}function as(Re){let u,h="The query API doesn’t support grouping yet. We’ll use the older search API.";return{c(){u=i("p"),u.textContent=h},l(w){u=o(w,"P",{"data-svelte-h":!0}),p(u)!=="svelte-1qxmdba"&&(u.textContent=h)},m(w,I){s(w,u,I)},p:Ll,d(w){w&&l(u)}}}function is(Re){let u,h,w,I,U,qe,g,Ve,C,nl='<em>Authored by: <a href="https://qdrant.tech/" rel="nofollow">Qdrant Team</a></em>',Qe,x,al="In this notebook, we demonstrate how you can use vector embeddings to navigate a codebase, and find relevant code snippets. We’ll search codebases using natural semantic queries, and search for code based on a similar logic.",ze,A,il='You can check out the <a href="https://code-search.qdrant.tech/" rel="nofollow">live deployment</a> of this approach which exposes the Qdrant codebase for search with a web interface.',He,B,Xe,_,ol="We need two models to accomplish our goal.",Se,$,pl='<li><p>General usage neural encoder for Natural Language Processing (NLP), in our case <a href="https://huggingface.co/sentence-transformers/all-MiniLM-L6-v2" rel="nofollow">sentence-transformers/all-MiniLM-L6-v2</a>. We’ll call this NLP model.</p></li> <li><p>Specialized embeddings for code-to-code similarity search. We’ll use the <a href="https://huggingface.co/jinaai/jina-embeddings-v2-base-code" rel="nofollow">jinaai/jina-embeddings-v2-base-code</a> model for the task. It supports English and 30 widely used programming languages with a 8192 sequence length. Let’s call this code model.</p></li>',Ye,v,rl="To prepare our code for the NLP model, we need to preprocess the code to a format that closely resembles natural language. The code model supports a variety of standard programming languages, so there is no need to preprocess the snippets. We can use the code as is.",Le,k,Fe,Z,Ml="Let’s install the packages we’ll work with.",De,E,Jl='<li><a href="https://pypi.org/project/inflection/" rel="nofollow">inflection</a> - A string transformation library. It singularizes and pluralizes English words, and transforms CamelCase to underscored string.</li> <li><a href="https://pypi.org/project/fastembed/" rel="nofollow">fastembed</a> - A CPU-first, lightweight library for generating vector embeddings. <a href="https://github.com/qdrant/fastembed#%EF%B8%8F-fastembed-on-a-gpu" rel="nofollow">GPU support is available</a>.</li> <li><a href="https://pypi.org/project/qdrant-client/" rel="nofollow">qdrant-client</a> - Official Python library to interface with the Qdrant server.</li>',Pe,W,Oe,N,Ke,R,cl="Chunking the application sources into smaller parts is a non-trivial task. In general, functions, class methods, structs, enums, and all the other language-specific constructs are good candidates for chunks. They are big enough to contain some meaningful information, but small enough to be processed by embedding models with a limited context window. You can also use docstrings, comments, and other metadata can be used to enrich the chunks with additional information.",et,y,dl='<img src="https://huggingface.co/datasets/Anush008/cookbook-images/resolve/main/data-chunking.png"/>',tt,G,Tl="Text-based search is based on function signatures, but code search may return smaller pieces, such as loops. So, if we receive a particular function signature from the NLP model and part of its implementation from the code model, we merge the results.",lt,q,st,V,ul=`We’ll use the <a href="https://github.com/qdrant/qdrant" rel="nofollow">Qdrant codebase</a> for this demo.
While this codebase uses Rust, you can use this approach with any other language. You can use an <a href="https://microsoft.github.io/language-server-protocol/" rel="nofollow">Language Server Protocol (LSP)</a> tool to build a graph of the codebase, and then extract chunks. We did our work with the <a href="https://rust-analyzer.github.io/" rel="nofollow">rust-analyzer</a>. We exported the parsed codebase into the <a href="https://microsoft.github.io/language-server-protocol/specifications/lsif/0.4.0/specification/" rel="nofollow">LSIF</a> format, a standard for code intelligence data. Next, we used the LSIF data to navigate the codebase and extract the chunks.`,nt,Q,wl='You can use the same approach for other languages. There are <a href="https://microsoft.github.io/language-server-protocol/implementors/servers/" rel="nofollow">plenty of implementations</a> available.',at,z,ml="We will then export the chunks into JSON documents with not only the code itself, but also context with the location of the code in the project.",it,H,jl='You can examine the Qdrant structures, parsed in JSON, in the <a href="https://storage.googleapis.com/tutorial-attachments/code-search/structures.jsonl" rel="nofollow">structures.jsonl file</a> in our Google Cloud Storage bucket. Download it and use it as a source of data for our code search.',ot,X,pt,S,hl="Next, load the file and parse the lines into a list of dictionaries:",rt,Y,Mt,L,Il="Let’s see how one entry looks like.",Jt,F,ct,D,dt,P,yl="Each programming language has its own syntax which is not a part of the natural language. Thus, a general-purpose model probably does not understand the code as is. We can, however, normalize the data by removing code specifics and including additional context, such as module, class, function, and file name. We take the following steps:",Tt,O,fl="<li>Extract the signature of the function, method, or other code construct.</li> <li>Divide camel case and snake case names into separate words.</li> <li>Take the docstring, comments, and other important metadata.</li> <li>Build a sentence from the extracted data using a predefined template.</li> <li>Remove the special characters and replace them with spaces.</li>",ut,K,bl="We can now define the <code>textify</code> function that uses the <code>inflection</code> library to carry out our conversions:",wt,ee,mt,te,Ul="Now we can use <code>textify</code> to convert all chunks into text representations:",jt,le,ht,se,gl="Let’s see how one of our representations looks like:",It,ne,yt,ae,ft,ie,bt,oe,Ut,pe,gt,re,Ct,Me,Cl='Qdrant supports multiple modes of deployment. Including in-memory for prototyping, Docker and Qdrant Cloud. You can refer to the <a href="https://qdrant.tech/documentation/guides/installation/" rel="nofollow">installation instructions</a> for more information.',xt,Je,xl="We’ll continue the tutorial using an in-memory instance.",At,f,Bt,ce,Al="Let’s create a collection to store our vectors.",_t,de,$t,Te,Bl="Our newly created collection is ready to accept the data. Let’s upload the embeddings:",vt,ue,kt,we,_l="The uploaded points are immediately available for search. Next, query the collection to find relevant code snippets.",Zt,me,Et,je,$l='We use one of the models to search the collection via Qdrant’s new <a href="https://qdrant.tech/blog/qdrant-1.10.x/" rel="nofollow">Query API</a>. Start with text embeddings. Run the following query “How do I count points in a collection?”. Review the results.',Wt,he,Nt,Ie,vl=`Now, review the results. The following table lists the module, the file name
and score. Each line includes a link to the signature.`,Rt,ye,kl='<thead><tr><th>module</th> <th>file_name</th> <th>score</th> <th>signature</th></tr></thead> <tbody><tr><td>operations</td> <td>types.rs</td> <td>0.5493385</td> <td><a href="https://github.com/qdrant/qdrant/blob/4aac02315bb3ca461a29484094cf6d19025fce99/lib/collection/src/operations/types.rs#L794" rel="nofollow"><code>pub struct CountRequestInternal</code></a></td></tr> <tr><td>map_index</td> <td>types.rs</td> <td>0.49973965</td> <td><a href="https://github.com/qdrant/qdrant/blob/4aac02315bb3ca461a29484094cf6d19025fce99/lib/segment/src/index/field_index/map_index/mod.rs#L89" rel="nofollow"><code>fn get_points_with_value_count</code></a></td></tr> <tr><td>map_index</td> <td>mutable_map_index.rs</td> <td>0.49941066</td> <td><a href="https://github.com/qdrant/qdrant/blob/4aac02315bb3ca461a29484094cf6d19025fce99/lib/segment/src/index/field_index/map_index/mutable_map_index.rs#L143" rel="nofollow"><code>pub fn get_points_with_value_count</code></a></td></tr></tbody>',Gt,fe,Zl="It seems we were able to find some relevant code structures. Let’s try the same with the code embeddings:",qt,be,Vt,Ue,El="Output:",Qt,ge,Wl='<thead><tr><th>module</th> <th>file_name</th> <th>score</th> <th>signature</th></tr></thead> <tbody><tr><td>field_index</td> <td>geo_index.rs</td> <td>0.7217579</td> <td><a href="https://github.com/qdrant/qdrant/blob/4aac02315bb3ca461a29484094cf6d19025fce99/lib/segment/src/index/field_index/geo_index/mod.rs#L319" rel="nofollow"><code>fn count_indexed_points</code></a></td></tr> <tr><td>numeric_index</td> <td>mod.rs</td> <td>0.7113214</td> <td><a href="https://github.com/qdrant/qdrant/blob/4aac02315bb3ca461a29484094cf6d19025fce99/lib/segment/src/index/field_index/numeric_index/mod.rs#L317" rel="nofollow"><code>fn count_indexed_points</code></a></td></tr> <tr><td>full_text_index</td> <td>text_index.rs</td> <td>0.6993165</td> <td><a href="https://github.com/qdrant/qdrant/blob/4aac02315bb3ca461a29484094cf6d19025fce99/lib/segment/src/index/field_index/full_text_index/text_index.rs#L179" rel="nofollow"><code>fn count_indexed_points</code></a></td></tr></tbody>',zt,Ce,Nl=`While the scores retrieved by different models are not comparable, but we can
see that the results are different. Code and text embeddings can capture
different aspects of the codebase. We can use both models to query the collection
and then combine the results to get the most relevant code snippets.`,Ht,xe,Xt,Ae,St,Be,Rl='|  operations  |  lib/collection/src/operations/types.rs  |  0.5  | ` &num; [doc = " Count Request"] &num; [doc = " Counts the number of points which satisfy the given filter."] &num; [doc = " If filter is not provided, the count of all points in the collection will be returned."] &num; [derive (Debug , Deserialize , Serialize , JsonSchema , Validate)] &num; [serde (rename_all = "snake_case")] pub struct CountRequestInternal &#123; &num; [doc = " Look only for points which satisfies this conditions"] &num; [validate] pub filter : Option < Filter > , &num; [doc = " If true, count exact number of points. If false, count approximate number of points faster."] &num; [doc = " Approximate count might be unreliable during the indexing process. Default: true"] &num; [serde (default = "default_exact_count")] pub exact : bool , } ` |\n|  field_index  |  lib/segment/src/index/field_index/geo_index.rs  |  0.5  | ` fn count_indexed_points (& self) -> usize ` |\n|  map_index  |  lib/segment/src/index/field_index/map_index/mod.rs  |  0.33333334  | ` fn get_points_with_value_count < Q > (& self , value : & Q) -> Option < usize > where Q : ? Sized , N : std :: borrow :: Borrow < Q > , Q : Hash + Eq , ` |\n|  numeric_index  |  lib/segment/src/index/field_index/numeric_index/mod.rs  |  0.33333334  | ` fn count_indexed_points (& self) -> usize ` |\n|  fixtures  |  lib/segment/src/fixtures/payload_context_fixture.rs  |  0.25  | ` fn total_point_count (& self) -> usize ` |\n|  map_index  |  lib/segment/src/index/field_index/map_index/mutable_map_index.rs  |  0.25  | ` fn get_points_with_value_count < Q > (& self , value : & Q) -> Option < usize > where Q : ? Sized , N : std :: borrow :: Borrow < Q > , Q : Hash + Eq , ` |\n|  id_tracker  |  lib/segment/src/id_tracker/simple_id_tracker.rs  |  0.2  | ` fn total_point_count (& self) -> usize ` |\n|  map_index  |  lib/segment/src/index/field_index/map_index/mod.rs  |  0.2  | ` fn count_indexed_points (& self) -> usize ` |\n|  map_index  |  lib/segment/src/index/field_index/map_index/mod.rs  |  0.16666667  | ` fn count_indexed_points (& self) -> usize ` |\n|  field_index  |  lib/segment/src/index/field_index/stat_tools.rs  |  0.16666667  | ` fn number_of_selected_points (points : usize , values : usize) -> usize ` |\n',Yt,_e,Gl=`This is one example of how you can fuse the results from different models.
In a real-world scenario, you might run some reranking and deduplication, as well as additional processing of the results.`,Lt,$e,Ft,ve,ql=`You can improve the search results, by grouping them by payload properties.
In our case, we can group the results by the module. If we use code embeddings,
we can see multiple results from the <code>map_index</code> module. Let’s group the
results and assume a single result per module:`,Dt,b,Pt,ke,Ot,Ze,Kt,Ee,Vl="|  field_index  |  geo_index.rs  |  0.7217579  | ` fn count_indexed_points (& self) -> usize ` |\n|  numeric_index  |  mod.rs  |  0.7113214  | ` fn count_indexed_points (& self) -> usize ` |\n|  fixtures  |  payload_context_fixture.rs  |  0.6993165  | ` fn total_point_count (& self) -> usize ` |\n|  map_index  |  mod.rs  |  0.68385994  | ` fn count_indexed_points (& self) -> usize ` |\n|  full_text_index  |  text_index.rs  |  0.6660142  | ` fn count_indexed_points (& self) -> usize ` |\n",el,We,Ql='That concludes our tutorial. Thanks for taking the time to get here. We’ve just begun exploring what’s possible with vector embeddings and how to improve it. Feel free to experiment your way; you could build something very cool! Do share it with us 🙏 We are <a href="https://qdrant.tech/contact-us/" rel="nofollow">here</a>.',tl,Ne,ll,Ge,sl;return U=new ls({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/patch-1/notebooks/en/code_search.ipynb"}]}}),g=new j({props:{title:"Code Search with Vector Embeddings and Qdrant",local:"code-search-with-vector-embeddings-and-qdrant",headingTag:"h2"}}),B=new j({props:{title:"The approach",local:"the-approach",headingTag:"h3"}}),k=new j({props:{title:"Installing Dependencies",local:"installing-dependencies",headingTag:"h2"}}),W=new m({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMGluZmxlY3Rpb24lMjBxZHJhbnQtY2xpZW50JTIwaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGcWRyYW50JTJGZmFzdGVtYmVkJTJGYXJjaGl2ZSUyRm1haW4uemlw",highlighted:'%pip install inflection qdrant-client https://github.com/qdrant/fastembed/archive/main.<span class="hljs-built_in">zip</span>',wrap:!1}}),N=new j({props:{title:"Data preparation",local:"data-preparation",headingTag:"h3"}}),q=new j({props:{title:"Parsing the Codebaase",local:"parsing-the-codebaase",headingTag:"h3"}}),X=new m({props:{code:"IXdnZXQlMjBodHRwcyUzQSUyRiUyRnN0b3JhZ2UuZ29vZ2xlYXBpcy5jb20lMkZ0dXRvcmlhbC1hdHRhY2htZW50cyUyRmNvZGUtc2VhcmNoJTJGc3RydWN0dXJlcy5qc29ubA==",highlighted:"!wget https://storage.googleapis.com/tutorial-attachments/code-search/structures.jsonl",wrap:!1}}),Y=new m({props:{code:"aW1wb3J0JTIwanNvbiUwQSUwQXN0cnVjdHVyZXMlMjAlM0QlMjAlNUIlNUQlMEF3aXRoJTIwb3BlbiglMjJzdHJ1Y3R1cmVzLmpzb25sJTIyJTJDJTIwJTIyciUyMiklMjBhcyUyMGZwJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyQyUyMHJvdyUyMGluJTIwZW51bWVyYXRlKGZwKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVudHJ5JTIwJTNEJTIwanNvbi5sb2Fkcyhyb3cpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RydWN0dXJlcy5hcHBlbmQoZW50cnkp",highlighted:`<span class="hljs-keyword">import</span> json

structures = []
<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;structures.jsonl&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> fp:
    <span class="hljs-keyword">for</span> i, row <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(fp):
        entry = json.loads(row)
        structures.append(entry)`,wrap:!1}}),F=new m({props:{code:"c3RydWN0dXJlcyU1QjAlNUQ=",highlighted:'structures[<span class="hljs-number">0</span>]',wrap:!1}}),D=new j({props:{title:"Code to natural language conversion",local:"code-to-natural-language-conversion",headingTag:"h3"}}),ee=new m({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> inflection
<span class="hljs-keyword">import</span> re

<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Dict</span>, <span class="hljs-type">Any</span>


<span class="hljs-keyword">def</span> <span class="hljs-title function_">textify</span>(<span class="hljs-params">chunk: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]</span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-comment"># Get rid of all the camel case / snake case</span>
    <span class="hljs-comment"># - inflection.underscore changes the camel case to snake case</span>
    <span class="hljs-comment"># - inflection.humanize converts the snake case to human readable form</span>
    name = inflection.humanize(inflection.underscore(chunk[<span class="hljs-string">&quot;name&quot;</span>]))
    signature = inflection.humanize(inflection.underscore(chunk[<span class="hljs-string">&quot;signature&quot;</span>]))

    <span class="hljs-comment"># Check if docstring is provided</span>
    docstring = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">if</span> chunk[<span class="hljs-string">&quot;docstring&quot;</span>]:
        docstring = <span class="hljs-string">f&quot;that does <span class="hljs-subst">{chunk[<span class="hljs-string">&#x27;docstring&#x27;</span>]}</span> &quot;</span>

    <span class="hljs-comment"># Extract the location of that snippet of code</span>
    context = <span class="hljs-string">f&quot;module <span class="hljs-subst">{chunk[<span class="hljs-string">&#x27;context&#x27;</span>][<span class="hljs-string">&#x27;module&#x27;</span>]}</span> &quot;</span> <span class="hljs-string">f&quot;file <span class="hljs-subst">{chunk[<span class="hljs-string">&#x27;context&#x27;</span>][<span class="hljs-string">&#x27;file_name&#x27;</span>]}</span>&quot;</span>
    <span class="hljs-keyword">if</span> chunk[<span class="hljs-string">&quot;context&quot;</span>][<span class="hljs-string">&quot;struct_name&quot;</span>]:
        struct_name = inflection.humanize(inflection.underscore(chunk[<span class="hljs-string">&quot;context&quot;</span>][<span class="hljs-string">&quot;struct_name&quot;</span>]))
        context = <span class="hljs-string">f&quot;defined in struct <span class="hljs-subst">{struct_name}</span> <span class="hljs-subst">{context}</span>&quot;</span>

    <span class="hljs-comment"># Combine all the bits and pieces together</span>
    text_representation = <span class="hljs-string">f&quot;<span class="hljs-subst">{chunk[<span class="hljs-string">&#x27;code_type&#x27;</span>]}</span> <span class="hljs-subst">{name}</span> &quot;</span> <span class="hljs-string">f&quot;<span class="hljs-subst">{docstring}</span>&quot;</span> <span class="hljs-string">f&quot;defined as <span class="hljs-subst">{signature}</span> &quot;</span> <span class="hljs-string">f&quot;<span class="hljs-subst">{context}</span>&quot;</span>

    <span class="hljs-comment"># Remove any special characters and concatenate the tokens</span>
    tokens = re.split(<span class="hljs-string">r&quot;\\W&quot;</span>, text_representation)
    tokens = <span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> x: x, tokens)
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot; &quot;</span>.join(tokens)`,wrap:!1}}),le=new m({props:{code:"dGV4dF9yZXByZXNlbnRhdGlvbnMlMjAlM0QlMjBsaXN0KG1hcCh0ZXh0aWZ5JTJDJTIwc3RydWN0dXJlcykp",highlighted:'text_representations = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">map</span>(textify, structures))',wrap:!1}}),ne=new m({props:{code:"dGV4dF9yZXByZXNlbnRhdGlvbnMlNUIxMDAwJTVE",highlighted:'text_representations[<span class="hljs-number">1000</span>]',wrap:!1}}),ae=new j({props:{title:"Natural language embeddings",local:"natural-language-embeddings",headingTag:"h3"}}),ie=new m({props:{code:"ZnJvbSUyMGZhc3RlbWJlZCUyMGltcG9ydCUyMFRleHRFbWJlZGRpbmclMEElMEFiYXRjaF9zaXplJTIwJTNEJTIwNSUwQSUwQW5scF9tb2RlbCUyMCUzRCUyMFRleHRFbWJlZGRpbmcoJTIyc2VudGVuY2UtdHJhbnNmb3JtZXJzJTJGYWxsLU1pbmlMTS1MNi12MiUyMiUyQyUyMHRocmVhZHMlM0QwKSUwQW5scF9lbWJlZGRpbmdzJTIwJTNEJTIwbmxwX21vZGVsLmVtYmVkKHRleHRfcmVwcmVzZW50YXRpb25zJTJDJTIwYmF0Y2hfc2l6ZSUzRGJhdGNoX3NpemUp",highlighted:`<span class="hljs-keyword">from</span> fastembed <span class="hljs-keyword">import</span> TextEmbedding

batch_size = <span class="hljs-number">5</span>

nlp_model = TextEmbedding(<span class="hljs-string">&quot;sentence-transformers/all-MiniLM-L6-v2&quot;</span>, threads=<span class="hljs-number">0</span>)
nlp_embeddings = nlp_model.embed(text_representations, batch_size=batch_size)`,wrap:!1}}),oe=new j({props:{title:"Code Embeddings",local:"code-embeddings",headingTag:"h3"}}),pe=new m({props:{code:"Y29kZV9zbmlwcGV0cyUyMCUzRCUyMCU1QnN0cnVjdHVyZSU1QiUyMmNvbnRleHQlMjIlNUQlNUIlMjJzbmlwcGV0JTIyJTVEJTIwZm9yJTIwc3RydWN0dXJlJTIwaW4lMjBzdHJ1Y3R1cmVzJTVEJTBBJTBBY29kZV9tb2RlbCUyMCUzRCUyMFRleHRFbWJlZGRpbmcoJTIyamluYWFpJTJGamluYS1lbWJlZGRpbmdzLXYyLWJhc2UtY29kZSUyMiklMEElMEFjb2RlX2VtYmVkZGluZ3MlMjAlM0QlMjBjb2RlX21vZGVsLmVtYmVkKGNvZGVfc25pcHBldHMlMkMlMjBiYXRjaF9zaXplJTNEYmF0Y2hfc2l6ZSk=",highlighted:`code_snippets = [structure[<span class="hljs-string">&quot;context&quot;</span>][<span class="hljs-string">&quot;snippet&quot;</span>] <span class="hljs-keyword">for</span> structure <span class="hljs-keyword">in</span> structures]

code_model = TextEmbedding(<span class="hljs-string">&quot;jinaai/jina-embeddings-v2-base-code&quot;</span>)

code_embeddings = code_model.embed(code_snippets, batch_size=batch_size)`,wrap:!1}}),re=new j({props:{title:"Building Qdrant collection",local:"building-qdrant-collection",headingTag:"h3"}}),f=new Yl({props:{warning:!1,$$slots:{default:[ns]},$$scope:{ctx:Re}}}),de=new m({props:{code:"ZnJvbSUyMHFkcmFudF9jbGllbnQlMjBpbXBvcnQlMjBRZHJhbnRDbGllbnQlMkMlMjBtb2RlbHMlMEElMEFDT0xMRUNUSU9OX05BTUUlMjAlM0QlMjAlMjJxZHJhbnQtc291cmNlcyUyMiUwQSUwQWNsaWVudCUyMCUzRCUyMFFkcmFudENsaWVudCglMjIlM0FtZW1vcnklM0ElMjIpJTIwJTIwJTIzJTIwVXNlJTIwaW4tbWVtb3J5JTIwc3RvcmFnZSUwQSUyMyUyMGNsaWVudCUyMCUzRCUyMFFkcmFudENsaWVudCglMjJodHRwJTNBJTJGJTJGbG9jYWhvc3QlM0E2MzMzJTIyKSUyMCUyMCUyMyUyMEZvciUyMFFkcmFudCUyMHNlcnZlciUwQSUwQWNsaWVudC5jcmVhdGVfY29sbGVjdGlvbiglMEElMjAlMjAlMjAlMjBDT0xMRUNUSU9OX05BTUUlMkMlMEElMjAlMjAlMjAlMjB2ZWN0b3JzX2NvbmZpZyUzRCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRleHQlMjIlM0ElMjBtb2RlbHMuVmVjdG9yUGFyYW1zKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNpemUlM0QzODQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkaXN0YW5jZSUzRG1vZGVscy5EaXN0YW5jZS5DT1NJTkUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29kZSUyMiUzQSUyMG1vZGVscy5WZWN0b3JQYXJhbXMoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2l6ZSUzRDc2OCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRpc3RhbmNlJTNEbW9kZWxzLkRpc3RhbmNlLkNPU0lORSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> qdrant_client <span class="hljs-keyword">import</span> QdrantClient, models

COLLECTION_NAME = <span class="hljs-string">&quot;qdrant-sources&quot;</span>

client = QdrantClient(<span class="hljs-string">&quot;:memory:&quot;</span>)  <span class="hljs-comment"># Use in-memory storage</span>
<span class="hljs-comment"># client = QdrantClient(&quot;http://locahost:6333&quot;)  # For Qdrant server</span>

client.create_collection(
    COLLECTION_NAME,
    vectors_config={
        <span class="hljs-string">&quot;text&quot;</span>: models.VectorParams(
            size=<span class="hljs-number">384</span>,
            distance=models.Distance.COSINE,
        ),
        <span class="hljs-string">&quot;code&quot;</span>: models.VectorParams(
            size=<span class="hljs-number">768</span>,
            distance=models.Distance.COSINE,
        ),
    },
)`,wrap:!1}}),ue=new m({props:{code:"ZnJvbSUyMHRxZG0lMjBpbXBvcnQlMjB0cWRtJTBBJTBBcG9pbnRzJTIwJTNEJTIwJTVCJTVEJTBBdG90YWwlMjAlM0QlMjBsZW4oc3RydWN0dXJlcyklMEFwcmludCglMjJOdW1iZXIlMjBvZiUyMHBvaW50cyUyMHRvJTIwdXBsb2FkJTNBJTIwJTIyJTJDJTIwdG90YWwpJTBBJTBBZm9yJTIwaWQlMkMlMjAodGV4dF9lbWJlZGRpbmclMkMlMjBjb2RlX2VtYmVkZGluZyUyQyUyMHN0cnVjdHVyZSklMjBpbiUyMHRxZG0oJTBBJTIwJTIwJTIwJTIwZW51bWVyYXRlKHppcChubHBfZW1iZWRkaW5ncyUyQyUyMGNvZGVfZW1iZWRkaW5ncyUyQyUyMHN0cnVjdHVyZXMpKSUyQyUyMHRvdGFsJTNEdG90YWwlMEEpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwRmFzdEVtYmVkJTIwcmV0dXJucyUyMGdlbmVyYXRvcnMuJTIwRW1iZWRkaW5ncyUyMGFyZSUyMGNvbXB1dGVkJTIwYXMlMjBjb25zdW1lZC4lMEElMjAlMjAlMjAlMjBwb2ludHMuYXBwZW5kKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVscy5Qb2ludFN0cnVjdCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZCUzRGlkJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdmVjdG9yJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGV4dCUyMiUzQSUyMHRleHRfZW1iZWRkaW5nJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29kZSUyMiUzQSUyMGNvZGVfZW1iZWRkaW5nJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGF5bG9hZCUzRHN0cnVjdHVyZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwVXBsb2FkJTIwcG9pbnRzJTIwaW4lMjBiYXRjaGVzJTBBJTIwJTIwJTIwJTIwaWYlMjBsZW4ocG9pbnRzKSUyMCUzRSUzRCUyMGJhdGNoX3NpemUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjbGllbnQudXBsb2FkX3BvaW50cyhDT0xMRUNUSU9OX05BTUUlMkMlMjBwb2ludHMlM0Rwb2ludHMlMkMlMjB3YWl0JTNEVHJ1ZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwb2ludHMlMjAlM0QlMjAlNUIlNUQlMEElMEElMjMlMjBFbnN1cmUlMjBhbnklMjByZW1haW5pbmclMjBwb2ludHMlMjBhcmUlMjB1cGxvYWRlZCUwQWlmJTIwcG9pbnRzJTNBJTBBJTIwJTIwJTIwJTIwY2xpZW50LnVwbG9hZF9wb2ludHMoQ09MTEVDVElPTl9OQU1FJTJDJTIwcG9pbnRzJTNEcG9pbnRzKSUwQSUwQXByaW50KGYlMjJUb3RhbCUyMHBvaW50cyUyMGluJTIwY29sbGVjdGlvbiUzQSUyMCU3QmNsaWVudC5jb3VudChDT0xMRUNUSU9OX05BTUUpLmNvdW50JTdEJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm

points = []
total = <span class="hljs-built_in">len</span>(structures)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Number of points to upload: &quot;</span>, total)

<span class="hljs-keyword">for</span> <span class="hljs-built_in">id</span>, (text_embedding, code_embedding, structure) <span class="hljs-keyword">in</span> tqdm(
    <span class="hljs-built_in">enumerate</span>(<span class="hljs-built_in">zip</span>(nlp_embeddings, code_embeddings, structures)), total=total
):
    <span class="hljs-comment"># FastEmbed returns generators. Embeddings are computed as consumed.</span>
    points.append(
        models.PointStruct(
            <span class="hljs-built_in">id</span>=<span class="hljs-built_in">id</span>,
            vector={
                <span class="hljs-string">&quot;text&quot;</span>: text_embedding,
                <span class="hljs-string">&quot;code&quot;</span>: code_embedding,
            },
            payload=structure,
        )
    )

    <span class="hljs-comment"># Upload points in batches</span>
    <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(points) &gt;= batch_size:
        client.upload_points(COLLECTION_NAME, points=points, wait=<span class="hljs-literal">True</span>)
        points = []

<span class="hljs-comment"># Ensure any remaining points are uploaded</span>
<span class="hljs-keyword">if</span> points:
    client.upload_points(COLLECTION_NAME, points=points)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Total points in collection: <span class="hljs-subst">{client.count(COLLECTION_NAME).count}</span>&quot;</span>)`,wrap:!1}}),me=new j({props:{title:"Querying the codebase",local:"querying-the-codebase",headingTag:"h3"}}),he=new m({props:{code:"cXVlcnklMjAlM0QlMjAlMjJIb3clMjBkbyUyMEklMjBjb3VudCUyMHBvaW50cyUyMGluJTIwYSUyMGNvbGxlY3Rpb24lM0YlMjIlMEElMEFoaXRzJTIwJTNEJTIwY2xpZW50LnF1ZXJ5X3BvaW50cyglMEElMjAlMjAlMjAlMjBDT0xMRUNUSU9OX05BTUUlMkMlMEElMjAlMjAlMjAlMjBxdWVyeSUzRG5leHQobmxwX21vZGVsLnF1ZXJ5X2VtYmVkKHF1ZXJ5KSkudG9saXN0KCklMkMlMEElMjAlMjAlMjAlMjB1c2luZyUzRCUyMnRleHQlMjIlMkMlMEElMjAlMjAlMjAlMjBsaW1pdCUzRDMlMkMlMEEpLnBvaW50cw==",highlighted:`query = <span class="hljs-string">&quot;How do I count points in a collection?&quot;</span>

hits = client.query_points(
    COLLECTION_NAME,
    query=<span class="hljs-built_in">next</span>(nlp_model.query_embed(query)).tolist(),
    using=<span class="hljs-string">&quot;text&quot;</span>,
    limit=<span class="hljs-number">3</span>,
).points`,wrap:!1}}),be=new m({props:{code:"aGl0cyUyMCUzRCUyMGNsaWVudC5xdWVyeV9wb2ludHMoJTBBJTIwJTIwJTIwJTIwQ09MTEVDVElPTl9OQU1FJTJDJTBBJTIwJTIwJTIwJTIwcXVlcnklM0RuZXh0KGNvZGVfbW9kZWwucXVlcnlfZW1iZWQocXVlcnkpKS50b2xpc3QoKSUyQyUwQSUyMCUyMCUyMCUyMHVzaW5nJTNEJTIyY29kZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGxpbWl0JTNEMyUyQyUwQSkucG9pbnRz",highlighted:`hits = client.query_points(
    COLLECTION_NAME,
    query=<span class="hljs-built_in">next</span>(code_model.query_embed(query)).tolist(),
    using=<span class="hljs-string">&quot;code&quot;</span>,
    limit=<span class="hljs-number">3</span>,
).points`,wrap:!1}}),xe=new m({props:{code:"ZnJvbSUyMHFkcmFudF9jbGllbnQlMjBpbXBvcnQlMjBtb2RlbHMlMEElMEFoaXRzJTIwJTNEJTIwY2xpZW50LnF1ZXJ5X3BvaW50cyglMEElMjAlMjAlMjAlMjBjb2xsZWN0aW9uX25hbWUlM0RDT0xMRUNUSU9OX05BTUUlMkMlMEElMjAlMjAlMjAlMjBwcmVmZXRjaCUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVscy5QcmVmZXRjaCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBxdWVyeSUzRG5leHQobmxwX21vZGVsLnF1ZXJ5X2VtYmVkKHF1ZXJ5KSkudG9saXN0KCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB1c2luZyUzRCUyMnRleHQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsaW1pdCUzRDUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWxzLlByZWZldGNoKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHF1ZXJ5JTNEbmV4dChjb2RlX21vZGVsLnF1ZXJ5X2VtYmVkKHF1ZXJ5KSkudG9saXN0KCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB1c2luZyUzRCUyMmNvZGUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsaW1pdCUzRDUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwcXVlcnklM0Rtb2RlbHMuRnVzaW9uUXVlcnkoZnVzaW9uJTNEbW9kZWxzLkZ1c2lvbi5SUkYpJTJDJTBBKS5wb2ludHM=",highlighted:`<span class="hljs-keyword">from</span> qdrant_client <span class="hljs-keyword">import</span> models

hits = client.query_points(
    collection_name=COLLECTION_NAME,
    prefetch=[
        models.Prefetch(
            query=<span class="hljs-built_in">next</span>(nlp_model.query_embed(query)).tolist(),
            using=<span class="hljs-string">&quot;text&quot;</span>,
            limit=<span class="hljs-number">5</span>,
        ),
        models.Prefetch(
            query=<span class="hljs-built_in">next</span>(code_model.query_embed(query)).tolist(),
            using=<span class="hljs-string">&quot;code&quot;</span>,
            limit=<span class="hljs-number">5</span>,
        ),
    ],
    query=models.FusionQuery(fusion=models.Fusion.RRF),
).points`,wrap:!1}}),Ae=new m({props:{code:"Zm9yJTIwaGl0JTIwaW4lMjBoaXRzJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTdDJTIwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGl0LnBheWxvYWQlNUIlMjJjb250ZXh0JTIyJTVEJTVCJTIybW9kdWxlJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIwJTdDJTIwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGl0LnBheWxvYWQlNUIlMjJjb250ZXh0JTIyJTVEJTVCJTIyZmlsZV9wYXRoJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIwJTdDJTIwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGl0LnNjb3JlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIwJTdDJTIwJTYwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGl0LnBheWxvYWQlNUIlMjJzaWduYXR1cmUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjIlNjAlMjAlN0MlMjIlMkMlMEElMjAlMjAlMjAlMjAp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> hit <span class="hljs-keyword">in</span> hits:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;| &quot;</span>,
<span class="hljs-meta">... </span>        hit.payload[<span class="hljs-string">&quot;context&quot;</span>][<span class="hljs-string">&quot;module&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot; | &quot;</span>,
<span class="hljs-meta">... </span>        hit.payload[<span class="hljs-string">&quot;context&quot;</span>][<span class="hljs-string">&quot;file_path&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot; | &quot;</span>,
<span class="hljs-meta">... </span>        hit.score,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot; | \`&quot;</span>,
<span class="hljs-meta">... </span>        hit.payload[<span class="hljs-string">&quot;signature&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;\` |&quot;</span>,
<span class="hljs-meta">... </span>    )`,wrap:!1}}),$e=new j({props:{title:"Grouping the results",local:"grouping-the-results",headingTag:"h3"}}),b=new Yl({props:{warning:!1,$$slots:{default:[as]},$$scope:{ctx:Re}}}),ke=new m({props:{code:"cmVzdWx0cyUyMCUzRCUyMGNsaWVudC5zZWFyY2hfZ3JvdXBzKCUwQSUyMCUyMCUyMCUyMENPTExFQ1RJT05fTkFNRSUyQyUwQSUyMCUyMCUyMCUyMHF1ZXJ5X3ZlY3RvciUzRCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb2RlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbmV4dChjb2RlX21vZGVsLnF1ZXJ5X2VtYmVkKHF1ZXJ5KSkudG9saXN0KCklMkMlMEElMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwZ3JvdXBfYnklM0QlMjJjb250ZXh0Lm1vZHVsZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGxpbWl0JTNENSUyQyUwQSUyMCUyMCUyMCUyMGdyb3VwX3NpemUlM0QxJTJDJTBBKQ==",highlighted:`results = client.search_groups(
    COLLECTION_NAME,
    query_vector=(
        <span class="hljs-string">&quot;code&quot;</span>,
        <span class="hljs-built_in">next</span>(code_model.query_embed(query)).tolist(),
    ),
    group_by=<span class="hljs-string">&quot;context.module&quot;</span>,
    limit=<span class="hljs-number">5</span>,
    group_size=<span class="hljs-number">1</span>,
)`,wrap:!1}}),Ze=new m({props:{code:"Zm9yJTIwZ3JvdXAlMjBpbiUyMHJlc3VsdHMuZ3JvdXBzJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwaGl0JTIwaW4lMjBncm91cC5oaXRzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTdDJTIwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGl0LnBheWxvYWQlNUIlMjJjb250ZXh0JTIyJTVEJTVCJTIybW9kdWxlJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIwJTdDJTIwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGl0LnBheWxvYWQlNUIlMjJjb250ZXh0JTIyJTVEJTVCJTIyZmlsZV9uYW1lJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIwJTdDJTIwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGl0LnNjb3JlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIwJTdDJTIwJTYwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGl0LnBheWxvYWQlNUIlMjJzaWduYXR1cmUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjIlNjAlMjAlN0MlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> group <span class="hljs-keyword">in</span> results.groups:
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> hit <span class="hljs-keyword">in</span> group.hits:
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;| &quot;</span>,
<span class="hljs-meta">... </span>            hit.payload[<span class="hljs-string">&quot;context&quot;</span>][<span class="hljs-string">&quot;module&quot;</span>],
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot; | &quot;</span>,
<span class="hljs-meta">... </span>            hit.payload[<span class="hljs-string">&quot;context&quot;</span>][<span class="hljs-string">&quot;file_name&quot;</span>],
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot; | &quot;</span>,
<span class="hljs-meta">... </span>            hit.score,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot; | \`&quot;</span>,
<span class="hljs-meta">... </span>            hit.payload[<span class="hljs-string">&quot;signature&quot;</span>],
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;\` |&quot;</span>,
<span class="hljs-meta">... </span>        )`,wrap:!1}}),Ne=new ss({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/code_search.md"}}),{c(){u=i("meta"),h=n(),w=i("p"),I=n(),r(U.$$.fragment),qe=n(),r(g.$$.fragment),Ve=n(),C=i("p"),C.innerHTML=nl,Qe=n(),x=i("p"),x.textContent=al,ze=n(),A=i("p"),A.innerHTML=il,He=n(),r(B.$$.fragment),Xe=n(),_=i("p"),_.textContent=ol,Se=n(),$=i("ul"),$.innerHTML=pl,Ye=n(),v=i("p"),v.textContent=rl,Le=n(),r(k.$$.fragment),Fe=n(),Z=i("p"),Z.textContent=Ml,De=n(),E=i("ul"),E.innerHTML=Jl,Pe=n(),r(W.$$.fragment),Oe=n(),r(N.$$.fragment),Ke=n(),R=i("p"),R.textContent=cl,et=n(),y=i("div"),y.innerHTML=dl,tt=n(),G=i("p"),G.textContent=Tl,lt=n(),r(q.$$.fragment),st=n(),V=i("p"),V.innerHTML=ul,nt=n(),Q=i("p"),Q.innerHTML=wl,at=n(),z=i("p"),z.textContent=ml,it=n(),H=i("p"),H.innerHTML=jl,ot=n(),r(X.$$.fragment),pt=n(),S=i("p"),S.textContent=hl,rt=n(),r(Y.$$.fragment),Mt=n(),L=i("p"),L.textContent=Il,Jt=n(),r(F.$$.fragment),ct=n(),r(D.$$.fragment),dt=n(),P=i("p"),P.textContent=yl,Tt=n(),O=i("ol"),O.innerHTML=fl,ut=n(),K=i("p"),K.innerHTML=bl,wt=n(),r(ee.$$.fragment),mt=n(),te=i("p"),te.innerHTML=Ul,jt=n(),r(le.$$.fragment),ht=n(),se=i("p"),se.textContent=gl,It=n(),r(ne.$$.fragment),yt=n(),r(ae.$$.fragment),ft=n(),r(ie.$$.fragment),bt=n(),r(oe.$$.fragment),Ut=n(),r(pe.$$.fragment),gt=n(),r(re.$$.fragment),Ct=n(),Me=i("p"),Me.innerHTML=Cl,xt=n(),Je=i("p"),Je.textContent=xl,At=n(),r(f.$$.fragment),Bt=n(),ce=i("p"),ce.textContent=Al,_t=n(),r(de.$$.fragment),$t=n(),Te=i("p"),Te.textContent=Bl,vt=n(),r(ue.$$.fragment),kt=n(),we=i("p"),we.textContent=_l,Zt=n(),r(me.$$.fragment),Et=n(),je=i("p"),je.innerHTML=$l,Wt=n(),r(he.$$.fragment),Nt=n(),Ie=i("p"),Ie.textContent=vl,Rt=n(),ye=i("table"),ye.innerHTML=kl,Gt=n(),fe=i("p"),fe.textContent=Zl,qt=n(),r(be.$$.fragment),Vt=n(),Ue=i("p"),Ue.textContent=El,Qt=n(),ge=i("table"),ge.innerHTML=Wl,zt=n(),Ce=i("p"),Ce.textContent=Nl,Ht=n(),r(xe.$$.fragment),Xt=n(),r(Ae.$$.fragment),St=n(),Be=i("pre"),Be.textContent=Rl,Yt=n(),_e=i("p"),_e.textContent=Gl,Lt=n(),r($e.$$.fragment),Ft=n(),ve=i("p"),ve.innerHTML=ql,Dt=n(),r(b.$$.fragment),Pt=n(),r(ke.$$.fragment),Ot=n(),r(Ze.$$.fragment),Kt=n(),Ee=i("pre"),Ee.textContent=Vl,el=n(),We=i("p"),We.innerHTML=Ql,tl=n(),r(Ne.$$.fragment),ll=n(),Ge=i("p"),this.h()},l(e){const t=Kl("svelte-u9bgzb",document.head);u=o(t,"META",{name:!0,content:!0}),t.forEach(l),h=a(e),w=o(e,"P",{}),Xl(w).forEach(l),I=a(e),M(U.$$.fragment,e),qe=a(e),M(g.$$.fragment,e),Ve=a(e),C=o(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-17bl742"&&(C.innerHTML=nl),Qe=a(e),x=o(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-ae7bkg"&&(x.textContent=al),ze=a(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-kszg01"&&(A.innerHTML=il),He=a(e),M(B.$$.fragment,e),Xe=a(e),_=o(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1dvof7"&&(_.textContent=ol),Se=a(e),$=o(e,"UL",{"data-svelte-h":!0}),p($)!=="svelte-19x5x7t"&&($.innerHTML=pl),Ye=a(e),v=o(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-d94nr5"&&(v.textContent=rl),Le=a(e),M(k.$$.fragment,e),Fe=a(e),Z=o(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-ut59o"&&(Z.textContent=Ml),De=a(e),E=o(e,"UL",{"data-svelte-h":!0}),p(E)!=="svelte-n6syf2"&&(E.innerHTML=Jl),Pe=a(e),M(W.$$.fragment,e),Oe=a(e),M(N.$$.fragment,e),Ke=a(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1g3hp9b"&&(R.textContent=cl),et=a(e),y=o(e,"DIV",{style:!0,"data-svelte-h":!0}),p(y)!=="svelte-aiydin"&&(y.innerHTML=dl),tt=a(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-k9nbvr"&&(G.textContent=Tl),lt=a(e),M(q.$$.fragment,e),st=a(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-i8w8vo"&&(V.innerHTML=ul),nt=a(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1mfzfdl"&&(Q.innerHTML=wl),at=a(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-15jgfrp"&&(z.textContent=ml),it=a(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-14cl4i2"&&(H.innerHTML=jl),ot=a(e),M(X.$$.fragment,e),pt=a(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-6aidpg"&&(S.textContent=hl),rt=a(e),M(Y.$$.fragment,e),Mt=a(e),L=o(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-y6ssjb"&&(L.textContent=Il),Jt=a(e),M(F.$$.fragment,e),ct=a(e),M(D.$$.fragment,e),dt=a(e),P=o(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1oie9o1"&&(P.textContent=yl),Tt=a(e),O=o(e,"OL",{"data-svelte-h":!0}),p(O)!=="svelte-xx6zbg"&&(O.innerHTML=fl),ut=a(e),K=o(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-1k8bmra"&&(K.innerHTML=bl),wt=a(e),M(ee.$$.fragment,e),mt=a(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-1fo0w5p"&&(te.innerHTML=Ul),jt=a(e),M(le.$$.fragment,e),ht=a(e),se=o(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-3wwgsm"&&(se.textContent=gl),It=a(e),M(ne.$$.fragment,e),yt=a(e),M(ae.$$.fragment,e),ft=a(e),M(ie.$$.fragment,e),bt=a(e),M(oe.$$.fragment,e),Ut=a(e),M(pe.$$.fragment,e),gt=a(e),M(re.$$.fragment,e),Ct=a(e),Me=o(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-8h1xvl"&&(Me.innerHTML=Cl),xt=a(e),Je=o(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-5jc3sw"&&(Je.textContent=xl),At=a(e),M(f.$$.fragment,e),Bt=a(e),ce=o(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-1fvhhbg"&&(ce.textContent=Al),_t=a(e),M(de.$$.fragment,e),$t=a(e),Te=o(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-dpehrl"&&(Te.textContent=Bl),vt=a(e),M(ue.$$.fragment,e),kt=a(e),we=o(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-3ws99c"&&(we.textContent=_l),Zt=a(e),M(me.$$.fragment,e),Et=a(e),je=o(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-h95ly4"&&(je.innerHTML=$l),Wt=a(e),M(he.$$.fragment,e),Nt=a(e),Ie=o(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-1yoto9z"&&(Ie.textContent=vl),Rt=a(e),ye=o(e,"TABLE",{"data-svelte-h":!0}),p(ye)!=="svelte-129t8ym"&&(ye.innerHTML=kl),Gt=a(e),fe=o(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-19cp8rk"&&(fe.textContent=Zl),qt=a(e),M(be.$$.fragment,e),Vt=a(e),Ue=o(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-1wuxk0l"&&(Ue.textContent=El),Qt=a(e),ge=o(e,"TABLE",{"data-svelte-h":!0}),p(ge)!=="svelte-1d7gdtl"&&(ge.innerHTML=Wl),zt=a(e),Ce=o(e,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-6u9tc7"&&(Ce.textContent=Nl),Ht=a(e),M(xe.$$.fragment,e),Xt=a(e),M(Ae.$$.fragment,e),St=a(e),Be=o(e,"PRE",{"data-svelte-h":!0}),p(Be)!=="svelte-13qauwq"&&(Be.textContent=Rl),Yt=a(e),_e=o(e,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-rfg7y4"&&(_e.textContent=Gl),Lt=a(e),M($e.$$.fragment,e),Ft=a(e),ve=o(e,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-t87f2d"&&(ve.innerHTML=ql),Dt=a(e),M(b.$$.fragment,e),Pt=a(e),M(ke.$$.fragment,e),Ot=a(e),M(Ze.$$.fragment,e),Kt=a(e),Ee=o(e,"PRE",{"data-svelte-h":!0}),p(Ee)!=="svelte-jxqdo"&&(Ee.textContent=Vl),el=a(e),We=o(e,"P",{"data-svelte-h":!0}),p(We)!=="svelte-1rvelqz"&&(We.innerHTML=Ql),tl=a(e),M(Ne.$$.fragment,e),ll=a(e),Ge=o(e,"P",{}),Xl(Ge).forEach(l),this.h()},h(){Sl(u,"name","hf:doc:metadata"),Sl(u,"content",os),es(y,"text-align","center")},m(e,t){ts(document.head,u),s(e,h,t),s(e,w,t),s(e,I,t),J(U,e,t),s(e,qe,t),J(g,e,t),s(e,Ve,t),s(e,C,t),s(e,Qe,t),s(e,x,t),s(e,ze,t),s(e,A,t),s(e,He,t),J(B,e,t),s(e,Xe,t),s(e,_,t),s(e,Se,t),s(e,$,t),s(e,Ye,t),s(e,v,t),s(e,Le,t),J(k,e,t),s(e,Fe,t),s(e,Z,t),s(e,De,t),s(e,E,t),s(e,Pe,t),J(W,e,t),s(e,Oe,t),J(N,e,t),s(e,Ke,t),s(e,R,t),s(e,et,t),s(e,y,t),s(e,tt,t),s(e,G,t),s(e,lt,t),J(q,e,t),s(e,st,t),s(e,V,t),s(e,nt,t),s(e,Q,t),s(e,at,t),s(e,z,t),s(e,it,t),s(e,H,t),s(e,ot,t),J(X,e,t),s(e,pt,t),s(e,S,t),s(e,rt,t),J(Y,e,t),s(e,Mt,t),s(e,L,t),s(e,Jt,t),J(F,e,t),s(e,ct,t),J(D,e,t),s(e,dt,t),s(e,P,t),s(e,Tt,t),s(e,O,t),s(e,ut,t),s(e,K,t),s(e,wt,t),J(ee,e,t),s(e,mt,t),s(e,te,t),s(e,jt,t),J(le,e,t),s(e,ht,t),s(e,se,t),s(e,It,t),J(ne,e,t),s(e,yt,t),J(ae,e,t),s(e,ft,t),J(ie,e,t),s(e,bt,t),J(oe,e,t),s(e,Ut,t),J(pe,e,t),s(e,gt,t),J(re,e,t),s(e,Ct,t),s(e,Me,t),s(e,xt,t),s(e,Je,t),s(e,At,t),J(f,e,t),s(e,Bt,t),s(e,ce,t),s(e,_t,t),J(de,e,t),s(e,$t,t),s(e,Te,t),s(e,vt,t),J(ue,e,t),s(e,kt,t),s(e,we,t),s(e,Zt,t),J(me,e,t),s(e,Et,t),s(e,je,t),s(e,Wt,t),J(he,e,t),s(e,Nt,t),s(e,Ie,t),s(e,Rt,t),s(e,ye,t),s(e,Gt,t),s(e,fe,t),s(e,qt,t),J(be,e,t),s(e,Vt,t),s(e,Ue,t),s(e,Qt,t),s(e,ge,t),s(e,zt,t),s(e,Ce,t),s(e,Ht,t),J(xe,e,t),s(e,Xt,t),J(Ae,e,t),s(e,St,t),s(e,Be,t),s(e,Yt,t),s(e,_e,t),s(e,Lt,t),J($e,e,t),s(e,Ft,t),s(e,ve,t),s(e,Dt,t),J(b,e,t),s(e,Pt,t),J(ke,e,t),s(e,Ot,t),J(Ze,e,t),s(e,Kt,t),s(e,Ee,t),s(e,el,t),s(e,We,t),s(e,tl,t),J(Ne,e,t),s(e,ll,t),s(e,Ge,t),sl=!0},p(e,[t]){const zl={};t&2&&(zl.$$scope={dirty:t,ctx:e}),f.$set(zl);const Hl={};t&2&&(Hl.$$scope={dirty:t,ctx:e}),b.$set(Hl)},i(e){sl||(c(U.$$.fragment,e),c(g.$$.fragment,e),c(B.$$.fragment,e),c(k.$$.fragment,e),c(W.$$.fragment,e),c(N.$$.fragment,e),c(q.$$.fragment,e),c(X.$$.fragment,e),c(Y.$$.fragment,e),c(F.$$.fragment,e),c(D.$$.fragment,e),c(ee.$$.fragment,e),c(le.$$.fragment,e),c(ne.$$.fragment,e),c(ae.$$.fragment,e),c(ie.$$.fragment,e),c(oe.$$.fragment,e),c(pe.$$.fragment,e),c(re.$$.fragment,e),c(f.$$.fragment,e),c(de.$$.fragment,e),c(ue.$$.fragment,e),c(me.$$.fragment,e),c(he.$$.fragment,e),c(be.$$.fragment,e),c(xe.$$.fragment,e),c(Ae.$$.fragment,e),c($e.$$.fragment,e),c(b.$$.fragment,e),c(ke.$$.fragment,e),c(Ze.$$.fragment,e),c(Ne.$$.fragment,e),sl=!0)},o(e){d(U.$$.fragment,e),d(g.$$.fragment,e),d(B.$$.fragment,e),d(k.$$.fragment,e),d(W.$$.fragment,e),d(N.$$.fragment,e),d(q.$$.fragment,e),d(X.$$.fragment,e),d(Y.$$.fragment,e),d(F.$$.fragment,e),d(D.$$.fragment,e),d(ee.$$.fragment,e),d(le.$$.fragment,e),d(ne.$$.fragment,e),d(ae.$$.fragment,e),d(ie.$$.fragment,e),d(oe.$$.fragment,e),d(pe.$$.fragment,e),d(re.$$.fragment,e),d(f.$$.fragment,e),d(de.$$.fragment,e),d(ue.$$.fragment,e),d(me.$$.fragment,e),d(he.$$.fragment,e),d(be.$$.fragment,e),d(xe.$$.fragment,e),d(Ae.$$.fragment,e),d($e.$$.fragment,e),d(b.$$.fragment,e),d(ke.$$.fragment,e),d(Ze.$$.fragment,e),d(Ne.$$.fragment,e),sl=!1},d(e){e&&(l(h),l(w),l(I),l(qe),l(Ve),l(C),l(Qe),l(x),l(ze),l(A),l(He),l(Xe),l(_),l(Se),l($),l(Ye),l(v),l(Le),l(Fe),l(Z),l(De),l(E),l(Pe),l(Oe),l(Ke),l(R),l(et),l(y),l(tt),l(G),l(lt),l(st),l(V),l(nt),l(Q),l(at),l(z),l(it),l(H),l(ot),l(pt),l(S),l(rt),l(Mt),l(L),l(Jt),l(ct),l(dt),l(P),l(Tt),l(O),l(ut),l(K),l(wt),l(mt),l(te),l(jt),l(ht),l(se),l(It),l(yt),l(ft),l(bt),l(Ut),l(gt),l(Ct),l(Me),l(xt),l(Je),l(At),l(Bt),l(ce),l(_t),l($t),l(Te),l(vt),l(kt),l(we),l(Zt),l(Et),l(je),l(Wt),l(Nt),l(Ie),l(Rt),l(ye),l(Gt),l(fe),l(qt),l(Vt),l(Ue),l(Qt),l(ge),l(zt),l(Ce),l(Ht),l(Xt),l(St),l(Be),l(Yt),l(_e),l(Lt),l(Ft),l(ve),l(Dt),l(Pt),l(Ot),l(Kt),l(Ee),l(el),l(We),l(tl),l(ll),l(Ge)),l(u),T(U,e),T(g,e),T(B,e),T(k,e),T(W,e),T(N,e),T(q,e),T(X,e),T(Y,e),T(F,e),T(D,e),T(ee,e),T(le,e),T(ne,e),T(ae,e),T(ie,e),T(oe,e),T(pe,e),T(re,e),T(f,e),T(de,e),T(ue,e),T(me,e),T(he,e),T(be,e),T(xe,e),T(Ae,e),T($e,e),T(b,e),T(ke,e),T(Ze,e),T(Ne,e)}}}const os='{"title":"Code Search with Vector Embeddings and Qdrant","local":"code-search-with-vector-embeddings-and-qdrant","sections":[{"title":"The approach","local":"the-approach","sections":[],"depth":3}],"depth":2}';function ps(Re){return Dl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ts extends Pl{constructor(u){super(),Ol(this,u,ps,is,Fl,{})}}export{Ts as component};
