import{s as le,n as ce,o as pe}from"../chunks/scheduler.7b8d42e8.js";import{S as ge,i as ue,g as i,s as r,r as l,A as _e,h as o,f as t,c as s,j as x,u as c,x as d,k as v,y as m,a as n,v as p,d as g,t as u,w as _}from"../chunks/index.0671836c.js";import{D as b}from"../chunks/Docstring.8421363b.js";import{C as Jt}from"../chunks/CodeBlock.c4671c67.js";import{H as $,E as de}from"../chunks/EditOnGithub.15b2d305.js";function he(Ft){let D,Na,ja,ka,L,za,O,Rt=`AutoTrain is a library that allows you to train state of the art models on Hugging Face Spaces, or locally.
It provides a simple and easy-to-use interface to train models for various tasks like llm finetuning, text classification,
image classification, object detection, and more.`,$a,I,Et="In this quickstart guide, we will show you how to train a model using AutoTrain in Python.",La,S,Oa,J,Ut="AutoTrain can be installed using pip:",Ia,F,Sa,R,Wt="The example code below shows how to finetune an LLM model using AutoTrain in Python:",Ja,E,Fa,U,At=`In this example, we are finetuning the <code>meta-llama/Llama-3.2-1B-Instruct</code> model on the <code>HuggingFaceH4/no_robots</code> dataset.
We are training the model for 3 epochs with a batch size of 1 and a learning rate of <code>1e-5</code>.
We are using the <code>paged_adamw_8bit</code> optimizer and the <code>cosine</code> scheduler.
We are also using mixed precision training with a gradient accumulation of 8.
The final model will be pushed to the Hugging Face Hub after training.`,Ra,W,Ht="To train the model, run the following command:",Ea,A,Ua,H,Qt=`This will create a new project directory with the name <code>autotrain-llama32-1b-finetune</code> and start the training process.
Once the training is complete, the model will be pushed to the Hugging Face Hub.`,Wa,Q,Vt="Your HF_TOKEN and HF_USERNAME are only required if you want to push the model or if you are accessing a gated model or dataset.",Aa,V,Ha,h,B,Dt,ua,Bt="A class to train an AutoTrain project",Pt,G,yt,_a,Gt=`params : Union[
LLMTrainingParams,
TextClassificationParams,
TabularParams,
Seq2SeqParams,
ImageClassificationParams,
TextRegressionParams,
ObjectDetectionParams,
TokenClassificationParams,
SentenceTransformersParams,
ImageRegressionParams,
ExtractiveQuestionAnsweringParams,
VLMTrainingParams,
]
The parameters for the AutoTrain project.
backend : str
The backend to be used for the AutoTrain project. It should be one of the following:`,Tt,da,Zt=`<li>local</li> <li>spaces-a10g-large</li> <li>spaces-a10g-small</li> <li>spaces-a100-large</li> <li>spaces-t4-medium</li> <li>spaces-t4-small</li> <li>spaces-cpu-upgrade</li> <li>spaces-cpu-basic</li> <li>spaces-l4x1</li> <li>spaces-l4x4</li> <li>spaces-l40sx1</li> <li>spaces-l40sx4</li> <li>spaces-l40sx8</li> <li>spaces-a10g-largex2</li> <li>spaces-a10g-largex4
process : bool
Flag to indicate if the params and dataset should be processed. If your data format is not AutoTrain-readable, set it to True. Set it to True when in doubt. Defaults to False.</li>`,wt,Z,Ct,ha,Xt=`<strong>post_init</strong>():
Validates the backend attribute.
create():
Creates a runner based on the backend and initializes the AutoTrain project.`,Qa,X,Va,Y,Ba,P,K,qt,fa,Yt="LLMTrainingParams: Parameters for training a language model using the autotrain library.",Ga,y,aa,jt,xa,Kt="SentenceTransformersParams is a configuration class for setting up parameters for training sentence transformers.",Za,T,ta,Mt,va,ae="Seq2SeqParams is a configuration class for sequence-to-sequence training parameters.",Xa,w,ea,Nt,ba,te="TokenClassificationParams is a configuration class for token classification training parameters.",Ya,C,na,kt,Da,ee="ExtractiveQuestionAnsweringParams",Ka,q,ra,zt,Pa,ne="<code>TextClassificationParams</code> is a configuration class for text classification training parameters.",at,j,sa,$t,ya,re="TextRegressionParams is a configuration class for setting up text regression training parameters.",tt,ia,et,M,oa,Lt,Ta,se="ImageClassificationParams is a configuration class for image classification training parameters.",nt,N,ma,Ot,wa,ie="ImageRegressionParams is a configuration class for image regression training parameters.",rt,k,la,It,Ca,oe="ObjectDetectionParams is a configuration class for object detection training parameters.",st,ca,it,z,pa,St,qa,me="TabularParams is a configuration class for tabular data training parameters.",ot,ga,mt,Ma,lt;return L=new $({props:{title:"Quickstart with Python",local:"quickstart-with-python",headingTag:"h1"}}),S=new $({props:{title:"Getting Started",local:"getting-started",headingTag:"h2"}}),F=new Jt({props:{code:"JTI0JTIwcGlwJTIwaW5zdGFsbCUyMGF1dG90cmFpbi1hZHZhbmNlZA==",highlighted:"$ pip install autotrain-advanced",wrap:!1}}),E=new Jt({props:{code:"aW1wb3J0JTIwb3MlMEElMEFmcm9tJTIwYXV0b3RyYWluLnBhcmFtcyUyMGltcG9ydCUyMExMTVRyYWluaW5nUGFyYW1zJTBBZnJvbSUyMGF1dG90cmFpbi5wcm9qZWN0JTIwaW1wb3J0JTIwQXV0b1RyYWluUHJvamVjdCUwQSUwQSUwQXBhcmFtcyUyMCUzRCUyMExMTVRyYWluaW5nUGFyYW1zKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIybWV0YS1sbGFtYSUyRkxsYW1hLTMuMi0xQi1JbnN0cnVjdCUyMiUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfcGF0aCUzRCUyMkh1Z2dpbmdGYWNlSDQlMkZub19yb2JvdHMlMjIlMkMlMEElMjAlMjAlMjAlMjBjaGF0X3RlbXBsYXRlJTNEJTIydG9rZW5pemVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGV4dF9jb2x1bW4lM0QlMjJtZXNzYWdlcyUyMiUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX3NwbGl0JTNEJTIydHJhaW4lMjIlMkMlMEElMjAlMjAlMjAlMjB0cmFpbmVyJTNEJTIyc2Z0JTIyJTJDJTBBJTIwJTIwJTIwJTIwZXBvY2hzJTNEMyUyQyUwQSUyMCUyMCUyMCUyMGJhdGNoX3NpemUlM0QxJTJDJTBBJTIwJTIwJTIwJTIwbHIlM0QxZS01JTJDJTBBJTIwJTIwJTIwJTIwcGVmdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb24lM0QlMjJpbnQ0JTIyJTJDJTBBJTIwJTIwJTIwJTIwdGFyZ2V0X21vZHVsZXMlM0QlMjJhbGwtbGluZWFyJTIyJTJDJTBBJTIwJTIwJTIwJTIwcGFkZGluZyUzRCUyMnJpZ2h0JTIyJTJDJTBBJTIwJTIwJTIwJTIwb3B0aW1pemVyJTNEJTIycGFnZWRfYWRhbXdfOGJpdCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNjaGVkdWxlciUzRCUyMmNvc2luZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbiUzRDglMkMlMEElMjAlMjAlMjAlMjBtaXhlZF9wcmVjaXNpb24lM0QlMjJiZjE2JTIyJTJDJTBBJTIwJTIwJTIwJTIwbWVyZ2VfYWRhcHRlciUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBwcm9qZWN0X25hbWUlM0QlMjJhdXRvdHJhaW4tbGxhbWEzMi0xYi1maW5ldHVuZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGxvZyUzRCUyMnRlbnNvcmJvYXJkJTIyJTJDJTBBJTIwJTIwJTIwJTIwcHVzaF90b19odWIlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwdXNlcm5hbWUlM0Rvcy5lbnZpcm9uLmdldCglMjJIRl9VU0VSTkFNRSUyMiklMkMlMEElMjAlMjAlMjAlMjB0b2tlbiUzRG9zLmVudmlyb24uZ2V0KCUyMkhGX1RPS0VOJTIyKSUyQyUwQSklMEElMEElMEFiYWNrZW5kJTIwJTNEJTIwJTIybG9jYWwlMjIlMEFwcm9qZWN0JTIwJTNEJTIwQXV0b1RyYWluUHJvamVjdChwYXJhbXMlM0RwYXJhbXMlMkMlMjBiYWNrZW5kJTNEYmFja2VuZCUyQyUyMHByb2Nlc3MlM0RUcnVlKSUwQXByb2plY3QuY3JlYXRlKCk=",highlighted:`<span class="hljs-keyword">import</span> os

<span class="hljs-keyword">from</span> autotrain.params <span class="hljs-keyword">import</span> LLMTrainingParams
<span class="hljs-keyword">from</span> autotrain.project <span class="hljs-keyword">import</span> AutoTrainProject


params = LLMTrainingParams(
    model=<span class="hljs-string">&quot;meta-llama/Llama-3.2-1B-Instruct&quot;</span>,
    data_path=<span class="hljs-string">&quot;HuggingFaceH4/no_robots&quot;</span>,
    chat_template=<span class="hljs-string">&quot;tokenizer&quot;</span>,
    text_column=<span class="hljs-string">&quot;messages&quot;</span>,
    train_split=<span class="hljs-string">&quot;train&quot;</span>,
    trainer=<span class="hljs-string">&quot;sft&quot;</span>,
    epochs=<span class="hljs-number">3</span>,
    batch_size=<span class="hljs-number">1</span>,
    lr=<span class="hljs-number">1e-5</span>,
    peft=<span class="hljs-literal">True</span>,
    quantization=<span class="hljs-string">&quot;int4&quot;</span>,
    target_modules=<span class="hljs-string">&quot;all-linear&quot;</span>,
    padding=<span class="hljs-string">&quot;right&quot;</span>,
    optimizer=<span class="hljs-string">&quot;paged_adamw_8bit&quot;</span>,
    scheduler=<span class="hljs-string">&quot;cosine&quot;</span>,
    gradient_accumulation=<span class="hljs-number">8</span>,
    mixed_precision=<span class="hljs-string">&quot;bf16&quot;</span>,
    merge_adapter=<span class="hljs-literal">True</span>,
    project_name=<span class="hljs-string">&quot;autotrain-llama32-1b-finetune&quot;</span>,
    log=<span class="hljs-string">&quot;tensorboard&quot;</span>,
    push_to_hub=<span class="hljs-literal">True</span>,
    username=os.environ.get(<span class="hljs-string">&quot;HF_USERNAME&quot;</span>),
    token=os.environ.get(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>),
)


backend = <span class="hljs-string">&quot;local&quot;</span>
project = AutoTrainProject(params=params, backend=backend, process=<span class="hljs-literal">True</span>)
project.create()`,wrap:!1}}),A=new Jt({props:{code:"JTI0JTIwZXhwb3J0JTIwSEZfVVNFUk5BTUUlM0QlM0N5b3VyLWhmLXVzZXJuYW1lJTNFJTBBJTI0JTIwZXhwb3J0JTIwSEZfVE9LRU4lM0QlM0N5b3VyLWhmLXdyaXRlLXRva2VuJTNFJTBBJTI0JTIwcHl0aG9uJTIwdHJhaW4ucHk=",highlighted:`$ <span class="hljs-built_in">export</span> HF_USERNAME=&lt;your-hf-username&gt;
$ <span class="hljs-built_in">export</span> HF_TOKEN=&lt;your-hf-write-token&gt;
$ python train.py`,wrap:!1}}),V=new $({props:{title:"AutoTrainProject Class",local:"autotrain.project.AutoTrainProject",headingTag:"h2"}}),B=new b({props:{name:"class autotrain.project.AutoTrainProject",anchor:"autotrain.project.AutoTrainProject",parameters:[{name:"params",val:": typing.Union[autotrain.trainers.clm.params.LLMTrainingParams, autotrain.trainers.text_classification.params.TextClassificationParams, autotrain.trainers.tabular.params.TabularParams, autotrain.trainers.seq2seq.params.Seq2SeqParams, autotrain.trainers.image_classification.params.ImageClassificationParams, autotrain.trainers.text_regression.params.TextRegressionParams, autotrain.trainers.object_detection.params.ObjectDetectionParams, autotrain.trainers.token_classification.params.TokenClassificationParams, autotrain.trainers.sent_transformers.params.SentenceTransformersParams, autotrain.trainers.image_regression.params.ImageRegressionParams, autotrain.trainers.extractive_question_answering.params.ExtractiveQuestionAnsweringParams, autotrain.trainers.vlm.params.VLMTrainingParams]"},{name:"backend",val:": str"},{name:"process",val:": bool = False"}],source:"https://github.com/huggingface/autotrain-advanced/blob/vr_775/src/autotrain/project.py#L443"}}),G=new $({props:{title:"Attributes",local:"attributes",headingTag:"h2"}}),Z=new $({props:{title:"Methods",local:"methods",headingTag:"h2"}}),X=new $({props:{title:"Parameters",local:"parameters",headingTag:"h2"}}),Y=new $({props:{title:"Text Tasks",local:"autotrain.trainers.clm.params.LLMTrainingParams",headingTag:"h3"}}),K=new b({props:{name:"class autotrain.trainers.clm.params.LLMTrainingParams",anchor:"autotrain.trainers.clm.params.LLMTrainingParams",parameters:[{name:"model",val:": str = 'gpt2'"},{name:"project_name",val:": str = 'project-name'"},{name:"data_path",val:": str = 'data'"},{name:"train_split",val:": str = 'train'"},{name:"valid_split",val:": typing.Optional[str] = None"},{name:"add_eos_token",val:": bool = True"},{name:"block_size",val:": typing.Union[int, typing.List[int]] = -1"},{name:"model_max_length",val:": int = 2048"},{name:"padding",val:": typing.Optional[str] = 'right'"},{name:"trainer",val:": str = 'default'"},{name:"use_flash_attention_2",val:": bool = False"},{name:"log",val:": str = 'none'"},{name:"disable_gradient_checkpointing",val:": bool = False"},{name:"logging_steps",val:": int = -1"},{name:"eval_strategy",val:": str = 'epoch'"},{name:"save_total_limit",val:": int = 1"},{name:"auto_find_batch_size",val:": bool = False"},{name:"mixed_precision",val:": typing.Optional[str] = None"},{name:"lr",val:": float = 3e-05"},{name:"epochs",val:": int = 1"},{name:"batch_size",val:": int = 2"},{name:"warmup_ratio",val:": float = 0.1"},{name:"gradient_accumulation",val:": int = 4"},{name:"optimizer",val:": str = 'adamw_torch'"},{name:"scheduler",val:": str = 'linear'"},{name:"weight_decay",val:": float = 0.0"},{name:"max_grad_norm",val:": float = 1.0"},{name:"seed",val:": int = 42"},{name:"chat_template",val:": typing.Optional[str] = None"},{name:"quantization",val:": typing.Optional[str] = 'int4'"},{name:"target_modules",val:": typing.Optional[str] = 'all-linear'"},{name:"merge_adapter",val:": bool = False"},{name:"peft",val:": bool = False"},{name:"lora_r",val:": int = 16"},{name:"lora_alpha",val:": int = 32"},{name:"lora_dropout",val:": float = 0.05"},{name:"model_ref",val:": typing.Optional[str] = None"},{name:"dpo_beta",val:": float = 0.1"},{name:"max_prompt_length",val:": int = 128"},{name:"max_completion_length",val:": typing.Optional[int] = None"},{name:"prompt_text_column",val:": typing.Optional[str] = None"},{name:"text_column",val:": str = 'text'"},{name:"rejected_text_column",val:": typing.Optional[str] = None"},{name:"push_to_hub",val:": bool = False"},{name:"username",val:": typing.Optional[str] = None"},{name:"token",val:": typing.Optional[str] = None"},{name:"unsloth",val:": bool = False"},{name:"distributed_backend",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.model",description:"<strong>model</strong> (str) &#x2014; Model name to be used for training. Default is &#x201C;gpt2&#x201D;.",name:"model"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.project_name",description:"<strong>project_name</strong> (str) &#x2014; Name of the project and output directory. Default is &#x201C;project-name&#x201D;.",name:"project_name"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.data_path",description:"<strong>data_path</strong> (str) &#x2014; Path to the dataset. Default is &#x201C;data&#x201D;.",name:"data_path"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.train_split",description:"<strong>train_split</strong> (str) &#x2014; Configuration for the training data split. Default is &#x201C;train&#x201D;.",name:"train_split"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.valid_split",description:"<strong>valid_split</strong> (Optional[str]) &#x2014; Configuration for the validation data split. Default is None.",name:"valid_split"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.add_eos_token",description:"<strong>add_eos_token</strong> (bool) &#x2014; Whether to add an EOS token at the end of sequences. Default is True.",name:"add_eos_token"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.block_size",description:"<strong>block_size</strong> (Union[int, List[int]]) &#x2014; Size of the blocks for training, can be a single integer or a list of integers. Default is -1.",name:"block_size"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.model_max_length",description:"<strong>model_max_length</strong> (int) &#x2014; Maximum length of the model input. Default is 2048.",name:"model_max_length"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.padding",description:"<strong>padding</strong> (Optional[str]) &#x2014; Side on which to pad sequences (left or right). Default is &#x201C;right&#x201D;.",name:"padding"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.trainer",description:"<strong>trainer</strong> (str) &#x2014; Type of trainer to use. Default is &#x201C;default&#x201D;.",name:"trainer"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.use_flash_attention_2",description:"<strong>use_flash_attention_2</strong> (bool) &#x2014; Whether to use flash attention version 2. Default is False.",name:"use_flash_attention_2"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.log",description:"<strong>log</strong> (str) &#x2014; Logging method for experiment tracking. Default is &#x201C;none&#x201D;.",name:"log"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.disable_gradient_checkpointing",description:"<strong>disable_gradient_checkpointing</strong> (bool) &#x2014; Whether to disable gradient checkpointing. Default is False.",name:"disable_gradient_checkpointing"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.logging_steps",description:"<strong>logging_steps</strong> (int) &#x2014; Number of steps between logging events. Default is -1.",name:"logging_steps"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.eval_strategy",description:"<strong>eval_strategy</strong> (str) &#x2014; Strategy for evaluation (e.g., &#x2018;epoch&#x2019;). Default is &#x201C;epoch&#x201D;.",name:"eval_strategy"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.save_total_limit",description:"<strong>save_total_limit</strong> (int) &#x2014; Maximum number of checkpoints to keep. Default is 1.",name:"save_total_limit"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.auto_find_batch_size",description:"<strong>auto_find_batch_size</strong> (bool) &#x2014; Whether to automatically find the optimal batch size. Default is False.",name:"auto_find_batch_size"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.mixed_precision",description:"<strong>mixed_precision</strong> (Optional[str]) &#x2014; Type of mixed precision to use (e.g., &#x2018;fp16&#x2019;, &#x2018;bf16&#x2019;, or None). Default is None.",name:"mixed_precision"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.lr",description:"<strong>lr</strong> (float) &#x2014; Learning rate for training. Default is 3e-5.",name:"lr"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.epochs",description:"<strong>epochs</strong> (int) &#x2014; Number of training epochs. Default is 1.",name:"epochs"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.batch_size",description:"<strong>batch_size</strong> (int) &#x2014; Batch size for training. Default is 2.",name:"batch_size"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.warmup_ratio",description:"<strong>warmup_ratio</strong> (float) &#x2014; Proportion of training to perform learning rate warmup. Default is 0.1.",name:"warmup_ratio"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.gradient_accumulation",description:"<strong>gradient_accumulation</strong> (int) &#x2014; Number of steps to accumulate gradients before updating. Default is 4.",name:"gradient_accumulation"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.optimizer",description:"<strong>optimizer</strong> (str) &#x2014; Optimizer to use for training. Default is &#x201C;adamw_torch&#x201D;.",name:"optimizer"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.scheduler",description:"<strong>scheduler</strong> (str) &#x2014; Learning rate scheduler to use. Default is &#x201C;linear&#x201D;.",name:"scheduler"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.weight_decay",description:"<strong>weight_decay</strong> (float) &#x2014; Weight decay to apply to the optimizer. Default is 0.0.",name:"weight_decay"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.max_grad_norm",description:"<strong>max_grad_norm</strong> (float) &#x2014; Maximum norm for gradient clipping. Default is 1.0.",name:"max_grad_norm"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.seed",description:"<strong>seed</strong> (int) &#x2014; Random seed for reproducibility. Default is 42.",name:"seed"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.chat_template",description:"<strong>chat_template</strong> (Optional[str]) &#x2014; Template for chat-based models, options include: None, zephyr, chatml, or tokenizer. Default is None.",name:"chat_template"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.quantization",description:"<strong>quantization</strong> (Optional[str]) &#x2014; Quantization method to use (e.g., &#x2018;int4&#x2019;, &#x2018;int8&#x2019;, or None). Default is &#x201C;int4&#x201D;.",name:"quantization"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.target_modules",description:"<strong>target_modules</strong> (Optional[str]) &#x2014; Target modules for quantization or fine-tuning. Default is &#x201C;all-linear&#x201D;.",name:"target_modules"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.merge_adapter",description:"<strong>merge_adapter</strong> (bool) &#x2014; Whether to merge the adapter layers. Default is False.",name:"merge_adapter"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.peft",description:"<strong>peft</strong> (bool) &#x2014; Whether to use Parameter-Efficient Fine-Tuning (PEFT). Default is False.",name:"peft"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.lora_r",description:"<strong>lora_r</strong> (int) &#x2014; Rank of the LoRA matrices. Default is 16.",name:"lora_r"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.lora_alpha",description:"<strong>lora_alpha</strong> (int) &#x2014; Alpha parameter for LoRA. Default is 32.",name:"lora_alpha"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.lora_dropout",description:"<strong>lora_dropout</strong> (float) &#x2014; Dropout rate for LoRA. Default is 0.05.",name:"lora_dropout"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.model_ref",description:"<strong>model_ref</strong> (Optional[str]) &#x2014; Reference model for DPO trainer. Default is None.",name:"model_ref"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.dpo_beta",description:"<strong>dpo_beta</strong> (float) &#x2014; Beta parameter for DPO trainer. Default is 0.1.",name:"dpo_beta"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.max_prompt_length",description:"<strong>max_prompt_length</strong> (int) &#x2014; Maximum length of the prompt. Default is 128.",name:"max_prompt_length"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.max_completion_length",description:"<strong>max_completion_length</strong> (Optional[int]) &#x2014; Maximum length of the completion. Default is None.",name:"max_completion_length"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.prompt_text_column",description:"<strong>prompt_text_column</strong> (Optional[str]) &#x2014; Column name for the prompt text. Default is None.",name:"prompt_text_column"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.text_column",description:"<strong>text_column</strong> (str) &#x2014; Column name for the text data. Default is &#x201C;text&#x201D;.",name:"text_column"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.rejected_text_column",description:"<strong>rejected_text_column</strong> (Optional[str]) &#x2014; Column name for the rejected text data. Default is None.",name:"rejected_text_column"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.push_to_hub",description:"<strong>push_to_hub</strong> (bool) &#x2014; Whether to push the model to the Hugging Face Hub. Default is False.",name:"push_to_hub"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.username",description:"<strong>username</strong> (Optional[str]) &#x2014; Hugging Face username for authentication. Default is None.",name:"username"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.token",description:"<strong>token</strong> (Optional[str]) &#x2014; Hugging Face token for authentication. Default is None.",name:"token"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.unsloth",description:"<strong>unsloth</strong> (bool) &#x2014; Whether to use the unsloth library. Default is False.",name:"unsloth"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.distributed_backend",description:"<strong>distributed_backend</strong> (Optional[str]) &#x2014; Backend to use for distributed training. Default is None.",name:"distributed_backend"}],source:"https://github.com/huggingface/autotrain-advanced/blob/vr_775/src/autotrain/trainers/clm/params.py#L8"}}),aa=new b({props:{name:"class autotrain.trainers.sent_transformers.params.SentenceTransformersParams",anchor:"autotrain.trainers.sent_transformers.params.SentenceTransformersParams",parameters:[{name:"data_path",val:": str = None"},{name:"model",val:": str = 'microsoft/mpnet-base'"},{name:"lr",val:": float = 3e-05"},{name:"epochs",val:": int = 3"},{name:"max_seq_length",val:": int = 128"},{name:"batch_size",val:": int = 8"},{name:"warmup_ratio",val:": float = 0.1"},{name:"gradient_accumulation",val:": int = 1"},{name:"optimizer",val:": str = 'adamw_torch'"},{name:"scheduler",val:": str = 'linear'"},{name:"weight_decay",val:": float = 0.0"},{name:"max_grad_norm",val:": float = 1.0"},{name:"seed",val:": int = 42"},{name:"train_split",val:": str = 'train'"},{name:"valid_split",val:": typing.Optional[str] = None"},{name:"logging_steps",val:": int = -1"},{name:"project_name",val:": str = 'project-name'"},{name:"auto_find_batch_size",val:": bool = False"},{name:"mixed_precision",val:": typing.Optional[str] = None"},{name:"save_total_limit",val:": int = 1"},{name:"token",val:": typing.Optional[str] = None"},{name:"push_to_hub",val:": bool = False"},{name:"eval_strategy",val:": str = 'epoch'"},{name:"username",val:": typing.Optional[str] = None"},{name:"log",val:": str = 'none'"},{name:"early_stopping_patience",val:": int = 5"},{name:"early_stopping_threshold",val:": float = 0.01"},{name:"trainer",val:": str = 'pair_score'"},{name:"sentence1_column",val:": str = 'sentence1'"},{name:"sentence2_column",val:": str = 'sentence2'"},{name:"sentence3_column",val:": typing.Optional[str] = None"},{name:"target_column",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"autotrain.trainers.sent_transformers.params.SentenceTransformersParams.data_path",description:"<strong>data_path</strong> (str) &#x2014; Path to the dataset.",name:"data_path"},{anchor:"autotrain.trainers.sent_transformers.params.SentenceTransformersParams.model",description:"<strong>model</strong> (str) &#x2014; Name of the pre-trained model to use. Default is &#x201C;microsoft/mpnet-base&#x201D;.",name:"model"},{anchor:"autotrain.trainers.sent_transformers.params.SentenceTransformersParams.lr",description:"<strong>lr</strong> (float) &#x2014; Learning rate for training. Default is 3e-5.",name:"lr"},{anchor:"autotrain.trainers.sent_transformers.params.SentenceTransformersParams.epochs",description:"<strong>epochs</strong> (int) &#x2014; Number of training epochs. Default is 3.",name:"epochs"},{anchor:"autotrain.trainers.sent_transformers.params.SentenceTransformersParams.max_seq_length",description:"<strong>max_seq_length</strong> (int) &#x2014; Maximum sequence length for the input. Default is 128.",name:"max_seq_length"},{anchor:"autotrain.trainers.sent_transformers.params.SentenceTransformersParams.batch_size",description:"<strong>batch_size</strong> (int) &#x2014; Batch size for training. Default is 8.",name:"batch_size"},{anchor:"autotrain.trainers.sent_transformers.params.SentenceTransformersParams.warmup_ratio",description:"<strong>warmup_ratio</strong> (float) &#x2014; Proportion of training to perform learning rate warmup. Default is 0.1.",name:"warmup_ratio"},{anchor:"autotrain.trainers.sent_transformers.params.SentenceTransformersParams.gradient_accumulation",description:"<strong>gradient_accumulation</strong> (int) &#x2014; Number of steps to accumulate gradients before updating. Default is 1.",name:"gradient_accumulation"},{anchor:"autotrain.trainers.sent_transformers.params.SentenceTransformersParams.optimizer",description:"<strong>optimizer</strong> (str) &#x2014; Optimizer to use. Default is &#x201C;adamw_torch&#x201D;.",name:"optimizer"},{anchor:"autotrain.trainers.sent_transformers.params.SentenceTransformersParams.scheduler",description:"<strong>scheduler</strong> (str) &#x2014; Learning rate scheduler to use. Default is &#x201C;linear&#x201D;.",name:"scheduler"},{anchor:"autotrain.trainers.sent_transformers.params.SentenceTransformersParams.weight_decay",description:"<strong>weight_decay</strong> (float) &#x2014; Weight decay to apply. Default is 0.0.",name:"weight_decay"},{anchor:"autotrain.trainers.sent_transformers.params.SentenceTransformersParams.max_grad_norm",description:"<strong>max_grad_norm</strong> (float) &#x2014; Maximum gradient norm for clipping. Default is 1.0.",name:"max_grad_norm"},{anchor:"autotrain.trainers.sent_transformers.params.SentenceTransformersParams.seed",description:"<strong>seed</strong> (int) &#x2014; Random seed for reproducibility. Default is 42.",name:"seed"},{anchor:"autotrain.trainers.sent_transformers.params.SentenceTransformersParams.train_split",description:"<strong>train_split</strong> (str) &#x2014; Name of the training data split. Default is &#x201C;train&#x201D;.",name:"train_split"},{anchor:"autotrain.trainers.sent_transformers.params.SentenceTransformersParams.valid_split",description:"<strong>valid_split</strong> (Optional[str]) &#x2014; Name of the validation data split. Default is None.",name:"valid_split"},{anchor:"autotrain.trainers.sent_transformers.params.SentenceTransformersParams.logging_steps",description:"<strong>logging_steps</strong> (int) &#x2014; Number of steps between logging. Default is -1.",name:"logging_steps"},{anchor:"autotrain.trainers.sent_transformers.params.SentenceTransformersParams.project_name",description:"<strong>project_name</strong> (str) &#x2014; Name of the project for output directory. Default is &#x201C;project-name&#x201D;.",name:"project_name"},{anchor:"autotrain.trainers.sent_transformers.params.SentenceTransformersParams.auto_find_batch_size",description:"<strong>auto_find_batch_size</strong> (bool) &#x2014; Whether to automatically find the optimal batch size. Default is False.",name:"auto_find_batch_size"},{anchor:"autotrain.trainers.sent_transformers.params.SentenceTransformersParams.mixed_precision",description:"<strong>mixed_precision</strong> (Optional[str]) &#x2014; Mixed precision training mode (fp16, bf16, or None). Default is None.",name:"mixed_precision"},{anchor:"autotrain.trainers.sent_transformers.params.SentenceTransformersParams.save_total_limit",description:"<strong>save_total_limit</strong> (int) &#x2014; Maximum number of checkpoints to save. Default is 1.",name:"save_total_limit"},{anchor:"autotrain.trainers.sent_transformers.params.SentenceTransformersParams.token",description:"<strong>token</strong> (Optional[str]) &#x2014; Token for accessing Hugging Face Hub. Default is None.",name:"token"},{anchor:"autotrain.trainers.sent_transformers.params.SentenceTransformersParams.push_to_hub",description:"<strong>push_to_hub</strong> (bool) &#x2014; Whether to push the model to Hugging Face Hub. Default is False.",name:"push_to_hub"},{anchor:"autotrain.trainers.sent_transformers.params.SentenceTransformersParams.eval_strategy",description:"<strong>eval_strategy</strong> (str) &#x2014; Evaluation strategy to use. Default is &#x201C;epoch&#x201D;.",name:"eval_strategy"},{anchor:"autotrain.trainers.sent_transformers.params.SentenceTransformersParams.username",description:"<strong>username</strong> (Optional[str]) &#x2014; Hugging Face username. Default is None.",name:"username"},{anchor:"autotrain.trainers.sent_transformers.params.SentenceTransformersParams.log",description:"<strong>log</strong> (str) &#x2014; Logging method for experiment tracking. Default is &#x201C;none&#x201D;.",name:"log"},{anchor:"autotrain.trainers.sent_transformers.params.SentenceTransformersParams.early_stopping_patience",description:"<strong>early_stopping_patience</strong> (int) &#x2014; Number of epochs with no improvement after which training will be stopped. Default is 5.",name:"early_stopping_patience"},{anchor:"autotrain.trainers.sent_transformers.params.SentenceTransformersParams.early_stopping_threshold",description:"<strong>early_stopping_threshold</strong> (float) &#x2014; Threshold for measuring the new optimum, to qualify as an improvement. Default is 0.01.",name:"early_stopping_threshold"},{anchor:"autotrain.trainers.sent_transformers.params.SentenceTransformersParams.trainer",description:"<strong>trainer</strong> (str) &#x2014; Name of the trainer to use. Default is &#x201C;pair_score&#x201D;.",name:"trainer"},{anchor:"autotrain.trainers.sent_transformers.params.SentenceTransformersParams.sentence1_column",description:"<strong>sentence1_column</strong> (str) &#x2014; Name of the column containing the first sentence. Default is &#x201C;sentence1&#x201D;.",name:"sentence1_column"},{anchor:"autotrain.trainers.sent_transformers.params.SentenceTransformersParams.sentence2_column",description:"<strong>sentence2_column</strong> (str) &#x2014; Name of the column containing the second sentence. Default is &#x201C;sentence2&#x201D;.",name:"sentence2_column"},{anchor:"autotrain.trainers.sent_transformers.params.SentenceTransformersParams.sentence3_column",description:"<strong>sentence3_column</strong> (Optional[str]) &#x2014; Name of the column containing the third sentence (if applicable). Default is None.",name:"sentence3_column"},{anchor:"autotrain.trainers.sent_transformers.params.SentenceTransformersParams.target_column",description:"<strong>target_column</strong> (Optional[str]) &#x2014; Name of the column containing the target variable. Default is None.",name:"target_column"}],source:"https://github.com/huggingface/autotrain-advanced/blob/vr_775/src/autotrain/trainers/sent_transformers/params.py#L8"}}),ta=new b({props:{name:"class autotrain.trainers.seq2seq.params.Seq2SeqParams",anchor:"autotrain.trainers.seq2seq.params.Seq2SeqParams",parameters:[{name:"data_path",val:": str = None"},{name:"model",val:": str = 'google/flan-t5-base'"},{name:"username",val:": typing.Optional[str] = None"},{name:"seed",val:": int = 42"},{name:"train_split",val:": str = 'train'"},{name:"valid_split",val:": typing.Optional[str] = None"},{name:"project_name",val:": str = 'project-name'"},{name:"token",val:": typing.Optional[str] = None"},{name:"push_to_hub",val:": bool = False"},{name:"text_column",val:": str = 'text'"},{name:"target_column",val:": str = 'target'"},{name:"lr",val:": float = 5e-05"},{name:"epochs",val:": int = 3"},{name:"max_seq_length",val:": int = 128"},{name:"max_target_length",val:": int = 128"},{name:"batch_size",val:": int = 2"},{name:"warmup_ratio",val:": float = 0.1"},{name:"gradient_accumulation",val:": int = 1"},{name:"optimizer",val:": str = 'adamw_torch'"},{name:"scheduler",val:": str = 'linear'"},{name:"weight_decay",val:": float = 0.0"},{name:"max_grad_norm",val:": float = 1.0"},{name:"logging_steps",val:": int = -1"},{name:"eval_strategy",val:": str = 'epoch'"},{name:"auto_find_batch_size",val:": bool = False"},{name:"mixed_precision",val:": typing.Optional[str] = None"},{name:"save_total_limit",val:": int = 1"},{name:"peft",val:": bool = False"},{name:"quantization",val:": typing.Optional[str] = 'int8'"},{name:"lora_r",val:": int = 16"},{name:"lora_alpha",val:": int = 32"},{name:"lora_dropout",val:": float = 0.05"},{name:"target_modules",val:": str = 'all-linear'"},{name:"log",val:": str = 'none'"},{name:"early_stopping_patience",val:": int = 5"},{name:"early_stopping_threshold",val:": float = 0.01"}],parametersDescription:[{anchor:"autotrain.trainers.seq2seq.params.Seq2SeqParams.data_path",description:"<strong>data_path</strong> (str) &#x2014; Path to the dataset.",name:"data_path"},{anchor:"autotrain.trainers.seq2seq.params.Seq2SeqParams.model",description:"<strong>model</strong> (str) &#x2014; Name of the model to be used. Default is &#x201C;google/flan-t5-base&#x201D;.",name:"model"},{anchor:"autotrain.trainers.seq2seq.params.Seq2SeqParams.username",description:"<strong>username</strong> (Optional[str]) &#x2014; Hugging Face Username.",name:"username"},{anchor:"autotrain.trainers.seq2seq.params.Seq2SeqParams.seed",description:"<strong>seed</strong> (int) &#x2014; Random seed for reproducibility. Default is 42.",name:"seed"},{anchor:"autotrain.trainers.seq2seq.params.Seq2SeqParams.train_split",description:"<strong>train_split</strong> (str) &#x2014; Name of the training data split. Default is &#x201C;train&#x201D;.",name:"train_split"},{anchor:"autotrain.trainers.seq2seq.params.Seq2SeqParams.valid_split",description:"<strong>valid_split</strong> (Optional[str]) &#x2014; Name of the validation data split.",name:"valid_split"},{anchor:"autotrain.trainers.seq2seq.params.Seq2SeqParams.project_name",description:"<strong>project_name</strong> (str) &#x2014; Name of the project or output directory. Default is &#x201C;project-name&#x201D;.",name:"project_name"},{anchor:"autotrain.trainers.seq2seq.params.Seq2SeqParams.token",description:"<strong>token</strong> (Optional[str]) &#x2014; Hub Token for authentication.",name:"token"},{anchor:"autotrain.trainers.seq2seq.params.Seq2SeqParams.push_to_hub",description:"<strong>push_to_hub</strong> (bool) &#x2014; Whether to push the model to the Hugging Face Hub. Default is False.",name:"push_to_hub"},{anchor:"autotrain.trainers.seq2seq.params.Seq2SeqParams.text_column",description:"<strong>text_column</strong> (str) &#x2014; Name of the text column in the dataset. Default is &#x201C;text&#x201D;.",name:"text_column"},{anchor:"autotrain.trainers.seq2seq.params.Seq2SeqParams.target_column",description:"<strong>target_column</strong> (str) &#x2014; Name of the target text column in the dataset. Default is &#x201C;target&#x201D;.",name:"target_column"},{anchor:"autotrain.trainers.seq2seq.params.Seq2SeqParams.lr",description:"<strong>lr</strong> (float) &#x2014; Learning rate for training. Default is 5e-5.",name:"lr"},{anchor:"autotrain.trainers.seq2seq.params.Seq2SeqParams.epochs",description:"<strong>epochs</strong> (int) &#x2014; Number of training epochs. Default is 3.",name:"epochs"},{anchor:"autotrain.trainers.seq2seq.params.Seq2SeqParams.max_seq_length",description:"<strong>max_seq_length</strong> (int) &#x2014; Maximum sequence length for input text. Default is 128.",name:"max_seq_length"},{anchor:"autotrain.trainers.seq2seq.params.Seq2SeqParams.max_target_length",description:"<strong>max_target_length</strong> (int) &#x2014; Maximum sequence length for target text. Default is 128.",name:"max_target_length"},{anchor:"autotrain.trainers.seq2seq.params.Seq2SeqParams.batch_size",description:"<strong>batch_size</strong> (int) &#x2014; Training batch size. Default is 2.",name:"batch_size"},{anchor:"autotrain.trainers.seq2seq.params.Seq2SeqParams.warmup_ratio",description:"<strong>warmup_ratio</strong> (float) &#x2014; Proportion of warmup steps. Default is 0.1.",name:"warmup_ratio"},{anchor:"autotrain.trainers.seq2seq.params.Seq2SeqParams.gradient_accumulation",description:"<strong>gradient_accumulation</strong> (int) &#x2014; Number of gradient accumulation steps. Default is 1.",name:"gradient_accumulation"},{anchor:"autotrain.trainers.seq2seq.params.Seq2SeqParams.optimizer",description:"<strong>optimizer</strong> (str) &#x2014; Optimizer to be used. Default is &#x201C;adamw_torch&#x201D;.",name:"optimizer"},{anchor:"autotrain.trainers.seq2seq.params.Seq2SeqParams.scheduler",description:"<strong>scheduler</strong> (str) &#x2014; Learning rate scheduler to be used. Default is &#x201C;linear&#x201D;.",name:"scheduler"},{anchor:"autotrain.trainers.seq2seq.params.Seq2SeqParams.weight_decay",description:"<strong>weight_decay</strong> (float) &#x2014; Weight decay for the optimizer. Default is 0.0.",name:"weight_decay"},{anchor:"autotrain.trainers.seq2seq.params.Seq2SeqParams.max_grad_norm",description:"<strong>max_grad_norm</strong> (float) &#x2014; Maximum gradient norm for clipping. Default is 1.0.",name:"max_grad_norm"},{anchor:"autotrain.trainers.seq2seq.params.Seq2SeqParams.logging_steps",description:"<strong>logging_steps</strong> (int) &#x2014; Number of steps between logging. Default is -1 (disabled).",name:"logging_steps"},{anchor:"autotrain.trainers.seq2seq.params.Seq2SeqParams.eval_strategy",description:"<strong>eval_strategy</strong> (str) &#x2014; Evaluation strategy. Default is &#x201C;epoch&#x201D;.",name:"eval_strategy"},{anchor:"autotrain.trainers.seq2seq.params.Seq2SeqParams.auto_find_batch_size",description:"<strong>auto_find_batch_size</strong> (bool) &#x2014; Whether to automatically find the batch size. Default is False.",name:"auto_find_batch_size"},{anchor:"autotrain.trainers.seq2seq.params.Seq2SeqParams.mixed_precision",description:"<strong>mixed_precision</strong> (Optional[str]) &#x2014; Mixed precision training mode (fp16, bf16, or None).",name:"mixed_precision"},{anchor:"autotrain.trainers.seq2seq.params.Seq2SeqParams.save_total_limit",description:"<strong>save_total_limit</strong> (int) &#x2014; Maximum number of checkpoints to save. Default is 1.",name:"save_total_limit"},{anchor:"autotrain.trainers.seq2seq.params.Seq2SeqParams.peft",description:"<strong>peft</strong> (bool) &#x2014; Whether to use Parameter-Efficient Fine-Tuning (PEFT). Default is False.",name:"peft"},{anchor:"autotrain.trainers.seq2seq.params.Seq2SeqParams.quantization",description:"<strong>quantization</strong> (Optional[str]) &#x2014; Quantization mode (int4, int8, or None). Default is &#x201C;int8&#x201D;.",name:"quantization"},{anchor:"autotrain.trainers.seq2seq.params.Seq2SeqParams.lora_r",description:"<strong>lora_r</strong> (int) &#x2014; LoRA-R parameter for PEFT. Default is 16.",name:"lora_r"},{anchor:"autotrain.trainers.seq2seq.params.Seq2SeqParams.lora_alpha",description:"<strong>lora_alpha</strong> (int) &#x2014; LoRA-Alpha parameter for PEFT. Default is 32.",name:"lora_alpha"},{anchor:"autotrain.trainers.seq2seq.params.Seq2SeqParams.lora_dropout",description:"<strong>lora_dropout</strong> (float) &#x2014; LoRA-Dropout parameter for PEFT. Default is 0.05.",name:"lora_dropout"},{anchor:"autotrain.trainers.seq2seq.params.Seq2SeqParams.target_modules",description:"<strong>target_modules</strong> (str) &#x2014; Target modules for PEFT. Default is &#x201C;all-linear&#x201D;.",name:"target_modules"},{anchor:"autotrain.trainers.seq2seq.params.Seq2SeqParams.log",description:"<strong>log</strong> (str) &#x2014; Logging method for experiment tracking. Default is &#x201C;none&#x201D;.",name:"log"},{anchor:"autotrain.trainers.seq2seq.params.Seq2SeqParams.early_stopping_patience",description:"<strong>early_stopping_patience</strong> (int) &#x2014; Patience for early stopping. Default is 5.",name:"early_stopping_patience"},{anchor:"autotrain.trainers.seq2seq.params.Seq2SeqParams.early_stopping_threshold",description:"<strong>early_stopping_threshold</strong> (float) &#x2014; Threshold for early stopping. Default is 0.01.",name:"early_stopping_threshold"}],source:"https://github.com/huggingface/autotrain-advanced/blob/vr_775/src/autotrain/trainers/seq2seq/params.py#L8"}}),ea=new b({props:{name:"class autotrain.trainers.token_classification.params.TokenClassificationParams",anchor:"autotrain.trainers.token_classification.params.TokenClassificationParams",parameters:[{name:"data_path",val:": str = None"},{name:"model",val:": str = 'bert-base-uncased'"},{name:"lr",val:": float = 5e-05"},{name:"epochs",val:": int = 3"},{name:"max_seq_length",val:": int = 128"},{name:"batch_size",val:": int = 8"},{name:"warmup_ratio",val:": float = 0.1"},{name:"gradient_accumulation",val:": int = 1"},{name:"optimizer",val:": str = 'adamw_torch'"},{name:"scheduler",val:": str = 'linear'"},{name:"weight_decay",val:": float = 0.0"},{name:"max_grad_norm",val:": float = 1.0"},{name:"seed",val:": int = 42"},{name:"train_split",val:": str = 'train'"},{name:"valid_split",val:": typing.Optional[str] = None"},{name:"tokens_column",val:": str = 'tokens'"},{name:"tags_column",val:": str = 'tags'"},{name:"logging_steps",val:": int = -1"},{name:"project_name",val:": str = 'project-name'"},{name:"auto_find_batch_size",val:": bool = False"},{name:"mixed_precision",val:": typing.Optional[str] = None"},{name:"save_total_limit",val:": int = 1"},{name:"token",val:": typing.Optional[str] = None"},{name:"push_to_hub",val:": bool = False"},{name:"eval_strategy",val:": str = 'epoch'"},{name:"username",val:": typing.Optional[str] = None"},{name:"log",val:": str = 'none'"},{name:"early_stopping_patience",val:": int = 5"},{name:"early_stopping_threshold",val:": float = 0.01"}],parametersDescription:[{anchor:"autotrain.trainers.token_classification.params.TokenClassificationParams.data_path",description:"<strong>data_path</strong> (str) &#x2014; Path to the dataset.",name:"data_path"},{anchor:"autotrain.trainers.token_classification.params.TokenClassificationParams.model",description:"<strong>model</strong> (str) &#x2014; Name of the model to use. Default is &#x201C;bert-base-uncased&#x201D;.",name:"model"},{anchor:"autotrain.trainers.token_classification.params.TokenClassificationParams.lr",description:"<strong>lr</strong> (float) &#x2014; Learning rate. Default is 5e-5.",name:"lr"},{anchor:"autotrain.trainers.token_classification.params.TokenClassificationParams.epochs",description:"<strong>epochs</strong> (int) &#x2014; Number of training epochs. Default is 3.",name:"epochs"},{anchor:"autotrain.trainers.token_classification.params.TokenClassificationParams.max_seq_length",description:"<strong>max_seq_length</strong> (int) &#x2014; Maximum sequence length. Default is 128.",name:"max_seq_length"},{anchor:"autotrain.trainers.token_classification.params.TokenClassificationParams.batch_size",description:"<strong>batch_size</strong> (int) &#x2014; Training batch size. Default is 8.",name:"batch_size"},{anchor:"autotrain.trainers.token_classification.params.TokenClassificationParams.warmup_ratio",description:"<strong>warmup_ratio</strong> (float) &#x2014; Warmup proportion. Default is 0.1.",name:"warmup_ratio"},{anchor:"autotrain.trainers.token_classification.params.TokenClassificationParams.gradient_accumulation",description:"<strong>gradient_accumulation</strong> (int) &#x2014; Gradient accumulation steps. Default is 1.",name:"gradient_accumulation"},{anchor:"autotrain.trainers.token_classification.params.TokenClassificationParams.optimizer",description:"<strong>optimizer</strong> (str) &#x2014; Optimizer to use. Default is &#x201C;adamw_torch&#x201D;.",name:"optimizer"},{anchor:"autotrain.trainers.token_classification.params.TokenClassificationParams.scheduler",description:"<strong>scheduler</strong> (str) &#x2014; Scheduler to use. Default is &#x201C;linear&#x201D;.",name:"scheduler"},{anchor:"autotrain.trainers.token_classification.params.TokenClassificationParams.weight_decay",description:"<strong>weight_decay</strong> (float) &#x2014; Weight decay. Default is 0.0.",name:"weight_decay"},{anchor:"autotrain.trainers.token_classification.params.TokenClassificationParams.max_grad_norm",description:"<strong>max_grad_norm</strong> (float) &#x2014; Maximum gradient norm. Default is 1.0.",name:"max_grad_norm"},{anchor:"autotrain.trainers.token_classification.params.TokenClassificationParams.seed",description:"<strong>seed</strong> (int) &#x2014; Random seed. Default is 42.",name:"seed"},{anchor:"autotrain.trainers.token_classification.params.TokenClassificationParams.train_split",description:"<strong>train_split</strong> (str) &#x2014; Name of the training split. Default is &#x201C;train&#x201D;.",name:"train_split"},{anchor:"autotrain.trainers.token_classification.params.TokenClassificationParams.valid_split",description:"<strong>valid_split</strong> (Optional[str]) &#x2014; Name of the validation split. Default is None.",name:"valid_split"},{anchor:"autotrain.trainers.token_classification.params.TokenClassificationParams.tokens_column",description:"<strong>tokens_column</strong> (str) &#x2014; Name of the tokens column. Default is &#x201C;tokens&#x201D;.",name:"tokens_column"},{anchor:"autotrain.trainers.token_classification.params.TokenClassificationParams.tags_column",description:"<strong>tags_column</strong> (str) &#x2014; Name of the tags column. Default is &#x201C;tags&#x201D;.",name:"tags_column"},{anchor:"autotrain.trainers.token_classification.params.TokenClassificationParams.logging_steps",description:"<strong>logging_steps</strong> (int) &#x2014; Number of steps between logging. Default is -1.",name:"logging_steps"},{anchor:"autotrain.trainers.token_classification.params.TokenClassificationParams.project_name",description:"<strong>project_name</strong> (str) &#x2014; Name of the project. Default is &#x201C;project-name&#x201D;.",name:"project_name"},{anchor:"autotrain.trainers.token_classification.params.TokenClassificationParams.auto_find_batch_size",description:"<strong>auto_find_batch_size</strong> (bool) &#x2014; Whether to automatically find the batch size. Default is False.",name:"auto_find_batch_size"},{anchor:"autotrain.trainers.token_classification.params.TokenClassificationParams.mixed_precision",description:"<strong>mixed_precision</strong> (Optional[str]) &#x2014; Mixed precision setting (fp16, bf16, or None). Default is None.",name:"mixed_precision"},{anchor:"autotrain.trainers.token_classification.params.TokenClassificationParams.save_total_limit",description:"<strong>save_total_limit</strong> (int) &#x2014; Total number of checkpoints to save. Default is 1.",name:"save_total_limit"},{anchor:"autotrain.trainers.token_classification.params.TokenClassificationParams.token",description:"<strong>token</strong> (Optional[str]) &#x2014; Hub token for authentication. Default is None.",name:"token"},{anchor:"autotrain.trainers.token_classification.params.TokenClassificationParams.push_to_hub",description:"<strong>push_to_hub</strong> (bool) &#x2014; Whether to push the model to the Hugging Face hub. Default is False.",name:"push_to_hub"},{anchor:"autotrain.trainers.token_classification.params.TokenClassificationParams.eval_strategy",description:"<strong>eval_strategy</strong> (str) &#x2014; Evaluation strategy. Default is &#x201C;epoch&#x201D;.",name:"eval_strategy"},{anchor:"autotrain.trainers.token_classification.params.TokenClassificationParams.username",description:"<strong>username</strong> (Optional[str]) &#x2014; Hugging Face username. Default is None.",name:"username"},{anchor:"autotrain.trainers.token_classification.params.TokenClassificationParams.log",description:"<strong>log</strong> (str) &#x2014; Logging method for experiment tracking. Default is &#x201C;none&#x201D;.",name:"log"},{anchor:"autotrain.trainers.token_classification.params.TokenClassificationParams.early_stopping_patience",description:"<strong>early_stopping_patience</strong> (int) &#x2014; Patience for early stopping. Default is 5.",name:"early_stopping_patience"},{anchor:"autotrain.trainers.token_classification.params.TokenClassificationParams.early_stopping_threshold",description:"<strong>early_stopping_threshold</strong> (float) &#x2014; Threshold for early stopping. Default is 0.01.",name:"early_stopping_threshold"}],source:"https://github.com/huggingface/autotrain-advanced/blob/vr_775/src/autotrain/trainers/token_classification/params.py#L8"}}),na=new b({props:{name:"class autotrain.trainers.extractive_question_answering.params.ExtractiveQuestionAnsweringParams",anchor:"autotrain.trainers.extractive_question_answering.params.ExtractiveQuestionAnsweringParams",parameters:[{name:"data_path",val:": str = None"},{name:"model",val:": str = 'bert-base-uncased'"},{name:"lr",val:": float = 5e-05"},{name:"epochs",val:": int = 3"},{name:"max_seq_length",val:": int = 128"},{name:"max_doc_stride",val:": int = 128"},{name:"batch_size",val:": int = 8"},{name:"warmup_ratio",val:": float = 0.1"},{name:"gradient_accumulation",val:": int = 1"},{name:"optimizer",val:": str = 'adamw_torch'"},{name:"scheduler",val:": str = 'linear'"},{name:"weight_decay",val:": float = 0.0"},{name:"max_grad_norm",val:": float = 1.0"},{name:"seed",val:": int = 42"},{name:"train_split",val:": str = 'train'"},{name:"valid_split",val:": typing.Optional[str] = None"},{name:"text_column",val:": str = 'context'"},{name:"question_column",val:": str = 'question'"},{name:"answer_column",val:": str = 'answers'"},{name:"logging_steps",val:": int = -1"},{name:"project_name",val:": str = 'project-name'"},{name:"auto_find_batch_size",val:": bool = False"},{name:"mixed_precision",val:": typing.Optional[str] = None"},{name:"save_total_limit",val:": int = 1"},{name:"token",val:": typing.Optional[str] = None"},{name:"push_to_hub",val:": bool = False"},{name:"eval_strategy",val:": str = 'epoch'"},{name:"username",val:": typing.Optional[str] = None"},{name:"log",val:": str = 'none'"},{name:"early_stopping_patience",val:": int = 5"},{name:"early_stopping_threshold",val:": float = 0.01"}],parametersDescription:[{anchor:"autotrain.trainers.extractive_question_answering.params.ExtractiveQuestionAnsweringParams.data_path",description:"<strong>data_path</strong> (str) &#x2014; Path to the dataset.",name:"data_path"},{anchor:"autotrain.trainers.extractive_question_answering.params.ExtractiveQuestionAnsweringParams.model",description:"<strong>model</strong> (str) &#x2014; Pre-trained model name. Default is &#x201C;bert-base-uncased&#x201D;.",name:"model"},{anchor:"autotrain.trainers.extractive_question_answering.params.ExtractiveQuestionAnsweringParams.lr",description:"<strong>lr</strong> (float) &#x2014; Learning rate for the optimizer. Default is 5e-5.",name:"lr"},{anchor:"autotrain.trainers.extractive_question_answering.params.ExtractiveQuestionAnsweringParams.epochs",description:"<strong>epochs</strong> (int) &#x2014; Number of training epochs. Default is 3.",name:"epochs"},{anchor:"autotrain.trainers.extractive_question_answering.params.ExtractiveQuestionAnsweringParams.max_seq_length",description:"<strong>max_seq_length</strong> (int) &#x2014; Maximum sequence length for inputs. Default is 128.",name:"max_seq_length"},{anchor:"autotrain.trainers.extractive_question_answering.params.ExtractiveQuestionAnsweringParams.max_doc_stride",description:"<strong>max_doc_stride</strong> (int) &#x2014; Maximum document stride for splitting context. Default is 128.",name:"max_doc_stride"},{anchor:"autotrain.trainers.extractive_question_answering.params.ExtractiveQuestionAnsweringParams.batch_size",description:"<strong>batch_size</strong> (int) &#x2014; Batch size for training. Default is 8.",name:"batch_size"},{anchor:"autotrain.trainers.extractive_question_answering.params.ExtractiveQuestionAnsweringParams.warmup_ratio",description:"<strong>warmup_ratio</strong> (float) &#x2014; Warmup proportion for learning rate scheduler. Default is 0.1.",name:"warmup_ratio"},{anchor:"autotrain.trainers.extractive_question_answering.params.ExtractiveQuestionAnsweringParams.gradient_accumulation",description:"<strong>gradient_accumulation</strong> (int) &#x2014; Number of gradient accumulation steps. Default is 1.",name:"gradient_accumulation"},{anchor:"autotrain.trainers.extractive_question_answering.params.ExtractiveQuestionAnsweringParams.optimizer",description:"<strong>optimizer</strong> (str) &#x2014; Optimizer type. Default is &#x201C;adamw_torch&#x201D;.",name:"optimizer"},{anchor:"autotrain.trainers.extractive_question_answering.params.ExtractiveQuestionAnsweringParams.scheduler",description:"<strong>scheduler</strong> (str) &#x2014; Learning rate scheduler type. Default is &#x201C;linear&#x201D;.",name:"scheduler"},{anchor:"autotrain.trainers.extractive_question_answering.params.ExtractiveQuestionAnsweringParams.weight_decay",description:"<strong>weight_decay</strong> (float) &#x2014; Weight decay for the optimizer. Default is 0.0.",name:"weight_decay"},{anchor:"autotrain.trainers.extractive_question_answering.params.ExtractiveQuestionAnsweringParams.max_grad_norm",description:"<strong>max_grad_norm</strong> (float) &#x2014; Maximum gradient norm for clipping. Default is 1.0.",name:"max_grad_norm"},{anchor:"autotrain.trainers.extractive_question_answering.params.ExtractiveQuestionAnsweringParams.seed",description:"<strong>seed</strong> (int) &#x2014; Random seed for reproducibility. Default is 42.",name:"seed"},{anchor:"autotrain.trainers.extractive_question_answering.params.ExtractiveQuestionAnsweringParams.train_split",description:"<strong>train_split</strong> (str) &#x2014; Name of the training data split. Default is &#x201C;train&#x201D;.",name:"train_split"},{anchor:"autotrain.trainers.extractive_question_answering.params.ExtractiveQuestionAnsweringParams.valid_split",description:"<strong>valid_split</strong> (Optional[str]) &#x2014; Name of the validation data split. Default is None.",name:"valid_split"},{anchor:"autotrain.trainers.extractive_question_answering.params.ExtractiveQuestionAnsweringParams.text_column",description:"<strong>text_column</strong> (str) &#x2014; Column name for context/text. Default is &#x201C;context&#x201D;.",name:"text_column"},{anchor:"autotrain.trainers.extractive_question_answering.params.ExtractiveQuestionAnsweringParams.question_column",description:"<strong>question_column</strong> (str) &#x2014; Column name for questions. Default is &#x201C;question&#x201D;.",name:"question_column"},{anchor:"autotrain.trainers.extractive_question_answering.params.ExtractiveQuestionAnsweringParams.answer_column",description:"<strong>answer_column</strong> (str) &#x2014; Column name for answers. Default is &#x201C;answers&#x201D;.",name:"answer_column"},{anchor:"autotrain.trainers.extractive_question_answering.params.ExtractiveQuestionAnsweringParams.logging_steps",description:"<strong>logging_steps</strong> (int) &#x2014; Number of steps between logging. Default is -1.",name:"logging_steps"},{anchor:"autotrain.trainers.extractive_question_answering.params.ExtractiveQuestionAnsweringParams.project_name",description:"<strong>project_name</strong> (str) &#x2014; Name of the project for output directory. Default is &#x201C;project-name&#x201D;.",name:"project_name"},{anchor:"autotrain.trainers.extractive_question_answering.params.ExtractiveQuestionAnsweringParams.auto_find_batch_size",description:"<strong>auto_find_batch_size</strong> (bool) &#x2014; Automatically find optimal batch size. Default is False.",name:"auto_find_batch_size"},{anchor:"autotrain.trainers.extractive_question_answering.params.ExtractiveQuestionAnsweringParams.mixed_precision",description:"<strong>mixed_precision</strong> (Optional[str]) &#x2014; Mixed precision training mode (fp16, bf16, or None). Default is None.",name:"mixed_precision"},{anchor:"autotrain.trainers.extractive_question_answering.params.ExtractiveQuestionAnsweringParams.save_total_limit",description:"<strong>save_total_limit</strong> (int) &#x2014; Maximum number of checkpoints to save. Default is 1.",name:"save_total_limit"},{anchor:"autotrain.trainers.extractive_question_answering.params.ExtractiveQuestionAnsweringParams.token",description:"<strong>token</strong> (Optional[str]) &#x2014; Authentication token for Hugging Face Hub. Default is None.",name:"token"},{anchor:"autotrain.trainers.extractive_question_answering.params.ExtractiveQuestionAnsweringParams.push_to_hub",description:"<strong>push_to_hub</strong> (bool) &#x2014; Whether to push the model to Hugging Face Hub. Default is False.",name:"push_to_hub"},{anchor:"autotrain.trainers.extractive_question_answering.params.ExtractiveQuestionAnsweringParams.eval_strategy",description:"<strong>eval_strategy</strong> (str) &#x2014; Evaluation strategy during training. Default is &#x201C;epoch&#x201D;.",name:"eval_strategy"},{anchor:"autotrain.trainers.extractive_question_answering.params.ExtractiveQuestionAnsweringParams.username",description:"<strong>username</strong> (Optional[str]) &#x2014; Hugging Face username for authentication. Default is None.",name:"username"},{anchor:"autotrain.trainers.extractive_question_answering.params.ExtractiveQuestionAnsweringParams.log",description:"<strong>log</strong> (str) &#x2014; Logging method for experiment tracking. Default is &#x201C;none&#x201D;.",name:"log"},{anchor:"autotrain.trainers.extractive_question_answering.params.ExtractiveQuestionAnsweringParams.early_stopping_patience",description:"<strong>early_stopping_patience</strong> (int) &#x2014; Number of epochs with no improvement for early stopping. Default is 5.",name:"early_stopping_patience"},{anchor:"autotrain.trainers.extractive_question_answering.params.ExtractiveQuestionAnsweringParams.early_stopping_threshold",description:"<strong>early_stopping_threshold</strong> (float) &#x2014; Threshold for early stopping improvement. Default is 0.01.",name:"early_stopping_threshold"}],source:"https://github.com/huggingface/autotrain-advanced/blob/vr_775/src/autotrain/trainers/extractive_question_answering/params.py#L8"}}),ra=new b({props:{name:"class autotrain.trainers.text_classification.params.TextClassificationParams",anchor:"autotrain.trainers.text_classification.params.TextClassificationParams",parameters:[{name:"data_path",val:": str = None"},{name:"model",val:": str = 'bert-base-uncased'"},{name:"lr",val:": float = 5e-05"},{name:"epochs",val:": int = 3"},{name:"max_seq_length",val:": int = 128"},{name:"batch_size",val:": int = 8"},{name:"warmup_ratio",val:": float = 0.1"},{name:"gradient_accumulation",val:": int = 1"},{name:"optimizer",val:": str = 'adamw_torch'"},{name:"scheduler",val:": str = 'linear'"},{name:"weight_decay",val:": float = 0.0"},{name:"max_grad_norm",val:": float = 1.0"},{name:"seed",val:": int = 42"},{name:"train_split",val:": str = 'train'"},{name:"valid_split",val:": typing.Optional[str] = None"},{name:"text_column",val:": str = 'text'"},{name:"target_column",val:": str = 'target'"},{name:"logging_steps",val:": int = -1"},{name:"project_name",val:": str = 'project-name'"},{name:"auto_find_batch_size",val:": bool = False"},{name:"mixed_precision",val:": typing.Optional[str] = None"},{name:"save_total_limit",val:": int = 1"},{name:"token",val:": typing.Optional[str] = None"},{name:"push_to_hub",val:": bool = False"},{name:"eval_strategy",val:": str = 'epoch'"},{name:"username",val:": typing.Optional[str] = None"},{name:"log",val:": str = 'none'"},{name:"early_stopping_patience",val:": int = 5"},{name:"early_stopping_threshold",val:": float = 0.01"},{name:"gen_prompt",val:": typing.Optional[str] = None"},{name:"gen_model",val:": typing.Optional[str] = None"},{name:"gen_samples",val:": typing.Optional[int] = 100"},{name:"gen_params",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"autotrain.trainers.text_classification.params.TextClassificationParams.data_path",description:"<strong>data_path</strong> (str) &#x2014; Path to the dataset.",name:"data_path"},{anchor:"autotrain.trainers.text_classification.params.TextClassificationParams.model",description:"<strong>model</strong> (str) &#x2014; Name of the model to use. Default is &#x201C;bert-base-uncased&#x201D;.",name:"model"},{anchor:"autotrain.trainers.text_classification.params.TextClassificationParams.lr",description:"<strong>lr</strong> (float) &#x2014; Learning rate. Default is 5e-5.",name:"lr"},{anchor:"autotrain.trainers.text_classification.params.TextClassificationParams.epochs",description:"<strong>epochs</strong> (int) &#x2014; Number of training epochs. Default is 3.",name:"epochs"},{anchor:"autotrain.trainers.text_classification.params.TextClassificationParams.max_seq_length",description:"<strong>max_seq_length</strong> (int) &#x2014; Maximum sequence length. Default is 128.",name:"max_seq_length"},{anchor:"autotrain.trainers.text_classification.params.TextClassificationParams.batch_size",description:"<strong>batch_size</strong> (int) &#x2014; Training batch size. Default is 8.",name:"batch_size"},{anchor:"autotrain.trainers.text_classification.params.TextClassificationParams.warmup_ratio",description:"<strong>warmup_ratio</strong> (float) &#x2014; Warmup proportion. Default is 0.1.",name:"warmup_ratio"},{anchor:"autotrain.trainers.text_classification.params.TextClassificationParams.gradient_accumulation",description:"<strong>gradient_accumulation</strong> (int) &#x2014; Number of gradient accumulation steps. Default is 1.",name:"gradient_accumulation"},{anchor:"autotrain.trainers.text_classification.params.TextClassificationParams.optimizer",description:"<strong>optimizer</strong> (str) &#x2014; Optimizer to use. Default is &#x201C;adamw_torch&#x201D;.",name:"optimizer"},{anchor:"autotrain.trainers.text_classification.params.TextClassificationParams.scheduler",description:"<strong>scheduler</strong> (str) &#x2014; Scheduler to use. Default is &#x201C;linear&#x201D;.",name:"scheduler"},{anchor:"autotrain.trainers.text_classification.params.TextClassificationParams.weight_decay",description:"<strong>weight_decay</strong> (float) &#x2014; Weight decay. Default is 0.0.",name:"weight_decay"},{anchor:"autotrain.trainers.text_classification.params.TextClassificationParams.max_grad_norm",description:"<strong>max_grad_norm</strong> (float) &#x2014; Maximum gradient norm. Default is 1.0.",name:"max_grad_norm"},{anchor:"autotrain.trainers.text_classification.params.TextClassificationParams.seed",description:"<strong>seed</strong> (int) &#x2014; Random seed. Default is 42.",name:"seed"},{anchor:"autotrain.trainers.text_classification.params.TextClassificationParams.train_split",description:"<strong>train_split</strong> (str) &#x2014; Name of the training split. Default is &#x201C;train&#x201D;.",name:"train_split"},{anchor:"autotrain.trainers.text_classification.params.TextClassificationParams.valid_split",description:"<strong>valid_split</strong> (Optional[str]) &#x2014; Name of the validation split. Default is None.",name:"valid_split"},{anchor:"autotrain.trainers.text_classification.params.TextClassificationParams.text_column",description:"<strong>text_column</strong> (str) &#x2014; Name of the text column in the dataset. Default is &#x201C;text&#x201D;.",name:"text_column"},{anchor:"autotrain.trainers.text_classification.params.TextClassificationParams.target_column",description:"<strong>target_column</strong> (str) &#x2014; Name of the target column in the dataset. Default is &#x201C;target&#x201D;.",name:"target_column"},{anchor:"autotrain.trainers.text_classification.params.TextClassificationParams.logging_steps",description:"<strong>logging_steps</strong> (int) &#x2014; Number of steps between logging. Default is -1.",name:"logging_steps"},{anchor:"autotrain.trainers.text_classification.params.TextClassificationParams.project_name",description:"<strong>project_name</strong> (str) &#x2014; Name of the project. Default is &#x201C;project-name&#x201D;.",name:"project_name"},{anchor:"autotrain.trainers.text_classification.params.TextClassificationParams.auto_find_batch_size",description:"<strong>auto_find_batch_size</strong> (bool) &#x2014; Whether to automatically find the batch size. Default is False.",name:"auto_find_batch_size"},{anchor:"autotrain.trainers.text_classification.params.TextClassificationParams.mixed_precision",description:"<strong>mixed_precision</strong> (Optional[str]) &#x2014; Mixed precision setting (fp16, bf16, or None). Default is None.",name:"mixed_precision"},{anchor:"autotrain.trainers.text_classification.params.TextClassificationParams.save_total_limit",description:"<strong>save_total_limit</strong> (int) &#x2014; Total number of checkpoints to save. Default is 1.",name:"save_total_limit"},{anchor:"autotrain.trainers.text_classification.params.TextClassificationParams.token",description:"<strong>token</strong> (Optional[str]) &#x2014; Hub token for authentication. Default is None.",name:"token"},{anchor:"autotrain.trainers.text_classification.params.TextClassificationParams.push_to_hub",description:"<strong>push_to_hub</strong> (bool) &#x2014; Whether to push the model to the hub. Default is False.",name:"push_to_hub"},{anchor:"autotrain.trainers.text_classification.params.TextClassificationParams.eval_strategy",description:"<strong>eval_strategy</strong> (str) &#x2014; Evaluation strategy. Default is &#x201C;epoch&#x201D;.",name:"eval_strategy"},{anchor:"autotrain.trainers.text_classification.params.TextClassificationParams.username",description:"<strong>username</strong> (Optional[str]) &#x2014; Hugging Face username. Default is None.",name:"username"},{anchor:"autotrain.trainers.text_classification.params.TextClassificationParams.log",description:"<strong>log</strong> (str) &#x2014; Logging method for experiment tracking. Default is &#x201C;none&#x201D;.",name:"log"},{anchor:"autotrain.trainers.text_classification.params.TextClassificationParams.early_stopping_patience",description:"<strong>early_stopping_patience</strong> (int) &#x2014; Number of epochs with no improvement after which training will be stopped. Default is 5.",name:"early_stopping_patience"},{anchor:"autotrain.trainers.text_classification.params.TextClassificationParams.early_stopping_threshold",description:"<strong>early_stopping_threshold</strong> (float) &#x2014; Threshold for measuring the new optimum to continue training. Default is 0.01.",name:"early_stopping_threshold"}],source:"https://github.com/huggingface/autotrain-advanced/blob/vr_775/src/autotrain/trainers/text_classification/params.py#L8"}}),sa=new b({props:{name:"class autotrain.trainers.text_regression.params.TextRegressionParams",anchor:"autotrain.trainers.text_regression.params.TextRegressionParams",parameters:[{name:"data_path",val:": str = None"},{name:"model",val:": str = 'bert-base-uncased'"},{name:"lr",val:": float = 5e-05"},{name:"epochs",val:": int = 3"},{name:"max_seq_length",val:": int = 128"},{name:"batch_size",val:": int = 8"},{name:"warmup_ratio",val:": float = 0.1"},{name:"gradient_accumulation",val:": int = 1"},{name:"optimizer",val:": str = 'adamw_torch'"},{name:"scheduler",val:": str = 'linear'"},{name:"weight_decay",val:": float = 0.0"},{name:"max_grad_norm",val:": float = 1.0"},{name:"seed",val:": int = 42"},{name:"train_split",val:": str = 'train'"},{name:"valid_split",val:": typing.Optional[str] = None"},{name:"text_column",val:": str = 'text'"},{name:"target_column",val:": str = 'target'"},{name:"logging_steps",val:": int = -1"},{name:"project_name",val:": str = 'project-name'"},{name:"auto_find_batch_size",val:": bool = False"},{name:"mixed_precision",val:": typing.Optional[str] = None"},{name:"save_total_limit",val:": int = 1"},{name:"token",val:": typing.Optional[str] = None"},{name:"push_to_hub",val:": bool = False"},{name:"eval_strategy",val:": str = 'epoch'"},{name:"username",val:": typing.Optional[str] = None"},{name:"log",val:": str = 'none'"},{name:"early_stopping_patience",val:": int = 5"},{name:"early_stopping_threshold",val:": float = 0.01"}],parametersDescription:[{anchor:"autotrain.trainers.text_regression.params.TextRegressionParams.data_path",description:"<strong>data_path</strong> (str) &#x2014; Path to the dataset.",name:"data_path"},{anchor:"autotrain.trainers.text_regression.params.TextRegressionParams.model",description:"<strong>model</strong> (str) &#x2014; Name of the pre-trained model to use. Default is &#x201C;bert-base-uncased&#x201D;.",name:"model"},{anchor:"autotrain.trainers.text_regression.params.TextRegressionParams.lr",description:"<strong>lr</strong> (float) &#x2014; Learning rate for the optimizer. Default is 5e-5.",name:"lr"},{anchor:"autotrain.trainers.text_regression.params.TextRegressionParams.epochs",description:"<strong>epochs</strong> (int) &#x2014; Number of training epochs. Default is 3.",name:"epochs"},{anchor:"autotrain.trainers.text_regression.params.TextRegressionParams.max_seq_length",description:"<strong>max_seq_length</strong> (int) &#x2014; Maximum sequence length for the inputs. Default is 128.",name:"max_seq_length"},{anchor:"autotrain.trainers.text_regression.params.TextRegressionParams.batch_size",description:"<strong>batch_size</strong> (int) &#x2014; Batch size for training. Default is 8.",name:"batch_size"},{anchor:"autotrain.trainers.text_regression.params.TextRegressionParams.warmup_ratio",description:"<strong>warmup_ratio</strong> (float) &#x2014; Proportion of training to perform learning rate warmup. Default is 0.1.",name:"warmup_ratio"},{anchor:"autotrain.trainers.text_regression.params.TextRegressionParams.gradient_accumulation",description:"<strong>gradient_accumulation</strong> (int) &#x2014; Number of steps to accumulate gradients before updating. Default is 1.",name:"gradient_accumulation"},{anchor:"autotrain.trainers.text_regression.params.TextRegressionParams.optimizer",description:"<strong>optimizer</strong> (str) &#x2014; Optimizer to use. Default is &#x201C;adamw_torch&#x201D;.",name:"optimizer"},{anchor:"autotrain.trainers.text_regression.params.TextRegressionParams.scheduler",description:"<strong>scheduler</strong> (str) &#x2014; Learning rate scheduler to use. Default is &#x201C;linear&#x201D;.",name:"scheduler"},{anchor:"autotrain.trainers.text_regression.params.TextRegressionParams.weight_decay",description:"<strong>weight_decay</strong> (float) &#x2014; Weight decay to apply. Default is 0.0.",name:"weight_decay"},{anchor:"autotrain.trainers.text_regression.params.TextRegressionParams.max_grad_norm",description:"<strong>max_grad_norm</strong> (float) &#x2014; Maximum norm for the gradients. Default is 1.0.",name:"max_grad_norm"},{anchor:"autotrain.trainers.text_regression.params.TextRegressionParams.seed",description:"<strong>seed</strong> (int) &#x2014; Random seed for reproducibility. Default is 42.",name:"seed"},{anchor:"autotrain.trainers.text_regression.params.TextRegressionParams.train_split",description:"<strong>train_split</strong> (str) &#x2014; Name of the training data split. Default is &#x201C;train&#x201D;.",name:"train_split"},{anchor:"autotrain.trainers.text_regression.params.TextRegressionParams.valid_split",description:"<strong>valid_split</strong> (Optional[str]) &#x2014; Name of the validation data split. Default is None.",name:"valid_split"},{anchor:"autotrain.trainers.text_regression.params.TextRegressionParams.text_column",description:"<strong>text_column</strong> (str) &#x2014; Name of the column containing text data. Default is &#x201C;text&#x201D;.",name:"text_column"},{anchor:"autotrain.trainers.text_regression.params.TextRegressionParams.target_column",description:"<strong>target_column</strong> (str) &#x2014; Name of the column containing target data. Default is &#x201C;target&#x201D;.",name:"target_column"},{anchor:"autotrain.trainers.text_regression.params.TextRegressionParams.logging_steps",description:"<strong>logging_steps</strong> (int) &#x2014; Number of steps between logging. Default is -1 (no logging).",name:"logging_steps"},{anchor:"autotrain.trainers.text_regression.params.TextRegressionParams.project_name",description:"<strong>project_name</strong> (str) &#x2014; Name of the project for output directory. Default is &#x201C;project-name&#x201D;.",name:"project_name"},{anchor:"autotrain.trainers.text_regression.params.TextRegressionParams.auto_find_batch_size",description:"<strong>auto_find_batch_size</strong> (bool) &#x2014; Whether to automatically find the batch size. Default is False.",name:"auto_find_batch_size"},{anchor:"autotrain.trainers.text_regression.params.TextRegressionParams.mixed_precision",description:"<strong>mixed_precision</strong> (Optional[str]) &#x2014; Mixed precision training mode (fp16, bf16, or None). Default is None.",name:"mixed_precision"},{anchor:"autotrain.trainers.text_regression.params.TextRegressionParams.save_total_limit",description:"<strong>save_total_limit</strong> (int) &#x2014; Maximum number of checkpoints to save. Default is 1.",name:"save_total_limit"},{anchor:"autotrain.trainers.text_regression.params.TextRegressionParams.token",description:"<strong>token</strong> (Optional[str]) &#x2014; Token for accessing Hugging Face Hub. Default is None.",name:"token"},{anchor:"autotrain.trainers.text_regression.params.TextRegressionParams.push_to_hub",description:"<strong>push_to_hub</strong> (bool) &#x2014; Whether to push the model to Hugging Face Hub. Default is False.",name:"push_to_hub"},{anchor:"autotrain.trainers.text_regression.params.TextRegressionParams.eval_strategy",description:"<strong>eval_strategy</strong> (str) &#x2014; Evaluation strategy to use. Default is &#x201C;epoch&#x201D;.",name:"eval_strategy"},{anchor:"autotrain.trainers.text_regression.params.TextRegressionParams.username",description:"<strong>username</strong> (Optional[str]) &#x2014; Hugging Face username. Default is None.",name:"username"},{anchor:"autotrain.trainers.text_regression.params.TextRegressionParams.log",description:"<strong>log</strong> (str) &#x2014; Logging method for experiment tracking. Default is &#x201C;none&#x201D;.",name:"log"},{anchor:"autotrain.trainers.text_regression.params.TextRegressionParams.early_stopping_patience",description:"<strong>early_stopping_patience</strong> (int) &#x2014; Number of epochs with no improvement after which training will be stopped. Default is 5.",name:"early_stopping_patience"},{anchor:"autotrain.trainers.text_regression.params.TextRegressionParams.early_stopping_threshold",description:"<strong>early_stopping_threshold</strong> (float) &#x2014; Threshold for measuring the new optimum, to qualify as an improvement. Default is 0.01.",name:"early_stopping_threshold"}],source:"https://github.com/huggingface/autotrain-advanced/blob/vr_775/src/autotrain/trainers/text_regression/params.py#L8"}}),ia=new $({props:{title:"Image Tasks",local:"autotrain.trainers.image_classification.params.ImageClassificationParams",headingTag:"h3"}}),oa=new b({props:{name:"class autotrain.trainers.image_classification.params.ImageClassificationParams",anchor:"autotrain.trainers.image_classification.params.ImageClassificationParams",parameters:[{name:"data_path",val:": str = None"},{name:"model",val:": str = 'google/vit-base-patch16-224'"},{name:"username",val:": typing.Optional[str] = None"},{name:"lr",val:": float = 5e-05"},{name:"epochs",val:": int = 3"},{name:"batch_size",val:": int = 8"},{name:"warmup_ratio",val:": float = 0.1"},{name:"gradient_accumulation",val:": int = 1"},{name:"optimizer",val:": str = 'adamw_torch'"},{name:"scheduler",val:": str = 'linear'"},{name:"weight_decay",val:": float = 0.0"},{name:"max_grad_norm",val:": float = 1.0"},{name:"seed",val:": int = 42"},{name:"train_split",val:": str = 'train'"},{name:"valid_split",val:": typing.Optional[str] = None"},{name:"logging_steps",val:": int = -1"},{name:"project_name",val:": str = 'project-name'"},{name:"auto_find_batch_size",val:": bool = False"},{name:"mixed_precision",val:": typing.Optional[str] = None"},{name:"save_total_limit",val:": int = 1"},{name:"token",val:": typing.Optional[str] = None"},{name:"push_to_hub",val:": bool = False"},{name:"eval_strategy",val:": str = 'epoch'"},{name:"image_column",val:": str = 'image'"},{name:"target_column",val:": str = 'target'"},{name:"log",val:": str = 'none'"},{name:"early_stopping_patience",val:": int = 5"},{name:"early_stopping_threshold",val:": float = 0.01"}],parametersDescription:[{anchor:"autotrain.trainers.image_classification.params.ImageClassificationParams.data_path",description:"<strong>data_path</strong> (str) &#x2014; Path to the dataset.",name:"data_path"},{anchor:"autotrain.trainers.image_classification.params.ImageClassificationParams.model",description:"<strong>model</strong> (str) &#x2014; Pre-trained model name or path. Default is &#x201C;google/vit-base-patch16-224&#x201D;.",name:"model"},{anchor:"autotrain.trainers.image_classification.params.ImageClassificationParams.username",description:"<strong>username</strong> (Optional[str]) &#x2014; Hugging Face account username.",name:"username"},{anchor:"autotrain.trainers.image_classification.params.ImageClassificationParams.lr",description:"<strong>lr</strong> (float) &#x2014; Learning rate for the optimizer. Default is 5e-5.",name:"lr"},{anchor:"autotrain.trainers.image_classification.params.ImageClassificationParams.epochs",description:"<strong>epochs</strong> (int) &#x2014; Number of epochs for training. Default is 3.",name:"epochs"},{anchor:"autotrain.trainers.image_classification.params.ImageClassificationParams.batch_size",description:"<strong>batch_size</strong> (int) &#x2014; Batch size for training. Default is 8.",name:"batch_size"},{anchor:"autotrain.trainers.image_classification.params.ImageClassificationParams.warmup_ratio",description:"<strong>warmup_ratio</strong> (float) &#x2014; Warmup ratio for learning rate scheduler. Default is 0.1.",name:"warmup_ratio"},{anchor:"autotrain.trainers.image_classification.params.ImageClassificationParams.gradient_accumulation",description:"<strong>gradient_accumulation</strong> (int) &#x2014; Number of gradient accumulation steps. Default is 1.",name:"gradient_accumulation"},{anchor:"autotrain.trainers.image_classification.params.ImageClassificationParams.optimizer",description:"<strong>optimizer</strong> (str) &#x2014; Optimizer type. Default is &#x201C;adamw_torch&#x201D;.",name:"optimizer"},{anchor:"autotrain.trainers.image_classification.params.ImageClassificationParams.scheduler",description:"<strong>scheduler</strong> (str) &#x2014; Learning rate scheduler type. Default is &#x201C;linear&#x201D;.",name:"scheduler"},{anchor:"autotrain.trainers.image_classification.params.ImageClassificationParams.weight_decay",description:"<strong>weight_decay</strong> (float) &#x2014; Weight decay for the optimizer. Default is 0.0.",name:"weight_decay"},{anchor:"autotrain.trainers.image_classification.params.ImageClassificationParams.max_grad_norm",description:"<strong>max_grad_norm</strong> (float) &#x2014; Maximum gradient norm for clipping. Default is 1.0.",name:"max_grad_norm"},{anchor:"autotrain.trainers.image_classification.params.ImageClassificationParams.seed",description:"<strong>seed</strong> (int) &#x2014; Random seed for reproducibility. Default is 42.",name:"seed"},{anchor:"autotrain.trainers.image_classification.params.ImageClassificationParams.train_split",description:"<strong>train_split</strong> (str) &#x2014; Name of the training data split. Default is &#x201C;train&#x201D;.",name:"train_split"},{anchor:"autotrain.trainers.image_classification.params.ImageClassificationParams.valid_split",description:"<strong>valid_split</strong> (Optional[str]) &#x2014; Name of the validation data split.",name:"valid_split"},{anchor:"autotrain.trainers.image_classification.params.ImageClassificationParams.logging_steps",description:"<strong>logging_steps</strong> (int) &#x2014; Number of steps between logging. Default is -1.",name:"logging_steps"},{anchor:"autotrain.trainers.image_classification.params.ImageClassificationParams.project_name",description:"<strong>project_name</strong> (str) &#x2014; Name of the project for output directory. Default is &#x201C;project-name&#x201D;.",name:"project_name"},{anchor:"autotrain.trainers.image_classification.params.ImageClassificationParams.auto_find_batch_size",description:"<strong>auto_find_batch_size</strong> (bool) &#x2014; Automatically find optimal batch size. Default is False.",name:"auto_find_batch_size"},{anchor:"autotrain.trainers.image_classification.params.ImageClassificationParams.mixed_precision",description:"<strong>mixed_precision</strong> (Optional[str]) &#x2014; Mixed precision training mode (fp16, bf16, or None).",name:"mixed_precision"},{anchor:"autotrain.trainers.image_classification.params.ImageClassificationParams.save_total_limit",description:"<strong>save_total_limit</strong> (int) &#x2014; Maximum number of checkpoints to keep. Default is 1.",name:"save_total_limit"},{anchor:"autotrain.trainers.image_classification.params.ImageClassificationParams.token",description:"<strong>token</strong> (Optional[str]) &#x2014; Hugging Face Hub token for authentication.",name:"token"},{anchor:"autotrain.trainers.image_classification.params.ImageClassificationParams.push_to_hub",description:"<strong>push_to_hub</strong> (bool) &#x2014; Whether to push the model to Hugging Face Hub. Default is False.",name:"push_to_hub"},{anchor:"autotrain.trainers.image_classification.params.ImageClassificationParams.eval_strategy",description:"<strong>eval_strategy</strong> (str) &#x2014; Evaluation strategy during training. Default is &#x201C;epoch&#x201D;.",name:"eval_strategy"},{anchor:"autotrain.trainers.image_classification.params.ImageClassificationParams.image_column",description:"<strong>image_column</strong> (str) &#x2014; Column name for images in the dataset. Default is &#x201C;image&#x201D;.",name:"image_column"},{anchor:"autotrain.trainers.image_classification.params.ImageClassificationParams.target_column",description:"<strong>target_column</strong> (str) &#x2014; Column name for target labels in the dataset. Default is &#x201C;target&#x201D;.",name:"target_column"},{anchor:"autotrain.trainers.image_classification.params.ImageClassificationParams.log",description:"<strong>log</strong> (str) &#x2014; Logging method for experiment tracking. Default is &#x201C;none&#x201D;.",name:"log"},{anchor:"autotrain.trainers.image_classification.params.ImageClassificationParams.early_stopping_patience",description:"<strong>early_stopping_patience</strong> (int) &#x2014; Number of epochs with no improvement for early stopping. Default is 5.",name:"early_stopping_patience"},{anchor:"autotrain.trainers.image_classification.params.ImageClassificationParams.early_stopping_threshold",description:"<strong>early_stopping_threshold</strong> (float) &#x2014; Threshold for early stopping. Default is 0.01.",name:"early_stopping_threshold"}],source:"https://github.com/huggingface/autotrain-advanced/blob/vr_775/src/autotrain/trainers/image_classification/params.py#L8"}}),ma=new b({props:{name:"class autotrain.trainers.image_regression.params.ImageRegressionParams",anchor:"autotrain.trainers.image_regression.params.ImageRegressionParams",parameters:[{name:"data_path",val:": str = None"},{name:"model",val:": str = 'google/vit-base-patch16-224'"},{name:"username",val:": typing.Optional[str] = None"},{name:"lr",val:": float = 5e-05"},{name:"epochs",val:": int = 3"},{name:"batch_size",val:": int = 8"},{name:"warmup_ratio",val:": float = 0.1"},{name:"gradient_accumulation",val:": int = 1"},{name:"optimizer",val:": str = 'adamw_torch'"},{name:"scheduler",val:": str = 'linear'"},{name:"weight_decay",val:": float = 0.0"},{name:"max_grad_norm",val:": float = 1.0"},{name:"seed",val:": int = 42"},{name:"train_split",val:": str = 'train'"},{name:"valid_split",val:": typing.Optional[str] = None"},{name:"logging_steps",val:": int = -1"},{name:"project_name",val:": str = 'project-name'"},{name:"auto_find_batch_size",val:": bool = False"},{name:"mixed_precision",val:": typing.Optional[str] = None"},{name:"save_total_limit",val:": int = 1"},{name:"token",val:": typing.Optional[str] = None"},{name:"push_to_hub",val:": bool = False"},{name:"eval_strategy",val:": str = 'epoch'"},{name:"image_column",val:": str = 'image'"},{name:"target_column",val:": str = 'target'"},{name:"log",val:": str = 'none'"},{name:"early_stopping_patience",val:": int = 5"},{name:"early_stopping_threshold",val:": float = 0.01"}],parametersDescription:[{anchor:"autotrain.trainers.image_regression.params.ImageRegressionParams.data_path",description:"<strong>data_path</strong> (str) &#x2014; Path to the dataset.",name:"data_path"},{anchor:"autotrain.trainers.image_regression.params.ImageRegressionParams.model",description:"<strong>model</strong> (str) &#x2014; Name of the model to use. Default is &#x201C;google/vit-base-patch16-224&#x201D;.",name:"model"},{anchor:"autotrain.trainers.image_regression.params.ImageRegressionParams.username",description:"<strong>username</strong> (Optional[str]) &#x2014; Hugging Face Username.",name:"username"},{anchor:"autotrain.trainers.image_regression.params.ImageRegressionParams.lr",description:"<strong>lr</strong> (float) &#x2014; Learning rate. Default is 5e-5.",name:"lr"},{anchor:"autotrain.trainers.image_regression.params.ImageRegressionParams.epochs",description:"<strong>epochs</strong> (int) &#x2014; Number of training epochs. Default is 3.",name:"epochs"},{anchor:"autotrain.trainers.image_regression.params.ImageRegressionParams.batch_size",description:"<strong>batch_size</strong> (int) &#x2014; Training batch size. Default is 8.",name:"batch_size"},{anchor:"autotrain.trainers.image_regression.params.ImageRegressionParams.warmup_ratio",description:"<strong>warmup_ratio</strong> (float) &#x2014; Warmup proportion. Default is 0.1.",name:"warmup_ratio"},{anchor:"autotrain.trainers.image_regression.params.ImageRegressionParams.gradient_accumulation",description:"<strong>gradient_accumulation</strong> (int) &#x2014; Gradient accumulation steps. Default is 1.",name:"gradient_accumulation"},{anchor:"autotrain.trainers.image_regression.params.ImageRegressionParams.optimizer",description:"<strong>optimizer</strong> (str) &#x2014; Optimizer to use. Default is &#x201C;adamw_torch&#x201D;.",name:"optimizer"},{anchor:"autotrain.trainers.image_regression.params.ImageRegressionParams.scheduler",description:"<strong>scheduler</strong> (str) &#x2014; Scheduler to use. Default is &#x201C;linear&#x201D;.",name:"scheduler"},{anchor:"autotrain.trainers.image_regression.params.ImageRegressionParams.weight_decay",description:"<strong>weight_decay</strong> (float) &#x2014; Weight decay. Default is 0.0.",name:"weight_decay"},{anchor:"autotrain.trainers.image_regression.params.ImageRegressionParams.max_grad_norm",description:"<strong>max_grad_norm</strong> (float) &#x2014; Max gradient norm. Default is 1.0.",name:"max_grad_norm"},{anchor:"autotrain.trainers.image_regression.params.ImageRegressionParams.seed",description:"<strong>seed</strong> (int) &#x2014; Random seed. Default is 42.",name:"seed"},{anchor:"autotrain.trainers.image_regression.params.ImageRegressionParams.train_split",description:"<strong>train_split</strong> (str) &#x2014; Train split name. Default is &#x201C;train&#x201D;.",name:"train_split"},{anchor:"autotrain.trainers.image_regression.params.ImageRegressionParams.valid_split",description:"<strong>valid_split</strong> (Optional[str]) &#x2014; Validation split name.",name:"valid_split"},{anchor:"autotrain.trainers.image_regression.params.ImageRegressionParams.logging_steps",description:"<strong>logging_steps</strong> (int) &#x2014; Logging steps. Default is -1.",name:"logging_steps"},{anchor:"autotrain.trainers.image_regression.params.ImageRegressionParams.project_name",description:"<strong>project_name</strong> (str) &#x2014; Output directory name. Default is &#x201C;project-name&#x201D;.",name:"project_name"},{anchor:"autotrain.trainers.image_regression.params.ImageRegressionParams.auto_find_batch_size",description:"<strong>auto_find_batch_size</strong> (bool) &#x2014; Whether to auto find batch size. Default is False.",name:"auto_find_batch_size"},{anchor:"autotrain.trainers.image_regression.params.ImageRegressionParams.mixed_precision",description:"<strong>mixed_precision</strong> (Optional[str]) &#x2014; Mixed precision type (fp16, bf16, or None).",name:"mixed_precision"},{anchor:"autotrain.trainers.image_regression.params.ImageRegressionParams.save_total_limit",description:"<strong>save_total_limit</strong> (int) &#x2014; Save total limit. Default is 1.",name:"save_total_limit"},{anchor:"autotrain.trainers.image_regression.params.ImageRegressionParams.token",description:"<strong>token</strong> (Optional[str]) &#x2014; Hub Token.",name:"token"},{anchor:"autotrain.trainers.image_regression.params.ImageRegressionParams.push_to_hub",description:"<strong>push_to_hub</strong> (bool) &#x2014; Whether to push to hub. Default is False.",name:"push_to_hub"},{anchor:"autotrain.trainers.image_regression.params.ImageRegressionParams.eval_strategy",description:"<strong>eval_strategy</strong> (str) &#x2014; Evaluation strategy. Default is &#x201C;epoch&#x201D;.",name:"eval_strategy"},{anchor:"autotrain.trainers.image_regression.params.ImageRegressionParams.image_column",description:"<strong>image_column</strong> (str) &#x2014; Image column name. Default is &#x201C;image&#x201D;.",name:"image_column"},{anchor:"autotrain.trainers.image_regression.params.ImageRegressionParams.target_column",description:"<strong>target_column</strong> (str) &#x2014; Target column name. Default is &#x201C;target&#x201D;.",name:"target_column"},{anchor:"autotrain.trainers.image_regression.params.ImageRegressionParams.log",description:"<strong>log</strong> (str) &#x2014; Logging using experiment tracking. Default is &#x201C;none&#x201D;.",name:"log"},{anchor:"autotrain.trainers.image_regression.params.ImageRegressionParams.early_stopping_patience",description:"<strong>early_stopping_patience</strong> (int) &#x2014; Early stopping patience. Default is 5.",name:"early_stopping_patience"},{anchor:"autotrain.trainers.image_regression.params.ImageRegressionParams.early_stopping_threshold",description:"<strong>early_stopping_threshold</strong> (float) &#x2014; Early stopping threshold. Default is 0.01.",name:"early_stopping_threshold"}],source:"https://github.com/huggingface/autotrain-advanced/blob/vr_775/src/autotrain/trainers/image_regression/params.py#L8"}}),la=new b({props:{name:"class autotrain.trainers.object_detection.params.ObjectDetectionParams",anchor:"autotrain.trainers.object_detection.params.ObjectDetectionParams",parameters:[{name:"data_path",val:": str = None"},{name:"model",val:": str = 'google/vit-base-patch16-224'"},{name:"username",val:": typing.Optional[str] = None"},{name:"lr",val:": float = 5e-05"},{name:"epochs",val:": int = 3"},{name:"batch_size",val:": int = 8"},{name:"warmup_ratio",val:": float = 0.1"},{name:"gradient_accumulation",val:": int = 1"},{name:"optimizer",val:": str = 'adamw_torch'"},{name:"scheduler",val:": str = 'linear'"},{name:"weight_decay",val:": float = 0.0"},{name:"max_grad_norm",val:": float = 1.0"},{name:"seed",val:": int = 42"},{name:"train_split",val:": str = 'train'"},{name:"valid_split",val:": typing.Optional[str] = None"},{name:"logging_steps",val:": int = -1"},{name:"project_name",val:": str = 'project-name'"},{name:"auto_find_batch_size",val:": bool = False"},{name:"mixed_precision",val:": typing.Optional[str] = None"},{name:"save_total_limit",val:": int = 1"},{name:"token",val:": typing.Optional[str] = None"},{name:"push_to_hub",val:": bool = False"},{name:"eval_strategy",val:": str = 'epoch'"},{name:"image_column",val:": str = 'image'"},{name:"objects_column",val:": str = 'objects'"},{name:"log",val:": str = 'none'"},{name:"image_square_size",val:": typing.Optional[int] = 600"},{name:"early_stopping_patience",val:": int = 5"},{name:"early_stopping_threshold",val:": float = 0.01"}],parametersDescription:[{anchor:"autotrain.trainers.object_detection.params.ObjectDetectionParams.data_path",description:"<strong>data_path</strong> (str) &#x2014; Path to the dataset.",name:"data_path"},{anchor:"autotrain.trainers.object_detection.params.ObjectDetectionParams.model",description:"<strong>model</strong> (str) &#x2014; Name of the model to be used. Default is &#x201C;google/vit-base-patch16-224&#x201D;.",name:"model"},{anchor:"autotrain.trainers.object_detection.params.ObjectDetectionParams.username",description:"<strong>username</strong> (Optional[str]) &#x2014; Hugging Face Username.",name:"username"},{anchor:"autotrain.trainers.object_detection.params.ObjectDetectionParams.lr",description:"<strong>lr</strong> (float) &#x2014; Learning rate. Default is 5e-5.",name:"lr"},{anchor:"autotrain.trainers.object_detection.params.ObjectDetectionParams.epochs",description:"<strong>epochs</strong> (int) &#x2014; Number of training epochs. Default is 3.",name:"epochs"},{anchor:"autotrain.trainers.object_detection.params.ObjectDetectionParams.batch_size",description:"<strong>batch_size</strong> (int) &#x2014; Training batch size. Default is 8.",name:"batch_size"},{anchor:"autotrain.trainers.object_detection.params.ObjectDetectionParams.warmup_ratio",description:"<strong>warmup_ratio</strong> (float) &#x2014; Warmup proportion. Default is 0.1.",name:"warmup_ratio"},{anchor:"autotrain.trainers.object_detection.params.ObjectDetectionParams.gradient_accumulation",description:"<strong>gradient_accumulation</strong> (int) &#x2014; Gradient accumulation steps. Default is 1.",name:"gradient_accumulation"},{anchor:"autotrain.trainers.object_detection.params.ObjectDetectionParams.optimizer",description:"<strong>optimizer</strong> (str) &#x2014; Optimizer to be used. Default is &#x201C;adamw_torch&#x201D;.",name:"optimizer"},{anchor:"autotrain.trainers.object_detection.params.ObjectDetectionParams.scheduler",description:"<strong>scheduler</strong> (str) &#x2014; Scheduler to be used. Default is &#x201C;linear&#x201D;.",name:"scheduler"},{anchor:"autotrain.trainers.object_detection.params.ObjectDetectionParams.weight_decay",description:"<strong>weight_decay</strong> (float) &#x2014; Weight decay. Default is 0.0.",name:"weight_decay"},{anchor:"autotrain.trainers.object_detection.params.ObjectDetectionParams.max_grad_norm",description:"<strong>max_grad_norm</strong> (float) &#x2014; Max gradient norm. Default is 1.0.",name:"max_grad_norm"},{anchor:"autotrain.trainers.object_detection.params.ObjectDetectionParams.seed",description:"<strong>seed</strong> (int) &#x2014; Random seed. Default is 42.",name:"seed"},{anchor:"autotrain.trainers.object_detection.params.ObjectDetectionParams.train_split",description:"<strong>train_split</strong> (str) &#x2014; Name of the training data split. Default is &#x201C;train&#x201D;.",name:"train_split"},{anchor:"autotrain.trainers.object_detection.params.ObjectDetectionParams.valid_split",description:"<strong>valid_split</strong> (Optional[str]) &#x2014; Name of the validation data split.",name:"valid_split"},{anchor:"autotrain.trainers.object_detection.params.ObjectDetectionParams.logging_steps",description:"<strong>logging_steps</strong> (int) &#x2014; Number of steps between logging. Default is -1.",name:"logging_steps"},{anchor:"autotrain.trainers.object_detection.params.ObjectDetectionParams.project_name",description:"<strong>project_name</strong> (str) &#x2014; Name of the project for output directory. Default is &#x201C;project-name&#x201D;.",name:"project_name"},{anchor:"autotrain.trainers.object_detection.params.ObjectDetectionParams.auto_find_batch_size",description:"<strong>auto_find_batch_size</strong> (bool) &#x2014; Whether to automatically find batch size. Default is False.",name:"auto_find_batch_size"},{anchor:"autotrain.trainers.object_detection.params.ObjectDetectionParams.mixed_precision",description:"<strong>mixed_precision</strong> (Optional[str]) &#x2014; Mixed precision type (fp16, bf16, or None).",name:"mixed_precision"},{anchor:"autotrain.trainers.object_detection.params.ObjectDetectionParams.save_total_limit",description:"<strong>save_total_limit</strong> (int) &#x2014; Total number of checkpoints to save. Default is 1.",name:"save_total_limit"},{anchor:"autotrain.trainers.object_detection.params.ObjectDetectionParams.token",description:"<strong>token</strong> (Optional[str]) &#x2014; Hub Token for authentication.",name:"token"},{anchor:"autotrain.trainers.object_detection.params.ObjectDetectionParams.push_to_hub",description:"<strong>push_to_hub</strong> (bool) &#x2014; Whether to push the model to the Hugging Face Hub. Default is False.",name:"push_to_hub"},{anchor:"autotrain.trainers.object_detection.params.ObjectDetectionParams.eval_strategy",description:"<strong>eval_strategy</strong> (str) &#x2014; Evaluation strategy. Default is &#x201C;epoch&#x201D;.",name:"eval_strategy"},{anchor:"autotrain.trainers.object_detection.params.ObjectDetectionParams.image_column",description:"<strong>image_column</strong> (str) &#x2014; Name of the image column in the dataset. Default is &#x201C;image&#x201D;.",name:"image_column"},{anchor:"autotrain.trainers.object_detection.params.ObjectDetectionParams.objects_column",description:"<strong>objects_column</strong> (str) &#x2014; Name of the target column in the dataset. Default is &#x201C;objects&#x201D;.",name:"objects_column"},{anchor:"autotrain.trainers.object_detection.params.ObjectDetectionParams.log",description:"<strong>log</strong> (str) &#x2014; Logging method for experiment tracking. Default is &#x201C;none&#x201D;.",name:"log"},{anchor:"autotrain.trainers.object_detection.params.ObjectDetectionParams.image_square_size",description:"<strong>image_square_size</strong> (Optional[int]) &#x2014; Longest size to which the image will be resized, then padded to square. Default is 600.",name:"image_square_size"},{anchor:"autotrain.trainers.object_detection.params.ObjectDetectionParams.early_stopping_patience",description:"<strong>early_stopping_patience</strong> (int) &#x2014; Number of epochs with no improvement after which training will be stopped. Default is 5.",name:"early_stopping_patience"},{anchor:"autotrain.trainers.object_detection.params.ObjectDetectionParams.early_stopping_threshold",description:"<strong>early_stopping_threshold</strong> (float) &#x2014; Minimum change to qualify as an improvement. Default is 0.01.",name:"early_stopping_threshold"}],source:"https://github.com/huggingface/autotrain-advanced/blob/vr_775/src/autotrain/trainers/object_detection/params.py#L8"}}),ca=new $({props:{title:"Tabular Tasks",local:"autotrain.trainers.tabular.params.TabularParams",headingTag:"h3"}}),pa=new b({props:{name:"class autotrain.trainers.tabular.params.TabularParams",anchor:"autotrain.trainers.tabular.params.TabularParams",parameters:[{name:"data_path",val:": str = None"},{name:"model",val:": str = 'xgboost'"},{name:"username",val:": typing.Optional[str] = None"},{name:"seed",val:": int = 42"},{name:"train_split",val:": str = 'train'"},{name:"valid_split",val:": typing.Optional[str] = None"},{name:"project_name",val:": str = 'project-name'"},{name:"token",val:": typing.Optional[str] = None"},{name:"push_to_hub",val:": bool = False"},{name:"id_column",val:": str = 'id'"},{name:"target_columns",val:": typing.Union[typing.List[str], str] = ['target']"},{name:"categorical_columns",val:": typing.Optional[typing.List[str]] = None"},{name:"numerical_columns",val:": typing.Optional[typing.List[str]] = None"},{name:"task",val:": str = 'classification'"},{name:"num_trials",val:": int = 10"},{name:"time_limit",val:": int = 600"},{name:"categorical_imputer",val:": typing.Optional[str] = None"},{name:"numerical_imputer",val:": typing.Optional[str] = None"},{name:"numeric_scaler",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"autotrain.trainers.tabular.params.TabularParams.data_path",description:"<strong>data_path</strong> (str) &#x2014; Path to the dataset.",name:"data_path"},{anchor:"autotrain.trainers.tabular.params.TabularParams.model",description:"<strong>model</strong> (str) &#x2014; Name of the model to use. Default is &#x201C;xgboost&#x201D;.",name:"model"},{anchor:"autotrain.trainers.tabular.params.TabularParams.username",description:"<strong>username</strong> (Optional[str]) &#x2014; Hugging Face Username.",name:"username"},{anchor:"autotrain.trainers.tabular.params.TabularParams.seed",description:"<strong>seed</strong> (int) &#x2014; Random seed for reproducibility. Default is 42.",name:"seed"},{anchor:"autotrain.trainers.tabular.params.TabularParams.train_split",description:"<strong>train_split</strong> (str) &#x2014; Name of the training data split. Default is &#x201C;train&#x201D;.",name:"train_split"},{anchor:"autotrain.trainers.tabular.params.TabularParams.valid_split",description:"<strong>valid_split</strong> (Optional[str]) &#x2014; Name of the validation data split.",name:"valid_split"},{anchor:"autotrain.trainers.tabular.params.TabularParams.project_name",description:"<strong>project_name</strong> (str) &#x2014; Name of the output directory. Default is &#x201C;project-name&#x201D;.",name:"project_name"},{anchor:"autotrain.trainers.tabular.params.TabularParams.token",description:"<strong>token</strong> (Optional[str]) &#x2014; Hub Token for authentication.",name:"token"},{anchor:"autotrain.trainers.tabular.params.TabularParams.push_to_hub",description:"<strong>push_to_hub</strong> (bool) &#x2014; Whether to push the model to the hub. Default is False.",name:"push_to_hub"},{anchor:"autotrain.trainers.tabular.params.TabularParams.id_column",description:"<strong>id_column</strong> (str) &#x2014; Name of the ID column. Default is &#x201C;id&#x201D;.",name:"id_column"},{anchor:"autotrain.trainers.tabular.params.TabularParams.target_columns",description:"<strong>target_columns</strong> (Union[List[str], str]) &#x2014; Target column(s) in the dataset. Default is [&#x201C;target&#x201D;].",name:"target_columns"},{anchor:"autotrain.trainers.tabular.params.TabularParams.categorical_columns",description:"<strong>categorical_columns</strong> (Optional[List[str]]) &#x2014; List of categorical columns.",name:"categorical_columns"},{anchor:"autotrain.trainers.tabular.params.TabularParams.numerical_columns",description:"<strong>numerical_columns</strong> (Optional[List[str]]) &#x2014; List of numerical columns.",name:"numerical_columns"},{anchor:"autotrain.trainers.tabular.params.TabularParams.task",description:"<strong>task</strong> (str) &#x2014; Type of task (e.g., &#x201C;classification&#x201D;). Default is &#x201C;classification&#x201D;.",name:"task"},{anchor:"autotrain.trainers.tabular.params.TabularParams.num_trials",description:"<strong>num_trials</strong> (int) &#x2014; Number of trials for hyperparameter optimization. Default is 10.",name:"num_trials"},{anchor:"autotrain.trainers.tabular.params.TabularParams.time_limit",description:"<strong>time_limit</strong> (int) &#x2014; Time limit for training in seconds. Default is 600.",name:"time_limit"},{anchor:"autotrain.trainers.tabular.params.TabularParams.categorical_imputer",description:"<strong>categorical_imputer</strong> (Optional[str]) &#x2014; Imputer strategy for categorical columns.",name:"categorical_imputer"},{anchor:"autotrain.trainers.tabular.params.TabularParams.numerical_imputer",description:"<strong>numerical_imputer</strong> (Optional[str]) &#x2014; Imputer strategy for numerical columns.",name:"numerical_imputer"},{anchor:"autotrain.trainers.tabular.params.TabularParams.numeric_scaler",description:"<strong>numeric_scaler</strong> (Optional[str]) &#x2014; Scaler strategy for numerical columns.",name:"numeric_scaler"}],source:"https://github.com/huggingface/autotrain-advanced/blob/vr_775/src/autotrain/trainers/tabular/params.py#L8"}}),ga=new de({props:{source:"https://github.com/huggingface/autotrain-advanced/blob/main/docs/source/quickstart_py.mdx"}}),{c(){D=i("meta"),Na=r(),ja=i("p"),ka=r(),l(L.$$.fragment),za=r(),O=i("p"),O.textContent=Rt,$a=r(),I=i("p"),I.textContent=Et,La=r(),l(S.$$.fragment),Oa=r(),J=i("p"),J.textContent=Ut,Ia=r(),l(F.$$.fragment),Sa=r(),R=i("p"),R.textContent=Wt,Ja=r(),l(E.$$.fragment),Fa=r(),U=i("p"),U.innerHTML=At,Ra=r(),W=i("p"),W.textContent=Ht,Ea=r(),l(A.$$.fragment),Ua=r(),H=i("p"),H.innerHTML=Qt,Wa=r(),Q=i("p"),Q.textContent=Vt,Aa=r(),l(V.$$.fragment),Ha=r(),h=i("div"),l(B.$$.fragment),Dt=r(),ua=i("p"),ua.textContent=Bt,Pt=r(),l(G.$$.fragment),yt=r(),_a=i("p"),_a.textContent=Gt,Tt=r(),da=i("ul"),da.innerHTML=Zt,wt=r(),l(Z.$$.fragment),Ct=r(),ha=i("p"),ha.innerHTML=Xt,Qa=r(),l(X.$$.fragment),Va=r(),l(Y.$$.fragment),Ba=r(),P=i("div"),l(K.$$.fragment),qt=r(),fa=i("p"),fa.textContent=Yt,Ga=r(),y=i("div"),l(aa.$$.fragment),jt=r(),xa=i("p"),xa.textContent=Kt,Za=r(),T=i("div"),l(ta.$$.fragment),Mt=r(),va=i("p"),va.textContent=ae,Xa=r(),w=i("div"),l(ea.$$.fragment),Nt=r(),ba=i("p"),ba.textContent=te,Ya=r(),C=i("div"),l(na.$$.fragment),kt=r(),Da=i("p"),Da.textContent=ee,Ka=r(),q=i("div"),l(ra.$$.fragment),zt=r(),Pa=i("p"),Pa.innerHTML=ne,at=r(),j=i("div"),l(sa.$$.fragment),$t=r(),ya=i("p"),ya.textContent=re,tt=r(),l(ia.$$.fragment),et=r(),M=i("div"),l(oa.$$.fragment),Lt=r(),Ta=i("p"),Ta.textContent=se,nt=r(),N=i("div"),l(ma.$$.fragment),Ot=r(),wa=i("p"),wa.textContent=ie,rt=r(),k=i("div"),l(la.$$.fragment),It=r(),Ca=i("p"),Ca.textContent=oe,st=r(),l(ca.$$.fragment),it=r(),z=i("div"),l(pa.$$.fragment),St=r(),qa=i("p"),qa.textContent=me,ot=r(),l(ga.$$.fragment),mt=r(),Ma=i("p"),this.h()},l(a){const e=_e("svelte-u9bgzb",document.head);D=o(e,"META",{name:!0,content:!0}),e.forEach(t),Na=s(a),ja=o(a,"P",{}),x(ja).forEach(t),ka=s(a),c(L.$$.fragment,a),za=s(a),O=o(a,"P",{"data-svelte-h":!0}),d(O)!=="svelte-iwwqyj"&&(O.textContent=Rt),$a=s(a),I=o(a,"P",{"data-svelte-h":!0}),d(I)!=="svelte-ss9rl9"&&(I.textContent=Et),La=s(a),c(S.$$.fragment,a),Oa=s(a),J=o(a,"P",{"data-svelte-h":!0}),d(J)!=="svelte-nz17j9"&&(J.textContent=Ut),Ia=s(a),c(F.$$.fragment,a),Sa=s(a),R=o(a,"P",{"data-svelte-h":!0}),d(R)!=="svelte-ourrjt"&&(R.textContent=Wt),Ja=s(a),c(E.$$.fragment,a),Fa=s(a),U=o(a,"P",{"data-svelte-h":!0}),d(U)!=="svelte-13i6wj2"&&(U.innerHTML=At),Ra=s(a),W=o(a,"P",{"data-svelte-h":!0}),d(W)!=="svelte-16fhw2p"&&(W.textContent=Ht),Ea=s(a),c(A.$$.fragment,a),Ua=s(a),H=o(a,"P",{"data-svelte-h":!0}),d(H)!=="svelte-3dlof2"&&(H.innerHTML=Qt),Wa=s(a),Q=o(a,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-1qrs7xw"&&(Q.textContent=Vt),Aa=s(a),c(V.$$.fragment,a),Ha=s(a),h=o(a,"DIV",{class:!0});var f=x(h);c(B.$$.fragment,f),Dt=s(f),ua=o(f,"P",{"data-svelte-h":!0}),d(ua)!=="svelte-1l0kpxz"&&(ua.textContent=Bt),Pt=s(f),c(G.$$.fragment,f),yt=s(f),_a=o(f,"P",{"data-svelte-h":!0}),d(_a)!=="svelte-1e89075"&&(_a.textContent=Gt),Tt=s(f),da=o(f,"UL",{"data-svelte-h":!0}),d(da)!=="svelte-1nhx34q"&&(da.innerHTML=Zt),wt=s(f),c(Z.$$.fragment,f),Ct=s(f),ha=o(f,"P",{"data-svelte-h":!0}),d(ha)!=="svelte-22o3hs"&&(ha.innerHTML=Xt),f.forEach(t),Qa=s(a),c(X.$$.fragment,a),Va=s(a),c(Y.$$.fragment,a),Ba=s(a),P=o(a,"DIV",{class:!0});var ct=x(P);c(K.$$.fragment,ct),qt=s(ct),fa=o(ct,"P",{"data-svelte-h":!0}),d(fa)!=="svelte-1ij51xj"&&(fa.textContent=Yt),ct.forEach(t),Ga=s(a),y=o(a,"DIV",{class:!0});var pt=x(y);c(aa.$$.fragment,pt),jt=s(pt),xa=o(pt,"P",{"data-svelte-h":!0}),d(xa)!=="svelte-17ktjs2"&&(xa.textContent=Kt),pt.forEach(t),Za=s(a),T=o(a,"DIV",{class:!0});var gt=x(T);c(ta.$$.fragment,gt),Mt=s(gt),va=o(gt,"P",{"data-svelte-h":!0}),d(va)!=="svelte-l9dn8j"&&(va.textContent=ae),gt.forEach(t),Xa=s(a),w=o(a,"DIV",{class:!0});var ut=x(w);c(ea.$$.fragment,ut),Nt=s(ut),ba=o(ut,"P",{"data-svelte-h":!0}),d(ba)!=="svelte-dqlvim"&&(ba.textContent=te),ut.forEach(t),Ya=s(a),C=o(a,"DIV",{class:!0});var _t=x(C);c(na.$$.fragment,_t),kt=s(_t),Da=o(_t,"P",{"data-svelte-h":!0}),d(Da)!=="svelte-vnbhrf"&&(Da.textContent=ee),_t.forEach(t),Ka=s(a),q=o(a,"DIV",{class:!0});var dt=x(q);c(ra.$$.fragment,dt),zt=s(dt),Pa=o(dt,"P",{"data-svelte-h":!0}),d(Pa)!=="svelte-1xpjeqj"&&(Pa.innerHTML=ne),dt.forEach(t),at=s(a),j=o(a,"DIV",{class:!0});var ht=x(j);c(sa.$$.fragment,ht),$t=s(ht),ya=o(ht,"P",{"data-svelte-h":!0}),d(ya)!=="svelte-39jvzx"&&(ya.textContent=re),ht.forEach(t),tt=s(a),c(ia.$$.fragment,a),et=s(a),M=o(a,"DIV",{class:!0});var ft=x(M);c(oa.$$.fragment,ft),Lt=s(ft),Ta=o(ft,"P",{"data-svelte-h":!0}),d(Ta)!=="svelte-1jyt9vi"&&(Ta.textContent=se),ft.forEach(t),nt=s(a),N=o(a,"DIV",{class:!0});var xt=x(N);c(ma.$$.fragment,xt),Ot=s(xt),wa=o(xt,"P",{"data-svelte-h":!0}),d(wa)!=="svelte-xdj7e2"&&(wa.textContent=ie),xt.forEach(t),rt=s(a),k=o(a,"DIV",{class:!0});var vt=x(k);c(la.$$.fragment,vt),It=s(vt),Ca=o(vt,"P",{"data-svelte-h":!0}),d(Ca)!=="svelte-cn0mw6"&&(Ca.textContent=oe),vt.forEach(t),st=s(a),c(ca.$$.fragment,a),it=s(a),z=o(a,"DIV",{class:!0});var bt=x(z);c(pa.$$.fragment,bt),St=s(bt),qa=o(bt,"P",{"data-svelte-h":!0}),d(qa)!=="svelte-u2hn7q"&&(qa.textContent=me),bt.forEach(t),ot=s(a),c(ga.$$.fragment,a),mt=s(a),Ma=o(a,"P",{}),x(Ma).forEach(t),this.h()},h(){v(D,"name","hf:doc:metadata"),v(D,"content",fe),v(h,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(a,e){m(document.head,D),n(a,Na,e),n(a,ja,e),n(a,ka,e),p(L,a,e),n(a,za,e),n(a,O,e),n(a,$a,e),n(a,I,e),n(a,La,e),p(S,a,e),n(a,Oa,e),n(a,J,e),n(a,Ia,e),p(F,a,e),n(a,Sa,e),n(a,R,e),n(a,Ja,e),p(E,a,e),n(a,Fa,e),n(a,U,e),n(a,Ra,e),n(a,W,e),n(a,Ea,e),p(A,a,e),n(a,Ua,e),n(a,H,e),n(a,Wa,e),n(a,Q,e),n(a,Aa,e),p(V,a,e),n(a,Ha,e),n(a,h,e),p(B,h,null),m(h,Dt),m(h,ua),m(h,Pt),p(G,h,null),m(h,yt),m(h,_a),m(h,Tt),m(h,da),m(h,wt),p(Z,h,null),m(h,Ct),m(h,ha),n(a,Qa,e),p(X,a,e),n(a,Va,e),p(Y,a,e),n(a,Ba,e),n(a,P,e),p(K,P,null),m(P,qt),m(P,fa),n(a,Ga,e),n(a,y,e),p(aa,y,null),m(y,jt),m(y,xa),n(a,Za,e),n(a,T,e),p(ta,T,null),m(T,Mt),m(T,va),n(a,Xa,e),n(a,w,e),p(ea,w,null),m(w,Nt),m(w,ba),n(a,Ya,e),n(a,C,e),p(na,C,null),m(C,kt),m(C,Da),n(a,Ka,e),n(a,q,e),p(ra,q,null),m(q,zt),m(q,Pa),n(a,at,e),n(a,j,e),p(sa,j,null),m(j,$t),m(j,ya),n(a,tt,e),p(ia,a,e),n(a,et,e),n(a,M,e),p(oa,M,null),m(M,Lt),m(M,Ta),n(a,nt,e),n(a,N,e),p(ma,N,null),m(N,Ot),m(N,wa),n(a,rt,e),n(a,k,e),p(la,k,null),m(k,It),m(k,Ca),n(a,st,e),p(ca,a,e),n(a,it,e),n(a,z,e),p(pa,z,null),m(z,St),m(z,qa),n(a,ot,e),p(ga,a,e),n(a,mt,e),n(a,Ma,e),lt=!0},p:ce,i(a){lt||(g(L.$$.fragment,a),g(S.$$.fragment,a),g(F.$$.fragment,a),g(E.$$.fragment,a),g(A.$$.fragment,a),g(V.$$.fragment,a),g(B.$$.fragment,a),g(G.$$.fragment,a),g(Z.$$.fragment,a),g(X.$$.fragment,a),g(Y.$$.fragment,a),g(K.$$.fragment,a),g(aa.$$.fragment,a),g(ta.$$.fragment,a),g(ea.$$.fragment,a),g(na.$$.fragment,a),g(ra.$$.fragment,a),g(sa.$$.fragment,a),g(ia.$$.fragment,a),g(oa.$$.fragment,a),g(ma.$$.fragment,a),g(la.$$.fragment,a),g(ca.$$.fragment,a),g(pa.$$.fragment,a),g(ga.$$.fragment,a),lt=!0)},o(a){u(L.$$.fragment,a),u(S.$$.fragment,a),u(F.$$.fragment,a),u(E.$$.fragment,a),u(A.$$.fragment,a),u(V.$$.fragment,a),u(B.$$.fragment,a),u(G.$$.fragment,a),u(Z.$$.fragment,a),u(X.$$.fragment,a),u(Y.$$.fragment,a),u(K.$$.fragment,a),u(aa.$$.fragment,a),u(ta.$$.fragment,a),u(ea.$$.fragment,a),u(na.$$.fragment,a),u(ra.$$.fragment,a),u(sa.$$.fragment,a),u(ia.$$.fragment,a),u(oa.$$.fragment,a),u(ma.$$.fragment,a),u(la.$$.fragment,a),u(ca.$$.fragment,a),u(pa.$$.fragment,a),u(ga.$$.fragment,a),lt=!1},d(a){a&&(t(Na),t(ja),t(ka),t(za),t(O),t($a),t(I),t(La),t(Oa),t(J),t(Ia),t(Sa),t(R),t(Ja),t(Fa),t(U),t(Ra),t(W),t(Ea),t(Ua),t(H),t(Wa),t(Q),t(Aa),t(Ha),t(h),t(Qa),t(Va),t(Ba),t(P),t(Ga),t(y),t(Za),t(T),t(Xa),t(w),t(Ya),t(C),t(Ka),t(q),t(at),t(j),t(tt),t(et),t(M),t(nt),t(N),t(rt),t(k),t(st),t(it),t(z),t(ot),t(mt),t(Ma)),t(D),_(L,a),_(S,a),_(F,a),_(E,a),_(A,a),_(V,a),_(B),_(G),_(Z),_(X,a),_(Y,a),_(K),_(aa),_(ta),_(ea),_(na),_(ra),_(sa),_(ia,a),_(oa),_(ma),_(la),_(ca,a),_(pa),_(ga,a)}}}const fe='{"title":"Quickstart with Python","local":"quickstart-with-python","sections":[{"title":"Getting Started","local":"getting-started","sections":[],"depth":2},{"title":"AutoTrainProject Class","local":"autotrain.project.AutoTrainProject","sections":[],"depth":2},{"title":"Attributes","local":"attributes","sections":[],"depth":2},{"title":"Methods","local":"methods","sections":[],"depth":2},{"title":"Parameters","local":"parameters","sections":[{"title":"Text Tasks","local":"autotrain.trainers.clm.params.LLMTrainingParams","sections":[],"depth":3},{"title":"Image Tasks","local":"autotrain.trainers.image_classification.params.ImageClassificationParams","sections":[],"depth":3},{"title":"Tabular Tasks","local":"autotrain.trainers.tabular.params.TabularParams","sections":[],"depth":3}],"depth":2}],"depth":1}';function xe(Ft){return pe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Te extends ge{constructor(D){super(),ue(this,D,xe,he,le,{})}}export{Te as component};
