import{s as sn,o as ln}from"../chunks/scheduler.37c15a92.js";import{S as en,i as nn,g as u,s as a,r as p,A as an,h,f as e,c as t,j as Ke,u as M,x as i,k as Oe,y as tn,a as n,v as r,d as m,t as y,w as j}from"../chunks/index.7cb9c9b8.js";import{Y as pn}from"../chunks/Youtube.8666c400.js";import{C as J}from"../chunks/CodeBlock.abae2786.js";import{C as Mn}from"../chunks/CourseFloatingBanner.df82c153.js";import{F as rn}from"../chunks/FrameworkSwitchCourse.97630871.js";import{H as T,E as mn}from"../chunks/getInferenceSnippets.725a12c2.js";function yn(Je){let c,Ws,b,zs,w,Xs,o,Gs,U,qs,d,Ls,I,ce="In this section, we’ll take a closer look at creating and using models. We’ll use the <code>AutoModel</code> class, which is handy when you want to instantiate any model from a checkpoint.",Fs,f,Ys,A,Te="Let’s begin by examining what happens when we instantiate an <code>AutoModel</code>:",Ps,k,Ks,$,be='Similar to the tokenizer, the <code>from_pretrained()</code> method will download and cache the model data from the Hugging Face Hub. As mentioned previously, the checkpoint name corresponds to a specific model architecture and weights, in this case a BERT model with a basic architecture (12 layers, 768 hidden size, 12 attention heads) and cased inputs (meaning that the uppercase/lowercase distinction is important). There are many checkpoints available on the Hub — you can explore them <a href="https://huggingface.co/models" rel="nofollow">here</a>.',Os,D,we="The <code>AutoModel</code> class and its associates are actually simple wrappers designed to fetch the appropriate model architecture for a given checkpoint. It’s an “auto” class meaning it will guess the appropriate model architecture for you and instantiate the correct model class. However, if you know the type of model you want to use, you can use the class that defines its architecture directly:",sl,C,ll,g,el,x,oe="Saving a model is as simple as saving a tokenizer. In fact, the models actually have the same <code>save_pretrained()</code> method, which saves the model’s weights and architecture configuration:",nl,E,al,Q,Ue="This will save two files to your disk:",tl,v,pl,N,de="If you look inside the <em>config.json</em> file, you’ll see all the necessary attributes needed to build the model architecture. This file also contains some metadata, such as where the checkpoint originated and what 🤗 Transformers version you were using when you last saved the checkpoint.",Ml,Z,Ie="The <em>pytorch_model.safetensors</em> file is known as the state dictionary; it contains all your model’s weights. The two files work together: the configuration file is needed to know about the model architecture, while the model weights are the parameters of the model.",rl,S,fe="To reuse a saved model, use the <code>from_pretrained()</code> method again:",ml,V,yl,_,Ae='A wonderful feature of the 🤗 Transformers library is the ability to easily share models and tokenizers with the community. To do this, make sure you have an account on <a href="https://huggingface.co" rel="nofollow">Hugging Face</a>. If you’re using a notebook, you can easily log in with this:',jl,B,ul,H,ke="Otherwise, at your terminal run:",hl,W,il,z,$e="Then you can push the model to the Hub with the <code>push_to_hub()</code> method:",Jl,R,cl,X,De="This will upload the model files to the Hub, in a repository under your namespace named <em>my-awesome-model</em>. Then, anyone can load your model with the <code>from_pretrained()</code> method!",Tl,G,bl,q,Ce="You can do a lot more with the Hub API:",wl,L,ge="<li>Push a model from a local repository</li> <li>Update specific files without re-uploading everything</li> <li>Add model cards to document the model’s abilities, limitations, known biases, etc.</li>",ol,F,xe='See <a href="https://huggingface.co/docs/huggingface_hub/how-to-upstream" rel="nofollow">the documentation</a> for a complete tutorial on this, or check out the advanced <a href="/course/chapter4">Chapter 4</a>.',Ul,Y,dl,P,Ee='Transformer models handle text by turning the inputs into numbers. Here we will look at exactly what happens when your text is processed by the tokenizer. We’ve already seen in <a href="/course/chapter1">Chapter 1</a> that tokenizers split the text into tokens and then convert these tokens into numbers. We can see this conversion through a simple tokenizer:',Il,K,fl,O,Al,ss,Qe="We get a dictionary with the following fields:",kl,ls,ve="<li>input_ids: numerical representations of your tokens</li> <li>token_type_ids: these tell the model which part of the input is sentence A and which is sentence B (discussed more in the next section)</li> <li>attention_mask: this indicates which tokens should be attended to and which should not (discussed more in a bit)</li>",$l,es,Ne="We can decode the input IDs to get back the original text:",Dl,ns,Cl,as,gl,ts,Ze="You’ll notice that the tokenizer has added special tokens — <code>[CLS]</code> and <code>[SEP]</code> — required by the model. Not all models need special tokens; they’re utilized when a model was pretrained with them, in which case the tokenizer needs to add them as that model expects these tokens.",xl,ps,Se="You can encode multiple sentences at once, either by batching them together (we’ll discuss this soon) or by passing a list:",El,Ms,Ql,rs,vl,ms,Ve="Note that when passing multiple sentences, the tokenizer returns a list for each sentence for each dictionary value. We can also ask the tokenizer to return tensors directly from PyTorch:",Nl,ys,Zl,js,Sl,us,_e="But there’s a problem: the two lists don’t have the same length! Arrays and tensors need to be rectangular, so we can’t simply convert these lists to a PyTorch tensor (or NumPy array). The tokenizer provides an option for that: padding.",Vl,hs,_l,is,Be="If we ask the tokenizer to pad the inputs, it will make all sentences the same length by adding a special padding token to the sentences that are shorter than the longest one:",Bl,Js,Hl,cs,Wl,Ts,He="Now we have rectangular tensors! Note that the padding tokens have been encoded into input IDs with ID 0, and they have an attention mask value of 0 as well. This is because those padding tokens shouldn’t be analyzed by the model: they’re not part of the actual sentence.",zl,bs,Rl,ws,We="The tensors might get too big to be processed by the model. For instance, BERT was only pretrained with sequences up to 512 tokens, so it cannot process longer sequences. If you have sequences longer than the model can handle, you’ll need to truncate them with the <code>truncation</code> parameter:",Xl,os,Gl,Us,ql,ds,ze="By combining the padding and truncation arguments, you can make sure your tensors have the exact size you need:",Ll,Is,Fl,fs,Yl,As,Pl,ks,Re="Special tokens (or at least the concept of them) is particularly important to BERT and derived models. These tokens are added to better represent the sentence boundaries, such as the beginning of a sentence (<code>[CLS]</code>) or separator between sentences (<code>[SEP]</code>). Let’s look at a simple example:",Kl,$s,Ol,Ds,se,Cs,Xe="These special tokens are automatically added by the tokenizer. Not all models need special tokens; they are primarily used when a model was pretrained with them, in which case the tokenizer will add them since the model expects them.",le,gs,ee,xs,Ge="Here’s a concrete example. Consider these encoded sequences:",ne,Es,ae,Qs,qe="Once tokenized, we have:",te,vs,pe,Ns,Le="This is a list of encoded sequences: a list of lists. Tensors only accept rectangular shapes (think matrices). This “array” is already of rectangular shape, so converting it to a tensor is easy:",Me,Zs,re,Ss,me,Vs,Fe="Making use of the tensors with the model is extremely simple — we just call the model with the inputs:",ye,_s,je,Bs,Ye=`While the model accepts a lot of different arguments, only the input IDs are necessary. We’ll explain what the other arguments do and when they are required later,
but first we need to take a closer look at the tokenizers that build the inputs that a Transformer model can understand.`,ue,Hs,he,Rs,ie;return w=new rn({props:{fw:Je[0]}}),o=new T({props:{title:"Models",local:"the-models",headingTag:"h1"}}),U=new Mn({props:{chapter:2,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter2/section3_pt.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter2/section3_pt.ipynb"}]}}),d=new pn({props:{id:"AhChOFRegn4"}}),f=new T({props:{title:"Creating a Transformer",local:"creating-a-transformer",headingTag:"h2"}}),k=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel

model = AutoModel.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)`,wrap:!1}}),C=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlcnRNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwQmVydE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertModel

model = BertModel.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)`,wrap:!1}}),g=new T({props:{title:"Loading and saving",local:"loading-and-saving",headingTag:"h2"}}),E=new J({props:{code:"bW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMmRpcmVjdG9yeV9vbl9teV9jb21wdXRlciUyMik=",highlighted:'model.save_pretrained(<span class="hljs-string">&quot;directory_on_my_computer&quot;</span>)',wrap:!1}}),v=new J({props:{code:"bHMlMjBkaXJlY3Rvcnlfb25fbXlfY29tcHV0ZXIlMEElMEFjb25maWcuanNvbiUyMG1vZGVsLnNhZmV0ZW5zb3Jz",highlighted:`ls <span class="hljs-keyword">directory_on_my_computer
</span>
<span class="hljs-built_in">config</span>.<span class="hljs-keyword">json </span>model.safetensors`,wrap:!1}}),V=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJkaXJlY3Rvcnlfb25fbXlfY29tcHV0ZXIlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel

model = AutoModel.from_pretrained(<span class="hljs-string">&quot;directory_on_my_computer&quot;</span>)`,wrap:!1}}),B=new J({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),W=new J({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),R=new J({props:{code:"bW9kZWwucHVzaF90b19odWIoJTIybXktYXdlc29tZS1tb2RlbCUyMik=",highlighted:'model.push_to_hub(<span class="hljs-string">&quot;my-awesome-model&quot;</span>)',wrap:!1}}),G=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJ5b3VyLXVzZXJuYW1lJTJGbXktYXdlc29tZS1tb2RlbCUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel

model = AutoModel.from_pretrained(<span class="hljs-string">&quot;your-username/my-awesome-model&quot;</span>)`,wrap:!1}}),Y=new T({props:{title:"Encoding text",local:"encoding-text",headingTag:"h2"}}),K=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBZW5jb2RlZF9pbnB1dCUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMEknbSUyMGElMjBzaW5nbGUlMjBzZW50ZW5jZSElMjIpJTBBcHJpbnQoZW5jb2RlZF9pbnB1dCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

encoded_input = tokenizer(<span class="hljs-string">&quot;Hello, I&#x27;m a single sentence!&quot;</span>)
<span class="hljs-built_in">print</span>(encoded_input)`,wrap:!1}}),O=new J({props:{code:"JTdCJ2lucHV0X2lkcyclM0ElMjAlNUIxMDElMkMlMjA4NjY3JTJDJTIwMTE3JTJDJTIwMTAwMCUyQyUyMDEwNDUlMkMlMjAxMDA1JTJDJTIwMTA0OSUyQyUyMDIyMzUlMkMlMjAxNzY2MiUyQyUyMDEyMTcyJTJDJTIwMTAxMiUyQyUyMDEwMiU1RCUyQyUyMCUwQSUyMCd0b2tlbl90eXBlX2lkcyclM0ElMjAlNUIwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlNUQlMkMlMjAlMEElMjAnYXR0ZW50aW9uX21hc2snJTNBJTIwJTVCMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTVEJTdE",highlighted:`{<span class="hljs-string">&#x27;input_ids&#x27;</span>: [<span class="hljs-number">101</span>, <span class="hljs-number">8667</span>, <span class="hljs-number">117</span>, <span class="hljs-number">1000</span>, <span class="hljs-number">1045</span>, <span class="hljs-number">1005</span>, <span class="hljs-number">1049</span>, <span class="hljs-number">2235</span>, <span class="hljs-number">17662</span>, <span class="hljs-number">12172</span>, <span class="hljs-number">1012</span>, <span class="hljs-number">102</span>], 
 <span class="hljs-string">&#x27;token_type_ids&#x27;</span>: [<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>], 
 <span class="hljs-string">&#x27;attention_mask&#x27;</span>: [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]}`,wrap:!1}}),ns=new J({props:{code:"dG9rZW5pemVyLmRlY29kZShlbmNvZGVkX2lucHV0JTVCJTIyaW5wdXRfaWRzJTIyJTVEKQ==",highlighted:'tokenizer.decode(encoded_input[<span class="hljs-string">&quot;input_ids&quot;</span>])',wrap:!1}}),as=new J({props:{code:"JTIyJTVCQ0xTJTVEJTIwSGVsbG8lMkMlMjBJJ20lMjBhJTIwc2luZ2xlJTIwc2VudGVuY2UhJTIwJTVCU0VQJTVEJTIy",highlighted:'<span class="hljs-string">&quot;[CLS] Hello, I&#x27;m a single sentence! [SEP]&quot;</span>',wrap:!1}}),Ms=new J({props:{code:"ZW5jb2RlZF9pbnB1dCUyMCUzRCUyMHRva2VuaXplciglMjJIb3clMjBhcmUlMjB5b3UlM0YlMjIlMkMlMjAlMjJJJ20lMjBmaW5lJTJDJTIwdGhhbmslMjB5b3UhJTIyKSUwQXByaW50KGVuY29kZWRfaW5wdXQp",highlighted:`encoded_input = tokenizer(<span class="hljs-string">&quot;How are you?&quot;</span>, <span class="hljs-string">&quot;I&#x27;m fine, thank you!&quot;</span>)
<span class="hljs-built_in">print</span>(encoded_input)`,wrap:!1}}),rs=new J({props:{code:"JTdCJ2lucHV0X2lkcyclM0ElMjAlNUIlNUIxMDElMkMlMjAxNzMxJTJDJTIwMTEzMiUyQyUyMDExMjglMkMlMjAxMzYlMkMlMjAxMDIlNUQlMkMlMjAlNUIxMDElMkMlMjAxMDQ1JTJDJTIwMTAwNSUyQyUyMDEwNDklMkMlMjAyNTAzJTJDJTIwMTE3JTJDJTIwNTc2MyUyQyUyMDExMjglMkMlMjAxMzYlMkMlMjAxMDIlNUQlNUQlMkMlMjAlMEElMjAndG9rZW5fdHlwZV9pZHMnJTNBJTIwJTVCJTVCMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTVEJTJDJTIwJTVCMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCU1RCU1RCUyQyUyMCUwQSUyMCdhdHRlbnRpb25fbWFzayclM0ElMjAlNUIlNUIxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElNUQlMkMlMjAlNUIxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTVEJTVEJTdE",highlighted:`{<span class="hljs-string">&#x27;input_ids&#x27;</span>: [[<span class="hljs-number">101</span>, <span class="hljs-number">1731</span>, <span class="hljs-number">1132</span>, <span class="hljs-number">1128</span>, <span class="hljs-number">136</span>, <span class="hljs-number">102</span>], [<span class="hljs-number">101</span>, <span class="hljs-number">1045</span>, <span class="hljs-number">1005</span>, <span class="hljs-number">1049</span>, <span class="hljs-number">2503</span>, <span class="hljs-number">117</span>, <span class="hljs-number">5763</span>, <span class="hljs-number">1128</span>, <span class="hljs-number">136</span>, <span class="hljs-number">102</span>]], 
 <span class="hljs-string">&#x27;token_type_ids&#x27;</span>: [[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>], [<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>]], 
 <span class="hljs-string">&#x27;attention_mask&#x27;</span>: [[<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>], [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]]}`,wrap:!1}}),ys=new J({props:{code:"ZW5jb2RlZF9pbnB1dCUyMCUzRCUyMHRva2VuaXplciglMjJIb3clMjBhcmUlMjB5b3UlM0YlMjIlMkMlMjAlMjJJJ20lMjBmaW5lJTJDJTIwdGhhbmslMjB5b3UhJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFwcmludChlbmNvZGVkX2lucHV0KQ==",highlighted:`encoded_input = tokenizer(<span class="hljs-string">&quot;How are you?&quot;</span>, <span class="hljs-string">&quot;I&#x27;m fine, thank you!&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-built_in">print</span>(encoded_input)`,wrap:!1}}),js=new J({props:{code:"JTdCJ2lucHV0X2lkcyclM0ElMjB0ZW5zb3IoJTVCJTVCJTIwJTIwMTAxJTJDJTIwJTIwMTczMSUyQyUyMCUyMDExMzIlMkMlMjAlMjAxMTI4JTJDJTIwJTIwJTIwMTM2JTJDJTIwJTIwJTIwMTAyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCJTIwJTIwMTAxJTJDJTIwJTIwMTA0NSUyQyUyMCUyMDEwMDUlMkMlMjAlMjAxMDQ5JTJDJTIwJTIwMjUwMyUyQyUyMCUyMCUyMDExNyUyQyUyMCUyMDU3NjMlMkMlMjAlMjAxMTI4JTJDJTIwJTIwJTIwMTM2JTJDJTIwJTIwJTIwMTAyJTVEJTVEKSUyQyUyMCUwQSUyMCd0b2tlbl90eXBlX2lkcyclM0ElMjB0ZW5zb3IoJTVCJTVCMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCU1RCU1RCklMkMlMjAlMEElMjAnYXR0ZW50aW9uX21hc2snJTNBJTIwdGVuc29yKCU1QiU1QjElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QjElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElNUQlNUQpJTdE",highlighted:`{<span class="hljs-string">&#x27;input_ids&#x27;</span>: tensor([[  <span class="hljs-number">101</span>,  <span class="hljs-number">1731</span>,  <span class="hljs-number">1132</span>,  <span class="hljs-number">1128</span>,   <span class="hljs-number">136</span>,   <span class="hljs-number">102</span>],
         [  <span class="hljs-number">101</span>,  <span class="hljs-number">1045</span>,  <span class="hljs-number">1005</span>,  <span class="hljs-number">1049</span>,  <span class="hljs-number">2503</span>,   <span class="hljs-number">117</span>,  <span class="hljs-number">5763</span>,  <span class="hljs-number">1128</span>,   <span class="hljs-number">136</span>,   <span class="hljs-number">102</span>]]), 
 <span class="hljs-string">&#x27;token_type_ids&#x27;</span>: tensor([[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>],
         [<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>]]), 
 <span class="hljs-string">&#x27;attention_mask&#x27;</span>: tensor([[<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
         [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]])}`,wrap:!1}}),hs=new T({props:{title:"Padding inputs",local:"padding-inputs",headingTag:"h3"}}),Js=new J({props:{code:"ZW5jb2RlZF9pbnB1dCUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjAlNUIlMjJIb3clMjBhcmUlMjB5b3UlM0YlMjIlMkMlMjAlMjJJJ20lMjBmaW5lJTJDJTIwdGhhbmslMjB5b3UhJTIyJTVEJTJDJTIwcGFkZGluZyUzRFRydWUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTBBKSUwQXByaW50KGVuY29kZWRfaW5wdXQp",highlighted:`encoded_input = tokenizer(
    [<span class="hljs-string">&quot;How are you?&quot;</span>, <span class="hljs-string">&quot;I&#x27;m fine, thank you!&quot;</span>], padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
)
<span class="hljs-built_in">print</span>(encoded_input)`,wrap:!1}}),cs=new J({props:{code:"JTdCJ2lucHV0X2lkcyclM0ElMjB0ZW5zb3IoJTVCJTVCJTIwJTIwMTAxJTJDJTIwJTIwMTczMSUyQyUyMCUyMDExMzIlMkMlMjAlMjAxMTI4JTJDJTIwJTIwJTIwMTM2JTJDJTIwJTIwJTIwMTAyJTJDJTIwJTIwJTIwJTIwJTIwMCUyQyUyMCUyMCUyMCUyMCUyMDAlMkMlMjAlMjAlMjAlMjAlMjAwJTJDJTIwJTIwJTIwJTIwJTIwMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiUyMCUyMDEwMSUyQyUyMCUyMDEwNDUlMkMlMjAlMjAxMDA1JTJDJTIwJTIwMTA0OSUyQyUyMCUyMDI1MDMlMkMlMjAlMjAlMjAxMTclMkMlMjAlMjA1NzYzJTJDJTIwJTIwMTEyOCUyQyUyMCUyMCUyMDEzNiUyQyUyMCUyMCUyMDEwMiU1RCU1RCklMkMlMjAlMEElMjAndG9rZW5fdHlwZV9pZHMnJTNBJTIwdGVuc29yKCU1QiU1QjAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTVEJTVEKSUyQyUyMCUwQSUyMCdhdHRlbnRpb25fbWFzayclM0ElMjB0ZW5zb3IoJTVCJTVCMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QjElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElNUQlNUQpJTdE",highlighted:`{<span class="hljs-string">&#x27;input_ids&#x27;</span>: tensor([[  <span class="hljs-number">101</span>,  <span class="hljs-number">1731</span>,  <span class="hljs-number">1132</span>,  <span class="hljs-number">1128</span>,   <span class="hljs-number">136</span>,   <span class="hljs-number">102</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>,     <span class="hljs-number">0</span>],
         [  <span class="hljs-number">101</span>,  <span class="hljs-number">1045</span>,  <span class="hljs-number">1005</span>,  <span class="hljs-number">1049</span>,  <span class="hljs-number">2503</span>,   <span class="hljs-number">117</span>,  <span class="hljs-number">5763</span>,  <span class="hljs-number">1128</span>,   <span class="hljs-number">136</span>,   <span class="hljs-number">102</span>]]), 
 <span class="hljs-string">&#x27;token_type_ids&#x27;</span>: tensor([[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>],
         [<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>]]), 
 <span class="hljs-string">&#x27;attention_mask&#x27;</span>: tensor([[<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>],
         [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]])}`,wrap:!1}}),bs=new T({props:{title:"Truncating inputs",local:"truncating-inputs",headingTag:"h3"}}),os=new J({props:{code:"ZW5jb2RlZF9pbnB1dCUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjAlMjJUaGlzJTIwaXMlMjBhJTIwdmVyeSUyMHZlcnklMjB2ZXJ5JTIwdmVyeSUyMHZlcnklMjB2ZXJ5JTIwdmVyeSUyMHZlcnklMjB2ZXJ5JTIwdmVyeSUyMHZlcnklMjB2ZXJ5JTIwdmVyeSUyMHZlcnklMjB2ZXJ5JTIwdmVyeSUyMHZlcnklMjB2ZXJ5JTIwdmVyeSUyMHZlcnklMjB2ZXJ5JTIwdmVyeSUyMHZlcnklMjB2ZXJ5JTIwdmVyeSUyMHZlcnklMjB2ZXJ5JTIwdmVyeSUyMHZlcnklMjB2ZXJ5JTIwdmVyeSUyMHZlcnklMjB2ZXJ5JTIwdmVyeSUyMHZlcnklMjB2ZXJ5JTIwdmVyeSUyMHZlcnklMjB2ZXJ5JTIwdmVyeSUyMHZlcnklMjB2ZXJ5JTIwdmVyeSUyMHZlcnklMjB2ZXJ5JTIwdmVyeSUyMHZlcnklMjB2ZXJ5JTIwdmVyeSUyMGxvbmclMjBzZW50ZW5jZS4lMjIlMkMlMEElMjAlMjAlMjAlMjB0cnVuY2F0aW9uJTNEVHJ1ZSUyQyUwQSklMEFwcmludChlbmNvZGVkX2lucHV0JTVCJTIyaW5wdXRfaWRzJTIyJTVEKQ==",highlighted:`encoded_input = tokenizer(
    <span class="hljs-string">&quot;This is a very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very long sentence.&quot;</span>,
    truncation=<span class="hljs-literal">True</span>,
)
<span class="hljs-built_in">print</span>(encoded_input[<span class="hljs-string">&quot;input_ids&quot;</span>])`,wrap:!1}}),Us=new J({props:{code:"JTVCMTAxJTJDJTIwMTE4OCUyQyUyMDExMTAlMkMlMjAxNzAlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTUwNSUyQyUyMDE1MDUlMkMlMjAxNTA1JTJDJTIwMTE3OSUyQyUyMDU2NTAlMkMlMjAxMTklMkMlMjAxMDIlNUQ=",highlighted:'[<span class="hljs-number">101</span>, <span class="hljs-number">1188</span>, <span class="hljs-number">1110</span>, <span class="hljs-number">170</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1505</span>, <span class="hljs-number">1179</span>, <span class="hljs-number">5650</span>, <span class="hljs-number">119</span>, <span class="hljs-number">102</span>]',wrap:!1}}),Is=new J({props:{code:"ZW5jb2RlZF9pbnB1dCUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjAlNUIlMjJIb3clMjBhcmUlMjB5b3UlM0YlMjIlMkMlMjAlMjJJJ20lMjBmaW5lJTJDJTIwdGhhbmslMjB5b3UhJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwcGFkZGluZyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjB0cnVuY2F0aW9uJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG1heF9sZW5ndGglM0Q1JTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUwQSklMEFwcmludChlbmNvZGVkX2lucHV0KQ==",highlighted:`encoded_input = tokenizer(
    [<span class="hljs-string">&quot;How are you?&quot;</span>, <span class="hljs-string">&quot;I&#x27;m fine, thank you!&quot;</span>],
    padding=<span class="hljs-literal">True</span>,
    truncation=<span class="hljs-literal">True</span>,
    max_length=<span class="hljs-number">5</span>,
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
)
<span class="hljs-built_in">print</span>(encoded_input)`,wrap:!1}}),fs=new J({props:{code:"JTdCJ2lucHV0X2lkcyclM0ElMjB0ZW5zb3IoJTVCJTVCJTIwJTIwMTAxJTJDJTIwJTIwMTczMSUyQyUyMCUyMDExMzIlMkMlMjAlMjAxMTI4JTJDJTIwJTIwJTIwMTAyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCJTIwJTIwMTAxJTJDJTIwJTIwMTA0NSUyQyUyMCUyMDEwMDUlMkMlMjAlMjAxMDQ5JTJDJTIwJTIwJTIwMTAyJTVEJTVEKSUyQyUyMCUwQSUyMCd0b2tlbl90eXBlX2lkcyclM0ElMjB0ZW5zb3IoJTVCJTVCMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCU1RCU1RCklMkMlMjAlMEElMjAnYXR0ZW50aW9uX21hc2snJTNBJTIwdGVuc29yKCU1QiU1QjElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElNUQlNUQpJTdE",highlighted:`{<span class="hljs-string">&#x27;input_ids&#x27;</span>: tensor([[  <span class="hljs-number">101</span>,  <span class="hljs-number">1731</span>,  <span class="hljs-number">1132</span>,  <span class="hljs-number">1128</span>,   <span class="hljs-number">102</span>],
         [  <span class="hljs-number">101</span>,  <span class="hljs-number">1045</span>,  <span class="hljs-number">1005</span>,  <span class="hljs-number">1049</span>,   <span class="hljs-number">102</span>]]), 
 <span class="hljs-string">&#x27;token_type_ids&#x27;</span>: tensor([[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>],
         [<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>]]), 
 <span class="hljs-string">&#x27;attention_mask&#x27;</span>: tensor([[<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
         [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]])}`,wrap:!1}}),As=new T({props:{title:"Adding special tokens",local:"adding-special-tokens",headingTag:"h3"}}),$s=new J({props:{code:"ZW5jb2RlZF9pbnB1dCUyMCUzRCUyMHRva2VuaXplciglMjJIb3clMjBhcmUlMjB5b3UlM0YlMjIpJTBBcHJpbnQoZW5jb2RlZF9pbnB1dCU1QiUyMmlucHV0X2lkcyUyMiU1RCklMEF0b2tlbml6ZXIuZGVjb2RlKGVuY29kZWRfaW5wdXQlNUIlMjJpbnB1dF9pZHMlMjIlNUQp",highlighted:`encoded_input = tokenizer(<span class="hljs-string">&quot;How are you?&quot;</span>)
<span class="hljs-built_in">print</span>(encoded_input[<span class="hljs-string">&quot;input_ids&quot;</span>])
tokenizer.decode(encoded_input[<span class="hljs-string">&quot;input_ids&quot;</span>])`,wrap:!1}}),Ds=new J({props:{code:"JTVCMTAxJTJDJTIwMTczMSUyQyUyMDExMzIlMkMlMjAxMTI4JTJDJTIwMTM2JTJDJTIwMTAyJTVEJTBBJyU1QkNMUyU1RCUyMEhvdyUyMGFyZSUyMHlvdSUzRiUyMCU1QlNFUCU1RCc=",highlighted:`[<span class="hljs-number">101</span>, <span class="hljs-number">1731</span>, <span class="hljs-number">1132</span>, <span class="hljs-number">1128</span>, <span class="hljs-number">136</span>, <span class="hljs-number">102</span>]
<span class="hljs-string">&#x27;[CLS] How are you? [SEP]&#x27;</span>`,wrap:!1}}),gs=new T({props:{title:"Why is all of this necessary?",local:"why-is-all-of-this-necessary",headingTag:"h3"}}),Es=new J({props:{code:"c2VxdWVuY2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIySSd2ZSUyMGJlZW4lMjB3YWl0aW5nJTIwZm9yJTIwYSUyMEh1Z2dpbmdGYWNlJTIwY291cnNlJTIwbXklMjB3aG9sZSUyMGxpZmUuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIySSUyMGhhdGUlMjB0aGlzJTIwc28lMjBtdWNoISUyMiUyQyUwQSU1RA==",highlighted:`sequences = [
    <span class="hljs-string">&quot;I&#x27;ve been waiting for a HuggingFace course my whole life.&quot;</span>,
    <span class="hljs-string">&quot;I hate this so much!&quot;</span>,
]`,wrap:!1}}),vs=new J({props:{code:"ZW5jb2RlZF9zZXF1ZW5jZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAxMDElMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAxMDQ1JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMTAwNSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDIzMTAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAyMDQyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMzQwMyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDIwMDUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAxMDM3JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMTc2NjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAxMjE3MiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDI2MDclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAyMDI2JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMjg3OCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDIxNjYlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAxMDEyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMTAyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTVCMTAxJTJDJTIwMTA0NSUyQyUyMDUyMjMlMkMlMjAyMDIzJTJDJTIwMjA2MSUyQyUyMDIxNzIlMkMlMjA5OTklMkMlMjAxMDIlNUQlMkMlMEElNUQ=",highlighted:`encoded_sequences = [
    [
        <span class="hljs-number">101</span>,
        <span class="hljs-number">1045</span>,
        <span class="hljs-number">1005</span>,
        <span class="hljs-number">2310</span>,
        <span class="hljs-number">2042</span>,
        <span class="hljs-number">3403</span>,
        <span class="hljs-number">2005</span>,
        <span class="hljs-number">1037</span>,
        <span class="hljs-number">17662</span>,
        <span class="hljs-number">12172</span>,
        <span class="hljs-number">2607</span>,
        <span class="hljs-number">2026</span>,
        <span class="hljs-number">2878</span>,
        <span class="hljs-number">2166</span>,
        <span class="hljs-number">1012</span>,
        <span class="hljs-number">102</span>,
    ],
    [<span class="hljs-number">101</span>, <span class="hljs-number">1045</span>, <span class="hljs-number">5223</span>, <span class="hljs-number">2023</span>, <span class="hljs-number">2061</span>, <span class="hljs-number">2172</span>, <span class="hljs-number">999</span>, <span class="hljs-number">102</span>],
]`,wrap:!1}}),Zs=new J({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pbnB1dHMlMjAlM0QlMjB0b3JjaC50ZW5zb3IoZW5jb2RlZF9zZXF1ZW5jZXMp",highlighted:`<span class="hljs-keyword">import</span> torch

model_inputs = torch.tensor(encoded_sequences)`,wrap:!1}}),Ss=new T({props:{title:"Using the tensors as inputs to the model",local:"using-the-tensors-as-inputs-to-the-model",headingTag:"h3"}}),_s=new J({props:{code:"b3V0cHV0JTIwJTNEJTIwbW9kZWwobW9kZWxfaW5wdXRzKQ==",highlighted:"output = model(model_inputs)",wrap:!1}}),Hs=new mn({props:{source:"https://github.com/huggingface/course/blob/main/chapters/en/chapter2/3.mdx"}}),{c(){c=u("meta"),Ws=a(),b=u("p"),zs=a(),p(w.$$.fragment),Xs=a(),p(o.$$.fragment),Gs=a(),p(U.$$.fragment),qs=a(),p(d.$$.fragment),Ls=a(),I=u("p"),I.innerHTML=ce,Fs=a(),p(f.$$.fragment),Ys=a(),A=u("p"),A.innerHTML=Te,Ps=a(),p(k.$$.fragment),Ks=a(),$=u("p"),$.innerHTML=be,Os=a(),D=u("p"),D.innerHTML=we,sl=a(),p(C.$$.fragment),ll=a(),p(g.$$.fragment),el=a(),x=u("p"),x.innerHTML=oe,nl=a(),p(E.$$.fragment),al=a(),Q=u("p"),Q.textContent=Ue,tl=a(),p(v.$$.fragment),pl=a(),N=u("p"),N.innerHTML=de,Ml=a(),Z=u("p"),Z.innerHTML=Ie,rl=a(),S=u("p"),S.innerHTML=fe,ml=a(),p(V.$$.fragment),yl=a(),_=u("p"),_.innerHTML=Ae,jl=a(),p(B.$$.fragment),ul=a(),H=u("p"),H.textContent=ke,hl=a(),p(W.$$.fragment),il=a(),z=u("p"),z.innerHTML=$e,Jl=a(),p(R.$$.fragment),cl=a(),X=u("p"),X.innerHTML=De,Tl=a(),p(G.$$.fragment),bl=a(),q=u("p"),q.textContent=Ce,wl=a(),L=u("ul"),L.innerHTML=ge,ol=a(),F=u("p"),F.innerHTML=xe,Ul=a(),p(Y.$$.fragment),dl=a(),P=u("p"),P.innerHTML=Ee,Il=a(),p(K.$$.fragment),fl=a(),p(O.$$.fragment),Al=a(),ss=u("p"),ss.textContent=Qe,kl=a(),ls=u("ul"),ls.innerHTML=ve,$l=a(),es=u("p"),es.textContent=Ne,Dl=a(),p(ns.$$.fragment),Cl=a(),p(as.$$.fragment),gl=a(),ts=u("p"),ts.innerHTML=Ze,xl=a(),ps=u("p"),ps.textContent=Se,El=a(),p(Ms.$$.fragment),Ql=a(),p(rs.$$.fragment),vl=a(),ms=u("p"),ms.textContent=Ve,Nl=a(),p(ys.$$.fragment),Zl=a(),p(js.$$.fragment),Sl=a(),us=u("p"),us.textContent=_e,Vl=a(),p(hs.$$.fragment),_l=a(),is=u("p"),is.textContent=Be,Bl=a(),p(Js.$$.fragment),Hl=a(),p(cs.$$.fragment),Wl=a(),Ts=u("p"),Ts.textContent=He,zl=a(),p(bs.$$.fragment),Rl=a(),ws=u("p"),ws.innerHTML=We,Xl=a(),p(os.$$.fragment),Gl=a(),p(Us.$$.fragment),ql=a(),ds=u("p"),ds.textContent=ze,Ll=a(),p(Is.$$.fragment),Fl=a(),p(fs.$$.fragment),Yl=a(),p(As.$$.fragment),Pl=a(),ks=u("p"),ks.innerHTML=Re,Kl=a(),p($s.$$.fragment),Ol=a(),p(Ds.$$.fragment),se=a(),Cs=u("p"),Cs.textContent=Xe,le=a(),p(gs.$$.fragment),ee=a(),xs=u("p"),xs.textContent=Ge,ne=a(),p(Es.$$.fragment),ae=a(),Qs=u("p"),Qs.textContent=qe,te=a(),p(vs.$$.fragment),pe=a(),Ns=u("p"),Ns.textContent=Le,Me=a(),p(Zs.$$.fragment),re=a(),p(Ss.$$.fragment),me=a(),Vs=u("p"),Vs.textContent=Fe,ye=a(),p(_s.$$.fragment),je=a(),Bs=u("p"),Bs.textContent=Ye,ue=a(),p(Hs.$$.fragment),he=a(),Rs=u("p"),this.h()},l(s){const l=an("svelte-u9bgzb",document.head);c=h(l,"META",{name:!0,content:!0}),l.forEach(e),Ws=t(s),b=h(s,"P",{}),Ke(b).forEach(e),zs=t(s),M(w.$$.fragment,s),Xs=t(s),M(o.$$.fragment,s),Gs=t(s),M(U.$$.fragment,s),qs=t(s),M(d.$$.fragment,s),Ls=t(s),I=h(s,"P",{"data-svelte-h":!0}),i(I)!=="svelte-1nloweu"&&(I.innerHTML=ce),Fs=t(s),M(f.$$.fragment,s),Ys=t(s),A=h(s,"P",{"data-svelte-h":!0}),i(A)!=="svelte-17aypug"&&(A.innerHTML=Te),Ps=t(s),M(k.$$.fragment,s),Ks=t(s),$=h(s,"P",{"data-svelte-h":!0}),i($)!=="svelte-1rqsf14"&&($.innerHTML=be),Os=t(s),D=h(s,"P",{"data-svelte-h":!0}),i(D)!=="svelte-gay9y4"&&(D.innerHTML=we),sl=t(s),M(C.$$.fragment,s),ll=t(s),M(g.$$.fragment,s),el=t(s),x=h(s,"P",{"data-svelte-h":!0}),i(x)!=="svelte-hdwas9"&&(x.innerHTML=oe),nl=t(s),M(E.$$.fragment,s),al=t(s),Q=h(s,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-1mevt8f"&&(Q.textContent=Ue),tl=t(s),M(v.$$.fragment,s),pl=t(s),N=h(s,"P",{"data-svelte-h":!0}),i(N)!=="svelte-1dlg86"&&(N.innerHTML=de),Ml=t(s),Z=h(s,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-1lituvv"&&(Z.innerHTML=Ie),rl=t(s),S=h(s,"P",{"data-svelte-h":!0}),i(S)!=="svelte-1h4c2vc"&&(S.innerHTML=fe),ml=t(s),M(V.$$.fragment,s),yl=t(s),_=h(s,"P",{"data-svelte-h":!0}),i(_)!=="svelte-ddgh4s"&&(_.innerHTML=Ae),jl=t(s),M(B.$$.fragment,s),ul=t(s),H=h(s,"P",{"data-svelte-h":!0}),i(H)!=="svelte-l3oiw9"&&(H.textContent=ke),hl=t(s),M(W.$$.fragment,s),il=t(s),z=h(s,"P",{"data-svelte-h":!0}),i(z)!=="svelte-1pzfpy5"&&(z.innerHTML=$e),Jl=t(s),M(R.$$.fragment,s),cl=t(s),X=h(s,"P",{"data-svelte-h":!0}),i(X)!=="svelte-1nxdobe"&&(X.innerHTML=De),Tl=t(s),M(G.$$.fragment,s),bl=t(s),q=h(s,"P",{"data-svelte-h":!0}),i(q)!=="svelte-1wh37ph"&&(q.textContent=Ce),wl=t(s),L=h(s,"UL",{"data-svelte-h":!0}),i(L)!=="svelte-103qsj1"&&(L.innerHTML=ge),ol=t(s),F=h(s,"P",{"data-svelte-h":!0}),i(F)!=="svelte-1ml54wi"&&(F.innerHTML=xe),Ul=t(s),M(Y.$$.fragment,s),dl=t(s),P=h(s,"P",{"data-svelte-h":!0}),i(P)!=="svelte-1i2mfbj"&&(P.innerHTML=Ee),Il=t(s),M(K.$$.fragment,s),fl=t(s),M(O.$$.fragment,s),Al=t(s),ss=h(s,"P",{"data-svelte-h":!0}),i(ss)!=="svelte-mgm01i"&&(ss.textContent=Qe),kl=t(s),ls=h(s,"UL",{"data-svelte-h":!0}),i(ls)!=="svelte-1n80xkj"&&(ls.innerHTML=ve),$l=t(s),es=h(s,"P",{"data-svelte-h":!0}),i(es)!=="svelte-954hsi"&&(es.textContent=Ne),Dl=t(s),M(ns.$$.fragment,s),Cl=t(s),M(as.$$.fragment,s),gl=t(s),ts=h(s,"P",{"data-svelte-h":!0}),i(ts)!=="svelte-w3oug8"&&(ts.innerHTML=Ze),xl=t(s),ps=h(s,"P",{"data-svelte-h":!0}),i(ps)!=="svelte-kdmifw"&&(ps.textContent=Se),El=t(s),M(Ms.$$.fragment,s),Ql=t(s),M(rs.$$.fragment,s),vl=t(s),ms=h(s,"P",{"data-svelte-h":!0}),i(ms)!=="svelte-zcnpfw"&&(ms.textContent=Ve),Nl=t(s),M(ys.$$.fragment,s),Zl=t(s),M(js.$$.fragment,s),Sl=t(s),us=h(s,"P",{"data-svelte-h":!0}),i(us)!=="svelte-1jvf30l"&&(us.textContent=_e),Vl=t(s),M(hs.$$.fragment,s),_l=t(s),is=h(s,"P",{"data-svelte-h":!0}),i(is)!=="svelte-1frpdsp"&&(is.textContent=Be),Bl=t(s),M(Js.$$.fragment,s),Hl=t(s),M(cs.$$.fragment,s),Wl=t(s),Ts=h(s,"P",{"data-svelte-h":!0}),i(Ts)!=="svelte-1dmy5z2"&&(Ts.textContent=He),zl=t(s),M(bs.$$.fragment,s),Rl=t(s),ws=h(s,"P",{"data-svelte-h":!0}),i(ws)!=="svelte-1jolo2s"&&(ws.innerHTML=We),Xl=t(s),M(os.$$.fragment,s),Gl=t(s),M(Us.$$.fragment,s),ql=t(s),ds=h(s,"P",{"data-svelte-h":!0}),i(ds)!=="svelte-48hc6q"&&(ds.textContent=ze),Ll=t(s),M(Is.$$.fragment,s),Fl=t(s),M(fs.$$.fragment,s),Yl=t(s),M(As.$$.fragment,s),Pl=t(s),ks=h(s,"P",{"data-svelte-h":!0}),i(ks)!=="svelte-1mklzwf"&&(ks.innerHTML=Re),Kl=t(s),M($s.$$.fragment,s),Ol=t(s),M(Ds.$$.fragment,s),se=t(s),Cs=h(s,"P",{"data-svelte-h":!0}),i(Cs)!=="svelte-2judgi"&&(Cs.textContent=Xe),le=t(s),M(gs.$$.fragment,s),ee=t(s),xs=h(s,"P",{"data-svelte-h":!0}),i(xs)!=="svelte-zezeea"&&(xs.textContent=Ge),ne=t(s),M(Es.$$.fragment,s),ae=t(s),Qs=h(s,"P",{"data-svelte-h":!0}),i(Qs)!=="svelte-k5jj6q"&&(Qs.textContent=qe),te=t(s),M(vs.$$.fragment,s),pe=t(s),Ns=h(s,"P",{"data-svelte-h":!0}),i(Ns)!=="svelte-y3q2fn"&&(Ns.textContent=Le),Me=t(s),M(Zs.$$.fragment,s),re=t(s),M(Ss.$$.fragment,s),me=t(s),Vs=h(s,"P",{"data-svelte-h":!0}),i(Vs)!=="svelte-1et2den"&&(Vs.textContent=Fe),ye=t(s),M(_s.$$.fragment,s),je=t(s),Bs=h(s,"P",{"data-svelte-h":!0}),i(Bs)!=="svelte-1suqc52"&&(Bs.textContent=Ye),ue=t(s),M(Hs.$$.fragment,s),he=t(s),Rs=h(s,"P",{}),Ke(Rs).forEach(e),this.h()},h(){Oe(c,"name","hf:doc:metadata"),Oe(c,"content",jn)},m(s,l){tn(document.head,c),n(s,Ws,l),n(s,b,l),n(s,zs,l),r(w,s,l),n(s,Xs,l),r(o,s,l),n(s,Gs,l),r(U,s,l),n(s,qs,l),r(d,s,l),n(s,Ls,l),n(s,I,l),n(s,Fs,l),r(f,s,l),n(s,Ys,l),n(s,A,l),n(s,Ps,l),r(k,s,l),n(s,Ks,l),n(s,$,l),n(s,Os,l),n(s,D,l),n(s,sl,l),r(C,s,l),n(s,ll,l),r(g,s,l),n(s,el,l),n(s,x,l),n(s,nl,l),r(E,s,l),n(s,al,l),n(s,Q,l),n(s,tl,l),r(v,s,l),n(s,pl,l),n(s,N,l),n(s,Ml,l),n(s,Z,l),n(s,rl,l),n(s,S,l),n(s,ml,l),r(V,s,l),n(s,yl,l),n(s,_,l),n(s,jl,l),r(B,s,l),n(s,ul,l),n(s,H,l),n(s,hl,l),r(W,s,l),n(s,il,l),n(s,z,l),n(s,Jl,l),r(R,s,l),n(s,cl,l),n(s,X,l),n(s,Tl,l),r(G,s,l),n(s,bl,l),n(s,q,l),n(s,wl,l),n(s,L,l),n(s,ol,l),n(s,F,l),n(s,Ul,l),r(Y,s,l),n(s,dl,l),n(s,P,l),n(s,Il,l),r(K,s,l),n(s,fl,l),r(O,s,l),n(s,Al,l),n(s,ss,l),n(s,kl,l),n(s,ls,l),n(s,$l,l),n(s,es,l),n(s,Dl,l),r(ns,s,l),n(s,Cl,l),r(as,s,l),n(s,gl,l),n(s,ts,l),n(s,xl,l),n(s,ps,l),n(s,El,l),r(Ms,s,l),n(s,Ql,l),r(rs,s,l),n(s,vl,l),n(s,ms,l),n(s,Nl,l),r(ys,s,l),n(s,Zl,l),r(js,s,l),n(s,Sl,l),n(s,us,l),n(s,Vl,l),r(hs,s,l),n(s,_l,l),n(s,is,l),n(s,Bl,l),r(Js,s,l),n(s,Hl,l),r(cs,s,l),n(s,Wl,l),n(s,Ts,l),n(s,zl,l),r(bs,s,l),n(s,Rl,l),n(s,ws,l),n(s,Xl,l),r(os,s,l),n(s,Gl,l),r(Us,s,l),n(s,ql,l),n(s,ds,l),n(s,Ll,l),r(Is,s,l),n(s,Fl,l),r(fs,s,l),n(s,Yl,l),r(As,s,l),n(s,Pl,l),n(s,ks,l),n(s,Kl,l),r($s,s,l),n(s,Ol,l),r(Ds,s,l),n(s,se,l),n(s,Cs,l),n(s,le,l),r(gs,s,l),n(s,ee,l),n(s,xs,l),n(s,ne,l),r(Es,s,l),n(s,ae,l),n(s,Qs,l),n(s,te,l),r(vs,s,l),n(s,pe,l),n(s,Ns,l),n(s,Me,l),r(Zs,s,l),n(s,re,l),r(Ss,s,l),n(s,me,l),n(s,Vs,l),n(s,ye,l),r(_s,s,l),n(s,je,l),n(s,Bs,l),n(s,ue,l),r(Hs,s,l),n(s,he,l),n(s,Rs,l),ie=!0},p(s,[l]){const Pe={};l&1&&(Pe.fw=s[0]),w.$set(Pe)},i(s){ie||(m(w.$$.fragment,s),m(o.$$.fragment,s),m(U.$$.fragment,s),m(d.$$.fragment,s),m(f.$$.fragment,s),m(k.$$.fragment,s),m(C.$$.fragment,s),m(g.$$.fragment,s),m(E.$$.fragment,s),m(v.$$.fragment,s),m(V.$$.fragment,s),m(B.$$.fragment,s),m(W.$$.fragment,s),m(R.$$.fragment,s),m(G.$$.fragment,s),m(Y.$$.fragment,s),m(K.$$.fragment,s),m(O.$$.fragment,s),m(ns.$$.fragment,s),m(as.$$.fragment,s),m(Ms.$$.fragment,s),m(rs.$$.fragment,s),m(ys.$$.fragment,s),m(js.$$.fragment,s),m(hs.$$.fragment,s),m(Js.$$.fragment,s),m(cs.$$.fragment,s),m(bs.$$.fragment,s),m(os.$$.fragment,s),m(Us.$$.fragment,s),m(Is.$$.fragment,s),m(fs.$$.fragment,s),m(As.$$.fragment,s),m($s.$$.fragment,s),m(Ds.$$.fragment,s),m(gs.$$.fragment,s),m(Es.$$.fragment,s),m(vs.$$.fragment,s),m(Zs.$$.fragment,s),m(Ss.$$.fragment,s),m(_s.$$.fragment,s),m(Hs.$$.fragment,s),ie=!0)},o(s){y(w.$$.fragment,s),y(o.$$.fragment,s),y(U.$$.fragment,s),y(d.$$.fragment,s),y(f.$$.fragment,s),y(k.$$.fragment,s),y(C.$$.fragment,s),y(g.$$.fragment,s),y(E.$$.fragment,s),y(v.$$.fragment,s),y(V.$$.fragment,s),y(B.$$.fragment,s),y(W.$$.fragment,s),y(R.$$.fragment,s),y(G.$$.fragment,s),y(Y.$$.fragment,s),y(K.$$.fragment,s),y(O.$$.fragment,s),y(ns.$$.fragment,s),y(as.$$.fragment,s),y(Ms.$$.fragment,s),y(rs.$$.fragment,s),y(ys.$$.fragment,s),y(js.$$.fragment,s),y(hs.$$.fragment,s),y(Js.$$.fragment,s),y(cs.$$.fragment,s),y(bs.$$.fragment,s),y(os.$$.fragment,s),y(Us.$$.fragment,s),y(Is.$$.fragment,s),y(fs.$$.fragment,s),y(As.$$.fragment,s),y($s.$$.fragment,s),y(Ds.$$.fragment,s),y(gs.$$.fragment,s),y(Es.$$.fragment,s),y(vs.$$.fragment,s),y(Zs.$$.fragment,s),y(Ss.$$.fragment,s),y(_s.$$.fragment,s),y(Hs.$$.fragment,s),ie=!1},d(s){s&&(e(Ws),e(b),e(zs),e(Xs),e(Gs),e(qs),e(Ls),e(I),e(Fs),e(Ys),e(A),e(Ps),e(Ks),e($),e(Os),e(D),e(sl),e(ll),e(el),e(x),e(nl),e(al),e(Q),e(tl),e(pl),e(N),e(Ml),e(Z),e(rl),e(S),e(ml),e(yl),e(_),e(jl),e(ul),e(H),e(hl),e(il),e(z),e(Jl),e(cl),e(X),e(Tl),e(bl),e(q),e(wl),e(L),e(ol),e(F),e(Ul),e(dl),e(P),e(Il),e(fl),e(Al),e(ss),e(kl),e(ls),e($l),e(es),e(Dl),e(Cl),e(gl),e(ts),e(xl),e(ps),e(El),e(Ql),e(vl),e(ms),e(Nl),e(Zl),e(Sl),e(us),e(Vl),e(_l),e(is),e(Bl),e(Hl),e(Wl),e(Ts),e(zl),e(Rl),e(ws),e(Xl),e(Gl),e(ql),e(ds),e(Ll),e(Fl),e(Yl),e(Pl),e(ks),e(Kl),e(Ol),e(se),e(Cs),e(le),e(ee),e(xs),e(ne),e(ae),e(Qs),e(te),e(pe),e(Ns),e(Me),e(re),e(me),e(Vs),e(ye),e(je),e(Bs),e(ue),e(he),e(Rs)),e(c),j(w,s),j(o,s),j(U,s),j(d,s),j(f,s),j(k,s),j(C,s),j(g,s),j(E,s),j(v,s),j(V,s),j(B,s),j(W,s),j(R,s),j(G,s),j(Y,s),j(K,s),j(O,s),j(ns,s),j(as,s),j(Ms,s),j(rs,s),j(ys,s),j(js,s),j(hs,s),j(Js,s),j(cs,s),j(bs,s),j(os,s),j(Us,s),j(Is,s),j(fs,s),j(As,s),j($s,s),j(Ds,s),j(gs,s),j(Es,s),j(vs,s),j(Zs,s),j(Ss,s),j(_s,s),j(Hs,s)}}}const jn='{"title":"Models","local":"the-models","sections":[{"title":"Creating a Transformer","local":"creating-a-transformer","sections":[],"depth":2},{"title":"Loading and saving","local":"loading-and-saving","sections":[],"depth":2},{"title":"Encoding text","local":"encoding-text","sections":[{"title":"Padding inputs","local":"padding-inputs","sections":[],"depth":3},{"title":"Truncating inputs","local":"truncating-inputs","sections":[],"depth":3},{"title":"Adding special tokens","local":"adding-special-tokens","sections":[],"depth":3},{"title":"Why is all of this necessary?","local":"why-is-all-of-this-necessary","sections":[],"depth":3},{"title":"Using the tensors as inputs to the model","local":"using-the-tensors-as-inputs-to-the-model","sections":[],"depth":3}],"depth":2}],"depth":1}';function un(Je,c,Ws){let b="pt";return ln(()=>{const zs=new URLSearchParams(window.location.search);Ws(0,b=zs.get("fw")||"pt")}),[b]}class Un extends en{constructor(c){super(),nn(this,c,un,yn,sn,{})}}export{Un as component};
